import React, { useContext, useRef, useEffect, createElement, useState, useMemo, Fragment, useCallback } from 'react';
import { isPlatform as isPlatform$1, getPlatforms as getPlatforms$1, componentOnReady, createAnimation, actionSheetController, alertController, toastController, modalController, popoverController, pickerController, loadingController, initialize } from '@ionic/core/components';
export { IonicSafeString, IonicSlides, createAnimation, createGesture, getIonPageElement, getTimeGivenProgression, iosTransitionAnimation, mdTransitionAnimation, openURL } from '@ionic/core/components';
import { __rest } from 'tslib';
import ReactDOM, { createPortal } from 'react-dom';
import { defineCustomElement as defineCustomElement$1 } from '@ionic/core/components/ion-accordion.js';
import { defineCustomElement as defineCustomElement$2 } from '@ionic/core/components/ion-accordion-group.js';
import { defineCustomElement as defineCustomElement$3 } from '@ionic/core/components/ion-avatar.js';
import { defineCustomElement as defineCustomElement$4 } from '@ionic/core/components/ion-backdrop.js';
import { defineCustomElement as defineCustomElement$5 } from '@ionic/core/components/ion-badge.js';
import { defineCustomElement as defineCustomElement$6 } from '@ionic/core/components/ion-breadcrumbs.js';
import { defineCustomElement as defineCustomElement$7 } from '@ionic/core/components/ion-buttons.js';
import { defineCustomElement as defineCustomElement$8 } from '@ionic/core/components/ion-card-content.js';
import { defineCustomElement as defineCustomElement$9 } from '@ionic/core/components/ion-card-header.js';
import { defineCustomElement as defineCustomElement$a } from '@ionic/core/components/ion-card-subtitle.js';
import { defineCustomElement as defineCustomElement$b } from '@ionic/core/components/ion-card-title.js';
import { defineCustomElement as defineCustomElement$c } from '@ionic/core/components/ion-checkbox.js';
import { defineCustomElement as defineCustomElement$d } from '@ionic/core/components/ion-chip.js';
import { defineCustomElement as defineCustomElement$e } from '@ionic/core/components/ion-col.js';
import { defineCustomElement as defineCustomElement$f } from '@ionic/core/components/ion-content.js';
import { defineCustomElement as defineCustomElement$g } from '@ionic/core/components/ion-datetime.js';
import { defineCustomElement as defineCustomElement$h } from '@ionic/core/components/ion-datetime-button.js';
import { defineCustomElement as defineCustomElement$i } from '@ionic/core/components/ion-fab.js';
import { defineCustomElement as defineCustomElement$j } from '@ionic/core/components/ion-fab-list.js';
import { defineCustomElement as defineCustomElement$k } from '@ionic/core/components/ion-footer.js';
import { defineCustomElement as defineCustomElement$l } from '@ionic/core/components/ion-grid.js';
import { defineCustomElement as defineCustomElement$m } from '@ionic/core/components/ion-header.js';
import { defineCustomElement as defineCustomElement$n } from '@ionic/core/components/ion-img.js';
import { defineCustomElement as defineCustomElement$o } from '@ionic/core/components/ion-infinite-scroll.js';
import { defineCustomElement as defineCustomElement$p } from '@ionic/core/components/ion-infinite-scroll-content.js';
import { defineCustomElement as defineCustomElement$q } from '@ionic/core/components/ion-input.js';
import { defineCustomElement as defineCustomElement$r } from '@ionic/core/components/ion-item-divider.js';
import { defineCustomElement as defineCustomElement$s } from '@ionic/core/components/ion-item-group.js';
import { defineCustomElement as defineCustomElement$t } from '@ionic/core/components/ion-item-options.js';
import { defineCustomElement as defineCustomElement$u } from '@ionic/core/components/ion-item-sliding.js';
import { defineCustomElement as defineCustomElement$v } from '@ionic/core/components/ion-label.js';
import { defineCustomElement as defineCustomElement$w } from '@ionic/core/components/ion-list.js';
import { defineCustomElement as defineCustomElement$x } from '@ionic/core/components/ion-list-header.js';
import { defineCustomElement as defineCustomElement$y } from '@ionic/core/components/ion-menu.js';
import { defineCustomElement as defineCustomElement$z } from '@ionic/core/components/ion-menu-button.js';
import { defineCustomElement as defineCustomElement$A } from '@ionic/core/components/ion-menu-toggle.js';
import { defineCustomElement as defineCustomElement$1d } from '@ionic/core/components/ion-nav.js';
import { defineCustomElement as defineCustomElement$B } from '@ionic/core/components/ion-nav-link.js';
import { defineCustomElement as defineCustomElement$C } from '@ionic/core/components/ion-note.js';
import { defineCustomElement as defineCustomElement$D } from '@ionic/core/components/ion-progress-bar.js';
import { defineCustomElement as defineCustomElement$E } from '@ionic/core/components/ion-radio.js';
import { defineCustomElement as defineCustomElement$F } from '@ionic/core/components/ion-radio-group.js';
import { defineCustomElement as defineCustomElement$G } from '@ionic/core/components/ion-range.js';
import { defineCustomElement as defineCustomElement$H } from '@ionic/core/components/ion-refresher.js';
import { defineCustomElement as defineCustomElement$I } from '@ionic/core/components/ion-refresher-content.js';
import { defineCustomElement as defineCustomElement$J } from '@ionic/core/components/ion-reorder.js';
import { defineCustomElement as defineCustomElement$K } from '@ionic/core/components/ion-reorder-group.js';
import { defineCustomElement as defineCustomElement$L } from '@ionic/core/components/ion-ripple-effect.js';
import { defineCustomElement as defineCustomElement$M } from '@ionic/core/components/ion-row.js';
import { defineCustomElement as defineCustomElement$N } from '@ionic/core/components/ion-searchbar.js';
import { defineCustomElement as defineCustomElement$O } from '@ionic/core/components/ion-segment.js';
import { defineCustomElement as defineCustomElement$P } from '@ionic/core/components/ion-segment-button.js';
import { defineCustomElement as defineCustomElement$Q } from '@ionic/core/components/ion-select.js';
import { defineCustomElement as defineCustomElement$R } from '@ionic/core/components/ion-select-option.js';
import { defineCustomElement as defineCustomElement$S } from '@ionic/core/components/ion-skeleton-text.js';
import { defineCustomElement as defineCustomElement$T } from '@ionic/core/components/ion-spinner.js';
import { defineCustomElement as defineCustomElement$U } from '@ionic/core/components/ion-split-pane.js';
import { defineCustomElement as defineCustomElement$V } from '@ionic/core/components/ion-tab.js';
import { defineCustomElement as defineCustomElement$W } from '@ionic/core/components/ion-text.js';
import { defineCustomElement as defineCustomElement$X } from '@ionic/core/components/ion-textarea.js';
import { defineCustomElement as defineCustomElement$Y } from '@ionic/core/components/ion-thumbnail.js';
import { defineCustomElement as defineCustomElement$Z } from '@ionic/core/components/ion-title.js';
import { defineCustomElement as defineCustomElement$_ } from '@ionic/core/components/ion-toggle.js';
import { defineCustomElement as defineCustomElement$$ } from '@ionic/core/components/ion-toolbar.js';
import { IonBreadcrumb as IonBreadcrumb$1 } from '@ionic/core/components/ion-breadcrumb.js';
import { IonButton as IonButton$1 } from '@ionic/core/components/ion-button.js';
import { IonCard as IonCard$1 } from '@ionic/core/components/ion-card.js';
import { IonFabButton as IonFabButton$1 } from '@ionic/core/components/ion-fab-button.js';
import { IonItemOption as IonItemOption$1 } from '@ionic/core/components/ion-item-option.js';
import { IonItem as IonItem$1 } from '@ionic/core/components/ion-item.js';
import { IonRouterLink as IonRouterLink$1 } from '@ionic/core/components/ion-router-link.js';
import { defineCustomElement as defineCustomElement$10 } from '@ionic/core/components/ion-alert.js';
import { defineCustomElement as defineCustomElement$11 } from '@ionic/core/components/ion-loading.js';
import { defineCustomElement as defineCustomElement$12 } from '@ionic/core/components/ion-toast.js';
import { defineCustomElement as defineCustomElement$13 } from '@ionic/core/components/ion-picker.js';
import { defineCustomElement as defineCustomElement$14 } from '@ionic/core/components/ion-action-sheet.js';
import { defineCustomElement as defineCustomElement$15 } from '@ionic/core/components/ion-modal.js';
import { defineCustomElement as defineCustomElement$16 } from '@ionic/core/components/ion-popover.js';
import { defineCustomElement as defineCustomElement$1c } from '@ionic/core/components/ion-app.js';
import { defineCustomElement as defineCustomElement$1b } from '@ionic/core/components/ion-back-button.js';
import { defineCustomElement as defineCustomElement$18 } from '@ionic/core/components/ion-router-outlet.js';
import { defineCustomElement as defineCustomElement$17 } from '@ionic/core/components/ion-tab-bar.js';
import { defineCustomElement as defineCustomElement$1a } from '@ionic/core/components/ion-tab-button.js';
import { defineCustomElement as defineCustomElement$19 } from 'ionicons/components/ion-icon.js';

const IonLifeCycleContext = /*@__PURE__*/ React.createContext({
    onIonViewWillEnter: () => {
        return;
    },
    ionViewWillEnter: () => {
        return;
    },
    onIonViewDidEnter: () => {
        return;
    },
    ionViewDidEnter: () => {
        return;
    },
    onIonViewWillLeave: () => {
        return;
    },
    ionViewWillLeave: () => {
        return;
    },
    onIonViewDidLeave: () => {
        return;
    },
    ionViewDidLeave: () => {
        return;
    },
    cleanupIonViewWillEnter: () => {
        return;
    },
    cleanupIonViewDidEnter: () => {
        return;
    },
    cleanupIonViewWillLeave: () => {
        return;
    },
    cleanupIonViewDidLeave: () => {
        return;
    },
});
const DefaultIonLifeCycleContext = class {
    constructor() {
        this.ionViewWillEnterCallbacks = [];
        this.ionViewDidEnterCallbacks = [];
        this.ionViewWillLeaveCallbacks = [];
        this.ionViewDidLeaveCallbacks = [];
        this.ionViewWillEnterDestructorCallbacks = [];
        this.ionViewDidEnterDestructorCallbacks = [];
        this.ionViewWillLeaveDestructorCallbacks = [];
        this.ionViewDidLeaveDestructorCallbacks = [];
    }
    onIonViewWillEnter(callback) {
        if (callback.id) {
            const index = this.ionViewWillEnterCallbacks.findIndex((x) => x.id === callback.id);
            if (index > -1) {
                this.ionViewWillEnterCallbacks[index] = callback;
            }
            else {
                this.ionViewWillEnterCallbacks.push(callback);
            }
        }
        else {
            this.ionViewWillEnterCallbacks.push(callback);
        }
    }
    teardownCallback(callback, callbacks) {
        // Find any destructors that have been registered for the callback
        const matches = callbacks.filter((x) => x.id === callback.id);
        if (matches.length !== 0) {
            // Execute the destructor for each matching item
            matches.forEach((match) => {
                if (match && typeof match.destructor === 'function') {
                    match.destructor();
                }
            });
            // Remove all matching items from the array
            callbacks = callbacks.filter((x) => x.id !== callback.id);
        }
    }
    /**
     * Tears down the user-provided ionViewWillEnter lifecycle callback.
     * This is the same behavior as React's useEffect hook. The callback
     * is invoked when the component is unmounted.
     */
    cleanupIonViewWillEnter(callback) {
        this.teardownCallback(callback, this.ionViewWillEnterDestructorCallbacks);
    }
    /**
     * Tears down the user-provided ionViewDidEnter lifecycle callback.
     * This is the same behavior as React's useEffect hook. The callback
     * is invoked when the component is unmounted.
     */
    cleanupIonViewDidEnter(callback) {
        this.teardownCallback(callback, this.ionViewDidEnterDestructorCallbacks);
    }
    /**
     * Tears down the user-provided ionViewWillLeave lifecycle callback.
     * This is the same behavior as React's useEffect hook. The callback
     * is invoked when the component is unmounted.
     */
    cleanupIonViewWillLeave(callback) {
        this.teardownCallback(callback, this.ionViewWillLeaveDestructorCallbacks);
    }
    /**
     * Tears down the user-provided ionViewDidLeave lifecycle callback.
     * This is the same behavior as React's useEffect hook. The callback
     * is invoked when the component is unmounted.
     */
    cleanupIonViewDidLeave(callback) {
        this.teardownCallback(callback, this.ionViewDidLeaveDestructorCallbacks);
    }
    ionViewWillEnter() {
        this.ionViewWillEnterCallbacks.forEach((cb) => {
            const destructor = cb();
            if (cb.id) {
                this.ionViewWillEnterDestructorCallbacks.push({ id: cb.id, destructor });
            }
        });
    }
    onIonViewDidEnter(callback) {
        if (callback.id) {
            const index = this.ionViewDidEnterCallbacks.findIndex((x) => x.id === callback.id);
            if (index > -1) {
                this.ionViewDidEnterCallbacks[index] = callback;
            }
            else {
                this.ionViewDidEnterCallbacks.push(callback);
            }
        }
        else {
            this.ionViewDidEnterCallbacks.push(callback);
        }
    }
    ionViewDidEnter() {
        this.ionViewDidEnterCallbacks.forEach((cb) => {
            const destructor = cb();
            if (cb.id) {
                this.ionViewDidEnterDestructorCallbacks.push({ id: cb.id, destructor });
            }
        });
    }
    onIonViewWillLeave(callback) {
        if (callback.id) {
            const index = this.ionViewWillLeaveCallbacks.findIndex((x) => x.id === callback.id);
            if (index > -1) {
                this.ionViewWillLeaveCallbacks[index] = callback;
            }
            else {
                this.ionViewWillLeaveCallbacks.push(callback);
            }
        }
        else {
            this.ionViewWillLeaveCallbacks.push(callback);
        }
    }
    ionViewWillLeave() {
        this.ionViewWillLeaveCallbacks.forEach((cb) => {
            const destructor = cb();
            if (cb.id) {
                this.ionViewWillLeaveDestructorCallbacks.push({ id: cb.id, destructor });
            }
        });
    }
    onIonViewDidLeave(callback) {
        if (callback.id) {
            const index = this.ionViewDidLeaveCallbacks.findIndex((x) => x.id === callback.id);
            if (index > -1) {
                this.ionViewDidLeaveCallbacks[index] = callback;
            }
            else {
                this.ionViewDidLeaveCallbacks.push(callback);
            }
        }
        else {
            this.ionViewDidLeaveCallbacks.push(callback);
        }
    }
    ionViewDidLeave() {
        this.ionViewDidLeaveCallbacks.forEach((cb) => {
            const destructor = cb();
            if (cb.id) {
                this.ionViewDidLeaveDestructorCallbacks.push({ id: cb.id, destructor });
            }
        });
        this.componentCanBeDestroyed();
    }
    onComponentCanBeDestroyed(callback) {
        this.componentCanBeDestroyedCallback = callback;
    }
    componentCanBeDestroyed() {
        if (this.componentCanBeDestroyedCallback) {
            this.componentCanBeDestroyedCallback();
        }
    }
};

// TODO(FW-2959): types
const withIonLifeCycle = (WrappedComponent) => {
    return class IonLifeCycle extends React.Component {
        constructor(props) {
            super(props);
            this.componentRef = React.createRef();
        }
        componentDidMount() {
            const element = this.componentRef.current;
            this.context.onIonViewWillEnter(() => {
                if (element && element.ionViewWillEnter) {
                    element.ionViewWillEnter();
                }
            });
            this.context.onIonViewDidEnter(() => {
                if (element && element.ionViewDidEnter) {
                    element.ionViewDidEnter();
                }
            });
            this.context.onIonViewWillLeave(() => {
                if (element && element.ionViewWillLeave) {
                    element.ionViewWillLeave();
                }
            });
            this.context.onIonViewDidLeave(() => {
                if (element && element.ionViewDidLeave) {
                    element.ionViewDidLeave();
                }
            });
        }
        render() {
            return (React.createElement(IonLifeCycleContext.Consumer, null, (context) => {
                this.context = context;
                return React.createElement(WrappedComponent, Object.assign({ ref: this.componentRef }, this.props));
            }));
        }
    };
};

const useIonViewWillEnter = (callback, deps = []) => {
    const context = useContext(IonLifeCycleContext);
    const id = useRef();
    id.current = id.current || Math.floor(Math.random() * 1000000);
    useEffect(() => {
        callback.id = id.current;
        context.onIonViewWillEnter(callback);
        return () => {
            context.cleanupIonViewWillEnter(callback);
        };
    }, deps);
};
const useIonViewDidEnter = (callback, deps = []) => {
    const context = useContext(IonLifeCycleContext);
    const id = useRef();
    id.current = id.current || Math.floor(Math.random() * 1000000);
    useEffect(() => {
        callback.id = id.current;
        context.onIonViewDidEnter(callback);
        return () => {
            context.cleanupIonViewDidEnter(callback);
        };
    }, deps);
};
const useIonViewWillLeave = (callback, deps = []) => {
    const context = useContext(IonLifeCycleContext);
    const id = useRef();
    id.current = id.current || Math.floor(Math.random() * 1000000);
    useEffect(() => {
        callback.id = id.current;
        context.onIonViewWillLeave(callback);
        return () => {
            context.cleanupIonViewWillLeave(callback);
        };
    }, deps);
};
const useIonViewDidLeave = (callback, deps = []) => {
    const context = useContext(IonLifeCycleContext);
    const id = useRef();
    id.current = id.current || Math.floor(Math.random() * 1000000);
    useEffect(() => {
        callback.id = id.current;
        context.onIonViewDidLeave(callback);
        return () => {
            context.cleanupIonViewDidLeave(callback);
        };
    }, deps);
};

const NavContext = /*@__PURE__*/ React.createContext({
    getIonRedirect: () => undefined,
    getIonRoute: () => undefined,
    getPageManager: () => undefined,
    getStackManager: () => undefined,
    goBack: (route) => {
        if (typeof window !== 'undefined') {
            if (typeof route === 'string') {
                window.location.pathname = route;
            }
            else {
                window.history.back();
            }
        }
    },
    navigate: (path) => {
        if (typeof window !== 'undefined') {
            window.location.pathname = path;
        }
    },
    hasIonicRouter: () => false,
    routeInfo: undefined,
    setCurrentTab: () => undefined,
    changeTab: (_tab, path) => {
        if (typeof window !== 'undefined') {
            window.location.pathname = path;
        }
    },
    resetTab: (_tab, path) => {
        if (typeof window !== 'undefined') {
            window.location.pathname = path;
        }
    },
});

const dashToPascalCase = (str) => str
    .toLowerCase()
    .split('-')
    .map((segment) => segment.charAt(0).toUpperCase() + segment.slice(1))
    .join('');
const camelToDashCase = (str) => str.replace(/([A-Z])/g, (m) => `-${m[0].toLowerCase()}`);

const attachProps = (node, newProps, oldProps = {}) => {
    // some test frameworks don't render DOM elements, so we test here to make sure we are dealing with DOM first
    if (node instanceof Element) {
        // add any classes in className to the class list
        const className = getClassName(node.classList, newProps, oldProps);
        if (className !== '') {
            node.className = className;
        }
        Object.keys(newProps).forEach((name) => {
            if (name === 'children' ||
                name === 'style' ||
                name === 'ref' ||
                name === 'class' ||
                name === 'className' ||
                name === 'forwardedRef') {
                return;
            }
            if (name.indexOf('on') === 0 && name[2] === name[2].toUpperCase()) {
                const eventName = name.substring(2);
                const eventNameLc = eventName[0].toLowerCase() + eventName.substring(1);
                if (!isCoveredByReact(eventNameLc)) {
                    syncEvent(node, eventNameLc, newProps[name]);
                }
            }
            else {
                node[name] = newProps[name];
                const propType = typeof newProps[name];
                if (propType === 'string') {
                    node.setAttribute(camelToDashCase(name), newProps[name]);
                }
            }
        });
    }
};
const getClassName = (classList, newProps, oldProps) => {
    const newClassProp = newProps.className || newProps.class;
    const oldClassProp = oldProps.className || oldProps.class;
    // map the classes to Maps for performance
    const currentClasses = arrayToMap(classList);
    const incomingPropClasses = arrayToMap(newClassProp ? newClassProp.split(' ') : []);
    const oldPropClasses = arrayToMap(oldClassProp ? oldClassProp.split(' ') : []);
    const finalClassNames = [];
    // loop through each of the current classes on the component
    // to see if it should be a part of the classNames added
    currentClasses.forEach((currentClass) => {
        if (incomingPropClasses.has(currentClass)) {
            // add it as its already included in classnames coming in from newProps
            finalClassNames.push(currentClass);
            incomingPropClasses.delete(currentClass);
        }
        else if (!oldPropClasses.has(currentClass)) {
            // add it as it has NOT been removed by user
            finalClassNames.push(currentClass);
        }
    });
    incomingPropClasses.forEach((s) => finalClassNames.push(s));
    return finalClassNames.join(' ');
};
/**
 * Transforms a React event name to a browser event name.
 */
const transformReactEventName = (eventNameSuffix) => {
    switch (eventNameSuffix) {
        case 'doubleclick':
            return 'dblclick';
    }
    return eventNameSuffix;
};
/**
 * Checks if an event is supported in the current execution environment.
 * @license Modernizr 3.0.0pre (Custom Build) | MIT
 */
const isCoveredByReact = (eventNameSuffix) => {
    if (typeof document === 'undefined') {
        return true;
    }
    else {
        const eventName = 'on' + transformReactEventName(eventNameSuffix);
        let isSupported = eventName in document;
        if (!isSupported) {
            const element = document.createElement('div');
            element.setAttribute(eventName, 'return;');
            isSupported = typeof element[eventName] === 'function';
        }
        return isSupported;
    }
};
const syncEvent = (node, eventName, newEventHandler) => {
    const eventStore = node.__events || (node.__events = {});
    const oldEventHandler = eventStore[eventName];
    // Remove old listener so they don't double up.
    if (oldEventHandler) {
        node.removeEventListener(eventName, oldEventHandler);
    }
    // Bind new listener.
    node.addEventListener(eventName, (eventStore[eventName] = function handler(e) {
        if (newEventHandler) {
            newEventHandler.call(this, e);
        }
    }));
};
const arrayToMap = (arr) => {
    const map = new Map();
    arr.forEach((s) => map.set(s, s));
    return map;
};

const setRef = (ref, value) => {
    if (typeof ref === 'function') {
        ref(value);
    }
    else if (ref != null) {
        // Cast as a MutableRef so we can assign current
        ref.current = value;
    }
};
const mergeRefs = (...refs) => {
    return (value) => {
        refs.forEach((ref) => {
            setRef(ref, value);
        });
    };
};
const createForwardRef$1 = (ReactComponent, displayName) => {
    const forwardRef = (props, ref) => {
        return React.createElement(ReactComponent, Object.assign({}, props, { forwardedRef: ref }));
    };
    forwardRef.displayName = displayName;
    return React.forwardRef(forwardRef);
};
const defineCustomElement = (tagName, customElement) => {
    if (customElement !== undefined && typeof customElements !== 'undefined' && !customElements.get(tagName)) {
        customElements.define(tagName, customElement);
    }
};

const createReactComponent = (tagName, ReactComponentContext, manipulatePropsFunction, defineCustomElement) => {
    if (defineCustomElement !== undefined) {
        defineCustomElement();
    }
    const displayName = dashToPascalCase(tagName);
    const ReactComponent = class extends React.Component {
        constructor(props) {
            super(props);
            this.setComponentElRef = (element) => {
                this.componentEl = element;
            };
        }
        componentDidMount() {
            this.componentDidUpdate(this.props);
        }
        componentDidUpdate(prevProps) {
            attachProps(this.componentEl, this.props, prevProps);
        }
        render() {
            const _a = this.props, { children, forwardedRef, style, className, ref } = _a, cProps = __rest(_a, ["children", "forwardedRef", "style", "className", "ref"]);
            let propsToPass = Object.keys(cProps).reduce((acc, name) => {
                const value = cProps[name];
                if (name.indexOf('on') === 0 && name[2] === name[2].toUpperCase()) {
                    const eventName = name.substring(2).toLowerCase();
                    if (typeof document !== 'undefined' && isCoveredByReact(eventName)) {
                        acc[name] = value;
                    }
                }
                else {
                    // we should only render strings, booleans, and numbers as attrs in html.
                    // objects, functions, arrays etc get synced via properties on mount.
                    const type = typeof value;
                    if (type === 'string' || type === 'boolean' || type === 'number') {
                        acc[camelToDashCase(name)] = value;
                    }
                }
                return acc;
            }, {});
            if (manipulatePropsFunction) {
                propsToPass = manipulatePropsFunction(this.props, propsToPass);
            }
            const newProps = Object.assign(Object.assign({}, propsToPass), { ref: mergeRefs(forwardedRef, this.setComponentElRef), style });
            /**
             * We use createElement here instead of
             * React.createElement to work around a
             * bug in Vite (https://github.com/vitejs/vite/issues/6104).
             * React.createElement causes all elements to be rendered
             * as <tagname> instead of the actual Web Component.
             */
            return createElement(tagName, newProps, children);
        }
        static get displayName() {
            return displayName;
        }
    };
    // If context was passed to createReactComponent then conditionally add it to the Component Class
    if (ReactComponentContext) {
        ReactComponent.contextType = ReactComponentContext;
    }
    return createForwardRef$1(ReactComponent, displayName);
};

/* eslint-disable */
const IonAccordion = /*@__PURE__*/ createReactComponent('ion-accordion', undefined, undefined, defineCustomElement$1);
const IonAccordionGroup = /*@__PURE__*/ createReactComponent('ion-accordion-group', undefined, undefined, defineCustomElement$2);
const IonAvatar = /*@__PURE__*/ createReactComponent('ion-avatar', undefined, undefined, defineCustomElement$3);
const IonBackdrop = /*@__PURE__*/ createReactComponent('ion-backdrop', undefined, undefined, defineCustomElement$4);
const IonBadge = /*@__PURE__*/ createReactComponent('ion-badge', undefined, undefined, defineCustomElement$5);
const IonBreadcrumbs = /*@__PURE__*/ createReactComponent('ion-breadcrumbs', undefined, undefined, defineCustomElement$6);
const IonButtons = /*@__PURE__*/ createReactComponent('ion-buttons', undefined, undefined, defineCustomElement$7);
const IonCardContent = /*@__PURE__*/ createReactComponent('ion-card-content', undefined, undefined, defineCustomElement$8);
const IonCardHeader = /*@__PURE__*/ createReactComponent('ion-card-header', undefined, undefined, defineCustomElement$9);
const IonCardSubtitle = /*@__PURE__*/ createReactComponent('ion-card-subtitle', undefined, undefined, defineCustomElement$a);
const IonCardTitle = /*@__PURE__*/ createReactComponent('ion-card-title', undefined, undefined, defineCustomElement$b);
const IonCheckbox = /*@__PURE__*/ createReactComponent('ion-checkbox', undefined, undefined, defineCustomElement$c);
const IonChip = /*@__PURE__*/ createReactComponent('ion-chip', undefined, undefined, defineCustomElement$d);
const IonCol = /*@__PURE__*/ createReactComponent('ion-col', undefined, undefined, defineCustomElement$e);
const IonContent = /*@__PURE__*/ createReactComponent('ion-content', undefined, undefined, defineCustomElement$f);
const IonDatetime = /*@__PURE__*/ createReactComponent('ion-datetime', undefined, undefined, defineCustomElement$g);
const IonDatetimeButton = /*@__PURE__*/ createReactComponent('ion-datetime-button', undefined, undefined, defineCustomElement$h);
const IonFab = /*@__PURE__*/ createReactComponent('ion-fab', undefined, undefined, defineCustomElement$i);
const IonFabList = /*@__PURE__*/ createReactComponent('ion-fab-list', undefined, undefined, defineCustomElement$j);
const IonFooter = /*@__PURE__*/ createReactComponent('ion-footer', undefined, undefined, defineCustomElement$k);
const IonGrid = /*@__PURE__*/ createReactComponent('ion-grid', undefined, undefined, defineCustomElement$l);
const IonHeader = /*@__PURE__*/ createReactComponent('ion-header', undefined, undefined, defineCustomElement$m);
const IonImg = /*@__PURE__*/ createReactComponent('ion-img', undefined, undefined, defineCustomElement$n);
const IonInfiniteScroll = /*@__PURE__*/ createReactComponent('ion-infinite-scroll', undefined, undefined, defineCustomElement$o);
const IonInfiniteScrollContent = /*@__PURE__*/ createReactComponent('ion-infinite-scroll-content', undefined, undefined, defineCustomElement$p);
const IonInput = /*@__PURE__*/ createReactComponent('ion-input', undefined, undefined, defineCustomElement$q);
const IonItemDivider = /*@__PURE__*/ createReactComponent('ion-item-divider', undefined, undefined, defineCustomElement$r);
const IonItemGroup = /*@__PURE__*/ createReactComponent('ion-item-group', undefined, undefined, defineCustomElement$s);
const IonItemOptions = /*@__PURE__*/ createReactComponent('ion-item-options', undefined, undefined, defineCustomElement$t);
const IonItemSliding = /*@__PURE__*/ createReactComponent('ion-item-sliding', undefined, undefined, defineCustomElement$u);
const IonLabel = /*@__PURE__*/ createReactComponent('ion-label', undefined, undefined, defineCustomElement$v);
const IonList = /*@__PURE__*/ createReactComponent('ion-list', undefined, undefined, defineCustomElement$w);
const IonListHeader = /*@__PURE__*/ createReactComponent('ion-list-header', undefined, undefined, defineCustomElement$x);
const IonMenu = /*@__PURE__*/ createReactComponent('ion-menu', undefined, undefined, defineCustomElement$y);
const IonMenuButton = /*@__PURE__*/ createReactComponent('ion-menu-button', undefined, undefined, defineCustomElement$z);
const IonMenuToggle = /*@__PURE__*/ createReactComponent('ion-menu-toggle', undefined, undefined, defineCustomElement$A);
const IonNavLink = /*@__PURE__*/ createReactComponent('ion-nav-link', undefined, undefined, defineCustomElement$B);
const IonNote = /*@__PURE__*/ createReactComponent('ion-note', undefined, undefined, defineCustomElement$C);
const IonProgressBar = /*@__PURE__*/ createReactComponent('ion-progress-bar', undefined, undefined, defineCustomElement$D);
const IonRadio = /*@__PURE__*/ createReactComponent('ion-radio', undefined, undefined, defineCustomElement$E);
const IonRadioGroup = /*@__PURE__*/ createReactComponent('ion-radio-group', undefined, undefined, defineCustomElement$F);
const IonRange = /*@__PURE__*/ createReactComponent('ion-range', undefined, undefined, defineCustomElement$G);
const IonRefresher = /*@__PURE__*/ createReactComponent('ion-refresher', undefined, undefined, defineCustomElement$H);
const IonRefresherContent = /*@__PURE__*/ createReactComponent('ion-refresher-content', undefined, undefined, defineCustomElement$I);
const IonReorder = /*@__PURE__*/ createReactComponent('ion-reorder', undefined, undefined, defineCustomElement$J);
const IonReorderGroup = /*@__PURE__*/ createReactComponent('ion-reorder-group', undefined, undefined, defineCustomElement$K);
const IonRippleEffect = /*@__PURE__*/ createReactComponent('ion-ripple-effect', undefined, undefined, defineCustomElement$L);
const IonRow = /*@__PURE__*/ createReactComponent('ion-row', undefined, undefined, defineCustomElement$M);
const IonSearchbar = /*@__PURE__*/ createReactComponent('ion-searchbar', undefined, undefined, defineCustomElement$N);
const IonSegment = /*@__PURE__*/ createReactComponent('ion-segment', undefined, undefined, defineCustomElement$O);
const IonSegmentButton = /*@__PURE__*/ createReactComponent('ion-segment-button', undefined, undefined, defineCustomElement$P);
const IonSelect = /*@__PURE__*/ createReactComponent('ion-select', undefined, undefined, defineCustomElement$Q);
const IonSelectOption = /*@__PURE__*/ createReactComponent('ion-select-option', undefined, undefined, defineCustomElement$R);
const IonSkeletonText = /*@__PURE__*/ createReactComponent('ion-skeleton-text', undefined, undefined, defineCustomElement$S);
const IonSpinner = /*@__PURE__*/ createReactComponent('ion-spinner', undefined, undefined, defineCustomElement$T);
const IonSplitPane = /*@__PURE__*/ createReactComponent('ion-split-pane', undefined, undefined, defineCustomElement$U);
const IonTab = /*@__PURE__*/ createReactComponent('ion-tab', undefined, undefined, defineCustomElement$V);
const IonText = /*@__PURE__*/ createReactComponent('ion-text', undefined, undefined, defineCustomElement$W);
const IonTextarea = /*@__PURE__*/ createReactComponent('ion-textarea', undefined, undefined, defineCustomElement$X);
const IonThumbnail = /*@__PURE__*/ createReactComponent('ion-thumbnail', undefined, undefined, defineCustomElement$Y);
const IonTitle = /*@__PURE__*/ createReactComponent('ion-title', undefined, undefined, defineCustomElement$Z);
const IonToggle = /*@__PURE__*/ createReactComponent('ion-toggle', undefined, undefined, defineCustomElement$_);
const IonToolbar = /*@__PURE__*/ createReactComponent('ion-toolbar', undefined, undefined, defineCustomElement$$);

const createForwardRef = (ReactComponent, // TODO(FW-2959): type
displayName) => {
    const forwardRef = (props, ref) => {
        return React.createElement(ReactComponent, Object.assign({}, props, { forwardedRef: ref }));
    };
    forwardRef.displayName = displayName;
    return React.forwardRef(forwardRef);
};
const isPlatform = (platform) => {
    return isPlatform$1(window, platform);
};
const getPlatforms = () => {
    return getPlatforms$1(window);
};
const getConfig = () => {
    if (typeof window !== 'undefined') {
        const Ionic = window.Ionic;
        if (Ionic && Ionic.config) {
            return Ionic.config;
        }
    }
    return null;
};

const createRoutingComponent = (tagName, customElement) => {
    defineCustomElement(tagName, customElement);
    const displayName = dashToPascalCase(tagName);
    const ReactComponent = class extends React.Component {
        constructor(props) {
            super(props);
            this.handleClick = (e) => {
                const { routerLink, routerDirection, routerOptions, routerAnimation } = this.props;
                if (routerLink !== undefined) {
                    e.preventDefault();
                    this.context.navigate(routerLink, routerDirection, undefined, routerAnimation, routerOptions);
                }
            };
            // Create a local ref to to attach props to the wrapped element.
            this.ref = React.createRef();
            // React refs must be stable (not created inline).
            this.stableMergedRefs = mergeRefs(this.ref, this.props.forwardedRef);
        }
        componentDidMount() {
            this.componentDidUpdate(this.props);
        }
        componentDidUpdate(prevProps) {
            const node = this.ref.current;
            attachProps(node, this.props, prevProps);
        }
        render() {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            const _a = this.props, { children, forwardedRef, style, className, ref } = _a, cProps = __rest(_a, ["children", "forwardedRef", "style", "className", "ref"]);
            const propsToPass = Object.keys(cProps).reduce((acc, name) => {
                if (name.indexOf('on') === 0 && name[2] === name[2].toUpperCase()) {
                    const eventName = name.substring(2).toLowerCase();
                    if (isCoveredByReact(eventName)) {
                        acc[name] = cProps[name];
                    }
                }
                else if (['string', 'boolean', 'number'].includes(typeof cProps[name])) {
                    acc[camelToDashCase(name)] = cProps[name];
                }
                return acc;
            }, {});
            const newProps = Object.assign(Object.assign({}, propsToPass), { ref: this.stableMergedRefs, style });
            if (this.props.routerLink && !this.props.href) {
                newProps.href = this.props.routerLink;
            }
            if (newProps.onClick) {
                const oldClick = newProps.onClick;
                newProps.onClick = (e) => {
                    oldClick(e);
                    if (!e.defaultPrevented) {
                        this.handleClick(e);
                    }
                };
            }
            else {
                newProps.onClick = this.handleClick;
            }
            return createElement(tagName, newProps, children);
        }
        static get displayName() {
            return displayName;
        }
        static get contextType() {
            return NavContext;
        }
    };
    return createForwardRef(ReactComponent, displayName);
};

const IonRouterLink = /*@__PURE__*/ createRoutingComponent('ion-router-link', IonRouterLink$1);
const IonButton = /*@__PURE__*/ createRoutingComponent('ion-button', IonButton$1);
const IonCard = /*@__PURE__*/ createRoutingComponent('ion-card', IonCard$1);
const IonFabButton = /*@__PURE__*/ createRoutingComponent('ion-fab-button', IonFabButton$1);
const IonItem = /*@__PURE__*/ createRoutingComponent('ion-item', IonItem$1);
const IonItemOption = /*@__PURE__*/ createRoutingComponent('ion-item-option', IonItemOption$1);
const IonBreadcrumb = /*@__PURE__*/ createRoutingComponent('ion-breadcrumb', IonBreadcrumb$1);

/**
 * The @stencil/react-output-target will bind event listeners for any
 * attached props that use the `on` prefix. This function will remove
 * those event listeners when the component is unmounted.
 *
 * This prevents memory leaks and React state updates on unmounted components.
 */
const detachProps = (node, props) => {
    if (node instanceof Element) {
        Object.keys(props).forEach((name) => {
            if (name.indexOf('on') === 0 && name[2] === name[2].toUpperCase()) {
                const eventName = name.substring(2);
                const eventNameLc = eventName[0].toLowerCase() + eventName.substring(1);
                if (!isCoveredByReact(eventNameLc)) {
                    /**
                     * Detach custom event bindings (not built-in React events)
                     * that were added by the @stencil/react-output-target attachProps function.
                     */
                    detachEvent(node, eventNameLc);
                }
            }
        });
    }
};
const detachEvent = (node, eventName) => {
    const eventStore = node.__events || (node.__events = {});
    /**
     * If the event listener was added by attachProps, it will
     * be stored in the __events object.
     */
    const eventHandler = eventStore[eventName];
    if (eventHandler) {
        node.removeEventListener(eventName, eventHandler);
        eventStore[eventName] = undefined;
    }
};

const createInlineOverlayComponent = (tagName, defineCustomElement, hasDelegateHost) => {
    if (defineCustomElement) {
        defineCustomElement();
    }
    const displayName = dashToPascalCase(tagName);
    const ReactComponent = class extends React.Component {
        constructor(props) {
            super(props);
            this.handleIonMount = () => {
                /**
                 * Mount the inner component when the
                 * overlay is about to open.
                 *
                 * For ion-popover, this is when `ionMount` is emitted.
                 * For other overlays, this is when `willPresent` is emitted.
                 */
                this.setState({ isOpen: true });
            };
            this.handleWillPresent = (evt) => {
                this.setState({ isOpen: true });
                /**
                 * Manually call the onWillPresent
                 * handler if present as setState will
                 * cause the event handlers to be
                 * destroyed and re-created.
                 */
                this.props.onWillPresent && this.props.onWillPresent(evt);
            };
            this.handleDidDismiss = (evt) => {
                const wrapper = this.wrapperRef.current;
                const el = this.ref.current;
                /**
                 * This component might be unmounted already, if the containing
                 * element was removed while the overlay was still open. (For
                 * example, if an item contains an inline overlay with a button
                 * that removes the item.)
                 */
                if (wrapper && el) {
                    el.append(wrapper);
                    this.setState({ isOpen: false });
                }
                this.props.onDidDismiss && this.props.onDidDismiss(evt);
            };
            // Create a local ref to to attach props to the wrapped element.
            this.ref = React.createRef();
            // React refs must be stable (not created inline).
            this.stableMergedRefs = mergeRefs(this.ref, this.props.forwardedRef);
            // Component is hidden by default
            this.state = { isOpen: false };
            // Create a local ref to the inner child element.
            this.wrapperRef = React.createRef();
        }
        componentDidMount() {
            var _a, _b, _c;
            this.componentDidUpdate(this.props);
            (_a = this.ref.current) === null || _a === void 0 ? void 0 : _a.addEventListener('ionMount', this.handleIonMount);
            (_b = this.ref.current) === null || _b === void 0 ? void 0 : _b.addEventListener('willPresent', this.handleWillPresent);
            (_c = this.ref.current) === null || _c === void 0 ? void 0 : _c.addEventListener('didDismiss', this.handleDidDismiss);
        }
        componentDidUpdate(prevProps) {
            const node = this.ref.current;
            /**
             * onDidDismiss and onWillPresent have manual implementations that
             * will invoke the original handler. We need to filter those out
             * so they don't get attached twice and called twice.
             */
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            const _a = this.props, cProps = __rest(_a, ["onDidDismiss", "onWillPresent"]);
            attachProps(node, cProps, prevProps);
        }
        componentWillUnmount() {
            const node = this.ref.current;
            /**
             * If the overlay is being unmounted, but is still
             * open, this means the unmount was triggered outside
             * of the overlay being dismissed.
             *
             * This can happen with:
             * - The parent component being unmounted
             * - The overlay being conditionally rendered
             * - A route change (push/pop/replace)
             *
             * Unmounting the overlay at this stage should skip
             * the dismiss lifecycle, including skipping the transition.
             *
             */
            if (node && this.state.isOpen) {
                /**
                 * Detach the local event listener that performs the state updates,
                 * before dismissing the overlay, to prevent the callback handlers
                 * executing after the component has been unmounted. This is to
                 * avoid memory leaks.
                 */
                node.removeEventListener('didDismiss', this.handleDidDismiss);
                node.remove();
                detachProps(node, this.props);
            }
        }
        render() {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            const _a = this.props, { children, forwardedRef, style, className, ref } = _a, cProps = __rest(_a, ["children", "forwardedRef", "style", "className", "ref"]);
            const propsToPass = Object.keys(cProps).reduce((acc, name) => {
                if (name.indexOf('on') === 0 && name[2] === name[2].toUpperCase()) {
                    const eventName = name.substring(2).toLowerCase();
                    if (isCoveredByReact(eventName)) {
                        acc[name] = cProps[name];
                    }
                }
                else if (['string', 'boolean', 'number'].includes(typeof cProps[name])) {
                    acc[camelToDashCase(name)] = cProps[name];
                }
                return acc;
            }, {});
            const newProps = Object.assign(Object.assign({}, propsToPass), { ref: this.stableMergedRefs, style });
            /**
             * Some overlays need `.ion-page` so content
             * takes up the full size of the parent overlay.
             */
            const getWrapperClasses = () => {
                if (hasDelegateHost) {
                    return `${DELEGATE_HOST} ion-page`;
                }
                return DELEGATE_HOST;
            };
            return createElement('template', {}, createElement(tagName, newProps, 
            /**
             * We only want the inner component
             * to be mounted if the overlay is open,
             * so conditionally render the component
             * based on the isOpen state.
             */
            this.state.isOpen || this.props.keepContentsMounted
                ? createElement('div', {
                    ref: this.wrapperRef,
                    className: getWrapperClasses(),
                }, children)
                : null));
        }
        static get displayName() {
            return displayName;
        }
    };
    return createForwardRef(ReactComponent, displayName);
};
const DELEGATE_HOST = 'ion-delegate-host';

const IonAlert = /*@__PURE__*/ createInlineOverlayComponent('ion-alert', defineCustomElement$10);

const IonLoading = /*@__PURE__*/ createInlineOverlayComponent('ion-loading', defineCustomElement$11);

const IonToast = /*@__PURE__*/ createInlineOverlayComponent('ion-toast', defineCustomElement$12);

const IonPicker = /*@__PURE__*/ createInlineOverlayComponent('ion-picker', defineCustomElement$13);

const IonActionSheet = /*@__PURE__*/ createInlineOverlayComponent('ion-action-sheet', defineCustomElement$14);

const IonModal = /*@__PURE__*/ createInlineOverlayComponent('ion-modal', defineCustomElement$15, true);

const IonPopover = /*@__PURE__*/ createInlineOverlayComponent('ion-popover', defineCustomElement$16);

const IonContext = React.createContext({
    addOverlay: () => {
        return;
    },
    removeOverlay: () => {
        return;
    },
});

/**
 * Manages overlays that are added via the useOverlay hook.
 * This is a standalone component so changes to its children don't cause other descendant
 * components to re-render when overlays are added. However, we need to communicate with the IonContext
 * that is set up in <IonApp />, so we register callbacks so when overlays are added to IonContext,
 * they ultimately added here.
 */
const IonOverlayManager = ({ onAddOverlay, onRemoveOverlay }) => {
    /**
     * Because of the way we're passing around the addOverlay and removeOverlay
     * callbacks, by the time they finally get called, they use a stale reference
     * to the state that only has the initial values. So if two overlays are opened
     * at the same time, both using useIonModal or similar (such as through nesting),
     * the second will erase the first from the overlays list. This causes the content
     * of the first overlay to unmount.
     *
     * We wrap the state in useRef to ensure the two callbacks always use the most
     * up-to-date version.
     *
     * Further reading: https://stackoverflow.com/a/56554056
     */
    const [overlays, setOverlays] = useState({});
    const overlaysRef = useRef({});
    useEffect(() => {
        /* Setup the callbacks that get called from <IonApp /> */
        onAddOverlay(addOverlay);
        onRemoveOverlay(removeOverlay);
    }, []);
    const addOverlay = (id, component, containerElement) => {
        const newOverlays = Object.assign({}, overlaysRef.current);
        newOverlays[id] = { component, containerElement };
        /**
         * In order for this function to use the latest data
         * we need to update the ref synchronously.
         * However, updating a ref does not cause a re-render
         * which is why we still update the state.
         *
         * Note that updating the ref in the body
         * of IonOverlayManager is not sufficient
         * because that relies on overlaysRef being
         * updated as part of React's render loop. State updates
         * are batched, so updating the state twice in quick succession does
         * not necessarily result in 2 separate render calls.
         * This means if two modals are added one after the other,
         * the first modal will not have been added to
         * overlaysRef since React has not re-rendered yet.
         * More info: https://react.dev/reference/react/useState#setstate-caveats
         */
        overlaysRef.current = newOverlays;
        setOverlays(newOverlays);
    };
    const removeOverlay = (id) => {
        const newOverlays = Object.assign({}, overlaysRef.current);
        delete newOverlays[id];
        /**
         * In order for this function to use the latest data
         * we need to update the ref synchronously.
         * However, updating a ref does not cause a re-render
         * which is why we still update the state.
         *
         * Note that updating the ref in the body
         * of IonOverlayManager is not sufficient
         * because that relies on overlaysRef being
         * updated as part of React's render loop. State updates
         * are batched, so updating the state twice in quick succession does
         * not necessarily result in 2 separate render calls.
         * This means if two modals are added one after the other,
         * the first modal will not have been added to
         * overlaysRef since React has not re-rendered yet.
         * More info: https://react.dev/reference/react/useState#setstate-caveats
         */
        overlaysRef.current = newOverlays;
        setOverlays(newOverlays);
    };
    const overlayKeys = Object.keys(overlays);
    return (React.createElement(React.Fragment, null, overlayKeys.map((key) => {
        const overlay = overlays[key];
        return ReactDOM.createPortal(overlay.component, overlay.containerElement, `overlay-${key}`);
    })));
};

const IonTabButtonInner = /*@__PURE__*/ createReactComponent('ion-tab-button', undefined, undefined, defineCustomElement$1a);
const IonTabBarInner = /*@__PURE__*/ createReactComponent('ion-tab-bar', undefined, undefined, defineCustomElement$17);
const IonBackButtonInner = /*@__PURE__*/ createReactComponent('ion-back-button', undefined, undefined, defineCustomElement$1b);
const IonRouterOutletInner = /*@__PURE__*/ createReactComponent('ion-router-outlet', undefined, undefined, defineCustomElement$18);
const IonAppInner = /*@__PURE__*/ createReactComponent('ion-app', undefined, undefined, defineCustomElement$1c);
// ionicons
const IonIconInner = /*@__PURE__*/ createReactComponent('ion-icon', undefined, undefined, defineCustomElement$19);

const IonApp = /*@__PURE__*/ (() => class extends React.Component {
    constructor(props) {
        super(props);
        /*
          Wire up methods to call into IonOverlayManager
        */
        this.ionContext = {
            addOverlay: (id, overlay, containerElement) => {
                if (this.addOverlayCallback) {
                    this.addOverlayCallback(id, overlay, containerElement);
                }
            },
            removeOverlay: (id) => {
                if (this.removeOverlayCallback) {
                    this.removeOverlayCallback(id);
                }
            },
        };
    }
    render() {
        return (React.createElement(IonContext.Provider, { value: this.ionContext },
            React.createElement(IonAppInner, Object.assign({}, this.props), this.props.children),
            React.createElement(IonOverlayManager, { onAddOverlay: (callback) => {
                    this.addOverlayCallback = callback;
                }, onRemoveOverlay: (callback) => {
                    this.removeOverlayCallback = callback;
                } })));
    }
    static get displayName() {
        return 'IonApp';
    }
})();

const StackContext = React.createContext({
    registerIonPage: () => undefined,
    isInOutlet: () => false,
});

class PageManager extends React.PureComponent {
    constructor(props) {
        super(props);
        this.ionPageElementRef = React.createRef();
        // React refs must be stable (not created inline).
        this.stableMergedRefs = mergeRefs(this.ionPageElementRef, this.props.forwardedRef);
        /**
         * This binds the scope of the following methods to the class scope.
         * The `.bind` method returns a new function, so we need to assign it
         * in the constructor rather than when adding or removing the listeners
         * to avoid creating a new function.
         */
        this.ionViewWillEnterHandler = this.ionViewWillEnterHandler.bind(this);
        this.ionViewDidEnterHandler = this.ionViewDidEnterHandler.bind(this);
        this.ionViewWillLeaveHandler = this.ionViewWillLeaveHandler.bind(this);
        this.ionViewDidLeaveHandler = this.ionViewDidLeaveHandler.bind(this);
    }
    componentDidMount() {
        if (this.ionPageElementRef.current) {
            if (this.context.isInOutlet()) {
                this.ionPageElementRef.current.classList.add('ion-page-invisible');
            }
            this.context.registerIonPage(this.ionPageElementRef.current, this.props.routeInfo);
            this.ionPageElementRef.current.addEventListener('ionViewWillEnter', this.ionViewWillEnterHandler);
            this.ionPageElementRef.current.addEventListener('ionViewDidEnter', this.ionViewDidEnterHandler);
            this.ionPageElementRef.current.addEventListener('ionViewWillLeave', this.ionViewWillLeaveHandler);
            this.ionPageElementRef.current.addEventListener('ionViewDidLeave', this.ionViewDidLeaveHandler);
        }
    }
    componentWillUnmount() {
        if (this.ionPageElementRef.current) {
            this.ionPageElementRef.current.removeEventListener('ionViewWillEnter', this.ionViewWillEnterHandler);
            this.ionPageElementRef.current.removeEventListener('ionViewDidEnter', this.ionViewDidEnterHandler);
            this.ionPageElementRef.current.removeEventListener('ionViewWillLeave', this.ionViewWillLeaveHandler);
            this.ionPageElementRef.current.removeEventListener('ionViewDidLeave', this.ionViewDidLeaveHandler);
        }
    }
    ionViewWillEnterHandler() {
        this.ionLifeCycleContext.ionViewWillEnter();
    }
    ionViewDidEnterHandler() {
        this.ionLifeCycleContext.ionViewDidEnter();
    }
    ionViewWillLeaveHandler() {
        this.ionLifeCycleContext.ionViewWillLeave();
    }
    ionViewDidLeaveHandler() {
        this.ionLifeCycleContext.ionViewDidLeave();
    }
    render() {
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        const _a = this.props, { className, children, routeInfo, forwardedRef } = _a, props = __rest(_a, ["className", "children", "routeInfo", "forwardedRef"]);
        return (React.createElement(IonLifeCycleContext.Consumer, null, (context) => {
            this.ionLifeCycleContext = context;
            return (React.createElement("div", Object.assign({ className: className ? `${className} ion-page` : `ion-page`, ref: this.stableMergedRefs }, props), children));
        }));
    }
    static get contextType() {
        return StackContext;
    }
}

class IonPageInternal extends React.Component {
    constructor(props) {
        super(props);
    }
    render() {
        const _a = this.props, { className, children, forwardedRef } = _a, props = __rest(_a, ["className", "children", "forwardedRef"]);
        return this.context.hasIonicRouter() ? (React.createElement(PageManager, Object.assign({ className: className ? `${className}` : '', routeInfo: this.context.routeInfo, forwardedRef: forwardedRef }, props), children)) : (React.createElement("div", Object.assign({ className: className ? `ion-page ${className}` : 'ion-page', ref: forwardedRef }, props), children));
    }
    static get displayName() {
        return 'IonPage';
    }
    static get contextType() {
        return NavContext;
    }
}
const IonPage = createForwardRef(IonPageInternal, 'IonPage');

const ids = { main: 0 };
const generateId = (type = 'main') => {
    var _a;
    const id = ((_a = ids[type]) !== null && _a !== void 0 ? _a : 0) + 1;
    ids[type] = id;
    return id.toString();
};

const ReactDelegate = (addView, removeView) => {
    const refMap = new WeakMap();
    const reactDelegateId = `react-delegate-${generateId()}`;
    // Incrementing counter to generate unique keys for each view
    let id = 0;
    const attachViewToDom = async (parentElement, component, propsOrDataObj, cssClasses) => {
        const div = document.createElement('div');
        cssClasses && div.classList.add(...cssClasses);
        parentElement.appendChild(div);
        const componentWithProps = component(propsOrDataObj);
        const key = `${reactDelegateId}-${id++}`;
        const hostComponent = createPortal(componentWithProps, div, key);
        refMap.set(div, hostComponent);
        addView(hostComponent);
        return Promise.resolve(div);
    };
    const removeViewFromDom = (_container, component) => {
        const hostComponent = refMap.get(component);
        hostComponent && removeView(hostComponent);
        component.remove();
        return Promise.resolve();
    };
    return {
        attachViewToDom,
        removeViewFromDom,
    };
};

const IonNavInner = createReactComponent('ion-nav', undefined, undefined, defineCustomElement$1d);
// eslint-disable-next-line @typescript-eslint/no-unused-vars
const IonNavInternal = (_a) => {
    var { children, forwardedRef } = _a, restOfProps = __rest(_a, ["children", "forwardedRef"]);
    const [views, setViews] = useState([]);
    /**
     * Allows us to create React components that are rendered within
     * the context of the IonNav component.
     */
    const addView = (view) => setViews((existingViews) => [...existingViews, view]);
    const removeView = (view) => setViews((existingViews) => existingViews.filter((v) => v !== view));
    const delegate = useMemo(() => ReactDelegate(addView, removeView), []);
    return (React.createElement(IonNavInner, Object.assign({ delegate: delegate, ref: forwardedRef }, restOfProps), views));
};
const IonNav = createForwardRef(IonNavInternal, 'IonNav');

const IonTabsContext = React.createContext({
    activeTab: undefined,
    selectTab: () => false,
});

const HTMLElementSSR = (typeof HTMLElement !== 'undefined' ? HTMLElement : class {
});

class OutletPageManager extends React.Component {
    constructor(props) {
        super(props);
        this.outletIsReady = false;
        /**
         * This binds the scope of the following methods to the class scope.
         * The `.bind` method returns a new function, so we need to assign it
         * in the constructor rather than when adding or removing the listeners
         * to avoid creating a new function.
         */
        this.ionViewWillEnterHandler = this.ionViewWillEnterHandler.bind(this);
        this.ionViewDidEnterHandler = this.ionViewDidEnterHandler.bind(this);
        this.ionViewWillLeaveHandler = this.ionViewWillLeaveHandler.bind(this);
        this.ionViewDidLeaveHandler = this.ionViewDidLeaveHandler.bind(this);
    }
    componentDidMount() {
        if (this.ionRouterOutlet) {
            /**
             * This avoids multiple raf calls
             * when React unmounts + remounts components.
             */
            if (!this.outletIsReady) {
                componentOnReady(this.ionRouterOutlet, () => {
                    this.outletIsReady = true;
                    this.context.registerIonPage(this.ionRouterOutlet, this.props.routeInfo);
                });
            }
            this.ionRouterOutlet.addEventListener('ionViewWillEnter', this.ionViewWillEnterHandler);
            this.ionRouterOutlet.addEventListener('ionViewDidEnter', this.ionViewDidEnterHandler);
            this.ionRouterOutlet.addEventListener('ionViewWillLeave', this.ionViewWillLeaveHandler);
            this.ionRouterOutlet.addEventListener('ionViewDidLeave', this.ionViewDidLeaveHandler);
        }
    }
    componentWillUnmount() {
        if (this.ionRouterOutlet) {
            this.ionRouterOutlet.removeEventListener('ionViewWillEnter', this.ionViewWillEnterHandler);
            this.ionRouterOutlet.removeEventListener('ionViewDidEnter', this.ionViewDidEnterHandler);
            this.ionRouterOutlet.removeEventListener('ionViewWillLeave', this.ionViewWillLeaveHandler);
            this.ionRouterOutlet.removeEventListener('ionViewDidLeave', this.ionViewDidLeaveHandler);
        }
    }
    ionViewWillEnterHandler() {
        this.ionLifeCycleContext.ionViewWillEnter();
    }
    ionViewDidEnterHandler() {
        this.ionLifeCycleContext.ionViewDidEnter();
    }
    ionViewWillLeaveHandler() {
        this.ionLifeCycleContext.ionViewWillLeave();
    }
    ionViewDidLeaveHandler() {
        this.ionLifeCycleContext.ionViewDidLeave();
    }
    render() {
        const _a = this.props, { StackManager, children, routeInfo } = _a, props = __rest(_a, ["StackManager", "children", "routeInfo"]);
        return (React.createElement(IonLifeCycleContext.Consumer, null, (context) => {
            this.ionLifeCycleContext = context;
            return (React.createElement(StackManager, { routeInfo: routeInfo },
                React.createElement(IonRouterOutletInner, Object.assign({ setRef: (val) => (this.ionRouterOutlet = val) }, props), children)));
        }));
    }
    static get contextType() {
        return StackContext;
    }
}

class IonRouterOutletContainer extends React.Component {
    constructor(props) {
        super(props);
    }
    render() {
        const StackManager = this.context.getStackManager();
        const _a = this.props, { children, forwardedRef } = _a, props = __rest(_a, ["children", "forwardedRef"]);
        return this.context.hasIonicRouter() ? (props.ionPage ? (React.createElement(OutletPageManager, Object.assign({ StackManager: StackManager, routeInfo: this.context.routeInfo }, props), children)) : (React.createElement(StackManager, { routeInfo: this.context.routeInfo },
            React.createElement(IonRouterOutletInner, Object.assign({}, props, { forwardedRef: forwardedRef }), children)))) : (React.createElement(IonRouterOutletInner, Object.assign({ ref: forwardedRef }, this.props), this.props.children));
    }
    static get contextType() {
        return NavContext;
    }
}
const IonRouterOutlet = createForwardRef(IonRouterOutletContainer, 'IonRouterOutlet');

const IonTabButton = /*@__PURE__*/ (() => class extends React.Component {
    constructor(props) {
        super(props);
        this.handleIonTabButtonClick = this.handleIonTabButtonClick.bind(this);
    }
    handleIonTabButtonClick() {
        if (this.props.onClick) {
            this.props.onClick(new CustomEvent('ionTabButtonClick', {
                detail: {
                    tab: this.props.tab,
                    href: this.props.href,
                    routeOptions: this.props.routerOptions,
                },
            }));
        }
    }
    render() {
        /**
         * onClick is excluded from the props, since it has a custom
         * implementation within IonTabBar.tsx. Calling onClick within this
         * component would result in duplicate handler calls.
         */
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        const _a = this.props, rest = __rest(_a, ["onClick"]);
        return React.createElement(IonTabButtonInner, Object.assign({ onIonTabButtonClick: this.handleIonTabButtonClick }, rest));
    }
    static get displayName() {
        return 'IonTabButton';
    }
})();

// TODO(FW-2959): types
class IonTabBarUnwrapped extends React.PureComponent {
    constructor(props) {
        super(props);
        // eslint-disable-next-line
        this.setActiveTabOnContext = (_tab) => { };
        const tabs = {};
        React.Children.forEach(props.children, (child) => {
            var _a, _b, _c, _d;
            if (child != null &&
                typeof child === 'object' &&
                child.props &&
                (child.type === IonTabButton || child.type.isTabButton)) {
                tabs[child.props.tab] = {
                    originalHref: child.props.href,
                    currentHref: child.props.href,
                    originalRouteOptions: child.props.href === ((_a = props.routeInfo) === null || _a === void 0 ? void 0 : _a.pathname) ? (_b = props.routeInfo) === null || _b === void 0 ? void 0 : _b.routeOptions : undefined,
                    currentRouteOptions: child.props.href === ((_c = props.routeInfo) === null || _c === void 0 ? void 0 : _c.pathname) ? (_d = props.routeInfo) === null || _d === void 0 ? void 0 : _d.routeOptions : undefined,
                };
            }
        });
        this.state = {
            tabs,
        };
        this.onTabButtonClick = this.onTabButtonClick.bind(this);
        this.renderTabButton = this.renderTabButton.bind(this);
        this.setActiveTabOnContext = this.setActiveTabOnContext.bind(this);
        this.selectTab = this.selectTab.bind(this);
    }
    componentDidMount() {
        const tabs = this.state.tabs;
        const tabKeys = Object.keys(tabs);
        const activeTab = tabKeys.find((key) => {
            const href = tabs[key].originalHref;
            return this.props.routeInfo.pathname.startsWith(href);
        });
        if (activeTab) {
            this.setState({
                activeTab,
            });
        }
    }
    componentDidUpdate() {
        if (this.state.activeTab) {
            this.setActiveTabOnContext(this.state.activeTab);
        }
    }
    selectTab(tab) {
        const tabUrl = this.state.tabs[tab];
        if (tabUrl) {
            this.onTabButtonClick(new CustomEvent('ionTabButtonClick', {
                detail: {
                    href: tabUrl.currentHref,
                    tab,
                    selected: tab === this.state.activeTab,
                    routeOptions: undefined,
                },
            }));
            return true;
        }
        return false;
    }
    static getDerivedStateFromProps(props, state) {
        var _a, _b, _c;
        const tabs = Object.assign({}, state.tabs);
        const tabKeys = Object.keys(state.tabs);
        const activeTab = tabKeys.find((key) => {
            const href = state.tabs[key].originalHref;
            return props.routeInfo.pathname.startsWith(href);
        });
        // Check to see if the tab button href has changed, and if so, update it in the tabs state
        React.Children.forEach(props.children, (child) => {
            if (child != null &&
                typeof child === 'object' &&
                child.props &&
                (child.type === IonTabButton || child.type.isTabButton)) {
                const tab = tabs[child.props.tab];
                if (!tab || tab.originalHref !== child.props.href) {
                    tabs[child.props.tab] = {
                        originalHref: child.props.href,
                        currentHref: child.props.href,
                        originalRouteOptions: child.props.routeOptions,
                        currentRouteOptions: child.props.routeOptions,
                    };
                }
            }
        });
        const { activeTab: prevActiveTab } = state;
        if (activeTab && prevActiveTab) {
            const prevHref = state.tabs[prevActiveTab].currentHref;
            const prevRouteOptions = state.tabs[prevActiveTab].currentRouteOptions;
            if (activeTab !== prevActiveTab ||
                prevHref !== ((_a = props.routeInfo) === null || _a === void 0 ? void 0 : _a.pathname) ||
                prevRouteOptions !== ((_b = props.routeInfo) === null || _b === void 0 ? void 0 : _b.routeOptions)) {
                tabs[activeTab] = {
                    originalHref: tabs[activeTab].originalHref,
                    currentHref: props.routeInfo.pathname + (props.routeInfo.search || ''),
                    originalRouteOptions: tabs[activeTab].originalRouteOptions,
                    currentRouteOptions: (_c = props.routeInfo) === null || _c === void 0 ? void 0 : _c.routeOptions,
                };
                if (props.routeInfo.routeAction === 'pop' && activeTab !== prevActiveTab) {
                    // If navigating back and the tabs change, set the prev tab back to its original href
                    tabs[prevActiveTab] = {
                        originalHref: tabs[prevActiveTab].originalHref,
                        currentHref: tabs[prevActiveTab].originalHref,
                        originalRouteOptions: tabs[prevActiveTab].originalRouteOptions,
                        currentRouteOptions: tabs[prevActiveTab].currentRouteOptions,
                    };
                }
            }
        }
        activeTab && props.onSetCurrentTab(activeTab, props.routeInfo);
        return {
            activeTab,
            tabs,
        };
    }
    onTabButtonClick(e, onClickFn) {
        const tappedTab = this.state.tabs[e.detail.tab];
        const originalHref = tappedTab.originalHref;
        const currentHref = e.detail.href;
        const { activeTab: prevActiveTab } = this.state;
        if (onClickFn) {
            /**
             * If the user provides an onClick function, we call it
             * with the original event.
             */
            onClickFn(e);
        }
        // this.props.onSetCurrentTab(e.detail.tab, this.props.routeInfo);
        // Clicking the current tab will bring you back to the original href
        if (prevActiveTab === e.detail.tab) {
            if (originalHref !== currentHref) {
                this.context.resetTab(e.detail.tab, originalHref, tappedTab.originalRouteOptions);
            }
        }
        else {
            if (this.props.onIonTabsWillChange) {
                this.props.onIonTabsWillChange(new CustomEvent('ionTabWillChange', { detail: { tab: e.detail.tab } }));
            }
            if (this.props.onIonTabsDidChange) {
                this.props.onIonTabsDidChange(new CustomEvent('ionTabDidChange', { detail: { tab: e.detail.tab } }));
            }
            this.setActiveTabOnContext(e.detail.tab);
            this.context.changeTab(e.detail.tab, currentHref, e.detail.routeOptions);
        }
    }
    renderTabButton(activeTab) {
        return (child) => {
            var _a, _b;
            if (child != null && child.props && (child.type === IonTabButton || child.type.isTabButton)) {
                const href = child.props.tab === activeTab
                    ? (_a = this.props.routeInfo) === null || _a === void 0 ? void 0 : _a.pathname
                    : this.state.tabs[child.props.tab].currentHref;
                const routeOptions = child.props.tab === activeTab
                    ? (_b = this.props.routeInfo) === null || _b === void 0 ? void 0 : _b.routeOptions
                    : this.state.tabs[child.props.tab].currentRouteOptions;
                return React.cloneElement(child, {
                    href,
                    routeOptions,
                    onClick: (ev) => this.onTabButtonClick(ev, child.props.onClick),
                });
            }
            return null;
        };
    }
    render() {
        const { activeTab } = this.state;
        return (React.createElement(IonTabBarInner, Object.assign({}, this.props, { selectedTab: activeTab }), React.Children.map(this.props.children, this.renderTabButton(activeTab))));
    }
    static get contextType() {
        return NavContext;
    }
}
const IonTabBarContainer = React.memo((_a) => {
    var { forwardedRef } = _a, props = __rest(_a, ["forwardedRef"]);
    const context = useContext(NavContext);
    return (React.createElement(IonTabBarUnwrapped, Object.assign({ ref: forwardedRef }, props, { routeInfo: props.routeInfo || context.routeInfo || { pathname: window.location.pathname }, onSetCurrentTab: context.setCurrentTab }), props.children));
});
const IonTabBar = createForwardRef(IonTabBarContainer, 'IonTabBar');

class IonTabsElement extends HTMLElementSSR {
    constructor() {
        super();
    }
}
// TODO(FW-2959): types
if (typeof window !== 'undefined' && window.customElements) {
    const element = window.customElements.get('ion-tabs');
    if (!element) {
        window.customElements.define('ion-tabs', IonTabsElement);
    }
}
const hostStyles = {
    display: 'flex',
    position: 'absolute',
    top: '0',
    left: '0',
    right: '0',
    bottom: '0',
    flexDirection: 'column',
    width: '100%',
    height: '100%',
    contain: 'layout size style',
};
const tabsInner = {
    position: 'relative',
    flex: 1,
    contain: 'layout size style',
};
const IonTabs = /*@__PURE__*/ (() => class extends React.Component {
    constructor(props) {
        super(props);
        this.routerOutletRef = React.createRef();
        this.tabBarRef = React.createRef();
        this.ionTabContextState = {
            activeTab: undefined,
            selectTab: () => false,
        };
    }
    componentDidMount() {
        if (this.tabBarRef.current) {
            // Grab initial value
            this.ionTabContextState.activeTab = this.tabBarRef.current.state.activeTab;
            // Override method
            this.tabBarRef.current.setActiveTabOnContext = (tab) => {
                this.ionTabContextState.activeTab = tab;
            };
            this.ionTabContextState.selectTab = this.tabBarRef.current.selectTab;
        }
    }
    render() {
        let outlet;
        let tabBar;
        const _a = this.props, { className, onIonTabsDidChange, onIonTabsWillChange } = _a, props = __rest(_a, ["className", "onIonTabsDidChange", "onIonTabsWillChange"]);
        const children = typeof this.props.children === 'function'
            ? this.props.children(this.ionTabContextState)
            : this.props.children;
        React.Children.forEach(children, (child) => {
            // eslint-disable-next-line no-prototype-builtins
            if (child == null || typeof child !== 'object' || !child.hasOwnProperty('type')) {
                return;
            }
            if (child.type === IonRouterOutlet || child.type.isRouterOutlet) {
                outlet = React.cloneElement(child);
            }
            else if (child.type === Fragment && child.props.children[0].type === IonRouterOutlet) {
                outlet = child.props.children[0];
            }
            let childProps = {
                ref: this.tabBarRef,
            };
            /**
             * Only pass these props
             * down from IonTabs to IonTabBar
             * if they are defined, otherwise
             * if you have a handler set on
             * IonTabBar it will be overridden.
             */
            if (onIonTabsDidChange !== undefined) {
                childProps = Object.assign(Object.assign({}, childProps), { onIonTabsDidChange });
            }
            if (onIonTabsWillChange !== undefined) {
                childProps = Object.assign(Object.assign({}, childProps), { onIonTabsWillChange });
            }
            if (child.type === IonTabBar || child.type.isTabBar) {
                tabBar = React.cloneElement(child, childProps);
            }
            else if (child.type === Fragment &&
                (child.props.children[1].type === IonTabBar || child.props.children[1].type.isTabBar)) {
                tabBar = React.cloneElement(child.props.children[1], childProps);
            }
        });
        if (!outlet) {
            throw new Error('IonTabs must contain an IonRouterOutlet');
        }
        if (!tabBar) {
            throw new Error('IonTabs needs a IonTabBar');
        }
        return (React.createElement(IonTabsContext.Provider, { value: this.ionTabContextState }, this.context.hasIonicRouter() ? (React.createElement(PageManager, Object.assign({ className: className ? `${className}` : '', routeInfo: this.context.routeInfo }, props),
            React.createElement("ion-tabs", { className: "ion-tabs", style: hostStyles },
                tabBar.props.slot === 'top' ? tabBar : null,
                React.createElement("div", { style: tabsInner, className: "tabs-inner" }, outlet),
                tabBar.props.slot === 'bottom' ? tabBar : null))) : (React.createElement("div", Object.assign({ className: className ? `${className}` : 'ion-tabs' }, props, { style: hostStyles }),
            tabBar.props.slot === 'top' ? tabBar : null,
            React.createElement("div", { style: tabsInner, className: "tabs-inner" }, outlet),
            tabBar.props.slot === 'bottom' ? tabBar : null))));
    }
    static get contextType() {
        return NavContext;
    }
})();

const IonBackButton = /*@__PURE__*/ (() => class extends React.Component {
    constructor() {
        super(...arguments);
        this.clickButton = (e) => {
            /**
             * If ion-back-button is being used inside
             * of ion-nav then we should not interact with
             * the router.
             */
            if (e.target && e.target.closest('ion-nav') !== null) {
                return;
            }
            const { defaultHref, routerAnimation } = this.props;
            if (this.context.hasIonicRouter()) {
                e.stopPropagation();
                this.context.goBack(defaultHref, routerAnimation);
            }
            else if (defaultHref !== undefined) {
                window.location.href = defaultHref;
            }
        };
    }
    render() {
        return React.createElement(IonBackButtonInner, Object.assign({ onClick: this.clickButton }, this.props));
    }
    static get displayName() {
        return 'IonBackButton';
    }
    static get contextType() {
        return NavContext;
    }
})();

class IonIconContainer extends React.PureComponent {
    constructor(props) {
        super(props);
        if (this.props.name) {
            console.warn('In Ionic React, you import icons from "ionicons/icons" and set the icon you imported to the "icon" property. Setting the "name" property has no effect.');
        }
    }
    render() {
        var _a, _b;
        const _c = this.props, { icon, ios, md, mode } = _c, rest = __rest(_c, ["icon", "ios", "md", "mode"]);
        let iconToUse;
        const config = getConfig();
        const iconMode = mode || (config === null || config === void 0 ? void 0 : config.get('mode'));
        if (ios || md) {
            if (iconMode === 'ios') {
                iconToUse = (_a = ios !== null && ios !== void 0 ? ios : md) !== null && _a !== void 0 ? _a : icon;
            }
            else {
                iconToUse = (_b = md !== null && md !== void 0 ? md : ios) !== null && _b !== void 0 ? _b : icon;
            }
        }
        else {
            iconToUse = icon;
        }
        return (React.createElement(IonIconInner, Object.assign({ ref: this.props.forwardedRef, icon: iconToUse }, rest), this.props.children));
    }
    static get contextType() {
        return NavContext;
    }
}
const IonIcon = createForwardRef(IonIconContainer, 'IonIcon');

class IonRoute extends React.PureComponent {
    render() {
        const IonRouteInner = this.context.getIonRoute();
        if (!this.context.hasIonicRouter() || !IonRoute) {
            console.error('You either do not have an Ionic Router package, or your router does not support using <IonRoute>');
            return null;
        }
        return React.createElement(IonRouteInner, Object.assign({}, this.props));
    }
    static get contextType() {
        return NavContext;
    }
}

class IonRedirect extends React.PureComponent {
    render() {
        const IonRedirectInner = this.context.getIonRedirect();
        if (!this.context.hasIonicRouter() || !IonRedirect) {
            console.error('You either do not have an Ionic Router package, or your router does not support using <IonRedirect>');
            return null;
        }
        return React.createElement(IonRedirectInner, Object.assign({}, this.props));
    }
    static get contextType() {
        return NavContext;
    }
}

const IonRouterContext = React.createContext({
    routeInfo: undefined,
    push: () => {
        throw new Error('An Ionic Router is required for IonRouterContext');
    },
    back: () => {
        throw new Error('An Ionic Router is required for IonRouterContext');
    },
    canGoBack: () => {
        throw new Error('An Ionic Router is required for IonRouterContext');
    },
    nativeBack: () => {
        throw new Error('An Ionic Router is required for IonRouterContext');
    },
});
/**
 * A hook for more direct control over routing in an Ionic React application. Allows you to pass additional meta-data to the router before the call to the native router.
 */
function useIonRouter() {
    const context = useContext(IonRouterContext);
    return useMemo(() => ({
        back: context.back,
        push: context.push,
        goBack: context.back,
        canGoBack: context.canGoBack,
        routeInfo: context.routeInfo,
    }), [context.back, context.push, context.canGoBack, context.routeInfo]);
}

class CreateAnimation extends React.PureComponent {
    constructor(props) {
        super(props);
        this.nodes = new Map();
        this.animation = createAnimation(props.id);
    }
    setupAnimation(props) {
        const animation = this.animation;
        if (this.nodes.size > 0) {
            animation.addElement(Array.from(this.nodes.values()));
        }
        checkConfig(animation, props);
        checkPlayback(animation, props);
    }
    componentDidMount() {
        const props = this.props;
        this.setupAnimation(props);
    }
    componentDidUpdate(prevProps) {
        const animation = this.animation;
        const props = this.props;
        checkConfig(animation, props, prevProps);
        checkProgress(animation, props, prevProps);
        checkPlayback(animation, props, prevProps);
    }
    render() {
        const { children } = this.props;
        return (React.createElement(React.Fragment, null, React.Children.map(children, (child, id) => React.cloneElement(child, { ref: (el) => this.nodes.set(id, el) }))));
    }
}
const checkConfig = (animation, currentProps = {}, prevProps = {}) => {
    const reservedProps = [
        'children',
        'progressStart',
        'progressStep',
        'progressEnd',
        'pause',
        'stop',
        'destroy',
        'play',
        'from',
        'to',
        'fromTo',
        'onFinish',
    ];
    for (const key in currentProps) {
        if (
        // eslint-disable-next-line no-prototype-builtins
        currentProps.hasOwnProperty(key) &&
            !reservedProps.includes(key) &&
            currentProps[key] !== prevProps[key]) {
            animation[key](currentProps[key]);
        }
    }
    const fromValues = currentProps.from;
    if (fromValues && fromValues !== prevProps.from) {
        const values = Array.isArray(fromValues) ? fromValues : [fromValues];
        values.forEach((val) => animation.from(val.property, val.value));
    }
    const toValues = currentProps.to;
    if (toValues && toValues !== prevProps.to) {
        const values = Array.isArray(toValues) ? toValues : [toValues];
        values.forEach((val) => animation.to(val.property, val.value));
    }
    const fromToValues = currentProps.fromTo;
    if (fromToValues && fromToValues !== prevProps.fromTo) {
        const values = Array.isArray(fromToValues) ? fromToValues : [fromToValues];
        values.forEach((val) => animation.fromTo(val.property, val.fromValue, val.toValue));
    }
    const onFinishValues = currentProps.onFinish;
    if (onFinishValues && onFinishValues !== prevProps.onFinish) {
        const values = Array.isArray(onFinishValues) ? onFinishValues : [onFinishValues];
        values.forEach((val) => animation.onFinish(val.callback, val.opts));
    }
};
const checkProgress = (animation, currentProps = {}, prevProps = {}) => {
    var _a, _b, _c, _d, _e;
    const { progressStart, progressStep, progressEnd } = currentProps;
    if (progressStart &&
        (((_a = prevProps.progressStart) === null || _a === void 0 ? void 0 : _a.forceLinearEasing) !== (progressStart === null || progressStart === void 0 ? void 0 : progressStart.forceLinearEasing) ||
            ((_b = prevProps.progressStart) === null || _b === void 0 ? void 0 : _b.step) !== (progressStart === null || progressStart === void 0 ? void 0 : progressStart.step))) {
        animation.progressStart(progressStart.forceLinearEasing, progressStart.step);
    }
    if (progressStep && ((_c = prevProps.progressStep) === null || _c === void 0 ? void 0 : _c.step) !== (progressStep === null || progressStep === void 0 ? void 0 : progressStep.step)) {
        animation.progressStep(progressStep.step);
    }
    if (progressEnd &&
        (((_d = prevProps.progressEnd) === null || _d === void 0 ? void 0 : _d.playTo) !== (progressEnd === null || progressEnd === void 0 ? void 0 : progressEnd.playTo) ||
            ((_e = prevProps.progressEnd) === null || _e === void 0 ? void 0 : _e.step) !== (progressEnd === null || progressEnd === void 0 ? void 0 : progressEnd.step) ||
            (prevProps === null || prevProps === void 0 ? void 0 : prevProps.dur) !== (progressEnd === null || progressEnd === void 0 ? void 0 : progressEnd.dur))) {
        animation.progressEnd(progressEnd.playTo, progressEnd.step, progressEnd.dur);
    }
};
const checkPlayback = (animation, currentProps = {}, prevProps = {}) => {
    if (!prevProps.play && currentProps.play) {
        animation.play();
    }
    if (!prevProps.pause && currentProps.pause) {
        animation.pause();
    }
    if (!prevProps.stop && currentProps.stop) {
        animation.stop();
    }
    if (!prevProps.destroy && currentProps.destroy) {
        animation.destroy();
    }
};

function useController(displayName, controller, defineCustomElement) {
    const overlayRef = useRef();
    const didDismissEventName = useMemo(() => `on${displayName}DidDismiss`, [displayName]);
    const didPresentEventName = useMemo(() => `on${displayName}DidPresent`, [displayName]);
    const willDismissEventName = useMemo(() => `on${displayName}WillDismiss`, [displayName]);
    const willPresentEventName = useMemo(() => `on${displayName}WillPresent`, [displayName]);
    defineCustomElement();
    const present = useCallback(async (options) => {
        if (overlayRef.current) {
            return;
        }
        const { onDidDismiss, onWillDismiss, onDidPresent, onWillPresent } = options, rest = __rest(options, ["onDidDismiss", "onWillDismiss", "onDidPresent", "onWillPresent"]);
        const handleDismiss = (event) => {
            if (onDidDismiss) {
                onDidDismiss(event);
            }
            overlayRef.current = undefined;
        };
        overlayRef.current = await controller.create(Object.assign({}, rest));
        attachProps(overlayRef.current, {
            [didDismissEventName]: handleDismiss,
            [didPresentEventName]: (e) => onDidPresent && onDidPresent(e),
            [willDismissEventName]: (e) => onWillDismiss && onWillDismiss(e),
            [willPresentEventName]: (e) => onWillPresent && onWillPresent(e),
        });
        overlayRef.current.present();
    }, [controller]);
    const dismiss = useCallback(async () => {
        overlayRef.current && (await overlayRef.current.dismiss());
        overlayRef.current = undefined;
    }, []);
    return {
        present,
        dismiss,
    };
}

/**
 * A hook for presenting/dismissing an IonActionSheet component
 * @returns Returns the present and dismiss methods in an array
 */
function useIonActionSheet() {
    const controller = useController('IonActionSheet', actionSheetController, defineCustomElement$14);
    const present = useCallback((buttonsOrOptions, header) => {
        if (Array.isArray(buttonsOrOptions)) {
            return controller.present({
                buttons: buttonsOrOptions,
                header,
            });
        }
        else {
            return controller.present(buttonsOrOptions);
        }
    }, [controller.present]);
    return [present, controller.dismiss];
}

/**
 * A hook for presenting/dismissing an IonAlert component
 * @returns Returns the present and dismiss methods in an array
 */
function useIonAlert() {
    const controller = useController('IonAlert', alertController, defineCustomElement$10);
    const present = useCallback((messageOrOptions, buttons) => {
        if (typeof messageOrOptions === 'string') {
            return controller.present({
                message: messageOrOptions,
                buttons: buttons !== null && buttons !== void 0 ? buttons : [{ text: 'Ok' }],
            });
        }
        else {
            return controller.present(messageOrOptions);
        }
    }, [controller.present]);
    return [present, controller.dismiss];
}

/**
 * A hook for presenting/dismissing an IonToast component
 * @returns Returns the present and dismiss methods in an array
 */
function useIonToast() {
    const controller = useController('IonToast', toastController, defineCustomElement$12);
    const present = useCallback((messageOrOptions, duration) => {
        if (typeof messageOrOptions === 'string') {
            return controller.present({
                message: messageOrOptions,
                duration,
            });
        }
        else {
            return controller.present(messageOrOptions);
        }
    }, [controller.present]);
    return [present, controller.dismiss];
}

function useOverlay(displayName, controller, defineCustomElement, component, componentProps) {
    const overlayRef = useRef();
    const containerElRef = useRef();
    const didDismissEventName = useMemo(() => `on${displayName}DidDismiss`, [displayName]);
    const didPresentEventName = useMemo(() => `on${displayName}DidPresent`, [displayName]);
    const willDismissEventName = useMemo(() => `on${displayName}WillDismiss`, [displayName]);
    const willPresentEventName = useMemo(() => `on${displayName}WillPresent`, [displayName]);
    const [isOpen, setIsOpen] = useState(false);
    const ionContext = useContext(IonContext);
    const [overlayId] = useState(generateId('overlay'));
    defineCustomElement();
    useEffect(() => {
        if (isOpen && component && containerElRef.current) {
            if (React.isValidElement(component)) {
                ionContext.addOverlay(overlayId, component, containerElRef.current);
            }
            else {
                const element = createElement(component, componentProps);
                ionContext.addOverlay(overlayId, element, containerElRef.current);
            }
        }
    }, [component, containerElRef.current, isOpen, componentProps]);
    const present = useCallback(async (options) => {
        if (overlayRef.current) {
            return;
        }
        const { onDidDismiss, onWillDismiss, onDidPresent, onWillPresent } = options, rest = __rest(options, ["onDidDismiss", "onWillDismiss", "onDidPresent", "onWillPresent"]);
        if (typeof document !== 'undefined') {
            containerElRef.current = document.createElement('div');
        }
        overlayRef.current = await controller.create(Object.assign(Object.assign({}, rest), { component: containerElRef.current }));
        attachProps(overlayRef.current, {
            [didDismissEventName]: handleDismiss,
            [didPresentEventName]: (e) => onDidPresent && onDidPresent(e),
            [willDismissEventName]: (e) => onWillDismiss && onWillDismiss(e),
            [willPresentEventName]: (e) => onWillPresent && onWillPresent(e),
        });
        overlayRef.current.present();
        setIsOpen(true);
        function handleDismiss(event) {
            if (onDidDismiss) {
                onDidDismiss(event);
            }
            overlayRef.current = undefined;
            containerElRef.current = undefined;
            setIsOpen(false);
            ionContext.removeOverlay(overlayId);
        }
    }, []);
    const dismiss = useCallback(async (data, role) => {
        overlayRef.current && (await overlayRef.current.dismiss(data, role));
        overlayRef.current = undefined;
        containerElRef.current = undefined;
    }, []);
    return {
        present,
        dismiss,
    };
}

// TODO(FW-2959): types
/**
 * A hook for presenting/dismissing an IonModal component
 * @param component The component that the modal will show. Can be a React Component, a functional component, or a JSX Element
 * @param componentProps The props that will be passed to the component, if required
 * @returns Returns the present and dismiss methods in an array
 */
function useIonModal(component, componentProps) {
    const controller = useOverlay('IonModal', modalController, defineCustomElement$15, component, componentProps);
    const present = useCallback((options = {}) => {
        controller.present(options);
    }, [controller.present]);
    return [present, controller.dismiss];
}

// TODO(FW-2959): types
/**
 * A hook for presenting/dismissing an IonPicker component
 * @param component The component that the popover will show. Can be a React Component, a functional component, or a JSX Element
 * @param componentProps The props that will be passed to the component, if required
 * @returns Returns the present and dismiss methods in an array
 */
function useIonPopover(component, componentProps) {
    const controller = useOverlay('IonPopover', popoverController, defineCustomElement$16, component, componentProps);
    const present = useCallback((options = {}) => {
        controller.present(options);
    }, [controller.present]);
    return [present, controller.dismiss];
}

/**
 * A hook for presenting/dismissing an IonPicker component
 * @returns Returns the present and dismiss methods in an array
 */
function useIonPicker() {
    const controller = useController('IonPicker', pickerController, defineCustomElement$13);
    const present = useCallback((columnsOrOptions, buttons) => {
        if (Array.isArray(columnsOrOptions)) {
            return controller.present({
                columns: columnsOrOptions,
                buttons: buttons !== null && buttons !== void 0 ? buttons : [{ text: 'Ok' }],
            });
        }
        else {
            return controller.present(columnsOrOptions);
        }
    }, [controller.present]);
    return [present, controller.dismiss];
}

/**
 * A hook for presenting/dismissing an IonLoading component
 * @returns Returns the present and dismiss methods in an array
 */
function useIonLoading() {
    const controller = useController('IonLoading', loadingController, defineCustomElement$11);
    const present = useCallback((messageOrOptions = {}, duration, spinner) => {
        if (typeof messageOrOptions === 'string') {
            return controller.present({
                message: messageOrOptions,
                duration,
                spinner,
            });
        }
        else {
            return controller.present(messageOrOptions);
        }
    }, [controller.present]);
    return [present, controller.dismiss];
}

const setupIonicReact = (config = {}) => {
    /**
     * By default Ionic Framework hides elements that
     * are not hydrated, but in the CE build there is no
     * hydration.
     * TODO FW-2797: Remove when all integrations have been
     * migrated to CE build.
     */
    if (typeof document !== 'undefined') {
        document.documentElement.classList.add('ion-ce');
    }
    initialize(Object.assign({}, config));
};

// TODO(FW-2959): types
const RouteManagerContext = /*@__PURE__*/ React.createContext({
    addViewItem: () => undefined,
    canGoBack: () => undefined,
    clearOutlet: () => undefined,
    createViewItem: () => undefined,
    findViewItemByPathname: () => undefined,
    findLeavingViewItemByRouteInfo: () => undefined,
    findViewItemByRouteInfo: () => undefined,
    getChildrenToRender: () => undefined,
    goBack: () => undefined,
    unMountViewItem: () => undefined,
});

class ViewLifeCycleManager extends React.Component {
    constructor(props) {
        super(props);
        this.ionLifeCycleContext = new DefaultIonLifeCycleContext();
        this._isMounted = false;
        this.ionLifeCycleContext.onComponentCanBeDestroyed(() => {
            if (!this.props.mount) {
                if (this._isMounted) {
                    this.setState({
                        show: false,
                    }, () => this.props.removeView());
                }
            }
        });
        this.state = {
            show: true,
        };
    }
    componentDidMount() {
        this._isMounted = true;
    }
    componentWillUnmount() {
        this._isMounted = false;
    }
    render() {
        const { show } = this.state;
        return (React.createElement(IonLifeCycleContext.Provider, { value: this.ionLifeCycleContext }, show && this.props.children));
    }
}

// const RESTRICT_SIZE = 100;
class LocationHistory {
    constructor() {
        this.locationHistory = [];
        this.tabHistory = {};
    }
    add(routeInfo) {
        if (routeInfo.routeAction === 'push' || routeInfo.routeAction == null) {
            this._add(routeInfo);
        }
        else if (routeInfo.routeAction === 'pop') {
            this._pop(routeInfo);
        }
        else if (routeInfo.routeAction === 'replace') {
            this._replace(routeInfo);
        }
        if (routeInfo.routeDirection === 'root') {
            this._clear();
            this._add(routeInfo);
        }
    }
    clearTabStack(tab) {
        const routeInfos = this._getRouteInfosByKey(tab);
        if (routeInfos) {
            routeInfos.forEach((ri) => {
                this.locationHistory = this.locationHistory.filter((x) => x.id !== ri.id);
            });
            this.tabHistory[tab] = [];
        }
    }
    update(routeInfo) {
        const locationIndex = this.locationHistory.findIndex((x) => x.id === routeInfo.id);
        if (locationIndex > -1) {
            this.locationHistory.splice(locationIndex, 1, routeInfo);
        }
        const tabArray = this.tabHistory[routeInfo.tab || ''];
        if (tabArray) {
            const tabIndex = tabArray.findIndex((x) => x.id === routeInfo.id);
            if (tabIndex > -1) {
                tabArray.splice(tabIndex, 1, routeInfo);
            }
            else {
                tabArray.push(routeInfo);
            }
        }
        else if (routeInfo.tab) {
            this.tabHistory[routeInfo.tab] = [routeInfo];
        }
    }
    _add(routeInfo) {
        const routeInfos = this._getRouteInfosByKey(routeInfo.tab);
        if (routeInfos) {
            // If the latest routeInfo is the same (going back and forth between tabs), replace it
            if (this._areRoutesEqual(routeInfos[routeInfos.length - 1], routeInfo)) {
                routeInfos.pop();
            }
            routeInfos.push(routeInfo);
        }
        this.locationHistory.push(routeInfo);
    }
    _areRoutesEqual(route1, route2) {
        if (!route1 || !route2) {
            return false;
        }
        return route1.pathname === route2.pathname && route1.search === route2.search;
    }
    _pop(routeInfo) {
        const routeInfos = this._getRouteInfosByKey(routeInfo.tab);
        if (routeInfos) {
            // Pop the previous route
            routeInfos.pop();
            // Replace the current route with an updated version
            routeInfos.pop();
            routeInfos.push(routeInfo);
        }
        // Pop the previous route
        this.locationHistory.pop();
        // Replace the current route with an updated version
        this.locationHistory.pop();
        this.locationHistory.push(routeInfo);
    }
    _replace(routeInfo) {
        const routeInfos = this._getRouteInfosByKey(routeInfo.tab);
        routeInfos && routeInfos.pop();
        this.locationHistory.pop();
        this._add(routeInfo);
    }
    _clear() {
        const keys = Object.keys(this.tabHistory);
        keys.forEach((k) => (this.tabHistory[k] = []));
        this.locationHistory = [];
    }
    _getRouteInfosByKey(key) {
        let routeInfos;
        if (key) {
            routeInfos = this.tabHistory[key];
            if (!routeInfos) {
                routeInfos = this.tabHistory[key] = [];
            }
        }
        return routeInfos;
    }
    getFirstRouteInfoForTab(tab) {
        const routeInfos = this._getRouteInfosByKey(tab);
        if (routeInfos) {
            return routeInfos[0];
        }
        return undefined;
    }
    getCurrentRouteInfoForTab(tab) {
        const routeInfos = this._getRouteInfosByKey(tab);
        if (routeInfos) {
            return routeInfos[routeInfos.length - 1];
        }
        return undefined;
    }
    findLastLocation(routeInfo) {
        const routeInfos = this._getRouteInfosByKey(routeInfo.tab);
        if (routeInfos) {
            for (let i = routeInfos.length - 2; i >= 0; i--) {
                const ri = routeInfos[i];
                if (ri) {
                    if (ri.pathname === routeInfo.pushedByRoute) {
                        return ri;
                    }
                }
            }
        }
        for (let i = this.locationHistory.length - 2; i >= 0; i--) {
            const ri = this.locationHistory[i];
            if (ri) {
                if (ri.pathname === routeInfo.pushedByRoute) {
                    return ri;
                }
            }
        }
        return undefined;
    }
    previous() {
        return (this.locationHistory[this.locationHistory.length - 2] || this.locationHistory[this.locationHistory.length - 1]);
    }
    current() {
        return this.locationHistory[this.locationHistory.length - 1];
    }
    canGoBack() {
        return this.locationHistory.length > 1;
    }
}

class NavManager extends React.PureComponent {
    constructor(props) {
        super(props);
        this.ionRouterContextValue = {
            push: (pathname, routerDirection, routeAction, routerOptions, animationBuilder) => {
                this.navigate(pathname, routerDirection, routeAction, animationBuilder, routerOptions);
            },
            back: (animationBuilder) => {
                this.goBack(undefined, animationBuilder);
            },
            canGoBack: () => this.props.locationHistory.canGoBack(),
            nativeBack: () => this.props.onNativeBack(),
            routeInfo: this.props.routeInfo,
        };
        this.state = {
            goBack: this.goBack.bind(this),
            hasIonicRouter: () => true,
            navigate: this.navigate.bind(this),
            getIonRedirect: this.getIonRedirect.bind(this),
            getIonRoute: this.getIonRoute.bind(this),
            getStackManager: this.getStackManager.bind(this),
            getPageManager: this.getPageManager.bind(this),
            routeInfo: this.props.routeInfo,
            setCurrentTab: this.props.onSetCurrentTab,
            changeTab: this.props.onChangeTab,
            resetTab: this.props.onResetTab,
        };
    }
    componentDidMount() {
        if (typeof document !== 'undefined') {
            this.handleHardwareBackButton = this.handleHardwareBackButton.bind(this);
            document.addEventListener('ionBackButton', this.handleHardwareBackButton);
        }
    }
    componentWillUnmount() {
        if (typeof document !== 'undefined') {
            document.removeEventListener('ionBackButton', this.handleHardwareBackButton);
        }
    }
    handleHardwareBackButton(e) {
        e.detail.register(0, (processNextHandler) => {
            this.nativeGoBack();
            processNextHandler();
        });
    }
    goBack(route, animationBuilder) {
        this.props.onNavigateBack(route, animationBuilder);
    }
    nativeGoBack() {
        this.props.onNativeBack();
    }
    navigate(path, direction = 'forward', action = 'push', animationBuilder, options, tab) {
        this.props.onNavigate(path, action, direction, animationBuilder, options, tab);
    }
    getPageManager() {
        return PageManager;
    }
    getIonRedirect() {
        return this.props.ionRedirect;
    }
    getIonRoute() {
        return this.props.ionRoute;
    }
    getStackManager() {
        return this.props.stackManager;
    }
    render() {
        return (React.createElement(NavContext.Provider, { value: Object.assign(Object.assign({}, this.state), { routeInfo: this.props.routeInfo }) },
            React.createElement(IonRouterContext.Provider, { value: Object.assign(Object.assign({}, this.ionRouterContextValue), { routeInfo: this.props.routeInfo }) }, this.props.children)));
    }
}

class ViewStacks {
    constructor() {
        this.viewStacks = {};
        this.add = this.add.bind(this);
        this.clear = this.clear.bind(this);
        this.getViewItemsForOutlet = this.getViewItemsForOutlet.bind(this);
        this.remove = this.remove.bind(this);
    }
    add(viewItem) {
        const { outletId } = viewItem;
        if (!this.viewStacks[outletId]) {
            this.viewStacks[outletId] = [viewItem];
        }
        else {
            this.viewStacks[outletId].push(viewItem);
        }
    }
    clear(outletId) {
        // Give some time for the leaving views to transition before removing
        return setTimeout(() => {
            delete this.viewStacks[outletId];
        }, 500);
    }
    getViewItemsForOutlet(outletId) {
        return this.viewStacks[outletId] || [];
    }
    remove(viewItem) {
        const { outletId } = viewItem;
        const viewStack = this.viewStacks[outletId];
        if (viewStack) {
            const viewItemToRemove = viewStack.find((x) => x.id === viewItem.id);
            if (viewItemToRemove) {
                viewItemToRemove.mount = false;
                this.viewStacks[outletId] = viewStack.filter((x) => x.id !== viewItemToRemove.id);
            }
        }
    }
    getStackIds() {
        return Object.keys(this.viewStacks);
    }
    getAllViewItems() {
        const keys = this.getStackIds();
        const viewItems = [];
        keys.forEach((k) => {
            viewItems.push(...this.viewStacks[k]);
        });
        return viewItems;
    }
}

export { CreateAnimation, DefaultIonLifeCycleContext, IonAccordion, IonAccordionGroup, IonActionSheet, IonAlert, IonApp, IonAvatar, IonBackButton, IonBackdrop, IonBadge, IonBreadcrumb, IonBreadcrumbs, IonButton, IonButtons, IonCard, IonCardContent, IonCardHeader, IonCardSubtitle, IonCardTitle, IonCheckbox, IonChip, IonCol, IonContent, IonDatetime, IonDatetimeButton, IonFab, IonFabButton, IonFabList, IonFooter, IonGrid, IonHeader, IonIcon, IonImg, IonInfiniteScroll, IonInfiniteScrollContent, IonInput, IonItem, IonItemDivider, IonItemGroup, IonItemOption, IonItemOptions, IonItemSliding, IonLabel, IonLifeCycleContext, IonList, IonListHeader, IonLoading, IonMenu, IonMenuButton, IonMenuToggle, IonModal, IonNav, IonNavLink, IonNote, IonPage, IonPicker, IonPopover, IonProgressBar, IonRadio, IonRadioGroup, IonRange, IonRedirect, IonRefresher, IonRefresherContent, IonReorder, IonReorderGroup, IonRippleEffect, IonRoute, IonRouterContext, IonRouterLink, IonRouterOutlet, IonRow, IonSearchbar, IonSegment, IonSegmentButton, IonSelect, IonSelectOption, IonSkeletonText, IonSpinner, IonSplitPane, IonTab, IonTabBar, IonTabButton, IonTabs, IonTabsContext, IonText, IonTextarea, IonThumbnail, IonTitle, IonToast, IonToggle, IonToolbar, LocationHistory, NavContext, NavManager, RouteManagerContext, StackContext, ViewLifeCycleManager, ViewStacks, generateId, getConfig, getPlatforms, isPlatform, setupIonicReact, useIonActionSheet, useIonAlert, useIonLoading, useIonModal, useIonPicker, useIonPopover, useIonRouter, useIonToast, useIonViewDidEnter, useIonViewDidLeave, useIonViewWillEnter, useIonViewWillLeave, withIonLifeCycle };
//# sourceMappingURL=index.js.map
