"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPS = void 0;
const log_1 = require("../../util/log");
async function execute(ctx, op) {
    var _a;
    const xmlOp = op;
    const entries = xmlOp.value;
    for (const entry of entries) {
        const xmlFile = await ((_a = ctx.project.ios) === null || _a === void 0 ? void 0 : _a.getXmlFile(entry.file));
        if (!xmlFile) {
            throw new Error(`No such XML file for xml operation: ${entry.file}`);
        }
        try {
            await xmlFile.load();
        }
        catch (e) {
            (0, log_1.error)('Unable to load the XML file here', e);
            return;
        }
        try {
            if (entry.attrs) {
                await xmlFile.setAttrs(entry.target, entry.merge);
            }
            else if (entry.inject) {
                await xmlFile.injectFragment(entry.target, entry.inject);
            }
            else if (entry.merge) {
                await xmlFile.mergeFragment(entry.target, entry.merge);
            }
            else if (entry.replace) {
                await xmlFile.replaceFragment(entry.target, entry.replace);
            }
            else if (entry.delete) {
                await xmlFile.deleteNodes(entry.delete);
            }
            else if (entry.deleteAttributes) {
                await xmlFile.deleteAttributes(entry.target, entry.deleteAttributes);
            }
        }
        catch (e) {
            log_1.logger.warn(`Skipping ${op.id} (${e.message})`);
        }
    }
}
exports.default = execute;
exports.OPS = [
    'ios.xml'
];
//# sourceMappingURL=xml.js.map