/*!
 Stencil Testing v4.4.1 | MIT Licensed | https://stenciljs.com
 */
function _lazyRequire(e) {
 return new Proxy({}, {
  get(t, r) {
   const n = require(e);
   return Reflect.get(n, r);
  },
  set(t, r, n) {
   const s = require(e);
   return Reflect.set(s, r, n);
  }
 });
}

function _interopDefaultLegacy(e) {
 return e && "object" == typeof e && "default" in e ? e : {
  default: e
 };
}

function _interopNamespace(e) {
 if (e && e.__esModule) return e;
 var t = Object.create(null);
 return e && Object.keys(e).forEach((function(r) {
  if ("default" !== r) {
   var n = Object.getOwnPropertyDescriptor(e, r);
   Object.defineProperty(t, r, n.get ? n : {
    enumerable: !0,
    get: function() {
     return e[r];
    }
   });
  }
 })), t.default = e, Object.freeze(t);
}

function createCommonjsModule(e, t, r) {
 return e(r = {
  path: t,
  exports: {},
  require: function(e, t) {
   return function n() {
    throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs");
   }(null == t && r.path);
  }
 }, r.exports), r.exports;
}

async function startPuppeteerBrowser(e) {
 if (!e.flags.e2e) return null;
 const t = process.env, r = e.testing.browserExecutablePath ? "puppeteer-core" : "puppeteer", n = e.sys.lazyRequire.getModulePath(e.rootDir, r), s = e.sys.platformPath.join(n, "package.json"), o = e.sys.lazyRequire.require(e.rootDir, n);
 t.__STENCIL_PUPPETEER_MODULE__ = n;
 try {
  const r = e.sys.readFileSync(s, "utf8"), n = JSON.parse(r);
  t.__STENCIL_PUPPETEER_VERSION__ = major_1(n.version);
 } catch (e) {
  console.error(`An error occurred determining the version of Puppeteer installed:\n${e}`), 
  t.__STENCIL_PUPPETEER_VERSION__ = void 0;
 }
 t.__STENCIL_BROWSER_WAIT_UNTIL = e.testing.browserWaitUntil, e.flags.devtools && (t.__STENCIL_E2E_DEVTOOLS__ = "true"), 
 e.logger.debug(`puppeteer: ${n}`), e.logger.debug(`puppeteer headless: ${e.testing.browserHeadless}`), 
 Array.isArray(e.testing.browserArgs) && e.logger.debug(`puppeteer args: ${e.testing.browserArgs.join(" ")}`), 
 "boolean" == typeof e.testing.browserDevtools && e.logger.debug(`puppeteer devtools: ${e.testing.browserDevtools}`), 
 "number" == typeof e.testing.browserSlowMo && e.logger.debug(`puppeteer slowMo: ${e.testing.browserSlowMo}`);
 const i = {
  ignoreHTTPSErrors: !0,
  slowMo: e.testing.browserSlowMo
 };
 let a;
 if (e.testing.browserWSEndpoint) a = await o.connect({
  browserWSEndpoint: e.testing.browserWSEndpoint,
  ...i
 }); else {
  const t = {
   args: e.testing.browserArgs,
   headless: e.testing.browserHeadless,
   devtools: e.testing.browserDevtools,
   ...i
  };
  e.testing.browserExecutablePath && (t.executablePath = e.testing.browserExecutablePath), 
  a = await o.launch({
   ...t
  });
 }
 return t.__STENCIL_BROWSER_WS_ENDPOINT__ = a.wsEndpoint(), e.logger.debug(`puppeteer browser wsEndpoint: ${t.__STENCIL_BROWSER_WS_ENDPOINT__}`), 
 a;
}

function transpile(e, t = {}) {
 var r;
 t = {
  ...t,
  componentExport: null,
  componentMetadata: "compilerstatic",
  coreImportPath: isString(t.coreImportPath) ? t.coreImportPath : "@stencil/core/internal/testing",
  currentDirectory: t.currentDirectory || process.cwd(),
  module: "cjs",
  proxy: null,
  sourceMap: "inline",
  style: null,
  styleImportData: "queryparams",
  target: "es2015",
  transformAliasedImportPaths: (r = process.env.__STENCIL_TRANSPILE_PATHS__, "true" === r)
 };
 try {
  const e = process.versions.node.split(".");
  parseInt(e[0], 10) >= 10 && (t.target = "es2017");
 } catch (e) {}
 return stencil_js.transpileSync(e, t);
}

function formatDiagnostic(e) {
 let t = "";
 return e.relFilePath && (t += e.relFilePath, "number" == typeof e.lineNumber && (t += ":" + e.lineNumber + 1, 
 "number" == typeof e.columnNumber && (t += ":" + e.columnNumber)), t += "\n"), t += e.messageText, 
 t;
}

function getCompilerOptions(e) {
 if (_tsCompilerOptions) return _tsCompilerOptions;
 if ("string" != typeof e) return null;
 e = normalizePath(e);
 const t = stencil_js.ts.findConfigFile(e, stencil_js.ts.sys.fileExists);
 if (!t) return null;
 const r = stencil_js.ts.readConfigFile(t, stencil_js.ts.sys.readFile);
 if (r.error) throw new Error(formatDiagnostic((e => {
  var t;
  const r = {
   absFilePath: void 0,
   code: e.code.toString(),
   columnNumber: void 0,
   header: "TypeScript",
   language: "typescript",
   level: "warn",
   lineNumber: void 0,
   lines: [],
   messageText: flattenDiagnosticMessageText(e, e.messageText),
   relFilePath: void 0,
   type: "typescript"
  };
  if (1 === e.category && (r.level = "error"), e.file && "number" == typeof e.start) {
   r.absFilePath = e.file.fileName;
   const s = "string" != typeof (n = e.file.text) ? [] : (n = n.replace(/\\r/g, "\n")).split("\n"), o = e.file.getLineAndCharacterOfPosition(e.start), i = {
    lineIndex: o.line,
    lineNumber: o.line + 1,
    text: s[o.line],
    errorCharStart: o.character,
    errorLength: Math.max(null !== (t = e.length) && void 0 !== t ? t : 0, 1)
   };
   if (r.lineNumber = i.lineNumber, r.columnNumber = i.errorCharStart + 1, r.lines.push(i), 
   0 === i.errorLength && i.errorCharStart > 0 && (i.errorLength = 1, i.errorCharStart--), 
   i.lineIndex > 0) {
    const e = {
     lineIndex: i.lineIndex - 1,
     lineNumber: i.lineNumber - 1,
     text: s[i.lineIndex - 1],
     errorCharStart: -1,
     errorLength: -1
    };
    r.lines.unshift(e);
   }
   if (i.lineIndex + 1 < s.length) {
    const e = {
     lineIndex: i.lineIndex + 1,
     lineNumber: i.lineNumber + 1,
     text: s[i.lineIndex + 1],
     errorCharStart: -1,
     errorLength: -1
    };
    r.lines.push(e);
   }
  }
  var n;
  return r;
 })(r.error)));
 const n = stencil_js.ts.parseJsonConfigFileContent(r.config, stencil_js.ts.sys, e, void 0, t);
 return _tsCompilerOptions = n.options, _tsCompilerOptions;
}

function setScreenshotEmulateData(e, t) {
 const r = {
  userAgent: "default",
  viewport: {
   width: 800,
   height: 600,
   deviceScaleFactor: 1,
   isMobile: !1,
   hasTouch: !1,
   isLandscape: !1
  }
 };
 if ("string" == typeof e.device) try {
  const n = require(t.__STENCIL_PUPPETEER_MODULE__ + "/DeviceDescriptors")[e.device];
  if (!n) return void console.error(`invalid emulate device: ${e.device}`);
  r.device = e.device, r.userAgent = n.userAgent, r.viewport = n.viewport;
 } catch (e) {
  return void console.error("error loading puppeteer DeviceDescriptors", e);
 }
 e.viewport && ("number" == typeof e.viewport.width && (r.viewport.width = e.viewport.width), 
 "number" == typeof e.viewport.height && (r.viewport.height = e.viewport.height), 
 "number" == typeof e.viewport.deviceScaleFactor && (r.viewport.deviceScaleFactor = e.viewport.deviceScaleFactor), 
 "boolean" == typeof e.viewport.hasTouch && (r.viewport.hasTouch = e.viewport.hasTouch), 
 "boolean" == typeof e.viewport.isLandscape && (r.viewport.isLandscape = e.viewport.isLandscape), 
 "boolean" == typeof e.viewport.isMobile && (r.viewport.isMobile = e.viewport.isMobile), 
 "string" == typeof e.userAgent && (r.userAgent = e.userAgent)), t.__STENCIL_EMULATE__ = JSON.stringify(r);
}

async function runJest(e, t) {
 let r = !1;
 try {
  const n = function n(e, t) {
   var r, n;
   let s = null !== (n = null === (r = e.emulate) || void 0 === r ? void 0 : r.slice()) && void 0 !== n ? n : [];
   if ("string" == typeof t.emulate) {
    const e = t.emulate.toLowerCase();
    s = s.filter((t => "string" == typeof t.device && t.device.toLowerCase() === e || !("string" != typeof t.userAgent || !t.userAgent.toLowerCase().includes(e))));
   }
   return s;
  }(e.testing, e.flags);
  t.__STENCIL_EMULATE_CONFIGS__ = JSON.stringify(n), t.__STENCIL_ENV__ = JSON.stringify(e.env), 
  t.__STENCIL_TRANSPILE_PATHS__ = e.transformAliasedImportPaths ? "true" : "false", 
  e.flags.ci || e.flags.e2e ? t.__STENCIL_DEFAULT_TIMEOUT__ = "30000" : t.__STENCIL_DEFAULT_TIMEOUT__ = "15000", 
  e.flags.devtools && (t.__STENCIL_DEFAULT_TIMEOUT__ = "300000000"), e.logger.debug(`default timeout: ${t.__STENCIL_DEFAULT_TIMEOUT__}`);
  const s = function s(e) {
   const t = require("yargs"), r = e.flags.knownArgs.slice();
   r.some((e => e.startsWith("--max-workers") || e.startsWith("--maxWorkers"))) || r.push(`--max-workers=${e.maxConcurrentWorkers}`), 
   e.flags.devtools && r.push("--runInBand");
   const n = [ ...r, ...e.flags.unknownArgs ];
   e.logger.info(e.logger.magenta(`jest args: ${n.join(" ")}`));
   let s = t(n).argv;
   if (s = {
    detectLeaks: !1,
    "detect-leaks": !1,
    detectOpenHandles: !1,
    "detect-open-handles": !1,
    errorOnDeprecated: !1,
    "error-on-deprecated": !1,
    listTests: !1,
    "list-tests": !1,
    maxConcurrency: 5,
    "max-concurrency": 5,
    notifyMode: "failure-change",
    "notify-mode": "failure-change",
    passWithNoTests: !1,
    "pass-with-no-tests": !1,
    runTestsByPath: !1,
    "run-tests-by-path": !1,
    testLocationInResults: !1,
    "test-location-in-results": !1,
    ...s
   }, s.config = function o(e) {
    const t = e.testing, r = require("jest-config").defaults, n = Object.keys(r), s = {};
    return Object.keys(t).forEach((e => {
     n.includes(e) && (s[e] = t[e]);
    })), s.rootDir = e.rootDir, isString(t.collectCoverage) && (s.collectCoverage = t.collectCoverage), 
    Array.isArray(t.collectCoverageFrom) && (s.collectCoverageFrom = t.collectCoverageFrom), 
    isString(t.coverageDirectory) && (s.coverageDirectory = t.coverageDirectory), t.coverageThreshold && (s.coverageThreshold = t.coverageThreshold), 
    isString(t.globalSetup) && (s.globalSetup = t.globalSetup), isString(t.globalTeardown) && (s.globalTeardown = t.globalTeardown), 
    isString(t.preset) && (s.preset = t.preset), t.projects && (s.projects = t.projects), 
    Array.isArray(t.reporters) && (s.reporters = t.reporters), isString(t.testResultsProcessor) && (s.testResultsProcessor = t.testResultsProcessor), 
    t.transform && (s.transform = t.transform), t.verbose && (s.verbose = t.verbose), 
    s.testRunner = "jest-jasmine2", JSON.stringify(s);
   }(e), "string" == typeof s.maxWorkers) try {
    s.maxWorkers = parseInt(s.maxWorkers, 10);
   } catch (e) {}
   return "string" == typeof s.ci && (s.ci = "true" === s.ci || "" === s.ci), s;
  }(e), o = function o(e, t) {
   const r = t.projects ? t.projects : [];
   return r.push(e.rootDir), r;
  }(e, s), {runCLI: i} = require("@jest/core");
  r = !!(await i(s, o)).results.success;
 } catch (t) {
  e.logger.error(`runJest: ${t}`);
 }
 return r;
}

async function globalMockFetch(e) {
 let t;
 if (null == e) throw new Error("missing url input for mock fetch()");
 if ("string" == typeof e) t = e; else {
  if ("string" != typeof e.url) throw new Error("invalid url for mock fetch()");
  t = e.url;
 }
 t = new URL(t, location.href).href;
 let r = mockedResponses.get(t);
 if (null == r) {
  const e = new URL(FETCH_DEFAULT_PATH, location.href);
  r = mockedResponses.get(e.href);
 }
 if (null == r) return new MockResponse404;
 const n = r.response.clone();
 return "number" != typeof n.status && (n.status = 200), "string" != typeof n.statusText && (n.status >= 500 ? n.statusText = "Internal Server Error" : 404 === n.status ? n.statusText = "Not Found" : n.status >= 400 ? n.statusText = "Bad Request" : 302 === n.status ? n.statusText = "Found" : 301 === n.status ? n.statusText = "Moved Permanently" : n.status >= 300 ? n.statusText = "Redirection" : n.statusText = "OK"), 
 n.ok = n.status >= 200 && n.status <= 299, "string" != typeof n.type && (n.type = "basic"), 
 n;
}

function setMockedResponse(e, t, r) {
 if (!e) throw new Error("MockResponse required");
 "string" == typeof e.url && "" !== e.url || ("string" == typeof t ? e.url = t : t && "string" == typeof t.url ? e.url = t.url : e.url = FETCH_DEFAULT_PATH);
 const n = new URL(e.url, location.href);
 e.url = n.href;
 const s = {
  response: e,
  reject: r
 };
 mockedResponses.set(e.url, s);
}

function resetBuildConditionals(e) {
 Object.keys(e).forEach((t => {
  e[t] = !0;
 })), e.isDev = !0, e.isTesting = !0, e.isDebug = !1, e.lazyLoad = !0, e.member = !0, 
 e.reflect = !0, e.scoped = !0, e.shadowDom = !0, e.slotRelocation = !0, e.asyncLoading = !0, 
 e.svg = !0, e.updatable = !0, e.vdomAttribute = !0, e.vdomClass = !0, e.vdomFunctional = !0, 
 e.vdomKey = !0, e.vdomPropOrAttr = !0, e.vdomRef = !0, e.vdomListener = !0, e.vdomStyle = !0, 
 e.vdomText = !0, e.vdomXlink = !0, e.allRenderFn = !1, e.devTools = !1, e.hydrateClientSide = !1, 
 e.hydrateServerSide = !1, e.cssAnnotations = !1, e.style = !1, e.hydratedAttribute = !1, 
 e.hydratedClass = !0, e.invisiblePrehydration = !0, e.appendChildSlotFix = !1, e.cloneNodeFix = !1, 
 e.hotModuleReplacement = !1, e.scriptDataOpts = !1, e.scopedSlotTextContentFix = !1, 
 e.slotChildNodesFix = !1, e.patchPseudoShadowDom = !1;
}

function toHaveClasses(e, t) {
 if (!e) throw new Error("expect toHaveClasses value is null");
 if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
 if (1 !== e.nodeType) throw new Error("expect toHaveClasses value is not an element");
 const r = t.every((t => e.classList.contains(t)));
 return {
  message: () => `expected to ${r ? "not " : ""}have css classes "${t.join(" ")}", but className is "${e.className}"`,
  pass: r
 };
}

function compareHtml(e, t, r) {
 if (null == e) throw new Error(`expect toEqualHtml() value is "${e}"`);
 if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
 let n;
 if (1 === e.nodeType) {
  const t = function s(e) {
   return e && e.ownerDocument && e.ownerDocument.defaultView && e.ownerDocument.defaultView.__stencil_spec_options || {};
  }(e);
  n = index_cjs.serializeNodeToHtml(e, {
   prettyHtml: !0,
   outerHtml: !0,
   removeHtmlComments: !1 === t.includeAnnotations,
   excludeTags: [ "body" ],
   serializeShadowRoot: r
  });
 } else if (11 === e.nodeType) n = index_cjs.serializeNodeToHtml(e, {
  prettyHtml: !0,
  excludeTags: [ "style" ],
  excludeTagContent: [ "style" ],
  serializeShadowRoot: r
 }); else {
  if ("string" != typeof e) throw new Error("expect toEqualHtml() value should be an element, shadow root or string.");
  {
   const t = index_cjs.parseHtmlToFragment(e);
   n = index_cjs.serializeNodeToHtml(t, {
    prettyHtml: !0,
    serializeShadowRoot: r
   });
  }
 }
 const o = index_cjs.parseHtmlToFragment(t), i = index_cjs.serializeNodeToHtml(o, {
  prettyHtml: !0,
  excludeTags: [ "body" ]
 });
 return n !== i ? (expect(n).toBe(i), {
  message: () => "HTML does not match",
  pass: !1
 }) : {
  message: () => "expect HTML to match",
  pass: !0
 };
}

function removeDomNodes(e) {
 var t, r;
 null != e && ((null === (t = e.childNodes) || void 0 === t ? void 0 : t.length) || e.remove(), 
 null === (r = e.childNodes) || void 0 === r || r.forEach(removeDomNodes));
}

function specifierIncluded$1(e, t) {
 var r, n, s, o = e.split("."), i = t.split(" "), a = i.length > 1 ? i[0] : "=", l = (i.length > 1 ? i[1] : i[0]).split(".");
 for (r = 0; r < 3; ++r) if ((n = parseInt(o[r] || 0, 10)) !== (s = parseInt(l[r] || 0, 10))) return "<" === a ? n < s : ">=" === a && n >= s;
 return ">=" === a;
}

function matchesRange$1(e, t) {
 var r, n = t.split(/ ?&& ?/);
 if (0 === n.length) return !1;
 for (r = 0; r < n.length; ++r) if (!specifierIncluded$1(e, n[r])) return !1;
 return !0;
}

function specifierIncluded(e) {
 var t, r, n, s = e.split(" "), o = s.length > 1 ? s[0] : "=", i = (s.length > 1 ? s[1] : s[0]).split(".");
 for (t = 0; t < 3; ++t) if ((r = parseInt(current[t] || 0, 10)) !== (n = parseInt(i[t] || 0, 10))) return "<" === o ? r < n : ">=" === o && r >= n;
 return ">=" === o;
}

function matchesRange(e) {
 var t, r = e.split(/ ?&& ?/);
 if (0 === r.length) return !1;
 for (t = 0; t < r.length; ++t) if (!specifierIncluded(r[t])) return !1;
 return !0;
}

function versionIncluded(e) {
 if ("boolean" == typeof e) return e;
 if (e && "object" == typeof e) {
  for (var t = 0; t < e.length; ++t) if (matchesRange(e[t])) return !0;
  return !1;
 }
 return matchesRange(e);
}

function mockValidatedConfig(e = {}) {
 var t;
 const r = mockConfig(e), n = path__default.default.resolve("/");
 return {
  ...r,
  devServer: {},
  extras: {},
  flags: createConfigFlags(),
  fsNamespace: "testing",
  hydratedFlag: null,
  logLevel: "info",
  logger: mockLogger(),
  namespace: "Testing",
  outputTargets: null !== (t = r.outputTargets) && void 0 !== t ? t : [],
  packageJsonFilePath: path__default.default.join(n, "package.json"),
  rootDir: n,
  cacheDir: ".stencil",
  srcIndexHtml: "src/index.html",
  srcDir: "/src",
  sys: createTestingSystem(),
  testing: {},
  transformAliasedImportPaths: !0,
  rollupConfig: {
   inputOptions: {},
   outputOptions: {}
  },
  validatePrimaryPackageOutputTarget: !1,
  ...e
 };
}

function mockConfig(e = {}) {
 const t = path__default.default.resolve("/");
 let {sys: r} = e;
 return r || (r = createTestingSystem()), r.getCurrentDirectory = () => t, {
  _isTesting: !0,
  buildAppCore: !1,
  buildDist: !0,
  buildEs5: !1,
  bundles: null,
  devMode: !0,
  enableCache: !1,
  extras: {},
  flags: createConfigFlags(),
  globalScript: null,
  hashFileNames: !1,
  logger: new TestingLogger,
  maxConcurrentWorkers: 0,
  minifyCss: !1,
  minifyJs: !1,
  namespace: "Testing",
  nodeResolve: {
   customResolveOptions: {}
  },
  outputTargets: null,
  rollupPlugins: {
   before: [],
   after: []
  },
  rootDir: t,
  sourceMap: !0,
  sys: r,
  testing: null,
  validateTypes: !1,
  ...e
 };
}

function mockCompilerCtx(e) {
 const t = e || mockValidatedConfig(), r = {
  version: 1,
  activeBuildId: 0,
  activeDirsAdded: [],
  activeDirsDeleted: [],
  activeFilesAdded: [],
  activeFilesDeleted: [],
  activeFilesUpdated: [],
  addWatchDir: noop,
  addWatchFile: noop,
  cachedGlobalStyle: null,
  changedFiles: new Set,
  changedModules: new Set,
  collections: [],
  compilerOptions: null,
  cache: null,
  cssModuleImports: new Map,
  events: buildEvents(),
  fs: null,
  hasSuccessfulBuild: !1,
  isActivelyBuilding: !1,
  lastBuildResults: null,
  moduleMap: new Map,
  nodeMap: new WeakMap,
  reset: noop,
  resolvedCollections: new Set,
  rollupCache: new Map,
  rollupCacheHydrate: null,
  rollupCacheLazy: null,
  rollupCacheNative: null,
  styleModeNames: new Set,
  worker: stencil_js.createWorkerContext(t.sys)
 };
 return Object.defineProperty(r, "fs", {
  get() {
   return null == this._fs && (this._fs = createInMemoryFs(t.sys)), this._fs;
  }
 }), Object.defineProperty(r, "cache", {
  get() {
   return null == this._cache && (this._cache = function e(t, r) {
    t.enableCache = !0;
    const n = new Cache(t, r.fs);
    return n.initCacheDir(), n;
   }(t, r)), this._cache;
  }
 }), r;
}

function mockLogger() {
 return new TestingLogger;
}

async function initPageEvents(e) {
 e._e2eEvents = new Map, e._e2eEventIds = 0, e.spyOnEvent = pageSpyOnEvent.bind(e, e), 
 await e.exposeFunction("stencilOnEvent", ((t, r) => {
  !function n(e, t, r) {
   const n = e.get(t);
   n && n.callback(r);
  }(e._e2eEvents, t, r);
 })), await e.evaluateOnNewDocument(browserContextEvents);
}

async function pageSpyOnEvent(e, t, r) {
 const n = new EventSpy(t), s = "document" !== r ? () => window : () => document, o = await e.evaluateHandle(s);
 return await addE2EListener(e, o, t, (e => {
  n.push(e);
 })), n;
}

async function waitForEvent(e, t, r) {
 const n = .5 * jasmine.DEFAULT_TIMEOUT_INTERVAL, s = await e.evaluate(((e, t, r) => new Promise(((n, s) => {
  const o = setTimeout((() => {
   s(new Error(`waitForEvent() timeout, eventName: ${t}`));
  }), r);
  e.addEventListener(t, (e => {
   clearTimeout(o), n(window.stencilSerializeEvent(e));
  }), {
   once: !0
  });
 }))), r, t, n);
 return await e.waitForChanges(), s;
}

async function addE2EListener(e, t, r, n) {
 const s = e._e2eEventIds++;
 e._e2eEvents.set(s, {
  eventName: r,
  callback: n
 }), await t.evaluate(((e, t, r) => {
  e.addEventListener(r, (e => {
   window.stencilOnEvent(t, window.stencilSerializeEvent(e));
  }));
 }), s, r);
}

function browserContextEvents() {
 const e = () => {
  const e = [], t = (e, r) => {
   if (null != r && 1 === r.nodeType) for (let n = 0; n < r.children.length; n++) {
    const s = r.children[n];
    s.tagName.includes("-") && "function" == typeof s.componentOnReady && e.push(s.componentOnReady()), 
    t(e, s);
   }
  };
  return t(e, window.document.documentElement), Promise.all(e).catch((e => console.error(e)));
 }, t = () => e().then((() => new Promise((e => {
  requestAnimationFrame(e);
 })))).then((() => e())).then((() => {
  window.stencilAppLoaded = !0;
 }));
 window.stencilSerializeEventTarget = e => e ? e === window ? {
  serializedWindow: !0
 } : e === document ? {
  serializedDocument: !0
 } : null != e.nodeType ? {
  serializedElement: !0,
  nodeName: e.nodeName,
  nodeValue: e.nodeValue,
  nodeType: e.nodeType,
  tagName: e.tagName,
  className: e.className,
  id: e.id
 } : null : null, window.stencilSerializeEvent = e => ({
  bubbles: e.bubbles,
  cancelBubble: e.cancelBubble,
  cancelable: e.cancelable,
  composed: e.composed,
  currentTarget: window.stencilSerializeEventTarget(e.currentTarget),
  defaultPrevented: e.defaultPrevented,
  detail: e.detail,
  eventPhase: e.eventPhase,
  isTrusted: e.isTrusted,
  returnValue: e.returnValue,
  srcElement: window.stencilSerializeEventTarget(e.srcElement),
  target: window.stencilSerializeEventTarget(e.target),
  timeStamp: e.timeStamp,
  type: e.type,
  isSerializedEvent: !0
 }), "complete" === window.document.readyState ? t() : document.addEventListener("readystatechange", (function(e) {
  "complete" == e.target.readyState && t();
 }));
}

async function find(e, t, r) {
 const {lightSelector: n, shadowSelector: s, text: o, contains: i} = getSelector(r);
 let a;
 if (a = "string" == typeof n ? await async function l(e, t, r, n) {
  let s = await t.$(r);
  if (!s) return null;
  if (n) {
   const t = await e.evaluateHandle(((e, t) => {
    if (!e.shadowRoot) throw new Error(`shadow root does not exist for element: ${e.tagName.toLowerCase()}`);
    return e.shadowRoot.querySelector(t);
   }), s, n);
   if (await s.dispose(), !t) return null;
   s = t.asElement();
  }
  return s;
 }(e, t, n, s) : await async function c(e, t, r, n) {
  const s = await e.evaluateHandle(((e, t, r) => {
   let n = null;
   return function e(s) {
    if (s && !n) if (3 === s.nodeType) {
     if ("string" == typeof t && s.textContent.trim() === t) return void (n = s.parentElement);
     if ("string" == typeof r && s.textContent.includes(r)) return void (n = s.parentElement);
    } else {
     if ("SCRIPT" === s.nodeName || "STYLE" === s.nodeName) return;
     if (e(s.shadowRoot), s.childNodes) for (let t = 0; t < s.childNodes.length; t++) e(s.childNodes[t]);
    }
   }(e), n;
  }), t, r, n);
  return s ? s.asElement() : null;
 }(e, t, o, i), !a) return null;
 const u = new E2EElement(e, a);
 return await u.e2eSync(), u;
}

async function findAll(e, t, r) {
 const n = [], {lightSelector: s, shadowSelector: o} = getSelector(r), i = await t.$$(s);
 if (0 === i.length) return n;
 if (o) for (let t = 0; t < i.length; t++) {
  const r = getPuppeteerExecution(i[t]), s = await r.evaluateHandle(((e, t) => {
   if (!e.shadowRoot) throw new Error(`shadow root does not exist for element: ${e.tagName.toLowerCase()}`);
   return e.shadowRoot.querySelectorAll(t);
  }), i[t], o);
  await i[t].dispose();
  const a = await s.getProperties();
  await s.dispose();
  for (const t of a.values()) {
   const r = t.asElement();
   if (r) {
    const t = new E2EElement(e, r);
    await t.e2eSync(), n.push(t);
   }
  }
 } else for (let t = 0; t < i.length; t++) {
  const r = new E2EElement(e, i[t]);
  await r.e2eSync(), n.push(r);
 }
 return n;
}

function getSelector(e) {
 const t = {
  lightSelector: null,
  shadowSelector: null,
  text: null,
  contains: null
 };
 if ("string" == typeof e) {
  const r = e.split(">>>");
  t.lightSelector = r[0].trim(), t.shadowSelector = r.length > 1 ? r[1].trim() : null;
 } else if ("string" == typeof e.text) t.text = e.text.trim(); else {
  if ("string" != typeof e.contains) throw new Error(`invalid find selector: ${e}`);
  t.contains = e.contains.trim();
 }
 return t;
}

function getPuppeteerExecution(e) {
 return parseInt(process.env.__STENCIL_PUPPETEER_VERSION__, 10) >= 17 ? e.frame : e.executionContext();
}

async function writeScreenshotData(e, t) {
 const r = function n(e, t) {
  const r = `${t}.json`;
  return path__default.default.join(e, r);
 }(e, t.id), s = JSON.stringify(t, null, 2);
 await writeFile(r, s);
}

function writeFile(e, t) {
 return new Promise(((r, n) => {
  fs__default.default.writeFile(e, t, (e => {
   e ? n(e) : r();
  }));
 }));
}

async function compareScreenshot(e, t, r, n, s, o, i, a) {
 var l, c, u, d, p, h, f, m;
 const g = `${require$$3.createHash("md5").update(r).digest("hex")}.png`, y = path$2.join(t.imagesDir, g);
 await async function w(e, t) {
  const r = await function n(e) {
   return new Promise((t => {
    fs__default.default.access(e, (e => t(!e)));
   }));
  }(e);
  r || await writeFile(e, t);
 }(y, r), r = null, i && (i = normalizePath(path$2.relative(t.rootDir, i)));
 const _ = function E(e, t) {
  if ("string" != typeof t || 0 === t.trim().length) throw new Error("invalid test description");
  const r = require$$3.createHash("md5");
  return r.update(t + ":"), r.update(e.userAgent + ":"), void 0 !== e.viewport && (r.update(e.viewport.width + ":"), 
  r.update(e.viewport.height + ":"), r.update(e.viewport.deviceScaleFactor + ":"), 
  r.update(e.viewport.hasTouch + ":"), r.update(e.viewport.isMobile + ":")), r.digest("hex").slice(0, 8).toLowerCase();
 }(e, n), v = {
  id: _,
  image: g,
  device: e.device,
  userAgent: e.userAgent,
  desc: n,
  testPath: i,
  width: s,
  height: o,
  deviceScaleFactor: null === (l = e.viewport) || void 0 === l ? void 0 : l.deviceScaleFactor,
  hasTouch: null === (c = e.viewport) || void 0 === c ? void 0 : c.hasTouch,
  isLandscape: null === (u = e.viewport) || void 0 === u ? void 0 : u.isLandscape,
  isMobile: null === (d = e.viewport) || void 0 === d ? void 0 : d.isMobile,
  diff: {
   id: _,
   desc: n,
   imageA: g,
   imageB: g,
   mismatchedPixels: 0,
   device: e.device,
   userAgent: e.userAgent,
   width: s,
   height: o,
   deviceScaleFactor: null === (p = e.viewport) || void 0 === p ? void 0 : p.deviceScaleFactor,
   hasTouch: null === (h = e.viewport) || void 0 === h ? void 0 : h.hasTouch,
   isLandscape: null === (f = e.viewport) || void 0 === f ? void 0 : f.isLandscape,
   isMobile: null === (m = e.viewport) || void 0 === m ? void 0 : m.isMobile,
   allowableMismatchedPixels: t.allowableMismatchedPixels,
   allowableMismatchedRatio: t.allowableMismatchedRatio,
   testPath: i,
   cacheKey: void 0
  }
 };
 if (t.updateMaster) return await writeScreenshotData(t.currentBuildDir, v), v.diff;
 const b = t.masterScreenshots[v.id];
 if (!b) return await writeScreenshotData(t.currentBuildDir, v), v.diff;
 if (v.diff.imageA = b, v.diff.imageA !== v.diff.imageB) {
  v.diff.cacheKey = function T(e, t, r) {
   const n = require$$3.createHash("md5");
   return n.update(`${e}:${t}:${r}`), n.digest("hex").slice(0, 10);
  }(v.diff.imageA, v.diff.imageB, a);
  const r = t.cache[v.diff.cacheKey];
  if ("number" != typeof r || isNaN(r)) {
   const r = Math.round(e.viewport.width * e.viewport.deviceScaleFactor), n = Math.round(e.viewport.height * e.viewport.deviceScaleFactor), s = {
    imageAPath: path$2.join(t.imagesDir, v.diff.imageA),
    imageBPath: path$2.join(t.imagesDir, v.diff.imageB),
    width: r,
    height: n,
    pixelmatchThreshold: a
   };
   v.diff.mismatchedPixels = await async function S(e, t) {
    return new Promise(((r, n) => {
     const s = .5 * jasmine.DEFAULT_TIMEOUT_INTERVAL, o = setTimeout((() => {
      n(`getMismatchedPixels timeout: ${s}ms`);
     }), s);
     try {
      const s = {
       execArgv: process.execArgv.filter((e => !/^--(debug|inspect)/.test(e))),
       env: process.env,
       cwd: process.cwd(),
       stdio: [ "pipe", "pipe", "pipe", "ipc" ]
      }, i = cp.fork(e, [], s);
      i.on("message", (e => {
       i.kill(), clearTimeout(o), r(e);
      })), i.on("error", (e => {
       clearTimeout(o), n(e);
      })), i.send(t);
     } catch (e) {
      clearTimeout(o), n(`getMismatchedPixels error: ${e}`);
     }
    }));
   }(t.pixelmatchModulePath, s);
  } else v.diff.mismatchedPixels = r;
 }
 return await writeScreenshotData(t.currentBuildDir, v), v.diff;
}

async function e2eGoTo(e, t, r = {}) {
 if (e.isClosed()) throw new Error("e2eGoTo unavailable: page already closed");
 if ("string" != typeof t) throw new Error("invalid gotoTest() url");
 if (!t.startsWith("/")) throw new Error("gotoTest() url must start with /");
 const n = env.__STENCIL_BROWSER_URL__;
 if ("string" != typeof n) throw new Error("invalid gotoTest() browser url");
 const s = n + t.substring(1);
 r.waitUntil || (r.waitUntil = env.__STENCIL_BROWSER_WAIT_UNTIL);
 const o = await e._e2eGoto(s, r);
 if (!o.ok()) throw new Error(`Testing unable to load ${t}, HTTP status: ${o.status()}`);
 return await waitForStencil(e, r), o;
}

async function e2eSetContent(e, t, r = {}) {
 if (e.isClosed()) throw new Error("e2eSetContent unavailable: page already closed");
 if ("string" != typeof t) throw new Error("invalid e2eSetContent() html");
 const n = [], s = env.__STENCIL_APP_SCRIPT_URL__;
 if ("string" != typeof s) throw new Error("invalid e2eSetContent() app script url");
 n.push("<!doctype html>"), n.push("<html>"), n.push("<head>");
 const o = env.__STENCIL_APP_STYLE_URL__;
 "string" == typeof o && n.push(`<link rel="stylesheet" href="${o}">`), n.push(`<script type="module" src="${s}"><\/script>`), 
 n.push("</head>"), n.push("<body>"), n.push(t), n.push("</body>"), n.push("</html>");
 const i = env.__STENCIL_BROWSER_URL__;
 if (await e.setRequestInterception(!0), e.on("request", (e => {
  i === e.url() ? e.respond({
   status: 200,
   contentType: "text/html",
   body: n.join("\n")
  }) : e.continue();
 })), r.waitUntil || (r.waitUntil = env.__STENCIL_BROWSER_WAIT_UNTIL), !(await e._e2eGoto(i, r)).ok()) throw new Error("Testing unable to load content");
 await waitForStencil(e, r);
}

async function waitForStencil(e, t) {
 try {
  const r = "number" == typeof t.timeout ? t.timeout : 4750;
  await e.waitForFunction("window.stencilAppLoaded", {
   timeout: r
  });
 } catch (e) {
  throw new Error("App did not load in allowed time. Please ensure the content loads a stencil application.");
 }
}

async function waitForChanges(e) {
 try {
  if (e.isClosed()) return;
  if (await Promise.all(e._e2eElements.map((e => e.e2eRunActions()))), e.isClosed()) return;
  if (await e.evaluate((() => new Promise((e => {
   requestAnimationFrame((() => {
    const t = [], r = (e, t) => {
     if (null != e) {
      "shadowRoot" in e && e.shadowRoot instanceof ShadowRoot && r(e.shadowRoot, t);
      const n = e.children, s = n.length;
      for (let e = 0; e < s; e++) {
       const s = n[e];
       null != s && (s.tagName.includes("-") && "function" == typeof s.componentOnReady && t.push(s.componentOnReady()), 
       r(s, t));
      }
     }
    };
    r(document.documentElement, t), Promise.all(t).then((() => {
     e();
    })).catch((() => {
     e();
    }));
   }));
  })))), e.isClosed()) return;
  "function" == typeof e.waitForTimeout ? await e.waitForTimeout(100) : await e.waitFor(100), 
  await Promise.all(e._e2eElements.map((e => e.e2eSync())));
 } catch (e) {}
}

function serializeConsoleMessage(e) {
 return `${e.text()} ${function t(e) {
  let t = "";
  return e && e.url && (t = `\nLocation: ${e.url}`, e.lineNumber && (t += `:${e.lineNumber}`), 
  e.columnNumber && (t += `:${e.columnNumber}`)), t;
 }(e.location())}`;
}

function findRootComponent(e, t) {
 if (null != t) {
  const r = t.children, n = r.length;
  for (let t = 0; t < n; t++) {
   const n = r[t];
   if (e.has(n.nodeName.toLowerCase())) return n;
  }
  for (let t = 0; t < n; t++) {
   const n = findRootComponent(e, r[t]);
   if (null != n) return n;
  }
 }
 return null;
}

function createBuildId() {
 const e = new Date;
 let t = e.getFullYear() + "";
 return t += ("0" + (e.getMonth() + 1)).slice(-2), t += ("0" + e.getDate()).slice(-2), 
 t += ("0" + e.getHours()).slice(-2), t += ("0" + e.getMinutes()).slice(-2), t += ("0" + e.getSeconds()).slice(-2), 
 t;
}

function createBuildMessage() {
 const e = new Date;
 let t = e.getFullYear() + "-";
 return t += ("0" + (e.getMonth() + 1)).slice(-2) + "-", t += ("0" + e.getDate()).slice(-2) + " ", 
 t += ("0" + e.getHours()).slice(-2) + ":", t += ("0" + e.getMinutes()).slice(-2) + ":", 
 t += ("0" + e.getSeconds()).slice(-2), `Build: ${t}`;
}

function getAppUrl(e, t, r) {
 const n = e.outputTargets.find(isOutputTargetWww);
 if (n) {
  const e = n.buildDir, s = path$2.join(e, r), o = path$2.relative(n.dir, s);
  return new URL(o, t).href;
 }
 const s = e.outputTargets.find(isOutputTargetDistLazy);
 if (s) {
  const n = s.esmDir, o = path$2.join(n, r), i = path$2.relative(e.rootDir, o);
  return new URL(i, t).href;
 }
 return t;
}

var debug_1, constants$2, commonjsGlobal, re_1, parseOptions_1, identifiers, semver, major_1, origCwd, cwd, platform, chdir, polyfills, Stream, legacyStreams, clone_1, getPrototypeOf, gracefulFs, symbols, ansiColors, create_1, caller, pathParse, parse, getNodeModulesDirs, nodeModulesPaths, normalizeOptions, slice, toStr, implementation, functionBind, src, isCoreModule, realpathFS$1, defaultIsFile$1, defaultIsDir$1, defaultRealpath, maybeRealpath, defaultReadPackage, getPackageCandidates$1, async, current, core, mod, core_1, isCore, realpathFS, defaultIsFile, defaultIsDir, defaultRealpathSync, maybeRealpathSync, defaultReadPackageSync, getPackageCandidates, sync, resolve;

const stencil_js = require("../compiler/stencil.js"), appData = _lazyRequire("@stencil/core/internal/app-data"), testing = _lazyRequire("@stencil/core/internal/testing"), index_cjs = _lazyRequire("../mock-doc/index.cjs"), path$2 = require("path"), require$$3 = require("crypto"), os$2 = require("os"), process$3 = require("process"), fs$2 = require("fs"), constants$3 = require("constants"), require$$0 = require("stream"), util$2 = require("util"), assert$2 = require("assert"), index_js = _lazyRequire("../dev-server/index.js"), cp = require("child_process"), path__default = _interopDefaultLegacy(path$2), os__namespace = _interopNamespace(os$2), process__namespace = _interopNamespace(process$3), fs__default = _interopDefaultLegacy(fs$2), constants__default = _interopDefaultLegacy(constants$3), require$$0__default = _interopDefaultLegacy(require$$0), util__default = _interopDefaultLegacy(util$2), assert__default = _interopDefaultLegacy(assert$2), debug = ("object" == typeof process && process.env, 
() => {});

debug_1 = debug;

const MAX_SAFE_INTEGER$1 = Number.MAX_SAFE_INTEGER || 9007199254740991;

constants$2 = {
 MAX_LENGTH: 256,
 MAX_SAFE_COMPONENT_LENGTH: 16,
 MAX_SAFE_BUILD_LENGTH: 250,
 MAX_SAFE_INTEGER: MAX_SAFE_INTEGER$1,
 RELEASE_TYPES: [ "major", "premajor", "minor", "preminor", "patch", "prepatch", "prerelease" ],
 SEMVER_SPEC_VERSION: "2.0.0",
 FLAG_INCLUDE_PRERELEASE: 1,
 FLAG_LOOSE: 2
}, commonjsGlobal = "undefined" != typeof globalThis ? globalThis : "undefined" != typeof window ? window : "undefined" != typeof global ? global : "undefined" != typeof self ? self : {}, 
re_1 = createCommonjsModule((function(e, t) {
 const {MAX_SAFE_COMPONENT_LENGTH: r, MAX_SAFE_BUILD_LENGTH: n, MAX_LENGTH: s} = constants$2, o = (t = e.exports = {}).re = [], i = t.safeRe = [], a = t.src = [], l = t.t = {};
 let c = 0;
 const u = "[a-zA-Z0-9-]", d = [ [ "\\s", 1 ], [ "\\d", s ], [ u, n ] ], p = (e, t, r) => {
  const n = (e => {
   for (const [t, r] of d) e = e.split(`${t}*`).join(`${t}{0,${r}}`).split(`${t}+`).join(`${t}{1,${r}}`);
   return e;
  })(t), s = c++;
  debug_1(e, s, t), l[e] = s, a[s] = t, o[s] = new RegExp(t, r ? "g" : void 0), i[s] = new RegExp(n, r ? "g" : void 0);
 };
 p("NUMERICIDENTIFIER", "0|[1-9]\\d*"), p("NUMERICIDENTIFIERLOOSE", "\\d+"), p("NONNUMERICIDENTIFIER", `\\d*[a-zA-Z-]${u}*`), 
 p("MAINVERSION", `(${a[l.NUMERICIDENTIFIER]})\\.(${a[l.NUMERICIDENTIFIER]})\\.(${a[l.NUMERICIDENTIFIER]})`), 
 p("MAINVERSIONLOOSE", `(${a[l.NUMERICIDENTIFIERLOOSE]})\\.(${a[l.NUMERICIDENTIFIERLOOSE]})\\.(${a[l.NUMERICIDENTIFIERLOOSE]})`), 
 p("PRERELEASEIDENTIFIER", `(?:${a[l.NUMERICIDENTIFIER]}|${a[l.NONNUMERICIDENTIFIER]})`), 
 p("PRERELEASEIDENTIFIERLOOSE", `(?:${a[l.NUMERICIDENTIFIERLOOSE]}|${a[l.NONNUMERICIDENTIFIER]})`), 
 p("PRERELEASE", `(?:-(${a[l.PRERELEASEIDENTIFIER]}(?:\\.${a[l.PRERELEASEIDENTIFIER]})*))`), 
 p("PRERELEASELOOSE", `(?:-?(${a[l.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${a[l.PRERELEASEIDENTIFIERLOOSE]})*))`), 
 p("BUILDIDENTIFIER", `${u}+`), p("BUILD", `(?:\\+(${a[l.BUILDIDENTIFIER]}(?:\\.${a[l.BUILDIDENTIFIER]})*))`), 
 p("FULLPLAIN", `v?${a[l.MAINVERSION]}${a[l.PRERELEASE]}?${a[l.BUILD]}?`), p("FULL", `^${a[l.FULLPLAIN]}$`), 
 p("LOOSEPLAIN", `[v=\\s]*${a[l.MAINVERSIONLOOSE]}${a[l.PRERELEASELOOSE]}?${a[l.BUILD]}?`), 
 p("LOOSE", `^${a[l.LOOSEPLAIN]}$`), p("GTLT", "((?:<|>)?=?)"), p("XRANGEIDENTIFIERLOOSE", `${a[l.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`), 
 p("XRANGEIDENTIFIER", `${a[l.NUMERICIDENTIFIER]}|x|X|\\*`), p("XRANGEPLAIN", `[v=\\s]*(${a[l.XRANGEIDENTIFIER]})(?:\\.(${a[l.XRANGEIDENTIFIER]})(?:\\.(${a[l.XRANGEIDENTIFIER]})(?:${a[l.PRERELEASE]})?${a[l.BUILD]}?)?)?`), 
 p("XRANGEPLAINLOOSE", `[v=\\s]*(${a[l.XRANGEIDENTIFIERLOOSE]})(?:\\.(${a[l.XRANGEIDENTIFIERLOOSE]})(?:\\.(${a[l.XRANGEIDENTIFIERLOOSE]})(?:${a[l.PRERELEASELOOSE]})?${a[l.BUILD]}?)?)?`), 
 p("XRANGE", `^${a[l.GTLT]}\\s*${a[l.XRANGEPLAIN]}$`), p("XRANGELOOSE", `^${a[l.GTLT]}\\s*${a[l.XRANGEPLAINLOOSE]}$`), 
 p("COERCE", `(^|[^\\d])(\\d{1,${r}})(?:\\.(\\d{1,${r}}))?(?:\\.(\\d{1,${r}}))?(?:$|[^\\d])`), 
 p("COERCERTL", a[l.COERCE], !0), p("LONETILDE", "(?:~>?)"), p("TILDETRIM", `(\\s*)${a[l.LONETILDE]}\\s+`, !0), 
 t.tildeTrimReplace = "$1~", p("TILDE", `^${a[l.LONETILDE]}${a[l.XRANGEPLAIN]}$`), 
 p("TILDELOOSE", `^${a[l.LONETILDE]}${a[l.XRANGEPLAINLOOSE]}$`), p("LONECARET", "(?:\\^)"), 
 p("CARETTRIM", `(\\s*)${a[l.LONECARET]}\\s+`, !0), t.caretTrimReplace = "$1^", p("CARET", `^${a[l.LONECARET]}${a[l.XRANGEPLAIN]}$`), 
 p("CARETLOOSE", `^${a[l.LONECARET]}${a[l.XRANGEPLAINLOOSE]}$`), p("COMPARATORLOOSE", `^${a[l.GTLT]}\\s*(${a[l.LOOSEPLAIN]})$|^$`), 
 p("COMPARATOR", `^${a[l.GTLT]}\\s*(${a[l.FULLPLAIN]})$|^$`), p("COMPARATORTRIM", `(\\s*)${a[l.GTLT]}\\s*(${a[l.LOOSEPLAIN]}|${a[l.XRANGEPLAIN]})`, !0), 
 t.comparatorTrimReplace = "$1$2$3", p("HYPHENRANGE", `^\\s*(${a[l.XRANGEPLAIN]})\\s+-\\s+(${a[l.XRANGEPLAIN]})\\s*$`), 
 p("HYPHENRANGELOOSE", `^\\s*(${a[l.XRANGEPLAINLOOSE]})\\s+-\\s+(${a[l.XRANGEPLAINLOOSE]})\\s*$`), 
 p("STAR", "(<|>)?=?\\s*\\*"), p("GTE0", "^\\s*>=\\s*0\\.0\\.0\\s*$"), p("GTE0PRE", "^\\s*>=\\s*0\\.0\\.0-0\\s*$");
}));

const looseOption = Object.freeze({
 loose: !0
}), emptyOpts = Object.freeze({});

parseOptions_1 = e => e ? "object" != typeof e ? looseOption : e : emptyOpts;

const numeric = /^[0-9]+$/, compareIdentifiers$1 = (e, t) => {
 const r = numeric.test(e), n = numeric.test(t);
 return r && n && (e = +e, t = +t), e === t ? 0 : r && !n ? -1 : n && !r ? 1 : e < t ? -1 : 1;
};

identifiers = {
 compareIdentifiers: compareIdentifiers$1,
 rcompareIdentifiers: (e, t) => compareIdentifiers$1(t, e)
};

const {MAX_LENGTH, MAX_SAFE_INTEGER} = constants$2, {safeRe: re, t} = re_1, {compareIdentifiers} = identifiers;

class SemVer {
 constructor(e, r) {
  if (r = parseOptions_1(r), e instanceof SemVer) {
   if (e.loose === !!r.loose && e.includePrerelease === !!r.includePrerelease) return e;
   e = e.version;
  } else if ("string" != typeof e) throw new TypeError(`Invalid version. Must be a string. Got type "${typeof e}".`);
  if (e.length > MAX_LENGTH) throw new TypeError(`version is longer than ${MAX_LENGTH} characters`);
  debug_1("SemVer", e, r), this.options = r, this.loose = !!r.loose, this.includePrerelease = !!r.includePrerelease;
  const n = e.trim().match(r.loose ? re[t.LOOSE] : re[t.FULL]);
  if (!n) throw new TypeError(`Invalid Version: ${e}`);
  if (this.raw = e, this.major = +n[1], this.minor = +n[2], this.patch = +n[3], this.major > MAX_SAFE_INTEGER || this.major < 0) throw new TypeError("Invalid major version");
  if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) throw new TypeError("Invalid minor version");
  if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) throw new TypeError("Invalid patch version");
  n[4] ? this.prerelease = n[4].split(".").map((e => {
   if (/^[0-9]+$/.test(e)) {
    const t = +e;
    if (t >= 0 && t < MAX_SAFE_INTEGER) return t;
   }
   return e;
  })) : this.prerelease = [], this.build = n[5] ? n[5].split(".") : [], this.format();
 }
 format() {
  return this.version = `${this.major}.${this.minor}.${this.patch}`, this.prerelease.length && (this.version += `-${this.prerelease.join(".")}`), 
  this.version;
 }
 toString() {
  return this.version;
 }
 compare(e) {
  if (debug_1("SemVer.compare", this.version, this.options, e), !(e instanceof SemVer)) {
   if ("string" == typeof e && e === this.version) return 0;
   e = new SemVer(e, this.options);
  }
  return e.version === this.version ? 0 : this.compareMain(e) || this.comparePre(e);
 }
 compareMain(e) {
  return e instanceof SemVer || (e = new SemVer(e, this.options)), compareIdentifiers(this.major, e.major) || compareIdentifiers(this.minor, e.minor) || compareIdentifiers(this.patch, e.patch);
 }
 comparePre(e) {
  if (e instanceof SemVer || (e = new SemVer(e, this.options)), this.prerelease.length && !e.prerelease.length) return -1;
  if (!this.prerelease.length && e.prerelease.length) return 1;
  if (!this.prerelease.length && !e.prerelease.length) return 0;
  let t = 0;
  do {
   const r = this.prerelease[t], n = e.prerelease[t];
   if (debug_1("prerelease compare", t, r, n), void 0 === r && void 0 === n) return 0;
   if (void 0 === n) return 1;
   if (void 0 === r) return -1;
   if (r !== n) return compareIdentifiers(r, n);
  } while (++t);
 }
 compareBuild(e) {
  e instanceof SemVer || (e = new SemVer(e, this.options));
  let t = 0;
  do {
   const r = this.build[t], n = e.build[t];
   if (debug_1("prerelease compare", t, r, n), void 0 === r && void 0 === n) return 0;
   if (void 0 === n) return 1;
   if (void 0 === r) return -1;
   if (r !== n) return compareIdentifiers(r, n);
  } while (++t);
 }
 inc(e, t, r) {
  switch (e) {
  case "premajor":
   this.prerelease.length = 0, this.patch = 0, this.minor = 0, this.major++, this.inc("pre", t, r);
   break;

  case "preminor":
   this.prerelease.length = 0, this.patch = 0, this.minor++, this.inc("pre", t, r);
   break;

  case "prepatch":
   this.prerelease.length = 0, this.inc("patch", t, r), this.inc("pre", t, r);
   break;

  case "prerelease":
   0 === this.prerelease.length && this.inc("patch", t, r), this.inc("pre", t, r);
   break;

  case "major":
   0 === this.minor && 0 === this.patch && 0 !== this.prerelease.length || this.major++, 
   this.minor = 0, this.patch = 0, this.prerelease = [];
   break;

  case "minor":
   0 === this.patch && 0 !== this.prerelease.length || this.minor++, this.patch = 0, 
   this.prerelease = [];
   break;

  case "patch":
   0 === this.prerelease.length && this.patch++, this.prerelease = [];
   break;

  case "pre":
   {
    const e = Number(r) ? 1 : 0;
    if (!t && !1 === r) throw new Error("invalid increment argument: identifier is empty");
    if (0 === this.prerelease.length) this.prerelease = [ e ]; else {
     let n = this.prerelease.length;
     for (;--n >= 0; ) "number" == typeof this.prerelease[n] && (this.prerelease[n]++, 
     n = -2);
     if (-1 === n) {
      if (t === this.prerelease.join(".") && !1 === r) throw new Error("invalid increment argument: identifier already exists");
      this.prerelease.push(e);
     }
    }
    if (t) {
     let n = [ t, e ];
     !1 === r && (n = [ t ]), 0 === compareIdentifiers(this.prerelease[0], t) ? isNaN(this.prerelease[1]) && (this.prerelease = n) : this.prerelease = n;
    }
    break;
   }

  default:
   throw new Error(`invalid increment argument: ${e}`);
  }
  return this.raw = this.format(), this.build.length && (this.raw += `+${this.build.join(".")}`), 
  this;
 }
}

semver = SemVer, major_1 = (e, t) => new semver(e, t).major;

const formatComponentRuntimeWatchers = e => {
 const t = {};
 return e.watchers.forEach((({propName: e, methodName: r}) => {
  var n;
  t[e] = [ ...null !== (n = t[e]) && void 0 !== n ? n : [], r ];
 })), t;
}, formatComponentRuntimeMembers = (e, t = !0) => ({
 ...formatPropertiesRuntimeMember(e.properties),
 ...formatStatesRuntimeMember(e.states),
 ...t ? formatMethodsRuntimeMember(e.methods) : {}
}), formatPropertiesRuntimeMember = e => {
 const t = {};
 return e.forEach((e => {
  t[e.name] = trimFalsy([ formatFlags(e), formatAttrName(e) ]);
 })), t;
}, formatFlags = e => {
 let t = formatPropType(e.type);
 return e.mutable && (t |= 1024), e.reflect && (t |= 512), t;
}, formatAttrName = e => {
 if ("string" == typeof e.attribute) {
  if (e.name === e.attribute) return;
  return e.attribute;
 }
}, formatPropType = e => "string" === e ? 1 : "number" === e ? 2 : "boolean" === e ? 4 : "any" === e ? 8 : 16, formatStatesRuntimeMember = e => {
 const t = {};
 return e.forEach((e => {
  t[e.name] = [ 32 ];
 })), t;
}, formatMethodsRuntimeMember = e => {
 const t = {};
 return e.forEach((e => {
  t[e.name] = [ 64 ];
 })), t;
}, formatHostListeners = e => e.listeners.map((e => [ computeListenerFlags(e), e.name, e.method ])), computeListenerFlags = e => {
 let t = 0;
 switch (e.capture && (t |= 2), e.passive && (t |= 1), e.target) {
 case "document":
  t |= 4;
  break;

 case "window":
  t |= 8;
  break;

 case "body":
  t |= 16;
  break;

 case "parent":
  t |= 32;
 }
 return t;
}, trimFalsy = e => {
 const t = e;
 for (let e = t.length - 1; e >= 0 && !t[e]; e--) t.pop();
 return t;
}, noop = () => {}, isString = e => "string" == typeof e, isIterable = e => (e => null != e)(e) && (e => "function" == typeof e)(e[Symbol.iterator]), windowsPathRegex = /^(?:[a-zA-Z]:|[\\/]{2}[^\\/]+[\\/]+[^\\/]+)?[\\/]$/, hasError = e => null != e && 0 !== e.length && e.some((e => "error" === e.level && "runtime" !== e.type)), normalizePath = (e, t = !0) => {
 if ("string" != typeof e) throw new Error("invalid path to normalize");
 e = normalizeSlashes(e.trim());
 const r = pathComponents(e, getRootLength(e)), n = reducePathComponents(r), s = n[0], o = n[1], i = s + n.slice(1).join("/");
 return "" === i ? "." : "" === s && o && e.includes("/") && !o.startsWith(".") && !o.startsWith("@") && t ? "./" + i : i;
}, normalizeSlashes = e => e.replace(backslashRegExp, "/"), backslashRegExp = /\\/g, reducePathComponents = e => {
 if (!Array.isArray(e) || 0 === e.length) return [];
 const t = [ e[0] ];
 for (let r = 1; r < e.length; r++) {
  const n = e[r];
  if (n && "." !== n) {
   if (".." === n) if (t.length > 1) {
    if (".." !== t[t.length - 1]) {
     t.pop();
     continue;
    }
   } else if (t[0]) continue;
   t.push(n);
  }
 }
 return t;
}, getRootLength = e => {
 const t = getEncodedRootLength(e);
 return t < 0 ? ~t : t;
}, getEncodedRootLength = e => {
 if (!e) return 0;
 const t = e.charCodeAt(0);
 if (47 === t || 92 === t) {
  if (e.charCodeAt(1) !== t) return 1;
  const r = e.indexOf(47 === t ? "/" : "\\", 2);
  return r < 0 ? e.length : r + 1;
 }
 if (isVolumeCharacter(t) && 58 === e.charCodeAt(1)) {
  const t = e.charCodeAt(2);
  if (47 === t || 92 === t) return 3;
  if (2 === e.length) return 2;
 }
 const r = e.indexOf("://");
 if (-1 !== r) {
  const t = r + 3, n = e.indexOf("/", t);
  if (-1 !== n) {
   const s = e.slice(0, r), o = e.slice(t, n);
   if ("file" === s && ("" === o || "localhost" === o) && isVolumeCharacter(e.charCodeAt(n + 1))) {
    const t = getFileUrlVolumeSeparatorEnd(e, n + 2);
    if (-1 !== t) {
     if (47 === e.charCodeAt(t)) return ~(t + 1);
     if (t === e.length) return ~t;
    }
   }
   return ~(n + 1);
  }
  return ~e.length;
 }
 return 0;
}, isVolumeCharacter = e => e >= 97 && e <= 122 || e >= 65 && e <= 90, getFileUrlVolumeSeparatorEnd = (e, t) => {
 const r = e.charCodeAt(t);
 if (58 === r) return t + 1;
 if (37 === r && 51 === e.charCodeAt(t + 1)) {
  const r = e.charCodeAt(t + 2);
  if (97 === r || 65 === r) return t + 3;
 }
 return -1;
}, pathComponents = (e, t) => {
 const r = e.substring(0, t), n = e.substring(t).split("/"), s = n.length;
 return s > 0 && !n[s - 1] && n.pop(), [ r, ...n ];
}, normalizeFsPath = e => normalizePath(e.split("?")[0].replace(/\0/g, "")), flattenDiagnosticMessageText = (e, t) => {
 var r, n;
 if ("string" == typeof t) return t;
 if (void 0 === t) return "";
 const s = [], o = (null !== (n = null === (r = e.file) || void 0 === r ? void 0 : r.fileName) && void 0 !== n ? n : "").includes("stencil.config");
 o && s.push(2322);
 let i = "";
 if (!s.includes(t.code) && (i = t.messageText, isIterable(t.next))) for (const r of t.next) i += flattenDiagnosticMessageText(e, r);
 return o && (i = i.replace("type 'StencilConfig'", "Stencil Config"), i = i.replace("Object literal may only specify known properties, but ", ""), 
 i = i.replace("Object literal may only specify known properties, and ", "")), i.trim();
}, isOutputTargetDistLazy = e => "dist-lazy" === e.type, isOutputTargetWww = e => "www" === e.type, isJest27TransformOptions = e => null != e && "object" == typeof e && e.hasOwnProperty("config");

let _tsCompilerOptions = null, _tsCompilerOptionsKey = null;

const jestPreprocessor = {
 process(e, t, r, n) {
  if (isJest27TransformOptions(r) && (n = r.config), !n) throw "Unable to find Jest transformation options.";
  if (function s(e, t) {
   var r;
   const n = (null !== (r = e.split(".").pop()) && void 0 !== r ? r : "").toLowerCase().split("?")[0];
   if ("ts" === n || "tsx" === n || "jsx" === n) return !0;
   if ("mjs" === n) return !0;
   if ("js" === n) {
    if (t.includes("import ") || t.includes("import.") || t.includes("import(")) return !0;
    if (t.includes("export ")) return !0;
   }
   return "css" === n;
  }(t, e)) {
   const r = {
    file: t,
    currentDirectory: n.rootDir
   }, s = getCompilerOptions(n.rootDir);
   s && (s.baseUrl && (r.baseUrl = s.baseUrl), s.paths && (r.paths = s.paths));
   const o = transpile(e, r), i = o.diagnostics.some((e => "error" === e.level));
   if (o.diagnostics && i) {
    const e = o.diagnostics.map(formatDiagnostic).join("\n\n");
    throw new Error(e);
   }
   return o.code;
  }
  return e;
 },
 getCacheKey(e, t, r, n) {
  if (isJest27TransformOptions(r) && (n = r.config), !n) throw "Unable to find Jest transformation options.";
  if (!_tsCompilerOptionsKey) {
   const e = getCompilerOptions(n.rootDir);
   _tsCompilerOptionsKey = JSON.stringify(e);
  }
  return [ process.version, _tsCompilerOptionsKey, e, t, r, !!n.instrument, 7 ].join(":");
 }
};

class MockHeaders {
 constructor(e) {
  if (this._values = [], "object" == typeof e) if ("function" == typeof e[Symbol.iterator]) {
   const t = [];
   for (const r of e) "function" == typeof r[Symbol.iterator] && t.push([ ...r ]);
   for (const e of t) this.append(e[0], e[1]);
  } else for (const t in e) this.append(t, e[t]);
 }
 append(e, t) {
  this._values.push([ e, t + "" ]);
 }
 delete(e) {
  e = e.toLowerCase();
  for (let t = this._values.length - 1; t >= 0; t--) this._values[t][0].toLowerCase() === e && this._values.splice(t, 1);
 }
 entries() {
  const e = [];
  for (const t of this.keys()) e.push([ t, this.get(t) ]);
  let t = -1;
  return {
   next: () => (t++, {
    value: e[t],
    done: !e[t]
   }),
   [Symbol.iterator]() {
    return this;
   }
  };
 }
 forEach(e) {
  for (const t of this.entries()) e(t[1], t[0]);
 }
 get(e) {
  const t = [];
  e = e.toLowerCase();
  for (const r of this._values) r[0].toLowerCase() === e && t.push(r[1]);
  return t.length > 0 ? t.join(", ") : null;
 }
 has(e) {
  e = e.toLowerCase();
  for (const t of this._values) if (t[0].toLowerCase() === e) return !0;
  return !1;
 }
 keys() {
  const e = [];
  for (const t of this._values) {
   const r = t[0].toLowerCase();
   e.includes(r) || e.push(r);
  }
  let t = -1;
  return {
   next: () => (t++, {
    value: e[t],
    done: !e[t]
   }),
   [Symbol.iterator]() {
    return this;
   }
  };
 }
 set(e, t) {
  for (const r of this._values) if (r[0].toLowerCase() === e.toLowerCase()) return void (r[1] = t + "");
  this.append(e, t);
 }
 values() {
  const e = this._values;
  let t = -1;
  return {
   next() {
    t++;
    const r = !e[t];
    return {
     value: r ? void 0 : e[t][1],
     done: r
    };
   },
   [Symbol.iterator]() {
    return this;
   }
  };
 }
 [Symbol.iterator]() {
  return this.entries();
 }
}

class MockRequest {
 constructor(e, t = {}) {
  this._method = "GET", this._url = "/", this.bodyUsed = !1, this.cache = "default", 
  this.credentials = "same-origin", this.integrity = "", this.keepalive = !1, this.mode = "cors", 
  this.redirect = "follow", this.referrer = "about:client", this.referrerPolicy = "", 
  "string" == typeof e ? this.url = e : e && (Object.assign(this, e), this.headers = new MockHeaders(e.headers)), 
  Object.assign(this, t), t.headers && (this.headers = new MockHeaders(t.headers)), 
  this.headers || (this.headers = new MockHeaders);
 }
 get url() {
  return "string" == typeof this._url ? new URL(this._url, location.href).href : new URL("/", location.href).href;
 }
 set url(e) {
  this._url = e;
 }
 get method() {
  return "string" == typeof this._method ? this._method.toUpperCase() : "GET";
 }
 set method(e) {
  this._method = e;
 }
 clone() {
  const e = {
   ...this
  };
  return e.headers = new MockHeaders(this.headers), new MockRequest(e);
 }
}

class MockResponse {
 constructor(e, t = {}) {
  this.ok = !0, this.status = 200, this.statusText = "", this.type = "default", this.url = "", 
  this._body = e, t && Object.assign(this, t), this.headers = new MockHeaders(t.headers);
 }
 async json() {
  return JSON.parse(this._body);
 }
 async text() {
  return this._body;
 }
 clone() {
  const e = {
   ...this
  };
  return e.headers = new MockHeaders(this.headers), new MockResponse(this._body, e);
 }
}

const mockedResponses = new Map, mockFetch = {
 json(e, t) {
  setMockedResponse(new MockResponse(JSON.stringify(e, null, 2), {
   headers: new MockHeaders({
    "Content-Type": "application/json"
   })
  }), t, !1);
 },
 text(e, t) {
  setMockedResponse(new MockResponse(e, {
   headers: new MockHeaders({
    "Content-Type": "text/plain"
   })
  }), t, !1);
 },
 response(e, t) {
  setMockedResponse(e, t, !1);
 },
 reject(e, t) {
  setMockedResponse(e, t, !0);
 },
 reset: function mockFetchReset() {
  mockedResponses.clear();
 }
};

class MockResponse404 extends MockResponse {
 constructor() {
  super("", {
   headers: new MockHeaders({
    "Content-Type": "text/plain"
   })
  }), this.ok = !1, this.status = 404, this.statusText = "Not Found";
 }
 async json() {
  return {
   status: 404,
   statusText: "Not Found"
  };
 }
 async text() {
  return "Not Found";
 }
}

const FETCH_DEFAULT_PATH = "/mock-fetch-data", HtmlSerializer = {
 print: e => index_cjs.serializeNodeToHtml(e, {
  serializeShadowRoot: !0,
  prettyHtml: !0,
  outerHtml: !0
 }),
 test: e => null != e && (e instanceof HTMLElement || e instanceof index_cjs.MockNode)
}, deepEqual = function e(t, r) {
 if (t === r) return !0;
 if (t && r && "object" == typeof t && "object" == typeof r) {
  const n = Array.isArray(t), s = Array.isArray(r);
  let o, i, a;
  if (n && s) {
   if (i = t.length, i != r.length) return !1;
   for (o = i; 0 != o--; ) if (!e(t[o], r[o])) return !1;
   return !0;
  }
  if (n != s) return !1;
  const l = t instanceof Date, c = r instanceof Date;
  if (l != c) return !1;
  if (l && c) return t.getTime() == r.getTime();
  const u = t instanceof RegExp, d = r instanceof RegExp;
  if (u != d) return !1;
  if (u && d) return t.toString() == r.toString();
  const p = Object.keys(t);
  if (i = p.length, i !== Object.keys(r).length) return !1;
  for (o = i; 0 != o--; ) if (!Object.prototype.hasOwnProperty.call(r, p[o])) return !1;
  for (o = i; 0 != o--; ) if (a = p[o], !e(t[a], r[a])) return !1;
  return !0;
 }
 return t != t && r != r;
}, expectExtend = {
 toEqualAttribute: function toEqualAttribute(e, t, r) {
  if (!e) throw new Error("expect toMatchAttribute value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toMatchAttribute value is not an element");
  let n = e.getAttribute(t);
  null != r && (r = String(r)), null != n && (n = String(n));
  const s = r === n;
  return {
   message: () => `expected attribute ${t} "${r}" to ${s ? "not " : ""}equal "${n}"`,
   pass: s
  };
 },
 toEqualAttributes: function toEqualAttributes(e, t) {
  if (!e) throw new Error("expect toEqualAttributes value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toEqualAttributes value is not an element");
  const r = Object.keys(t), n = r.every((r => {
   let n = t[r];
   return null != n && (n = String(n)), e.getAttribute(r) === n;
  }));
  return {
   message: () => `expected attributes to ${n ? "not " : ""}equal ${r.map((e => `[${e}="${t[e]}"]`)).join(", ")}`,
   pass: n
  };
 },
 toEqualHtml: function toEqualHtml(e, t) {
  return compareHtml(e, t, !0);
 },
 toEqualLightHtml: function toEqualLightHtml(e, t) {
  return compareHtml(e, t, !1);
 },
 toEqualText: function toEqualText(e, t) {
  var r;
  if (null == e) throw new Error(`expect toEqualText() value is "${e}"`);
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  let n;
  n = 1 === e.nodeType ? (null !== (r = e.textContent) && void 0 !== r ? r : "").replace(/\s\s+/g, " ").trim() : String(e).replace(/\s\s+/g, " ").trim(), 
  "string" == typeof t && (t = t.replace(/\s\s+/g, " ").trim());
  const s = n === t;
  return {
   message: () => `expected textContent "${t}" to ${s ? "not " : ""}equal "${n}"`,
   pass: s
  };
 },
 toHaveAttribute: function toHaveAttribute(e, t) {
  if (!e) throw new Error("expect toHaveAttribute value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toHaveAttribute value is not an element");
  const r = e.hasAttribute(t);
  return {
   message: () => `expected to ${r ? "not " : ""}have the attribute "${t}"`,
   pass: r
  };
 },
 toHaveClass: function toHaveClass(e, t) {
  if (!e) throw new Error("expect toHaveClass value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toHaveClass value is not an element");
  const r = e.classList.contains(t);
  return {
   message: () => `expected to ${r ? "not " : ""}have css class "${t}"`,
   pass: r
  };
 },
 toHaveClasses,
 toMatchClasses: function toMatchClasses(e, t) {
  let {pass: r} = toHaveClasses(e, t);
  return r && (r = t.length === e.classList.length), {
   message: () => `expected to ${r ? "not " : ""}match css classes "${t.join(" ")}", but className is "${e.className}"`,
   pass: r
  };
 },
 toHaveReceivedEvent: function toHaveReceivedEvent(e) {
  if (!e) throw new Error("toHaveReceivedEvent event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveReceivedEvent did not receive an event spy");
  const t = e.events.length > 0;
  return {
   message: () => `expected to have ${t ? "not " : ""}called "${e.eventName}" event`,
   pass: t
  };
 },
 toHaveReceivedEventDetail: function toHaveReceivedEventDetail(e, t) {
  if (!e) throw new Error("toHaveReceivedEventDetail event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveReceivedEventDetail did not receive an event spy");
  if (!e.lastEvent) throw new Error(`event "${e.eventName}" was not received`);
  const r = deepEqual(e.lastEvent.detail, t);
  return expect(e.lastEvent.detail).toEqual(t), {
   message: () => `expected event "${e.eventName}" detail to ${r ? "not " : ""}equal`,
   pass: r
  };
 },
 toHaveReceivedEventTimes: function toHaveReceivedEventTimes(e, t) {
  if (!e) throw new Error("toHaveReceivedEventTimes event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveReceivedEventTimes did not receive an event spy");
  return {
   message: () => `expected event "${e.eventName}" to have been called ${t} times, but was called ${e.events.length} time${e.events.length > 1 ? "s" : ""}`,
   pass: e.length === t
  };
 },
 toHaveFirstReceivedEventDetail: function toHaveFirstReceivedEventDetail(e, t) {
  if (!e) throw new Error("toHaveFirstReceivedEventDetail event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveFirstReceivedEventDetail did not receive an event spy");
  if (!e.firstEvent) throw new Error(`event "${e.eventName}" was not received`);
  const r = deepEqual(e.firstEvent.detail, t);
  return expect(e.lastEvent.detail).toEqual(t), {
   message: () => `expected event "${e.eventName}" detail to ${r ? "not " : ""}equal`,
   pass: r
  };
 },
 toHaveNthReceivedEventDetail: function toHaveNthReceivedEventDetail(e, t, r) {
  if (!e) throw new Error("toHaveNthReceivedEventDetail event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveNthReceivedEventDetail did not receive an event spy");
  if (!e.firstEvent) throw new Error(`event "${e.eventName}" was not received`);
  const n = e.events[t];
  if (!n) throw new Error(`event at index ${t} was not received`);
  const s = deepEqual(n.detail, r);
  return expect(n.detail).toEqual(r), {
   message: () => `expected event "${e.eventName}" detail to ${s ? "not " : ""}equal`,
   pass: s
  };
 },
 toMatchScreenshot: function toMatchScreenshot(e, t = {}) {
  if (!e) throw new Error("expect toMatchScreenshot value is null");
  if ("function" == typeof e.then) throw new Error("expect(compare).toMatchScreenshot() must be a resolved value, not a promise, before it can be tested");
  if ("number" != typeof e.mismatchedPixels) throw new Error(`expect toMatchScreenshot() value is not a valid screenshot compare object - 'mismatchedPixels' has type '${typeof e.mismatchedPixels}', but should be a number`);
  if ("number" != typeof e.deviceScaleFactor) throw new Error(`expect toMatchScreenshot() value is not a valid screenshot compare object - 'deviceScaleFactor' has type '${typeof e.deviceScaleFactor}', but should be a number`);
  const r = e.device || e.userAgent;
  if ("number" == typeof t.allowableMismatchedRatio) {
   if (t.allowableMismatchedRatio < 0 || t.allowableMismatchedRatio > 1) throw new Error("expect toMatchScreenshot() allowableMismatchedRatio must be a value ranging from 0 to 1");
   const n = e.mismatchedPixels / (e.width * e.deviceScaleFactor * (e.height * e.deviceScaleFactor));
   return {
    message: () => `${r}: screenshot has a mismatch ratio of "${n}" for "${e.desc}", but expected ratio to be less than "${t.allowableMismatchedRatio}"`,
    pass: n <= t.allowableMismatchedRatio
   };
  }
  if ("number" == typeof t.allowableMismatchedPixels) {
   if (t.allowableMismatchedPixels < 0) throw new Error("expect toMatchScreenshot() allowableMismatchedPixels value must be a value that is 0 or greater");
   return {
    message: () => `${r}: screenshot has "${e.mismatchedPixels}" mismatched pixels for "${e.desc}", but expected less than "${t.allowableMismatchedPixels}" mismatched pixels`,
    pass: e.mismatchedPixels <= t.allowableMismatchedPixels
   };
  }
  if ("number" == typeof e.allowableMismatchedRatio) {
   const t = e.mismatchedPixels / (e.width * e.deviceScaleFactor * (e.height * e.deviceScaleFactor));
   return {
    message: () => `${r}: screenshot has a mismatch ratio of "${t}" for "${e.desc}", but expected ratio to be less than "${e.allowableMismatchedRatio}"`,
    pass: t <= e.allowableMismatchedRatio
   };
  }
  if ("number" == typeof e.allowableMismatchedPixels) return {
   message: () => `${r}: screenshot has "${e.mismatchedPixels}" mismatched pixels for "${e.desc}", but expected less than "${e.allowableMismatchedPixels}" mismatched pixels`,
   pass: e.mismatchedPixels <= e.allowableMismatchedPixels
  };
  throw new Error("expect toMatchScreenshot() missing allowableMismatchedPixels in testing config");
 }
}, createConfigFlags = (e = {}) => ({
 task: null,
 args: [],
 knownArgs: [],
 unknownArgs: [],
 ...e
});

class BuildContext {
 constructor(e, t) {
  this.buildId = -1, this.buildMessages = [], this.buildResults = null, this.bundleBuildCount = 0, 
  this.collections = [], this.completedTasks = [], this.components = [], this.componentGraph = new Map, 
  this.data = {}, this.buildStats = void 0, this.diagnostics = [], this.dirsAdded = [], 
  this.dirsDeleted = [], this.entryModules = [], this.filesAdded = [], this.filesChanged = [], 
  this.filesDeleted = [], this.filesUpdated = [], this.filesWritten = [], this.globalStyle = void 0, 
  this.hasConfigChanges = !1, this.hasFinished = !1, this.hasHtmlChanges = !1, this.hasPrintedResults = !1, 
  this.hasServiceWorkerChanges = !1, this.hasScriptChanges = !0, this.hasStyleChanges = !0, 
  this.hydrateAppFilePath = null, this.indexBuildCount = 0, this.indexDoc = void 0, 
  this.isRebuild = !1, this.moduleFiles = [], this.outputs = [], this.packageJson = {}, 
  this.packageJsonFilePath = null, this.pendingCopyTasks = [], this.requiresFullBuild = !0, 
  this.scriptsAdded = [], this.scriptsDeleted = [], this.startTime = Date.now(), this.styleBuildCount = 0, 
  this.stylesPromise = null, this.stylesUpdated = [], this.timeSpan = null, this.transpileBuildCount = 0, 
  this.config = e, this.compilerCtx = t, this.buildId = ++this.compilerCtx.activeBuildId, 
  this.debug = e.logger.debug.bind(e.logger);
 }
 start() {
  const e = `${this.isRebuild ? "rebuild" : "build"}, ${this.config.fsNamespace}, ${this.config.devMode ? "dev" : "prod"} mode, started`, t = {
   buildId: this.buildId,
   messages: [],
   progress: 0
  };
  this.compilerCtx.events.emit("buildLog", t), this.timeSpan = this.createTimeSpan(e), 
  this.timestamp = getBuildTimestamp(), this.debug(`start build, ${this.timestamp}`);
  const r = {
   buildId: this.buildId,
   timestamp: this.timestamp
  };
  this.compilerCtx.events.emit("buildStart", r);
 }
 createTimeSpan(e, t) {
  if (!this.hasFinished || t) {
   t && this.config.watch && (e = `${this.config.logger.cyan("[" + this.buildId + "]")} ${e}`);
   const r = this.config.logger.createTimeSpan(e, t, this.buildMessages);
   if (!t && this.compilerCtx.events) {
    const e = {
     buildId: this.buildId,
     messages: this.buildMessages,
     progress: getProgress(this.completedTasks)
    };
    this.compilerCtx.events.emit("buildLog", e);
   }
   return {
    duration: () => r.duration(),
    finish: (e, n, s, o) => {
     if ((!this.hasFinished || t) && (t && this.config.watch && (e = `${this.config.logger.cyan("[" + this.buildId + "]")} ${e}`), 
     r.finish(e, n, s, o), !t)) {
      const e = {
       buildId: this.buildId,
       messages: this.buildMessages.slice(),
       progress: getProgress(this.completedTasks)
      };
      this.compilerCtx.events.emit("buildLog", e);
     }
     return r.duration();
    }
   };
  }
  return {
   duration: () => 0,
   finish: () => 0
  };
 }
 debug(e) {
  this.config.logger.debug(e);
 }
 get hasError() {
  return hasError(this.diagnostics);
 }
 get hasWarning() {
  return null != (e = this.diagnostics) && 0 !== e.length && e.some((e => "warn" === e.level));
  var e;
 }
 progress(e) {
  this.completedTasks.push(e);
 }
 async validateTypesBuild() {
  this.hasError || this.validateTypesPromise && (this.config.watch || (this.debug("build, non-watch, waiting on validateTypes"), 
  await this.validateTypesPromise, this.debug("build, non-watch, finished waiting on validateTypes")));
 }
}

const getBuildTimestamp = () => {
 const e = new Date;
 let t = e.getUTCFullYear() + "-";
 return t += ("0" + (e.getUTCMonth() + 1)).slice(-2) + "-", t += ("0" + e.getUTCDate()).slice(-2) + "T", 
 t += ("0" + e.getUTCHours()).slice(-2) + ":", t += ("0" + e.getUTCMinutes()).slice(-2) + ":", 
 t += ("0" + e.getUTCSeconds()).slice(-2), t;
}, getProgress = e => {
 let t = 0;
 const r = Object.keys(ProgressTask);
 return r.forEach(((r, n) => {
  e.includes(ProgressTask[r]) && (t = n);
 })), (t + 1) / r.length;
}, ProgressTask = {
 emptyOutputTargets: {},
 transpileApp: {},
 generateStyles: {},
 generateOutputTargets: {},
 validateTypesBuild: {},
 writeBuildFiles: {}
};

class Cache {
 constructor(e, t) {
  this.config = e, this.cacheFs = t, this.failed = 0, this.skip = !1, this.sys = e.sys, 
  this.logger = e.logger;
 }
 async initCacheDir() {
  if (!this.config._isTesting && this.config.cacheDir) {
   if (this.buildCacheDir = path$2.join(this.config.cacheDir, ".build"), !this.config.enableCache || !this.cacheFs) return this.config.logger.info("cache optimizations disabled"), 
   void this.clearDiskCache();
   this.config.logger.debug(`cache enabled, cacheDir: ${this.buildCacheDir}`);
   try {
    const e = path$2.join(this.buildCacheDir, "_README.log");
    await this.cacheFs.writeFile(e, CACHE_DIR_README);
   } catch (e) {
    this.logger.error(`Cache, initCacheDir: ${e}`), this.config.enableCache = !1;
   }
  }
 }
 async get(e) {
  if (!this.config.enableCache || this.skip) return null;
  if (this.failed >= MAX_FAILED) return this.skip || (this.skip = !0, this.logger.debug(`cache had ${this.failed} failed ops, skip disk ops for remainder of build`)), 
  null;
  let t;
  try {
   t = await this.cacheFs.readFile(this.getCacheFilePath(e)), this.failed = 0, this.skip = !1;
  } catch (e) {
   this.failed++, t = null;
  }
  return t;
 }
 async put(e, t) {
  if (!this.config.enableCache) return !1;
  try {
   return await this.cacheFs.writeFile(this.getCacheFilePath(e), t), !0;
  } catch (e) {
   return this.failed++, !1;
  }
 }
 async has(e) {
  return "string" == typeof await this.get(e);
 }
 async createKey(e, ...t) {
  return this.config.enableCache && this.sys.generateContentHash ? e + "_" + await this.sys.generateContentHash(JSON.stringify(t), 32) : e + 9999999 * Math.random();
 }
 async commit() {
  this.config.enableCache && (this.skip = !1, this.failed = 0, await this.cacheFs.commit(), 
  await this.clearExpiredCache());
 }
 clear() {
  null != this.cacheFs && this.cacheFs.clearCache();
 }
 async clearExpiredCache() {
  if (null == this.cacheFs || null == this.sys.cacheStorage) return;
  const e = Date.now(), t = await this.sys.cacheStorage.get(EXP_STORAGE_KEY);
  if (null != t) {
   if (e - t < ONE_DAY) return;
   const r = this.cacheFs.sys, n = await r.readDir(this.buildCacheDir), s = n.map((e => path$2.join(this.buildCacheDir, e)));
   let o = 0;
   const i = s.map((async t => {
    const n = (await r.stat(t)).mtimeMs;
    n && e - n > ONE_WEEK && (await r.removeFile(t), o++);
   }));
   await Promise.all(i), this.logger.debug(`clearExpiredCache, cachedFileNames: ${n.length}, totalCleared: ${o}`);
  }
  this.logger.debug("clearExpiredCache, set last clear"), await this.sys.cacheStorage.set(EXP_STORAGE_KEY, e);
 }
 async clearDiskCache() {
  null != this.cacheFs && await this.cacheFs.access(this.buildCacheDir) && (await this.cacheFs.remove(this.buildCacheDir), 
  await this.cacheFs.commit());
 }
 getCacheFilePath(e) {
  return path$2.join(this.buildCacheDir, e) + ".log";
 }
 getMemoryStats() {
  return null != this.cacheFs ? this.cacheFs.getMemoryStats() : null;
 }
}

const MAX_FAILED = 100, ONE_DAY = 864e5, ONE_WEEK = 7 * ONE_DAY, EXP_STORAGE_KEY = "last_clear_expired_cache", CACHE_DIR_README = '# Stencil Cache Directory\n\nThis directory contains files which the compiler has\ncached for faster builds. To disable caching, please set\n"enableCache: false" within the stencil config.\n\nTo change the cache directory, please update the\n"cacheDir" property within the stencil config.\n', buildEvents = () => {
 const e = [], t = t => {
  const r = e.findIndex((e => e.callback === t));
  return r > -1 && (e.splice(r, 1), !0);
 };
 return {
  emit: (t, r) => {
   const n = t.toLowerCase().trim(), s = e.slice();
   for (const e of s) if (null == e.eventName) try {
    e.callback(t, r);
   } catch (e) {
    console.error(e);
   } else if (e.eventName === n) try {
    e.callback(r);
   } catch (e) {
    console.error(e);
   }
  },
  on: (r, n) => {
   if ("function" == typeof r) {
    const n = null, s = r;
    return e.push({
     eventName: n,
     callback: s
    }), () => t(s);
   }
   if ("string" == typeof r && "function" == typeof n) {
    const s = r.toLowerCase().trim(), o = n;
    return e.push({
     eventName: s,
     callback: o
    }), () => t(o);
   }
   return () => !1;
  },
  unsubscribeAll: () => {
   e.length = 0;
  }
 };
}, createInMemoryFs = e => {
 const t = new Map, r = new Map, n = async (e, r = {}) => {
  e = normalizePath(e);
  const n = [];
  if (!0 === r.inMemoryOnly) {
   let s = e;
   s.endsWith("/") || (s += "/");
   const i = e.split("/");
   t.forEach(((t, s) => {
    if (!s.startsWith(e)) return;
    const a = s.split("/");
    if ((a.length === i.length + 1 || r.recursive && a.length > i.length) && t.exists) {
     const e = {
      absPath: s,
      relPath: a[i.length],
      isDirectory: t.isDirectory,
      isFile: t.isFile
     };
     o(r, e) || n.push(e);
    }
   }));
  } else await s(e, e, r, n);
  return n.sort(((e, t) => e.absPath < t.absPath ? -1 : e.absPath > t.absPath ? 1 : 0));
 }, s = async (t, r, n, i) => {
  const l = await e.readDir(r);
  if (l.length > 0) {
   const e = m(r);
   e.exists = !0, e.isFile = !1, e.isDirectory = !0, await Promise.all(l.map((async e => {
    const r = normalizePath(e), l = normalizePath(path$2.relative(t, r)), c = await a(r), u = {
     absPath: r,
     relPath: l,
     isDirectory: c.isDirectory,
     isFile: c.isFile
    };
    o(n, u) || (i.push(u), !0 === n.recursive && !0 === c.isDirectory && await s(t, r, n, i));
   })));
  }
 }, o = (e, t) => {
  if (t.isDirectory) {
   if (Array.isArray(e.excludeDirNames)) {
    const r = path$2.basename(t.absPath);
    if (e.excludeDirNames.some((e => r === e))) return !0;
   }
  } else if (Array.isArray(e.excludeExtensions)) {
   const r = t.relPath.toLowerCase();
   if (e.excludeExtensions.some((e => r.endsWith(e)))) return !0;
  }
  return !1;
 }, i = async e => {
  const t = m(e);
  t.queueWriteToDisk || (t.queueDeleteFromDisk = !0);
 }, a = async t => {
  const r = m(t);
  if ("boolean" != typeof r.isDirectory || "boolean" != typeof r.isFile) {
   const n = await e.stat(t);
   n.error ? r.exists = !1 : (r.exists = !0, n.isFile ? (r.isFile = !0, r.isDirectory = !1, 
   r.size = n.size) : n.isDirectory ? (r.isFile = !1, r.isDirectory = !0, r.size = n.size) : (r.isFile = !1, 
   r.isDirectory = !1, r.size = null));
  }
  return {
   exists: !!r.exists,
   isFile: !!r.isFile,
   isDirectory: !!r.isDirectory,
   size: "number" == typeof r.size ? r.size : 0
  };
 }, l = t => {
  const r = m(t);
  if ("boolean" != typeof r.isDirectory || "boolean" != typeof r.isFile) {
   const n = e.statSync(t);
   n.error ? r.exists = !1 : (r.exists = !0, n.isFile ? (r.isFile = !0, r.isDirectory = !1, 
   r.size = n.size) : n.isDirectory ? (r.isFile = !1, r.isDirectory = !0, r.size = n.size) : (r.isFile = !1, 
   r.isDirectory = !1, r.size = null));
  }
  return {
   exists: !!r.exists,
   isFile: !!r.isFile,
   isDirectory: !!r.isDirectory,
   size: r.size
  };
 }, c = async (t, n, s) => {
  if ("string" != typeof t) throw new Error(`writeFile, invalid filePath: ${t}`);
  if ("string" != typeof n) throw new Error(`writeFile, invalid content: ${t}`);
  const o = {
   ignored: !1,
   changedContent: !1,
   queuedWrite: !1
  };
  if (!0 === shouldIgnore(t)) return o.ignored = !0, o;
  const i = m(t);
  if (i.exists = !0, i.isFile = !0, i.isDirectory = !1, i.queueDeleteFromDisk = !1, 
  "string" == typeof i.fileText ? o.changedContent = i.fileText.replace(/\r/g, "") !== n.replace(/\r/g, "") : o.changedContent = !0, 
  i.fileText = n, o.queuedWrite = !1, null != s && ("string" == typeof s.outputTargetType && r.set(t, s.outputTargetType), 
  !1 === s.useCache && (i.useCache = !1)), null != s && !0 === s.inMemoryOnly) i.queueWriteToDisk ? o.queuedWrite = !0 : i.queueWriteToDisk = !1, 
  await u(t, !0); else if (null != s && !0 === s.immediateWrite) {
   if (o.changedContent || !0 !== s.useCache) {
    const r = await e.readFile(t);
    "string" == typeof r && (o.changedContent = i.fileText.replace(/\r/g, "") !== r.replace(/\r/g, "")), 
    o.changedContent && (await u(t, !1), await e.writeFile(t, i.fileText));
   }
  } else i.queueWriteToDisk || !0 !== o.changedContent || (i.queueWriteToDisk = !0, 
  o.queuedWrite = !0);
  return o;
 }, u = async (e, t) => {
  const r = [];
  for (;"string" == typeof (e = path$2.dirname(e)) && e.length > 0 && "/" !== e && !1 === e.endsWith(":/") && !1 === e.endsWith(":\\"); ) r.push(e);
  r.reverse(), await d(r, t);
 }, d = async (t, r) => {
  const n = [];
  for (const s of t) {
   const t = m(s);
   if (!0 !== t.exists || !0 !== t.isDirectory) try {
    t.exists = !0, t.isDirectory = !0, t.isFile = !1, r || await e.createDir(s), n.push(s);
   } catch (e) {}
  }
  return n;
 }, p = async t => {
  const r = m(t);
  if (null == r.fileText) throw new Error(`unable to find item fileText to write: ${t}`);
  return await e.writeFile(t, r.fileText), !1 === r.useCache && f(t), t;
 }, h = e => {
  e = normalizePath(e), t.forEach(((t, r) => {
   const n = path$2.relative(e, r).split("/")[0];
   n.startsWith(".") || n.startsWith("/") || f(r);
  }));
 }, f = e => {
  e = normalizePath(e);
  const r = t.get(e);
  null == r || r.queueWriteToDisk || t.delete(e);
 }, m = e => {
  e = normalizePath(e);
  let r = t.get(e);
  return null != r || t.set(e, r = {
   exists: null,
   fileText: null,
   size: null,
   mtimeMs: null,
   isDirectory: null,
   isFile: null,
   queueCopyFileToDest: null,
   queueDeleteFromDisk: null,
   queueWriteToDisk: null,
   useCache: null
  }), r;
 }, g = 5242880;
 return {
  access: async e => {
   const t = m(e);
   return "boolean" != typeof t.exists ? (await a(e)).exists : t.exists;
  },
  accessSync: e => {
   const t = m(e);
   return "boolean" != typeof t.exists ? l(e).exists : t.exists;
  },
  cancelDeleteDirectoriesFromDisk: e => {
   for (const t of e) {
    const e = m(t);
    !0 === e.queueDeleteFromDisk && (e.queueDeleteFromDisk = !1);
   }
  },
  cancelDeleteFilesFromDisk: e => {
   for (const t of e) {
    const e = m(t);
    !0 === e.isFile && !0 === e.queueDeleteFromDisk && (e.queueDeleteFromDisk = !1);
   }
  },
  clearCache: () => {
   t.clear();
  },
  clearDirCache: h,
  clearFileCache: f,
  commit: async () => {
   const r = getCommitInstructions(t), n = await d(r.dirsToEnsure, !1), s = await (l = r.filesToWrite, 
   Promise.all(l.map((async e => {
    if ("string" != typeof e) throw new Error("unable to writeFile without filePath");
    return p(e);
   })))), o = await (t => {
    const r = Promise.all(t.map((async t => {
     const [r, n] = t;
     return await e.copyFile(r, n), [ r, n ];
    })));
    return r;
   })(r.filesToCopy), i = await (async t => await Promise.all(t.map((async t => {
    if ("string" != typeof t) throw new Error("unable to unlink without filePath");
    return await e.removeFile(t), t;
   }))))(r.filesToDelete), a = await (async t => {
    const r = [];
    for (const n of t) await e.removeDir(n), r.push(n);
    return r;
   })(r.dirsToDelete);
   var l;
   return r.filesToDelete.forEach(f), r.dirsToDelete.forEach(h), {
    filesCopied: o,
    filesWritten: s,
    filesDeleted: i,
    dirsDeleted: a,
    dirsAdded: n
   };
  },
  copyFile: async (e, t) => {
   m(e).queueCopyFileToDest = t;
  },
  emptyDirs: async e => {
   e = e.filter(isString).map((e => normalizePath(e))).reduce(((e, t) => (e.includes(t) || e.push(t), 
   e)), []);
   const t = await Promise.all(e.map((e => n(e, {
    recursive: !0
   })))), r = [];
   for (const e of t) for (const t of e) r.includes(t.absPath) || r.push(t.absPath);
   r.sort(((e, t) => {
    const r = e.split("/").length, n = t.split("/").length;
    return r < n ? 1 : r > n ? -1 : 0;
   })), await Promise.all(r.map(i)), e.forEach((e => {
    const t = m(e);
    t.isFile = !1, t.isDirectory = !0, t.queueWriteToDisk = !0, t.queueDeleteFromDisk = !1;
   }));
  },
  getBuildOutputs: () => {
   const e = [];
   return r.forEach(((t, r) => {
    const n = e.find((e => e.type === t));
    n ? n.files.push(r) : e.push({
     type: t,
     files: [ r ]
    });
   })), e.forEach((e => e.files.sort())), e.sort(((e, t) => e.type < t.type ? -1 : e.type > t.type ? 1 : 0));
  },
  getItem: m,
  getMemoryStats: () => `data length: ${t.size}`,
  readFile: async (t, r) => {
   if (null == r || !0 === r.useCache || void 0 === r.useCache) {
    const e = m(t);
    if (e.exists && "string" == typeof e.fileText) return e.fileText;
   }
   const n = await e.readFile(t), s = m(t);
   return "string" == typeof n ? n.length < g && (s.exists = !0, s.isFile = !0, s.isDirectory = !1, 
   s.fileText = n) : s.exists = !1, n;
  },
  readFileSync: (t, r) => {
   if (null == r || !0 === r.useCache || void 0 === r.useCache) {
    const e = m(t);
    if (e.exists && "string" == typeof e.fileText) return e.fileText;
   }
   const n = e.readFileSync(t), s = m(t);
   return "string" == typeof n ? n.length < g && (s.exists = !0, s.isFile = !0, s.isDirectory = !1, 
   s.fileText = n) : s.exists = !1, n;
  },
  readdir: n,
  remove: async e => {
   const t = await a(e);
   !0 === t.isDirectory ? await (async e => {
    const t = m(e);
    t.isFile = !1, t.isDirectory = !0, t.queueWriteToDisk || (t.queueDeleteFromDisk = !0);
    try {
     const t = await n(e, {
      recursive: !0
     });
     await Promise.all(t.map((e => e.relPath.endsWith(".gitkeep") ? null : i(e.absPath))));
    } catch (e) {}
   })(e) : !0 === t.isFile && await i(e);
  },
  stat: a,
  statSync: l,
  sys: e,
  writeFile: c,
  writeFiles: (e, t) => {
   const r = [];
   return isIterable(e) ? e.forEach(((e, n) => {
    r.push(c(n, e, t));
   })) : Object.keys(e).map((n => {
    r.push(c(n, e[n], t));
   })), Promise.all(r);
  }
 };
}, getCommitInstructions = e => {
 const t = {
  filesToDelete: [],
  filesToWrite: [],
  filesToCopy: [],
  dirsToDelete: [],
  dirsToEnsure: []
 };
 e.forEach(((e, r) => {
  if (!0 === e.queueWriteToDisk) {
   if (!0 === e.isFile) {
    t.filesToWrite.push(r);
    const e = normalizePath(path$2.dirname(r));
    t.dirsToEnsure.includes(e) || t.dirsToEnsure.push(e);
    const n = t.dirsToDelete.indexOf(e);
    n > -1 && t.dirsToDelete.splice(n, 1);
    const s = t.filesToDelete.indexOf(r);
    s > -1 && t.filesToDelete.splice(s, 1);
   } else if (!0 === e.isDirectory) {
    t.dirsToEnsure.includes(r) || t.dirsToEnsure.push(r);
    const e = t.dirsToDelete.indexOf(r);
    e > -1 && t.dirsToDelete.splice(e, 1);
   }
  } else if (!0 === e.queueDeleteFromDisk) e.isDirectory && !t.dirsToEnsure.includes(r) ? t.dirsToDelete.push(r) : e.isFile && !t.filesToWrite.includes(r) && t.filesToDelete.push(r); else if ("string" == typeof e.queueCopyFileToDest) {
   const n = r, s = e.queueCopyFileToDest;
   t.filesToCopy.push([ n, s ]);
   const o = normalizePath(path$2.dirname(s));
   t.dirsToEnsure.includes(o) || t.dirsToEnsure.push(o);
   const i = t.dirsToDelete.indexOf(o);
   i > -1 && t.dirsToDelete.splice(i, 1);
   const a = t.filesToDelete.indexOf(s);
   a > -1 && t.filesToDelete.splice(a, 1);
  }
  e.queueDeleteFromDisk = !1, e.queueWriteToDisk = !1;
 }));
 for (let e = 0, r = t.dirsToEnsure.length; e < r; e++) {
  const r = t.dirsToEnsure[e].split("/");
  for (let e = 2; e < r.length; e++) {
   const n = r.slice(0, e).join("/");
   !1 === t.dirsToEnsure.includes(n) && t.dirsToEnsure.push(n);
  }
 }
 t.dirsToEnsure.sort(((e, t) => {
  const r = e.split("/").length, n = t.split("/").length;
  return r < n ? -1 : r > n ? 1 : e.length < t.length ? -1 : e.length > t.length ? 1 : 0;
 })), t.dirsToDelete.sort(((e, t) => {
  const r = e.split("/").length, n = t.split("/").length;
  return r < n ? 1 : r > n ? -1 : e.length < t.length ? 1 : e.length > t.length ? -1 : 0;
 }));
 for (const e of t.dirsToEnsure) {
  const r = t.dirsToDelete.indexOf(e);
  r > -1 && t.dirsToDelete.splice(r, 1);
 }
 return t.dirsToDelete = t.dirsToDelete.filter((e => "/" !== e && !0 !== e.endsWith(":/"))), 
 t.dirsToEnsure = t.dirsToEnsure.filter((t => {
  const r = e.get(t);
  return (null == r || !0 !== r.exists || !0 !== r.isDirectory) && "/" !== t && !t.endsWith(":/");
 })), t;
}, shouldIgnore = e => (e = e.trim().toLowerCase(), IGNORE.some((t => e.endsWith(t)))), IGNORE = [ ".ds_store", ".gitignore", "desktop.ini", "thumbs.db" ];

class TestingLogger {
 constructor() {
  this.isEnabled = !1;
 }
 enable() {
  this.isEnabled = !0;
 }
 setLevel(e) {}
 getLevel() {
  return "info";
 }
 enableColors(e) {}
 emoji(e) {
  return "";
 }
 info(...e) {
  this.isEnabled && console.log(...e);
 }
 warn(...e) {
  this.isEnabled && console.warn(...e);
 }
 error(...e) {
  this.isEnabled && console.error(...e);
 }
 debug(...e) {
  this.isEnabled && console.log(...e);
 }
 color(e, t) {}
 red(e) {
  return e;
 }
 green(e) {
  return e;
 }
 yellow(e) {
  return e;
 }
 blue(e) {
  return e;
 }
 magenta(e) {
  return e;
 }
 cyan(e) {
  return e;
 }
 gray(e) {
  return e;
 }
 bold(e) {
  return e;
 }
 dim(e) {
  return e;
 }
 bgRed(e) {
  return e;
 }
 createTimeSpan(e, t = !1) {
  return {
   duration: () => 0,
   finish: () => 0
  };
 }
 printDiagnostics(e) {}
}

origCwd = process.cwd, cwd = null, platform = process.env.GRACEFUL_FS_PLATFORM || process.platform, 
process.cwd = function() {
 return cwd || (cwd = origCwd.call(process)), cwd;
};

try {
 process.cwd();
} catch (e) {}

"function" == typeof process.chdir && (chdir = process.chdir, process.chdir = function(e) {
 cwd = null, chdir.call(process, e);
}, Object.setPrototypeOf && Object.setPrototypeOf(process.chdir, chdir)), polyfills = function patch(e) {
 function t(t) {
  return t ? function(r, n, s) {
   return t.call(e, r, n, (function(e) {
    a(e) && (e = null), s && s.apply(this, arguments);
   }));
  } : t;
 }
 function r(t) {
  return t ? function(r, n) {
   try {
    return t.call(e, r, n);
   } catch (e) {
    if (!a(e)) throw e;
   }
  } : t;
 }
 function n(t) {
  return t ? function(r, n, s, o) {
   return t.call(e, r, n, s, (function(e) {
    a(e) && (e = null), o && o.apply(this, arguments);
   }));
  } : t;
 }
 function s(t) {
  return t ? function(r, n, s) {
   try {
    return t.call(e, r, n, s);
   } catch (e) {
    if (!a(e)) throw e;
   }
  } : t;
 }
 function o(t) {
  return t ? function(r, n, s) {
   function o(e, t) {
    t && (t.uid < 0 && (t.uid += 4294967296), t.gid < 0 && (t.gid += 4294967296)), s && s.apply(this, arguments);
   }
   return "function" == typeof n && (s = n, n = null), n ? t.call(e, r, n, o) : t.call(e, r, o);
  } : t;
 }
 function i(t) {
  return t ? function(r, n) {
   var s = n ? t.call(e, r, n) : t.call(e, r);
   return s && (s.uid < 0 && (s.uid += 4294967296), s.gid < 0 && (s.gid += 4294967296)), 
   s;
  } : t;
 }
 function a(e) {
  return !e || "ENOSYS" === e.code || !(process.getuid && 0 === process.getuid() || "EINVAL" !== e.code && "EPERM" !== e.code);
 }
 var l;
 constants__default.default.hasOwnProperty("O_SYMLINK") && process.version.match(/^v0\.6\.[0-2]|^v0\.5\./) && function c(e) {
  e.lchmod = function(t, r, n) {
   e.open(t, constants__default.default.O_WRONLY | constants__default.default.O_SYMLINK, r, (function(t, s) {
    t ? n && n(t) : e.fchmod(s, r, (function(t) {
     e.close(s, (function(e) {
      n && n(t || e);
     }));
    }));
   }));
  }, e.lchmodSync = function(t, r) {
   var n, s = e.openSync(t, constants__default.default.O_WRONLY | constants__default.default.O_SYMLINK, r), o = !0;
   try {
    n = e.fchmodSync(s, r), o = !1;
   } finally {
    if (o) try {
     e.closeSync(s);
    } catch (e) {} else e.closeSync(s);
   }
   return n;
  };
 }(e), e.lutimes || function u(e) {
  constants__default.default.hasOwnProperty("O_SYMLINK") && e.futimes ? (e.lutimes = function(t, r, n, s) {
   e.open(t, constants__default.default.O_SYMLINK, (function(t, o) {
    t ? s && s(t) : e.futimes(o, r, n, (function(t) {
     e.close(o, (function(e) {
      s && s(t || e);
     }));
    }));
   }));
  }, e.lutimesSync = function(t, r, n) {
   var s, o = e.openSync(t, constants__default.default.O_SYMLINK), i = !0;
   try {
    s = e.futimesSync(o, r, n), i = !1;
   } finally {
    if (i) try {
     e.closeSync(o);
    } catch (e) {} else e.closeSync(o);
   }
   return s;
  }) : e.futimes && (e.lutimes = function(e, t, r, n) {
   n && process.nextTick(n);
  }, e.lutimesSync = function() {});
 }(e), e.chown = n(e.chown), e.fchown = n(e.fchown), e.lchown = n(e.lchown), e.chmod = t(e.chmod), 
 e.fchmod = t(e.fchmod), e.lchmod = t(e.lchmod), e.chownSync = s(e.chownSync), e.fchownSync = s(e.fchownSync), 
 e.lchownSync = s(e.lchownSync), e.chmodSync = r(e.chmodSync), e.fchmodSync = r(e.fchmodSync), 
 e.lchmodSync = r(e.lchmodSync), e.stat = o(e.stat), e.fstat = o(e.fstat), e.lstat = o(e.lstat), 
 e.statSync = i(e.statSync), e.fstatSync = i(e.fstatSync), e.lstatSync = i(e.lstatSync), 
 e.chmod && !e.lchmod && (e.lchmod = function(e, t, r) {
  r && process.nextTick(r);
 }, e.lchmodSync = function() {}), e.chown && !e.lchown && (e.lchown = function(e, t, r, n) {
  n && process.nextTick(n);
 }, e.lchownSync = function() {}), "win32" === platform && (e.rename = "function" != typeof e.rename ? e.rename : function(t) {
  function r(r, n, s) {
   var o = Date.now(), i = 0;
   t(r, n, (function a(l) {
    if (l && ("EACCES" === l.code || "EPERM" === l.code || "EBUSY" === l.code) && Date.now() - o < 6e4) return setTimeout((function() {
     e.stat(n, (function(e, o) {
      e && "ENOENT" === e.code ? t(r, n, a) : s(l);
     }));
    }), i), void (i < 100 && (i += 10));
    s && s(l);
   }));
  }
  return Object.setPrototypeOf && Object.setPrototypeOf(r, t), r;
 }(e.rename)), e.read = "function" != typeof e.read ? e.read : function(t) {
  function r(r, n, s, o, i, a) {
   var l, c;
   return a && "function" == typeof a && (c = 0, l = function(u, d, p) {
    if (u && "EAGAIN" === u.code && c < 10) return c++, t.call(e, r, n, s, o, i, l);
    a.apply(this, arguments);
   }), t.call(e, r, n, s, o, i, l);
  }
  return Object.setPrototypeOf && Object.setPrototypeOf(r, t), r;
 }(e.read), e.readSync = "function" != typeof e.readSync ? e.readSync : (l = e.readSync, 
 function(t, r, n, s, o) {
  for (var i = 0; ;) try {
   return l.call(e, t, r, n, s, o);
  } catch (e) {
   if ("EAGAIN" === e.code && i < 10) {
    i++;
    continue;
   }
   throw e;
  }
 });
}, Stream = require$$0__default.default.Stream, legacyStreams = function legacy(e) {
 return {
  ReadStream: function t(r, n) {
   var s, o, i, a, l;
   if (!(this instanceof t)) return new t(r, n);
   for (Stream.call(this), s = this, this.path = r, this.fd = null, this.readable = !0, 
   this.paused = !1, this.flags = "r", this.mode = 438, this.bufferSize = 65536, n = n || {}, 
   i = 0, a = (o = Object.keys(n)).length; i < a; i++) this[l = o[i]] = n[l];
   if (this.encoding && this.setEncoding(this.encoding), void 0 !== this.start) {
    if ("number" != typeof this.start) throw TypeError("start must be a Number");
    if (void 0 === this.end) this.end = 1 / 0; else if ("number" != typeof this.end) throw TypeError("end must be a Number");
    if (this.start > this.end) throw new Error("start must be <= end");
    this.pos = this.start;
   }
   null === this.fd ? e.open(this.path, this.flags, this.mode, (function(e, t) {
    if (e) return s.emit("error", e), void (s.readable = !1);
    s.fd = t, s.emit("open", t), s._read();
   })) : process.nextTick((function() {
    s._read();
   }));
  },
  WriteStream: function t(r, n) {
   var s, o, i, a;
   if (!(this instanceof t)) return new t(r, n);
   for (Stream.call(this), this.path = r, this.fd = null, this.writable = !0, this.flags = "w", 
   this.encoding = "binary", this.mode = 438, this.bytesWritten = 0, n = n || {}, o = 0, 
   i = (s = Object.keys(n)).length; o < i; o++) this[a = s[o]] = n[a];
   if (void 0 !== this.start) {
    if ("number" != typeof this.start) throw TypeError("start must be a Number");
    if (this.start < 0) throw new Error("start must be >= zero");
    this.pos = this.start;
   }
   this.busy = !1, this._queue = [], null === this.fd && (this._open = e.open, this._queue.push([ this._open, this.path, this.flags, this.mode, void 0 ]), 
   this.flush());
  }
 };
}, clone_1 = function clone(e) {
 var t;
 return null === e || "object" != typeof e ? e : (t = e instanceof Object ? {
  __proto__: getPrototypeOf(e)
 } : Object.create(null), Object.getOwnPropertyNames(e).forEach((function(r) {
  Object.defineProperty(t, r, Object.getOwnPropertyDescriptor(e, r));
 })), t);
}, getPrototypeOf = Object.getPrototypeOf || function(e) {
 return e.__proto__;
}, gracefulFs = createCommonjsModule((function(e) {
 function t(e, t) {
  Object.defineProperty(e, i, {
   get: function() {
    return t;
   }
  });
 }
 function r(e) {
  function t(e, r) {
   return this instanceof t ? (h.apply(this, arguments), this) : t.apply(Object.create(t.prototype), arguments);
  }
  function s(e, t) {
   return this instanceof s ? (f.apply(this, arguments), this) : s.apply(Object.create(s.prototype), arguments);
  }
  function o(e, t, r, s) {
   return "function" == typeof r && (s = r, r = null), function e(t, r, s, o, i) {
    return y(t, r, s, (function(a, l) {
     !a || "EMFILE" !== a.code && "ENFILE" !== a.code ? "function" == typeof o && o.apply(this, arguments) : n([ e, [ t, r, s, o ], a, i || Date.now(), Date.now() ]);
    }));
   }(e, t, r, s);
  }
  var i, a, l, c, u, d, p, h, f, m, g, y;
  return polyfills(e), e.gracefulify = r, e.createReadStream = function w(t, r) {
   return new e.ReadStream(t, r);
  }, e.createWriteStream = function _(t, r) {
   return new e.WriteStream(t, r);
  }, i = e.readFile, e.readFile = function E(e, t, r) {
   return "function" == typeof t && (r = t, t = null), function e(t, r, s, o) {
    return i(t, r, (function(i) {
     !i || "EMFILE" !== i.code && "ENFILE" !== i.code ? "function" == typeof s && s.apply(this, arguments) : n([ e, [ t, r, s ], i, o || Date.now(), Date.now() ]);
    }));
   }(e, t, r);
  }, a = e.writeFile, e.writeFile = function v(e, t, r, s) {
   return "function" == typeof r && (s = r, r = null), function e(t, r, s, o, i) {
    return a(t, r, s, (function(a) {
     !a || "EMFILE" !== a.code && "ENFILE" !== a.code ? "function" == typeof o && o.apply(this, arguments) : n([ e, [ t, r, s, o ], a, i || Date.now(), Date.now() ]);
    }));
   }(e, t, r, s);
  }, (l = e.appendFile) && (e.appendFile = function b(e, t, r, s) {
   return "function" == typeof r && (s = r, r = null), function e(t, r, s, o, i) {
    return l(t, r, s, (function(a) {
     !a || "EMFILE" !== a.code && "ENFILE" !== a.code ? "function" == typeof o && o.apply(this, arguments) : n([ e, [ t, r, s, o ], a, i || Date.now(), Date.now() ]);
    }));
   }(e, t, r, s);
  }), (c = e.copyFile) && (e.copyFile = function T(e, t, r, s) {
   return "function" == typeof r && (s = r, r = 0), function e(t, r, s, o, i) {
    return c(t, r, s, (function(a) {
     !a || "EMFILE" !== a.code && "ENFILE" !== a.code ? "function" == typeof o && o.apply(this, arguments) : n([ e, [ t, r, s, o ], a, i || Date.now(), Date.now() ]);
    }));
   }(e, t, r, s);
  }), u = e.readdir, e.readdir = function S(e, t, r) {
   function s(e, t, r, s) {
    return function(i, a) {
     !i || "EMFILE" !== i.code && "ENFILE" !== i.code ? (a && a.sort && a.sort(), "function" == typeof r && r.call(this, i, a)) : n([ o, [ e, t, r ], i, s || Date.now(), Date.now() ]);
    };
   }
   "function" == typeof t && (r = t, t = null);
   var o = d.test(process.version) ? function e(t, r, n, o) {
    return u(t, s(t, r, n, o));
   } : function e(t, r, n, o) {
    return u(t, r, s(t, r, n, o));
   };
   return o(e, t, r);
  }, d = /^v[0-5]\./, "v0.8" === process.version.substr(0, 4) && (t = (p = legacyStreams(e)).ReadStream, 
  s = p.WriteStream), (h = e.ReadStream) && (t.prototype = Object.create(h.prototype), 
  t.prototype.open = function C() {
   var e = this;
   o(e.path, e.flags, e.mode, (function(t, r) {
    t ? (e.autoClose && e.destroy(), e.emit("error", t)) : (e.fd = r, e.emit("open", r), 
    e.read());
   }));
  }), (f = e.WriteStream) && (s.prototype = Object.create(f.prototype), s.prototype.open = function D() {
   var e = this;
   o(e.path, e.flags, e.mode, (function(t, r) {
    t ? (e.destroy(), e.emit("error", t)) : (e.fd = r, e.emit("open", r));
   }));
  }), Object.defineProperty(e, "ReadStream", {
   get: function() {
    return t;
   },
   set: function(e) {
    t = e;
   },
   enumerable: !0,
   configurable: !0
  }), Object.defineProperty(e, "WriteStream", {
   get: function() {
    return s;
   },
   set: function(e) {
    s = e;
   },
   enumerable: !0,
   configurable: !0
  }), m = t, Object.defineProperty(e, "FileReadStream", {
   get: function() {
    return m;
   },
   set: function(e) {
    m = e;
   },
   enumerable: !0,
   configurable: !0
  }), g = s, Object.defineProperty(e, "FileWriteStream", {
   get: function() {
    return g;
   },
   set: function(e) {
    g = e;
   },
   enumerable: !0,
   configurable: !0
  }), y = e.open, e.open = o, e;
 }
 function n(e) {
  l("ENQUEUE", e[0].name, e[1]), fs__default.default[i].push(e), o();
 }
 function s() {
  var e, t = Date.now();
  for (e = 0; e < fs__default.default[i].length; ++e) fs__default.default[i][e].length > 2 && (fs__default.default[i][e][3] = t, 
  fs__default.default[i][e][4] = t);
  o();
 }
 function o() {
  var e, t, r, n, s, a, c, d, p;
  clearTimeout(u), u = void 0, 0 !== fs__default.default[i].length && (t = (e = fs__default.default[i].shift())[0], 
  r = e[1], n = e[2], s = e[3], a = e[4], void 0 === s ? (l("RETRY", t.name, r), t.apply(null, r)) : Date.now() - s >= 6e4 ? (l("TIMEOUT", t.name, r), 
  "function" == typeof (c = r.pop()) && c.call(null, n)) : (d = Date.now() - a, p = Math.max(a - s, 1), 
  d >= Math.min(1.2 * p, 100) ? (l("RETRY", t.name, r), t.apply(null, r.concat([ s ]))) : fs__default.default[i].push(e)), 
  void 0 === u && (u = setTimeout(o, 0)));
 }
 var i, a, l, c, u;
 "function" == typeof Symbol && "function" == typeof Symbol.for ? (i = Symbol.for("graceful-fs.queue"), 
 a = Symbol.for("graceful-fs.previous")) : (i = "___graceful-fs.queue", a = "___graceful-fs.previous"), 
 l = function d() {}, util__default.default.debuglog ? l = util__default.default.debuglog("gfs4") : /\bgfs4\b/i.test("") && (l = function() {
  var e = util__default.default.format.apply(util__default.default, arguments);
  e = "GFS4: " + e.split(/\n/).join("\nGFS4: "), console.error(e);
 }), fs__default.default[i] || (c = commonjsGlobal[i] || [], t(fs__default.default, c), 
 fs__default.default.close = function(e) {
  function t(t, r) {
   return e.call(fs__default.default, t, (function(e) {
    e || s(), "function" == typeof r && r.apply(this, arguments);
   }));
  }
  return Object.defineProperty(t, a, {
   value: e
  }), t;
 }(fs__default.default.close), fs__default.default.closeSync = function(e) {
  function t(t) {
   e.apply(fs__default.default, arguments), s();
  }
  return Object.defineProperty(t, a, {
   value: e
  }), t;
 }(fs__default.default.closeSync), /\bgfs4\b/i.test("") && process.on("exit", (function() {
  l(fs__default.default[i]), assert__default.default.equal(fs__default.default[i].length, 0);
 }))), commonjsGlobal[i] || t(commonjsGlobal, fs__default.default[i]), e.exports = r(clone_1(fs__default.default)), 
 process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH && !fs__default.default.__patched && (e.exports = r(fs__default.default), 
 fs__default.default.__patched = !0);
})), symbols = createCommonjsModule((function(e) {
 const t = "undefined" != typeof process && "Hyper" === process.env.TERM_PROGRAM, r = "undefined" != typeof process && "win32" === process.platform, n = "undefined" != typeof process && "linux" === process.platform, s = {
  ballotDisabled: "☒",
  ballotOff: "☐",
  ballotOn: "☑",
  bullet: "•",
  bulletWhite: "◦",
  fullBlock: "█",
  heart: "❤",
  identicalTo: "≡",
  line: "─",
  mark: "※",
  middot: "·",
  minus: "－",
  multiplication: "×",
  obelus: "÷",
  pencilDownRight: "✎",
  pencilRight: "✏",
  pencilUpRight: "✐",
  percent: "%",
  pilcrow2: "❡",
  pilcrow: "¶",
  plusMinus: "±",
  question: "?",
  section: "§",
  starsOff: "☆",
  starsOn: "★",
  upDownArrow: "↕"
 }, o = Object.assign({}, s, {
  check: "√",
  cross: "×",
  ellipsisLarge: "...",
  ellipsis: "...",
  info: "i",
  questionSmall: "?",
  pointer: ">",
  pointerSmall: "»",
  radioOff: "( )",
  radioOn: "(*)",
  warning: "‼"
 }), i = Object.assign({}, s, {
  ballotCross: "✘",
  check: "✔",
  cross: "✖",
  ellipsisLarge: "⋯",
  ellipsis: "…",
  info: "ℹ",
  questionFull: "？",
  questionSmall: "﹖",
  pointer: n ? "▸" : "❯",
  pointerSmall: n ? "‣" : "›",
  radioOff: "◯",
  radioOn: "◉",
  warning: "⚠"
 });
 e.exports = r && !t ? o : i, Reflect.defineProperty(e.exports, "common", {
  enumerable: !1,
  value: s
 }), Reflect.defineProperty(e.exports, "windows", {
  enumerable: !1,
  value: o
 }), Reflect.defineProperty(e.exports, "other", {
  enumerable: !1,
  value: i
 });
}));

const ANSI_REGEX = /[\u001b\u009b][[\]#;?()]*(?:(?:(?:[^\W_]*;?[^\W_]*)\u0007)|(?:(?:[0-9]{1,4}(;[0-9]{0,4})*)?[~0-9=<>cf-nqrtyA-PRZ]))/g, create = () => {
 const e = {
  enabled: "undefined" != typeof process && "0" !== process.env.FORCE_COLOR,
  visible: !0,
  styles: {},
  keys: {}
 }, t = (e, t, r) => "function" == typeof e ? e(t) : e.wrap(t, r), r = (r, n) => {
  if ("" === r || null == r) return "";
  if (!1 === e.enabled) return r;
  if (!1 === e.visible) return "";
  let s = "" + r, o = s.includes("\n"), i = n.length;
  for (i > 0 && n.includes("unstyle") && (n = [ ...new Set([ "unstyle", ...n ]) ].reverse()); i-- > 0; ) s = t(e.styles[n[i]], s, o);
  return s;
 }, n = (t, n, s) => {
  e.styles[t] = (e => {
   let t = e.open = `[${e.codes[0]}m`, r = e.close = `[${e.codes[1]}m`, n = e.regex = new RegExp(`\\u001b\\[${e.codes[1]}m`, "g");
   return e.wrap = (e, s) => {
    e.includes(r) && (e = e.replace(n, r + t));
    let o = t + e + r;
    return s ? o.replace(/\r*\n/g, `${r}$&${t}`) : o;
   }, e;
  })({
   name: t,
   codes: n
  }), (e.keys[s] || (e.keys[s] = [])).push(t), Reflect.defineProperty(e, t, {
   configurable: !0,
   enumerable: !0,
   set(r) {
    e.alias(t, r);
   },
   get() {
    let n = e => r(e, n.stack);
    return Reflect.setPrototypeOf(n, e), n.stack = this.stack ? this.stack.concat(t) : [ t ], 
    n;
   }
  });
 };
 return n("reset", [ 0, 0 ], "modifier"), n("bold", [ 1, 22 ], "modifier"), n("dim", [ 2, 22 ], "modifier"), 
 n("italic", [ 3, 23 ], "modifier"), n("underline", [ 4, 24 ], "modifier"), n("inverse", [ 7, 27 ], "modifier"), 
 n("hidden", [ 8, 28 ], "modifier"), n("strikethrough", [ 9, 29 ], "modifier"), n("black", [ 30, 39 ], "color"), 
 n("red", [ 31, 39 ], "color"), n("green", [ 32, 39 ], "color"), n("yellow", [ 33, 39 ], "color"), 
 n("blue", [ 34, 39 ], "color"), n("magenta", [ 35, 39 ], "color"), n("cyan", [ 36, 39 ], "color"), 
 n("white", [ 37, 39 ], "color"), n("gray", [ 90, 39 ], "color"), n("grey", [ 90, 39 ], "color"), 
 n("bgBlack", [ 40, 49 ], "bg"), n("bgRed", [ 41, 49 ], "bg"), n("bgGreen", [ 42, 49 ], "bg"), 
 n("bgYellow", [ 43, 49 ], "bg"), n("bgBlue", [ 44, 49 ], "bg"), n("bgMagenta", [ 45, 49 ], "bg"), 
 n("bgCyan", [ 46, 49 ], "bg"), n("bgWhite", [ 47, 49 ], "bg"), n("blackBright", [ 90, 39 ], "bright"), 
 n("redBright", [ 91, 39 ], "bright"), n("greenBright", [ 92, 39 ], "bright"), n("yellowBright", [ 93, 39 ], "bright"), 
 n("blueBright", [ 94, 39 ], "bright"), n("magentaBright", [ 95, 39 ], "bright"), 
 n("cyanBright", [ 96, 39 ], "bright"), n("whiteBright", [ 97, 39 ], "bright"), n("bgBlackBright", [ 100, 49 ], "bgBright"), 
 n("bgRedBright", [ 101, 49 ], "bgBright"), n("bgGreenBright", [ 102, 49 ], "bgBright"), 
 n("bgYellowBright", [ 103, 49 ], "bgBright"), n("bgBlueBright", [ 104, 49 ], "bgBright"), 
 n("bgMagentaBright", [ 105, 49 ], "bgBright"), n("bgCyanBright", [ 106, 49 ], "bgBright"), 
 n("bgWhiteBright", [ 107, 49 ], "bgBright"), e.ansiRegex = ANSI_REGEX, e.hasColor = e.hasAnsi = t => (e.ansiRegex.lastIndex = 0, 
 "string" == typeof t && "" !== t && e.ansiRegex.test(t)), e.alias = (t, n) => {
  let s = "string" == typeof n ? e[n] : n;
  if ("function" != typeof s) throw new TypeError("Expected alias to be the name of an existing color (string) or a function");
  s.stack || (Reflect.defineProperty(s, "name", {
   value: t
  }), e.styles[t] = s, s.stack = [ t ]), Reflect.defineProperty(e, t, {
   configurable: !0,
   enumerable: !0,
   set(r) {
    e.alias(t, r);
   },
   get() {
    let t = e => r(e, t.stack);
    return Reflect.setPrototypeOf(t, e), t.stack = this.stack ? this.stack.concat(s.stack) : s.stack, 
    t;
   }
  });
 }, e.theme = t => {
  if (null === (r = t) || "object" != typeof r || Array.isArray(r)) throw new TypeError("Expected theme to be an object");
  var r;
  for (let r of Object.keys(t)) e.alias(r, t[r]);
  return e;
 }, e.alias("unstyle", (t => "string" == typeof t && "" !== t ? (e.ansiRegex.lastIndex = 0, 
 t.replace(e.ansiRegex, "")) : "")), e.alias("noop", (e => e)), e.none = e.clear = e.noop, 
 e.stripColor = e.unstyle, e.symbols = symbols, e.define = n, e;
};

ansiColors = create(), create_1 = create, ansiColors.create = create_1;

const LOG_LEVELS = [ "debug", "info", "warn", "error" ], createTerminalLogger = e => {
 let t = "info", r = null;
 const n = [], s = e => {
  if (e.length > 0) {
   const t = formatPrefixTimestamp();
   e[0] = ansiColors.dim(t) + e[0].slice(t.length);
  }
 }, o = e => {
  if (e.length) {
   const t = "[ WARN  ]";
   e[0] = ansiColors.bold(ansiColors.yellow(t)) + e[0].slice(t.length);
  }
 }, i = e => {
  if (e.length) {
   const t = "[ ERROR ]";
   e[0] = ansiColors.bold(ansiColors.red(t)) + e[0].slice(t.length);
  }
 }, a = e => {
  if (e.length) {
   const t = formatPrefixTimestamp();
   e[0] = ansiColors.cyan(t) + e[0].slice(t.length);
  }
 }, l = t => {
  const r = e.memoryUsage();
  r > 0 && t.push(ansiColors.dim(` MEM: ${(r / 1e6).toFixed(1)}MB`));
 }, c = (t, s) => {
  if (r) {
   const r = new Date, o = ("0" + r.getHours()).slice(-2) + ":" + ("0" + r.getMinutes()).slice(-2) + ":" + ("0" + r.getSeconds()).slice(-2) + ".0" + Math.floor(r.getMilliseconds() / 1e3 * 10) + "  " + ("000" + (e.memoryUsage() / 1e6).toFixed(1)).slice(-6) + "MB  " + t + "  " + s.join(", ");
   n.push(o);
  }
 }, u = (t, r, n) => {
  let s = t.length - r + n - 1;
  for (;t.length + INDENT.length > e.getColumns(); ) if (r > t.length - r + n && r > 5) t = t.slice(1), 
  r--; else {
   if (!(s > 1)) break;
   t = t.slice(0, -1), s--;
  }
  const o = [], i = Math.max(t.length, r + n);
  for (let e = 0; e < i; e++) {
   let s = t.charAt(e);
   e >= r && e < r + n && (s = ansiColors.bgRed("" === s ? " " : s)), o.push(s);
  }
  return o.join("");
 }, d = e => e.trim().startsWith("//") ? ansiColors.dim(e) : e.split(" ").map((e => JS_KEYWORDS.indexOf(e) > -1 ? ansiColors.cyan(e) : e)).join(" "), p = e => {
  let t = !0;
  const r = [];
  for (let n = 0; n < e.length; n++) {
   const s = e.charAt(n);
   ";" === s || "{" === s ? t = !0 : ".#,:}@$[]/*".indexOf(s) > -1 && (t = !1), t && "abcdefghijklmnopqrstuvwxyz-_".indexOf(s.toLowerCase()) > -1 ? r.push(ansiColors.cyan(s)) : r.push(s);
  }
  return r.join("");
 }, h = {
  createLineUpdater: e.createLineUpdater,
  createTimeSpan: (r, n = !1, o) => {
   const i = Date.now(), u = () => Date.now() - i, d = {
    duration: u,
    finish: (r, i, d, p) => {
     const h = u();
     let f;
     return f = h > 1e3 ? "in " + (h / 1e3).toFixed(2) + " s" : parseFloat(h.toFixed(3)) > 0 ? "in " + h + " ms" : "in less than 1 ms", 
     ((r, n, o, i, u, d, p) => {
      let h = r;
      if (o && (h = ansiColors[o](r)), i && (h = ansiColors.bold(h)), h += " " + ansiColors.dim(n), 
      d) {
       if (shouldLog(t, "debug")) {
        const t = [ h ];
        l(t);
        const r = wordWrap(t, e.getColumns());
        a(r), console.log(r.join("\n"));
       }
       c("D", [ `${r} ${n}` ]);
      } else {
       const t = wordWrap([ h ], e.getColumns());
       s(t), console.log(t.join("\n")), c("I", [ `${r} ${n}` ]), p && p.push(`${r} ${n}`);
      }
      u && console.log("");
     })(r, f, i, d, p, n, o), h;
    }
   };
   return ((r, n, o) => {
    const i = [ `${r} ${ansiColors.dim("...")}` ];
    if (n) {
     if (shouldLog(t, "debug")) {
      l(i);
      const t = wordWrap(i, e.getColumns());
      a(t), console.log(t.join("\n")), c("D", [ `${r} ...` ]);
     }
    } else {
     const t = wordWrap(i, e.getColumns());
     s(t), console.log(t.join("\n")), c("I", [ `${r} ...` ]), o && o.push(`${r} ...`);
    }
   })(r, n, o), d;
  },
  debug: (...r) => {
   if (shouldLog(t, "debug")) {
    l(r);
    const t = wordWrap(r, e.getColumns());
    a(t), console.log(t.join("\n"));
   }
   c("D", r);
  },
  emoji: e.emoji,
  enableColors: e => {
   ansiColors.enabled = e;
  },
  error: (...r) => {
   for (let e = 0; e < r.length; e++) if (r[e] instanceof Error) {
    const t = r[e];
    r[e] = t.message, t.stack && (r[e] += "\n" + t.stack);
   }
   if (shouldLog(t, "error")) {
    const t = wordWrap(r, e.getColumns());
    i(t), console.error("\n" + t.join("\n") + "\n");
   }
   c("E", r);
  },
  getLevel: () => t,
  info: (...r) => {
   if (shouldLog(t, "info")) {
    const t = wordWrap(r, e.getColumns());
    s(t), console.log(t.join("\n"));
   }
   c("I", r);
  },
  printDiagnostics: (r, n) => {
   if (!r || 0 === r.length) return;
   let l = [ "" ];
   r.forEach((r => {
    l = l.concat(((r, n) => {
     const l = wordWrap([ r.messageText ], e.getColumns());
     let c = "";
     r.header && "Build Error" !== r.header && (c += r.header), "string" == typeof r.absFilePath && "string" != typeof r.relFilePath && ("string" != typeof n && (n = e.cwd()), 
     r.relFilePath = e.relativePath(n, r.absFilePath), r.relFilePath.includes("/") || (r.relFilePath = "./" + r.relFilePath));
     let h = r.relFilePath;
     return "string" != typeof h && (h = r.absFilePath), "string" == typeof h && (c.length > 0 && (c += ": "), 
     c += ansiColors.cyan(h), "number" == typeof r.lineNumber && r.lineNumber > -1 && (c += ansiColors.dim(":"), 
     c += ansiColors.yellow(`${r.lineNumber}`), "number" == typeof r.columnNumber && r.columnNumber > -1 && (c += ansiColors.dim(":"), 
     c += ansiColors.yellow(`${r.columnNumber}`)))), c.length > 0 && l.unshift(INDENT + c), 
     l.push(""), r.lines && r.lines.length && (removeLeadingWhitespace(r.lines).forEach((e => {
      if (!isMeaningfulLine(e.text)) return;
      let t = "";
      for (e.lineNumber > -1 && (t = `L${e.lineNumber}:  `); t.length < INDENT.length; ) t = " " + t;
      let n = e.text;
      e.errorCharStart > -1 && (n = u(n, e.errorCharStart, e.errorLength)), t = ansiColors.dim(t), 
      "typescript" === r.language || "javascript" === r.language ? t += d(n) : "scss" === r.language || "css" === r.language ? t += p(n) : t += n, 
      l.push(t);
     })), l.push("")), "error" === r.level ? i(l) : "warn" === r.level ? o(l) : "debug" === r.level ? a(l) : s(l), 
     null != r.debugText && "debug" === t && (l.push(r.debugText), a(wordWrap([ r.debugText ], e.getColumns()))), 
     l;
    })(r, n));
   })), console.log(l.join("\n"));
  },
  setLevel: e => t = e,
  setLogFilePath: e => r = e,
  warn: (...r) => {
   if (shouldLog(t, "warn")) {
    const t = wordWrap(r, e.getColumns());
    o(t), console.warn("\n" + t.join("\n") + "\n");
   }
   c("W", r);
  },
  writeLogs: t => {
   if (r) try {
    c("F", [ "--------------------------------------" ]), e.writeLogs(r, n.join("\n"), t);
   } catch (e) {}
   n.length = 0;
  },
  bgRed: ansiColors.bgRed,
  blue: ansiColors.blue,
  bold: ansiColors.bold,
  cyan: ansiColors.cyan,
  dim: ansiColors.dim,
  gray: ansiColors.gray,
  green: ansiColors.green,
  magenta: ansiColors.magenta,
  red: ansiColors.red,
  yellow: ansiColors.yellow
 };
 return h;
}, shouldLog = (e, t) => LOG_LEVELS.indexOf(t) >= LOG_LEVELS.indexOf(e), formatPrefixTimestamp = () => {
 const e = new Date;
 return `[${clampTwoDigits(e.getMinutes())}:${clampTwoDigits(e.getSeconds())}.${Math.floor(e.getMilliseconds() / 1e3 * 10)}]`;
}, clampTwoDigits = e => ("0" + e.toString()).slice(-2), wordWrap = (e, t) => {
 const r = [], n = [];
 e.forEach((e => {
  null === e ? n.push("null") : void 0 === e ? n.push("undefined") : "string" == typeof e ? e.replace(/\s/gm, " ").split(" ").forEach((e => {
   e.trim().length && n.push(e.trim());
  })) : "number" == typeof e || "boolean" == typeof e || "function" == typeof e ? n.push(e.toString()) : Array.isArray(e) || Object(e) === e ? n.push((() => e.toString())) : n.push(e.toString());
 }));
 let s = INDENT;
 return n.forEach((e => {
  r.length > 25 || ("function" == typeof e ? (s.trim().length && r.push(s), r.push(e()), 
  s = INDENT) : INDENT.length + e.length > t - 1 ? (s.trim().length && r.push(s), 
  r.push(INDENT + e), s = INDENT) : e.length + s.length > t - 1 ? (r.push(s), s = INDENT + e + " ") : s += e + " ");
 })), s.trim().length && r.push(s), r.map((e => e.trimRight()));
}, removeLeadingWhitespace = e => {
 const t = JSON.parse(JSON.stringify(e));
 for (let e = 0; e < 100; e++) {
  if (!eachLineHasLeadingWhitespace(t)) return t;
  for (let e = 0; e < t.length; e++) if (t[e].text = t[e].text.slice(1), t[e].errorCharStart--, 
  !t[e].text.length) return t;
 }
 return t;
}, eachLineHasLeadingWhitespace = e => {
 if (!e.length) return !1;
 for (let t = 0; t < e.length; t++) {
  if (!e[t].text || e[t].text.length < 1) return !1;
  const r = e[t].text.charAt(0);
  if (" " !== r && "\t" !== r) return !1;
 }
 return !0;
}, isMeaningfulLine = e => !!e && (e = e.trim()).length > 0, JS_KEYWORDS = [ "abstract", "any", "as", "break", "boolean", "case", "catch", "class", "console", "const", "continue", "debugger", "declare", "default", "delete", "do", "else", "enum", "export", "extends", "false", "finally", "for", "from", "function", "get", "if", "import", "in", "implements", "Infinity", "instanceof", "let", "module", "namespace", "NaN", "new", "number", "null", "public", "private", "protected", "require", "return", "static", "set", "string", "super", "switch", "this", "throw", "try", "true", "type", "typeof", "undefined", "var", "void", "with", "while", "yield" ], INDENT = "           ";

caller = function() {
 var e, t = Error.prepareStackTrace;
 return Error.prepareStackTrace = function(e, t) {
  return t;
 }, e = (new Error).stack, Error.prepareStackTrace = t, e[2].getFileName();
}, pathParse = createCommonjsModule((function(e) {
 var t, r, n = "win32" === process.platform, s = /^(((?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?[\\\/]?)(?:[^\\\/]*[\\\/])*)((\.{1,2}|[^\\\/]+?|)(\.[^.\/\\]*|))[\\\/]*$/, o = {
  parse: function(e) {
   if ("string" != typeof e) throw new TypeError("Parameter 'pathString' must be a string, not " + typeof e);
   var t = function r(e) {
    return s.exec(e).slice(1);
   }(e);
   if (!t || 5 !== t.length) throw new TypeError("Invalid path '" + e + "'");
   return {
    root: t[1],
    dir: t[0] === t[1] ? t[0] : t[0].slice(0, -1),
    base: t[2],
    ext: t[4],
    name: t[3]
   };
  }
 };
 t = /^((\/?)(?:[^\/]*\/)*)((\.{1,2}|[^\/]+?|)(\.[^.\/]*|))[\/]*$/, (r = {}).parse = function(e) {
  if ("string" != typeof e) throw new TypeError("Parameter 'pathString' must be a string, not " + typeof e);
  var r = function n(e) {
   return t.exec(e).slice(1);
  }(e);
  if (!r || 5 !== r.length) throw new TypeError("Invalid path '" + e + "'");
  return {
   root: r[1],
   dir: r[0].slice(0, -1),
   base: r[2],
   ext: r[4],
   name: r[3]
  };
 }, e.exports = n ? o.parse : r.parse, e.exports.posix = r.parse, e.exports.win32 = o.parse;
})), parse = path__default.default.parse || pathParse, getNodeModulesDirs = function e(t, r) {
 var n, s, o = "/";
 for (/^([A-Za-z]:)/.test(t) ? o = "" : /^\\\\/.test(t) && (o = "\\\\"), n = [ t ], 
 s = parse(t); s.dir !== n[n.length - 1]; ) n.push(s.dir), s = parse(s.dir);
 return n.reduce((function(e, t) {
  return e.concat(r.map((function(e) {
   return path__default.default.resolve(o, t, e);
  })));
 }), []);
}, nodeModulesPaths = function e(t, r, n) {
 var s, o = r && r.moduleDirectory ? [].concat(r.moduleDirectory) : [ "node_modules" ];
 return r && "function" == typeof r.paths ? r.paths(n, t, (function() {
  return getNodeModulesDirs(t, o);
 }), r) : (s = getNodeModulesDirs(t, o), r && r.paths ? s.concat(r.paths) : s);
}, normalizeOptions = function(e, t) {
 return t || {};
}, slice = Array.prototype.slice, toStr = Object.prototype.toString, implementation = function e(t) {
 var r, n, s, o, i, a, l, c = this;
 if ("function" != typeof c || "[object Function]" !== toStr.call(c)) throw new TypeError("Function.prototype.bind called on incompatible " + c);
 for (r = slice.call(arguments, 1), s = function() {
  if (this instanceof n) {
   var e = c.apply(this, r.concat(slice.call(arguments)));
   return Object(e) === e ? e : this;
  }
  return c.apply(t, r.concat(slice.call(arguments)));
 }, o = Math.max(0, c.length - r.length), i = [], a = 0; a < o; a++) i.push("$" + a);
 return n = Function("binder", "return function (" + i.join(",") + "){ return binder.apply(this,arguments); }")(s), 
 c.prototype && ((l = function e() {}).prototype = c.prototype, n.prototype = new l, 
 l.prototype = null), n;
}, functionBind = Function.prototype.bind || implementation, src = functionBind.call(Function.call, Object.prototype.hasOwnProperty);

const data$1 = {
 assert: !0,
 "node:assert": [ ">= 14.18 && < 15", ">= 16" ],
 "assert/strict": ">= 15",
 "node:assert/strict": ">= 16",
 async_hooks: ">= 8",
 "node:async_hooks": [ ">= 14.18 && < 15", ">= 16" ],
 buffer_ieee754: ">= 0.5 && < 0.9.7",
 buffer: !0,
 "node:buffer": [ ">= 14.18 && < 15", ">= 16" ],
 child_process: !0,
 "node:child_process": [ ">= 14.18 && < 15", ">= 16" ],
 cluster: ">= 0.5",
 "node:cluster": [ ">= 14.18 && < 15", ">= 16" ],
 console: !0,
 "node:console": [ ">= 14.18 && < 15", ">= 16" ],
 constants: !0,
 "node:constants": [ ">= 14.18 && < 15", ">= 16" ],
 crypto: !0,
 "node:crypto": [ ">= 14.18 && < 15", ">= 16" ],
 _debug_agent: ">= 1 && < 8",
 _debugger: "< 8",
 dgram: !0,
 "node:dgram": [ ">= 14.18 && < 15", ">= 16" ],
 diagnostics_channel: [ ">= 14.17 && < 15", ">= 15.1" ],
 "node:diagnostics_channel": [ ">= 14.18 && < 15", ">= 16" ],
 dns: !0,
 "node:dns": [ ">= 14.18 && < 15", ">= 16" ],
 "dns/promises": ">= 15",
 "node:dns/promises": ">= 16",
 domain: ">= 0.7.12",
 "node:domain": [ ">= 14.18 && < 15", ">= 16" ],
 events: !0,
 "node:events": [ ">= 14.18 && < 15", ">= 16" ],
 freelist: "< 6",
 fs: !0,
 "node:fs": [ ">= 14.18 && < 15", ">= 16" ],
 "fs/promises": [ ">= 10 && < 10.1", ">= 14" ],
 "node:fs/promises": [ ">= 14.18 && < 15", ">= 16" ],
 _http_agent: ">= 0.11.1",
 "node:_http_agent": [ ">= 14.18 && < 15", ">= 16" ],
 _http_client: ">= 0.11.1",
 "node:_http_client": [ ">= 14.18 && < 15", ">= 16" ],
 _http_common: ">= 0.11.1",
 "node:_http_common": [ ">= 14.18 && < 15", ">= 16" ],
 _http_incoming: ">= 0.11.1",
 "node:_http_incoming": [ ">= 14.18 && < 15", ">= 16" ],
 _http_outgoing: ">= 0.11.1",
 "node:_http_outgoing": [ ">= 14.18 && < 15", ">= 16" ],
 _http_server: ">= 0.11.1",
 "node:_http_server": [ ">= 14.18 && < 15", ">= 16" ],
 http: !0,
 "node:http": [ ">= 14.18 && < 15", ">= 16" ],
 http2: ">= 8.8",
 "node:http2": [ ">= 14.18 && < 15", ">= 16" ],
 https: !0,
 "node:https": [ ">= 14.18 && < 15", ">= 16" ],
 inspector: ">= 8",
 "node:inspector": [ ">= 14.18 && < 15", ">= 16" ],
 "inspector/promises": [ ">= 19" ],
 "node:inspector/promises": [ ">= 19" ],
 _linklist: "< 8",
 module: !0,
 "node:module": [ ">= 14.18 && < 15", ">= 16" ],
 net: !0,
 "node:net": [ ">= 14.18 && < 15", ">= 16" ],
 "node-inspect/lib/_inspect": ">= 7.6 && < 12",
 "node-inspect/lib/internal/inspect_client": ">= 7.6 && < 12",
 "node-inspect/lib/internal/inspect_repl": ">= 7.6 && < 12",
 os: !0,
 "node:os": [ ">= 14.18 && < 15", ">= 16" ],
 path: !0,
 "node:path": [ ">= 14.18 && < 15", ">= 16" ],
 "path/posix": ">= 15.3",
 "node:path/posix": ">= 16",
 "path/win32": ">= 15.3",
 "node:path/win32": ">= 16",
 perf_hooks: ">= 8.5",
 "node:perf_hooks": [ ">= 14.18 && < 15", ">= 16" ],
 process: ">= 1",
 "node:process": [ ">= 14.18 && < 15", ">= 16" ],
 punycode: ">= 0.5",
 "node:punycode": [ ">= 14.18 && < 15", ">= 16" ],
 querystring: !0,
 "node:querystring": [ ">= 14.18 && < 15", ">= 16" ],
 readline: !0,
 "node:readline": [ ">= 14.18 && < 15", ">= 16" ],
 "readline/promises": ">= 17",
 "node:readline/promises": ">= 17",
 repl: !0,
 "node:repl": [ ">= 14.18 && < 15", ">= 16" ],
 smalloc: ">= 0.11.5 && < 3",
 _stream_duplex: ">= 0.9.4",
 "node:_stream_duplex": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_transform: ">= 0.9.4",
 "node:_stream_transform": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_wrap: ">= 1.4.1",
 "node:_stream_wrap": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_passthrough: ">= 0.9.4",
 "node:_stream_passthrough": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_readable: ">= 0.9.4",
 "node:_stream_readable": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_writable: ">= 0.9.4",
 "node:_stream_writable": [ ">= 14.18 && < 15", ">= 16" ],
 stream: !0,
 "node:stream": [ ">= 14.18 && < 15", ">= 16" ],
 "stream/consumers": ">= 16.7",
 "node:stream/consumers": ">= 16.7",
 "stream/promises": ">= 15",
 "node:stream/promises": ">= 16",
 "stream/web": ">= 16.5",
 "node:stream/web": ">= 16.5",
 string_decoder: !0,
 "node:string_decoder": [ ">= 14.18 && < 15", ">= 16" ],
 sys: [ ">= 0.4 && < 0.7", ">= 0.8" ],
 "node:sys": [ ">= 14.18 && < 15", ">= 16" ],
 "test/reporters": ">= 19.9 && < 20.2",
 "node:test/reporters": [ ">= 19.9", ">= 20" ],
 "node:test": [ ">= 16.17 && < 17", ">= 18" ],
 timers: !0,
 "node:timers": [ ">= 14.18 && < 15", ">= 16" ],
 "timers/promises": ">= 15",
 "node:timers/promises": ">= 16",
 _tls_common: ">= 0.11.13",
 "node:_tls_common": [ ">= 14.18 && < 15", ">= 16" ],
 _tls_legacy: ">= 0.11.3 && < 10",
 _tls_wrap: ">= 0.11.3",
 "node:_tls_wrap": [ ">= 14.18 && < 15", ">= 16" ],
 tls: !0,
 "node:tls": [ ">= 14.18 && < 15", ">= 16" ],
 trace_events: ">= 10",
 "node:trace_events": [ ">= 14.18 && < 15", ">= 16" ],
 tty: !0,
 "node:tty": [ ">= 14.18 && < 15", ">= 16" ],
 url: !0,
 "node:url": [ ">= 14.18 && < 15", ">= 16" ],
 util: !0,
 "node:util": [ ">= 14.18 && < 15", ">= 16" ],
 "util/types": ">= 15.3",
 "node:util/types": ">= 16",
 "v8/tools/arguments": ">= 10 && < 12",
 "v8/tools/codemap": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/consarray": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/csvparser": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/logreader": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/profile_view": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/splaytree": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 v8: ">= 1",
 "node:v8": [ ">= 14.18 && < 15", ">= 16" ],
 vm: !0,
 "node:vm": [ ">= 14.18 && < 15", ">= 16" ],
 wasi: [ ">= 13.4 && < 13.5", ">= 20" ],
 "node:wasi": ">= 20",
 worker_threads: ">= 11.7",
 "node:worker_threads": [ ">= 14.18 && < 15", ">= 16" ],
 zlib: ">= 0.5",
 "node:zlib": [ ">= 14.18 && < 15", ">= 16" ]
};

isCoreModule = function e(t, r) {
 return src(data$1, t) && function n(e, t) {
  var r, n;
  if ("boolean" == typeof t) return t;
  if ("string" != typeof (r = void 0 === e ? process.versions && process.versions.node : e)) throw new TypeError(void 0 === e ? "Unable to determine current node version" : "If provided, a valid node version is required");
  if (t && "object" == typeof t) {
   for (n = 0; n < t.length; ++n) if (matchesRange$1(r, t[n])) return !0;
   return !1;
  }
  return matchesRange$1(r, t);
 }(r, data$1[t]);
}, realpathFS$1 = fs__default.default.realpath && "function" == typeof fs__default.default.realpath.native ? fs__default.default.realpath.native : fs__default.default.realpath, 
defaultIsFile$1 = function e(t, r) {
 fs__default.default.stat(t, (function(e, t) {
  return e ? "ENOENT" === e.code || "ENOTDIR" === e.code ? r(null, !1) : r(e) : r(null, t.isFile() || t.isFIFO());
 }));
}, defaultIsDir$1 = function e(t, r) {
 fs__default.default.stat(t, (function(e, t) {
  return e ? "ENOENT" === e.code || "ENOTDIR" === e.code ? r(null, !1) : r(e) : r(null, t.isDirectory());
 }));
}, defaultRealpath = function e(t, r) {
 realpathFS$1(t, (function(e, n) {
  e && "ENOENT" !== e.code ? r(e) : r(null, e ? t : n);
 }));
}, maybeRealpath = function e(t, r, n, s) {
 n && !1 === n.preserveSymlinks ? t(r, s) : s(null, r);
}, defaultReadPackage = function e(t, r, n) {
 t(r, (function(e, t) {
  if (e) n(e); else try {
   var r = JSON.parse(t);
   n(null, r);
  } catch (e) {
   n(null);
  }
 }));
}, getPackageCandidates$1 = function e(t, r, n) {
 var s, o = nodeModulesPaths(r, n, t);
 for (s = 0; s < o.length; s++) o[s] = path__default.default.join(o[s], t);
 return o;
}, async = function e(t, r, n) {
 function s(e) {
  if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(t)) T = path__default.default.resolve(e, t), 
  "." !== t && ".." !== t && "/" !== t.slice(-1) || (T += "/"), /\/$/.test(t) && T === e ? l(T, C.package, o) : i(T, C.package, o); else {
   if (_ && isCoreModule(t)) return S(null, t);
   !function r(e, t, n) {
    var s = function() {
     return getPackageCandidates$1(e, t, C);
    };
    c(n, y ? y(e, t, s, C) : s());
   }(t, e, (function(e, r, n) {
    if (e) S(e); else {
     if (r) return maybeRealpath(f, r, C, (function(e, t) {
      e ? S(e) : S(null, t, n);
     }));
     var s = new Error("Cannot find module '" + t + "' from '" + v + "'");
     s.code = "MODULE_NOT_FOUND", S(s);
    }
   }));
  }
 }
 function o(e, r, n) {
  e ? S(e) : r ? S(null, r, n) : l(T, (function(e, r, n) {
   if (e) S(e); else if (r) maybeRealpath(f, r, C, (function(e, t) {
    e ? S(e) : S(null, t, n);
   })); else {
    var s = new Error("Cannot find module '" + t + "' from '" + v + "'");
    s.code = "MODULE_NOT_FOUND", S(s);
   }
  }));
 }
 function i(e, t, r) {
  var n = t, s = r;
  "function" == typeof n && (s = n, n = void 0), function e(t, r, n) {
   function o(n, o, a) {
    var u, p, h;
    return c = o, n ? s(n) : a && c && C.pathFilter && (p = (u = path__default.default.relative(a, l)).slice(0, u.length - t[0].length), 
    h = C.pathFilter(c, r, p)) ? e([ "" ].concat(w.slice()), path__default.default.resolve(a, h), c) : void d(l, i);
   }
   function i(n, o) {
    return n ? s(n) : o ? s(null, l, c) : void e(t.slice(1), r, c);
   }
   var l, c;
   if (0 === t.length) return s(null, void 0, n);
   l = r + t[0], (c = n) ? o(null, c) : a(path__default.default.dirname(l), o);
  }([ "" ].concat(w), e, n);
 }
 function a(e, t) {
  return "" === e || "/" === e || "win32" === process.platform && /^\w:[/\\]*$/.test(e) || /[/\\]node_modules[/\\]*$/.test(e) ? t(null) : void maybeRealpath(f, e, C, (function(r, n) {
   if (r) return a(path__default.default.dirname(e), t);
   var s = path__default.default.join(n, "package.json");
   d(s, (function(r, n) {
    if (!n) return a(path__default.default.dirname(e), t);
    m(h, s, (function(r, n) {
     r && t(r);
     var o = n;
     o && C.packageFilter && (o = C.packageFilter(o, s)), t(null, o, e);
    }));
   }));
  }));
 }
 function l(e, t, r) {
  var n = r, s = t;
  "function" == typeof s && (n = s, s = C.package), maybeRealpath(f, e, C, (function(t, r) {
   if (t) return n(t);
   var o = path__default.default.join(r, "package.json");
   d(o, (function(t, r) {
    return t ? n(t) : r ? void m(h, o, (function(t, r) {
     var s, a;
     return t ? n(t) : ((s = r) && C.packageFilter && (s = C.packageFilter(s, o)), s && s.main ? "string" != typeof s.main ? ((a = new TypeError("package “" + s.name + "” `main` must be a string")).code = "INVALID_PACKAGE_MAIN", 
     n(a)) : ("." !== s.main && "./" !== s.main || (s.main = "index"), void i(path__default.default.resolve(e, s.main), s, (function(t, r, s) {
      return t ? n(t) : r ? n(null, r, s) : s ? void l(path__default.default.resolve(e, s.main), s, (function(t, r, s) {
       return t ? n(t) : r ? n(null, r, s) : void i(path__default.default.join(e, "index"), s, n);
      })) : i(path__default.default.join(e, "index"), s, n);
     }))) : void i(path__default.default.join(e, "/index"), s, n));
    })) : i(path__default.default.join(e, "index"), s, n);
   }));
  }));
 }
 function c(e, t) {
  function r(t, r, o) {
   return t ? e(t) : r ? e(null, r, o) : void l(s, C.package, n);
  }
  function n(r, n, s) {
   return r ? e(r) : n ? e(null, n, s) : void c(e, t.slice(1));
  }
  if (0 === t.length) return e(null, void 0);
  var s = t[0];
  p(path__default.default.dirname(s), (function o(n, a) {
   return n ? e(n) : a ? void i(s, C.package, r) : c(e, t.slice(1));
  }));
 }
 var u, d, p, h, f, m, g, y, w, _, E, v, b, T, S = n, C = r;
 return "function" == typeof r && (S = C, C = {}), "string" != typeof t ? (u = new TypeError("Path must be a string."), 
 process.nextTick((function() {
  S(u);
 }))) : (C = normalizeOptions(0, C), d = C.isFile || defaultIsFile$1, p = C.isDirectory || defaultIsDir$1, 
 h = C.readFile || fs__default.default.readFile, f = C.realpath || defaultRealpath, 
 m = C.readPackage || defaultReadPackage, C.readFile && C.readPackage ? (g = new TypeError("`readFile` and `readPackage` are mutually exclusive."), 
 process.nextTick((function() {
  S(g);
 }))) : (y = C.packageIterator, w = C.extensions || [ ".js" ], _ = !1 !== C.includeCoreModules, 
 E = C.basedir || path__default.default.dirname(caller()), v = C.filename || E, C.paths = C.paths || [], 
 b = path__default.default.resolve(E), void maybeRealpath(f, b, C, (function(e, t) {
  e ? S(e) : s(t);
 }))));
};

const data = {
 assert: !0,
 "assert/strict": ">= 15",
 async_hooks: ">= 8",
 buffer_ieee754: "< 0.9.7",
 buffer: !0,
 child_process: !0,
 cluster: !0,
 console: !0,
 constants: !0,
 crypto: !0,
 _debug_agent: ">= 1 && < 8",
 _debugger: "< 8",
 dgram: !0,
 diagnostics_channel: ">= 15.1",
 dns: !0,
 "dns/promises": ">= 15",
 domain: ">= 0.7.12",
 events: !0,
 freelist: "< 6",
 fs: !0,
 "fs/promises": [ ">= 10 && < 10.1", ">= 14" ],
 _http_agent: ">= 0.11.1",
 _http_client: ">= 0.11.1",
 _http_common: ">= 0.11.1",
 _http_incoming: ">= 0.11.1",
 _http_outgoing: ">= 0.11.1",
 _http_server: ">= 0.11.1",
 http: !0,
 http2: ">= 8.8",
 https: !0,
 inspector: ">= 8.0.0",
 _linklist: "< 8",
 module: !0,
 net: !0,
 "node-inspect/lib/_inspect": ">= 7.6.0 && < 12",
 "node-inspect/lib/internal/inspect_client": ">= 7.6.0 && < 12",
 "node-inspect/lib/internal/inspect_repl": ">= 7.6.0 && < 12",
 os: !0,
 path: !0,
 "path/posix": ">= 15.3",
 "path/win32": ">= 15.3",
 perf_hooks: ">= 8.5",
 process: ">= 1",
 punycode: !0,
 querystring: !0,
 readline: !0,
 repl: !0,
 smalloc: ">= 0.11.5 && < 3",
 _stream_duplex: ">= 0.9.4",
 _stream_transform: ">= 0.9.4",
 _stream_wrap: ">= 1.4.1",
 _stream_passthrough: ">= 0.9.4",
 _stream_readable: ">= 0.9.4",
 _stream_writable: ">= 0.9.4",
 stream: !0,
 "stream/promises": ">= 15",
 string_decoder: !0,
 sys: [ ">= 0.6 && < 0.7", ">= 0.8" ],
 timers: !0,
 "timers/promises": ">= 15",
 _tls_common: ">= 0.11.13",
 _tls_legacy: ">= 0.11.3 && < 10",
 _tls_wrap: ">= 0.11.3",
 tls: !0,
 trace_events: ">= 10",
 tty: !0,
 url: !0,
 util: !0,
 "util/types": ">= 15.3",
 "v8/tools/arguments": ">= 10 && < 12",
 "v8/tools/codemap": [ ">= 4.4.0 && < 5", ">= 5.2.0 && < 12" ],
 "v8/tools/consarray": [ ">= 4.4.0 && < 5", ">= 5.2.0 && < 12" ],
 "v8/tools/csvparser": [ ">= 4.4.0 && < 5", ">= 5.2.0 && < 12" ],
 "v8/tools/logreader": [ ">= 4.4.0 && < 5", ">= 5.2.0 && < 12" ],
 "v8/tools/profile_view": [ ">= 4.4.0 && < 5", ">= 5.2.0 && < 12" ],
 "v8/tools/splaytree": [ ">= 4.4.0 && < 5", ">= 5.2.0 && < 12" ],
 v8: ">= 1",
 vm: !0,
 wasi: ">= 13.4 && < 13.5",
 worker_threads: ">= 11.7",
 zlib: !0
};

for (mod in current = process.versions && process.versions.node && process.versions.node.split(".") || [], 
core = {}, data) Object.prototype.hasOwnProperty.call(data, mod) && (core[mod] = versionIncluded(data[mod]));

core_1 = core, isCore = function e(t) {
 return isCoreModule(t);
}, realpathFS = fs__default.default.realpathSync && "function" == typeof fs__default.default.realpathSync.native ? fs__default.default.realpathSync.native : fs__default.default.realpathSync, 
defaultIsFile = function e(t) {
 try {
  var r = fs__default.default.statSync(t);
 } catch (e) {
  if (e && ("ENOENT" === e.code || "ENOTDIR" === e.code)) return !1;
  throw e;
 }
 return r.isFile() || r.isFIFO();
}, defaultIsDir = function e(t) {
 try {
  var r = fs__default.default.statSync(t);
 } catch (e) {
  if (e && ("ENOENT" === e.code || "ENOTDIR" === e.code)) return !1;
  throw e;
 }
 return r.isDirectory();
}, defaultRealpathSync = function e(t) {
 try {
  return realpathFS(t);
 } catch (e) {
  if ("ENOENT" !== e.code) throw e;
 }
 return t;
}, maybeRealpathSync = function e(t, r, n) {
 return n && !1 === n.preserveSymlinks ? t(r) : r;
}, defaultReadPackageSync = function e(t, r) {
 var n = t(r);
 try {
  return JSON.parse(n);
 } catch (e) {}
}, getPackageCandidates = function e(t, r, n) {
 var s, o = nodeModulesPaths(r, n, t);
 for (s = 0; s < o.length; s++) o[s] = path__default.default.join(o[s], t);
 return o;
}, sync = function e(t, r) {
 function n(e) {
  var t, r, n, o, l = s(path__default.default.dirname(e));
  if (l && l.dir && l.pkg && i.pathFilter && (t = path__default.default.relative(l.dir, e), 
  (r = i.pathFilter(l.pkg, e, t)) && (e = path__default.default.resolve(l.dir, r))), 
  a(e)) return e;
  for (n = 0; n < h.length; n++) if (o = e + h[n], a(o)) return o;
 }
 function s(e) {
  var t, r;
  if ("" !== e && "/" !== e && !("win32" === process.platform && /^\w:[/\\]*$/.test(e) || /[/\\]node_modules[/\\]*$/.test(e))) return t = path__default.default.join(maybeRealpathSync(u, e, i), "package.json"), 
  a(t) ? ((r = d(l, t)) && i.packageFilter && (r = i.packageFilter(r, e)), {
   pkg: r,
   dir: e
  }) : s(path__default.default.dirname(e));
 }
 function o(e) {
  var t, r, s, c, p = path__default.default.join(maybeRealpathSync(u, e, i), "/package.json");
  if (a(p)) {
   try {
    t = d(l, p);
   } catch (e) {}
   if (t && i.packageFilter && (t = i.packageFilter(t, e)), t && t.main) {
    if ("string" != typeof t.main) throw (r = new TypeError("package “" + t.name + "” `main` must be a string")).code = "INVALID_PACKAGE_MAIN", 
    r;
    "." !== t.main && "./" !== t.main || (t.main = "index");
    try {
     if (s = n(path__default.default.resolve(e, t.main))) return s;
     if (c = o(path__default.default.resolve(e, t.main))) return c;
    } catch (e) {}
   }
  }
  return n(path__default.default.join(e, "/index"));
 }
 var i, a, l, c, u, d, p, h, f, m, g, y, w, _, E, v;
 if ("string" != typeof t) throw new TypeError("Path must be a string.");
 if (i = normalizeOptions(0, r), a = i.isFile || defaultIsFile, l = i.readFileSync || fs__default.default.readFileSync, 
 c = i.isDirectory || defaultIsDir, u = i.realpathSync || defaultRealpathSync, d = i.readPackageSync || defaultReadPackageSync, 
 i.readFileSync && i.readPackageSync) throw new TypeError("`readFileSync` and `readPackageSync` are mutually exclusive.");
 if (p = i.packageIterator, h = i.extensions || [ ".js" ], f = !1 !== i.includeCoreModules, 
 m = i.basedir || path__default.default.dirname(caller()), g = i.filename || m, i.paths = i.paths || [], 
 y = maybeRealpathSync(u, path__default.default.resolve(m), i), /^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(t)) {
  if (w = path__default.default.resolve(y, t), "." !== t && ".." !== t && "/" !== t.slice(-1) || (w += "/"), 
  _ = n(w) || o(w)) return maybeRealpathSync(u, _, i);
 } else {
  if (f && isCoreModule(t)) return t;
  if (E = function b(e, t) {
   var r, s, a, l, u = function() {
    return getPackageCandidates(e, t, i);
   }, d = p ? p(e, t, u, i) : u();
   for (r = 0; r < d.length; r++) if (s = d[r], c(path__default.default.dirname(s))) {
    if (a = n(s)) return a;
    if (l = o(s)) return l;
   }
  }(t, y), E) return maybeRealpathSync(u, E, i);
 }
 throw (v = new Error("Cannot find module '" + t + "' from '" + g + "'")).code = "MODULE_NOT_FOUND", 
 v;
}, async.core = core_1, async.isCore = isCore, async.sync = sync, resolve = async;

const getPackageDirPath = (e, t) => {
 const r = normalizePath(e).split("/"), n = (e => {
  e.startsWith("~") && (e = e.substring(1));
  const t = e.split("/"), r = {
   moduleId: null,
   filePath: null,
   scope: null,
   scopeSubModuleId: null
  };
  return e.startsWith("@") && t.length > 1 ? (r.moduleId = t.slice(0, 2).join("/"), 
  r.filePath = t.slice(2).join("/"), r.scope = t[0], r.scopeSubModuleId = t[1]) : (r.moduleId = t[0], 
  r.filePath = t.slice(1).join("/")), r;
 })(t);
 for (let e = r.length - 1; e >= 1; e--) if ("node_modules" === r[e - 1]) if (n.scope) {
  if (r[e] === n.scope && r[e + 1] === n.scopeSubModuleId) return r.slice(0, e + 2).join("/");
 } else if (r[e] === n.moduleId) return r.slice(0, e + 1).join("/");
 return null;
}, createSystem = e => {
 var t;
 const r = null !== (t = null == e ? void 0 : e.logger) && void 0 !== t ? t : (() => {
  const e = function t() {
   return {
    cwd: () => process.cwd(),
    emoji: e => "win32" !== process.platform ? e : "",
    getColumns: () => {
     var e, t;
     const r = null !== (t = null === (e = null === process || void 0 === process ? void 0 : process.stdout) || void 0 === e ? void 0 : e.columns) && void 0 !== t ? t : 80;
     return Math.max(Math.min(r, 120), 60);
    },
    memoryUsage: () => process.memoryUsage().rss,
    relativePath: (e, t) => path__default.default.relative(e, t),
    writeLogs: (e, t, r) => {
     if (r) try {
      gracefulFs.accessSync(e);
     } catch (e) {
      r = !1;
     }
     r ? gracefulFs.appendFileSync(e, t) : gracefulFs.writeFileSync(e, t);
    },
    createLineUpdater: async () => {
     const e = await Promise.resolve().then((function() {
      return _interopNamespace(require("readline"));
     }));
     let t = Promise.resolve();
     const r = r => (r = r.substring(0, process.stdout.columns - 5) + "[0m", t = t.then((() => new Promise((t => {
      e.clearLine(process.stdout, 0), e.cursorTo(process.stdout, 0, null), process.stdout.write(r, t);
     })))));
     return process.stdout.write("[?25l"), {
      update: r,
      stop: () => r("[?25h")
     };
    }
   };
  }();
  return createTerminalLogger(e);
 })(), n = new Map, s = new Set, o = e => s.add(e), i = e => s.delete(e), a = buildEvents(), l = e => {
  if ("/" === e || "" === e) return "/";
  const t = path$2.dirname(e), r = path$2.basename(e);
  return t.endsWith("/") ? normalizePath(`${t}${r}`) : normalizePath(`${t}/${r}`);
 }, c = e => {
  const t = n.get(l(e));
  return !(!t || !(t.isDirectory || t.isFile && "string" == typeof t.data));
 }, u = (e, t) => {
  e = l(e);
  const r = {
   basename: path$2.basename(e),
   dirname: path$2.dirname(e),
   path: e,
   newDirs: [],
   error: null
  };
  return d(e, t, r), r;
 }, d = (e, t, r) => {
  const s = path$2.dirname(e);
  t && t.recursive && !(e => "/" === e || windowsPathRegex.test(e))(s) && d(s, t, r);
  const o = n.get(e);
  o ? (o.isDirectory = !0, o.isFile = !1) : (n.set(e, {
   basename: path$2.basename(e),
   dirname: s,
   isDirectory: !0,
   isFile: !1,
   watcherCallbacks: null,
   data: void 0
  }), r.newDirs.push(e), E(e, new Set));
 }, p = e => {
  e = l(e);
  const t = [], r = n.get(e);
  return r && r.isDirectory && n.forEach(((r, n) => {
   "/" !== n && (r.isDirectory || r.isFile && "string" == typeof r.data) && (e.endsWith("/") && `${e}${r.basename}` === n || `${e}/${r.basename}` === n) && t.push(n);
  })), t.sort();
 }, h = e => {
  e = l(e);
  const t = n.get(e);
  if (t && t.isFile) return t.data;
 }, f = e => ({
  path: l(e),
  error: null
 }), m = (e, t, r) => {
  const s = w(e);
  if (!s.error && !r.error) if (s.isFile) {
   const s = path$2.dirname(t), o = u(s, {
    recursive: !0
   }), i = n.get(e).data, a = v(t, i);
   r.newDirs.push(...o.newDirs), r.renamed.push({
    oldPath: e,
    newPath: t,
    isDirectory: !1,
    isFile: !0
   }), a.error ? r.error = a.error : r.newFiles.push(t);
  } else if (s.isDirectory) {
   const n = p(e), s = u(t, {
    recursive: !0
   });
   r.newDirs.push(...s.newDirs), r.renamed.push({
    oldPath: e,
    newPath: t,
    isDirectory: !0,
    isFile: !1
   });
   for (const s of n) {
    const n = s.replace(e, t);
    m(s, n, r);
   }
  }
 }, g = (e, t = {}) => {
  const r = {
   basename: path$2.basename(e),
   dirname: path$2.dirname(e),
   path: e,
   removedDirs: [],
   removedFiles: [],
   error: null
  };
  return y(e, t, r), r;
 }, y = (e, t, r) => {
  if (!r.error) {
   e = l(e);
   const s = p(e);
   if (t && t.recursive) for (const e of s) {
    const s = n.get(e);
    if (s) if (s.isDirectory) y(e, t, r); else if (s.isFile) {
     const t = _(e);
     t.error ? r.error = t.error : r.removedFiles.push(e);
    }
   } else if (s.length > 0) return void (r.error = "cannot delete directory that contains files/subdirectories");
   n.delete(e), E(e, new Set), r.removedDirs.push(e);
  }
 }, w = e => {
  e = l(e);
  const t = n.get(e);
  return t && (t.isDirectory || t.isFile && "string" == typeof t.data) ? {
   isDirectory: t.isDirectory,
   isFile: t.isFile,
   isSymbolicLink: !1,
   size: t.isFile && t.data ? t.data.length : 0,
   error: null
  } : {
   isDirectory: !1,
   isFile: !1,
   isSymbolicLink: !1,
   size: 0,
   error: `ENOENT: no such file or directory, statSync '${e}'`
  };
 }, _ = e => {
  e = l(e);
  const t = {
   basename: path$2.basename(e),
   dirname: path$2.dirname(e),
   path: e,
   error: null
  }, r = n.get(e);
  if (r) {
   if (r.watcherCallbacks) for (const t of r.watcherCallbacks) t(e, "fileDelete");
   n.delete(e), E(e, new Set);
  }
  return t;
 }, E = (e, t) => {
  const r = l(path$2.dirname(e)), s = n.get(r);
  if (s && s.isDirectory && s.watcherCallbacks) for (const t of s.watcherCallbacks) t(e, null);
  t.has(r) || (t.add(r), E(r, t));
 }, v = (e, t) => {
  const r = {
   path: e = l(e),
   error: null
  }, s = n.get(e);
  if (s) {
   const r = s.data !== t;
   if (s.data = t, r && s.watcherCallbacks) for (const t of s.watcherCallbacks) t(e, "fileUpdate");
  } else n.set(e, {
   basename: path$2.basename(e),
   dirname: path$2.dirname(e),
   isDirectory: !1,
   isFile: !0,
   watcherCallbacks: null,
   data: t
  }), E(e, new Set);
  return r;
 }, b = "undefined" != typeof self ? null === self || void 0 === self ? void 0 : self.fetch : "undefined" != typeof window ? null === window || void 0 === window ? void 0 : window.fetch : "undefined" != typeof global ? null === global || void 0 === global ? void 0 : global.fetch : void 0, T = Promise.resolve();
 u("/");
 const S = {
  name: "in-memory",
  version: "4.4.1",
  events: a,
  access: async e => c(e),
  accessSync: c,
  addDestroy: o,
  copyFile: async (e, t) => (v(t, h(e)), !0),
  createDir: async (e, t) => u(e, t),
  createDirSync: u,
  homeDir: () => os__namespace.homedir(),
  isTTY: () => {
   var e;
   return !!(null === (e = null == process__namespace ? void 0 : process__namespace.stdout) || void 0 === e ? void 0 : e.isTTY);
  },
  getEnvironmentVar: e => null == process__namespace ? void 0 : process__namespace.env[e],
  destroy: async () => {
   const e = [];
   s.forEach((t => {
    try {
     const r = t();
     r && "function" == typeof r.then && e.push(r);
    } catch (e) {
     r.error(`stencil sys destroy: ${e}`);
    }
   })), await Promise.all(e), s.clear();
  },
  encodeToBase64: e => btoa(unescape(encodeURIComponent(e))),
  exit: async e => r.warn(`exit ${e}`),
  getCurrentDirectory: () => "/",
  getCompilerExecutingPath: () => S.getRemoteModuleUrl({
   moduleId: "@stencil/core",
   path: "compiler/stencil.min.js"
  }),
  getLocalModulePath: e => path$2.join(e.rootDir, "node_modules", e.moduleId, e.path),
  getRemoteModuleUrl: e => {
   const t = `${e.moduleId}${e.version ? "@" + e.version : ""}/${e.path}`;
   return new URL(t, "https://cdn.jsdelivr.net/npm/").href;
  },
  hardwareConcurrency: 1,
  isSymbolicLink: async e => !1,
  nextTick: e => T.then(e),
  normalizePath: l,
  platformPath: path__default.default,
  readDir: async e => p(e),
  readDirSync: p,
  readFile: async e => h(e),
  readFileSync: h,
  realpath: async e => f(e),
  realpathSync: f,
  removeDestroy: i,
  rename: async (e, t) => {
   const r = {
    oldPath: e = normalizePath(e),
    newPath: t = normalizePath(t),
    renamed: [],
    oldDirs: [],
    oldFiles: [],
    newDirs: [],
    newFiles: [],
    isFile: !1,
    isDirectory: !1,
    error: null
   }, n = w(e);
   if (n.error) r.error = `${e} does not exist`; else if (n.isFile ? r.isFile = !0 : n.isDirectory && (r.isDirectory = !0), 
   m(e, t, r), !r.error) if (r.isDirectory) {
    const t = g(e, {
     recursive: !0
    });
    t.error ? r.error = t.error : (r.oldDirs.push(...t.removedDirs), r.oldFiles.push(...t.removedFiles));
   } else if (r.isFile) {
    const t = _(e);
    t.error ? r.error = t.error : r.oldFiles.push(e);
   }
   return r;
  },
  fetch: b,
  resolvePath: e => l(e),
  removeDir: async (e, t = {}) => g(e, t),
  removeDirSync: g,
  stat: async e => w(e),
  statSync: w,
  tmpDirSync: () => "/.tmp",
  removeFile: async e => _(e),
  removeFileSync: _,
  watchDirectory: (e, t) => {
   e = l(e);
   const r = n.get(e), s = () => {
    const r = n.get(e);
    if (r && r.watcherCallbacks) {
     const e = r.watcherCallbacks.indexOf(t);
     e > -1 && r.watcherCallbacks.splice(e, 1);
    }
   };
   return o(s), r ? (r.isDirectory = !0, r.isFile = !1, r.watcherCallbacks = r.watcherCallbacks || [], 
   r.watcherCallbacks.push(t)) : n.set(e, {
    basename: path$2.basename(e),
    dirname: path$2.dirname(e),
    isDirectory: !0,
    isFile: !1,
    watcherCallbacks: [ t ],
    data: void 0
   }), {
    close() {
     i(s), s();
    }
   };
  },
  watchFile: (e, t) => {
   e = l(e);
   const r = n.get(e), s = () => {
    const r = n.get(e);
    if (r && r.watcherCallbacks) {
     const e = r.watcherCallbacks.indexOf(t);
     e > -1 && r.watcherCallbacks.splice(e, 1);
    }
   };
   return o(s), r ? (r.isDirectory = !1, r.isFile = !0, r.watcherCallbacks = r.watcherCallbacks || [], 
   r.watcherCallbacks.push(t)) : n.set(e, {
    basename: path$2.basename(e),
    dirname: path$2.dirname(e),
    isDirectory: !1,
    isFile: !0,
    watcherCallbacks: [ t ],
    data: void 0
   }), {
    close() {
     i(s), s();
    }
   };
  },
  watchTimeout: 32,
  writeFile: async (e, t) => v(e, t),
  writeFileSync: v,
  generateContentHash: async (e, t) => {
   const r = await crypto.subtle.digest("SHA-256", (new TextEncoder).encode(e));
   let n = Array.from(new Uint8Array(r)).map((e => e.toString(16).padStart(2, "0"))).join("");
   return "number" == typeof t && (n = n.slice(0, t)), n;
  },
  createWorkerController: null,
  details: {
   cpuModel: "",
   freemem: () => 0,
   platform: "",
   release: "",
   totalmem: 0
  },
  copy: async (e, t) => (r.info("todo, copy task", e.length, t), {
   diagnostics: [],
   dirPaths: [],
   filePaths: []
  })
 };
 return S.resolveModuleId = e => ((e, t, r) => {
  const n = ((e, t, r) => ({
   async isFile(e, r) {
    const n = normalizeFsPath(e);
    (await t.stat(n)).isFile ? r(null, !0) : r(null, !1);
   },
   async isDirectory(e, r) {
    const n = normalizeFsPath(e);
    (await t.stat(n)).isDirectory ? r(null, !0) : r(null, !1);
   },
   async readFile(e, r) {
    const n = normalizeFsPath(e), s = await t.readFile(n);
    return isString(s) ? r(null, s) : r(`readFile not found: ${e}`);
   },
   async realpath(t, r) {
    const n = normalizeFsPath(t), s = await e.realpath(n);
    s.error && "ENOENT" !== s.error.code ? r(s.error) : r(null, s.error ? n : s.path);
   },
   extensions: r
  }))(e, null, r.exts);
  return n.basedir = path$2.dirname(normalizeFsPath(r.containingFile)), r.packageFilter ? n.packageFilter = r.packageFilter : null !== r.packageFilter && (n.packageFilter = e => (isString(e.main) && "" !== e.main || (e.main = "package.json"), 
  e)), new Promise(((e, t) => {
   resolve(r.moduleId, n, ((n, s, o) => {
    if (n) t(n); else {
     s = normalizePath(s);
     const t = {
      moduleId: r.moduleId,
      resolveId: s,
      pkgData: o,
      pkgDirPath: getPackageDirPath(s, r.moduleId)
     };
     e(t);
    }
   }));
  }));
 })(S, 0, e), S;
}, createTestingSystem = () => {
 let e = 0, t = 0;
 const r = createSystem();
 r.platformPath = path__default.default, r.generateContentHash = (e, t) => {
  let r = require$$3.createHash("sha1").update(e).digest("hex").toLowerCase();
  return "number" == typeof t && (r = r.slice(0, t)), Promise.resolve(r);
 };
 const n = t => {
  const r = t;
  return (...t) => (e++, r.apply(r, t));
 }, s = e => {
  const r = e;
  return (...e) => (t++, r.apply(r, e));
 };
 if (r.access = n(r.access), r.accessSync = n(r.accessSync), r.homeDir = n(r.homeDir), 
 r.readFile = n(r.readFile), r.readFileSync = n(r.readFileSync), r.readDir = n(r.readDir), 
 r.readDirSync = n(r.readDirSync), r.stat = n(r.stat), r.statSync = n(r.statSync), 
 r.copyFile = s(r.copyFile), r.createDir = s(r.createDir), r.createDirSync = s(r.createDirSync), 
 r.removeFile = s(r.removeFile), r.removeFileSync = s(r.removeFileSync), r.writeFile = s(r.writeFile), 
 r.writeFileSync = s(r.writeFileSync), r.getCompilerExecutingPath = () => "bin/stencil.js", 
 Object.defineProperties(r, {
  diskReads: {
   get: () => e,
   set(t) {
    e = t;
   }
  },
  diskWrites: {
   get: () => t,
   set(e) {
    t = e;
   }
  }
 }), !function o(e) {
  return "diskReads" in e && "diskWrites" in e;
 }(r)) throw new Error("could not generate TestingSystem");
 return r;
};

class EventSpy {
 constructor(e) {
  this.eventName = e, this.events = [], this.cursor = 0, this.queuedHandler = [];
 }
 get length() {
  return this.events.length;
 }
 get firstEvent() {
  return this.events[0] || null;
 }
 get lastEvent() {
  return this.events[this.events.length - 1] || null;
 }
 next() {
  const e = this.cursor;
  this.cursor++;
  const t = this.events[e];
  if (t) return Promise.resolve({
   done: !1,
   value: t
  });
  {
   let t;
   const r = new Promise((e => t = e));
   return this.queuedHandler.push(t), r.then((() => ({
    done: !1,
    value: this.events[e]
   })));
  }
 }
 push(e) {
  this.events.push(e);
  const t = this.queuedHandler.shift();
  t && t();
 }
}

class E2EElement extends index_cjs.MockHTMLElement {
 _queueAction(e) {
  this._queuedActions.push(e);
 }
 constructor(e, t) {
  super(null, null), this._page = e, this._elmHandle = t, this._queuedActions = [], 
  e._e2eElements.push(this);
 }
 find(e) {
  return find(this._page, this._elmHandle, e);
 }
 findAll(e) {
  return findAll(this._page, this._elmHandle, e);
 }
 callMethod(e, ...t) {
  return this._queueAction({
   methodName: e,
   methodArgs: t
  }), this.e2eRunActions();
 }
 triggerEvent(e, t) {
  this._queueAction({
   eventName: e,
   eventInitDict: t
  });
 }
 async spyOnEvent(e) {
  const t = new EventSpy(e);
  return await addE2EListener(this._page, this._elmHandle, e, (e => {
   t.push(e);
  })), t;
 }
 async click(e) {
  await this._elmHandle.click(e), await this._page.waitForChanges();
 }
 async focus() {
  await this._elmHandle.focus(), await this._page.waitForChanges();
 }
 async hover() {
  await this._elmHandle.hover(), await this._page.waitForChanges();
 }
 async isVisible() {
  this._validate();
  let e = !1;
  try {
   const t = getPuppeteerExecution(this._elmHandle);
   e = await t.evaluate((e => new Promise((t => {
    window.requestAnimationFrame((() => {
     if (e.isConnected) {
      const r = window.getComputedStyle(e);
      r && "none" !== r.display && "hidden" !== r.visibility && "0" !== r.opacity ? window.requestAnimationFrame((() => {
       e.clientWidth, t(!0);
      })) : t(!1);
     } else t(!1);
    }));
   }))), this._elmHandle);
  } catch (e) {}
  return e;
 }
 waitForEvent(e) {
  return waitForEvent(this._page, e, this._elmHandle);
 }
 waitForVisible() {
  return new Promise(((e, t) => {
   const r = setInterval((async () => {
    await this.isVisible() && (clearInterval(r), clearTimeout(o), e());
   }), 10), n = .5 * jasmine.DEFAULT_TIMEOUT_INTERVAL, s = new Error(`waitForVisible timed out: ${n}ms`), o = setTimeout((() => {
    clearTimeout(r), t(s);
   }), n);
  }));
 }
 waitForNotVisible() {
  return new Promise(((e, t) => {
   const r = setInterval((async () => {
    await this.isVisible() || (clearInterval(r), clearTimeout(o), e());
   }), 10), n = .5 * jasmine.DEFAULT_TIMEOUT_INTERVAL, s = new Error(`waitForNotVisible timed out: ${n}ms`), o = setTimeout((() => {
    clearTimeout(r), t(s);
   }), n);
  }));
 }
 isIntersectingViewport() {
  return this._elmHandle.isIntersectingViewport();
 }
 async press(e, t) {
  await this._elmHandle.press(e, t), await this._page.waitForChanges();
 }
 async tap() {
  await this._elmHandle.tap(), await this._page.waitForChanges();
 }
 async type(e, t) {
  await this._elmHandle.type(e, t), await this._page.waitForChanges();
 }
 async getProperty(e) {
  this._validate();
  const t = getPuppeteerExecution(this._elmHandle);
  return await t.evaluate(((e, t) => e[t]), this._elmHandle, e);
 }
 setProperty(e, t) {
  this._queueAction({
   setPropertyName: e,
   setPropertyValue: t
  });
 }
 getAttribute(e) {
  return this._validate(), super.getAttribute(e);
 }
 setAttribute(e, t) {
  this._queueAction({
   setAttributeName: e,
   setAttributeValue: t
  });
 }
 removeAttribute(e) {
  this._queueAction({
   removeAttribute: e
  });
 }
 toggleAttribute(e, t) {
  this._queueAction({
   toggleAttributeName: e,
   toggleAttributeForce: t
  });
 }
 get classList() {
  return {
   add: (...e) => {
    e.forEach((e => {
     this._queueAction({
      classAdd: e
     });
    }));
   },
   remove: (...e) => {
    e.forEach((e => {
     this._queueAction({
      classRemove: e
     });
    }));
   },
   toggle: e => {
    this._queueAction({
     classToggle: e
    });
   },
   contains: e => (this._validate(), super.className.split(" ").includes(e))
  };
 }
 get className() {
  return this._validate(), super.className;
 }
 set className(e) {
  this._queueAction({
   setPropertyName: "className",
   setPropertyValue: e
  });
 }
 get id() {
  return this._validate(), super.id;
 }
 set id(e) {
  this._queueAction({
   setPropertyName: "id",
   setPropertyValue: e
  });
 }
 get innerHTML() {
  return this._validate(), super.innerHTML;
 }
 set innerHTML(e) {
  this._queueAction({
   setPropertyName: "innerHTML",
   setPropertyValue: e
  });
 }
 get innerText() {
  return this._validate(), super.innerText;
 }
 set innerText(e) {
  this._queueAction({
   setPropertyName: "innerText",
   setPropertyValue: e
  });
 }
 get nodeValue() {
  return this._validate(), super.nodeValue;
 }
 set nodeValue(e) {
  "string" == typeof e && this._queueAction({
   setPropertyName: "nodeValue",
   setPropertyValue: e
  });
 }
 get outerHTML() {
  return this._validate(), super.outerHTML;
 }
 set outerHTML(e) {
  throw new Error("outerHTML is read-only");
 }
 get shadowRoot() {
  return this._validate(), super.shadowRoot;
 }
 set shadowRoot(e) {
  super.shadowRoot = e;
 }
 get tabIndex() {
  return this._validate(), super.tabIndex;
 }
 set tabIndex(e) {
  this._queueAction({
   setPropertyName: "tabIndex",
   setPropertyValue: e
  });
 }
 get textContent() {
  return this._validate(), super.textContent;
 }
 set textContent(e) {
  this._queueAction({
   setPropertyName: "textContent",
   setPropertyValue: e
  });
 }
 get title() {
  return this._validate(), super.title;
 }
 set title(e) {
  this._queueAction({
   setPropertyName: "title",
   setPropertyValue: e
  });
 }
 async getComputedStyle(e) {
  const t = await this._page.evaluate(((e, t) => {
   const r = {}, n = window.getComputedStyle(e, t);
   return Object.keys(n).forEach((e => {
    if (isNaN(e)) {
     const t = n[e];
     null != t && (r[e] = t);
    } else {
     const t = n[e];
     if (t.includes("-")) {
      const e = n.getPropertyValue(t);
      null != e && (r[t] = e);
     }
    }
   })), r;
  }), this._elmHandle, e);
  return t.getPropertyValue = e => t[e], t;
 }
 async e2eRunActions() {
  if (0 === this._queuedActions.length) return;
  const e = getPuppeteerExecution(this._elmHandle), t = await e.evaluate(((e, t) => e.componentOnReady().then((() => {
   let r = null;
   return t.forEach((t => {
    if (t.methodName) r = e[t.methodName].apply(e, t.methodArgs); else if (t.setPropertyName) e[t.setPropertyName] = t.setPropertyValue; else if (t.setAttributeName) e.setAttribute(t.setAttributeName, t.setAttributeValue); else if (t.removeAttribute) e.removeAttribute(t.removeAttribute); else if (t.toggleAttributeName) "boolean" == typeof t.toggleAttributeForce ? e.toggleAttribute(t.toggleAttributeName, t.toggleAttributeForce) : e.toggleAttribute(t.toggleAttributeName); else if (t.classAdd) e.classList.add(t.classAdd); else if (t.classRemove) e.classList.remove(t.classRemove); else if (t.classToggle) e.classList.toggle(t.classToggle); else if (t.eventName) {
     const r = t.eventInitDict || {};
     "boolean" != typeof r.bubbles && (r.bubbles = !0), "boolean" != typeof r.cancelable && (r.cancelable = !0), 
     "boolean" != typeof r.composed && (r.composed = !0);
     const n = new CustomEvent(t.eventName, r);
     e.dispatchEvent(n);
    }
   })), r && "function" == typeof r.then ? r.then((e => e)) : r;
  }))), this._elmHandle, this._queuedActions);
  return this._queuedActions.length = 0, t;
 }
 async e2eSync() {
  const e = getPuppeteerExecution(this._elmHandle), {outerHTML: t, shadowRootHTML: r} = await e.evaluate((e => ({
   outerHTML: e.outerHTML,
   shadowRootHTML: e.shadowRoot ? e.shadowRoot.innerHTML : null
  })), this._elmHandle);
  "string" == typeof r ? (this.shadowRoot = index_cjs.parseHtmlToFragment(r), this.shadowRoot.host = this) : this.shadowRoot = null;
  const n = index_cjs.parseHtmlToFragment(t).firstElementChild;
  for (this.nodeName = n.nodeName, this.attributes = index_cjs.cloneAttributes(n.attributes); this.childNodes.length > 0; ) this.removeChild(this.childNodes[0]);
  for (;n.childNodes.length > 0; ) this.appendChild(n.childNodes[0]);
 }
 _validate() {
  if (this._queuedActions.length > 0) throw new Error("await page.waitForChanges() must be called before reading element information");
 }
 async e2eDispose() {
  this._elmHandle && (await this._elmHandle.dispose(), this._elmHandle = null);
  const e = this._page._e2eElements.indexOf(this);
  e > -1 && this._page._e2eElements.splice(e, 1), this._page = null;
 }
}

const env = process.env;

exports.MockHeaders = MockHeaders, exports.MockRequest = MockRequest, exports.MockResponse = MockResponse, 
exports.createJestPuppeteerEnvironment = function createJestPuppeteerEnvironment() {
 const e = require("jest-environment-node");
 return class extends e {
  constructor(e) {
   super(e), this.browser = null, this.pages = [];
  }
  async setup() {
   "true" === process.env.__STENCIL_E2E_TESTS__ && (this.global.__NEW_TEST_PAGE__ = this.newPuppeteerPage.bind(this), 
   this.global.__CLOSE_OPEN_PAGES__ = this.closeOpenPages.bind(this));
  }
  async newPuppeteerPage() {
   this.browser || (this.browser = await async function e() {
    const e = process.env, t = e.__STENCIL_BROWSER_WS_ENDPOINT__;
    if (!t) return null;
    const r = {
     browserWSEndpoint: t,
     ignoreHTTPSErrors: !0
    }, n = require(e.__STENCIL_PUPPETEER_MODULE__);
    return await n.connect(r);
   }());
   const t = await function r(e) {
    return e.newPage();
   }(this.browser);
   this.pages.push(t);
   const n = process.env;
   return "string" == typeof n.__STENCIL_DEFAULT_TIMEOUT__ && t.setDefaultTimeout(parseInt(n.__STENCIL_DEFAULT_TIMEOUT__, 10)), 
   t;
  }
  async closeOpenPages() {
   await Promise.all(this.pages.map((e => e.close()))), this.pages.length = 0;
  }
  async teardown() {
   await super.teardown(), await this.closeOpenPages(), await async function e(t) {
    if (t) try {
     t.disconnect();
    } catch (e) {}
   }(this.browser), this.browser = null;
  }
  getVmContext() {
   return super.getVmContext();
  }
 };
}, exports.createTestRunner = function createTestRunner() {
 var e;
 const t = null !== (e = require("jest-runner").default) && void 0 !== e ? e : require("jest-runner");
 return class r extends t {
  async runTests(e, t, r, n, s, o) {
   const i = process.env;
   if (e = e.filter((e => function t(e, r) {
    const n = (e = e.toLowerCase().replace(/\\/g, "/")).includes(".e2e.") || e.includes("/e2e.");
    return !("true" !== r.__STENCIL_E2E_TESTS__ || !n) || "true" === r.__STENCIL_SPEC_TESTS__ && !n;
   }(e.path, i))), "true" === i.__STENCIL_SCREENSHOT__ && i.__STENCIL_EMULATE_CONFIGS__) {
    const a = JSON.parse(i.__STENCIL_EMULATE_CONFIGS__);
    for (let l = 0; l < a.length; l++) setScreenshotEmulateData(a[l], i), await super.runTests(e, t, r, n, s, o);
   } else await super.runTests(e, t, r, n, s, o);
  }
 };
}, exports.createTesting = async e => {
 e = function t(e) {
  return e.buildEs5 = !1, e.devMode = !0, e.minifyCss = !1, e.minifyJs = !1, e.hashFileNames = !1, 
  e.validateTypes = !1, e._isTesting = !0, e.buildDist = !0, e.flags.serve = !1, e.flags.open = !1, 
  e.outputTargets.forEach((e => {
   "www" === e.type && (e.serviceWorker = null);
  })), e.flags.args.includes("--watchAll") && (e.watch = !0), e;
 }(e);
 const {createCompiler: r} = require("../compiler/stencil.js"), n = await r(e);
 let s, o;
 const i = async () => {
  const t = [];
  e && (e.sys && e.sys.destroy && t.push(e.sys.destroy()), e = null), s && (s.close && t.push(s.close()), 
  s = null), o && (o.close && t.push(o.close()), o = null), await Promise.all(t);
 };
 return {
  destroy: i,
  run: async (t = {}) => {
   let r, a = !1, l = !1, c = null;
   const u = [];
   try {
    if (!t.spec && !t.e2e) return e.logger.error("Testing requires either the --spec or --e2e command line flags, or both. For example, to run unit tests, use the command: stencil test --spec"), 
    !1;
    if (r = process.env, t.e2e && (u.push("e2e"), r.__STENCIL_E2E_TESTS__ = "true"), 
    t.spec && (u.push("spec"), r.__STENCIL_SPEC_TESTS__ = "true"), e.logger.info(e.logger.magenta(`testing ${u.join(" and ")} files${e.watch ? " (watch)" : ""}`)), 
    a = !(!t.e2e || !t.screenshot), a && (r.__STENCIL_SCREENSHOT__ = "true", t.updateScreenshot ? e.logger.info(e.logger.magenta("updating master screenshots")) : e.logger.info(e.logger.magenta("comparing against master screenshots"))), 
    t.e2e) {
     let t = null;
     e.outputTargets.forEach((e => {
      e.empty = !1;
     }));
     const a = !(e.flags && !1 === e.flags.build);
     a && e.watch && (c = await n.createWatcher()), a && (c ? (t = new Promise((e => {
      const t = c.on("buildFinish", (r => {
       t(), e(r);
      }));
     })), c.start()) : t = n.build()), e.devServer.openBrowser = !1, e.devServer.gzip = !1, 
     e.devServer.reloadStrategy = null;
     const l = await Promise.all([ index_js.start(e.devServer, e.logger), startPuppeteerBrowser(e) ]);
     if (s = l[0], o = l[1], t) {
      const r = await t;
      if (!r || !e.watch && hasError(r && r.diagnostics)) return await i(), !1;
     }
     if (s) {
      r.__STENCIL_BROWSER_URL__ = s.browserUrl, e.logger.debug(`e2e dev server url: ${r.__STENCIL_BROWSER_URL__}`), 
      r.__STENCIL_APP_SCRIPT_URL__ = function d(e, t) {
       return getAppUrl(e, t, `${e.fsNamespace}.esm.js`);
      }(e, s.browserUrl), e.logger.debug(`e2e app script url: ${r.__STENCIL_APP_SCRIPT_URL__}`);
      const t = function p(e, t) {
       return e.globalStyle ? getAppUrl(e, t, `${e.fsNamespace}.css`) : null;
      }(e, s.browserUrl);
      t && (r.__STENCIL_APP_STYLE_URL__ = t, e.logger.debug(`e2e app style url: ${r.__STENCIL_APP_STYLE_URL__}`));
     }
    }
   } catch (t) {
    return e.logger.error(t), !1;
   }
   try {
    l = a ? await async function h(e, t) {
     e.logger.debug(`screenshot connector: ${e.testing.screenshotConnector}`);
     const r = new (require(e.testing.screenshotConnector)), n = path$2.join(e.sys.getCompilerExecutingPath(), "..", "..", "screenshot", "pixel-match.js");
     e.logger.debug(`pixelmatch module: ${n}`);
     const s = e.logger.createTimeSpan("screenshot, initBuild started", !0);
     await r.initBuild({
      buildId: createBuildId(),
      buildMessage: createBuildMessage(),
      buildTimestamp: Date.now(),
      appNamespace: e.namespace,
      rootDir: e.rootDir,
      cacheDir: e.cacheDir,
      packageDir: path$2.join(e.sys.getCompilerExecutingPath(), "..", ".."),
      updateMaster: !!e.flags.updateScreenshot,
      logger: e.logger,
      allowableMismatchedPixels: e.testing.allowableMismatchedPixels,
      allowableMismatchedRatio: e.testing.allowableMismatchedRatio,
      pixelmatchThreshold: e.testing.pixelmatchThreshold,
      waitBeforeScreenshot: e.testing.waitBeforeScreenshot,
      pixelmatchModulePath: n
     }), e.flags.updateScreenshot || await r.pullMasterBuild(), s.finish("screenshot, initBuild finished");
     const o = await Promise.all([ await r.getMasterBuild(), await r.getScreenshotCache() ]), i = o[0], a = o[1];
     t.__STENCIL_SCREENSHOT_BUILD__ = r.toJson(i, a);
     const l = e.logger.createTimeSpan("screenshot, tests started", !0), c = await runJest(e, t);
     l.finish(`screenshot, tests finished, passed: ${c}`);
     try {
      const t = e.logger.createTimeSpan("screenshot, completeTimespan started", !0);
      let n = await r.completeBuild(i);
      if (t.finish("screenshot, completeTimespan finished"), n) {
       const t = e.logger.createTimeSpan("screenshot, publishBuild started", !0);
       if (n = await r.publishBuild(n), t.finish("screenshot, publishBuild finished"), 
       e.flags.updateScreenshot) n.currentBuild && "string" == typeof n.currentBuild.previewUrl && e.logger.info(e.logger.magenta(n.currentBuild.previewUrl)); else if (n.compare) {
        try {
         await r.updateScreenshotCache(a, n);
        } catch (t) {
         e.logger.error(t);
        }
        e.logger.info(`screenshots compared: ${n.compare.diffs.length}`), "string" == typeof n.compare.url && e.logger.info(e.logger.magenta(n.compare.url));
       }
      }
     } catch (t) {
      t instanceof Error ? e.logger.error(t, t.stack) : e.logger.error(t);
     }
     return c;
    }(e, r) : await runJest(e, r), e.logger.info(""), c && await c.close();
   } catch (t) {
    e.logger.error(t);
   }
   return l;
  }
 };
}, exports.getMockFSPatch = e => ({
 "node_modules/write-file-atomic": e.load(path$2.resolve(process.cwd(), "node_modules", "write-file-atomic")),
 "node_modules/imurmurhash": e.load(path$2.resolve(process.cwd(), "node_modules", "imurmurhash")),
 "node_modules/is-typedarray": e.load(path$2.resolve(process.cwd(), "node_modules", "is-typedarray")),
 "node_modules/typedarray-to-buffer": e.load(path$2.resolve(process.cwd(), "node_modules", "typedarray-to-buffer")),
 [path$2.resolve(process.cwd(), "sys")]: e.load(path$2.resolve(process.cwd(), "sys"))
}), exports.jestPreprocessor = jestPreprocessor, exports.jestSetupTestFramework = function jestSetupTestFramework() {
 global.resourcesUrl = "/build", expect.extend(expectExtend), expect.addSnapshotSerializer(HtmlSerializer), 
 index_cjs.setupGlobal(global), function e(t) {
  const r = t.window;
  "fetch" in r || (r.fetch = function(e) {
   return globalMockFetch(e);
  }), "fetch" in t || (t.fetch = function(e) {
   return globalMockFetch(e);
  });
 }(global), beforeEach((() => {
  testing.resetPlatform(), testing.setErrorHandler(void 0), resetBuildConditionals(appData.BUILD), 
  testing.modeResolutionChain.length = 0;
 })), afterEach((async () => {
  var e, t, r, n, s, o;
  global.__CLOSE_OPEN_PAGES__ && await global.__CLOSE_OPEN_PAGES__(), testing.stopAutoApplyChanges();
  const i = null === (s = null === (n = null === (r = null === (t = null === (e = global.window) || void 0 === e ? void 0 : e.document) || void 0 === t ? void 0 : t.childNodes) || void 0 === r ? void 0 : r[1]) || void 0 === n ? void 0 : n.childNodes) || void 0 === s ? void 0 : s.find((e => "BODY" === e.nodeName));
  null === (o = null == i ? void 0 : i.childNodes) || void 0 === o || o.forEach(removeDomNodes), 
  index_cjs.teardownGlobal(global), global.resourcesUrl = "/build";
 }));
 const t = jasmine.getEnv();
 null != t && t.addReporter({
  specStarted: e => {
   global.currentSpec = e;
  }
 }), global.screenshotDescriptions = new Set;
 const r = process.env;
 if ("string" == typeof r.__STENCIL_DEFAULT_TIMEOUT__) {
  const e = parseInt(r.__STENCIL_DEFAULT_TIMEOUT__, 10);
  jest.setTimeout(1.5 * e), jasmine.DEFAULT_TIMEOUT_INTERVAL = e;
 }
 if ("string" == typeof r.__STENCIL_ENV__) {
  const e = JSON.parse(r.__STENCIL_ENV__);
  Object.assign(appData.Env, e);
 }
}, exports.mockBuildCtx = function mockBuildCtx(e, t) {
 return e || (e = mockValidatedConfig()), t || (t = mockCompilerCtx(e)), new BuildContext(e, t);
}, exports.mockCompilerCtx = mockCompilerCtx, exports.mockCompilerSystem = function mockCompilerSystem() {
 return createTestingSystem();
}, exports.mockConfig = mockConfig, exports.mockDocument = function mockDocument(e = null) {
 return new index_cjs.MockWindow(e).document;
}, exports.mockFetch = mockFetch, exports.mockLoadConfigInit = e => ({
 config: {},
 configPath: void 0,
 initTsConfig: !0,
 logger: void 0,
 sys: void 0,
 ...e
}), exports.mockLogger = mockLogger, exports.mockModule = (e = {}) => ({
 cmps: [],
 coreRuntimeApis: [],
 outputTargetCoreRuntimeApis: {},
 collectionName: "",
 dtsFilePath: "",
 excludeFromCollection: !1,
 externalImports: [],
 htmlAttrNames: [],
 htmlTagNames: [],
 htmlParts: [],
 isCollectionDependency: !1,
 isLegacy: !1,
 jsFilePath: "",
 localImports: [],
 originalImports: [],
 originalCollectionComponentPath: "",
 potentialCmpRefs: [],
 sourceFilePath: "",
 staticSourceFile: "",
 staticSourceFileText: "",
 sourceMapPath: "",
 sourceMapFileText: "",
 hasVdomAttribute: !1,
 hasVdomClass: !1,
 hasVdomFunctional: !1,
 hasVdomKey: !1,
 hasVdomListener: !1,
 hasVdomPropOrAttr: !1,
 hasVdomRef: !1,
 hasVdomRender: !1,
 hasVdomStyle: !1,
 hasVdomText: !1,
 hasVdomXlink: !1,
 ...e
}), exports.mockValidatedConfig = mockValidatedConfig, exports.mockWindow = function mockWindow(e) {
 return new index_cjs.MockWindow(e);
}, exports.newE2EPage = async function newE2EPage(e = {}) {
 if (!global.__NEW_TEST_PAGE__) throw new Error("newE2EPage() is only available from E2E tests, and ran with the --e2e cmd line flag.");
 const t = await global.__NEW_TEST_PAGE__(), r = [];
 try {
  t._e2eElements = [], t._e2eGoto = t.goto, t._e2eClose = t.close, await t.setCacheEnabled(!1), 
  await initPageEvents(t), function n(e) {
   const t = process.env;
   "true" === t.__STENCIL_SCREENSHOT__ ? e.compareScreenshot = (r, n) => {
    const s = global;
    let o, i = "", a = "";
    if (s.currentSpec && ("string" == typeof s.currentSpec.fullName && (i = s.currentSpec.fullName), 
    "string" == typeof s.currentSpec.testPath && (a = s.currentSpec.testPath)), "string" == typeof r ? (i.length > 0 ? i += ", " + r : i = r, 
    "object" == typeof n && (o = n)) : "object" == typeof r && (o = r), i = i.trim(), 
    o = o || {}, !i) throw new Error(`Invalid screenshot description in "${a}"`);
    if (s.screenshotDescriptions.has(i)) throw new Error(`Screenshot description "${i}" found in "${a}" cannot be used for multiple screenshots and must be unique. To make screenshot descriptions unique within the same test, use the first argument to "compareScreenshot", such as "compareScreenshot('more to the description')".`);
    return s.screenshotDescriptions.add(i), async function l(e, t, r, n, s) {
     if ("string" != typeof t.__STENCIL_EMULATE__) throw new Error("compareScreenshot, missing screenshot emulate env var");
     if ("string" != typeof t.__STENCIL_SCREENSHOT_BUILD__) throw new Error("compareScreenshot, missing screen build env var");
     const o = JSON.parse(t.__STENCIL_EMULATE__), i = JSON.parse(t.__STENCIL_SCREENSHOT_BUILD__);
     await function a(e) {
      return new Promise((t => setTimeout(t, e)));
     }(i.timeoutBeforeScreenshot), await e.evaluate((() => new Promise((e => {
      window.requestAnimationFrame((() => {
       e();
      }));
     }))));
     const l = function c(e) {
      const t = {
       type: "png",
       fullPage: e.fullPage,
       omitBackground: e.omitBackground,
       encoding: "binary"
      };
      return e.clip && (t.clip = {
       x: e.clip.x,
       y: e.clip.y,
       width: e.clip.width,
       height: e.clip.height
      }), t;
     }(s), u = await e.screenshot(l), d = "number" == typeof s.pixelmatchThreshold ? s.pixelmatchThreshold : i.pixelmatchThreshold;
     let p = o.viewport.width, h = o.viewport.height;
     return s && s.clip && ("number" == typeof s.clip.width && (p = s.clip.width), "number" == typeof s.clip.height && (h = s.clip.height)), 
     await compareScreenshot(o, i, u, r, p, h, n, d);
    }(e, t, i, a, o);
   } : e.compareScreenshot = async () => ({
    id: "placeholder",
    mismatchedPixels: 0,
    allowableMismatchedPixels: 1,
    allowableMismatchedRatio: 1,
    desc: "",
    width: 1,
    height: 1,
    deviceScaleFactor: 1
   });
  }(t);
  let n = null;
  t.close = async e => {
   try {
    if (Array.isArray(t._e2eElements)) {
     const e = t._e2eElements.map((async e => {
      "function" == typeof e.e2eDispose && await e.e2eDispose();
     }));
     await Promise.all(e);
    }
   } catch (e) {}
   const r = () => {
    throw new Error("The page was already closed");
   };
   t._e2eElements = r, t._e2eEvents = r, t._e2eGoto = r, t.find = r, t.debugger = r, 
   t.findAll = r, t.compareScreenshot = r, t.setContent = r, t.spyOnEvent = r, t.waitForChanges = r, 
   t.waitForEvent = r;
   try {
    t.isClosed() || await t._e2eClose(e);
   } catch (e) {}
  };
  const s = async () => (n || (n = t.evaluateHandle((() => document))), (await n).asElement());
  t.find = async e => {
   const r = await s();
   return find(t, r, e);
  }, t.findAll = async e => {
   const r = await s();
   return findAll(t, r, e);
  }, t.waitForEvent = async e => {
   const r = await s();
   return waitForEvent(t, e, r);
  }, t.getDiagnostics = () => r, t.waitForChanges = waitForChanges.bind(null, t), 
  t.debugger = () => {
   if ("true" !== env.__STENCIL_E2E_DEVTOOLS__) throw new Error("Set the --devtools flag in order to use E2EPage.debugger()");
   return t.evaluate((() => new Promise((e => {
    e();
   }))));
  };
  const o = !0 === e.failOnConsoleError, i = !0 === e.failOnNetworkError;
  t.on("console", (e => {
   if ("error" === e.type() && (r.push({
    type: "error",
    message: e.text(),
    location: e.location().url
   }), o)) throw new Error(serializeConsoleMessage(e));
   !function t(e) {
    const t = serializeConsoleMessage(e), r = e.type(), n = "warning" === r ? "warn" : r;
    "debug" !== n && ("function" == typeof console[n] ? console[n](t) : console.log(r, t));
   }(e);
  })), t.on("pageerror", (e => {
   throw r.push({
    type: "pageerror",
    message: e.message,
    location: e.stack
   }), e;
  })), t.on("requestfailed", (e => {
   if (r.push({
    type: "requestfailed",
    message: e.failure().errorText,
    location: e.url()
   }), i) throw new Error(e.failure().errorText);
   console.error("requestfailed", e.url());
  })), "string" == typeof e.html ? await e2eSetContent(t, e.html, {
   waitUntil: e.waitUntil
  }) : "string" == typeof e.url ? await e2eGoTo(t, e.url, {
   waitUntil: e.waitUntil
  }) : (t.goto = e2eGoTo.bind(null, t), t.setContent = e2eSetContent.bind(null, t));
 } catch (e) {
  throw t && (t.isClosed() || await t.close()), e;
 }
 return t;
}, exports.newSpecPage = async function newSpecPage(e) {
 var t;
 if (null == e) throw new Error("NewSpecPageOptions required");
 testing.resetPlatform(null !== (t = e.platform) && void 0 !== t ? t : {}), resetBuildConditionals(appData.BUILD), 
 Array.isArray(e.components) && testing.registerComponents(e.components), e.hydrateClientSide && (e.includeAnnotations = !0), 
 e.hydrateServerSide ? (e.includeAnnotations = !0, testing.setSupportsShadowDom(!1)) : (e.includeAnnotations = !!e.includeAnnotations, 
 !1 === e.supportsShadowDom ? testing.setSupportsShadowDom(!1) : testing.setSupportsShadowDom(!0)), 
 appData.BUILD.cssAnnotations = e.includeAnnotations;
 const r = new Set;
 testing.win.__stencil_spec_options = e;
 const n = testing.win.document, s = {
  win: testing.win,
  doc: n,
  body: n.body,
  build: appData.BUILD,
  styles: testing.styles,
  setContent: e => (n.body.innerHTML = e, testing.flushAll()),
  waitForChanges: testing.flushAll,
  flushLoadModule: testing.flushLoadModule,
  flushQueue: testing.flushQueue
 }, o = e.components.map((e => {
  if (null == e.COMPILER_META) throw new Error('Invalid component class: Missing static "COMPILER_META" property.');
  r.add(e.COMPILER_META.tagName), e.isProxied = !1, function t(e) {
   var t, r, n, s, o, i;
   "function" == typeof (null === (t = e.prototype) || void 0 === t ? void 0 : t.__componentWillLoad) && (e.prototype.componentWillLoad = e.prototype.__componentWillLoad, 
   e.prototype.__componentWillLoad = null), "function" == typeof (null === (r = e.prototype) || void 0 === r ? void 0 : r.__componentWillUpdate) && (e.prototype.componentWillUpdate = e.prototype.__componentWillUpdate, 
   e.prototype.__componentWillUpdate = null), "function" == typeof (null === (n = e.prototype) || void 0 === n ? void 0 : n.__componentWillRender) && (e.prototype.componentWillRender = e.prototype.__componentWillRender, 
   e.prototype.__componentWillRender = null), "function" == typeof (null === (s = e.prototype) || void 0 === s ? void 0 : s.componentWillLoad) && (e.prototype.__componentWillLoad = e.prototype.componentWillLoad, 
   e.prototype.componentWillLoad = function() {
    const e = this.__componentWillLoad();
    return null != e && "function" == typeof e.then ? testing.writeTask((() => e)) : testing.writeTask((() => Promise.resolve())), 
    e;
   }), "function" == typeof (null === (o = e.prototype) || void 0 === o ? void 0 : o.componentWillUpdate) && (e.prototype.__componentWillUpdate = e.prototype.componentWillUpdate, 
   e.prototype.componentWillUpdate = function() {
    const e = this.__componentWillUpdate();
    return null != e && "function" == typeof e.then ? testing.writeTask((() => e)) : testing.writeTask((() => Promise.resolve())), 
    e;
   }), "function" == typeof (null === (i = e.prototype) || void 0 === i ? void 0 : i.componentWillRender) && (e.prototype.__componentWillRender = e.prototype.componentWillRender, 
   e.prototype.componentWillRender = function() {
    const e = this.__componentWillRender();
    return null != e && "function" == typeof e.then ? testing.writeTask((() => e)) : testing.writeTask((() => Promise.resolve())), 
    e;
   });
  }(e);
  const n = `${e.COMPILER_META.tagName}.${Math.round(899999 * Math.random()) + 1e5}`, s = e.COMPILER_META.styles;
  if (Array.isArray(s)) if (s.length > 1) {
   const t = {};
   s.forEach((e => {
    t[e.modeName] = e.styleStr;
   })), e.style = t;
  } else 1 === s.length && (e.style = s[0].styleStr);
  testing.registerModule(n, e);
  const o = ((e, t) => [ e, t.map((e => ((e, t) => {
   let r = 0;
   "shadow" === e.encapsulation ? (r |= 1, e.shadowDelegatesFocus && (r |= 16)) : "scoped" === e.encapsulation && (r |= 2), 
   "shadow" !== e.encapsulation && e.htmlTagNames.includes("slot") && (r |= 4), e.hasMode && (r |= 32);
   const n = formatComponentRuntimeMembers(e, t), s = formatHostListeners(e), o = formatComponentRuntimeWatchers(e);
   return trimFalsy([ r, e.tagName, Object.keys(n).length > 0 ? n : void 0, s.length > 0 ? s : void 0, Object.keys(o).length > 0 ? o : void 0 ]);
  })(e, !0))) ])(n, [ e.COMPILER_META ]);
  return o;
 })), i = (e => {
  const t = e.some((e => e.htmlTagNames.includes("slot"))), r = e.some((e => "shadow" === e.encapsulation)), n = e.some((e => "shadow" !== e.encapsulation && e.htmlTagNames.includes("slot"))), s = {
   allRenderFn: e.every((e => e.hasRenderFn)),
   cmpDidLoad: e.some((e => e.hasComponentDidLoadFn)),
   cmpShouldUpdate: e.some((e => e.hasComponentShouldUpdateFn)),
   cmpDidUnload: e.some((e => e.hasComponentDidUnloadFn)),
   cmpDidUpdate: e.some((e => e.hasComponentDidUpdateFn)),
   cmpDidRender: e.some((e => e.hasComponentDidRenderFn)),
   cmpWillLoad: e.some((e => e.hasComponentWillLoadFn)),
   cmpWillUpdate: e.some((e => e.hasComponentWillUpdateFn)),
   cmpWillRender: e.some((e => e.hasComponentWillRenderFn)),
   connectedCallback: e.some((e => e.hasConnectedCallbackFn)),
   disconnectedCallback: e.some((e => e.hasDisconnectedCallbackFn)),
   element: e.some((e => e.hasElement)),
   event: e.some((e => e.hasEvent)),
   hasRenderFn: e.some((e => e.hasRenderFn)),
   lifecycle: e.some((e => e.hasLifecycle)),
   asyncLoading: !1,
   hostListener: e.some((e => e.hasListener)),
   hostListenerTargetWindow: e.some((e => e.hasListenerTargetWindow)),
   hostListenerTargetDocument: e.some((e => e.hasListenerTargetDocument)),
   hostListenerTargetBody: e.some((e => e.hasListenerTargetBody)),
   hostListenerTargetParent: e.some((e => e.hasListenerTargetParent)),
   hostListenerTarget: e.some((e => e.hasListenerTarget)),
   member: e.some((e => e.hasMember)),
   method: e.some((e => e.hasMethod)),
   mode: e.some((e => e.hasMode)),
   observeAttribute: e.some((e => e.hasAttribute)),
   prop: e.some((e => e.hasProp)),
   propBoolean: e.some((e => e.hasPropBoolean)),
   propNumber: e.some((e => e.hasPropNumber)),
   propString: e.some((e => e.hasPropString)),
   propMutable: e.some((e => e.hasPropMutable)),
   reflect: e.some((e => e.hasReflect)),
   scoped: e.some((e => "scoped" === e.encapsulation)),
   shadowDom: r,
   shadowDelegatesFocus: r && e.some((e => e.shadowDelegatesFocus)),
   slot: t,
   slotRelocation: n,
   state: e.some((e => e.hasState)),
   style: e.some((e => e.hasStyle)),
   svg: e.some((e => e.htmlTagNames.includes("svg"))),
   updatable: e.some((e => e.isUpdateable)),
   vdomAttribute: e.some((e => e.hasVdomAttribute)),
   vdomXlink: e.some((e => e.hasVdomXlink)),
   vdomClass: e.some((e => e.hasVdomClass)),
   vdomFunctional: e.some((e => e.hasVdomFunctional)),
   vdomKey: e.some((e => e.hasVdomKey)),
   vdomListener: e.some((e => e.hasVdomListener)),
   vdomPropOrAttr: e.some((e => e.hasVdomPropOrAttr)),
   vdomRef: e.some((e => e.hasVdomRef)),
   vdomRender: e.some((e => e.hasVdomRender)),
   vdomStyle: e.some((e => e.hasVdomStyle)),
   vdomText: e.some((e => e.hasVdomText)),
   watchCallback: e.some((e => e.hasWatchCallback)),
   taskQueue: !0
  };
  return s.asyncLoading = s.cmpWillUpdate || s.cmpWillLoad || s.cmpWillRender, s.vdomAttribute = s.vdomAttribute || s.reflect, 
  s.vdomPropOrAttr = s.vdomPropOrAttr || s.reflect, s;
 })(e.components.map((e => e.COMPILER_META)));
 if (e.strictBuild ? Object.assign(appData.BUILD, i) : Object.keys(i).forEach((e => {
  !0 === i[e] && (appData.BUILD[e] = !0);
 })), appData.BUILD.asyncLoading = !0, e.hydrateClientSide ? (appData.BUILD.hydrateClientSide = !0, 
 appData.BUILD.hydrateServerSide = !1) : e.hydrateServerSide && (appData.BUILD.hydrateServerSide = !0, 
 appData.BUILD.hydrateClientSide = !1), appData.BUILD.cloneNodeFix = !1, appData.BUILD.shadowDomShim = !1, 
 appData.BUILD.attachStyles = !!e.attachStyles, "string" == typeof e.url && (s.win.location.href = e.url), 
 "string" == typeof e.direction && s.doc.documentElement.setAttribute("dir", e.direction), 
 "string" == typeof e.language && s.doc.documentElement.setAttribute("lang", e.language), 
 "string" == typeof e.cookie) try {
  s.doc.cookie = e.cookie;
 } catch (e) {}
 if ("string" == typeof e.referrer) try {
  s.doc.referrer = e.referrer;
 } catch (e) {}
 if ("string" == typeof e.userAgent) try {
  s.win.navigator.userAgent = e.userAgent;
 } catch (e) {}
 if (testing.bootstrapLazy(o), "function" == typeof e.template) {
  const t = {
   $ancestorComponent$: void 0,
   $flags$: 0,
   $modeName$: void 0,
   $cmpMeta$: {
    $flags$: 0,
    $tagName$: "body"
   },
   $hostElement$: s.body
  };
  testing.renderVdom(t, e.template());
 } else "string" == typeof e.html && (s.body.innerHTML = e.html);
 !1 !== e.flushQueue && await s.waitForChanges();
 let a = null;
 return Object.defineProperty(s, "root", {
  get() {
   if (null == a && (a = findRootComponent(r, s.body)), null != a) return a;
   const e = s.body.firstElementChild;
   return null != e ? e : null;
  }
 }), Object.defineProperty(s, "rootInstance", {
  get() {
   const e = testing.getHostRef(s.root);
   return null != e ? e.$lazyInstance$ : null;
  }
 }), e.hydrateServerSide && testing.insertVdomAnnotations(n, []), e.autoApplyChanges && (testing.startAutoApplyChanges(), 
 s.waitForChanges = () => (console.error('waitForChanges() cannot be used manually if the "startAutoApplyChanges" option is enabled'), 
 Promise.resolve())), s;
}, exports.setupConsoleMocker = function setupConsoleMocker() {
 function e() {
  console.log = t, console.warn = r, console.error = n;
 }
 const t = console.log, r = console.warn, n = console.error;
 return afterAll((() => {
  e();
 })), {
  setupConsoleMocks: function s() {
   const e = jest.fn(), t = jest.fn(), r = jest.fn();
   return console.log = e, console.warn = t, console.error = r, {
    logMock: e,
    warnMock: t,
    errorMock: r
   };
  },
  teardownConsoleMocks: e
 };
}, exports.shuffleArray = function shuffleArray(e) {
 let t, r, n = e.length;
 for (;0 !== n; ) r = Math.floor(Math.random() * n), n -= 1, t = e[n], e[n] = e[r], 
 e[r] = t;
 return e;
}, exports.transpile = transpile;