import type { HookOverlayOptions } from './HookOverlayOptions';
interface OverlayBase extends HTMLElement {
    present: () => Promise<void>;
    dismiss: (data?: any, role?: string | undefined) => Promise<boolean>;
}
export declare function useController<OptionsType, OverlayType extends OverlayBase>(displayName: string, controller: {
    create: (options: OptionsType) => Promise<OverlayType>;
}, defineCustomElement: () => void): {
    present: (options: OptionsType & HookOverlayOptions) => Promise<void>;
    dismiss: () => Promise<void>;
};
export {};
