package app.shosetsu.android.common.consts

import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.text.TextStyle

/*
 * This file is part of shosetsu.
 *
 * shosetsu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * shosetsu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with shosetsu.  If not, see <https://www.gnu.org/licenses/>.
 */
const val USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64; rv:107.0) Gecko/20100101 Firefox/107.0"

const val SELECTED_STROKE_WIDTH: Int = 8

/** How fast the user must fling inorder to activate the scroll to last */
const val FLING_THRESHOLD = 19999

/**
 * Size of sub text, used for description
 */
val SUB_TEXT_SIZE: TextStyle
	@Composable
	get() = MaterialTheme.typography.bodySmall

/**
 * File system directory for extension scripts
 */
const val FILE_SCRIPT_DIR: String = "/scripts/"

/**
 * File system directory for library scripts
 */
const val FILE_LIBRARY_DIR: String = "/libraries/"

/**
 * File system directory for source files
 */
const val FILE_SOURCE_DIR: String = "/src/"

/**
 * Directory on the repository that contains the extensions,
 * proceeding this will be the extension language
 */
const val REPO_SOURCE_DIR: String = "/src/"

const val APP_UPDATE_CACHE_FILE = "SHOSETSU_APP_UPDATE.json"

const val APK_MIME = "application/vnd.android.package-archive"

/**
 * The version of backups this build of shosetsu supports
 */
const val VERSION_BACKUP: String = "1.1.0"
const val BACKUP_FILE_EXTENSION = "sbk"
const val REPOSITORY_HELP_URL = "https://shosetsu.app/help/guides/repositories/"
const val BROWSE_HELP_URL = "https://shosetsu.app/help/guides/browse/"
const val SHARE_HELP_URL = "https://shosetsu.app/help/guides/share/"
const val URL_WEBSITE = "https://shosetsu.app"
const val URL_PRIVACY = "https://shosetsu.app/privacy"
const val URL_DISCLAIMER = "https://shosetsu.app/disclaimer"
const val URL_GITHUB_APP = "https://gitlab.com/shosetsuorg/shosetsu"
const val URL_GITHUB_EXTENSIONS = "https://github.com/shosetsuorg/extensions"
const val URL_PATREON = "https://www.patreon.com/doomsdayrs"
const val URL_DISCORD = "https://discord.gg/ttSX7gB"
const val URL_MATRIX = "https://matrix.to/#/#shosetsu:matrix.org"