package app.reading.stoic.stoicreading.SenecaHelvia;

import android.view.View;
import android.widget.TextView;

import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

import androidx.test.rule.ActivityTestRule;
import app.reading.stoic.stoicreading.R;

import static org.junit.Assert.*;

public class SenecaHelvia2Test {

    @Rule
    public ActivityTestRule<SenecaHelvia2> SenecaHelvia2TestRule = new ActivityTestRule<SenecaHelvia2>(SenecaHelvia2.class);

    private SenecaHelvia2 SenecaHelvia2 = null;

    @Before
    public void setUp() throws Exception {
        SenecaHelvia2 = SenecaHelvia2TestRule.getActivity();
    }

    @Test
    public void testLaunch(){
        View view = SenecaHelvia2.findViewById(R.id.textView2);
        assertNotNull(view);
    }

    //What I want the string to be. Checks if it's correct in Strings.xml
    @Test
    public void testTitleValue(){
        String titleExpected = "Chapter 2";
        String titleActual = SenecaHelvia2.getResources().getString(R.string.SenecaHelviaTitle2);
        assertEquals(titleExpected, titleActual);
    }

    //Test to see if the correct value is pulled in from Strings.xml
    @Test
    public void testTitleDisplayed(){
        String titleExpected = SenecaHelvia2.getResources().getString(R.string.SenecaHelviaTitle2);
        String titleActual = String.valueOf(SenecaHelvia2.getTitle());
        assertEquals(titleExpected, titleActual);
    }

    @Test
    public void testStringTooLarge(){
        String tooLarge = "STRING_TOO_LARGE";
        String textActual = SenecaHelvia2.getResources().getString(R.string.SenecaHelviaChapter2);
        assertNotEquals(tooLarge, textActual);
    }

    //Test to see if correct text is displayed
    @Test
    public void testCorrectTextDisplayed(){
        String expected = SenecaHelvia2.getResources().getString(R.string.SenecaHelviaChapter2);
        TextView actualTextView = (TextView) SenecaHelvia2.findViewById(R.id.textView2);
        String actual = actualTextView.getText().toString();
        assertEquals(expected, actual);
    }

    @After
    public void tearDown() throws Exception {
        SenecaHelvia2 = null;
    }
}