# Contributing to project management

> [!NOTE]
> These instructions are supposed to be complete and accurate. If anything is unclear or does not work please report it so it can be fixed.

## Synopsis

Thank you for wanting to improve Pachli by contributing project management skills.

After reading this document you will know:

- Specific areas to focus on that would bring immediate benefit

## Overview

Project management is difficult at the best of times, and an open source project relying primarily on volunteer work is not the best of times.

## Activities

With that in mind the following list describes specific activities that are typically part of a project manager's role and would be useful ways to onboard on to the project before making a larger commitment.

This is not an exhaustive list. If there are other ways that you would like to contribute and they are not listed here please start a [discussion](https://github.com/pachli/pachli-android/discussions).

> [!NOTE]
> Each of the following has an implicit "... and describe your processes so other volunteers can help, and automate the work where possible" step.

### Curating the list of open issues

Left untended open bug reports and feature requests can grow without bounds. Activites to help include:

- Follow up on incomplete bug reports to get more information from the reporter
  - Device, server, relevant accounts, screnshots, etc
- Make sure that bug reports are not being ignored
- Identify and close duplicate reports
- Apply consistent bug report labels to make them easy to manage

### Create new issues from user feedback

- Create GitHub issues to track problems or feature requests reported by users to the @pachli account or the #pachli hashtag

### Project prioritisation and planning

As an open source project contributors are free to work on whichever issues they prefer.

However, providing clear guidance about the relative priority of different issues can still be extremely helpful. Contributors may prefer to work on issues they know affect many people, or have a large impact on the affected users.

Mining issue reports to extract common themes or frustrations, developing and proposing a prioritisation scheme, and using it within the project could be extremely helpful.

### Follow up on open-but-stalled PRs

A contributor might start a PR and then the work stalls. It is very helpful to identify stalled PRs, and help the work continue.

- Had the submitter run out of time?
  - Can someone else from the project finish the work?
- Did they not understand the review feedback?
  - Can the reviewer update the feedback?
- Were they waiting for review and the project had not noticed?
  - Determine who should review the PR, and ask them to assign it to themselves

### Project internal communication

- Communicate the state of ongoing activities to the rest of the project contributors
- Track requests for comments on proposal documents

### Liaise between the project and other Fediverse projects

The project needs to keep track of new features planned for release in upcoming versions of Mastodon to determine how and when to support those features.

Keeping track of features in other Mastodon-like software is also important; both as they get feature parity with Mastodon, and where they have features Mastodon doesn't but we should consider supporting.

The project often discovers bugs in implementation of those features (or documentation thereof), reporting and tracking those is also very helpful.
