# Contributing to user support and social presence

> [!NOTE]
> These instructions are supposed to be complete and accurate. If anything is unclear or does not work please report it so it can be fixed.

## Synopsis

Users can post questions or problem reports to Mastodon, either mentioning the `@pachli@mastodon.social` account or using the `#pachli` hashtag.

After reading this document you will know how to respond to these support requests.

## Activities

### Responding to questions

- Answer the question.
- If you observe repeated instances of this question it may point to a UX issue in the app. Consider filing an issue to capture the possible improvement.

### Responding to problem reports

- Check the [list of closed issues](https://github.com/pachli/pachli-android/issues?q=is%3Aissue+is%3Aclosed) to see if the problem has already been fixed and will be in the next release.
  - If it has then let the user know.
  - If the fix is in a deployed version of Pachli Current then suggest they try that and confirm the fix works for them.
- Check the [list of open issues](https://github.com/pachli/pachli-android/issues?q=is%3Aopen+is%3Aissue) to see if the problem has already been reported
  - If it has then let the user know (link to the issue), with a timeframe for the fix (if known)
    - Ask if the user has any additional information that can be used to help resolve the issue, ask them to add it
  - If it hasn't, ask the user to create an issue, or, if they can't do that, ask them for enough information so you can create the issue on their behalf
