/*
 * Copyright 2023 Pachli Association
 *
 * This file is a part of Pachli.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * Pachli is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with Pachli; if not,
 * see <http://www.gnu.org/licenses>.
 */

package app.pachli.interfaces

import com.google.android.material.appbar.AppBarLayout

/**
 * Access the host's [AppBarLayout].
 *
 * Activities that contain an [AppBarLayout] need to "lift" the app bar when content scrolls
 * under the bar, otherwise the app bar background flickers.
 *
 * When the scrolling view and the app bar are in the same layout this is achieved with the
 * `app:liftOnScrollTargetViewId` attribute. But when they are in different layouts the
 * view that scrolls must call methods on the app bar to tell it when to "lift".
 */
interface AppBarLayoutHost {
    val appBarLayout: AppBarLayout
}
