/* Copyright 2022 Tusky Contributors
 *
 * This file is a part of Pachli.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * Pachli is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with Pachli; if not,
 * see <http://www.gnu.org/licenses>.
 */

package app.pachli.components.viewthread

import android.os.Bundle
import androidx.fragment.app.commit
import app.pachli.R
import app.pachli.core.activity.BottomSheetActivity
import app.pachli.core.common.extensions.viewBinding
import app.pachli.core.navigation.ViewThreadActivityIntent
import app.pachli.databinding.ActivityViewThreadBinding
import dagger.hilt.android.AndroidEntryPoint

/**
 * View the statuses in a single thread.
 */
@AndroidEntryPoint
class ViewThreadActivity : BottomSheetActivity() {
    private val binding by viewBinding(ActivityViewThreadBinding::inflate)

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(binding.root)
        setSupportActionBar(binding.toolbar)
        supportActionBar?.run {
            setDisplayHomeAsUpEnabled(true)
            setDisplayShowHomeEnabled(true)
            setDisplayShowTitleEnabled(true)
        }
        val id = ViewThreadActivityIntent.getStatusId(intent)
        val url = ViewThreadActivityIntent.getUrl(intent)
        val fragment =
            supportFragmentManager.findFragmentByTag(FRAGMENT_TAG + id) as ViewThreadFragment?
                ?: ViewThreadFragment.newInstance(id, url)

        supportFragmentManager.commit {
            replace(R.id.fragment_container, fragment, FRAGMENT_TAG + id)
        }
    }

    companion object {
        private const val FRAGMENT_TAG = "ViewThreadFragment_"
    }
}
