# "Pachli" and "Pachli Current" Privacy Policy

## Data access

"Pachli" and "Pachli Current" (collectively "the application") process data from your Mastodon server ("server") locally on your device.

After using the application to sign in to an account on your server your data is fetched and stored securely on your device. As you use the application additional data will be fetched and stored securely on your device.

You may use the application to share new data with your server (e.g., a new post, an image), or edit existing data (e.g., your account's profile).

You can not create an account using the application.

## Data security

All local data is processed using secure Android APIs.

All network data is encrypted using `https`.

## Data deletion

All locally cached data for an account is deleted if you do any of the following:

- Log out of the account in the application
- Clear the application's local storage
- Uninstall the application

You can not delete your Mastodon account using the application. Deleting your account must be done through your server's web interface.

## Data sharing

**None of the data used by the application is shared with the application developers or unrelated third parties.** Your data is only ever sent to your server, and handled in accordance with your server's privacy policy.

## Data types

The application processes the following types of data.

| Data                    | Purpose                                                                                                                                                                                       |
| ----------------------- |-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Authentication token    | Generated by your server. Used to log in to your account and ensure the application can not access your username or password                                                                  |
| Account metadata        | Allow you to view and edit your account metadata, including description, relevant links, accounts you follow and follow you. Allows you to view the public account information of other users |
| Notifications           | View and manage your account's notifications, including displaying them, deleting them, and creating device notifications                                                                     |
| Timelines               | View, manage, and create posts on your Mastodon timelines (home, bookmarks, local, federated, lists, hashtags, etc)                                                                           |
| Scheduled posts         | View, manage, and create posts scheduled to send at some future time                                                                                                                          |
| Draft posts             | View, manage, and create posts you are drafting                                                                                                                                               |
| Account preferences     | Specific settings you may have configured on your account (filters, blocks, mutes, language, etc)                                                                                             |
| Application preferences | Specific settings you may have configured for the application (app theme, font, confirmations, etc)                                                                                           |

Again, **none of this data is shared with the application developers or unrelated third parties.**

## Permissions

The application requires the following permissions for the following reasons:

- `INTERNET`: Connect to your Mastodon server of choice, fetch and post content
- `ACCESS_NETWORK_STATE`: Defer work when the network is unavailable, and retry work when the network becomes available
- `POST_NOTIFICATIONS`: Show notifications from your server
- `READ_MEDIA_IMAGES` / `VIDEO` / `AUDIO`, and `READ_EXTERNAL_STORAGE`: Select media on your device if you attach it to a post
- `WRITE_EXTERNAL_STORAGE`: Save media to your device if you download it from a post
- `FOREGROUND_SERVICE`: Improve reliability when sending posts

## Contact

If you have any questions about this privacy policy please contact [team@pachli.app](mailto:team@pachli.app).
