#pragma once

// Only defines and constexprs are allowed in this file.

#define DATA_FILE_EXTENSION ".mwm"
#define DATA_FILE_EXTENSION_TMP ".mwm.tmp"
#define DIFF_FILE_EXTENSION ".mwmdiff"
#define DIFF_APPLYING_FILE_EXTENSION ".diff.applying"
#define FONT_FILE_EXTENSION ".ttf"
#define OSM2FEATURE_FILE_EXTENSION ".osm2ft"
#define EXTENSION_TMP ".tmp"
#define RAW_GEOM_FILE_EXTENSION ".rawgeom"
#define OSM_DATA_FILE_EXTENSION ".osm"
#define ARCHIVE_TRACKS_FILE_EXTENSION ".track"
#define ARCHIVE_TRACKS_ZIPPED_FILE_EXTENSION ".track.zip"
#define STATS_EXTENSION ".stats"

#define NODES_FILE "nodes.dat"
#define WAYS_FILE "ways.dat"
#define RELATIONS_FILE "relations.dat"
#define TOWNS_FILE "towns.csv"
#define OFFSET_EXT ".offs"
#define ID2REL_EXT ".id2rel"

#define CENTERS_FILE_TAG "centers"
#define FEATURES_FILE_TAG "features"
#define GEOMETRY_FILE_TAG "geom"
#define TRIANGLE_FILE_TAG "trg"
#define INDEX_FILE_TAG "idx"
#define SEARCH_INDEX_FILE_TAG "sdx"

// Feature -> Street, do not rename for compatibility.
#define FEATURE2STREET_FILE_TAG "addr"
#define FEATURE2PLACE_FILE_TAG "ft2place"

#define POSTCODE_POINTS_FILE_TAG "postcode_points"
#define POSTCODES_FILE_TAG "postcodes"
#define CITIES_BOUNDARIES_FILE_TAG "cities_boundaries"
#define FEATURE_TO_OSM_FILE_TAG "feature_to_osm"
#define HEADER_FILE_TAG "header"
#define VERSION_FILE_TAG "version"
#define METADATA_FILE_TAG "meta"
#define ALTITUDES_FILE_TAG "altitudes"
#define ROAD_ACCESS_FILE_TAG "roadaccess"
#define RESTRICTIONS_FILE_TAG "restrictions"
#define ROUTING_FILE_TAG "routing"
#define CROSS_MWM_FILE_TAG "cross_mwm"
#define FEATURE_OFFSETS_FILE_TAG "offs"
#define SEARCH_RANKS_FILE_TAG "ranks"
#define POPULARITY_RANKS_FILE_TAG "popularity"
#define REGION_INFO_FILE_TAG "rgninfo"
#define METALINES_FILE_TAG "metalines"
#define CAMERAS_INFO_FILE_TAG "speedcams"
#define ISOLINES_INFO_FILE_TAG "isolines_info"
#define TRAFFIC_KEYS_FILE_TAG "traffic"
#define TRANSIT_CROSS_MWM_FILE_TAG "transit_cross_mwm"
#define TRANSIT_FILE_TAG "transit"
#define CITY_ROADS_FILE_TAG "city_roads"
#define DESCRIPTIONS_FILE_TAG "descriptions"
#define MAXSPEEDS_FILE_TAG "maxspeeds"
#define ROUTING_WORLD_FILE_TAG "routing_world"

#define READY_FILE_EXTENSION ".ready"
#define RESUME_FILE_EXTENSION ".resume"
#define DOWNLOADING_FILE_EXTENSION ".downloading"
#define TRANSIT_FILE_EXTENSION ".transit.json"

#define GEOM_INDEX_TMP_EXT ".geomidx.tmp"

#define COUNTRIES_FILE "countries.txt"
#define SERVER_DATAVERSION_FILE "data_version.json"
#define COUNTRIES_ROOT "Countries"

#define COUNTRIES_META_FILE "countries_meta.txt"
#define LEAP_SPEEDS_FILE "leap_speeds.json"

#define WORLD_FILE_NAME "World"
#define WORLD_COASTS_FILE_NAME "WorldCoasts"

#define SETTINGS_FILE_NAME "settings.ini"
#define MARKETING_SETTINGS_FILE_NAME "marketing_settings.ini"

#define SEARCH_CATEGORIES_FILE_NAME "categories.txt"
#define SEARCH_CUISINE_CATEGORIES_FILE_NAME "categories_cuisines.txt"
#define SEARCH_BRAND_CATEGORIES_FILE_NAME "categories_brands.txt"

#define PACKED_POLYGONS_INFO_TAG "info"
#define PACKED_POLYGONS_FILE "packed_polygons.bin"

#define GPS_TRACK_FILENAME "gps_track.dat"
#define RESTRICTIONS_FILENAME "restrictions.csv"
#define ROAD_ACCESS_FILENAME "road_access.bin"

#define METALINES_FILENAME "metalines.bin"
#define CAMERAS_TO_WAYS_FILENAME "cameras_to_ways.bin"
#define MINI_ROUNDABOUTS_FILENAME "mini_roundabouts.bin"
#define ADDR_INTERPOL_FILENAME "addr_interpol.bin"
#define MAXSPEEDS_FILENAME "maxspeeds.csv"
#define BOUNDARY_POSTCODES_FILENAME "boundary_postcodes.bin"
#define CITY_BOUNDARIES_COLLECTOR_FILENAME "city_boundaries_collector.bin"
#define CROSS_MWM_OSM_WAYS_DIR "cross_mwm_osm_ways"
#define TEMP_ADDR_EXTENSION ".tempaddr"

#define TRAFFIC_FILE_EXTENSION ".traffic"

#define SKIPPED_ELEMENTS_FILE "skipped_elements.json"

#define MAPCSS_MAPPING_FILE "mapcss-mapping.csv"
#define REPLACED_TAGS_FILE "replaced_tags.txt"
#define MIXED_TAGS_FILE "mixed_tags.txt"
#define MIXED_NODES_FILE "mixed_nodes.txt"

#define LOCALIZATION_DESCRIPTION_SUFFIX " Description"

#define BUILDING_PARTS_MAPPING_FILE "building_parts_mapping.bin"
