# Organic Maps

<a name="install"/>

[Organic Maps](https://organicmaps.app) is a free Android & iOS offline maps app for travelers, tourists, drivers, hikers, and cyclists.
It uses crowd-sourced [OpenStreetMap](https://www.openstreetmap.org) data and is developed with love by creators of **MapsWithMe** app (later renamed to **Maps.Me**) and by our community.
No ads, no tracking, no data collection, no crapware. Your [donations](https://organicmaps.app/donate/) and positive reviews motivate and inspire us, thanks ❤️!

<p float="left">
  <a href="https://apps.apple.com/app/organic-maps/id1567437057">
    <img src="docs/badges/apple-appstore.png" width="180">
  </a>
  <a href="https://play.google.com/store/apps/details?id=app.organicmaps">
    <img src="docs/badges/google-play.png" width="180">
  </a>
  <a href="https://appgallery.huawei.com/#/app/C104325611">
    <img src="docs/badges/huawei-appgallery.png" width="180">
  </a>
  <a href="https://f-droid.org/en/packages/app.organicmaps/">
    <img src="docs/badges/fdroid.png" width="180">
  </a>
  <a href='https://flathub.org/apps/details/app.organicmaps.desktop'>
    <img alt="Download on Flathub" src="https://flathub.org/assets/badges/flathub-badge-en.png" width="180"/>
  </a>
  <a href="https://repology.org/project/organicmaps/versions">
    <img src="https://repology.org/badge/vertical-allrepos/organicmaps.svg" width="180" alt="Packaging status">
  </a>
</p>

<p float="left">
  <img src="android/src/fdroid/play/listings/en-US/graphics/phone-screenshots/1.jpg" width="400" />
  <img src="android/src/fdroid/play/listings/en-US/graphics/phone-screenshots/2.jpg" width="400" />
  <img src="android/src/fdroid/play/listings/en-US/graphics/phone-screenshots/3.jpg" width="400" />
  <img src="android/src/fdroid/play/listings/en-US/graphics/phone-screenshots/4.jpg" width="400" />
</p>

## Features

Organic Maps is the ultimate companion app for travelers, tourists, hikers, and cyclists:

- Detailed offline maps with places that don't exist on other maps, thanks to [OpenStreetMap](https://osm.org)
- Cycling routes, hiking trails, and walking paths
- Contour lines, elevation profiles, peaks, and slopes
- Turn-by-turn walking, cycling, and car navigation with voice guidance
- Fast offline search on the map
- Bookmarks export and import in KML/KMZ formats (GPX is [planned](https://github.com/organicmaps/organicmaps/issues/624))
- Dark Mode to protect your eyes
- Countries and regions don't take a lot of space
- Free and open-source

## Why Organic?

Organic Maps is pure and organic, made with love:

- Respects your privacy
- Saves your battery
- No unexpected mobile data charges

Organic Maps app is free from trackers and other bad stuff:

- No ads
- No tracking
- No data collection
- No phoning home
- No annoying registration
- No mandatory tutorials
- No noisy email spam
- No push notifications
- No crapware
- ~~No pesticides~~ Purely organic!

The application is verified by <a href="https://reports.exodus-privacy.eu.org/en/reports/app.organicmaps/latest/">Exodus Privacy Project:

<img src="docs/privacy/exodus.png" width="400">
</a>

<br/>

Organic Maps doesn't request excessive permissions to spy on you:

<p float="left">
  <img src="docs/privacy/om.jpg" width="400">
  <img src="docs/privacy/mm.jpg" width="400">
</p>

At Organic Maps, we believe that privacy is a fundamental human right:

- Organic Maps is an indie community-driven open-source project
- We protect your privacy from Big Tech's prying eyes
- Stay safe no matter wherever you are

Reject surveillance - embrace your freedom.

[**Give Organic Maps a try!**](#install)

## Who is paying for the free app?

The app is free for everyone. Please [donate](https://organicmaps.app/donate) to support us!

### Our sponsors

[Mythic Beasts](https://www.mythic-beasts.com/) ISP [provides us](https://www.mythic-beasts.com/blog/2021/10/06/improving-the-world-bit-by-expensive-bit/)
two virtual servers with 400 TB/month of free bandwidth to help our users with
maps downloads and updates.

## Copyrights

Licensed under the Apache License, Version 2.0. See
[LICENSE](https://github.com/organicmaps/organicmaps/blob/master/LICENSE),
[NOTICE](https://github.com/organicmaps/organicmaps/blob/master/NOTICE)
and [data/copyright.html](http://htmlpreview.github.io/?https://github.com/organicmaps/organicmaps/blob/master/data/copyright.html)
files for more information.

## Governance

See [GOVERNANCE](docs/GOVERNANCE.md).

## Contributing

If you want to build the project, check [docs/INSTALL.md](docs/INSTALL.md). If you want to help the project,
see [docs/CONTRIBUTING.md](docs/CONTRIBUTING.md). You can [help in many ways](https://organicmaps.app/support-us/), the ability to code is not necessary.

## Beta

Please join our beta program, suggest your features, and report bugs:

- [iOS Beta (TestFlight)](https://testflight.apple.com/join/lrKCl08I)
- [Android Beta (Firebase)](https://appdistribution.firebase.dev/i/9ec3bca5e2b47373)

## Feedback

- **Rate us on [App Store](https://apps.apple.com/app/organic-maps/id1567437057)
and [Google Play](https://play.google.com/store/apps/details?id=app.organicmaps)**.
- **Star us on GitHub**.
- Report bugs or issues to [the issue tracker](https://github.com/organicmaps/organicmaps/issues).
- [Discuss](https://github.com/organicmaps/organicmaps/discussions/categories/ideas) ideas or propose feature requests.
- Subscribe to our [Telegram Channel](https://t.me/OrganicMapsApp) or to the [[matrix] space](https://matrix.to/#/#organicmaps:matrix.org) for updates.
- Join our [Telegram Group](https://t.me/OrganicMaps) to discuss with other users.
  - Присоединяйтесь к нашей [русскоязычной группе в Telegram](https://t.me/OrganicMapsRu) для обратной связи и помощи.
  - Diğer kullanıcılarla tartışmak için [Telegram Grubumuza](https://t.me/OrganicMapsTR) katılın.
- Contact us by [email](mailto:hello@organicmaps.app).
- Follow our updates in
[Mastodon](https://fosstodon.org/@organicmaps),
[Facebook](https://facebook.com/OrganicMaps),
[Twitter](https://twitter.com/OrganicMapsApp),
[Instagram](https://instagram.com/organicmaps.app/).
  - Güncellemelerimizi [Instagram](https://instagram.com/organicmapstr/) üzerinden takip edin.

The Organic Maps community abides by the CNCF [code of conduct](https://github.com/organicmaps/organicmaps/blob/master/docs/CODE_OF_CONDUCT.md).
