---
layout: default
title: Contributions
nav_order: 4
parent: Contributors
---
<!--
© 2020 and later: Unicode, Inc. and others.
License & terms of use: http://www.unicode.org/copyright.html
-->

# Contributions to the ICU library
{: .no_toc }

## Contents
{: .no_toc .text-delta }

1. TOC
{:toc}

---

## Why Contribute?

ICU is an open source library that is a de-facto industry standard for
internationalization libraries. Our goal is to provide top of the line i18n
support on all widely used platforms. By contributing your code to the ICU
library, you will get the benefit of continuing improvement by the ICU team and
the community, as well as testing and multi-platform portability. In addition,
it saves you from having to re-merge your own additions into ICU each time you
upgrade to a new ICU release.

## Current Process

See <https://icu.unicode.org/processes/contribute>.

## Historical

### Legal Issues ICU 1.8.1-57

The following process was in place up to ICU 57, when the old ICU license was
used.

### Old Process

In order for your code to be contributed, you need to assign to IBM joint
copyright ownership in the contribution. You retain joint ownership in the
contribution without restriction. (For the complete set of terms, please see the
forms mentioned below.)

The sections below describe two processes, for one-time and ongoing
contributors. In either case, please complete the form(s) electronically and
send it/them to IBM for review. After review by IBM, please print and sign the
form(s), send it/them by mail, and send the code. The code will then be
evaluated.

Please consult a legal representative if you do not understand the implications
of the copyright assignment.

### One-Time Contributors

If you would like to make a contribution only once or infrequently, please use
the *Joint Copyright Assignment - One-time Contribution* form.
(<https://github.com/unicode-org/icu-docs/blob/main/legal/contributions/Copyright_Assignment.rtf>).
The contribution will be identified by a bug ID which is unique to the
contribution and entered into the form. Therefore, please make sure that there
is an appropriate bug (or Request For Enhancement) in the ICU bug database, or
submit one.

The code contribution will be checked into a special part of the ICU source code
repository and evaluated. The ICU team may request updates, for example for
better conformance with the ICU [design](../design.md) principles,
[coding](codingguidelines.md) and testing guidelines, or performance. (See also
the Requirements (§) above.) Such updates can be contributed without exchanging
another form: An ICU team member commits related materials into the ICU source
code repository using the same bug ID that was entered into the copyright
assignment form.

### Ongoing Contributors

If you are interested in making frequent contributions to ICU, then the ICU
Project Management Committee may agree to invite you as an ongoing contributor.
Ongoing contributors may be individuals but are more typically expected to be
companies with one or more people ("authors") writing different parts of one or
more contributions.

In this case, the relationship between the contributor and the ICU team is much
closer: One or more authors belonging to the contributor will have commit access
to the ICU source code repository. With this direct access come additional
responsibilities including an understanding that the contributor will work to
follow the technical Requirements (§) above for contributions, and agreement to
adhere to the terms of the copyright assignment forms for all future
contributions.

The process for ongoing contributors involves two types of forms: Initially, and
only once, an ongoing contributor submits a *Joint Copyright Assignment by
Ongoing Contributor* form, agreeing to essentially the same terms as in the
one-time contributor form, for all future contributions. (See the form at
<https://github.com/unicode-org/icu-docs/blob/main/legal/contributions/Copyright_Assignment_ongoing.rtf>).

The contributor must also send another form, *Addendum to Joint Copyright
Assignment by Ongoing Contributor: Authors*, for the initial set and each
addition of authors to ICU contributions, **before** any contributions from
these authors are committed into the ICU source code repository. (Only new,
additional authors need to be listed on each such form.) The contributor agrees
to ensure that all of these authors agree to adhere to the terms of the
associated *Joint Copyright Assignment by Ongoing Contributor Agreement*. (See
the Authors Addendum form at
<https://github.com/unicode-org/icu-docs/blob/main/legal/contributions/Copyright_Assignment_authors.rtf>).

Some of an ongoing contributor's authors will have commit access to the ICU
source code repository. Their committer IDs need to be established before
completing the Authors Addendum form, so that these committer IDs can be entered
there. (The committer IDs should be activated only after the form is received.)

Committer authors commit materials directly into the appropriate parts of the
ICU source code repository. Contributions from an ongoing contributor are
identified by their association with the contributor's committer IDs.

### Previous Contributions

All previous "one-off" contributions from non-IBM sources to ICU are listed on
the code contributions page in ICU's source code repository. The page contains
links to the softcopies of the Joint Copyright Assignment forms. See
<https://htmlpreview.github.io/?https://github.com/unicode-org/icu-docs/blob/main/legal/contributions/code_contributions.html>

In addition, the following non-IBM companies are registered as Ongoing
Contributors:

*   Apple
*   Google

See the repository folder that contains the contributions page for the full set
of softcopies of contributor agreements including one-off contributions,
ongoing-contributor agreements and author-addendum documents to
ongoing-contributor agreements:
<https://github.com/unicode-org/icu-docs/tree/main/legal/contributions>
