/// A map from words to number of syllables.
///
/// From
/// https://raw.githubusercontent.com/wooorm/syllable/master/test/fixture.json
const Map<String, int> syllableTestData = {
  "abalone": 4,
  "abare": 3,
  "abatement": 3,
  "abatements": 3,
  "abbatiello": 5,
  "abbruzzese": 4,
  "abed": 2,
  "abeyance": 3,
  "aborigine": 5,
//  "aborigines": 5,
  "abounded": 3,
  "aboveboard": 3,
  "aboveground": 3,
  "abridged": 2,
  "abruzzese": 4,
  "absences": 3,
  "absoluteness": 4,
  "absolve": 2,
  "absolves": 2,
  "abuses": 3,
  "acacia": 3,
  "academically": 6,
  "academician": 5,
  "academicians": 5,
  "acceding": 3,
  "acceptances": 4,
  "accion": 3,
  "accompaniment": 5,
  "accompaniments": 5,
  "accomplice": 3,
  "accomplices": 4,
  "accorded": 3,
  "accordion": 4,
  "accuses": 3,
  "aces": 2,
  "achievement": 3,
  "achievements": 3,
  "achoa": 3,
  "acknowledged": 3,
  "acknowledgement": 4,
  "acknowledges": 4,
  "acoustically": 5,
  "acquaint": 2,
  "acquaintance": 3,
  "acquainted": 3,
  "acquiesced": 3,
  "acquire": 2,
  "acquired": 2,
  "acquirer": 3,
  "acquirers": 3,
  "acquires": 2,
  "acreage": 3,
  "acuteness": 3,
  "adabelle": 3,
  "adage": 2,
  "adame": 3,
  "added": 2,
  "addeo": 3,
  "addled": 2,
  "adelle": 2,
  "adieu": 2,
  "adjudged": 2,
  "admired": 2,
  "adorabelle": 4,
  "advanced": 2,
  "advancement": 3,
  "advancements": 3,
  "advances": 3,
  "advantage": 3,
  "advantaged": 3,
  "advantageous": 4,
  "advantages": 4,
  "adventuresome": 4,
  "advertisement": 4,
  "advertisements": 4,
  "advertises": 4,
  "advice": 2,
  "advisedly": 4,
  "advisement": 3,
  "advises": 3,
  "aegean": 3,
  "aerobically": 5,
  "aerodynamically": 7,
  "aerospace": 3,
  "aerospatiale": 4,
  "aesthetically": 5,
  "afanasyev": 5,
  "affixes": 3,
  "affluence": 3,
  "affluent": 3,
  "afforded": 3,
  "aforementioned": 4,
  "aforesaid": 3,
  "afterimage": 4,
  "aftertaste": 3,
  "aged": 1,
  "ageless": 2,
  "ages": 2,
  "aggrandizement": 4,
  "aggressiveness": 4,
  "agius": 3,
  "agne": 1,
  "agonizes": 4,
  "agreement": 3,
  "agribusiness": 4,
  "aguayo": 3,
  "aherne": 2,
  "aiguebelle": 3,
  "airborne": 2,
  "aircoa": 3,
  "airspace": 2,
  "aisle": 1,
  "aisles": 1,
  "akiyama": 4,
  "alarice": 3,
  "albertville": 3,
  "albion": 3,
  "alcoa": 3,
  "aldred": 2,
  "aleo": 3,
  "algeo": 3,
  "algorithm": 4,
  "aliases": 4,
  "alice": 2,
  "alicia": 3,
  "allderdice": 3,
  "allege": 2,
  "alleged": 2,
  "alleges": 3,
  "allegiances": 5,
  "alles": 1,
  "alliances": 4,
  "allowances": 4,
  "allspice": 2,
  "allwaste": 2,
  "alsace": 2,
  "altarpiece": 3,
  "altice": 2,
  "alusuisse": 3,
  "alveolar": 4,
  "alveoli": 4,
  "alyce": 2,
  "alyea": 3,
  "alyeska": 4,
  "amabelle": 3,
  "amadea": 4,
  "amadeo": 4,
  "amaryllises": 5,
  "amaya": 3,
  "amazement": 3,
  "amazes": 3,
  "ambled": 2,
  "ambrosial": 3,
  "ambrosian": 3,
  "ambulances": 4,
  "amended": 3,
  "amezcua": 4,
  "amityville": 4,
  "amorette": 3,
  "amperage": 3,
  "amusement": 3,
  "amusements": 3,
  "amuses": 3,
  "analyses": 4,
  "analyzes": 4,
  "anaya": 3,
  "anchorage": 3,
  "andalusian": 4,
  "andreoli": 4,
  "andreoni": 4,
  "andreotti": 4,
  "andreozzi": 4,
  "anette": 2,
  "angelle": 2,
  "angerer": 3,
  "angering": 3,
  "angled": 2,
  "anisette": 3,
  "annabelle": 3,
  "anne": 1,
  "annette": 2,
  "annexes": 3,
  "announced": 2,
  "announcement": 3,
  "announcements": 3,
  "announces": 3,
  "annoyance": 3,
  "annoyances": 4,
  "anstice": 2,
  "antaya": 3,
  "antiabortion": 5,
  "antiapartheid": 5,
  "antoinette": 3,
  "anyplace": 3,
  "anzaldua": 4,
  "aoyama": 3,
  "apace": 2,
  "apiece": 2,
  "apologizes": 5,
  "apotheosis": 5,
  "apparatuses": 5,
  "appearances": 4,
  "appeasement": 3,
  "appendage": 3,
  "appendages": 4,
  "appended": 3,
  "appendixes": 4,
  "applesauce": 3,
  "appleyard": 3,
  "appliances": 4,
  "appraises": 3,
  "apprehended": 4,
  "apprentice": 3,
  "apprenticed": 3,
  "apprentices": 4,
  "apprenticeship": 4,
  "approached": 2,
  "appropriateness": 5,
  "araya": 3,
  "arbed": 2,
  "arbitrage": 3,
  "arboreal": 4,
  "arceneaux": 3,
  "arceo": 3,
  "archambeau": 3,
  "archambeault": 3,
  "archeological": 6,
  "archeology": 5,
  "arches": 2,
  "ardelle": 2,
  "argonne": 2,
  "ariella": 4,
  "arises": 3,
  "arlette": 2,
  "armistice": 3,
  "armitage": 3,
  "arne": 1,
  "arnelle": 2,
  "arnette": 2,
  "arouses": 3,
  "arranged": 2,
  "arrangement": 3,
  "arrangements": 3,
  "arranges": 3,
  "arrearage": 3,
  "arrearages": 4,
  "arreola": 4,
  "arriortua": 5,
  "arroyo": 3,
  "arseneau": 3,
  "arseneault": 3,
  "artifice": 3,
  "aryan": 3,
  "ascended": 3,
  "asiain": 3,
  "asian": 2,
  "asians": 2,
  "asiaweek": 3,
  "assemblage": 3,
  "assembled": 3,
  "assertiveness": 4,
  "assurances": 4,
  "astounded": 3,
  "astuteness": 3,
  "atalaya": 4,
  "atlases": 3,
  "atonement": 3,
  "attached": 2,
  "attended": 3,
  "attentiveness": 4,
  "attractiveness": 4,
  "audette": 2,
  "audiences": 4,
  "auguste": 2,
  "auspices": 3,
  "authement": 2,
  "authorizes": 4,
  "auyeung": 2,
  "auzenne": 2,
  "avarice": 3,
  "avedisian": 4,
  "avenged": 2,
  "average": 3,
  "averette": 3,
  "avice": 2,
  "avowedly": 4,
  "awarded": 3,
  "awareness": 3,
  "AWOL": 2,
  "axes": 2,
  "ayacucho": 4,
  "ayala": 3,
  "ayars": 2,
  "ayatollah": 4,
  "ayatollahs": 4,
  "Ayatullah": 4,
  "ayerst": 2,
  "ayo": 2,
  "ayon": 2,
  "ayoub": 2,
  "ayuso": 3,
  "ayyad": 2,
  "azpurua": 4,
  "babbled": 2,
  "babette": 2,
  "babineau": 3,
  "babineaux": 3,
  "babyak": 3,
  "backhanded": 3,
  "backstage": 2,
  "badeau": 2,
  "badeaux": 2,
  "badgering": 3,
  "badges": 2,
  "baffled": 2,
  "baggage": 2,
  "baidoa": 3,
  "balanced": 2,
  "balances": 3,
  "balboa": 3,
  "baldrige": 2,
  "balle": 1,
  "balles": 1,
  "balliet": 3,
  "balyeat": 3,
  "bandage": 2,
  "bandaged": 2,
  "bandages": 3,
  "banded": 2,
  "banville": 2,
  "baptiste": 2,
  "barbeau": 2,
  "barbette": 2,
  "barcia": 2,
  "barges": 2,
  "baribeau": 3,
  "barlage": 2,
  "barnes": 1,
  "barnette": 2,
  "barrage": 2,
  "barraged": 2,
  "barrages": 3,
  "barrette": 2,
  "barrilleaux": 3,
  "barrineau": 3,
  "bartlesville": 3,
  "bartolomeo": 5,
  "basaldua": 4,
  "basement": 2,
  "basements": 2,
  "bases": 2,
  "baskerville": 3,
  "baskette": 2,
  "basque": 1,
  "basques": 1,
  "basse": 1,
  "bassette": 2,
  "bastille": 2,
  "bastogne": 2,
  "batches": 2,
  "batesville": 2,
  "bathe": 1,
  "bathed": 1,
  "bathes": 1,
  "battelle": 2,
  "batticaloa": 5,
  "bayard": 2,
  "bayog": 2,
  "bayonet": 3,
  "bayonets": 3,
  "bayou": 2,
  "bayous": 2,
  "bayuk": 2,
  "bayus": 2,
  "bearded": 2,
  "beau": 1,
  "beaubien": 2,
  "beauchaine": 2,
  "beauchamp": 2,
  "beauchemin": 3,
  "beauchene": 2,
  "beaudet": 2,
  "beaudette": 2,
  "beaudin": 2,
  "beaudoin": 2,
  "beaudreau": 2,
  "beaudry": 2,
  "beauford": 2,
  "beaufort": 2,
  "beaufrere": 2,
  "beaujolais": 3,
  "beaulac": 2,
  "beaumier": 3,
  "beaumont": 2,
  "beaupre": 2,
  "beauregard": 3,
  "beausoleil": 3,
  "beautician": 3,
  "beauties": 2,
  "beautiful": 3,
  "beautify": 3,
  "beauty": 2,
  "beauvais": 2,
  "beaux": 1,
  "bebeau": 2,
  "becherer": 3,
  "bedoya": 3,
  "bedraggled": 3,
  "bedrosian": 3,
  "Beetlejuice": 3,
  "befriended": 3,
  "befuddled": 3,
  "beidaihe": 3,
  "beiges": 2,
  "beirne": 1,
  "belge": 2,
  "beliveau": 3,
  "belle": 1,
  "belleau": 2,
  "bellefeuille": 4,
  "belles": 1,
  "belleville": 2,
  "belliveau": 3,
  "bellville": 2,
  "bellyache": 3,
  "belonged": 2,
  "beltsville": 2,
  "belville": 2,
  "belyea": 3,
  "belyeu": 3,
  "bemusement": 3,
  "bended": 2,
  "benne": 1,
  "bennette": 2,
  "bentonville": 3,
  "beowulf": 3,
  "bereavement": 3,
  "berges": 2,
  "berjaya": 3,
  "bernadette": 3,
  "berne": 1,
  "berneice": 2,
  "bernice": 2,
  "beseiged": 2,
  "besiege": 2,
  "besieged": 2,
  "beske": 1,
  "bespectacled": 4,
  "besse": 1,
  "bessette": 2,
  "beste": 1,
  "bethpage": 2,
  "betrayal": 3,
  "betrayals": 3,
  "beverage": 3,
  "beville": 2,
  "beyond": 2,
  "biases": 3,
  "bibeau": 2,
  "bibeault": 2,
  "bicycled": 3,
  "bierbusse": 2,
  "bille": 1,
  "billes": 1,
  "bilodeau": 3,
  "bilyeu": 3,
  "binette": 2,
  "binges": 2,
  "biondi": 3,
  "biondo": 3,
  "biondolillo": 5,
  "bionetics": 4,
  "birthplace": 2,
  "bisque": 1,
  "bissette": 2,
  "bissonette": 3,
  "bissonnette": 3,
  "bistodeau": 3,
  "bivalve": 2,
  "bivalves": 2,
  "blanchette": 2,
  "blaske": 1,
  "blazes": 2,
  "bleau": 1,
  "blended": 2,
  "blinded": 2,
  "blindfolded": 3,
  "blithe": 1,
  "blithely": 2,
  "blockage": 2,
  "blockages": 3,
  "blouses": 2,
  "blythe": 1,
  "boa": 2,
  "boarded": 2,
  "boardinghouses": 4,
  "bobbette": 2,
  "bobsled": 2,
  "boccia": 2,
  "bocian": 2,
  "boggled": 2,
  "boghosian": 3,
  "bogosian": 3,
  "boguslavskaya": 5,
  "boileau": 2,
  "boisseau": 2,
  "boissonneault": 3,
  "boldface": 2,
  "bolle": 1,
  "bolles": 1,
  "bombarded": 3,
  "bondage": 2,
  "bonded": 2,
  "bonne": 1,
  "bonneau": 2,
  "bonnes": 1,
  "bonnette": 2,
  "bonnibelle": 3,
  "bonuses": 3,
  "bonville": 2,
  "bookcases": 3,
  "bookshelves": 2,
  "boomeranged": 3,
  "boonville": 2,
  "boothe": 1,
  "bordeau": 2,
  "bordeaux": 2,
  "borealis": 4,
  "borges": 2,
  "borne": 1,
  "borneo": 3,
  "borosage": 3,
  "boscia": 2,
  "bosse": 1,
  "bothe": 1,
  "boudreau": 2,
  "boudreaux": 2,
  "bougainville": 3,
  "boulette": 2,
  "bounces": 2,
  "bounded": 2,
  "bourbeau": 2,
  "bourdeau": 2,
  "bourne": 1,
  "bournonville": 3,
  "boutelle": 2,
  "boxes": 2,
  "boyack": 2,
  "boyajian": 4,
  "boyan": 2,
  "boyar": 2,
  "boyett": 2,
  "boyington": 3,
  "boyish": 2,
  "boyum": 2,
  "braces": 2,
  "braille": 1,
  "brailles": 1,
  "bralorne": 2,
  "bramlage": 2,
  "bramlette": 2,
  "brancheau": 2,
  "branded": 2,
  "brasseaux": 2,
  "brazeau": 2,
  "brazzaville": 3,
  "breakage": 2,
  "breathe": 1,
  "breathed": 1,
  "breathes": 1,
  "breau": 1,
  "breault": 1,
  "breaux": 1,
  "breezes": 2,
  "breon": 2,
  "brescia": 2,
  "bresette": 2,
  "bresse": 1,
  "bressette": 2,
  "brideau": 2,
  "bridgeport": 2,
  "bridges": 2,
  "bridled": 2,
  "briefcases": 3,
  "brion": 2,
  "brissette": 2,
  "britches": 2,
  "brokerage": 3,
  "brokerages": 4,
  "brokering": 3,
  "brooksville": 2,
  "brosseau": 2,
  "brossette": 2,
  "brousseau": 2,
  "brownsville": 2,
  "bruegge": 2,
  "bruges": 2,
  "bruises": 2,
  "brundage": 2,
  "brundige": 2,
  "bruneau": 2,
  "brunelle": 2,
  "brunette": 2,
  "bruske": 1,
  "brusque": 1,
  "brusquely": 2,
  "brusseau": 2,
  "brutalizes": 4,
  "brutsche": 2,
  "bryan": 2,
  "bryans": 2,
  "bryant": 2,
  "bryars": 2,
  "brydges": 2,
  "bryen": 2,
  "bua": 2,
  "bubbled": 2,
  "Bubiyan": 3,
  "buckled": 2,
  "budreau": 2,
  "bulges": 2,
  "bundled": 2,
  "bungled": 2,
  "buoyancy": 3,
  "buoyant": 2,
  "burbage": 2,
  "burchette": 2,
  "burdette": 2,
  "bureau": 2,
  "bureaucracies": 4,
  "bureaucracy": 4,
  "bureaucrat": 3,
  "bureaucratic": 4,
  "bureaucrats": 3,
  "bureaus": 2,
  "burlesque": 2,
  "burne": 1,
  "burnes": 1,
  "burnette": 2,
  "burrage": 2,
  "buses": 2,
  "business": 2,
  "businesses": 3,
  "buske": 1,
  "busse": 1,
  "butchering": 3,
  "buteau": 2,
  "buttonville": 3,
  "buyout": 2,
  "buyouts": 2,
  "buysse": 1,
  "byam": 2,
  "byars": 2,
  "byas": 2,
  "byassee": 3,
  "byerley": 3,
  "byrne": 1,
  "byrnes": 1,
  "cabbage": 2,
  "cabbages": 3,
  "cabled": 2,
  "cableone": 3,
  "cabooses": 3,
  "cabotage": 3,
  "cacace": 2,
  "caccia": 2,
  "cadences": 3,
  "cadorette": 3,
  "cafe": 2,
//  "cafes": 2,
  "cages": 2,
  "cairnes": 1,
  "caisse": 1,
  "calif": 2,
  "california": 5,
  "californian": 5,
  "californians": 5,
  "calle": 1,
  "calles": 1,
  "calves": 1,
  "cambridgeport": 3,
  "cambridgeside": 3,
  "cameo": 3,
  "cameos": 3,
  "camerer": 3,
  "camille": 2,
  "camouflage": 3,
  "camouflaged": 3,
  "campeau": 2,
  "campion": 3,
  "campuses": 3,
  "canadienne": 4,
  "candace": 2,
  "candice": 2,
  "cannes": 1,
  "cantrelle": 2,
  "canvases": 3,
  "capece": 2,
  "capelle": 2,
  "capitalizes": 5,
  "cappiello": 4,
  "caprice": 2,
  "capua": 3,
  "caravelle": 3,
  "caraveo": 4,
  "carbonneau": 3,
  "carcione": 3,
  "carded": 2,
  "cardiges": 3,
  "caresse": 2,
  "cariello": 4,
  "carlisle": 2,
  "carnage": 2,
  "carne": 1,
  "carnes": 1,
  "carreon": 3,
  "carrion": 3,
  "carriveau": 3,
  "cartaya": 3,
  "cartersville": 3,
  "carthage": 2,
  "cartilage": 3,
  "cartrette": 2,
  "cartridges": 3,
  "cartusciello": 5,
  "carves": 1,
  "carville": 2,
  "cases": 2,
  "cassette": 2,
  "cassettes": 2,
  "caste": 1,
  "castille": 2,
  "cataloged": 3,
  "cataloguing": 4,
  "catches": 2,
  "categorizes": 5,
  "cattaneo": 4,
  "caucasian": 3,
  "caucuses": 3,
  "causes": 2,
  "cawthorne": 2,
  "caya": 2,
  "cayuses": 3,
  "ceases": 2,
  "ceausescu": 3,
  "ceder": 2,
  "ceding": 2,
  "celaya": 3,
  "celeste": 2,
  "censuses": 3,
  "centerpiece": 3,
  "centrifuge": 3,
  "centrifuges": 4,
  "ceraceous": 3,
  "cereal": 3,
  "cereals": 3,
  "cezanne": 2,
  "chadbourne": 2,
  "challenged": 2,
  "challenges": 3,
  "chalmette": 2,
  "chameleon": 4,
  "champagne": 2,
  "champagnes": 2,
  "champeau": 2,
  "champion": 3,
  "championed": 3,
  "championing": 4,
  "champions": 3,
  "championship": 4,
  "championships": 4,
  "chances": 2,
  "changes": 2,
  "chapelle": 2,
  "chappelle": 2,
  "characterizes": 5,
  "charasse": 2,
  "charboneau": 3,
  "charbonneau": 3,
  "charette": 2,
  "charges": 2,
  "charlemagne": 3,
  "charmion": 3,
  "chases": 2,
  "chasm": 2,
  "chasse": 1,
  "chaste": 1,
  "chastises": 3,
  "chateau": 2,
  "chateaux": 2,
  "chausse": 1,
  "chechnya": 3,
  "chechnyan": 3,
  "cheeses": 2,
  "chelette": 2,
  "chenette": 2,
  "cheong": 2,
  "chequing": 2,
  "cherne": 1,
  "chevette": 2,
  "chevrette": 2,
  "chiyoda": 3,
  "choices": 2,
  "chooses": 2,
  "choreograph": 4,
  "choreographed": 4,
  "choreographer": 5,
  "choreographers": 5,
  "choreographic": 5,
  "choreography": 5,
  "choruses": 3,
  "christabelle": 3,
  "chronicled": 3,
  "chua": 2,
  "chuckled": 2,
  "chujitsuya": 4,
  "churches": 2,
  "cian": 1,
  "cigarette": 3,
  "cigarettes": 3,
  "cilicia": 3,
  "circled": 2,
  "circumstances": 4,
  "circuses": 3,
  "ciriello": 4,
  "cirincione": 4,
  "cirrincione": 4,
  "cistercian": 3,
  "cityplace": 3,
  "claiborne": 2,
  "clairvoyance": 3,
  "clarabelle": 3,
  "clarette": 2,
  "clarice": 2,
  "clarisse": 2,
  "clarksville": 2,
  "clarrisse": 2,
  "claudette": 2,
  "clauses": 2,
  "clavette": 2,
  "clayborne": 2,
  "claybourne": 2,
  "clayey": 2,
  "clearances": 3,
  "clearinghouses": 4,
  "cleavage": 2,
  "cleo": 2,
  "cleopatra": 4,
  "climaxes": 3,
  "clinician": 3,
  "clinicians": 3,
  "clodoveo": 4,
  "closeness": 2,
  "closes": 2,
  "clothe": 1,
  "clothed": 1,
  "clothes": 1,
  "clubhouses": 3,
  "clutches": 2,
  "clyatt": 2,
  "coalesced": 3,
  "coatesville": 2,
  "cobbled": 2,
  "coccia": 2,
  "coddled": 2,
  "coercion": 3,
  "cohesiveness": 4,
  "coinage": 2,
  "cointreau": 2,
  "colette": 2,
  "collage": 2,
  "collages": 3,
  "colle": 1,
  "college": 2,
  "colleges": 3,
  "collegeville": 3,
  "collette": 2,
  "colleville": 2,
  "cologne": 2,
  "colville": 2,
  "comanche": 3,
  "combativeness": 4,
  "comeau": 2,
  "comeaux": 2,
  "comedienne": 4,
  "commanded": 3,
  "commenced": 2,
  "commencement": 3,
  "commences": 3,
  "commended": 3,
  "commingled": 3,
  "commonplace": 3,
  "compeau": 2,
  "competitiveness": 5,
  "completeness": 3,
  "complexes": 3,
  "composes": 3,
  "compounded": 3,
  "comprehended": 4,
  "comprises": 3,
  "compromises": 4,
  "conceding": 3,
  "concepcion": 4,
  "concierge": 3,
  "concubinage": 4,
  "condolences": 4,
  "conferences": 4,
  "confidences": 4,
  "confinement": 3,
  "confluence": 3,
  "confounded": 3,
  "confucian": 3,
  "confuses": 3,
  "congruence": 3,
  "connely": 2,
  "consciences": 3,
  "constituencies": 5,
  "constituency": 5,
  "constituent": 4,
  "constituents": 4,
  "contended": 3,
  "continuances": 5,
  "contrivances": 4,
  "controversial": 4,
  "conveniences": 4,
  "conveyance": 3,
  "conveyor": 3,
  "conville": 2,
  "convinced": 2,
  "convinces": 3,
  "cooperage": 3,
  "coppage": 2,
  "corabelle": 3,
  "corded": 2,
  "corette": 2,
  "corinne": 2,
  "corne": 1,
  "cornelle": 2,
  "cornette": 2,
  "corresponded": 4,
  "corriveau": 3,
  "corsage": 2,
  "corvette": 2,
  "corvettes": 2,
  "coscia": 2,
  "cosette": 2,
  "cossette": 2,
  "coste": 1,
  "cotelle": 2,
  "cotroneo": 4,
  "cottage": 2,
  "cottages": 3,
  "countenanced": 3,
  "countenances": 4,
  "counterbalanced": 4,
  "countercharges": 4,
  "counterespionage": 6,
  "coupled": 2,
  "courage": 2,
  "courageous": 3,
  "courageously": 4,
  "courteau": 2,
  "courthouses": 3,
  "courville": 2,
  "cousineau": 3,
  "coverage": 3,
  "coverages": 4,
  "covering": 3,
  "coverings": 3,
  "coviello": 4,
  "coville": 2,
  "cowardice": 3,
  "cowering": 3,
  "crackled": 2,
  "crawfordsville": 3,
  "crayon": 2,
  "crayons": 2,
  "creole": 2,
  "creoles": 2,
  "creolized": 3,
  "creosote": 3,
  "crepeau": 2,
  "crevice": 2,
  "crevices": 3,
  "cribbage": 2,
  "cringes": 2,
  "crippled": 2,
  "criscione": 3,
  "crises": 2,
  "criticizes": 4,
  "crocuses": 3,
  "crosse": 1,
  "crosspiece": 2,
  "crosspieces": 3,
  "croteau": 2,
  "crotonville": 3,
  "crotteau": 2,
  "crowded": 2,
  "cruces": 2,
  "crucifixes": 4,
  "cruises": 2,
  "crumbled": 2,
  "crumpled": 2,
  "crutches": 2,
  "cryan": 2,
  "cubbage": 2,
  "cuccia": 2,
  "cuddled": 2,
  "cuddling": 2,
  "cuneo": 3,
  "curtice": 2,
  "curves": 1,
  "cuteness": 2,
  "cuyahoga": 4,
  "cyacq": 2,
  "cyanamid": 4,
  "cyanazine": 4,
  "cyanide": 3,
  "cyanuric": 4,
  "cyberspace": 3,
  "cycled": 2,
  "cytoplasm": 4,
  "dabbled": 2,
  "daigneault": 2,
  "daleo": 3,
  "damage": 2,
  "damaged": 2,
  "damages": 3,
  "damme": 1,
  "dances": 2,
  "dandeneau": 3,
  "danelle": 2,
  "dangled": 2,
  "daniello": 4,
  "dansereau": 3,
  "danville": 2,
  "dapice": 2,
  "darbonne": 2,
  "darice": 2,
  "darrelle": 2,
  "darville": 2,
  "databases": 4,
  "daya": 2,
  "dayan": 2,
  "dazzled": 2,
  "deathbed": 2,
  "deatherage": 3,
  "debasement": 3,
  "debrosse": 2,
  "decapua": 4,
  "decelle": 2,
  "decelles": 2,
  "decisiveness": 4,
  "decomposes": 4,
  "decoteau": 3,
  "decreases": 3,
  "dedeaux": 2,
  "deduce": 2,
  "deduced": 2,
  "defaced": 2,
  "defarges": 3,
  "defelice": 3,
  "defended": 3,
  "defensiveness": 4,
  "defeo": 3,
  "degaulle": 2,
  "dehoyos": 3,
  "dejarnette": 3,
  "delage": 2,
  "delbosque": 2,
  "deleo": 3,
  "deleon": 3,
  "deleonardis": 5,
  "delfosse": 2,
  "delgiudice": 3,
  "delguidice": 3,
  "delicia": 3,
  "delisle": 2,
  "deliverers": 4,
  "delivering": 4,
  "delle": 1,
  "delmed": 2,
  "deluccia": 3,
  "delucia": 3,
  "deluge": 2,
  "deluged": 2,
  "delve": 1,
  "delves": 1,
  "demanded": 3,
  "dematteo": 4,
  "demayo": 3,
  "demeo": 3,
  "demilitarizes": 6,
  "demme": 1,
  "deneau": 2,
  "deneault": 2,
  "denice": 2,
  "denne": 1,
  "denomme": 2,
  "denounced": 2,
  "denounces": 3,
  "deo": 2,
  "deodorant": 4,
  "deodorants": 4,
  "deoliveira": 5,
  "deon": 2,
  "depended": 3,
  "deployable": 4,
  "deranged": 2,
  "derousse": 2,
  "descended": 3,
  "descoteaux": 3,
  "deserves": 2,
  "desormeaux": 3,
  "despises": 3,
  "desselle": 2,
  "detached": 2,
  "deterioration": 6,
  "detherage": 3,
  "dettling": 2,
  "deveau": 2,
  "deveaux": 2,
  "develle": 2,
  "devereaux": 3,
  "device": 2,
  "devices": 3,
  "deville": 2,
  "devises": 3,
  "deyo": 2,
  "deyoe": 2,
  "deyoung": 2,
  "diagnoses": 4,
  "dianthia": 4,
  "diaphonia": 5,
  "dibartolomeo": 6,
  "dibbled": 2,
  "diceon": 3,
  "dideoxycytidine": 7,
  "dieringer": 3,
  "dieses": 2,
  "diet": 2,
  "dieters": 3,
  "difelice": 3,
  "differences": 4,
  "diffuses": 3,
  "dileo": 3,
  "dileonardo": 5,
  "dille": 1,
  "dimatteo": 4,
  "dimeo": 3,
  "dimpled": 2,
  "dinges": 2,
  "dion": 2,
  "diona": 3,
  "dione": 2,
  "dionysius": 5,
  "disabled": 3,
  "disadvantage": 4,
  "disadvantaged": 4,
  "disadvantageous": 5,
  "disadvantages": 5,
  "disallowances": 5,
  "disappearances": 5,
  "disassembled": 4,
  "disbanded": 3,
  "disbursement": 3,
  "disbursements": 3,
  "discarded": 3,
  "discharges": 3,
  "discloses": 3,
  "discourage": 3,
  "discouraged": 3,
  "discouragement": 4,
  "discourages": 4,
  "discovering": 4,
  "diseases": 3,
  "disenfranchisement": 5,
  "disengage": 3,
  "disengaged": 3,
  "disengagement": 4,
  "disgrace": 2,
  "disgraced": 2,
  "disgraceful": 3,
  "disguises": 3,
  "diskette": 2,
  "diskettes": 2,
  "dislodged": 2,
  "disloyal": 3,
  "disloyalty": 4,
  "disparage": 3,
  "disparaged": 3,
  "disparages": 4,
  "dispatches": 3,
  "displace": 2,
  "displaced": 2,
  "displacement": 3,
  "displacements": 3,
  "displaces": 3,
  "disposes": 3,
  "disregarded": 4,
  "disservice": 3,
  "dissolve": 2,
  "dissolves": 2,
  "distanced": 2,
  "distances": 3,
  "distaste": 2,
  "distasteful": 3,
  "distended": 3,
  "distinctiveness": 4,
  "disturbances": 4,
  "ditches": 2,
  "divergences": 4,
  "diverges": 3,
  "divisiveness": 4,
  "divorced": 2,
  "divorces": 3,
  "dodges": 2,
  "doenges": 2,
  "doggedly": 3,
  "dolce": 2,
  "dolle": 1,
  "donne": 1,
  "doralynne": 3,
  "doraville": 3,
  "dorette": 2,
  "dorice": 2,
  "dOrsay": 2,
  "dosage": 2,
  "dosages": 3,
  "doses": 2,
  "doubled": 2,
  "doucette": 2,
  "douville": 2,
  "downstage": 2,
  "doyal": 2,
  "doyel": 2,
  "doyen": 2,
  "doyon": 2,
  "drainage": 2,
  "dralle": 1,
  "dramatizes": 4,
  "drapeau": 2,
  "dredges": 2,
  "dressage": 2,
  "dribbled": 2,
  "droste": 1,
  "dubeau": 2,
  "duchenne": 2,
  "duchesneau": 3,
  "dudayev": 3,
  "duena": 3,
  "duenas": 3,
  "dukakises": 4,
  "dulcibelle": 3,
  "dulle": 1,
  "dumbfounded": 3,
  "dunne": 1,
  "durette": 2,
  "duryea": 3,
  "dusseau": 2,
  "dusseault": 2,
  "dwelle": 1,
  "dwindled": 2,
  "dyad": 2,
  "dyal": 2,
  "dyana": 3,
  "dyane": 2,
  "dyansen": 3,
  "dyar": 2,
  "dyas": 2,
  "dyatron": 3,
  "dyazide": 3,
  "dyess": 2,
  "easement": 2,
  "eases": 2,
  "eastes": 1,
  "eau": 1,
  "eaux": 1,
  "edges": 2,
  "edifice": 3,
  "edithe": 2,
  "edythe": 2,
  "effectiveness": 4,
  "efficiences": 4,
  "effluent": 3,
  "egerer": 3,
  "Ehud": 2,
  "eldred": 2,
  "electrician": 4,
  "electricians": 4,
  "electrospace": 4,
  "elle": 1,
  "ellesse": 2,
  "ellette": 2,
  "ellice": 2,
  "elusiveness": 4,
  "elves": 1,
  "embed": 2,
  "embedded": 3,
  "embezzled": 3,
  "embrace": 2,
  "embraced": 2,
  "embraces": 3,
  "embryology": 5,
  "emerges": 3,
  "emeryville": 4,
  "eminences": 4,
  "emlynne": 2,
  "emme": 1,
  "emphases": 3,
  "emphasizes": 4,
  "emplacement": 3,
  "employable": 4,
  "employee": 3,
  "employees": 3,
  "empowering": 4,
  "enabled": 3,
  "encircled": 3,
  "encourage": 3,
  "encouraged": 3,
  "encouragement": 4,
  "encourages": 4,
  "encroached": 2,
  "endangering": 4,
  "ended": 2,
  "endorsement": 3,
  "endorsements": 3,
  "enfeebled": 3,
  "enforced": 2,
  "enforcement": 3,
  "enforces": 3,
  "enfranchises": 4,
  "engage": 2,
  "engaged": 2,
  "engagement": 3,
  "engagements": 3,
  "engages": 3,
  "enhanced": 2,
  "enhancement": 3,
  "enhancements": 3,
  "enhances": 3,
  "enjoyable": 4,
  "enlarges": 3,
  "ennes": 1,
  "enrage": 2,
  "enraged": 2,
  "enriched": 2,
  "ensconced": 2,
  "enslavement": 3,
  "entangled": 3,
  "enterprises": 4,
  "enthuses": 3,
  "enthusiastically": 6,
  "entice": 2,
  "enticed": 2,
  "enticement": 3,
  "enticements": 3,
  "entourage": 3,
  "entranced": 2,
  "entrances": 3,
  "entrenched": 2,
  "envisage": 3,
  "envisaged": 3,
  "envisages": 4,
  "eocene": 3,
  "eoff": 2,
  "eohippus": 4,
  "eolande": 4,
  "eon": 2,
  "eons": 2,
  "epitomizes": 5,
  "erases": 3,
  "erne": 1,
  "escapement": 3,
  "espionage": 4,
  "espouses": 3,
  "essayist": 3,
  "esse": 1,
  "este": 1,
  "estelle": 2,
  "estranged": 2,
  "estrangement": 3,
  "etches": 2,
  "ethereal": 4,
  "ettlinger": 3,
  "etzioni": 4,
  "eudocia": 3,
  "eunice": 2,
  "eurasian": 3,
  "europeenne": 3,
  "euroyen": 3,
  "eustace": 2,
  "eustacia": 3,
  "eustice": 2,
  "evansville": 3,
  "evenhanded": 4,
  "evenhandedly": 5,
  "everage": 3,
  "everette": 3,
  "evidenced": 3,
  "evidences": 4,
  "evinced": 2,
  "evolve": 2,
  "evolves": 2,
  "evonne": 2,
  "exchanged": 2,
  "exchanges": 3,
  "excises": 3,
  "excitement": 3,
  "excoa": 3,
  "excuses": 3,
  "exercises": 4,
  "exes": 2,
  "expanded": 3,
  "expended": 3,
  "exposes": 3,
  "expounded": 3,
  "expunged": 2,
  "extended": 3,
  "extraordinaire": 5,
  "eyerman": 3,
  "ezelle": 2,
  "fabled": 2,
  "faceless": 2,
  "faces": 2,
  "facteau": 2,
  "falardeau": 3,
  "fangled": 2,
  "fantasizes": 4,
  "fariello": 4,
  "farmhouses": 3,
  "farnes": 1,
  "faucette": 2,
  "favreau": 2,
  "faxes": 2,
  "fayard": 2,
  "fayez": 2,
  "faymonville": 3,
  "feces": 2,
  "fecteau": 2,
  "fejes": 2,
  "felice": 2,
  "felicia": 3,
  "felrice": 2,
  "femme": 1,
  "fences": 2,
  "fended": 2,
  "feodor": 3,
  "feodora": 4,
  "feola": 3,
  "fertilizes": 4,
  "fetches": 2,
  "fette": 1,
  "fettes": 1,
  "fetuses": 3,
  "fiddled": 2,
  "fiddling": 2,
  "fielded": 2,
  "figaroa": 4,
  "figueroa": 4,
  "filice": 2,
  "filyaw": 3,
  "financed": 2,
  "financement": 3,
  "finances": 3,
  "finesse": 2,
  "fingering": 3,
  "finne": 1,
  "fiona": 3,
  "firehouses": 4,
  "fireplace": 3,
  "fireplaces": 4,
  "fisette": 2,
  "fishburne": 2,
  "fiske": 1,
  "fitzmaurice": 3,
  "fixes": 2,
  "fizzled": 2,
  "flamboyance": 3,
  "flamboyant": 3,
  "flamboyantly": 4,
  "flanges": 2,
  "fleurette": 2,
  "flexes": 2,
  "flounces": 2,
  "flowering": 3,
  "fluency": 3,
  "fluent": 2,
  "flythe": 1,
  "focuses": 3,
  "folded": 2,
  "follette": 2,
  "fontenette": 3,
  "fonville": 2,
  "foodservice": 3,
  "footage": 2,
  "footrace": 2,
  "forage": 2,
  "forages": 3,
  "forces": 2,
  "fordyce": 2,
  "forecloses": 3,
  "foretaste": 2,
  "forges": 2,
  "forgette": 2,
  "forgione": 3,
  "forgiveness": 3,
  "formalizes": 4,
  "fornes": 1,
  "forsythe": 2,
  "forwarded": 3,
  "fosse": 1,
  "founded": 2,
  "foxes": 2,
  "fradette": 2,
  "fragrances": 3,
  "frances": 2,
  "franchises": 3,
  "francia": 2,
  "francisville": 3,
  "frazzled": 2,
  "frechette": 2,
  "freckled": 2,
  "freezes": 2,
  "fregeau": 2,
  "frenette": 2,
  "freon": 2,
  "freons": 2,
  "freya": 2,
  "freyermuth": 3,
  "fringes": 2,
  "friona": 3,
  "friscia": 2,
  "friske": 1,
  "fromme": 1,
  "frontage": 2,
  "fryar": 2,
  "fuchsias": 2,
  "fujiya": 3,
  "fujiyama": 4,
  "fukuyama": 4,
  "fumbled": 2,
  "funded": 2,
  "furches": 2,
  "furloughed": 2,
  "furnace": 2,
  "furnaces": 3,
  "furuya": 3,
  "fuselage": 3,
  "fuselages": 4,
  "fuses": 2,
  "fuzes": 2,
  "gabriella": 4,
  "gabrielli": 4,
  "gaccione": 3,
  "gainesville": 2,
  "galarneau": 3,
  "galileo": 4,
  "galipeau": 3,
  "galle": 1,
  "galleon": 3,
  "galleons": 3,
  "galles": 1,
  "galyean": 3,
  "galyen": 3,
  "gamage": 2,
  "gambled": 2,
  "gamboa": 3,
  "gammage": 2,
  "ganglionic": 4,
  "garage": 2,
  "garages": 3,
  "garbage": 2,
  "garbled": 2,
  "garceau": 2,
  "garces": 2,
  "gardea": 3,
  "gareau": 2,
  "garges": 2,
  "garneau": 2,
  "garnes": 1,
  "garnette": 2,
  "garrette": 2,
  "gases": 2,
  "gasque": 1,
  "gastineau": 3,
  "gaudette": 2,
  "gaudreau": 2,
  "gauges": 2,
  "gaulle": 1,
  "gauthreaux": 2,
  "gautreau": 2,
  "gautreaux": 2,
  "gauvreau": 2,
  "gazelle": 2,
  "gazelles": 2,
  "gazes": 2,
  "gazette": 2,
  "gearboxes": 3,
  "gedeon": 3,
  "geers": 2,
  "gelette": 2,
  "gelineau": 3,
  "gelles": 1,
  "gemayel": 3,
  "gemme": 1,
  "gendreau": 2,
  "genoa": 3,
  "geo": 2,
  "geocentric": 4,
  "geochemistry": 5,
  "geodesic": 4,
  "geodesy": 4,
  "geodyne": 3,
  "geoffrion": 4,
  "geoffroy": 3,
  "geographer": 4,
  "geographic": 4,
  "geographical": 5,
  "geographically": 6,
  "geography": 4,
  "geologic": 4,
  "geological": 5,
  "geologist": 4,
  "geologists": 4,
  "geology": 4,
  "geomagnetic": 5,
  "geometric": 4,
  "geometrical": 5,
  "geometries": 4,
  "geometry": 4,
  "geomorphology": 6,
  "geon": 2,
  "geophysical": 5,
  "geopolitical": 6,
  "geopolitics": 5,
  "geordie": 3,
  "georg": 2,
  "georgeson": 4,
  "georgi": 3,
  "georgiades": 4,
  "geostrophic": 4,
  "geosyncline": 4,
  "geotaxis": 4,
  "geotek": 3,
  "geothermal": 4,
  "geotropic": 4,
  "geotropism": 5,
  "gering": 2,
  "geringer": 3,
  "geske": 1,
  "geyelin": 3,
  "gibeau": 2,
  "gibeault": 2,
  "gideon": 3,
  "gieske": 1,
  "giggled": 2,
  "gildea": 3,
  "gilded": 2,
  "gille": 1,
  "gilles": 1,
  "gillette": 2,
  "gionet": 3,
  "giselle": 2,
  "giudice": 3,
  "glances": 2,
  "glanville": 2,
  "glazes": 2,
  "glenville": 2,
  "glitches": 2,
  "glowering": 3,
  "goa": 2,
  "gobbled": 2,
  "goddeau": 2,
  "godette": 2,
  "goethe": 1,
  "goldfeder": 3,
  "golle": 1,
  "goodreau": 2,
  "gooseberry": 3,
  "gordeyev": 3,
  "gorgeous": 2,
  "gorges": 2,
  "gossage": 2,
  "gosse": 1,
  "goudeau": 2,
  "goudreau": 2,
  "goulette": 2,
  "goya": 2,
  "goyim": 2,
  "graceful": 2,
  "gracefully": 3,
  "graceless": 2,
  "graces": 2,
  "gracia": 2,
  "graffeo": 3,
  "grambling": 2,
  "granges": 2,
  "granville": 2,
  "grappled": 2,
  "grappling": 2,
  "grasse": 1,
  "gravelle": 2,
  "gravette": 2,
  "grayish": 2,
  "grecian": 2,
  "greenhouses": 3,
  "greenpeace": 2,
  "greenville": 2,
  "grelle": 1,
  "grenouille": 3,
  "grievances": 3,
  "grille": 1,
  "grimaced": 2,
  "grimaces": 3,
  "grimme": 1,
  "grinage": 2,
  "grizzled": 2,
  "groleau": 2,
  "grosse": 1,
  "grotesque": 2,
  "grotesquely": 3,
  "grothe": 1,
  "grotheer": 2,
  "grounded": 2,
  "groupement": 2,
  "grouses": 2,
  "grua": 2,
  "grudges": 2,
  "grumbled": 2,
  "guarded": 2,
  "guardedly": 3,
  "guayabera": 4,
  "guccione": 3,
  "guerette": 2,
  "guerrette": 2,
  "guidice": 2,
  "guilbeau": 2,
  "guilbeault": 2,
  "guilbeaux": 2,
  "guillemette": 3,
  "guillette": 2,
  "guilmette": 2,
  "guises": 2,
  "gullette": 2,
  "guste": 1,
  "guyana": 3,
  "guyett": 2,
  "guyon": 2,
  "guyot": 2,
  "gvaryahu": 4,
  "gwynne": 1,
  "haberer": 3,
  "hachette": 2,
  "haggled": 2,
  "halcion": 3,
  "halle": 1,
  "halve": 1,
  "halves": 1,
  "hamme": 1,
  "hammes": 1,
  "handed": 2,
  "handedly": 3,
  "handled": 2,
  "hannes": 1,
  "hansche": 2,
  "haranguing": 3,
  "hardage": 2,
  "harleysville": 3,
  "harnage": 2,
  "harne": 1,
  "harriette": 3,
  "hartlage": 2,
  "hartshorne": 2,
  "harville": 2,
  "haske": 1,
  "hasse": 1,
  "hassled": 2,
  "haste": 1,
  "hatches": 2,
  "hathorne": 2,
  "hauppauge": 2,
  "hawthorne": 2,
  "hayashi": 3,
  "hayashida": 4,
  "hayek": 2,
  "hayen": 2,
  "hayenga": 3,
  "hearne": 1,
  "heavyhanded": 4,
  "heberer": 3,
  "heckled": 2,
  "hedges": 2,
  "heidbreder": 3,
  "heiges": 2,
  "helice": 2,
  "helle": 1,
  "hemme": 1,
  "hemocyanin": 5,
  "hemorrhage": 3,
  "hemorrhaged": 3,
  "henne": 1,
  "henneberry": 3,
  "hennes": 1,
  "henriette": 3,
  "hentges": 2,
  "henthorne": 2,
  "heon": 2,
  "heralded": 3,
  "herbaceous": 3,
  "herded": 2,
  "heritage": 3,
  "hermitage": 3,
  "herne": 1,
  "herriage": 3,
  "herrlinger": 3,
  "hesse": 1,
  "hessian": 2,
  "heterogeneous": 5,
  "hicksville": 2,
  "hideo": 3,
  "hille": 1,
  "himalayan": 4,
  "himalayas": 4,
  "hindrances": 3,
  "hinges": 2,
  "hirayama": 4,
  "hiroyuki": 4,
  "histrionic": 4,
  "histrionics": 4,
  "hitches": 2,
  "hoarded": 2,
  "hoarseness": 2,
  "hoaxes": 2,
  "hobbled": 2,
  "hodges": 2,
  "hoelle": 1,
  "holle": 1,
  "homage": 2,
  "homeostasis": 5,
  "homeostatic": 5,
  "homme": 1,
  "hommes": 1,
  "horace": 2,
  "horne": 1,
  "hoses": 2,
  "hospice": 2,
  "hospices": 3,
  "hostage": 2,
  "hostages": 3,
  "houdaille": 2,
  "hounded": 2,
  "houses": 2,
  "hovering": 3,
  "hoyos": 2,
  "hua": 2,
  "huddled": 2,
  "hugely": 2,
  "hugette": 2,
  "hughette": 2,
  "hulette": 2,
  "humbled": 2,
  "hundred": 2,
  "hungering": 3,
  "huntsville": 2,
  "hurteau": 2,
  "hutcheon": 3,
  "huyett": 2,
  "hyacinth": 3,
  "hyacintha": 4,
  "hyacinthia": 5,
  "hyacinthie": 4,
  "hyacinths": 3,
  "hyaluronic": 5,
  "hyams": 2,
  "hyannis": 3,
  "hyatt": 2,
  "hyena": 3,
  "hyenas": 3,
  "hyperion": 4,
  "hypotheses": 4,
  "hyraxes": 3,
  "ianniello": 5,
  "ices": 2,
  "iconoclasm": 5,
  "idea": 3,
  "ideological": 6,
  "ideologies": 5,
  "ideologists": 5,
  "idette": 2,
  "idled": 2,
  "idolizes": 4,
  "ierne": 1,
  "ignace": 2,
  "illes": 1,
  "Ilyich": 2,
  "image": 2,
  "images": 3,
  "imbalances": 4,
  "imbedded": 3,
  "immortalizes": 5,
  "immunizes": 4,
  "impasse": 2,
  "impeached": 2,
  "impeding": 3,
  "imposes": 3,
  "impounded": 3,
  "improvement": 3,
  "improvements": 3,
  "inbred": 2,
  "incidences": 4,
  "inconvenienced": 4,
  "inconveniences": 5,
  "increases": 3,
  "indecisiveness": 5,
  "indexes": 3,
  "indices": 3,
  "indonesian": 4,
  "induce": 2,
  "induced": 2,
  "inducement": 3,
  "inducements": 3,
  "induces": 3,
  "indulgences": 4,
  "indulges": 3,
  "ineffectiveness": 5,
  "inferences": 4,
  "influence": 3,
  "influenced": 3,
  "influences": 4,
  "influencing": 4,
  "influential": 4,
  "influenza": 4,
  "infrared": 3,
  "infringed": 2,
  "infringement": 3,
  "infringements": 3,
  "infringes": 3,
  "infuses": 3,
  "injustice": 3,
  "injustices": 4,
  "innerspace": 3,
  "innuendo": 4,
  "innuendoes": 4,
  "innuendos": 4,
  "instances": 3,
  "institutionalizes": 7,
  "insurances": 4,
  "intended": 3,
  "interacciones": 5,
  "interbred": 3,
  "interceding": 4,
  "interchanges": 4,
  "interface": 3,
  "interfaces": 4,
  "interlaced": 3,
  "intermingled": 4,
  "interoffice": 4,
  "intervoice": 3,
  "intraocular": 5,
  "intrauterine": 5,
  "intriguing": 3,
  "intriguingly": 4,
  "introduce": 3,
  "introduced": 3,
  "introduces": 4,
  "inveighed": 2,
  "inventiveness": 4,
  "invoice": 2,
  "invoices": 3,
  "involve": 2,
  "involvement": 3,
  "involves": 2,
  "iodice": 3,
  "ion": 2,
  "iona": 3,
  "ionic": 3,
  "ionics": 3,
  "ionization": 5,
  "ionizers": 4,
  "ionizing": 4,
  "ionospheric": 5,
  "ions": 2,
  "irette": 2,
  "irises": 3,
  "ironizes": 4,
  "irvette": 2,
  "isabelle": 3,
  "isle": 1,
  "isles": 1,
  "isocyanate": 5,
  "Isozaki": 4,
  "issuances": 4,
  "itches": 2,
  "jacksonville": 3,
  "jandreau": 2,
  "janelle": 2,
  "janesville": 2,
  "janette": 2,
  "jangled": 2,
  "janice": 2,
  "jarreau": 2,
  "jasmer": 3,
  "jaundice": 2,
  "jaundiced": 2,
  "jaya": 2,
  "jayashankar": 4,
  "jeanbaptiste": 3,
  "jeanette": 2,
  "jeanne": 1,
  "jeannette": 2,
  "jeansonne": 2,
  "jenne": 1,
  "jennette": 2,
  "jenrette": 2,
  "jeske": 1,
  "jetborne": 2,
  "jette": 1,
  "jeyaretnam": 4,
  "joffrion": 3,
  "jolette": 2,
  "joliet": 3,
  "jolivette": 3,
  "jopling": 2,
  "jorge": 2,
  "josette": 2,
  "joshua": 3,
  "jostes": 1,
  "jostling": 2,
  "joyal": 2,
  "joyoni": 3,
  "joyous": 2,
  "juan": 1,
  "juana": 2,
  "juanita": 3,
  "juarez": 2,
  "judaism": 3,
  "judea": 3,
  "judeo": 3,
  "judgement": 2,
  "judgements": 2,
  "judges": 2,
  "judgeship": 2,
  "judgeships": 2,
  "judice": 2,
  "juggled": 2,
  "juices": 2,
  "jukebox": 2,
  "julia": 3,
  "julianne": 3,
  "juliet": 3,
  "julius": 3,
  "jumbled": 2,
  "jumonville": 3,
  "juneau": 2,
  "junette": 2,
  "junior": 3,
  "juniors": 3,
  "justice": 2,
  "justices": 3,
  "kageyama": 4,
  "kamerer": 3,
  "kanghua": 3,
  "kanne": 1,
  "karges": 2,
  "karnes": 1,
  "kasmer": 3,
  "katayama": 4,
  "kaya": 2,
  "kayak": 2,
  "kayaking": 3,
  "kayaks": 2,
  "kayo": 2,
  "kemerer": 3,
  "keo": 2,
  "keogh": 2,
  "keohane": 3,
  "keown": 2,
  "kerestes": 2,
  "kernes": 1,
  "kerrville": 2,
  "keske": 1,
  "keville": 2,
  "keynesian": 3,
  "kibodeaux": 3,
  "kidded": 2,
  "kiessling": 2,
  "kilborne": 2,
  "kilbourne": 2,
  "kille": 1,
  "kimche": 2,
  "kindled": 2,
  "kindred": 2,
  "kingsville": 2,
  "kinne": 1,
  "kissling": 2,
  "kitchenette": 3,
  "kiyoshi": 3,
  "kiyotaka": 4,
  "klages": 2,
  "kleinpaste": 2,
  "klemme": 1,
  "knicely": 2,
  "knoxville": 2,
  "kobayashi": 4,
  "kocian": 2,
  "koelle": 1,
  "kolle": 1,
  "Komsomolskaya": 5,
  "korfhage": 2,
  "kothe": 1,
  "koyama": 3,
  "koyo": 2,
  "kramme": 1,
  "krammes": 1,
  "krasnoyarsk": 3,
  "krausse": 1,
  "kresge": 2,
  "kresse": 1,
  "krumme": 1,
  "kuenheim": 3,
  "kuenstler": 3,
  "kuenzi": 3,
  "kunayev": 3,
  "kuske": 1,
  "labeau": 2,
  "labelle": 2,
  "labranche": 3,
  "lacayo": 3,
  "laces": 2,
  "lachapelle": 3,
  "lacoste": 2,
  "lacrosse": 2,
  "ladled": 2,
  "lafalce": 3,
  "laflamme": 2,
  "lafollette": 3,
  "lafosse": 2,
  "lagesse": 2,
  "lajeunesse": 3,
  "lakeside": 2,
  "lamarche": 3,
  "lambaste": 2,
  "lambastes": 2,
  "lamme": 1,
  "lamontagne": 3,
  "lamoreaux": 3,
  "lamothe": 2,
  "lamoureaux": 3,
  "lanceolate": 4,
  "lancia": 2,
  "landed": 2,
  "landreneau": 3,
  "langhorne": 2,
  "language": 2,
  "languages": 3,
  "lanouette": 3,
  "lapage": 2,
  "larche": 2,
  "larded": 2,
  "lareau": 2,
  "largesse": 2,
  "lariccia": 3,
  "larochelle": 3,
  "lasalle": 2,
  "lashua": 3,
  "laske": 1,
  "lasseigne": 2,
  "latches": 2,
  "latendresse": 3,
  "lateness": 2,
  "latexes": 3,
  "lathe": 1,
  "lathes": 1,
  "latourette": 3,
  "lattice": 2,
  "laurette": 2,
  "laurice": 2,
  "lausanne": 2,
  "lavelle": 2,
  "laverne": 2,
  "lavette": 2,
  "lavigne": 2,
  "laviolette": 4,
  "lawhorne": 2,
  "lawrenceville": 3,
  "layborne": 2,
  "layered": 2,
  "layering": 3,
  "layoff": 2,
  "layoffs": 2,
  "layout": 2,
  "layouts": 2,
  "layover": 3,
  "layovers": 3,
  "leadville": 2,
  "leakage": 2,
  "leases": 2,
  "leatrice": 2,
  "leavelle": 2,
  "lebeau": 2,
  "ledges": 2,
  "ledonne": 2,
  "legette": 2,
  "legged": 2,
  "leggette": 2,
  "legitimizes": 5,
  "leifeste": 2,
  "lemelle": 2,
  "leo": 2,
  "leoma": 3,
  "leominster": 4,
  "leon": 2,
  "leona": 3,
  "leonardo": 4,
  "leone": 2,
  "leonel": 3,
  "leonerd": 3,
  "leones": 2,
  "leonhard": 3,
  "leoni": 3,
  "leonid": 3,
  "leonora": 4,
  "leonore": 3,
  "leontine": 3,
  "leopold": 3,
  "leopoldine": 4,
  "leopoldo": 4,
  "leos": 2,
  "leotard": 3,
  "lepage": 2,
  "lerette": 2,
  "lesage": 2,
  "leske": 1,
  "lespinasse": 3,
  "leticia": 3,
  "letourneau": 3,
  "lettice": 2,
  "lettuce": 2,
  "leveille": 2,
  "leverage": 3,
  "leveraged": 3,
  "leverette": 3,
  "levering": 3,
  "levesque": 2,
  "leya": 2,
  "lianne": 2,
  "liberace": 3,
  "libya": 3,
  "libyan": 3,
  "libyans": 3,
  "licences": 3,
  "licorice": 3,
  "lighthouses": 3,
  "likeness": 2,
  "likenesses": 3,
  "lille": 1,
  "lilyan": 3,
  "limoges": 3,
  "linage": 2,
  "lineberry": 3,
  "linette": 2,
  "lingering": 3,
  "linkage": 2,
  "linkages": 3,
  "linne": 1,
  "linville": 2,
  "lion": 2,
  "lionberger": 4,
  "lionel": 3,
  "lionetti": 4,
  "lionheart": 3,
  "lionized": 3,
  "lions": 2,
  "lirette": 2,
  "lisette": 2,
  "liske": 1,
  "literaturnaya": 6,
  "lithe": 1,
  "littlepage": 3,
  "loathe": 1,
  "loathed": 1,
  "lodges": 2,
  "loewe": 2,
  "logarithm": 4,
  "loges": 2,
  "logician": 3,
  "loguidice": 3,
  "loiselle": 2,
  "lonesome": 2,
  "looses": 2,
  "lorette": 2,
  "lorne": 1,
  "loses": 2,
  "losoya": 3,
  "louisville": 3,
  "lounges": 2,
  "lovage": 2,
  "lovering": 3,
  "lovette": 2,
  "lowering": 3,
  "loya": 2,
  "loyal": 2,
  "loyalist": 3,
  "loyalists": 3,
  "loyall": 2,
  "loyally": 3,
  "loyalties": 3,
  "loyalty": 3,
  "loyola": 3,
  "lozeau": 2,
  "lozenges": 3,
  "lozoya": 3,
  "lua": 2,
  "lucerne": 2,
  "lucette": 2,
  "lucia": 2,
  "lucian": 2,
  "lucille": 2,
  "lucrecia": 3,
  "luelle": 1,
  "luggage": 2,
  "lunges": 2,
  "lurches": 2,
  "lurette": 2,
  "lyall": 2,
  "lyell": 2,
  "lyerla": 3,
  "lynette": 2,
  "lynne": 1,
  "mabelle": 2,
  "macfadyen": 4,
  "macioce": 3,
  "macroeconomic": 6,
  "macroeconomics": 6,
  "macrophage": 3,
  "macrophages": 4,
  "madelle": 2,
  "mademoiselle": 4,
  "maffeo": 3,
  "mages": 2,
  "magician": 3,
  "magicians": 3,
  "mahayana": 4,
  "mahe": 2,
  "mailboxes": 3,
  "maille": 1,
  "mainville": 2,
  "maione": 3,
  "majette": 2,
  "makeover": 4,
  "makepeace": 3,
  "malayan": 3,
  "malaysian": 3,
  "malaysians": 3,
  "maleness": 2,
  "malice": 2,
  "malle": 1,
  "mallette": 2,
  "malpractice": 3,
  "malveaux": 2,
  "manage": 2,
  "managed": 2,
  "management": 3,
  "managements": 3,
  "manages": 3,
  "mandeville": 3,
  "manette": 2,
  "maneuvering": 4,
  "maneuverings": 4,
  "manganiello": 5,
  "mangement": 2,
  "manges": 2,
  "mangione": 3,
  "mangled": 2,
  "manhandled": 3,
  "manne": 1,
  "mannes": 1,
  "manseau": 2,
  "mantua": 3,
  "manuevering": 4,
  "manville": 2,
  "marantette": 3,
  "maranville": 3,
  "marbled": 2,
  "marceau": 2,
  "marceaux": 2,
  "marcelle": 2,
  "marches": 2,
  "marcia": 2,
  "marcille": 2,
  "marcoses": 3,
  "marette": 2,
  "margette": 2,
  "marginalizes": 5,
  "marianne": 3,
  "marice": 2,
  "mariette": 3,
  "marineau": 3,
  "marketplace": 3,
  "marketplaces": 4,
  "marlette": 2,
  "marmion": 3,
  "marseille": 2,
  "martelle": 2,
  "martineau": 3,
  "maruyama": 4,
  "maruyu": 3,
  "marvelle": 2,
  "maryann": 3,
  "marysville": 3,
  "maryville": 3,
  "marzette": 2,
  "masaya": 3,
  "masayoshi": 4,
  "masayuki": 4,
  "mascia": 2,
  "masiello": 4,
  "maske": 1,
  "massacred": 3,
  "massage": 2,
  "massaged": 2,
  "massages": 3,
  "masse": 1,
  "masterminded": 4,
  "masterpiece": 3,
  "masterpieces": 4,
  "mataya": 3,
  "matches": 2,
  "mateo": 3,
  "materializes": 6,
  "mathe": 1,
  "mathematician": 5,
  "mathematicians": 5,
  "matherne": 2,
  "matisse": 2,
  "matteo": 3,
  "mattice": 2,
  "maurice": 2,
  "mauriello": 4,
  "mauthe": 1,
  "maximizes": 4,
  "maya": 2,
  "mayall": 2,
  "mayan": 2,
  "maybelle": 2,
  "mayeda": 3,
  "mayernik": 3,
  "mayerson": 3,
  "mayeux": 2,
  "mayo": 2,
  "mayon": 2,
  "mayonnaise": 3,
  "mayor": 2,
  "mayoral": 3,
  "mayoralty": 4,
  "mayorga": 3,
  "mayors": 2,
  "mayville": 2,
  "mazes": 2,
  "mazzeo": 3,
  "mcbryar": 3,
  "mccarville": 3,
  "mcconville": 3,
  "mcfadyen": 4,
  "mcginnes": 2,
  "mckeon": 3,
  "mckeone": 3,
  "mckeown": 3,
  "mcneece": 2,
  "mcneice": 2,
  "mcquaid": 2,
  "mcquaide": 2,
  "mcquaig": 2,
  "mcquain": 2,
  "measurement": 3,
  "measurements": 3,
  "meaux": 1,
  "medea": 3,
  "megahouses": 4,
  "mehitabelle": 4,
  "meiyuh": 2,
  "melanesian": 4,
  "melbourne": 2,
  "melded": 2,
  "melisse": 2,
  "melle": 1,
  "melville": 2,
  "menace": 2,
  "menaced": 2,
  "menaces": 3,
  "mended": 2,
  "meneses": 3,
  "menezes": 3,
  "menges": 2,
  "menne": 1,
  "meo": 2,
  "meola": 3,
  "meow": 2,
  "mercedeses": 4,
  "merdyce": 2,
  "merges": 2,
  "merhige": 2,
  "mersereau": 3,
  "mertice": 2,
  "meske": 1,
  "message": 2,
  "messages": 3,
  "messiaen": 3,
  "messineo": 4,
  "meteor": 3,
  "meteoric": 4,
  "meteorological": 7,
  "meteorologist": 6,
  "meteorologists": 6,
  "meteorology": 6,
  "mette": 1,
  "meyerhoff": 3,
  "meyering": 3,
  "meyerman": 3,
  "meyerowitz": 4,
  "meyerson": 3,
  "meyo": 2,
  "meyohas": 3,
  "micheaux": 2,
  "michelle": 2,
  "microage": 3,
  "microamerica": 6,
  "microeconomic": 6,
  "microeconomics": 6,
  "microelectronic": 6,
  "microelectronics": 6,
  "microelettronica": 7,
  "micromanage": 4,
  "micromanagement": 5,
  "microorganism": 6,
  "micropaleontology": 8,
  "midges": 2,
  "midgette": 2,
  "midpriced": 2,
  "miesse": 1,
  "migneault": 2,
  "milbourne": 2,
  "mildred": 2,
  "mileage": 2,
  "millage": 2,
  "mille": 1,
  "millette": 2,
  "milliet": 3,
  "mimeograph": 4,
  "minasian": 3,
  "minassian": 3,
  "minded": 2,
  "mindedly": 3,
  "mineau": 2,
  "mineo": 3,
  "mineola": 4,
  "minette": 2,
  "minges": 2,
  "mingled": 2,
  "minibuses": 4,
  "minichiello": 5,
  "minimizes": 4,
  "mintage": 2,
  "minuses": 3,
  "mion": 2,
  "mione": 2,
  "mirabelle": 3,
  "mirage": 2,
  "mirelle": 2,
  "miscayuna": 4,
  "mischarges": 3,
  "mises": 2,
  "mishandled": 3,
  "misjudged": 2,
  "miske": 1,
  "mismanaged": 3,
  "mismanagement": 4,
  "mismatches": 3,
  "misplace": 2,
  "misplaced": 2,
  "mispriced": 2,
  "misstatement": 3,
  "misstatements": 3,
  "misuses": 3,
  "mixes": 2,
  "miyagawa": 4,
  "miyahara": 4,
  "miyako": 3,
  "miyamori": 4,
  "miyamoto": 4,
  "miyasaki": 4,
  "miyasato": 4,
  "miyashiro": 4,
  "miyazaki": 4,
  "miyazawa": 4,
  "mizelle": 2,
  "moccia": 2,
  "modisette": 3,
  "moises": 2,
  "molded": 2,
  "molineaux": 3,
  "molle": 1,
  "molyneaux": 3,
  "momayez": 3,
  "moncayo": 3,
  "monceaux": 2,
  "mondeo": 3,
  "monette": 2,
  "mongeau": 2,
  "mongering": 3,
  "mongooses": 3,
  "monopolizes": 5,
  "monroeville": 3,
  "montage": 2,
  "montagne": 2,
  "montemayor": 4,
  "montesdeoca": 5,
  "montevideo": 5,
  "montoya": 3,
  "montreal": 3,
  "montville": 2,
  "moragne": 2,
  "moreau": 2,
  "morice": 2,
  "morisette": 3,
  "morissette": 3,
  "moriya": 3,
  "morneau": 2,
  "morneault": 2,
  "morreale": 3,
  "morrisette": 3,
  "morrissette": 3,
  "morrisville": 3,
  "mortage": 2,
  "mortages": 3,
  "mortgage": 2,
  "mortgaged": 2,
  "mortgages": 3,
  "mortician": 3,
  "moselle": 2,
  "moses": 2,
  "mosque": 1,
  "mosques": 1,
  "mousse": 1,
  "mousseau": 2,
  "mouthed": 1,
  "mouthpiece": 2,
  "mouthpieces": 3,
  "movement": 2,
  "movements": 2,
  "moya": 2,
  "mozelle": 2,
  "Muammar": 3,
  "muddled": 2,
  "muffled": 2,
  "mughniyeh": 3,
  "mugniyah": 3,
  "mullineaux": 3,
  "multilayered": 4,
  "multivalve": 3,
  "multiyear": 3,
  "mumbled": 2,
  "mumme": 1,
  "murayama": 4,
  "muscled": 2,
  "muses": 2,
  "musician": 3,
  "musicians": 3,
  "muske": 1,
  "mustached": 2,
  "muzzled": 2,
  "myatt": 2,
  "myelin": 3,
  "myreon": 3,
  "myrtice": 2,
  "nadeau": 2,
  "nagoya": 3,
  "nairne": 1,
  "nakayama": 4,
  "nanette": 2,
  "naperville": 3,
  "napoleon": 4,
  "napoleonic": 5,
  "narayan": 3,
  "narayanan": 4,
  "narcisse": 2,
  "nardiello": 4,
  "nashua": 3,
  "nashville": 2,
  "nathe": 1,
  "navarette": 3,
  "navarrette": 3,
  "Nazarbayev": 4,
  "neault": 1,
  "nechayev": 3,
  "necklace": 2,
  "necklaces": 3,
  "nedeau": 2,
  "nederlandsche": 4,
  "needled": 2,
  "neises": 2,
  "nelle": 1,
  "nelles": 1,
  "nellette": 2,
  "neo": 2,
  "neoclassic": 4,
  "neoclassical": 5,
  "neoconservative": 6,
  "neoconservatives": 6,
  "neola": 3,
  "neoliberal": 5,
  "neoliberals": 5,
  "neoma": 3,
  "neon": 2,
  "neonatal": 4,
  "neons": 2,
  "neophyte": 3,
  "neophytes": 3,
  "neoplasm": 4,
  "neoplatonic": 5,
  "neoplatonist": 5,
  "neoprene": 3,
  "neoprobe": 3,
  "neotenic": 4,
  "neoteny": 4,
  "nerice": 2,
  "nerves": 1,
  "neste": 1,
  "netterville": 3,
  "neuroses": 3,
  "neutralizes": 4,
  "neuville": 2,
  "neveau": 2,
  "neville": 2,
  "newfangled": 3,
  "newlywed": 3,
  "newville": 2,
  "nguyen": 2,
  "nibbled": 2,
  "nicely": 2,
  "niceness": 2,
  "nickelodeon": 5,
  "nicolette": 3,
  "nicolle": 2,
  "nicorette": 3,
  "nieces": 2,
  "nietzsche": 2,
  "nightstage": 2,
  "nilges": 2,
  "nilles": 1,
  "ninette": 2,
  "nishiyama": 4,
  "nixes": 2,
  "noa": 2,
  "noblesse": 2,
  "nobuyuki": 4,
  "nodded": 2,
  "noises": 2,
  "nolette": 2,
  "nonbusiness": 3,
  "noncontroversial": 5,
  "nonesuch": 2,
  "nonetheless": 3,
  "nonmanagement": 4,
  "norcia": 2,
  "norville": 2,
  "noses": 2,
  "notches": 2,
  "notice": 2,
  "noticed": 2,
  "notices": 3,
  "nottage": 2,
  "nouveau": 2,
  "nouvelle": 2,
  "novice": 2,
  "novices": 3,
  "novoa": 3,
  "noyola": 3,
  "nuanced": 2,
  "nuances": 3,
  "nucleonics": 4,
  "nucleotide": 4,
  "nudges": 2,
  "nuisances": 3,
  "nureyev": 3,
  "nyack": 2,
  "nyenhuis": 3,
  "nyerere": 3,
  "oakville": 2,
  "obeirne": 2,
  "oblige": 2,
  "obliged": 2,
  "obliges": 3,
  "obryan": 3,
  "obryant": 3,
  "observances": 4,
  "observes": 2,
  "obstetrician": 4,
  "obstetricians": 4,
  "obyrne": 2,
  "occhoa": 3,
  "occurrences": 4,
  "ochoa": 3,
  "odea": 3,
  "odelette": 3,
  "odeon": 3,
  "odette": 2,
  "oesterreichische": 5,
  "offended": 3,
  "office": 2,
  "offices": 3,
  "offstage": 2,
  "ogled": 2,
  "ohanesian": 4,
  "OHara": 3,
  "ohbayashi": 4,
  "olayan": 3,
  "oleo": 3,
  "olivette": 3,
  "omnibuses": 4,
  "oneness": 2,
  "oneok": 3,
  "onstage": 2,
  "oozes": 2,
  "opposes": 3,
  "opticians": 3,
  "orabelle": 3,
  "oranges": 3,
  "ordinances": 4,
  "oreffice": 3,
  "orefice": 3,
  "oreo": 3,
  "organelles": 3,
  "organizes": 4,
  "orgasm": 3,
  "orifices": 4,
  "orne": 1,
  "orphanage": 3,
  "orphanages": 4,
  "orville": 2,
  "osage": 2,
  "osages": 3,
  "osborne": 2,
  "osbourne": 2,
  "osceola": 4,
  "osteopathic": 5,
  "osteoporosis": 6,
  "osterreichische": 5,
  "ouelette": 3,
  "ouellette": 3,
  "ounces": 2,
  "outage": 2,
  "outages": 3,
  "outhouses": 3,
  "outpace": 2,
  "outpaced": 2,
  "outpaces": 3,
  "outplacement": 3,
  "outrage": 2,
  "outraged": 2,
  "outrageous": 3,
  "outrageously": 4,
  "outrages": 3,
  "outweighed": 2,
  "ovalle": 2,
  "overcharges": 4,
  "overcrowded": 4,
  "overdoses": 4,
  "overextended": 5,
  "overfunded": 4,
  "overpriced": 3,
  "overproduce": 4,
  "overproduced": 4,
  "overreached": 3,
  "overseer": 4,
  "overseers": 4,
  "oversizes": 4,
  "overstatement": 4,
  "overstatements": 4,
  "oyama": 3,
  "oyen": 2,
  "oyola": 3,
  "ozanne": 2,
  "ozelle": 2,
  "paccione": 3,
  "paces": 2,
  "package": 2,
  "packaged": 2,
  "packages": 3,
  "padded": 2,
  "paddled": 2,
  "padua": 3,
  "pages": 2,
  "pagette": 2,
  "paille": 1,
  "palace": 2,
  "palaces": 3,
  "paleobotany": 6,
  "paleocene": 4,
  "paleontology": 6,
  "palette": 2,
  "paniccia": 3,
  "pantaleo": 4,
  "pantheon": 3,
  "panzhihua": 4,
  "papaleo": 4,
  "papaya": 3,
  "papayas": 3,
  "papering": 3,
  "papineau": 3,
  "papua": 3,
  "paradoxes": 4,
  "paraguayan": 4,
  "paralyzes": 4,
  "parazoa": 4,
  "parcplace": 2,
  "parentage": 3,
  "parenteau": 3,
  "parentheses": 4,
  "pariseau": 3,
  "parisian": 3,
  "parizeau": 3,
  "parlette": 2,
  "parnes": 1,
  "parsonage": 3,
  "partridges": 3,
  "pascua": 3,
  "paseo": 3,
  "paske": 1,
  "pasquariello": 5,
  "pasque": 1,
  "passage": 2,
  "passages": 3,
  "paste": 1,
  "pastes": 1,
  "patches": 2,
  "pathe": 1,
  "patrice": 2,
  "patricia": 3,
  "patrician": 3,
  "patricians": 3,
  "patronage": 3,
  "paulette": 2,
  "pauses": 2,
  "pavement": 2,
  "pavements": 2,
  "payable": 3,
  "payables": 3,
  "payan": 2,
  "payeur": 2,
  "payoff": 2,
  "payoffs": 2,
  "payola": 3,
  "payout": 2,
  "payouts": 2,
  "peaceful": 2,
  "peacefully": 3,
  "pebereau": 3,
  "peddled": 2,
  "peerage": 2,
  "peladeau": 3,
  "pelayo": 3,
  "pelle": 1,
  "peloponnesian": 5,
  "penalizes": 4,
  "peon": 2,
  "peonies": 3,
  "peons": 2,
  "peony": 3,
  "peoria": 4,
  "percentage": 3,
  "percentages": 4,
  "perches": 2,
  "performances": 4,
  "permissiveness": 4,
  "pernice": 2,
  "perplexes": 3,
  "perreault": 2,
  "perriello": 4,
  "persian": 2,
  "persians": 2,
  "pervasiveness": 4,
  "petroleos": 4,
  "petrossian": 3,
  "phalanges": 3,
  "phantasm": 3,
  "phases": 2,
  "phileo": 3,
  "phoenicia": 3,
  "phoenician": 3,
  "phoenicians": 3,
  "phrases": 2,
  "phua": 2,
  "physician": 3,
  "physicians": 3,
  "phytogeography": 6,
  "picariello": 5,
  "picayune": 3,
  "piccione": 3,
  "pichette": 2,
  "pickled": 2,
  "picturesque": 3,
  "pieces": 2,
  "piet": 2,
  "pilferage": 3,
  "pilgrimage": 3,
  "pilgrimages": 4,
  "pillage": 2,
  "pillaged": 2,
  "pillages": 3,
  "pille": 1,
  "pincavage": 3,
  "pineau": 2,
  "pineo": 3,
  "pinette": 2,
  "pinneo": 3,
  "pinsoneault": 3,
  "pion": 2,
  "pioneer": 3,
  "pioneered": 3,
  "pioneering": 4,
  "pioneers": 3,
  "piontek": 3,
  "piontkowski": 4,
  "pirouettes": 3,
  "pitches": 2,
  "placement": 2,
  "placements": 2,
  "placencia": 3,
  "places": 2,
  "plaguing": 2,
  "plainclothes": 2,
  "plascencia": 3,
  "plasencia": 3,
  "plasse": 1,
  "plateau": 2,
  "plateaued": 2,
  "playa": 2,
  "playoff": 2,
  "playoffs": 2,
  "pleasantville": 3,
  "pleases": 2,
  "pledges": 2,
  "plisetskaya": 4,
  "plodded": 2,
  "plumage": 2,
  "plumages": 3,
  "plunges": 2,
  "pluses": 2,
  "police": 2,
  "policed": 2,
  "polices": 3,
  "policewoman": 4,
  "politeness": 3,
  "politician": 4,
  "politicians": 4,
  "pollyanna": 4,
  "polyacetylene": 6,
  "polyak": 3,
  "polyamide": 4,
  "polyandrous": 4,
  "polyandry": 4,
  "polyester": 4,
  "polyesters": 4,
  "polyethylene": 5,
  "polymerizes": 5,
  "polynesian": 4,
  "pomerleau": 3,
  "pompeo": 3,
  "ponsolle": 2,
  "populace": 3,
  "porches": 2,
  "porges": 2,
  "porpoises": 3,
  "porsche": 2,
  "porsches": 2,
  "portage": 2,
  "porterages": 4,
  "portrayal": 3,
  "portrayals": 3,
  "poses": 2,
  "postage": 2,
  "postponement": 3,
  "postponements": 3,
  "postrelle": 2,
  "poultices": 3,
  "poundage": 2,
  "pounded": 2,
  "powerhouses": 4,
  "powering": 3,
  "practice": 2,
  "practiced": 2,
  "practices": 3,
  "praises": 2,
  "pralle": 1,
  "prances": 2,
  "prattville": 2,
  "preaches": 2,
  "preadolescent": 5,
  "preamble": 3,
  "prearranged": 3,
  "preceding": 3,
  "precipice": 3,
  "predaceous": 3,
  "preeminence": 4,
  "preeminent": 4,
  "preempt": 2,
  "preempted": 3,
  "preemption": 3,
  "preemptive": 3,
  "preexist": 3,
  "preexisted": 4,
  "preexisting": 4,
  "preexists": 3,
  "preface": 2,
  "prefaced": 2,
  "preferenced": 3,
  "preferences": 4,
  "preignition": 4,
  "preinvasion": 4,
  "preisler": 3,
  "prejudged": 2,
  "prejudice": 3,
  "prejudiced": 3,
  "prejudices": 4,
  "premed": 2,
  "premiering": 3,
  "premises": 3,
  "prentice": 2,
  "preoccupation": 5,
  "preoccupations": 5,
  "preoccupied": 4,
  "preoccupies": 4,
  "preoccupy": 4,
  "preordained": 3,
  "prepackaged": 3,
  "prerecorded": 4,
  "presage": 2,
  "presaged": 2,
  "presages": 3,
  "presences": 3,
  "preserves": 2,
  "prestage": 2,
  "prestige": 2,
  "presupposes": 4,
  "pretended": 3,
  "prevette": 2,
  "priceless": 2,
  "prices": 2,
  "prideaux": 2,
  "primeau": 2,
  "primeaux": 2,
  "primroses": 3,
  "princes": 2,
  "princeville": 2,
  "principled": 3,
  "prindiville": 3,
  "prioleau": 3,
  "prioritizes": 5,
  "privette": 2,
  "prizes": 2,
  "proactive": 3,
  "probusiness": 3,
  "procurement": 3,
  "procurements": 3,
  "prodded": 2,
  "produce": 2,
  "produced": 2,
  "produces": 3,
  "prognoses": 3,
  "programme": 2,
  "prolonged": 2,
  "prominences": 4,
  "promises": 3,
  "pronounced": 2,
  "pronouncement": 3,
  "pronouncements": 3,
  "pronounces": 3,
  "propionic": 4,
  "proposes": 3,
  "propounded": 3,
  "proscia": 2,
  "prospectuses": 4,
  "prostheses": 3,
  "proteges": 3,
  "protozoa": 4,
  "protuberances": 5,
  "provideniya": 5,
  "provinces": 3,
  "prudhomme": 2,
  "pruneau": 2,
  "prussian": 2,
  "puleo": 3,
  "pulice": 2,
  "pumice": 2,
  "purchases": 3,
  "purges": 2,
  "purposes": 3,
  "purves": 1,
  "purveyor": 3,
  "purveyors": 3,
  "puzzled": 2,
  "pyatt": 2,
  "pyeatt": 2,
  "quadrupled": 3,
  "quai": 1,
  "quaid": 1,
  "quail": 1,
  "quails": 1,
  "quain": 1,
  "quaint": 1,
  "quaintance": 2,
  "quaintly": 2,
  "quamme": 1,
  "queau": 1,
  "quebedeaux": 3,
  "quellette": 2,
  "quenneville": 3,
  "queuing": 2,
  "quintupled": 3,
  "quivering": 3,
  "rabideau": 3,
  "racehorses": 3,
  "races": 2,
  "racette": 2,
  "rachelle": 2,
  "radborne": 2,
  "radbourne": 2,
  "radice": 2,
  "rages": 2,
  "ragged": 2,
  "rahe": 2,
  "rainville": 2,
  "raises": 2,
  "raleses": 3,
  "ramage": 2,
  "rambeau": 2,
  "rambled": 2,
  "rambling": 2,
  "rameses": 3,
  "rampage": 2,
  "rampaged": 2,
  "rampages": 3,
  "ranges": 2,
  "rankled": 2,
  "rapprochement": 3,
  "raske": 1,
  "rathburne": 2,
  "rathe": 1,
  "rattling": 2,
  "ravaged": 2,
  "ravages": 3,
  "raya": 2,
  "rayon": 2,
  "rayos": 2,
  "rayovac": 3,
  "raytheon": 3,
  "reabsorbed": 3,
  "reactionaries": 5,
  "reactionary": 5,
  "reactions": 3,
  "reaganesque": 3,
  "realign": 3,
  "realigned": 3,
  "realigning": 4,
  "realignment": 4,
  "realignments": 4,
  "realistic": 4,
  "realities": 4,
  "reality": 4,
  "realizable": 5,
  "realizes": 4,
  "reallocate": 4,
  "reallocated": 5,
  "reallocating": 5,
  "reallocation": 5,
  "reallowance": 4,
  "realtor": 3,
  "realtors": 3,
  "realty": 3,
  "reappraised": 3,
  "reaume": 1,
  "reaux": 1,
  "rebounded": 3,
  "receding": 3,
  "recognizes": 4,
  "recommended": 4,
  "recorded": 3,
  "recovering": 4,
  "recycled": 3,
  "redhanded": 3,
  "rediscovering": 5,
  "redoubled": 3,
  "reduce": 2,
  "reduced": 2,
  "reduces": 3,
  "reemerge": 3,
  "reemerged": 3,
  "reestablished": 4,
  "referenced": 3,
  "references": 4,
  "refering": 3,
  "refinanced": 3,
  "refinances": 4,
  "refinement": 3,
  "refinements": 3,
  "reflexes": 3,
  "refocuses": 4,
  "refuge": 2,
  "refuges": 3,
  "refunded": 3,
  "refuses": 3,
  "regarded": 3,
  "reimposed": 3,
  "rejiggering": 4,
  "rejoice": 2,
  "rejoiced": 2,
  "rekindled": 3,
  "relaunched": 2,
  "relaxes": 3,
  "releases": 3,
  "remanded": 3,
  "remembrances": 4,
  "reminded": 3,
  "reminisced": 3,
  "reminiscences": 5,
  "remittances": 4,
  "remme": 1,
  "remolded": 3,
  "remoteness": 3,
  "remoulded": 3,
  "reneau": 2,
  "renege": 2,
  "reneged": 2,
  "renne": 1,
  "renounced": 2,
  "reo": 2,
  "reoffer": 3,
  "reoffered": 3,
  "reoffering": 4,
  "reopen": 3,
  "reopened": 3,
  "reopening": 4,
  "reopens": 3,
  "reorder": 3,
  "reordering": 4,
  "reorganization": 6,
  "reorganizations": 6,
  "reorganize": 4,
  "reorganized": 4,
  "reorganizes": 5,
  "reorganizing": 5,
  "repackage": 3,
  "repackaged": 3,
  "repackages": 4,
  "repayable": 4,
  "replace": 2,
  "replaced": 2,
  "replacement": 3,
  "replacements": 3,
  "replaces": 3,
  "reportage": 3,
  "reprice": 2,
  "repriced": 2,
  "reprimanded": 4,
  "reproduce": 3,
  "reproduced": 3,
  "reproduces": 4,
  "repurchases": 4,
  "requirement": 3,
  "requirements": 3,
  "rescinded": 3,
  "researches": 3,
  "resemblances": 4,
  "resembled": 3,
  "reserves": 2,
  "reshuffled": 3,
  "residences": 4,
  "resistiveness": 4,
  "reske": 1,
  "resolve": 2,
  "resolves": 2,
  "resources": 3,
  "responded": 3,
  "responsiveness": 4,
  "restaged": 2,
  "restatement": 3,
  "restatements": 3,
  "restiveness": 3,
  "restrictiveness": 4,
  "resurface": 3,
  "resurfaced": 3,
  "retarded": 3,
  "retirements": 3,
  "retrace": 2,
  "retraced": 2,
  "retracement": 3,
  "retrenched": 2,
  "retroviruses": 5,
  "reused": 2,
  "revelle": 2,
  "revette": 2,
  "reville": 2,
  "revises": 3,
  "revolve": 2,
  "revolves": 2,
  "rewarded": 3,
  "rhapsodizes": 4,
  "rheault": 1,
  "rheaume": 1,
  "rhetoricians": 4,
  "rhodesian": 3,
  "rhythm": 2,
  "riddled": 2,
  "rideau": 2,
  "rideaux": 2,
  "ridges": 2,
  "riendeau": 2,
  "rifled": 2,
  "righteous": 2,
  "righteously": 3,
  "righteousness": 3,
  "rillette": 2,
  "rinne": 1,
  "rion": 2,
  "riposte": 2,
  "ripostes": 2,
  "rippeon": 3,
  "rippled": 2,
  "rises": 2,
  "riske": 1,
  "risse": 1,
  "riverbed": 3,
  "rivette": 2,
  "riviello": 4,
  "riyad": 2,
  "riyadh": 2,
  "riyals": 2,
  "roa": 2,
  "robicheaux": 3,
  "robideau": 3,
  "robinette": 3,
  "robitaille": 3,
  "rocheleau": 3,
  "rochelle": 2,
  "rochette": 2,
  "rockville": 2,
  "rodeo": 3,
  "rodeos": 3,
  "roebling": 2,
  "roelle": 1,
  "roeske": 1,
  "rohleder": 3,
  "rolle": 1,
  "romances": 3,
  "romanesque": 3,
  "romaniello": 5,
  "romelle": 2,
  "romeo": 3,
  "rondeau": 2,
  "ronne": 1,
  "rosabelle": 3,
  "rosanne": 2,
  "roseanne": 2,
  "roseberry": 3,
  "roses": 2,
  "rosette": 2,
  "rosettes": 2,
  "roseville": 2,
  "roske": 1,
  "rosse": 1,
  "rossiya": 3,
  "rothe": 1,
  "rototilles": 3,
  "rougeau": 2,
  "rouleau": 2,
  "roulette": 2,
  "roulettes": 2,
  "rounded": 2,
  "rounsaville": 3,
  "rousse": 1,
  "rousseau": 2,
  "rousselle": 2,
  "rowlette": 2,
  "roxanne": 2,
  "royal": 2,
  "royale": 2,
  "royalist": 3,
  "royall": 2,
  "royals": 2,
  "royalties": 3,
  "royalty": 3,
  "royces": 2,
  "royex": 2,
  "rozelle": 2,
  "rua": 2,
  "rudelle": 2,
  "rudeness": 2,
  "ruffled": 2,
  "rugged": 2,
  "ruggedly": 3,
  "rumage": 2,
  "rumbled": 2,
  "rummage": 2,
  "rumpled": 2,
  "ruses": 2,
  "russe": 1,
  "russellville": 3,
  "russian": 2,
  "russians": 2,
  "ryal": 2,
  "ryall": 2,
  "ryals": 2,
  "ryan": 2,
  "ryanair": 3,
  "ryans": 2,
  "ryen": 2,
  "sabotage": 3,
  "sabotaged": 3,
  "sackville": 2,
  "sacred": 2,
  "sacrifice": 3,
  "sacrificed": 3,
  "sacrifices": 4,
  "sacrilege": 3,
  "saddled": 2,
  "sages": 2,
  "salemme": 2,
  "saleswoman": 3,
  "saleswomen": 3,
  "salle": 1,
  "salvage": 2,
  "salvaged": 2,
  "salve": 1,
  "salves": 1,
  "samelle": 2,
  "sameness": 2,
  "samoa": 3,
  "sampled": 2,
  "sancia": 2,
  "sandage": 2,
  "sanded": 2,
  "sandwiched": 2,
  "sannes": 1,
  "santaniello": 5,
  "santayana": 4,
  "santoyo": 3,
  "sanville": 2,
  "sapoa": 3,
  "sarcasm": 3,
  "sarette": 2,
  "sarkisian": 3,
  "sarkissian": 3,
  "sasse": 1,
  "satirizes": 4,
  "sauces": 2,
  "sausage": 2,
  "sausages": 3,
  "sauternes": 2,
  "sauvage": 2,
  "sauvageau": 3,
  "savage": 2,
  "savaged": 2,
  "savagely": 3,
  "savages": 3,
  "saville": 2,
  "sawaya": 3,
  "sawtelle": 2,
  "sayad": 2,
  "sayegh": 2,
  "scaccia": 2,
  "scarface": 2,
  "scarves": 1,
  "scherer": 2,
  "schering": 2,
  "schiewe": 2,
  "schnelle": 1,
  "scholle": 1,
//  "sciascia": 2,
  "scion": 2,
  "scolded": 2,
  "sconces": 2,
  "scorpion": 3,
  "scorpions": 3,
  "scotches": 2,
  "scourges": 2,
  "scoville": 2,
  "scrambled": 2,
  "scratches": 2,
  "scribbled": 2,
  "scrimmage": 2,
  "scrutinizes": 4,
  "scuffled": 2,
  "seaborne": 2,
  "searches": 2,
  "sebaceous": 3,
  "seceding": 3,
  "seconded": 3,
  "secretiveness": 4,
  "seduce": 2,
  "seduced": 2,
  "seepage": 2,
  "seethe": 1,
  "seigniorage": 4,
  "seiyaku": 3,
  "seiyu": 2,
  "seizes": 2,
  "selle": 1,
  "selvage": 2,
  "selves": 1,
  "semiautomatic": 6,
  "semionenkov": 5,
  "semmes": 1,
  "senne": 1,
  "sensitiveness": 4,
  "sentelle": 2,
  "sentenced": 2,
  "sentences": 3,
  "seo": 2,
  "seow": 2,
  "separateness": 4,
  "sequoyah": 3,
  "serves": 1,
  "service": 2,
  "serviced": 2,
  "services": 3,
  "sette": 1,
  "severing": 3,
  "seville": 2,
  "sewage": 2,
  "sewerage": 3,
  "sexes": 2,
  "sfernice": 2,
  "shackled": 2,
  "shaquille": 2,
  "sharpeville": 3,
  "sheathe": 1,
  "sheathed": 1,
  "shelburne": 2,
  "shelbyville": 3,
  "shelve": 1,
  "shelves": 1,
  "shepherded": 3,
  "sherborne": 2,
  "sherbourne": 2,
  "sherburne": 2,
  "shielded": 2,
  "shigeo": 3,
  "shionogi": 4,
  "shivering": 3,
  "shiyuan": 3,
  "shoelace": 2,
  "shoelaces": 3,
  "shortage": 2,
  "shortages": 3,
  "shortchanged": 2,
  "showcases": 3,
  "showering": 3,
  "showpiece": 2,
  "showplace": 2,
  "shredded": 2,
  "shreveport": 2,
  "shrinkage": 2,
  "shuffled": 2,
  "shuffling": 2,
  "siang": 1,
  "sias": 1,
  "sibelle": 2,
  "sibille": 2,
  "sibling": 2,
  "siblings": 2,
  "sidekick": 2,
  "sideline": 2,
  "sidelined": 2,
  "sidelines": 2,
  "sideman": 2,
  "sideshow": 2,
  "sidestep": 2,
  "sidestepped": 2,
  "sidestepping": 3,
  "sidesteps": 2,
  "sidestream": 2,
  "sidetrack": 2,
  "sidewalk": 2,
  "sidewalks": 2,
  "sidewater": 3,
  "sideways": 2,
  "sidewinder": 3,
  "sidewise": 2,
  "signage": 2,
  "silenced": 2,
  "silences": 3,
  "sileo": 3,
  "silhouette": 3,
  "silhouettes": 3,
  "silverthorne": 3,
  "simeon": 3,
  "simeone": 3,
  "simoneau": 3,
  "simoneaux": 3,
  "simonette": 3,
  "simpleminded": 4,
  "simplesse": 2,
  "sincavage": 3,
  "Sindayen": 3,
  "singled": 2,
  "singlehandedly": 5,
  "sinuses": 3,
  "sithe": 1,
  "sixes": 2,
  "sizes": 2,
  "sizzled": 2,
  "skeoch": 2,
  "sketches": 2,
  "skewering": 3,
  "skidded": 2,
  "skyboxes": 3,
  "slaughterhouses": 4,
  "slices": 2,
  "slippage": 2,
  "smoothed": 1,
  "smuggled": 2,
  "smythe": 1,
  "snarled": 2,
  "snatches": 2,
  "sobering": 3,
  "socia": 2,
  "softimage": 3,
  "soileau": 2,
  "sokaiya": 3,
  "solace": 2,
  "soldiering": 3,
  "solve": 1,
  "solves": 1,
  "somerville": 3,
  "sommerville": 3,
  "sonne": 1,
  "soothe": 1,
  "soothed": 1,
  "soothes": 1,
  "sorbonne": 2,
  "sorcerer": 3,
  "sorcerers": 3,
  "sorice": 2,
  "sotomayor": 4,
  "sounded": 2,
  "sources": 2,
  "sourrouille": 3,
  "sovetskaya": 4,
  "soviet": 3,
  "sovietologist": 6,
  "soya": 2,
  "soyars": 2,
  "soysauce": 2,
  "soyuz": 2,
  "spaceport": 2,
  "spaces": 2,
  "spaceship": 2,
  "spaceships": 2,
  "spangled": 2,
  "sparkled": 2,
  "spasm": 2,
  "specializes": 4,
  "speckled": 2,
  "spices": 2,
  "splices": 2,
  "spoilage": 2,
  "spokeswoman": 3,
  "spokewoman": 3,
  "sponges": 2,
  "sporleder": 3,
  "spouses": 2,
  "springerville": 3,
  "sprinkled": 2,
  "squabbled": 2,
  "squillace": 2,
  "stabilizes": 4,
  "stacia": 2,
  "stages": 2,
  "staggering": 3,
  "staircases": 3,
  "stampeding": 3,
  "stances": 2,
  "stapled": 2,
  "starches": 2,
  "starnes": 1,
  "statement": 2,
  "statements": 2,
  "stateside": 2,
  "statistician": 4,
  "statisticians": 4,
  "stayover": 3,
  "stayovers": 3,
  "steakhouses": 3,
  "stearne": 1,
  "steenkiste": 2,
  "stelle": 1,
  "stephenville": 3,
  "stereo": 3,
  "stereographic": 5,
  "stereos": 3,
  "stereotype": 4,
  "stereotyped": 4,
  "stereotypes": 4,
  "stereotypical": 6,
  "stereotyping": 5,
  "sterilizes": 4,
  "sterne": 1,
  "steubenville": 3,
  "stifled": 2,
  "stille": 1,
  "stinnette": 2,
  "stitches": 2,
  "stockbrokerage": 4,
  "stockbrokerages": 5,
  "stolichnaya": 4,
  "stolle": 1,
  "stooges": 2,
  "stoppage": 2,
  "stoppages": 3,
  "stopwatches": 3,
  "storage": 2,
  "straddled": 2,
  "straddling": 2,
  "straggled": 2,
  "straitlaced": 2,
  "stranded": 2,
  "strangeness": 2,
  "strangled": 2,
  "stretches": 2,
  "stromme": 1,
  "struggled": 2,
  "studded": 2,
  "stumbled": 2,
  "stumpage": 2,
  "sturges": 2,
  "stuteville": 2,
  "subsidizes": 4,
  "substances": 3,
  "subsurface": 3,
  "subterfuge": 3,
  "suffice": 2,
  "sufficed": 2,
  "suffices": 3,
  "suffrage": 2,
  "suffragettes": 3,
  "suggestiveness": 4,
  "sugiyama": 4,
  "suisse": 1,
  "suitcases": 3,
  "sukiyaki": 4,
  "summarizes": 4,
  "summerville": 3,
  "superseding": 4,
  "supervises": 4,
  "supposedly": 4,
  "supposes": 3,
  "surcharges": 3,
  "surette": 2,
  "surface": 2,
  "surfaced": 2,
  "surfaceness": 3,
  "surfaces": 3,
  "surges": 2,
  "surmises": 3,
  "surpluses": 3,
  "surprises": 3,
  "surrealisms": 4,
  "surrette": 2,
  "surrounded": 3,
  "surtaxes": 3,
  "surveyor": 3,
  "surveyors": 3,
  "susanne": 2,
  "susette": 2,
  "suspended": 3,
  "suzanne": 2,
  "suzette": 2,
  "sverige": 2,
  "swaggering": 3,
  "swatches": 2,
  "swathed": 1,
  "swinburnes": 2,
  "swindled": 2,
  "switches": 2,
  "sybille": 2,
  "symbion": 3,
  "symbolizes": 4,
  "symmes": 1,
  "sympathizes": 4,
  "syringes": 3,
  "tableau": 2,
  "tableaux": 2,
  "tabled": 2,
  "tackled": 2,
  "tactician": 3,
  "tacticians": 3,
  "taddeo": 3,
  "tafoya": 3,
  "taiyo": 2,
  "takashimaya": 5,
  "takayama": 4,
  "takeo": 3,
  "talmage": 2,
  "tamayo": 3,
  "tangled": 2,
  "tapering": 3,
  "tasm": 2,
  "taste": 1,
  "tasteful": 2,
  "tastefully": 3,
  "tasteless": 2,
  "tastes": 1,
  "tauruses": 3,
  "taxes": 2,
  "teases": 2,
  "tebeau": 2,
  "technician": 3,
  "technicians": 3,
  "teenage": 2,
  "teenaged": 2,
  "telemanagement": 5,
  "televideo": 5,
  "telexes": 3,
  "telles": 1,
  "temme": 1,
  "tended": 2,
  "teo": 2,
  "teodoro": 4,
  "teriyaki": 4,
  "ternes": 1,
  "terrace": 2,
  "terraced": 2,
  "terraces": 3,
  "terrorizes": 4,
  "teruya": 3,
  "teske": 1,
  "tetreault": 2,
  "thaddea": 3,
  "thatches": 2,
  "thebeau": 2,
  "themselves": 2,
  "theo": 2,
  "theobald": 3,
  "theocracy": 4,
  "theocratic": 4,
  "theodor": 3,
  "theodora": 4,
  "theodore": 3,
  "theodorou": 4,
  "theodric": 3,
  "theola": 3,
  "theologian": 5,
  "theological": 5,
  "theology": 4,
  "theon": 2,
  "theone": 2,
  "theophania": 5,
  "theophila": 4,
  "theora": 3,
  "theoretical": 5,
  "theoretically": 6,
  "theorist": 3,
  "theorists": 3,
  "theorize": 3,
  "theorized": 3,
  "theorizes": 4,
  "theorizing": 4,
  "theses": 2,
  "thibadeau": 3,
  "thibeau": 2,
  "thibeault": 2,
  "thibeaux": 2,
  "thibedeau": 3,
  "thibodeau": 3,
  "thibodeaux": 3,
  "thinnes": 1,
  "thoennes": 1,
  "thomases": 3,
  "thomasville": 3,
  "thoreau": 2,
  "thorne": 1,
  "thoroughbred": 3,
  "throneberry": 3,
  "tickled": 2,
  "tilles": 1,
  "timme": 1,
  "tinkled": 2,
  "tithe": 1,
  "titusville": 3,
  "toa": 2,
  "toddling": 2,
  "toelle": 1,
  "toggled": 2,
  "toggling": 2,
  "tokuyama": 4,
  "tolerances": 4,
  "tolle": 1,
  "tolles": 1,
  "tomeo": 3,
  "tondreau": 2,
  "tonnage": 2,
  "tonnages": 3,
  "tonne": 1,
  "tonnes": 1,
  "toothed": 1,
  "toothpaste": 2,
  "toothpastes": 2,
  "toppled": 2,
  "torches": 2,
  "torosian": 3,
  "torreon": 3,
  "torsiello": 4,
  "tortoises": 3,
  "tortorice": 3,
  "tortoriello": 5,
  "toshiyuki": 4,
  "toste": 1,
  "touchette": 2,
  "tourangeau": 3,
  "tourville": 2,
  "towering": 3,
  "townhouses": 3,
  "toyama": 3,
  "toyo": 2,
  "toyobo": 3,
  "toyoda": 3,
  "toyoo": 2,
  "toyota": 3,
  "toyotas": 3,
  "traces": 2,
  "tracheophytes": 4,
  "trackage": 2,
  "trageser": 3,
  "trampled": 2,
  "transcended": 3,
  "transimage": 3,
  "treatises": 3,
  "trebled": 2,
  "trefgarne": 2,
  "treharne": 2,
  "trembled": 2,
  "trended": 2,
  "treon": 2,
  "triage": 2,
  "tricia": 2,
  "trickled": 2,
  "trieste": 1,
  "triggering": 3,
  "tripled": 2,
  "trivette": 2,
  "trivializes": 5,
  "troubled": 2,
  "troyan": 2,
  "troyanos": 3,
  "troyat": 2,
  "troyu": 2,
  "trudeau": 2,
  "trudges": 2,
  "trundled": 2,
  "tryart": 2,
  "tsiang": 1,
  "tsuneo": 3,
  "tuberville": 3,
  "tumbled": 2,
  "tunisian": 3,
  "turberville": 3,
  "turbocharges": 4,
  "turenne": 2,
  "turnage": 2,
  "turville": 2,
  "tussled": 2,
  "tutelage": 3,
  "twelve": 1,
  "twitches": 2,
  "udelle": 2,
  "ulloa": 3,
  "umbrage": 2,
  "unabashedly": 5,
  "unabridged": 3,
  "unacknowledged": 4,
  "unamended": 4,
  "unannounced": 3,
  "unattached": 3,
  "unattended": 4,
  "unbalanced": 3,
  "unbounded": 3,
  "unbranded": 3,
  "unbridled": 3,
  "unchallenged": 3,
  "unchanged": 2,
  "uncontroversial": 5,
  "unconvinced": 3,
  "uncovering": 4,
  "undamaged": 3,
  "underage": 3,
  "underfinanced": 4,
  "underfunded": 4,
  "underhanded": 4,
  "underprice": 3,
  "underpriced": 3,
  "understatement": 4,
  "unemployable": 5,
  "unfenced": 2,
  "unfolded": 3,
  "unfounded": 3,
  "unfunded": 3,
  "Ungeheuer": 4,
  "ungerer": 3,
  "unguarded": 3,
  "unhedged": 2,
  "unheralded": 4,
  "unhinged": 2,
  "unintended": 4,
  "unionfed": 3,
  "uniroyal": 4,
  "unmanage": 3,
  "unmanaged": 3,
  "unnoticed": 3,
  "unpayable": 4,
  "unplaced": 2,
  "unprincipled": 4,
  "unreality": 5,
  "unrealized": 4,
  "unrecorded": 4,
  "unruffled": 3,
  "unscathed": 2,
  "unshackled": 3,
  "untouched": 2,
  "untroubled": 3,
  "unwavering": 4,
  "upended": 3,
  "upstage": 2,
  "upstaged": 2,
  "Ural": 2,
  "urges": 2,
  "Urquart": 2,
  "uruguayan": 4,
  "usage": 2,
  "usages": 3,
  "uses": 2,
  "uthe": 1,
  "utilizes": 4,
  "Uttar": 2,
  "utterances": 4,
  "uyeda": 3,
  "uyehara": 4,
  "uyeno": 3,
  "Uzis": 2,
  "vacaville": 3,
  "valeo": 3,
  "valle": 1,
  "valleau": 2,
  "vallely": 2,
  "valles": 1,
  "vallette": 2,
  "valve": 1,
  "valves": 1,
  "vanasse": 2,
  "vandamme": 2,
  "vanderslice": 3,
  "vandewalle": 3,
  "vanhorne": 2,
  "vannguyen": 3,
  "vannice": 2,
  "vanscoyoc": 3,
  "vantage": 2,
  "vantages": 3,
  "variances": 4,
  "varnes": 1,
  "varves": 1,
  "vases": 2,
  "vaske": 1,
  "vaudeville": 2,
  "vaxes": 2,
  "vedette": 2,
  "veillette": 2,
  "velayati": 4,
  "venereal": 4,
  "venice": 2,
  "venne": 1,
  "venturesome": 3,
  "verbiage": 3,
  "verges": 2,
  "verhage": 2,
  "vermette": 2,
  "verne": 1,
  "vernes": 1,
  "verrette": 2,
  "versace": 2,
  "versailles": 2,
  "verville": 2,
  "vestige": 2,
  "vestiges": 3,
  "vette": 1,
  "vices": 2,
  "video": 3,
  "videodisk": 4,
  "videodisks": 4,
  "videogame": 4,
  "videophone": 4,
  "videos": 3,
  "videotape": 4,
  "videotaped": 4,
  "videotapes": 4,
  "videotaping": 5,
  "videotex": 4,
  "videotext": 4,
  "videotron": 4,
  "vienneau": 2,
  "viet": 2,
  "vigneau": 2,
  "vigneault": 2,
  "vignette": 2,
  "vignettes": 2,
  "village": 2,
  "villages": 3,
  "villareal": 4,
  "ville": 1,
  "villette": 2,
  "vincelette": 3,
  "vindictiveness": 4,
  "vingmed": 2,
  "vintage": 2,
  "vintages": 3,
  "violation": 4,
  "violette": 3,
  "viruses": 3,
  "visage": 2,
  "vitiello": 4,
  "viverette": 3,
  "viyella": 3,
  "vizcaya": 3,
  "voges": 2,
  "voiceless": 2,
  "voices": 2,
  "volle": 1,
  "voltage": 2,
  "voltages": 3,
  "voyage": 2,
  "voyaged": 2,
  "voyager": 3,
  "voyagers": 3,
  "voyages": 3,
  "voyeur": 2,
  "voyeurism": 4,
  "vremya": 3,
  "wadded": 2,
  "waffled": 2,
  "waffling": 2,
  "wagering": 3,
  "wages": 2,
  "wakabayashi": 5,
  "wallace": 2,
  "walle": 1,
  "walles": 1,
  "wallpapering": 4,
  "walruses": 3,
  "wangled": 2,
  "wantage": 2,
  "wantages": 3,
  "warded": 2,
  "warehime": 2,
  "warehouse": 2,
  "warehousing": 3,
  "warmongering": 4,
  "warne": 1,
  "warnes": 1,
  "washburne": 2,
  "wasmer": 3,
  "waste": 1,
  "wasteful": 2,
  "wastes": 1,
  "watches": 2,
  "waterbed": 3,
  "waterborne": 3,
  "watsonville": 3,
  "wavering": 3,
  "waxes": 2,
  "Wayans": 2,
  "waynesville": 2,
  "wedded": 2,
  "wedges": 2,
  "weisse": 1,
  "welborne": 2,
  "welded": 2,
  "welle": 1,
  "welles": 1,
  "wentzville": 2,
  "wernette": 2,
  "wesleyan": 3,
  "westburne": 2,
  "westfaelisches": 4,
  "weyand": 2,
  "weyandt": 2,
  "weyant": 2,
  "whampoa": 3,
  "wheezes": 2,
  "whiteness": 2,
  "whiteside": 2,
  "whitesides": 2,
  "whittling": 2,
  "wholesome": 2,
  "wicked": 2,
  "wickedly": 3,
  "wielded": 2,
  "wilbourne": 2,
  "willabelle": 3,
  "willamette": 3,
  "wille": 1,
  "willes": 1,
  "willette": 2,
  "wilmette": 2,
  "winborne": 2,
  "winded": 2,
  "winne": 1,
  "winterbourne": 3,
  "wion": 2,
  "witches": 2,
  "wobbled": 2,
  "woeste": 1,
  "wolle": 1,
  "wolves": 1,
  "worded": 2,
  "workplace": 2,
  "workplaces": 3,
  "wounded": 2,
  "wrangled": 2,
  "wreckage": 2,
  "wretched": 2,
  "wretchedly": 3,
  "wrinkled": 2,
  "wristwatches": 3,
  "wyand": 2,
  "wyant": 2,
  "wyatt": 2,
  "wyeth": 2,
  "wynne": 1,
  "wythe": 1,
  "xinhua": 3,
  "Yanayev": 3,
  "yardage": 2,
  "yasuyoshi": 4,
  "yelle": 1,
  "yeo": 2,
  "yeses": 2,
  "yeske": 1,
  "yevette": 2,
  "yielded": 2,
  "ying": 1,
  "yinger": 2,
  "yodice": 2,
  "yohe": 2,
  "yokoyama": 4,
  "yoneyama": 4,
  "yourselves": 2,
  "youville": 2,
  "yuille": 1,
  "yvette": 2,
  "yvonne": 2,
  "zanoyan": 3,
  "zaske": 1,
  "zaslavskaya": 4,
  "zayac": 2,
  "zayas": 2,
  "zeebrugge": 3,
  "zegeer": 2,
  "zelaya": 3,
  "zelle": 1,
  "zeoli": 3,
  "zeos": 2,
  "zieske": 1,
  "zion": 2,
  "zionism": 4,
  "zionist": 3,
  "zionists": 3,
  "zions": 2,
  "zises": 2,
  "ziyad": 2,
  "ziyang": 2,
  "zoologist": 4,
  "zoology": 4,
  "zornes": 1
};
