import 'dart:async';

import 'package:flutter/foundation.dart';
import 'package:flutter/widgets.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:intl/intl.dart' as intl;

import 'app_localizations_en.dart';
import 'app_localizations_tr.dart';

/// Callers can lookup localized strings with an instance of AppLocalizations
/// returned by `AppLocalizations.of(context)`.
///
/// Applications need to include `AppLocalizations.delegate()` in their app's
/// `localizationDelegates` list, and the locales they support in the app's
/// `supportedLocales` list. For example:
///
/// ```dart
/// import 'gen_l10n/app_localizations.dart';
///
/// return MaterialApp(
///   localizationsDelegates: AppLocalizations.localizationsDelegates,
///   supportedLocales: AppLocalizations.supportedLocales,
///   home: MyApplicationHome(),
/// );
/// ```
///
/// ## Update pubspec.yaml
///
/// Please make sure to update your pubspec.yaml to include the following
/// packages:
///
/// ```yaml
/// dependencies:
///   # Internationalization support.
///   flutter_localizations:
///     sdk: flutter
///   intl: any # Use the pinned version from flutter_localizations
///
///   # Rest of dependencies
/// ```
///
/// ## iOS Applications
///
/// iOS applications define key application metadata, including supported
/// locales, in an Info.plist file that is built into the application bundle.
/// To configure the locales supported by your app, you’ll need to edit this
/// file.
///
/// First, open your project’s ios/Runner.xcworkspace Xcode workspace file.
/// Then, in the Project Navigator, open the Info.plist file under the Runner
/// project’s Runner folder.
///
/// Next, select the Information Property List item, select Add Item from the
/// Editor menu, then select Localizations from the pop-up menu.
///
/// Select and expand the newly-created Localizations item then, for each
/// locale your application supports, add a new item and select the locale
/// you wish to add from the pop-up menu in the Value field. This list should
/// be consistent with the languages listed in the AppLocalizations.supportedLocales
/// property.
abstract class AppLocalizations {
  AppLocalizations(String locale) : localeName = intl.Intl.canonicalizedLocale(locale.toString());

  final String localeName;

  static AppLocalizations of(BuildContext context) {
    return Localizations.of<AppLocalizations>(context, AppLocalizations)!;
  }

  static const LocalizationsDelegate<AppLocalizations> delegate = _AppLocalizationsDelegate();

  /// A list of this localizations delegate along with the default localizations
  /// delegates.
  ///
  /// Returns a list of localizations delegates containing this delegate along with
  /// GlobalMaterialLocalizations.delegate, GlobalCupertinoLocalizations.delegate,
  /// and GlobalWidgetsLocalizations.delegate.
  ///
  /// Additional delegates can be added by appending to this list in
  /// MaterialApp. This list does not have to be used at all if a custom list
  /// of delegates is preferred or required.
  static const List<LocalizationsDelegate<dynamic>> localizationsDelegates = <LocalizationsDelegate<dynamic>>[
    delegate,
    GlobalMaterialLocalizations.delegate,
    GlobalCupertinoLocalizations.delegate,
    GlobalWidgetsLocalizations.delegate,
  ];

  /// A list of this localizations delegate's supported locales.
  static const List<Locale> supportedLocales = <Locale>[
    Locale('en'),
    Locale('tr')
  ];

  /// No description provided for @appName.
  ///
  /// In en, this message translates to:
  /// **'Locus'**
  String get appName;

  /// No description provided for @unknownError.
  ///
  /// In en, this message translates to:
  /// **'An unknown error occurred'**
  String get unknownError;

  /// No description provided for @unknownValue.
  ///
  /// In en, this message translates to:
  /// **'Unknown'**
  String get unknownValue;

  /// No description provided for @resetLabel.
  ///
  /// In en, this message translates to:
  /// **'Reset'**
  String get resetLabel;

  /// No description provided for @cancelLabel.
  ///
  /// In en, this message translates to:
  /// **'Cancel'**
  String get cancelLabel;

  /// No description provided for @loading.
  ///
  /// In en, this message translates to:
  /// **'Loading...'**
  String get loading;

  /// No description provided for @biometricsFailed.
  ///
  /// In en, this message translates to:
  /// **'You could not be authenticated'**
  String get biometricsFailed;

  /// No description provided for @openInMaps.
  ///
  /// In en, this message translates to:
  /// **'Open in Maps'**
  String get openInMaps;

  /// No description provided for @addLabel.
  ///
  /// In en, this message translates to:
  /// **'Add'**
  String get addLabel;

  /// No description provided for @showDetailsLabel.
  ///
  /// In en, this message translates to:
  /// **'Show Details'**
  String get showDetailsLabel;

  /// No description provided for @addNewValueLabel.
  ///
  /// In en, this message translates to:
  /// **'Add \"{value}\"'**
  String addNewValueLabel(String value);

  /// No description provided for @taskImportError.
  ///
  /// In en, this message translates to:
  /// **'An error occurred while importing the task'**
  String get taskImportError;

  /// No description provided for @taskImport_error_no_relays.
  ///
  /// In en, this message translates to:
  /// **'No relays are present in the task.'**
  String get taskImport_error_no_relays;

  /// No description provided for @taskImport_error_sameTask.
  ///
  /// In en, this message translates to:
  /// **'This is a task from you (name: {name}).'**
  String taskImport_error_sameTask(String name);

  /// No description provided for @taskImport_error_sameView.
  ///
  /// In en, this message translates to:
  /// **'This is a view from you (name: {name}).'**
  String taskImport_error_sameView(String name);

  /// No description provided for @longFormattedDate.
  ///
  /// In en, this message translates to:
  /// **'{date}'**
  String longFormattedDate(DateTime date);

  /// No description provided for @hoursPluralization.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =1{hour} other{hours}}'**
  String hoursPluralization(num count);

  /// No description provided for @locationsLoadingError.
  ///
  /// In en, this message translates to:
  /// **'An error occurred while loading locations'**
  String get locationsLoadingError;

  /// No description provided for @locationFetchError.
  ///
  /// In en, this message translates to:
  /// **'There was an error fetching the locations. Please try again later.'**
  String get locationFetchError;

  /// No description provided for @locationFetchEmptyError.
  ///
  /// In en, this message translates to:
  /// **'No locations found. Maybe there hasn\'t been shared a location yet or they expired.'**
  String get locationFetchEmptyError;

  /// No description provided for @locationIsStillFetching.
  ///
  /// In en, this message translates to:
  /// **'Locations are still being fetched... These may not be the latest locations.'**
  String get locationIsStillFetching;

  /// No description provided for @goBack.
  ///
  /// In en, this message translates to:
  /// **'Go back'**
  String get goBack;

  /// No description provided for @closePositiveSheetAction.
  ///
  /// In en, this message translates to:
  /// **'Done'**
  String get closePositiveSheetAction;

  /// No description provided for @closeNeutralAction.
  ///
  /// In en, this message translates to:
  /// **'Ok'**
  String get closeNeutralAction;

  /// No description provided for @continueLabel.
  ///
  /// In en, this message translates to:
  /// **'Continue'**
  String get continueLabel;

  /// No description provided for @deleteLabel.
  ///
  /// In en, this message translates to:
  /// **'Delete'**
  String get deleteLabel;

  /// No description provided for @dismissLabel.
  ///
  /// In en, this message translates to:
  /// **'Dismiss'**
  String get dismissLabel;

  /// No description provided for @editRelays.
  ///
  /// In en, this message translates to:
  /// **'Edit Relays'**
  String get editRelays;

  /// No description provided for @editTimers.
  ///
  /// In en, this message translates to:
  /// **'Edit Timers'**
  String get editTimers;

  /// No description provided for @uniLinksOpenError.
  ///
  /// In en, this message translates to:
  /// **'Link could not be opened'**
  String get uniLinksOpenError;

  /// No description provided for @actionNotUndoable.
  ///
  /// In en, this message translates to:
  /// **'This action cannot be undone!'**
  String get actionNotUndoable;

  /// No description provided for @linkCopiedToClipboard.
  ///
  /// In en, this message translates to:
  /// **'Link copied to clipboard!'**
  String get linkCopiedToClipboard;

  /// No description provided for @textCopiedToClipboard.
  ///
  /// In en, this message translates to:
  /// **'Text copied to clipboard!'**
  String get textCopiedToClipboard;

  /// No description provided for @increaseVolume.
  ///
  /// In en, this message translates to:
  /// **'Turn up the volume'**
  String get increaseVolume;

  /// No description provided for @nostrRelaysLabel.
  ///
  /// In en, this message translates to:
  /// **'Nostr Relays'**
  String get nostrRelaysLabel;

  /// No description provided for @nostrPublicKeyLabel.
  ///
  /// In en, this message translates to:
  /// **'Public Nostr key'**
  String get nostrPublicKeyLabel;

  /// No description provided for @signPublicKeyLabel.
  ///
  /// In en, this message translates to:
  /// **'Public Sign key'**
  String get signPublicKeyLabel;

  /// No description provided for @detailsTimersLabel.
  ///
  /// In en, this message translates to:
  /// **'Timers'**
  String get detailsTimersLabel;

  /// No description provided for @searchLabel.
  ///
  /// In en, this message translates to:
  /// **'Search'**
  String get searchLabel;

  /// No description provided for @closeApp.
  ///
  /// In en, this message translates to:
  /// **'Close Locus'**
  String get closeApp;

  /// No description provided for @restartRequired_title.
  ///
  /// In en, this message translates to:
  /// **'Restart required'**
  String get restartRequired_title;

  /// No description provided for @restartRequired_description.
  ///
  /// In en, this message translates to:
  /// **'Please restart Locus to apply the changes.'**
  String get restartRequired_description;

  /// No description provided for @grantBluetoothPermission.
  ///
  /// In en, this message translates to:
  /// **'Please activate Bluetooth and grant the permission to scan for nearby devices'**
  String get grantBluetoothPermission;

  /// No description provided for @grantPermission.
  ///
  /// In en, this message translates to:
  /// **'Grant permission'**
  String get grantPermission;

  /// No description provided for @updateAvailable_android.
  ///
  /// In en, this message translates to:
  /// **'A new version of Locus is available! Click to download the newest APK.'**
  String get updateAvailable_android;

  /// No description provided for @updateAvailable_android_title.
  ///
  /// In en, this message translates to:
  /// **'Please update Locus'**
  String get updateAvailable_android_title;

  /// No description provided for @updateAvailable_android_description.
  ///
  /// In en, this message translates to:
  /// **'A new version of Locus is available! Please keep Locus up to date to ensure that it works properly and you are not missing out any new features or bug fixes. Tap to download the newest APK.'**
  String get updateAvailable_android_description;

  /// No description provided for @updateAvailable_android_download.
  ///
  /// In en, this message translates to:
  /// **'Download update'**
  String get updateAvailable_android_download;

  /// No description provided for @updateAvailable_android_remindLater.
  ///
  /// In en, this message translates to:
  /// **'Remind me later'**
  String get updateAvailable_android_remindLater;

  /// No description provided for @updateAvailable_android_ignore.
  ///
  /// In en, this message translates to:
  /// **'Ignore updates'**
  String get updateAvailable_android_ignore;

  /// No description provided for @locationFetcher_actions_fetchMore.
  ///
  /// In en, this message translates to:
  /// **'Download older locations'**
  String get locationFetcher_actions_fetchMore;

  /// No description provided for @doNotShowAgainLabel.
  ///
  /// In en, this message translates to:
  /// **'Do not show again'**
  String get doNotShowAgainLabel;

  /// No description provided for @fields_errors_isEmpty.
  ///
  /// In en, this message translates to:
  /// **'This field is required'**
  String get fields_errors_isEmpty;

  /// No description provided for @fields_errors_invalidCharacters.
  ///
  /// In en, this message translates to:
  /// **'This field contains invalid characters'**
  String get fields_errors_invalidCharacters;

  /// No description provided for @fields_errors_notNumber.
  ///
  /// In en, this message translates to:
  /// **'This field must be a number'**
  String get fields_errors_notNumber;

  /// No description provided for @fields_errors_greaterThan.
  ///
  /// In en, this message translates to:
  /// **'This field must be greater than {value}'**
  String fields_errors_greaterThan(Object value);

  /// No description provided for @fields_errors_invalidURL.
  ///
  /// In en, this message translates to:
  /// **'This field must be a valid URL'**
  String get fields_errors_invalidURL;

  /// No description provided for @openInMaps_title.
  ///
  /// In en, this message translates to:
  /// **'Open in Maps'**
  String get openInMaps_title;

  /// No description provided for @openInMaps_description.
  ///
  /// In en, this message translates to:
  /// **'Where do you want to open this location in?'**
  String get openInMaps_description;

  /// No description provided for @timer_executionStartsImmediately.
  ///
  /// In en, this message translates to:
  /// **'Execution will start immediately.'**
  String get timer_executionStartsImmediately;

  /// No description provided for @timer_nextExecution.
  ///
  /// In en, this message translates to:
  /// **'Next execution will start at {date}'**
  String timer_nextExecution(DateTime date);

  /// No description provided for @timer_runsInfiniteMessage.
  ///
  /// In en, this message translates to:
  /// **'This task will run until you stop it manually.'**
  String get timer_runsInfiniteMessage;

  /// No description provided for @timer_addWeekday.
  ///
  /// In en, this message translates to:
  /// **'Add Weekday'**
  String get timer_addWeekday;

  /// No description provided for @timer_addDuration.
  ///
  /// In en, this message translates to:
  /// **'Add Duration'**
  String get timer_addDuration;

  /// No description provided for @relaySelectSheet_selectRandomRelays.
  ///
  /// In en, this message translates to:
  /// **'Select {count} random Nostr Relays'**
  String relaySelectSheet_selectRandomRelays(Object count);

  /// No description provided for @relaySelectSheet_loadingRelaysMeta.
  ///
  /// In en, this message translates to:
  /// **'Loading Nostr Relays information...'**
  String get relaySelectSheet_loadingRelaysMeta;

  /// No description provided for @relaySelectSheet_hint.
  ///
  /// In en, this message translates to:
  /// **'Relays are sorted from best to worst in ascending order. The best relays are at the top.'**
  String get relaySelectSheet_hint;

  /// No description provided for @taskAction_start.
  ///
  /// In en, this message translates to:
  /// **'Start Task'**
  String get taskAction_start;

  /// No description provided for @taskAction_started_title.
  ///
  /// In en, this message translates to:
  /// **'Task started'**
  String get taskAction_started_title;

  /// No description provided for @taskAction_started_description.
  ///
  /// In en, this message translates to:
  /// **'Task started at {date}'**
  String taskAction_started_description(DateTime date);

  /// No description provided for @taskAction_notRunning_title.
  ///
  /// In en, this message translates to:
  /// **'Task is not running'**
  String get taskAction_notRunning_title;

  /// No description provided for @taskAction_started_runsUntil.
  ///
  /// In en, this message translates to:
  /// **'The task has been started and will run until {date}'**
  String taskAction_started_runsUntil(DateTime date);

  /// No description provided for @taskAction_stop.
  ///
  /// In en, this message translates to:
  /// **'Stop Task'**
  String get taskAction_stop;

  /// No description provided for @taskAction_stopped_title.
  ///
  /// In en, this message translates to:
  /// **'Task stopped'**
  String get taskAction_stopped_title;

  /// No description provided for @taskAction_stopped_startsAgain.
  ///
  /// In en, this message translates to:
  /// **'The task has been stopped and will start again at {date}'**
  String taskAction_stopped_startsAgain(DateTime date);

  /// No description provided for @taskAction_startSchedule.
  ///
  /// In en, this message translates to:
  /// **'Start Schedule'**
  String get taskAction_startSchedule;

  /// No description provided for @taskAction_startSchedule_title.
  ///
  /// In en, this message translates to:
  /// **'Task has been scheduled'**
  String get taskAction_startSchedule_title;

  /// No description provided for @taskAction_startSchedule_description.
  ///
  /// In en, this message translates to:
  /// **'Task has been scheduled to start at {date}.'**
  String taskAction_startSchedule_description(DateTime date);

  /// No description provided for @taskAction_startSchedule_notScheduled_title.
  ///
  /// In en, this message translates to:
  /// **'Task has not been scheduled'**
  String get taskAction_startSchedule_notScheduled_title;

  /// No description provided for @taskAction_startSchedule_notScheduled_description.
  ///
  /// In en, this message translates to:
  /// **'The task has not been started because there is no schedule set for the future.'**
  String get taskAction_startSchedule_notScheduled_description;

  /// No description provided for @taskAction_stopSchedule.
  ///
  /// In en, this message translates to:
  /// **'Stop Schedule'**
  String get taskAction_stopSchedule;

  /// No description provided for @taskAction_stopSchedule_title.
  ///
  /// In en, this message translates to:
  /// **'Task has been unscheduled'**
  String get taskAction_stopSchedule_title;

  /// No description provided for @taskAction_stopSchedule_description.
  ///
  /// In en, this message translates to:
  /// **'The task has been unscheduled. It will no longer be executed automatically. To start it again, you can either schedule it again or start it manually'**
  String get taskAction_stopSchedule_description;

  /// No description provided for @taskAction_generateLink.
  ///
  /// In en, this message translates to:
  /// **'Generate link'**
  String get taskAction_generateLink;

  /// No description provided for @taskAction_generateLink_process_encrypting.
  ///
  /// In en, this message translates to:
  /// **'Encrypting...'**
  String get taskAction_generateLink_process_encrypting;

  /// No description provided for @taskAction_generateLink_process_publishing.
  ///
  /// In en, this message translates to:
  /// **'Publishing encrypted data...'**
  String get taskAction_generateLink_process_publishing;

  /// No description provided for @taskAction_generateLink_process_creatingURI.
  ///
  /// In en, this message translates to:
  /// **'Creating link...'**
  String get taskAction_generateLink_process_creatingURI;

  /// No description provided for @taskAction_generateLink_shareTextSubject.
  ///
  /// In en, this message translates to:
  /// **'Here\'s the link to see my location'**
  String get taskAction_generateLink_shareTextSubject;

  /// No description provided for @taskAction_showDetails.
  ///
  /// In en, this message translates to:
  /// **'Show Details'**
  String get taskAction_showDetails;

  /// No description provided for @tasks_action_stopAll.
  ///
  /// In en, this message translates to:
  /// **'Stop tasks'**
  String get tasks_action_stopAll;

  /// No description provided for @tasks_action_startAll.
  ///
  /// In en, this message translates to:
  /// **'Start tasks'**
  String get tasks_action_startAll;

  /// No description provided for @tasks_examples_weekend.
  ///
  /// In en, this message translates to:
  /// **'Weekend Getaway'**
  String get tasks_examples_weekend;

  /// No description provided for @tasks_examples_school.
  ///
  /// In en, this message translates to:
  /// **'School'**
  String get tasks_examples_school;

  /// No description provided for @tasks_example_hourDuration.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =1{One hour} other{{count} hours}}'**
  String tasks_example_hourDuration(int count);

  /// No description provided for @tasks_example_daysDuration.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =1{One day} other{{count} days}}'**
  String tasks_example_daysDuration(int count);

  /// No description provided for @unnamedView.
  ///
  /// In en, this message translates to:
  /// **'Unnamed'**
  String get unnamedView;

  /// No description provided for @viewAction_delete.
  ///
  /// In en, this message translates to:
  /// **'Delete'**
  String get viewAction_delete;

  /// No description provided for @viewAction_delete_confirm_title.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to delete {view}?'**
  String viewAction_delete_confirm_title(String view);

  /// No description provided for @welcomeScreen_title.
  ///
  /// In en, this message translates to:
  /// **'Welcome to Locus'**
  String get welcomeScreen_title;

  /// No description provided for @welcomeScreen_description.
  ///
  /// In en, this message translates to:
  /// **'Share your location with your friends and family fully privately and securely.'**
  String get welcomeScreen_description;

  /// No description provided for @welcomeScreen_getStarted.
  ///
  /// In en, this message translates to:
  /// **'Get Started'**
  String get welcomeScreen_getStarted;

  /// No description provided for @welcomeScreen_explanation_title.
  ///
  /// In en, this message translates to:
  /// **'Your data. You decide.'**
  String get welcomeScreen_explanation_title;

  /// No description provided for @welcomeScreen_explanation_description.
  ///
  /// In en, this message translates to:
  /// **'Your data is fully end-to-end encrypted to people you share your location with. We can not see your location. Your encrypted data is stored only on the servers of your choice.'**
  String get welcomeScreen_explanation_description;

  /// No description provided for @welcomeScreen_explanation_understood.
  ///
  /// In en, this message translates to:
  /// **'Understood'**
  String get welcomeScreen_explanation_understood;

  /// No description provided for @welcomeScreen_startLabel.
  ///
  /// In en, this message translates to:
  /// **'Start Locus'**
  String get welcomeScreen_startLabel;

  /// No description provided for @transferScreen_receive_awaiting_label.
  ///
  /// In en, this message translates to:
  /// **'Make sure you have Bluetooth enabled. Waiting for transfer, open Locus on your old device and go to settings, then tap \"Transfer Locus to a new Phone\"'**
  String get transferScreen_receive_awaiting_label;

  /// No description provided for @transferScreen_send_awaiting_label.
  ///
  /// In en, this message translates to:
  /// **'Make sure you have Bluetooth enabled. Searching for nearby devices...'**
  String get transferScreen_send_awaiting_label;

  /// No description provided for @transferScreen_send_pin_description.
  ///
  /// In en, this message translates to:
  /// **'This is your PIN:'**
  String get transferScreen_send_pin_description;

  /// No description provided for @transferScreen_send_connected_label.
  ///
  /// In en, this message translates to:
  /// **'Perfect! You are connected to your new device. Press \"Transfer\" to start the transfer.'**
  String get transferScreen_send_connected_label;

  /// No description provided for @transferScreen_send_startTransfer.
  ///
  /// In en, this message translates to:
  /// **'Transfer'**
  String get transferScreen_send_startTransfer;

  /// No description provided for @transferScreen_receive_connect_description.
  ///
  /// In en, this message translates to:
  /// **'Received a transfer request. This is the PIN. Make sure the PIN matches the one on your old device. If it does, tap \"Connect\".'**
  String get transferScreen_receive_connect_description;

  /// No description provided for @transferScreen_receive_connected_label.
  ///
  /// In en, this message translates to:
  /// **'Please start the transfer on your old device now.'**
  String get transferScreen_receive_connected_label;

  /// No description provided for @importTask_bluetooth_receive_title.
  ///
  /// In en, this message translates to:
  /// **'Receive View Key'**
  String get importTask_bluetooth_receive_title;

  /// No description provided for @importTask_bluetooth_receive_description.
  ///
  /// In en, this message translates to:
  /// **'Receive a view key from another device via Bluetooth. Ask the other person to open a task. Then go to details, tap on share location and select Bluetooth. Make sure you have Bluetooth enabled.'**
  String get importTask_bluetooth_receive_description;

  /// No description provided for @importTask_bluetooth_receive_id_description.
  ///
  /// In en, this message translates to:
  /// **'This is your name visible to others:'**
  String get importTask_bluetooth_receive_id_description;

  /// No description provided for @importTask_bluetooth_send_title.
  ///
  /// In en, this message translates to:
  /// **'Share location via Bluetooth'**
  String get importTask_bluetooth_send_title;

  /// No description provided for @importTask_bluetooth_send_description.
  ///
  /// In en, this message translates to:
  /// **'Make sure you have Bluetooth enabled. Looking for devices...'**
  String get importTask_bluetooth_send_description;

  /// No description provided for @importTask_bluetooth_receive_request_title.
  ///
  /// In en, this message translates to:
  /// **'Do you want to accept the request?'**
  String get importTask_bluetooth_receive_request_title;

  /// No description provided for @importTask_bluetooth_receive_request_description.
  ///
  /// In en, this message translates to:
  /// **'A connect request to share a location has been made. We can\'t tell what location is being shared until you accept the connection. If you expected this connection, you can connect. Otherwise, the request will be rejected.'**
  String get importTask_bluetooth_receive_request_description;

  /// No description provided for @importTask_bluetooth_receive_request_decline.
  ///
  /// In en, this message translates to:
  /// **'Decline'**
  String get importTask_bluetooth_receive_request_decline;

  /// No description provided for @importTask_bluetooth_receive_request_accept.
  ///
  /// In en, this message translates to:
  /// **'Accept'**
  String get importTask_bluetooth_receive_request_accept;

  /// No description provided for @sharesOverviewScreen_title.
  ///
  /// In en, this message translates to:
  /// **'Shares Overview'**
  String get sharesOverviewScreen_title;

  /// No description provided for @sharesOverviewScreen_createTask.
  ///
  /// In en, this message translates to:
  /// **'Create Share'**
  String get sharesOverviewScreen_createTask;

  /// No description provided for @sharesOverviewScreen_tasks.
  ///
  /// In en, this message translates to:
  /// **'Shares'**
  String get sharesOverviewScreen_tasks;

  /// No description provided for @sharesOverviewScreen_createTask_scheduleNow.
  ///
  /// In en, this message translates to:
  /// **'Start schedule immediately'**
  String get sharesOverviewScreen_createTask_scheduleNow;

  /// No description provided for @sharesOverviewScreen_createTask_scheduleNow_help_title.
  ///
  /// In en, this message translates to:
  /// **'Scheduling'**
  String get sharesOverviewScreen_createTask_scheduleNow_help_title;

  /// No description provided for @sharesOverviewScreen_createTask_scheduleNow_help_description.
  ///
  /// In en, this message translates to:
  /// **'The task will be scheduled after you create it. This does not necessarily mean that it will start directly. It will start at the next expected time based on your timers. If you disable this, you will have to schedule the task manually.'**
  String get sharesOverviewScreen_createTask_scheduleNow_help_description;

  /// No description provided for @sharesOverviewScreen_createTask_tasksEmpty.
  ///
  /// In en, this message translates to:
  /// **'No tasks yet'**
  String get sharesOverviewScreen_createTask_tasksEmpty;

  /// No description provided for @sharesOverviewScreen_createTask_description.
  ///
  /// In en, this message translates to:
  /// **'Create a task to share your current location'**
  String get sharesOverviewScreen_createTask_description;

  /// No description provided for @sharesOverviewScreen_createTask_action_create.
  ///
  /// In en, this message translates to:
  /// **'Create Share'**
  String get sharesOverviewScreen_createTask_action_create;

  /// No description provided for @sharesOverviewScreen_tasksSection.
  ///
  /// In en, this message translates to:
  /// **'Shares'**
  String get sharesOverviewScreen_tasksSection;

  /// No description provided for @sharesOverviewScreen_viewsSection.
  ///
  /// In en, this message translates to:
  /// **'Views'**
  String get sharesOverviewScreen_viewsSection;

  /// No description provided for @sharesOverviewScreen_importTask_title.
  ///
  /// In en, this message translates to:
  /// **'Import a Share'**
  String get sharesOverviewScreen_importTask_title;

  /// No description provided for @sharesOverviewScreen_importTask_description.
  ///
  /// In en, this message translates to:
  /// **'Import a task from a link or a file you have received'**
  String get sharesOverviewScreen_importTask_description;

  /// No description provided for @sharesOverviewScreen_importTask_action_import.
  ///
  /// In en, this message translates to:
  /// **'Import Share'**
  String get sharesOverviewScreen_importTask_action_import;

  /// No description provided for @sharesOverviewScreen_importTask_action_importMethod.
  ///
  /// In en, this message translates to:
  /// **'How would you like to import the share?'**
  String get sharesOverviewScreen_importTask_action_importMethod;

  /// No description provided for @sharesOverviewScreen_importTask_action_importMethod_url.
  ///
  /// In en, this message translates to:
  /// **'Import Link'**
  String get sharesOverviewScreen_importTask_action_importMethod_url;

  /// No description provided for @sharesOverviewScreen_importTask_action_importMethod_url_title.
  ///
  /// In en, this message translates to:
  /// **'Enter the link of the share'**
  String get sharesOverviewScreen_importTask_action_importMethod_url_title;

  /// No description provided for @sharesOverviewScreen_importTask_action_importMethod_url_hint.
  ///
  /// In en, this message translates to:
  /// **'https://locus.cfd/#'**
  String get sharesOverviewScreen_importTask_action_importMethod_url_hint;

  /// No description provided for @sharesOverviewScreen_importTask_action_importMethod_url_label.
  ///
  /// In en, this message translates to:
  /// **'Share Link'**
  String get sharesOverviewScreen_importTask_action_importMethod_url_label;

  /// No description provided for @sharesOverviewScreen_importTask_action_importMethod_file.
  ///
  /// In en, this message translates to:
  /// **'Import file'**
  String get sharesOverviewScreen_importTask_action_importMethod_file;

  /// No description provided for @sharesOverviewScreen_importTask_action_importMethod_bluetooth.
  ///
  /// In en, this message translates to:
  /// **'Receive via Bluetooth'**
  String get sharesOverviewScreen_importTask_action_importMethod_bluetooth;

  /// No description provided for @sharesOverviewScreen_importTask_action_importMethod_file_selectFile.
  ///
  /// In en, this message translates to:
  /// **'Select a ViewKey file to import'**
  String get sharesOverviewScreen_importTask_action_importMethod_file_selectFile;

  /// No description provided for @sharesOverviewScreen_importTask_action_import_isLoading.
  ///
  /// In en, this message translates to:
  /// **'Importing...'**
  String get sharesOverviewScreen_importTask_action_import_isLoading;

  /// No description provided for @sharesOverviewScreen_importTask_action_name_title.
  ///
  /// In en, this message translates to:
  /// **'Enter a name for this view'**
  String get sharesOverviewScreen_importTask_action_name_title;

  /// No description provided for @sharesOverviewScreen_importTask_action_name_label.
  ///
  /// In en, this message translates to:
  /// **'Name'**
  String get sharesOverviewScreen_importTask_action_name_label;

  /// No description provided for @sharesOverviewScreen_importTask_action_name_errors_sameNameAlreadyExists.
  ///
  /// In en, this message translates to:
  /// **'A view with this name already exists'**
  String get sharesOverviewScreen_importTask_action_name_errors_sameNameAlreadyExists;

  /// No description provided for @sharesOverviewScreen_importTask_action_color_label.
  ///
  /// In en, this message translates to:
  /// **'Pick a color'**
  String get sharesOverviewScreen_importTask_action_color_label;

  /// No description provided for @sharesOverviewScreen_importTask_importOverview_title.
  ///
  /// In en, this message translates to:
  /// **'Would you like to import this task view?'**
  String get sharesOverviewScreen_importTask_importOverview_title;

  /// No description provided for @sharesOverviewScreen_importTask_importOverview_lastPosition.
  ///
  /// In en, this message translates to:
  /// **'Last Position:'**
  String get sharesOverviewScreen_importTask_importOverview_lastPosition;

  /// No description provided for @sharesOverviewScreen_importTask_successMessage.
  ///
  /// In en, this message translates to:
  /// **'The task was successfully imported!'**
  String get sharesOverviewScreen_importTask_successMessage;

  /// No description provided for @sharesOverviewScreen_importTask_importLabel.
  ///
  /// In en, this message translates to:
  /// **'Import'**
  String get sharesOverviewScreen_importTask_importLabel;

  /// No description provided for @locationsOverview_viewSelection_all.
  ///
  /// In en, this message translates to:
  /// **'Show all locations'**
  String get locationsOverview_viewSelection_all;

  /// No description provided for @locationsOverview_activeShares_amount.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0{No active shares} =1{One share active} other{{count} shares active}}'**
  String locationsOverview_activeShares_amount(num count);

  /// No description provided for @locationsOverview_mapAction_detailedLocations_show.
  ///
  /// In en, this message translates to:
  /// **'Show detailed locations'**
  String get locationsOverview_mapAction_detailedLocations_show;

  /// No description provided for @locationsOverview_mapAction_detailedLocations_hide.
  ///
  /// In en, this message translates to:
  /// **'Merge nearby locations'**
  String get locationsOverview_mapAction_detailedLocations_hide;

  /// No description provided for @mapAction_goToCurrentPosition.
  ///
  /// In en, this message translates to:
  /// **'Go to current position'**
  String get mapAction_goToCurrentPosition;

  /// No description provided for @mapAction_alignNorth.
  ///
  /// In en, this message translates to:
  /// **'Align North'**
  String get mapAction_alignNorth;

  /// No description provided for @createTask_title.
  ///
  /// In en, this message translates to:
  /// **'Define a name for your Share'**
  String get createTask_title;

  /// No description provided for @createTask_fields_name_label.
  ///
  /// In en, this message translates to:
  /// **'Name'**
  String get createTask_fields_name_label;

  /// No description provided for @createTask_sameTaskNameAlreadyExists.
  ///
  /// In en, this message translates to:
  /// **'A Share with this name already exists. You can create the Share, but you will have two Shares with the same name.'**
  String get createTask_sameTaskNameAlreadyExists;

  /// No description provided for @createTask_fields_relays_label.
  ///
  /// In en, this message translates to:
  /// **'Relays'**
  String get createTask_fields_relays_label;

  /// No description provided for @createTask_fields_relays_selectLabel.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0{Select Relays} =1{Selected One Relay} other{Selected {count} Relays}}'**
  String createTask_fields_relays_selectLabel(int count);

  /// No description provided for @createTask_fields_timers_label.
  ///
  /// In en, this message translates to:
  /// **'Timers'**
  String get createTask_fields_timers_label;

  /// No description provided for @createTask_fields_timers_selectLabel.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0{Select Timers} =1{Selected One Timer} other{Selected {count} Timers}}'**
  String createTask_fields_timers_selectLabel(int count);

  /// No description provided for @createTask_process_creatingSignKeys.
  ///
  /// In en, this message translates to:
  /// **'Creating Sign Key...'**
  String get createTask_process_creatingSignKeys;

  /// No description provided for @createTask_process_creatingViewKeys.
  ///
  /// In en, this message translates to:
  /// **'Creating View Key...'**
  String get createTask_process_creatingViewKeys;

  /// No description provided for @createTask_errors_emptyRelays.
  ///
  /// In en, this message translates to:
  /// **'Please select at least one relay'**
  String get createTask_errors_emptyRelays;

  /// No description provided for @createTask_createLabel.
  ///
  /// In en, this message translates to:
  /// **'Create'**
  String get createTask_createLabel;

  /// No description provided for @taskDetails_title.
  ///
  /// In en, this message translates to:
  /// **'Details'**
  String get taskDetails_title;

  /// No description provided for @taskDetails_goToDetails.
  ///
  /// In en, this message translates to:
  /// **'Go to Details'**
  String get taskDetails_goToDetails;

  /// No description provided for @taskDetails_lastKnownLocation.
  ///
  /// In en, this message translates to:
  /// **'Last known location'**
  String get taskDetails_lastKnownLocation;

  /// No description provided for @taskDetails_noLocations.
  ///
  /// In en, this message translates to:
  /// **'No locations saved yet'**
  String get taskDetails_noLocations;

  /// No description provided for @taskDetails_noTimers.
  ///
  /// In en, this message translates to:
  /// **'No timers set up'**
  String get taskDetails_noTimers;

  /// No description provided for @taskDetails_summary.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =1{One location saved} other{{count} locations saved}} ranging from {startDate} to {endDate}'**
  String taskDetails_summary(int count, DateTime startDate, DateTime endDate);

  /// No description provided for @taskDetails_mostRecentLocationExplanation.
  ///
  /// In en, this message translates to:
  /// **'This is the most recent location saved'**
  String get taskDetails_mostRecentLocationExplanation;

  /// No description provided for @taskDetails_locationDetails.
  ///
  /// In en, this message translates to:
  /// **'Location Details'**
  String get taskDetails_locationDetails;

  /// No description provided for @taskDetails_savedLocations.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0{No locations saved yet} =1{One location saved} other{{count} locations saved}}'**
  String taskDetails_savedLocations(int count);

  /// No description provided for @taskDetails_taskStatus.
  ///
  /// In en, this message translates to:
  /// **'Share Status'**
  String get taskDetails_taskStatus;

  /// No description provided for @taskDetails_deleteTask.
  ///
  /// In en, this message translates to:
  /// **'Delete Share'**
  String get taskDetails_deleteTask;

  /// No description provided for @taskDetails_deleteTask_confirm.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to delete this Share? This means that no more locations will be saved for this Share. Existing locations will not be deleted.'**
  String get taskDetails_deleteTask_confirm;

  /// No description provided for @taskDetails_locationDetails_createdAt_label.
  ///
  /// In en, this message translates to:
  /// **'Created At'**
  String get taskDetails_locationDetails_createdAt_label;

  /// No description provided for @taskDetails_locationDetails_createdAt_value.
  ///
  /// In en, this message translates to:
  /// **'{date}'**
  String taskDetails_locationDetails_createdAt_value(DateTime date);

  /// No description provided for @taskDetails_locationDetails_battery_label.
  ///
  /// In en, this message translates to:
  /// **'Battery Level'**
  String get taskDetails_locationDetails_battery_label;

  /// No description provided for @taskDetails_locationDetails_battery_value.
  ///
  /// In en, this message translates to:
  /// **'{level}%'**
  String taskDetails_locationDetails_battery_value(int level);

  /// No description provided for @taskDetails_locationDetails_batteryState_label.
  ///
  /// In en, this message translates to:
  /// **'Battery State'**
  String get taskDetails_locationDetails_batteryState_label;

  /// No description provided for @taskDetails_locationDetails_batteryState_charging.
  ///
  /// In en, this message translates to:
  /// **'Charging'**
  String get taskDetails_locationDetails_batteryState_charging;

  /// No description provided for @taskDetails_locationDetails_batteryState_discharging.
  ///
  /// In en, this message translates to:
  /// **'Discharging'**
  String get taskDetails_locationDetails_batteryState_discharging;

  /// No description provided for @taskDetails_locationDetails_batteryState_full.
  ///
  /// In en, this message translates to:
  /// **'Full'**
  String get taskDetails_locationDetails_batteryState_full;

  /// No description provided for @taskDetails_locationDetails_batteryState_unknown.
  ///
  /// In en, this message translates to:
  /// **'Unknown'**
  String get taskDetails_locationDetails_batteryState_unknown;

  /// No description provided for @taskDetails_locationDetails_accuracy_label.
  ///
  /// In en, this message translates to:
  /// **'Accuracy'**
  String get taskDetails_locationDetails_accuracy_label;

  /// No description provided for @taskDetails_locationDetails_accuracy_value.
  ///
  /// In en, this message translates to:
  /// **'{accuracy}m'**
  String taskDetails_locationDetails_accuracy_value(int accuracy);

  /// No description provided for @taskDetails_locationDetails_speed_label.
  ///
  /// In en, this message translates to:
  /// **'Speed'**
  String get taskDetails_locationDetails_speed_label;

  /// No description provided for @taskDetails_locationDetails_speed_value.
  ///
  /// In en, this message translates to:
  /// **'{speed}m/s'**
  String taskDetails_locationDetails_speed_value(int speed);

  /// No description provided for @taskDetails_locationDetails_altitude_label.
  ///
  /// In en, this message translates to:
  /// **'Altitude'**
  String get taskDetails_locationDetails_altitude_label;

  /// No description provided for @taskDetails_locationDetails_altitude_value.
  ///
  /// In en, this message translates to:
  /// **'{altitude}m'**
  String taskDetails_locationDetails_altitude_value(int altitude);

  /// No description provided for @viewDetails_title.
  ///
  /// In en, this message translates to:
  /// **'View Details'**
  String get viewDetails_title;

  /// No description provided for @viewDetails_actions_openLatestLocation.
  ///
  /// In en, this message translates to:
  /// **'Open Maps to latest location'**
  String get viewDetails_actions_openLatestLocation;

  /// No description provided for @viewDetails_actions_showLocationList.
  ///
  /// In en, this message translates to:
  /// **'Show Location List'**
  String get viewDetails_actions_showLocationList;

  /// No description provided for @viewDetails_actions_showAlarms_show.
  ///
  /// In en, this message translates to:
  /// **'Show Alarms'**
  String get viewDetails_actions_showAlarms_show;

  /// No description provided for @viewDetails_actions_showAlarms_hide.
  ///
  /// In en, this message translates to:
  /// **'Hide Alarms'**
  String get viewDetails_actions_showAlarms_hide;

  /// No description provided for @viewDetails_distanceToLatestLocation_label.
  ///
  /// In en, this message translates to:
  /// **'{distance} meters away'**
  String viewDetails_distanceToLatestLocation_label(int distance);

  /// No description provided for @loadingLocationsTitle.
  ///
  /// In en, this message translates to:
  /// **'Loading locations: {count}'**
  String loadingLocationsTitle(int count);

  /// No description provided for @quickLocationShare_title.
  ///
  /// In en, this message translates to:
  /// **'Share your location now'**
  String get quickLocationShare_title;

  /// No description provided for @quickLocationShare_description.
  ///
  /// In en, this message translates to:
  /// **'A link will be copied to your clipboard which you can share with anyone'**
  String get quickLocationShare_description;

  /// No description provided for @quickLocationShare_shareUntilTurnOff.
  ///
  /// In en, this message translates to:
  /// **'Share until I turn it off'**
  String get quickLocationShare_shareUntilTurnOff;

  /// No description provided for @quickLocationShare_shareForTime.
  ///
  /// In en, this message translates to:
  /// **'Share for the following time'**
  String get quickLocationShare_shareForTime;

  /// No description provided for @quickLocationShare_submit_label.
  ///
  /// In en, this message translates to:
  /// **'Share'**
  String get quickLocationShare_submit_label;

  /// No description provided for @quickLocationShare_name.
  ///
  /// In en, this message translates to:
  /// **'Share from {date}'**
  String quickLocationShare_name(DateTime date);

  /// No description provided for @shareLocation_title.
  ///
  /// In en, this message translates to:
  /// **'Share Location'**
  String get shareLocation_title;

  /// No description provided for @shareLocation_description.
  ///
  /// In en, this message translates to:
  /// **'Would you like to share your location from this task? This will allow other users to see your location. A view key file will be generated which allows anyone to view your location. Makes sure to keep this file safe and only share it with people you trust.'**
  String get shareLocation_description;

  /// No description provided for @shareLocation_actions_saveFile.
  ///
  /// In en, this message translates to:
  /// **'Save File'**
  String get shareLocation_actions_saveFile;

  /// No description provided for @shareLocation_actions_createQRCode.
  ///
  /// In en, this message translates to:
  /// **'Create QR Code'**
  String get shareLocation_actions_createQRCode;

  /// No description provided for @shareLocation_actions_shareFile.
  ///
  /// In en, this message translates to:
  /// **'Share File'**
  String get shareLocation_actions_shareFile;

  /// No description provided for @shareLocation_actions_shareFile_text.
  ///
  /// In en, this message translates to:
  /// **'Here\'s my Locus View Key to see my location'**
  String get shareLocation_actions_shareFile_text;

  /// No description provided for @shareLocation_actions_shareLink.
  ///
  /// In en, this message translates to:
  /// **'Share Link'**
  String get shareLocation_actions_shareLink;

  /// No description provided for @shareLocation_actions_shareLink_text.
  ///
  /// In en, this message translates to:
  /// **'Here\'s my Locus link to see my location'**
  String get shareLocation_actions_shareLink_text;

  /// No description provided for @shareLocation_actions_shareBluetooth.
  ///
  /// In en, this message translates to:
  /// **'Share via Bluetooth'**
  String get shareLocation_actions_shareBluetooth;

  /// No description provided for @shareLocation_scanToImport.
  ///
  /// In en, this message translates to:
  /// **'Scan this QR Code to import task {task}'**
  String shareLocation_scanToImport(String task);

  /// No description provided for @settingsScreen_title.
  ///
  /// In en, this message translates to:
  /// **'Settings'**
  String get settingsScreen_title;

  /// No description provided for @settingsScreen_section_design.
  ///
  /// In en, this message translates to:
  /// **'Design'**
  String get settingsScreen_section_design;

  /// No description provided for @settingsScreen_section_privacy.
  ///
  /// In en, this message translates to:
  /// **'Privacy'**
  String get settingsScreen_section_privacy;

  /// No description provided for @settingsScreen_section_defaults.
  ///
  /// In en, this message translates to:
  /// **'Default Values'**
  String get settingsScreen_section_defaults;

  /// No description provided for @settingsScreen_sections_misc.
  ///
  /// In en, this message translates to:
  /// **'Miscellaneous'**
  String get settingsScreen_sections_misc;

  /// No description provided for @settingsScreen_setting_primaryColor_label.
  ///
  /// In en, this message translates to:
  /// **'Primary Color'**
  String get settingsScreen_setting_primaryColor_label;

  /// No description provided for @settingsScreen_setting_primaryColor_systemDefault.
  ///
  /// In en, this message translates to:
  /// **'System Default'**
  String get settingsScreen_setting_primaryColor_systemDefault;

  /// No description provided for @settingsScreen_settings_androidTheme_label.
  ///
  /// In en, this message translates to:
  /// **'Android Theme'**
  String get settingsScreen_settings_androidTheme_label;

  /// No description provided for @settingsScreen_settings_androidTheme_materialYou.
  ///
  /// In en, this message translates to:
  /// **'Material You'**
  String get settingsScreen_settings_androidTheme_materialYou;

  /// No description provided for @settingsScreen_settings_androidTheme_miui.
  ///
  /// In en, this message translates to:
  /// **'MIUI (Xiaomi\'s theme)'**
  String get settingsScreen_settings_androidTheme_miui;

  /// No description provided for @settingsScreen_setting_lookupAddresses_label.
  ///
  /// In en, this message translates to:
  /// **'Automatically lookup addresses'**
  String get settingsScreen_setting_lookupAddresses_label;

  /// No description provided for @settingsScreen_setting_lookupAddresses_description.
  ///
  /// In en, this message translates to:
  /// **'Looks up addresses for locations. This means that a raw location, such as (37.422131, -122.084801) can be mapped to an address. This will send the location to a third party service to get the address. This will only happen when you open the location details screen. If you disable this, you can manually load the address by tapping on the location.'**
  String get settingsScreen_setting_lookupAddresses_description;

  /// No description provided for @settingsScreen_settings_mapProvider_label.
  ///
  /// In en, this message translates to:
  /// **'Map Provider'**
  String get settingsScreen_settings_mapProvider_label;

  /// No description provided for @settingsScreen_settings_mapProvider_apple.
  ///
  /// In en, this message translates to:
  /// **'Apple Maps'**
  String get settingsScreen_settings_mapProvider_apple;

  /// No description provided for @settingsScreen_settings_mapProvider_openStreetMap.
  ///
  /// In en, this message translates to:
  /// **'OpenStreetMap'**
  String get settingsScreen_settings_mapProvider_openStreetMap;

  /// No description provided for @settingsScreen_settings_useRealtimeUpdates_label.
  ///
  /// In en, this message translates to:
  /// **'Update in real-time'**
  String get settingsScreen_settings_useRealtimeUpdates_label;

  /// No description provided for @settingsScreen_settings_useRealtimeUpdates_description.
  ///
  /// In en, this message translates to:
  /// **'If enabled, Locus will always update your location in real-time. This means that your location will be updated even if you don\'t have the app open. This will use more battery. However, as a location sharing app, this is strongly recommended. Setting this off, Locus will only occasionally update your location in the background. This setting is only recommended for people who regularly share their location, experience battery drain and only need to know occasional location updates.'**
  String get settingsScreen_settings_useRealtimeUpdates_description;

  /// No description provided for @settingsScreen_settings_useRealtimeUpdates_dialog_title.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to disable real-time updates?'**
  String get settingsScreen_settings_useRealtimeUpdates_dialog_title;

  /// No description provided for @settingsScreen_settings_useRealtimeUpdates_dialog_message.
  ///
  /// In en, this message translates to:
  /// **'It is strongly recommended to keep this setting enabled! Your location will only be occasionally updated if you disable real-time updates!'**
  String get settingsScreen_settings_useRealtimeUpdates_dialog_message;

  /// No description provided for @settingsScreen_settings_useRealtimeUpdates_dialog_confirm.
  ///
  /// In en, this message translates to:
  /// **'Disable'**
  String get settingsScreen_settings_useRealtimeUpdates_dialog_confirm;

  /// No description provided for @settingsScreen_settings_showHints_label.
  ///
  /// In en, this message translates to:
  /// **'Show Hints'**
  String get settingsScreen_settings_showHints_label;

  /// No description provided for @settingsScreen_settings_showHints_description.
  ///
  /// In en, this message translates to:
  /// **'Show occasional hints on how to get the most out of Locus'**
  String get settingsScreen_settings_showHints_description;

  /// No description provided for @settingsScreen_settings_relays_label.
  ///
  /// In en, this message translates to:
  /// **'Default Relays'**
  String get settingsScreen_settings_relays_label;

  /// No description provided for @settingsScreen_settings_relays_selectLabel.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0{Select Relays} =1{Selected One Relay} other{Selected {count} Relays}}'**
  String settingsScreen_settings_relays_selectLabel(int count);

  /// No description provided for @settingsScreen_settings_geocoderProvider_label.
  ///
  /// In en, this message translates to:
  /// **'Lookup Provider'**
  String get settingsScreen_settings_geocoderProvider_label;

  /// No description provided for @settingsScreen_settings_geocoderProvider_description.
  ///
  /// In en, this message translates to:
  /// **'Which provider to used to look up addresses for locations.'**
  String get settingsScreen_settings_geocoderProvider_description;

  /// No description provided for @settingsScreen_settings_geocoderProvider_system.
  ///
  /// In en, this message translates to:
  /// **'System'**
  String get settingsScreen_settings_geocoderProvider_system;

  /// No description provided for @settingsScreen_settings_geocoderProvider_geocodeMapsCo.
  ///
  /// In en, this message translates to:
  /// **'geocode.maps.co'**
  String get settingsScreen_settings_geocoderProvider_geocodeMapsCo;

  /// No description provided for @settingsScreen_settings_geocoderProvider_nominatim.
  ///
  /// In en, this message translates to:
  /// **'Nominatim (OpenStreetMap)'**
  String get settingsScreen_settings_geocoderProvider_nominatim;

  /// No description provided for @settingsScreen_settings_importExport_exportFile.
  ///
  /// In en, this message translates to:
  /// **'Export Locus data'**
  String get settingsScreen_settings_importExport_exportFile;

  /// No description provided for @settingsScreen_settings_importExport_exportFile_description.
  ///
  /// In en, this message translates to:
  /// **'Export all your Locus data to a file. This includes all your tasks and settings. You can use this file to import your data on another device.'**
  String get settingsScreen_settings_importExport_exportFile_description;

  /// No description provided for @settingsScreen_settings_importExport_exportFile_save.
  ///
  /// In en, this message translates to:
  /// **'Save Export'**
  String get settingsScreen_settings_importExport_exportFile_save;

  /// No description provided for @settingsScreen_settings_importExport_transfer.
  ///
  /// In en, this message translates to:
  /// **'Transfer Locus to a new phone'**
  String get settingsScreen_settings_importExport_transfer;

  /// No description provided for @settingsScreen_settings_importExport_transfer_connectionActionLabel.
  ///
  /// In en, this message translates to:
  /// **'Connect'**
  String get settingsScreen_settings_importExport_transfer_connectionActionLabel;

  /// No description provided for @settingsScreen_settings_importExport_importLabel.
  ///
  /// In en, this message translates to:
  /// **'Import Locus data'**
  String get settingsScreen_settings_importExport_importLabel;

  /// No description provided for @settingsScreen_import_file.
  ///
  /// In en, this message translates to:
  /// **'Import file'**
  String get settingsScreen_import_file;

  /// No description provided for @settingsScreen_import_pickerTitle.
  ///
  /// In en, this message translates to:
  /// **'Select the export.locus.json file to import your data'**
  String get settingsScreen_import_pickerTitle;

  /// No description provided for @settingsScreen_import_transfer.
  ///
  /// In en, this message translates to:
  /// **'Transfer from old device'**
  String get settingsScreen_import_transfer;

  /// No description provided for @settingsScreen_import_confirmation_title.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to import your data?'**
  String get settingsScreen_import_confirmation_title;

  /// No description provided for @settingsScreen_import_confirmation_description.
  ///
  /// In en, this message translates to:
  /// **'Do you want to import your data? THIS WILL OVERWRITE YOUR CURRENT DATA (SHARES, SETTINGS, ETC.) WITH THE DATA FROM THE IMPORT!'**
  String get settingsScreen_import_confirmation_description;

  /// No description provided for @settingsScreen_import_confirmation_confirm.
  ///
  /// In en, this message translates to:
  /// **'Import'**
  String get settingsScreen_import_confirmation_confirm;

  /// No description provided for @settingsScreen_import_restart_title.
  ///
  /// In en, this message translates to:
  /// **'Restart Locus'**
  String get settingsScreen_import_restart_title;

  /// No description provided for @settingsScreen_import_restart_description.
  ///
  /// In en, this message translates to:
  /// **'Locus needs to be restart to finish the import. Please restart the app now.'**
  String get settingsScreen_import_restart_description;

  /// No description provided for @settingsScreen_version.
  ///
  /// In en, this message translates to:
  /// **'Version {version} ({flavor, select, gms{GMS} floss{FLOSS} other{Unknown}})'**
  String settingsScreen_version(String version, String flavor);

  /// No description provided for @settingsScreen_exportLogs.
  ///
  /// In en, this message translates to:
  /// **'Export Logs'**
  String get settingsScreen_exportLogs;

  /// No description provided for @settingsScreen_exportLogs_shareText.
  ///
  /// In en, this message translates to:
  /// **'Here are my Locus logs'**
  String get settingsScreen_exportLogs_shareText;

  /// No description provided for @settingsScreen_exportLogs_error.
  ///
  /// In en, this message translates to:
  /// **'There was an error exporting the logs'**
  String get settingsScreen_exportLogs_error;

  /// No description provided for @settingsScreen_setting_requireBiometricAuth_label.
  ///
  /// In en, this message translates to:
  /// **'Require Biometric Authentication'**
  String get settingsScreen_setting_requireBiometricAuth_label;

  /// No description provided for @settingsScreen_setting_requireBiometricAuth_description.
  ///
  /// In en, this message translates to:
  /// **'If enabled, Locus will require you to authenticate with your biometric data (fingerprint, face, etc.) before opening the app.'**
  String get settingsScreen_setting_requireBiometricAuth_description;

  /// No description provided for @settingsScreen_setting_requireBiometricAuth_requireNowReason.
  ///
  /// In en, this message translates to:
  /// **'Confirm your identity to change this setting'**
  String get settingsScreen_setting_requireBiometricAuth_requireNowReason;

  /// No description provided for @settingsScreen_settings_alwaysUseBatterySaveMode_label.
  ///
  /// In en, this message translates to:
  /// **'Always use battery save mode'**
  String get settingsScreen_settings_alwaysUseBatterySaveMode_label;

  /// No description provided for @settingsScreen_settings_alwaysUseBatterySaveMode_description.
  ///
  /// In en, this message translates to:
  /// **'Locus will update your location less frequently in the background if your phone is in battery save mode. Enabling this option will force Locus to always use battery save mode. Note that your location will still be updated in real time if you have the app open.'**
  String get settingsScreen_settings_alwaysUseBatterySaveMode_description;

  /// No description provided for @settingsScreen_settings_serverOrigin_label.
  ///
  /// In en, this message translates to:
  /// **'Server Origin'**
  String get settingsScreen_settings_serverOrigin_label;

  /// No description provided for @settingsScreen_settings_serverOrigin_description.
  ///
  /// In en, this message translates to:
  /// **'The origin of the server to connect to. This is only used if you have a custom server. If you don\'t know what this is, you can ignore this setting.'**
  String get settingsScreen_settings_serverOrigin_description;

  /// No description provided for @settingsScreen_settings_serverOrigin_error_invalid.
  ///
  /// In en, this message translates to:
  /// **'This must be a valid origin. An origin consists of a protocol (http:// or https://) and a domain name (e.g. example.com). For example: https://example.com or https://locus.cfd'**
  String get settingsScreen_settings_serverOrigin_error_invalid;

  /// No description provided for @settingsScreen_settings_serverOrigin_hint.
  ///
  /// In en, this message translates to:
  /// **'locus.cfd'**
  String get settingsScreen_settings_serverOrigin_hint;

  /// No description provided for @settingsScreen_settings_serverOrigin_error_serverInvalid.
  ///
  /// In en, this message translates to:
  /// **'This is not a Locus server'**
  String get settingsScreen_settings_serverOrigin_error_serverInvalid;

  /// No description provided for @support_title.
  ///
  /// In en, this message translates to:
  /// **'Support Locus'**
  String get support_title;

  /// No description provided for @support_description.
  ///
  /// In en, this message translates to:
  /// **'Locus is a free open source project. This means that I don\'t make any money from it. If you like the app and want to support me, you can do so by multiple ways. Thank you very much! :)'**
  String get support_description;

  /// No description provided for @support_options_develop.
  ///
  /// In en, this message translates to:
  /// **'Help developing Locus'**
  String get support_options_develop;

  /// No description provided for @support_options_develop_description.
  ///
  /// In en, this message translates to:
  /// **'Add a new feature, fix a bug or improve the app in any other way'**
  String get support_options_develop_description;

  /// No description provided for @support_options_translate.
  ///
  /// In en, this message translates to:
  /// **'Translate Locus'**
  String get support_options_translate;

  /// No description provided for @support_options_translate_description.
  ///
  /// In en, this message translates to:
  /// **'Help translating Locus into your language'**
  String get support_options_translate_description;

  /// No description provided for @support_options_donate.
  ///
  /// In en, this message translates to:
  /// **'Donate 1€'**
  String get support_options_donate;

  /// No description provided for @support_options_donate_description.
  ///
  /// In en, this message translates to:
  /// **'Donate via Bitcoin, Monero or Github Sponsors'**
  String get support_options_donate_description;

  /// No description provided for @honorableMentions_title.
  ///
  /// In en, this message translates to:
  /// **'Honorable Mentions'**
  String get honorableMentions_title;

  /// No description provided for @honorableMentions_description.
  ///
  /// In en, this message translates to:
  /// **'These are honorable mentions of other great open source projects I personally use and would like to thank for their work :). They are listed in no particular order. These apps are not affiliated with Locus and aren\'t sponsored in any way and won\'t be. I just like them and want to thank them for their work.'**
  String get honorableMentions_description;

  /// No description provided for @honorableMentions_values_libreTube.
  ///
  /// In en, this message translates to:
  /// **'LibreTube'**
  String get honorableMentions_values_libreTube;

  /// No description provided for @honorableMentions_values_libreTube_description.
  ///
  /// In en, this message translates to:
  /// **'Awesome YouTube client for Android with the ability to proxy videos through external servers.'**
  String get honorableMentions_values_libreTube_description;

  /// No description provided for @honorableMentions_values_findMyDevice.
  ///
  /// In en, this message translates to:
  /// **'Find My Device'**
  String get honorableMentions_values_findMyDevice;

  /// No description provided for @honorableMentions_values_findMyDevice_description.
  ///
  /// In en, this message translates to:
  /// **'Open Source alternative to Google\'s Find My Device. Allows you to track your device and wipe it remotely.'**
  String get honorableMentions_values_findMyDevice_description;

  /// No description provided for @honorableMentions_values_simpleQR.
  ///
  /// In en, this message translates to:
  /// **'Simple QR'**
  String get honorableMentions_values_simpleQR;

  /// No description provided for @honorableMentions_values_simpleQR_description.
  ///
  /// In en, this message translates to:
  /// **'Simple QR Code scanner and generator without ads and tracking that just works.'**
  String get honorableMentions_values_simpleQR_description;

  /// No description provided for @honorableMentions_values_session.
  ///
  /// In en, this message translates to:
  /// **'Session'**
  String get honorableMentions_values_session;

  /// No description provided for @honorableMentions_values_session_description.
  ///
  /// In en, this message translates to:
  /// **'Decentralized messaging app with end-to-end encryption and no phone number or email required.'**
  String get honorableMentions_values_session_description;

  /// No description provided for @honorableMentions_values_odysee.
  ///
  /// In en, this message translates to:
  /// **'Odysee'**
  String get honorableMentions_values_odysee;

  /// No description provided for @honorableMentions_values_odysee_description.
  ///
  /// In en, this message translates to:
  /// **'Awesome YouTube alternative with better privacy and monetization options.'**
  String get honorableMentions_values_odysee_description;

  /// No description provided for @honorableMentions_values_kleckRelay.
  ///
  /// In en, this message translates to:
  /// **'KleckRelay'**
  String get honorableMentions_values_kleckRelay;

  /// No description provided for @honorableMentions_values_kleckRelay_description.
  ///
  /// In en, this message translates to:
  /// **'An open source email relay service with tracker remover, image preloaders and much more. Created by me :)'**
  String get honorableMentions_values_kleckRelay_description;

  /// No description provided for @quickActions_createOneHour.
  ///
  /// In en, this message translates to:
  /// **'Create One-Hour Share'**
  String get quickActions_createOneHour;

  /// No description provided for @quickActions_createOneHour_labelFromNow.
  ///
  /// In en, this message translates to:
  /// **'One-Hour task from {date}'**
  String quickActions_createOneHour_labelFromNow(DateTime date);

  /// No description provided for @quickActions_shareNow.
  ///
  /// In en, this message translates to:
  /// **'Update Location now'**
  String get quickActions_shareNow;

  /// No description provided for @quickActions_stopTasks.
  ///
  /// In en, this message translates to:
  /// **'Stop all Shares'**
  String get quickActions_stopTasks;

  /// No description provided for @quickActions_generationExplanation.
  ///
  /// In en, this message translates to:
  /// **'Hold on, we are working on it!'**
  String get quickActions_generationExplanation;

  /// No description provided for @appHint_quickActions_title.
  ///
  /// In en, this message translates to:
  /// **'Check out Quick Actions'**
  String get appHint_quickActions_title;

  /// No description provided for @appHint_quickActions_description.
  ///
  /// In en, this message translates to:
  /// **'You can quickly create a new Share or update your location by long pressing the Locus icon on your home screen.'**
  String get appHint_quickActions_description;

  /// No description provided for @appHint_defaultRelays_title.
  ///
  /// In en, this message translates to:
  /// **'Add default Relays'**
  String get appHint_defaultRelays_title;

  /// No description provided for @appHint_defaultRelays_description.
  ///
  /// In en, this message translates to:
  /// **'You can add default relays in the settings. This will automatically select them when creating a new task.'**
  String get appHint_defaultRelays_description;

  /// No description provided for @appHint_appColor_title.
  ///
  /// In en, this message translates to:
  /// **'Change App Colors'**
  String get appHint_appColor_title;

  /// No description provided for @appHint_appColor_description.
  ///
  /// In en, this message translates to:
  /// **'You can personalize Locus by changing the primary color in the settings.'**
  String get appHint_appColor_description;

  /// No description provided for @appHint_showMeLabel.
  ///
  /// In en, this message translates to:
  /// **'Show me'**
  String get appHint_showMeLabel;

  /// No description provided for @weekdays_monday.
  ///
  /// In en, this message translates to:
  /// **'Monday'**
  String get weekdays_monday;

  /// No description provided for @weekdays_tuesday.
  ///
  /// In en, this message translates to:
  /// **'Tuesday'**
  String get weekdays_tuesday;

  /// No description provided for @weekdays_wednesday.
  ///
  /// In en, this message translates to:
  /// **'Wednesday'**
  String get weekdays_wednesday;

  /// No description provided for @weekdays_thursday.
  ///
  /// In en, this message translates to:
  /// **'Thursday'**
  String get weekdays_thursday;

  /// No description provided for @weekdays_friday.
  ///
  /// In en, this message translates to:
  /// **'Friday'**
  String get weekdays_friday;

  /// No description provided for @weekdays_saturday.
  ///
  /// In en, this message translates to:
  /// **'Saturday'**
  String get weekdays_saturday;

  /// No description provided for @weekdays_sunday.
  ///
  /// In en, this message translates to:
  /// **'Sunday'**
  String get weekdays_sunday;

  /// No description provided for @weekdaySelection_selectTitle.
  ///
  /// In en, this message translates to:
  /// **'Select Date and Time'**
  String get weekdaySelection_selectTitle;

  /// No description provided for @weekdaySelection_error_startTimeBeforeEndTime.
  ///
  /// In en, this message translates to:
  /// **'Start time must be before end time'**
  String get weekdaySelection_error_startTimeBeforeEndTime;

  /// No description provided for @backgroundLocationFetch_title.
  ///
  /// In en, this message translates to:
  /// **'Updating location in real-time'**
  String get backgroundLocationFetch_title;

  /// Keep this very short
  ///
  /// In en, this message translates to:
  /// **'Close Locus to stop sharing in real time. Locus will still update your location, but less frequently.'**
  String get backgroundLocationFetch_text;

  /// No description provided for @backgroundLocator_title.
  ///
  /// In en, this message translates to:
  /// **'Updating location in real-time'**
  String get backgroundLocator_title;

  /// No description provided for @backgroundLocator_text.
  ///
  /// In en, this message translates to:
  /// **'Locus is updating your location in real-time.'**
  String get backgroundLocator_text;

  /// No description provided for @backgroundLocator_channelName.
  ///
  /// In en, this message translates to:
  /// **'Location Updater'**
  String get backgroundLocator_channelName;

  /// No description provided for @logs_createdAt.
  ///
  /// In en, this message translates to:
  /// **'{date}'**
  String logs_createdAt(DateTime date);

  /// No description provided for @logs_values_taskCreated.
  ///
  /// In en, this message translates to:
  /// **'Share created'**
  String get logs_values_taskCreated;

  /// No description provided for @logs_values_taskDeleted.
  ///
  /// In en, this message translates to:
  /// **'Share deleted'**
  String get logs_values_taskDeleted;

  /// No description provided for @logs_values_taskStatusChanged.
  ///
  /// In en, this message translates to:
  /// **'Share status changed'**
  String get logs_values_taskStatusChanged;

  /// No description provided for @logs_values_updatedLocation.
  ///
  /// In en, this message translates to:
  /// **'Location updated'**
  String get logs_values_updatedLocation;

  /// No description provided for @logs_values_alarmCreated.
  ///
  /// In en, this message translates to:
  /// **'Alarm added'**
  String get logs_values_alarmCreated;

  /// No description provided for @logs_values_alarmDeleted.
  ///
  /// In en, this message translates to:
  /// **'Alarm removed'**
  String get logs_values_alarmDeleted;

  /// No description provided for @log_title_taskCreated.
  ///
  /// In en, this message translates to:
  /// **'<{name}> created'**
  String log_title_taskCreated(String name);

  /// No description provided for @log_title_taskDeleted.
  ///
  /// In en, this message translates to:
  /// **'<{name}> deleted'**
  String log_title_taskDeleted(String name);

  /// No description provided for @log_title_taskStatusChanged.
  ///
  /// In en, this message translates to:
  /// **'{active, select, true{{name} started} false{{name} stopped} other{Unknown error occurred}}'**
  String log_title_taskStatusChanged(String active, String name);

  /// No description provided for @log_title_updatedLocation.
  ///
  /// In en, this message translates to:
  /// **'Location updated for {count, plural, =1{one task} other{{count} tasks}}'**
  String log_title_updatedLocation(int count);

  /// No description provided for @log_title_alarmCreated.
  ///
  /// In en, this message translates to:
  /// **'Alarm added for {viewName}'**
  String log_title_alarmCreated(String viewName);

  /// No description provided for @log_title_alarmDeleted.
  ///
  /// In en, this message translates to:
  /// **'Alarm removed from {viewName}'**
  String log_title_alarmDeleted(String viewName);

  /// No description provided for @logs_system_initiator_description.
  ///
  /// In en, this message translates to:
  /// **'This log was created by the system'**
  String get logs_system_initiator_description;

  /// No description provided for @logs_task_creationContext_description.
  ///
  /// In en, this message translates to:
  /// **'{context, select, inApp{Share created inside the App} quickAction{Share created via Quick Action} other{Unknown error occurred}}'**
  String logs_task_creationContext_description(String context);

  /// No description provided for @logs_title.
  ///
  /// In en, this message translates to:
  /// **'Locus automatically creates logs'**
  String get logs_title;

  /// No description provided for @logs_description.
  ///
  /// In en, this message translates to:
  /// **'Logs are kept for 7 days and are automatically deleted afterwards.'**
  String get logs_description;

  /// No description provided for @locationPointsScreen_title.
  ///
  /// In en, this message translates to:
  /// **'Location Points'**
  String get locationPointsScreen_title;

  /// Notification title when entering a zone; Try to keep this short, will be truncated to 80 characters
  ///
  /// In en, this message translates to:
  /// **'{name} entered zone {zone}'**
  String locationAlarm_radiusBasedRegion_notificationTitle_whenEnter(String name, String zone);

  /// Notification title when leaving a zone; Try to keep this short, will be truncated to 80 characters
  ///
  /// In en, this message translates to:
  /// **'{name} left zone {zone}'**
  String locationAlarm_radiusBasedRegion_notificationTitle_whenLeave(String name, String zone);

  /// Notification title when it is not clear if the user entered or left a zone; Try to keep this short, will be truncated to 80 characters
  ///
  /// In en, this message translates to:
  /// **'{name} may has entered or left zone {zone}'**
  String locationAlarm_radiusBasedRegion_notificationTitle_maybe(String name, String zone);

  /// Notification title when entering a proximity location; Try to keep this short, will be truncated to 80 characters
  ///
  /// In en, this message translates to:
  /// **'{name} is within {proximity}m'**
  String locationAlarm_proximityLocation_notificationTitle_whenEnter(String name, int proximity);

  /// Notification title when leaving a proximity location; Try to keep this short, will be truncated to 80 characters
  ///
  /// In en, this message translates to:
  /// **'{name} is outside of {proximity}m'**
  String locationAlarm_proximityLocation_notificationTitle_whenLeave(String name, int proximity);

  /// No description provided for @locationAlarm_notification_description.
  ///
  /// In en, this message translates to:
  /// **'Tap for more information'**
  String get locationAlarm_notification_description;

  /// No description provided for @androidNotificationChannel_locationAlarms_name.
  ///
  /// In en, this message translates to:
  /// **'Location Alarms'**
  String get androidNotificationChannel_locationAlarms_name;

  /// No description provided for @androidNotificationChannel_locationAlarms_description.
  ///
  /// In en, this message translates to:
  /// **'Receive notifications for location alarms'**
  String get androidNotificationChannel_locationAlarms_description;

  /// No description provided for @androidNotificationChannel_appIssues_name.
  ///
  /// In en, this message translates to:
  /// **'Important Issues'**
  String get androidNotificationChannel_appIssues_name;

  /// No description provided for @androidNotificationChannel_appIssues_description.
  ///
  /// In en, this message translates to:
  /// **'Receive notifications for important issues about Locus (when a task is not updating, location can\'t be updated, etc.)'**
  String get androidNotificationChannel_appIssues_description;

  /// No description provided for @location_manageAlarms_title.
  ///
  /// In en, this message translates to:
  /// **'Manage Alarms'**
  String get location_manageAlarms_title;

  /// No description provided for @location_manageAlarms_empty_title.
  ///
  /// In en, this message translates to:
  /// **'No Alarms'**
  String get location_manageAlarms_empty_title;

  /// No description provided for @location_manageAlarms_empty_description.
  ///
  /// In en, this message translates to:
  /// **'Add alarms to be notified when certain conditions are met'**
  String get location_manageAlarms_empty_description;

  /// No description provided for @location_manageAlarms_addNewAlarm_actionLabel.
  ///
  /// In en, this message translates to:
  /// **'Add Alarm'**
  String get location_manageAlarms_addNewAlarm_actionLabel;

  /// No description provided for @location_manageAlarms_lastCheck_description.
  ///
  /// In en, this message translates to:
  /// **'Last checked at {date}'**
  String location_manageAlarms_lastCheck_description(DateTime date);

  /// No description provided for @location_addAlarm_geo_title.
  ///
  /// In en, this message translates to:
  /// **'Add geo-based alarm'**
  String get location_addAlarm_geo_title;

  /// No description provided for @location_addAlarm_geo_description.
  ///
  /// In en, this message translates to:
  /// **'Define a region and get notified when your friend enters or leaves this region'**
  String get location_addAlarm_geo_description;

  /// No description provided for @location_addAlarm_geo_name_description.
  ///
  /// In en, this message translates to:
  /// **'Please enter a name for this region'**
  String get location_addAlarm_geo_name_description;

  /// No description provided for @location_addAlarm_geo_help_tapDescription.
  ///
  /// In en, this message translates to:
  /// **'Tap on the map to mark the center of your region'**
  String get location_addAlarm_geo_help_tapDescription;

  /// No description provided for @location_addAlarm_proximity_title.
  ///
  /// In en, this message translates to:
  /// **'Add proximity alarm'**
  String get location_addAlarm_proximity_title;

  /// No description provided for @location_addAlarm_proximity_description.
  ///
  /// In en, this message translates to:
  /// **'Get notified when your friend is within a certain distance of you'**
  String get location_addAlarm_proximity_description;

  /// No description provided for @location_addAlarm_radiusBased_radius_meters.
  ///
  /// In en, this message translates to:
  /// **'Radius: {value} meters'**
  String location_addAlarm_radiusBased_radius_meters(int value);

  /// No description provided for @location_removeAlarm_title.
  ///
  /// In en, this message translates to:
  /// **'Remove Alarm'**
  String get location_removeAlarm_title;

  /// No description provided for @location_removeAlarm_description.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to remove this alarm?'**
  String get location_removeAlarm_description;

  /// No description provided for @location_removeAlarm_confirm.
  ///
  /// In en, this message translates to:
  /// **'Remove'**
  String get location_removeAlarm_confirm;

  /// No description provided for @location_addAlarm_radiusBased_radius_kilometers.
  ///
  /// In en, this message translates to:
  /// **'Radius: {value} km'**
  String location_addAlarm_radiusBased_radius_kilometers(double value);

  /// No description provided for @location_addAlarm_radiusBased_isInScaleMode.
  ///
  /// In en, this message translates to:
  /// **'You can now scale the radius by pinching and zooming into the map. Tap on the screen to go back to normal mode.'**
  String get location_addAlarm_radiusBased_isInScaleMode;

  /// No description provided for @location_addAlarm_radiusBased_addLabel.
  ///
  /// In en, this message translates to:
  /// **'Select region'**
  String get location_addAlarm_radiusBased_addLabel;

  /// No description provided for @location_addAlarm_radiusBased_help_title.
  ///
  /// In en, this message translates to:
  /// **'Radius-based Alarms'**
  String get location_addAlarm_radiusBased_help_title;

  /// No description provided for @location_addAlarm_radiusBased_help_description.
  ///
  /// In en, this message translates to:
  /// **'Radius-based alarms are triggered either when leaving or entering a region. After defining your region, you can decide when your alarm should trigger.'**
  String get location_addAlarm_radiusBased_help_description;

  /// No description provided for @location_addAlarm_radiusBased_help_pinchDescription.
  ///
  /// In en, this message translates to:
  /// **'Press and hold to enter into scale mode. You can then change the radius by pinching and zooming into the map.'**
  String get location_addAlarm_radiusBased_help_pinchDescription;

  /// No description provided for @location_addAlarm_radiusBased_trigger_title.
  ///
  /// In en, this message translates to:
  /// **'When should your alarm trigger?'**
  String get location_addAlarm_radiusBased_trigger_title;

  /// No description provided for @location_addAlarm_radiusBased_trigger_whenEnter.
  ///
  /// In en, this message translates to:
  /// **'Trigger when entering'**
  String get location_addAlarm_radiusBased_trigger_whenEnter;

  /// No description provided for @location_addAlarm_radiusBased_trigger_whenLeave.
  ///
  /// In en, this message translates to:
  /// **'Trigger when leaving'**
  String get location_addAlarm_radiusBased_trigger_whenLeave;

  /// No description provided for @location_addAlarm_actionLabel.
  ///
  /// In en, this message translates to:
  /// **'Add Alarm'**
  String get location_addAlarm_actionLabel;

  /// No description provided for @location_addAlarm_selectType_title.
  ///
  /// In en, this message translates to:
  /// **'Select Alarm Type'**
  String get location_addAlarm_selectType_title;

  /// No description provided for @location_addAlarm_selectType_description.
  ///
  /// In en, this message translates to:
  /// **'What kind of alarm do you want to add?'**
  String get location_addAlarm_selectType_description;

  /// No description provided for @permissions_openSettings_label.
  ///
  /// In en, this message translates to:
  /// **'Open settings'**
  String get permissions_openSettings_label;

  /// No description provided for @permissions_openSettings_failed_title.
  ///
  /// In en, this message translates to:
  /// **'Settings could not be opened'**
  String get permissions_openSettings_failed_title;

  /// No description provided for @permissions_location_askPermission_title.
  ///
  /// In en, this message translates to:
  /// **'Grant access to your location'**
  String get permissions_location_askPermission_title;

  /// No description provided for @permissions_location_askPermission_message_always.
  ///
  /// In en, this message translates to:
  /// **'Locus needs to access your location in the background. We will first ask for your permission while you use the app. Please make sure to tap on \"Allow while using the App\". Do not tap on \"Allow once\". After that, we will ask you to grant us permission to access your location in the background. Please make sure to tap on \"Always Allow\".'**
  String get permissions_location_askPermission_message_always;

  /// No description provided for @permissions_location_askPermission_message_whileInUse.
  ///
  /// In en, this message translates to:
  /// **'Locus needs to access your location. Please grant the permission in the next step.'**
  String get permissions_location_askPermission_message_whileInUse;

  /// No description provided for @permissions_location_askPermission_action_grant_label.
  ///
  /// In en, this message translates to:
  /// **'Grant permission'**
  String get permissions_location_askPermission_action_grant_label;

  /// No description provided for @permissions_location_permissionDenied_message.
  ///
  /// In en, this message translates to:
  /// **'You have denied Locus access to your location. You can grant the permission in the settings.'**
  String get permissions_location_permissionDenied_message;

  /// No description provided for @permissions_location_permissionDenied_settingsNotOpened_message.
  ///
  /// In en, this message translates to:
  /// **'We could not open the settings. Please open the settings manually and grant Locus access to your location.'**
  String get permissions_location_permissionDenied_settingsNotOpened_message;

  /// No description provided for @permissions_batteryOptimizations_askPermission_title.
  ///
  /// In en, this message translates to:
  /// **'Disable battery optimizations'**
  String get permissions_batteryOptimizations_askPermission_title;

  /// No description provided for @permissions_batteryOptimizations_askPermission_message.
  ///
  /// In en, this message translates to:
  /// **'Locus needs to run in the background to be able to store your location and notify you when you an alarm is set. Please disable battery optimizations for Locus in the next step. You might need to press on \"Create\" again after disabling the optimizations.'**
  String get permissions_batteryOptimizations_askPermission_message;

  /// No description provided for @permissions_batteryOptimizations_disableManufacturerOptimization_title.
  ///
  /// In en, this message translates to:
  /// **'Your device has additional battery optimizations'**
  String get permissions_batteryOptimizations_disableManufacturerOptimization_title;

  /// No description provided for @permissions_batteryOptimizations_disableManufacturerOptimization_message.
  ///
  /// In en, this message translates to:
  /// **'Your device has additional battery optimizations. Please disable them too based on the instructions below.'**
  String get permissions_batteryOptimizations_disableManufacturerOptimization_message;

  /// No description provided for @permissions_batteryOptimizations_askPermission_action_label.
  ///
  /// In en, this message translates to:
  /// **'Disable battery optimizations'**
  String get permissions_batteryOptimizations_askPermission_action_label;

  /// No description provided for @permissions_autoStart_title.
  ///
  /// In en, this message translates to:
  /// **'Enable auto start'**
  String get permissions_autoStart_title;

  /// No description provided for @permissions_autoStart_message.
  ///
  /// In en, this message translates to:
  /// **'Locus needs to start automatically to ensure your locations are sent. Please enable auto start in the next step.'**
  String get permissions_autoStart_message;

  /// No description provided for @permissions_notification_askPermission_title.
  ///
  /// In en, this message translates to:
  /// **'Grant access to notifications'**
  String get permissions_notification_askPermission_title;

  /// No description provided for @permissions_notification_askPermission_message.
  ///
  /// In en, this message translates to:
  /// **'Locus needs to send notifications to notify you when an alarm is triggered. Please grant the permission to send you notifications in the next step.'**
  String get permissions_notification_askPermission_message;

  /// No description provided for @permissions_notification_permissionDenied_message.
  ///
  /// In en, this message translates to:
  /// **'You have denied Locus access to notifications. Please grant the permission in the settings.'**
  String get permissions_notification_permissionDenied_message;

  /// No description provided for @permissions_notification_permissionDenied_settingsNotOpened_message.
  ///
  /// In en, this message translates to:
  /// **'We could not open the settings. Please open the settings manually and allow Locus to send notifications.'**
  String get permissions_notification_permissionDenied_settingsNotOpened_message;

  /// No description provided for @taskDetails_share_help_title.
  ///
  /// In en, this message translates to:
  /// **'Share your location with your friends'**
  String get taskDetails_share_help_title;

  /// No description provided for @taskDetails_share_help_shareDescription.
  ///
  /// In en, this message translates to:
  /// **'You can share this location with your friends. They will be able to see your location until you delete this task.'**
  String get taskDetails_share_help_shareDescription;

  /// No description provided for @taskDetails_share_help_appDescription.
  ///
  /// In en, this message translates to:
  /// **'Ask your friends to install Locus. Go to the task details and generate a link you can send, or share the view key file. When your friends open Locus and scroll down on the overview screen, they can import your location.'**
  String get taskDetails_share_help_appDescription;

  /// No description provided for @taskDetails_share_help_webDescription.
  ///
  /// In en, this message translates to:
  /// **'Alternatively, other people can open the link in their browser. They will be able to see your location on a map. We discourage this method though, as it is less secure.'**
  String get taskDetails_share_help_webDescription;

  /// No description provided for @biometricsAuthentication_title.
  ///
  /// In en, this message translates to:
  /// **'Biometrics Authentication'**
  String get biometricsAuthentication_title;

  /// No description provided for @biometricsAuthentication_description.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to open Locus'**
  String get biometricsAuthentication_description;

  /// No description provided for @biometricsAuthentication_action.
  ///
  /// In en, this message translates to:
  /// **'Authenticate'**
  String get biometricsAuthentication_action;

  /// No description provided for @checkLocation_title.
  ///
  /// In en, this message translates to:
  /// **'Verify location access'**
  String get checkLocation_title;

  /// No description provided for @checkLocation_shortDescription.
  ///
  /// In en, this message translates to:
  /// **'Verify Locus can access your location'**
  String get checkLocation_shortDescription;

  /// No description provided for @checkLocation_description.
  ///
  /// In en, this message translates to:
  /// **'Tap to check if Locus can access your location. Note that this might take up to {minutes} minutes. Make sure you have GPS enabled. Do not close the app or turn off your screen while the check is running.'**
  String checkLocation_description(int minutes);

  /// No description provided for @checkLocation_start_label.
  ///
  /// In en, this message translates to:
  /// **'Start check'**
  String get checkLocation_start_label;

  /// No description provided for @checkLocation_values_usingBestLocation.
  ///
  /// In en, this message translates to:
  /// **'Checking using best accuracy'**
  String get checkLocation_values_usingBestLocation;

  /// No description provided for @checkLocation_values_usingWorstLocation.
  ///
  /// In en, this message translates to:
  /// **'Checking using worst accuracy'**
  String get checkLocation_values_usingWorstLocation;

  /// No description provided for @checkLocation_values_usingAndroidLocationManagerBest.
  ///
  /// In en, this message translates to:
  /// **'Checking using Android\'s Location Manager with best accuracy'**
  String get checkLocation_values_usingAndroidLocationManagerBest;

  /// No description provided for @checkLocation_values_usingAndroidLocationManagerWorst.
  ///
  /// In en, this message translates to:
  /// **'Checking using Android\'s Location Manager with worst accuracy'**
  String get checkLocation_values_usingAndroidLocationManagerWorst;

  /// No description provided for @checkLocation_successMessage.
  ///
  /// In en, this message translates to:
  /// **'Congratulations! Locus can access your location!'**
  String get checkLocation_successMessage;

  /// Keep this short
  ///
  /// In en, this message translates to:
  /// **'Please enable GPS to continue'**
  String get checkLocation_gpsDisabledMessage;

  /// Keep this short
  ///
  /// In en, this message translates to:
  /// **'Please grant permission to your location'**
  String get checkLocation_permissionDeniedMessage;

  /// No description provided for @checkLocation_errorMessage.
  ///
  /// In en, this message translates to:
  /// **'We are sorry, but Locus could not access your location. You can try it again later or find more information in the help section.'**
  String get checkLocation_errorMessage;

  /// No description provided for @checkLocation_openHelp.
  ///
  /// In en, this message translates to:
  /// **'Open help'**
  String get checkLocation_openHelp;

  /// No description provided for @help_location_title.
  ///
  /// In en, this message translates to:
  /// **'Location Help'**
  String get help_location_title;

  /// No description provided for @help_location_preamble.
  ///
  /// In en, this message translates to:
  /// **'We are very sorry if Locus can not access your location. There are many reasons why this might happen. Please try the following steps to fix the issue:'**
  String get help_location_preamble;

  /// No description provided for @help_location_goOutside.
  ///
  /// In en, this message translates to:
  /// **'Go outside. It is possible that your device can not get proper signal inside.'**
  String get help_location_goOutside;

  /// No description provided for @help_location_enableGoogleLocationServices.
  ///
  /// In en, this message translates to:
  /// **'Enable Google Location Services. Google Location Services massively improve the accuracy of your location. You can enable it in your device settings. Note that this will very likely tell Google your location.'**
  String get help_location_enableGoogleLocationServices;

  /// No description provided for @help_location_enableScanning.
  ///
  /// In en, this message translates to:
  /// **'Enable Wi-Fi and Bluetooth scanning. You can enable them in your device settings. Note that this could drain your battery faster.'**
  String get help_location_enableScanning;

  /// No description provided for @help_location_useGMSVersion.
  ///
  /// In en, this message translates to:
  /// **'Use the GMS version of Locus. The GMS version uses Google Location Services to get your location. You can download it from GitHub. You will be notified about updates inside the app.'**
  String get help_location_useGMSVersion;

  /// No description provided for @locations_values_battery_description.
  ///
  /// In en, this message translates to:
  /// **'Battery'**
  String get locations_values_battery_description;

  /// No description provided for @locations_values_battery_value.
  ///
  /// In en, this message translates to:
  /// **'{value}%'**
  String locations_values_battery_value(int value);

  /// No description provided for @locations_values_lastLocation_description.
  ///
  /// In en, this message translates to:
  /// **'Last location update'**
  String get locations_values_lastLocation_description;

  /// No description provided for @locations_values_distance_description.
  ///
  /// In en, this message translates to:
  /// **'Distance'**
  String get locations_values_distance_description;

  /// No description provided for @locations_values_distance_permissionRequired.
  ///
  /// In en, this message translates to:
  /// **'Grant permission'**
  String get locations_values_distance_permissionRequired;

  /// No description provided for @locations_values_distance_nearby.
  ///
  /// In en, this message translates to:
  /// **'<10 m'**
  String get locations_values_distance_nearby;

  /// No description provided for @locations_values_distance_m.
  ///
  /// In en, this message translates to:
  /// **'{distance} m'**
  String locations_values_distance_m(String distance);

  /// No description provided for @locations_values_distance_km.
  ///
  /// In en, this message translates to:
  /// **'{distance, select, 0 {<1 km} 1 {one km} other {{distance} km}}'**
  String locations_values_distance_km(String distance);

  /// No description provided for @locations_values_speed_description.
  ///
  /// In en, this message translates to:
  /// **'Speed'**
  String get locations_values_speed_description;

  /// No description provided for @locations_values_speed_kmh.
  ///
  /// In en, this message translates to:
  /// **'{speed} km/h'**
  String locations_values_speed_kmh(int speed);

  /// No description provided for @locations_values_altitude_description.
  ///
  /// In en, this message translates to:
  /// **'Altitude'**
  String get locations_values_altitude_description;

  /// No description provided for @locations_values_altitude_m.
  ///
  /// In en, this message translates to:
  /// **'{altitude} m'**
  String locations_values_altitude_m(int altitude);

  /// No description provided for @locations_values_batteryState_description.
  ///
  /// In en, this message translates to:
  /// **'Battery state'**
  String get locations_values_batteryState_description;

  /// No description provided for @locations_values_batteryState_value.
  ///
  /// In en, this message translates to:
  /// **'{state, select, full {full} charging {charging} discharging {discharging} other {unknown}}'**
  String locations_values_batteryState_value(String state);

  /// No description provided for @permissionsMissing_title.
  ///
  /// In en, this message translates to:
  /// **'Permissions missing'**
  String get permissionsMissing_title;

  /// No description provided for @permissionsMissing_message.
  ///
  /// In en, this message translates to:
  /// **'Please allow access to your location in the background'**
  String get permissionsMissing_message;
}

class _AppLocalizationsDelegate extends LocalizationsDelegate<AppLocalizations> {
  const _AppLocalizationsDelegate();

  @override
  Future<AppLocalizations> load(Locale locale) {
    return SynchronousFuture<AppLocalizations>(lookupAppLocalizations(locale));
  }

  @override
  bool isSupported(Locale locale) => <String>['en', 'tr'].contains(locale.languageCode);

  @override
  bool shouldReload(_AppLocalizationsDelegate old) => false;
}

AppLocalizations lookupAppLocalizations(Locale locale) {


  // Lookup logic when only language code is specified.
  switch (locale.languageCode) {
    case 'en': return AppLocalizationsEn();
    case 'tr': return AppLocalizationsTr();
  }

  throw FlutterError(
    'AppLocalizations.delegate failed to load unsupported locale "$locale". This is likely '
    'an issue with the localizations generation tool. Please file an issue '
    'on GitHub with a reproducible sample app and the gen-l10n configuration '
    'that was used.'
  );
}
