# clipboard_watcher

[![pub version][pub-image]][pub-url] [![][discord-image]][discord-url] ![][visits-count-image]

[pub-image]: https://img.shields.io/pub/v/clipboard_watcher.svg
[pub-url]: https://pub.dev/packages/clipboard_watcher
[discord-image]: https://img.shields.io/discord/884679008049037342.svg
[discord-url]: https://discord.gg/zPa6EZ2jqb
[visits-count-image]: https://img.shields.io/badge/dynamic/json?label=Visits%20Count&query=value&url=https://api.countapi.xyz/hit/leanflutter.clipboard_watcher/visits

这个插件允许 Flutter 应用程序观察剪贴板的变化。

---

[English](./README.md) | 简体中文

---

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->

- [clipboard_watcher](#clipboard_watcher)
  - [平台支持](#平台支持)
  - [快速开始](#快速开始)
    - [安装](#安装)
    - [用法](#用法)
  - [谁在用使用它？](#谁在用使用它)
  - [许可证](#许可证)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## 平台支持

| 平台    | 支持                                                                   |
| ------- | :--------------------------------------------------------------------- |
| Linux   | ✔️ 完全支持                                                            |
| macOS   | ✔️ 完全支持                                                            |
| Windows | ✔️ 完全支持                                                            |
| iOS     | 14+ 需要用户权限才能读取从其他应用复制的数据<br>旧版本完全支持开箱即用 |
| Android | 10+ 仅当应用程序位于前台时有效<br>旧版本完全支持开箱即用               |

## 快速开始

### 安装

将此添加到你的软件包的 pubspec.yaml 文件：

```yaml
dependencies:
  clipboard_watcher: ^0.2.0
```

或

```yaml
dependencies:
  clipboard_watcher:
    git:
      url: https://github.com/leanflutter/clipboard_watcher.git
      ref: main
```

### 用法

```dart
class HomePage extends StatefulWidget {
  const HomePage({Key? key}) : super(key: key);

  @override
  _HomePageState createState() => _HomePageState();
}

class _HomePageState extends State<HomePage> with ClipboardListener {
  @override
  void initState() {
    clipboardWatcher.addListener(this);
    // start watch
    clipboardWatcher.start();
    super.initState();
  }

  @override
  void dispose() {
    clipboardWatcher.removeListener(this);
    // stop watch
    clipboardWatcher.stop();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    // ...
  }

  @override
  void onClipboardChanged() async {
    ClipboardData? newClipboardData = await Clipboard.getData(Clipboard.kTextPlain);
    print(newClipboardData?.text ?? "");
  }
}
```

> 请看这个插件的示例应用，以了解完整的例子。

## 谁在用使用它？

- [比译](https://biyidev.com/) - 一个便捷的翻译和词典应用程序。

## 许可证

[MIT](./LICENSE)
