// ignore_for_file: deprecated_member_use_from_same_package

import 'dart:convert';
import 'dart:io';

import 'package:basic_utils/src/X509Utils.dart';
import 'package:basic_utils/src/model/crl/CrlReason.dart';
import 'package:basic_utils/src/model/ocsp/OCSPCertStatusValues.dart';
import 'package:basic_utils/src/model/ocsp/OCSPResponseStatus.dart';
import 'package:basic_utils/src/model/x509/ExtendedKeyUsage.dart';
import 'package:basic_utils/src/model/x509/KeyUsage.dart';
import 'package:pointycastle/pointycastle.dart';
import 'package:test/test.dart';

// ignore: avoid_relative_lib_imports
import '../lib/src/CryptoUtils.dart';

void main() {
  var brokenPEM = '''-----BEGIN CERTIFICATE REQUEST-----
 MIIFBDCCAuwCAQAwgb4xCzAJBgNVBAYTAkRFMRkwFwYDVQQDDBBzZnRwMi5rbGl
u Z2VsLmRlMRIwEAYDVQQHDAlQZm9yemhlaW0xHDAaBgNVBAsME1ZlcnNhbmRoYX
Vz IEtsaW5nZWwxJzAlBgNVBAoMHksg4oCTIE1haWwgT3JkZXIgR21iSCAmIENvL
iBL RzEQMA4GA1UECAwHR2VybWFueTEnMCUGCSqGSIb3DQEJARYYbmlscy5zY2hl
bGVu ekBrbGluZ2VsLmRlMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgE
-----END CERTIFICATE REQUEST-----''';

  var brokenPEM2 = '''-----BEGIN CERTIFICATE REQUEST-----
                                                                
                                                                
                                                                
                                            MIIE2DCCAsACAQAwgZIx
CzAJBgNVBAYTAkRFMRswG%%%!QYDVQQIDBJCYWRlbi1XdWVy
QliZqZ+PCWraydu5WpFhdCDdL+6qzc=                                 
                                                                
                                                                
                                                  
-----END CERTIFICATE REQUEST-----''';

  var brokenPEM3 =
      '''MIIFBDCCAuwCAQAwgb4xCzAJBgNVBAYTAkRFMRkwFwYDVQQDDBBzZnRwMi5rbGl
u Z2VsLmRlMRIwEAYDVQQ HDAlQZm9yemhlaW0xHDAaBgNVBAsME1ZlcnNhbmRoYX
Vz IEtsaW5  nZWwxJzAlBgNVB  AoMHksg4oCTIE1haWw%%gT3JkZXIgR21iSCAmIENvL
iBL RzEQMA4GA1  UECAwHR2VybWFu  eTEnMCUGCSqGSIb3DQEJARYYbmlscy5zY2hl
bGVu ekBrbGluZ2VsLmRlMIICIjAN BgkqhkiG9w0BAQEFAAOC  Ag8AMIICCgKCAgE
''';

  var fixedPem3 =
      '''MIIFBDCCAuwCAQAwgb4xCzAJBgNVBAYTAkRFMRkwFwYDVQQDDBBzZnRwMi5rbGlu
Z2VsLmRlMRIwEAYDVQQHDAlQZm9yemhlaW0xHDAaBgNVBAsME1ZlcnNhbmRoYXVz
IEtsaW5nZWwxJzAlBgNVBAoMHksg4oCTIE1haWwgT3JkZXIgR21iSCAmIENvLiBL
RzEQMA4GA1UECAwHR2VybWFueTEnMCUGCSqGSIb3DQEJARYYbmlscy5zY2hlbGVu
ekBrbGluZ2VsLmRlMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgE''';

  var fixedPem2 = '''-----BEGIN CERTIFICATE REQUEST-----
MIIE2DCCAsACAQAwgZIxCzAJBgNVBAYTAkRFMRswGQYDVQQIDBJCYWRlbi1XdWVy
QliZqZ+PCWraydu5WpFhdCDdL+6qzc=
-----END CERTIFICATE REQUEST-----''';

  var fixedPem = '''-----BEGIN CERTIFICATE REQUEST-----
MIIFBDCCAuwCAQAwgb4xCzAJBgNVBAYTAkRFMRkwFwYDVQQDDBBzZnRwMi5rbGlu
Z2VsLmRlMRIwEAYDVQQHDAlQZm9yemhlaW0xHDAaBgNVBAsME1ZlcnNhbmRoYXVz
IEtsaW5nZWwxJzAlBgNVBAoMHksg4oCTIE1haWwgT3JkZXIgR21iSCAmIENvLiBL
RzEQMA4GA1UECAwHR2VybWFueTEnMCUGCSqGSIb3DQEJARYYbmlscy5zY2hlbGVu
ekBrbGluZ2VsLmRlMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgE
-----END CERTIFICATE REQUEST-----''';

  var csr = '''-----BEGIN CERTIFICATE REQUEST-----
MIICvzCCAacCAQAwejELMAkGA1UEBhMCREUxEjAQBgNVBAgMCUZha2VzdGF0ZTER
MA8GA1UEBwwIRmFrZXRvd24xEzARBgNVBAoMCkVwaGVub2Ryb20xFTATBgNVBAsM
DERldmVsb3BlbWVudDEYMBYGA1UEAwwPYmFzaWMtdXRpbHMuZGV2MIIBIjANBgkq
hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0QX4e8oAKpD91eKKLL/EdrH02N/Ulg35
bdCJSozHubnoDG7ZXiELTFuPDANNmG4HmxVUpHv1uxmVrbzECnqBBEzjLW5NaW2T
9U74ACo23HmDFQJqiTF/aVFcfEzKwHXtZeVVCrXU5MEvnFjDrEOrgZIFd46AElSt
/IU6d6zKRlFx6pYgB64mPW3L50sNrg6ONkCfXt7HT5u2ftzo/iP5qi41BtzJUk2d
S9DskbweQ8mv4KRstjawioQf2Qjew/lgaVSf5V5YEFWnvHLCh15/LwbN5Z6EN0Ks
7i0gkefKfg+7ydd7eU4jHKhmE15Kbu59uWgS9cswJ4jmXPPqukusZQIDAQABoAAw
DQYJKoZIhvcNAQELBQADggEBAMLfJml1DbYOnUA7Nwlutk6suMmS0FDkQLXFiJQk
Ks5Fy6rfNtV1Z8KL/xGqAzyAcuAXL+0cQMZRsNTd9sT5ZriSzoikwaeIKOoRqhFq
bKXqlhYSbgmVUiYKm9HI3w+rzyZ+JXhiRXZ1ZGZXwEjBSu+Ne+SPE12mYlK+4zBx
gPTDMrvb73QiqHqiGc/l5UjwFyrOUsq5GtiMc6QU+rAQjj6Ix6KqOzJIxyVdRzOC
c47tT30d2tJEJbDHGutbqLQFRr7xx7uHP/LGggTFN8Zs2u+cQxPRFsIhQdpDY1MF
tHAaI8r/tlZQWf3fu4FVZMbxrYTMA5cwz/TxweMKWTroN5c=
-----END CERTIFICATE REQUEST-----''';

  var csrWithUnusedData = '''-----BEGIN CERTIFICATE REQUEST-----
MIIEIjCCAwoCAQAwOzEXMBUGA1UEAwwOb3dhLmZlLWNvbi5jb20xEzARBgNVBAoM
CkZlQ29uIEdtYkgxCzAJBgNVBAYTAkRFMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A
MIIBCgKCAQEAtauNcOeA3pwNPuvC67Q028VE39kpT8oTJO11Kbv4c5GJqo3oLTsT
b8x2uOdKq/ZoRaMr+dbIZ5u6rnWoQlmKekO7LhpmdjcL1dbD5LjQclQOHSzcosjd
EPhPUo1+PMvlwl9o+dlVvMhQC0gymDS+puXsyxjPtPOgM8MbUEdR8jLiZMtscu1O
rl083M99opLYNnTSQ2kFlT87TQk91lSsTkrbl/uKdk9wkEdgeC9D6b+LV/80VsMl
jyzNPsIM/t982MPmyGBKtstwvdOw+xoGDokyaf6gebj3QH+4GGuf8E1m/4VQhW0H
qmdn9GLCsxb7193CxZ5VHhccisgdxOS6EwIDAQABoIIBoDAaBgorBgEEAYI3DQID
MQwWCjYuMC42MDAyLjIwSQYJKwYBBAGCNxUUMTwwOgIBBQwXRkVDT04tU0JTMDgu
ZmVjb24ubG9jYWwMDEZFQ09OXGZhZG1pbgwOcG93ZXJzaGVsbC5leGUwcgYKKwYB
BAGCNw0CAjFkMGICAQEeWgBNAGkAYwByAG8AcwBvAGYAdAAgAFIAUwBBACAAUwBD
AGgAYQBuAG4AZQBsACAAQwByAHkAcAB0AG8AZwByAGEAcABoAGkAYwAgAFAAcgBv
AHYAaQBkAGUAcgMBADCBwgYJKoZIhvcNAQkOMYG0MIGxMA4GA1UdDwEB/wQEAwIF
oDByBgNVHREEazBpgg5vd2EuZmUtY29uLmNvbYILZmVjb24tc2JzMDiCF2ZlY29u
LXNiczA4LmZlY29uLmxvY2FsghhhdXRvZGlzY292ZXIuZmVjb24ubG9jYWyCF2F1
dG9kaXNjb3Zlci5mZS1jb24uY29tMAwGA1UdEwEB/wQCMAAwHQYDVR0OBBYEFIlC
K5ap/X+4sUtGqmP5HE4lcBaYMA0GCSqGSIb3DQEBBQUAA4IBAQCDu/cxbr9mYSGp
fSbtirIjURoW5Y6BtWVcP3CTYvn0//LWSpwz42n7kK95jX4kPI640SILleba3gye
nZGxZhdA8TOeXkeI9aIxRUCb9S2z9xvcCJKzQN9D+izAY1KlUjzVTrbwNW76IdIq
E9QMd+ItwS4dj5kwu7Z7tAMyG1EZWVV/uXUqQLHwYDqs2zTbw0xYg9ZZctTCa9Gx
MZw/rWTrpNxZ/uwmag/w1z9adFnUYxzrrbFyPxF356AWQa9B/kX7mfOn9UIE5QsH
0oos6SSv/Z2Dv8eePBMc/ai7lHmUGNF37fyRxth9yvZ3y7qkwQIMbV66CDg0ZiIt
yQRqfEI3
-----END CERTIFICATE REQUEST-----''';

  var csrWithConstructedSans = '''-----BEGIN CERTIFICATE REQUEST-----
MIIB7TCCAZMCAQAwXzELMAkGA1UEBhMCU0ExEzARBgNVBAsMCjMxMjM0NTY3ODkx
EzARBgNVBAoMCjMxMjM0NTY3ODkxJjAkBgNVBAMMHVRTVC04ODY0MzExNDUtMzEy
MzQ1Njc4OTAwMDAzMFYwEAYHKoZIzj0CAQYFK4EEAAoDQgAEkNOiV8GaCBVDnQw2
bM1Wy6PqIRZ6t+/hxJNQxg7FAdWK0PcUiUdv5ry2SVyFSz/qY34IJuPstO01fLWv
c41ny6CB1DCB0QYJKoZIhvcNAQkOMYHDMIHAMCEGCSsGAQQBgjcUAgQUDBJaQVRD
QS1Db2RlLVNpZ25pbmcwgZoGA1UdEQSBkjCBj6SBjDCBiTE7MDkGA1UEBAwyMS1U
U1R8Mi1UU1R8My1lZDIyZjFkOC1lNmEyLTExMTgtOWI1OC1kOWE4ZjExZTQ0NWYx
HzAdBgoJkiaJk/IsZAEBDA8zMTIzNDU2Nzg5MDAwMDMxDTALBgNVBAwMBDExMTEx
DDAKBgNVBBoMA1RTVDEMMAoGA1UEDwwDVFNUMAoGCCqGSM49BAMCA0gAMEUCIQCJ
bnRkFWRGFymr/HW84klYXSoxQLe8yuhewNOD86OdKQIgEeuUUbMzr2C5VGTKAOFo
ia4a0ZuZLVXe3JGRUtmvLZk=
-----END CERTIFICATE REQUEST-----''';

  var eccCsr = '''-----BEGIN CERTIFICATE REQUEST-----
MIIBLTCB1QIBADBzMQswCQYDVQQGEwJERTESMBAGA1UECAwJRmFrZVN0YXRlMREw
DwYDVQQHDAhGYWtlQ2l0eTEQMA4GA1UECgwHRmFrZU9yZzERMA8GA1UECwwIRmFr
ZVVuaXQxGDAWBgNVBAMMD2Jhc2ljLXV0aWxzLmRldjBZMBMGByqGSM49AgEGCCqG
SM49AwEHA0IABNPipBb/4mYzBOPg790huspXlAgsh34LkQR9EsUMyxCYOEhSlD5E
bPldDpxW+OPqe9E5+H79Yt9WHcYurdqluw+gADAKBggqhkjOPQQDAgNHADBEAiAX
fPGC9L6I+0SLjaz6saiNV5iEzCd7FFLUxwS/NldS3gIgbGt2BH8BvSsPQ8YMN+ad
/LFkdPu/ZgVpCkV/950NU3k=
-----END CERTIFICATE REQUEST-----''';

  var unformattedKey =
      'MIICvzCCAacCAQAwejELMAkGA1UEBhMCREUxEjAQBgNVBAgMCUZha2VzdGF0ZTERMA8GA1UEBwwIRmFrZXRvd24xEzARBgNVBAoMCkVwaGVub2Ryb20xFTATBgNVBAsMDERldmVsb3BlbWVudDEYMBYGA1UEAwwPYmFzaWMtdXRpbHMuZGV2MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0QX4e8oAKpD91eKKLL/EdrH02N/Ulg35bdCJSozHubnoDG7ZXiELTFuPDANNmG4HmxVUpHv1uxmVrbzECnqBBEzjLW5NaW2T9U74ACo23HmDFQJqiTF/aVFcfEzKwHXtZeVVCrXU5MEvnFjDrEOrgZIFd46AElSt/IU6d6zKRlFx6pYgB64mPW3L50sNrg6ONkCfXt7HT5u2ftzo/iP5qi41BtzJUk2dS9DskbweQ8mv4KRstjawioQf2Qjew/lgaVSf5V5YEFWnvHLCh15/LwbN5Z6EN0Ks7i0gkefKfg+7ydd7eU4jHKhmE15Kbu59uWgS9cswJ4jmXPPqukusZQIDAQABoAAwDQYJKoZIhvcNAQELBQADggEBAMLfJml1DbYOnUA7Nwlutk6suMmS0FDkQLXFiJQkKs5Fy6rfNtV1Z8KL/xGqAzyAcuAXL+0cQMZRsNTd9sT5ZriSzoikwaeIKOoRqhFqbKXqlhYSbgmVUiYKm9HI3w+rzyZ+JXhiRXZ1ZGZXwEjBSu+Ne+SPE12mYlK+4zBxgPTDMrvb73QiqHqiGc/l5UjwFyrOUsq5GtiMc6QU+rAQjj6Ix6KqOzJIxyVdRzOCc47tT30d2tJEJbDHGutbqLQFRr7xx7uHP/LGggTFN8Zs2u+cQxPRFsIhQdpDY1MFtHAaI8r/tlZQWf3fu4FVZMbxrYTMA5cwz/TxweMKWTroN5c=';

  var x509Pem = '''-----BEGIN CERTIFICATE-----
MIIFDTCCA/WgAwIBAgIQBxYr+XmB67PWzCkR7C39iDANBgkqhkiG9w0BAQsFADBA
MQswCQYDVQQGEwJVUzERMA8GA1UEChMIT0VNIFRlc3QxHjAcBgNVBAMTFUZ1bGwg
T0VNIFRlc3QgUlNBIFN1YjAeFw0xOTAzMTEwMDAwMDBaFw0yMDAzMTAxMjAwMDBa
MHsxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIEwZCYXllcm4xEzARBgNVBAcTClJlZ2Vu
c2J1cmcxFzAVBgNVBAoTDkludGVyTmV0WCBHbWJIMRQwEgYDVQQLEwtFbnR3aWNr
bHVuZzEXMBUGA1UEAxMOanVua2RyYWdvbnMuZGUwggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDDGv7+2oQyRWvFAt7UxtAQJB6zajegzrlvLLZ4+PhhJt6w
aSDW6IPV7H4uIvgL3cHP68AkATl+2fW0CEPy2i3vO27VDtxMp2oTk/IdPtVbNtZB
sjeFiNVzr7ZaD6z0u41WLEQbR34CmlWbggza3SS0tvPXD02YJpDz/Qm43hz0m+SJ
0IaesAM7b1tTbmlCxg3rm+CViU9wTsI9eUvOCZIjKS3E3MVcRJZTCCaZMp8JMKct
Ae4B90RunGbpvsYvWo4W4UQMFCVYcZp47FFeWcUnqx03nrSdP3LEEPcePVsRxPeB
ptsZzby9Wf7Sc2UNzTZSGjzxlpItgXdsjL4HiR/VAgMBAAGjggHGMIIBwjAfBgNV
HSMEGDAWgBS8odGV3/ZO7g4f11MzIg9X66vlUjAdBgNVHQ4EFgQUTriCU/8x5yQN
BoQPPYQcUVL7FUIwQQYDVR0RBDowOIIOanVua2RyYWdvbnMuZGWCEnd3dy5qdW5r
ZHJhZ29ucy5kZYISYXBpLmp1bmtkcmFnb25zLmRlMA4GA1UdDwEB/wQEAwIFoDAd
BgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwPgYDVR0fBDcwNTAzoDGgL4Yt
aHR0cDovL2NkcC5yYXBpZHNzbC5jb20vRnVsbE9FTVRlc3RSU0FTdWIuY3JsMEwG
A1UdIARFMEMwNwYJYIZIAYb9bAEBMCowKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3
LmRpZ2ljZXJ0LmNvbS9DUFMwCAYGZ4EMAQICMHUGCCsGAQUFBwEBBGkwZzAmBggr
BgEFBQcwAYYaaHR0cDovL3N0YXR1cy5yYXBpZHNzbC5jb20wPQYIKwYBBQUHMAKG
MWh0dHA6Ly9jYWNlcnRzLnJhcGlkc3NsLmNvbS9GdWxsT0VNVGVzdFJTQVN1Yi5j
cnQwCQYDVR0TBAIwADANBgkqhkiG9w0BAQsFAAOCAQEAwCJAiSMJSYCIrJZdcLmY
zgH/Hd6VUDQzuo/s8Q+UoqpwyPwGnmNpovvzfjtz2+bF0dCQwUWerm61kYF/3IU6
ucrdTW4uS+T11tipJgDUBU8jEHvASe+QNIP7BiNoXCs10SfI8FQajL0HxnHY0vKC
AAQiFStLngxNYduyz4C3ZUjeNjt/8NhCUhd2GZGA6gveHKvck47ZWFbblecH8Odw
nhzR+ztf+lSGoyQW+egNlPog/OLjr//kKx7kjuuvXa5Os8oPLENu6LAjTZJqGvJP
ga7IcCj2gCeuTdS4Ibhx3hiew7cfuGa9XbVd5JJmV8kIoFlzLrZpKB4eVDKqaNWg
/g==
-----END CERTIFICATE-----''';

  var x509PemV1 = '''-----BEGIN CERTIFICATE-----
MIIEGjCCAwICEQCbfgZJoz5iudXukEhxKe9XMA0GCSqGSIb3DQEBBQUAMIHKMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
cmlTaWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWdu
LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlT
aWduIENsYXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
dHkgLSBHMzAeFw05OTEwMDEwMDAwMDBaFw0zNjA3MTYyMzU5NTlaMIHKMQswCQYD
VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
aWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWduLCBJ
bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlTaWdu
IENsYXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkg
LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMu6nFL8eB8aHm8b
N3O9+MlrlBIwT/A2R/XQkQr1F8ilYcEWQE37imGQ5XYgwREGfassbqb1EUGO+i2t
KmFZpGcmTNDovFJbcCAEWNF6yaRpvIMXZK0Fi7zQWM6NjPXr8EJJC52XJ2cybuGu
kxUccLwgTS8Y3pKI6GyFVxEa6X7jJhFUokWWVYPKMIno3Nij7SqAP395ZVc+FSBm
CC+Vk7+qRy+oRpfwEuL+wgorUeZ25rdGt+INpsyow0xZVYnm6FNcHOqd8GIWC6fJ
Xwzw3sJ2zq/3avL6QaaiMxTJ5Xpj055iN9WFZZ4O5lMkdBteHRJTW8cs54NJOxWu
imi5V5cCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAERSWwauSCPc/L8my/uRan2Te
2yFPhpk0djZX3dAVL8WtfxUfN2JzPtTnX84XA9s1+ivbrmAJXx5fj267Cz3qWhMe
DGBvtcC1IyIuBwvLqXTLR7sdwdela8wv0kL9Sd2nic9TutoAWii/gt/4uhMdUIaC
/Y4wjylGsB49Ndo4YhYYSq3mtlFs3q9i6wHQHiT+eo8SGhJouPtmmRQURVyu565p
F4ErWjfJXir0xuKhXFSbplQAz/DxwceYMBo7Nhbbo27q/a2ywtrvAkcTisDxszGt
TxzhT5yvDwyd93gN2PQ1VoDat20Xj50egWTh/sVFuq1ruQp6Tk9LhO5L8X3dEQ==
-----END CERTIFICATE-----''';

  var x509PemWithGeneralizedTime = '''-----BEGIN CERTIFICATE-----
MIIEAzCCAuugAwIBAgIQVID5oHPtPwBMyonY43HmSjANBgkqhkiG9w0BAQUFADB1
MQswCQYDVQQGEwJFRTEiMCAGA1UECgwZQVMgU2VydGlmaXRzZWVyaW1pc2tlc2t1
czEoMCYGA1UEAwwfRUUgQ2VydGlmaWNhdGlvbiBDZW50cmUgUm9vdCBDQTEYMBYG
CSqGSIb3DQEJARYJcGtpQHNrLmVlMCIYDzIwMTAxMDMwMTAxMDMwWhgPMjAzMDEy
MTcyMzU5NTlaMHUxCzAJBgNVBAYTAkVFMSIwIAYDVQQKDBlBUyBTZXJ0aWZpdHNl
ZXJpbWlza2Vza3VzMSgwJgYDVQQDDB9FRSBDZXJ0aWZpY2F0aW9uIENlbnRyZSBS
b290IENBMRgwFgYJKoZIhvcNAQkBFglwa2lAc2suZWUwggEiMA0GCSqGSIb3DQEB
AQUAA4IBDwAwggEKAoIBAQDIIMDs4MVLqwd4lfNE7vsLDP90jmG7sWLqI9iroWUy
euuOF0+W2Ap7kaJjbMeMTC55v6kF/GlclY1i+blw7cNRfdCT5mzrMEvhvH2/UpvO
bntl8jixwKIy72KyaOBhU8E2lf/slLo2rpwcpzIP5Xy0xm90/XsY6KxX7QYgSzIw
WFv9zajmofxwvI6Sc9uXp3whrj3B9UiHbCe9nyV0gVWw93X2PaRka9ZP585ArQ/d
MtO8ihJTmMmJ+xAdTX7Nfh9WDSFwhfYggx/2uh8Ej+p3iDXE/+pOoYtNP2MbRMNE
1CV2yreN1x5KZmTNXMWcg+HCCIia7E6j8T4cLNlsHaFLAgMBAAGjgYowgYcwDwYD
VR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFBLyWj7qVhy/
zQas8fElyalL1BSZMEUGA1UdJQQ+MDwGCCsGAQUFBwMCBggrBgEFBQcDAQYIKwYB
BQUHAwMGCCsGAQUFBwMEBggrBgEFBQcDCAYIKwYBBQUHAwkwDQYJKoZIhvcNAQEF
BQADggEBAHv25MANqhlHt01Xo/6tu7Fq1Q+e2+RjxY6hUFaTlrg4wCQiZrxTFGGV
v9DHKpY5P30osxBAIWrEr7BSdxjhlthWXePdNl4dp1BUoMUq5KqMlIpPnTX/dqQG
E5Gion0ARD9V04I8GtVbvFZMIi5GQ4okQC3zErg7cBqklrkar4dBGmoYDQZPxz5u
uSlNDUmJEYcyW+ZLBMjkXOZ0c5RdFpgTlf7727FE5TpwrDdr5rMzcijJs1eg9gIW
iAYLtqZLICjU3j2LrTcFU3T+bsy8QxdxXvnFzBqpYe73dgzzcvRyrc9yAjYHR8/v
GVCJYMzpJJUPwssd8m92kMfMdcGWxZ0=
-----END CERTIFICATE-----''';

  var x509PemWithTeletextString = '''-----BEGIN CERTIFICATE-----
MIIEKjCCAxKgAwIBAgIEOGPe+DANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChML
RW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBp
bmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5
IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRp
ZmljYXRpb24gQXV0aG9yaXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0yOTA3
MjQxNDE1MTJaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3
LmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxp
YWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEG
A1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgp
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQq
K0vRvwtKTY7tgHalZ7d4QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQe
sYGpjX24zGtLA/ECDNyrpUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuX
MlBvPci6Zgzj/L24ScF2iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVT
XTzWnLLPKQP5L6RQstRIzgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/
HoZdenoVve8AjhUiVBcAkCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH
4QIDAQABo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNV
HQ4EFgQUVeSB0RGAvtiJuQijMfmhJAkWuXAwDQYJKoZIhvcNAQEFBQADggEBADub
j1abMOdTmXx6eadNl9cZlZD7Bh/KM3xGY4+WZiT6QBshJ8rmcnPyT/4xmf3IDExo
U8aAghOY+rat2l098c5u9hURlIIM7j+VrxGrD9cv3h8Dj1csHsm7mhpElesYT6Yf
zX1XEC+bBAlahLVu2B064dae0Wx5XnkcFMXj0EyTO2U87d89vqbllRrDtRnDvV5b
u/8j72gZyxKTJ1wDLW8w0B62GqzeWvfRqqgnpv55gcR5mTNXuhKwqeBCbJPKVt7+
bYQLCIt+jerXmCHG8+c8eS9enNFMFY3h7CI3zJpDC5fcgJCNs2ebb0gIFVbPv/Er
fF6adulZkMV8gzURZVE=
-----END CERTIFICATE-----''';

  var X509WithSans = '''-----BEGIN CERTIFICATE-----
MIIDsTCCApmgAwIBAgIUDmyV5Jod3FGoVStvzghkIs1xZTcwDQYJKoZIhvcNAQEL
BQAwajELMAkGA1UEBhMCREUxCzAJBgNVBAgMAkJZMQ0wCwYDVQQHDARDaXR5MRAw
DgYDVQQKDAdDb21wYW55MRUwEwYDVQQLDAxEZXZlbG9wZW1lbnQxFjAUBgNVBAMM
DWVwaGVub2Ryb20uZGUwHhcNMTkxMTI2MTA1MjMzWhcNMjExMTI1MTA1MjMzWjBq
MQswCQYDVQQGEwJERTELMAkGA1UECAwCQlkxDTALBgNVBAcMBENpdHkxEDAOBgNV
BAoMB0NvbXBhbnkxFTATBgNVBAsMDERldmVsb3BlbWVudDEWMBQGA1UEAwwNZXBo
ZW5vZHJvbS5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALkzNq/p
4YblpAyXOCZAsTgZau2NvmyJ/B4H4SgGC+A4sJCBRuhsiZTSxUHiF4Y1WkXPNIRJ
wxMU0BLCbpLP3QYJpXwQhRtVJB2I4BWybAS2zzV1s6x6XLJsuJUQxZXN4rBdSocN
+D9v4qsfaIIkN7CXnEmTFlzUh33YqL/lmCDZcIQe4HIGa7ElfgzMLEcDh60AsUrr
JSgIDGuAKfxRaZLYY1wpRm3sxkwSSGKYFZK/H34GDC3/PGqyLPxFHIeLRFwIlJH+
r/puvcKlot8dh3SCDgNGuzszbfN351Kdp01ZHVzoMLVMsC93hux/kfsBFPR7NSO2
tG9ClLZ23CdqcIcCAwEAAaNPME0wCwYDVR0PBAQDAgQwMBMGA1UdJQQMMAoGCCsG
AQUFBwMBMCkGA1UdEQQiMCCCEWFwaS5lcGhlbm9kcm9tLmRlggsxOTIuMTY4LjAu
MTANBgkqhkiG9w0BAQsFAAOCAQEALAS85yXzCcdpN2uPQIx9edN4/0sglP+hVEXA
XtWgjq8uYpPmSUdjPYMDQzg+A+zgLQc8FB2YK8bk/yuaDRZaRt8xhjaXQsRhrKf8
pAvj+Cwzy5Sn+L21a1xd+IJHVSh+B0xF8H7D9G2+KwG4GbEkwprDdCh/Ci39/5qg
eRnR3fZYB8vnirc4pJr8tOoZ3aKsdyFyBhozZNQETihW1vrzegs5/rQlLmSUwb3C
TQiUAMlBpzuKM6oCy833Ed+uCtCwGAj0unysv9o7pYv4dKW4REyBGQ0lJltpN3Cg
MrWLubLgMfDzQmOC3oOeNVBDUsQBdFwJwqEEO658U+/OsQYVlw==
-----END CERTIFICATE-----''';

  var X509WithIpSans = '''-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----''';

  var certWithoutCN = '''-----BEGIN CERTIFICATE-----
MIIGQzCCBCugAwIBAgIKWNF1YknimMXcJzANBgkqhkiG9w0BAQsFADBLMQswCQYD
VQQGEwJOTzEdMBsGA1UECgwUQnV5cGFzcyBBUy05ODMxNjMzMjcxHTAbBgNVBAMM
FEJ1eXBhc3MgQ2xhc3MgMiBDQSA1MB4XDTIwMDkzMDAzMTg1N1oXDTIxMDMyOTIx
NTkwMFowADCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMdi82GXyrIB
6syElYZjAcDsovgVi75Ha+BQEfFNZEk7gx9hKJjKqtS4ml+I/jeYkkBZJKkRZ/QB
kDxP+C3katM3QhZ1Ro/uJDh7lx60+S2W3By+rVJdR0JKs1kxalq/fkC/rMSCPRSr
Sb7DakuQNDytqMvwI3Be60L5UIt+vzITKS+zXru/DsK75I0DmObKzvWVyPdI3KRX
NpJfHYqAdN3AQIlftqrwuOwjPCVfSfmpQ/kWSBPnLMX4JJjNTrpR+bO8Zeh6AcnV
ZrmF9nflYC4LE8P/WPY4l6+3MXhmZLI6cFRKjHrb+TsqJqU6RUZ7Kdcy0whf9Plq
lWdhP3BaAfcCAwEAAaOCAnIwggJuMAkGA1UdEwQCMAAwHwYDVR0jBBgwFoAUJ1Kk
by0qq0CTkOzWacv+fGE7fEIwHQYDVR0OBBYEFCeb0lXIYklGgxzvQrx7jEuWGfOW
MA4GA1UdDwEB/wQEAwIFoDAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIw
HwYDVR0gBBgwFjAKBghghEIBGgECBzAIBgZngQwBAgEwOgYDVR0fBDMwMTAvoC2g
K4YpaHR0cDovL2NybC5idXlwYXNzLm5vL2NybC9CUENsYXNzMkNBNS5jcmwwIQYD
VR0RAQH/BBcwFYITdGVzdC5sYWIuc2hhZHVmLmNvbTBqBggrBgEFBQcBAQReMFww
IwYIKwYBBQUHMAGGF2h0dHA6Ly9vY3NwLmJ1eXBhc3MuY29tMDUGCCsGAQUFBzAC
hilodHRwOi8vY3J0LmJ1eXBhc3Mubm8vY3J0L0JQQ2xhc3MyQ0E1LmNlcjCCAQQG
CisGAQQB1nkCBAIEgfUEgfIA8AB1APZclC/RdzAiFFQYCDCUVo7jTRMZM7/fDC8g
C8xO8WTjAAABdN0FN7EAAAQDAEYwRAIgArAvLNqvUrMg/vDQu8zNgsoGahFodt2O
faPW/w07BZICIHek8n/zq1lbW58XForWdbXZ6ogqd5YgaVNS5Gy6jukYAHcARJRl
LrDuzq/EQAfYqP4owNrmgr7YyzG1P9MzlrW2gagAAAF03QUv+wAABAMASDBGAiEA
14996HrGYMCydAXZDFOUF3yt2V26IEb3lfLY3nPmTzMCIQC6Fto0DF97qpHgCAaf
YS2MFKbiTYN+HTv5+nDcoE886TANBgkqhkiG9w0BAQsFAAOCAgEAqZigbgUbLZse
PAUc+SDyPu456PoGHFTF7qUgOPJd5roARLcpiI8zxr8zSIirrlzfdUgRozdzGL7Y
hJ3XtNlg5F/WDQHWC6XeJSXyLzlnaqnvEckkHrvW2PfX+JsdgaIue9/mjZfqe1nk
/jJwK2ftw40l4sfxIpmNP3zjCzg0jMnakmzDf3cRg2r78VyzeqONr1SHyAaLvFmr
F6ZU5mCrxKO3JjMLGkJw1Rxc16fqGNniKPoqmEZbliJgSNLBK23MuRHpWvCG6JMT
AE0a9lkAdUQ07NJRJaBpEus1wYkPyO2b4Di69On2kdUsQ9LdU5aAIB9RCj5z97GQ
UN7LqL8NWQgKio8MgclLmP9s+IdWnB/cGPMrO6xyqBWtKA6rE0BCQTqYKOODPTXU
sR6+GN+bgkxtVxdKt52aWo6gy6Xuq98TXOj17m9hfKMIBRitrDJgU0v5YY5BLGYi
DpKZ45oA1K/PMZba/ZxxS9CzMU803ouHZZUJQgbJIaRUxVf0YrVKfcDdhEJ6MrRg
04mwh3NteH1/O3uQ+mFtKsmj1rFt9WMzgsO15fcYiCjjSzui/1jJL+15epiWXSFd
aTMXqalErmW7yZZ4+xHVFPcR+Wt/aXcJ9QaTf+N5sPwIYuQT5k3ZsA6z0bO/FV7i
8UhhGUUcPT6NuTN1LY7k+wvsdcRayEU=
-----END CERTIFICATE-----''';

  var selfSigned = '''-----BEGIN CERTIFICATE-----
MIID7TCCAtWgAwIBAgIBCjANBgkqhkiG9w0BAQsFADCBujELMAkGA1UEBhMCUlUx
FjAUBgNVBAgMDU1vc2NvdyBPYmxhc3QxEDAOBgNVBAcMB0tvcm9sZXYxJTAjBgNV
BAoMHEhpa3Zpc2lvbiBEaWdpdGFsIFRlY2hub2xvZ3kxFjAUBgNVBAMMDTk0LjE5
OC4xMzEuNTUxGTAXBgNVBAsMEEhpa3Zpc2lvbiBSdXNzaWExJzAlBgkqhkiG9w0B
CQEWGHN1cHBvcnQucnVAaGlrdmlzaW9uLmNvbTAeFw0yMDExMTUwOTAwMThaFw0z
MDExMTUwOTAwMThaMIG6MQswCQYDVQQGEwJSVTEWMBQGA1UECAwNTW9zY293IE9i
bGFzdDEQMA4GA1UEBwwHS29yb2xldjElMCMGA1UECgwcSGlrdmlzaW9uIERpZ2l0
YWwgVGVjaG5vbG9neTEWMBQGA1UEAwwNOTQuMTk4LjEzMS41NTEZMBcGA1UECwwQ
SGlrdmlzaW9uIFJ1c3NpYTEnMCUGCSqGSIb3DQEJARYYc3VwcG9ydC5ydUBoaWt2
aXNpb24uY29tMIIBIDANBgkqhkiG9w0BAQEFAAOCAQ0AMIIBCAKCAQEA2OHq1U7I
UvX+DQloekW1f+moc9BX6ogOG6lS1EfZ4jBQCZ5zDhLxhCAcaICa30jHlHtcWNMw
9AkFQi19CmngxU+c4nw8elLn8QMA4gHBDOdPlLMH5jx7r0L9qZLxZ5zN/U2QpJbz
8tFRBI4U/L8Kiypy1VHg36MSOGhrPtjMu4s2Cl9Pmz+HG/9Gun4nyH6rLsh9YnMk
gkMYNNDsoXAQ2XlM6D8Obw0GWibYOl4aNU4Z5DAPeyokPR1D1RaoH9lu3nH2JaoZ
5dOfJwrUchSUEwD/a0VGVMbVnK1HN99ZEfQVhzFvhyserYXxryhvk8xhVGs1BLZF
gulrh83aWFTltQIBAzANBgkqhkiG9w0BAQsFAAOCAQEADE9QYRIrqDZzqZwElDiI
yQdqGtouhz3Hxp/2oR5e0S/Zv+SyJCN5TWaFrnSKeYUNgoWpd4HwYaZ91+OKr4pg
pC3GyaocUthbg8Z1CSjJvLlBg4yyJ3ydANmx7Wf5luokItsTHdLX3j4JLlV97I4u
ue9WtHfK9LZqplDg2foDreC2ZXLXi7CaPCaxMyizIXxqekkPmyXK1AJDXxLXs/Eq
dj4aM+vWzHutpNb6bhzzgQALeAYOpI7akiJhjh7oHrhqiP7f1o+MVtJHNiRFy8em
HqE2zJz1wkcCwanxmQ4Sc+BQxIUXwsbq2tuknKfvOfaTSD226yn65C73cLKv97tr
yA==
-----END CERTIFICATE-----''';

  var bigCert = '''-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----''';

  var pkcs7 = '''-----BEGIN PKCS7-----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-----END PKCS7-----''';

  var digiCertGlobalRootG3 = '''-----BEGIN CERTIFICATE-----
MIICPzCCAcWgAwIBAgIQBVVWvPJepDU1w6QP1atFcjAKBggqhkjOPQQDAzBhMQsw
CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
ZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBHMzAe
Fw0xMzA4MDExMjAwMDBaFw0zODAxMTUxMjAwMDBaMGExCzAJBgNVBAYTAlVTMRUw
EwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
IDAeBgNVBAMTF0RpZ2lDZXJ0IEdsb2JhbCBSb290IEczMHYwEAYHKoZIzj0CAQYF
K4EEACIDYgAE3afZu4q4C/sLfyHS8L6+c/MzXRq8NOrexpu80JX28MzQC7phW1FG
fp4tn+6OYwwX7Adw9c+ELkCDnOg/QW07rdOkFFk2eJ0DQ+4QE2xy3q6Ip6FrtUPO
Z9wj/wMco+I+o0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjAd
BgNVHQ4EFgQUs9tIpPmhxdiuNkHMEWNpYim8S8YwCgYIKoZIzj0EAwMDaAAwZQIx
AK288mw/EkrRLTnDCgmXc/SINoyIJ7vmiI1Qhadj+Z4y3maTD/HMsQmP3Wyr+mt/
oAIwOWZbwmSNuJ5Q3KjVSaLtx9zRSX8XAbjIho9OjIgrqJqpisXRAL34VOKa5Vt8
sycX
-----END CERTIFICATE-----''';

  var digiCertGlobalRootG2 = '''-----BEGIN CERTIFICATE-----
MIIDjjCCAnagAwIBAgIQAzrx5qcRqaC7KGSxHQn65TANBgkqhkiG9w0BAQsFADBh
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBH
MjAeFw0xMzA4MDExMjAwMDBaFw0zODAxMTUxMjAwMDBaMGExCzAJBgNVBAYTAlVT
MRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
b20xIDAeBgNVBAMTF0RpZ2lDZXJ0IEdsb2JhbCBSb290IEcyMIIBIjANBgkqhkiG
9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuzfNNNx7a8myaJCtSnX/RrohCgiN9RlUyfuI
2/Ou8jqJkTx65qsGGmvPrC3oXgkkRLpimn7Wo6h+4FR1IAWsULecYxpsMNzaHxmx
1x7e/dfgy5SDN67sH0NO3Xss0r0upS/kqbitOtSZpLYl6ZtrAGCSYP9PIUkY92eQ
q2EGnI/yuum06ZIya7XzV+hdG82MHauVBJVJ8zUtluNJbd134/tJS7SsVQepj5Wz
tCO7TG1F8PapspUwtP1MVYwnSlcUfIKdzXOS0xZKBgyMUNGPHgm+F6HmIcr9g+UQ
vIOlCsRnKPZzFBQ9RnbDhxSJITRNrw9FDKZJobq7nMWxM4MphQIDAQABo0IwQDAP
BgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjAdBgNVHQ4EFgQUTiJUIBiV
5uNu5g/6+rkS7QYXjzkwDQYJKoZIhvcNAQELBQADggEBAGBnKJRvDkhj6zHd6mcY
1Yl9PMWLSn/pvtsrF9+wX3N3KjITOYFnQoQj8kVnNeyIv/iPsGEMNKSuIEyExtv4
NeF22d+mQrvHRAiGfzZ0JFrabA0UWTW98kndth/Jsw1HKj2ZL7tcu7XUIOGZX1NG
Fdtom/DzMNU+MeKNhJ7jitralj41E6Vf8PlwUHBHQRFXGU7Aj64GxJUTFy8bJZ91
8rGOmaFvE7FBcf6IKshPECBV1/MUReXgRPTqh5Uykw7+U0b6LJ3/iyK5S9kJRaTe
pLiaWN0bfVKfjllDiIGknibVb63dDcY3fe0Dkhvld1927jyNxF1WW6LZZm6zNTfl
MrY=
-----END CERTIFICATE-----''';

  var oscpEnd = '''-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----''';

  var ocspInter = '''-----BEGIN CERTIFICATE-----
MIIEYTCCA0mgAwIBAgIOSKQC3SeSDaIINJ3RmXswDQYJKoZIhvcNAQELBQAwTDEg
MB4GA1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjMxEzARBgNVBAoTCkdsb2Jh
bFNpZ24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMTYwOTIxMDAwMDAwWhcNMjYw
OTIxMDAwMDAwWjBiMQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2lnbiBu
di1zYTE4MDYGA1UEAxMvR2xvYmFsU2lnbiBFeHRlbmRlZCBWYWxpZGF0aW9uIENB
IC0gU0hBMjU2IC0gRzMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCr
awNnVNXcEfvFohPBjBkn3BB04mGDPfqO24+lD+SpvkY/Ar5EpAkcJjOfR0iBFYhW
N80HzpXYy2tIA7mbXpKu2JpmYdU1xcoQpQK0ujE/we+vEDyjyjmtf76LLqbOfuq3
xZbSqUqAY+MOvA67nnpdawvkHgJBFVPnxui45XH4BwTwbtDucx+Mo7EK4mS0Ti+P
1NzARxFNCUFM8Wxc32wxXKff6WU4TbqUx/UJm485ttkFqu0Ox4wTUUbn0uuzK7yV
3Y986EtGzhKBraMH36MekSYlE473GqHetRi9qbNG5pM++Sa+WjR9E1e0Yws16CGq
smVKwAqg4uc43eBTFUhVAgMBAAGjggEpMIIBJTAOBgNVHQ8BAf8EBAMCAQYwEgYD
VR0TAQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQU3bPnbagu6MVObs905nU8lBXO6B0w
HwYDVR0jBBgwFoAUj/BLf6guRSSuTVD6Y5qL3uLdG7wwPgYIKwYBBQUHAQEEMjAw
MC4GCCsGAQUFBzABhiJodHRwOi8vb2NzcDIuZ2xvYmFsc2lnbi5jb20vcm9vdHIz
MDYGA1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9jcmwuZ2xvYmFsc2lnbi5jb20vcm9v
dC1yMy5jcmwwRwYDVR0gBEAwPjA8BgRVHSAAMDQwMgYIKwYBBQUHAgEWJmh0dHBz
Oi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRvcnkvMA0GCSqGSIb3DQEBCwUA
A4IBAQBVaJzl0J/i0zUV38iMXIQ+Q/yht+JZZ5DW1otGL5OYV0LZ6ZE6xh+WuvWJ
J4hrDbhfo6khUEaFtRUnurqzutvVyWgW8msnoP0gtMZO11cwPUMUuUV8iGyIOuIB
0flo6G+XbV74SZuR5v5RAgqgGXucYUPZWvv9AfzMMQhRQkr/MO/WR2XSdiBrXHoD
L2xk4DmjA4K6iPI+1+qMhyrkUM/2ZEdA8ldqwl8nQDkKS7vq6sUZ5LPVdfpxJZZu
5JBj4y7FNFTVW1OMlCUvwt5H8aFgBMLFik9xqK6JFHpYxYmf4t2sLLxN0LlCthJE
abvp10ZlOtfu8hL5gCXcxnwGxzSb
-----END CERTIFICATE-----''';

  var X509WithIpv6Sans = '''-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
''';

  var openSslPkcs7 = '''-----BEGIN PKCS7-----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-----END PKCS7-----''';

  var vmc = '''-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----''';

  var csrWithSans = '''-----BEGIN CERTIFICATE REQUEST-----
MIIC8zCCAdsCAQAwZjEYMBYGA1UEAwwPYmFzaWMtdXRpbHMuZGV2MRYwFAYDVQQK
DA1NYWdpYyBDb21wYW55MREwDwYDVQQHDAhGYWtlY2l0eTESMBAGA1UECAwJRmFr
ZVN0YXRlMQswCQYDVQQGEwJERTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
ggEBAKIvmxVwFHsjGgmK7CWdioqwT/YyJYi86RO0jcWWSoe1MyrV1rkRO1oGGKRW
HDf2wzqaJbaWlnGDalCkJJVi7mecUkKUuRzPVDz4J0hHWo11FL7O08D5yGXEiaLn
VUMMWmm2p83a9Lgdf3cfYuo1rDxz6h2PeRxwg6JYh+CjsPTaAQ0XKyp0oAPKacOh
V4q6ftPzon2Q9MJzQEgXEjay29TN6nCmxfit4NWp7LTZiYyRLSvB4m3zaW5rYtSW
CyOyhq28J04adW/34WPdYJaFSWMiVtd9maYTaJS0L2HHSRMDSWP3uTmkzG6DbEkL
uAGmzUsMIPUan3D2pD5ywQBvKhECAwEAAaBIMEYGCSqGSIb3DQEJDjE5MDcwNQYD
VR0RBC4wLIIUc2FuMS5iYXNpYy11dGlscy5kZXaCFHNhbjIuYmFzaWMtdXRpbHMu
ZGV2MA0GCSqGSIb3DQEBCwUAA4IBAQCFRgmU3Pd5no0M8RFDqhMgD70EmTm8cCAh
LQE3AJoWnNZR17KRIr+7RUIjMEUzrvvx/ab8j8f66lLVceIAobAv+v0/wpOXZFOE
bQNr1TTNXo28TM7+mJOOi0mnUpkxBlvDfBpnl408cXWq0eE2qvVIhy0eQDyi9hzp
xc7oIqnRUVhb+/iLDyDO9Xdo8Jzuh16HTsaNe5bB75q6RjqOB0HqLvEgcuuBGVBT
o+4xEWN5ZSX/56iVTPXmD5LWcbSIJ+wm6ftsy4jrnvLGwnRPrUaNKzs7g+t3KXBN
HLrcjUGW+DDdf76QVu/3o42Jq8w5hCaykzup4hoSzh0QEw8YzN/j
-----END CERTIFICATE REQUEST-----''';

  var ocspResponse =
      'MIIFxgoBAKCCBb8wggW7BgkrBgEFBQcwAQEEggWsMIIFqDCBmqIWBBQhKQoVCN15AXyjxhHpv4ozglPEDBgPMjAyMTA4MTExMDEzNDRaMG8wbTBFMAkGBSsOAwIaBQAEFJxMcRXDAhnKNty5iyEzAEykp47TBBTds+dtqC7oxU5uz3TmdTyUFc7oHQIMb5wBeBwhgDIlSnMrgAAYDzIwMjEwODExMTAxMzQ0WqARGA8yMDIxMDgxNTEwMTM0NFowDQYJKoZIhvcNAQELBQADggEBACnhEigwmP9klp9f/AZXIFUtWIdOJmVS2M/wjuxjiR+50TPuPYysiExnYj3lf3ZM5cAK2UVvdTOhOfDBG13waLDb7J2r3Iyfd1DRubjIz8UtEOZe3Nh3DrhAYgHLXAlEWYhTQgibg50hQW8piTEb8jCX2Ice7JHPQn/x3GbZBU5MqAPYDrjCanpHyO2VDMhsViWP6BFRx7jReRph9u0JWaxbGoKWZ7vHIoZxsTUpktrlXAk5MzccDy8cbWLz81BajDE1E39iwiEa0A1j1j+OhrD6T0nLcYyqctd+aQI406Xr+BrvyX4eGYi2UWfsdnoi5KCiyu4BaZ1K4wNcB80zG0GgggPzMIID7zCCA+swggLToAMCAQICDExHmYumt6CDjKqQyzANBgkqhkiG9w0BAQsFADBiMQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2lnbiBudi1zYTE4MDYGA1UEAxMvR2xvYmFsU2lnbiBFeHRlbmRlZCBWYWxpZGF0aW9uIENBIC0gU0hBMjU2IC0gRzMwHhcNMjEwNzI4MTAyNTE4WhcNMjExMDI4MTAyNTE3WjCBijELMAkGA1UEBhMCU0cxGzAZBgNVBAoTEkdsb2JhbFNpZ24gUHRlIEx0ZDEVMBMGA1UEBRMMMjAxOTA2MTMwMDA4MUcwRQYDVQQDEz5HbG9iYWxTaWduIEV4dGVuZGVkIFZhbGlkYXRpb24gQ0EgLSBTSEEyNTYgLSBHMyBPQ1NQIHJlc3BvbmRlcjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAME720lBGu4snNoi0CA3izovZjHiwqubFWHOXvnF4cJ3ckrrlpEFfdYXLZ+fH+vNLj3/Bvwm4ZWuccetsh5NJUhtxfYXQu4tY/zQjEFXG47kCbIRV49C0aJpmeSvqong0qhCoZOkBqlbLwaAzxmCgFMSNaNMglqWshbKBZCvCKrtl1X2CL/10ZypY680R6nETZTDwZhUo5t2uCdJEb2bd3VSZ2slVaVrOP6hEa/2PLWsj8SzpE/NMAB0coaA8nDctfXPjTmZgM4ip/6R7mCfppyGlgIzxegI5H0AARHPTBil9vZoNowbDDt3LR23pnGgk1SiHGYyr+oIakCwQmdNMxUCAwEAAaN4MHYwHwYDVR0jBBgwFoAU3bPnbagu6MVObs905nU8lBXO6B0wDwYJKwYBBQUHMAEFBAIFADATBgNVHSUEDDAKBggrBgEFBQcDCTAdBgNVHQ4EFgQUISkKFQjdeQF8o8YR6b+KM4JTxAwwDgYDVR0PAQH/BAQDAgeAMA0GCSqGSIb3DQEBCwUAA4IBAQCjZW4xOUr6U9jmHS/nnvI/3ZsodsGvhC5BNE+AOSdOmGVSMU5qzVKpTWHxME+k8XUJxcIgh+1kCl2vTOFCrNF4aMDxWjoZwcmCJlehLNp0rU1/MHwHQHzGk11F7D73q4+AGoX8YF3VV5hCywJYHheS4iaTvupuwdsOD++sAKD7/KyUEL/CsADtwr/SKHNTto9vj5TAglUb/cDFHXsDpXhP9sS6dckbKsz+oYvtgR2zMQv4ehXppvwE3cHYR5RoTt2HZddB4uSav4OaQTVjEhWPOFKoqNzSlrfM333IyoRvTcCifzoJPaof2zWH4hhSpyEiXSoshJag1qRm4K9Bwd+V';

  var ocspResponse2 =
      'MIIB5goBAKCCAd8wggHbBgkrBgEFBQcwAQEEggHMMIIByDCBsaIWBBSljP4yzOsPLNQZxgi4ACSIXcPFtxgPMjAyMTA4MTExMTU0NThaMIGFMIGCMEkwCQYFKw4DAhoFAAQUc4Sn0GLAB0GWQ82/EbUOT4LE40EEFKWM/jLM6w8s1BnGCLgAJIhdw8W3AhAEv3crr1ZmySqLla9KGkYWoREYDzIwMjEwNTAyMTkyMTQ2WhgPMjAyMTA4MTExMTM5MDJaoBEYDzIwMjEwODE4MTA1NDAyWjANBgkqhkiG9w0BAQsFAAOCAQEAR4UMbB5wOiaiLqhmpcVZZTL2fGKDzxKxgG4U6J7NR12czlbbwhYy7taKw9etiw87l3wkbP6H/mgYN6NIVHH2DDhJJJXWKPuSaWY+K6g8bz4aIKGUnWKyfFiP8NWECTZiMgeNMRDI5sR/NrM2aekRHPWPC8In+2NxsZqvSvRhQGJbixEfHOvAX2bJUf0soIr+4WpoWxppqBKVafnwPoAsh6UB/Ks8MuSy89dIo4DfLQll1T2FkY0BtA1c2vx3Wyg0BzbWFnfK0Z0nRo9NBjoLvw/4pimos46DvVbtxebT/cmOhLwtjJUJ59UVzbUfEwYyB7WCUG5jT4EYodp9nwOsog==';

  var ocspResponse3 = 'MAMKAQY=';

  var certificateChain1 = '''-----BEGIN CERTIFICATE-----
MIIFajCCBPCgAwIBAgIQBRiaVOvox+kD4KsNklVF3jAKBggqhkjOPQQDAzBWMQsw
CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMTAwLgYDVQQDEydEaWdp
Q2VydCBUTFMgSHlicmlkIEVDQyBTSEEzODQgMjAyMCBDQTEwHhcNMjIwMzE1MDAw
MDAwWhcNMjMwMzE1MjM1OTU5WjBmMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2Fs
aWZvcm5pYTEWMBQGA1UEBxMNU2FuIEZyYW5jaXNjbzEVMBMGA1UEChMMR2l0SHVi
LCBJbmMuMRMwEQYDVQQDEwpnaXRodWIuY29tMFkwEwYHKoZIzj0CAQYIKoZIzj0D
AQcDQgAESrCTcYUh7GI/y3TARsjnANwnSjJLitVRgwgRI1JlxZ1kdZQQn5ltP3v7
KTtYuDdUeEu3PRx3fpDdu2cjMlyA0aOCA44wggOKMB8GA1UdIwQYMBaAFAq8CCkX
jKU5bXoOzjPHLrPt+8N6MB0GA1UdDgQWBBR4qnLGcWloFLVZsZ6LbitAh0I7HjAl
BgNVHREEHjAcggpnaXRodWIuY29tgg53d3cuZ2l0aHViLmNvbTAOBgNVHQ8BAf8E
BAMCB4AwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMIGbBgNVHR8EgZMw
gZAwRqBEoEKGQGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRMU0h5
YnJpZEVDQ1NIQTM4NDIwMjBDQTEtMS5jcmwwRqBEoEKGQGh0dHA6Ly9jcmw0LmRp
Z2ljZXJ0LmNvbS9EaWdpQ2VydFRMU0h5YnJpZEVDQ1NIQTM4NDIwMjBDQTEtMS5j
cmwwPgYDVR0gBDcwNTAzBgZngQwBAgIwKTAnBggrBgEFBQcCARYbaHR0cDovL3d3
dy5kaWdpY2VydC5jb20vQ1BTMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGG
GGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2Nh
Y2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VExTSHlicmlkRUNDU0hBMzg0MjAy
MENBMS0xLmNydDAJBgNVHRMEAjAAMIIBfwYKKwYBBAHWeQIEAgSCAW8EggFrAWkA
dgCt9776fP8QyIudPZwePhhqtGcpXc+xDCTKhYY069yCigAAAX+Oi8SRAAAEAwBH
MEUCIAR9cNnvYkZeKs9JElpeXwztYB2yLhtc8bB0rY2ke98nAiEAjiML8HZ7aeVE
P/DkUltwIS4c73VVrG9JguoRrII7gWMAdwA1zxkbv7FsV78PrUxtQsu7ticgJlHq
P+Eq76gDwzvWTAAAAX+Oi8R7AAAEAwBIMEYCIQDNckqvBhup7GpANMf0WPueytL8

u/PBaIAObzNZeNMpOgIhAMjfEtE6AJ2fTjYCFh/BNVKk1mkTwBTavJlGmWomQyaB

AHYAs3N3B+GEUPhjhtYFqdwRCUp5LbFnDAuH3PADDnk2pZoAAAF/jovErAAABAMA
RzBFAiEA9Uj5Ed/XjQpj/MxQRQjzG0UFQLmgWlc73nnt3CJ7vskCICqHfBKlDz7R
EHdV5Vk8bLMBW1Q6S7Ga2SbFuoVXs6zFMAoGCCqGSM49BAMDA2gAMGUCMCiVhqft
7L/stBmv1XqSRNfE/jG/AqKIbmjGTocNbuQ7kt1Cs7kRg+b3b3C9Ipu5FQIxAM7c
tGKrYDGt0pH8iF6rzbp9Q4HQXMZXkNxg+brjWxnaOVGTDNwNH7048+s/hT9bUQ==
-----END CERTIFICATE-----
-----BEGIN CERTIFICATE-----
MIIEFzCCAv+gAwIBAgIQB/LzXIeod6967+lHmTUlvTANBgkqhkiG9w0BAQwFADBh
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBD
QTAeFw0yMTA0MTQwMDAwMDBaFw0zMTA0MTMyMzU5NTlaMFYxCzAJBgNVBAYTAlVT
MRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxMDAuBgNVBAMTJ0RpZ2lDZXJ0IFRMUyBI
eWJyaWQgRUNDIFNIQTM4NCAyMDIwIENBMTB2MBAGByqGSM49AgEGBSuBBAAiA2IA
BMEbxppbmNmkKaDp1AS12+umsmxVwP/tmMZJLwYnUcu/cMEFesOxnYeJuq20ExfJ
qLSDyLiQ0cx0NTY8g3KwtdD3ImnI8YDEe0CPz2iHJlw5ifFNkU3aiYvkA8ND5b8v
c6OCAYIwggF+MBIGA1UdEwEB/wQIMAYBAf8CAQAwHQYDVR0OBBYEFAq8CCkXjKU5
bXoOzjPHLrPt+8N6MB8GA1UdIwQYMBaAFAPeUDVW0Uy7ZvCj4hsbw5eyPdFVMA4G
A1UdDwEB/wQEAwIBhjAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwdgYI
KwYBBQUHAQEEajBoMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5j
b20wQAYIKwYBBQUHMAKGNGh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdp
Q2VydEdsb2JhbFJvb3RDQS5jcnQwQgYDVR0fBDswOTA3oDWgM4YxaHR0cDovL2Ny
bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0R2xvYmFsUm9vdENBLmNybDA9BgNVHSAE
NjA0MAsGCWCGSAGG/WwCATAHBgVngQwBATAIBgZngQwBAgEwCAYGZ4EMAQICMAgG
BmeBDAECAzANBgkqhkiG9w0BAQwFAAOCAQEAR1mBf9QbH7Bx9phdGLqYR5iwfnYr
6v8ai6wms0KNMeZK6BnQ79oU59cUkqGS8qcuLa/7Hfb7U7CKP/zYFgrpsC62pQsY
kDUmotr2qLcy/JUjS8ZFucTP5Hzu5sn4kL1y45nDHQsFfGqXbbKrAjbYwrwsAZI/
BKOLdRHHuSm8EdCGupK8JvllyDfNJvaGEwwEqonleLHBTnm8dqMLUeTF0J5q/hos
Vq4GNiejcxwIfZMy0MJEGdqN9A57HSgDKwmKdsp33Id6rHtSJlWncg+d0ohP/rEh
xRqhqjn1VtvChMQ1H3Dau0bwhr9kAMQ+959GG50jBbl9s08PqUU643QwmA==
-----END CERTIFICATE-----

-----BEGIN CERTIFICATE-----
MIIDrzCCApegAwIBAgIQCDvgVpBCRrGhdWrJWZHHSjANBgkqhkiG9w0BAQUFADBh
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBD
QTAeFw0wNjExMTAwMDAwMDBaFw0zMTExMTAwMDAwMDBaMGExCzAJBgNVBAYTAlVT
MRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
b20xIDAeBgNVBAMTF0RpZ2lDZXJ0IEdsb2JhbCBSb290IENBMIIBIjANBgkqhkiG
9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4jvhEXLeqKTTo1eqUKKPC3eQyaKl7hLOllsB
CSDMAZOnTjC3U/dDxGkAV53ijSLdhwZAAIEJzs4bg7/fzTtxRuLWZscFs3YnFo97
nh6Vfe63SKMI2tavegw5BmV/Sl0fvBf4q77uKNd0f3p4mVmFaG5cIzJLv07A6Fpt
43C/dxC//AH2hdmoRBBYMql1GNXRor5H4idq9Joz+EkIYIvUX7Q6hL+hqkpMfT7P
T19sdl6gSzeRntwi5m3OFBqOasv+zbMUZBfHWymeMr/y7vrTC0LUq7dBMtoM1O/4
gdW7jVg/tRvoSSiicNoxBN33shbyTApOB6jtSj1etX+jkMOvJwIDAQABo2MwYTAO
BgNVHQ8BAf8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUA95QNVbR
TLtm8KPiGxvDl7I90VUwHwYDVR0jBBgwFoAUA95QNVbRTLtm8KPiGxvDl7I90VUw
DQYJKoZIhvcNAQEFBQADggEBAMucN6pIExIK+t1EnE9SsPTfrgT1eXkIoyQY/Esr
hMAtudXH/vTBH1jLuG2cenTnmCmrEbXjcKChzUyImZOMkXDiqw8cvpOp/2PV5Adg
06O/nVsJ8dWO41P0jmP6P6fbtGbfYmbW0W5BjfIttep3Sp+dWOIrWcBAI+0tKIJF
PnlUkiaY4IBIqDfv8NZ5YBberOgOzW6sRBc4L0na4UU+Krk2U886UAb3LujEV0ls
YSEY1QSteDwsOoBrp+uvFRTp2InBuThs4pFsiv9kuXclVzDAGySj4dzp30d8tbQk
CAUw7C29C79Fv1C5qfPrmAESrciIxpg0X40KPMbp1ZWVbd4=
-----END CERTIFICATE-----''';

  var multiValueDnCsr = '''-----BEGIN CERTIFICATE REQUEST-----
MIICmjCCAYICAQAwVTFTMAkGA1UEBhMCREUwCQYDVQQIDAJCWTASBgNVBAMMC2V4
YW1wbGUuY29tMBIGA1UECgwLRXhhbXBsZSBPcmcwEwYDVQQHDAxFeGFtcGxlIENp
dHkwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDZ3APz9QD2IGLy2XCC
ZrIXQkLvexS6YiwWYvX/3hr1ECII6rNQdNwuSUVRI0GYpkM4S0OPvmVo3ATenS+Z
mkW00GhtxFPDKw84IUFiVen+Jse89c04J91Shgxxtg5aUZYk7NP7ewfHC7JpY0AJ
gN+eyWBQQQxy44KfCymuUG6txtOkJw5/rMTmWTm6a7TVRNXYZFWYZ6ekhsXgin2j
WHjzBRxhWLsU1DYFJhQxTcGCfiujeNUDeZYtLAzYsxsI+m/7I9zrrFmo6wCvIdOq
xU1YVihPQU3PsXe5pwLYRpHHgr1piCoUlgMexdJE8ce/J07xMOKZIL7Pw4Z+lmEw
ESHpAgMBAAGgADANBgkqhkiG9w0BAQsFAAOCAQEAAxH+QPy6gmLRCFbeSU/CENL+
qFAzhDnFChWApL/8NZvB8O31KwRtskaT0rCT2tITFuYQ3f1r1QdweNYYHflrKJD7
h++rWZqcMalno/xW+JQFXRF+tPBv8TW8ctYzW78oGXN0G5pVmNg/dUGqtCfgr5vA
U1QfDr9/25srVZywlxzlVH6jwv39wY2nzsa+0cp1oRixCDRAigBJwpjwwUTgjRLg
8qd59XnpgXEtJfR5Kt2Rkm6HX/cKe/5NnzH1m28XWOgl1b891J0MmLvszTWVnNNn
nuA2AnJ5dA8+KfA37mjH9uWQbSnMq8ehnu61MyKj68qN5UWZCqo7OLNI/WVIrA==
-----END CERTIFICATE REQUEST-----''';

  var rsaPssSignature = '''-----BEGIN CERTIFICATE REQUEST-----
MIIE/zCCArcCAQAwgYkxCzAJBgNVBAYTAkRFMQswCQYDVQQIDAJCVzEMMAoGA1UE
BwwDVWxtMRkwFwYDVQQKDBBTV1UgVGVsZW5ldCBHbWJIMRwwGgYDVQQLDBNFbmVy
Z2lld2lydHNjaGFmdCAzMSYwJAYDVQQDDB1mYWhycGxhbm1hbmFnZW1lbnRAZWRp
LnN3dS5kZTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAM0ZRsagguJH
H9UmmzODkiJjUesZyXiY0V5F2DdRwAgI8pQvLAfOUy6lpZk96ojHA/k7chcg0NWe
I2h6RpaiSSuLGYHcg0lkuXg3Q3QdLNgb40b17byLURj7aWMUIo/nLXqIotvoetCM
qDnvUd0QrEVpUUBMV6WtjyDBQKxG7b4kJYy32LH6p1CKW5MmRILYN1lGxX6F22WX
V2vVHVo8LMyrYLFHgNhk0rKtnZI9SOEE2jEFACxgwdVVTATQWFVBuga3yhscq49b
1JC6Zu1ZtyR81Ckt/SMZnO+Gkk5Elr5+ziVwr8m4rbBVxLFv2FCcnHydZzHpX1EN
H+xKleuk0sVDyUuoThNmxh7AWS8YUhLkk113XnK4t2jJzCu2mBlMf40qK4JzkMDN
Q0xlMzSE4/4jkEhr9m0YSl81+X9sn5av9Ine6F70QWGGQnlK2WcO/EpzHeJTcUs5
ncYcEGaa8l+XJCnhjC/s7C44jCLFxY4iS3u/NiHdRQUdP4m5I529hSJuFBEZo2/g
nQxTMA/dwCLukSm6H+20SUnI78Tgo1pRKrtM3urSgmvMpEH6nisEbAteUCb4xrvM
0HcvXzqMbBoXC2LumvRuDz67STb7LhM5euY99flmC1q2rjH9XVlDHX+OnQ/SAzPO
TxjNIBFRG40w1p26tBNDJnDEWz5BbunLAgMBAAGgADA9BgkqhkiG9w0BAQowMKAN
MAsGCWCGSAFlAwQCAaEaMBgGCSqGSIb3DQEBCDALBglghkgBZQMEAgGiAwIBIAOC
AgEAyUcepyNHOowFuJ0+7Cw/nVNxu139CjNLzW6iIynGgDm8hLBNjBVBzCjqRT5X
exF3yIHT401D8wVDj2Q0XjM+hVE8TA0zER+ScXfIH8DlA0wjaItSzPf85xDkKX3Y
blSHHJ7a34G2LQFDmkvoMUh7dxaxx/QMBjB+gVH6W8R5z3ZbOUijw17+FtBQuo+R
1+PqKpaJSB7sfj8VBybD2Zb0NEM40tO9esj4uWVJ535yHIfd1N8ecy/UojKQ4v6X
W45PiyfMEQODZUK+IaEcf9asyWUFrdmPaiOF/TTqo7IB47+g64DoJQwC5cuucqef
B7SX1hNT+Alq3QIrYyXYTNXUUPGjWWMM54N05C/gBJAchA5MJ5w4CP8T7BlInMdW
1vvk/DiVV/M+oNCVYeOCj8cP4N1wOReEuL7slAlzgIAw0twQe5HrXCd/KHusiCaP
EJa5dxjOJVZxTYbPzdSzzG1wlXpkeArYC23mA+doPPrsLP+3KVztikNaRPhhxwjd
LW/oNqZMcgg5Os1lkzxPBaTVlb616tQy2T0whzwvRKm7uyEKx0iRUUZdQTfCeb+V
J8oruF/gUh/G3Naq3ZqnPSr6caJwdLKI9+Di2a4rMYGWkI37kwQN7fhpqquASD8p
rn6zwvNaIBmG2reX1OyNE7nRlM1SoBNQ4We+Kf5H2JN1v+4=
-----END CERTIFICATE REQUEST-----
''';

  test('Test getBytesFromPEMString', () {
    var bytes = CryptoUtils.getBytesFromPEMString(csr);
    var formatted = X509Utils.formatKeyString(
        base64Encode(bytes), X509Utils.BEGIN_CSR, X509Utils.END_CSR);
    expect(formatted, csr);
  });

  test('Test formatKeyString', () {
    var formatted = X509Utils.formatKeyString(
        unformattedKey, X509Utils.BEGIN_CSR, X509Utils.END_CSR);
    expect(formatted, csr);
  });

  test('Test encodeDN', () {
    var dn = {
      'CN': 'basic-utils.dev',
      'O': 'Magic Company',
      'L': 'Fakecity',
      'S': 'FakeState',
      'C': 'DE',
    };
    var object = X509Utils.encodeDN(dn) as ASN1Sequence;
    expect(object.elements!.length, 5);
  });

  test('Test privateKeyFromASN1Sequence', () {
    var pair = CryptoUtils.generateRSAKeyPair();

    var privateKey =
        CryptoUtils.encodeRSAPrivateKeyToPem(pair.privateKey as RSAPrivateKey);
    var bytes = CryptoUtils.getBytesFromPEMString(privateKey);
    var asn = ASN1Parser(bytes).nextObject() as ASN1Sequence;
    var objects = asn.elements!;
    var string = objects[2] as ASN1OctetString;
    var object = X509Utils.privateKeyFromASN1Sequence(
        ASN1Parser(string.valueBytes).nextObject() as ASN1Sequence);
    expect(object.n!.bitLength, 2048);
  });

  test('Test encodeASN1ObjectToPem', () {
    var topLevelSeq = ASN1Sequence();
    topLevelSeq.add(ASN1Integer(BigInt.from(0)));
    var pem = X509Utils.encodeASN1ObjectToPem(
        topLevelSeq, '-----BEGIN PUBLIC KEY-----', '-----END PUBLIC KEY-----');
    expect(
        pem, '-----BEGIN PUBLIC KEY-----\nMAMCAQA=\n-----END PUBLIC KEY-----');
  });

  test('Test generateRsaCsrPem', () {
    var pair = CryptoUtils.generateRSAKeyPair();
    var dn = {
      'CN': 'basic-utils.dev',
      'O': 'Magic Company',
      'L': 'Fakecity',
      'S': 'FakeState',
      'C': 'DE',
    };
    var csr = X509Utils.generateRsaCsrPem(
        dn, pair.privateKey as RSAPrivateKey, pair.publicKey as RSAPublicKey,
        san: ['san1.basic-utils.dev', 'san2.basic-utils.dev']);
    var bytes = CryptoUtils.getBytesFromPEMString(csr);
    var sequence = ASN1Sequence.fromBytes(bytes);
    var e1 = sequence.elements!.elementAt(0) as ASN1Sequence;
    var e2 = e1.elements!.elementAt(1) as ASN1Sequence;
    var e3 = e2.elements!.elementAt(0) as ASN1Set;
    var e4 = e3.elements!.elementAt(0) as ASN1Sequence;
    var e5 = e4.elements!.elementAt(1) as ASN1UTF8String;
    var cn = e5.utf8StringValue;
    expect(cn, 'basic-utils.dev');

    csr = X509Utils.generateRsaCsrPem(
        dn, pair.privateKey as RSAPrivateKey, pair.publicKey as RSAPublicKey,
        signingAlgorithm: 'SHA-1');
  });

  test('Test generateEccCsrPem', () {
    var pair = CryptoUtils.generateEcKeyPair();
    var dn = {
      'CN': 'basic-utils.dev',
      'O': 'Magic Company',
      'L': 'Fakecity',
      'S': 'FakeState',
      'C': 'DE',
    };
    var csr = X509Utils.generateEccCsrPem(
        dn, pair.privateKey as ECPrivateKey, pair.publicKey as ECPublicKey);
    var bytes = CryptoUtils.getBytesFromPEMString(csr);
    var sequence = ASN1Sequence.fromBytes(bytes);
    var e1 = sequence.elements!.elementAt(0) as ASN1Sequence;
    var e2 = e1.elements!.elementAt(1) as ASN1Sequence;
    var e3 = e2.elements!.elementAt(0) as ASN1Set;
    var e4 = e3.elements!.elementAt(0) as ASN1Sequence;
    var e5 = e4.elements!.elementAt(1) as ASN1UTF8String;
    var cn = e5.utf8StringValue;
    expect(cn, 'basic-utils.dev');

    csr = X509Utils.generateEccCsrPem(
        dn, pair.privateKey as ECPrivateKey, pair.publicKey as ECPublicKey,
        signingAlgorithm: 'SHA-384');
  });

  test('Test generateKeyPair', () {
    var pair = CryptoUtils.generateRSAKeyPair();
    var private = pair.privateKey as RSAPrivateKey;
    var public = pair.publicKey as RSAPublicKey;
    expect(private.n!.bitLength, 2048);
    expect(public.n!.bitLength, 2048);
  });

  test('Test x509CertificateFromPem', () {
    var data = X509Utils.x509CertificateFromPem(x509Pem);
    expect(data.version, 3);

    expect(
        data.serialNumber.toString(), '9419718410412351084484106081643920776');

    expect(data.signatureAlgorithm, '1.2.840.113549.1.1.11');

    expect(data.issuer.containsKey('2.5.4.6'), true);
    expect(data.issuer['2.5.4.6'], 'US');
    expect(data.issuer.containsKey('2.5.4.10'), true);
    expect(data.issuer['2.5.4.10'], 'OEM Test');
    expect(data.issuer.containsKey('2.5.4.3'), true);
    expect(data.issuer['2.5.4.3'], 'Full OEM Test RSA Sub');

    expect(
        data.validity.notBefore.toIso8601String(), '2019-03-11T00:00:00.000Z');
    expect(
        data.validity.notAfter.toIso8601String(), '2020-03-10T12:00:00.000Z');

    expect(data.subject.containsKey('2.5.4.3'), true);
    expect(data.subject['2.5.4.3'], 'junkdragons.de');

    expect(data.sha1Thumbprint, '1F6254CEDA7E9E9AEBF8B687BDFB5CC03AD1B3E7');
    expect(data.md5Thumbprint, '4CBED02D6CF2F161540A3177A55F94F6');

    var publicKeyData = data.publicKeyData;

    expect(publicKeyData.length, 2048);
    expect(publicKeyData.sha1Thumbprint,
        'EEBEB3DA65F238F829F0977BBF409395099704CB');
    expect(publicKeyData.algorithm, '1.2.840.113549.1.1.1');
    expect(publicKeyData.bytes,
        '30820122300D06092A864886F70D01010105000382010F003082010A0282010100C31AFEFEDA8432456BC502DED4C6D010241EB36A37A0CEB96F2CB678F8F86126DEB06920D6E883D5EC7E2E22F80BDDC1CFEBC02401397ED9F5B40843F2DA2DEF3B6ED50EDC4CA76A1393F21D3ED55B36D641B2378588D573AFB65A0FACF4BB8D562C441B477E029A559B820CDADD24B4B6F3D70F4D982690F3FD09B8DE1CF49BE489D0869EB0033B6F5B536E6942C60DEB9BE095894F704EC23D794BCE099223292DC4DCC55C449653082699329F0930A72D01EE01F7446E9C66E9BEC62F5A8E16E1440C142558719A78EC515E59C527AB1D379EB49D3F72C410F71E3D5B11C4F781A6DB19CDBCBD59FED273650DCD36521A3CF196922D81776C8CBE07891FD50203010001');

    var sans = data.subjectAlternativNames!;
    expect(sans.length, 3);
    expect(sans.elementAt(0), 'junkdragons.de');
    expect(sans.elementAt(1), 'www.junkdragons.de');
    expect(sans.elementAt(2), 'api.junkdragons.de');

    var cRLDistributionPoints = data.extensions!.cRLDistributionPoints;
    expect(cRLDistributionPoints!.length, 1);
    expect(cRLDistributionPoints.elementAt(0),
        'http://cdp.rapidssl.com/FullOEMTestRSASub.crl');
  });

  test('Test x509CertificateFromPem with IP Sans', () {
    var data = X509Utils.x509CertificateFromPem(X509WithSans);
    var sans = data.subjectAlternativNames!;
    expect(sans.length, 2);
    expect(sans.elementAt(0), 'api.ephenodrom.de');
    expect(sans.elementAt(1), '192.168.0.1');

    data = X509Utils.x509CertificateFromPem(X509WithIpSans);
    sans = data.subjectAlternativNames!;
    expect(sans.length, 2);
    expect(sans.elementAt(0), '127.0.0.1');
    expect(sans.elementAt(1), '0.0.0.0');
  });

  test('Test x509CertificateFromPem with V1 X509', () {
    var data = X509Utils.x509CertificateFromPem(x509PemV1);
    expect(data.version, 1);

    expect(data.serialNumber.toString(),
        '206684696279472310254277870180966723415');

    expect(data.signatureAlgorithm, '1.2.840.113549.1.1.5');

    expect(data.issuer.containsKey('2.5.4.6'), true);
    expect(data.issuer['2.5.4.6'], 'US');
    expect(data.issuer.containsKey('2.5.4.10'), true);
    expect(data.issuer['2.5.4.10'], 'VeriSign, Inc.');
    expect(data.issuer.containsKey('2.5.4.3'), true);
    expect(data.issuer['2.5.4.3'],
        'VeriSign Class 3 Public Primary Certification Authority - G3');

    expect(
        data.validity.notBefore.toIso8601String(), '1999-10-01T00:00:00.000Z');
    expect(
        data.validity.notAfter.toIso8601String(), '2036-07-16T23:59:59.000Z');

    expect(data.subject.containsKey('2.5.4.3'), true);
    expect(data.subject['2.5.4.3'],
        'VeriSign Class 3 Public Primary Certification Authority - G3');

    expect(data.sha1Thumbprint, '132D0D45534B6997CDB2D5C339E25576609B5CC6');
    expect(data.md5Thumbprint, 'CD68B6A7C7C4CE75E01D4F5744619209');

    var publicKeyData = data.publicKeyData;

    expect(publicKeyData.length, 2048);
    expect(publicKeyData.sha1Thumbprint,
        '22F19E2EC6EACCFC5D2346F4C2E8F6C554DD5E07');
    expect(publicKeyData.algorithm, '1.2.840.113549.1.1.1');
    expect(publicKeyData.bytes,
        '30820122300D06092A864886F70D01010105000382010F003082010A0282010100CBBA9C52FC781F1A1E6F1B3773BDF8C96B9412304FF03647F5D0910AF517C8A561C116404DFB8A6190E57620C111067DAB2C6EA6F511418EFA2DAD2A6159A467264CD0E8BC525B70200458D17AC9A469BC831764AD058BBCD058CE8D8CF5EBF042490B9D972767326EE1AE93151C70BC204D2F18DE9288E86C8557111AE97EE3261154A245965583CA3089E8DCD8A3ED2A803F7F7965573E152066082F9593BFAA472FA84697F012E2FEC20A2B51E676E6B746B7E20DA6CCA8C34C595589E6E8535C1CEA9DF062160BA7C95F0CF0DEC276CEAFF76AF2FA41A6A23314C9E57A63D39E6237D585659E0EE65324741B5E1D12535BC72CE783493B15AE8A68B957970203010001');
  });

  test('Test x509CertificateFromPem with GeneralizedTime', () {
    var data = X509Utils.x509CertificateFromPem(x509PemWithGeneralizedTime);
    expect(data.version, 3);

    expect(data.serialNumber.toString(),
        '112324828676200291871926431888494945866');

    expect(data.signatureAlgorithm, '1.2.840.113549.1.1.5');

    expect(data.issuer.containsKey('2.5.4.6'), true);
    expect(data.issuer['2.5.4.6'], 'EE');
    expect(data.issuer.containsKey('2.5.4.10'), true);
    expect(data.issuer['2.5.4.10'], 'AS Sertifitseerimiskeskus');
    expect(data.issuer.containsKey('2.5.4.3'), true);
    expect(data.issuer['2.5.4.3'], 'EE Certification Centre Root CA');

    expect(
        data.validity.notBefore.toIso8601String(), '2010-10-30T10:10:30.000Z');
    expect(
        data.validity.notAfter.toIso8601String(), '2030-12-17T23:59:59.000Z');

    expect(data.subject.containsKey('2.5.4.3'), true);
    expect(data.subject['2.5.4.3'], 'EE Certification Centre Root CA');

    expect(data.sha1Thumbprint, 'C9A8B9E755805E58E35377A725EBAFC37B27CCD7');
    expect(data.md5Thumbprint, '435E88D47D1A4A7EFD842E52EB01D46F');

    var publicKeyData = data.publicKeyData;

    expect(publicKeyData.length, 2048);
    expect(publicKeyData.sha1Thumbprint,
        '30B8B08C3E820AD83B4F1F891EAB29C29C49E937');
    expect(publicKeyData.algorithm, '1.2.840.113549.1.1.1');
    expect(publicKeyData.bytes,
        '30820122300D06092A864886F70D01010105000382010F003082010A0282010100C820C0ECE0C54BAB077895F344EEFB0B0CFF748E61BBB162EA23D8ABA165327AEB8E174F96D80A7B91A2636CC78C4C2E79BFA905FC695C958D62F9B970EDC3517DD093E66CEB304BE1BC7DBF529BCE6E7B65F238B1C0A232EF62B268E06153C13695FFEC94BA36AE9C1CA7320FE57CB4C66F74FD7B18E8AC57ED06204B3230585BFDCDA8E6A1FC70BC8E9273DB97A77C21AE3DC1F548876C27BD9F25748155B0F775F63DA4646BD64FE7CE40AD0FDD32D3BC8A125398C989FB101D4D7ECD7E1F560D217085F620831FF6BA1F048FEA778835C4FFEA4EA18B4D3F631B44C344D42576CAB78DD71E4A6664CD5CC59C83E1C208889AEC4EA3F13E1C2CD96C1DA14B0203010001A3818A308187300F0603551D130101FF040530030101FF300E0603551D0F0101FF040403020106301D0603551D0E0416041412F25A3EEA561CBFCD06ACF1F125C9A94BD4149930450603551D25043E303C06082B0601050507030206082B0601050507030106082B0601050507030306082B0601050507030406082B0601050507030806082B06010505070309');
  });

  test('Test x509CertificateFromPem with TeletextString', () {
    var data = X509Utils.x509CertificateFromPem(x509PemWithTeletextString);
    expect(data.version, 3);

    expect(data.serialNumber.toString(), '946069240');

    expect(data.signatureAlgorithm, '1.2.840.113549.1.1.5');

    expect(data.issuer.containsKey('2.5.4.11'), true);
    expect(data.issuer['2.5.4.11'],
        'www.entrust.net/CPS_2048 incorp. by ref. (limits liab.)');
    expect(data.issuer.containsKey('2.5.4.10'), true);
    expect(data.issuer['2.5.4.10'], 'Entrust.net');
    expect(data.issuer.containsKey('2.5.4.3'), true);
    expect(
        data.issuer['2.5.4.3'], 'Entrust.net Certification Authority (2048)');

    expect(
        data.validity.notBefore.toIso8601String(), '1999-12-24T17:50:51.000Z');
    expect(
        data.validity.notAfter.toIso8601String(), '2029-07-24T14:15:12.000Z');

    expect(data.subject.containsKey('2.5.4.3'), true);
    expect(
        data.subject['2.5.4.3'], 'Entrust.net Certification Authority (2048)');

    expect(data.sha1Thumbprint, '503006091D97D4F5AE39F7CBE7927D7D652D3431');
    expect(data.md5Thumbprint, 'EE2931BC327E9AE6E8B5F751B4347190');

    var publicKeyData = data.publicKeyData;

    expect(publicKeyData.length, 2048);
    expect(publicKeyData.sha1Thumbprint,
        'BED60C6DD525D609CA1E3EE48C5D911EF0B95E0D');
    expect(publicKeyData.algorithm, '1.2.840.113549.1.1.1');
    expect(publicKeyData.bytes,
        '30820122300D06092A864886F70D01010105000382010F003082010A0282010100AD4D4BA91286B2EAA320071516642A2B4BD1BF0B4A4D8EED8076A567B77840C07342C868C0DB532BDD5EB8769835938B1A9D7C133A0E1F5BB71ECFE524141EB181A98D7DB8CC6B4B03F1020CDCABA54024007F7494A19D0829B3880BF587779D55CDE4C37ED76A64AB851486955B9732506F3DC8BA660CE3FCBDB849C176894919FDC0A8BD89A3672FC69FBC711960B82DE92CC99076667B94E2AF78D665535D3CD69CB2CF2903F92FA450B2D448CE0532558AFDB2644C0EE4980775DB7FDFB9085560853029F97B48A46986E3353F1E865D7A7A15BDEF008E1522541700902693BC0E496891BFF847D39D9542C10E4DDF6F26CFC3182162664370D6D5C007E10203010001A3423040300E0603551D0F0101FF040403020106300F0603551D130101FF040530030101FF301D0603551D0E0416041455E481D11180BED889B908A331F9A1240916B970');
  });

  test('Test x509CertificateFromPem without CN', () {
    var data = X509Utils.x509CertificateFromPem(certWithoutCN);
    expect(data.version, 3);

    expect(data.serialNumber.toString(), '419432078408221804846119');

    expect(data.signatureAlgorithm, '1.2.840.113549.1.1.11');

    expect(data.issuer['2.5.4.6'], 'NO');
    expect(data.issuer['2.5.4.10'], 'Buypass AS-983163327');
    expect(data.issuer['2.5.4.3'], 'Buypass Class 2 CA 5');

    expect(
        data.validity.notBefore.toIso8601String(), '2020-09-30T03:18:57.000Z');
    expect(
        data.validity.notAfter.toIso8601String(), '2021-03-29T21:59:00.000Z');

    expect(data.subject.isEmpty, true);

    expect(data.sha1Thumbprint, '60A66A69269C74F1DDD33EF3CD60E844716974A0');
    expect(data.md5Thumbprint, '29B4F34A5CA1B38A8329A20BFD714CEA');

    var publicKeyData = data.publicKeyData;

    expect(publicKeyData.length, 2048);
    expect(publicKeyData.sha1Thumbprint,
        'C836ECF35C878C7B51327ECE402641C7A06DF4DE');
    expect(publicKeyData.algorithm, '1.2.840.113549.1.1.1');
    expect(publicKeyData.bytes,
        '30820122300D06092A864886F70D01010105000382010F003082010A0282010100C762F36197CAB201EACC8495866301C0ECA2F8158BBE476BE05011F14D64493B831F612898CAAAD4B89A5F88FE379892405924A91167F401903C4FF82DE46AD337421675468FEE24387B971EB4F92D96DC1CBEAD525D47424AB359316A5ABF7E40BFACC4823D14AB49BEC36A4B90343CADA8CBF023705EEB42F9508B7EBF3213292FB35EBBBF0EC2BBE48D0398E6CACEF595C8F748DCA45736925F1D8A8074DDC040895FB6AAF0B8EC233C255F49F9A943F9164813E72CC5F82498CD4EBA51F9B3BC65E87A01C9D566B985F677E5602E0B13C3FF58F63897AFB731786664B23A70544A8C7ADBF93B2A26A53A45467B29D732D3085FF4F96A9567613F705A01F70203010001');
  });

  test('Test x509CertificateFromPem with selfsigned', () {
    var data = X509Utils.x509CertificateFromPem(selfSigned);
    expect(data.version, 3);

    expect(data.serialNumber.toString(), '10');

    expect(data.signatureAlgorithm, '1.2.840.113549.1.1.11');

    expect(data.issuer.containsKey('2.5.4.6'), true);
    expect(data.issuer['2.5.4.6'], 'RU');
    expect(data.issuer.containsKey('2.5.4.10'), true);
    expect(data.issuer['2.5.4.10'], 'Hikvision Digital Technology');
    expect(data.issuer.containsKey('2.5.4.3'), true);
    expect(data.issuer['2.5.4.3'], '94.198.131.55');

    expect(
        data.validity.notBefore.toIso8601String(), '2020-11-15T09:00:18.000Z');
    expect(
        data.validity.notAfter.toIso8601String(), '2030-11-15T09:00:18.000Z');

    expect(data.subject.containsKey('2.5.4.3'), true);
    expect(data.subject['2.5.4.3'], '94.198.131.55');

    expect(data.sha1Thumbprint, 'DD7B2CE1C8DA3568E2396EA86DCC6A2B4FB9B45B');
    expect(data.md5Thumbprint, 'C588B049D87D433BE5FC6E98481A88D2');

    var publicKeyData = data.publicKeyData;

    expect(publicKeyData.length, 2048);
    expect(publicKeyData.sha1Thumbprint,
        '7884BDE6157EF1F32E2CD346A39C696F3055C10E');
    expect(publicKeyData.algorithm, '1.2.840.113549.1.1.1');
    expect(publicKeyData.bytes,
        '30820120300D06092A864886F70D01010105000382010D00308201080282010100D8E1EAD54EC852F5FE0D09687A45B57FE9A873D057EA880E1BA952D447D9E23050099E730E12F184201C68809ADF48C7947B5C58D330F40905422D7D0A69E0C54F9CE27C3C7A52E7F10300E201C10CE74F94B307E63C7BAF42FDA992F1679CCDFD4D90A496F3F2D151048E14FCBF0A8B2A72D551E0DFA31238686B3ED8CCBB8B360A5F4F9B3F871BFF46BA7E27C87EAB2EC87D62732482431834D0ECA17010D9794CE83F0E6F0D065A26D83A5E1A354E19E4300F7B2A243D1D43D516A81FD96EDE71F625AA19E5D39F270AD47214941300FF6B454654C6D59CAD4737DF5911F41587316F872B1EAD85F1AF286F93CC61546B3504B64582E96B87CDDA5854E5B5020103');
  });

  test('Test x509CertificateFromPem with bigCert', () {
    var data = X509Utils.x509CertificateFromPem(bigCert);
    expect(data.version, 3);

    expect(data.serialNumber.toString(),
        '313802195999642166411276783379421068021');

    expect(data.signatureAlgorithm, '1.2.840.113549.1.1.11');

    expect(data.issuer.containsKey('2.5.4.6'), true);
    expect(data.issuer['2.5.4.6'], 'GB');
    expect(data.issuer.containsKey('2.5.4.10'), true);
    expect(data.issuer['2.5.4.10'], 'COMODO CA Limited');
    expect(data.issuer.containsKey('2.5.4.3'), true);
    expect(data.issuer['2.5.4.3'],
        'COMODO RSA Organization Validation Secure Server CA');
  });

  test('Test pkcs7FromPem', () {
    var data = X509Utils.pkcs7fromPem(pkcs7);
    expect(data.version, 1);
    expect(data.contentType, '1.2.840.113549.1.7.2');
    expect(data.certificates!.length, 3);
  });

  test('Test csrFromPem', () {
    var data = X509Utils.csrFromPem(csr);
    expect(data.version, 0);
    expect(data.subject!.length, 6);
    expect(data.signature,
        '00C2DF2669750DB60E9D403B37096EB64EACB8C992D050E440B5C58894242ACE45CBAADF36D57567C28BFF11AA033C8072E0172FED1C40C651B0D4DDF6C4F966B892CE88A4C1A78828EA11AA116A6CA5EA9616126E099552260A9BD1C8DF0FABCF267E257862457675646657C048C14AEF8D7BE48F135DA66252BEE3307180F4C332BBDBEF7422A87AA219CFE5E548F0172ACE52CAB91AD88C73A414FAB0108E3E88C7A2AA3B3248C7255D473382738EED4F7D1DDAD24425B0C71AEB5BA8B40546BEF1C7BB873FF2C68204C537C66CDAEF9C4313D116C22141DA43635305B4701A23CAFFB6565059FDDFBB815564C6F1AD84CC039730CFF4F1C1E30A593AE83797');
    expect(data.signatureAlgorithm, '1.2.840.113549.1.1.11');
    expect(data.signatureAlgorithmReadableName, 'sha256WithRSAEncryption');
    expect(data.publicKeyInfo!.algorithm, '1.2.840.113549.1.1.1');
    expect(data.publicKeyInfo!.algorithmReadableName, 'rsaEncryption');
    expect(data.publicKeyInfo!.length, 2048);
    expect(data.publicKeyInfo!.sha1Thumbprint,
        '8DC03E4113683C6D02E0254B523C09C4A175F392');
    expect(data.publicKeyInfo!.sha256Thumbprint,
        'F187E676386764D40A901E6157310BCDF59CF0336DBC9AF077122A23D687511F');
    expect(data.publicKeyInfo!.parameter, null);
    expect(data.publicKeyInfo!.parameterReadableName, null);
    expect(data.publicKeyInfo!.exponent, 65537);
  });

  test('Test csrFromPem with unused extension data', () {
    var data = X509Utils.csrFromPem(csrWithUnusedData);
    expect(data.version, 0);
    expect(data.subject!.length, 3);
    expect(data.signature,
        '0083BBF7316EBF666121A97D26ED8AB223511A16E58E81B5655C3F709362F9F4FFF2D64A9C33E369FB90AF798D7E243C8EB8D1220B95E6DADE0C9E9D91B1661740F1339E5E4788F5A23145409BF52DB3F71BDC0892B340DF43FA2CC06352A5523CD54EB6F0356EFA21D22A13D40C77E22DC12E1D8F9930BBB67BB403321B511959557FB9752A40B1F0603AACDB34DBC34C5883D65972D4C26BD1B1319C3FAD64EBA4DC59FEEC266A0FF0D73F5A7459D4631CEBADB1723F1177E7A01641AF41FE45FB99F3A7F54204E50B07D28A2CE924AFFD9D83BFC79E3C131CFDA8BB94799418D177EDFC91C6D87DCAF677CBBAA4C1020C6D5EBA08383466222DC9046A7C4237');
    expect(data.signatureAlgorithm, '1.2.840.113549.1.1.5');
    expect(data.signatureAlgorithmReadableName, 'sha1WithRSAEncryption');
    expect(data.publicKeyInfo!.algorithm, '1.2.840.113549.1.1.1');
    expect(data.publicKeyInfo!.algorithmReadableName, 'rsaEncryption');
    expect(data.publicKeyInfo!.length, 2048);
    expect(data.publicKeyInfo!.sha1Thumbprint,
        'C509365EAEBF0D94D21C6A909934248FA9C83211');
    expect(data.publicKeyInfo!.sha256Thumbprint,
        '5A8D60DF5194F22D4AF24D820C6A88ADBA7B1ED0B351C63B18B9231A46E87622');
    expect(data.publicKeyInfo!.parameter, null);
    expect(data.publicKeyInfo!.parameterReadableName, null);
  });

  test('Test csrFromPem with Sans', () {
    var data = X509Utils.csrFromPem(csrWithSans);
    expect(data.version, 0);
    expect(data.subject!.length, 5);
    expect(data.signature,
        '0085460994DCF7799E8D0CF11143AA13200FBD049939BC7020212D0137009A169CD651D7B29122BFBB454223304533AEFBF1FDA6FC8FC7FAEA52D571E200A1B02FFAFD3FC293976453846D036BD534CD5E8DBC4CCEFE98938E8B49A7529931065BC37C1A67978D3C7175AAD1E136AAF548872D1E403CA2F61CE9C5CEE822A9D151585BFBF88B0F20CEF57768F09CEE875E874EC68D7B96C1EF9ABA463A8E0741EA2EF12072EB81195053A3EE311163796525FFE7A8954CF5E60F92D671B48827EC26E9FB6CCB88EB9EF2C6C2744FAD468D2B3B3B83EB7729704D1CBADC8D4196F830DD7FBE9056EFF7A38D89ABCC398426B2933BA9E21A12CE1D10130F18CCDFE3');
    expect(data.signatureAlgorithm, '1.2.840.113549.1.1.11');
    expect(data.signatureAlgorithmReadableName, 'sha256WithRSAEncryption');
    expect(data.publicKeyInfo!.algorithm, '1.2.840.113549.1.1.1');
    expect(data.publicKeyInfo!.algorithmReadableName, 'rsaEncryption');
    expect(data.publicKeyInfo!.length, 2048);
    expect(data.publicKeyInfo!.sha1Thumbprint,
        'D65AA43092DFC48A20E0443B14227AA14051C5F1');
    expect(data.publicKeyInfo!.sha256Thumbprint,
        '90D6AB3BBDB0BBD54C596363CCBAA49319C03F8B8A0F2833837EEB4BB54805D4');
    expect(data.publicKeyInfo!.parameter, null);
    expect(data.publicKeyInfo!.parameterReadableName, null);
    expect(data.extensions!.subjectAlternativNames!.length, 2);
    expect(data.extensions!.subjectAlternativNames!.elementAt(0),
        'san1.basic-utils.dev');
    expect(data.extensions!.subjectAlternativNames!.elementAt(1),
        'san2.basic-utils.dev');
  });

  test('Test csrFromPem with ECC', () {
    var data = X509Utils.csrFromPem(eccCsr);
    expect(data.version, 0);
    expect(data.subject!.length, 6);
    expect(data.signature,
        '0030440220177CF182F4BE88FB448B8DACFAB1A88D579884CC277B1452D4C704BF365752DE02206C6B76047F01BD2B0F43C60C37E69DFCB16474FBBF6605690A457FF79D0D5379');
    expect(data.signatureAlgorithm, '1.2.840.10045.4.3.2');
    expect(data.signatureAlgorithmReadableName, 'ecdsaWithSHA256');
    expect(data.publicKeyInfo!.algorithm, '1.2.840.10045.2.1');
    expect(data.publicKeyInfo!.algorithmReadableName, 'ecPublicKey');
    expect(data.publicKeyInfo!.length, 520);
    expect(data.publicKeyInfo!.sha1Thumbprint,
        'EEE9267F9374C82BCA1173623468503C5AE3A24E');
    expect(data.publicKeyInfo!.sha256Thumbprint,
        'CBAC34F18B6EE4970B45C4028FF5F2EEBF0E62AC79C8FD131DE305C49F9728FF');
    expect(data.publicKeyInfo!.parameter, '1.2.840.10045.3.1.7');
    expect(data.publicKeyInfo!.parameterReadableName, 'prime256v1');
  });

  test('Test buildOCSPRequest', () {
/*
SEQUENCE (1 elem)
  SEQUENCE (1 elem)
    SEQUENCE (1 elem)
      SEQUENCE (1 elem)
        SEQUENCE (4 elem)
          SEQUENCE (2 elem)
            OBJECT IDENTIFIER 1.3.14.3.2.26 sha1 (OIW)
            NULL
          OCTET STRING (20 byte) 9C4C7115C30219CA36DCB98B2133004CA4A78ED3
          OCTET STRING (20 byte) DDB3E76DA82EE8C54E6ECF74E6753C9415CEE81D
          INTEGER (95 bit) 34541435456031998754652058411
*/

    var data = X509Utils.buildOCSPRequest(oscpEnd, intermediate: ocspInter);
    var base = base64.encode(data.encode());
    expect(base,
        'ME0wSzBJMEcwRTAJBgUrDgMCGgUABBScTHEVwwIZyjbcuYshMwBMpKeO0wQU3bPnbagu6MVObs905nU8lBXO6B0CDG+cAXgcIYAyJUpzKw==');

    data = X509Utils.buildOCSPRequest(pkcs7);
    base = base64.encode(data.encode());
    expect(base,
        'MFEwTzBNMEswSTAJBgUrDgMCGgUABBQWO4uRaz/kv87G7gglaT+Q+Z+LpwQU5wIjgABP2Ne8lAvZP3Q5STI8inkCEAOXfkvt618n0tfQb5veKgk=');
  });

  test('Test getOCSPUrl', () {
    var data = X509Utils.getOCSPUrl(oscpEnd);
    expect(data, 'http://ocsp2.globalsign.com/gsextendvalsha2g3r3');

    data = X509Utils.getOCSPUrl(pkcs7);
    expect(data, 'http://ocsp.digicert.com');
  });

  test('Test parseOCSPResponse', () {
    var bytes = base64.decode(ocspResponse);
    var data = X509Utils.parseOCSPResponse(bytes);
    expect(data.responseStatus, OCSPResponseStatus.SUCCESSFUL);
    var responseData = data.basicOCSPResponse!.responseData;
    expect(responseData!.singleResponse.length, 1);
    var certStatus = responseData.singleResponse.elementAt(0).certStatus;
    expect(certStatus.status, OCSPCertStatusValues.GOOD);

    bytes = base64.decode(ocspResponse2);
    data = X509Utils.parseOCSPResponse(bytes);
    expect(data.responseStatus, OCSPResponseStatus.SUCCESSFUL);
    responseData = data.basicOCSPResponse!.responseData;
    expect(responseData!.singleResponse.length, 1);
    certStatus = responseData.singleResponse.elementAt(0).certStatus;
    expect(certStatus.status, OCSPCertStatusValues.REVOKED);
    expect(certStatus.status, OCSPCertStatusValues.REVOKED);
    expect(certStatus.revocationTime!.toIso8601String(),
        '2021-05-02T19:21:46.000Z');

    bytes = base64.decode(ocspResponse3);
    data = X509Utils.parseOCSPResponse(bytes);
    expect(data.responseStatus, OCSPResponseStatus.UNAUTHORIZED);
  });

  test('Test getModulusFromRSACsrPem', () {
    var modulus = X509Utils.getModulusFromRSACsrPem(
      csr,
    );
    expect(modulus.toRadixString(16).toUpperCase(),
        'D105F87BCA002A90FDD5E28A2CBFC476B1F4D8DFD4960DF96DD0894A8CC7B9B9E80C6ED95E210B4C5B8F0C034D986E079B1554A47BF5BB1995ADBCC40A7A81044CE32D6E4D696D93F54EF8002A36DC798315026A89317F69515C7C4CCAC075ED65E5550AB5D4E4C12F9C58C3AC43AB819205778E801254ADFC853A77ACCA465171EA962007AE263D6DCBE74B0DAE0E8E36409F5EDEC74F9BB67EDCE8FE23F9AA2E3506DCC9524D9D4BD0EC91BC1E43C9AFE0A46CB636B08A841FD908DEC3F96069549FE55E581055A7BC72C2875E7F2F06CDE59E843742ACEE2D2091E7CA7E0FBBC9D77B794E231CA866135E4A6EEE7DB96812F5CB302788E65CF3EABA4BAC65');
  });

  test('Test getModulusFromRSAX509Pem', () {
    var modulus = X509Utils.getModulusFromRSAX509Pem(
      x509Pem,
    );
    expect(modulus.toRadixString(16).toUpperCase(),
        'C31AFEFEDA8432456BC502DED4C6D010241EB36A37A0CEB96F2CB678F8F86126DEB06920D6E883D5EC7E2E22F80BDDC1CFEBC02401397ED9F5B40843F2DA2DEF3B6ED50EDC4CA76A1393F21D3ED55B36D641B2378588D573AFB65A0FACF4BB8D562C441B477E029A559B820CDADD24B4B6F3D70F4D982690F3FD09B8DE1CF49BE489D0869EB0033B6F5B536E6942C60DEB9BE095894F704EC23D794BCE099223292DC4DCC55C449653082699329F0930A72D01EE01F7446E9C66E9BEC62F5A8E16E1440C142558719A78EC515E59C527AB1D379EB49D3F72C410F71E3D5B11C4F781A6DB19CDBCBD59FED273650DCD36521A3CF196922D81776C8CBE07891FD5');
  });

  test('Test x509CertificateFromPem with IPv6 Sans', () {
    var data = X509Utils.x509CertificateFromPem(X509WithIpv6Sans);
    var sans = data.subjectAlternativNames!;
    expect(sans.length, 14);
    expect(sans.elementAt(0), 'centos7.hq.ferrari-electronic.de');
    expect(sans.elementAt(1), 'centos7');
    expect(sans.elementAt(12), '10.1.1.12');
    expect(sans.elementAt(13), '2a00:0000:1100:0001:ffff:0000:0000:0012');
  });

  test('Test pemToPkcs7', () {
    var data = X509Utils.pkcs7fromPem(openSslPkcs7);
    var certPems = <String>[];
    data.certificates!.forEach((element) {
      certPems.add(element.plain!);
    });

    var pkcs7 = X509Utils.pemToPkcs7(certPems);
    expect(pkcs7, openSslPkcs7);
  });

  test('Test generateSelfSignedCertificate', () {
    var pair = CryptoUtils.generateRSAKeyPair();
    var dn = {
      'CN': 'basic-utils.dev',
      'O': 'Magic Company',
      'L': 'Fäkecity',
      'S': 'FakeState',
      'C': 'DE',
    };
    var csr = X509Utils.generateRsaCsrPem(
        dn, pair.privateKey as RSAPrivateKey, pair.publicKey as RSAPublicKey,
        san: ['san1.basic-utils.dev', 'san2.basic-utils.dev']);
    var pem = X509Utils.generateSelfSignedCertificate(
      pair.privateKey,
      csr,
      365,
      sans: ['san1.basic-utils.dev', 'san2.basic-utils.dev'],
      extKeyUsage: [ExtendedKeyUsage.SERVER_AUTH, ExtendedKeyUsage.CLIENT_AUTH],
    );

    var x509 = X509Utils.x509CertificateFromPem(pem);
    var expectedDn = {
      '2.5.4.3': 'basic-utils.dev',
      '2.5.4.10': 'Magic Company',
      '2.5.4.7': 'Fäkecity',
      '2.5.4.8': 'FakeState',
      '2.5.4.6': 'DE'
    };
    expect(x509.subject, expectedDn);
    expect(x509.issuer, expectedDn);
    expect(x509.subjectAlternativNames!.elementAt(0), 'san1.basic-utils.dev');
    expect(x509.subjectAlternativNames!.elementAt(1), 'san2.basic-utils.dev');
    expect(x509.extKeyUsage!.elementAt(0), ExtendedKeyUsage.SERVER_AUTH);
    expect(x509.extKeyUsage!.elementAt(1), ExtendedKeyUsage.CLIENT_AUTH);

    pem = X509Utils.generateSelfSignedCertificate(pair.privateKey, csr, 365,
        sans: [
          'san1.basic-utils.dev',
          'san2.basic-utils.dev'
        ],
        extKeyUsage: [
          ExtendedKeyUsage.SERVER_AUTH,
          ExtendedKeyUsage.CLIENT_AUTH
        ],
        issuer: {
          'CN': 'foobar.dev',
          'O': 'Magic Company',
          'L': 'Fäkecity',
          'S': 'FakeState',
          'C': 'DE',
        });
  });

  test('Test generateSelfSignedCertificate with ECC', () {
    var pair = CryptoUtils.generateEcKeyPair();
    var dn = {
      'CN': 'basic-utils.dev',
      'O': 'Magic Company',
      'L': 'Fakecity',
      'S': 'FakeState',
      'C': 'DE',
    };
    var csr = X509Utils.generateEccCsrPem(
        dn, pair.privateKey as ECPrivateKey, pair.publicKey as ECPublicKey,
        san: ['san1.basic-utils.dev', 'san2.basic-utils.dev']);

    var pem = X509Utils.generateSelfSignedCertificate(
      pair.privateKey,
      csr,
      365,
      sans: ['san1.basic-utils.dev', 'san2.basic-utils.dev'],
      keyUsage: [
        KeyUsage.DIGITAL_SIGNATURE,
        KeyUsage.DATA_ENCIPHERMENT,
        KeyUsage.DECIPHER_ONLY
      ],
      extKeyUsage: [ExtendedKeyUsage.SERVER_AUTH, ExtendedKeyUsage.CLIENT_AUTH],
    );
    var x509 = X509Utils.x509CertificateFromPem(pem);
    var expectedDn = {
      '2.5.4.3': 'basic-utils.dev',
      '2.5.4.10': 'Magic Company',
      '2.5.4.7': 'Fakecity',
      '2.5.4.8': 'FakeState',
      '2.5.4.6': 'DE'
    };
    expect(x509.subject, expectedDn);
    expect(x509.issuer, expectedDn);
    expect(x509.subjectAlternativNames!.elementAt(0), 'san1.basic-utils.dev');
    expect(x509.subjectAlternativNames!.elementAt(1), 'san2.basic-utils.dev');
    expect(x509.extKeyUsage!.elementAt(0), ExtendedKeyUsage.SERVER_AUTH);
    expect(x509.extKeyUsage!.elementAt(1), ExtendedKeyUsage.CLIENT_AUTH);
    expect(x509.tbsCertificate?.extensions?.keyUsage?.elementAt(0),
        KeyUsage.DIGITAL_SIGNATURE);
    expect(x509.tbsCertificate?.extensions?.keyUsage?.elementAt(1),
        KeyUsage.DATA_ENCIPHERMENT);
    expect(x509.tbsCertificate?.extensions?.keyUsage?.elementAt(2),
        KeyUsage.DECIPHER_ONLY);
  });

  test('Test x509CertificateFromPem with vmc', () {
    var data = X509Utils.x509CertificateFromPem(vmc);

    expect(data.extensions!.vmc!.base64Logo,
        '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');
    expect(data.extensions!.vmc!.type, 'image/svg+xml');
    expect(
        data.extensions!.vmc!.hash, '71D54CAFCF07722637B036DF45BECF9254DAE0EA');
    expect(data.extensions!.vmc!.hashAlgorithm, '1.3.14.3.2.26');
    expect(data.extensions!.vmc!.hashAlgorithmReadable, 'SHA1');

    expect(data.extensions!.vmc!.getFullSvgData(),
        'data:image/svg+xml;base64,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');
  });

  test('Test parseChainStringAsString', () {
    var data = X509Utils.parseChainStringAsString(certificateChain1);

    expect(data.length, 3);
    expect(data.elementAt(0).startsWith(X509Utils.BEGIN_CERT), true);
    expect(data.elementAt(0).endsWith(X509Utils.END_CERT), true);
    expect(data.elementAt(1).startsWith(X509Utils.BEGIN_CERT), true);
    expect(data.elementAt(1).endsWith(X509Utils.END_CERT), true);
    expect(data.elementAt(2).startsWith(X509Utils.BEGIN_CERT), true);
    expect(data.elementAt(2).endsWith(X509Utils.END_CERT), true);
  });

  test('Test parseChainString', () {
    var data = X509Utils.parseChainString(certificateChain1);
    expect(data.length, 3);
  });

  test('Test csrFromPem with constructed sans', () {
    var data = X509Utils.csrFromPem(csrWithConstructedSans);
    expect(data.extensions!.subjectAlternativNames!.length, 1);
    expect(data.extensions!.subjectAlternativNames!.elementAt(0),
        'DirName:/SN=1-TST|2-TST|3-ed22f1d8-e6a2-1118-9b58-d9a8f11e445f/UID=312345678900003/title=1111/registeredAddress=TST/businessCategory=TST');
  });

  test('Test crlDataFromPem()', () {
    var f = File('test_resources/RapidSSLTLSRSACAG1.pem');
    var pem = f.readAsStringSync();
    var data = X509Utils.crlDataFromPem(pem);
    var tbsCertList = data.tbsCertList;
    expect(tbsCertList!.version, 1);
    expect(tbsCertList.issuer!.length, 4);
    expect(
        tbsCertList.thisUpdate!.toIso8601String(), '2022-07-17T08:17:38.000Z');
    expect(
        tbsCertList.nextUpdate!.toIso8601String(), '2022-07-24T08:17:38.000Z');
    expect(tbsCertList.revokedCertificates!.length, 408);
    var revoked = tbsCertList.revokedCertificates!.elementAt(0);
    expect(revoked.serialNumber!.toRadixString(16).toUpperCase(),
        '1293146B5A10E6C3B1FCB2C14D8C441');
    expect(
        revoked.revocationDate!.toIso8601String(), '2020-04-29T21:11:33.000Z');
    expect(revoked.extensions!.reason, CrlReason.cessationOfOperation);
  });

  test('Test crlDerToPem()', () {
    var f = File('test_resources/RapidSSLTLSRSACAG1.pem');
    var pem = f.readAsStringSync();

    var f1 = File('test_resources/RapidSSLTLSRSACAG1.crl');
    var der = f1.readAsBytesSync();
    var data = X509Utils.crlDerToPem(der);

    expect(data, pem);
  });

  test('Test checkCsrSignature()', () {
    var pair = CryptoUtils.generateRSAKeyPair();
    var dn = {'CN': 'basic-utils.dev'};
    var pem = X509Utils.generateRsaCsrPem(
      dn,
      pair.privateKey as RSAPrivateKey,
      pair.publicKey as RSAPublicKey,
    );
    var data = X509Utils.checkCsrSignature(pem);
    expect(data, true);

    var ecPair = CryptoUtils.generateEcKeyPair();
    var ecPem = X509Utils.generateEccCsrPem(
      dn,
      ecPair.privateKey as ECPrivateKey,
      ecPair.publicKey as ECPublicKey,
    );
    data = X509Utils.checkCsrSignature(ecPem);
    expect(data, true);

    data = X509Utils.checkCsrSignature(rsaPssSignature);
    expect(data, true);
  });

  test('Test checkX509Signature()', () {
    var data = X509Utils.pkcs7fromPem(pkcs7);
    var endCertificate = data.certificates!.elementAt(0).plain!;
    var parentCertificate = data.certificates!.elementAt(1).plain!;
    var check = X509Utils.checkX509Signature(
      endCertificate,
      parent: parentCertificate,
    );
    expect(check, true);

    check = X509Utils.checkX509Signature(
      x509Pem,
      parent: digiCertGlobalRootG3,
    );
    expect(check, false);

    check = X509Utils.checkX509Signature(
      x509Pem,
      parent: digiCertGlobalRootG2,
    );
    expect(check, false);
  });

  test('Test checkX509Signature2()', () {
    var f = File('test_resources/github_com_cert_chain.pem');
    var pem = f.readAsStringSync();
    var chain = X509Utils.parseChainString(pem);
    var endCertificate = chain.elementAt(0).plain!;
    var intermediate = chain.elementAt(1).plain!;
    var root = chain.elementAt(2).plain!;
    var check = X509Utils.checkX509Signature(
      endCertificate,
      parent: intermediate,
    );
    expect(check, true);

    check = X509Utils.checkX509Signature(
      intermediate,
      parent: root,
    );
    expect(check, true);
  });

  test('Test fixPem()', () {
    var data = X509Utils.fixPem(brokenPEM);
    expect(data, fixedPem);

    data = X509Utils.fixPem(brokenPEM2);
    expect(data, fixedPem2);

    data = X509Utils.fixPem(brokenPEM3);
    expect(data, fixedPem3);
  });

  test('Test checkChain()', () {
    var data = X509Utils.pkcs7fromPem(pkcs7);
    var result = X509Utils.checkChain(data.certificates!);
    expect(result.pairs!.length, 2);
    expect(result.pairs!.elementAt(0).isValid(), true);
    expect(result.pairs!.elementAt(1).isValid(), true);

    var f = File('test_resources/rapid_ssl_broken_chain.pem');
    var pem = f.readAsStringSync();
    var chain = X509Utils.parseChainString(pem);
    result = X509Utils.checkChain(chain);
    expect(result.pairs!.length, 1);
    expect(result.pairs!.elementAt(0).isValid(), false);
    expect(result.pairs!.elementAt(0).dnDataMatch, true);
    expect(result.pairs!.elementAt(0).signatureMatch, false);
  });

  test('Test csrFromPem with multiValue', () {
    var data = X509Utils.csrFromPem(multiValueDnCsr);
    expect(data.subject!.length, 5);
    expect(data.subject!.containsKey('2.5.4.6'), true);
    expect(data.subject!['2.5.4.6'], 'DE');

    expect(data.subject!.containsKey('2.5.4.8'), true);
    expect(data.subject!['2.5.4.8'], 'BY');
    expect(data.subject!.containsKey('2.5.4.3'), true);
    expect(data.subject!['2.5.4.3'], 'example.com');
    expect(data.subject!.containsKey('2.5.4.10'), true);
    expect(data.subject!['2.5.4.10'], 'Example Org');
    expect(data.subject!.containsKey('2.5.4.7'), true);
    expect(data.subject!['2.5.4.7'], 'Example City');
  });
}
