///
/// The public suffix list maintained by Mozzilla at Github.
/// https://github.com/publicsuffix/list/blob/master/public_suffix_list.dat
///
/// A 'public suffix' is one under which Internet users can (or historically
/// could) directly register names. Some examples of public suffixes are .com,
/// .co.uk and pvt.k12.ma.us. The Public Suffix List is a list of all known
/// public suffixes.
///
/// See https://publicsuffix.org/ for more information.
///
final Map<String, List<String>> suffixList = {
  '公司': [],
  'qpon': [],
  'comsec': [],
  'lego': [],
  'virgin': [],
  'ไทย': [],
  'tel': [],
  'pics': [],
  'xn--55qx5d': [],
  'energy': [],
  'gle': [],
  'ferrari': [],
  'click': [],
  'latino': [],
  'redstone': [],
  'wine': [],
  'xn--80aqecdr1a': [],
  'arab': [],
  '天主教': [],
  'weir': [],
  'ceb': [],
  'glade': [],
  'hosting': ['opencraft', 'opencraft'],
  'theguardian': [],
  'xn--ogbpf8fl': [],
  'gmo': [],
  'infiniti': [],
  'ceo': [],
  'gold': [],
  'skype': [],
  'golf': [],
  'gmx': [],
  'cfa': [],
  'flir': [],
  'cfd': [],
  'xn--ngbc5azd': [],
  'xn--c2br7g': [],
  'xn--80ao21a': [],
  'creditunion': [],
  'thd': [],
  'sale': [],
  'spreadbetting': [],
  'blue': [],
  'pfizer': [],
  '淡马锡': [],
  'surgery': [],
  'taipei': [],
  'broadway': [],
  'goo': [],
  'gop': [],
  'got': [],
  'rsvp': [],
  'gov': [],
  'analytics': [],
  'miami': [],
  'imdb': [],
  'xn--1qqw23a': [],
  'viajes': [],
  'السعوديه': [],
  '中文网': [],
  'eurovision': [],
  'pay': [],
  'lasalle': [],
  'ventures': [],
  'claims': [],
  'alfaromeo': [],
  'tjx': [],
  'بھارت': [],
  'اتصالات': [],
  '组织机构': [],
  'samsung': [],
  'xn--mix891f': [],
  'maserati': [],
  'liaison': [],
  'live': [],
  '大众汽车': [],
  'lefrak': [],
  'السعودیۃ': [],
  'hoteles': [],
  'realty': [],
  'sexy': [],
  'schwarz': [],
  'mobile': [],
  '香格里拉': [],
  'room': [],
  'goog': [],
  'tjmaxx': [],
  'coffee': [],
  'sapo': [],
  'कॉम': [],
  'mobily': [],
  'lancome': [],
  'genting': [],
  'xn--45brj9c': [],
  'السعودیة': [],
  'xerox': [],
  'channel': [],
  'pioneer': [],
  'schmidt': [],
  'airtel': [],
  'pet': [],
  'africa': [],
  'xn--kput3i': [],
  'intel': [],
  'sydney': [],
  '政府': [],
  'المغرب': [],
  'mattel': [],
  'coach': [],
  'sarl': [],
  'pink': [],
  'ping': [],
  'save': [],
  'protection': [],
  'aero': [
    'accident-investigation',
    'accident-prevention',
    'aerobatic',
    'aeroclub',
    'aerodrome',
    'agents',
    'aircraft',
    'airline',
    'airport',
    'air-surveillance',
    'airtraffic',
    'air-traffic-control',
    'ambulance',
    'amusement',
    'association',
    'author',
    'ballooning',
    'broker',
    'caa',
    'cargo',
    'catering',
    'certification',
    'championship',
    'charter',
    'civilaviation',
    'club',
    'conference',
    'consultant',
    'consulting',
    'control',
    'council',
    'crew',
    'design',
    'dgca',
    'educator',
    'emergency',
    'engine',
    'engineer',
    'entertainment',
    'equipment',
    'exchange',
    'express',
    'federation',
    'flight',
    'freight',
    'fuel',
    'gliding',
    'government',
    'groundhandling',
    'group',
    'hanggliding',
    'homebuilt',
    'insurance',
    'journal',
    'journalist',
    'leasing',
    'logistics',
    'magazine',
    'maintenance',
    'media',
    'microlight',
    'modelling',
    'navigation',
    'parachuting',
    'paragliding',
    'passenger-association',
    'pilot',
    'press',
    'production',
    'recreation',
    'repbody',
    'res',
    'research',
    'rotorcraft',
    'safety',
    'scientist',
    'services',
    'show',
    'skydiving',
    'software',
    'student',
    'trader',
    'trading',
    'trainer',
    'union',
    'workinggroup',
    'works',
    'accident-investigation',
    'accident-prevention',
    'aerobatic',
    'aeroclub',
    'aerodrome',
    'agents',
    'aircraft',
    'airline',
    'airport',
    'air-surveillance',
    'airtraffic',
    'air-traffic-control',
    'ambulance',
    'amusement',
    'association',
    'author',
    'ballooning',
    'broker',
    'caa',
    'cargo',
    'catering',
    'certification',
    'championship',
    'charter',
    'civilaviation',
    'club',
    'conference',
    'consultant',
    'consulting',
    'control',
    'council',
    'crew',
    'design',
    'dgca',
    'educator',
    'emergency',
    'engine',
    'engineer',
    'entertainment',
    'equipment',
    'exchange',
    'express',
    'federation',
    'flight',
    'freight',
    'fuel',
    'gliding',
    'government',
    'groundhandling',
    'group',
    'hanggliding',
    'homebuilt',
    'insurance',
    'journal',
    'journalist',
    'leasing',
    'logistics',
    'magazine',
    'maintenance',
    'media',
    'microlight',
    'modelling',
    'navigation',
    'parachuting',
    'paragliding',
    'passenger-association',
    'pilot',
    'press',
    'production',
    'recreation',
    'repbody',
    'res',
    'research',
    'rotorcraft',
    'safety',
    'scientist',
    'services',
    'show',
    'skydiving',
    'software',
    'student',
    'trader',
    'trading',
    'trainer',
    'union',
    'workinggroup',
    'works'
  ],
  'dabur': [],
  'السعودية': [],
  'xn--80aswg': [],
  'top': [],
  'lancia': [],
  'இலங்கை': [],
  'tiaa': [],
  'walter': [],
  'haus': [],
  'barclaycard': [],
  'cheap': [],
  'xn--czrs0t': [],
  'phd': [],
  'kaufen': [],
  'industries': [],
  'xxx': [],
  'dunlop': [],
  'com': [
    '*.compute.amazonaws',
    '*.compute-1.amazonaws',
    'us-east-1.amazonaws',
    '*.elasticbeanstalk',
    '*.elb.amazonaws',
    '*.s3.amazonaws',
    's3-ap-northeast-1.amazonaws',
    's3-ap-northeast-2.amazonaws',
    's3-ap-south-1.amazonaws',
    's3-ap-southeast-1.amazonaws',
    's3-ap-southeast-2.amazonaws',
    's3-ca-central-1.amazonaws',
    's3-eu-central-1.amazonaws',
    's3-eu-west-1.amazonaws',
    's3-external-1.amazonaws',
    's3-fips-us-gov-west-1.amazonaws',
    's3-sa-east-1.amazonaws',
    's3-us-gov-west-1.amazonaws',
    's3-us-east-2.amazonaws',
    's3-us-west-1.amazonaws',
    's3-us-west-2.amazonaws',
    's3.ap-northeast-2.amazonaws',
    's3.ap-south-1.amazonaws',
    's3.ca-central-1.amazonaws',
    's3.eu-central-1.amazonaws',
    's3.us-east-2.amazonaws',
    's3.dualstack.ap-northeast-1.amazonaws',
    's3.dualstack.ap-northeast-2.amazonaws',
    's3.dualstack.ap-south-1.amazonaws',
    's3.dualstack.ap-southeast-1.amazonaws',
    's3.dualstack.ap-southeast-2.amazonaws',
    's3.dualstack.ca-central-1.amazonaws',
    's3.dualstack.eu-central-1.amazonaws',
    's3.dualstack.eu-west-1.amazonaws',
    's3.dualstack.sa-east-1.amazonaws',
    's3.dualstack.us-east-1.amazonaws',
    's3.dualstack.us-east-2.amazonaws',
    's3-website-us-east-1.amazonaws',
    's3-website-us-west-1.amazonaws',
    's3-website-us-west-2.amazonaws',
    's3-website-ap-northeast-1.amazonaws',
    's3-website-ap-southeast-1.amazonaws',
    's3-website-ap-southeast-2.amazonaws',
    's3-website-eu-west-1.amazonaws',
    's3-website-sa-east-1.amazonaws',
    's3-website.ap-northeast-2.amazonaws',
    's3-website.ap-south-1.amazonaws',
    's3-website.ca-central-1.amazonaws',
    's3-website.eu-central-1.amazonaws',
    's3-website.us-east-2.amazonaws',
    'on-aptible',
    'myasustor',
    'betainabox',
    'ar',
    'br',
    'cn',
    'de',
    'eu',
    'gb',
    'hu',
    'jpn',
    'kr',
    'mex',
    'no',
    'qc',
    'ru',
    'sa',
    'se',
    'uk',
    'us',
    'uy',
    'za',
    'africa',
    'gr',
    'co',
    'xenapponazure',
    'cloudcontrolled',
    'cloudcontrolapp',
    'dreamhosters',
    'mydrobo',
    'dyndns-at-home',
    'dyndns-at-work',
    'dyndns-blog',
    'dyndns-free',
    'dyndns-home',
    'dyndns-ip',
    'dyndns-mail',
    'dyndns-office',
    'dyndns-pics',
    'dyndns-remote',
    'dyndns-server',
    'dyndns-web',
    'dyndns-wiki',
    'dyndns-work',
    'blogdns',
    'cechire',
    'dnsalias',
    'dnsdojo',
    'doesntexist',
    'dontexist',
    'doomdns',
    'dyn-o-saur',
    'dynalias',
    'est-a-la-maison',
    'est-a-la-masion',
    'est-le-patron',
    'est-mon-blogueur',
    'from-ak',
    'from-al',
    'from-ar',
    'from-ca',
    'from-ct',
    'from-dc',
    'from-de',
    'from-fl',
    'from-ga',
    'from-hi',
    'from-ia',
    'from-id',
    'from-il',
    'from-in',
    'from-ks',
    'from-ky',
    'from-ma',
    'from-md',
    'from-mi',
    'from-mn',
    'from-mo',
    'from-ms',
    'from-mt',
    'from-nc',
    'from-nd',
    'from-ne',
    'from-nh',
    'from-nj',
    'from-nm',
    'from-nv',
    'from-oh',
    'from-ok',
    'from-or',
    'from-pa',
    'from-pr',
    'from-ri',
    'from-sc',
    'from-sd',
    'from-tn',
    'from-tx',
    'from-ut',
    'from-va',
    'from-vt',
    'from-wa',
    'from-wi',
    'from-wv',
    'from-wy',
    'getmyip',
    'gotdns',
    'hobby-site',
    'homelinux',
    'homeunix',
    'iamallama',
    'is-a-anarchist',
    'is-a-blogger',
    'is-a-bookkeeper',
    'is-a-bulls-fan',
    'is-a-caterer',
    'is-a-chef',
    'is-a-conservative',
    'is-a-cpa',
    'is-a-cubicle-slave',
    'is-a-democrat',
    'is-a-designer',
    'is-a-doctor',
    'is-a-financialadvisor',
    'is-a-geek',
    'is-a-green',
    'is-a-guru',
    'is-a-hard-worker',
    'is-a-hunter',
    'is-a-landscaper',
    'is-a-lawyer',
    'is-a-liberal',
    'is-a-libertarian',
    'is-a-llama',
    'is-a-musician',
    'is-a-nascarfan',
    'is-a-nurse',
    'is-a-painter',
    'is-a-personaltrainer',
    'is-a-photographer',
    'is-a-player',
    'is-a-republican',
    'is-a-rockstar',
    'is-a-socialist',
    'is-a-student',
    'is-a-teacher',
    'is-a-techie',
    'is-a-therapist',
    'is-an-accountant',
    'is-an-actor',
    'is-an-actress',
    'is-an-anarchist',
    'is-an-artist',
    'is-an-engineer',
    'is-an-entertainer',
    'is-certified',
    'is-gone',
    'is-into-anime',
    'is-into-cars',
    'is-into-cartoons',
    'is-into-games',
    'is-leet',
    'is-not-certified',
    'is-slick',
    'is-uberleet',
    'is-with-theband',
    'isa-geek',
    'isa-hockeynut',
    'issmarterthanyou',
    'likes-pie',
    'likescandy',
    'neat-url',
    'saves-the-whales',
    'selfip',
    'sells-for-less',
    'sells-for-u',
    'servebbs',
    'simple-url',
    'space-to-rent',
    'teaches-yoga',
    'writesthisblog',
    'eu-1.evennode',
    'eu-2.evennode',
    'us-1.evennode',
    'us-2.evennode',
    'apps.fbsbx',
    'firebaseapp',
    'flynnhub',
    'freebox-os',
    'freeboxos',
    'githubusercontent',
    'githubcloud',
    '*.api.githubcloud',
    '*.ext.githubcloud',
    'gist.githubcloud',
    '*.githubcloudusercontent',
    'ro',
    '*.0emm',
    'appspot',
    'blogspot',
    'codespot',
    'googleapis',
    'googlecode',
    'pagespeedmobilizer',
    'publishproxy',
    'withgoogle',
    'withyoutube',
    'herokuapp',
    'herokussl',
    '*.cns.joyent',
    'meteorapp',
    'eu.meteorapp',
    '4u',
    'nfshost',
    'blogsyte',
    'ciscofreak',
    'damnserver',
    'ditchyourip',
    'dnsiskinky',
    'dynns',
    'geekgalaxy',
    'health-carereform',
    'homesecuritymac',
    'homesecuritypc',
    'myactivedirectory',
    'mysecuritycamera',
    'net-freaks',
    'onthewifi',
    'point2this',
    'quicksytes',
    'securitytactics',
    'serveexchange',
    'servehumour',
    'servep2p',
    'servesarcasm',
    'stufftoread',
    'unusualperson',
    'workisboring',
    '3utilities',
    'ddnsking',
    'myvnc',
    'servebeer',
    'servecounterstrike',
    'serveftp',
    'servegame',
    'servehalflife',
    'servehttp',
    'serveirc',
    'servemp3',
    'servepics',
    'servequake',
    'operaunite',
    'outsystemscloud',
    'ownprovider',
    'pgfog',
    'pagefrontapp',
    'gotpantheon',
    'xen.prgmr',
    'qa2',
    'dev-myqnapcloud',
    'alpha-myqnapcloud',
    'myqnapcloud',
    'rackmaze',
    'rhcloud',
    'logoip',
    'firewall-gateway',
    'myshopblocks',
    '1kapp',
    'appchizi',
    'applinzi',
    'sinaapp',
    'vipsinaapp',
    'bounty-full',
    'alpha.bounty-full',
    'beta.bounty-full',
    'dsmynas',
    'familyds',
    'bloxcms',
    'townnews-staging',
    'hk',
    'yolasite',
    '*.compute.amazonaws',
    '*.compute-1.amazonaws',
    'us-east-1.amazonaws',
    '*.elasticbeanstalk',
    '*.elb.amazonaws',
    '*.s3.amazonaws',
    's3-ap-northeast-1.amazonaws',
    's3-ap-northeast-2.amazonaws',
    's3-ap-south-1.amazonaws',
    's3-ap-southeast-1.amazonaws',
    's3-ap-southeast-2.amazonaws',
    's3-ca-central-1.amazonaws',
    's3-eu-central-1.amazonaws',
    's3-eu-west-1.amazonaws',
    's3-external-1.amazonaws',
    's3-fips-us-gov-west-1.amazonaws',
    's3-sa-east-1.amazonaws',
    's3-us-gov-west-1.amazonaws',
    's3-us-east-2.amazonaws',
    's3-us-west-1.amazonaws',
    's3-us-west-2.amazonaws',
    's3.ap-northeast-2.amazonaws',
    's3.ap-south-1.amazonaws',
    's3.ca-central-1.amazonaws',
    's3.eu-central-1.amazonaws',
    's3.us-east-2.amazonaws',
    's3.dualstack.ap-northeast-1.amazonaws',
    's3.dualstack.ap-northeast-2.amazonaws',
    's3.dualstack.ap-south-1.amazonaws',
    's3.dualstack.ap-southeast-1.amazonaws',
    's3.dualstack.ap-southeast-2.amazonaws',
    's3.dualstack.ca-central-1.amazonaws',
    's3.dualstack.eu-central-1.amazonaws',
    's3.dualstack.eu-west-1.amazonaws',
    's3.dualstack.sa-east-1.amazonaws',
    's3.dualstack.us-east-1.amazonaws',
    's3.dualstack.us-east-2.amazonaws',
    's3-website-us-east-1.amazonaws',
    's3-website-us-west-1.amazonaws',
    's3-website-us-west-2.amazonaws',
    's3-website-ap-northeast-1.amazonaws',
    's3-website-ap-southeast-1.amazonaws',
    's3-website-ap-southeast-2.amazonaws',
    's3-website-eu-west-1.amazonaws',
    's3-website-sa-east-1.amazonaws',
    's3-website.ap-northeast-2.amazonaws',
    's3-website.ap-south-1.amazonaws',
    's3-website.ca-central-1.amazonaws',
    's3-website.eu-central-1.amazonaws',
    's3-website.us-east-2.amazonaws',
    'on-aptible',
    'myasustor',
    'betainabox',
    'ar',
    'br',
    'cn',
    'de',
    'eu',
    'gb',
    'hu',
    'jpn',
    'kr',
    'mex',
    'no',
    'qc',
    'ru',
    'sa',
    'se',
    'uk',
    'us',
    'uy',
    'za',
    'africa',
    'gr',
    'co',
    'xenapponazure',
    'cloudcontrolled',
    'cloudcontrolapp',
    'dreamhosters',
    'mydrobo',
    'dyndns-at-home',
    'dyndns-at-work',
    'dyndns-blog',
    'dyndns-free',
    'dyndns-home',
    'dyndns-ip',
    'dyndns-mail',
    'dyndns-office',
    'dyndns-pics',
    'dyndns-remote',
    'dyndns-server',
    'dyndns-web',
    'dyndns-wiki',
    'dyndns-work',
    'blogdns',
    'cechire',
    'dnsalias',
    'dnsdojo',
    'doesntexist',
    'dontexist',
    'doomdns',
    'dyn-o-saur',
    'dynalias',
    'est-a-la-maison',
    'est-a-la-masion',
    'est-le-patron',
    'est-mon-blogueur',
    'from-ak',
    'from-al',
    'from-ar',
    'from-ca',
    'from-ct',
    'from-dc',
    'from-de',
    'from-fl',
    'from-ga',
    'from-hi',
    'from-ia',
    'from-id',
    'from-il',
    'from-in',
    'from-ks',
    'from-ky',
    'from-ma',
    'from-md',
    'from-mi',
    'from-mn',
    'from-mo',
    'from-ms',
    'from-mt',
    'from-nc',
    'from-nd',
    'from-ne',
    'from-nh',
    'from-nj',
    'from-nm',
    'from-nv',
    'from-oh',
    'from-ok',
    'from-or',
    'from-pa',
    'from-pr',
    'from-ri',
    'from-sc',
    'from-sd',
    'from-tn',
    'from-tx',
    'from-ut',
    'from-va',
    'from-vt',
    'from-wa',
    'from-wi',
    'from-wv',
    'from-wy',
    'getmyip',
    'gotdns',
    'hobby-site',
    'homelinux',
    'homeunix',
    'iamallama',
    'is-a-anarchist',
    'is-a-blogger',
    'is-a-bookkeeper',
    'is-a-bulls-fan',
    'is-a-caterer',
    'is-a-chef',
    'is-a-conservative',
    'is-a-cpa',
    'is-a-cubicle-slave',
    'is-a-democrat',
    'is-a-designer',
    'is-a-doctor',
    'is-a-financialadvisor',
    'is-a-geek',
    'is-a-green',
    'is-a-guru',
    'is-a-hard-worker',
    'is-a-hunter',
    'is-a-landscaper',
    'is-a-lawyer',
    'is-a-liberal',
    'is-a-libertarian',
    'is-a-llama',
    'is-a-musician',
    'is-a-nascarfan',
    'is-a-nurse',
    'is-a-painter',
    'is-a-personaltrainer',
    'is-a-photographer',
    'is-a-player',
    'is-a-republican',
    'is-a-rockstar',
    'is-a-socialist',
    'is-a-student',
    'is-a-teacher',
    'is-a-techie',
    'is-a-therapist',
    'is-an-accountant',
    'is-an-actor',
    'is-an-actress',
    'is-an-anarchist',
    'is-an-artist',
    'is-an-engineer',
    'is-an-entertainer',
    'is-certified',
    'is-gone',
    'is-into-anime',
    'is-into-cars',
    'is-into-cartoons',
    'is-into-games',
    'is-leet',
    'is-not-certified',
    'is-slick',
    'is-uberleet',
    'is-with-theband',
    'isa-geek',
    'isa-hockeynut',
    'issmarterthanyou',
    'likes-pie',
    'likescandy',
    'neat-url',
    'saves-the-whales',
    'selfip',
    'sells-for-less',
    'sells-for-u',
    'servebbs',
    'simple-url',
    'space-to-rent',
    'teaches-yoga',
    'writesthisblog',
    'eu-1.evennode',
    'eu-2.evennode',
    'us-1.evennode',
    'us-2.evennode',
    'apps.fbsbx',
    'firebaseapp',
    'flynnhub',
    'freebox-os',
    'freeboxos',
    'githubusercontent',
    'githubcloud',
    '*.api.githubcloud',
    '*.ext.githubcloud',
    'gist.githubcloud',
    '*.githubcloudusercontent',
    'ro',
    '*.0emm',
    'appspot',
    'blogspot',
    'codespot',
    'googleapis',
    'googlecode',
    'pagespeedmobilizer',
    'publishproxy',
    'withgoogle',
    'withyoutube',
    'herokuapp',
    'herokussl',
    '*.cns.joyent',
    'meteorapp',
    'eu.meteorapp',
    '4u',
    'nfshost',
    'blogsyte',
    'ciscofreak',
    'damnserver',
    'ditchyourip',
    'dnsiskinky',
    'dynns',
    'geekgalaxy',
    'health-carereform',
    'homesecuritymac',
    'homesecuritypc',
    'myactivedirectory',
    'mysecuritycamera',
    'net-freaks',
    'onthewifi',
    'point2this',
    'quicksytes',
    'securitytactics',
    'serveexchange',
    'servehumour',
    'servep2p',
    'servesarcasm',
    'stufftoread',
    'unusualperson',
    'workisboring',
    '3utilities',
    'ddnsking',
    'myvnc',
    'servebeer',
    'servecounterstrike',
    'serveftp',
    'servegame',
    'servehalflife',
    'servehttp',
    'serveirc',
    'servemp3',
    'servepics',
    'servequake',
    'operaunite',
    'outsystemscloud',
    'ownprovider',
    'pgfog',
    'pagefrontapp',
    'gotpantheon',
    'xen.prgmr',
    'qa2',
    'dev-myqnapcloud',
    'alpha-myqnapcloud',
    'myqnapcloud',
    'rackmaze',
    'rhcloud',
    'logoip',
    'firewall-gateway',
    'myshopblocks',
    '1kapp',
    'appchizi',
    'applinzi',
    'sinaapp',
    'vipsinaapp',
    'bounty-full',
    'alpha.bounty-full',
    'beta.bounty-full',
    'dsmynas',
    'familyds',
    'bloxcms',
    'townnews-staging',
    'hk',
    'yolasite'
  ],
  'capital': [],
  'xn--mgbayh7gpa': [],
  'xn--nnx388a': [],
  'banamex': [],
  'pid': [],
  'xn--fiq228c5hs': [],
  'mopar': [],
  'pin': [],
  'jetzt': [],
  'xyz': ['fhapp', 'fhapp'],
  'xn--mk1bu44c': [],
  'lat': [],
  'law': [],
  'wales': [],
  'christmas': [],
  'army': [],
  'ggee': [],
  'xn--wgbh1c': [],
  'markets': [],
  'xn--y9a3aq': [],
  'bingo': [],
  'gucci': [],
  'trv': [],
  'university': [],
  'arpa': [
    'e164',
    'in-addr',
    'ip6',
    'iris',
    'uri',
    'urn',
    'e164',
    'in-addr',
    'ip6',
    'iris',
    'uri',
    'urn'
  ],
  'xn--wgbl6a': [],
  'design': [],
  'imamat': [],
  'land': [
    'static',
    'dev.static',
    'sites.static',
    'static',
    'dev.static',
    'sites.static'
  ],
  'alipay': [],
  'crs': [],
  'whoswho': [],
  'پاكستان': [],
  'warman': [],
  'doctor': [],
  'saxo': [],
  'csc': [],
  'flickr': [],
  'immo': [],
  'lds': [],
  'productions': [],
  '网址': [],
  'hyatt': [],
  'walmart': [],
  'عرب': [],
  'tui': [],
  'xn--pssy2u': [],
  'supply': [],
  'shriram': [],
  '家電': [],
  'docs': [],
  'wolterskluwer': [],
  '商店': [],
  'press': [],
  'events': [],
  'honeywell': [],
  'bible': [],
  'pnc': [],
  'xn--fzys8d69uvgm': [],
  'tvs': [],
  'caseih': [],
  'wang': [],
  'jprs': [],
  'circle': [],
  'xn--mgb9awbf': [],
  'olayan': [],
  'giving': [],
  'chase': [],
  'onyourside': [],
  'arte': [],
  'juegos': [],
  'xn--rovu88b': [],
  'richardli': [],
  'kitchen': [],
  'gives': [],
  'dodge': [],
  'consulting': [],
  'foodnetwork': [],
  'services': [],
  'team': [],
  'فلسطين': [],
  'ismaili': [],
  'marketing': [],
  'aarp': [],
  'xn--45q11c': [],
  'watch': [],
  'fashion': [],
  'insurance': [],
  'бел': [],
  'voting': [],
  'secure': [],
  'ieee': [],
  'school': [],
  'homes': [],
  'xn--mgbaam7a8h': [],
  'xn--mgberp4a5d4ar': [],
  'tech': [],
  'glass': [],
  'xn--55qw42g': [],
  'ايران': [],
  'pro': [
    'aaa',
    'aca',
    'acct',
    'avocat',
    'bar',
    'cpa',
    'eng',
    'jur',
    'law',
    'med',
    'recht',
    'cloudns',
    'aaa',
    'aca',
    'acct',
    'avocat',
    'bar',
    'cpa',
    'eng',
    'jur',
    'law',
    'med',
    'recht',
    'cloudns'
  ],
  'คอม': [],
  'futbol': [],
  'ubank': [],
  'pru': [],
  'aramco': [],
  'auspost': [],
  'hbo': [],
  'page': [],
  'hsbc': [],
  'xn--czr694b': [],
  'cards': [],
  'voto': [],
  'farmers': [],
  'video': [],
  'house': [],
  'xn--fct429k': [],
  '公益': [],
  'קום': [],
  'lexus': [],
  'lixil': [],
  'vote': [],
  'xn--mgbtx2b': [],
  'xn--6frz82g': [],
  'center': [],
  'doha': [],
  'windows': [],
  'engineer': [],
  'etisalat': [],
  'lifestyle': [],
  'xn--gckr3f0f': [],
  'frontdoor': [],
  'calvinklein': [],
  'fund': [],
  'hotels': [],
  'xn--mgbab2bd': [],
  'pramerica': [],
  'ladbrokes': [],
  'pub': [],
  'buzz': [],
  'finance': [],
  'studio': [],
  'xn--s9brj9c': [],
  'erni': [],
  'abbvie': [],
  'komatsu': [],
  'tips': [],
  'xn--vermgensberater-ctb': [],
  'xn--efvy88h': [],
  'bananarepublic': [],
  'gallery': [],
  'flowers': [],
  'omega': [],
  'مليسيا': [],
  'webcam': [],
  'xn--kprw13d': [],
  'pwc': [],
  'lol': [],
  'solar': [],
  'xn--3oq18vl8pn36a': [],
  'xn--vhquv': [],
  'smart': [],
  'xn--80asehdb': [],
  'computer': [],
  'frogans': [],
  'ferrero': [],
  'yachts': [],
  'شبكة': [],
  'blackfriday': [],
  'corsica': [],
  'holdings': [],
  'rocher': [],
  'commbank': [],
  'hamburg': [],
  'prod': [],
  'lpl': [],
  'prof': [],
  'chintai': [],
  'tennis': [],
  'xn--mgba7c0bbn0a': [],
  'airbus': [],
  'chat': [],
  'garden': [],
  'travel': [],
  'dad': [],
  'ubs': [],
  '한국': [],
  'oldnavy': [],
  'дети': [],
  'praxi': [],
  'hiv': [],
  'maison': [],
  'zone': ['*.triton', '*.triton'],
  'audible': [],
  'day': [],
  'group': [],
  'jewelry': [],
  'helsinki': [],
  '珠宝': [],
  'xn--8y0a063a': [],
  'condos': [],
  'nadex': [],
  'xn--fiq64b': [],
  'pars': [],
  'عمان': [],
  'rightathome': [],
  'bayern': [],
  'bike': [],
  'hkt': [],
  'afamilycompany': [],
  'hospital': [],
  'xn--mgbai9azgqp6j': [],
  'ltd': [],
  'firestone': [],
  'ලංකා': [],
  'xn--fiqz9s': [],
  'dds': [],
  'xn--54b7fta0cc': [],
  'xn--ygbi2ammx': [],
  'build': [],
  '新加坡': [],
  'redumbrella': [],
  'bugatti': [],
  'asda': [],
  'tushu': [],
  'xn--3ds443g': [],
  'xn--cg4bki': [],
  'dev': [],
  'coupons': [],
  'dental': [],
  'stada': [],
  'fiat': [],
  'beer': [],
  'you': [],
  'prime': [],
  'active': [],
  'abbott': [],
  'deals': [],
  'adult': [],
  'compare': [],
  'xn--xkc2al3hye2a': [],
  'xn--4gbrim': [],
  'hot': [],
  'investments': [],
  'how': [],
  'mint': [],
  'xn--mgbx4cd0ab': [],
  '書籍': [],
  'xn--fiqs8s': [],
  'wedding': [],
  'sohu': [],
  '我爱你': [],
  'latrobe': [],
  'yokohama': [],
  'business': [],
  'mini': [],
  'xn--kpu716f': [],
  'dhl': [],
  'shoes': [],
  'bing': [],
  'meet': [],
  'williamhill': [],
  'xn--q9jyb4c': [],
  'ikano': [],
  'london': [],
  'accountant': [],
  'قطر': [],
  'moscow': [],
  'xn--nqv7fs00ema': [],
  'sener': [],
  'netbank': [],
  'abogado': [],
  'diy': [],
  'club': ['cloudns', 'cloudns'],
  'legal': [],
  'بازار': [],
  'talk': [],
  'info': [
    'cloudns',
    'dynamic-dns',
    'dyndns',
    'barrel-of-knowledge',
    'barrell-of-knowledge',
    'for-our',
    'groks-the',
    'groks-this',
    'here-for-more',
    'knowsitall',
    'selfip',
    'webhop',
    'nsupdate',
    'dvrcam',
    'ilovecollege',
    'no-ip',
    'cloudns',
    'dynamic-dns',
    'dyndns',
    'barrel-of-knowledge',
    'barrell-of-knowledge',
    'for-our',
    'groks-the',
    'groks-this',
    'here-for-more',
    'knowsitall',
    'selfip',
    'webhop',
    'nsupdate',
    'dvrcam',
    'ilovecollege',
    'no-ip'
  ],
  'fido': [],
  'орг': [],
  'xn--w4rs40l': [],
  'vision': [],
  'final': [],
  'toyota': [],
  'abudhabi': [],
  'loan': [],
  'xn--estv75g': [],
  'training': [],
  'schaeffler': [],
  'xn--hxt814e': [],
  'yun': [],
  'htc': [],
  'exposed': [],
  'company': [],
  'symantec': [],
  'భారత్': [],
  'kyoto': [],
  'asia': ['cloudns', 'cloudns'],
  '时尚': [],
  'teva': [],
  'cyou': [],
  'uno': [],
  'baby': [],
  'xn--tckwe': [],
  'عراق': [],
  'meme': [],
  'rehab': [],
  'discount': [],
  'sony': [],
  'uol': [],
  'москва': [],
  'supplies': [],
  'chloe': [],
  'song': [],
  'boutique': [],
  'dnp': [],
  'xn--5su34j936bgsg': [],
  'hiphop': [],
  'bosch': [],
  'tienda': [],
  'anquan': [],
  'ups': [],
  'baseball': [],
  'capitalone': [],
  'dog': [],
  'jaguar': [],
  'xn--t60b56a': [],
  'trading': [],
  'hyundai': [],
  'dot': [],
  'skin': [],
  '政务': [],
  'stream': [],
  'montblanc': [],
  'toray': [],
  'man': [],
  'map': [],
  'dupont': [],
  'ком': [],
  'health': [],
  'menu': [],
  'quebec': [],
  'mba': [],
  'kerryhotels': [],
  'able': [],
  'bradesco': [],
  'goldpoint': [],
  'codes': [],
  'maif': [],
  'casino': [],
  'kpmg': [],
  'mcd': [],
  'radio': [],
  'smile': [],
  'ricoh': [],
  'nextdirect': [],
  'reviews': [],
  'host': [],
  'credit': [],
  'international': [],
  'merckmsd': [],
  'fujitsu': [],
  'loft': [],
  '网站': [],
  'equipment': [],
  'movistar': [],
  'film': [],
  'mormon': [],
  'dentist': [],
  'հայ': [],
  'bridgestone': [],
  'telefonica': [],
  'weber': [],
  'nexus': [],
  'best': [],
  'fidelity': [],
  'xn--xhq521b': [],
  'med': [],
  'godaddy': [],
  'nikon': [],
  'meo': [],
  'men': [],
  'piaget': [],
  'shangrila': [],
  '谷歌': [],
  'xn--l1acc': [],
  'dtv': [],
  'xn--3pxu8k': [],
  'mango': [],
  'orange': [],
  'caravan': [],
  'accenture': [],
  'blanco': [],
  'online': [],
  'xn--io0a7i': [],
  'properties': [],
  'zippo': [],
  'blockbuster': [],
  'dclk': [],
  'theatre': [],
  'observer': [],
  'bank': [],
  'சிங்கப்பூர்': [],
  'akdn': [],
  'fire': [],
  'band': [],
  'volkswagen': [],
  'melbourne': [],
  'alibaba': [],
  'dvr': [],
  'sandvik': [],
  'xn--lgbbat1ad8j': [],
  'taxi': [],
  'homedepot': [],
  'dwg': [],
  'xn--xkc2dl3a5ee0h': [],
  '新闻': [],
  'global': [],
  'mil': [],
  'boots': [],
  'mit': [],
  'free': [],
  'ભારત': [],
  'barclays': [],
  'xperia': [],
  'associates': [],
  'star': [],
  'xn--3bst00m': [],
  'संगठन': [],
  'ibm': [],
  'alsace': [],
  'fish': [],
  'guge': [],
  'xn--mgbt3dhd': [],
  'open': [],
  'сайт': [],
  'seven': [],
  'ice': [],
  'xn--9dbq2a': [],
  'コム': [],
  'bharti': [],
  'xn--mgbpl2fh': [],
  'icu': [],
  'tiffany': [],
  'mlb': [],
  'mutuelle': [],
  'solutions': [],
  'ελ': [],
  'plumbing': [],
  '一号店': [],
  'mls': [],
  'ruhr': [],
  'ею': [],
  'cartier': [],
  'mma': [],
  'edeka': [],
  'jpmorgan': [],
  'esurance': [],
  'rodeo': [],
  'auction': [],
  'apple': [],
  'koeln': [],
  'العليان': [],
  'укр': [],
  'organic': [],
  'qvc': [],
  'passagens': [],
  'xn--cck2b3b': [],
  'beats': [],
  'rentals': [],
  'موقع': [],
  'ifm': [],
  'telecity': [],
  'xn--kcrx77d1x4a': [],
  'money': [],
  'fage': [],
  'catering': [],
  'moe': [],
  'aetna': [],
  'moi': [],
  'mom': [],
  '工行': [],
  'politie': [],
  'mov': [],
  'safety': [],
  'jeep': [],
  'games': [],
  'azure': [],
  'staples': [],
  'zip': [],
  '嘉里大酒店': [],
  'work': [],
  'ابوظبي': [],
  'भारत': [],
  'xn--c1avg': [],
  'okinawa': [],
  'fail': [],
  'forsale': [],
  'tattoo': [],
  'xn--90a3ac': [
    'xn--o1ac',
    'xn--c1avg',
    'xn--90azh',
    'xn--d1at',
    'xn--o1ach',
    'xn--80au'
  ],
  'lgbt': [],
  'love': [],
  'osaka': [],
  'church': [],
  'hisamitsu': [],
  'republican': [],
  'foundation': [],
  'pictures': [],
  'mortgage': [],
  'nico': [],
  'eat': [],
  '中信': [],
  'academy': [],
  'hockey': [],
  'agency': [],
  'coupon': [],
  'guitars': [],
  'pohl': [],
  'msd': [],
  'guru': [],
  '机构': [],
  'tours': [],
  'space': ['stackspace', 'stackspace'],
  'eco': [],
  'basketball': [],
  'xn--p1acf': [],
  'امارات': [],
  'theater': [],
  'xn--g2xx48c': [],
  'gmbh': [],
  'онлайн': [],
  'viking': [],
  'discover': [],
  'ਭਾਰਤ': [],
  'lotte': [],
  'vet': [],
  'monash': [],
  '香港': [],
  'mtn': [],
  'lotto': [],
  'mtr': [],
  'kddi': [],
  'travelers': [],
  'kuokgroup': [],
  'edu': [],
  'repair': [],
  'tickets': [],
  'नेट': [],
  'insure': [],
  'citic': [],
  'network': ['*.alces', '*.alces'],
  '食品': [],
  'lacaixa': [],
  'ing': [],
  'xn--mgbai9a5eva00b': [],
  'ink': [],
  'xn--mxtq1m': [],
  '삼성': [],
  'int': ['eu', 'eu'],
  'ভারত': [],
  'fans': [],
  'hgtv': [],
  'trade': ['ybo', 'ybo'],
  'locus': [],
  'xn--vuq861b': [],
  'scot': [],
  'xn--zfr164b': [],
  '移动': [],
  'рф': [],
  'landrover': [],
  'scor': [],
  'saarland': [],
  'cruises': [],
  '電訊盈科': [],
  'statoil': [],
  'ollo': [],
  'vig': [],
  'barcelona': [],
  'farm': [],
  'vin': [],
  'vip': [],
  'xn--pgbs0dh': [],
  'motorcycles': [],
  'google': [],
  'community': [],
  'lighting': [],
  'ltda': [],
  'science': ['ybo', 'ybo'],
  'fujixerox': [],
  'institute': [],
  'vista': [],
  'aaa': [],
  'boston': [],
  'uconnect': [],
  'xn--b4w605ferd': [],
  'porn': [],
  'cisco': [],
  'abb': [],
  'winners': [],
  'website': [],
  'abc': [],
  'nike': [],
  'xn--11b4c3d': [],
  'photo': [],
  'xn--fjq720a': [],
  'sling': [],
  'xn--gecrj9c': [],
  'fast': [],
  'ericsson': [],
  'panasonic': [],
  'schule': [],
  'grocery': [],
  'lease': [],
  'volvo': [],
  '佛山': [],
  '台湾': [],
  'tatar': [],
  'ist': [],
  'aco': [],
  'red': [],
  'avianca': [],
  'rmit': [],
  'post': [],
  'duck': [],
  'fitness': [],
  'everbank': [],
  'florist': [],
  'ren': [],
  'kindle': [],
  'bostik': [],
  'gifts': [],
  'clinique': [],
  'itv': [],
  'ads': [],
  'mutual': [],
  'ninja': [],
  'shell': [],
  'pharmacy': [],
  'exchange': [],
  'trust': [],
  'aeg': [],
  'epson': [],
  'directory': [],
  '集团': [],
  'hangout': [],
  'dating': [],
  'afl': [],
  'rich': [],
  'forum': [],
  'linde': [],
  'emerck': [],
  'iwc': [],
  'lundbeck': [],
  'spiegel': [],
  'progressive': [],
  'airforce': [],
  'family': [],
  'college': [],
  'gift': [],
  'career': [],
  'education': [],
  'movie': [],
  'nab': [],
  'ril': [],
  'католик': [],
  'property': [],
  'rip': [],
  'rio': [],
  'xn--mgbaakc7dvf': [],
  'woodside': [],
  'swiss': [],
  'موبايلي': [],
  'scjohnson': [],
  'xn--j6w193g': [],
  'nba': [],
  'spot': [],
  'catholic': [],
  'xn--czru2d': [],
  'aig': [],
  'كاثوليك': [],
  '诺基亚': [],
  'city': [],
  'agakhan': [],
  'holiday': [],
  'healthcare': [],
  'xn--h2brj9c': [],
  'mobi': ['dscloud', 'dscloud'],
  'wanggou': [],
  '微博': [],
  '网店': [],
  'lplfinancial': [],
  'sharp': [],
  'xn--fpcrj9c3d': [],
  'yodobashi': [],
  'citi': [],
  'xn--mgba3a4fra': [],
  'shaw': [],
  'esq': [],
  'xn--mgba3a4f16a': [],
  'nec': [],
  'pccw': [],
  'hermes': [],
  'net': [
    '*.alwaysdata',
    'cloudfront',
    't3l3p0rt',
    'myfritz',
    'gb',
    'hu',
    'jp',
    'se',
    'uk',
    'in',
    'cdn77-ssl',
    'r.cdn77',
    'feste-ip',
    'knx-server',
    'static-access',
    '*.cryptonomic',
    'at-band-camp',
    'blogdns',
    'broke-it',
    'buyshouses',
    'dnsalias',
    'dnsdojo',
    'does-it',
    'dontexist',
    'dynalias',
    'dynathome',
    'endofinternet',
    'from-az',
    'from-co',
    'from-la',
    'from-ny',
    'gets-it',
    'ham-radio-op',
    'homeftp',
    'homeip',
    'homelinux',
    'homeunix',
    'in-the-band',
    'is-a-chef',
    'is-a-geek',
    'isa-geek',
    'kicks-ass',
    'office-on-the',
    'podzone',
    'scrapper-site',
    'selfip',
    'sells-it',
    'servebbs',
    'serveftp',
    'thruhere',
    'webhop',
    'dynv6',
    'a.ssl.fastly',
    'b.ssl.fastly',
    'global.ssl.fastly',
    'a.prod.fastly',
    'global.prod.fastly',
    'cloudfunctions',
    'azurewebsites',
    'azure-mobile',
    'cloudapp',
    'eating-organic',
    'mydissent',
    'myeffect',
    'mymediapc',
    'mypsx',
    'mysecuritycamera',
    'nhlfan',
    'no-ip',
    'pgafan',
    'privatizehealthinsurance',
    'bounceme',
    'ddns',
    'redirectme',
    'serveblog',
    'serveminecraft',
    'sytes',
    'rackmaze',
    'firewall-gateway',
    'dsmynas',
    'familyds',
    'za',
    '*.alwaysdata',
    'cloudfront',
    't3l3p0rt',
    'myfritz',
    'gb',
    'hu',
    'jp',
    'se',
    'uk',
    'in',
    'cdn77-ssl',
    'r.cdn77',
    'feste-ip',
    'knx-server',
    'static-access',
    '*.cryptonomic',
    'at-band-camp',
    'blogdns',
    'broke-it',
    'buyshouses',
    'dnsalias',
    'dnsdojo',
    'does-it',
    'dontexist',
    'dynalias',
    'dynathome',
    'endofinternet',
    'from-az',
    'from-co',
    'from-la',
    'from-ny',
    'gets-it',
    'ham-radio-op',
    'homeftp',
    'homeip',
    'homelinux',
    'homeunix',
    'in-the-band',
    'is-a-chef',
    'is-a-geek',
    'isa-geek',
    'kicks-ass',
    'office-on-the',
    'podzone',
    'scrapper-site',
    'selfip',
    'sells-it',
    'servebbs',
    'serveftp',
    'thruhere',
    'webhop',
    'dynv6',
    'a.ssl.fastly',
    'b.ssl.fastly',
    'global.ssl.fastly',
    'a.prod.fastly',
    'global.prod.fastly',
    'cloudfunctions',
    'azurewebsites',
    'azure-mobile',
    'cloudapp',
    'eating-organic',
    'mydissent',
    'myeffect',
    'mymediapc',
    'mypsx',
    'mysecuritycamera',
    'nhlfan',
    'no-ip',
    'pgafan',
    'privatizehealthinsurance',
    'bounceme',
    'ddns',
    'redirectme',
    'serveblog',
    'serveminecraft',
    'sytes',
    'rackmaze',
    'firewall-gateway',
    'dsmynas',
    'familyds',
    'za'
  ],
  'new': [],
  'sakura': [],
  'read': [],
  '网络': [],
  'estate': ['*.compute', '*.compute'],
  'domains': [],
  'mcdonalds': [],
  'moda': [],
  'careers': [],
  'cafe': [],
  'versicherung': [],
  'villas': [],
  'nfl': [],
  'eus': ['user.party', 'user.party'],
  'deloitte': [],
  'financial': [],
  'media': [],
  'prudential': [],
  'shiksha': [],
  'goodhands': [],
  'kosher': [],
  'vodka': [],
  'xn--gk3at1e': [],
  'ngo': [],
  'today': [],
  'construction': [],
  'xn--mgbi4ecexp': [],
  'vermögensberatung': [],
  'frontier': [],
  'sucks': [],
  'tunes': [],
  'bofa': [],
  'marriott': [],
  'xn--jvr189m': [],
  'xn--4gq48lf9j': [],
  'xn--node': [],
  'anz': [],
  'nhk': [],
  'singles': [],
  'xn--vermgensberatung-pwb': [],
  'aol': [],
  'statebank': [],
  '世界': [],
  'hotmail': [],
  'nowruz': [],
  'gallo': [],
  'java': [],
  'shia': [],
  'dance': [],
  'tmall': [],
  'shopping': [],
  'app': [],
  'xn--90ais': [],
  'juniper': [],
  'xn--ngbrx': [],
  'cern': [],
  'zappos': [],
  '娱乐': [],
  'سورية': [],
  'سوريا': [],
  'duns': [],
  'xn--mgbb9fbpob': [],
  'photography': [],
  'გე': [],
  'xn--mix082f': [],
  'jcb': [],
  'xn--p1ai': [],
  'taobao': [],
  'weibo': [],
  'jcp': [],
  '联通': [],
  'xn--nqv7f': [],
  'art': [],
  'black': [],
  'xbox': [],
  'broker': [],
  'call': [],
  'lincoln': [],
  'partners': [],
  '台灣': [],
  'macys': [],
  'hdfc': [],
  'run': [],
  'microsoft': [],
  'realtor': [],
  'cymru': [],
  'furniture': [],
  'كوم': [],
  'mitsubishi': [],
  'otsuka': [],
  'courses': [],
  'watches': [],
  'クラウド': [],
  'town': [],
  'bloomberg': [],
  'physio': [],
  'ایران': [],
  'americanfamily': [],
  'boats': [],
  'engineering': [],
  'reit': [],
  'northwesternmutual': [],
  'itau': [],
  'camp': [],
  'gripe': [],
  'museum': [
    'academy',
    'agriculture',
    'air',
    'airguard',
    'alabama',
    'alaska',
    'amber',
    'ambulance',
    'american',
    'americana',
    'americanantiques',
    'americanart',
    'amsterdam',
    'and',
    'annefrank',
    'anthro',
    'anthropology',
    'antiques',
    'aquarium',
    'arboretum',
    'archaeological',
    'archaeology',
    'architecture',
    'art',
    'artanddesign',
    'artcenter',
    'artdeco',
    'arteducation',
    'artgallery',
    'arts',
    'artsandcrafts',
    'asmatart',
    'assassination',
    'assisi',
    'association',
    'astronomy',
    'atlanta',
    'austin',
    'australia',
    'automotive',
    'aviation',
    'axis',
    'badajoz',
    'baghdad',
    'bahn',
    'bale',
    'baltimore',
    'barcelona',
    'baseball',
    'basel',
    'baths',
    'bauern',
    'beauxarts',
    'beeldengeluid',
    'bellevue',
    'bergbau',
    'berkeley',
    'berlin',
    'bern',
    'bible',
    'bilbao',
    'bill',
    'birdart',
    'birthplace',
    'bonn',
    'boston',
    'botanical',
    'botanicalgarden',
    'botanicgarden',
    'botany',
    'brandywinevalley',
    'brasil',
    'bristol',
    'british',
    'britishcolumbia',
    'broadcast',
    'brunel',
    'brussel',
    'brussels',
    'bruxelles',
    'building',
    'burghof',
    'bus',
    'bushey',
    'cadaques',
    'california',
    'cambridge',
    'can',
    'canada',
    'capebreton',
    'carrier',
    'cartoonart',
    'casadelamoneda',
    'castle',
    'castres',
    'celtic',
    'center',
    'chattanooga',
    'cheltenham',
    'chesapeakebay',
    'chicago',
    'children',
    'childrens',
    'childrensgarden',
    'chiropractic',
    'chocolate',
    'christiansburg',
    'cincinnati',
    'cinema',
    'circus',
    'civilisation',
    'civilization',
    'civilwar',
    'clinton',
    'clock',
    'coal',
    'coastaldefence',
    'cody',
    'coldwar',
    'collection',
    'colonialwilliamsburg',
    'coloradoplateau',
    'columbia',
    'columbus',
    'communication',
    'communications',
    'community',
    'computer',
    'computerhistory',
    'xn--comunicaes-v6a2o',
    'contemporary',
    'contemporaryart',
    'convent',
    'copenhagen',
    'corporation',
    'xn--correios-e-telecomunicaes-ghc29a',
    'corvette',
    'costume',
    'countryestate',
    'county',
    'crafts',
    'cranbrook',
    'creation',
    'cultural',
    'culturalcenter',
    'culture',
    'cyber',
    'cymru',
    'dali',
    'dallas',
    'database',
    'ddr',
    'decorativearts',
    'delaware',
    'delmenhorst',
    'denmark',
    'depot',
    'design',
    'detroit',
    'dinosaur',
    'discovery',
    'dolls',
    'donostia',
    'durham',
    'eastafrica',
    'eastcoast',
    'education',
    'educational',
    'egyptian',
    'eisenbahn',
    'elburg',
    'elvendrell',
    'embroidery',
    'encyclopedic',
    'england',
    'entomology',
    'environment',
    'environmentalconservation',
    'epilepsy',
    'essex',
    'estate',
    'ethnology',
    'exeter',
    'exhibition',
    'family',
    'farm',
    'farmequipment',
    'farmers',
    'farmstead',
    'field',
    'figueres',
    'filatelia',
    'film',
    'fineart',
    'finearts',
    'finland',
    'flanders',
    'florida',
    'force',
    'fortmissoula',
    'fortworth',
    'foundation',
    'francaise',
    'frankfurt',
    'franziskaner',
    'freemasonry',
    'freiburg',
    'fribourg',
    'frog',
    'fundacio',
    'furniture',
    'gallery',
    'garden',
    'gateway',
    'geelvinck',
    'gemological',
    'geology',
    'georgia',
    'giessen',
    'glas',
    'glass',
    'gorge',
    'grandrapids',
    'graz',
    'guernsey',
    'halloffame',
    'hamburg',
    'handson',
    'harvestcelebration',
    'hawaii',
    'health',
    'heimatunduhren',
    'hellas',
    'helsinki',
    'hembygdsforbund',
    'heritage',
    'histoire',
    'historical',
    'historicalsociety',
    'historichouses',
    'historisch',
    'historisches',
    'history',
    'historyofscience',
    'horology',
    'house',
    'humanities',
    'illustration',
    'imageandsound',
    'indian',
    'indiana',
    'indianapolis',
    'indianmarket',
    'intelligence',
    'interactive',
    'iraq',
    'iron',
    'isleofman',
    'jamison',
    'jefferson',
    'jerusalem',
    'jewelry',
    'jewish',
    'jewishart',
    'jfk',
    'journalism',
    'judaica',
    'judygarland',
    'juedisches',
    'juif',
    'karate',
    'karikatur',
    'kids',
    'koebenhavn',
    'koeln',
    'kunst',
    'kunstsammlung',
    'kunstunddesign',
    'labor',
    'labour',
    'lajolla',
    'lancashire',
    'landes',
    'lans',
    'xn--lns-qla',
    'larsson',
    'lewismiller',
    'lincoln',
    'linz',
    'living',
    'livinghistory',
    'localhistory',
    'london',
    'losangeles',
    'louvre',
    'loyalist',
    'lucerne',
    'luxembourg',
    'luzern',
    'mad',
    'madrid',
    'mallorca',
    'manchester',
    'mansion',
    'mansions',
    'manx',
    'marburg',
    'maritime',
    'maritimo',
    'maryland',
    'marylhurst',
    'media',
    'medical',
    'medizinhistorisches',
    'meeres',
    'memorial',
    'mesaverde',
    'michigan',
    'midatlantic',
    'military',
    'mill',
    'miners',
    'mining',
    'minnesota',
    'missile',
    'missoula',
    'modern',
    'moma',
    'money',
    'monmouth',
    'monticello',
    'montreal',
    'moscow',
    'motorcycle',
    'muenchen',
    'muenster',
    'mulhouse',
    'muncie',
    'museet',
    'museumcenter',
    'museumvereniging',
    'music',
    'national',
    'nationalfirearms',
    'nationalheritage',
    'nativeamerican',
    'naturalhistory',
    'naturalhistorymuseum',
    'naturalsciences',
    'nature',
    'naturhistorisches',
    'natuurwetenschappen',
    'naumburg',
    'naval',
    'nebraska',
    'neues',
    'newhampshire',
    'newjersey',
    'newmexico',
    'newport',
    'newspaper',
    'newyork',
    'niepce',
    'norfolk',
    'north',
    'nrw',
    'nuernberg',
    'nuremberg',
    'nyc',
    'nyny',
    'oceanographic',
    'oceanographique',
    'omaha',
    'online',
    'ontario',
    'openair',
    'oregon',
    'oregontrail',
    'otago',
    'oxford',
    'pacific',
    'paderborn',
    'palace',
    'paleo',
    'palmsprings',
    'panama',
    'paris',
    'pasadena',
    'pharmacy',
    'philadelphia',
    'philadelphiaarea',
    'philately',
    'phoenix',
    'photography',
    'pilots',
    'pittsburgh',
    'planetarium',
    'plantation',
    'plants',
    'plaza',
    'portal',
    'portland',
    'portlligat',
    'posts-and-telecommunications',
    'preservation',
    'presidio',
    'press',
    'project',
    'public',
    'pubol',
    'quebec',
    'railroad',
    'railway',
    'research',
    'resistance',
    'riodejaneiro',
    'rochester',
    'rockart',
    'roma',
    'russia',
    'saintlouis',
    'salem',
    'salvadordali',
    'salzburg',
    'sandiego',
    'sanfrancisco',
    'santabarbara',
    'santacruz',
    'santafe',
    'saskatchewan',
    'satx',
    'savannahga',
    'schlesisches',
    'schoenbrunn',
    'schokoladen',
    'school',
    'schweiz',
    'science',
    'scienceandhistory',
    'scienceandindustry',
    'sciencecenter',
    'sciencecenters',
    'science-fiction',
    'sciencehistory',
    'sciences',
    'sciencesnaturelles',
    'scotland',
    'seaport',
    'settlement',
    'settlers',
    'shell',
    'sherbrooke',
    'sibenik',
    'silk',
    'ski',
    'skole',
    'society',
    'sologne',
    'soundandvision',
    'southcarolina',
    'southwest',
    'space',
    'spy',
    'square',
    'stadt',
    'stalbans',
    'starnberg',
    'state',
    'stateofdelaware',
    'station',
    'steam',
    'steiermark',
    'stjohn',
    'stockholm',
    'stpetersburg',
    'stuttgart',
    'suisse',
    'surgeonshall',
    'surrey',
    'svizzera',
    'sweden',
    'sydney',
    'tank',
    'tcm',
    'technology',
    'telekommunikation',
    'television',
    'texas',
    'textile',
    'theater',
    'time',
    'timekeeping',
    'topology',
    'torino',
    'touch',
    'town',
    'transport',
    'tree',
    'trolley',
    'trust',
    'trustee',
    'uhren',
    'ulm',
    'undersea',
    'university',
    'usa',
    'usantiques',
    'usarts',
    'uscountryestate',
    'usculture',
    'usdecorativearts',
    'usgarden',
    'ushistory',
    'ushuaia',
    'uslivinghistory',
    'utah',
    'uvic',
    'valley',
    'vantaa',
    'versailles',
    'viking',
    'village',
    'virginia',
    'virtual',
    'virtuel',
    'vlaanderen',
    'volkenkunde',
    'wales',
    'wallonie',
    'war',
    'washingtondc',
    'watchandclock',
    'watch-and-clock',
    'western',
    'westfalen',
    'whaling',
    'wildlife',
    'williamsburg',
    'windmill',
    'workshop',
    'york',
    'yorkshire',
    'yosemite',
    'youth',
    'zoological',
    'zoology',
    'xn--9dbhblg6di',
    'xn--h1aegh',
    'academy',
    'agriculture',
    'air',
    'airguard',
    'alabama',
    'alaska',
    'amber',
    'ambulance',
    'american',
    'americana',
    'americanantiques',
    'americanart',
    'amsterdam',
    'and',
    'annefrank',
    'anthro',
    'anthropology',
    'antiques',
    'aquarium',
    'arboretum',
    'archaeological',
    'archaeology',
    'architecture',
    'art',
    'artanddesign',
    'artcenter',
    'artdeco',
    'arteducation',
    'artgallery',
    'arts',
    'artsandcrafts',
    'asmatart',
    'assassination',
    'assisi',
    'association',
    'astronomy',
    'atlanta',
    'austin',
    'australia',
    'automotive',
    'aviation',
    'axis',
    'badajoz',
    'baghdad',
    'bahn',
    'bale',
    'baltimore',
    'barcelona',
    'baseball',
    'basel',
    'baths',
    'bauern',
    'beauxarts',
    'beeldengeluid',
    'bellevue',
    'bergbau',
    'berkeley',
    'berlin',
    'bern',
    'bible',
    'bilbao',
    'bill',
    'birdart',
    'birthplace',
    'bonn',
    'boston',
    'botanical',
    'botanicalgarden',
    'botanicgarden',
    'botany',
    'brandywinevalley',
    'brasil',
    'bristol',
    'british',
    'britishcolumbia',
    'broadcast',
    'brunel',
    'brussel',
    'brussels',
    'bruxelles',
    'building',
    'burghof',
    'bus',
    'bushey',
    'cadaques',
    'california',
    'cambridge',
    'can',
    'canada',
    'capebreton',
    'carrier',
    'cartoonart',
    'casadelamoneda',
    'castle',
    'castres',
    'celtic',
    'center',
    'chattanooga',
    'cheltenham',
    'chesapeakebay',
    'chicago',
    'children',
    'childrens',
    'childrensgarden',
    'chiropractic',
    'chocolate',
    'christiansburg',
    'cincinnati',
    'cinema',
    'circus',
    'civilisation',
    'civilization',
    'civilwar',
    'clinton',
    'clock',
    'coal',
    'coastaldefence',
    'cody',
    'coldwar',
    'collection',
    'colonialwilliamsburg',
    'coloradoplateau',
    'columbia',
    'columbus',
    'communication',
    'communications',
    'community',
    'computer',
    'computerhistory',
    'comunicações',
    'contemporary',
    'contemporaryart',
    'convent',
    'copenhagen',
    'corporation',
    'correios-e-telecomunicações',
    'corvette',
    'costume',
    'countryestate',
    'county',
    'crafts',
    'cranbrook',
    'creation',
    'cultural',
    'culturalcenter',
    'culture',
    'cyber',
    'cymru',
    'dali',
    'dallas',
    'database',
    'ddr',
    'decorativearts',
    'delaware',
    'delmenhorst',
    'denmark',
    'depot',
    'design',
    'detroit',
    'dinosaur',
    'discovery',
    'dolls',
    'donostia',
    'durham',
    'eastafrica',
    'eastcoast',
    'education',
    'educational',
    'egyptian',
    'eisenbahn',
    'elburg',
    'elvendrell',
    'embroidery',
    'encyclopedic',
    'england',
    'entomology',
    'environment',
    'environmentalconservation',
    'epilepsy',
    'essex',
    'estate',
    'ethnology',
    'exeter',
    'exhibition',
    'family',
    'farm',
    'farmequipment',
    'farmers',
    'farmstead',
    'field',
    'figueres',
    'filatelia',
    'film',
    'fineart',
    'finearts',
    'finland',
    'flanders',
    'florida',
    'force',
    'fortmissoula',
    'fortworth',
    'foundation',
    'francaise',
    'frankfurt',
    'franziskaner',
    'freemasonry',
    'freiburg',
    'fribourg',
    'frog',
    'fundacio',
    'furniture',
    'gallery',
    'garden',
    'gateway',
    'geelvinck',
    'gemological',
    'geology',
    'georgia',
    'giessen',
    'glas',
    'glass',
    'gorge',
    'grandrapids',
    'graz',
    'guernsey',
    'halloffame',
    'hamburg',
    'handson',
    'harvestcelebration',
    'hawaii',
    'health',
    'heimatunduhren',
    'hellas',
    'helsinki',
    'hembygdsforbund',
    'heritage',
    'histoire',
    'historical',
    'historicalsociety',
    'historichouses',
    'historisch',
    'historisches',
    'history',
    'historyofscience',
    'horology',
    'house',
    'humanities',
    'illustration',
    'imageandsound',
    'indian',
    'indiana',
    'indianapolis',
    'indianmarket',
    'intelligence',
    'interactive',
    'iraq',
    'iron',
    'isleofman',
    'jamison',
    'jefferson',
    'jerusalem',
    'jewelry',
    'jewish',
    'jewishart',
    'jfk',
    'journalism',
    'judaica',
    'judygarland',
    'juedisches',
    'juif',
    'karate',
    'karikatur',
    'kids',
    'koebenhavn',
    'koeln',
    'kunst',
    'kunstsammlung',
    'kunstunddesign',
    'labor',
    'labour',
    'lajolla',
    'lancashire',
    'landes',
    'lans',
    'läns',
    'larsson',
    'lewismiller',
    'lincoln',
    'linz',
    'living',
    'livinghistory',
    'localhistory',
    'london',
    'losangeles',
    'louvre',
    'loyalist',
    'lucerne',
    'luxembourg',
    'luzern',
    'mad',
    'madrid',
    'mallorca',
    'manchester',
    'mansion',
    'mansions',
    'manx',
    'marburg',
    'maritime',
    'maritimo',
    'maryland',
    'marylhurst',
    'media',
    'medical',
    'medizinhistorisches',
    'meeres',
    'memorial',
    'mesaverde',
    'michigan',
    'midatlantic',
    'military',
    'mill',
    'miners',
    'mining',
    'minnesota',
    'missile',
    'missoula',
    'modern',
    'moma',
    'money',
    'monmouth',
    'monticello',
    'montreal',
    'moscow',
    'motorcycle',
    'muenchen',
    'muenster',
    'mulhouse',
    'muncie',
    'museet',
    'museumcenter',
    'museumvereniging',
    'music',
    'national',
    'nationalfirearms',
    'nationalheritage',
    'nativeamerican',
    'naturalhistory',
    'naturalhistorymuseum',
    'naturalsciences',
    'nature',
    'naturhistorisches',
    'natuurwetenschappen',
    'naumburg',
    'naval',
    'nebraska',
    'neues',
    'newhampshire',
    'newjersey',
    'newmexico',
    'newport',
    'newspaper',
    'newyork',
    'niepce',
    'norfolk',
    'north',
    'nrw',
    'nuernberg',
    'nuremberg',
    'nyc',
    'nyny',
    'oceanographic',
    'oceanographique',
    'omaha',
    'online',
    'ontario',
    'openair',
    'oregon',
    'oregontrail',
    'otago',
    'oxford',
    'pacific',
    'paderborn',
    'palace',
    'paleo',
    'palmsprings',
    'panama',
    'paris',
    'pasadena',
    'pharmacy',
    'philadelphia',
    'philadelphiaarea',
    'philately',
    'phoenix',
    'photography',
    'pilots',
    'pittsburgh',
    'planetarium',
    'plantation',
    'plants',
    'plaza',
    'portal',
    'portland',
    'portlligat',
    'posts-and-telecommunications',
    'preservation',
    'presidio',
    'press',
    'project',
    'public',
    'pubol',
    'quebec',
    'railroad',
    'railway',
    'research',
    'resistance',
    'riodejaneiro',
    'rochester',
    'rockart',
    'roma',
    'russia',
    'saintlouis',
    'salem',
    'salvadordali',
    'salzburg',
    'sandiego',
    'sanfrancisco',
    'santabarbara',
    'santacruz',
    'santafe',
    'saskatchewan',
    'satx',
    'savannahga',
    'schlesisches',
    'schoenbrunn',
    'schokoladen',
    'school',
    'schweiz',
    'science',
    'scienceandhistory',
    'scienceandindustry',
    'sciencecenter',
    'sciencecenters',
    'science-fiction',
    'sciencehistory',
    'sciences',
    'sciencesnaturelles',
    'scotland',
    'seaport',
    'settlement',
    'settlers',
    'shell',
    'sherbrooke',
    'sibenik',
    'silk',
    'ski',
    'skole',
    'society',
    'sologne',
    'soundandvision',
    'southcarolina',
    'southwest',
    'space',
    'spy',
    'square',
    'stadt',
    'stalbans',
    'starnberg',
    'state',
    'stateofdelaware',
    'station',
    'steam',
    'steiermark',
    'stjohn',
    'stockholm',
    'stpetersburg',
    'stuttgart',
    'suisse',
    'surgeonshall',
    'surrey',
    'svizzera',
    'sweden',
    'sydney',
    'tank',
    'tcm',
    'technology',
    'telekommunikation',
    'television',
    'texas',
    'textile',
    'theater',
    'time',
    'timekeeping',
    'topology',
    'torino',
    'touch',
    'town',
    'transport',
    'tree',
    'trolley',
    'trust',
    'trustee',
    'uhren',
    'ulm',
    'undersea',
    'university',
    'usa',
    'usantiques',
    'usarts',
    'uscountryestate',
    'usculture',
    'usdecorativearts',
    'usgarden',
    'ushistory',
    'ushuaia',
    'uslivinghistory',
    'utah',
    'uvic',
    'valley',
    'vantaa',
    'versailles',
    'viking',
    'village',
    'virginia',
    'virtual',
    'virtuel',
    'vlaanderen',
    'volkenkunde',
    'wales',
    'wallonie',
    'war',
    'washingtondc',
    'watchandclock',
    'watch-and-clock',
    'western',
    'westfalen',
    'whaling',
    'wildlife',
    'williamsburg',
    'windmill',
    'workshop',
    'york',
    'yorkshire',
    'yosemite',
    'youth',
    'zoological',
    'zoology',
    'ירושלים',
    'иком'
  ],
  'name': ['forgot.her', 'forgot.his', 'forgot.her', 'forgot.his'],
  'budapest': [],
  'clothing': [],
  'iveco': [],
  'kerrylogistics': [],
  'next': [],
  'rwe': [],
  'shop': [],
  'bbva': [],
  'android': [],
  'book': [],
  'show': [],
  '닷컴': [],
  '购物': [],
  'playstation': [],
  'pizza': [],
  'ally': [],
  'xihuan': [],
  'now': [],
  'pamperedchef': [],
  '游戏': [],
  'memorial': [],
  'news': [],
  'delivery': [],
  'green': [],
  'toys': [],
  'norton': [],
  'icbc': [],
  'bond': [],
  'amfam': [],
  'target': [],
  'پاکستان': [],
  'tokyo': [],
  '健康': [],
  'swiftcover': [],
  'aws': [],
  'xn--6qq986b3xl': [],
  'play': [],
  'xn--j1aef': [],
  'casa': [],
  'xn--imr513n': [],
  'axa': [],
  'rent': [],
  'jio': [],
  'fan': [],
  'gent': [],
  'xn--30rr7y': [],
  'fresenius': [],
  'nra': [],
  'cash': [],
  'aquarelle': [],
  'case': [],
  'citadel': [],
  'بيتك': [],
  'nokia': [],
  'durban': [],
  'firmdale': [],
  'cars': [],
  'chrysler': [],
  'nrw': [],
  'xn--yfro4i67o': [],
  'phone': [],
  'style': [],
  'apartments': [],
  'care': [],
  'stockholm': [],
  'study': [],
  '商城': [],
  'epost': [],
  'direct': [],
  'irish': [],
  'cityeats': [],
  'wed': [],
  'xn--qxam': [],
  'cooking': [],
  'berlin': [],
  'extraspace': [],
  'xn--jlq61u9w7b': [],
  'intuit': [],
  'jlc': [],
  'nissay': [],
  'reliance': [],
  'vegas': [],
  'jll': [],
  'ntt': [],
  'bargains': [],
  'xn--kpry57d': [],
  'unicom': [],
  'homegoods': [],
  'nissan': [],
  'diamonds': [],
  'booking': [],
  'marshalls': [],
  'navy': [],
  'starhub': [],
  'baidu': [],
  'rogers': [],
  'xn--42c2d9a': [],
  '商标': [],
  'fairwinds': [],
  'jmp': [],
  'xn--ngbe9e0a': [],
  'cloud': [
    'myfusion',
    '*.statics',
    '*.magentosite',
    'myfusion',
    '*.statics',
    '*.magentosite'
  ],
  'ryukyu': [],
  'audi': [],
  'xn--rhqv96g': [],
  'orientexpress': [],
  'amsterdam': [],
  'jnj': [],
  'adac': [],
  'vermögensberater': [],
  'moto': [],
  'voyage': [],
  'market': [],
  'cruise': [],
  'raid': [],
  'game': [],
  'hughes': [],
  'faith': ['ybo', 'ybo'],
  'jot': [],
  'panerai': [],
  'rocks': [],
  'joy': [],
  'allstate': [],
  'xn--mgbqly7c0a67fbc': [],
  'diet': [],
  'win': [],
  'lawyer': [],
  'rest': [],
  'soccer': [],
  'sap': [],
  'sas': [],
  'اليمن': [],
  '飞利浦': [],
  'xn--mgbqly7cvafr': [],
  'yandex': [],
  'vuelos': [],
  'nyc': [],
  'xn--j1amh': [],
  'clinic': [],
  'sbi': [],
  'flights': [],
  'vanguard': [],
  'softbank': [],
  'sbs': [],
  'ارامكو': [],
  'vistaprint': [],
  'canon': [],
  'fit': ['ptplus', 'ptplus'],
  'sca': [],
  'الاردن': [],
  'bar': [],
  'scb': [],
  'dvag': [],
  'surf': [],
  'recipes': [],
  'ac': [
    'com',
    'edu',
    'gov',
    'net',
    'mil',
    'org',
    'com',
    'edu',
    'gov',
    'net',
    'mil',
    'org'
  ],
  'bbc': [],
  'ad': ['nom', 'nom'],
  '澳門': [],
  'ae': [
    'co',
    'net',
    'org',
    'sch',
    'ac',
    'gov',
    'mil',
    'blogspot',
    'co',
    'net',
    'org',
    'sch',
    'ac',
    'gov',
    'mil',
    'blogspot'
  ],
  'af': ['gov', 'com', 'org', 'net', 'edu', 'gov', 'com', 'org', 'net', 'edu'],
  'ag': ['com', 'org', 'net', 'co', 'nom', 'com', 'org', 'net', 'co', 'nom'],
  'ai': ['off', 'com', 'net', 'org', 'off', 'com', 'net', 'org'],
  'globo': [],
  'al': [
    'com',
    'edu',
    'gov',
    'mil',
    'net',
    'org',
    'blogspot',
    'com',
    'edu',
    'gov',
    'mil',
    'net',
    'org',
    'blogspot'
  ],
  'am': ['blogspot', 'blogspot'],
  'ao': [
    'ed',
    'gv',
    'og',
    'co',
    'pb',
    'it',
    'ed',
    'gv',
    'og',
    'co',
    'pb',
    'it'
  ],
  'aq': [],
  'xn--e1a4c': [],
  'ar': [
    'com',
    'edu',
    'gob',
    'gov',
    'int',
    'mil',
    'net',
    'org',
    'tur',
    'blogspot.com',
    'com',
    'edu',
    'gob',
    'gov',
    'int',
    'mil',
    'net',
    'org',
    'tur',
    'blogspot.com'
  ],
  'as': ['gov', 'gov'],
  'at': [
    'ac',
    'co',
    'gv',
    'or',
    'futurehosting',
    'futuremailing',
    '*.ex.ortsinfo',
    '*.kunden.ortsinfo',
    'blogspot.co',
    'biz',
    'info',
    'priv',
    'ac',
    'co',
    'gv',
    'or',
    'futurehosting',
    'futuremailing',
    '*.ex.ortsinfo',
    '*.kunden.ortsinfo',
    'blogspot.co',
    'biz',
    'info',
    'priv'
  ],
  'au': [
    'com',
    'net',
    'org',
    'edu',
    'gov',
    'asn',
    'id',
    'info',
    'conf',
    'oz',
    'act',
    'nsw',
    'nt',
    'qld',
    'sa',
    'tas',
    'vic',
    'wa',
    'act.edu',
    'nsw.edu',
    'nt.edu',
    'qld.edu',
    'sa.edu',
    'tas.edu',
    'vic.edu',
    'wa.edu',
    'qld.gov',
    'sa.gov',
    'tas.gov',
    'vic.gov',
    'wa.gov',
    'blogspot.com',
    'com',
    'net',
    'org',
    'edu',
    'gov',
    'asn',
    'id',
    'info',
    'conf',
    'oz',
    'act',
    'nsw',
    'nt',
    'qld',
    'sa',
    'tas',
    'vic',
    'wa',
    'act.edu',
    'nsw.edu',
    'nt.edu',
    'qld.edu',
    'sa.edu',
    'tas.edu',
    'vic.edu',
    'wa.edu',
    'qld.gov',
    'sa.gov',
    'tas.gov',
    'vic.gov',
    'wa.gov',
    'blogspot.com'
  ],
  'bbt': [],
  'aw': ['com', 'com'],
  'vacations': [],
  'ax': [],
  'az': [
    'com',
    'net',
    'int',
    'gov',
    'org',
    'edu',
    'info',
    'pp',
    'mil',
    'name',
    'pro',
    'biz',
    'com',
    'net',
    'int',
    'gov',
    'org',
    'edu',
    'info',
    'pp',
    'mil',
    'name',
    'pro',
    'biz'
  ],
  'drive': [],
  'brother': [],
  'ba': [
    'com',
    'edu',
    'gov',
    'mil',
    'net',
    'org',
    'blogspot',
    'com',
    'edu',
    'gov',
    'mil',
    'net',
    'org',
    'blogspot'
  ],
  'xn--mgbca7dzdo': [],
  'bb': [
    'biz',
    'co',
    'com',
    'edu',
    'gov',
    'info',
    'net',
    'org',
    'store',
    'tv',
    'biz',
    'co',
    'com',
    'edu',
    'gov',
    'info',
    'net',
    'org',
    'store',
    'tv'
  ],
  'bd': ['*', '*'],
  'deal': [],
  'be': ['ac', 'blogspot', '*.transurl', 'ac', 'blogspot', '*.transurl'],
  'bf': ['gov', 'gov'],
  'bg': [
    'a',
    'b',
    'c',
    'd',
    'e',
    'f',
    'g',
    'h',
    'i',
    'j',
    'k',
    'l',
    'm',
    'n',
    'o',
    'p',
    'q',
    'r',
    's',
    't',
    'u',
    'v',
    'w',
    'x',
    'y',
    'z',
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
    'blogspot',
    'a',
    'b',
    'c',
    'd',
    'e',
    'f',
    'g',
    'h',
    'i',
    'j',
    'k',
    'l',
    'm',
    'n',
    'o',
    'p',
    'q',
    'r',
    's',
    't',
    'u',
    'v',
    'w',
    'x',
    'y',
    'z',
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
    'blogspot'
  ],
  'bh': ['com', 'edu', 'net', 'org', 'gov', 'com', 'edu', 'net', 'org', 'gov'],
  'bi': ['co', 'com', 'edu', 'or', 'org', 'co', 'com', 'edu', 'or', 'org'],
  'bcg': [],
  'bj': [
    'asso',
    'barreau',
    'gouv',
    'blogspot',
    'asso',
    'barreau',
    'gouv',
    'blogspot'
  ],
  'xn--mgb2ddes': [],
  'bm': ['com', 'edu', 'gov', 'net', 'org', 'com', 'edu', 'gov', 'net', 'org'],
  'bn': ['*', '*'],
  'bcn': [],
  'bo': [
    'com',
    'edu',
    'gov',
    'gob',
    'int',
    'org',
    'net',
    'mil',
    'tv',
    'com',
    'edu',
    'gov',
    'gob',
    'int',
    'org',
    'net',
    'mil',
    'tv'
  ],
  'wme': [],
  'reisen': [],
  'br': [
    'adm',
    'adv',
    'agr',
    'am',
    'arq',
    'art',
    'ato',
    'b',
    'bio',
    'blog',
    'bmd',
    'cim',
    'cng',
    'cnt',
    'com',
    'coop',
    'ecn',
    'eco',
    'edu',
    'emp',
    'eng',
    'esp',
    'etc',
    'eti',
    'far',
    'flog',
    'fm',
    'fnd',
    'fot',
    'fst',
    'g12',
    'ggf',
    'gov',
    'imb',
    'ind',
    'inf',
    'jor',
    'jus',
    'leg',
    'lel',
    'mat',
    'med',
    'mil',
    'mp',
    'mus',
    'net',
    '*.nom',
    'not',
    'ntr',
    'odo',
    'org',
    'ppg',
    'pro',
    'psc',
    'psi',
    'qsl',
    'radio',
    'rec',
    'slg',
    'srv',
    'taxi',
    'teo',
    'tmp',
    'trd',
    'tur',
    'tv',
    'vet',
    'vlog',
    'wiki',
    'zlg',
    'blogspot.com',
    'ac.leg',
    'al.leg',
    'am.leg',
    'ap.leg',
    'ba.leg',
    'ce.leg',
    'df.leg',
    'es.leg',
    'go.leg',
    'ma.leg',
    'mg.leg',
    'ms.leg',
    'mt.leg',
    'pa.leg',
    'pb.leg',
    'pe.leg',
    'pi.leg',
    'pr.leg',
    'rj.leg',
    'rn.leg',
    'ro.leg',
    'rr.leg',
    'rs.leg',
    'sc.leg',
    'se.leg',
    'sp.leg',
    'to.leg',
    'adm',
    'adv',
    'agr',
    'am',
    'arq',
    'art',
    'ato',
    'b',
    'bio',
    'blog',
    'bmd',
    'cim',
    'cng',
    'cnt',
    'com',
    'coop',
    'ecn',
    'eco',
    'edu',
    'emp',
    'eng',
    'esp',
    'etc',
    'eti',
    'far',
    'flog',
    'fm',
    'fnd',
    'fot',
    'fst',
    'g12',
    'ggf',
    'gov',
    'imb',
    'ind',
    'inf',
    'jor',
    'jus',
    'leg',
    'lel',
    'mat',
    'med',
    'mil',
    'mp',
    'mus',
    'net',
    '*.nom',
    'not',
    'ntr',
    'odo',
    'org',
    'ppg',
    'pro',
    'psc',
    'psi',
    'qsl',
    'radio',
    'rec',
    'slg',
    'srv',
    'taxi',
    'teo',
    'tmp',
    'trd',
    'tur',
    'tv',
    'vet',
    'vlog',
    'wiki',
    'zlg',
    'blogspot.com',
    'ac.leg',
    'al.leg',
    'am.leg',
    'ap.leg',
    'ba.leg',
    'ce.leg',
    'df.leg',
    'es.leg',
    'go.leg',
    'ma.leg',
    'mg.leg',
    'ms.leg',
    'mt.leg',
    'pa.leg',
    'pb.leg',
    'pe.leg',
    'pi.leg',
    'pr.leg',
    'rj.leg',
    'rn.leg',
    'ro.leg',
    'rr.leg',
    'rs.leg',
    'sc.leg',
    'se.leg',
    'sp.leg',
    'to.leg'
  ],
  'bs': ['com', 'net', 'org', 'edu', 'gov', 'com', 'net', 'org', 'edu', 'gov'],
  'bt': ['com', 'edu', 'gov', 'net', 'org', 'com', 'edu', 'gov', 'net', 'org'],
  'search': [],
  'bv': [],
  'bw': ['co', 'org', 'co', 'org'],
  'sanofi': [],
  'systems': ['knightpoint', 'knightpoint'],
  'by': [
    'gov',
    'mil',
    'com',
    'of',
    'blogspot.com',
    'gov',
    'mil',
    'com',
    'of',
    'blogspot.com'
  ],
  'bz': [
    'com',
    'net',
    'org',
    'edu',
    'gov',
    'za',
    'com',
    'net',
    'org',
    'edu',
    'gov',
    'za'
  ],
  'xn--i1b6b1a6a2e': [],
  'xn--flw351e': [],
  'xn--1ck2e1b': [],
  'ca': [
    'ab',
    'bc',
    'mb',
    'nb',
    'nf',
    'nl',
    'ns',
    'nt',
    'nu',
    'on',
    'pe',
    'qc',
    'sk',
    'yk',
    'gc',
    'co',
    'blogspot',
    'no-ip',
    'ab',
    'bc',
    'mb',
    'nb',
    'nf',
    'nl',
    'ns',
    'nt',
    'nu',
    'on',
    'pe',
    'qc',
    'sk',
    'yk',
    'gc',
    'co',
    'blogspot',
    'no-ip'
  ],
  'cc': [
    'cloudns',
    'ftpaccess',
    'game-server',
    'myphotos',
    'scrapping',
    'fantasyleague',
    'cloudns',
    'ftpaccess',
    'game-server',
    'myphotos',
    'scrapping',
    'fantasyleague'
  ],
  'ses': [],
  'cd': ['gov', 'gov'],
  'cf': ['blogspot', 'blogspot'],
  'cg': [],
  'sew': [],
  'ch': ['blogspot', 'gotdns', 'blogspot', 'gotdns'],
  'ci': [
    'org',
    'or',
    'com',
    'co',
    'edu',
    'ed',
    'ac',
    'net',
    'go',
    'asso',
    'xn--aroport-bya',
    'int',
    'presse',
    'md',
    'gouv',
    'org',
    'or',
    'com',
    'co',
    'edu',
    'ed',
    'ac',
    'net',
    'go',
    'asso',
    'aéroport',
    'int',
    'presse',
    'md',
    'gouv'
  ],
  'мкд': [],
  'jobs': [],
  'sex': [],
  '餐厅': [],
  'ck': ['*', '!www', '*', '!www'],
  'cl': [
    'gov',
    'gob',
    'co',
    'mil',
    'blogspot',
    'gov',
    'gob',
    'co',
    'mil',
    'blogspot'
  ],
  'cm': ['co', 'com', 'gov', 'net', 'co', 'com', 'gov', 'net'],
  'cn': [
    'ac',
    'com',
    'edu',
    'gov',
    'net',
    'org',
    'mil',
    'xn--55qx5d',
    'xn--io0a7i',
    'xn--od0alg',
    'ah',
    'bj',
    'cq',
    'fj',
    'gd',
    'gs',
    'gz',
    'gx',
    'ha',
    'hb',
    'he',
    'hi',
    'hl',
    'hn',
    'jl',
    'js',
    'jx',
    'ln',
    'nm',
    'nx',
    'qh',
    'sc',
    'sd',
    'sh',
    'sn',
    'sx',
    'tj',
    'xj',
    'xz',
    'yn',
    'zj',
    'hk',
    'mo',
    'tw',
    '*.compute.amazonaws.com',
    'elasticbeanstalk.cn-north-1.amazonaws.com',
    '*.elb.amazonaws.com',
    's3.cn-north-1.amazonaws.com',
    'ac',
    'com',
    'edu',
    'gov',
    'net',
    'org',
    'mil',
    '公司',
    '网络',
    '網絡',
    'ah',
    'bj',
    'cq',
    'fj',
    'gd',
    'gs',
    'gz',
    'gx',
    'ha',
    'hb',
    'he',
    'hi',
    'hl',
    'hn',
    'jl',
    'js',
    'jx',
    'ln',
    'nm',
    'nx',
    'qh',
    'sc',
    'sd',
    'sh',
    'sn',
    'sx',
    'tj',
    'xj',
    'xz',
    'yn',
    'zj',
    'hk',
    'mo',
    'tw',
    '*.compute.amazonaws.com',
    'elasticbeanstalk.cn-north-1.amazonaws.com',
    '*.elb.amazonaws.com',
    's3.cn-north-1.amazonaws.com'
  ],
  'co': [
    'arts',
    'com',
    'edu',
    'firm',
    'gov',
    'info',
    'int',
    'mil',
    'net',
    'nom',
    'org',
    'rec',
    'web',
    'blogspot.com',
    'arts',
    'com',
    'edu',
    'firm',
    'gov',
    'info',
    'int',
    'mil',
    'net',
    'nom',
    'org',
    'rec',
    'web',
    'blogspot.com'
  ],
  'americanexpress': [],
  'dubai': [],
  'food': [],
  'تونس': [],
  'cr': [
    'ac',
    'co',
    'ed',
    'fi',
    'go',
    'or',
    'sa',
    'ac',
    'co',
    'ed',
    'fi',
    'go',
    'or',
    'sa'
  ],
  'actor': [],
  'cu': [
    'com',
    'edu',
    'org',
    'net',
    'gov',
    'inf',
    'com',
    'edu',
    'org',
    'net',
    'gov',
    'inf'
  ],
  'fly': [],
  'cv': ['blogspot', 'blogspot'],
  'yamaxun': [],
  'cw': ['com', 'edu', 'net', 'org', 'com', 'edu', 'net', 'org'],
  'cookingchannel': [],
  'kred': [],
  'tatamotors': [],
  'cx': ['gov', 'ath', 'gov', 'ath'],
  'cy': [
    'ac',
    'biz',
    'com',
    'ekloges',
    'gov',
    'ltd',
    'name',
    'net',
    'org',
    'parliament',
    'press',
    'pro',
    'tm',
    'blogspot.com',
    'ac',
    'biz',
    'com',
    'ekloges',
    'gov',
    'ltd',
    'name',
    'net',
    'org',
    'parliament',
    'press',
    'pro',
    'tm',
    'blogspot.com'
  ],
  'visa': [],
  'cz': ['co', 'realm', 'e4', 'blogspot', 'co', 'realm', 'e4', 'blogspot'],
  'الجزائر': [],
  'xn--fzc2c9e2c': [],
  'sfr': [],
  'de': [
    'com',
    'dyn.cosidns',
    'dynamisches-dns',
    'dnsupdater',
    'internet-dns',
    'l-o-g-i-n',
    'dnshome',
    'fuettertdasnetz',
    'isteingeek',
    'istmein',
    'lebtimnetz',
    'leitungsen',
    'traeumtgerade',
    'ddnss',
    'dyn.ddnss',
    'dyndns.ddnss',
    'dyndns1',
    'dyn-ip24',
    'home-webserver',
    'dyn.home-webserver',
    'myhome-server',
    'goip',
    'blogspot',
    'keymachine',
    'logoip',
    'firewall-gateway',
    'my-gateway',
    'my-router',
    'spdns',
    'taifun-dns',
    'dd-dns',
    'dray-dns',
    'draydns',
    'dyn-vpn',
    'dynvpn',
    'mein-vigor',
    'my-vigor',
    'my-wan',
    'syno-ds',
    'synology-diskstation',
    'synology-ds',
    'com',
    'dyn.cosidns',
    'dynamisches-dns',
    'dnsupdater',
    'internet-dns',
    'l-o-g-i-n',
    'dnshome',
    'fuettertdasnetz',
    'isteingeek',
    'istmein',
    'lebtimnetz',
    'leitungsen',
    'traeumtgerade',
    'ddnss',
    'dyn.ddnss',
    'dyndns.ddnss',
    'dyndns1',
    'dyn-ip24',
    'home-webserver',
    'dyn.home-webserver',
    'myhome-server',
    'goip',
    'blogspot',
    'keymachine',
    'logoip',
    'firewall-gateway',
    'my-gateway',
    'my-router',
    'spdns',
    'taifun-dns',
    'dd-dns',
    'dray-dns',
    'draydns',
    'dyn-vpn',
    'dynvpn',
    'mein-vigor',
    'my-vigor',
    'my-wan',
    'syno-ds',
    'synology-diskstation',
    'synology-ds'
  ],
  'kiwi': [],
  'beauty': [],
  'dj': [],
  'dk': [
    'biz',
    'co',
    'firm',
    'reg',
    'store',
    'blogspot',
    'biz',
    'co',
    'firm',
    'reg',
    'store',
    'blogspot'
  ],
  'dm': ['com', 'net', 'org', 'edu', 'gov', 'com', 'net', 'org', 'edu', 'gov'],
  'do': [
    'art',
    'com',
    'edu',
    'gob',
    'gov',
    'mil',
    'net',
    'org',
    'sld',
    'web',
    'art',
    'com',
    'edu',
    'gob',
    'gov',
    'mil',
    'net',
    'org',
    'sld',
    'web'
  ],
  'ford': [],
  'graphics': [],
  'рус': [],
  'bet': [],
  'xn--mgbtf8fl': [],
  'dz': [
    'com',
    'org',
    'net',
    'gov',
    'edu',
    'asso',
    'pol',
    'art',
    'com',
    'org',
    'net',
    'gov',
    'edu',
    'asso',
    'pol',
    'art'
  ],
  'showtime': [],
  'contact': [],
  'vivo': [],
  '澳门': [],
  '在线': [],
  'ec': [
    'com',
    'info',
    'net',
    'fin',
    'k12',
    'med',
    'pro',
    'org',
    'edu',
    'gov',
    'gob',
    'mil',
    'com',
    'info',
    'net',
    'fin',
    'k12',
    'med',
    'pro',
    'org',
    'edu',
    'gov',
    'gob',
    'mil'
  ],
  'wow': [],
  'tires': [],
  'ee': [
    'edu',
    'gov',
    'riik',
    'lib',
    'med',
    'com',
    'pri',
    'aip',
    'org',
    'fie',
    'blogspot.com',
    'edu',
    'gov',
    'riik',
    'lib',
    'med',
    'com',
    'pri',
    'aip',
    'org',
    'fie',
    'blogspot.com'
  ],
  'বাংলা': [],
  'eg': [
    'com',
    'edu',
    'eun',
    'gov',
    'mil',
    'name',
    'net',
    'org',
    'sci',
    'blogspot.com',
    'com',
    'edu',
    'eun',
    'gov',
    'mil',
    'name',
    'net',
    'org',
    'sci',
    'blogspot.com'
  ],
  'chrome': [],
  '信息': [],
  'viva': [],
  'er': ['*', '*'],
  'es': [
    'com',
    'nom',
    'org',
    'gob',
    'edu',
    'blogspot.com',
    'com',
    'nom',
    'org',
    'gob',
    'edu',
    'blogspot.com'
  ],
  'temasek': [],
  'et': [
    'com',
    'gov',
    'org',
    'edu',
    'biz',
    'name',
    'info',
    'net',
    'com',
    'gov',
    'org',
    'edu',
    'biz',
    'name',
    'info',
    'net'
  ],
  'eu': [
    'mycd',
    'cloudns',
    'wellbeingzone',
    'spdns',
    '*.transurl',
    'diskstation',
    'mycd',
    'cloudns',
    'wellbeingzone',
    'spdns',
    '*.transurl',
    'diskstation'
  ],
  'parts': [],
  'party': ['ybo', 'ybo'],
  'accountants': [],
  'salon': [],
  'cuisinella': [],
  'fi': ['aland', 'dy', 'blogspot', 'iki', 'aland', 'dy', 'blogspot', 'iki'],
  'fj': ['*', '*'],
  'fk': ['*', '*'],
  'fm': [],
  'foo': [],
  'fo': [],
  'lifeinsurance': [],
  'fr': [
    'com',
    'asso',
    'nom',
    'prd',
    'presse',
    'tm',
    'aeroport',
    'assedic',
    'avocat',
    'avoues',
    'cci',
    'chambagri',
    'chirurgiens-dentistes',
    'experts-comptables',
    'geometre-expert',
    'gouv',
    'greta',
    'huissier-justice',
    'medecin',
    'notaires',
    'pharmacien',
    'port',
    'veterinaire',
    'fbx-os',
    'fbxos',
    'freebox-os',
    'freeboxos',
    'blogspot',
    'on-web',
    'chirurgiens-dentistes-en-france',
    'com',
    'asso',
    'nom',
    'prd',
    'presse',
    'tm',
    'aeroport',
    'assedic',
    'avocat',
    'avoues',
    'cci',
    'chambagri',
    'chirurgiens-dentistes',
    'experts-comptables',
    'geometre-expert',
    'gouv',
    'greta',
    'huissier-justice',
    'medecin',
    'notaires',
    'pharmacien',
    'port',
    'veterinaire',
    'fbx-os',
    'fbxos',
    'freebox-os',
    'freeboxos',
    'blogspot',
    'on-web',
    'chirurgiens-dentistes-en-france'
  ],
  'fox': [],
  'xfinity': [],
  'xn--5tzm5g': [],
  'mckinsey': [],
  'stcgroup': [],
  'ga': [],
  'gb': [],
  'gd': [],
  'ge': [
    'com',
    'edu',
    'gov',
    'org',
    'mil',
    'net',
    'pvt',
    'com',
    'edu',
    'gov',
    'org',
    'mil',
    'net',
    'pvt'
  ],
  'gf': [],
  'gg': ['co', 'net', 'org', 'co', 'net', 'org'],
  'digital': [],
  'gh': ['com', 'edu', 'gov', 'org', 'mil', 'com', 'edu', 'gov', 'org', 'mil'],
  'comcast': [],
  'gi': [
    'com',
    'ltd',
    'gov',
    'mod',
    'edu',
    'org',
    'com',
    'ltd',
    'gov',
    'mod',
    'edu',
    'org'
  ],
  'living': [],
  'gl': ['co', 'com', 'edu', 'net', 'org', 'co', 'com', 'edu', 'net', 'org'],
  'gm': [],
  'gn': [
    'ac',
    'com',
    'edu',
    'gov',
    'org',
    'net',
    'ac',
    'com',
    'edu',
    'gov',
    'org',
    'net'
  ],
  'gp': [
    'com',
    'net',
    'mobi',
    'edu',
    'org',
    'asso',
    'com',
    'net',
    'mobi',
    'edu',
    'org',
    'asso'
  ],
  '嘉里': [],
  'gq': [],
  'goodyear': [],
  'gr': [
    'com',
    'edu',
    'net',
    'org',
    'gov',
    'blogspot',
    'com',
    'edu',
    'net',
    'org',
    'gov',
    'blogspot'
  ],
  'football': [],
  'мон': [],
  'gs': [],
  'gt': [
    'com',
    'edu',
    'gob',
    'ind',
    'mil',
    'net',
    'org',
    'com',
    'edu',
    'gob',
    'ind',
    'mil',
    'net',
    'org'
  ],
  'gu': ['*', '*'],
  'ファッション': [],
  'gw': [],
  'gy': [
    'co',
    'com',
    'edu',
    'gov',
    'net',
    'org',
    'co',
    'com',
    'edu',
    'gov',
    'net',
    'org'
  ],
  'allfinanz': [],
  'management': ['router', 'router'],
  'obi': [],
  'bid': [],
  'expert': [],
  'hk': [
    'com',
    'edu',
    'gov',
    'idv',
    'net',
    'org',
    'xn--55qx5d',
    'xn--wcvs22d',
    'xn--lcvr32d',
    'xn--mxtq1m',
    'xn--gmqw5a',
    'xn--ciqpn',
    'xn--gmq050i',
    'xn--zf0avx',
    'xn--io0a7i',
    'xn--mk0axi',
    'xn--od0alg',
    'xn--od0aq3b',
    'xn--tn0ag',
    'xn--uc0atv',
    'xn--uc0ay4a',
    'blogspot',
    'ltd',
    'inc',
    'com',
    'edu',
    'gov',
    'idv',
    'net',
    'org',
    '公司',
    '教育',
    '敎育',
    '政府',
    '個人',
    '个人',
    '箇人',
    '網络',
    '网络',
    '组織',
    '網絡',
    '网絡',
    '组织',
    '組織',
    '組织',
    'blogspot',
    'ltd',
    'inc'
  ],
  'select': [],
  'இந்தியா': [],
  'alstom': [],
  'hm': [],
  'hn': [
    'com',
    'edu',
    'org',
    'net',
    'mil',
    'gob',
    'com',
    'edu',
    'org',
    'net',
    'mil',
    'gob'
  ],
  'bio': [],
  'hr': [
    'iz',
    'from',
    'name',
    'com',
    'blogspot',
    'iz',
    'from',
    'name',
    'com',
    'blogspot'
  ],
  'ht': [
    'com',
    'shop',
    'firm',
    'info',
    'adult',
    'net',
    'pro',
    'org',
    'med',
    'art',
    'coop',
    'pol',
    'asso',
    'edu',
    'rel',
    'gouv',
    'perso',
    'com',
    'shop',
    'firm',
    'info',
    'adult',
    'net',
    'pro',
    'org',
    'med',
    'art',
    'coop',
    'pol',
    'asso',
    'edu',
    'rel',
    'gouv',
    'perso'
  ],
  'hu': [
    'co',
    'info',
    'org',
    'priv',
    'sport',
    'tm',
    '2000',
    'agrar',
    'bolt',
    'casino',
    'city',
    'erotica',
    'erotika',
    'film',
    'forum',
    'games',
    'hotel',
    'ingatlan',
    'jogasz',
    'konyvelo',
    'lakas',
    'media',
    'news',
    'reklam',
    'sex',
    'shop',
    'suli',
    'szex',
    'tozsde',
    'utazas',
    'video',
    'blogspot',
    'co',
    'info',
    'org',
    'priv',
    'sport',
    'tm',
    '2000',
    'agrar',
    'bolt',
    'casino',
    'city',
    'erotica',
    'erotika',
    'film',
    'forum',
    'games',
    'hotel',
    'ingatlan',
    'jogasz',
    'konyvelo',
    'lakas',
    'media',
    'news',
    'reklam',
    'sex',
    'shop',
    'suli',
    'szex',
    'tozsde',
    'utazas',
    'video',
    'blogspot'
  ],
  'ski': [],
  'biz': [
    'cloudns',
    'dyndns',
    'for-better',
    'for-more',
    'for-some',
    'for-the',
    'selfip',
    'webhop',
    'mmafan',
    'myftp',
    'no-ip',
    'dscloud',
    'cloudns',
    'dyndns',
    'for-better',
    'for-more',
    'for-some',
    'for-the',
    'selfip',
    'webhop',
    'mmafan',
    'myftp',
    'no-ip',
    'dscloud'
  ],
  'id': [
    'ac',
    'biz',
    'co',
    'desa',
    'go',
    'mil',
    'my',
    'net',
    'or',
    'sch',
    'web',
    'blogspot.co',
    'ac',
    'biz',
    'co',
    'desa',
    'go',
    'mil',
    'my',
    'net',
    'or',
    'sch',
    'web',
    'blogspot.co'
  ],
  'ie': ['gov', 'blogspot', 'gov', 'blogspot'],
  'neustar': [],
  'philips': [],
  'abarth': [],
  'crown': [],
  'sky': [],
  'frl': [],
  'il': [
    'ac',
    'co',
    'gov',
    'idf',
    'k12',
    'muni',
    'net',
    'org',
    'blogspot.co',
    'ac',
    'co',
    'gov',
    'idf',
    'k12',
    'muni',
    'net',
    'org',
    'blogspot.co'
  ],
  'im': [
    'ac',
    'co',
    'com',
    'ltd.co',
    'net',
    'org',
    'plc.co',
    'tt',
    'tv',
    'ro',
    'ac',
    'co',
    'com',
    'ltd.co',
    'net',
    'org',
    'plc.co',
    'tt',
    'tv',
    'ro'
  ],
  'bestbuy': [],
  'in': [
    'co',
    'firm',
    'net',
    'org',
    'gen',
    'ind',
    'nic',
    'ac',
    'edu',
    'res',
    'gov',
    'mil',
    'cloudns',
    'blogspot',
    'co',
    'firm',
    'net',
    'org',
    'gen',
    'ind',
    'nic',
    'ac',
    'edu',
    'res',
    'gov',
    'mil',
    'cloudns',
    'blogspot'
  ],
  'io': [
    'com',
    'backplaneapp',
    'boxfuse',
    'browsersafetymark',
    'dedyn',
    'drud',
    'enonic',
    'customer.enonic',
    'github',
    'gitlab',
    'hasura-app',
    'ngrok',
    'nid',
    'pantheonsite',
    'protonet',
    'hzc',
    'sandcats',
    'shiftedit',
    'apps.lair',
    '*.stolos',
    'spacekit',
    'com',
    'backplaneapp',
    'boxfuse',
    'browsersafetymark',
    'dedyn',
    'drud',
    'enonic',
    'customer.enonic',
    'github',
    'gitlab',
    'hasura-app',
    'ngrok',
    'nid',
    'pantheonsite',
    'protonet',
    'hzc',
    'sandcats',
    'shiftedit',
    'apps.lair',
    '*.stolos',
    'spacekit'
  ],
  'wtc': [],
  'iq': [
    'gov',
    'edu',
    'mil',
    'com',
    'org',
    'net',
    'gov',
    'edu',
    'mil',
    'com',
    'org',
    'net'
  ],
  'wtf': [],
  'ir': [
    'ac',
    'co',
    'gov',
    'id',
    'net',
    'org',
    'sch',
    'xn--mgba3a4f16a',
    'xn--mgba3a4fra',
    'ac',
    'co',
    'gov',
    'id',
    'net',
    'org',
    'sch',
    'ایران',
    'ايران'
  ],
  'autos': [],
  'is': [
    'net',
    'com',
    'edu',
    'gov',
    'org',
    'int',
    'cupcake',
    'blogspot',
    'net',
    'com',
    'edu',
    'gov',
    'org',
    'int',
    'cupcake',
    'blogspot'
  ],
  'it': [
    'gov',
    'edu',
    'abr',
    'abruzzo',
    'aosta-valley',
    'aostavalley',
    'bas',
    'basilicata',
    'cal',
    'calabria',
    'cam',
    'campania',
    'emilia-romagna',
    'emiliaromagna',
    'emr',
    'friuli-v-giulia',
    'friuli-ve-giulia',
    'friuli-vegiulia',
    'friuli-venezia-giulia',
    'friuli-veneziagiulia',
    'friuli-vgiulia',
    'friuliv-giulia',
    'friulive-giulia',
    'friulivegiulia',
    'friulivenezia-giulia',
    'friuliveneziagiulia',
    'friulivgiulia',
    'fvg',
    'laz',
    'lazio',
    'lig',
    'liguria',
    'lom',
    'lombardia',
    'lombardy',
    'lucania',
    'mar',
    'marche',
    'mol',
    'molise',
    'piedmont',
    'piemonte',
    'pmn',
    'pug',
    'puglia',
    'sar',
    'sardegna',
    'sardinia',
    'sic',
    'sicilia',
    'sicily',
    'taa',
    'tos',
    'toscana',
    'trentino-a-adige',
    'trentino-aadige',
    'trentino-alto-adige',
    'trentino-altoadige',
    'trentino-s-tirol',
    'trentino-stirol',
    'trentino-sud-tirol',
    'trentino-sudtirol',
    'trentino-sued-tirol',
    'trentino-suedtirol',
    'trentinoa-adige',
    'trentinoaadige',
    'trentinoalto-adige',
    'trentinoaltoadige',
    'trentinos-tirol',
    'trentinostirol',
    'trentinosud-tirol',
    'trentinosudtirol',
    'trentinosued-tirol',
    'trentinosuedtirol',
    'tuscany',
    'umb',
    'umbria',
    'val-d-aosta',
    'val-daosta',
    'vald-aosta',
    'valdaosta',
    'valle-aosta',
    'valle-d-aosta',
    'valle-daosta',
    'valleaosta',
    'valled-aosta',
    'valledaosta',
    'vallee-aoste',
    'valleeaoste',
    'vao',
    'vda',
    'ven',
    'veneto',
    'ag',
    'agrigento',
    'al',
    'alessandria',
    'alto-adige',
    'altoadige',
    'an',
    'ancona',
    'andria-barletta-trani',
    'andria-trani-barletta',
    'andriabarlettatrani',
    'andriatranibarletta',
    'ao',
    'aosta',
    'aoste',
    'ap',
    'aq',
    'aquila',
    'ar',
    'arezzo',
    'ascoli-piceno',
    'ascolipiceno',
    'asti',
    'at',
    'av',
    'avellino',
    'ba',
    'balsan',
    'bari',
    'barletta-trani-andria',
    'barlettatraniandria',
    'belluno',
    'benevento',
    'bergamo',
    'bg',
    'bi',
    'biella',
    'bl',
    'bn',
    'bo',
    'bologna',
    'bolzano',
    'bozen',
    'br',
    'brescia',
    'brindisi',
    'bs',
    'bt',
    'bz',
    'ca',
    'cagliari',
    'caltanissetta',
    'campidano-medio',
    'campidanomedio',
    'campobasso',
    'carbonia-iglesias',
    'carboniaiglesias',
    'carrara-massa',
    'carraramassa',
    'caserta',
    'catania',
    'catanzaro',
    'cb',
    'ce',
    'cesena-forli',
    'cesenaforli',
    'ch',
    'chieti',
    'ci',
    'cl',
    'cn',
    'co',
    'como',
    'cosenza',
    'cr',
    'cremona',
    'crotone',
    'cs',
    'ct',
    'cuneo',
    'cz',
    'dell-ogliastra',
    'dellogliastra',
    'en',
    'enna',
    'fc',
    'fe',
    'fermo',
    'ferrara',
    'fg',
    'fi',
    'firenze',
    'florence',
    'fm',
    'foggia',
    'forli-cesena',
    'forlicesena',
    'fr',
    'frosinone',
    'ge',
    'genoa',
    'genova',
    'go',
    'gorizia',
    'gr',
    'grosseto',
    'iglesias-carbonia',
    'iglesiascarbonia',
    'im',
    'imperia',
    'is',
    'isernia',
    'kr',
    'la-spezia',
    'laquila',
    'laspezia',
    'latina',
    'lc',
    'le',
    'lecce',
    'lecco',
    'li',
    'livorno',
    'lo',
    'lodi',
    'lt',
    'lu',
    'lucca',
    'macerata',
    'mantova',
    'massa-carrara',
    'massacarrara',
    'matera',
    'mb',
    'mc',
    'me',
    'medio-campidano',
    'mediocampidano',
    'messina',
    'mi',
    'milan',
    'milano',
    'mn',
    'mo',
    'modena',
    'monza-brianza',
    'monza-e-della-brianza',
    'monza',
    'monzabrianza',
    'monzaebrianza',
    'monzaedellabrianza',
    'ms',
    'mt',
    'na',
    'naples',
    'napoli',
    'no',
    'novara',
    'nu',
    'nuoro',
    'og',
    'ogliastra',
    'olbia-tempio',
    'olbiatempio',
    'or',
    'oristano',
    'ot',
    'pa',
    'padova',
    'padua',
    'palermo',
    'parma',
    'pavia',
    'pc',
    'pd',
    'pe',
    'perugia',
    'pesaro-urbino',
    'pesarourbino',
    'pescara',
    'pg',
    'pi',
    'piacenza',
    'pisa',
    'pistoia',
    'pn',
    'po',
    'pordenone',
    'potenza',
    'pr',
    'prato',
    'pt',
    'pu',
    'pv',
    'pz',
    'ra',
    'ragusa',
    'ravenna',
    'rc',
    're',
    'reggio-calabria',
    'reggio-emilia',
    'reggiocalabria',
    'reggioemilia',
    'rg',
    'ri',
    'rieti',
    'rimini',
    'rm',
    'rn',
    'ro',
    'roma',
    'rome',
    'rovigo',
    'sa',
    'salerno',
    'sassari',
    'savona',
    'si',
    'siena',
    'siracusa',
    'so',
    'sondrio',
    'sp',
    'sr',
    'ss',
    'suedtirol',
    'sv',
    'ta',
    'taranto',
    'te',
    'tempio-olbia',
    'tempioolbia',
    'teramo',
    'terni',
    'tn',
    'to',
    'torino',
    'tp',
    'tr',
    'trani-andria-barletta',
    'trani-barletta-andria',
    'traniandriabarletta',
    'tranibarlettaandria',
    'trapani',
    'trentino',
    'trento',
    'treviso',
    'trieste',
    'ts',
    'turin',
    'tv',
    'ud',
    'udine',
    'urbino-pesaro',
    'urbinopesaro',
    'va',
    'varese',
    'vb',
    'vc',
    've',
    'venezia',
    'venice',
    'verbania',
    'vercelli',
    'verona',
    'vi',
    'vibo-valentia',
    'vibovalentia',
    'vicenza',
    'viterbo',
    'vr',
    'vs',
    'vt',
    'vv',
    'blogspot',
    'gov',
    'edu',
    'abr',
    'abruzzo',
    'aosta-valley',
    'aostavalley',
    'bas',
    'basilicata',
    'cal',
    'calabria',
    'cam',
    'campania',
    'emilia-romagna',
    'emiliaromagna',
    'emr',
    'friuli-v-giulia',
    'friuli-ve-giulia',
    'friuli-vegiulia',
    'friuli-venezia-giulia',
    'friuli-veneziagiulia',
    'friuli-vgiulia',
    'friuliv-giulia',
    'friulive-giulia',
    'friulivegiulia',
    'friulivenezia-giulia',
    'friuliveneziagiulia',
    'friulivgiulia',
    'fvg',
    'laz',
    'lazio',
    'lig',
    'liguria',
    'lom',
    'lombardia',
    'lombardy',
    'lucania',
    'mar',
    'marche',
    'mol',
    'molise',
    'piedmont',
    'piemonte',
    'pmn',
    'pug',
    'puglia',
    'sar',
    'sardegna',
    'sardinia',
    'sic',
    'sicilia',
    'sicily',
    'taa',
    'tos',
    'toscana',
    'trentino-a-adige',
    'trentino-aadige',
    'trentino-alto-adige',
    'trentino-altoadige',
    'trentino-s-tirol',
    'trentino-stirol',
    'trentino-sud-tirol',
    'trentino-sudtirol',
    'trentino-sued-tirol',
    'trentino-suedtirol',
    'trentinoa-adige',
    'trentinoaadige',
    'trentinoalto-adige',
    'trentinoaltoadige',
    'trentinos-tirol',
    'trentinostirol',
    'trentinosud-tirol',
    'trentinosudtirol',
    'trentinosued-tirol',
    'trentinosuedtirol',
    'tuscany',
    'umb',
    'umbria',
    'val-d-aosta',
    'val-daosta',
    'vald-aosta',
    'valdaosta',
    'valle-aosta',
    'valle-d-aosta',
    'valle-daosta',
    'valleaosta',
    'valled-aosta',
    'valledaosta',
    'vallee-aoste',
    'valleeaoste',
    'vao',
    'vda',
    'ven',
    'veneto',
    'ag',
    'agrigento',
    'al',
    'alessandria',
    'alto-adige',
    'altoadige',
    'an',
    'ancona',
    'andria-barletta-trani',
    'andria-trani-barletta',
    'andriabarlettatrani',
    'andriatranibarletta',
    'ao',
    'aosta',
    'aoste',
    'ap',
    'aq',
    'aquila',
    'ar',
    'arezzo',
    'ascoli-piceno',
    'ascolipiceno',
    'asti',
    'at',
    'av',
    'avellino',
    'ba',
    'balsan',
    'bari',
    'barletta-trani-andria',
    'barlettatraniandria',
    'belluno',
    'benevento',
    'bergamo',
    'bg',
    'bi',
    'biella',
    'bl',
    'bn',
    'bo',
    'bologna',
    'bolzano',
    'bozen',
    'br',
    'brescia',
    'brindisi',
    'bs',
    'bt',
    'bz',
    'ca',
    'cagliari',
    'caltanissetta',
    'campidano-medio',
    'campidanomedio',
    'campobasso',
    'carbonia-iglesias',
    'carboniaiglesias',
    'carrara-massa',
    'carraramassa',
    'caserta',
    'catania',
    'catanzaro',
    'cb',
    'ce',
    'cesena-forli',
    'cesenaforli',
    'ch',
    'chieti',
    'ci',
    'cl',
    'cn',
    'co',
    'como',
    'cosenza',
    'cr',
    'cremona',
    'crotone',
    'cs',
    'ct',
    'cuneo',
    'cz',
    'dell-ogliastra',
    'dellogliastra',
    'en',
    'enna',
    'fc',
    'fe',
    'fermo',
    'ferrara',
    'fg',
    'fi',
    'firenze',
    'florence',
    'fm',
    'foggia',
    'forli-cesena',
    'forlicesena',
    'fr',
    'frosinone',
    'ge',
    'genoa',
    'genova',
    'go',
    'gorizia',
    'gr',
    'grosseto',
    'iglesias-carbonia',
    'iglesiascarbonia',
    'im',
    'imperia',
    'is',
    'isernia',
    'kr',
    'la-spezia',
    'laquila',
    'laspezia',
    'latina',
    'lc',
    'le',
    'lecce',
    'lecco',
    'li',
    'livorno',
    'lo',
    'lodi',
    'lt',
    'lu',
    'lucca',
    'macerata',
    'mantova',
    'massa-carrara',
    'massacarrara',
    'matera',
    'mb',
    'mc',
    'me',
    'medio-campidano',
    'mediocampidano',
    'messina',
    'mi',
    'milan',
    'milano',
    'mn',
    'mo',
    'modena',
    'monza-brianza',
    'monza-e-della-brianza',
    'monza',
    'monzabrianza',
    'monzaebrianza',
    'monzaedellabrianza',
    'ms',
    'mt',
    'na',
    'naples',
    'napoli',
    'no',
    'novara',
    'nu',
    'nuoro',
    'og',
    'ogliastra',
    'olbia-tempio',
    'olbiatempio',
    'or',
    'oristano',
    'ot',
    'pa',
    'padova',
    'padua',
    'palermo',
    'parma',
    'pavia',
    'pc',
    'pd',
    'pe',
    'perugia',
    'pesaro-urbino',
    'pesarourbino',
    'pescara',
    'pg',
    'pi',
    'piacenza',
    'pisa',
    'pistoia',
    'pn',
    'po',
    'pordenone',
    'potenza',
    'pr',
    'prato',
    'pt',
    'pu',
    'pv',
    'pz',
    'ra',
    'ragusa',
    'ravenna',
    'rc',
    're',
    'reggio-calabria',
    'reggio-emilia',
    'reggiocalabria',
    'reggioemilia',
    'rg',
    'ri',
    'rieti',
    'rimini',
    'rm',
    'rn',
    'ro',
    'roma',
    'rome',
    'rovigo',
    'sa',
    'salerno',
    'sassari',
    'savona',
    'si',
    'siena',
    'siracusa',
    'so',
    'sondrio',
    'sp',
    'sr',
    'ss',
    'suedtirol',
    'sv',
    'ta',
    'taranto',
    'te',
    'tempio-olbia',
    'tempioolbia',
    'teramo',
    'terni',
    'tn',
    'to',
    'torino',
    'tp',
    'tr',
    'trani-andria-barletta',
    'trani-barletta-andria',
    'traniandriabarletta',
    'tranibarlettaandria',
    'trapani',
    'trentino',
    'trento',
    'treviso',
    'trieste',
    'ts',
    'turin',
    'tv',
    'ud',
    'udine',
    'urbino-pesaro',
    'urbinopesaro',
    'va',
    'varese',
    'vb',
    'vc',
    've',
    'venezia',
    'venice',
    'verbania',
    'vercelli',
    'verona',
    'vi',
    'vibo-valentia',
    'vibovalentia',
    'vicenza',
    'viterbo',
    'vr',
    'vs',
    'vt',
    'vv',
    'blogspot'
  ],
  'ポイント': [],
  '慈善': [],
  '닷넷': [],
  'je': ['co', 'net', 'org', 'co', 'net', 'org'],
  'jm': ['*', '*'],
  'works': [],
  'xn--9krt00a': [],
  'lupin': [],
  'jo': [
    'com',
    'org',
    'net',
    'edu',
    'sch',
    'gov',
    'mil',
    'name',
    'com',
    'org',
    'net',
    'edu',
    'sch',
    'gov',
    'mil',
    'name'
  ],
  'jp': [
    'ac',
    'ad',
    'co',
    'ed',
    'go',
    'gr',
    'lg',
    'ne',
    'or',
    'aichi',
    'akita',
    'aomori',
    'chiba',
    'ehime',
    'fukui',
    'fukuoka',
    'fukushima',
    'gifu',
    'gunma',
    'hiroshima',
    'hokkaido',
    'hyogo',
    'ibaraki',
    'ishikawa',
    'iwate',
    'kagawa',
    'kagoshima',
    'kanagawa',
    'kochi',
    'kumamoto',
    'kyoto',
    'mie',
    'miyagi',
    'miyazaki',
    'nagano',
    'nagasaki',
    'nara',
    'niigata',
    'oita',
    'okayama',
    'okinawa',
    'osaka',
    'saga',
    'saitama',
    'shiga',
    'shimane',
    'shizuoka',
    'tochigi',
    'tokushima',
    'tokyo',
    'tottori',
    'toyama',
    'wakayama',
    'yamagata',
    'yamaguchi',
    'yamanashi',
    'xn--4pvxs',
    'xn--vgu402c',
    'xn--c3s14m',
    'xn--f6qx53a',
    'xn--8pvr4u',
    'xn--uist22h',
    'xn--djrs72d6uy',
    'xn--mkru45i',
    'xn--0trq7p7nn',
    'xn--8ltr62k',
    'xn--2m4a15e',
    'xn--efvn9s',
    'xn--32vp30h',
    'xn--4it797k',
    'xn--1lqs71d',
    'xn--5rtp49c',
    'xn--5js045d',
    'xn--ehqz56n',
    'xn--1lqs03n',
    'xn--qqqt11m',
    'xn--kbrq7o',
    'xn--pssu33l',
    'xn--ntsq17g',
    'xn--uisz3g',
    'xn--6btw5a',
    'xn--1ctwo',
    'xn--6orx2r',
    'xn--rht61e',
    'xn--rht27z',
    'xn--djty4k',
    'xn--nit225k',
    'xn--rht3d',
    'xn--klty5x',
    'xn--kltx9a',
    'xn--kltp7d',
    'xn--uuwu58a',
    'xn--zbx025d',
    'xn--ntso0iqx3a',
    'xn--elqq16h',
    'xn--4it168d',
    'xn--klt787d',
    'xn--rny31h',
    'xn--7t0a264c',
    'xn--5rtq34k',
    'xn--k7yn95e',
    'xn--tor131o',
    'xn--d5qv7z876c',
    '*.kawasaki',
    '*.kitakyushu',
    '*.kobe',
    '*.nagoya',
    '*.sapporo',
    '*.sendai',
    '*.yokohama',
    '!city.kawasaki',
    '!city.kitakyushu',
    '!city.kobe',
    '!city.nagoya',
    '!city.sapporo',
    '!city.sendai',
    '!city.yokohama',
    'aisai.aichi',
    'ama.aichi',
    'anjo.aichi',
    'asuke.aichi',
    'chiryu.aichi',
    'chita.aichi',
    'fuso.aichi',
    'gamagori.aichi',
    'handa.aichi',
    'hazu.aichi',
    'hekinan.aichi',
    'higashiura.aichi',
    'ichinomiya.aichi',
    'inazawa.aichi',
    'inuyama.aichi',
    'isshiki.aichi',
    'iwakura.aichi',
    'kanie.aichi',
    'kariya.aichi',
    'kasugai.aichi',
    'kira.aichi',
    'kiyosu.aichi',
    'komaki.aichi',
    'konan.aichi',
    'kota.aichi',
    'mihama.aichi',
    'miyoshi.aichi',
    'nishio.aichi',
    'nisshin.aichi',
    'obu.aichi',
    'oguchi.aichi',
    'oharu.aichi',
    'okazaki.aichi',
    'owariasahi.aichi',
    'seto.aichi',
    'shikatsu.aichi',
    'shinshiro.aichi',
    'shitara.aichi',
    'tahara.aichi',
    'takahama.aichi',
    'tobishima.aichi',
    'toei.aichi',
    'togo.aichi',
    'tokai.aichi',
    'tokoname.aichi',
    'toyoake.aichi',
    'toyohashi.aichi',
    'toyokawa.aichi',
    'toyone.aichi',
    'toyota.aichi',
    'tsushima.aichi',
    'yatomi.aichi',
    'akita.akita',
    'daisen.akita',
    'fujisato.akita',
    'gojome.akita',
    'hachirogata.akita',
    'happou.akita',
    'higashinaruse.akita',
    'honjo.akita',
    'honjyo.akita',
    'ikawa.akita',
    'kamikoani.akita',
    'kamioka.akita',
    'katagami.akita',
    'kazuno.akita',
    'kitaakita.akita',
    'kosaka.akita',
    'kyowa.akita',
    'misato.akita',
    'mitane.akita',
    'moriyoshi.akita',
    'nikaho.akita',
    'noshiro.akita',
    'odate.akita',
    'oga.akita',
    'ogata.akita',
    'semboku.akita',
    'yokote.akita',
    'yurihonjo.akita',
    'aomori.aomori',
    'gonohe.aomori',
    'hachinohe.aomori',
    'hashikami.aomori',
    'hiranai.aomori',
    'hirosaki.aomori',
    'itayanagi.aomori',
    'kuroishi.aomori',
    'misawa.aomori',
    'mutsu.aomori',
    'nakadomari.aomori',
    'noheji.aomori',
    'oirase.aomori',
    'owani.aomori',
    'rokunohe.aomori',
    'sannohe.aomori',
    'shichinohe.aomori',
    'shingo.aomori',
    'takko.aomori',
    'towada.aomori',
    'tsugaru.aomori',
    'tsuruta.aomori',
    'abiko.chiba',
    'asahi.chiba',
    'chonan.chiba',
    'chosei.chiba',
    'choshi.chiba',
    'chuo.chiba',
    'funabashi.chiba',
    'futtsu.chiba',
    'hanamigawa.chiba',
    'ichihara.chiba',
    'ichikawa.chiba',
    'ichinomiya.chiba',
    'inzai.chiba',
    'isumi.chiba',
    'kamagaya.chiba',
    'kamogawa.chiba',
    'kashiwa.chiba',
    'katori.chiba',
    'katsuura.chiba',
    'kimitsu.chiba',
    'kisarazu.chiba',
    'kozaki.chiba',
    'kujukuri.chiba',
    'kyonan.chiba',
    'matsudo.chiba',
    'midori.chiba',
    'mihama.chiba',
    'minamiboso.chiba',
    'mobara.chiba',
    'mutsuzawa.chiba',
    'nagara.chiba',
    'nagareyama.chiba',
    'narashino.chiba',
    'narita.chiba',
    'noda.chiba',
    'oamishirasato.chiba',
    'omigawa.chiba',
    'onjuku.chiba',
    'otaki.chiba',
    'sakae.chiba',
    'sakura.chiba',
    'shimofusa.chiba',
    'shirako.chiba',
    'shiroi.chiba',
    'shisui.chiba',
    'sodegaura.chiba',
    'sosa.chiba',
    'tako.chiba',
    'tateyama.chiba',
    'togane.chiba',
    'tohnosho.chiba',
    'tomisato.chiba',
    'urayasu.chiba',
    'yachimata.chiba',
    'yachiyo.chiba',
    'yokaichiba.chiba',
    'yokoshibahikari.chiba',
    'yotsukaido.chiba',
    'ainan.ehime',
    'honai.ehime',
    'ikata.ehime',
    'imabari.ehime',
    'iyo.ehime',
    'kamijima.ehime',
    'kihoku.ehime',
    'kumakogen.ehime',
    'masaki.ehime',
    'matsuno.ehime',
    'matsuyama.ehime',
    'namikata.ehime',
    'niihama.ehime',
    'ozu.ehime',
    'saijo.ehime',
    'seiyo.ehime',
    'shikokuchuo.ehime',
    'tobe.ehime',
    'toon.ehime',
    'uchiko.ehime',
    'uwajima.ehime',
    'yawatahama.ehime',
    'echizen.fukui',
    'eiheiji.fukui',
    'fukui.fukui',
    'ikeda.fukui',
    'katsuyama.fukui',
    'mihama.fukui',
    'minamiechizen.fukui',
    'obama.fukui',
    'ohi.fukui',
    'ono.fukui',
    'sabae.fukui',
    'sakai.fukui',
    'takahama.fukui',
    'tsuruga.fukui',
    'wakasa.fukui',
    'ashiya.fukuoka',
    'buzen.fukuoka',
    'chikugo.fukuoka',
    'chikuho.fukuoka',
    'chikujo.fukuoka',
    'chikushino.fukuoka',
    'chikuzen.fukuoka',
    'chuo.fukuoka',
    'dazaifu.fukuoka',
    'fukuchi.fukuoka',
    'hakata.fukuoka',
    'higashi.fukuoka',
    'hirokawa.fukuoka',
    'hisayama.fukuoka',
    'iizuka.fukuoka',
    'inatsuki.fukuoka',
    'kaho.fukuoka',
    'kasuga.fukuoka',
    'kasuya.fukuoka',
    'kawara.fukuoka',
    'keisen.fukuoka',
    'koga.fukuoka',
    'kurate.fukuoka',
    'kurogi.fukuoka',
    'kurume.fukuoka',
    'minami.fukuoka',
    'miyako.fukuoka',
    'miyama.fukuoka',
    'miyawaka.fukuoka',
    'mizumaki.fukuoka',
    'munakata.fukuoka',
    'nakagawa.fukuoka',
    'nakama.fukuoka',
    'nishi.fukuoka',
    'nogata.fukuoka',
    'ogori.fukuoka',
    'okagaki.fukuoka',
    'okawa.fukuoka',
    'oki.fukuoka',
    'omuta.fukuoka',
    'onga.fukuoka',
    'onojo.fukuoka',
    'oto.fukuoka',
    'saigawa.fukuoka',
    'sasaguri.fukuoka',
    'shingu.fukuoka',
    'shinyoshitomi.fukuoka',
    'shonai.fukuoka',
    'soeda.fukuoka',
    'sue.fukuoka',
    'tachiarai.fukuoka',
    'tagawa.fukuoka',
    'takata.fukuoka',
    'toho.fukuoka',
    'toyotsu.fukuoka',
    'tsuiki.fukuoka',
    'ukiha.fukuoka',
    'umi.fukuoka',
    'usui.fukuoka',
    'yamada.fukuoka',
    'yame.fukuoka',
    'yanagawa.fukuoka',
    'yukuhashi.fukuoka',
    'aizubange.fukushima',
    'aizumisato.fukushima',
    'aizuwakamatsu.fukushima',
    'asakawa.fukushima',
    'bandai.fukushima',
    'date.fukushima',
    'fukushima.fukushima',
    'furudono.fukushima',
    'futaba.fukushima',
    'hanawa.fukushima',
    'higashi.fukushima',
    'hirata.fukushima',
    'hirono.fukushima',
    'iitate.fukushima',
    'inawashiro.fukushima',
    'ishikawa.fukushima',
    'iwaki.fukushima',
    'izumizaki.fukushima',
    'kagamiishi.fukushima',
    'kaneyama.fukushima',
    'kawamata.fukushima',
    'kitakata.fukushima',
    'kitashiobara.fukushima',
    'koori.fukushima',
    'koriyama.fukushima',
    'kunimi.fukushima',
    'miharu.fukushima',
    'mishima.fukushima',
    'namie.fukushima',
    'nango.fukushima',
    'nishiaizu.fukushima',
    'nishigo.fukushima',
    'okuma.fukushima',
    'omotego.fukushima',
    'ono.fukushima',
    'otama.fukushima',
    'samegawa.fukushima',
    'shimogo.fukushima',
    'shirakawa.fukushima',
    'showa.fukushima',
    'soma.fukushima',
    'sukagawa.fukushima',
    'taishin.fukushima',
    'tamakawa.fukushima',
    'tanagura.fukushima',
    'tenei.fukushima',
    'yabuki.fukushima',
    'yamato.fukushima',
    'yamatsuri.fukushima',
    'yanaizu.fukushima',
    'yugawa.fukushima',
    'anpachi.gifu',
    'ena.gifu',
    'gifu.gifu',
    'ginan.gifu',
    'godo.gifu',
    'gujo.gifu',
    'hashima.gifu',
    'hichiso.gifu',
    'hida.gifu',
    'higashishirakawa.gifu',
    'ibigawa.gifu',
    'ikeda.gifu',
    'kakamigahara.gifu',
    'kani.gifu',
    'kasahara.gifu',
    'kasamatsu.gifu',
    'kawaue.gifu',
    'kitagata.gifu',
    'mino.gifu',
    'minokamo.gifu',
    'mitake.gifu',
    'mizunami.gifu',
    'motosu.gifu',
    'nakatsugawa.gifu',
    'ogaki.gifu',
    'sakahogi.gifu',
    'seki.gifu',
    'sekigahara.gifu',
    'shirakawa.gifu',
    'tajimi.gifu',
    'takayama.gifu',
    'tarui.gifu',
    'toki.gifu',
    'tomika.gifu',
    'wanouchi.gifu',
    'yamagata.gifu',
    'yaotsu.gifu',
    'yoro.gifu',
    'annaka.gunma',
    'chiyoda.gunma',
    'fujioka.gunma',
    'higashiagatsuma.gunma',
    'isesaki.gunma',
    'itakura.gunma',
    'kanna.gunma',
    'kanra.gunma',
    'katashina.gunma',
    'kawaba.gunma',
    'kiryu.gunma',
    'kusatsu.gunma',
    'maebashi.gunma',
    'meiwa.gunma',
    'midori.gunma',
    'minakami.gunma',
    'naganohara.gunma',
    'nakanojo.gunma',
    'nanmoku.gunma',
    'numata.gunma',
    'oizumi.gunma',
    'ora.gunma',
    'ota.gunma',
    'shibukawa.gunma',
    'shimonita.gunma',
    'shinto.gunma',
    'showa.gunma',
    'takasaki.gunma',
    'takayama.gunma',
    'tamamura.gunma',
    'tatebayashi.gunma',
    'tomioka.gunma',
    'tsukiyono.gunma',
    'tsumagoi.gunma',
    'ueno.gunma',
    'yoshioka.gunma',
    'asaminami.hiroshima',
    'daiwa.hiroshima',
    'etajima.hiroshima',
    'fuchu.hiroshima',
    'fukuyama.hiroshima',
    'hatsukaichi.hiroshima',
    'higashihiroshima.hiroshima',
    'hongo.hiroshima',
    'jinsekikogen.hiroshima',
    'kaita.hiroshima',
    'kui.hiroshima',
    'kumano.hiroshima',
    'kure.hiroshima',
    'mihara.hiroshima',
    'miyoshi.hiroshima',
    'naka.hiroshima',
    'onomichi.hiroshima',
    'osakikamijima.hiroshima',
    'otake.hiroshima',
    'saka.hiroshima',
    'sera.hiroshima',
    'seranishi.hiroshima',
    'shinichi.hiroshima',
    'shobara.hiroshima',
    'takehara.hiroshima',
    'abashiri.hokkaido',
    'abira.hokkaido',
    'aibetsu.hokkaido',
    'akabira.hokkaido',
    'akkeshi.hokkaido',
    'asahikawa.hokkaido',
    'ashibetsu.hokkaido',
    'ashoro.hokkaido',
    'assabu.hokkaido',
    'atsuma.hokkaido',
    'bibai.hokkaido',
    'biei.hokkaido',
    'bifuka.hokkaido',
    'bihoro.hokkaido',
    'biratori.hokkaido',
    'chippubetsu.hokkaido',
    'chitose.hokkaido',
    'date.hokkaido',
    'ebetsu.hokkaido',
    'embetsu.hokkaido',
    'eniwa.hokkaido',
    'erimo.hokkaido',
    'esan.hokkaido',
    'esashi.hokkaido',
    'fukagawa.hokkaido',
    'fukushima.hokkaido',
    'furano.hokkaido',
    'furubira.hokkaido',
    'haboro.hokkaido',
    'hakodate.hokkaido',
    'hamatonbetsu.hokkaido',
    'hidaka.hokkaido',
    'higashikagura.hokkaido',
    'higashikawa.hokkaido',
    'hiroo.hokkaido',
    'hokuryu.hokkaido',
    'hokuto.hokkaido',
    'honbetsu.hokkaido',
    'horokanai.hokkaido',
    'horonobe.hokkaido',
    'ikeda.hokkaido',
    'imakane.hokkaido',
    'ishikari.hokkaido',
    'iwamizawa.hokkaido',
    'iwanai.hokkaido',
    'kamifurano.hokkaido',
    'kamikawa.hokkaido',
    'kamishihoro.hokkaido',
    'kamisunagawa.hokkaido',
    'kamoenai.hokkaido',
    'kayabe.hokkaido',
    'kembuchi.hokkaido',
    'kikonai.hokkaido',
    'kimobetsu.hokkaido',
    'kitahiroshima.hokkaido',
    'kitami.hokkaido',
    'kiyosato.hokkaido',
    'koshimizu.hokkaido',
    'kunneppu.hokkaido',
    'kuriyama.hokkaido',
    'kuromatsunai.hokkaido',
    'kushiro.hokkaido',
    'kutchan.hokkaido',
    'kyowa.hokkaido',
    'mashike.hokkaido',
    'matsumae.hokkaido',
    'mikasa.hokkaido',
    'minamifurano.hokkaido',
    'mombetsu.hokkaido',
    'moseushi.hokkaido',
    'mukawa.hokkaido',
    'muroran.hokkaido',
    'naie.hokkaido',
    'nakagawa.hokkaido',
    'nakasatsunai.hokkaido',
    'nakatombetsu.hokkaido',
    'nanae.hokkaido',
    'nanporo.hokkaido',
    'nayoro.hokkaido',
    'nemuro.hokkaido',
    'niikappu.hokkaido',
    'niki.hokkaido',
    'nishiokoppe.hokkaido',
    'noboribetsu.hokkaido',
    'numata.hokkaido',
    'obihiro.hokkaido',
    'obira.hokkaido',
    'oketo.hokkaido',
    'okoppe.hokkaido',
    'otaru.hokkaido',
    'otobe.hokkaido',
    'otofuke.hokkaido',
    'otoineppu.hokkaido',
    'oumu.hokkaido',
    'ozora.hokkaido',
    'pippu.hokkaido',
    'rankoshi.hokkaido',
    'rebun.hokkaido',
    'rikubetsu.hokkaido',
    'rishiri.hokkaido',
    'rishirifuji.hokkaido',
    'saroma.hokkaido',
    'sarufutsu.hokkaido',
    'shakotan.hokkaido',
    'shari.hokkaido',
    'shibecha.hokkaido',
    'shibetsu.hokkaido',
    'shikabe.hokkaido',
    'shikaoi.hokkaido',
    'shimamaki.hokkaido',
    'shimizu.hokkaido',
    'shimokawa.hokkaido',
    'shinshinotsu.hokkaido',
    'shintoku.hokkaido',
    'shiranuka.hokkaido',
    'shiraoi.hokkaido',
    'shiriuchi.hokkaido',
    'sobetsu.hokkaido',
    'sunagawa.hokkaido',
    'taiki.hokkaido',
    'takasu.hokkaido',
    'takikawa.hokkaido',
    'takinoue.hokkaido',
    'teshikaga.hokkaido',
    'tobetsu.hokkaido',
    'tohma.hokkaido',
    'tomakomai.hokkaido',
    'tomari.hokkaido',
    'toya.hokkaido',
    'toyako.hokkaido',
    'toyotomi.hokkaido',
    'toyoura.hokkaido',
    'tsubetsu.hokkaido',
    'tsukigata.hokkaido',
    'urakawa.hokkaido',
    'urausu.hokkaido',
    'uryu.hokkaido',
    'utashinai.hokkaido',
    'wakkanai.hokkaido',
    'wassamu.hokkaido',
    'yakumo.hokkaido',
    'yoichi.hokkaido',
    'aioi.hyogo',
    'akashi.hyogo',
    'ako.hyogo',
    'amagasaki.hyogo',
    'aogaki.hyogo',
    'asago.hyogo',
    'ashiya.hyogo',
    'awaji.hyogo',
    'fukusaki.hyogo',
    'goshiki.hyogo',
    'harima.hyogo',
    'himeji.hyogo',
    'ichikawa.hyogo',
    'inagawa.hyogo',
    'itami.hyogo',
    'kakogawa.hyogo',
    'kamigori.hyogo',
    'kamikawa.hyogo',
    'kasai.hyogo',
    'kasuga.hyogo',
    'kawanishi.hyogo',
    'miki.hyogo',
    'minamiawaji.hyogo',
    'nishinomiya.hyogo',
    'nishiwaki.hyogo',
    'ono.hyogo',
    'sanda.hyogo',
    'sannan.hyogo',
    'sasayama.hyogo',
    'sayo.hyogo',
    'shingu.hyogo',
    'shinonsen.hyogo',
    'shiso.hyogo',
    'sumoto.hyogo',
    'taishi.hyogo',
    'taka.hyogo',
    'takarazuka.hyogo',
    'takasago.hyogo',
    'takino.hyogo',
    'tamba.hyogo',
    'tatsuno.hyogo',
    'toyooka.hyogo',
    'yabu.hyogo',
    'yashiro.hyogo',
    'yoka.hyogo',
    'yokawa.hyogo',
    'ami.ibaraki',
    'asahi.ibaraki',
    'bando.ibaraki',
    'chikusei.ibaraki',
    'daigo.ibaraki',
    'fujishiro.ibaraki',
    'hitachi.ibaraki',
    'hitachinaka.ibaraki',
    'hitachiomiya.ibaraki',
    'hitachiota.ibaraki',
    'ibaraki.ibaraki',
    'ina.ibaraki',
    'inashiki.ibaraki',
    'itako.ibaraki',
    'iwama.ibaraki',
    'joso.ibaraki',
    'kamisu.ibaraki',
    'kasama.ibaraki',
    'kashima.ibaraki',
    'kasumigaura.ibaraki',
    'koga.ibaraki',
    'miho.ibaraki',
    'mito.ibaraki',
    'moriya.ibaraki',
    'naka.ibaraki',
    'namegata.ibaraki',
    'oarai.ibaraki',
    'ogawa.ibaraki',
    'omitama.ibaraki',
    'ryugasaki.ibaraki',
    'sakai.ibaraki',
    'sakuragawa.ibaraki',
    'shimodate.ibaraki',
    'shimotsuma.ibaraki',
    'shirosato.ibaraki',
    'sowa.ibaraki',
    'suifu.ibaraki',
    'takahagi.ibaraki',
    'tamatsukuri.ibaraki',
    'tokai.ibaraki',
    'tomobe.ibaraki',
    'tone.ibaraki',
    'toride.ibaraki',
    'tsuchiura.ibaraki',
    'tsukuba.ibaraki',
    'uchihara.ibaraki',
    'ushiku.ibaraki',
    'yachiyo.ibaraki',
    'yamagata.ibaraki',
    'yawara.ibaraki',
    'yuki.ibaraki',
    'anamizu.ishikawa',
    'hakui.ishikawa',
    'hakusan.ishikawa',
    'kaga.ishikawa',
    'kahoku.ishikawa',
    'kanazawa.ishikawa',
    'kawakita.ishikawa',
    'komatsu.ishikawa',
    'nakanoto.ishikawa',
    'nanao.ishikawa',
    'nomi.ishikawa',
    'nonoichi.ishikawa',
    'noto.ishikawa',
    'shika.ishikawa',
    'suzu.ishikawa',
    'tsubata.ishikawa',
    'tsurugi.ishikawa',
    'uchinada.ishikawa',
    'wajima.ishikawa',
    'fudai.iwate',
    'fujisawa.iwate',
    'hanamaki.iwate',
    'hiraizumi.iwate',
    'hirono.iwate',
    'ichinohe.iwate',
    'ichinoseki.iwate',
    'iwaizumi.iwate',
    'iwate.iwate',
    'joboji.iwate',
    'kamaishi.iwate',
    'kanegasaki.iwate',
    'karumai.iwate',
    'kawai.iwate',
    'kitakami.iwate',
    'kuji.iwate',
    'kunohe.iwate',
    'kuzumaki.iwate',
    'miyako.iwate',
    'mizusawa.iwate',
    'morioka.iwate',
    'ninohe.iwate',
    'noda.iwate',
    'ofunato.iwate',
    'oshu.iwate',
    'otsuchi.iwate',
    'rikuzentakata.iwate',
    'shiwa.iwate',
    'shizukuishi.iwate',
    'sumita.iwate',
    'tanohata.iwate',
    'tono.iwate',
    'yahaba.iwate',
    'yamada.iwate',
    'ayagawa.kagawa',
    'higashikagawa.kagawa',
    'kanonji.kagawa',
    'kotohira.kagawa',
    'manno.kagawa',
    'marugame.kagawa',
    'mitoyo.kagawa',
    'naoshima.kagawa',
    'sanuki.kagawa',
    'tadotsu.kagawa',
    'takamatsu.kagawa',
    'tonosho.kagawa',
    'uchinomi.kagawa',
    'utazu.kagawa',
    'zentsuji.kagawa',
    'akune.kagoshima',
    'amami.kagoshima',
    'hioki.kagoshima',
    'isa.kagoshima',
    'isen.kagoshima',
    'izumi.kagoshima',
    'kagoshima.kagoshima',
    'kanoya.kagoshima',
    'kawanabe.kagoshima',
    'kinko.kagoshima',
    'kouyama.kagoshima',
    'makurazaki.kagoshima',
    'matsumoto.kagoshima',
    'minamitane.kagoshima',
    'nakatane.kagoshima',
    'nishinoomote.kagoshima',
    'satsumasendai.kagoshima',
    'soo.kagoshima',
    'tarumizu.kagoshima',
    'yusui.kagoshima',
    'aikawa.kanagawa',
    'atsugi.kanagawa',
    'ayase.kanagawa',
    'chigasaki.kanagawa',
    'ebina.kanagawa',
    'fujisawa.kanagawa',
    'hadano.kanagawa',
    'hakone.kanagawa',
    'hiratsuka.kanagawa',
    'isehara.kanagawa',
    'kaisei.kanagawa',
    'kamakura.kanagawa',
    'kiyokawa.kanagawa',
    'matsuda.kanagawa',
    'minamiashigara.kanagawa',
    'miura.kanagawa',
    'nakai.kanagawa',
    'ninomiya.kanagawa',
    'odawara.kanagawa',
    'oi.kanagawa',
    'oiso.kanagawa',
    'sagamihara.kanagawa',
    'samukawa.kanagawa',
    'tsukui.kanagawa',
    'yamakita.kanagawa',
    'yamato.kanagawa',
    'yokosuka.kanagawa',
    'yugawara.kanagawa',
    'zama.kanagawa',
    'zushi.kanagawa',
    'aki.kochi',
    'geisei.kochi',
    'hidaka.kochi',
    'higashitsuno.kochi',
    'ino.kochi',
    'kagami.kochi',
    'kami.kochi',
    'kitagawa.kochi',
    'kochi.kochi',
    'mihara.kochi',
    'motoyama.kochi',
    'muroto.kochi',
    'nahari.kochi',
    'nakamura.kochi',
    'nankoku.kochi',
    'nishitosa.kochi',
    'niyodogawa.kochi',
    'ochi.kochi',
    'okawa.kochi',
    'otoyo.kochi',
    'otsuki.kochi',
    'sakawa.kochi',
    'sukumo.kochi',
    'susaki.kochi',
    'tosa.kochi',
    'tosashimizu.kochi',
    'toyo.kochi',
    'tsuno.kochi',
    'umaji.kochi',
    'yasuda.kochi',
    'yusuhara.kochi',
    'amakusa.kumamoto',
    'arao.kumamoto',
    'aso.kumamoto',
    'choyo.kumamoto',
    'gyokuto.kumamoto',
    'kamiamakusa.kumamoto',
    'kikuchi.kumamoto',
    'kumamoto.kumamoto',
    'mashiki.kumamoto',
    'mifune.kumamoto',
    'minamata.kumamoto',
    'minamioguni.kumamoto',
    'nagasu.kumamoto',
    'nishihara.kumamoto',
    'oguni.kumamoto',
    'ozu.kumamoto',
    'sumoto.kumamoto',
    'takamori.kumamoto',
    'uki.kumamoto',
    'uto.kumamoto',
    'yamaga.kumamoto',
    'yamato.kumamoto',
    'yatsushiro.kumamoto',
    'ayabe.kyoto',
    'fukuchiyama.kyoto',
    'higashiyama.kyoto',
    'ide.kyoto',
    'ine.kyoto',
    'joyo.kyoto',
    'kameoka.kyoto',
    'kamo.kyoto',
    'kita.kyoto',
    'kizu.kyoto',
    'kumiyama.kyoto',
    'kyotamba.kyoto',
    'kyotanabe.kyoto',
    'kyotango.kyoto',
    'maizuru.kyoto',
    'minami.kyoto',
    'minamiyamashiro.kyoto',
    'miyazu.kyoto',
    'muko.kyoto',
    'nagaokakyo.kyoto',
    'nakagyo.kyoto',
    'nantan.kyoto',
    'oyamazaki.kyoto',
    'sakyo.kyoto',
    'seika.kyoto',
    'tanabe.kyoto',
    'uji.kyoto',
    'ujitawara.kyoto',
    'wazuka.kyoto',
    'yamashina.kyoto',
    'yawata.kyoto',
    'asahi.mie',
    'inabe.mie',
    'ise.mie',
    'kameyama.mie',
    'kawagoe.mie',
    'kiho.mie',
    'kisosaki.mie',
    'kiwa.mie',
    'komono.mie',
    'kumano.mie',
    'kuwana.mie',
    'matsusaka.mie',
    'meiwa.mie',
    'mihama.mie',
    'minamiise.mie',
    'misugi.mie',
    'miyama.mie',
    'nabari.mie',
    'shima.mie',
    'suzuka.mie',
    'tado.mie',
    'taiki.mie',
    'taki.mie',
    'tamaki.mie',
    'toba.mie',
    'tsu.mie',
    'udono.mie',
    'ureshino.mie',
    'watarai.mie',
    'yokkaichi.mie',
    'furukawa.miyagi',
    'higashimatsushima.miyagi',
    'ishinomaki.miyagi',
    'iwanuma.miyagi',
    'kakuda.miyagi',
    'kami.miyagi',
    'kawasaki.miyagi',
    'marumori.miyagi',
    'matsushima.miyagi',
    'minamisanriku.miyagi',
    'misato.miyagi',
    'murata.miyagi',
    'natori.miyagi',
    'ogawara.miyagi',
    'ohira.miyagi',
    'onagawa.miyagi',
    'osaki.miyagi',
    'rifu.miyagi',
    'semine.miyagi',
    'shibata.miyagi',
    'shichikashuku.miyagi',
    'shikama.miyagi',
    'shiogama.miyagi',
    'shiroishi.miyagi',
    'tagajo.miyagi',
    'taiwa.miyagi',
    'tome.miyagi',
    'tomiya.miyagi',
    'wakuya.miyagi',
    'watari.miyagi',
    'yamamoto.miyagi',
    'zao.miyagi',
    'aya.miyazaki',
    'ebino.miyazaki',
    'gokase.miyazaki',
    'hyuga.miyazaki',
    'kadogawa.miyazaki',
    'kawaminami.miyazaki',
    'kijo.miyazaki',
    'kitagawa.miyazaki',
    'kitakata.miyazaki',
    'kitaura.miyazaki',
    'kobayashi.miyazaki',
    'kunitomi.miyazaki',
    'kushima.miyazaki',
    'mimata.miyazaki',
    'miyakonojo.miyazaki',
    'miyazaki.miyazaki',
    'morotsuka.miyazaki',
    'nichinan.miyazaki',
    'nishimera.miyazaki',
    'nobeoka.miyazaki',
    'saito.miyazaki',
    'shiiba.miyazaki',
    'shintomi.miyazaki',
    'takaharu.miyazaki',
    'takanabe.miyazaki',
    'takazaki.miyazaki',
    'tsuno.miyazaki',
    'achi.nagano',
    'agematsu.nagano',
    'anan.nagano',
    'aoki.nagano',
    'asahi.nagano',
    'azumino.nagano',
    'chikuhoku.nagano',
    'chikuma.nagano',
    'chino.nagano',
    'fujimi.nagano',
    'hakuba.nagano',
    'hara.nagano',
    'hiraya.nagano',
    'iida.nagano',
    'iijima.nagano',
    'iiyama.nagano',
    'iizuna.nagano',
    'ikeda.nagano',
    'ikusaka.nagano',
    'ina.nagano',
    'karuizawa.nagano',
    'kawakami.nagano',
    'kiso.nagano',
    'kisofukushima.nagano',
    'kitaaiki.nagano',
    'komagane.nagano',
    'komoro.nagano',
    'matsukawa.nagano',
    'matsumoto.nagano',
    'miasa.nagano',
    'minamiaiki.nagano',
    'minamimaki.nagano',
    'minamiminowa.nagano',
    'minowa.nagano',
    'miyada.nagano',
    'miyota.nagano',
    'mochizuki.nagano',
    'nagano.nagano',
    'nagawa.nagano',
    'nagiso.nagano',
    'nakagawa.nagano',
    'nakano.nagano',
    'nozawaonsen.nagano',
    'obuse.nagano',
    'ogawa.nagano',
    'okaya.nagano',
    'omachi.nagano',
    'omi.nagano',
    'ookuwa.nagano',
    'ooshika.nagano',
    'otaki.nagano',
    'otari.nagano',
    'sakae.nagano',
    'sakaki.nagano',
    'saku.nagano',
    'sakuho.nagano',
    'shimosuwa.nagano',
    'shinanomachi.nagano',
    'shiojiri.nagano',
    'suwa.nagano',
    'suzaka.nagano',
    'takagi.nagano',
    'takamori.nagano',
    'takayama.nagano',
    'tateshina.nagano',
    'tatsuno.nagano',
    'togakushi.nagano',
    'togura.nagano',
    'tomi.nagano',
    'ueda.nagano',
    'wada.nagano',
    'yamagata.nagano',
    'yamanouchi.nagano',
    'yasaka.nagano',
    'yasuoka.nagano',
    'chijiwa.nagasaki',
    'futsu.nagasaki',
    'goto.nagasaki',
    'hasami.nagasaki',
    'hirado.nagasaki',
    'iki.nagasaki',
    'isahaya.nagasaki',
    'kawatana.nagasaki',
    'kuchinotsu.nagasaki',
    'matsuura.nagasaki',
    'nagasaki.nagasaki',
    'obama.nagasaki',
    'omura.nagasaki',
    'oseto.nagasaki',
    'saikai.nagasaki',
    'sasebo.nagasaki',
    'seihi.nagasaki',
    'shimabara.nagasaki',
    'shinkamigoto.nagasaki',
    'togitsu.nagasaki',
    'tsushima.nagasaki',
    'unzen.nagasaki',
    'ando.nara',
    'gose.nara',
    'heguri.nara',
    'higashiyoshino.nara',
    'ikaruga.nara',
    'ikoma.nara',
    'kamikitayama.nara',
    'kanmaki.nara',
    'kashiba.nara',
    'kashihara.nara',
    'katsuragi.nara',
    'kawai.nara',
    'kawakami.nara',
    'kawanishi.nara',
    'koryo.nara',
    'kurotaki.nara',
    'mitsue.nara',
    'miyake.nara',
    'nara.nara',
    'nosegawa.nara',
    'oji.nara',
    'ouda.nara',
    'oyodo.nara',
    'sakurai.nara',
    'sango.nara',
    'shimoichi.nara',
    'shimokitayama.nara',
    'shinjo.nara',
    'soni.nara',
    'takatori.nara',
    'tawaramoto.nara',
    'tenkawa.nara',
    'tenri.nara',
    'uda.nara',
    'yamatokoriyama.nara',
    'yamatotakada.nara',
    'yamazoe.nara',
    'yoshino.nara',
    'aga.niigata',
    'agano.niigata',
    'gosen.niigata',
    'itoigawa.niigata',
    'izumozaki.niigata',
    'joetsu.niigata',
    'kamo.niigata',
    'kariwa.niigata',
    'kashiwazaki.niigata',
    'minamiuonuma.niigata',
    'mitsuke.niigata',
    'muika.niigata',
    'murakami.niigata',
    'myoko.niigata',
    'nagaoka.niigata',
    'niigata.niigata',
    'ojiya.niigata',
    'omi.niigata',
    'sado.niigata',
    'sanjo.niigata',
    'seiro.niigata',
    'seirou.niigata',
    'sekikawa.niigata',
    'shibata.niigata',
    'tagami.niigata',
    'tainai.niigata',
    'tochio.niigata',
    'tokamachi.niigata',
    'tsubame.niigata',
    'tsunan.niigata',
    'uonuma.niigata',
    'yahiko.niigata',
    'yoita.niigata',
    'yuzawa.niigata',
    'beppu.oita',
    'bungoono.oita',
    'bungotakada.oita',
    'hasama.oita',
    'hiji.oita',
    'himeshima.oita',
    'hita.oita',
    'kamitsue.oita',
    'kokonoe.oita',
    'kuju.oita',
    'kunisaki.oita',
    'kusu.oita',
    'oita.oita',
    'saiki.oita',
    'taketa.oita',
    'tsukumi.oita',
    'usa.oita',
    'usuki.oita',
    'yufu.oita',
    'akaiwa.okayama',
    'asakuchi.okayama',
    'bizen.okayama',
    'hayashima.okayama',
    'ibara.okayama',
    'kagamino.okayama',
    'kasaoka.okayama',
    'kibichuo.okayama',
    'kumenan.okayama',
    'kurashiki.okayama',
    'maniwa.okayama',
    'misaki.okayama',
    'nagi.okayama',
    'niimi.okayama',
    'nishiawakura.okayama',
    'okayama.okayama',
    'satosho.okayama',
    'setouchi.okayama',
    'shinjo.okayama',
    'shoo.okayama',
    'soja.okayama',
    'takahashi.okayama',
    'tamano.okayama',
    'tsuyama.okayama',
    'wake.okayama',
    'yakage.okayama',
    'aguni.okinawa',
    'ginowan.okinawa',
    'ginoza.okinawa',
    'gushikami.okinawa',
    'haebaru.okinawa',
    'higashi.okinawa',
    'hirara.okinawa',
    'iheya.okinawa',
    'ishigaki.okinawa',
    'ishikawa.okinawa',
    'itoman.okinawa',
    'izena.okinawa',
    'kadena.okinawa',
    'kin.okinawa',
    'kitadaito.okinawa',
    'kitanakagusuku.okinawa',
    'kumejima.okinawa',
    'kunigami.okinawa',
    'minamidaito.okinawa',
    'motobu.okinawa',
    'nago.okinawa',
    'naha.okinawa',
    'nakagusuku.okinawa',
    'nakijin.okinawa',
    'nanjo.okinawa',
    'nishihara.okinawa',
    'ogimi.okinawa',
    'okinawa.okinawa',
    'onna.okinawa',
    'shimoji.okinawa',
    'taketomi.okinawa',
    'tarama.okinawa',
    'tokashiki.okinawa',
    'tomigusuku.okinawa',
    'tonaki.okinawa',
    'urasoe.okinawa',
    'uruma.okinawa',
    'yaese.okinawa',
    'yomitan.okinawa',
    'yonabaru.okinawa',
    'yonaguni.okinawa',
    'zamami.okinawa',
    'abeno.osaka',
    'chihayaakasaka.osaka',
    'chuo.osaka',
    'daito.osaka',
    'fujiidera.osaka',
    'habikino.osaka',
    'hannan.osaka',
    'higashiosaka.osaka',
    'higashisumiyoshi.osaka',
    'higashiyodogawa.osaka',
    'hirakata.osaka',
    'ibaraki.osaka',
    'ikeda.osaka',
    'izumi.osaka',
    'izumiotsu.osaka',
    'izumisano.osaka',
    'kadoma.osaka',
    'kaizuka.osaka',
    'kanan.osaka',
    'kashiwara.osaka',
    'katano.osaka',
    'kawachinagano.osaka',
    'kishiwada.osaka',
    'kita.osaka',
    'kumatori.osaka',
    'matsubara.osaka',
    'minato.osaka',
    'minoh.osaka',
    'misaki.osaka',
    'moriguchi.osaka',
    'neyagawa.osaka',
    'nishi.osaka',
    'nose.osaka',
    'osakasayama.osaka',
    'sakai.osaka',
    'sayama.osaka',
    'sennan.osaka',
    'settsu.osaka',
    'shijonawate.osaka',
    'shimamoto.osaka',
    'suita.osaka',
    'tadaoka.osaka',
    'taishi.osaka',
    'tajiri.osaka',
    'takaishi.osaka',
    'takatsuki.osaka',
    'tondabayashi.osaka',
    'toyonaka.osaka',
    'toyono.osaka',
    'yao.osaka',
    'ariake.saga',
    'arita.saga',
    'fukudomi.saga',
    'genkai.saga',
    'hamatama.saga',
    'hizen.saga',
    'imari.saga',
    'kamimine.saga',
    'kanzaki.saga',
    'karatsu.saga',
    'kashima.saga',
    'kitagata.saga',
    'kitahata.saga',
    'kiyama.saga',
    'kouhoku.saga',
    'kyuragi.saga',
    'nishiarita.saga',
    'ogi.saga',
    'omachi.saga',
    'ouchi.saga',
    'saga.saga',
    'shiroishi.saga',
    'taku.saga',
    'tara.saga',
    'tosu.saga',
    'yoshinogari.saga',
    'arakawa.saitama',
    'asaka.saitama',
    'chichibu.saitama',
    'fujimi.saitama',
    'fujimino.saitama',
    'fukaya.saitama',
    'hanno.saitama',
    'hanyu.saitama',
    'hasuda.saitama',
    'hatogaya.saitama',
    'hatoyama.saitama',
    'hidaka.saitama',
    'higashichichibu.saitama',
    'higashimatsuyama.saitama',
    'honjo.saitama',
    'ina.saitama',
    'iruma.saitama',
    'iwatsuki.saitama',
    'kamiizumi.saitama',
    'kamikawa.saitama',
    'kamisato.saitama',
    'kasukabe.saitama',
    'kawagoe.saitama',
    'kawaguchi.saitama',
    'kawajima.saitama',
    'kazo.saitama',
    'kitamoto.saitama',
    'koshigaya.saitama',
    'kounosu.saitama',
    'kuki.saitama',
    'kumagaya.saitama',
    'matsubushi.saitama',
    'minano.saitama',
    'misato.saitama',
    'miyashiro.saitama',
    'miyoshi.saitama',
    'moroyama.saitama',
    'nagatoro.saitama',
    'namegawa.saitama',
    'niiza.saitama',
    'ogano.saitama',
    'ogawa.saitama',
    'ogose.saitama',
    'okegawa.saitama',
    'omiya.saitama',
    'otaki.saitama',
    'ranzan.saitama',
    'ryokami.saitama',
    'saitama.saitama',
    'sakado.saitama',
    'satte.saitama',
    'sayama.saitama',
    'shiki.saitama',
    'shiraoka.saitama',
    'soka.saitama',
    'sugito.saitama',
    'toda.saitama',
    'tokigawa.saitama',
    'tokorozawa.saitama',
    'tsurugashima.saitama',
    'urawa.saitama',
    'warabi.saitama',
    'yashio.saitama',
    'yokoze.saitama',
    'yono.saitama',
    'yorii.saitama',
    'yoshida.saitama',
    'yoshikawa.saitama',
    'yoshimi.saitama',
    'aisho.shiga',
    'gamo.shiga',
    'higashiomi.shiga',
    'hikone.shiga',
    'koka.shiga',
    'konan.shiga',
    'kosei.shiga',
    'koto.shiga',
    'kusatsu.shiga',
    'maibara.shiga',
    'moriyama.shiga',
    'nagahama.shiga',
    'nishiazai.shiga',
    'notogawa.shiga',
    'omihachiman.shiga',
    'otsu.shiga',
    'ritto.shiga',
    'ryuoh.shiga',
    'takashima.shiga',
    'takatsuki.shiga',
    'torahime.shiga',
    'toyosato.shiga',
    'yasu.shiga',
    'akagi.shimane',
    'ama.shimane',
    'gotsu.shimane',
    'hamada.shimane',
    'higashiizumo.shimane',
    'hikawa.shimane',
    'hikimi.shimane',
    'izumo.shimane',
    'kakinoki.shimane',
    'masuda.shimane',
    'matsue.shimane',
    'misato.shimane',
    'nishinoshima.shimane',
    'ohda.shimane',
    'okinoshima.shimane',
    'okuizumo.shimane',
    'shimane.shimane',
    'tamayu.shimane',
    'tsuwano.shimane',
    'unnan.shimane',
    'yakumo.shimane',
    'yasugi.shimane',
    'yatsuka.shimane',
    'arai.shizuoka',
    'atami.shizuoka',
    'fuji.shizuoka',
    'fujieda.shizuoka',
    'fujikawa.shizuoka',
    'fujinomiya.shizuoka',
    'fukuroi.shizuoka',
    'gotemba.shizuoka',
    'haibara.shizuoka',
    'hamamatsu.shizuoka',
    'higashiizu.shizuoka',
    'ito.shizuoka',
    'iwata.shizuoka',
    'izu.shizuoka',
    'izunokuni.shizuoka',
    'kakegawa.shizuoka',
    'kannami.shizuoka',
    'kawanehon.shizuoka',
    'kawazu.shizuoka',
    'kikugawa.shizuoka',
    'kosai.shizuoka',
    'makinohara.shizuoka',
    'matsuzaki.shizuoka',
    'minamiizu.shizuoka',
    'mishima.shizuoka',
    'morimachi.shizuoka',
    'nishiizu.shizuoka',
    'numazu.shizuoka',
    'omaezaki.shizuoka',
    'shimada.shizuoka',
    'shimizu.shizuoka',
    'shimoda.shizuoka',
    'shizuoka.shizuoka',
    'susono.shizuoka',
    'yaizu.shizuoka',
    'yoshida.shizuoka',
    'ashikaga.tochigi',
    'bato.tochigi',
    'haga.tochigi',
    'ichikai.tochigi',
    'iwafune.tochigi',
    'kaminokawa.tochigi',
    'kanuma.tochigi',
    'karasuyama.tochigi',
    'kuroiso.tochigi',
    'mashiko.tochigi',
    'mibu.tochigi',
    'moka.tochigi',
    'motegi.tochigi',
    'nasu.tochigi',
    'nasushiobara.tochigi',
    'nikko.tochigi',
    'nishikata.tochigi',
    'nogi.tochigi',
    'ohira.tochigi',
    'ohtawara.tochigi',
    'oyama.tochigi',
    'sakura.tochigi',
    'sano.tochigi',
    'shimotsuke.tochigi',
    'shioya.tochigi',
    'takanezawa.tochigi',
    'tochigi.tochigi',
    'tsuga.tochigi',
    'ujiie.tochigi',
    'utsunomiya.tochigi',
    'yaita.tochigi',
    'aizumi.tokushima',
    'anan.tokushima',
    'ichiba.tokushima',
    'itano.tokushima',
    'kainan.tokushima',
    'komatsushima.tokushima',
    'matsushige.tokushima',
    'mima.tokushima',
    'minami.tokushima',
    'miyoshi.tokushima',
    'mugi.tokushima',
    'nakagawa.tokushima',
    'naruto.tokushima',
    'sanagochi.tokushima',
    'shishikui.tokushima',
    'tokushima.tokushima',
    'wajiki.tokushima',
    'adachi.tokyo',
    'akiruno.tokyo',
    'akishima.tokyo',
    'aogashima.tokyo',
    'arakawa.tokyo',
    'bunkyo.tokyo',
    'chiyoda.tokyo',
    'chofu.tokyo',
    'chuo.tokyo',
    'edogawa.tokyo',
    'fuchu.tokyo',
    'fussa.tokyo',
    'hachijo.tokyo',
    'hachioji.tokyo',
    'hamura.tokyo',
    'higashikurume.tokyo',
    'higashimurayama.tokyo',
    'higashiyamato.tokyo',
    'hino.tokyo',
    'hinode.tokyo',
    'hinohara.tokyo',
    'inagi.tokyo',
    'itabashi.tokyo',
    'katsushika.tokyo',
    'kita.tokyo',
    'kiyose.tokyo',
    'kodaira.tokyo',
    'koganei.tokyo',
    'kokubunji.tokyo',
    'komae.tokyo',
    'koto.tokyo',
    'kouzushima.tokyo',
    'kunitachi.tokyo',
    'machida.tokyo',
    'meguro.tokyo',
    'minato.tokyo',
    'mitaka.tokyo',
    'mizuho.tokyo',
    'musashimurayama.tokyo',
    'musashino.tokyo',
    'nakano.tokyo',
    'nerima.tokyo',
    'ogasawara.tokyo',
    'okutama.tokyo',
    'ome.tokyo',
    'oshima.tokyo',
    'ota.tokyo',
    'setagaya.tokyo',
    'shibuya.tokyo',
    'shinagawa.tokyo',
    'shinjuku.tokyo',
    'suginami.tokyo',
    'sumida.tokyo',
    'tachikawa.tokyo',
    'taito.tokyo',
    'tama.tokyo',
    'toshima.tokyo',
    'chizu.tottori',
    'hino.tottori',
    'kawahara.tottori',
    'koge.tottori',
    'kotoura.tottori',
    'misasa.tottori',
    'nanbu.tottori',
    'nichinan.tottori',
    'sakaiminato.tottori',
    'tottori.tottori',
    'wakasa.tottori',
    'yazu.tottori',
    'yonago.tottori',
    'asahi.toyama',
    'fuchu.toyama',
    'fukumitsu.toyama',
    'funahashi.toyama',
    'himi.toyama',
    'imizu.toyama',
    'inami.toyama',
    'johana.toyama',
    'kamiichi.toyama',
    'kurobe.toyama',
    'nakaniikawa.toyama',
    'namerikawa.toyama',
    'nanto.toyama',
    'nyuzen.toyama',
    'oyabe.toyama',
    'taira.toyama',
    'takaoka.toyama',
    'tateyama.toyama',
    'toga.toyama',
    'tonami.toyama',
    'toyama.toyama',
    'unazuki.toyama',
    'uozu.toyama',
    'yamada.toyama',
    'arida.wakayama',
    'aridagawa.wakayama',
    'gobo.wakayama',
    'hashimoto.wakayama',
    'hidaka.wakayama',
    'hirogawa.wakayama',
    'inami.wakayama',
    'iwade.wakayama',
    'kainan.wakayama',
    'kamitonda.wakayama',
    'katsuragi.wakayama',
    'kimino.wakayama',
    'kinokawa.wakayama',
    'kitayama.wakayama',
    'koya.wakayama',
    'koza.wakayama',
    'kozagawa.wakayama',
    'kudoyama.wakayama',
    'kushimoto.wakayama',
    'mihama.wakayama',
    'misato.wakayama',
    'nachikatsuura.wakayama',
    'shingu.wakayama',
    'shirahama.wakayama',
    'taiji.wakayama',
    'tanabe.wakayama',
    'wakayama.wakayama',
    'yuasa.wakayama',
    'yura.wakayama',
    'asahi.yamagata',
    'funagata.yamagata',
    'higashine.yamagata',
    'iide.yamagata',
    'kahoku.yamagata',
    'kaminoyama.yamagata',
    'kaneyama.yamagata',
    'kawanishi.yamagata',
    'mamurogawa.yamagata',
    'mikawa.yamagata',
    'murayama.yamagata',
    'nagai.yamagata',
    'nakayama.yamagata',
    'nanyo.yamagata',
    'nishikawa.yamagata',
    'obanazawa.yamagata',
    'oe.yamagata',
    'oguni.yamagata',
    'ohkura.yamagata',
    'oishida.yamagata',
    'sagae.yamagata',
    'sakata.yamagata',
    'sakegawa.yamagata',
    'shinjo.yamagata',
    'shirataka.yamagata',
    'shonai.yamagata',
    'takahata.yamagata',
    'tendo.yamagata',
    'tozawa.yamagata',
    'tsuruoka.yamagata',
    'yamagata.yamagata',
    'yamanobe.yamagata',
    'yonezawa.yamagata',
    'yuza.yamagata',
    'abu.yamaguchi',
    'hagi.yamaguchi',
    'hikari.yamaguchi',
    'hofu.yamaguchi',
    'iwakuni.yamaguchi',
    'kudamatsu.yamaguchi',
    'mitou.yamaguchi',
    'nagato.yamaguchi',
    'oshima.yamaguchi',
    'shimonoseki.yamaguchi',
    'shunan.yamaguchi',
    'tabuse.yamaguchi',
    'tokuyama.yamaguchi',
    'toyota.yamaguchi',
    'ube.yamaguchi',
    'yuu.yamaguchi',
    'chuo.yamanashi',
    'doshi.yamanashi',
    'fuefuki.yamanashi',
    'fujikawa.yamanashi',
    'fujikawaguchiko.yamanashi',
    'fujiyoshida.yamanashi',
    'hayakawa.yamanashi',
    'hokuto.yamanashi',
    'ichikawamisato.yamanashi',
    'kai.yamanashi',
    'kofu.yamanashi',
    'koshu.yamanashi',
    'kosuge.yamanashi',
    'minami-alps.yamanashi',
    'minobu.yamanashi',
    'nakamichi.yamanashi',
    'nanbu.yamanashi',
    'narusawa.yamanashi',
    'nirasaki.yamanashi',
    'nishikatsura.yamanashi',
    'oshino.yamanashi',
    'otsuki.yamanashi',
    'showa.yamanashi',
    'tabayama.yamanashi',
    'tsuru.yamanashi',
    'uenohara.yamanashi',
    'yamanakako.yamanashi',
    'yamanashi.yamanashi',
    'blogspot',
    'ac',
    'ad',
    'co',
    'ed',
    'go',
    'gr',
    'lg',
    'ne',
    'or',
    'aichi',
    'akita',
    'aomori',
    'chiba',
    'ehime',
    'fukui',
    'fukuoka',
    'fukushima',
    'gifu',
    'gunma',
    'hiroshima',
    'hokkaido',
    'hyogo',
    'ibaraki',
    'ishikawa',
    'iwate',
    'kagawa',
    'kagoshima',
    'kanagawa',
    'kochi',
    'kumamoto',
    'kyoto',
    'mie',
    'miyagi',
    'miyazaki',
    'nagano',
    'nagasaki',
    'nara',
    'niigata',
    'oita',
    'okayama',
    'okinawa',
    'osaka',
    'saga',
    'saitama',
    'shiga',
    'shimane',
    'shizuoka',
    'tochigi',
    'tokushima',
    'tokyo',
    'tottori',
    'toyama',
    'wakayama',
    'yamagata',
    'yamaguchi',
    'yamanashi',
    '栃木',
    '愛知',
    '愛媛',
    '兵庫',
    '熊本',
    '茨城',
    '北海道',
    '千葉',
    '和歌山',
    '長崎',
    '長野',
    '新潟',
    '青森',
    '静岡',
    '東京',
    '石川',
    '埼玉',
    '三重',
    '京都',
    '佐賀',
    '大分',
    '大阪',
    '奈良',
    '宮城',
    '宮崎',
    '富山',
    '山口',
    '山形',
    '山梨',
    '岩手',
    '岐阜',
    '岡山',
    '島根',
    '広島',
    '徳島',
    '沖縄',
    '滋賀',
    '神奈川',
    '福井',
    '福岡',
    '福島',
    '秋田',
    '群馬',
    '香川',
    '高知',
    '鳥取',
    '鹿児島',
    '*.kawasaki',
    '*.kitakyushu',
    '*.kobe',
    '*.nagoya',
    '*.sapporo',
    '*.sendai',
    '*.yokohama',
    '!city.kawasaki',
    '!city.kitakyushu',
    '!city.kobe',
    '!city.nagoya',
    '!city.sapporo',
    '!city.sendai',
    '!city.yokohama',
    'aisai.aichi',
    'ama.aichi',
    'anjo.aichi',
    'asuke.aichi',
    'chiryu.aichi',
    'chita.aichi',
    'fuso.aichi',
    'gamagori.aichi',
    'handa.aichi',
    'hazu.aichi',
    'hekinan.aichi',
    'higashiura.aichi',
    'ichinomiya.aichi',
    'inazawa.aichi',
    'inuyama.aichi',
    'isshiki.aichi',
    'iwakura.aichi',
    'kanie.aichi',
    'kariya.aichi',
    'kasugai.aichi',
    'kira.aichi',
    'kiyosu.aichi',
    'komaki.aichi',
    'konan.aichi',
    'kota.aichi',
    'mihama.aichi',
    'miyoshi.aichi',
    'nishio.aichi',
    'nisshin.aichi',
    'obu.aichi',
    'oguchi.aichi',
    'oharu.aichi',
    'okazaki.aichi',
    'owariasahi.aichi',
    'seto.aichi',
    'shikatsu.aichi',
    'shinshiro.aichi',
    'shitara.aichi',
    'tahara.aichi',
    'takahama.aichi',
    'tobishima.aichi',
    'toei.aichi',
    'togo.aichi',
    'tokai.aichi',
    'tokoname.aichi',
    'toyoake.aichi',
    'toyohashi.aichi',
    'toyokawa.aichi',
    'toyone.aichi',
    'toyota.aichi',
    'tsushima.aichi',
    'yatomi.aichi',
    'akita.akita',
    'daisen.akita',
    'fujisato.akita',
    'gojome.akita',
    'hachirogata.akita',
    'happou.akita',
    'higashinaruse.akita',
    'honjo.akita',
    'honjyo.akita',
    'ikawa.akita',
    'kamikoani.akita',
    'kamioka.akita',
    'katagami.akita',
    'kazuno.akita',
    'kitaakita.akita',
    'kosaka.akita',
    'kyowa.akita',
    'misato.akita',
    'mitane.akita',
    'moriyoshi.akita',
    'nikaho.akita',
    'noshiro.akita',
    'odate.akita',
    'oga.akita',
    'ogata.akita',
    'semboku.akita',
    'yokote.akita',
    'yurihonjo.akita',
    'aomori.aomori',
    'gonohe.aomori',
    'hachinohe.aomori',
    'hashikami.aomori',
    'hiranai.aomori',
    'hirosaki.aomori',
    'itayanagi.aomori',
    'kuroishi.aomori',
    'misawa.aomori',
    'mutsu.aomori',
    'nakadomari.aomori',
    'noheji.aomori',
    'oirase.aomori',
    'owani.aomori',
    'rokunohe.aomori',
    'sannohe.aomori',
    'shichinohe.aomori',
    'shingo.aomori',
    'takko.aomori',
    'towada.aomori',
    'tsugaru.aomori',
    'tsuruta.aomori',
    'abiko.chiba',
    'asahi.chiba',
    'chonan.chiba',
    'chosei.chiba',
    'choshi.chiba',
    'chuo.chiba',
    'funabashi.chiba',
    'futtsu.chiba',
    'hanamigawa.chiba',
    'ichihara.chiba',
    'ichikawa.chiba',
    'ichinomiya.chiba',
    'inzai.chiba',
    'isumi.chiba',
    'kamagaya.chiba',
    'kamogawa.chiba',
    'kashiwa.chiba',
    'katori.chiba',
    'katsuura.chiba',
    'kimitsu.chiba',
    'kisarazu.chiba',
    'kozaki.chiba',
    'kujukuri.chiba',
    'kyonan.chiba',
    'matsudo.chiba',
    'midori.chiba',
    'mihama.chiba',
    'minamiboso.chiba',
    'mobara.chiba',
    'mutsuzawa.chiba',
    'nagara.chiba',
    'nagareyama.chiba',
    'narashino.chiba',
    'narita.chiba',
    'noda.chiba',
    'oamishirasato.chiba',
    'omigawa.chiba',
    'onjuku.chiba',
    'otaki.chiba',
    'sakae.chiba',
    'sakura.chiba',
    'shimofusa.chiba',
    'shirako.chiba',
    'shiroi.chiba',
    'shisui.chiba',
    'sodegaura.chiba',
    'sosa.chiba',
    'tako.chiba',
    'tateyama.chiba',
    'togane.chiba',
    'tohnosho.chiba',
    'tomisato.chiba',
    'urayasu.chiba',
    'yachimata.chiba',
    'yachiyo.chiba',
    'yokaichiba.chiba',
    'yokoshibahikari.chiba',
    'yotsukaido.chiba',
    'ainan.ehime',
    'honai.ehime',
    'ikata.ehime',
    'imabari.ehime',
    'iyo.ehime',
    'kamijima.ehime',
    'kihoku.ehime',
    'kumakogen.ehime',
    'masaki.ehime',
    'matsuno.ehime',
    'matsuyama.ehime',
    'namikata.ehime',
    'niihama.ehime',
    'ozu.ehime',
    'saijo.ehime',
    'seiyo.ehime',
    'shikokuchuo.ehime',
    'tobe.ehime',
    'toon.ehime',
    'uchiko.ehime',
    'uwajima.ehime',
    'yawatahama.ehime',
    'echizen.fukui',
    'eiheiji.fukui',
    'fukui.fukui',
    'ikeda.fukui',
    'katsuyama.fukui',
    'mihama.fukui',
    'minamiechizen.fukui',
    'obama.fukui',
    'ohi.fukui',
    'ono.fukui',
    'sabae.fukui',
    'sakai.fukui',
    'takahama.fukui',
    'tsuruga.fukui',
    'wakasa.fukui',
    'ashiya.fukuoka',
    'buzen.fukuoka',
    'chikugo.fukuoka',
    'chikuho.fukuoka',
    'chikujo.fukuoka',
    'chikushino.fukuoka',
    'chikuzen.fukuoka',
    'chuo.fukuoka',
    'dazaifu.fukuoka',
    'fukuchi.fukuoka',
    'hakata.fukuoka',
    'higashi.fukuoka',
    'hirokawa.fukuoka',
    'hisayama.fukuoka',
    'iizuka.fukuoka',
    'inatsuki.fukuoka',
    'kaho.fukuoka',
    'kasuga.fukuoka',
    'kasuya.fukuoka',
    'kawara.fukuoka',
    'keisen.fukuoka',
    'koga.fukuoka',
    'kurate.fukuoka',
    'kurogi.fukuoka',
    'kurume.fukuoka',
    'minami.fukuoka',
    'miyako.fukuoka',
    'miyama.fukuoka',
    'miyawaka.fukuoka',
    'mizumaki.fukuoka',
    'munakata.fukuoka',
    'nakagawa.fukuoka',
    'nakama.fukuoka',
    'nishi.fukuoka',
    'nogata.fukuoka',
    'ogori.fukuoka',
    'okagaki.fukuoka',
    'okawa.fukuoka',
    'oki.fukuoka',
    'omuta.fukuoka',
    'onga.fukuoka',
    'onojo.fukuoka',
    'oto.fukuoka',
    'saigawa.fukuoka',
    'sasaguri.fukuoka',
    'shingu.fukuoka',
    'shinyoshitomi.fukuoka',
    'shonai.fukuoka',
    'soeda.fukuoka',
    'sue.fukuoka',
    'tachiarai.fukuoka',
    'tagawa.fukuoka',
    'takata.fukuoka',
    'toho.fukuoka',
    'toyotsu.fukuoka',
    'tsuiki.fukuoka',
    'ukiha.fukuoka',
    'umi.fukuoka',
    'usui.fukuoka',
    'yamada.fukuoka',
    'yame.fukuoka',
    'yanagawa.fukuoka',
    'yukuhashi.fukuoka',
    'aizubange.fukushima',
    'aizumisato.fukushima',
    'aizuwakamatsu.fukushima',
    'asakawa.fukushima',
    'bandai.fukushima',
    'date.fukushima',
    'fukushima.fukushima',
    'furudono.fukushima',
    'futaba.fukushima',
    'hanawa.fukushima',
    'higashi.fukushima',
    'hirata.fukushima',
    'hirono.fukushima',
    'iitate.fukushima',
    'inawashiro.fukushima',
    'ishikawa.fukushima',
    'iwaki.fukushima',
    'izumizaki.fukushima',
    'kagamiishi.fukushima',
    'kaneyama.fukushima',
    'kawamata.fukushima',
    'kitakata.fukushima',
    'kitashiobara.fukushima',
    'koori.fukushima',
    'koriyama.fukushima',
    'kunimi.fukushima',
    'miharu.fukushima',
    'mishima.fukushima',
    'namie.fukushima',
    'nango.fukushima',
    'nishiaizu.fukushima',
    'nishigo.fukushima',
    'okuma.fukushima',
    'omotego.fukushima',
    'ono.fukushima',
    'otama.fukushima',
    'samegawa.fukushima',
    'shimogo.fukushima',
    'shirakawa.fukushima',
    'showa.fukushima',
    'soma.fukushima',
    'sukagawa.fukushima',
    'taishin.fukushima',
    'tamakawa.fukushima',
    'tanagura.fukushima',
    'tenei.fukushima',
    'yabuki.fukushima',
    'yamato.fukushima',
    'yamatsuri.fukushima',
    'yanaizu.fukushima',
    'yugawa.fukushima',
    'anpachi.gifu',
    'ena.gifu',
    'gifu.gifu',
    'ginan.gifu',
    'godo.gifu',
    'gujo.gifu',
    'hashima.gifu',
    'hichiso.gifu',
    'hida.gifu',
    'higashishirakawa.gifu',
    'ibigawa.gifu',
    'ikeda.gifu',
    'kakamigahara.gifu',
    'kani.gifu',
    'kasahara.gifu',
    'kasamatsu.gifu',
    'kawaue.gifu',
    'kitagata.gifu',
    'mino.gifu',
    'minokamo.gifu',
    'mitake.gifu',
    'mizunami.gifu',
    'motosu.gifu',
    'nakatsugawa.gifu',
    'ogaki.gifu',
    'sakahogi.gifu',
    'seki.gifu',
    'sekigahara.gifu',
    'shirakawa.gifu',
    'tajimi.gifu',
    'takayama.gifu',
    'tarui.gifu',
    'toki.gifu',
    'tomika.gifu',
    'wanouchi.gifu',
    'yamagata.gifu',
    'yaotsu.gifu',
    'yoro.gifu',
    'annaka.gunma',
    'chiyoda.gunma',
    'fujioka.gunma',
    'higashiagatsuma.gunma',
    'isesaki.gunma',
    'itakura.gunma',
    'kanna.gunma',
    'kanra.gunma',
    'katashina.gunma',
    'kawaba.gunma',
    'kiryu.gunma',
    'kusatsu.gunma',
    'maebashi.gunma',
    'meiwa.gunma',
    'midori.gunma',
    'minakami.gunma',
    'naganohara.gunma',
    'nakanojo.gunma',
    'nanmoku.gunma',
    'numata.gunma',
    'oizumi.gunma',
    'ora.gunma',
    'ota.gunma',
    'shibukawa.gunma',
    'shimonita.gunma',
    'shinto.gunma',
    'showa.gunma',
    'takasaki.gunma',
    'takayama.gunma',
    'tamamura.gunma',
    'tatebayashi.gunma',
    'tomioka.gunma',
    'tsukiyono.gunma',
    'tsumagoi.gunma',
    'ueno.gunma',
    'yoshioka.gunma',
    'asaminami.hiroshima',
    'daiwa.hiroshima',
    'etajima.hiroshima',
    'fuchu.hiroshima',
    'fukuyama.hiroshima',
    'hatsukaichi.hiroshima',
    'higashihiroshima.hiroshima',
    'hongo.hiroshima',
    'jinsekikogen.hiroshima',
    'kaita.hiroshima',
    'kui.hiroshima',
    'kumano.hiroshima',
    'kure.hiroshima',
    'mihara.hiroshima',
    'miyoshi.hiroshima',
    'naka.hiroshima',
    'onomichi.hiroshima',
    'osakikamijima.hiroshima',
    'otake.hiroshima',
    'saka.hiroshima',
    'sera.hiroshima',
    'seranishi.hiroshima',
    'shinichi.hiroshima',
    'shobara.hiroshima',
    'takehara.hiroshima',
    'abashiri.hokkaido',
    'abira.hokkaido',
    'aibetsu.hokkaido',
    'akabira.hokkaido',
    'akkeshi.hokkaido',
    'asahikawa.hokkaido',
    'ashibetsu.hokkaido',
    'ashoro.hokkaido',
    'assabu.hokkaido',
    'atsuma.hokkaido',
    'bibai.hokkaido',
    'biei.hokkaido',
    'bifuka.hokkaido',
    'bihoro.hokkaido',
    'biratori.hokkaido',
    'chippubetsu.hokkaido',
    'chitose.hokkaido',
    'date.hokkaido',
    'ebetsu.hokkaido',
    'embetsu.hokkaido',
    'eniwa.hokkaido',
    'erimo.hokkaido',
    'esan.hokkaido',
    'esashi.hokkaido',
    'fukagawa.hokkaido',
    'fukushima.hokkaido',
    'furano.hokkaido',
    'furubira.hokkaido',
    'haboro.hokkaido',
    'hakodate.hokkaido',
    'hamatonbetsu.hokkaido',
    'hidaka.hokkaido',
    'higashikagura.hokkaido',
    'higashikawa.hokkaido',
    'hiroo.hokkaido',
    'hokuryu.hokkaido',
    'hokuto.hokkaido',
    'honbetsu.hokkaido',
    'horokanai.hokkaido',
    'horonobe.hokkaido',
    'ikeda.hokkaido',
    'imakane.hokkaido',
    'ishikari.hokkaido',
    'iwamizawa.hokkaido',
    'iwanai.hokkaido',
    'kamifurano.hokkaido',
    'kamikawa.hokkaido',
    'kamishihoro.hokkaido',
    'kamisunagawa.hokkaido',
    'kamoenai.hokkaido',
    'kayabe.hokkaido',
    'kembuchi.hokkaido',
    'kikonai.hokkaido',
    'kimobetsu.hokkaido',
    'kitahiroshima.hokkaido',
    'kitami.hokkaido',
    'kiyosato.hokkaido',
    'koshimizu.hokkaido',
    'kunneppu.hokkaido',
    'kuriyama.hokkaido',
    'kuromatsunai.hokkaido',
    'kushiro.hokkaido',
    'kutchan.hokkaido',
    'kyowa.hokkaido',
    'mashike.hokkaido',
    'matsumae.hokkaido',
    'mikasa.hokkaido',
    'minamifurano.hokkaido',
    'mombetsu.hokkaido',
    'moseushi.hokkaido',
    'mukawa.hokkaido',
    'muroran.hokkaido',
    'naie.hokkaido',
    'nakagawa.hokkaido',
    'nakasatsunai.hokkaido',
    'nakatombetsu.hokkaido',
    'nanae.hokkaido',
    'nanporo.hokkaido',
    'nayoro.hokkaido',
    'nemuro.hokkaido',
    'niikappu.hokkaido',
    'niki.hokkaido',
    'nishiokoppe.hokkaido',
    'noboribetsu.hokkaido',
    'numata.hokkaido',
    'obihiro.hokkaido',
    'obira.hokkaido',
    'oketo.hokkaido',
    'okoppe.hokkaido',
    'otaru.hokkaido',
    'otobe.hokkaido',
    'otofuke.hokkaido',
    'otoineppu.hokkaido',
    'oumu.hokkaido',
    'ozora.hokkaido',
    'pippu.hokkaido',
    'rankoshi.hokkaido',
    'rebun.hokkaido',
    'rikubetsu.hokkaido',
    'rishiri.hokkaido',
    'rishirifuji.hokkaido',
    'saroma.hokkaido',
    'sarufutsu.hokkaido',
    'shakotan.hokkaido',
    'shari.hokkaido',
    'shibecha.hokkaido',
    'shibetsu.hokkaido',
    'shikabe.hokkaido',
    'shikaoi.hokkaido',
    'shimamaki.hokkaido',
    'shimizu.hokkaido',
    'shimokawa.hokkaido',
    'shinshinotsu.hokkaido',
    'shintoku.hokkaido',
    'shiranuka.hokkaido',
    'shiraoi.hokkaido',
    'shiriuchi.hokkaido',
    'sobetsu.hokkaido',
    'sunagawa.hokkaido',
    'taiki.hokkaido',
    'takasu.hokkaido',
    'takikawa.hokkaido',
    'takinoue.hokkaido',
    'teshikaga.hokkaido',
    'tobetsu.hokkaido',
    'tohma.hokkaido',
    'tomakomai.hokkaido',
    'tomari.hokkaido',
    'toya.hokkaido',
    'toyako.hokkaido',
    'toyotomi.hokkaido',
    'toyoura.hokkaido',
    'tsubetsu.hokkaido',
    'tsukigata.hokkaido',
    'urakawa.hokkaido',
    'urausu.hokkaido',
    'uryu.hokkaido',
    'utashinai.hokkaido',
    'wakkanai.hokkaido',
    'wassamu.hokkaido',
    'yakumo.hokkaido',
    'yoichi.hokkaido',
    'aioi.hyogo',
    'akashi.hyogo',
    'ako.hyogo',
    'amagasaki.hyogo',
    'aogaki.hyogo',
    'asago.hyogo',
    'ashiya.hyogo',
    'awaji.hyogo',
    'fukusaki.hyogo',
    'goshiki.hyogo',
    'harima.hyogo',
    'himeji.hyogo',
    'ichikawa.hyogo',
    'inagawa.hyogo',
    'itami.hyogo',
    'kakogawa.hyogo',
    'kamigori.hyogo',
    'kamikawa.hyogo',
    'kasai.hyogo',
    'kasuga.hyogo',
    'kawanishi.hyogo',
    'miki.hyogo',
    'minamiawaji.hyogo',
    'nishinomiya.hyogo',
    'nishiwaki.hyogo',
    'ono.hyogo',
    'sanda.hyogo',
    'sannan.hyogo',
    'sasayama.hyogo',
    'sayo.hyogo',
    'shingu.hyogo',
    'shinonsen.hyogo',
    'shiso.hyogo',
    'sumoto.hyogo',
    'taishi.hyogo',
    'taka.hyogo',
    'takarazuka.hyogo',
    'takasago.hyogo',
    'takino.hyogo',
    'tamba.hyogo',
    'tatsuno.hyogo',
    'toyooka.hyogo',
    'yabu.hyogo',
    'yashiro.hyogo',
    'yoka.hyogo',
    'yokawa.hyogo',
    'ami.ibaraki',
    'asahi.ibaraki',
    'bando.ibaraki',
    'chikusei.ibaraki',
    'daigo.ibaraki',
    'fujishiro.ibaraki',
    'hitachi.ibaraki',
    'hitachinaka.ibaraki',
    'hitachiomiya.ibaraki',
    'hitachiota.ibaraki',
    'ibaraki.ibaraki',
    'ina.ibaraki',
    'inashiki.ibaraki',
    'itako.ibaraki',
    'iwama.ibaraki',
    'joso.ibaraki',
    'kamisu.ibaraki',
    'kasama.ibaraki',
    'kashima.ibaraki',
    'kasumigaura.ibaraki',
    'koga.ibaraki',
    'miho.ibaraki',
    'mito.ibaraki',
    'moriya.ibaraki',
    'naka.ibaraki',
    'namegata.ibaraki',
    'oarai.ibaraki',
    'ogawa.ibaraki',
    'omitama.ibaraki',
    'ryugasaki.ibaraki',
    'sakai.ibaraki',
    'sakuragawa.ibaraki',
    'shimodate.ibaraki',
    'shimotsuma.ibaraki',
    'shirosato.ibaraki',
    'sowa.ibaraki',
    'suifu.ibaraki',
    'takahagi.ibaraki',
    'tamatsukuri.ibaraki',
    'tokai.ibaraki',
    'tomobe.ibaraki',
    'tone.ibaraki',
    'toride.ibaraki',
    'tsuchiura.ibaraki',
    'tsukuba.ibaraki',
    'uchihara.ibaraki',
    'ushiku.ibaraki',
    'yachiyo.ibaraki',
    'yamagata.ibaraki',
    'yawara.ibaraki',
    'yuki.ibaraki',
    'anamizu.ishikawa',
    'hakui.ishikawa',
    'hakusan.ishikawa',
    'kaga.ishikawa',
    'kahoku.ishikawa',
    'kanazawa.ishikawa',
    'kawakita.ishikawa',
    'komatsu.ishikawa',
    'nakanoto.ishikawa',
    'nanao.ishikawa',
    'nomi.ishikawa',
    'nonoichi.ishikawa',
    'noto.ishikawa',
    'shika.ishikawa',
    'suzu.ishikawa',
    'tsubata.ishikawa',
    'tsurugi.ishikawa',
    'uchinada.ishikawa',
    'wajima.ishikawa',
    'fudai.iwate',
    'fujisawa.iwate',
    'hanamaki.iwate',
    'hiraizumi.iwate',
    'hirono.iwate',
    'ichinohe.iwate',
    'ichinoseki.iwate',
    'iwaizumi.iwate',
    'iwate.iwate',
    'joboji.iwate',
    'kamaishi.iwate',
    'kanegasaki.iwate',
    'karumai.iwate',
    'kawai.iwate',
    'kitakami.iwate',
    'kuji.iwate',
    'kunohe.iwate',
    'kuzumaki.iwate',
    'miyako.iwate',
    'mizusawa.iwate',
    'morioka.iwate',
    'ninohe.iwate',
    'noda.iwate',
    'ofunato.iwate',
    'oshu.iwate',
    'otsuchi.iwate',
    'rikuzentakata.iwate',
    'shiwa.iwate',
    'shizukuishi.iwate',
    'sumita.iwate',
    'tanohata.iwate',
    'tono.iwate',
    'yahaba.iwate',
    'yamada.iwate',
    'ayagawa.kagawa',
    'higashikagawa.kagawa',
    'kanonji.kagawa',
    'kotohira.kagawa',
    'manno.kagawa',
    'marugame.kagawa',
    'mitoyo.kagawa',
    'naoshima.kagawa',
    'sanuki.kagawa',
    'tadotsu.kagawa',
    'takamatsu.kagawa',
    'tonosho.kagawa',
    'uchinomi.kagawa',
    'utazu.kagawa',
    'zentsuji.kagawa',
    'akune.kagoshima',
    'amami.kagoshima',
    'hioki.kagoshima',
    'isa.kagoshima',
    'isen.kagoshima',
    'izumi.kagoshima',
    'kagoshima.kagoshima',
    'kanoya.kagoshima',
    'kawanabe.kagoshima',
    'kinko.kagoshima',
    'kouyama.kagoshima',
    'makurazaki.kagoshima',
    'matsumoto.kagoshima',
    'minamitane.kagoshima',
    'nakatane.kagoshima',
    'nishinoomote.kagoshima',
    'satsumasendai.kagoshima',
    'soo.kagoshima',
    'tarumizu.kagoshima',
    'yusui.kagoshima',
    'aikawa.kanagawa',
    'atsugi.kanagawa',
    'ayase.kanagawa',
    'chigasaki.kanagawa',
    'ebina.kanagawa',
    'fujisawa.kanagawa',
    'hadano.kanagawa',
    'hakone.kanagawa',
    'hiratsuka.kanagawa',
    'isehara.kanagawa',
    'kaisei.kanagawa',
    'kamakura.kanagawa',
    'kiyokawa.kanagawa',
    'matsuda.kanagawa',
    'minamiashigara.kanagawa',
    'miura.kanagawa',
    'nakai.kanagawa',
    'ninomiya.kanagawa',
    'odawara.kanagawa',
    'oi.kanagawa',
    'oiso.kanagawa',
    'sagamihara.kanagawa',
    'samukawa.kanagawa',
    'tsukui.kanagawa',
    'yamakita.kanagawa',
    'yamato.kanagawa',
    'yokosuka.kanagawa',
    'yugawara.kanagawa',
    'zama.kanagawa',
    'zushi.kanagawa',
    'aki.kochi',
    'geisei.kochi',
    'hidaka.kochi',
    'higashitsuno.kochi',
    'ino.kochi',
    'kagami.kochi',
    'kami.kochi',
    'kitagawa.kochi',
    'kochi.kochi',
    'mihara.kochi',
    'motoyama.kochi',
    'muroto.kochi',
    'nahari.kochi',
    'nakamura.kochi',
    'nankoku.kochi',
    'nishitosa.kochi',
    'niyodogawa.kochi',
    'ochi.kochi',
    'okawa.kochi',
    'otoyo.kochi',
    'otsuki.kochi',
    'sakawa.kochi',
    'sukumo.kochi',
    'susaki.kochi',
    'tosa.kochi',
    'tosashimizu.kochi',
    'toyo.kochi',
    'tsuno.kochi',
    'umaji.kochi',
    'yasuda.kochi',
    'yusuhara.kochi',
    'amakusa.kumamoto',
    'arao.kumamoto',
    'aso.kumamoto',
    'choyo.kumamoto',
    'gyokuto.kumamoto',
    'kamiamakusa.kumamoto',
    'kikuchi.kumamoto',
    'kumamoto.kumamoto',
    'mashiki.kumamoto',
    'mifune.kumamoto',
    'minamata.kumamoto',
    'minamioguni.kumamoto',
    'nagasu.kumamoto',
    'nishihara.kumamoto',
    'oguni.kumamoto',
    'ozu.kumamoto',
    'sumoto.kumamoto',
    'takamori.kumamoto',
    'uki.kumamoto',
    'uto.kumamoto',
    'yamaga.kumamoto',
    'yamato.kumamoto',
    'yatsushiro.kumamoto',
    'ayabe.kyoto',
    'fukuchiyama.kyoto',
    'higashiyama.kyoto',
    'ide.kyoto',
    'ine.kyoto',
    'joyo.kyoto',
    'kameoka.kyoto',
    'kamo.kyoto',
    'kita.kyoto',
    'kizu.kyoto',
    'kumiyama.kyoto',
    'kyotamba.kyoto',
    'kyotanabe.kyoto',
    'kyotango.kyoto',
    'maizuru.kyoto',
    'minami.kyoto',
    'minamiyamashiro.kyoto',
    'miyazu.kyoto',
    'muko.kyoto',
    'nagaokakyo.kyoto',
    'nakagyo.kyoto',
    'nantan.kyoto',
    'oyamazaki.kyoto',
    'sakyo.kyoto',
    'seika.kyoto',
    'tanabe.kyoto',
    'uji.kyoto',
    'ujitawara.kyoto',
    'wazuka.kyoto',
    'yamashina.kyoto',
    'yawata.kyoto',
    'asahi.mie',
    'inabe.mie',
    'ise.mie',
    'kameyama.mie',
    'kawagoe.mie',
    'kiho.mie',
    'kisosaki.mie',
    'kiwa.mie',
    'komono.mie',
    'kumano.mie',
    'kuwana.mie',
    'matsusaka.mie',
    'meiwa.mie',
    'mihama.mie',
    'minamiise.mie',
    'misugi.mie',
    'miyama.mie',
    'nabari.mie',
    'shima.mie',
    'suzuka.mie',
    'tado.mie',
    'taiki.mie',
    'taki.mie',
    'tamaki.mie',
    'toba.mie',
    'tsu.mie',
    'udono.mie',
    'ureshino.mie',
    'watarai.mie',
    'yokkaichi.mie',
    'furukawa.miyagi',
    'higashimatsushima.miyagi',
    'ishinomaki.miyagi',
    'iwanuma.miyagi',
    'kakuda.miyagi',
    'kami.miyagi',
    'kawasaki.miyagi',
    'marumori.miyagi',
    'matsushima.miyagi',
    'minamisanriku.miyagi',
    'misato.miyagi',
    'murata.miyagi',
    'natori.miyagi',
    'ogawara.miyagi',
    'ohira.miyagi',
    'onagawa.miyagi',
    'osaki.miyagi',
    'rifu.miyagi',
    'semine.miyagi',
    'shibata.miyagi',
    'shichikashuku.miyagi',
    'shikama.miyagi',
    'shiogama.miyagi',
    'shiroishi.miyagi',
    'tagajo.miyagi',
    'taiwa.miyagi',
    'tome.miyagi',
    'tomiya.miyagi',
    'wakuya.miyagi',
    'watari.miyagi',
    'yamamoto.miyagi',
    'zao.miyagi',
    'aya.miyazaki',
    'ebino.miyazaki',
    'gokase.miyazaki',
    'hyuga.miyazaki',
    'kadogawa.miyazaki',
    'kawaminami.miyazaki',
    'kijo.miyazaki',
    'kitagawa.miyazaki',
    'kitakata.miyazaki',
    'kitaura.miyazaki',
    'kobayashi.miyazaki',
    'kunitomi.miyazaki',
    'kushima.miyazaki',
    'mimata.miyazaki',
    'miyakonojo.miyazaki',
    'miyazaki.miyazaki',
    'morotsuka.miyazaki',
    'nichinan.miyazaki',
    'nishimera.miyazaki',
    'nobeoka.miyazaki',
    'saito.miyazaki',
    'shiiba.miyazaki',
    'shintomi.miyazaki',
    'takaharu.miyazaki',
    'takanabe.miyazaki',
    'takazaki.miyazaki',
    'tsuno.miyazaki',
    'achi.nagano',
    'agematsu.nagano',
    'anan.nagano',
    'aoki.nagano',
    'asahi.nagano',
    'azumino.nagano',
    'chikuhoku.nagano',
    'chikuma.nagano',
    'chino.nagano',
    'fujimi.nagano',
    'hakuba.nagano',
    'hara.nagano',
    'hiraya.nagano',
    'iida.nagano',
    'iijima.nagano',
    'iiyama.nagano',
    'iizuna.nagano',
    'ikeda.nagano',
    'ikusaka.nagano',
    'ina.nagano',
    'karuizawa.nagano',
    'kawakami.nagano',
    'kiso.nagano',
    'kisofukushima.nagano',
    'kitaaiki.nagano',
    'komagane.nagano',
    'komoro.nagano',
    'matsukawa.nagano',
    'matsumoto.nagano',
    'miasa.nagano',
    'minamiaiki.nagano',
    'minamimaki.nagano',
    'minamiminowa.nagano',
    'minowa.nagano',
    'miyada.nagano',
    'miyota.nagano',
    'mochizuki.nagano',
    'nagano.nagano',
    'nagawa.nagano',
    'nagiso.nagano',
    'nakagawa.nagano',
    'nakano.nagano',
    'nozawaonsen.nagano',
    'obuse.nagano',
    'ogawa.nagano',
    'okaya.nagano',
    'omachi.nagano',
    'omi.nagano',
    'ookuwa.nagano',
    'ooshika.nagano',
    'otaki.nagano',
    'otari.nagano',
    'sakae.nagano',
    'sakaki.nagano',
    'saku.nagano',
    'sakuho.nagano',
    'shimosuwa.nagano',
    'shinanomachi.nagano',
    'shiojiri.nagano',
    'suwa.nagano',
    'suzaka.nagano',
    'takagi.nagano',
    'takamori.nagano',
    'takayama.nagano',
    'tateshina.nagano',
    'tatsuno.nagano',
    'togakushi.nagano',
    'togura.nagano',
    'tomi.nagano',
    'ueda.nagano',
    'wada.nagano',
    'yamagata.nagano',
    'yamanouchi.nagano',
    'yasaka.nagano',
    'yasuoka.nagano',
    'chijiwa.nagasaki',
    'futsu.nagasaki',
    'goto.nagasaki',
    'hasami.nagasaki',
    'hirado.nagasaki',
    'iki.nagasaki',
    'isahaya.nagasaki',
    'kawatana.nagasaki',
    'kuchinotsu.nagasaki',
    'matsuura.nagasaki',
    'nagasaki.nagasaki',
    'obama.nagasaki',
    'omura.nagasaki',
    'oseto.nagasaki',
    'saikai.nagasaki',
    'sasebo.nagasaki',
    'seihi.nagasaki',
    'shimabara.nagasaki',
    'shinkamigoto.nagasaki',
    'togitsu.nagasaki',
    'tsushima.nagasaki',
    'unzen.nagasaki',
    'ando.nara',
    'gose.nara',
    'heguri.nara',
    'higashiyoshino.nara',
    'ikaruga.nara',
    'ikoma.nara',
    'kamikitayama.nara',
    'kanmaki.nara',
    'kashiba.nara',
    'kashihara.nara',
    'katsuragi.nara',
    'kawai.nara',
    'kawakami.nara',
    'kawanishi.nara',
    'koryo.nara',
    'kurotaki.nara',
    'mitsue.nara',
    'miyake.nara',
    'nara.nara',
    'nosegawa.nara',
    'oji.nara',
    'ouda.nara',
    'oyodo.nara',
    'sakurai.nara',
    'sango.nara',
    'shimoichi.nara',
    'shimokitayama.nara',
    'shinjo.nara',
    'soni.nara',
    'takatori.nara',
    'tawaramoto.nara',
    'tenkawa.nara',
    'tenri.nara',
    'uda.nara',
    'yamatokoriyama.nara',
    'yamatotakada.nara',
    'yamazoe.nara',
    'yoshino.nara',
    'aga.niigata',
    'agano.niigata',
    'gosen.niigata',
    'itoigawa.niigata',
    'izumozaki.niigata',
    'joetsu.niigata',
    'kamo.niigata',
    'kariwa.niigata',
    'kashiwazaki.niigata',
    'minamiuonuma.niigata',
    'mitsuke.niigata',
    'muika.niigata',
    'murakami.niigata',
    'myoko.niigata',
    'nagaoka.niigata',
    'niigata.niigata',
    'ojiya.niigata',
    'omi.niigata',
    'sado.niigata',
    'sanjo.niigata',
    'seiro.niigata',
    'seirou.niigata',
    'sekikawa.niigata',
    'shibata.niigata',
    'tagami.niigata',
    'tainai.niigata',
    'tochio.niigata',
    'tokamachi.niigata',
    'tsubame.niigata',
    'tsunan.niigata',
    'uonuma.niigata',
    'yahiko.niigata',
    'yoita.niigata',
    'yuzawa.niigata',
    'beppu.oita',
    'bungoono.oita',
    'bungotakada.oita',
    'hasama.oita',
    'hiji.oita',
    'himeshima.oita',
    'hita.oita',
    'kamitsue.oita',
    'kokonoe.oita',
    'kuju.oita',
    'kunisaki.oita',
    'kusu.oita',
    'oita.oita',
    'saiki.oita',
    'taketa.oita',
    'tsukumi.oita',
    'usa.oita',
    'usuki.oita',
    'yufu.oita',
    'akaiwa.okayama',
    'asakuchi.okayama',
    'bizen.okayama',
    'hayashima.okayama',
    'ibara.okayama',
    'kagamino.okayama',
    'kasaoka.okayama',
    'kibichuo.okayama',
    'kumenan.okayama',
    'kurashiki.okayama',
    'maniwa.okayama',
    'misaki.okayama',
    'nagi.okayama',
    'niimi.okayama',
    'nishiawakura.okayama',
    'okayama.okayama',
    'satosho.okayama',
    'setouchi.okayama',
    'shinjo.okayama',
    'shoo.okayama',
    'soja.okayama',
    'takahashi.okayama',
    'tamano.okayama',
    'tsuyama.okayama',
    'wake.okayama',
    'yakage.okayama',
    'aguni.okinawa',
    'ginowan.okinawa',
    'ginoza.okinawa',
    'gushikami.okinawa',
    'haebaru.okinawa',
    'higashi.okinawa',
    'hirara.okinawa',
    'iheya.okinawa',
    'ishigaki.okinawa',
    'ishikawa.okinawa',
    'itoman.okinawa',
    'izena.okinawa',
    'kadena.okinawa',
    'kin.okinawa',
    'kitadaito.okinawa',
    'kitanakagusuku.okinawa',
    'kumejima.okinawa',
    'kunigami.okinawa',
    'minamidaito.okinawa',
    'motobu.okinawa',
    'nago.okinawa',
    'naha.okinawa',
    'nakagusuku.okinawa',
    'nakijin.okinawa',
    'nanjo.okinawa',
    'nishihara.okinawa',
    'ogimi.okinawa',
    'okinawa.okinawa',
    'onna.okinawa',
    'shimoji.okinawa',
    'taketomi.okinawa',
    'tarama.okinawa',
    'tokashiki.okinawa',
    'tomigusuku.okinawa',
    'tonaki.okinawa',
    'urasoe.okinawa',
    'uruma.okinawa',
    'yaese.okinawa',
    'yomitan.okinawa',
    'yonabaru.okinawa',
    'yonaguni.okinawa',
    'zamami.okinawa',
    'abeno.osaka',
    'chihayaakasaka.osaka',
    'chuo.osaka',
    'daito.osaka',
    'fujiidera.osaka',
    'habikino.osaka',
    'hannan.osaka',
    'higashiosaka.osaka',
    'higashisumiyoshi.osaka',
    'higashiyodogawa.osaka',
    'hirakata.osaka',
    'ibaraki.osaka',
    'ikeda.osaka',
    'izumi.osaka',
    'izumiotsu.osaka',
    'izumisano.osaka',
    'kadoma.osaka',
    'kaizuka.osaka',
    'kanan.osaka',
    'kashiwara.osaka',
    'katano.osaka',
    'kawachinagano.osaka',
    'kishiwada.osaka',
    'kita.osaka',
    'kumatori.osaka',
    'matsubara.osaka',
    'minato.osaka',
    'minoh.osaka',
    'misaki.osaka',
    'moriguchi.osaka',
    'neyagawa.osaka',
    'nishi.osaka',
    'nose.osaka',
    'osakasayama.osaka',
    'sakai.osaka',
    'sayama.osaka',
    'sennan.osaka',
    'settsu.osaka',
    'shijonawate.osaka',
    'shimamoto.osaka',
    'suita.osaka',
    'tadaoka.osaka',
    'taishi.osaka',
    'tajiri.osaka',
    'takaishi.osaka',
    'takatsuki.osaka',
    'tondabayashi.osaka',
    'toyonaka.osaka',
    'toyono.osaka',
    'yao.osaka',
    'ariake.saga',
    'arita.saga',
    'fukudomi.saga',
    'genkai.saga',
    'hamatama.saga',
    'hizen.saga',
    'imari.saga',
    'kamimine.saga',
    'kanzaki.saga',
    'karatsu.saga',
    'kashima.saga',
    'kitagata.saga',
    'kitahata.saga',
    'kiyama.saga',
    'kouhoku.saga',
    'kyuragi.saga',
    'nishiarita.saga',
    'ogi.saga',
    'omachi.saga',
    'ouchi.saga',
    'saga.saga',
    'shiroishi.saga',
    'taku.saga',
    'tara.saga',
    'tosu.saga',
    'yoshinogari.saga',
    'arakawa.saitama',
    'asaka.saitama',
    'chichibu.saitama',
    'fujimi.saitama',
    'fujimino.saitama',
    'fukaya.saitama',
    'hanno.saitama',
    'hanyu.saitama',
    'hasuda.saitama',
    'hatogaya.saitama',
    'hatoyama.saitama',
    'hidaka.saitama',
    'higashichichibu.saitama',
    'higashimatsuyama.saitama',
    'honjo.saitama',
    'ina.saitama',
    'iruma.saitama',
    'iwatsuki.saitama',
    'kamiizumi.saitama',
    'kamikawa.saitama',
    'kamisato.saitama',
    'kasukabe.saitama',
    'kawagoe.saitama',
    'kawaguchi.saitama',
    'kawajima.saitama',
    'kazo.saitama',
    'kitamoto.saitama',
    'koshigaya.saitama',
    'kounosu.saitama',
    'kuki.saitama',
    'kumagaya.saitama',
    'matsubushi.saitama',
    'minano.saitama',
    'misato.saitama',
    'miyashiro.saitama',
    'miyoshi.saitama',
    'moroyama.saitama',
    'nagatoro.saitama',
    'namegawa.saitama',
    'niiza.saitama',
    'ogano.saitama',
    'ogawa.saitama',
    'ogose.saitama',
    'okegawa.saitama',
    'omiya.saitama',
    'otaki.saitama',
    'ranzan.saitama',
    'ryokami.saitama',
    'saitama.saitama',
    'sakado.saitama',
    'satte.saitama',
    'sayama.saitama',
    'shiki.saitama',
    'shiraoka.saitama',
    'soka.saitama',
    'sugito.saitama',
    'toda.saitama',
    'tokigawa.saitama',
    'tokorozawa.saitama',
    'tsurugashima.saitama',
    'urawa.saitama',
    'warabi.saitama',
    'yashio.saitama',
    'yokoze.saitama',
    'yono.saitama',
    'yorii.saitama',
    'yoshida.saitama',
    'yoshikawa.saitama',
    'yoshimi.saitama',
    'aisho.shiga',
    'gamo.shiga',
    'higashiomi.shiga',
    'hikone.shiga',
    'koka.shiga',
    'konan.shiga',
    'kosei.shiga',
    'koto.shiga',
    'kusatsu.shiga',
    'maibara.shiga',
    'moriyama.shiga',
    'nagahama.shiga',
    'nishiazai.shiga',
    'notogawa.shiga',
    'omihachiman.shiga',
    'otsu.shiga',
    'ritto.shiga',
    'ryuoh.shiga',
    'takashima.shiga',
    'takatsuki.shiga',
    'torahime.shiga',
    'toyosato.shiga',
    'yasu.shiga',
    'akagi.shimane',
    'ama.shimane',
    'gotsu.shimane',
    'hamada.shimane',
    'higashiizumo.shimane',
    'hikawa.shimane',
    'hikimi.shimane',
    'izumo.shimane',
    'kakinoki.shimane',
    'masuda.shimane',
    'matsue.shimane',
    'misato.shimane',
    'nishinoshima.shimane',
    'ohda.shimane',
    'okinoshima.shimane',
    'okuizumo.shimane',
    'shimane.shimane',
    'tamayu.shimane',
    'tsuwano.shimane',
    'unnan.shimane',
    'yakumo.shimane',
    'yasugi.shimane',
    'yatsuka.shimane',
    'arai.shizuoka',
    'atami.shizuoka',
    'fuji.shizuoka',
    'fujieda.shizuoka',
    'fujikawa.shizuoka',
    'fujinomiya.shizuoka',
    'fukuroi.shizuoka',
    'gotemba.shizuoka',
    'haibara.shizuoka',
    'hamamatsu.shizuoka',
    'higashiizu.shizuoka',
    'ito.shizuoka',
    'iwata.shizuoka',
    'izu.shizuoka',
    'izunokuni.shizuoka',
    'kakegawa.shizuoka',
    'kannami.shizuoka',
    'kawanehon.shizuoka',
    'kawazu.shizuoka',
    'kikugawa.shizuoka',
    'kosai.shizuoka',
    'makinohara.shizuoka',
    'matsuzaki.shizuoka',
    'minamiizu.shizuoka',
    'mishima.shizuoka',
    'morimachi.shizuoka',
    'nishiizu.shizuoka',
    'numazu.shizuoka',
    'omaezaki.shizuoka',
    'shimada.shizuoka',
    'shimizu.shizuoka',
    'shimoda.shizuoka',
    'shizuoka.shizuoka',
    'susono.shizuoka',
    'yaizu.shizuoka',
    'yoshida.shizuoka',
    'ashikaga.tochigi',
    'bato.tochigi',
    'haga.tochigi',
    'ichikai.tochigi',
    'iwafune.tochigi',
    'kaminokawa.tochigi',
    'kanuma.tochigi',
    'karasuyama.tochigi',
    'kuroiso.tochigi',
    'mashiko.tochigi',
    'mibu.tochigi',
    'moka.tochigi',
    'motegi.tochigi',
    'nasu.tochigi',
    'nasushiobara.tochigi',
    'nikko.tochigi',
    'nishikata.tochigi',
    'nogi.tochigi',
    'ohira.tochigi',
    'ohtawara.tochigi',
    'oyama.tochigi',
    'sakura.tochigi',
    'sano.tochigi',
    'shimotsuke.tochigi',
    'shioya.tochigi',
    'takanezawa.tochigi',
    'tochigi.tochigi',
    'tsuga.tochigi',
    'ujiie.tochigi',
    'utsunomiya.tochigi',
    'yaita.tochigi',
    'aizumi.tokushima',
    'anan.tokushima',
    'ichiba.tokushima',
    'itano.tokushima',
    'kainan.tokushima',
    'komatsushima.tokushima',
    'matsushige.tokushima',
    'mima.tokushima',
    'minami.tokushima',
    'miyoshi.tokushima',
    'mugi.tokushima',
    'nakagawa.tokushima',
    'naruto.tokushima',
    'sanagochi.tokushima',
    'shishikui.tokushima',
    'tokushima.tokushima',
    'wajiki.tokushima',
    'adachi.tokyo',
    'akiruno.tokyo',
    'akishima.tokyo',
    'aogashima.tokyo',
    'arakawa.tokyo',
    'bunkyo.tokyo',
    'chiyoda.tokyo',
    'chofu.tokyo',
    'chuo.tokyo',
    'edogawa.tokyo',
    'fuchu.tokyo',
    'fussa.tokyo',
    'hachijo.tokyo',
    'hachioji.tokyo',
    'hamura.tokyo',
    'higashikurume.tokyo',
    'higashimurayama.tokyo',
    'higashiyamato.tokyo',
    'hino.tokyo',
    'hinode.tokyo',
    'hinohara.tokyo',
    'inagi.tokyo',
    'itabashi.tokyo',
    'katsushika.tokyo',
    'kita.tokyo',
    'kiyose.tokyo',
    'kodaira.tokyo',
    'koganei.tokyo',
    'kokubunji.tokyo',
    'komae.tokyo',
    'koto.tokyo',
    'kouzushima.tokyo',
    'kunitachi.tokyo',
    'machida.tokyo',
    'meguro.tokyo',
    'minato.tokyo',
    'mitaka.tokyo',
    'mizuho.tokyo',
    'musashimurayama.tokyo',
    'musashino.tokyo',
    'nakano.tokyo',
    'nerima.tokyo',
    'ogasawara.tokyo',
    'okutama.tokyo',
    'ome.tokyo',
    'oshima.tokyo',
    'ota.tokyo',
    'setagaya.tokyo',
    'shibuya.tokyo',
    'shinagawa.tokyo',
    'shinjuku.tokyo',
    'suginami.tokyo',
    'sumida.tokyo',
    'tachikawa.tokyo',
    'taito.tokyo',
    'tama.tokyo',
    'toshima.tokyo',
    'chizu.tottori',
    'hino.tottori',
    'kawahara.tottori',
    'koge.tottori',
    'kotoura.tottori',
    'misasa.tottori',
    'nanbu.tottori',
    'nichinan.tottori',
    'sakaiminato.tottori',
    'tottori.tottori',
    'wakasa.tottori',
    'yazu.tottori',
    'yonago.tottori',
    'asahi.toyama',
    'fuchu.toyama',
    'fukumitsu.toyama',
    'funahashi.toyama',
    'himi.toyama',
    'imizu.toyama',
    'inami.toyama',
    'johana.toyama',
    'kamiichi.toyama',
    'kurobe.toyama',
    'nakaniikawa.toyama',
    'namerikawa.toyama',
    'nanto.toyama',
    'nyuzen.toyama',
    'oyabe.toyama',
    'taira.toyama',
    'takaoka.toyama',
    'tateyama.toyama',
    'toga.toyama',
    'tonami.toyama',
    'toyama.toyama',
    'unazuki.toyama',
    'uozu.toyama',
    'yamada.toyama',
    'arida.wakayama',
    'aridagawa.wakayama',
    'gobo.wakayama',
    'hashimoto.wakayama',
    'hidaka.wakayama',
    'hirogawa.wakayama',
    'inami.wakayama',
    'iwade.wakayama',
    'kainan.wakayama',
    'kamitonda.wakayama',
    'katsuragi.wakayama',
    'kimino.wakayama',
    'kinokawa.wakayama',
    'kitayama.wakayama',
    'koya.wakayama',
    'koza.wakayama',
    'kozagawa.wakayama',
    'kudoyama.wakayama',
    'kushimoto.wakayama',
    'mihama.wakayama',
    'misato.wakayama',
    'nachikatsuura.wakayama',
    'shingu.wakayama',
    'shirahama.wakayama',
    'taiji.wakayama',
    'tanabe.wakayama',
    'wakayama.wakayama',
    'yuasa.wakayama',
    'yura.wakayama',
    'asahi.yamagata',
    'funagata.yamagata',
    'higashine.yamagata',
    'iide.yamagata',
    'kahoku.yamagata',
    'kaminoyama.yamagata',
    'kaneyama.yamagata',
    'kawanishi.yamagata',
    'mamurogawa.yamagata',
    'mikawa.yamagata',
    'murayama.yamagata',
    'nagai.yamagata',
    'nakayama.yamagata',
    'nanyo.yamagata',
    'nishikawa.yamagata',
    'obanazawa.yamagata',
    'oe.yamagata',
    'oguni.yamagata',
    'ohkura.yamagata',
    'oishida.yamagata',
    'sagae.yamagata',
    'sakata.yamagata',
    'sakegawa.yamagata',
    'shinjo.yamagata',
    'shirataka.yamagata',
    'shonai.yamagata',
    'takahata.yamagata',
    'tendo.yamagata',
    'tozawa.yamagata',
    'tsuruoka.yamagata',
    'yamagata.yamagata',
    'yamanobe.yamagata',
    'yonezawa.yamagata',
    'yuza.yamagata',
    'abu.yamaguchi',
    'hagi.yamaguchi',
    'hikari.yamaguchi',
    'hofu.yamaguchi',
    'iwakuni.yamaguchi',
    'kudamatsu.yamaguchi',
    'mitou.yamaguchi',
    'nagato.yamaguchi',
    'oshima.yamaguchi',
    'shimonoseki.yamaguchi',
    'shunan.yamaguchi',
    'tabuse.yamaguchi',
    'tokuyama.yamaguchi',
    'toyota.yamaguchi',
    'ube.yamaguchi',
    'yuu.yamaguchi',
    'chuo.yamanashi',
    'doshi.yamanashi',
    'fuefuki.yamanashi',
    'fujikawa.yamanashi',
    'fujikawaguchiko.yamanashi',
    'fujiyoshida.yamanashi',
    'hayakawa.yamanashi',
    'hokuto.yamanashi',
    'ichikawamisato.yamanashi',
    'kai.yamanashi',
    'kofu.yamanashi',
    'koshu.yamanashi',
    'kosuge.yamanashi',
    'minami-alps.yamanashi',
    'minobu.yamanashi',
    'nakamichi.yamanashi',
    'nanbu.yamanashi',
    'narusawa.yamanashi',
    'nirasaki.yamanashi',
    'nishikatsura.yamanashi',
    'oshino.yamanashi',
    'otsuki.yamanashi',
    'showa.yamanashi',
    'tabayama.yamanashi',
    'tsuru.yamanashi',
    'uenohara.yamanashi',
    'yamanakako.yamanashi',
    'yamanashi.yamanashi',
    'blogspot'
  ],
  'xn--pbt977c': [],
  'world': [],
  'leclerc': [],
  'grainger': [],
  'ke': ['*', 'blogspot.co', '*', 'blogspot.co'],
  'kg': [
    'org',
    'net',
    'com',
    'edu',
    'gov',
    'mil',
    'org',
    'net',
    'com',
    'edu',
    'gov',
    'mil'
  ],
  'camera': [],
  'guardian': [],
  'kh': ['*', '*'],
  'ki': [
    'edu',
    'biz',
    'net',
    'org',
    'gov',
    'info',
    'com',
    'edu',
    'biz',
    'net',
    'org',
    'gov',
    'info',
    'com'
  ],
  'km': [
    'org',
    'nom',
    'gov',
    'prd',
    'tm',
    'edu',
    'mil',
    'ass',
    'com',
    'coop',
    'asso',
    'presse',
    'medecin',
    'notaires',
    'pharmaciens',
    'veterinaire',
    'gouv',
    'org',
    'nom',
    'gov',
    'prd',
    'tm',
    'edu',
    'mil',
    'ass',
    'com',
    'coop',
    'asso',
    'presse',
    'medecin',
    'notaires',
    'pharmaciens',
    'veterinaire',
    'gouv'
  ],
  'kn': ['net', 'org', 'edu', 'gov', 'net', 'org', 'edu', 'gov'],
  'xn--d1acj3b': [],
  'kp': [
    'com',
    'edu',
    'gov',
    'org',
    'rep',
    'tra',
    'com',
    'edu',
    'gov',
    'org',
    'rep',
    'tra'
  ],
  'ftr': [],
  'kr': [
    'ac',
    'co',
    'es',
    'go',
    'hs',
    'kg',
    'mil',
    'ms',
    'ne',
    'or',
    'pe',
    're',
    'sc',
    'busan',
    'chungbuk',
    'chungnam',
    'daegu',
    'daejeon',
    'gangwon',
    'gwangju',
    'gyeongbuk',
    'gyeonggi',
    'gyeongnam',
    'incheon',
    'jeju',
    'jeonbuk',
    'jeonnam',
    'seoul',
    'ulsan',
    'blogspot',
    'ac',
    'co',
    'es',
    'go',
    'hs',
    'kg',
    'mil',
    'ms',
    'ne',
    'or',
    'pe',
    're',
    'sc',
    'busan',
    'chungbuk',
    'chungnam',
    'daegu',
    'daejeon',
    'gangwon',
    'gwangju',
    'gyeongbuk',
    'gyeonggi',
    'gyeongnam',
    'incheon',
    'jeju',
    'jeonbuk',
    'jeonnam',
    'seoul',
    'ulsan',
    'blogspot'
  ],
  'restaurant': [],
  'xn--d1alf': [],
  'xn--mgbc0a9azcg': [],
  'kw': ['*', '*'],
  'hdfcbank': [],
  'ky': ['edu', 'gov', 'com', 'org', 'net', 'edu', 'gov', 'com', 'org', 'net'],
  'off': [],
  'kz': [
    'org',
    'edu',
    'net',
    'gov',
    'mil',
    'com',
    'org',
    'edu',
    'net',
    'gov',
    'mil',
    'com'
  ],
  'la': [
    'int',
    'net',
    'info',
    'edu',
    'gov',
    'per',
    'com',
    'org',
    'bnr',
    'c',
    'int',
    'net',
    'info',
    'edu',
    'gov',
    'per',
    'com',
    'org',
    'bnr',
    'c'
  ],
  'lb': ['com', 'edu', 'gov', 'net', 'org', 'com', 'edu', 'gov', 'net', 'org'],
  'lc': [
    'com',
    'net',
    'co',
    'org',
    'edu',
    'gov',
    'oy',
    'com',
    'net',
    'co',
    'org',
    'edu',
    'gov',
    'oy'
  ],
  'report': [],
  'travelersinsurance': [],
  'homesense': [],
  '点看': [],
  'li': ['blogspot', 'blogspot'],
  'fun': [],
  'lk': [
    'gov',
    'sch',
    'net',
    'int',
    'com',
    'org',
    'edu',
    'ngo',
    'soc',
    'web',
    'ltd',
    'assn',
    'grp',
    'hotel',
    'ac',
    'gov',
    'sch',
    'net',
    'int',
    'com',
    'org',
    'edu',
    'ngo',
    'soc',
    'web',
    'ltd',
    'assn',
    'grp',
    'hotel',
    'ac'
  ],
  'auto': [],
  'xn--nyqy26a': [],
  'iinet': [],
  'lr': ['com', 'edu', 'gov', 'org', 'net', 'com', 'edu', 'gov', 'org', 'net'],
  'ls': ['co', 'org', 'co', 'org'],
  'lt': ['gov', 'blogspot', 'gov', 'blogspot'],
  'lu': ['blogspot', 'blogspot'],
  'bms': [],
  'lv': [
    'com',
    'edu',
    'gov',
    'org',
    'mil',
    'id',
    'net',
    'asn',
    'conf',
    'com',
    'edu',
    'gov',
    'org',
    'mil',
    'id',
    'net',
    'asn',
    'conf'
  ],
  'office': [],
  'ly': [
    'com',
    'net',
    'gov',
    'plc',
    'edu',
    'sch',
    'med',
    'org',
    'id',
    'com',
    'net',
    'gov',
    'plc',
    'edu',
    'sch',
    'med',
    'org',
    'id'
  ],
  'bmw': [],
  'enterprises': [],
  'photos': [],
  'xn--9et52u': [],
  'locker': [],
  'xn--3e0b707e': [],
  'download': [],
  'ma': [
    'co',
    'net',
    'gov',
    'org',
    'ac',
    'press',
    'co',
    'net',
    'gov',
    'org',
    'ac',
    'press'
  ],
  'mc': ['tm', 'asso', 'tm', 'asso'],
  'md': ['blogspot', 'blogspot'],
  'barefoot': [],
  'me': [
    'co',
    'net',
    'org',
    'edu',
    'ac',
    'gov',
    'its',
    'priv',
    'daplie',
    'brasilia',
    'ddns',
    'dnsfor',
    'hopto',
    'loginto',
    'noip',
    'webhop',
    'diskstation',
    'dscloud',
    'i234',
    'myds',
    'synology',
    'yombo',
    'co',
    'net',
    'org',
    'edu',
    'ac',
    'gov',
    'its',
    'priv',
    'daplie',
    'brasilia',
    'ddns',
    'dnsfor',
    'hopto',
    'loginto',
    'noip',
    'webhop',
    'diskstation',
    'dscloud',
    'i234',
    'myds',
    'synology',
    'yombo'
  ],
  'mg': [
    'org',
    'nom',
    'gov',
    'prd',
    'tm',
    'edu',
    'mil',
    'com',
    'co',
    'org',
    'nom',
    'gov',
    'prd',
    'tm',
    'edu',
    'mil',
    'com',
    'co'
  ],
  'nowtv': [],
  'mh': [],
  'soy': [],
  'mk': [
    'com',
    'org',
    'net',
    'edu',
    'gov',
    'inf',
    'name',
    'blogspot',
    'com',
    'org',
    'net',
    'edu',
    'gov',
    'inf',
    'name',
    'blogspot'
  ],
  'ml': [
    'com',
    'edu',
    'gouv',
    'gov',
    'net',
    'org',
    'presse',
    'com',
    'edu',
    'gouv',
    'gov',
    'net',
    'org',
    'presse'
  ],
  'lancaster': [],
  'mm': ['*', '*'],
  'mn': ['gov', 'edu', 'org', 'nyc', 'gov', 'edu', 'org', 'nyc'],
  'bnl': [],
  'mo': ['com', 'net', 'org', 'edu', 'gov', 'com', 'net', 'org', 'edu', 'gov'],
  'cancerresearch': [],
  'cipriani': [],
  'mp': [],
  'mq': [],
  'mr': ['gov', 'blogspot', 'gov', 'blogspot'],
  'ms': ['com', 'edu', 'gov', 'net', 'org', 'com', 'edu', 'gov', 'net', 'org'],
  'author': [],
  'mt': [
    'com',
    'edu',
    'net',
    'org',
    'blogspot.com',
    'com',
    'edu',
    'net',
    'org',
    'blogspot.com'
  ],
  'poker': [],
  'mu': [
    'com',
    'net',
    'org',
    'gov',
    'ac',
    'co',
    'or',
    'com',
    'net',
    'org',
    'gov',
    'ac',
    'co',
    'or'
  ],
  'mv': [
    'aero',
    'biz',
    'com',
    'coop',
    'edu',
    'gov',
    'info',
    'int',
    'mil',
    'museum',
    'name',
    'net',
    'org',
    'pro',
    'aero',
    'biz',
    'com',
    'coop',
    'edu',
    'gov',
    'info',
    'int',
    'mil',
    'museum',
    'name',
    'net',
    'org',
    'pro'
  ],
  'vana': [],
  'mw': [
    'ac',
    'biz',
    'co',
    'com',
    'coop',
    'edu',
    'gov',
    'int',
    'museum',
    'net',
    'org',
    'ac',
    'biz',
    'co',
    'com',
    'coop',
    'edu',
    'gov',
    'int',
    'museum',
    'net',
    'org'
  ],
  'mx': [
    'com',
    'org',
    'gob',
    'edu',
    'net',
    'blogspot',
    'com',
    'org',
    'gob',
    'edu',
    'net',
    'blogspot'
  ],
  'my': [
    'com',
    'net',
    'org',
    'gov',
    'edu',
    'mil',
    'name',
    'blogspot',
    'com',
    'net',
    'org',
    'gov',
    'edu',
    'mil',
    'name',
    'blogspot'
  ],
  'mz': [
    'ac',
    'adv',
    'co',
    'edu',
    'gov',
    'mil',
    'net',
    'org',
    'ac',
    'adv',
    'co',
    'edu',
    'gov',
    'mil',
    'net',
    'org'
  ],
  'chanel': [],
  'plus': [],
  'tirol': [],
  'na': [
    'info',
    'pro',
    'name',
    'school',
    'or',
    'dr',
    'us',
    'mx',
    'ca',
    'in',
    'cc',
    'tv',
    'ws',
    'mobi',
    'co',
    'com',
    'org',
    'info',
    'pro',
    'name',
    'school',
    'or',
    'dr',
    'us',
    'mx',
    'ca',
    'in',
    'cc',
    'tv',
    'ws',
    'mobi',
    'co',
    'com',
    'org'
  ],
  'nc': ['asso', 'asso'],
  'dish': [],
  'ne': [],
  'nf': [
    'com',
    'net',
    'per',
    'rec',
    'web',
    'arts',
    'firm',
    'info',
    'other',
    'store',
    'com',
    'net',
    'per',
    'rec',
    'web',
    'arts',
    'firm',
    'info',
    'other',
    'store'
  ],
  'ng': [
    'com',
    'edu',
    'gov',
    'i',
    'mil',
    'mobi',
    'name',
    'net',
    'org',
    'sch',
    'blogspot.com',
    'com',
    'edu',
    'gov',
    'i',
    'mil',
    'mobi',
    'name',
    'net',
    'org',
    'sch',
    'blogspot.com'
  ],
  '臺灣': [],
  'ni': [
    'ac',
    'biz',
    'co',
    'com',
    'edu',
    'gob',
    'in',
    'info',
    'int',
    'mil',
    'net',
    'nom',
    'org',
    'web',
    'ac',
    'biz',
    'co',
    'com',
    'edu',
    'gob',
    'in',
    'info',
    'int',
    'mil',
    'net',
    'nom',
    'org',
    'web'
  ],
  'nl': [
    'bv',
    'virtueeldomein',
    'co',
    'blogspot',
    '*.transurl',
    'bv',
    'virtueeldomein',
    'co',
    'blogspot',
    '*.transurl'
  ],
  'no': [
    'fhs',
    'vgs',
    'fylkesbibl',
    'folkebibl',
    'museum',
    'idrett',
    'priv',
    'mil',
    'stat',
    'dep',
    'kommune',
    'herad',
    'aa',
    'ah',
    'bu',
    'fm',
    'hl',
    'hm',
    'jan-mayen',
    'mr',
    'nl',
    'nt',
    'of',
    'ol',
    'oslo',
    'rl',
    'sf',
    'st',
    'svalbard',
    'tm',
    'tr',
    'va',
    'vf',
    'gs.aa',
    'gs.ah',
    'gs.bu',
    'gs.fm',
    'gs.hl',
    'gs.hm',
    'gs.jan-mayen',
    'gs.mr',
    'gs.nl',
    'gs.nt',
    'gs.of',
    'gs.ol',
    'gs.oslo',
    'gs.rl',
    'gs.sf',
    'gs.st',
    'gs.svalbard',
    'gs.tm',
    'gs.tr',
    'gs.va',
    'gs.vf',
    'akrehamn',
    'xn--krehamn-dxa',
    'algard',
    'xn--lgrd-poac',
    'arna',
    'brumunddal',
    'bryne',
    'bronnoysund',
    'xn--brnnysund-m8ac',
    'drobak',
    'xn--drbak-wua',
    'egersund',
    'fetsund',
    'floro',
    'xn--flor-jra',
    'fredrikstad',
    'hokksund',
    'honefoss',
    'xn--hnefoss-q1a',
    'jessheim',
    'jorpeland',
    'xn--jrpeland-54a',
    'kirkenes',
    'kopervik',
    'krokstadelva',
    'langevag',
    'xn--langevg-jxa',
    'leirvik',
    'mjondalen',
    'xn--mjndalen-64a',
    'mo-i-rana',
    'mosjoen',
    'xn--mosjen-eya',
    'nesoddtangen',
    'orkanger',
    'osoyro',
    'xn--osyro-wua',
    'raholt',
    'xn--rholt-mra',
    'sandnessjoen',
    'xn--sandnessjen-ogb',
    'skedsmokorset',
    'slattum',
    'spjelkavik',
    'stathelle',
    'stavern',
    'stjordalshalsen',
    'xn--stjrdalshalsen-sqb',
    'tananger',
    'tranby',
    'vossevangen',
    'afjord',
    'xn--fjord-lra',
    'agdenes',
    'al',
    'xn--l-1fa',
    'alesund',
    'xn--lesund-hua',
    'alstahaug',
    'alta',
    'xn--lt-liac',
    'alaheadju',
    'xn--laheadju-7ya',
    'alvdal',
    'amli',
    'xn--mli-tla',
    'amot',
    'xn--mot-tla',
    'andebu',
    'andoy',
    'xn--andy-ira',
    'andasuolo',
    'ardal',
    'xn--rdal-poa',
    'aremark',
    'arendal',
    'xn--s-1fa',
    'aseral',
    'xn--seral-lra',
    'asker',
    'askim',
    'askvoll',
    'askoy',
    'xn--asky-ira',
    'asnes',
    'xn--snes-poa',
    'audnedaln',
    'aukra',
    'aure',
    'aurland',
    'aurskog-holand',
    'xn--aurskog-hland-jnb',
    'austevoll',
    'austrheim',
    'averoy',
    'xn--avery-yua',
    'balestrand',
    'ballangen',
    'balat',
    'xn--blt-elab',
    'balsfjord',
    'bahccavuotna',
    'xn--bhccavuotna-k7a',
    'bamble',
    'bardu',
    'beardu',
    'beiarn',
    'bajddar',
    'xn--bjddar-pta',
    'baidar',
    'xn--bidr-5nac',
    'berg',
    'bergen',
    'berlevag',
    'xn--berlevg-jxa',
    'bearalvahki',
    'xn--bearalvhki-y4a',
    'bindal',
    'birkenes',
    'bjarkoy',
    'xn--bjarky-fya',
    'bjerkreim',
    'bjugn',
    'bodo',
    'xn--bod-2na',
    'badaddja',
    'xn--bdddj-mrabd',
    'budejju',
    'bokn',
    'bremanger',
    'bronnoy',
    'xn--brnny-wuac',
    'bygland',
    'bykle',
    'barum',
    'xn--brum-voa',
    'bo.telemark',
    'xn--b-5ga.telemark',
    'bo.nordland',
    'xn--b-5ga.nordland',
    'bievat',
    'xn--bievt-0qa',
    'bomlo',
    'xn--bmlo-gra',
    'batsfjord',
    'xn--btsfjord-9za',
    'bahcavuotna',
    'xn--bhcavuotna-s4a',
    'dovre',
    'drammen',
    'drangedal',
    'dyroy',
    'xn--dyry-ira',
    'donna',
    'xn--dnna-gra',
    'eid',
    'eidfjord',
    'eidsberg',
    'eidskog',
    'eidsvoll',
    'eigersund',
    'elverum',
    'enebakk',
    'engerdal',
    'etne',
    'etnedal',
    'evenes',
    'evenassi',
    'xn--eveni-0qa01ga',
    'evje-og-hornnes',
    'farsund',
    'fauske',
    'fuossko',
    'fuoisku',
    'fedje',
    'fet',
    'finnoy',
    'xn--finny-yua',
    'fitjar',
    'fjaler',
    'fjell',
    'flakstad',
    'flatanger',
    'flekkefjord',
    'flesberg',
    'flora',
    'fla',
    'xn--fl-zia',
    'folldal',
    'forsand',
    'fosnes',
    'frei',
    'frogn',
    'froland',
    'frosta',
    'frana',
    'xn--frna-woa',
    'froya',
    'xn--frya-hra',
    'fusa',
    'fyresdal',
    'forde',
    'xn--frde-gra',
    'gamvik',
    'gangaviika',
    'xn--ggaviika-8ya47h',
    'gaular',
    'gausdal',
    'gildeskal',
    'xn--gildeskl-g0a',
    'giske',
    'gjemnes',
    'gjerdrum',
    'gjerstad',
    'gjesdal',
    'gjovik',
    'xn--gjvik-wua',
    'gloppen',
    'gol',
    'gran',
    'grane',
    'granvin',
    'gratangen',
    'grimstad',
    'grong',
    'kraanghke',
    'xn--kranghke-b0a',
    'grue',
    'gulen',
    'hadsel',
    'halden',
    'halsa',
    'hamar',
    'hamaroy',
    'habmer',
    'xn--hbmer-xqa',
    'hapmir',
    'xn--hpmir-xqa',
    'hammerfest',
    'hammarfeasta',
    'xn--hmmrfeasta-s4ac',
    'haram',
    'hareid',
    'harstad',
    'hasvik',
    'aknoluokta',
    'xn--koluokta-7ya57h',
    'hattfjelldal',
    'aarborte',
    'haugesund',
    'hemne',
    'hemnes',
    'hemsedal',
    'heroy.more-og-romsdal',
    'xn--hery-ira.xn--mre-og-romsdal-qqb',
    'heroy.nordland',
    'xn--hery-ira.nordland',
    'hitra',
    'hjartdal',
    'hjelmeland',
    'hobol',
    'xn--hobl-ira',
    'hof',
    'hol',
    'hole',
    'holmestrand',
    'holtalen',
    'xn--holtlen-hxa',
    'hornindal',
    'horten',
    'hurdal',
    'hurum',
    'hvaler',
    'hyllestad',
    'hagebostad',
    'xn--hgebostad-g3a',
    'hoyanger',
    'xn--hyanger-q1a',
    'hoylandet',
    'xn--hylandet-54a',
    'ha',
    'xn--h-2fa',
    'ibestad',
    'inderoy',
    'xn--indery-fya',
    'iveland',
    'jevnaker',
    'jondal',
    'jolster',
    'xn--jlster-bya',
    'karasjok',
    'karasjohka',
    'xn--krjohka-hwab49j',
    'karlsoy',
    'galsa',
    'xn--gls-elac',
    'karmoy',
    'xn--karmy-yua',
    'kautokeino',
    'guovdageaidnu',
    'klepp',
    'klabu',
    'xn--klbu-woa',
    'kongsberg',
    'kongsvinger',
    'kragero',
    'xn--krager-gya',
    'kristiansand',
    'kristiansund',
    'krodsherad',
    'xn--krdsherad-m8a',
    'kvalsund',
    'rahkkeravju',
    'xn--rhkkervju-01af',
    'kvam',
    'kvinesdal',
    'kvinnherad',
    'kviteseid',
    'kvitsoy',
    'xn--kvitsy-fya',
    'kvafjord',
    'xn--kvfjord-nxa',
    'giehtavuoatna',
    'kvanangen',
    'xn--kvnangen-k0a',
    'navuotna',
    'xn--nvuotna-hwa',
    'kafjord',
    'xn--kfjord-iua',
    'gaivuotna',
    'xn--givuotna-8ya',
    'larvik',
    'lavangen',
    'lavagis',
    'loabat',
    'xn--loabt-0qa',
    'lebesby',
    'davvesiida',
    'leikanger',
    'leirfjord',
    'leka',
    'leksvik',
    'lenvik',
    'leangaviika',
    'xn--leagaviika-52b',
    'lesja',
    'levanger',
    'lier',
    'lierne',
    'lillehammer',
    'lillesand',
    'lindesnes',
    'lindas',
    'xn--linds-pra',
    'lom',
    'loppa',
    'lahppi',
    'xn--lhppi-xqa',
    'lund',
    'lunner',
    'luroy',
    'xn--lury-ira',
    'luster',
    'lyngdal',
    'lyngen',
    'ivgu',
    'lardal',
    'lerdal',
    'xn--lrdal-sra',
    'lodingen',
    'xn--ldingen-q1a',
    'lorenskog',
    'xn--lrenskog-54a',
    'loten',
    'xn--lten-gra',
    'malvik',
    'masoy',
    'xn--msy-ula0h',
    'muosat',
    'xn--muost-0qa',
    'mandal',
    'marker',
    'marnardal',
    'masfjorden',
    'meland',
    'meldal',
    'melhus',
    'meloy',
    'xn--mely-ira',
    'meraker',
    'xn--merker-kua',
    'moareke',
    'xn--moreke-jua',
    'midsund',
    'midtre-gauldal',
    'modalen',
    'modum',
    'molde',
    'moskenes',
    'moss',
    'mosvik',
    'malselv',
    'xn--mlselv-iua',
    'malatvuopmi',
    'xn--mlatvuopmi-s4a',
    'namdalseid',
    'aejrie',
    'namsos',
    'namsskogan',
    'naamesjevuemie',
    'xn--nmesjevuemie-tcba',
    'laakesvuemie',
    'nannestad',
    'narvik',
    'narviika',
    'naustdal',
    'nedre-eiker',
    'nes.akershus',
    'nes.buskerud',
    'nesna',
    'nesodden',
    'nesseby',
    'unjarga',
    'xn--unjrga-rta',
    'nesset',
    'nissedal',
    'nittedal',
    'nord-aurdal',
    'nord-fron',
    'nord-odal',
    'norddal',
    'nordkapp',
    'davvenjarga',
    'xn--davvenjrga-y4a',
    'nordre-land',
    'nordreisa',
    'raisa',
    'xn--risa-5na',
    'nore-og-uvdal',
    'notodden',
    'naroy',
    'xn--nry-yla5g',
    'notteroy',
    'xn--nttery-byae',
    'odda',
    'oksnes',
    'xn--ksnes-uua',
    'oppdal',
    'oppegard',
    'xn--oppegrd-ixa',
    'orkdal',
    'orland',
    'xn--rland-uua',
    'orskog',
    'xn--rskog-uua',
    'orsta',
    'xn--rsta-fra',
    'os.hedmark',
    'os.hordaland',
    'osen',
    'osteroy',
    'xn--ostery-fya',
    'ostre-toten',
    'xn--stre-toten-zcb',
    'overhalla',
    'ovre-eiker',
    'xn--vre-eiker-k8a',
    'oyer',
    'xn--yer-zna',
    'oygarden',
    'xn--ygarden-p1a',
    'oystre-slidre',
    'xn--ystre-slidre-ujb',
    'porsanger',
    'porsangu',
    'xn--porsgu-sta26f',
    'porsgrunn',
    'radoy',
    'xn--rady-ira',
    'rakkestad',
    'rana',
    'ruovat',
    'randaberg',
    'rauma',
    'rendalen',
    'rennebu',
    'rennesoy',
    'xn--rennesy-v1a',
    'rindal',
    'ringebu',
    'ringerike',
    'ringsaker',
    'rissa',
    'risor',
    'xn--risr-ira',
    'roan',
    'rollag',
    'rygge',
    'ralingen',
    'xn--rlingen-mxa',
    'rodoy',
    'xn--rdy-0nab',
    'romskog',
    'xn--rmskog-bya',
    'roros',
    'xn--rros-gra',
    'rost',
    'xn--rst-0na',
    'royken',
    'xn--ryken-vua',
    'royrvik',
    'xn--ryrvik-bya',
    'rade',
    'xn--rde-ula',
    'salangen',
    'siellak',
    'saltdal',
    'salat',
    'xn--slt-elab',
    'xn--slat-5na',
    'samnanger',
    'sande.more-og-romsdal',
    'sande.xn--mre-og-romsdal-qqb',
    'sande.vestfold',
    'sandefjord',
    'sandnes',
    'sandoy',
    'xn--sandy-yua',
    'sarpsborg',
    'sauda',
    'sauherad',
    'sel',
    'selbu',
    'selje',
    'seljord',
    'sigdal',
    'siljan',
    'sirdal',
    'skaun',
    'skedsmo',
    'ski',
    'skien',
    'skiptvet',
    'skjervoy',
    'xn--skjervy-v1a',
    'skierva',
    'xn--skierv-uta',
    'skjak',
    'xn--skjk-soa',
    'skodje',
    'skanland',
    'xn--sknland-fxa',
    'skanit',
    'xn--sknit-yqa',
    'smola',
    'xn--smla-hra',
    'snillfjord',
    'snasa',
    'xn--snsa-roa',
    'snoasa',
    'snaase',
    'xn--snase-nra',
    'sogndal',
    'sokndal',
    'sola',
    'solund',
    'songdalen',
    'sortland',
    'spydeberg',
    'stange',
    'stavanger',
    'steigen',
    'steinkjer',
    'stjordal',
    'xn--stjrdal-s1a',
    'stokke',
    'stor-elvdal',
    'stord',
    'stordal',
    'storfjord',
    'omasvuotna',
    'strand',
    'stranda',
    'stryn',
    'sula',
    'suldal',
    'sund',
    'sunndal',
    'surnadal',
    'sveio',
    'svelvik',
    'sykkylven',
    'sogne',
    'xn--sgne-gra',
    'somna',
    'xn--smna-gra',
    'sondre-land',
    'xn--sndre-land-0cb',
    'sor-aurdal',
    'xn--sr-aurdal-l8a',
    'sor-fron',
    'xn--sr-fron-q1a',
    'sor-odal',
    'xn--sr-odal-q1a',
    'sor-varanger',
    'xn--sr-varanger-ggb',
    'matta-varjjat',
    'xn--mtta-vrjjat-k7af',
    'sorfold',
    'xn--srfold-bya',
    'sorreisa',
    'xn--srreisa-q1a',
    'sorum',
    'xn--srum-gra',
    'tana',
    'deatnu',
    'time',
    'tingvoll',
    'tinn',
    'tjeldsund',
    'dielddanuorri',
    'tjome',
    'xn--tjme-hra',
    'tokke',
    'tolga',
    'torsken',
    'tranoy',
    'xn--trany-yua',
    'tromso',
    'xn--troms-zua',
    'tromsa',
    'romsa',
    'trondheim',
    'troandin',
    'trysil',
    'trana',
    'xn--trna-woa',
    'trogstad',
    'xn--trgstad-r1a',
    'tvedestrand',
    'tydal',
    'tynset',
    'tysfjord',
    'divtasvuodna',
    'divttasvuotna',
    'tysnes',
    'tysvar',
    'xn--tysvr-vra',
    'tonsberg',
    'xn--tnsberg-q1a',
    'ullensaker',
    'ullensvang',
    'ulvik',
    'utsira',
    'vadso',
    'xn--vads-jra',
    'cahcesuolo',
    'xn--hcesuolo-7ya35b',
    'vaksdal',
    'valle',
    'vang',
    'vanylven',
    'vardo',
    'xn--vard-jra',
    'varggat',
    'xn--vrggt-xqad',
    'vefsn',
    'vaapste',
    'vega',
    'vegarshei',
    'xn--vegrshei-c0a',
    'vennesla',
    'verdal',
    'verran',
    'vestby',
    'vestnes',
    'vestre-slidre',
    'vestre-toten',
    'vestvagoy',
    'xn--vestvgy-ixa6o',
    'vevelstad',
    'vik',
    'vikna',
    'vindafjord',
    'volda',
    'voss',
    'varoy',
    'xn--vry-yla5g',
    'vagan',
    'xn--vgan-qoa',
    'voagat',
    'vagsoy',
    'xn--vgsy-qoa0j',
    'vaga',
    'xn--vg-yiab',
    'valer.ostfold',
    'xn--vler-qoa.xn--stfold-9xa',
    'valer.hedmark',
    'xn--vler-qoa.hedmark',
    'co',
    'blogspot',
    'fhs',
    'vgs',
    'fylkesbibl',
    'folkebibl',
    'museum',
    'idrett',
    'priv',
    'mil',
    'stat',
    'dep',
    'kommune',
    'herad',
    'aa',
    'ah',
    'bu',
    'fm',
    'hl',
    'hm',
    'jan-mayen',
    'mr',
    'nl',
    'nt',
    'of',
    'ol',
    'oslo',
    'rl',
    'sf',
    'st',
    'svalbard',
    'tm',
    'tr',
    'va',
    'vf',
    'gs.aa',
    'gs.ah',
    'gs.bu',
    'gs.fm',
    'gs.hl',
    'gs.hm',
    'gs.jan-mayen',
    'gs.mr',
    'gs.nl',
    'gs.nt',
    'gs.of',
    'gs.ol',
    'gs.oslo',
    'gs.rl',
    'gs.sf',
    'gs.st',
    'gs.svalbard',
    'gs.tm',
    'gs.tr',
    'gs.va',
    'gs.vf',
    'akrehamn',
    'åkrehamn',
    'algard',
    'ålgård',
    'arna',
    'brumunddal',
    'bryne',
    'bronnoysund',
    'brønnøysund',
    'drobak',
    'drøbak',
    'egersund',
    'fetsund',
    'floro',
    'florø',
    'fredrikstad',
    'hokksund',
    'honefoss',
    'hønefoss',
    'jessheim',
    'jorpeland',
    'jørpeland',
    'kirkenes',
    'kopervik',
    'krokstadelva',
    'langevag',
    'langevåg',
    'leirvik',
    'mjondalen',
    'mjøndalen',
    'mo-i-rana',
    'mosjoen',
    'mosjøen',
    'nesoddtangen',
    'orkanger',
    'osoyro',
    'osøyro',
    'raholt',
    'råholt',
    'sandnessjoen',
    'sandnessjøen',
    'skedsmokorset',
    'slattum',
    'spjelkavik',
    'stathelle',
    'stavern',
    'stjordalshalsen',
    'stjørdalshalsen',
    'tananger',
    'tranby',
    'vossevangen',
    'afjord',
    'åfjord',
    'agdenes',
    'al',
    'ål',
    'alesund',
    'ålesund',
    'alstahaug',
    'alta',
    'áltá',
    'alaheadju',
    'álaheadju',
    'alvdal',
    'amli',
    'åmli',
    'amot',
    'åmot',
    'andebu',
    'andoy',
    'andøy',
    'andasuolo',
    'ardal',
    'årdal',
    'aremark',
    'arendal',
    'ås',
    'aseral',
    'åseral',
    'asker',
    'askim',
    'askvoll',
    'askoy',
    'askøy',
    'asnes',
    'åsnes',
    'audnedaln',
    'aukra',
    'aure',
    'aurland',
    'aurskog-holand',
    'aurskog-høland',
    'austevoll',
    'austrheim',
    'averoy',
    'averøy',
    'balestrand',
    'ballangen',
    'balat',
    'bálát',
    'balsfjord',
    'bahccavuotna',
    'báhccavuotna',
    'bamble',
    'bardu',
    'beardu',
    'beiarn',
    'bajddar',
    'bájddar',
    'baidar',
    'báidár',
    'berg',
    'bergen',
    'berlevag',
    'berlevåg',
    'bearalvahki',
    'bearalváhki',
    'bindal',
    'birkenes',
    'bjarkoy',
    'bjarkøy',
    'bjerkreim',
    'bjugn',
    'bodo',
    'bodø',
    'badaddja',
    'bådåddjå',
    'budejju',
    'bokn',
    'bremanger',
    'bronnoy',
    'brønnøy',
    'bygland',
    'bykle',
    'barum',
    'bærum',
    'bo.telemark',
    'bø.telemark',
    'bo.nordland',
    'bø.nordland',
    'bievat',
    'bievát',
    'bomlo',
    'bømlo',
    'batsfjord',
    'båtsfjord',
    'bahcavuotna',
    'báhcavuotna',
    'dovre',
    'drammen',
    'drangedal',
    'dyroy',
    'dyrøy',
    'donna',
    'dønna',
    'eid',
    'eidfjord',
    'eidsberg',
    'eidskog',
    'eidsvoll',
    'eigersund',
    'elverum',
    'enebakk',
    'engerdal',
    'etne',
    'etnedal',
    'evenes',
    'evenassi',
    'evenášši',
    'evje-og-hornnes',
    'farsund',
    'fauske',
    'fuossko',
    'fuoisku',
    'fedje',
    'fet',
    'finnoy',
    'finnøy',
    'fitjar',
    'fjaler',
    'fjell',
    'flakstad',
    'flatanger',
    'flekkefjord',
    'flesberg',
    'flora',
    'fla',
    'flå',
    'folldal',
    'forsand',
    'fosnes',
    'frei',
    'frogn',
    'froland',
    'frosta',
    'frana',
    'fræna',
    'froya',
    'frøya',
    'fusa',
    'fyresdal',
    'forde',
    'førde',
    'gamvik',
    'gangaviika',
    'gáŋgaviika',
    'gaular',
    'gausdal',
    'gildeskal',
    'gildeskål',
    'giske',
    'gjemnes',
    'gjerdrum',
    'gjerstad',
    'gjesdal',
    'gjovik',
    'gjøvik',
    'gloppen',
    'gol',
    'gran',
    'grane',
    'granvin',
    'gratangen',
    'grimstad',
    'grong',
    'kraanghke',
    'kråanghke',
    'grue',
    'gulen',
    'hadsel',
    'halden',
    'halsa',
    'hamar',
    'hamaroy',
    'habmer',
    'hábmer',
    'hapmir',
    'hápmir',
    'hammerfest',
    'hammarfeasta',
    'hámmárfeasta',
    'haram',
    'hareid',
    'harstad',
    'hasvik',
    'aknoluokta',
    'ákŋoluokta',
    'hattfjelldal',
    'aarborte',
    'haugesund',
    'hemne',
    'hemnes',
    'hemsedal',
    'heroy.more-og-romsdal',
    'herøy.møre-og-romsdal',
    'heroy.nordland',
    'herøy.nordland',
    'hitra',
    'hjartdal',
    'hjelmeland',
    'hobol',
    'hobøl',
    'hof',
    'hol',
    'hole',
    'holmestrand',
    'holtalen',
    'holtålen',
    'hornindal',
    'horten',
    'hurdal',
    'hurum',
    'hvaler',
    'hyllestad',
    'hagebostad',
    'hægebostad',
    'hoyanger',
    'høyanger',
    'hoylandet',
    'høylandet',
    'ha',
    'hå',
    'ibestad',
    'inderoy',
    'inderøy',
    'iveland',
    'jevnaker',
    'jondal',
    'jolster',
    'jølster',
    'karasjok',
    'karasjohka',
    'kárášjohka',
    'karlsoy',
    'galsa',
    'gálsá',
    'karmoy',
    'karmøy',
    'kautokeino',
    'guovdageaidnu',
    'klepp',
    'klabu',
    'klæbu',
    'kongsberg',
    'kongsvinger',
    'kragero',
    'kragerø',
    'kristiansand',
    'kristiansund',
    'krodsherad',
    'krødsherad',
    'kvalsund',
    'rahkkeravju',
    'ráhkkerávju',
    'kvam',
    'kvinesdal',
    'kvinnherad',
    'kviteseid',
    'kvitsoy',
    'kvitsøy',
    'kvafjord',
    'kvæfjord',
    'giehtavuoatna',
    'kvanangen',
    'kvænangen',
    'navuotna',
    'návuotna',
    'kafjord',
    'kåfjord',
    'gaivuotna',
    'gáivuotna',
    'larvik',
    'lavangen',
    'lavagis',
    'loabat',
    'loabát',
    'lebesby',
    'davvesiida',
    'leikanger',
    'leirfjord',
    'leka',
    'leksvik',
    'lenvik',
    'leangaviika',
    'leaŋgaviika',
    'lesja',
    'levanger',
    'lier',
    'lierne',
    'lillehammer',
    'lillesand',
    'lindesnes',
    'lindas',
    'lindås',
    'lom',
    'loppa',
    'lahppi',
    'láhppi',
    'lund',
    'lunner',
    'luroy',
    'lurøy',
    'luster',
    'lyngdal',
    'lyngen',
    'ivgu',
    'lardal',
    'lerdal',
    'lærdal',
    'lodingen',
    'lødingen',
    'lorenskog',
    'lørenskog',
    'loten',
    'løten',
    'malvik',
    'masoy',
    'måsøy',
    'muosat',
    'muosát',
    'mandal',
    'marker',
    'marnardal',
    'masfjorden',
    'meland',
    'meldal',
    'melhus',
    'meloy',
    'meløy',
    'meraker',
    'meråker',
    'moareke',
    'moåreke',
    'midsund',
    'midtre-gauldal',
    'modalen',
    'modum',
    'molde',
    'moskenes',
    'moss',
    'mosvik',
    'malselv',
    'målselv',
    'malatvuopmi',
    'málatvuopmi',
    'namdalseid',
    'aejrie',
    'namsos',
    'namsskogan',
    'naamesjevuemie',
    'nååmesjevuemie',
    'laakesvuemie',
    'nannestad',
    'narvik',
    'narviika',
    'naustdal',
    'nedre-eiker',
    'nes.akershus',
    'nes.buskerud',
    'nesna',
    'nesodden',
    'nesseby',
    'unjarga',
    'unjárga',
    'nesset',
    'nissedal',
    'nittedal',
    'nord-aurdal',
    'nord-fron',
    'nord-odal',
    'norddal',
    'nordkapp',
    'davvenjarga',
    'davvenjárga',
    'nordre-land',
    'nordreisa',
    'raisa',
    'ráisa',
    'nore-og-uvdal',
    'notodden',
    'naroy',
    'nærøy',
    'notteroy',
    'nøtterøy',
    'odda',
    'oksnes',
    'øksnes',
    'oppdal',
    'oppegard',
    'oppegård',
    'orkdal',
    'orland',
    'ørland',
    'orskog',
    'ørskog',
    'orsta',
    'ørsta',
    'os.hedmark',
    'os.hordaland',
    'osen',
    'osteroy',
    'osterøy',
    'ostre-toten',
    'østre-toten',
    'overhalla',
    'ovre-eiker',
    'øvre-eiker',
    'oyer',
    'øyer',
    'oygarden',
    'øygarden',
    'oystre-slidre',
    'øystre-slidre',
    'porsanger',
    'porsangu',
    'porsáŋgu',
    'porsgrunn',
    'radoy',
    'radøy',
    'rakkestad',
    'rana',
    'ruovat',
    'randaberg',
    'rauma',
    'rendalen',
    'rennebu',
    'rennesoy',
    'rennesøy',
    'rindal',
    'ringebu',
    'ringerike',
    'ringsaker',
    'rissa',
    'risor',
    'risør',
    'roan',
    'rollag',
    'rygge',
    'ralingen',
    'rælingen',
    'rodoy',
    'rødøy',
    'romskog',
    'rømskog',
    'roros',
    'røros',
    'rost',
    'røst',
    'royken',
    'røyken',
    'royrvik',
    'røyrvik',
    'rade',
    'råde',
    'salangen',
    'siellak',
    'saltdal',
    'salat',
    'sálát',
    'sálat',
    'samnanger',
    'sande.more-og-romsdal',
    'sande.møre-og-romsdal',
    'sande.vestfold',
    'sandefjord',
    'sandnes',
    'sandoy',
    'sandøy',
    'sarpsborg',
    'sauda',
    'sauherad',
    'sel',
    'selbu',
    'selje',
    'seljord',
    'sigdal',
    'siljan',
    'sirdal',
    'skaun',
    'skedsmo',
    'ski',
    'skien',
    'skiptvet',
    'skjervoy',
    'skjervøy',
    'skierva',
    'skiervá',
    'skjak',
    'skjåk',
    'skodje',
    'skanland',
    'skånland',
    'skanit',
    'skánit',
    'smola',
    'smøla',
    'snillfjord',
    'snasa',
    'snåsa',
    'snoasa',
    'snaase',
    'snåase',
    'sogndal',
    'sokndal',
    'sola',
    'solund',
    'songdalen',
    'sortland',
    'spydeberg',
    'stange',
    'stavanger',
    'steigen',
    'steinkjer',
    'stjordal',
    'stjørdal',
    'stokke',
    'stor-elvdal',
    'stord',
    'stordal',
    'storfjord',
    'omasvuotna',
    'strand',
    'stranda',
    'stryn',
    'sula',
    'suldal',
    'sund',
    'sunndal',
    'surnadal',
    'sveio',
    'svelvik',
    'sykkylven',
    'sogne',
    'søgne',
    'somna',
    'sømna',
    'sondre-land',
    'søndre-land',
    'sor-aurdal',
    'sør-aurdal',
    'sor-fron',
    'sør-fron',
    'sor-odal',
    'sør-odal',
    'sor-varanger',
    'sør-varanger',
    'matta-varjjat',
    'mátta-várjjat',
    'sorfold',
    'sørfold',
    'sorreisa',
    'sørreisa',
    'sorum',
    'sørum',
    'tana',
    'deatnu',
    'time',
    'tingvoll',
    'tinn',
    'tjeldsund',
    'dielddanuorri',
    'tjome',
    'tjøme',
    'tokke',
    'tolga',
    'torsken',
    'tranoy',
    'tranøy',
    'tromso',
    'tromsø',
    'tromsa',
    'romsa',
    'trondheim',
    'troandin',
    'trysil',
    'trana',
    'træna',
    'trogstad',
    'trøgstad',
    'tvedestrand',
    'tydal',
    'tynset',
    'tysfjord',
    'divtasvuodna',
    'divttasvuotna',
    'tysnes',
    'tysvar',
    'tysvær',
    'tonsberg',
    'tønsberg',
    'ullensaker',
    'ullensvang',
    'ulvik',
    'utsira',
    'vadso',
    'vadsø',
    'cahcesuolo',
    'čáhcesuolo',
    'vaksdal',
    'valle',
    'vang',
    'vanylven',
    'vardo',
    'vardø',
    'varggat',
    'várggát',
    'vefsn',
    'vaapste',
    'vega',
    'vegarshei',
    'vegårshei',
    'vennesla',
    'verdal',
    'verran',
    'vestby',
    'vestnes',
    'vestre-slidre',
    'vestre-toten',
    'vestvagoy',
    'vestvågøy',
    'vevelstad',
    'vik',
    'vikna',
    'vindafjord',
    'volda',
    'voss',
    'varoy',
    'værøy',
    'vagan',
    'vågan',
    'voagat',
    'vagsoy',
    'vågsøy',
    'vaga',
    'vågå',
    'valer.ostfold',
    'våler.østfold',
    'valer.hedmark',
    'våler.hedmark',
    'co',
    'blogspot'
  ],
  'bom': [],
  'np': ['*', '*'],
  'boo': [],
  'nr': [
    'biz',
    'info',
    'gov',
    'edu',
    'org',
    'net',
    'com',
    'biz',
    'info',
    'gov',
    'edu',
    'org',
    'net',
    'com'
  ],
  'bot': [],
  'nu': ['merseine', 'mine', 'shacknet', 'merseine', 'mine', 'shacknet'],
  'bnpparibas': [],
  'box': [],
  'storage': [],
  'nz': [
    'ac',
    'co',
    'cri',
    'geek',
    'gen',
    'govt',
    'health',
    'iwi',
    'kiwi',
    'maori',
    'mil',
    'xn--mori-qsa',
    'net',
    'org',
    'parliament',
    'school',
    'blogspot.co',
    'ac',
    'co',
    'cri',
    'geek',
    'gen',
    'govt',
    'health',
    'iwi',
    'kiwi',
    'maori',
    'mil',
    'māori',
    'net',
    'org',
    'parliament',
    'school',
    'blogspot.co'
  ],
  'total': [],
  'セール': [],
  'suzuki': [],
  'om': [
    'co',
    'com',
    'edu',
    'gov',
    'med',
    'museum',
    'net',
    'org',
    'pro',
    'co',
    'com',
    'edu',
    'gov',
    'med',
    'museum',
    'net',
    'org',
    'pro'
  ],
  'xn--qcka1pmc': [],
  'natura': [],
  'xn--tiq49xqyj': [],
  'social': [],
  'mtpc': [],
  'srl': [],
  'dell': [],
  'pa': [
    'ac',
    'gob',
    'com',
    'org',
    'sld',
    'edu',
    'net',
    'ing',
    'abo',
    'med',
    'nom',
    'ac',
    'gob',
    'com',
    'org',
    'sld',
    'edu',
    'net',
    'ing',
    'abo',
    'med',
    'nom'
  ],
  'contractors': [],
  'amex': [],
  'hitachi': [],
  'srt': [],
  'pe': [
    'edu',
    'gob',
    'nom',
    'mil',
    'org',
    'com',
    'net',
    'blogspot',
    'edu',
    'gob',
    'nom',
    'mil',
    'org',
    'com',
    'net',
    'blogspot'
  ],
  'pf': ['com', 'org', 'edu', 'com', 'org', 'edu'],
  'pg': ['*', '*'],
  'earth': [],
  'fyi': [],
  'ph': [
    'com',
    'net',
    'org',
    'gov',
    'edu',
    'ngo',
    'mil',
    'i',
    'com',
    'net',
    'org',
    'gov',
    'edu',
    'ngo',
    'mil',
    'i'
  ],
  'luxury': [],
  'pk': [
    'com',
    'net',
    'edu',
    'org',
    'fam',
    'biz',
    'web',
    'gov',
    'gob',
    'gok',
    'gon',
    'gop',
    'gos',
    'info',
    'com',
    'net',
    'edu',
    'org',
    'fam',
    'biz',
    'web',
    'gov',
    'gob',
    'gok',
    'gon',
    'gop',
    'gos',
    'info'
  ],
  'pl': [
    'com',
    'net',
    'org',
    'aid',
    'agro',
    'atm',
    'auto',
    'biz',
    'edu',
    'gmina',
    'gsm',
    'info',
    'mail',
    'miasta',
    'media',
    'mil',
    'nieruchomosci',
    'nom',
    'pc',
    'powiat',
    'priv',
    'realestate',
    'rel',
    'sex',
    'shop',
    'sklep',
    'sos',
    'szkola',
    'targi',
    'tm',
    'tourism',
    'travel',
    'turystyka',
    'gov',
    'ap.gov',
    'ic.gov',
    'is.gov',
    'us.gov',
    'kmpsp.gov',
    'kppsp.gov',
    'kwpsp.gov',
    'psp.gov',
    'wskr.gov',
    'kwp.gov',
    'mw.gov',
    'ug.gov',
    'um.gov',
    'umig.gov',
    'ugim.gov',
    'upow.gov',
    'uw.gov',
    'starostwo.gov',
    'pa.gov',
    'po.gov',
    'psse.gov',
    'pup.gov',
    'rzgw.gov',
    'sa.gov',
    'so.gov',
    'sr.gov',
    'wsa.gov',
    'sko.gov',
    'uzs.gov',
    'wiih.gov',
    'winb.gov',
    'pinb.gov',
    'wios.gov',
    'witd.gov',
    'wzmiuw.gov',
    'piw.gov',
    'wiw.gov',
    'griw.gov',
    'wif.gov',
    'oum.gov',
    'sdn.gov',
    'zp.gov',
    'uppo.gov',
    'mup.gov',
    'wuoz.gov',
    'konsulat.gov',
    'oirm.gov',
    'augustow',
    'babia-gora',
    'bedzin',
    'beskidy',
    'bialowieza',
    'bialystok',
    'bielawa',
    'bieszczady',
    'boleslawiec',
    'bydgoszcz',
    'bytom',
    'cieszyn',
    'czeladz',
    'czest',
    'dlugoleka',
    'elblag',
    'elk',
    'glogow',
    'gniezno',
    'gorlice',
    'grajewo',
    'ilawa',
    'jaworzno',
    'jelenia-gora',
    'jgora',
    'kalisz',
    'kazimierz-dolny',
    'karpacz',
    'kartuzy',
    'kaszuby',
    'katowice',
    'kepno',
    'ketrzyn',
    'klodzko',
    'kobierzyce',
    'kolobrzeg',
    'konin',
    'konskowola',
    'kutno',
    'lapy',
    'lebork',
    'legnica',
    'lezajsk',
    'limanowa',
    'lomza',
    'lowicz',
    'lubin',
    'lukow',
    'malbork',
    'malopolska',
    'mazowsze',
    'mazury',
    'mielec',
    'mielno',
    'mragowo',
    'naklo',
    'nowaruda',
    'nysa',
    'olawa',
    'olecko',
    'olkusz',
    'olsztyn',
    'opoczno',
    'opole',
    'ostroda',
    'ostroleka',
    'ostrowiec',
    'ostrowwlkp',
    'pila',
    'pisz',
    'podhale',
    'podlasie',
    'polkowice',
    'pomorze',
    'pomorskie',
    'prochowice',
    'pruszkow',
    'przeworsk',
    'pulawy',
    'radom',
    'rawa-maz',
    'rybnik',
    'rzeszow',
    'sanok',
    'sejny',
    'slask',
    'slupsk',
    'sosnowiec',
    'stalowa-wola',
    'skoczow',
    'starachowice',
    'stargard',
    'suwalki',
    'swidnica',
    'swiebodzin',
    'swinoujscie',
    'szczecin',
    'szczytno',
    'tarnobrzeg',
    'tgory',
    'turek',
    'tychy',
    'ustka',
    'walbrzych',
    'warmia',
    'warszawa',
    'waw',
    'wegrow',
    'wielun',
    'wlocl',
    'wloclawek',
    'wodzislaw',
    'wolomin',
    'wroclaw',
    'zachpomor',
    'zagan',
    'zarow',
    'zgora',
    'zgorzelec',
    'beep',
    'co',
    'art',
    'gliwice',
    'krakow',
    'poznan',
    'wroc',
    'zakopane',
    'gda',
    'gdansk',
    'gdynia',
    'med',
    'sopot',
    'com',
    'net',
    'org',
    'aid',
    'agro',
    'atm',
    'auto',
    'biz',
    'edu',
    'gmina',
    'gsm',
    'info',
    'mail',
    'miasta',
    'media',
    'mil',
    'nieruchomosci',
    'nom',
    'pc',
    'powiat',
    'priv',
    'realestate',
    'rel',
    'sex',
    'shop',
    'sklep',
    'sos',
    'szkola',
    'targi',
    'tm',
    'tourism',
    'travel',
    'turystyka',
    'gov',
    'ap.gov',
    'ic.gov',
    'is.gov',
    'us.gov',
    'kmpsp.gov',
    'kppsp.gov',
    'kwpsp.gov',
    'psp.gov',
    'wskr.gov',
    'kwp.gov',
    'mw.gov',
    'ug.gov',
    'um.gov',
    'umig.gov',
    'ugim.gov',
    'upow.gov',
    'uw.gov',
    'starostwo.gov',
    'pa.gov',
    'po.gov',
    'psse.gov',
    'pup.gov',
    'rzgw.gov',
    'sa.gov',
    'so.gov',
    'sr.gov',
    'wsa.gov',
    'sko.gov',
    'uzs.gov',
    'wiih.gov',
    'winb.gov',
    'pinb.gov',
    'wios.gov',
    'witd.gov',
    'wzmiuw.gov',
    'piw.gov',
    'wiw.gov',
    'griw.gov',
    'wif.gov',
    'oum.gov',
    'sdn.gov',
    'zp.gov',
    'uppo.gov',
    'mup.gov',
    'wuoz.gov',
    'konsulat.gov',
    'oirm.gov',
    'augustow',
    'babia-gora',
    'bedzin',
    'beskidy',
    'bialowieza',
    'bialystok',
    'bielawa',
    'bieszczady',
    'boleslawiec',
    'bydgoszcz',
    'bytom',
    'cieszyn',
    'czeladz',
    'czest',
    'dlugoleka',
    'elblag',
    'elk',
    'glogow',
    'gniezno',
    'gorlice',
    'grajewo',
    'ilawa',
    'jaworzno',
    'jelenia-gora',
    'jgora',
    'kalisz',
    'kazimierz-dolny',
    'karpacz',
    'kartuzy',
    'kaszuby',
    'katowice',
    'kepno',
    'ketrzyn',
    'klodzko',
    'kobierzyce',
    'kolobrzeg',
    'konin',
    'konskowola',
    'kutno',
    'lapy',
    'lebork',
    'legnica',
    'lezajsk',
    'limanowa',
    'lomza',
    'lowicz',
    'lubin',
    'lukow',
    'malbork',
    'malopolska',
    'mazowsze',
    'mazury',
    'mielec',
    'mielno',
    'mragowo',
    'naklo',
    'nowaruda',
    'nysa',
    'olawa',
    'olecko',
    'olkusz',
    'olsztyn',
    'opoczno',
    'opole',
    'ostroda',
    'ostroleka',
    'ostrowiec',
    'ostrowwlkp',
    'pila',
    'pisz',
    'podhale',
    'podlasie',
    'polkowice',
    'pomorze',
    'pomorskie',
    'prochowice',
    'pruszkow',
    'przeworsk',
    'pulawy',
    'radom',
    'rawa-maz',
    'rybnik',
    'rzeszow',
    'sanok',
    'sejny',
    'slask',
    'slupsk',
    'sosnowiec',
    'stalowa-wola',
    'skoczow',
    'starachowice',
    'stargard',
    'suwalki',
    'swidnica',
    'swiebodzin',
    'swinoujscie',
    'szczecin',
    'szczytno',
    'tarnobrzeg',
    'tgory',
    'turek',
    'tychy',
    'ustka',
    'walbrzych',
    'warmia',
    'warszawa',
    'waw',
    'wegrow',
    'wielun',
    'wlocl',
    'wloclawek',
    'wodzislaw',
    'wolomin',
    'wroclaw',
    'zachpomor',
    'zagan',
    'zarow',
    'zgora',
    'zgorzelec',
    'beep',
    'co',
    'art',
    'gliwice',
    'krakow',
    'poznan',
    'wroc',
    'zakopane',
    'gda',
    'gdansk',
    'gdynia',
    'med',
    'sopot'
  ],
  'pm': [],
  'pn': ['gov', 'co', 'org', 'edu', 'net', 'gov', 'co', 'org', 'edu', 'net'],
  'pr': [
    'com',
    'net',
    'org',
    'gov',
    'edu',
    'isla',
    'pro',
    'biz',
    'info',
    'name',
    'est',
    'prof',
    'ac',
    'com',
    'net',
    'org',
    'gov',
    'edu',
    'isla',
    'pro',
    'biz',
    'info',
    'name',
    'est',
    'prof',
    'ac'
  ],
  'ps': [
    'edu',
    'gov',
    'sec',
    'plo',
    'com',
    'org',
    'net',
    'edu',
    'gov',
    'sec',
    'plo',
    'com',
    'org',
    'net'
  ],
  'pt': [
    'net',
    'gov',
    'org',
    'edu',
    'int',
    'publ',
    'com',
    'nome',
    'blogspot',
    'net',
    'gov',
    'org',
    'edu',
    'int',
    'publ',
    'com',
    'nome',
    'blogspot'
  ],
  'luxe': [],
  'pw': [
    'co',
    'ne',
    'or',
    'ed',
    'go',
    'belau',
    'cloudns',
    'co',
    'ne',
    'or',
    'ed',
    'go',
    'belau',
    'cloudns'
  ],
  'delta': [],
  'py': [
    'com',
    'coop',
    'edu',
    'gov',
    'mil',
    'net',
    'org',
    'com',
    'coop',
    'edu',
    'gov',
    'mil',
    'net',
    'org'
  ],
  'vlaanderen': [],
  'qa': [
    'com',
    'edu',
    'gov',
    'mil',
    'name',
    'net',
    'org',
    'sch',
    'blogspot',
    'com',
    'edu',
    'gov',
    'mil',
    'name',
    'net',
    'org',
    'sch',
    'blogspot'
  ],
  'lipsy': [],
  'toshiba': [],
  'xn--eckvdtc9d': [],
  'stc': [],
  'rexroth': [],
  'bauhaus': [],
  'xn--clchc0ea0b2g2a9gcd': [],
  'metlife': [],
  'horse': [],
  'seat': [],
  're': ['asso', 'com', 'nom', 'blogspot', 'asso', 'com', 'nom', 'blogspot'],
  'همراه': [],
  'attorney': [],
  'madrid': [],
  'ro': [
    'arts',
    'com',
    'firm',
    'info',
    'nom',
    'nt',
    'org',
    'rec',
    'store',
    'tm',
    'www',
    'shop',
    'blogspot',
    'arts',
    'com',
    'firm',
    'info',
    'nom',
    'nt',
    'org',
    'rec',
    'store',
    'tm',
    'www',
    'shop',
    'blogspot'
  ],
  'gratis': [],
  'rs': [
    'ac',
    'co',
    'edu',
    'gov',
    'in',
    'org',
    'blogspot',
    'ac',
    'co',
    'edu',
    'gov',
    'in',
    'org',
    'blogspot'
  ],
  'ru': [
    'ac',
    'com',
    'edu',
    'int',
    'net',
    'org',
    'pp',
    'adygeya',
    'altai',
    'amur',
    'arkhangelsk',
    'astrakhan',
    'bashkiria',
    'belgorod',
    'bir',
    'bryansk',
    'buryatia',
    'cbg',
    'chel',
    'chelyabinsk',
    'chita',
    'chukotka',
    'chuvashia',
    'dagestan',
    'dudinka',
    'e-burg',
    'grozny',
    'irkutsk',
    'ivanovo',
    'izhevsk',
    'jar',
    'joshkar-ola',
    'kalmykia',
    'kaluga',
    'kamchatka',
    'karelia',
    'kazan',
    'kchr',
    'kemerovo',
    'khabarovsk',
    'khakassia',
    'khv',
    'kirov',
    'koenig',
    'komi',
    'kostroma',
    'krasnoyarsk',
    'kuban',
    'kurgan',
    'kursk',
    'lipetsk',
    'magadan',
    'mari',
    'mari-el',
    'marine',
    'mordovia',
    'msk',
    'murmansk',
    'nalchik',
    'nnov',
    'nov',
    'novosibirsk',
    'nsk',
    'omsk',
    'orenburg',
    'oryol',
    'palana',
    'penza',
    'perm',
    'ptz',
    'rnd',
    'ryazan',
    'sakhalin',
    'samara',
    'saratov',
    'simbirsk',
    'smolensk',
    'spb',
    'stavropol',
    'stv',
    'surgut',
    'tambov',
    'tatarstan',
    'tom',
    'tomsk',
    'tsaritsyn',
    'tsk',
    'tula',
    'tuva',
    'tver',
    'tyumen',
    'udm',
    'udmurtia',
    'ulan-ude',
    'vladikavkaz',
    'vladimir',
    'vladivostok',
    'vologda',
    'voronezh',
    'vrn',
    'vyatka',
    'yakutia',
    'yamal',
    'yaroslavl',
    'yekaterinburg',
    'yuzhno-sakhalinsk',
    'amursk',
    'baikal',
    'cmw',
    'fareast',
    'jamal',
    'kms',
    'k-uralsk',
    'kustanai',
    'kuzbass',
    'mytis',
    'nakhodka',
    'nkz',
    'norilsk',
    'oskol',
    'pyatigorsk',
    'rubtsovsk',
    'snz',
    'syzran',
    'vdonsk',
    'zgrad',
    'gov',
    'mil',
    'test',
    'blogspot',
    'ac',
    'com',
    'edu',
    'int',
    'net',
    'org',
    'pp',
    'adygeya',
    'altai',
    'amur',
    'arkhangelsk',
    'astrakhan',
    'bashkiria',
    'belgorod',
    'bir',
    'bryansk',
    'buryatia',
    'cbg',
    'chel',
    'chelyabinsk',
    'chita',
    'chukotka',
    'chuvashia',
    'dagestan',
    'dudinka',
    'e-burg',
    'grozny',
    'irkutsk',
    'ivanovo',
    'izhevsk',
    'jar',
    'joshkar-ola',
    'kalmykia',
    'kaluga',
    'kamchatka',
    'karelia',
    'kazan',
    'kchr',
    'kemerovo',
    'khabarovsk',
    'khakassia',
    'khv',
    'kirov',
    'koenig',
    'komi',
    'kostroma',
    'krasnoyarsk',
    'kuban',
    'kurgan',
    'kursk',
    'lipetsk',
    'magadan',
    'mari',
    'mari-el',
    'marine',
    'mordovia',
    'msk',
    'murmansk',
    'nalchik',
    'nnov',
    'nov',
    'novosibirsk',
    'nsk',
    'omsk',
    'orenburg',
    'oryol',
    'palana',
    'penza',
    'perm',
    'ptz',
    'rnd',
    'ryazan',
    'sakhalin',
    'samara',
    'saratov',
    'simbirsk',
    'smolensk',
    'spb',
    'stavropol',
    'stv',
    'surgut',
    'tambov',
    'tatarstan',
    'tom',
    'tomsk',
    'tsaritsyn',
    'tsk',
    'tula',
    'tuva',
    'tver',
    'tyumen',
    'udm',
    'udmurtia',
    'ulan-ude',
    'vladikavkaz',
    'vladimir',
    'vladivostok',
    'vologda',
    'voronezh',
    'vrn',
    'vyatka',
    'yakutia',
    'yamal',
    'yaroslavl',
    'yekaterinburg',
    'yuzhno-sakhalinsk',
    'amursk',
    'baikal',
    'cmw',
    'fareast',
    'jamal',
    'kms',
    'k-uralsk',
    'kustanai',
    'kuzbass',
    'mytis',
    'nakhodka',
    'nkz',
    'norilsk',
    'oskol',
    'pyatigorsk',
    'rubtsovsk',
    'snz',
    'syzran',
    'vdonsk',
    'zgrad',
    'gov',
    'mil',
    'test',
    'blogspot'
  ],
  '手机': [],
  'rw': [
    'gov',
    'net',
    'edu',
    'ac',
    'com',
    'co',
    'int',
    'mil',
    'gouv',
    'gov',
    'net',
    'edu',
    'ac',
    'com',
    'co',
    'int',
    'mil',
    'gouv'
  ],
  'yoga': [],
  'みんな': [],
  'netflix': [],
  'seek': [],
  'sa': [
    'com',
    'net',
    'org',
    'gov',
    'med',
    'pub',
    'edu',
    'sch',
    'com',
    'net',
    'org',
    'gov',
    'med',
    'pub',
    'edu',
    'sch'
  ],
  'sb': ['com', 'edu', 'gov', 'net', 'org', 'com', 'edu', 'gov', 'net', 'org'],
  'sc': ['com', 'gov', 'net', 'org', 'edu', 'com', 'gov', 'net', 'org', 'edu'],
  'sd': [
    'com',
    'net',
    'org',
    'edu',
    'med',
    'tv',
    'gov',
    'info',
    'com',
    'net',
    'org',
    'edu',
    'med',
    'tv',
    'gov',
    'info'
  ],
  'se': [
    'a',
    'ac',
    'b',
    'bd',
    'brand',
    'c',
    'd',
    'e',
    'f',
    'fh',
    'fhsk',
    'fhv',
    'g',
    'h',
    'i',
    'k',
    'komforb',
    'kommunalforbund',
    'komvux',
    'l',
    'lanbib',
    'm',
    'n',
    'naturbruksgymn',
    'o',
    'org',
    'p',
    'parti',
    'pp',
    'press',
    'r',
    's',
    't',
    'tm',
    'u',
    'w',
    'x',
    'y',
    'z',
    'com',
    'blogspot',
    'a',
    'ac',
    'b',
    'bd',
    'brand',
    'c',
    'd',
    'e',
    'f',
    'fh',
    'fhsk',
    'fhv',
    'g',
    'h',
    'i',
    'k',
    'komforb',
    'kommunalforbund',
    'komvux',
    'l',
    'lanbib',
    'm',
    'n',
    'naturbruksgymn',
    'o',
    'org',
    'p',
    'parti',
    'pp',
    'press',
    'r',
    's',
    't',
    'tm',
    'u',
    'w',
    'x',
    'y',
    'z',
    'com',
    'blogspot'
  ],
  'democrat': [],
  'sg': [
    'com',
    'net',
    'org',
    'gov',
    'edu',
    'per',
    'blogspot',
    'com',
    'net',
    'org',
    'gov',
    'edu',
    'per',
    'blogspot'
  ],
  'sh': [
    'com',
    'net',
    'gov',
    'org',
    'mil',
    '*.platform',
    'hashbang',
    'now',
    'com',
    'net',
    'gov',
    'org',
    'mil',
    '*.platform',
    'hashbang',
    'now'
  ],
  'si': ['blogspot', 'blogspot'],
  'sj': [],
  'sk': ['blogspot', 'blogspot'],
  'sl': ['com', 'net', 'edu', 'gov', 'org', 'com', 'net', 'edu', 'gov', 'org'],
  'george': [],
  'origins': [],
  'sm': [],
  'lamer': [],
  'sn': [
    'art',
    'com',
    'edu',
    'gouv',
    'org',
    'perso',
    'univ',
    'blogspot',
    'art',
    'com',
    'edu',
    'gouv',
    'org',
    'perso',
    'univ',
    'blogspot'
  ],
  'audio': [],
  'so': ['com', 'net', 'org', 'com', 'net', 'org'],
  'email': [],
  'sr': [],
  'silk': [],
  'st': [
    'co',
    'com',
    'consulado',
    'edu',
    'embaixada',
    'gov',
    'mil',
    'net',
    'org',
    'principe',
    'saotome',
    'store',
    'co',
    'com',
    'consulado',
    'edu',
    'embaixada',
    'gov',
    'mil',
    'net',
    'org',
    'principe',
    'saotome',
    'store'
  ],
  'realestate': [],
  'su': [
    'adygeya',
    'arkhangelsk',
    'balashov',
    'bashkiria',
    'bryansk',
    'dagestan',
    'grozny',
    'ivanovo',
    'kalmykia',
    'kaluga',
    'karelia',
    'khakassia',
    'krasnodar',
    'kurgan',
    'lenug',
    'mordovia',
    'msk',
    'murmansk',
    'nalchik',
    'nov',
    'obninsk',
    'penza',
    'pokrovsk',
    'sochi',
    'spb',
    'togliatti',
    'troitsk',
    'tula',
    'tuva',
    'vladikavkaz',
    'vladimir',
    'vologda',
    'adygeya',
    'arkhangelsk',
    'balashov',
    'bashkiria',
    'bryansk',
    'dagestan',
    'grozny',
    'ivanovo',
    'kalmykia',
    'kaluga',
    'karelia',
    'khakassia',
    'krasnodar',
    'kurgan',
    'lenug',
    'mordovia',
    'msk',
    'murmansk',
    'nalchik',
    'nov',
    'obninsk',
    'penza',
    'pokrovsk',
    'sochi',
    'spb',
    'togliatti',
    'troitsk',
    'tula',
    'tuva',
    'vladikavkaz',
    'vladimir',
    'vologda'
  ],
  'sv': ['com', 'edu', 'gob', 'org', 'red', 'com', 'edu', 'gob', 'org', 'red'],
  'sx': ['gov', 'gov'],
  'sy': [
    'edu',
    'gov',
    'net',
    'mil',
    'com',
    'org',
    'edu',
    'gov',
    'net',
    'mil',
    'com',
    'org'
  ],
  'sz': ['co', 'ac', 'org', 'co', 'ac', 'org'],
  'one': ['homelink', 'homelink'],
  'ong': [],
  'store': [],
  'xn--bck1b9a5dre4c': [],
  'kfh': [],
  'onl': [],
  'weatherchannel': [],
  'tc': [],
  'monster': [],
  'td': ['blogspot', 'blogspot'],
  'tf': [],
  'tg': [],
  'th': [
    'ac',
    'co',
    'go',
    'in',
    'mi',
    'net',
    'or',
    'ac',
    'co',
    'go',
    'in',
    'mi',
    'net',
    'or'
  ],
  'tj': [
    'ac',
    'biz',
    'co',
    'com',
    'edu',
    'go',
    'gov',
    'int',
    'mil',
    'name',
    'net',
    'nic',
    'org',
    'test',
    'web',
    'ac',
    'biz',
    'co',
    'com',
    'edu',
    'go',
    'gov',
    'int',
    'mil',
    'name',
    'net',
    'nic',
    'org',
    'test',
    'web'
  ],
  'cricket': [],
  'tk': [],
  '中國': [],
  'tl': ['gov', 'gov'],
  'dealer': [],
  'tm': [
    'com',
    'co',
    'org',
    'net',
    'nom',
    'gov',
    'mil',
    'edu',
    'com',
    'co',
    'org',
    'net',
    'nom',
    'gov',
    'mil',
    'edu'
  ],
  '中国': [],
  'tn': [
    'com',
    'ens',
    'fin',
    'gov',
    'ind',
    'intl',
    'nat',
    'net',
    'org',
    'info',
    'perso',
    'tourism',
    'edunet',
    'rnrt',
    'rns',
    'rnu',
    'mincom',
    'agrinet',
    'defense',
    'turen',
    'com',
    'ens',
    'fin',
    'gov',
    'ind',
    'intl',
    'nat',
    'net',
    'org',
    'info',
    'perso',
    'tourism',
    'edunet',
    'rnrt',
    'rns',
    'rnu',
    'mincom',
    'agrinet',
    'defense',
    'turen'
  ],
  'to': [
    'com',
    'gov',
    'net',
    'org',
    'edu',
    'mil',
    'com',
    'gov',
    'net',
    'org',
    'edu',
    'mil'
  ],
  'xn--mgba3a3ejt': [],
  'tr': [
    'com',
    'info',
    'biz',
    'net',
    'org',
    'web',
    'gen',
    'tv',
    'av',
    'dr',
    'bbs',
    'name',
    'tel',
    'gov',
    'bel',
    'pol',
    'mil',
    'k12',
    'edu',
    'kep',
    'nc',
    'gov.nc',
    'blogspot.com',
    'com',
    'info',
    'biz',
    'net',
    'org',
    'web',
    'gen',
    'tv',
    'av',
    'dr',
    'bbs',
    'name',
    'tel',
    'gov',
    'bel',
    'pol',
    'mil',
    'k12',
    'edu',
    'kep',
    'nc',
    'gov.nc',
    'blogspot.com'
  ],
  'lilly': [],
  'tt': [
    'co',
    'com',
    'org',
    'net',
    'biz',
    'info',
    'pro',
    'int',
    'coop',
    'jobs',
    'mobi',
    'travel',
    'museum',
    'aero',
    'name',
    'gov',
    'edu',
    'co',
    'com',
    'org',
    'net',
    'biz',
    'info',
    'pro',
    'int',
    'coop',
    'jobs',
    'mobi',
    'travel',
    'museum',
    'aero',
    'name',
    'gov',
    'edu'
  ],
  'makeup': [],
  'country': [],
  'tv': [
    'dyndns',
    'better-than',
    'on-the-web',
    'worse-than',
    'dyndns',
    'better-than',
    'on-the-web',
    'worse-than'
  ],
  'builders': [],
  'kerryproperties': [],
  'tkmaxx': [],
  'tw': [
    'edu',
    'gov',
    'mil',
    'com',
    'net',
    'org',
    'idv',
    'game',
    'ebiz',
    'club',
    'xn--zf0ao64a',
    'xn--uc0atv',
    'xn--czrw28b',
    'blogspot',
    'edu',
    'gov',
    'mil',
    'com',
    'net',
    'org',
    'idv',
    'game',
    'ebiz',
    'club',
    '網路',
    '組織',
    '商業',
    'blogspot'
  ],
  'tz': [
    'ac',
    'co',
    'go',
    'hotel',
    'info',
    'me',
    'mil',
    'mobi',
    'ne',
    'or',
    'sc',
    'tv',
    'ac',
    'co',
    'go',
    'hotel',
    'info',
    'me',
    'mil',
    'mobi',
    'ne',
    'or',
    'sc',
    'tv'
  ],
  'buy': [],
  'express': [],
  'ua': [
    'com',
    'edu',
    'gov',
    'in',
    'net',
    'org',
    'cherkassy',
    'cherkasy',
    'chernigov',
    'chernihiv',
    'chernivtsi',
    'chernovtsy',
    'ck',
    'cn',
    'cr',
    'crimea',
    'cv',
    'dn',
    'dnepropetrovsk',
    'dnipropetrovsk',
    'dominic',
    'donetsk',
    'dp',
    'if',
    'ivano-frankivsk',
    'kh',
    'kharkiv',
    'kharkov',
    'kherson',
    'khmelnitskiy',
    'khmelnytskyi',
    'kiev',
    'kirovograd',
    'km',
    'kr',
    'krym',
    'ks',
    'kv',
    'kyiv',
    'lg',
    'lt',
    'lugansk',
    'lutsk',
    'lv',
    'lviv',
    'mk',
    'mykolaiv',
    'nikolaev',
    'od',
    'odesa',
    'odessa',
    'pl',
    'poltava',
    'rivne',
    'rovno',
    'rv',
    'sb',
    'sebastopol',
    'sevastopol',
    'sm',
    'sumy',
    'te',
    'ternopil',
    'uz',
    'uzhgorod',
    'vinnica',
    'vinnytsia',
    'vn',
    'volyn',
    'yalta',
    'zaporizhzhe',
    'zaporizhzhia',
    'zhitomir',
    'zhytomyr',
    'zp',
    'zt',
    'biz',
    'co',
    'pp',
    'com',
    'edu',
    'gov',
    'in',
    'net',
    'org',
    'cherkassy',
    'cherkasy',
    'chernigov',
    'chernihiv',
    'chernivtsi',
    'chernovtsy',
    'ck',
    'cn',
    'cr',
    'crimea',
    'cv',
    'dn',
    'dnepropetrovsk',
    'dnipropetrovsk',
    'dominic',
    'donetsk',
    'dp',
    'if',
    'ivano-frankivsk',
    'kh',
    'kharkiv',
    'kharkov',
    'kherson',
    'khmelnitskiy',
    'khmelnytskyi',
    'kiev',
    'kirovograd',
    'km',
    'kr',
    'krym',
    'ks',
    'kv',
    'kyiv',
    'lg',
    'lt',
    'lugansk',
    'lutsk',
    'lv',
    'lviv',
    'mk',
    'mykolaiv',
    'nikolaev',
    'od',
    'odesa',
    'odessa',
    'pl',
    'poltava',
    'rivne',
    'rovno',
    'rv',
    'sb',
    'sebastopol',
    'sevastopol',
    'sm',
    'sumy',
    'te',
    'ternopil',
    'uz',
    'uzhgorod',
    'vinnica',
    'vinnytsia',
    'vn',
    'volyn',
    'yalta',
    'zaporizhzhe',
    'zaporizhzhia',
    'zhitomir',
    'zhytomyr',
    'zp',
    'zt',
    'biz',
    'co',
    'pp'
  ],
  'quest': [],
  'ooo': [],
  'xn--mgberp4a5d4a87g': [],
  'zero': [],
  'ug': [
    'co',
    'or',
    'ac',
    'sc',
    'go',
    'ne',
    'com',
    'org',
    'blogspot',
    'co',
    'or',
    'ac',
    'sc',
    'go',
    'ne',
    'com',
    'org',
    'blogspot'
  ],
  'uk': [
    'ac',
    'co',
    'gov',
    'ltd',
    'me',
    'net',
    'nhs',
    'org',
    'plc',
    'police',
    '*.sch',
    'service.gov',
    'blogspot.co',
    'no-ip.co',
    'wellbeingzone.co',
    'ac',
    'co',
    'gov',
    'ltd',
    'me',
    'net',
    'nhs',
    'org',
    'plc',
    'police',
    '*.sch',
    'service.gov',
    'blogspot.co',
    'no-ip.co',
    'wellbeingzone.co'
  ],
  'yahoo': [],
  'سودان': [],
  'scholarships': [],
  'us': [
    'dni',
    'fed',
    'isa',
    'kids',
    'nsn',
    'ak',
    'al',
    'ar',
    'as',
    'az',
    'ca',
    'co',
    'ct',
    'dc',
    'de',
    'fl',
    'ga',
    'gu',
    'hi',
    'ia',
    'id',
    'il',
    'in',
    'ks',
    'ky',
    'la',
    'ma',
    'md',
    'me',
    'mi',
    'mn',
    'mo',
    'ms',
    'mt',
    'nc',
    'nd',
    'ne',
    'nh',
    'nj',
    'nm',
    'nv',
    'ny',
    'oh',
    'ok',
    'or',
    'pa',
    'pr',
    'ri',
    'sc',
    'sd',
    'tn',
    'tx',
    'ut',
    'vi',
    'vt',
    'va',
    'wa',
    'wi',
    'wv',
    'wy',
    'k12.ak',
    'k12.al',
    'k12.ar',
    'k12.as',
    'k12.az',
    'k12.ca',
    'k12.co',
    'k12.ct',
    'k12.dc',
    'k12.de',
    'k12.fl',
    'k12.ga',
    'k12.gu',
    'k12.ia',
    'k12.id',
    'k12.il',
    'k12.in',
    'k12.ks',
    'k12.ky',
    'k12.la',
    'k12.ma',
    'k12.md',
    'k12.me',
    'k12.mi',
    'k12.mn',
    'k12.mo',
    'k12.ms',
    'k12.mt',
    'k12.nc',
    'k12.ne',
    'k12.nh',
    'k12.nj',
    'k12.nm',
    'k12.nv',
    'k12.ny',
    'k12.oh',
    'k12.ok',
    'k12.or',
    'k12.pa',
    'k12.pr',
    'k12.ri',
    'k12.sc',
    'k12.tn',
    'k12.tx',
    'k12.ut',
    'k12.vi',
    'k12.vt',
    'k12.va',
    'k12.wa',
    'k12.wi',
    'k12.wy',
    'cc.ak',
    'cc.al',
    'cc.ar',
    'cc.as',
    'cc.az',
    'cc.ca',
    'cc.co',
    'cc.ct',
    'cc.dc',
    'cc.de',
    'cc.fl',
    'cc.ga',
    'cc.gu',
    'cc.hi',
    'cc.ia',
    'cc.id',
    'cc.il',
    'cc.in',
    'cc.ks',
    'cc.ky',
    'cc.la',
    'cc.ma',
    'cc.md',
    'cc.me',
    'cc.mi',
    'cc.mn',
    'cc.mo',
    'cc.ms',
    'cc.mt',
    'cc.nc',
    'cc.nd',
    'cc.ne',
    'cc.nh',
    'cc.nj',
    'cc.nm',
    'cc.nv',
    'cc.ny',
    'cc.oh',
    'cc.ok',
    'cc.or',
    'cc.pa',
    'cc.pr',
    'cc.ri',
    'cc.sc',
    'cc.sd',
    'cc.tn',
    'cc.tx',
    'cc.ut',
    'cc.vi',
    'cc.vt',
    'cc.va',
    'cc.wa',
    'cc.wi',
    'cc.wv',
    'cc.wy',
    'lib.ak',
    'lib.al',
    'lib.ar',
    'lib.as',
    'lib.az',
    'lib.ca',
    'lib.co',
    'lib.ct',
    'lib.dc',
    'lib.fl',
    'lib.ga',
    'lib.gu',
    'lib.hi',
    'lib.ia',
    'lib.id',
    'lib.il',
    'lib.in',
    'lib.ks',
    'lib.ky',
    'lib.la',
    'lib.ma',
    'lib.md',
    'lib.me',
    'lib.mi',
    'lib.mn',
    'lib.mo',
    'lib.ms',
    'lib.mt',
    'lib.nc',
    'lib.nd',
    'lib.ne',
    'lib.nh',
    'lib.nj',
    'lib.nm',
    'lib.nv',
    'lib.ny',
    'lib.oh',
    'lib.ok',
    'lib.or',
    'lib.pa',
    'lib.pr',
    'lib.ri',
    'lib.sc',
    'lib.sd',
    'lib.tn',
    'lib.tx',
    'lib.ut',
    'lib.vi',
    'lib.vt',
    'lib.va',
    'lib.wa',
    'lib.wi',
    'lib.wy',
    'pvt.k12.ma',
    'chtr.k12.ma',
    'paroch.k12.ma',
    'cloudns',
    'drud',
    'is-by',
    'land-4-sale',
    'stuff-4-sale',
    'golffan',
    'noip',
    'pointto',
    'lib.de',
    'dni',
    'fed',
    'isa',
    'kids',
    'nsn',
    'ak',
    'al',
    'ar',
    'as',
    'az',
    'ca',
    'co',
    'ct',
    'dc',
    'de',
    'fl',
    'ga',
    'gu',
    'hi',
    'ia',
    'id',
    'il',
    'in',
    'ks',
    'ky',
    'la',
    'ma',
    'md',
    'me',
    'mi',
    'mn',
    'mo',
    'ms',
    'mt',
    'nc',
    'nd',
    'ne',
    'nh',
    'nj',
    'nm',
    'nv',
    'ny',
    'oh',
    'ok',
    'or',
    'pa',
    'pr',
    'ri',
    'sc',
    'sd',
    'tn',
    'tx',
    'ut',
    'vi',
    'vt',
    'va',
    'wa',
    'wi',
    'wv',
    'wy',
    'k12.ak',
    'k12.al',
    'k12.ar',
    'k12.as',
    'k12.az',
    'k12.ca',
    'k12.co',
    'k12.ct',
    'k12.dc',
    'k12.de',
    'k12.fl',
    'k12.ga',
    'k12.gu',
    'k12.ia',
    'k12.id',
    'k12.il',
    'k12.in',
    'k12.ks',
    'k12.ky',
    'k12.la',
    'k12.ma',
    'k12.md',
    'k12.me',
    'k12.mi',
    'k12.mn',
    'k12.mo',
    'k12.ms',
    'k12.mt',
    'k12.nc',
    'k12.ne',
    'k12.nh',
    'k12.nj',
    'k12.nm',
    'k12.nv',
    'k12.ny',
    'k12.oh',
    'k12.ok',
    'k12.or',
    'k12.pa',
    'k12.pr',
    'k12.ri',
    'k12.sc',
    'k12.tn',
    'k12.tx',
    'k12.ut',
    'k12.vi',
    'k12.vt',
    'k12.va',
    'k12.wa',
    'k12.wi',
    'k12.wy',
    'cc.ak',
    'cc.al',
    'cc.ar',
    'cc.as',
    'cc.az',
    'cc.ca',
    'cc.co',
    'cc.ct',
    'cc.dc',
    'cc.de',
    'cc.fl',
    'cc.ga',
    'cc.gu',
    'cc.hi',
    'cc.ia',
    'cc.id',
    'cc.il',
    'cc.in',
    'cc.ks',
    'cc.ky',
    'cc.la',
    'cc.ma',
    'cc.md',
    'cc.me',
    'cc.mi',
    'cc.mn',
    'cc.mo',
    'cc.ms',
    'cc.mt',
    'cc.nc',
    'cc.nd',
    'cc.ne',
    'cc.nh',
    'cc.nj',
    'cc.nm',
    'cc.nv',
    'cc.ny',
    'cc.oh',
    'cc.ok',
    'cc.or',
    'cc.pa',
    'cc.pr',
    'cc.ri',
    'cc.sc',
    'cc.sd',
    'cc.tn',
    'cc.tx',
    'cc.ut',
    'cc.vi',
    'cc.vt',
    'cc.va',
    'cc.wa',
    'cc.wi',
    'cc.wv',
    'cc.wy',
    'lib.ak',
    'lib.al',
    'lib.ar',
    'lib.as',
    'lib.az',
    'lib.ca',
    'lib.co',
    'lib.ct',
    'lib.dc',
    'lib.fl',
    'lib.ga',
    'lib.gu',
    'lib.hi',
    'lib.ia',
    'lib.id',
    'lib.il',
    'lib.in',
    'lib.ks',
    'lib.ky',
    'lib.la',
    'lib.ma',
    'lib.md',
    'lib.me',
    'lib.mi',
    'lib.mn',
    'lib.mo',
    'lib.ms',
    'lib.mt',
    'lib.nc',
    'lib.nd',
    'lib.ne',
    'lib.nh',
    'lib.nj',
    'lib.nm',
    'lib.nv',
    'lib.ny',
    'lib.oh',
    'lib.ok',
    'lib.or',
    'lib.pa',
    'lib.pr',
    'lib.ri',
    'lib.sc',
    'lib.sd',
    'lib.tn',
    'lib.tx',
    'lib.ut',
    'lib.vi',
    'lib.vt',
    'lib.va',
    'lib.wa',
    'lib.wi',
    'lib.wy',
    'pvt.k12.ma',
    'chtr.k12.ma',
    'paroch.k12.ma',
    'cloudns',
    'drud',
    'is-by',
    'land-4-sale',
    'stuff-4-sale',
    'golffan',
    'noip',
    'pointto',
    'lib.de'
  ],
  'athleta': [],
  'oracle': [],
  'uy': [
    'com',
    'edu',
    'gub',
    'mil',
    'net',
    'org',
    'blogspot.com',
    'com',
    'edu',
    'gub',
    'mil',
    'net',
    'org',
    'blogspot.com'
  ],
  'uz': ['co', 'com', 'net', 'org', 'co', 'com', 'net', 'org'],
  'clubmed': [],
  'istanbul': [],
  'xn--w4r85el8fhu5dnra': [],
  'xn--mgbbh1a71e': [],
  'degree': [],
  'va': [],
  'vc': [
    'com',
    'net',
    'org',
    'gov',
    'mil',
    'edu',
    'com',
    'net',
    'org',
    'gov',
    'mil',
    'edu'
  ],
  've': [
    'arts',
    'co',
    'com',
    'e12',
    'edu',
    'firm',
    'gob',
    'gov',
    'info',
    'int',
    'mil',
    'net',
    'org',
    'rec',
    'store',
    'tec',
    'web',
    'arts',
    'co',
    'com',
    'e12',
    'edu',
    'firm',
    'gob',
    'gov',
    'info',
    'int',
    'mil',
    'net',
    'org',
    'rec',
    'store',
    'tec',
    'web'
  ],
  'vg': [],
  'tube': [],
  'vi': ['co', 'com', 'k12', 'net', 'org', 'co', 'com', 'k12', 'net', 'org'],
  '大拿': [],
  'vn': [
    'com',
    'net',
    'org',
    'edu',
    'gov',
    'int',
    'ac',
    'biz',
    'info',
    'name',
    'pro',
    'health',
    'blogspot',
    'com',
    'net',
    'org',
    'edu',
    'gov',
    'int',
    'ac',
    'biz',
    'info',
    'name',
    'pro',
    'health',
    'blogspot'
  ],
  'desi': [],
  'gallup': [],
  'sina': [],
  'support': [],
  'vu': ['com', 'edu', 'net', 'org', 'com', 'edu', 'net', 'org'],
  'kia': [],
  'swatch': [],
  'verisign': [],
  'iselect': [],
  'xn--fhbei': [],
  'wien': [],
  'xn--ses554g': [],
  'samsclub': [],
  'kim': [],
  'life': [],
  'wf': [],
  'gal': [],
  'gap': [],
  'ws': [
    'com',
    'net',
    'org',
    'gov',
    'edu',
    'dyndns',
    'mypets',
    'com',
    'net',
    'org',
    'gov',
    'edu',
    'dyndns',
    'mypets'
  ],
  'org': [
    'tele.amune',
    'pimienta',
    'poivron',
    'potager',
    'sweetpepper',
    'ae',
    'us',
    'certmgr',
    'c.cdn77',
    'rsc.cdn77',
    'ssl.origin.cdn77-secure',
    'cloudns',
    'duckdns',
    'tunk',
    'dyndns',
    'blogdns',
    'blogsite',
    'boldlygoingnowhere',
    'dnsalias',
    'dnsdojo',
    'doesntexist',
    'dontexist',
    'doomdns',
    'dvrdns',
    'dynalias',
    'endofinternet',
    'endoftheinternet',
    'from-me',
    'game-host',
    'go.dyndns',
    'gotdns',
    'hobby-site',
    'home.dyndns',
    'homedns',
    'homeftp',
    'homelinux',
    'homeunix',
    'is-a-bruinsfan',
    'is-a-candidate',
    'is-a-celticsfan',
    'is-a-chef',
    'is-a-geek',
    'is-a-knight',
    'is-a-linux-user',
    'is-a-patsfan',
    'is-a-soxfan',
    'is-found',
    'is-lost',
    'is-saved',
    'is-very-bad',
    'is-very-evil',
    'is-very-good',
    'is-very-nice',
    'is-very-sweet',
    'isa-geek',
    'kicks-ass',
    'misconfused',
    'podzone',
    'readmyblog',
    'selfip',
    'sellsyourhome',
    'servebbs',
    'serveftp',
    'servegame',
    'stuff-4-sale',
    'webhop',
    'ddnss',
    'eu',
    'al.eu',
    'asso.eu',
    'at.eu',
    'au.eu',
    'be.eu',
    'bg.eu',
    'ca.eu',
    'cd.eu',
    'ch.eu',
    'cn.eu',
    'cy.eu',
    'cz.eu',
    'de.eu',
    'dk.eu',
    'edu.eu',
    'ee.eu',
    'es.eu',
    'fi.eu',
    'fr.eu',
    'gr.eu',
    'hr.eu',
    'hu.eu',
    'ie.eu',
    'il.eu',
    'in.eu',
    'int.eu',
    'is.eu',
    'it.eu',
    'jp.eu',
    'kr.eu',
    'lt.eu',
    'lu.eu',
    'lv.eu',
    'mc.eu',
    'me.eu',
    'mk.eu',
    'mt.eu',
    'my.eu',
    'net.eu',
    'ng.eu',
    'nl.eu',
    'no.eu',
    'nz.eu',
    'paris.eu',
    'pl.eu',
    'pt.eu',
    'q-a.eu',
    'ro.eu',
    'ru.eu',
    'se.eu',
    'si.eu',
    'sk.eu',
    'tr.eu',
    'uk.eu',
    'us.eu',
    'hepforge',
    'js',
    'bmoattachments',
    'cable-modem',
    'collegefan',
    'couchpotatofries',
    'mlbfan',
    'mysecuritycamera',
    'nflfan',
    'read-books',
    'ufcfan',
    'hopto',
    'myftp',
    'no-ip',
    'zapto',
    'my-firewall',
    'myfirewall',
    'spdns',
    'dsmynas',
    'familyds',
    'tuxfamily',
    'diskstation',
    'hk',
    'wmflabs',
    'za',
    'tele.amune',
    'pimienta',
    'poivron',
    'potager',
    'sweetpepper',
    'ae',
    'us',
    'certmgr',
    'c.cdn77',
    'rsc.cdn77',
    'ssl.origin.cdn77-secure',
    'cloudns',
    'duckdns',
    'tunk',
    'dyndns',
    'blogdns',
    'blogsite',
    'boldlygoingnowhere',
    'dnsalias',
    'dnsdojo',
    'doesntexist',
    'dontexist',
    'doomdns',
    'dvrdns',
    'dynalias',
    'endofinternet',
    'endoftheinternet',
    'from-me',
    'game-host',
    'go.dyndns',
    'gotdns',
    'hobby-site',
    'home.dyndns',
    'homedns',
    'homeftp',
    'homelinux',
    'homeunix',
    'is-a-bruinsfan',
    'is-a-candidate',
    'is-a-celticsfan',
    'is-a-chef',
    'is-a-geek',
    'is-a-knight',
    'is-a-linux-user',
    'is-a-patsfan',
    'is-a-soxfan',
    'is-found',
    'is-lost',
    'is-saved',
    'is-very-bad',
    'is-very-evil',
    'is-very-good',
    'is-very-nice',
    'is-very-sweet',
    'isa-geek',
    'kicks-ass',
    'misconfused',
    'podzone',
    'readmyblog',
    'selfip',
    'sellsyourhome',
    'servebbs',
    'serveftp',
    'servegame',
    'stuff-4-sale',
    'webhop',
    'ddnss',
    'eu',
    'al.eu',
    'asso.eu',
    'at.eu',
    'au.eu',
    'be.eu',
    'bg.eu',
    'ca.eu',
    'cd.eu',
    'ch.eu',
    'cn.eu',
    'cy.eu',
    'cz.eu',
    'de.eu',
    'dk.eu',
    'edu.eu',
    'ee.eu',
    'es.eu',
    'fi.eu',
    'fr.eu',
    'gr.eu',
    'hr.eu',
    'hu.eu',
    'ie.eu',
    'il.eu',
    'in.eu',
    'int.eu',
    'is.eu',
    'it.eu',
    'jp.eu',
    'kr.eu',
    'lt.eu',
    'lu.eu',
    'lv.eu',
    'mc.eu',
    'me.eu',
    'mk.eu',
    'mt.eu',
    'my.eu',
    'net.eu',
    'ng.eu',
    'nl.eu',
    'no.eu',
    'nz.eu',
    'paris.eu',
    'pl.eu',
    'pt.eu',
    'q-a.eu',
    'ro.eu',
    'ru.eu',
    'se.eu',
    'si.eu',
    'sk.eu',
    'tr.eu',
    'uk.eu',
    'us.eu',
    'hepforge',
    'js',
    'bmoattachments',
    'cable-modem',
    'collegefan',
    'couchpotatofries',
    'mlbfan',
    'mysecuritycamera',
    'nflfan',
    'read-books',
    'ufcfan',
    'hopto',
    'myftp',
    'no-ip',
    'zapto',
    'my-firewall',
    'myfirewall',
    'spdns',
    'dsmynas',
    'familyds',
    'tuxfamily',
    'diskstation',
    'hk',
    'wmflabs',
    'za'
  ],
  'honda': [],
  'technology': [],
  'forex': [],
  'bentley': [],
  'lidl': [],
  'cbre': [],
  'software': [],
  'ye': ['*', '*'],
  'feedback': [],
  'bzh': [],
  'review': ['ybo', 'ybo'],
  'weather': [],
  'yt': [],
  'reise': [],
  'guide': [],
  'nagoya': [],
  'boehringer': [],
  'za': [
    'ac',
    'agric',
    'alt',
    'co',
    'edu',
    'gov',
    'grondar',
    'law',
    'mil',
    'net',
    'ngo',
    'nis',
    'nom',
    'org',
    'school',
    'tm',
    'web',
    'blogspot.co',
    'ac',
    'agric',
    'alt',
    'co',
    'edu',
    'gov',
    'grondar',
    'law',
    'mil',
    'net',
    'ngo',
    'nis',
    'nom',
    'org',
    'school',
    'tm',
    'web',
    'blogspot.co'
  ],
  'xn--o3cw4h': [],
  'ott': [],
  'xn--80adxhks': [],
  'gdn': [],
  '企业': [],
  'zm': [
    'ac',
    'biz',
    'co',
    'com',
    'edu',
    'gov',
    'info',
    'mil',
    'net',
    'org',
    'sch',
    'ac',
    'biz',
    'co',
    'com',
    'edu',
    'gov',
    'info',
    'mil',
    'net',
    'org',
    'sch'
  ],
  'fedex': [],
  'nationwide': [],
  'zw': ['*', '*'],
  'aigo': [],
  'gmail': [],
  'newholland': [],
  'gea': [],
  'racing': [],
  'zuerich': [],
  'pictet': [],
  'tools': [],
  'promo': [],
  'amica': [],
  'shouji': [],
  '八卦': [],
  'グーグル': [],
  'place': [],
  'archi': [],
  'ovh': ['nerdpol', 'nerdpol'],
  'coop': [],
  'datsun': [],
  'cool': [],
  'help': [],
  '手表': [],
  'site': ['cyon', 'cyon'],
  '广东': [],
  'gbiz': [],
  'date': [],
  'xn--unup4y': [],
  'data': [],
  'wiki': [],
  'lamborghini': [],
  'blog': [],
  'tab': [],
  'cologne': [],
  'xin': [],
  'joburg': [],
  'like': [],
  'loans': [],
  'kpn': [],
  'tax': [],
  'brussels': [],
  'olayangroup': [],
  'zara': [],
  'travelchannel': [],
  'safe': [],
  'sandvikcoromant': [],
  'مصر': [],
  'here': [],
  'youtube': [],
  'cab': [],
  'link': ['cyon', 'mypep', 'cyon', 'mypep'],
  'lanxess': [],
  'sncf': [],
  'cam': [],
  'cal': [],
  'capetown': [],
  'kinder': [],
  'hair': [],
  'security': [],
  'paris': [],
  'car': [],
  'cat': [],
  'immobilien': [],
  'tci': [],
  'krd': ['co', 'edu', 'co', 'edu'],
  '通販': [],
  'cleaning': [],
  'ipiranga': [],
  'срб': ['пр', 'орг', 'обр', 'од', 'упр', 'ак'],
  'cba': [],
  'limited': [],
  'fishing': [],
  'creditcard': [],
  'limo': [],
  'cbn': [],
  'ストア': [],
  'қаз': [],
  'statefarm': [],
  'cbs': [],
  'tdk': []
};
