import 'package:intl/intl.dart' as intl;

import 'app_localizations.dart';

/// The translations for Turkish (`tr`).
class AppLocalizationsTr extends AppLocalizations {
  AppLocalizationsTr([String locale = 'tr']) : super(locale);

  @override
  String get appName => 'Locus';

  @override
  String get unknownError => 'Bilinmeyen bir hata oluştu';

  @override
  String get unknownValue => 'Bilinmeyen';

  @override
  String get resetLabel => 'Sıfırla';

  @override
  String get cancelLabel => 'İptal';

  @override
  String get loading => 'Loading...';

  @override
  String get biometricsFailed => 'You could not be authenticated';

  @override
  String get openInMaps => 'Open in Maps';

  @override
  String get addLabel => 'Ekle';

  @override
  String get showDetailsLabel => 'Show Details';

  @override
  String addNewValueLabel(String value) {
    return '\"$value\" ekle';
  }

  @override
  String get taskImportError => 'İşi içe aktarırken bir hata oluştu';

  @override
  String get taskImport_error_no_relays => 'No relays are present in the task.';

  @override
  String taskImport_error_sameTask(String name) {
    return 'This is a task from you (name: $name).';
  }

  @override
  String taskImport_error_sameView(String name) {
    return 'This is a view from you (name: $name).';
  }

  @override
  String longFormattedDate(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, yyyy HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return '$dateString';
  }

  @override
  String hoursPluralization(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'hours',
      one: 'hour',
    );
    return '$_temp0';
  }

  @override
  String get locationsLoadingError => 'Konumları yüklerken bir hata oluştu';

  @override
  String get locationFetchError => 'Konumları yüklerken bir hata oluştu. Lütfen daha sonra tekrar deneyin.';

  @override
  String get locationFetchEmptyError => 'Konum bulunamadı. Henüz bir konum paylaşılmamış veya paylaşılanların süreleri dolmuş olabilir.';

  @override
  String get locationIsStillFetching => 'Locations are still being fetched... These may not be the latest locations.';

  @override
  String get goBack => 'Geri dön';

  @override
  String get closePositiveSheetAction => 'Bitti';

  @override
  String get closeNeutralAction => 'Tamam';

  @override
  String get continueLabel => 'Devam et';

  @override
  String get deleteLabel => 'Sil';

  @override
  String get dismissLabel => 'Reddet';

  @override
  String get editRelays => 'Aktarıcıları Düzenle';

  @override
  String get editTimers => 'Edit Timers';

  @override
  String get uniLinksOpenError => 'Bağlantı açılamadı';

  @override
  String get actionNotUndoable => 'Bu işlem geri alınamaz!';

  @override
  String get linkCopiedToClipboard => 'Bağlantı panoya kopyalandı!';

  @override
  String get textCopiedToClipboard => 'Text copied to clipboard!';

  @override
  String get increaseVolume => 'Turn up the volume';

  @override
  String get nostrRelaysLabel => 'Nostr Aktarıcıları';

  @override
  String get nostrPublicKeyLabel => 'Herkese Açık Nostr anahtarı';

  @override
  String get signPublicKeyLabel => 'Herkese Açık İmza anahtarı';

  @override
  String get detailsTimersLabel => 'Sayaçlar';

  @override
  String get searchLabel => 'Ara';

  @override
  String get closeApp => 'Locus\'u Kapat';

  @override
  String get restartRequired_title => 'Restart required';

  @override
  String get restartRequired_description => 'Please restart Locus to apply the changes.';

  @override
  String get grantBluetoothPermission => 'Lütfen Bluetooth\'u etkinleştirin ve yakındaki cihazları tarayabilme iznini verin';

  @override
  String get grantPermission => 'İzin ver';

  @override
  String get updateAvailable_android => 'Locus\'un yeni versiyonu mevcut! Son versiyonun APK\'sını indirmek için tıklayın.';

  @override
  String get updateAvailable_android_title => 'Lütfen Locus\'u güncelleyin';

  @override
  String get updateAvailable_android_description => 'Locus\'un yeni versiyonu mevcut! Locus\'un yeni özelliklerinden yararlanmak ve hata düzeltmelerini kaçırmamak için Locus\'u güncel tutun. Son versiyonun APK\'sını indirmek için tıklayın.';

  @override
  String get updateAvailable_android_download => 'Güncellemeyi indir';

  @override
  String get updateAvailable_android_remindLater => 'Sonra hatırlat';

  @override
  String get updateAvailable_android_ignore => 'Güncellemeleri yoksay';

  @override
  String get locationFetcher_actions_fetchMore => 'Download older locations';

  @override
  String get doNotShowAgainLabel => 'Tekrar gösterme';

  @override
  String get fields_errors_isEmpty => 'Bu alan gereklidir';

  @override
  String get fields_errors_invalidCharacters => 'Bu alan geçersiz karakterler içeriyor';

  @override
  String get fields_errors_notNumber => 'Bu alan numara olmalı';

  @override
  String fields_errors_greaterThan(Object value) {
    return 'Bu alan $value\'den büyük olmalı';
  }

  @override
  String get fields_errors_invalidURL => 'This field must be a valid URL';

  @override
  String get openInMaps_title => 'Haritalarda Aç';

  @override
  String get openInMaps_description => 'Konumu nerede açmak istersiniz?';

  @override
  String get timer_executionStartsImmediately => 'Sayaç hemen başlayacak.';

  @override
  String timer_nextExecution(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'Bir sonraki sayaç $dateString\'de başlayacak';
  }

  @override
  String get timer_runsInfiniteMessage => 'Bu iş, siz durdurana kadar çalışmaya devam edecek.';

  @override
  String get timer_addWeekday => 'Hafta içi günü ekle';

  @override
  String get timer_addDuration => 'Süre Ekle';

  @override
  String relaySelectSheet_selectRandomRelays(Object count) {
    return 'Rastgele $count Nostr Aktarıcısı seç';
  }

  @override
  String get taskAction_start => 'İşi Başlat';

  @override
  String get taskAction_started_title => 'İş başlatıldı';

  @override
  String taskAction_started_description(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'İş $dateString\'de başlatıldı';
  }

  @override
  String get taskAction_notRunning_title => 'İş çalışmıyor';

  @override
  String taskAction_started_runsUntil(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'İş başlatıldı ve $dateString\'e kadar çalışacak';
  }

  @override
  String get taskAction_stop => 'İşi Durdur';

  @override
  String get taskAction_stopped_title => 'İş durduruldu';

  @override
  String taskAction_stopped_startsAgain(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'İş durduruldu ve $dateString\'de tekrar başlayacak';
  }

  @override
  String get taskAction_startSchedule => 'Programı Başlat';

  @override
  String get taskAction_startSchedule_title => 'İş zamanlandı';

  @override
  String taskAction_startSchedule_description(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'İş $dateString\'de başlamak üzere zamanlandı.';
  }

  @override
  String get taskAction_startSchedule_notScheduled_title => 'İş zamanlanamadı';

  @override
  String get taskAction_startSchedule_notScheduled_description => 'İş başlatılmadı çünkü gelecek için planlanmış bir program yok.';

  @override
  String get taskAction_stopSchedule => 'Programı Durdur';

  @override
  String get taskAction_stopSchedule_title => 'İşin zamanlaması kaldırıldı';

  @override
  String get taskAction_stopSchedule_description => 'İşin zamanlaması kaldırıldı. Artık otomatik olarak başlatılmayacak. Tekrar başlatmak için, tekrar zamanlayabilir veya manuel olarak başlatabilirsiniz';

  @override
  String get taskAction_generateLink => 'Link oluştur';

  @override
  String get taskAction_generateLink_process_encrypting => 'Şifreleniyor...';

  @override
  String get taskAction_generateLink_process_publishing => 'Şifrelenmiş veri yayınlanıyor...';

  @override
  String get taskAction_generateLink_process_creatingURI => 'Link oluşturuluyor...';

  @override
  String get taskAction_generateLink_shareTextSubject => 'Konumumu görmek için linkim';

  @override
  String get tasks_action_stopAll => 'Stop tasks';

  @override
  String get tasks_action_startAll => 'Start tasks';

  @override
  String get tasks_examples_weekend => 'Hafta Sonu Kaçamağı';

  @override
  String get tasks_examples_school => 'Okul';

  @override
  String tasks_example_hourDuration(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count saat',
      one: 'Bir saat',
    );
    return '$_temp0';
  }

  @override
  String tasks_example_daysDuration(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count gün',
      one: 'Bir gün',
    );
    return '$_temp0';
  }

  @override
  String get unnamedView => 'İsimsiz';

  @override
  String get viewAction_delete => 'Sil';

  @override
  String viewAction_delete_confirm_title(String view) {
    return '$view\'i silmek istediğinizden emin misiniz?';
  }

  @override
  String get welcomeScreen_title => 'Locus\'a Hoşgeldiniz';

  @override
  String get welcomeScreen_description => 'Konumunuzu arkadaşlarınızla ve ailenizle tamamen gizli ve güvenli bir şekilde paylaşın.';

  @override
  String get welcomeScreen_getStarted => 'Başla';

  @override
  String get welcomeScreen_explanation_title => 'Senin verin. Senin kararın.';

  @override
  String get welcomeScreen_explanation_description => 'Verileriniz konumunuzu paylaştığınız kişilerle tamamen uçtan uca şifrelenmiştir. Konumunuzu biz göremeyiz. Şifrelenmiş verileriniz sadece seçtiğiniz sunucularda saklanır.';

  @override
  String get welcomeScreen_explanation_understood => 'Anladım';

  @override
  String get welcomeScreen_startLabel => 'Start Locus';

  @override
  String get transferScreen_receive_awaiting_label => 'Bluetooth\'un açık olduğundan emin olun. Eski cihazınızda Locus\'u açın ve ayarlara gidin, ardından \"Yeni Telefon\'a Locus\'u Aktar\"\'a dokunun.';

  @override
  String get transferScreen_send_awaiting_label => 'Bluetooth\'un açık olduğundan emin olun. Yakındaki cihazlar aranıyor...';

  @override
  String get transferScreen_send_pin_description => 'PIN numaranız:';

  @override
  String get transferScreen_send_connected_label => 'Mükemmel! Yeni cihazınıza bağlandınız. Transferi başlatmak için \"Transfer\" düğmesine basın.';

  @override
  String get transferScreen_send_startTransfer => 'Transfer';

  @override
  String get transferScreen_receive_connect_description => 'Transfer isteği alındı. Bu PIN numarasıdır. PIN numarasının eski cihazınızdaki ile eşleştiğinden emin olun. PIN numaraları eşleşiyorsa \"Bağlan\"\'a dokunun.';

  @override
  String get transferScreen_receive_connected_label => 'Lütfen eski cihazınızdan transferi başlatın.';

  @override
  String get importTask_bluetooth_receive_title => 'Görüntüleme Anahtarı Al';

  @override
  String get importTask_bluetooth_receive_description => 'Bluetooth aracılığıyla başka bir cihazdan bir görüntüleme anahtarı alın. Diğer kişiden bir iş açmasını isteyin. Ardından ayrıntılara gidin, konum paylaşımına dokunun ve Bluetooth\'u seçin. Bluetooth\'un etkin olduğundan emin olun.';

  @override
  String get importTask_bluetooth_receive_id_description => 'Başkaları tarafından görülebilen ismin:';

  @override
  String get importTask_bluetooth_send_title => 'Konumunu Bluetooth kullanarak paylaş';

  @override
  String get importTask_bluetooth_send_description => 'Bluetooth\'un açık olduğundan emin olun. Cihazlar aranıyor...';

  @override
  String get importTask_bluetooth_receive_request_title => 'İsteği kabul etmek istiyor musunuz?';

  @override
  String get importTask_bluetooth_receive_request_description => 'Konum paylaşmak için bir bağlantı isteğinde bulunuldu. Siz bağlantıyı kabul edene kadar hangi konumun paylaşıldığını bilemeyiz. Bu bağlantıyı bekliyorsanız, bağlanabilirsiniz. Aksi takdirde talep reddedilecektir.';

  @override
  String get importTask_bluetooth_receive_request_decline => 'Reddet';

  @override
  String get importTask_bluetooth_receive_request_accept => 'Kabul et';

  @override
  String get sharesOverviewScreen_title => 'Shares Overview';

  @override
  String get sharesOverviewScreen_createTask => 'Create Share';

  @override
  String get sharesOverviewScreen_tasks => 'Shares';

  @override
  String get sharesOverviewScreen_createTask_scheduleNow => 'Start schedule immediately';

  @override
  String get sharesOverviewScreen_createTask_scheduleNow_help_title => 'Scheduling';

  @override
  String get sharesOverviewScreen_createTask_scheduleNow_help_description => 'The task will be scheduled after you create it. This does not necessarily mean that it will start directly. It will start at the next expected time based on your timers. If you disable this, you will have to schedule the task manually.';

  @override
  String get sharesOverviewScreen_createTask_tasksEmpty => 'No tasks yet';

  @override
  String get sharesOverviewScreen_createTask_description => 'Create a task to share your current location';

  @override
  String get sharesOverviewScreen_createTask_action_create => 'Create Share';

  @override
  String get sharesOverviewScreen_tasksSection => 'Shares';

  @override
  String get sharesOverviewScreen_viewsSection => 'Views';

  @override
  String get sharesOverviewScreen_importTask_title => 'Import a Share';

  @override
  String get sharesOverviewScreen_importTask_description => 'Import a task from a link or a file you have received';

  @override
  String get sharesOverviewScreen_importTask_action_import => 'Import Share';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod => 'How would you like to import the share?';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_url => 'Import Link';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_url_title => 'Enter the link of the share';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_url_hint => 'https://locus.cfd/#';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_url_label => 'Share Link';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_file => 'Import file';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_bluetooth => 'Receive via Bluetooth';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_file_selectFile => 'Select a ViewKey file to import';

  @override
  String get sharesOverviewScreen_importTask_action_import_isLoading => 'Importing...';

  @override
  String get sharesOverviewScreen_importTask_action_name_title => 'Enter a name for this view';

  @override
  String get sharesOverviewScreen_importTask_action_name_label => 'Name';

  @override
  String get sharesOverviewScreen_importTask_action_name_errors_sameNameAlreadyExists => 'A view with this name already exists';

  @override
  String get sharesOverviewScreen_importTask_action_color_label => 'Pick a color';

  @override
  String get sharesOverviewScreen_importTask_importOverview_title => 'Would you like to import this task view?';

  @override
  String get sharesOverviewScreen_importTask_importOverview_lastPosition => 'Last Position:';

  @override
  String get sharesOverviewScreen_importTask_successMessage => 'The task was successfully imported!';

  @override
  String get sharesOverviewScreen_importTask_importLabel => 'Import';

  @override
  String get locationsOverview_viewSelection_all => 'Show all locations';

  @override
  String locationsOverview_activeShares_amount(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count shares active',
      one: 'One share active',
      zero: 'No active shares',
    );
    return '$_temp0';
  }

  @override
  String get locationsOverview_mapAction_goToCurrentPosition => 'Go to current position';

  @override
  String get locationsOverview_mapAction_alignNorth => 'Align North';

  @override
  String get locationsOverview_mapAction_detailedLocations_show => 'Show detailed locations';

  @override
  String get locationsOverview_mapAction_detailedLocations_hide => 'Merge nearby locations';

  @override
  String get createTask_title => 'Bu iş için bir isim belirleyin';

  @override
  String get createTask_fields_name_label => 'İsim';

  @override
  String get createTask_sameTaskNameAlreadyExists => 'Bu isimde bir iş zaten var. İşi oluşturabilirsiniz, ancak aynı isimde iki işiniz olacak.';

  @override
  String get createTask_fields_relays_label => 'Relays';

  @override
  String createTask_fields_relays_selectLabel(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Aktarıcı Seçildi',
      one: 'Bir Aktarıcı Seçildi',
      zero: 'Aktarıcı Seç',
    );
    return '$_temp0';
  }

  @override
  String get createTask_fields_timers_label => 'Timers';

  @override
  String createTask_fields_timers_selectLabel(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Zamanlayıcı Seçildi',
      one: 'Bir Zamanlayıcı Seçildi',
      zero: 'Zamanlayıcı Seç',
    );
    return '$_temp0';
  }

  @override
  String get createTask_process_creatingSignKeys => 'İmza Anahtarı Oluşturuluyor...';

  @override
  String get createTask_process_creatingViewKeys => 'Görüntüleme Anahtarı Oluşturuluyor...';

  @override
  String get createTask_errors_emptyRelays => 'Lütfen en az bir aktarıcı seçin';

  @override
  String get createTask_createLabel => 'Oluştur';

  @override
  String get taskDetails_title => 'Detaylar';

  @override
  String get taskDetails_goToDetails => 'Detaylara Git';

  @override
  String get taskDetails_lastKnownLocation => 'Son bilinen konum';

  @override
  String get taskDetails_noLocations => 'Henüz konum kaydedilmedi';

  @override
  String get taskDetails_noTimers => 'No timers set up';

  @override
  String taskDetails_summary(int count, DateTime startDate, DateTime endDate) {
    final intl.DateFormat startDateDateFormat = intl.DateFormat('yyyy MMMM dd, HH:mm:ss', localeName);
    final String startDateString = startDateDateFormat.format(startDate);
    final intl.DateFormat endDateDateFormat = intl.DateFormat('yyyy MMMM dd, HH:mm:ss', localeName);
    final String endDateString = endDateDateFormat.format(endDate);

    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count locations saved',
      one: 'One location saved',
    );
    return '$_temp0 ranging from $startDateString to $endDateString';
  }

  @override
  String get taskDetails_mostRecentLocationExplanation => 'Bu, kaydedilen en son konumdur';

  @override
  String get taskDetails_locationDetails => 'Konum Detayları';

  @override
  String taskDetails_savedLocations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count konum kaydedildi',
      one: 'Bir konum kaydedildi',
      zero: 'Henüz konum kaydedilmedi',
    );
    return '$_temp0';
  }

  @override
  String get taskDetails_taskStatus => 'İş Durumu';

  @override
  String get taskDetails_deleteTask => 'İşi Sil';

  @override
  String get taskDetails_deleteTask_confirm => 'Bu işi silmek istediğinizden emin misiniz? Bu iş için daha fazla konumun kaydedilmeyeceği anlamına gelir. Mevcut konumlar silinmez.';

  @override
  String get taskDetails_locationDetails_createdAt_label => 'Oluşturulma Zamanı';

  @override
  String taskDetails_locationDetails_createdAt_value(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('yyyy MMMM dd, HH:mm:ss', localeName);
    final String dateString = dateDateFormat.format(date);

    return '$dateString';
  }

  @override
  String get taskDetails_locationDetails_battery_label => 'Pil Seviyesi';

  @override
  String taskDetails_locationDetails_battery_value(int level) {
    return '$level%';
  }

  @override
  String get taskDetails_locationDetails_batteryState_label => 'Pil Durumu';

  @override
  String get taskDetails_locationDetails_batteryState_charging => 'Şarj Oluyor';

  @override
  String get taskDetails_locationDetails_batteryState_discharging => 'Tükeniyor';

  @override
  String get taskDetails_locationDetails_batteryState_full => 'Dolu';

  @override
  String get taskDetails_locationDetails_batteryState_unknown => 'Bilinmeyen';

  @override
  String get taskDetails_locationDetails_accuracy_label => 'Doğruluk';

  @override
  String taskDetails_locationDetails_accuracy_value(int accuracy) {
    return '${accuracy}m';
  }

  @override
  String get taskDetails_locationDetails_speed_label => 'Hız';

  @override
  String taskDetails_locationDetails_speed_value(int speed) {
    return '${speed}m/s';
  }

  @override
  String get taskDetails_locationDetails_altitude_label => 'Yükseklik';

  @override
  String taskDetails_locationDetails_altitude_value(int altitude) {
    return '${altitude}m';
  }

  @override
  String get viewDetails_title => 'Detayları Gör';

  @override
  String get viewDetails_actions_openLatestLocation => 'Haritaları en son konuma aç';

  @override
  String get viewDetails_actions_showLocationList => 'Show Location List';

  @override
  String get viewDetails_actions_showAlarms_show => 'Show Alarms';

  @override
  String get viewDetails_actions_showAlarms_hide => 'Hide Alarms';

  @override
  String viewDetails_distanceToLatestLocation_label(int distance) {
    final intl.NumberFormat distanceNumberFormat = intl.NumberFormat.compactLong(
      locale: localeName,
      
    );
    final String distanceString = distanceNumberFormat.format(distance);

    return '$distanceString meters away';
  }

  @override
  String loadingLocationsTitle(int count) {
    return 'Konumlar yükleniyor: $count';
  }

  @override
  String get quickLocationShare_title => 'Share your location now';

  @override
  String get quickLocationShare_description => 'A link will be copied to your clipboard which you can share with anyone';

  @override
  String get quickLocationShare_shareUntilTurnOff => 'Share until I turn it off';

  @override
  String get quickLocationShare_shareForTime => 'Share for the following time';

  @override
  String get quickLocationShare_submit_label => 'Share';

  @override
  String quickLocationShare_name(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('yyyy MMMM dd, HH:mm:ss', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'Share from $dateString';
  }

  @override
  String get shareLocation_title => 'Konum Paylaş';

  @override
  String get shareLocation_description => 'Bu işten konumunuzu paylaşmak ister misiniz? Bu, diğer kullanıcıların konumunuzu görmesini sağlar. Konumunuzu görmek için herkesin kullanabileceği bir ViewKey dosyası oluşturur. Bu dosyayı güvende tutmanız ve yalnızca güvendiğiniz kişilerle paylaşmanız önemlidir.';

  @override
  String get shareLocation_actions_saveFile => 'Dosyayı Kaydet';

  @override
  String get shareLocation_actions_createQRCode => 'QR Kodu Oluştur';

  @override
  String get shareLocation_actions_shareFile => 'Dosyayı Paylaş';

  @override
  String get shareLocation_actions_shareFile_text => 'Konumumu görmek için Locus Görüntüleme Anahtarı';

  @override
  String get shareLocation_actions_shareLink => 'Link Paylaş';

  @override
  String get shareLocation_actions_shareLink_text => 'Konumumu görmek için Locus linkim';

  @override
  String get shareLocation_actions_shareBluetooth => 'Bluetooth ile paylaş';

  @override
  String shareLocation_scanToImport(String task) {
    return '$task işini içe aktarmak için bu QR Kodu\'nu tarayın';
  }

  @override
  String get settingsScreen_title => 'Ayarlar';

  @override
  String get settingsScreen_section_design => 'Tasarım';

  @override
  String get settingsScreen_section_privacy => 'Gizlilik';

  @override
  String get settingsScreen_section_defaults => 'Varsayılanlar';

  @override
  String get settingsScreen_sections_misc => 'Miscellaneous';

  @override
  String get settingsScreen_setting_primaryColor_label => 'Ana Renk';

  @override
  String get settingsScreen_setting_primaryColor_systemDefault => 'Sistem Varsayılanı';

  @override
  String get settingsScreen_settings_androidTheme_label => 'Android Theme';

  @override
  String get settingsScreen_settings_androidTheme_materialYou => 'Material You';

  @override
  String get settingsScreen_settings_androidTheme_miui => 'MIUI (Xiaomi\'s theme)';

  @override
  String get settingsScreen_setting_lookupAddresses_label => 'Adresleri Otomatik Ara';

  @override
  String get settingsScreen_setting_lookupAddresses_description => 'Konumlar için adresleri arar. Bu, ham bir konumun, örneğin (37.422131, -122.084801) bir adrese eşlenmesini sağlar. Adresi almak için konumu üçüncü taraf bir hizmete gönderir. Yalnızca konum detayları ekranını açtığınızda gerçekleşir. Bunu devre dışı bırakırsanız, konuma dokunarak adresi manuel olarak yükleyebilirsiniz.';

  @override
  String get settingsScreen_settings_mapProvider_label => 'Harita Sağlayıcı';

  @override
  String get settingsScreen_settings_mapProvider_apple => 'Apple Haritalar';

  @override
  String get settingsScreen_settings_mapProvider_openStreetMap => 'OpenStreetMap';

  @override
  String get settingsScreen_settings_showHints_label => 'İpuçlarını Göster';

  @override
  String get settingsScreen_settings_showHints_description => 'Locus\'tan en iyi şekilde yararlanmanın yolları hakkında ara sıra ipuçları göster';

  @override
  String get settingsScreen_settings_relays_label => 'Varsayılan Aktarıcılar';

  @override
  String settingsScreen_settings_relays_selectLabel(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Aktarıcı Seçildi',
      one: 'Bir Aktarıcı Seçildi',
      zero: 'Aktarıcı Seç',
    );
    return '$_temp0';
  }

  @override
  String get settingsScreen_settings_geocoderProvider_label => 'Arama Sağlayıcısı';

  @override
  String get settingsScreen_settings_geocoderProvider_description => 'Adresleri aramak için hangi sağlayıcının kullanılacağı.';

  @override
  String get settingsScreen_settings_geocoderProvider_system => 'Sistem';

  @override
  String get settingsScreen_settings_geocoderProvider_geocodeMapsCo => 'geocode.maps.co';

  @override
  String get settingsScreen_settings_geocoderProvider_nominatim => 'Nominatim (OpenStreetMap)';

  @override
  String get settingsScreen_settings_importExport_exportFile => 'Locus verilerini dışa aktar';

  @override
  String get settingsScreen_settings_importExport_exportFile_description => 'Tüm Locus verilerinizi dışa aktarın. Bu, tüm işlerinizi ve ayarlarınızı içerir. Bu dosyayı başka bir cihazda verilerinizi içe aktarmak için kullanabilirsiniz.';

  @override
  String get settingsScreen_settings_importExport_exportFile_save => 'Dışa Aktarmayı Kaydet';

  @override
  String get settingsScreen_settings_importExport_transfer => 'Locus\'u yeni bir telefona aktar';

  @override
  String get settingsScreen_settings_importExport_transfer_connectionActionLabel => 'Bağlan';

  @override
  String get settingsScreen_settings_importExport_importLabel => 'Locus verilerini içe aktar';

  @override
  String get settingsScreen_import_file => 'Dosyayı İçe Aktar';

  @override
  String get settingsScreen_import_pickerTitle => 'Verilerinizi içe aktarmak için export.locus.json dosyasını seçin';

  @override
  String get settingsScreen_import_transfer => 'Eski cihazdan aktar';

  @override
  String get settingsScreen_import_confirmation_title => 'Are you sure you want to import your data?';

  @override
  String get settingsScreen_import_confirmation_description => 'Do you want to import your data? THIS WILL OVERWRITE YOUR CURRENT DATA (SHARES, SETTINGS, ETC.) WITH THE DATA FROM THE IMPORT!';

  @override
  String get settingsScreen_import_confirmation_confirm => 'Import';

  @override
  String get settingsScreen_import_restart_title => 'Restart Locus';

  @override
  String get settingsScreen_import_restart_description => 'Locus needs to be restart to finish the import. Please restart the app now.';

  @override
  String settingsScreen_version(String version, String flavor) {
    String _temp0 = intl.Intl.selectLogic(
      flavor,
      {
        'gms': 'GMS',
        'floss': 'FLOSS',
        'other': 'Bilinmeyen',
      },
    );
    return 'Versiyon $version ($_temp0)';
  }

  @override
  String get settingsScreen_exportLogs => 'Export Logs';

  @override
  String get settingsScreen_exportLogs_shareText => 'Here are my Locus logs';

  @override
  String get settingsScreen_exportLogs_error => 'There was an error exporting the logs';

  @override
  String get settingsScreen_setting_requireBiometricAuth_label => 'Require Biometric Authentication';

  @override
  String get settingsScreen_setting_requireBiometricAuth_description => 'If enabled, Locus will require you to authenticate with your biometric data (fingerprint, face, etc.) before opening the app.';

  @override
  String get settingsScreen_setting_requireBiometricAuth_requireNowReason => 'Confirm your identity to change this setting';

  @override
  String get settingsScreen_settings_alwaysUseBatterySaveMode_label => 'Always use battery save mode';

  @override
  String get settingsScreen_settings_alwaysUseBatterySaveMode_description => 'Locus will update your location less frequently in the background if your phone is in battery save mode. Enabling this option will force Locus to always use battery save mode. Note that your location will still be updated in real time if you have the app open.';

  @override
  String get settingsScreen_settings_serverOrigin_label => 'Server Origin';

  @override
  String get settingsScreen_settings_serverOrigin_description => 'The origin of the server to connect to. This is only used if you have a custom server. If you don\'t know what this is, you can ignore this setting.';

  @override
  String get settingsScreen_settings_serverOrigin_error_invalid => 'This must be a valid origin. An origin consists of a protocol (http:// or https://) and a domain name (e.g. example.com). For example: https://example.com or https://locus.cfd';

  @override
  String get settingsScreen_settings_serverOrigin_hint => 'locus.cfd';

  @override
  String get settingsScreen_settings_serverOrigin_error_serverInvalid => 'This is not a Locus server';

  @override
  String get support_title => 'Locus\'u Destekle';

  @override
  String get support_description => 'Locus, açık kaynak kodlu bir özgür yazılımdır. Bu, Locus\'tan para kazanmadığım anlamına gelir. Uygulamayı beğendiyseniz ve beni desteklemek istiyorsanız, bunu birden çok şekilde yapabilirsiniz. Çok teşekkürler! :)';

  @override
  String get support_options_develop => 'Locus\'un Geliştirilmesine Destek Ol';

  @override
  String get support_options_develop_description => 'Yeni bir özellik ekle, bir hatayı düzelt veya uygulamayı kendin geliştir';

  @override
  String get support_options_translate => 'Locus\'u Çevir';

  @override
  String get support_options_translate_description => 'Locus\'un kendi dilinize çevrilmesine destek olun';

  @override
  String get support_options_donate => '1€ Bağışla';

  @override
  String get support_options_donate_description => 'Bitcoin, Monero veya Github Sponsors üzerinden bağış yapın';

  @override
  String get honorableMentions_title => 'Takdir Edilenler';

  @override
  String get honorableMentions_description => 'Kişisel olarak kullandığım ve emekleri için teşekkür etmek istediğim açık kaynak projelerdir. Herhangi bir sırayla listelenmişlerdir. Bu uygulamalar, Locus ile ilişkili değildir ve herhangi bir şekilde sponsor olmamışlardır ve olmayacaklardır. Sadece onları beğeniyorum ve emekleri için teşekkür etmek istiyorum.';

  @override
  String get honorableMentions_values_libreTube => 'LibreTube';

  @override
  String get honorableMentions_values_libreTube_description => 'Videoları harici sunucular aracılığıyla proxy yapma özelliğine sahip, Android için harika bir YouTube istemcisi.';

  @override
  String get honorableMentions_values_findMyDevice => 'Find My Device';

  @override
  String get honorableMentions_values_findMyDevice_description => 'Google\'ın Find My Device uygulamasına Açık Kaynak alternatif. Cihazınızı takip etmenizi sağlar.';

  @override
  String get honorableMentions_values_simpleQR => 'Simple QR';

  @override
  String get honorableMentions_values_simpleQR_description => 'Reklamsız ve izleyicisiz bir QR Kodu tarayıcısı ve oluşturucusu.';

  @override
  String get honorableMentions_values_session => 'Session';

  @override
  String get honorableMentions_values_session_description => 'Telefon numarası veya e-posta gerektirmeden uçtan uca şifreli mesajlaşmanızı sağlayan merkeziyetsiz mesajlaşma uygulaması.';

  @override
  String get honorableMentions_values_odysee => 'Odysee';

  @override
  String get honorableMentions_values_odysee_description => 'Gelişmiş gizlilik ve kazanç seçenekleri sunan mükemmel bir YouTube alternatifi.';

  @override
  String get honorableMentions_values_kleckRelay => 'KleckRelay';

  @override
  String get honorableMentions_values_kleckRelay_description => 'İzleyici kaldırıcı, görüntü ön yükleyicileri ve çok daha fazlasını içeren açık kaynaklı bir e-posta aktarma hizmeti. Tarafımdan oluşturuldu :)';

  @override
  String get quickActions_createOneHour => 'Bir Saatlik İş Oluştur';

  @override
  String quickActions_createOneHour_labelFromNow(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return '$dateString itibariyle bir saatlik iş';
  }

  @override
  String get quickActions_shareNow => 'Konumu Şimdi Güncelle';

  @override
  String get quickActions_stopTasks => 'Tüm İşleri Durdur';

  @override
  String get quickActions_generationExplanation => 'Üzerinde çalışıyoruz!';

  @override
  String get appHint_quickActions_title => 'Hızlı Eylemlere Göz Atın';

  @override
  String get appHint_quickActions_description => 'Ana ekranınızdaki Locus simgesine uzun basarak hızlıca yeni bir iş oluşturabilir veya konumunuzu güncelleyebilirsiniz.';

  @override
  String get appHint_defaultRelays_title => 'Varsayılan Aktarıcılar Ekleyin';

  @override
  String get appHint_defaultRelays_description => 'Ayarlar kısmında varsayılan aktarıcılar ekleyebilirsiniz. Bu, yeni bir iş oluştururken onların otomatik olarak seçilmesini sağlar.';

  @override
  String get appHint_appColor_title => 'Uygulama Renklerini Değiştir';

  @override
  String get appHint_appColor_description => 'Ayarlar kısmında ana rengi değiştirerek Locus\'u kişiselleştirebilirsiniz.';

  @override
  String get appHint_showMeLabel => 'Göster';

  @override
  String get weekdays_monday => 'Pazartesi';

  @override
  String get weekdays_tuesday => 'Salı';

  @override
  String get weekdays_wednesday => 'Çarşamba';

  @override
  String get weekdays_thursday => 'Perşembe';

  @override
  String get weekdays_friday => 'Cuma';

  @override
  String get weekdays_saturday => 'Cumartesi';

  @override
  String get weekdays_sunday => 'Pazar';

  @override
  String get weekdaySelection_selectTitle => 'Tarih ve Saati Seçin';

  @override
  String get weekdaySelection_error_startTimeBeforeEndTime => 'Başlangıç saati, bitiş saatinden önce olmalıdır';

  @override
  String get backgroundLocationFetch_title => 'Konum gerçek zamanlı olarak güncelleniyor';

  @override
  String get backgroundLocationFetch_text => 'Konumunuzu gerçek zamanlı olarak güncellemeyi durdurmak için uygulamayı kapatın. Locus, konumunuzu arka planda daha az pil kullanarak güncellemeye devam edecektir.';

  @override
  String logs_createdAt(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return '$dateString';
  }

  @override
  String get logs_values_taskCreated => 'İş oluşturuldu';

  @override
  String get logs_values_taskDeleted => 'İş silindi';

  @override
  String get logs_values_taskStatusChanged => 'İş durumu değiştirildi';

  @override
  String get logs_values_updatedLocation => 'Konum güncellendi';

  @override
  String get logs_values_alarmCreated => 'Alarm added';

  @override
  String get logs_values_alarmDeleted => 'Alarm removed';

  @override
  String log_title_taskCreated(String name) {
    return '<$name> oluşturuldu';
  }

  @override
  String log_title_taskDeleted(String name) {
    return '<$name> silindi';
  }

  @override
  String log_title_taskStatusChanged(String active, String name) {
    String _temp0 = intl.Intl.selectLogic(
      active,
      {
        'true': '$name başladı',
        'false': '$name durduruldu',
        'other': 'Bilinmeyen bir hata meydana geldi',
      },
    );
    return '$_temp0';
  }

  @override
  String log_title_updatedLocation(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count iş için',
      one: 'bir iş için',
    );
    return '$_temp0 konum güncellendi';
  }

  @override
  String log_title_alarmCreated(String viewName) {
    return 'Alarm added for $viewName';
  }

  @override
  String log_title_alarmDeleted(String viewName) {
    return 'Alarm removed from $viewName';
  }

  @override
  String get logs_system_initiator_description => 'Bu günlük sistem tarafından oluşturuldu';

  @override
  String logs_task_creationContext_description(String context) {
    String _temp0 = intl.Intl.selectLogic(
      context,
      {
        'inApp': 'İş, uygulama içinde oluşturuldu',
        'quickAction': 'İş, hızlı eylem ile oluşturuldu',
        'other': 'Bilinmeyen bir hata meydana geldi',
      },
    );
    return '$_temp0';
  }

  @override
  String get logs_title => 'Locus otomatik olarak günlükler oluşturur';

  @override
  String get logs_description => 'Günlükler 7 gün boyunca saklanır ve sonrasında otomatik olarak silinir.';

  @override
  String get locationPointsScreen_title => 'Location Points';

  @override
  String get bunny_unavailable => 'Sorry, but it seems as if your friend is as lost as this song.';

  @override
  String get bunny_unavailable_action => 'What\'s this song?';

  @override
  String locationAlarm_radiusBasedRegion_notificationTitle_whenEnter(String name, String zone) {
    return '$name entered zone $zone';
  }

  @override
  String locationAlarm_radiusBasedRegion_notificationTitle_whenLeave(String name, String zone) {
    return '$name left zone $zone';
  }

  @override
  String locationAlarm_radiusBasedRegion_notificationTitle_maybe(String name, String zone) {
    return '$name may has entered or left zone $zone';
  }

  @override
  String get locationAlarm_notification_description => 'Tap for more information';

  @override
  String get androidNotificationChannel_locationAlarms_name => 'Location Alarms';

  @override
  String get androidNotificationChannel_locationAlarms_description => 'Receive notifications for location alarms';

  @override
  String get location_manageAlarms_title => 'Manage Alarms';

  @override
  String get location_manageAlarms_empty_title => 'No Alarms';

  @override
  String get location_manageAlarms_empty_description => 'Add alarms to be notified when certain conditions are met (e.g. when this person enters a certain area).';

  @override
  String get location_manageAlarms_addNewAlarm_actionLabel => 'Add Alarm';

  @override
  String location_manageAlarms_lastCheck_description(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'Last checked at $dateString';
  }

  @override
  String get location_addAlarm_radiusBased_title => 'Add radius-based Alarm';

  @override
  String get location_addAlarm_radiusBased_isInScaleMode => 'You can now scale the radius by pinching and zooming into the map. Tap on the screen to go back to normal mode.';

  @override
  String get location_addAlarm_radiusBased_addLabel => 'Select region';

  @override
  String get location_addAlarm_radiusBased_help_title => 'Radius-based Alarms';

  @override
  String get location_addAlarm_radiusBased_help_description => 'Radius-based alarms are triggered either when leaving or entering a region. After defining your region, you can decide when your alarm should trigger.';

  @override
  String get location_addAlarm_radiusBased_help_tapDescription => 'Tap on the map to mark the center of your region';

  @override
  String get location_addAlarm_radiusBased_help_pinchDescription => 'Press and hold to enter into scale mode. You can then change the radius by pinching and zooming into the map.';

  @override
  String get location_addAlarm_radiusBased_trigger_title => 'When should your alarm trigger?';

  @override
  String get location_addAlarm_radiusBased_trigger_whenEnter => 'Trigger when entering';

  @override
  String get location_addAlarm_radiusBased_trigger_whenLeave => 'Trigger when leaving';

  @override
  String get location_addAlarm_radiusBased_name_description => 'Please enter a name for this region';

  @override
  String get location_addAlarm_actionLabel => 'Add Alarm';

  @override
  String get permissions_openSettings_label => 'Open settings';

  @override
  String get permissions_openSettings_failed_title => 'Settings could not be opened';

  @override
  String get permissions_location_askPermission_title => 'Grant access to your location';

  @override
  String get permissions_location_askPermission_message_always => 'Locus needs to access your location in the background. We will first ask for your permission while you use the app. Please make sure to tap on \"Allow while using the App\". Do not tap on \"Allow once\". After that, we will ask you to grant us permission to access your location in the background. Please make sure to tap on \"Always Allow\".';

  @override
  String get permissions_location_askPermission_message_whileInUse => 'Locus needs to access your location. Please grant the permission in the next step.';

  @override
  String get permissions_location_askPermission_action_grant_label => 'Grant permission';

  @override
  String get permissions_location_permissionDenied_message => 'You have denied Locus access to your location. You can grant the permission in the settings.';

  @override
  String get permissions_location_permissionDenied_settingsNotOpened_message => 'We could not open the settings. Please open the settings manually and grant Locus access to your location.';

  @override
  String get permissions_batteryOptimizations_askPermission_title => 'Disable battery optimizations';

  @override
  String get permissions_batteryOptimizations_askPermission_message => 'Locus needs to run in the background to be able to store your location and notify you when you an alarm is set. Please disable battery optimizations for Locus in the next step. You might need to press on \"Create\" again after disabling the optimizations.';

  @override
  String get permissions_batteryOptimizations_disableManufacturerOptimization_title => 'Your device has additional battery optimizations';

  @override
  String get permissions_batteryOptimizations_disableManufacturerOptimization_message => 'Your device has additional battery optimizations. Please disable them too based on the instructions below.';

  @override
  String get permissions_batteryOptimizations_askPermission_action_label => 'Disable battery optimizations';

  @override
  String get permissions_autoStart_title => 'Enable auto start';

  @override
  String get permissions_autoStart_message => 'Locus needs to start automatically to ensure your locations are sent. Please enable auto start in the next step.';

  @override
  String get permissions_notification_askPermission_title => 'Grant access to notifications';

  @override
  String get permissions_notification_askPermission_message => 'Locus needs to send notifications to notify you when an alarm is triggered. Please grant the permission to send you notifications in the next step.';

  @override
  String get permissions_notification_permissionDenied_message => 'You have denied Locus access to notifications. Please grant the permission in the settings.';

  @override
  String get permissions_notification_permissionDenied_settingsNotOpened_message => 'We could not open the settings. Please open the settings manually and allow Locus to send notifications.';

  @override
  String get taskDetails_share_help_title => 'Share your location with your friends';

  @override
  String get taskDetails_share_help_shareDescription => 'You can share this location with your friends. They will be able to see your location until you delete this task.';

  @override
  String get taskDetails_share_help_appDescription => 'Ask your friends to install Locus. Go to the task details and generate a link you can send, or share the view key file. When your friends open Locus and scroll down on the overview screen, they can import your location.';

  @override
  String get taskDetails_share_help_webDescription => 'Alternatively, other people can open the link in their browser. They will be able to see your location on a map. We discourage this method though, as it is less secure.';

  @override
  String get biometricsAuthentication_title => 'Biometrics Authentication';

  @override
  String get biometricsAuthentication_description => 'Please authenticate to open Locus';

  @override
  String get biometricsAuthentication_action => 'Authenticate';

  @override
  String get checkLocation_title => 'Verify location access';

  @override
  String get checkLocation_shortDescription => 'Verify Locus can access your location';

  @override
  String checkLocation_description(int minutes) {
    return 'Tap to check if Locus can access your location. Note that this might take up to $minutes minutes. Make sure you have GPS enabled. Do not close the app or turn off your screen while the check is running.';
  }

  @override
  String get checkLocation_start_label => 'Start check';

  @override
  String get checkLocation_values_usingBestLocation => 'Checking using best accuracy';

  @override
  String get checkLocation_values_usingWorstLocation => 'Checking using worst accuracy';

  @override
  String get checkLocation_values_usingAndroidLocationManagerBest => 'Checking using Android\'s Location Manager with best accuracy';

  @override
  String get checkLocation_values_usingAndroidLocationManagerWorst => 'Checking using Android\'s Location Manager with worst accuracy';

  @override
  String get checkLocation_successMessage => 'Congratulations! Locus can access your location!';

  @override
  String get checkLocation_gpsDisabledMessage => 'Please enable GPS to continue';

  @override
  String get checkLocation_permissionDeniedMessage => 'Please grant permission to your location';

  @override
  String get checkLocation_errorMessage => 'We are sorry, but Locus could not access your location. You can try it again later or find more information in the help section.';

  @override
  String get checkLocation_openHelp => 'Open help';

  @override
  String get help_location_title => 'Location Help';

  @override
  String get help_location_preamble => 'We are very sorry if Locus can not access your location. There are many reasons why this might happen. Please try the following steps to fix the issue:';

  @override
  String get help_location_goOutside => 'Go outside. It is possible that your device can not get proper signal inside.';

  @override
  String get help_location_enableGoogleLocationServices => 'Enable Google Location Services. Google Location Services massively improve the accuracy of your location. You can enable it in your device settings. Note that this will very likely tell Google your location.';

  @override
  String get help_location_enableScanning => 'Enable Wi-Fi and Bluetooth scanning. You can enable them in your device settings. Note that this could drain your battery faster.';

  @override
  String get help_location_useGMSVersion => 'Use the GMS version of Locus. The GMS version uses Google Location Services to get your location. You can download it from GitHub. You will be notified about updates inside the app.';

  @override
  String get locations_values_battery_description => 'Battery';

  @override
  String locations_values_battery_value(int value) {
    return '$value%';
  }

  @override
  String get locations_values_lastLocation_description => 'Last location update';

  @override
  String get locations_values_distance_description => 'Distance';

  @override
  String get locations_values_distance_permissionRequired => 'Grant permission';

  @override
  String locations_values_distance_km(String distance) {
    String _temp0 = intl.Intl.selectLogic(
      distance,
      {
        '0': '<1 km',
        '1': 'one km',
        'other': '$distance km',
      },
    );
    return '$_temp0';
  }

  @override
  String get locations_values_speed_description => 'Speed';

  @override
  String locations_values_speed_kmh(int speed) {
    return '$speed km/h';
  }

  @override
  String get locations_values_altitude_description => 'Altitude';

  @override
  String locations_values_altitude_m(int altitude) {
    return '$altitude m';
  }

  @override
  String get locations_values_batteryState_description => 'Battery state';

  @override
  String locations_values_batteryState_value(String state) {
    String _temp0 = intl.Intl.selectLogic(
      state,
      {
        'full': 'full',
        'charging': 'charging',
        'discharging': 'discharging',
        'other': 'unknown',
      },
    );
    return '$_temp0';
  }
}
