import 'package:intl/intl.dart' as intl;

import 'app_localizations.dart';

/// The translations for English (`en`).
class AppLocalizationsEn extends AppLocalizations {
  AppLocalizationsEn([String locale = 'en']) : super(locale);

  @override
  String get appName => 'Locus';

  @override
  String get unknownError => 'An unknown error occurred';

  @override
  String get unknownValue => 'Unknown';

  @override
  String get resetLabel => 'Reset';

  @override
  String get cancelLabel => 'Cancel';

  @override
  String get loading => 'Loading...';

  @override
  String get biometricsFailed => 'You could not be authenticated';

  @override
  String get openInMaps => 'Open in Maps';

  @override
  String get addLabel => 'Add';

  @override
  String get showDetailsLabel => 'Show Details';

  @override
  String addNewValueLabel(String value) {
    return 'Add \"$value\"';
  }

  @override
  String get taskImportError => 'An error occurred while importing the task';

  @override
  String get taskImport_error_no_relays => 'No relays are present in the task.';

  @override
  String taskImport_error_sameTask(String name) {
    return 'This is a task from you (name: $name).';
  }

  @override
  String taskImport_error_sameView(String name) {
    return 'This is a view from you (name: $name).';
  }

  @override
  String longFormattedDate(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, yyyy HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return '$dateString';
  }

  @override
  String hoursPluralization(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'hours',
      one: 'hour',
    );
    return '$_temp0';
  }

  @override
  String get locationsLoadingError => 'An error occurred while loading locations';

  @override
  String get locationFetchError => 'There was an error fetching the locations. Please try again later.';

  @override
  String get locationFetchEmptyError => 'No locations found. Maybe there hasn\'t been shared a location yet or they expired.';

  @override
  String get locationIsStillFetching => 'Locations are still being fetched... These may not be the latest locations.';

  @override
  String get goBack => 'Go back';

  @override
  String get closePositiveSheetAction => 'Done';

  @override
  String get closeNeutralAction => 'Ok';

  @override
  String get continueLabel => 'Continue';

  @override
  String get deleteLabel => 'Delete';

  @override
  String get dismissLabel => 'Dismiss';

  @override
  String get editRelays => 'Edit Relays';

  @override
  String get editTimers => 'Edit Timers';

  @override
  String get uniLinksOpenError => 'Link could not be opened';

  @override
  String get actionNotUndoable => 'This action cannot be undone!';

  @override
  String get linkCopiedToClipboard => 'Link copied to clipboard!';

  @override
  String get textCopiedToClipboard => 'Text copied to clipboard!';

  @override
  String get increaseVolume => 'Turn up the volume';

  @override
  String get nostrRelaysLabel => 'Nostr Relays';

  @override
  String get nostrPublicKeyLabel => 'Public Nostr key';

  @override
  String get signPublicKeyLabel => 'Public Sign key';

  @override
  String get detailsTimersLabel => 'Timers';

  @override
  String get searchLabel => 'Search';

  @override
  String get closeApp => 'Close Locus';

  @override
  String get restartRequired_title => 'Restart required';

  @override
  String get restartRequired_description => 'Please restart Locus to apply the changes.';

  @override
  String get grantBluetoothPermission => 'Please activate Bluetooth and grant the permission to scan for nearby devices';

  @override
  String get grantPermission => 'Grant permission';

  @override
  String get updateAvailable_android => 'A new version of Locus is available! Click to download the newest APK.';

  @override
  String get updateAvailable_android_title => 'Please update Locus';

  @override
  String get updateAvailable_android_description => 'A new version of Locus is available! Please keep Locus up to date to ensure that it works properly and you are not missing out any new features or bug fixes. Tap to download the newest APK.';

  @override
  String get updateAvailable_android_download => 'Download update';

  @override
  String get updateAvailable_android_remindLater => 'Remind me later';

  @override
  String get updateAvailable_android_ignore => 'Ignore updates';

  @override
  String get locationFetcher_actions_fetchMore => 'Download older locations';

  @override
  String get doNotShowAgainLabel => 'Do not show again';

  @override
  String get fields_errors_isEmpty => 'This field is required';

  @override
  String get fields_errors_invalidCharacters => 'This field contains invalid characters';

  @override
  String get fields_errors_notNumber => 'This field must be a number';

  @override
  String fields_errors_greaterThan(Object value) {
    return 'This field must be greater than $value';
  }

  @override
  String get fields_errors_invalidURL => 'This field must be a valid URL';

  @override
  String get openInMaps_title => 'Open in Maps';

  @override
  String get openInMaps_description => 'Where do you want to open this location in?';

  @override
  String get timer_executionStartsImmediately => 'Execution will start immediately.';

  @override
  String timer_nextExecution(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'Next execution will start at $dateString';
  }

  @override
  String get timer_runsInfiniteMessage => 'This task will run until you stop it manually.';

  @override
  String get timer_addWeekday => 'Add Weekday';

  @override
  String get timer_addDuration => 'Add Duration';

  @override
  String relaySelectSheet_selectRandomRelays(Object count) {
    return 'Select $count random Nostr Relays';
  }

  @override
  String get taskAction_start => 'Start Task';

  @override
  String get taskAction_started_title => 'Task started';

  @override
  String taskAction_started_description(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'Task started at $dateString';
  }

  @override
  String get taskAction_notRunning_title => 'Task is not running';

  @override
  String taskAction_started_runsUntil(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'The task has been started and will run until $dateString';
  }

  @override
  String get taskAction_stop => 'Stop Task';

  @override
  String get taskAction_stopped_title => 'Task stopped';

  @override
  String taskAction_stopped_startsAgain(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'The task has been stopped and will start again at $dateString';
  }

  @override
  String get taskAction_startSchedule => 'Start Schedule';

  @override
  String get taskAction_startSchedule_title => 'Task has been scheduled';

  @override
  String taskAction_startSchedule_description(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'Task has been scheduled to start at $dateString.';
  }

  @override
  String get taskAction_startSchedule_notScheduled_title => 'Task has not been scheduled';

  @override
  String get taskAction_startSchedule_notScheduled_description => 'The task has not been started because there is no schedule set for the future.';

  @override
  String get taskAction_stopSchedule => 'Stop Schedule';

  @override
  String get taskAction_stopSchedule_title => 'Task has been unscheduled';

  @override
  String get taskAction_stopSchedule_description => 'The task has been unscheduled. It will no longer be executed automatically. To start it again, you can either schedule it again or start it manually';

  @override
  String get taskAction_generateLink => 'Generate link';

  @override
  String get taskAction_generateLink_process_encrypting => 'Encrypting...';

  @override
  String get taskAction_generateLink_process_publishing => 'Publishing encrypted data...';

  @override
  String get taskAction_generateLink_process_creatingURI => 'Creating link...';

  @override
  String get taskAction_generateLink_shareTextSubject => 'Here\'s the link to see my location';

  @override
  String get tasks_action_stopAll => 'Stop tasks';

  @override
  String get tasks_action_startAll => 'Start tasks';

  @override
  String get tasks_examples_weekend => 'Weekend Getaway';

  @override
  String get tasks_examples_school => 'School';

  @override
  String tasks_example_hourDuration(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count hours',
      one: 'One hour',
    );
    return '$_temp0';
  }

  @override
  String tasks_example_daysDuration(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count days',
      one: 'One day',
    );
    return '$_temp0';
  }

  @override
  String get unnamedView => 'Unnamed';

  @override
  String get viewAction_delete => 'Delete';

  @override
  String viewAction_delete_confirm_title(String view) {
    return 'Are you sure you want to delete $view?';
  }

  @override
  String get welcomeScreen_title => 'Welcome to Locus';

  @override
  String get welcomeScreen_description => 'Share your location with your friends and family fully privately and securely.';

  @override
  String get welcomeScreen_getStarted => 'Get Started';

  @override
  String get welcomeScreen_explanation_title => 'Your data. You decide.';

  @override
  String get welcomeScreen_explanation_description => 'Your data is fully end-to-end encrypted to people you share your location with. We can not see your location. Your encrypted data is stored only on the servers of your choice.';

  @override
  String get welcomeScreen_explanation_understood => 'Understood';

  @override
  String get welcomeScreen_startLabel => 'Start Locus';

  @override
  String get transferScreen_receive_awaiting_label => 'Make sure you have Bluetooth enabled. Waiting for transfer, open Locus on your old device and go to settings, then tap \"Transfer Locus to a new Phone\"';

  @override
  String get transferScreen_send_awaiting_label => 'Make sure you have Bluetooth enabled. Searching for nearby devices...';

  @override
  String get transferScreen_send_pin_description => 'This is your PIN:';

  @override
  String get transferScreen_send_connected_label => 'Perfect! You are connected to your new device. Press \"Transfer\" to start the transfer.';

  @override
  String get transferScreen_send_startTransfer => 'Transfer';

  @override
  String get transferScreen_receive_connect_description => 'Received a transfer request. This is the PIN. Make sure the PIN matches the one on your old device. If it does, tap \"Connect\".';

  @override
  String get transferScreen_receive_connected_label => 'Please start the transfer on your old device now.';

  @override
  String get importTask_bluetooth_receive_title => 'Receive View Key';

  @override
  String get importTask_bluetooth_receive_description => 'Receive a view key from another device via Bluetooth. Ask the other person to open a task. Then go to details, tap on share location and select Bluetooth. Make sure you have Bluetooth enabled.';

  @override
  String get importTask_bluetooth_receive_id_description => 'This is your name visible to others:';

  @override
  String get importTask_bluetooth_send_title => 'Share location via Bluetooth';

  @override
  String get importTask_bluetooth_send_description => 'Make sure you have Bluetooth enabled. Looking for devices...';

  @override
  String get importTask_bluetooth_receive_request_title => 'Do you want to accept the request?';

  @override
  String get importTask_bluetooth_receive_request_description => 'A connect request to share a location has been made. We can\'t tell what location is being shared until you accept the connection. If you expected this connection, you can connect. Otherwise, the request will be rejected.';

  @override
  String get importTask_bluetooth_receive_request_decline => 'Decline';

  @override
  String get importTask_bluetooth_receive_request_accept => 'Accept';

  @override
  String get sharesOverviewScreen_title => 'Shares Overview';

  @override
  String get sharesOverviewScreen_createTask => 'Create Share';

  @override
  String get sharesOverviewScreen_tasks => 'Shares';

  @override
  String get sharesOverviewScreen_createTask_scheduleNow => 'Start schedule immediately';

  @override
  String get sharesOverviewScreen_createTask_scheduleNow_help_title => 'Scheduling';

  @override
  String get sharesOverviewScreen_createTask_scheduleNow_help_description => 'The task will be scheduled after you create it. This does not necessarily mean that it will start directly. It will start at the next expected time based on your timers. If you disable this, you will have to schedule the task manually.';

  @override
  String get sharesOverviewScreen_createTask_tasksEmpty => 'No tasks yet';

  @override
  String get sharesOverviewScreen_createTask_description => 'Create a task to share your current location';

  @override
  String get sharesOverviewScreen_createTask_action_create => 'Create Share';

  @override
  String get sharesOverviewScreen_tasksSection => 'Shares';

  @override
  String get sharesOverviewScreen_viewsSection => 'Views';

  @override
  String get sharesOverviewScreen_importTask_title => 'Import a Share';

  @override
  String get sharesOverviewScreen_importTask_description => 'Import a task from a link or a file you have received';

  @override
  String get sharesOverviewScreen_importTask_action_import => 'Import Share';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod => 'How would you like to import the share?';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_url => 'Import Link';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_url_title => 'Enter the link of the share';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_url_hint => 'https://locus.cfd/#';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_url_label => 'Share Link';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_file => 'Import file';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_bluetooth => 'Receive via Bluetooth';

  @override
  String get sharesOverviewScreen_importTask_action_importMethod_file_selectFile => 'Select a ViewKey file to import';

  @override
  String get sharesOverviewScreen_importTask_action_import_isLoading => 'Importing...';

  @override
  String get sharesOverviewScreen_importTask_action_name_title => 'Enter a name for this view';

  @override
  String get sharesOverviewScreen_importTask_action_name_label => 'Name';

  @override
  String get sharesOverviewScreen_importTask_action_name_errors_sameNameAlreadyExists => 'A view with this name already exists';

  @override
  String get sharesOverviewScreen_importTask_action_color_label => 'Pick a color';

  @override
  String get sharesOverviewScreen_importTask_importOverview_title => 'Would you like to import this task view?';

  @override
  String get sharesOverviewScreen_importTask_importOverview_lastPosition => 'Last Position:';

  @override
  String get sharesOverviewScreen_importTask_successMessage => 'The task was successfully imported!';

  @override
  String get sharesOverviewScreen_importTask_importLabel => 'Import';

  @override
  String get locationsOverview_viewSelection_all => 'Show all locations';

  @override
  String locationsOverview_activeShares_amount(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count shares active',
      one: 'One share active',
      zero: 'No active shares',
    );
    return '$_temp0';
  }

  @override
  String get locationsOverview_mapAction_goToCurrentPosition => 'Go to current position';

  @override
  String get locationsOverview_mapAction_alignNorth => 'Align North';

  @override
  String get locationsOverview_mapAction_detailedLocations_show => 'Show detailed locations';

  @override
  String get locationsOverview_mapAction_detailedLocations_hide => 'Merge nearby locations';

  @override
  String get createTask_title => 'Define a name for your Share';

  @override
  String get createTask_fields_name_label => 'Name';

  @override
  String get createTask_sameTaskNameAlreadyExists => 'A Share with this name already exists. You can create the Share, but you will have two Shares with the same name.';

  @override
  String get createTask_fields_relays_label => 'Relays';

  @override
  String createTask_fields_relays_selectLabel(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Selected $count Relays',
      one: 'Selected One Relay',
      zero: 'Select Relays',
    );
    return '$_temp0';
  }

  @override
  String get createTask_fields_timers_label => 'Timers';

  @override
  String createTask_fields_timers_selectLabel(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Selected $count Timers',
      one: 'Selected One Timer',
      zero: 'Select Timers',
    );
    return '$_temp0';
  }

  @override
  String get createTask_process_creatingSignKeys => 'Creating Sign Key...';

  @override
  String get createTask_process_creatingViewKeys => 'Creating View Key...';

  @override
  String get createTask_errors_emptyRelays => 'Please select at least one relay';

  @override
  String get createTask_createLabel => 'Create';

  @override
  String get taskDetails_title => 'Details';

  @override
  String get taskDetails_goToDetails => 'Go to Details';

  @override
  String get taskDetails_lastKnownLocation => 'Last known location';

  @override
  String get taskDetails_noLocations => 'No locations saved yet';

  @override
  String get taskDetails_noTimers => 'No timers set up';

  @override
  String taskDetails_summary(int count, DateTime startDate, DateTime endDate) {
    final intl.DateFormat startDateDateFormat = intl.DateFormat('yyyy MMMM dd, HH:mm:ss', localeName);
    final String startDateString = startDateDateFormat.format(startDate);
    final intl.DateFormat endDateDateFormat = intl.DateFormat('yyyy MMMM dd, HH:mm:ss', localeName);
    final String endDateString = endDateDateFormat.format(endDate);

    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count locations saved',
      one: 'One location saved',
    );
    return '$_temp0 ranging from $startDateString to $endDateString';
  }

  @override
  String get taskDetails_mostRecentLocationExplanation => 'This is the most recent location saved';

  @override
  String get taskDetails_locationDetails => 'Location Details';

  @override
  String taskDetails_savedLocations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count locations saved',
      one: 'One location saved',
      zero: 'No locations saved yet',
    );
    return '$_temp0';
  }

  @override
  String get taskDetails_taskStatus => 'Share Status';

  @override
  String get taskDetails_deleteTask => 'Delete Share';

  @override
  String get taskDetails_deleteTask_confirm => 'Are you sure you want to delete this Share? This means that no more locations will be saved for this Share. Existing locations will not be deleted.';

  @override
  String get taskDetails_locationDetails_createdAt_label => 'Created At';

  @override
  String taskDetails_locationDetails_createdAt_value(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('yyyy MMMM dd, HH:mm:ss', localeName);
    final String dateString = dateDateFormat.format(date);

    return '$dateString';
  }

  @override
  String get taskDetails_locationDetails_battery_label => 'Battery Level';

  @override
  String taskDetails_locationDetails_battery_value(int level) {
    return '$level%';
  }

  @override
  String get taskDetails_locationDetails_batteryState_label => 'Battery State';

  @override
  String get taskDetails_locationDetails_batteryState_charging => 'Charging';

  @override
  String get taskDetails_locationDetails_batteryState_discharging => 'Discharging';

  @override
  String get taskDetails_locationDetails_batteryState_full => 'Full';

  @override
  String get taskDetails_locationDetails_batteryState_unknown => 'Unknown';

  @override
  String get taskDetails_locationDetails_accuracy_label => 'Accuracy';

  @override
  String taskDetails_locationDetails_accuracy_value(int accuracy) {
    return '${accuracy}m';
  }

  @override
  String get taskDetails_locationDetails_speed_label => 'Speed';

  @override
  String taskDetails_locationDetails_speed_value(int speed) {
    return '${speed}m/s';
  }

  @override
  String get taskDetails_locationDetails_altitude_label => 'Altitude';

  @override
  String taskDetails_locationDetails_altitude_value(int altitude) {
    return '${altitude}m';
  }

  @override
  String get viewDetails_title => 'View Details';

  @override
  String get viewDetails_actions_openLatestLocation => 'Open Maps to latest location';

  @override
  String get viewDetails_actions_showLocationList => 'Show Location List';

  @override
  String get viewDetails_actions_showAlarms_show => 'Show Alarms';

  @override
  String get viewDetails_actions_showAlarms_hide => 'Hide Alarms';

  @override
  String viewDetails_distanceToLatestLocation_label(int distance) {
    final intl.NumberFormat distanceNumberFormat = intl.NumberFormat.compactLong(
      locale: localeName,
      
    );
    final String distanceString = distanceNumberFormat.format(distance);

    return '$distanceString meters away';
  }

  @override
  String loadingLocationsTitle(int count) {
    return 'Loading locations: $count';
  }

  @override
  String get quickLocationShare_title => 'Share your location now';

  @override
  String get quickLocationShare_description => 'A link will be copied to your clipboard which you can share with anyone';

  @override
  String get quickLocationShare_shareUntilTurnOff => 'Share until I turn it off';

  @override
  String get quickLocationShare_shareForTime => 'Share for the following time';

  @override
  String get quickLocationShare_submit_label => 'Share';

  @override
  String quickLocationShare_name(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('yyyy MMMM dd, HH:mm:ss', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'Share from $dateString';
  }

  @override
  String get shareLocation_title => 'Share Location';

  @override
  String get shareLocation_description => 'Would you like to share your location from this task? This will allow other users to see your location. A view key file will be generated which allows anyone to view your location. Makes sure to keep this file safe and only share it with people you trust.';

  @override
  String get shareLocation_actions_saveFile => 'Save File';

  @override
  String get shareLocation_actions_createQRCode => 'Create QR Code';

  @override
  String get shareLocation_actions_shareFile => 'Share File';

  @override
  String get shareLocation_actions_shareFile_text => 'Here\'s my Locus View Key to see my location';

  @override
  String get shareLocation_actions_shareLink => 'Share Link';

  @override
  String get shareLocation_actions_shareLink_text => 'Here\'s my Locus link to see my location';

  @override
  String get shareLocation_actions_shareBluetooth => 'Share via Bluetooth';

  @override
  String shareLocation_scanToImport(String task) {
    return 'Scan this QR Code to import task $task';
  }

  @override
  String get settingsScreen_title => 'Settings';

  @override
  String get settingsScreen_section_design => 'Design';

  @override
  String get settingsScreen_section_privacy => 'Privacy';

  @override
  String get settingsScreen_section_defaults => 'Default Values';

  @override
  String get settingsScreen_sections_misc => 'Miscellaneous';

  @override
  String get settingsScreen_setting_primaryColor_label => 'Primary Color';

  @override
  String get settingsScreen_setting_primaryColor_systemDefault => 'System Default';

  @override
  String get settingsScreen_settings_androidTheme_label => 'Android Theme';

  @override
  String get settingsScreen_settings_androidTheme_materialYou => 'Material You';

  @override
  String get settingsScreen_settings_androidTheme_miui => 'MIUI (Xiaomi\'s theme)';

  @override
  String get settingsScreen_setting_lookupAddresses_label => 'Automatically lookup addresses';

  @override
  String get settingsScreen_setting_lookupAddresses_description => 'Looks up addresses for locations. This means that a raw location, such as (37.422131, -122.084801) can be mapped to an address. This will send the location to a third party service to get the address. This will only happen when you open the location details screen. If you disable this, you can manually load the address by tapping on the location.';

  @override
  String get settingsScreen_settings_mapProvider_label => 'Map Provider';

  @override
  String get settingsScreen_settings_mapProvider_apple => 'Apple Maps';

  @override
  String get settingsScreen_settings_mapProvider_openStreetMap => 'OpenStreetMap';

  @override
  String get settingsScreen_settings_showHints_label => 'Show Hints';

  @override
  String get settingsScreen_settings_showHints_description => 'Show occasional hints on how to get the most out of Locus';

  @override
  String get settingsScreen_settings_relays_label => 'Default Relays';

  @override
  String settingsScreen_settings_relays_selectLabel(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Selected $count Relays',
      one: 'Selected One Relay',
      zero: 'Select Relays',
    );
    return '$_temp0';
  }

  @override
  String get settingsScreen_settings_geocoderProvider_label => 'Lookup Provider';

  @override
  String get settingsScreen_settings_geocoderProvider_description => 'Which provider to used to look up addresses for locations.';

  @override
  String get settingsScreen_settings_geocoderProvider_system => 'System';

  @override
  String get settingsScreen_settings_geocoderProvider_geocodeMapsCo => 'geocode.maps.co';

  @override
  String get settingsScreen_settings_geocoderProvider_nominatim => 'Nominatim (OpenStreetMap)';

  @override
  String get settingsScreen_settings_importExport_exportFile => 'Export Locus data';

  @override
  String get settingsScreen_settings_importExport_exportFile_description => 'Export all your Locus data to a file. This includes all your tasks and settings. You can use this file to import your data on another device.';

  @override
  String get settingsScreen_settings_importExport_exportFile_save => 'Save Export';

  @override
  String get settingsScreen_settings_importExport_transfer => 'Transfer Locus to a new phone';

  @override
  String get settingsScreen_settings_importExport_transfer_connectionActionLabel => 'Connect';

  @override
  String get settingsScreen_settings_importExport_importLabel => 'Import Locus data';

  @override
  String get settingsScreen_import_file => 'Import file';

  @override
  String get settingsScreen_import_pickerTitle => 'Select the export.locus.json file to import your data';

  @override
  String get settingsScreen_import_transfer => 'Transfer from old device';

  @override
  String get settingsScreen_import_confirmation_title => 'Are you sure you want to import your data?';

  @override
  String get settingsScreen_import_confirmation_description => 'Do you want to import your data? THIS WILL OVERWRITE YOUR CURRENT DATA (SHARES, SETTINGS, ETC.) WITH THE DATA FROM THE IMPORT!';

  @override
  String get settingsScreen_import_confirmation_confirm => 'Import';

  @override
  String get settingsScreen_import_restart_title => 'Restart Locus';

  @override
  String get settingsScreen_import_restart_description => 'Locus needs to be restart to finish the import. Please restart the app now.';

  @override
  String settingsScreen_version(String version, String flavor) {
    String _temp0 = intl.Intl.selectLogic(
      flavor,
      {
        'gms': 'GMS',
        'floss': 'FLOSS',
        'other': 'Unknown',
      },
    );
    return 'Version $version ($_temp0)';
  }

  @override
  String get settingsScreen_exportLogs => 'Export Logs';

  @override
  String get settingsScreen_exportLogs_shareText => 'Here are my Locus logs';

  @override
  String get settingsScreen_exportLogs_error => 'There was an error exporting the logs';

  @override
  String get settingsScreen_setting_requireBiometricAuth_label => 'Require Biometric Authentication';

  @override
  String get settingsScreen_setting_requireBiometricAuth_description => 'If enabled, Locus will require you to authenticate with your biometric data (fingerprint, face, etc.) before opening the app.';

  @override
  String get settingsScreen_setting_requireBiometricAuth_requireNowReason => 'Confirm your identity to change this setting';

  @override
  String get settingsScreen_settings_alwaysUseBatterySaveMode_label => 'Always use battery save mode';

  @override
  String get settingsScreen_settings_alwaysUseBatterySaveMode_description => 'Locus will update your location less frequently in the background if your phone is in battery save mode. Enabling this option will force Locus to always use battery save mode. Note that your location will still be updated in real time if you have the app open.';

  @override
  String get settingsScreen_settings_serverOrigin_label => 'Server Origin';

  @override
  String get settingsScreen_settings_serverOrigin_description => 'The origin of the server to connect to. This is only used if you have a custom server. If you don\'t know what this is, you can ignore this setting.';

  @override
  String get settingsScreen_settings_serverOrigin_error_invalid => 'This must be a valid origin. An origin consists of a protocol (http:// or https://) and a domain name (e.g. example.com). For example: https://example.com or https://locus.cfd';

  @override
  String get settingsScreen_settings_serverOrigin_hint => 'locus.cfd';

  @override
  String get settingsScreen_settings_serverOrigin_error_serverInvalid => 'This is not a Locus server';

  @override
  String get support_title => 'Support Locus';

  @override
  String get support_description => 'Locus is a free open source project. This means that I don\'t make any money from it. If you like the app and want to support me, you can do so by multiple ways. Thank you very much! :)';

  @override
  String get support_options_develop => 'Help developing Locus';

  @override
  String get support_options_develop_description => 'Add a new feature, fix a bug or improve the app in any other way';

  @override
  String get support_options_translate => 'Translate Locus';

  @override
  String get support_options_translate_description => 'Help translating Locus into your language';

  @override
  String get support_options_donate => 'Donate 1€';

  @override
  String get support_options_donate_description => 'Donate via Bitcoin, Monero or Github Sponsors';

  @override
  String get honorableMentions_title => 'Honorable Mentions';

  @override
  String get honorableMentions_description => 'These are honorable mentions of other great open source projects I personally use and would like to thank for their work :). They are listed in no particular order. These apps are not affiliated with Locus and aren\'t sponsored in any way and won\'t be. I just like them and want to thank them for their work.';

  @override
  String get honorableMentions_values_libreTube => 'LibreTube';

  @override
  String get honorableMentions_values_libreTube_description => 'Awesome YouTube client for Android with the ability to proxy videos through external servers.';

  @override
  String get honorableMentions_values_findMyDevice => 'Find My Device';

  @override
  String get honorableMentions_values_findMyDevice_description => 'Open Source alternative to Google\'s Find My Device. Allows you to track your device and wipe it remotely.';

  @override
  String get honorableMentions_values_simpleQR => 'Simple QR';

  @override
  String get honorableMentions_values_simpleQR_description => 'Simple QR Code scanner and generator without ads and tracking that just works.';

  @override
  String get honorableMentions_values_session => 'Session';

  @override
  String get honorableMentions_values_session_description => 'Decentralized messaging app with end-to-end encryption and no phone number or email required.';

  @override
  String get honorableMentions_values_odysee => 'Odysee';

  @override
  String get honorableMentions_values_odysee_description => 'Awesome YouTube alternative with better privacy and monetization options.';

  @override
  String get honorableMentions_values_kleckRelay => 'KleckRelay';

  @override
  String get honorableMentions_values_kleckRelay_description => 'An open source email relay service with tracker remover, image preloaders and much more. Created by me :)';

  @override
  String get quickActions_createOneHour => 'Create One-Hour Share';

  @override
  String quickActions_createOneHour_labelFromNow(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'One-Hour task from $dateString';
  }

  @override
  String get quickActions_shareNow => 'Update Location now';

  @override
  String get quickActions_stopTasks => 'Stop all Shares';

  @override
  String get quickActions_generationExplanation => 'Hold on, we are working on it!';

  @override
  String get appHint_quickActions_title => 'Check out Quick Actions';

  @override
  String get appHint_quickActions_description => 'You can quickly create a new Share or update your location by long pressing the Locus icon on your home screen.';

  @override
  String get appHint_defaultRelays_title => 'Add default Relays';

  @override
  String get appHint_defaultRelays_description => 'You can add default relays in the settings. This will automatically select them when creating a new task.';

  @override
  String get appHint_appColor_title => 'Change App Colors';

  @override
  String get appHint_appColor_description => 'You can personalize Locus by changing the primary color in the settings.';

  @override
  String get appHint_showMeLabel => 'Show me';

  @override
  String get weekdays_monday => 'Monday';

  @override
  String get weekdays_tuesday => 'Tuesday';

  @override
  String get weekdays_wednesday => 'Wednesday';

  @override
  String get weekdays_thursday => 'Thursday';

  @override
  String get weekdays_friday => 'Friday';

  @override
  String get weekdays_saturday => 'Saturday';

  @override
  String get weekdays_sunday => 'Sunday';

  @override
  String get weekdaySelection_selectTitle => 'Select Date and Time';

  @override
  String get weekdaySelection_error_startTimeBeforeEndTime => 'Start time must be before end time';

  @override
  String get backgroundLocationFetch_title => 'Updating location in real-time';

  @override
  String get backgroundLocationFetch_text => 'Close Locus to stop sharing in real time. Locus will still update your location, but less frequently.';

  @override
  String logs_createdAt(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return '$dateString';
  }

  @override
  String get logs_values_taskCreated => 'Share created';

  @override
  String get logs_values_taskDeleted => 'Share deleted';

  @override
  String get logs_values_taskStatusChanged => 'Share status changed';

  @override
  String get logs_values_updatedLocation => 'Location updated';

  @override
  String get logs_values_alarmCreated => 'Alarm added';

  @override
  String get logs_values_alarmDeleted => 'Alarm removed';

  @override
  String log_title_taskCreated(String name) {
    return '<$name> created';
  }

  @override
  String log_title_taskDeleted(String name) {
    return '<$name> deleted';
  }

  @override
  String log_title_taskStatusChanged(String active, String name) {
    String _temp0 = intl.Intl.selectLogic(
      active,
      {
        'true': '$name started',
        'false': '$name stopped',
        'other': 'Unknown error occurred',
      },
    );
    return '$_temp0';
  }

  @override
  String log_title_updatedLocation(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tasks',
      one: 'one task',
    );
    return 'Location updated for $_temp0';
  }

  @override
  String log_title_alarmCreated(String viewName) {
    return 'Alarm added for $viewName';
  }

  @override
  String log_title_alarmDeleted(String viewName) {
    return 'Alarm removed from $viewName';
  }

  @override
  String get logs_system_initiator_description => 'This log was created by the system';

  @override
  String logs_task_creationContext_description(String context) {
    String _temp0 = intl.Intl.selectLogic(
      context,
      {
        'inApp': 'Share created inside the App',
        'quickAction': 'Share created via Quick Action',
        'other': 'Unknown error occurred',
      },
    );
    return '$_temp0';
  }

  @override
  String get logs_title => 'Locus automatically creates logs';

  @override
  String get logs_description => 'Logs are kept for 7 days and are automatically deleted afterwards.';

  @override
  String get locationPointsScreen_title => 'Location Points';

  @override
  String get bunny_unavailable => 'Sorry, but it seems as if your friend is as lost as this song.';

  @override
  String get bunny_unavailable_action => 'What\'s this song?';

  @override
  String locationAlarm_radiusBasedRegion_notificationTitle_whenEnter(String name, String zone) {
    return '$name entered zone $zone';
  }

  @override
  String locationAlarm_radiusBasedRegion_notificationTitle_whenLeave(String name, String zone) {
    return '$name left zone $zone';
  }

  @override
  String locationAlarm_radiusBasedRegion_notificationTitle_maybe(String name, String zone) {
    return '$name may has entered or left zone $zone';
  }

  @override
  String get locationAlarm_notification_description => 'Tap for more information';

  @override
  String get androidNotificationChannel_locationAlarms_name => 'Location Alarms';

  @override
  String get androidNotificationChannel_locationAlarms_description => 'Receive notifications for location alarms';

  @override
  String get location_manageAlarms_title => 'Manage Alarms';

  @override
  String get location_manageAlarms_empty_title => 'No Alarms';

  @override
  String get location_manageAlarms_empty_description => 'Add alarms to be notified when certain conditions are met (e.g. when this person enters a certain area).';

  @override
  String get location_manageAlarms_addNewAlarm_actionLabel => 'Add Alarm';

  @override
  String location_manageAlarms_lastCheck_description(DateTime date) {
    final intl.DateFormat dateDateFormat = intl.DateFormat('MMMM d, HH:mm', localeName);
    final String dateString = dateDateFormat.format(date);

    return 'Last checked at $dateString';
  }

  @override
  String get location_addAlarm_radiusBased_title => 'Add radius-based Alarm';

  @override
  String get location_addAlarm_radiusBased_isInScaleMode => 'You can now scale the radius by pinching and zooming into the map. Tap on the screen to go back to normal mode.';

  @override
  String get location_addAlarm_radiusBased_addLabel => 'Select region';

  @override
  String get location_addAlarm_radiusBased_help_title => 'Radius-based Alarms';

  @override
  String get location_addAlarm_radiusBased_help_description => 'Radius-based alarms are triggered either when leaving or entering a region. After defining your region, you can decide when your alarm should trigger.';

  @override
  String get location_addAlarm_radiusBased_help_tapDescription => 'Tap on the map to mark the center of your region';

  @override
  String get location_addAlarm_radiusBased_help_pinchDescription => 'Press and hold to enter into scale mode. You can then change the radius by pinching and zooming into the map.';

  @override
  String get location_addAlarm_radiusBased_trigger_title => 'When should your alarm trigger?';

  @override
  String get location_addAlarm_radiusBased_trigger_whenEnter => 'Trigger when entering';

  @override
  String get location_addAlarm_radiusBased_trigger_whenLeave => 'Trigger when leaving';

  @override
  String get location_addAlarm_radiusBased_name_description => 'Please enter a name for this region';

  @override
  String get location_addAlarm_actionLabel => 'Add Alarm';

  @override
  String get permissions_openSettings_label => 'Open settings';

  @override
  String get permissions_openSettings_failed_title => 'Settings could not be opened';

  @override
  String get permissions_location_askPermission_title => 'Grant access to your location';

  @override
  String get permissions_location_askPermission_message_always => 'Locus needs to access your location in the background. We will first ask for your permission while you use the app. Please make sure to tap on \"Allow while using the App\". Do not tap on \"Allow once\". After that, we will ask you to grant us permission to access your location in the background. Please make sure to tap on \"Always Allow\".';

  @override
  String get permissions_location_askPermission_message_whileInUse => 'Locus needs to access your location. Please grant the permission in the next step.';

  @override
  String get permissions_location_askPermission_action_grant_label => 'Grant permission';

  @override
  String get permissions_location_permissionDenied_message => 'You have denied Locus access to your location. You can grant the permission in the settings.';

  @override
  String get permissions_location_permissionDenied_settingsNotOpened_message => 'We could not open the settings. Please open the settings manually and grant Locus access to your location.';

  @override
  String get permissions_batteryOptimizations_askPermission_title => 'Disable battery optimizations';

  @override
  String get permissions_batteryOptimizations_askPermission_message => 'Locus needs to run in the background to be able to store your location and notify you when you an alarm is set. Please disable battery optimizations for Locus in the next step. You might need to press on \"Create\" again after disabling the optimizations.';

  @override
  String get permissions_batteryOptimizations_disableManufacturerOptimization_title => 'Your device has additional battery optimizations';

  @override
  String get permissions_batteryOptimizations_disableManufacturerOptimization_message => 'Your device has additional battery optimizations. Please disable them too based on the instructions below.';

  @override
  String get permissions_batteryOptimizations_askPermission_action_label => 'Disable battery optimizations';

  @override
  String get permissions_autoStart_title => 'Enable auto start';

  @override
  String get permissions_autoStart_message => 'Locus needs to start automatically to ensure your locations are sent. Please enable auto start in the next step.';

  @override
  String get permissions_notification_askPermission_title => 'Grant access to notifications';

  @override
  String get permissions_notification_askPermission_message => 'Locus needs to send notifications to notify you when an alarm is triggered. Please grant the permission to send you notifications in the next step.';

  @override
  String get permissions_notification_permissionDenied_message => 'You have denied Locus access to notifications. Please grant the permission in the settings.';

  @override
  String get permissions_notification_permissionDenied_settingsNotOpened_message => 'We could not open the settings. Please open the settings manually and allow Locus to send notifications.';

  @override
  String get taskDetails_share_help_title => 'Share your location with your friends';

  @override
  String get taskDetails_share_help_shareDescription => 'You can share this location with your friends. They will be able to see your location until you delete this task.';

  @override
  String get taskDetails_share_help_appDescription => 'Ask your friends to install Locus. Go to the task details and generate a link you can send, or share the view key file. When your friends open Locus and scroll down on the overview screen, they can import your location.';

  @override
  String get taskDetails_share_help_webDescription => 'Alternatively, other people can open the link in their browser. They will be able to see your location on a map. We discourage this method though, as it is less secure.';

  @override
  String get biometricsAuthentication_title => 'Biometrics Authentication';

  @override
  String get biometricsAuthentication_description => 'Please authenticate to open Locus';

  @override
  String get biometricsAuthentication_action => 'Authenticate';

  @override
  String get checkLocation_title => 'Verify location access';

  @override
  String get checkLocation_shortDescription => 'Verify Locus can access your location';

  @override
  String checkLocation_description(int minutes) {
    return 'Tap to check if Locus can access your location. Note that this might take up to $minutes minutes. Make sure you have GPS enabled. Do not close the app or turn off your screen while the check is running.';
  }

  @override
  String get checkLocation_start_label => 'Start check';

  @override
  String get checkLocation_values_usingBestLocation => 'Checking using best accuracy';

  @override
  String get checkLocation_values_usingWorstLocation => 'Checking using worst accuracy';

  @override
  String get checkLocation_values_usingAndroidLocationManagerBest => 'Checking using Android\'s Location Manager with best accuracy';

  @override
  String get checkLocation_values_usingAndroidLocationManagerWorst => 'Checking using Android\'s Location Manager with worst accuracy';

  @override
  String get checkLocation_successMessage => 'Congratulations! Locus can access your location!';

  @override
  String get checkLocation_gpsDisabledMessage => 'Please enable GPS to continue';

  @override
  String get checkLocation_permissionDeniedMessage => 'Please grant permission to your location';

  @override
  String get checkLocation_errorMessage => 'We are sorry, but Locus could not access your location. You can try it again later or find more information in the help section.';

  @override
  String get checkLocation_openHelp => 'Open help';

  @override
  String get help_location_title => 'Location Help';

  @override
  String get help_location_preamble => 'We are very sorry if Locus can not access your location. There are many reasons why this might happen. Please try the following steps to fix the issue:';

  @override
  String get help_location_goOutside => 'Go outside. It is possible that your device can not get proper signal inside.';

  @override
  String get help_location_enableGoogleLocationServices => 'Enable Google Location Services. Google Location Services massively improve the accuracy of your location. You can enable it in your device settings. Note that this will very likely tell Google your location.';

  @override
  String get help_location_enableScanning => 'Enable Wi-Fi and Bluetooth scanning. You can enable them in your device settings. Note that this could drain your battery faster.';

  @override
  String get help_location_useGMSVersion => 'Use the GMS version of Locus. The GMS version uses Google Location Services to get your location. You can download it from GitHub. You will be notified about updates inside the app.';

  @override
  String get locations_values_battery_description => 'Battery';

  @override
  String locations_values_battery_value(int value) {
    return '$value%';
  }

  @override
  String get locations_values_lastLocation_description => 'Last location update';

  @override
  String get locations_values_distance_description => 'Distance';

  @override
  String get locations_values_distance_permissionRequired => 'Grant permission';

  @override
  String locations_values_distance_km(String distance) {
    String _temp0 = intl.Intl.selectLogic(
      distance,
      {
        '0': '<1 km',
        '1': 'one km',
        'other': '$distance km',
      },
    );
    return '$_temp0';
  }

  @override
  String get locations_values_speed_description => 'Speed';

  @override
  String locations_values_speed_kmh(int speed) {
    return '$speed km/h';
  }

  @override
  String get locations_values_altitude_description => 'Altitude';

  @override
  String locations_values_altitude_m(int altitude) {
    return '$altitude m';
  }

  @override
  String get locations_values_batteryState_description => 'Battery state';

  @override
  String locations_values_batteryState_value(String state) {
    String _temp0 = intl.Intl.selectLogic(
      state,
      {
        'full': 'full',
        'charging': 'charging',
        'discharging': 'discharging',
        'other': 'unknown',
      },
    );
    return '$_temp0';
  }
}
