# Changelog

All notable changes to this project will be documented in this file. See [conventional commits](https://www.conventionalcommits.org/) for commit guidelines.

## [Coming Soon](https://github.com/DroidWorksStudio/mLauncher/tree/HEAD)

### Implemented Enhancements:

- Added battery percentage click. - ([f2ef47f](https://github.com/DroidWorksStudio/mLauncher/commit/f2ef47fc2f4112cb59f575a9d05c942b3dc1658a))

### Bug Fixes:

- Fix the home screen from not being reloaded if not on home - ([e536fb5](https://github.com/DroidWorksStudio/mLauncher/commit/e536fb53f3dd1547a7ddd9198ad7d7953c74be42))

### Language Support:

- Updated Language Files. ([#507](https://github.com/DroidWorksStudio/mLauncher/issues/507)) - ([c28e754](https://github.com/DroidWorksStudio/mLauncher/commit/c28e7545dfa7a23b1dbcc0fa00de01b9388bb65f))

### Refactoring:

- Changed resetDefaultLauncher to better suit OEM - ([b701c18](https://github.com/DroidWorksStudio/mLauncher/commit/b701c18b76eb1dcea666c442c10bd9bb3cbab4af))

## [1.6.1](https://github.com/DroidWorksStudio/mLauncher/tree/1.6.1) - (11, May 2024)

### Implemented Enhancements:

- Added intent for ACTION_POWER_USAGE_SUMMARY ([#504](https://github.com/DroidWorksStudio/mLauncher/issues/504)) - ([a19cf8b](https://github.com/DroidWorksStudio/mLauncher/commit/a19cf8b7f766fa86da42d270f13978e3e61f34cb))
- Added the ability to have more custom font sizes. - ([e7ed4ca](https://github.com/DroidWorksStudio/mLauncher/commit/e7ed4caecb869a1e7377d2c050f614d45eb421d0))
- Added the ability to hide times AM/PM. - ([48ed53e](https://github.com/DroidWorksStudio/mLauncher/commit/48ed53e2658cc7c974d1bb0f0d3dc62a4f0f48f4))
- Added the ability to hide battery icon. - ([e177b18](https://github.com/DroidWorksStudio/mLauncher/commit/e177b1845e2fa10b7641286ac299ffa0e23fdd69))

### Bug Fixes:

- Fixed the clock size so it now has a max size of 150 instead of 70. - ([a62886c](https://github.com/DroidWorksStudio/mLauncher/commit/a62886ca0c8ea8e15afe3310d21e16ff576fe9cd))

### Dependency Updates:

- Updated a few depends. - ([f822278](https://github.com/DroidWorksStudio/mLauncher/commit/f82227849de569fd0f73af63018d2e75c16e1f89))

### Language Support:

- Updated Language Files. ([#501](https://github.com/DroidWorksStudio/mLauncher/issues/501)) - ([2e951d6](https://github.com/DroidWorksStudio/mLauncher/commit/2e951d677f213608cdd8c2f38e36e006948542ba))
- Updated Language Files. ([#499](https://github.com/DroidWorksStudio/mLauncher/issues/499)) - ([34a40d9](https://github.com/DroidWorksStudio/mLauncher/commit/34a40d96a5eedadd7d5559513787c42c7de799c6))

## [1.6.0](https://github.com/DroidWorksStudio/mLauncher/tree/1.6.0) - (05, May 2024)

### Bug Fixes:

- Check the total screen time is over 5 minutes. - ([a600069](https://github.com/DroidWorksStudio/mLauncher/commit/a600069e72e0db8a67468e887b88aef7b9a06975))

### Dependency Updates:

- Updated Gradle - ([dcb55be](https://github.com/DroidWorksStudio/mLauncher/commit/dcb55bedb9f83649d2956e0fcb3fde448cff69e2))

### Hotfixes:

- Updated !SheBang search functionality: - ([8bfcfc4](https://github.com/DroidWorksStudio/mLauncher/commit/8bfcfc48b76203cf337d136831bba6ee27aba981))

### Language Support:

- Updated Language Files. ([#494](https://github.com/DroidWorksStudio/mLauncher/issues/494)) - ([a1135de](https://github.com/DroidWorksStudio/mLauncher/commit/a1135debe45a43eca111288b8815b091721671ee))
- Updated Language Files. ([#493](https://github.com/DroidWorksStudio/mLauncher/issues/493)) - ([89e0ffa](https://github.com/DroidWorksStudio/mLauncher/commit/89e0ffae9273285b4889516661d94529ad5c3f61))

### Refactoring:

- Improved keyboard navigation and search functionality - ([d473265](https://github.com/DroidWorksStudio/mLauncher/commit/d473265f7644773da26e73202b104b55f4298e4e))

## [1.5.9](https://github.com/DroidWorksStudio/mLauncher/tree/1.5.9) - (01, May 2024)

### Implemented Enhancements:

- Add onKeyDown handling for menu key press. - ([7d7cc3f](https://github.com/DroidWorksStudio/mLauncher/commit/7d7cc3f44865a01da6d8bbd86b44a0af79099776))

### Bug Fixes:

- Some color themes were not working. - ([3763b01](https://github.com/DroidWorksStudio/mLauncher/commit/3763b014fd7a19e1e5b1390989483a8c9b4e8d6f))

## [1.5.8](https://github.com/DroidWorksStudio/mLauncher/tree/1.5.8) - (29, April 2024)

### Bug Fixes:

- Added the custom colors to the app draw too. - ([516eb12](https://github.com/DroidWorksStudio/mLauncher/commit/516eb12edb8ed2f0932c42b9a08f6447d3b813fd))
- Fixed Accent Colors When Disabled - ([e25ffa2](https://github.com/DroidWorksStudio/mLauncher/commit/e25ffa20afb6e4ffbb1c107a0ce36d905eb36ff8))

### Feature Removal:

- Removed unused strings - ([6de0b76](https://github.com/DroidWorksStudio/mLauncher/commit/6de0b761eb2ebf45e4566b7b05686b20576b0a2e))
- Removed Clutter from settings - ([c60bc9a](https://github.com/DroidWorksStudio/mLauncher/commit/c60bc9a946efcb0f214968c70f75fc106856969a))

## [1.5.7](https://github.com/DroidWorksStudio/mLauncher/tree/1.5.7) - (28, April 2024)

### Bug Fixes:

- Fixed the background opacity when below 10. - ([ebe667c](https://github.com/DroidWorksStudio/mLauncher/commit/ebe667ccd0b766dc92705d43cc98e25f6ac8c6f3))
- Fixed BiometricManager for when feature phone is enabled. - ([33ca37f](https://github.com/DroidWorksStudio/mLauncher/commit/33ca37f5a0702a1736c8df9a2eb2599f571db121))

### Dependency Updates:

- Updated androidxTestKotlin - ([17492ec](https://github.com/DroidWorksStudio/mLauncher/commit/17492ecf3950ee06cc3268a56e9da42b0786a616))

## [1.5.6](https://github.com/DroidWorksStudio/mLauncher/tree/1.5.6) - (28, April 2024)

### Implemented Enhancements:

- Add feature phone mode option - ([2042262](https://github.com/DroidWorksStudio/mLauncher/commit/20422622f4c0077e179db69787335ede2cba09d6))
- Added support for custom dark and light colors in app settings. - ([3d40055](https://github.com/DroidWorksStudio/mLauncher/commit/3d4005591bdd1eadac1a08605ac58045f6650b19))
- Add option to display app usage stats. - ([b2bc061](https://github.com/DroidWorksStudio/mLauncher/commit/b2bc061ec4c6c9a7e7a76152d0f5598baa73dddf))

### Bug Fixes:

- Fixed updateAppCountWithUsageStats to also allow feature phone buttons. - ([dc8c18c](https://github.com/DroidWorksStudio/mLauncher/commit/dc8c18c9b20b7312fc8e131d815cfd583363f092))
- Add key event handling and click listeners for feature phones - ([97818e5](https://github.com/DroidWorksStudio/mLauncher/commit/97818e571ab0d86b94c4701669a4fe7c8ae3173d))
- Better support for feature phones. - ([278ef1e](https://github.com/DroidWorksStudio/mLauncher/commit/278ef1e4d75058d1f8adb84f792fca69fcad0c4c))
- Fix receiver registration and unregistration in HomeFragment - ([935e2bb](https://github.com/DroidWorksStudio/mLauncher/commit/935e2bbea241751060b9512fabfef72c2a542c62))
- Fixed the ability for the launcher to ask for usage permission. - ([580a988](https://github.com/DroidWorksStudio/mLauncher/commit/580a988ae48032ba89dd780f5c9c2018ba579708))

### Language Support:

- Updated Language Files. ([#480](https://github.com/DroidWorksStudio/mLauncher/issues/480)) - ([4b381d9](https://github.com/DroidWorksStudio/mLauncher/commit/4b381d9fe0954fa1e3cabe135e70af3e30969a98))
- Updated Language Files. ([#477](https://github.com/DroidWorksStudio/mLauncher/issues/477)) - ([84ca97b](https://github.com/DroidWorksStudio/mLauncher/commit/84ca97bf4f368b5efdb6815777ffe066a364b072))

## [1.5.5](https://github.com/DroidWorksStudio/mLauncher/tree/1.5.5) - (23, April 2024)

### Implemented Enhancements:

- Update time formatting based on system settings - ([e6b3939](https://github.com/DroidWorksStudio/mLauncher/commit/e6b393974e3b1b65d84e583b2255d40a10b370b7))
- Add timezone support for date and time formatting - ([8be6d1c](https://github.com/DroidWorksStudio/mLauncher/commit/8be6d1cbcb1ab35abfca0ae2af3d37913d55745d))
- Add visibility control for app rename layout in AppDrawerAdapter - ([dd4dbd5](https://github.com/DroidWorksStudio/mLauncher/commit/dd4dbd5a25bc02cba4e9dde73d2d4fd6fac56736))

### Bug Fixes:

- Correct search behavior in AppDrawerFragment - ([0d12eb5](https://github.com/DroidWorksStudio/mLauncher/commit/0d12eb54ee59fb9d4bfc202fe1284e93895cb449))
- Fixed the backup so backups have timestamps. - ([886a189](https://github.com/DroidWorksStudio/mLauncher/commit/886a1897a060a7548d02ed10c8832aab7f2d5daa))

### Feature Removal:

- Removed Debugging Code - ([94df035](https://github.com/DroidWorksStudio/mLauncher/commit/94df0352754675188045769d21b08a3f79f1c2af))

### Language Support:

- Updated Language Files. ([#468](https://github.com/DroidWorksStudio/mLauncher/issues/468)) - ([343596d](https://github.com/DroidWorksStudio/mLauncher/commit/343596dd8bbedf5e2f06080c06d340ec25b57e88))

## [1.5.4](https://github.com/DroidWorksStudio/mLauncher/tree/1.5.4) - (18, April 2024)

### Bug Fixes:

- Fixed ISSUE_TEMPLATE - ([f520d5d](https://github.com/DroidWorksStudio/mLauncher/commit/f520d5db26f7e5d60a4d9fa67e19626ba7c65133))
- Ensure proper initialization of TextView objects in updateBatteryStatus() - ([939de4c](https://github.com/DroidWorksStudio/mLauncher/commit/939de4cd7ac48fe8a62c1f9d13f01e428bbc8b80))
- Fixed IllegalStateException when unregistering BatteryReceiver in onPause() - ([3cefa19](https://github.com/DroidWorksStudio/mLauncher/commit/3cefa19e2bc3a00729df839f4de215b769ec38b2))

### Language Support:

- Updated Language Files. ([#461](https://github.com/DroidWorksStudio/mLauncher/issues/461)) - ([6b427d4](https://github.com/DroidWorksStudio/mLauncher/commit/6b427d437977af25dcdc92d45d9576677551f055))

### Refactoring:

- Remove unused dependencies and notification-related configuration - ([ed2d732](https://github.com/DroidWorksStudio/mLauncher/commit/ed2d732582fb5388e5f1288537818323830c128a))
- Initialize prefs in attachBaseContext for timely initialization. - ([5a42051](https://github.com/DroidWorksStudio/mLauncher/commit/5a42051608a04ad472290f5ca5a5f8bd8356e45c))
- Improve ACRA configuration in Mlauncher.kt - ([52e1abb](https://github.com/DroidWorksStudio/mLauncher/commit/52e1abbb1f7f42dfed2223eb71924ad054a773c6))
- Refactor app settings and notification handling - ([2885e77](https://github.com/DroidWorksStudio/mLauncher/commit/2885e773140d4ae906fd50000e5616e31a43c886))

## [1.5.3](https://github.com/DroidWorksStudio/mLauncher/tree/1.5.3) - (16, April 2024)

### Bug Fixes:

- Corrected the format of the time and date when focus mode is enabled. - ([1751ee5](https://github.com/DroidWorksStudio/mLauncher/commit/1751ee58dd275c9bd2020a28970fdba7831a76de))

### Chore:

- Move skip configuration to the top of commit_parsers - ([f62c48a](https://github.com/DroidWorksStudio/mLauncher/commit/f62c48a89671ce11d85b9b65179984045091cb05))

### Configuration Changes:

- Updating to include additional changelog categories for comprehensive tracking and documentation. - ([81bdfbb](https://github.com/DroidWorksStudio/mLauncher/commit/81bdfbbf1c092c2ba81de5048bdd1c8718b7bceb))

### Documentation:

- Update badges in README.md - ([03f7cfc](https://github.com/DroidWorksStudio/mLauncher/commit/03f7cfc1c42a72dd02e9195b17bbb8bb300b659f))

### Refactoring:

- Improve language tag retrieval in value function. - ([b83dd83](https://github.com/DroidWorksStudio/mLauncher/commit/b83dd836785fd1cea8564fb8a0afc1fdf5249eff))
- Removing redundant or unused code segments. - ([0312061](https://github.com/DroidWorksStudio/mLauncher/commit/0312061b1a327a6a27a5d73303403ea4a9a395d6))
- Revised maximum and minimum size constraints for clock display - ([4b35505](https://github.com/DroidWorksStudio/mLauncher/commit/4b35505653603b8b43f7d37b2255e7b70c219f41))

## [1.5.2](https://github.com/DroidWorksStudio/mLauncher/tree/1.5.2) - (14, April 2024)

### Bug Fixes:

- Fixes #454 Clock size. - ([d66577d](https://github.com/DroidWorksStudio/mLauncher/commit/d66577dc2934f6fc979486840bed1e33637b1169))
- Fixed a few things, Crashing of app when searching hidden apps. Hidden apps couldn't be un hidden. - ([5b3f840](https://github.com/DroidWorksStudio/mLauncher/commit/5b3f8402065eb90c9966f9ef571f231fc1a66147))

### Language Support:

- Updated Language Files. ([#456](https://github.com/DroidWorksStudio/mLauncher/issues/456)) - ([b25032f](https://github.com/DroidWorksStudio/mLauncher/commit/b25032f82d0c11208904ed1968f06d8ca70f0783))
- Updated Language Files. ([#455](https://github.com/DroidWorksStudio/mLauncher/issues/455)) - ([740fdaa](https://github.com/DroidWorksStudio/mLauncher/commit/740fdaa52a8fb1d639e55c6431f2c759006dab5a))

## [1.5.1](https://github.com/DroidWorksStudio/mLauncher/tree/1.5.1) - (11, April 2024)

### Refactoring:

- Improved app icon design by updating to a more visually appealing icon. - ([b902790](https://github.com/DroidWorksStudio/mLauncher/commit/b9027903c64d5ffec647c4008528073c21b44e51))

## [1.5.0](https://github.com/DroidWorksStudio/mLauncher/tree/1.5.0) - (10, April 2024)

### Implemented Enhancements:

- Added a extra button for the Backup section of settings. - ([38fc111](https://github.com/DroidWorksStudio/mLauncher/commit/38fc1116150d6bbe45cc3d8ccb36ffea90956e07))
- Added Yahoo Brave and Bing search - ([e4db995](https://github.com/DroidWorksStudio/mLauncher/commit/e4db99569c750da974756188596ccfd5b36107b9))

### Chore:

- *(ci)* Updated FastLane - ([e541821](https://github.com/DroidWorksStudio/mLauncher/commit/e541821c3236ba8628c6c0b56f43353c023c03fb))

### Language Support:

- Updated Language Files. ([#442](https://github.com/DroidWorksStudio/mLauncher/issues/442)) - ([85ba73b](https://github.com/DroidWorksStudio/mLauncher/commit/85ba73b6c05309e7abfa2a4de3875efe987540ca))

### Refactoring:

- Eliminate duplicate entries in applist when adding a work profile - ([3aacf67](https://github.com/DroidWorksStudio/mLauncher/commit/3aacf6789f4547adc658029241a1945ed0496b02))

## [1.4.9](https://github.com/DroidWorksStudio/mLauncher/tree/1.4.9) - (09, April 2024)

### Implemented Enhancements:

- Added Search for Google, DuckDuckGo and Google Play Store - ([63eae1c](https://github.com/DroidWorksStudio/mLauncher/commit/63eae1c50e9435a9713d5da32da10bae00af12cc))
- Revamped the app context menu ([#438](https://github.com/DroidWorksStudio/mLauncher/issues/438)) - ([07952db](https://github.com/DroidWorksStudio/mLauncher/commit/07952dbab11e594c0ae74c94e3ac0ab153091a01))

### Bug Fixes:

- Fixed the fDroid app icon for next release. - ([82ba76b](https://github.com/DroidWorksStudio/mLauncher/commit/82ba76b61b53725f1c52346c9f07ea970bab7114))
- Added Quick Settings Bypass Back - ([50f9106](https://github.com/DroidWorksStudio/mLauncher/commit/50f9106787b294016c53c1fc2956132902853eb7))
- Updated Nerd Font - ([9335162](https://github.com/DroidWorksStudio/mLauncher/commit/9335162268a62a53ca677afe849367e4e936a0e7))

### Language Support:

- Updated Language Files. ([#437](https://github.com/DroidWorksStudio/mLauncher/issues/437)) - ([1d826d6](https://github.com/DroidWorksStudio/mLauncher/commit/1d826d6006e42a9dbba90c6a289501afe7c050eb))

## [1.4.8](https://github.com/DroidWorksStudio/mLauncher/tree/1.4.8) - (08, April 2024)

### Bug Fixes:

- Fixed the app list to not show duplicates when recent apps is enabled - ([1e8e037](https://github.com/DroidWorksStudio/mLauncher/commit/1e8e037ce0544538ae033e75b3f36b759b152e97))
- Fixed the backup system as it was not working. - ([554878b](https://github.com/DroidWorksStudio/mLauncher/commit/554878b3ec7482874a29d57c26be07b2b34c81cb))

## [1.4.7](https://github.com/DroidWorksStudio/mLauncher/tree/1.4.7) - (06, April 2024)

### Bug Fixes:

- Fixed RENAME from displaying in all list areas of the app. - ([5e8add8](https://github.com/DroidWorksStudio/mLauncher/commit/5e8add8240496d2ddd913f078efc2474ec1eea35))

### Language Support:

- Updated Language Files. ([#424](https://github.com/DroidWorksStudio/mLauncher/issues/424)) - ([dd4b374](https://github.com/DroidWorksStudio/mLauncher/commit/dd4b3741b111e561c50e5170199cff2bdd958f0e))

### Releases:

- Update the Release version to 147 (v1.4.7) - ([cc02343](https://github.com/DroidWorksStudio/mLauncher/commit/cc023438fd2bc11163c6ab97e6e5e09637bc9518))

## [1.4.6](https://github.com/DroidWorksStudio/mLauncher/tree/1.4.6) - (03, April 2024)

### Implemented Enhancements:

- Added Backup / Restore Feature - ([3837bfe](https://github.com/DroidWorksStudio/mLauncher/commit/3837bfe933477ba9ce824c564579b7a710b727f8))
- Added a home screen pager (disabled by default) - ([52a2a83](https://github.com/DroidWorksStudio/mLauncher/commit/52a2a83aa939590e91af2de86cedf906f295640d))

### Bug Fixes:

- Allow HomeScreen apps to be set to 0 - ([c7c5c4e](https://github.com/DroidWorksStudio/mLauncher/commit/c7c5c4e04810c9b309d8101a834e4fe9a2953052))

### Language Support:

- Updated Language Files. ([#419](https://github.com/DroidWorksStudio/mLauncher/issues/419)) - ([9c32a57](https://github.com/DroidWorksStudio/mLauncher/commit/9c32a57a9b59a571dab6df9563a4394ffd92bf08))
- Updated Language Files. ([#418](https://github.com/DroidWorksStudio/mLauncher/issues/418)) - ([9bb60d5](https://github.com/DroidWorksStudio/mLauncher/commit/9bb60d552eeae70886a564a57d82f87445828601))

### Documentation:

- Update CHANGELOG.md - ([d1343ee](https://github.com/DroidWorksStudio/mLauncher/commit/d1343ee010a08af7aee04732c214aab22da077f8))

### Refactoring:

- Cleaned up code adding permission request - ([666d2e7](https://github.com/DroidWorksStudio/mLauncher/commit/666d2e7d7f3520c2287673d1274bcc95b851de99))

## [1.4.5](https://github.com/DroidWorksStudio/mLauncher/tree/1.4.5) - (02, April 2024)

### Implemented Enhancements:

- Added `please_select_app` to the home screen apps ([#411](https://github.com/DroidWorksStudio/mLauncher/issues/411)) - ([3c22473](https://github.com/DroidWorksStudio/mLauncher/commit/3c2247301b988f9de3a01083b19b624c3dca8e3d))

### Bug Fixes:

- Fixed the reorder settings ([#416](https://github.com/DroidWorksStudio/mLauncher/issues/416)) - ([06ebd4a](https://github.com/DroidWorksStudio/mLauncher/commit/06ebd4a483a1e97b9dff58eeed9ebea2292b767d))
- Fix namespace for the project - ([3434ff3](https://github.com/DroidWorksStudio/mLauncher/commit/3434ff35d1da1c2f047fcda9a650f9ec134895ff))
- Fixed FUNDING.yml - ([edff6c2](https://github.com/DroidWorksStudio/mLauncher/commit/edff6c2a90e3d00b644442c9f670bbfc8faa5a2e))

### Chore:

- Update changelog.yml - ([4948ec8](https://github.com/DroidWorksStudio/mLauncher/commit/4948ec8db3ba701d6945174b13c032b8df35b0f7))
- Added App Details - ([26894e6](https://github.com/DroidWorksStudio/mLauncher/commit/26894e6c0e3af13d6af7fcc32aaa2ec49e1a9748))
- Changed App Icon - ([c5ba89f](https://github.com/DroidWorksStudio/mLauncher/commit/c5ba89f92e4cbe20914ee0429abc3f430f8fdcc8))
- Rename finder to FuzzyFinder - ([d650e2b](https://github.com/DroidWorksStudio/mLauncher/commit/d650e2b0c36aaa0a7485851ed001d0cf4901254f))

### Documentation:

- Update CHANGELOG.md - ([2fa9cce](https://github.com/DroidWorksStudio/mLauncher/commit/2fa9cce971c5e8b26c655beea31d008e5245f887))

### Releases:

- Update the Release version to 145 (v1.4.5) - ([9212a94](https://github.com/DroidWorksStudio/mLauncher/commit/9212a9485fb5dba0e6bde9de5452202f14a18353))
- Update the Release version to 144 (v1.4.4) - ([603a5fe](https://github.com/DroidWorksStudio/mLauncher/commit/603a5fee1a45976fc49445fdf2902a4be2a705ff))

## [1.4.3](https://github.com/DroidWorksStudio/mLauncher/tree/1.4.3) - (24, March 2024)

### Bug Fixes:

- Bug fix/fixed the swipe gestures ([#392](https://github.com/DroidWorksStudio/mLauncher/issues/392)) - ([1da6e7f](https://github.com/DroidWorksStudio/mLauncher/commit/1da6e7ffa18800602ad5b228b389b88e5e47a7f8))

### Feature Removal:

- Remove Junk Depends - ([ee96bcd](https://github.com/DroidWorksStudio/mLauncher/commit/ee96bcdc588fa36e60776210833f64b7865c2024))
- Removed Backup/Restore - ([749f4f0](https://github.com/DroidWorksStudio/mLauncher/commit/749f4f0c5b345da87ceb2e886e703e36dc0703d6))

## [1.4.1](https://github.com/DroidWorksStudio/mLauncher/tree/1.4.1) - (21, March 2024)

### Feature Removal:

- Removed Clean from variable name - ([0d524d7](https://github.com/DroidWorksStudio/mLauncher/commit/0d524d750737046e71df52ea09bcea5d067e0c1e))
- Removed the need for extra variable that wasn't needed and cleaned up some others - ([0d524d7](https://github.com/DroidWorksStudio/mLauncher/commit/0d524d750737046e71df52ea09bcea5d067e0c1e))
- Remove Annoying Icon - ([ac6735b](https://github.com/DroidWorksStudio/mLauncher/commit/ac6735b143d1aa1f9c38d1a94fde12ebd25a7974))

## [1.3.4](https://github.com/DroidWorksStudio/mLauncher/tree/1.3.4) - (17, March 2024)

### Versioning:

- Version - ([ac7d27d](https://github.com/DroidWorksStudio/mLauncher/commit/ac7d27ddc477ec0fce5db1077beaf1dab9fe3ceb))

## [1.3.3](https://github.com/DroidWorksStudio/mLauncher/tree/1.3.3) - (09, March 2024)

### Releases:

- Release/1.3.3 ([#356](https://github.com/DroidWorksStudio/mLauncher/issues/356)) - ([67e2d34](https://github.com/DroidWorksStudio/mLauncher/commit/67e2d34798171eaa7453c6a085a97f9cf4d24f3e))

## [1.3.2](https://github.com/DroidWorksStudio/mLauncher/tree/1.3.2) - (05, March 2024)

### Bug Fixes:

- Fixed Languages For Breaking - ([6312071](https://github.com/DroidWorksStudio/mLauncher/commit/63120716c96706563323108716f9522c15a084dd))
- Fixed Latin - ([ccc704b](https://github.com/DroidWorksStudio/mLauncher/commit/ccc704bf0c6f4b2ace02b5206696428a979367ad))

## [1.3.1](https://github.com/DroidWorksStudio/mLauncher/tree/1.3.1) - (05, March 2024)

### Bug Fixes:

- Fixed Languages - ([fc6e0ae](https://github.com/DroidWorksStudio/mLauncher/commit/fc6e0ae4a76f5b082033ce8e7365ce03252bc17e))
- Fixed the Accent color all apps header ([#338](https://github.com/DroidWorksStudio/mLauncher/issues/338)) - ([94d66ee](https://github.com/DroidWorksStudio/mLauncher/commit/94d66eea62a0b047d1f0187e18e569a35c69bedc))
- Fixed the title of app apps when accent color is disabled. ([#337](https://github.com/DroidWorksStudio/mLauncher/issues/337)) - ([0d63f38](https://github.com/DroidWorksStudio/mLauncher/commit/0d63f38574641918d75d96d53ec771704902a8c9))

## [1.3.0](https://github.com/DroidWorksStudio/mLauncher/tree/1.3.0) - (02, March 2024)

### Bug Fixes:

- Fixed Accent Color for "All apps" in app drawer  ([#333](https://github.com/DroidWorksStudio/mLauncher/issues/333)) - ([2c90a1c](https://github.com/DroidWorksStudio/mLauncher/commit/2c90a1c7999b062d164d04e467d4b71f99ad3546))
- Fixed closing issues - ([c8528d3](https://github.com/DroidWorksStudio/mLauncher/commit/c8528d3d6e690a118ebd6320db7b0f89c067531b))
- Fixed DateTime formatting - ([167674b](https://github.com/DroidWorksStudio/mLauncher/commit/167674be75c8194c641ad9e8b572f71208ec724a))

### Releases:

- Release 1.3.0 ([#335](https://github.com/DroidWorksStudio/mLauncher/issues/335)) - ([fac3213](https://github.com/DroidWorksStudio/mLauncher/commit/fac3213fe9c053c29f13bc3a3f4edc2f0d263841))

## [1.2.1](https://github.com/DroidWorksStudio/mLauncher/tree/1.2.1) - (23, July 2023)

### Bug Fixes:

- Fixed formatting - ([2ff310e](https://github.com/DroidWorksStudio/mLauncher/commit/2ff310ebe638d7712d1eeddcb2b5d6d101e39cd3))
- Fix the Font - ([b85f81d](https://github.com/DroidWorksStudio/mLauncher/commit/b85f81d509e33921259573e6d6ac65d08920f9b8))

### Releases:

- Update version to 66 (v1.2.1) ([#296](https://github.com/DroidWorksStudio/mLauncher/issues/296)) - ([39aae05](https://github.com/DroidWorksStudio/mLauncher/commit/39aae05e8847bf71fb0329028c684e6b9d5d2730))

## [1.2.0](https://github.com/DroidWorksStudio/mLauncher/tree/1.2.0) - (14, July 2023)

### Bug Fixes:

- Fixed other EN Languages - ([b3dbed0](https://github.com/DroidWorksStudio/mLauncher/commit/b3dbed0cb6bb37cced1244a555a1b3ef4bd3e639))

### Releases:

- Update version to 65 (v1.2.0) ([#290](https://github.com/DroidWorksStudio/mLauncher/issues/290)) - ([749a2ff](https://github.com/DroidWorksStudio/mLauncher/commit/749a2ffb20915fc767687abc0b7ed702bf6b71ea))

## [1.1.2](https://github.com/DroidWorksStudio/mLauncher/tree/1.1.2) - (08, July 2023)

### Bug Fixes:

- Fixed the README (no need for a PR) - ([2422aae](https://github.com/DroidWorksStudio/mLauncher/commit/2422aae87df5b6ddedc3547305a42354b4643dd3))

### Releases:

- Update version to 64 (v1.1.2) ([#285](https://github.com/DroidWorksStudio/mLauncher/issues/285)) - ([4111ea7](https://github.com/DroidWorksStudio/mLauncher/commit/4111ea70b5a2e30f8fc2209f9dc17b48a82d25e0))

## [1.1.1](https://github.com/DroidWorksStudio/mLauncher/tree/1.1.1) - (27, June 2023)

### Bug Fixes:

- Fixed the Logic for FuzzyWuzzy ([#277](https://github.com/DroidWorksStudio/mLauncher/issues/277)) - ([02521ce](https://github.com/DroidWorksStudio/mLauncher/commit/02521ce04690cd3810c3df9fac1fd3e7565554e6))

### Language Support:

- Language Support - ([cd25747](https://github.com/DroidWorksStudio/mLauncher/commit/cd2574719ba159f183e5c2656f864118e4b8132e))

### Releases:

- Release/v63 ([#278](https://github.com/DroidWorksStudio/mLauncher/issues/278)) - ([70a08df](https://github.com/DroidWorksStudio/mLauncher/commit/70a08df1fb8c988e999ff2c8b07f8a3e13dcb2b5))

## [1.1.0](https://github.com/DroidWorksStudio/mLauncher/tree/1.1.0) - (26, June 2023)

### Implemented Enhancements:

- Updated the logic for the app search. ([#273](https://github.com/DroidWorksStudio/mLauncher/issues/273)) - ([20b2a5d](https://github.com/DroidWorksStudio/mLauncher/commit/20b2a5d80e2f300b575d340823ae6207dade8e1f))

### Releases:

- Update version to 62 (v1.1.0) ([#272](https://github.com/DroidWorksStudio/mLauncher/issues/272)) - ([ef5d6e6](https://github.com/DroidWorksStudio/mLauncher/commit/ef5d6e66a1a525c3632d3e8e736b43712d57588e))

## [1.0.1](https://github.com/DroidWorksStudio/mLauncher/tree/1.0.1) - (11, April 2023)

### Implemented Enhancements:

- Auto open apps with spaces in name ([#251](https://github.com/DroidWorksStudio/mLauncher/issues/251)) - ([4b96648](https://github.com/DroidWorksStudio/mLauncher/commit/4b96648220b2fb7ebd02137a47661fd88a4c1e77))

### Feature Removal:

- Remove Junk - ([e86306e](https://github.com/DroidWorksStudio/mLauncher/commit/e86306ee0419b46cf4cee688569c9f1ddea93117))

### Releases:

- Update version to 61 (v1.0.1) ([#265](https://github.com/DroidWorksStudio/mLauncher/issues/265)) - ([ca9966d](https://github.com/DroidWorksStudio/mLauncher/commit/ca9966d1d8fb814c2ac4eb5077594f30fd204b0c))

## [1.0.0](https://github.com/DroidWorksStudio/mLauncher/tree/1.0.0) - (14, March 2023)

### Bug Fixes:

- Fixed the accent colors toggle for app draw ([#243](https://github.com/DroidWorksStudio/mLauncher/issues/243)) - ([85e22e6](https://github.com/DroidWorksStudio/mLauncher/commit/85e22e6ab3ed0e7a94f1dba78f4076a6489e18fe))

### Releases:

- Update version to 60 (v1.0.0) ([#244](https://github.com/DroidWorksStudio/mLauncher/issues/244)) - ([e1a9ec4](https://github.com/DroidWorksStudio/mLauncher/commit/e1a9ec458bbe70a2e0550860815bc79f9620c356))

## [0.5.9](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.9) - (11, March 2023)

### Bug Fixes:

- Fix the locked screen when no pass set ([#238](https://github.com/DroidWorksStudio/mLauncher/issues/238)) - ([1c47916](https://github.com/DroidWorksStudio/mLauncher/commit/1c47916ef1a3717641283617050b9d0c45abd12c))

### Releases:

- Update version to 59 (v0.5.9) ([#239](https://github.com/DroidWorksStudio/mLauncher/issues/239)) - ([aae3ac8](https://github.com/DroidWorksStudio/mLauncher/commit/aae3ac80b7257dc23cef418f5ab66a0d4abd95f6))

## [0.5.8](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.8) - (09, March 2023)

### Implemented Enhancements:

- System accent color & font for app drawer ([#233](https://github.com/DroidWorksStudio/mLauncher/issues/233)) - ([11abb98](https://github.com/DroidWorksStudio/mLauncher/commit/11abb98b2ecabc20863a0f14207ed273f6504b4e))
- Doubled the number of apps on the homescreen ([#232](https://github.com/DroidWorksStudio/mLauncher/issues/232)) - ([078fc26](https://github.com/DroidWorksStudio/mLauncher/commit/078fc26774f762d3f1a0b143bd5f4101e3adb64f))

### Releases:

- Update version to 58 (v0.5.8) ([#234](https://github.com/DroidWorksStudio/mLauncher/issues/234)) - ([bbb04a6](https://github.com/DroidWorksStudio/mLauncher/commit/bbb04a66ae355152cf98302e3dd572ec6a52caa5))

## [0.5.7](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.7) - (01, March 2023)

### Implemented Enhancements:

- Update the lock screen. ([#228](https://github.com/DroidWorksStudio/mLauncher/issues/228)) - ([73aa62b](https://github.com/DroidWorksStudio/mLauncher/commit/73aa62bef21a324d0c6e8284c365ed585e3eaed5))

### Bug Fixes:

- Fixed app alignment ([#226](https://github.com/DroidWorksStudio/mLauncher/issues/226)) - ([6ec501b](https://github.com/DroidWorksStudio/mLauncher/commit/6ec501b473778ee1fdec55ebcf4bd69618846fd4))

### Releases:

- Update version to 57 (v0.5.7) ([#227](https://github.com/DroidWorksStudio/mLauncher/issues/227)) - ([b77f8ac](https://github.com/DroidWorksStudio/mLauncher/commit/b77f8ac4911376e50572d592918f2b80ef69bf14))

## [0.5.6](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.6) - (26, February 2023)

### Bug Fixes:

- Fixed - ([5c5e058](https://github.com/DroidWorksStudio/mLauncher/commit/5c5e0581242339f3e09328a9824fb22d601b8452))
- Fixed the Settings ([#221](https://github.com/DroidWorksStudio/mLauncher/issues/221)) - ([0213db3](https://github.com/DroidWorksStudio/mLauncher/commit/0213db39e78a4686530ac7d7d83d468290e760ca))

### Releases:

- Update version to 56 (v0.5.6) ([#222](https://github.com/DroidWorksStudio/mLauncher/issues/222)) - ([4325602](https://github.com/DroidWorksStudio/mLauncher/commit/4325602cd3c81e8127c383108a269e0107eae416))

## [0.5.5](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.5) - (21, February 2023)

### Bug Fixes:

- Fixed incorrect preference assignment ([#215](https://github.com/DroidWorksStudio/mLauncher/issues/215)) - ([356df51](https://github.com/DroidWorksStudio/mLauncher/commit/356df51e22ac0a3fb58aea18cdd909ffa98df3c6))

## [0.5.4](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.4) - (16, February 2023)

### Bug Fixes:

- Fixed a bug that crashes on battery monitor ([#211](https://github.com/DroidWorksStudio/mLauncher/issues/211)) - ([766a3e1](https://github.com/DroidWorksStudio/mLauncher/commit/766a3e1ef4778b0f1ec883c3af37867fd9c307c8))

### Releases:

- App version bumped to 54 (v0.5.4) ([#212](https://github.com/DroidWorksStudio/mLauncher/issues/212)) - ([ebd4eee](https://github.com/DroidWorksStudio/mLauncher/commit/ebd4eee69ddcb2cdb0b02f3c411497080306876f))

## [0.5.3](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.3) - (13, February 2023)

### Bug Fixes:

- Fix a crash releated to loading the base app - ([585f157](https://github.com/DroidWorksStudio/mLauncher/commit/585f157ccafeec025066e764f638c36a0b46806c))
- Bug/fix colors and layout for pin screen ([#204](https://github.com/DroidWorksStudio/mLauncher/issues/204)) - ([9179bc1](https://github.com/DroidWorksStudio/mLauncher/commit/9179bc17f464d5f0331a1cbfa3d57c52ba47192b))
- Bug/fix the battery percent from not updating ([#203](https://github.com/DroidWorksStudio/mLauncher/issues/203)) - ([055538a](https://github.com/DroidWorksStudio/mLauncher/commit/055538ad267d45498216b25a401020546fc7071d))

## [0.5.1](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.1) - (06, February 2023)

### Implemented Enhancements:

- Added a toggle to use the custom icon font ([#186](https://github.com/DroidWorksStudio/mLauncher/issues/186)) - ([ec76ca7](https://github.com/DroidWorksStudio/mLauncher/commit/ec76ca77f01287a00d959bcac8bfeee2d7fd11a1))

### Bug Fixes:

- Fix Settings for Icon Font ([#192](https://github.com/DroidWorksStudio/mLauncher/issues/192)) - ([43a89fd](https://github.com/DroidWorksStudio/mLauncher/commit/43a89fdfd9c04e4e77158a00eaf1e6cd6bfa7724))

### Reverts:

- Revert "Update release-drafter.yml" - ([15dd6b0](https://github.com/DroidWorksStudio/mLauncher/commit/15dd6b04c9ba38ab863eadb620a44a6d66188796))

### Releases:

- Release.tml - ([fbc4a9a](https://github.com/DroidWorksStudio/mLauncher/commit/fbc4a9a9c0f202fe19f438f4ad60bae63d6f02fc))

## [0.5.0](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.0) - (24, January 2023)

### Implemented Enhancements:

- Fix the display for the battery usage ([#184](https://github.com/DroidWorksStudio/mLauncher/issues/184)) - ([085ba3c](https://github.com/DroidWorksStudio/mLauncher/commit/085ba3c82d120ec9ca07e08eb6e0f30e6df3111f))

## [0.4.9](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.9) - (23, January 2023)

### Implemented Enhancements:

- Make padding home apps apply to app draw too ([#173](https://github.com/DroidWorksStudio/mLauncher/issues/173)) - ([8125119](https://github.com/DroidWorksStudio/mLauncher/commit/8125119fbf0c484c41300d3855418efb138bd668))

### Bug Fixes:

- Fix fontsize that I had commented out - ([ebdb4da](https://github.com/DroidWorksStudio/mLauncher/commit/ebdb4dabee0cc4e789b07659bd2c7c5c5aa969ec))

## [0.4.7](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.7) - (16, January 2023)

### Implemented Enhancements:

- Padding for apps on homescreen ([#169](https://github.com/DroidWorksStudio/mLauncher/issues/169)) - ([c353836](https://github.com/DroidWorksStudio/mLauncher/commit/c3538368cdc9d4477171933d474d6bf1e8fab175))

## [0.4.6](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.6) - (14, January 2023)

### Implemented Enhancements:

- Filter application results start ([#166](https://github.com/DroidWorksStudio/mLauncher/issues/166)) - ([fe3d7bb](https://github.com/DroidWorksStudio/mLauncher/commit/fe3d7bbe04d548dcb26ff9f9d3f66f3a3c0cf373))
- Removed the roadmap link ([#162](https://github.com/DroidWorksStudio/mLauncher/issues/162)) - ([7e40236](https://github.com/DroidWorksStudio/mLauncher/commit/7e40236c901b3cbc0016afc475c54100df911f40))

### Bug Fixes:

- Just a few layout fixes - ([8fd0f08](https://github.com/DroidWorksStudio/mLauncher/commit/8fd0f08d4bd12afebe48d8e0c256a6a2fa81af25))

### Documentation:

- Docs Added. - ([c8f1464](https://github.com/DroidWorksStudio/mLauncher/commit/c8f1464efaf3063713890d613cfbbfdeb78702a2))

## [0.4.5](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.5) - (08, January 2023)

### Implemented Enhancements:

- Feature/more friendly colors ([#159](https://github.com/DroidWorksStudio/mLauncher/issues/159)) - ([4f3d4b1](https://github.com/DroidWorksStudio/mLauncher/commit/4f3d4b105d98cd9c1ff3009d4cdeab5cfd47181e))

### Bug Fixes:

- Fix the README - ([5b01de9](https://github.com/DroidWorksStudio/mLauncher/commit/5b01de924704e2529c7a9e03b78163a880270481))
- Fix text size... - ([9e7b096](https://github.com/DroidWorksStudio/mLauncher/commit/9e7b096ccb4c74267f41a6c685b9ce00bef8c02d))

## [0.4.4](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.4) - (05, January 2023)

### Bug Fixes:

- Work on the icons to make them look better. ([#155](https://github.com/DroidWorksStudio/mLauncher/issues/155)) - ([383b5df](https://github.com/DroidWorksStudio/mLauncher/commit/383b5df26e7810781e04871ecd0146c45855cc75))

### Feature Removal:

- Remove leftover import - ([432b3a0](https://github.com/DroidWorksStudio/mLauncher/commit/432b3a0c660bed693947da313af2abc39332cfa9))

### Releases:

- Release 0.4.4 - ([c116020](https://github.com/DroidWorksStudio/mLauncher/commit/c1160202ce8f955afba87023472650e2767c7a04))

## [0.4.3](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.3) - (03, January 2023)

### Implemented Enhancements:

- Added more swipe actions. ([#144](https://github.com/DroidWorksStudio/mLauncher/issues/144)) - ([1cf6b2f](https://github.com/DroidWorksStudio/mLauncher/commit/1cf6b2f1abcdeed556b9a12fde2c4841183b6656))

### Bug Fixes:

- Fixed slider bar to be off by 1 if too close. - ([7b02b16](https://github.com/DroidWorksStudio/mLauncher/commit/7b02b160ba29c5140e2f82e17c8280e43aa8a8b7))
- Fixed font and backup. - ([9c5a0d6](https://github.com/DroidWorksStudio/mLauncher/commit/9c5a0d649553d00247e2623dd3749a7c2e0d0f3d))
- Fixed backups - ([36791a5](https://github.com/DroidWorksStudio/mLauncher/commit/36791a52ad508857c3991b187dd45a3103e22f2d))
- Fixed the README - ([1caf33a](https://github.com/DroidWorksStudio/mLauncher/commit/1caf33a720ed03cf1fc35e86e9319187dcf87b07))
- File structure renaming and added sliders ([#137](https://github.com/DroidWorksStudio/mLauncher/issues/137)) - ([b0168a5](https://github.com/DroidWorksStudio/mLauncher/commit/b0168a5ac154ed628c6dfa126b2c43d4f86aab13))
- Fixed slider and font size. ([#136](https://github.com/DroidWorksStudio/mLauncher/issues/136)) - ([a179fde](https://github.com/DroidWorksStudio/mLauncher/commit/a179fde5fdbd511be94cdf775d12c10ff7540eb1))

## [0.4.2](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.2) - (30, December 2022)

### Bug Fixes:

- Fixes the other fragments opacity ([#132](https://github.com/DroidWorksStudio/mLauncher/issues/132)) - ([620c9f7](https://github.com/DroidWorksStudio/mLauncher/commit/620c9f72a218001fd42b1080c32c6cf6ecad8245))

### Code Cleanup:

- Fix some code for opacity ([#130](https://github.com/DroidWorksStudio/mLauncher/issues/130)) - ([1e17fa2](https://github.com/DroidWorksStudio/mLauncher/commit/1e17fa2d69c03f5119ab51fccd49603d28d6ef2e))

## [0.4.1](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.1) - (30, December 2022)

### Implemented Enhancements:

- Add the ability to change opacity of overlay ([#125](https://github.com/DroidWorksStudio/mLauncher/issues/125)) - ([b26aa4e](https://github.com/DroidWorksStudio/mLauncher/commit/b26aa4e5988c04d5207ae41afbacdd7313a94915))

### Bug Fixes:

- Fix the README.md - ([d7793aa](https://github.com/DroidWorksStudio/mLauncher/commit/d7793aa820f3ef167171c37585139a87787b42ed))

### Code Cleanup:

- Just some basic cleanup to the codebase - ([f770ec0](https://github.com/DroidWorksStudio/mLauncher/commit/f770ec0070212f0d9b050c4e52df414a99d4c757))

### Reverts:

- Revert back to java folder as kotlin breaks - ([b0ab5c7](https://github.com/DroidWorksStudio/mLauncher/commit/b0ab5c703b4f3715ea3e18e8a5dad099d24bf168))

## [0.4.0](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.0) - (28, December 2022)

### Implemented Enhancements:

- Added custom font size for settings ([#116](https://github.com/DroidWorksStudio/mLauncher/issues/116)) - ([02958c5](https://github.com/DroidWorksStudio/mLauncher/commit/02958c54d5dac1d26a41f8ebfd23a44e0b6b9226))

### Feature Removal:

- Removed "app_name" from the rest of the languages - ([f835783](https://github.com/DroidWorksStudio/mLauncher/commit/f8357838c9b8931dc9906252dd0b5b261e4a322b))
- Removed unneeded dependencies - ([8205cb5](https://github.com/DroidWorksStudio/mLauncher/commit/8205cb5342f22253ce2b3d595df9dbd1015383b7))

### Reverts:

- Revert "Update Templates" - ([e0b5524](https://github.com/DroidWorksStudio/mLauncher/commit/e0b5524a4be26869434841994a33233ac7667bf5))
- Revert "Code Cleanup" - ([f5d129f](https://github.com/DroidWorksStudio/mLauncher/commit/f5d129f6c68b6dae2ccfdad4349f597b3e792287))

## [0.3.8](https://github.com/DroidWorksStudio/mLauncher/tree/0.3.8) - (25, December 2022)

### Implemented Enhancements:

- Put settings items on two rows ([#104](https://github.com/DroidWorksStudio/mLauncher/issues/104)) - ([8c746be](https://github.com/DroidWorksStudio/mLauncher/commit/8c746be7a57f015af538b0da05dedf945d1495b5))
- Resize the font in the settings ([#107](https://github.com/DroidWorksStudio/mLauncher/issues/107)) - ([4918a6d](https://github.com/DroidWorksStudio/mLauncher/commit/4918a6dc119163f92f26fcc4656e99d65049063a))

### Bug Fixes:

- Fixed to build - ([c55f89c](https://github.com/DroidWorksStudio/mLauncher/commit/c55f89cc51f778f340242e5776e0c0166e95cb77))
- Updated the Changelog - ([1751b3d](https://github.com/DroidWorksStudio/mLauncher/commit/1751b3dc051569b5b14b7d3905b25c953fb6803a))
- Fixed the link to the roadmap ([#110](https://github.com/DroidWorksStudio/mLauncher/issues/110)) - ([a0afb7a](https://github.com/DroidWorksStudio/mLauncher/commit/a0afb7a37a514ad2753e247d453db0e3e5e06324))
- Fix some of the readme file. ([#108](https://github.com/DroidWorksStudio/mLauncher/issues/108)) - ([a61a53f](https://github.com/DroidWorksStudio/mLauncher/commit/a61a53f6755149b8567a8d162cd2d8e678906233))
- Fixed the local to use from system settings ([#106](https://github.com/DroidWorksStudio/mLauncher/issues/106)) - ([49640bb](https://github.com/DroidWorksStudio/mLauncher/commit/49640bb6877a8efd668e505273c5c2e0a7e96719))
- Fixed the language file for base en ([#103](https://github.com/DroidWorksStudio/mLauncher/issues/103)) - ([1e78f58](https://github.com/DroidWorksStudio/mLauncher/commit/1e78f585c22f32fbc33bd33140f7fc379e345207))

## [0.3.7](https://github.com/DroidWorksStudio/mLauncher/tree/0.3.7) - (23, December 2022)

### Bug Fixes:

- Fixing an error with the intent swipes ([#99](https://github.com/DroidWorksStudio/mLauncher/issues/99)) - ([d45e2c2](https://github.com/DroidWorksStudio/mLauncher/commit/d45e2c2a59066ad9d955aada2b5d1c5ed3aa8c81))
- Fix the french language string.xml ([#94](https://github.com/DroidWorksStudio/mLauncher/issues/94)) - ([318af22](https://github.com/DroidWorksStudio/mLauncher/commit/318af2246afd2d984198fcd192a2db95005872e1))
- Fix the OPEN to follow the language ([#91](https://github.com/DroidWorksStudio/mLauncher/issues/91)) - ([23cce1b](https://github.com/DroidWorksStudio/mLauncher/commit/23cce1b6702fd55498c64d5a5d1d45a2f7347d66))

### Code Cleanup:

- Cleanup the Settings panel. ([#97](https://github.com/DroidWorksStudio/mLauncher/issues/97)) - ([fdcf83d](https://github.com/DroidWorksStudio/mLauncher/commit/fdcf83d54a163ba26402d6910dbe59405e10869e))

## [0.3.6](https://github.com/DroidWorksStudio/mLauncher/tree/0.3.6) - (22, December 2022)

### Bug Fixes:

- Fix Contributing ([#88](https://github.com/DroidWorksStudio/mLauncher/issues/88)) - ([885bafd](https://github.com/DroidWorksStudio/mLauncher/commit/885bafdf701149160fe6976b5c7cc0c95e885afe))
- Fix file ([#86](https://github.com/DroidWorksStudio/mLauncher/issues/86)) - ([9e7eeaf](https://github.com/DroidWorksStudio/mLauncher/commit/9e7eeaf68c647cef03b5eb648662038d82335cf4))
- Fix italian string ([#79](https://github.com/DroidWorksStudio/mLauncher/issues/79)) - ([dcdab10](https://github.com/DroidWorksStudio/mLauncher/commit/dcdab10f1fed2f28f637076eb482021fd1a8ab4b))
- Fix some typos ([#74](https://github.com/DroidWorksStudio/mLauncher/issues/74)) - ([9aa5515](https://github.com/DroidWorksStudio/mLauncher/commit/9aa5515b4208a21b5c13a400b8bc461e937e2316))
- Fixed Actions ([#70](https://github.com/DroidWorksStudio/mLauncher/issues/70)) - ([2e32f9e](https://github.com/DroidWorksStudio/mLauncher/commit/2e32f9eaacc7b43d5eed7b9a1b40832ced7c267f))
- Fix French CDATA ([#68](https://github.com/DroidWorksStudio/mLauncher/issues/68)) - ([cc11e07](https://github.com/DroidWorksStudio/mLauncher/commit/cc11e07c6435b8246356afd8ce3084ae522134ae))
- FixedMax ([#63](https://github.com/DroidWorksStudio/mLauncher/issues/63)) - ([eed80dc](https://github.com/DroidWorksStudio/mLauncher/commit/eed80dc40773d96332616201f765d78da189b732))

### Code Cleanup:

- Cleanup ([#59](https://github.com/DroidWorksStudio/mLauncher/issues/59)) - ([c90f88b](https://github.com/DroidWorksStudio/mLauncher/commit/c90f88bf9b4a3a34d4585c789b21bea76c806e48))

## [0.3.5](https://github.com/DroidWorksStudio/mLauncher/tree/0.3.5) - (19, December 2022)

### Implemented Enhancements:

- *(german)* Update german string ([#175](https://github.com/DroidWorksStudio/mLauncher/issues/175)) - ([6c2dfbb](https://github.com/DroidWorksStudio/mLauncher/commit/6c2dfbbabeb104c255b6ed1cd53000e79967f3af))
- *(permission)* Remove internet permisisons, and everything that needed it - ([594de90](https://github.com/DroidWorksStudio/mLauncher/commit/594de9025290d29612102544e36636e440ad6432))
- *(translation)* Manually select language - ([f654519](https://github.com/DroidWorksStudio/mLauncher/commit/f65451926d98b67fb908cc62f658f9b9e5f993b2))
- Add toggle for "open apps automatically" ([#53](https://github.com/DroidWorksStudio/mLauncher/issues/53)) - ([f2f20e2](https://github.com/DroidWorksStudio/mLauncher/commit/f2f20e2251033760144fe05e3ec937d34ce827f9))
- Replace some texts with images, enable uninstall of apps throug… ([#204](https://github.com/DroidWorksStudio/mLauncher/issues/204)) - ([aea3e83](https://github.com/DroidWorksStudio/mLauncher/commit/aea3e837c0adbd099f4369e24f1b6bd970fd7646))
- Implement #102 ([#160](https://github.com/DroidWorksStudio/mLauncher/issues/160)) - ([e021915](https://github.com/DroidWorksStudio/mLauncher/commit/e0219152c1d0fa2c7a37e56f7f201089169498d3))
- Implements #82 ([#136](https://github.com/DroidWorksStudio/mLauncher/issues/136)) - ([6eb9b30](https://github.com/DroidWorksStudio/mLauncher/commit/6eb9b30b1bec233c844d56589a91f303d5af9f4d))
- Add korean to settings - ([415ff69](https://github.com/DroidWorksStudio/mLauncher/commit/415ff69ce953d83f82f9ad53879b7ecaad79e70a))
- Toggle date and time independently ([#88](https://github.com/DroidWorksStudio/mLauncher/issues/88)) - ([9b781d7](https://github.com/DroidWorksStudio/mLauncher/commit/9b781d75b18746a743b5e9d11ad223ca03218b7c))
- Changelogs for v9 - ([65117bd](https://github.com/DroidWorksStudio/mLauncher/commit/65117bda6932e0a0de8781c5e3cfb15d0e521b54))
- Option to set language from system settings - ([1d3b165](https://github.com/DroidWorksStudio/mLauncher/commit/1d3b1657d410488efd4a9afce88e885b9ff38a49))
- Option to set language from system settings - ([1426765](https://github.com/DroidWorksStudio/mLauncher/commit/14267658bd6eee2c9b655590b6cab4e6d15c7046))
- List hidden apps - ([17c8faf](https://github.com/DroidWorksStudio/mLauncher/commit/17c8fafbe85f8bb6951a0043d6e0f52ea7733752))
- Change text size - ([90a76b7](https://github.com/DroidWorksStudio/mLauncher/commit/90a76b7d230e491339cfb73ee34637a070905620))

### Bug Fixes:

- *(homescreen)* Place apps that are only in work profile on home screen ([#188](https://github.com/DroidWorksStudio/mLauncher/issues/188)) - ([d495796](https://github.com/DroidWorksStudio/mLauncher/commit/d495796b22633d44dc19d0aa6712efe784bd90d6))
- *(homescreen)* This fixes the homescreen alignment bug ([#185](https://github.com/DroidWorksStudio/mLauncher/issues/185)), while also being a general code improvement commit ([#187](https://github.com/DroidWorksStudio/mLauncher/issues/187)) - ([f8f6a69](https://github.com/DroidWorksStudio/mLauncher/commit/f8f6a69f7c4f7998ef1e176347ed520e0215545e))
- *(landscape)* Add language menu to landscape layout xml - ([712e6da](https://github.com/DroidWorksStudio/mLauncher/commit/712e6da89a48d40941de5494bc121eb7d4692233))
- *(settings)* Language list doubled - ([72b563d](https://github.com/DroidWorksStudio/mLauncher/commit/72b563d4ab1001d0ddc2f1afa9712818cc6d3e24))
- Fix a few actions ([#54](https://github.com/DroidWorksStudio/mLauncher/issues/54)) - ([99a4e0a](https://github.com/DroidWorksStudio/mLauncher/commit/99a4e0afdffdea31fbb4ac13a824af1b875abb55))
- Fix Translations ([#47](https://github.com/DroidWorksStudio/mLauncher/issues/47)) - ([027d40c](https://github.com/DroidWorksStudio/mLauncher/commit/027d40cd7ec061eb06e346ba96fb038d916216c5))
- Fix app draw - ([ac94305](https://github.com/DroidWorksStudio/mLauncher/commit/ac9430558aa7108d0f72a891205dbb77fac5c357))
- Not reundant ([#21](https://github.com/DroidWorksStudio/mLauncher/issues/21)) - ([887ad38](https://github.com/DroidWorksStudio/mLauncher/commit/887ad3818e3b1f32cf8c07d0f1a63c3deacbd771))
- Fix the bug from swiping apps ([#3](https://github.com/DroidWorksStudio/mLauncher/issues/3)) - ([6f60a21](https://github.com/DroidWorksStudio/mLauncher/commit/6f60a2171ccc0f7f20ba9710d123b5b0dc841037))
- Fix the Swiping ([#2](https://github.com/DroidWorksStudio/mLauncher/issues/2)) - ([656d4df](https://github.com/DroidWorksStudio/mLauncher/commit/656d4dfccc0cd402953ff673fc6838e30b325158))
- Fix the swipe apps - ([5079656](https://github.com/DroidWorksStudio/mLauncher/commit/5079656d74d47216b4be01dcabb60bd61800537a))
- Fix the README file - ([8c176f3](https://github.com/DroidWorksStudio/mLauncher/commit/8c176f30d86e63ec5b440451d34087b0e02b7594))
- Fix the swipe down app menu - ([692491c](https://github.com/DroidWorksStudio/mLauncher/commit/692491c698cbd52861da564a5f842744b11b52e1))
- Fixed settings - ([5deff32](https://github.com/DroidWorksStudio/mLauncher/commit/5deff32c74d3a509c95a2261d52d587ce0ed164f))
- #209 - ([ab295f4](https://github.com/DroidWorksStudio/mLauncher/commit/ab295f4b645c63fae682c39f85ff9acef3798a77))
- Text size in settings - ([dcf080e](https://github.com/DroidWorksStudio/mLauncher/commit/dcf080eba5aec0e27abbef253a75b3e5d96545ac))
- Work icon size and work icon position - ([04a4729](https://github.com/DroidWorksStudio/mLauncher/commit/04a47294000db09f5555a5bd5f8f0ad46a21cf43))
- Version number - ([1520ad9](https://github.com/DroidWorksStudio/mLauncher/commit/1520ad96bacd08c1a8f8562fa8e5a119e14bcf27))
- Set app name right when it is added to the home screen, not just at showing the fragment ([#202](https://github.com/DroidWorksStudio/mLauncher/issues/202)) - ([5988591](https://github.com/DroidWorksStudio/mLauncher/commit/59885911118d59b9d0b04b9145d81bf28683f50c))
- Set swipe right app - ([9bbda9a](https://github.com/DroidWorksStudio/mLauncher/commit/9bbda9a57e569e17b0aca7c2ae9f45536d143b95))
- #172 - ([f61fdcc](https://github.com/DroidWorksStudio/mLauncher/commit/f61fdcc21e06715d2eb364b672bed637a41d2d07))
- Move 'backToHomeScreen()' to onResume to not show home shortly before opening an app - ([19b970a](https://github.com/DroidWorksStudio/mLauncher/commit/19b970a8764f7c50fc631090626a0393149991f7))
- German translation ([#191](https://github.com/DroidWorksStudio/mLauncher/issues/191)) - ([9b2f652](https://github.com/DroidWorksStudio/mLauncher/commit/9b2f652c47d505dd204668337d7d99cb8a3d6923))
- Remove non-free dependencies - ([6d46b76](https://github.com/DroidWorksStudio/mLauncher/commit/6d46b76ec41dbea60f5b518092be6503248ff58d))
- Home alignment when click area is exetended ([#176](https://github.com/DroidWorksStudio/mLauncher/issues/176)) - ([933c050](https://github.com/DroidWorksStudio/mLauncher/commit/933c050644795bd2e92b654c6b856b642809549f))
- Swipe app names black if not set - ([19cb6b7](https://github.com/DroidWorksStudio/mLauncher/commit/19cb6b712a1fc0275de16cfa7718c749414cb982))
- Set app language to system language ([#128](https://github.com/DroidWorksStudio/mLauncher/issues/128)) - ([667a0a5](https://github.com/DroidWorksStudio/mLauncher/commit/667a0a5067f47ccc6876410f6dfb7e1f0ba00ac8))
- Hidden apps string hardcoded ([#126](https://github.com/DroidWorksStudio/mLauncher/issues/126)) - ([0a6d3a1](https://github.com/DroidWorksStudio/mLauncher/commit/0a6d3a1a70953650544292b3a934f0ee66a7b8bc))
- Fixed typo that was preventing ClickDateApp change ([#111](https://github.com/DroidWorksStudio/mLauncher/issues/111)) - ([5087a9e](https://github.com/DroidWorksStudio/mLauncher/commit/5087a9e04e70cbd918de7232d15eb53b40653f63))
- Use packageName for applias identifier instead of appLabel ([#103](https://github.com/DroidWorksStudio/mLauncher/issues/103)) - ([ebdbeeb](https://github.com/DroidWorksStudio/mLauncher/commit/ebdbeebf69c869c7cbf37fd67b9c91e373080ea7))
- Remove strings, use resources - ([63abaf3](https://github.com/DroidWorksStudio/mLauncher/commit/63abaf3f99f421f0bca1ce9109f8944ae4a86deb))
- Add layout to landscape-layout - ([a3e8f1c](https://github.com/DroidWorksStudio/mLauncher/commit/a3e8f1cada2aa4307c91afa80188605adc462a60))
- Add layout to landscape-layout - ([8cf45a9](https://github.com/DroidWorksStudio/mLauncher/commit/8cf45a98622a3af48a44b8183661aa67a798bd4f))
- Text size string - ([e7e3e07](https://github.com/DroidWorksStudio/mLauncher/commit/e7e3e07cfb6b2b102b58d00b7bb2977fe80db1f7))
- Fix double tap2lock - ([5e55b3f](https://github.com/DroidWorksStudio/mLauncher/commit/5e55b3f1125baf1edb0ffb58627e94256649b413))
- App drawer swipe down to dismiss not working sometimes - ([948e0a3](https://github.com/DroidWorksStudio/mLauncher/commit/948e0a3262d2250778a351b36d3949d1ce740dbb))
- Fixed status bar color for light theme - ([621f089](https://github.com/DroidWorksStudio/mLauncher/commit/621f08967d0eb9044cf5174b53c52f8fe4611a7b))
- Daily wallpaper not updating correctly - ([acf5168](https://github.com/DroidWorksStudio/mLauncher/commit/acf5168536eea325438f6d0500ac630bdb48236d))
- Pressing enter not opening the first app in list - ([769ce83](https://github.com/DroidWorksStudio/mLauncher/commit/769ce83bb8e627b9656e02571bbc4df6b9848776))
- Showing message dialog again and again - ([d38fced](https://github.com/DroidWorksStudio/mLauncher/commit/d38fcedfc82483e26f2a951675cb86ef5b5d4731))
- Some calendar apps not showing up - ([9cb3e41](https://github.com/DroidWorksStudio/mLauncher/commit/9cb3e4188973f730765639b2ad00d917e5a97e80))
- Fixed a crash.. I guess - ([c554a63](https://github.com/DroidWorksStudio/mLauncher/commit/c554a6380844f0a8d17cbfdd33f35bf8b6d70e23))
- Fixed typo - ([454e975](https://github.com/DroidWorksStudio/mLauncher/commit/454e975835ae07be501702a1cff650425b978190))
- Screen timeout resetting to 30 seconds if screen timeout lock is enabled - ([de560e5](https://github.com/DroidWorksStudio/mLauncher/commit/de560e5921f07383b9633be270630ae5313e2f0f))
- Some apps not being added on home screen - ([f1f6485](https://github.com/DroidWorksStudio/mLauncher/commit/f1f64850b5d6048ec093c44562631f5b8b72445a))
- Wallpaper worker not cancelled when setting black wallpaper - ([42c14be](https://github.com/DroidWorksStudio/mLauncher/commit/42c14be515c7638ada9ae8e2ab6acf79d2a0d610))
- Fixed a minor issue - ([e81ed86](https://github.com/DroidWorksStudio/mLauncher/commit/e81ed8610984887964940d0255e25956d364af22))
- Some work apps not opening - ([fdec75e](https://github.com/DroidWorksStudio/mLauncher/commit/fdec75e2efaf8124a5b996b4d029f3f6dbfc699f))
- Crashing while opening dual/cloned apps - ([3b97361](https://github.com/DroidWorksStudio/mLauncher/commit/3b973611f4837f39df636e6486599eabbac9cedd))
- Home apps not opening if userhandle is empty - ([999292c](https://github.com/DroidWorksStudio/mLauncher/commit/999292c8fe1413ad32d3fb8f65f7a5225e8231ab))
- Crash when a hidden app list contains an uninstalled app - ([59c9b9b](https://github.com/DroidWorksStudio/mLauncher/commit/59c9b9b8def49d2f63604da7bd3685bebd764031))
- Fixed issue with hidden apps with user info - ([fa8c345](https://github.com/DroidWorksStudio/mLauncher/commit/fa8c3459d678b21dfaabb8943da322e53a11d6e5))
- Fixed a stupid mistake. - ([b627e14](https://github.com/DroidWorksStudio/mLauncher/commit/b627e14c06ce175d47fac2fa5bb6c49efda296d8))
- Hidden apps set getting empty - ([3dcd4a8](https://github.com/DroidWorksStudio/mLauncher/commit/3dcd4a80a1187aca93eca7e2fd0d9ee068403af5))
- Fixed a ui crash issue on lock - ([36c7054](https://github.com/DroidWorksStudio/mLauncher/commit/36c70540581f50474f6e88e7f3222bc66cb28490))
- Nav bar not showing in certain conditions - ([e5780e7](https://github.com/DroidWorksStudio/mLauncher/commit/e5780e7ca4abc7d42e94041697b31b9c4bdbfef2))
- Not showing the triple lock message - ([a5448ad](https://github.com/DroidWorksStudio/mLauncher/commit/a5448ad7d879ea28a8f08711ebac1c7c4bddf88f))
- Fixed a minor issue - ([ef58268](https://github.com/DroidWorksStudio/mLauncher/commit/ef5826856aef5f0d7e73c1ea7299933f3214aa59))
- Fixed a minor issue in settings - ([fa4e985](https://github.com/DroidWorksStudio/mLauncher/commit/fa4e9852c6fb70343c87b18371cf7bc6f3005b38))
- App list not updating immediately after install/uninstall - ([629fcf5](https://github.com/DroidWorksStudio/mLauncher/commit/629fcf5d91e7566abc9469bf7d82467b862a8dee))
- Gravity issue in home apps text - ([01cc4dd](https://github.com/DroidWorksStudio/mLauncher/commit/01cc4ddb21722212684cc603e949f7d16df3af70))
- Non-transparent navigation bar in Android 10 - ([30374ee](https://github.com/DroidWorksStudio/mLauncher/commit/30374ee0ecbf5c0bc0018491f34d595c9e7cf620))
- Extra space after apps when right aligned - ([19ffaae](https://github.com/DroidWorksStudio/mLauncher/commit/19ffaae92e5cbfafe846b31d31f690f25e00e90d))
- Home apps not changin color on pressed - ([5b330d6](https://github.com/DroidWorksStudio/mLauncher/commit/5b330d670d613e72e81109e4290154437ae243c5))
- Fixed a bug in wallpaper update - ([c0d29a6](https://github.com/DroidWorksStudio/mLauncher/commit/c0d29a63386db156e5ff4aa8261dc838bc2bb804))
- Fixed (again): text overlapping on first run - ([2ab10dc](https://github.com/DroidWorksStudio/mLauncher/commit/2ab10dcf4381690d83cee42d69e6d04b39795fec))
- Theme change glitch on cold app start - ([632df0c](https://github.com/DroidWorksStudio/mLauncher/commit/632df0c6cd3b4f80116c75ca67a14402259be77a))
- Fixed an overlapping texts issue on first run - ([d01d6e4](https://github.com/DroidWorksStudio/mLauncher/commit/d01d6e4627f622a040799b35495cb701c333b94a))
- Fixed a typo - ([a05abd6](https://github.com/DroidWorksStudio/mLauncher/commit/a05abd6c5e46ab173af33dd19524ed236772e2b3))
- Fixed some admin permission issues - ([a8ead18](https://github.com/DroidWorksStudio/mLauncher/commit/a8ead1827870a3257d4cb6decac27ea247129a58))
- App list refreshing unnecessarily - ([24882d8](https://github.com/DroidWorksStudio/mLauncher/commit/24882d8aac71ed82cf1e50bac4b0b36d178ed6f0))
- Default wallpaper not working - ([ad0ede3](https://github.com/DroidWorksStudio/mLauncher/commit/ad0ede3a68bb714a135f5e5c2e6076bf31b0bc62))
- Fixed margins for different types of screens - ([6738ce0](https://github.com/DroidWorksStudio/mLauncher/commit/6738ce0d62ee37f8b5306b7b1106cb65c7c44ba7))
- App drawer closing unexpectedly when swiping after partial search - ([5734668](https://github.com/DroidWorksStudio/mLauncher/commit/573466897cc6bce48eee80322461e7a35aaed258))
- Not showing date if phone is set to 24 hour time format - ([af80be0](https://github.com/DroidWorksStudio/mLauncher/commit/af80be0b745c34bff1eabe5bccff80a2f49fa6c9))
- Apps blinking when home button pressed - ([f2a012e](https://github.com/DroidWorksStudio/mLauncher/commit/f2a012ec6ad0c70cdf19b5db6418d34030540935))
- App start crash in Android 8.0 - ([287c5d2](https://github.com/DroidWorksStudio/mLauncher/commit/287c5d2eb54a0a111a0b65787de1f7f94ecb2314))
- Wallpaper issue in Marshmallow (Android 6.0) - ([aa42583](https://github.com/DroidWorksStudio/mLauncher/commit/aa425836326e0e82b3abed32910e13cb66bc58f4))
- Search view text color - ([27f12c1](https://github.com/DroidWorksStudio/mLauncher/commit/27f12c1dcd545f3e6ece1662f97d308032062568))
- Fixed a typo - ([aafe5eb](https://github.com/DroidWorksStudio/mLauncher/commit/aafe5ebee3547408bf31b7448af2c26f07d0363f))
- Fixed double tap to lock - ([58f7cc2](https://github.com/DroidWorksStudio/mLauncher/commit/58f7cc29a4722a5254b0e7df0744807888831818))
- Fixed a theme change related bug - ([23366d4](https://github.com/DroidWorksStudio/mLauncher/commit/23366d4b252b533b43b4fa707932e9f01911bfc2))
- App click listener in app list - ([fee0817](https://github.com/DroidWorksStudio/mLauncher/commit/fee08176d13f626a6bc46d90dc582a3ab2205772))
- Crash on initialising navController in MainActivity - ([c1a287f](https://github.com/DroidWorksStudio/mLauncher/commit/c1a287f201c8680d1538e6f551cc4d681276a658))

### Chore:

- *(version)* Update version code - ([8ad6a37](https://github.com/DroidWorksStudio/mLauncher/commit/8ad6a37eae525653e18865dbd26c4ae08d3604d2))
- Version number - ([41b72e9](https://github.com/DroidWorksStudio/mLauncher/commit/41b72e9e625fc80f56a24e8e9ee48cebc670d817))
- Version number - ([8142cf0](https://github.com/DroidWorksStudio/mLauncher/commit/8142cf09aab9a0524233b2380fcb40a57643bc48))
- Version number - ([1782be7](https://github.com/DroidWorksStudio/mLauncher/commit/1782be7e5710911080ec635baaba03b9c10ce872))
- Version number - ([950107a](https://github.com/DroidWorksStudio/mLauncher/commit/950107a4044f664e7c6cf4d2b292add540d1abd3))
- Version number - ([d71f43d](https://github.com/DroidWorksStudio/mLauncher/commit/d71f43da914f846c3d41a9b79ebcab413a3421e7))
- Version number - ([c64e13b](https://github.com/DroidWorksStudio/mLauncher/commit/c64e13b1546ff1ea49c959d694783167b29188a9))
- Version number - ([ab9a397](https://github.com/DroidWorksStudio/mLauncher/commit/ab9a3975297d00d56c8fb1568225f735da272d60))
- Update dependencies - ([29eb4ff](https://github.com/DroidWorksStudio/mLauncher/commit/29eb4ffa76750621433d1e54c1a56c6a28a77371))
- Update dependencies - ([706a953](https://github.com/DroidWorksStudio/mLauncher/commit/706a9538727940ee8a595571d48aa2de16bcbbf1))
- Version number - ([1e75c75](https://github.com/DroidWorksStudio/mLauncher/commit/1e75c75f11ea811784d528e624d93c4fdfc40042))
- Version number - ([d43ffcc](https://github.com/DroidWorksStudio/mLauncher/commit/d43ffcc6e13e13b647cf0c8297df26cb66507437))
- Version number - ([356b772](https://github.com/DroidWorksStudio/mLauncher/commit/356b772bf4ac26623fb4e23bd542724073c19dc4))
- Update version number - ([c27290f](https://github.com/DroidWorksStudio/mLauncher/commit/c27290f23b030082ef0ba41e49d82e6f0d90c928))
- Bump version number - ([5edee82](https://github.com/DroidWorksStudio/mLauncher/commit/5edee82e783f8e30937e9bf97333baa435f196f1))
- Version number, preapre for next release - ([3f1de73](https://github.com/DroidWorksStudio/mLauncher/commit/3f1de732b637ecac033fe0c707871b8cfc436d01))
- Change version code - ([246084c](https://github.com/DroidWorksStudio/mLauncher/commit/246084c11891c62cd863180e346c8662b3a1d025))
- Add version number to settings to improve debugging - ([5b2cede](https://github.com/DroidWorksStudio/mLauncher/commit/5b2cedef09b981ecef0d050ed5d28bfd12499831))
- Rename pull_request_template - ([fe91748](https://github.com/DroidWorksStudio/mLauncher/commit/fe917489c8706b800cd27775f185db4a2ffddc8e))
- Rename translation template - ([96591ce](https://github.com/DroidWorksStudio/mLauncher/commit/96591ce45facf5be3bbc7e5d393325aeb722b6c6))
- Add pull request template for translations - ([5ac96d4](https://github.com/DroidWorksStudio/mLauncher/commit/5ac96d434e133f637e5c3b98b35f8a360df0ccfb))
- Change version code - ([db869fb](https://github.com/DroidWorksStudio/mLauncher/commit/db869fb7acb5b38c9e8710e0b6776427bc94ae0e))
- Remove mode dead code - ([17d285e](https://github.com/DroidWorksStudio/mLauncher/commit/17d285edd29ce0e646750b069a132779824ddb99))
- Removed unused constants and xml layout - ([2eadb7f](https://github.com/DroidWorksStudio/mLauncher/commit/2eadb7fde196e1e5e2dfe23d1348cc1568a635d9))
- Removed even more unused strings - ([1a74a31](https://github.com/DroidWorksStudio/mLauncher/commit/1a74a3168e4574867c5341c484c25c8b89e65280))
- Removed more unused strings - ([7080c59](https://github.com/DroidWorksStudio/mLauncher/commit/7080c59fb077da158325b639c4a9f667817505c0))
- Remove more ads - ([19a711d](https://github.com/DroidWorksStudio/mLauncher/commit/19a711db4e9544612b18f2b48f11104e62d415c5))
- Remove unused strings - ([60d8b93](https://github.com/DroidWorksStudio/mLauncher/commit/60d8b939aeb3a98377c544a5ac50a4c724809a74))
- Change deprecated code - ([da54fc9](https://github.com/DroidWorksStudio/mLauncher/commit/da54fc99ce3255252ead1b40878b74d864d79eb8))
- Clean up code - ([85d8be7](https://github.com/DroidWorksStudio/mLauncher/commit/85d8be7ce33e26a8f5604688e12ed7c4ce60a3ae))

### Versioning:

- Version Bump - ([9ed78b8](https://github.com/DroidWorksStudio/mLauncher/commit/9ed78b873e71fcd2d0bf57d8766132b7084ad3a2))

### Feature Removal:

- Removed a bit of junk - ([8716553](https://github.com/DroidWorksStudio/mLauncher/commit/87165532d84fcf44f5a7138ce8f07d47f9ba2418))
- Removed TEST File - ([fb1664f](https://github.com/DroidWorksStudio/mLauncher/commit/fb1664fb844457ab4c2b7cefd2ded379e88b7200))
- Remove unused strings ([#106](https://github.com/DroidWorksStudio/mLauncher/issues/106)) - ([e61aa36](https://github.com/DroidWorksStudio/mLauncher/commit/e61aa360885cf30cffed6b17ca00e0468ff645f1))
- Remove clutter - ([d546ec9](https://github.com/DroidWorksStudio/mLauncher/commit/d546ec9c55c21eec090be809641c11da0be6ec08))
- Remove clutter - ([e4cef8f](https://github.com/DroidWorksStudio/mLauncher/commit/e4cef8fe5e62f3ce693e3904b59ebe74cbec4a10))
- Removed vibrate on long press - ([0768cca](https://github.com/DroidWorksStudio/mLauncher/commit/0768cca8fb44511bb2c0569063a4c8ee84096924))
- Removed triple tap. Not being used. - ([c79885f](https://github.com/DroidWorksStudio/mLauncher/commit/c79885ff4cbb17b141f712d25d53cd5e80afe62c))
- Removed an overlay - ([cb61bbc](https://github.com/DroidWorksStudio/mLauncher/commit/cb61bbcf09c2c4958ef59078db8ded18b5cd9046))
- Removed text color change support - ([4a173e8](https://github.com/DroidWorksStudio/mLauncher/commit/4a173e84c92d36c887884eadb85345a389eb08cf))
- Removed double tap to lock feature - ([800bdfa](https://github.com/DroidWorksStudio/mLauncher/commit/800bdfa02d67e380bf408d1825a50680e5661b49))
- Remove font thin and increased padding of home apps - ([7681cc3](https://github.com/DroidWorksStudio/mLauncher/commit/7681cc317458423b78fdfa461c3e54ed91fcb418))
- Removed some toast messages - ([be57f66](https://github.com/DroidWorksStudio/mLauncher/commit/be57f66fe6bab045481c69da5e402c88fd0936af))
- Removed example test files and libraries - ([2116c68](https://github.com/DroidWorksStudio/mLauncher/commit/2116c683abc8869cbfb72aa6ddb6f1a40efb6c19))
- Removed sponsor button to comply with play store's payment policies - ([489d67d](https://github.com/DroidWorksStudio/mLauncher/commit/489d67d5f2bcac0abdca289963f8fac6268db418))
- Removed unused welcome fragment - ([5fd9e3d](https://github.com/DroidWorksStudio/mLauncher/commit/5fd9e3d0687405f0d108b6301d26a59c229dbff3))
- Removed some options in settings (will be added in next version) - ([b19cfca](https://github.com/DroidWorksStudio/mLauncher/commit/b19cfcac56fe3a46de9830458a631e66cfbcc23c))
- Removed some unused libraries - ([06c19a1](https://github.com/DroidWorksStudio/mLauncher/commit/06c19a10d01851291c928675ffd4c5a3c53cdb07))
- Removed olauncher from app list - ([fb32141](https://github.com/DroidWorksStudio/mLauncher/commit/fb321416bfcb6901b240b6ea6fdba0485b2abe7a))

### Language Support:

- Lang files and removed junk - ([64561b0](https://github.com/DroidWorksStudio/mLauncher/commit/64561b0ca7aaa598b846b2ba1b53a546b886e74a))

### Documentation:

- *(translation)* Add italian translation - ([39f2ee9](https://github.com/DroidWorksStudio/mLauncher/commit/39f2ee91bcc1206dfd5bfa597869fe09bda1c896))

### Refactoring:

- Improve text resize behaviour and set broader limits ([#207](https://github.com/DroidWorksStudio/mLauncher/issues/207)) - ([3e18041](https://github.com/DroidWorksStudio/mLauncher/commit/3e18041c01a04d4df8ac59afa83dbd43a5ac3ce6))
- Replace string with string resourece ([#97](https://github.com/DroidWorksStudio/mLauncher/issues/97)) - ([432148e](https://github.com/DroidWorksStudio/mLauncher/commit/432148e46bf8028c17dafe488f49be2e470a9ff1))
- Migrate to jetpack compose ([#30](https://github.com/DroidWorksStudio/mLauncher/issues/30)) - ([be2c1c0](https://github.com/DroidWorksStudio/mLauncher/commit/be2c1c052b9c9677f22d33db9a56c563713535b8))
- Refactoring - ([4f4e1b4](https://github.com/DroidWorksStudio/mLauncher/commit/4f4e1b48857bc13fc7a9aa8292c2da355b3dad25))
- Refactoring - ([7246ee1](https://github.com/DroidWorksStudio/mLauncher/commit/7246ee1e52d681db2ec1490ca3690711018ee566))
- Refactoring - ([f88b54a](https://github.com/DroidWorksStudio/mLauncher/commit/f88b54a36ba596b0ce2b664d45dc2e80c8104eb7))
- Refactored files into packages - ([244b064](https://github.com/DroidWorksStudio/mLauncher/commit/244b0642fe83095b1de7890ebed4e7ad37a9780f))
- Refactoring launcher reset and default launcher selection - ([7fdadef](https://github.com/DroidWorksStudio/mLauncher/commit/7fdadef12b4f23ba69c49e865fac82d0a1635c21))
- Moved some logic from view to viewmodel - ([d24d379](https://github.com/DroidWorksStudio/mLauncher/commit/d24d3794ff6a0cfc2d69b08a67ff907ea7c92213))

### Styling Changes:

- Deutsch -> german - ([21ce8bb](https://github.com/DroidWorksStudio/mLauncher/commit/21ce8bbfc6e2308957f95b9576c438f6bbb1ac31))

### Reverts:

- Settings text changin size (i guess it was better as it was before) - ([fe5b2da](https://github.com/DroidWorksStudio/mLauncher/commit/fe5b2daa669d69fa20fbd6dbde31ebb5d38e8b78))
- Revert "fix: move 'backToHomeScreen()' to onResume to not show home shortly before opening an app" - ([b90dbfa](https://github.com/DroidWorksStudio/mLauncher/commit/b90dbfa6c29e2453f6151d6cfde12b111f4a68ed))
- Revert "Change App icon" - ([d19b33f](https://github.com/DroidWorksStudio/mLauncher/commit/d19b33fcf676be0d6bfe5f787ef9608613ba16dd))

### Releases:

- Version number - ([3c082e4](https://github.com/DroidWorksStudio/mLauncher/commit/3c082e45c4d95afacdc5a2e259d073ea33c70328))

<!-- Generated by DroidWorks Studio -->
