# Changelog

## [Coming Soon](https://github.com/DroidWorksStudio/mLauncher/tree/HEAD)

### Implemented Enhancements:

- Added Backup / Restore Feature
- Added a home screen pager (disabled by default)

### Bug Fixes:

- Allow HomeScreen apps to be set to 0

### Language Support:

- Updated Language Files. ([#419](https://github.com/DroidWorksStudio/mLauncher/issues/419))
- Updated Language Files. ([#418](https://github.com/DroidWorksStudio/mLauncher/issues/418))

### Documentation:

- Update CHANGELOG.md

### Refactor:

- Cleaned up code adding permission request

## [1.4.5](https://github.com/DroidWorksStudio/mLauncher/tree/1.4.5) - (02, April 2024)

### Implemented Enhancements:

- Added `please_select_app` to the home screen apps ([#411](https://github.com/DroidWorksStudio/mLauncher/issues/411))

### Bug Fixes:

- Fixed the reorder settings ([#416](https://github.com/DroidWorksStudio/mLauncher/issues/416))
- Fix namespace for the project
- Fixed FUNDING.yml

### Release:

- Update the Release version to 145 (v1.4.5)
- Update the Release version to 144 (v1.4.4)

### Documentation:

- Update CHANGELOG.md

### Miscellaneous Tasks:

- Update changelog.yml
- Added App Details
- Changed App Icon
- Rename finder to FuzzyFinder

## [1.4.3](https://github.com/DroidWorksStudio/mLauncher/tree/1.4.3) - (24, March 2024)

### Bug Fixes:

- Bug fix/fixed the swipe gestures ([#392](https://github.com/DroidWorksStudio/mLauncher/issues/392))

## [1.3.3](https://github.com/DroidWorksStudio/mLauncher/tree/1.3.3) - (09, March 2024)

### Release:

- Release/1.3.3 ([#356](https://github.com/DroidWorksStudio/mLauncher/issues/356))

## [1.3.2](https://github.com/DroidWorksStudio/mLauncher/tree/1.3.2) - (05, March 2024)

### Bug Fixes:

- Fixed Languages For Breaking
- Fixed Latin

## [1.3.1](https://github.com/DroidWorksStudio/mLauncher/tree/1.3.1) - (05, March 2024)

### Bug Fixes:

- Fixed Languages
- Fixed the Accent color all apps header ([#338](https://github.com/DroidWorksStudio/mLauncher/issues/338))
- Fixed the title of app apps when accent color is disabled. ([#337](https://github.com/DroidWorksStudio/mLauncher/issues/337))

## [1.3.0](https://github.com/DroidWorksStudio/mLauncher/tree/1.3.0) - (02, March 2024)

### Bug Fixes:

- Fixed Accent Color for "All apps" in app drawer  ([#333](https://github.com/DroidWorksStudio/mLauncher/issues/333))
- Fixed closing issues
- Fixed few typos .
- Fixed DateTime formatting

### Release:

- Release 1.3.0 ([#335](https://github.com/DroidWorksStudio/mLauncher/issues/335))

## [1.2.1](https://github.com/DroidWorksStudio/mLauncher/tree/1.2.1) - (23, July 2023)

### Bug Fixes:

- Fixed formatting
- Fix the Font

### Release:

- Update version to 66 (v1.2.1) ([#296](https://github.com/DroidWorksStudio/mLauncher/issues/296))

## [1.2.0](https://github.com/DroidWorksStudio/mLauncher/tree/1.2.0) - (14, July 2023)

### Bug Fixes:

- Fixed other EN Languages

### Release:

- Update version to 65 (v1.2.0) ([#290](https://github.com/DroidWorksStudio/mLauncher/issues/290))

## [1.1.2](https://github.com/DroidWorksStudio/mLauncher/tree/1.1.2) - (08, July 2023)

### Bug Fixes:

- Fixed the README (no need for a PR)

### Release:

- Update version to 64 (v1.1.2) ([#285](https://github.com/DroidWorksStudio/mLauncher/issues/285))

## [1.1.1](https://github.com/DroidWorksStudio/mLauncher/tree/1.1.1) - (27, June 2023)

### Bug Fixes:

- Fixed the Logic for FuzzyWuzzy ([#277](https://github.com/DroidWorksStudio/mLauncher/issues/277))

### Release:

- Release/v63 ([#278](https://github.com/DroidWorksStudio/mLauncher/issues/278))

### Language Support:

- Language Support

## [1.1.0](https://github.com/DroidWorksStudio/mLauncher/tree/1.1.0) - (26, June 2023)

### Implemented Enhancements:

- Updated the logic for the app search. ([#273](https://github.com/DroidWorksStudio/mLauncher/issues/273))

### Release:

- Update version to 62 (v1.1.0) ([#272](https://github.com/DroidWorksStudio/mLauncher/issues/272))

## [1.0.1](https://github.com/DroidWorksStudio/mLauncher/tree/1.0.1) - (11, April 2023)

### Implemented Enhancements:

- Auto open apps with spaces in name ([#251](https://github.com/DroidWorksStudio/mLauncher/issues/251))

### Release:

- Update version to 61 (v1.0.1) ([#265](https://github.com/DroidWorksStudio/mLauncher/issues/265))

## [1.0.0](https://github.com/DroidWorksStudio/mLauncher/tree/1.0.0) - (14, March 2023)

### Bug Fixes:

- Fixed the accent colors toggle for app draw ([#243](https://github.com/DroidWorksStudio/mLauncher/issues/243))

### Release:

- Update version to 60 (v1.0.0) ([#244](https://github.com/DroidWorksStudio/mLauncher/issues/244))

## [0.5.9](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.9) - (11, March 2023)

### Bug Fixes:

- Fix the locked screen when no pass set ([#238](https://github.com/DroidWorksStudio/mLauncher/issues/238))

### Release:

- Update version to 59 (v0.5.9) ([#239](https://github.com/DroidWorksStudio/mLauncher/issues/239))

## [0.5.8](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.8) - (09, March 2023)

### Implemented Enhancements:

- System accent color & font for app drawer ([#233](https://github.com/DroidWorksStudio/mLauncher/issues/233))
- Doubled the number of apps on the homescreen ([#232](https://github.com/DroidWorksStudio/mLauncher/issues/232))

### Release:

- Update version to 58 (v0.5.8) ([#234](https://github.com/DroidWorksStudio/mLauncher/issues/234))

## [0.5.7](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.7) - (01, March 2023)

### Implemented Enhancements:

- Update the lock screen. ([#228](https://github.com/DroidWorksStudio/mLauncher/issues/228))

### Bug Fixes:

- Fixed app alignment ([#226](https://github.com/DroidWorksStudio/mLauncher/issues/226))

### Release:

- Update version to 57 (v0.5.7) ([#227](https://github.com/DroidWorksStudio/mLauncher/issues/227))

## [0.5.6](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.6) - (26, February 2023)

### Bug Fixes:

- Fixed
- Fixed the Settings ([#221](https://github.com/DroidWorksStudio/mLauncher/issues/221))

### Release:

- Update version to 56 (v0.5.6) ([#222](https://github.com/DroidWorksStudio/mLauncher/issues/222))

## [0.5.5](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.5) - (21, February 2023)

### Bug Fixes:

- Fixed incorrect preference assignment ([#215](https://github.com/DroidWorksStudio/mLauncher/issues/215))

## [0.5.4](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.4) - (16, February 2023)

### Bug Fixes:

- Fixed a bug that crashes on battery monitor ([#211](https://github.com/DroidWorksStudio/mLauncher/issues/211))

### Release:

- App version bumped to 54 (v0.5.4) ([#212](https://github.com/DroidWorksStudio/mLauncher/issues/212))

## [0.5.3](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.3) - (13, February 2023)

### Bug Fixes:

- Fix a crash releated to loading the base app
- Bug/fix colors and layout for pin screen ([#204](https://github.com/DroidWorksStudio/mLauncher/issues/204))
- Bug/fix the battery percent from not updating ([#203](https://github.com/DroidWorksStudio/mLauncher/issues/203))

## [0.5.1](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.1) - (06, February 2023)

### Implemented Enhancements:

- Added a toggle to use the custom icon font ([#186](https://github.com/DroidWorksStudio/mLauncher/issues/186))

### Bug Fixes:

- Fix Settings for Icon Font ([#192](https://github.com/DroidWorksStudio/mLauncher/issues/192))

### Revert:

- Revert "Update release-drafter.yml"

### Release:

- Release.tml

## [0.5.0](https://github.com/DroidWorksStudio/mLauncher/tree/0.5.0) - (24, January 2023)

### Implemented Enhancements:

- Fix the display for the battery usage ([#184](https://github.com/DroidWorksStudio/mLauncher/issues/184))

## [0.4.9](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.9) - (23, January 2023)

### Implemented Enhancements:

- Make padding home apps apply to app draw too ([#173](https://github.com/DroidWorksStudio/mLauncher/issues/173))

### Bug Fixes:

- Fix fontsize that I had commented out

## [0.4.7](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.7) - (16, January 2023)

### Implemented Enhancements:

- Padding for apps on homescreen ([#169](https://github.com/DroidWorksStudio/mLauncher/issues/169))

## [0.4.6](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.6) - (14, January 2023)

### Implemented Enhancements:

- Filter application results start ([#166](https://github.com/DroidWorksStudio/mLauncher/issues/166))
- Removed the roadmap link ([#162](https://github.com/DroidWorksStudio/mLauncher/issues/162))

### Bug Fixes:

- Just a few layout fixes

### Documentation:

- Docs Added.

## [0.4.5](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.5) - (08, January 2023)

### Implemented Enhancements:

- Feature/more friendly colors ([#159](https://github.com/DroidWorksStudio/mLauncher/issues/159))

### Bug Fixes:

- Fix the README
- Fix text size...

## [0.4.4](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.4) - (05, January 2023)

### Bug Fixes:

- Work on the icons to make them look better. ([#155](https://github.com/DroidWorksStudio/mLauncher/issues/155))

### Release:

- Release 0.4.4

## [0.4.3](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.3) - (03, January 2023)

### Implemented Enhancements:

- Added more swipe actions. ([#144](https://github.com/DroidWorksStudio/mLauncher/issues/144))

### Bug Fixes:

- Fixed slider bar to be off by 1 if too close.
- Fixed font and backup.
- Fixed backups
- Fixed the README
- File structure renaming and added sliders ([#137](https://github.com/DroidWorksStudio/mLauncher/issues/137))
- Fixed slider and font size. ([#136](https://github.com/DroidWorksStudio/mLauncher/issues/136))

## [0.4.2](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.2) - (30, December 2022)

### Bug Fixes:

- Fixes the other fragments opacity ([#132](https://github.com/DroidWorksStudio/mLauncher/issues/132))

## [0.4.1](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.1) - (30, December 2022)

### Implemented Enhancements:

- Add the ability to change opacity of overlay ([#125](https://github.com/DroidWorksStudio/mLauncher/issues/125))

### Bug Fixes:

- Fix the README.md

### Revert:

- Revert back to java folder as kotlin breaks

## [0.4.0](https://github.com/DroidWorksStudio/mLauncher/tree/0.4.0) - (28, December 2022)

### Implemented Enhancements:

- Added custom font size for settings ([#116](https://github.com/DroidWorksStudio/mLauncher/issues/116))

### Revert:

- Revert "Update Templates"
- Revert "Code Cleanup"

## [0.3.8](https://github.com/DroidWorksStudio/mLauncher/tree/0.3.8) - (25, December 2022)

### Implemented Enhancements:

- Put settings items on two rows ([#104](https://github.com/DroidWorksStudio/mLauncher/issues/104))
- Resize the font in the settings ([#107](https://github.com/DroidWorksStudio/mLauncher/issues/107))

### Bug Fixes:

- Fixed to build
- Updated the Changelog
- Fixed the link to the roadmap ([#110](https://github.com/DroidWorksStudio/mLauncher/issues/110))
- Fix some of the readme file. ([#108](https://github.com/DroidWorksStudio/mLauncher/issues/108))
- Fixed the local to use from system settings ([#106](https://github.com/DroidWorksStudio/mLauncher/issues/106))
- Fixed the language file for base en ([#103](https://github.com/DroidWorksStudio/mLauncher/issues/103))

## [0.3.7](https://github.com/DroidWorksStudio/mLauncher/tree/0.3.7) - (23, December 2022)

### Bug Fixes:

- Fixing an error with the intent swipes ([#99](https://github.com/DroidWorksStudio/mLauncher/issues/99))
- Fix the french language string.xml ([#94](https://github.com/DroidWorksStudio/mLauncher/issues/94))
- Fix the OPEN to follow the language ([#91](https://github.com/DroidWorksStudio/mLauncher/issues/91))

## [0.3.6](https://github.com/DroidWorksStudio/mLauncher/tree/0.3.6) - (22, December 2022)

### Bug Fixes:

- Fix Contributing ([#88](https://github.com/DroidWorksStudio/mLauncher/issues/88))
- Fix file ([#86](https://github.com/DroidWorksStudio/mLauncher/issues/86))
- Fix italian string ([#79](https://github.com/DroidWorksStudio/mLauncher/issues/79))
- Fix some typos ([#74](https://github.com/DroidWorksStudio/mLauncher/issues/74))
- Fixed Actions ([#70](https://github.com/DroidWorksStudio/mLauncher/issues/70))
- Fix French CDATA ([#68](https://github.com/DroidWorksStudio/mLauncher/issues/68))
- FixedMax ([#63](https://github.com/DroidWorksStudio/mLauncher/issues/63))

## [0.3.5](https://github.com/DroidWorksStudio/mLauncher/tree/0.3.5) - (19, December 2022)

### Implemented Enhancements:

- Add toggle for "open apps automatically" ([#53](https://github.com/DroidWorksStudio/mLauncher/issues/53))
- Replace some texts with images, enable uninstall of apps throug… ([#204](https://github.com/DroidWorksStudio/mLauncher/issues/204))
- *(german)* Update german string ([#175](https://github.com/DroidWorksStudio/mLauncher/issues/175))
- Implement #102 ([#160](https://github.com/DroidWorksStudio/mLauncher/issues/160))
- Implements #82 ([#136](https://github.com/DroidWorksStudio/mLauncher/issues/136))
- Add korean to settings
- Toggle date and time independently ([#88](https://github.com/DroidWorksStudio/mLauncher/issues/88))
- Changelogs for v9
- Option to set language from system settings
- Option to set language from system settings
- Option to set language from system settings
- Change text size
- List hidden apps
- Change text size
- *(permission)* Remove internet permisisons, and everything that ne…
- *(permission)* Remove internet permisisons, and everything that needed it
- *(translation)* Manually select language

### Bug Fixes:

- Fix a few actions ([#54](https://github.com/DroidWorksStudio/mLauncher/issues/54))
- Fix Translations ([#47](https://github.com/DroidWorksStudio/mLauncher/issues/47))
- Fix app draw
- Fixed the order
- Not reundant ([#21](https://github.com/DroidWorksStudio/mLauncher/issues/21))
- Fix the bug from swiping apps ([#3](https://github.com/DroidWorksStudio/mLauncher/issues/3))
- Fix the Swiping ([#2](https://github.com/DroidWorksStudio/mLauncher/issues/2))
- Fix the swipe apps
- Fix the README file
- Fix the swipe down app menu
- Fixed settings
- #209
- Text size in settings
- Work icon size and work icon position
- Version number
- Set app name right when it is added to the home screen, not just at showing the fragment ([#202](https://github.com/DroidWorksStudio/mLauncher/issues/202))
- Set swipe right app
- #172
- Move 'backToHomeScreen()' to onResume to not show home shortly before opening an app
- German translation ([#191](https://github.com/DroidWorksStudio/mLauncher/issues/191))
- *(homescreen)* Place apps that are only in work profile on home screen ([#188](https://github.com/DroidWorksStudio/mLauncher/issues/188))
- *(homescreen)* This fixes the homescreen alignment bug ([#185](https://github.com/DroidWorksStudio/mLauncher/issues/185)), while also being a general code improvement commit ([#187](https://github.com/DroidWorksStudio/mLauncher/issues/187))
- Remove non-free dependencies
- Home alignment when click area is exetended ([#176](https://github.com/DroidWorksStudio/mLauncher/issues/176))
- Swipe app names black if not set
- Fixed lack of backslash before apostrophes
- Set app language to system language ([#128](https://github.com/DroidWorksStudio/mLauncher/issues/128))
- Hidden apps string hardcoded ([#126](https://github.com/DroidWorksStudio/mLauncher/issues/126))
- Fixed typo that was preventing ClickDateApp change ([#111](https://github.com/DroidWorksStudio/mLauncher/issues/111))
- Use packageName for applias identifier instead of appLabel ([#103](https://github.com/DroidWorksStudio/mLauncher/issues/103))
- Fix simultaneous changes of README
- Remove strings, use resources
- *(full_description.txt)* Change clutter
- *(short_description.txt)* Change clutter
- *(settings)* Language list doubled
- Fix typo
- Fix typo
- Add layout to landscape-layout
- Add layout to landscape-layout
- Text size string
- Fix double tap2lock
- Fix double tap2lock
- *(landscape)* Add language menu to landscape layout xml
- *(landscape)* Add language menu to landscape layout xml
- Fixes #79 and #122.
- App drawer swipe down to dismiss not working sometimes
- Fixed status bar color for light theme
- Daily wallpaper not updating correctly
- Pressing enter not opening the first app in list
- Showing message dialog again and again
- Some calendar apps not showing up
- Fixed a crash.. I guess
- Fixed typo
- Screen timeout resetting to 30 seconds if screen timeout lock is enabled
- Some apps not being added on home screen
- Wallpaper worker not cancelled when setting black wallpaper
- Fixed a minor issue
- Some work apps not opening
- Crashing while opening dual/cloned apps
- Home apps not opening if userhandle is empty
- Crash when a hidden app list contains an uninstalled app
- Fixed issue with hidden apps with user info
- Fixed a stupid mistake.
- Hidden apps set getting empty
- Fixed a ui crash issue on lock
- Nav bar not showing in certain conditions
- Not showing the triple lock message
- Fixed a minor issue
- Fixed a minor issue in settings
- App list not updating immediately after install/uninstall
- Gravity issue in home apps text
- Non-transparent navigation bar in Android 10
- Extra space after apps when right aligned
- Home apps not changin color on pressed
- Fixed a bug in wallpaper update
- Fixed (again): text overlapping on first run
- Theme change glitch on cold app start
- Fixed an overlapping texts issue on first run
- Fixed a typo
- Fixed some admin permission issues
- App list refreshing unnecessarily
- Default wallpaper not working
- Fixed margins for different types of screens
- App drawer closing unexpectedly when swiping after partial search
- Not showing date if phone is set to 24 hour time format
- Apps blinking when home button pressed
- App start crash in Android 8.0
- Wallpaper issue in Marshmallow (Android 6.0)
- Search view text color
- Fixed a typo
- Fixed double tap to lock
- Fixed a theme change related bug
- App click listener in app list
- Crash on initialising navController in MainActivity

### Revert:

- Settings text changin size (i guess it was better as it was before)
- Revert "fix: move 'backToHomeScreen()' to onResume to not show home shortly before opening an app"
- Revert "Change App icon"
- Revert "Change App icon"
- Revert header

### Release:

- Version number

### Language Support:

- Lang files and removed junk

### Documentation:

- *(translation)* Add italian translation
- *(translation)* Add italian translation

### Refactor:

- Improve text resize behaviour and set broader limits ([#207](https://github.com/DroidWorksStudio/mLauncher/issues/207))
- Replace string with string resourece ([#97](https://github.com/DroidWorksStudio/mLauncher/issues/97))
- Migrate to jetpack compose ([#30](https://github.com/DroidWorksStudio/mLauncher/issues/30))
- Refactoring
- Refactoring
- Refactoring
- Refactored files into packages
- Refactoring launcher reset and default launcher selection
- Moved some logic from view to viewmodel

### Styling:

- Deutsch -> german

### Testing:

- Test out automated android builds

### Miscellaneous Tasks:

- Version number
- Version number
- Version number
- Version number
- Version number
- Version number
- Version number
- Update dependencies
- Update dependencies
- Version number
- Version number
- Version number
- Update version number
- Bump version number
- Version number, preapre for next release
- Change version code
- Add version number to settings to improve debugging
- Rename pull_request_template
- Rename translation template
- Add pull request template for translations
- Change version code
- Remove unused strings
- Remove mode dead code
- Removed unused constants and xml layout
- Removed even more unused strings
- Removed more unused strings
- Remove more ads
- Remove unused strings
- Change deprecated code
- Clean up code
- *(version)* Update version code

<!-- Generated by DroidWorks Studio -->
