<div align='center'>
	<h2>mLauncher - Minimal and Clutter Free Android launcher</h2>
	<img src='fastlane/metadata/android/en-US/images/phoneScreenshots/0.png' alt='mLauncher'>
    	<p></p>
    	<a href='https://f-droid.org/packages/app.mlauncher'><img src='https://fdroid.gitlab.io/artwork/badge/get-it-on.png' height="100"></a>
</div>

- Chat with us at [mLauncher](https://t.me/mLauncherAndroid) on telegram.
- This application can be found on [F-Droid](https://f-droid.org/packages/app.mlauncher/) and [Github](https://github.com/HeCodes2Much/mLauncher/releases/).
- You can also add this repo to [Obtanium](https://github.com/ImranR98/Obtainium) to get auto updates that are faster then F-Droid.
- The latest stable version is available on the [`main`](https://github.com/HeCodes2Much/mLauncher/tree/main) branch, which can be cloned to build the application independently.
- Additionally, a Github action has been set up to automatically generate an APK for every [release](https://github.com/HeCodes2Much/mLauncher/releases).
- The **original** version of the application is also accessible on the [Play Store](https://play.google.com/store/apps/details?id=app.olauncher), [F-Droid](https://f-droid.org/fr/packages/app.olauncher/) & [Github](https://github.com/tanujnotes/Olauncher).

We try to balance customizability and minimalization well still being simple :)</h3>

# Forked with extra features

<details><summary>List of features (click to expand)</summary>

- Removed clutter, like ads and links
- You can rename apps in the app-drawer (Renaming apps on the home screen is already supported. Just long-click on an app on the home screen and start typing)
- We have added a lot more options for gestures on the home screen:
    - Gestures are now:
        - Swiping up, down, left, right
        - Clicking on the clock
        - Clicking on the Date
    - Possible actions now include:
        - Open specified app
        - Locking the screen
        - Opening the notification drawer
        - Opening the quick settings
- You can also position the clock independently of the home apps
- The ability to have a pass code set for the settings page
- Change alignment of apps in app-drawer
- Change font size
- Removed internet permission. You never know what an app developer wants to know about you.

</details>

## Translations: [![Crowdin](https://badges.crowdin.net/mlauncher/localized.svg)](https://crowdin.com/project/mlauncher)

We would like to extend our sincere gratitude to the numerous individuals who have contributed to the translation of our application into various languages. Your efforts have made it possible for users around the world to access and benefit from our product, and we are immensely appreciative of your hard work and dedication. Thank you all for your invaluable contributions!  

<details><summary>List of translations (click to expand)</summary>

  - Arabic
  - Albanian
  - Bulgarian
  - Chinese
  - Croatian
  - Czech
  - Danish
  - English
  - Estonian
  - Filipino
  - Finnish
  - French
  - Georgian
  - German
  - Greek
  - Hawaiian
  - Hebrew
  - Hindi
  - Hungarian
  - Icelandic
  - Indonesian
  - Irish
  - Italian
  - Japanese
  - Korean
  - Lithuanian
  - Luxembourgish
  - Malay
  - Malagasy
  - Malayalam
  - Norwegian
  - Nepali
  - Persian
  - Polish
  - Portuguese (European)
  - Punjabi
  - Russian
  - Serbian
  - Sindhi
  - Spanish
  - Swedish
  - Thai
  - Turkish
  - Ukrainian
  - Vietnamese

</details>

## Contribute

- If you are unhappy with any part of the app or feel like missing something, you can open a pull request or an [**issue**](https://github.com/HeCodes2Much/mLauncher/issues/new/choose) as you like.
  - Please go through the issues marked as `Bug report`, `Crash report` or `Feature request`.
  - Please can we discuss before sending pull requests.
  - Make pull requests to `main` branch.
- Any help in translating mLauncher into other languages is greatly appreciated. If you don't know how to perform a pull request, feel free to check out our dedicated [**Wiki**](https://github.com/HeCodes2Much/mLauncher/wiki).

## License

**mLauncher is proudly licensed under the open source GPL3 license, granting users the freedom to use, study, modify and distribute it at will.**

The Copyleft provision guarantees that these freedoms remain intact, ensuring that mLauncher will remain a fully open-source project. With access to the full source code, anyone can build, fork, and customize the application to their heart's content, unleashing its full potential.

- mLauncher does not have network access.
- mLauncher does not collect or transmit any data in any way whatsoever.

## Permissions

mLauncher uses the following permissions:

- `android.permission.EXPAND_STATUS_BAR`
  - Allows an application to expand or collapse the status bar.
- `android.permission.QUERY_ALL_PACKAGES`
  - Allows query of any normal app on the device, regardless of manifest declarations. Used to show the apps list.
- `android.alarm.permission.SET_ALARM`
  - Allows an application to broadcast an Intent to set an alarm for the user. Used to open the default alarm app if no other clock app is set in the settings.
- `android.permission.REQUEST_DELETE_PACKAGES`
  - Required for issuing the request to remove packages. This does not allow the app to remove apps directly; this only gives the permission to issue the request.
- `android.permission.PACKAGE_USAGE_STATS`
  - Allows mLauncher to see usage of other apps to list last used apps first in the app list. 

## Credits
- [https://gitlab.com/tanujnotes/Olauncher](https://gitlab.com/tanujnotes/Olauncher)
- [https://github.com/OlauncherCF/OlauncherCF](https://github.com/OlauncherCF/OlauncherCF)

## Donation
We kindly request that you consider supporting the ongoing development of mLauncher by making a donation if you find it to be a useful application. As a free and open-source product, mLauncher depends entirely on the support and generosity of its users to maintain its continued growth and accessibility to all. Please note that while purchasing is not obligatory, even a small donation would go a long way in helping us to keep mLauncher alive and thriving. We appreciate your continued support, and thank you for your contribution towards the betterment of our product. 😊

<div align='center'>

<a href="https://www.buymeacoffee.com/HeCodes2Much"><img src="https://img.buymeacoffee.com/button-api/?text=Buy me a coffee&emoji=&slug=HeCodes2Much&button_colour=FFDD00&font_colour=000000&font_family=Cookie&outline_colour=000000&coffee_colour=ffffff" /></a>

</div>

## Build Information

<div align='center'>
    <p>
        <img src='https://img.shields.io/badge/Android-3DDC84?style=flat-square&logo=android&logoColor=white'>
        <img src='https://img.shields.io/badge/SDK-33-3DDC84?style=flat-square'>
        <a href='https://github.com/HeCodes2Much/mLauncher/blob/main/LICENSE'><img src='https://img.shields.io/github/license/HeCodes2Much/mLauncher?color=3DDC84&style=flat-square'></a>
        <br>
	<img src='https://img.shields.io/badge/Maintained-yes-44cc11?style=flat-square'>
        <a href='https://github.com/HeCodes2Much/mLauncher/actions'><img src='https://img.shields.io/github/actions/workflow/status/HeCodes2Much/mLauncher/android-release_ci.yml?style=flat-square'></a>
	<a href='https://github.com/HeCodes2Much/mLauncher/releases/latest'><img src='https://img.shields.io/github/downloads/HeCodes2Much/mLauncher/total?color=44cc11&style=flat-square'></a>
	<br>
	<a href='https://f-droid.org/packages/app.mlauncher'><img alt="F-Droid (including pre-releases)" src="https://img.shields.io/f-droid/v/app.mlauncher?include_prereleases&style=flat-square"></a>
	<a href='https://github.com/HeCodes2Much/mLauncher/releases/latest'><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/HeCodes2Much/mLauncher?style=flat-square"></a>
    </p>
</div>
