# Contributing

Thanks for being willing to contribute!

## Table of Contents

- [How to Contribute](#How-to-Contribute)
- [Contribution-Guidelines](#Contribution-Guidelines)

## How to Contribute

#### **Did you find a bug?**

- **Do not open up a GitHub issue if the bug is a security vulnerability in BitBanana**, and instead to refer to our [Security Policy](../README.md#security).

- **Ensure the bug was not already reported** by searching on GitHub under [Issues][issues].

- If you're unable to find an open issue addressing the problem, [open a new one][issues]. Be sure to include a **title and clear description**, and as much relevant information as possible.

#### **Did you write a patch that fixes a bug?**

- Open a new GitHub pull request with the patch.

- Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

- Before submitting, please read the [Coding Guidelines](#coding-guidelines) to know more about our coding conventions and practices.

#### **Do you intend to add a new feature or change an existing one?**

- Please join us on [discord][discord] and check [open issues][issues] to see what contributions are needed before tackling a task to avoid duplicate work.

#### **Do you have questions about the source code?**

- Ask any question about the BitBanana source code in [discord][discord].

## Contribution Guidelines

### Pull Requests

The `master` branch will be used for all pull requests for the time being. This may change as the repo and contributors grow.

### Style Guide

This project has lint rules and pull requests should pass before being merged. The lint rules are not final by any means and can be changed if necessary.

We also provide some code style rules within the project. Make sure your IDE is taking the provided files into consideration.
If you are using IntelliJ or Android Studio, check out the following link for selecting the projects code style: [IntelliJ Code Style][codestyle]

[issues]: https://github.com/michaelWuensch/BitBanana/issues
[discord]: https://discord.gg/Xg85BuTc9A
[codestyle]: https://www.jetbrains.com/help/idea/configuring-code-style.html