<div align='center'>
	<h2>EasyLauncher - Minimal and Clutter Free Android launcher</h2>
    <table align='center'>
        Click on any image to enlarge it. To know more, explore and see for yourself.
        <tr>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/0.png' width='111' alt=""></td>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/1.png' width='111' alt=""></td>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/2.png' width='111' alt=""></td>
        </tr>
	    <tr>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/3.png' width='111' alt=""></td>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/4.png' width='111' alt=""></td>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/5.png' width='111' alt=""></td>
        </tr>
        <tr>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/6.png' width='111' alt=""></td>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/7.png' width='111' alt=""></td>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/8.png' width='111' alt=""></td>
	    </tr>
    </table>
    <p>
        <a href='https://f-droid.org/packages/app.easy.launcher'><img src='https://github.com/DroidWorksStudio/mLauncher/assets/9284733/a1e7c86f-1c76-46c0-9193-8fde9c9f531c' width="150" alt="fDroid"></a>
        <a href='http://apps.obtainium.imranr.dev/redirect.html?r=obtainium://add/https://github.com/DroidWorksStudio/EasyLauncher'><img src='https://github.com/DroidWorksStudio/mLauncher/assets/9284733/071cccfa-207b-45fb-8be4-7e668eeec4e5' width="150" alt="Obtanium"></a>
    </p>
</div>

<div align='center'>
    <p>
        <img src='https://img.shields.io/badge/Android-SDK_34-BD93F9?style=flat-square&logo=android&logoColor=white' alt="SDK-34">
        <a href='https://github.com/DroidWorksStudio/EasyLauncher/blob/main/LICENSE'><img src='https://img.shields.io/github/license/DroidWorksStudio/EasyLauncher?color=BD93F9&style=flat-square' alt="LICENSE"></a>
        <br>
        <a href='https://github.com/DroidWorksStudio/EasyLauncher/releases/latest'><img src='https://img.shields.io/github/downloads/DroidWorksStudio/EasyLauncher/total?color=50FA7B&style=flat-square' alt="releases"></a>
        <a href='https://github.com/DroidWorksStudio/EasyLauncher/releases/latest'><img src="https://img.shields.io/github/downloads/DroidWorksStudio/EasyLauncher/latest/total?color=50FA7B&style=flat-square" alt="GitHub Downloads (all assets, latest release)"></a>
        <br>
        <a href='https://gitlab.com/fdroid/fdroiddata/-/blob/master/metadata/app.easy.launcher.yml'><img alt="F-Droid (including pre-releases)" src="https://img.shields.io/f-droid/v/app.easy.launcher?color=FFB86C&style=flat-square"></a>
        <a href='https://github.com/DroidWorksStudio/EasyLauncher/releases/latest'><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/DroidWorksStudio/EasyLauncher?color=FFB86C&style=flat-square"></a>
        <br>
        <img src='https://img.shields.io/badge/Maintained-yes-FF5555?style=flat-square' alt="Maintained">
    </p>
</div>

## About

#### Easy Launcher - the minimalist productivity launcher for focus, productivity, keep your focus on what really counts.

- Chat with us at [EasyLauncher](https://t.me/DroidWorksStudio) on telegram.
- This application can be found on [F-Droid](https://f-droid.org/packages/app.easy.launcher/)
  and [Github](https://github.com/HeCodes2Much/EasyLauncher/releases/).
- The latest stable version is available on
  the [`main`](https://github.com/HeCodes2Much/EasyLauncher/tree/main) branch, which can be cloned
  to build the application independently.
- Additionally, a Github action has been set up to automatically generate an APK for
  every [release](https://github.com/HeCodes2Much/EasyLauncher/releases).

We try to balance customizability and minimalization well still being simple :)</h3>

## Features:

- Favorite App Quick Access: Display your most-used apps on the home screen in text format for swift
  access, streamlining your operations.
- Hide Apps: Easily conceal apps you don't want visible, keeping your home screen clean and focused
  on essential content.
- Rename Apps: Personalize your apps with custom names that sync seamlessly between favorites and
  all apps.
- Locking: Secure your privacy and data with fingerprint lock for selected apps and settings.
- Internet Permissions: One version with INTERNET as it is needed for widgets and one without
  INTERNET (fdoird build).
- Crash Reports: Report crashes via email, including log files for effective troubleshooting.

#### Personalized Customization:

- Font Colors: Customize font colors using our color picker.
- Position: Align Date, Time, and Apps to Left, Center, or Right.
- Padding: Adjust padding between favorite apps and all apps.
- Font Size: Set font size for each element on the home screen.
- Toggle Items: Control display preferences on the home screen.

#### Possible Gestures Include:

- Swiping Gestures: Navigate by swiping in different directions (up, down, left, right) to access
  various features or move between screens.
- Double Tap: Quickly tap the screen twice to perform a predefined action or activate a feature.
- Clock Interaction: Tap on the clock to display additional information such as alarms or world
  clock.
- Date Interaction: Tap on the date to open the calendar app for scheduling and planning.
- Battery Icon: Tap on the battery icon to access battery usage details.

#### Possible Actions Include:

- Open Specified App: Instantly launch any app you choose for seamless access to your favorites.
- Display App List: View and manage your installed apps efficiently with a comprehensive list
  display.
- Screen Locking: Secure your device and protect your privacy with quick and convenient screen
  locking.
- Show Recently Opened Apps: Access recently used apps effortlessly for swift multitasking.
- Notification Drawer Access: Open the notification drawer with a single tap to check updates and
  alerts.
- Quick Settings: Manage device settings swiftly by accessing quick settings directly from the home
  screen.
- Power Dialog: Control power options such as restart, power off, and more with ease using the power
  dialog.
- Take a Screenshot: Capture your screen instantly to save and share important information and
  moments.
- Disable Gestures: Temporarily or permanently disable specific gestures to customize your device
  interaction experience.

## Contribute

- If you are unhappy with any part of the app or feel like missing something, you can open a pull
  request or an **[issue
  ](https://github.com/HeCodes2Much/EasyLauncher/issues/new/choose)** as you like.
    - Please go through the issues marked as `Bug report`, `Crash report` or `Feature request`.
    - Please can we discuss before sending pull requests.
    - Make pull requests to `main` branch.
- Any help in translating EasyLauncher into other languages is greatly appreciated. **[Crowdin
  ](https://crowdin.com/project/easy-launcher)**.

## Credits

- This project is partially based on code
  from [neophtex/AsterLauncher](https://github.com/neophtex/AsterLauncher), though it has been
  significantly modified.

Sure, here is a revised and improved version of the license description:

---

## License

**EasyLauncher is proudly licensed under the open source GPL3 license, granting users the freedom to
use, study, modify and distribute it at will.**

The Copyleft provision guarantees that these freedoms remain intact, ensuring that EasyLauncher will
remain a fully open-source project. With access to the full source code, anyone
can build, fork, and customize the application to their heart's content, unleashing its full
potential.

- EasyLauncher does not have network access unless using the Internet apk.
- EasyLauncher does not collect or transmit any data in any way whatsoever.

## Permissions

EasyLauncher uses the following permissions:

- `android.permission.EXPAND_STATUS_BAR`
    - Allows an application to expand or collapse the status bar.
- `android.permission.QUERY_ALL_PACKAGES`
    - Allows query of any normal app on the device, regardless of manifest declarations. Used to
      show the apps list.
- `android.alarm.permission.SET_ALARM`
    - Allows an application to broadcast an Intent to set an alarm for the user. Used to open the
      default alarm app if no other clock app is set in the settings.
- `android.permission.REQUEST_DELETE_PACKAGES`
    - Required for issuing the request to remove packages. This does not allow the app to remove
      apps directly; this only gives the permission to issue the request.
- `android.permission.PACKAGE_USAGE_STATS`
    - Allows EasyLauncher to see usage of other apps to list last used apps first in the app list.

## Donation

We kindly request that you consider supporting the ongoing development of EasyLauncher by making a
donation if you find it to be a useful application. As a free and open-source
product, EasyLauncher depends entirely on the support and generosity of its users to maintain its
continued growth and accessibility to all. Please note that while purchasing is
not obligatory, even a small donation would go a long way in helping us to keep EasyLauncher alive
and thriving. We appreciate your continued support, and thank you for your
contribution towards the betterment of our product. 😊

<div align='center'>
<a href="https://www.buymeacoffee.com/HeCodes2Much"><img src="https://img.buymeacoffee.com/button-api/?text=Buy me a coffee&emoji=&slug=HeCodes2Much&button_colour=FFDD00&font_colour=000000&font_family=Cookie&outline_colour=000000&coffee_colour=ffffff" /></a>
</div>
