# Contributing to EasyLauncher

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

Reading and following these guidelines will help us make the contribution process easy and effective for everyone involved. It also communicates that you agree to respect the time of the developers
managing and developing these open source projects. In return, we will reciprocate that respect by addressing your issue, assessing changes, and helping you finalize your pull requests.

## Quicklinks

* [Code of Conduct](#code-of-conduct)
* [Getting Started](#getting-started)
    * [We Develop with Github](#we-develop-with-github)
    * [Pull Requests](#pull-requests)
    * [Issues](#issues)
    * [Code Style](#code-style)
* [License](#license)

## Code of Conduct

We take our open source community seriously and hold ourselves and other contributors to high standards of communication. By participating and contributing to this project, you agree to uphold
our [Code of Conduct](CODE-OF-CONDUCT.md).

## Getting Started

Contributions are made to this repo via Issues and Pull Requests (PRs). A few general guidelines that cover both:

- Search for existing Issues and PRs before creating your own.
- We work hard to makes sure issues are handled in a timely manner but, depending on the impact, it could take a while to investigate the root cause. A friendly ping in the comment thread to the
  submitter or a contributor can help draw attention if your issue is blocking.

### We Develop with Github

We use github to host code, to track issues and feature requests, as well as accept pull requests.

### Pull Requests

**We Use ["fork-and-pull" Git workflow](FAPRW.md), So All Code Changes Happen Through Pull Requests**

Pull requests are the best way to propose changes to the codebase (In general, we follow the ["fork-and-pull" Git workflow](FAPRW.md)). We actively welcome your pull requests:

1. Fork the repository to your own Github account
2. Clone the project to your machine
3. Create a branch locally with a succinct but descriptive name
4. Commit changes to the branch
5. Following any formatting and testing guidelines specific to this repo
6. Push changes to your fork
7. Open a PR in our repository and follow the PR template so that we can efficiently review the changes.

In general, PRs should:

- Only fix/add the functionality in question **OR** address wide-spread whitespace/style issues, not both.
- Address a single concern in the least number of changed lines as possible.
- Be accompanied by a complete Pull Request template (loaded automatically when a PR is created).

For changes that address core functionality or would require breaking changes (e.g. a major release), it's best to open an Issue to discuss your proposal first. This is not required but can save time
creating and reviewing changes.

### Issues

Issues should be used to report problems with the project, request a new feature, or to discuss potential changes before a PR is created. When you create a new Issue, a template will be loaded that
will guide you through collecting and providing the information we need to investigate.

If you find an Issue that addresses the problem you're having, please add your own reproduction information to the existing issue rather than creating a new one. Adding
a [reaction](https://github.blog/2016-03-10-add-reactions-to-pull-requests-issues-and-comments/) can also help be indicating to our maintainers that a particular problem is affecting more than just
the reporter.

**Report bugs using Github's [issues](https://github.com/HeCodes2Much/EasyLauncher/issues)**

We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/HeCodes2Much/EasyLauncher/issues/new/choose); it's that easy!

Write bug reports with detail, background, and sample code

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
    - Be specific!
    - Give sample code if you can.
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

People *love* thorough bug reports. I'm not even kidding.

### Code Style

**Use a Consistent Coding Style**

* 4 spaces for indentation rather than tabs

## License

**Any contributions you make will be under the GPL-3.0 License**

In short, when you submit code changes, your submissions are understood to be under the same [GPL-3.0 License]([http://choosealicense.com/licenses/mit/](https://choosealicense.com/licenses/gpl-3.0/))
that covers the project. Feel free to contact the maintainers if that's a concern.

By contributing, you agree that your contributions will be licensed under its GPL-3.0 License.
