# Changelog

All notable changes to this project will be documented in this file. See [conventional commits](https://www.conventionalcommits.org/) for commit guidelines.

## [Coming Soon](https://github.com/DroidWorksStudio/EasyLauncher/tree/HEAD)

### Implemented Enhancements:

- Added Fuzzy Finding - ([29d2954](https://github.com/DroidWorksStudio/EasyLauncher/commit/29d29543144fde25c72877de0d09dbb73e1cb898))

### Bug Fixes:

- Fixed the settings from not displaying the background correctly. - ([709fac1](https://github.com/DroidWorksStudio/EasyLauncher/commit/709fac138cc8f16bd6754b09e61dafe8600f91b9))

### Language Support:

- Updated Language Files. ([#158](https://github.com/DroidWorksStudio/EasyLauncher/issues/158)) - ([4fff27c](https://github.com/DroidWorksStudio/EasyLauncher/commit/4fff27c78b0bedd75dde031d9955b7e781dc06d9))

### Releases:

- Prepare for version 0.2.7 - ([cbfd5c8](https://github.com/DroidWorksStudio/EasyLauncher/commit/cbfd5c8946a648278b6e6796e2d9a94d01a2ee43))

## [0.2.6](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.2.6) - (27, September 2024)

### Implemented Enhancements:

- Added the base for the new settings screen ([#130](https://github.com/DroidWorksStudio/EasyLauncher/issues/130)) - ([6b72000](https://github.com/DroidWorksStudio/EasyLauncher/commit/6b72000c6033f68499ae76a0865b7109c7a464c0))
- Added a default search engine so can use other apps other then ones selected - ([630e5c6](https://github.com/DroidWorksStudio/EasyLauncher/commit/630e5c6b2c765fc6abc481e066c9807ff57036f2))

### Bug Fixes:

- Fixed issue with layoutParams - ([a16b664](https://github.com/DroidWorksStudio/EasyLauncher/commit/a16b664b4d41884e1813a70fb438363679f7b2fa))

### Feature Removal:

- Remove trash files. ([#140](https://github.com/DroidWorksStudio/EasyLauncher/issues/140)) - ([d27ccc8](https://github.com/DroidWorksStudio/EasyLauncher/commit/d27ccc8cf6711d962c1b41504b52d77553d8fa4b))

### Language Support:

- Updated Language Files. ([#143](https://github.com/DroidWorksStudio/EasyLauncher/issues/143)) - ([b535512](https://github.com/DroidWorksStudio/EasyLauncher/commit/b535512a1c288cc8a9fc44cc01fbe1ae80cc5651))
- Updated Language Files. ([#129](https://github.com/DroidWorksStudio/EasyLauncher/issues/129)) - ([80fddba](https://github.com/DroidWorksStudio/EasyLauncher/commit/80fddba64d5f664662809d163a0b17737bcb64b0))

### Releases:

- Prepare for version 0.2.6 - ([b88ccdc](https://github.com/DroidWorksStudio/EasyLauncher/commit/b88ccdc44b05e9d5af662a745560ae1eec58a1e3))

## [0.2.5](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.2.5) - (15, September 2024)

### Bug Fixes:

- Fixed the appIconsSwitchCompat working with the appIconDotsSwitchCompat - ([4e61376](https://github.com/DroidWorksStudio/EasyLauncher/commit/4e61376e4106a5a6e96a5a18523a256044791e80))
- Fixed errors within github files. - ([560f797](https://github.com/DroidWorksStudio/EasyLauncher/commit/560f797f555a93fb4aedc276fbc642c1b9049012))
- Fixed string formatting for numbers in a few places - ([1a66d7e](https://github.com/DroidWorksStudio/EasyLauncher/commit/1a66d7e33a7773067759d4ba9818c7aaf0de7a93))
- Fixed some settings not closing when going home. - ([ad529e8](https://github.com/DroidWorksStudio/EasyLauncher/commit/ad529e855bbedd3ee3c63a0039bd3e2fc7cc800a))
- Fixed home app padding from not working. - ([c00c406](https://github.com/DroidWorksStudio/EasyLauncher/commit/c00c40696b2206d70e6426588a05196c934b75fe))

### Refactoring:

- Fixed manifestPlaceholders - ([2a73828](https://github.com/DroidWorksStudio/EasyLauncher/commit/2a73828dc1eddbfe1185a9d416f528db6d664a8b))
- Cleaned up the way that icons are displayed. - ([afd52c3](https://github.com/DroidWorksStudio/EasyLauncher/commit/afd52c344096ad97a07f5201ee8a52e16d18791c))
- Cleaned up xml files formatting - ([f881685](https://github.com/DroidWorksStudio/EasyLauncher/commit/f8816853d5269ac8e9277e88e760b81857c87c96))

### Releases:

- Prepare for version 0.2.5 - ([1c00b7c](https://github.com/DroidWorksStudio/EasyLauncher/commit/1c00b7cc8a643771a8be134805d6cd261b08443c))

## [0.2.4](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.2.4) - (04, September 2024)

### Implemented Enhancements:

- Added app dot icons. - ([34f32ff](https://github.com/DroidWorksStudio/EasyLauncher/commit/34f32ffffe1a8c25fef0f7a0bc6847e472f3bc16))

### Language Support:

- Updated Language Files. ([#123](https://github.com/DroidWorksStudio/EasyLauncher/issues/123)) - ([fc2c278](https://github.com/DroidWorksStudio/EasyLauncher/commit/fc2c2781477ba055771050983886ff26f204c60f))
- Updated Language Files. ([#122](https://github.com/DroidWorksStudio/EasyLauncher/issues/122)) - ([3df2179](https://github.com/DroidWorksStudio/EasyLauncher/commit/3df217918eb699aa3a721c294ac23a1df5a8772b))
- Updated Language Files. ([#121](https://github.com/DroidWorksStudio/EasyLauncher/issues/121)) - ([796dac1](https://github.com/DroidWorksStudio/EasyLauncher/commit/796dac1d65b2e1d7ba9395212d62309b453cc2a9))

### Refactoring:

- Made dots only work with left align apps on home screen. - ([e9fa768](https://github.com/DroidWorksStudio/EasyLauncher/commit/e9fa7682284957e12b023b8451c68248da8a7257))

### Releases:

- Prepare for version 0.2.4 - ([4533b6e](https://github.com/DroidWorksStudio/EasyLauncher/commit/4533b6e807db37a1e73620659bc2475d5a7b27b3))

## [0.2.3](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.2.3) - (24, August 2024)

### Bug Fixes:

- Added better support for work profiles. - ([9163334](https://github.com/DroidWorksStudio/EasyLauncher/commit/9163334c9d69a9fb495abe2db06fd141bc6bd802))
- Fixed back button from breaking - ([8771956](https://github.com/DroidWorksStudio/EasyLauncher/commit/8771956e4b28c235004baef14ad1db062519ecd1))
- Added the main touchArea back. - ([9f7c0ef](https://github.com/DroidWorksStudio/EasyLauncher/commit/9f7c0eff62c4eee0db19208e43666971c3e5d8b2))
- Fixed the touch area for HomeFragment - ([5c77a23](https://github.com/DroidWorksStudio/EasyLauncher/commit/5c77a238d5b6cf06b5607fc1c24a65ab51661f11))
- Fixed reload app bug. - ([ba5f5ef](https://github.com/DroidWorksStudio/EasyLauncher/commit/ba5f5ef85caf7d5815dba839361f0ca929e147dc))
- Fixed home press - ([2860bcc](https://github.com/DroidWorksStudio/EasyLauncher/commit/2860bcc9cd33ac6fa78207f470ece49ea260fb2d))

### Dependency Updates:

- Updated version numbers for libraries - ([1d2d933](https://github.com/DroidWorksStudio/EasyLauncher/commit/1d2d933b12fbf97f669a74f5cb7385639848c4ec))

### Refactoring:

- Added better support for work profiles. - ([9163334](https://github.com/DroidWorksStudio/EasyLauncher/commit/9163334c9d69a9fb495abe2db06fd141bc6bd802))
- Set targetSdk to Android 14 - ([3408a5f](https://github.com/DroidWorksStudio/EasyLauncher/commit/3408a5fc661f6ef238e000c9def8a33d3a0e6223))
- Updated github workflow for changelog - ([b5a8814](https://github.com/DroidWorksStudio/EasyLauncher/commit/b5a8814ef916f01fd6c1f6ede27c6fb8b02e35b0))
- Updated github workflows - ([f57537a](https://github.com/DroidWorksStudio/EasyLauncher/commit/f57537a70998fafd2bae18af3da19aa63b9005e9))
- Code Cleanup - ([a9e55e2](https://github.com/DroidWorksStudio/EasyLauncher/commit/a9e55e2fbec764fedc5ab51abd85665d40ac5aa5))
- Updated Patched Fonts - ([8386bb2](https://github.com/DroidWorksStudio/EasyLauncher/commit/8386bb218dbdd35a788a42e5cc789e9edebfe4a6))

### Releases:

- Prepare for version 0.2.3 - ([3931624](https://github.com/DroidWorksStudio/EasyLauncher/commit/3931624f2514f9b0d43b563643c0c1f928c3ec92))

## [0.2.2](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.2.2) - (29, July 2024)

### Bug Fixes:

- Fixed the App update helper - ([57a680d](https://github.com/DroidWorksStudio/EasyLauncher/commit/57a680d96befddb38fccc8d7e1078e8d9382a08c))
- Android 15: Fixed the set default launcher. - ([3fd3dc4](https://github.com/DroidWorksStudio/EasyLauncher/commit/3fd3dc49d9a9a28a4eff5597d027b323fb3a11f6))

### Releases:

- Prepare for version 0.2.2 - ([0a28ef7](https://github.com/DroidWorksStudio/EasyLauncher/commit/0a28ef74485fb5cd64a7519c4b74dfe8b5f327f2))

## [0.2.1](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.2.1) - (22, July 2024)

### Bug Fixes:

- Fixed the weather widget showing sunset and sunrise - ([9ca2cfa](https://github.com/DroidWorksStudio/EasyLauncher/commit/9ca2cfa03a9e88b68e48cbd12208fd58971b1ae1))
- Fixed primitive.isNumber for loadFromString - ([bb5a363](https://github.com/DroidWorksStudio/EasyLauncher/commit/bb5a36310179891186a0340f2311a1abea523c20))
- Fixed Json Deserializer for loadFromString - ([9f91945](https://github.com/DroidWorksStudio/EasyLauncher/commit/9f91945b1ac40dd08a1380e2dd1b62ac8e6f0c43))
- Fixed the home screen elements to hide when disabled. - ([6c6db81](https://github.com/DroidWorksStudio/EasyLauncher/commit/6c6db81498b18b76019b1762a0a72529a265bf4b))

### Feature Removal:

- Removed gitguardian.yaml - ([0c1ab69](https://github.com/DroidWorksStudio/EasyLauncher/commit/0c1ab693996cd154df6ac625d5cd4bfbfbb228f6))

### Language Support:

- Updated Language Files. ([#103](https://github.com/DroidWorksStudio/EasyLauncher/issues/103)) - ([dd2b907](https://github.com/DroidWorksStudio/EasyLauncher/commit/dd2b907a0e7010f3c06a1b1806b554beeb79ff6d))

### Refactoring:

- Changed the time for checking updates and weather. - ([ad2f907](https://github.com/DroidWorksStudio/EasyLauncher/commit/ad2f907b33dae8a1ca7b36fa79ef276725207a08))
- Setting dayNightMod to be 80% instead of 10% - ([86b2797](https://github.com/DroidWorksStudio/EasyLauncher/commit/86b27976ba3ec8090b6bfd5f41897ea914e6a1ae))

## [0.2.0](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.2.0) - (18, July 2024)

### Implemented Enhancements:

- Added placeholder text when no fave or hidden apps. - ([69742ab](https://github.com/DroidWorksStudio/EasyLauncher/commit/69742ab82fdbbe9b4f80bb913038f76264d4ec46))

### Bug Fixes:

- Fixed issue where backup was not doing numbers currently. - ([f18b4e3](https://github.com/DroidWorksStudio/EasyLauncher/commit/f18b4e394cd8c3113c7cc1774513adcb8a470762))
- Fixed the porguard rules - ([414101d](https://github.com/DroidWorksStudio/EasyLauncher/commit/414101d18463dce7c55aafca023dd129863f50b7))
- Fixed badge color - ([b2e39c2](https://github.com/DroidWorksStudio/EasyLauncher/commit/b2e39c2878db9b04cf47dc0d147d017c4ce0352a))
- Fixed weather icons to show correctly. - ([d60a935](https://github.com/DroidWorksStudio/EasyLauncher/commit/d60a935338a2c8a4e24e2ea82c303f927e2a0815))
- Fixed settings if cleared - ([e5b0197](https://github.com/DroidWorksStudio/EasyLauncher/commit/e5b0197e3dc79536838a93434a784119c6332b38))
- App name Gravity and Layout Params. - ([7622aa6](https://github.com/DroidWorksStudio/EasyLauncher/commit/7622aa68ca7eb5d8698a090778138f64063eebba))
- Allow decimal numbers in the settings. - ([78d9be6](https://github.com/DroidWorksStudio/EasyLauncher/commit/78d9be692ab56cace0d777b8b79d3a75dd2251c1))
- Set default colors depending on if nightMode or not. - ([d02f873](https://github.com/DroidWorksStudio/EasyLauncher/commit/d02f873a7039a0762488dc497e371de8957eb13a))
- Fixed the appSelectionDialog from not closing right. - ([3efe245](https://github.com/DroidWorksStudio/EasyLauncher/commit/3efe24503c40a2902a075707a8c87a25332b45bf))

### Dependency Updates:

- Updated version numbers for libraries - ([e384206](https://github.com/DroidWorksStudio/EasyLauncher/commit/e3842066521b0f2d521ffe1514a7635945e1e530))

### Housekeeping:

- Cleanup dead imports. - ([69c989e](https://github.com/DroidWorksStudio/EasyLauncher/commit/69c989e9a09f685ae7fb5e954de22c6ef7a66aab))
- Cleaned up the Readme File screenshots - ([ae2d841](https://github.com/DroidWorksStudio/EasyLauncher/commit/ae2d84124e5424712cf2f95a0fd07c90963db78f))
- Moved Word-of-the-day strings to there own file. - ([c727bfe](https://github.com/DroidWorksStudio/EasyLauncher/commit/c727bfec873b1f755d477e8b86239d2ff2620ee5))
- Making the issue types a bit better. - ([64593af](https://github.com/DroidWorksStudio/EasyLauncher/commit/64593af2b8fff6d1acd44880fa12336bacf091f7))

### Language Support:

- Updated Language Files. ([#98](https://github.com/DroidWorksStudio/EasyLauncher/issues/98)) - ([ac044fb](https://github.com/DroidWorksStudio/EasyLauncher/commit/ac044fbd3d6efa9a67f2b56fbdae862460b66eee))
- Updated Language Files. ([#97](https://github.com/DroidWorksStudio/EasyLauncher/issues/97)) - ([c27564c](https://github.com/DroidWorksStudio/EasyLauncher/commit/c27564ccae221996b6eb3e813072f496cec2e22b))
- Updated Language Files. ([#96](https://github.com/DroidWorksStudio/EasyLauncher/issues/96)) - ([5bec848](https://github.com/DroidWorksStudio/EasyLauncher/commit/5bec84825003560ae58c160579301c6f8f356626))

### Refactoring:

- Added NerdFont to custom fonts - ([48313fb](https://github.com/DroidWorksStudio/EasyLauncher/commit/48313fb3b0c1dbe9af534ac9014e24d865467f60))
- Made the backup system better so users chose the location. - ([623d2ab](https://github.com/DroidWorksStudio/EasyLauncher/commit/623d2ab633319a3b8c481de24cf82430bca821b7))
- Changed the settings for appDrawName to math the other holder names. - ([f9f49f0](https://github.com/DroidWorksStudio/EasyLauncher/commit/f9f49f0d8279da322cd277055e2b3e4a9036c64e))
- Disable Script Fonts - ([f3946dc](https://github.com/DroidWorksStudio/EasyLauncher/commit/f3946dc236cc670c0050cedf8e2b71aecd3a8eb6))

### Releases:

- Prepare for version 0.2.0 - ([6981953](https://github.com/DroidWorksStudio/EasyLauncher/commit/6981953fbb2b6ce24dcde2ff52bfb47582018ac8))

## [0.1.9](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.1.9) - (09, July 2024)

### Implemented Enhancements:

- Added support for open app via gesture. - ([e600252](https://github.com/DroidWorksStudio/EasyLauncher/commit/e6002526020a2c19c4dbb094ac830ed458680fbc))

### Bug Fixes:

- Fix. Fixed location permissions - ([42a806d](https://github.com/DroidWorksStudio/EasyLauncher/commit/42a806d15368d802f0c01b152d3adc588577b5e1))
- Fix. Fixed onProviderEnabled and onProviderDisabled for LocationListener - ([60374fe](https://github.com/DroidWorksStudio/EasyLauncher/commit/60374fe6b1634e10c5fdd85bf369b6fdd9fd6476))
- Fixed nightly builds to not overlap with other versions - ([e8d6a9a](https://github.com/DroidWorksStudio/EasyLauncher/commit/e8d6a9abf5463ea5f7670c40962f5a61a3fa2787))
- Fixed the download update to install the internet build. - ([124c4d9](https://github.com/DroidWorksStudio/EasyLauncher/commit/124c4d91aecedabe2c19b58cd09e5e315c407f92))

### Language Support:

- Updated Language Files. ([#91](https://github.com/DroidWorksStudio/EasyLauncher/issues/91)) - ([ceeba28](https://github.com/DroidWorksStudio/EasyLauncher/commit/ceeba281e3b47a170524413b4adfac98d1de36dd))

### Refactoring:

- Added more information onto the README - ([db40f39](https://github.com/DroidWorksStudio/EasyLauncher/commit/db40f39edc2cc0d1dc1abe328b865e21acd1310c))
- Cleanup workflow files - ([43c51a9](https://github.com/DroidWorksStudio/EasyLauncher/commit/43c51a9e35f7c2100ae2f4bf30885820d8434dc5))
- Removed unused code. - ([6034d34](https://github.com/DroidWorksStudio/EasyLauncher/commit/6034d34827704e11665b7ebe4339a5e4327c2b86))

### Releases:

- Prepare for version 0.1.9 - ([4ed1592](https://github.com/DroidWorksStudio/EasyLauncher/commit/4ed159262be81a870b89ab2d134184de895580b2))

## [0.1.8](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.1.8) - (06, July 2024)

### Implemented Enhancements:

- Added Dotness font as requested. - ([1340ad9](https://github.com/DroidWorksStudio/EasyLauncher/commit/1340ad99fb78bdca660f23597e383fe4582041a1))
- Added GreatVibes font as requested. - ([2c8c04d](https://github.com/DroidWorksStudio/EasyLauncher/commit/2c8c04d61530815cf1822267b6d64c5fd5d840e6))
- Added 3 new fonts to select from. - ([50d59e7](https://github.com/DroidWorksStudio/EasyLauncher/commit/50d59e715ef2eaa613d9f47ad877ebc75b78d2c1))

### Bug Fixes:

- Fixed the withoutInternet build from trying to find new build. - ([b830eed](https://github.com/DroidWorksStudio/EasyLauncher/commit/b830eedfd692376d0dddba148428447cda4587ba))
- Fixed locked apps to also allow DEVICE_CREDENTIAL not only Fingerprint - ([d2a0faf](https://github.com/DroidWorksStudio/EasyLauncher/commit/d2a0faf31e160482fdef4656a1f5135fe7647d73))
- Fixed error with fetchWeatherData not finding url. - ([6d32eed](https://github.com/DroidWorksStudio/EasyLauncher/commit/6d32eedbe1ba0371b42e3be91db16d22721a478c))

### Language Support:

- Updated Language Files. ([#87](https://github.com/DroidWorksStudio/EasyLauncher/issues/87)) - ([ac92fa7](https://github.com/DroidWorksStudio/EasyLauncher/commit/ac92fa7f68a7de60ae48b82e70a5835c5663e95c))

### Refactoring:

- Changed Dotness font name. - ([c98e008](https://github.com/DroidWorksStudio/EasyLauncher/commit/c98e008bf919e4e21b0c251c2bc1fbc384e13d76))
- Cleaned up code for HomeViewHolder. - ([9956333](https://github.com/DroidWorksStudio/EasyLauncher/commit/9956333323f94586f6b8136467d04e4f8627ddc9))

### Releases:

- Prepare for version 0.1.8 - ([6c151f0](https://github.com/DroidWorksStudio/EasyLauncher/commit/6c151f088cfc13314b9b52c53b66dca14adcf78d))

## [0.1.7](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.1.7) - (05, July 2024)

### Implemented Enhancements:

- Added font selection to select font used throughout the launcher - ([e125d44](https://github.com/DroidWorksStudio/EasyLauncher/commit/e125d443bb5635744e76608381e72b3437511e1c))

### Bug Fixes:

- Fixed a font name in strings. - ([1ea3899](https://github.com/DroidWorksStudio/EasyLauncher/commit/1ea3899b767ed026ee5f8cc4301814f34dab475b))
- Fixed the UpdateManager so that it can now get the apkUrl correctly - ([2024635](https://github.com/DroidWorksStudio/EasyLauncher/commit/2024635046c842578ea33bae00370e021e20ed33))
- Fixed the update manager to work when reloading app. - ([69dc514](https://github.com/DroidWorksStudio/EasyLauncher/commit/69dc514407dc6d165ae043f04d47b41df8b0f1ec))
- Fixed acra_mail_body string - ([ef4bec6](https://github.com/DroidWorksStudio/EasyLauncher/commit/ef4bec64f9feb75188a6f10b078ccf7317fb20ef))
- Fixed the issue report urls for the wiki. - ([9a1fe83](https://github.com/DroidWorksStudio/EasyLauncher/commit/9a1fe83330f7797133769513370562d270903f9c))

### Dependency Updates:

- Updated the dependencies for the launcher. - ([cb91acf](https://github.com/DroidWorksStudio/EasyLauncher/commit/cb91acf50855c7f5c0ae56a68bf012d5f27e5ed2))

### Language Support:

- Updated Language Files. ([#83](https://github.com/DroidWorksStudio/EasyLauncher/issues/83)) - ([e2bb543](https://github.com/DroidWorksStudio/EasyLauncher/commit/e2bb5430cd68cc5a84c286d3622876e953d2f1ba))
- Updated Language Files. ([#81](https://github.com/DroidWorksStudio/EasyLauncher/issues/81)) - ([9d825fa](https://github.com/DroidWorksStudio/EasyLauncher/commit/9d825fa3c992d245000299f610b19f9280dd0ee7))
- Updated Language Files. ([#78](https://github.com/DroidWorksStudio/EasyLauncher/issues/78)) - ([2d743f8](https://github.com/DroidWorksStudio/EasyLauncher/commit/2d743f8706cc1cf47e0c20d625f183c92f344027))

### Releases:

- Prepare for version 0.1.7 - ([3e1dd98](https://github.com/DroidWorksStudio/EasyLauncher/commit/3e1dd982254444f2e55551f475c2a3056f13b05c))

## [0.1.6](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.1.6) - (17, June 2024)

### Implemented Enhancements:

- Added a toggle for sun set and sun rise info. - ([0cb3aa6](https://github.com/DroidWorksStudio/EasyLauncher/commit/0cb3aa6729174ebd0778454381d9b59163112a34))
- Added crash report system. - ([66eb7c1](https://github.com/DroidWorksStudio/EasyLauncher/commit/66eb7c123ec209458f66d1b42774f78ca32fd577))

### Bug Fixes:

- Fixed the navigation well adding hidden apps to swipes - ([aa030e4](https://github.com/DroidWorksStudio/EasyLauncher/commit/aa030e46355eda676152427d9d69745112a2e7c8))
- Fixed the hasInternetPermission stuff to run every time the app runs not just on install. - ([9db3a6c](https://github.com/DroidWorksStudio/EasyLauncher/commit/9db3a6c55d43e39ccaedab5b4521595aaa85d83b))

### Housekeeping:

- Removed the unneeded Prefs files - ([0430108](https://github.com/DroidWorksStudio/EasyLauncher/commit/043010812c84cc104edeb16a7832a5f84ffb7e95))

### Language Support:

- Updated Language Files. ([#77](https://github.com/DroidWorksStudio/EasyLauncher/issues/77)) - ([a572872](https://github.com/DroidWorksStudio/EasyLauncher/commit/a5728721ad629796a9232687894eef1a208311dc))
- Updated Language Files. ([#76](https://github.com/DroidWorksStudio/EasyLauncher/issues/76)) - ([ccf5964](https://github.com/DroidWorksStudio/EasyLauncher/commit/ccf5964435f1591d5fa6b4da0a56f4c1dee50fd1))

### Refactoring:

- Moved the Adapters to there correct locations. - ([ff990ba](https://github.com/DroidWorksStudio/EasyLauncher/commit/ff990ba7ef100b23c5331485f09be2c8bb3e4ab2))

### Releases:

- Prepare for version 0.1.6 - ([9dbe1a3](https://github.com/DroidWorksStudio/EasyLauncher/commit/9dbe1a3f91c73d9ccfa71f3d9e745c83cf39ca49))

## [0.1.5](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.1.5) - (16, June 2024)

### Implemented Enhancements:

- Added sunset and sunrise to weather widget. - ([63465c0](https://github.com/DroidWorksStudio/EasyLauncher/commit/63465c088ed1bf530b6861fef6f5e816004f101a))

### Bug Fixes:

- Selected Search engine on wrong element. - ([1857c2d](https://github.com/DroidWorksStudio/EasyLauncher/commit/1857c2d267b7ca455c4f02925a718f75cbbb1752))
- Fixed the way the app is navigated. - ([ec3a88d](https://github.com/DroidWorksStudio/EasyLauncher/commit/ec3a88dc5790fe66809664496c10c23ada96ded5))
- Fixed the last updated time. - ([806ea26](https://github.com/DroidWorksStudio/EasyLauncher/commit/806ea2616b33a81e37e1a1d5582cc5008b87e348))
- Fixed the battery current and voltage numbers. - ([e0256f8](https://github.com/DroidWorksStudio/EasyLauncher/commit/e0256f823c29f30b9654f167a5190851b97c42e6))

### Housekeeping:

- Cleared UnNeeded resValue - ([3b883d3](https://github.com/DroidWorksStudio/EasyLauncher/commit/3b883d360e75ade568bf6c270dc767bd692177de))

### Language Support:

- Updated Language Files. ([#68](https://github.com/DroidWorksStudio/EasyLauncher/issues/68)) - ([bf48342](https://github.com/DroidWorksStudio/EasyLauncher/commit/bf48342ae32ac1f8feb84b9cf0430e090ed5f107))

### Refactoring:

- Made backup system more advanced. - ([6533a3c](https://github.com/DroidWorksStudio/EasyLauncher/commit/6533a3c0bebca63396f2ccc223cecc34200c384d))
- Removed the need for forcing API version - ([1be632d](https://github.com/DroidWorksStudio/EasyLauncher/commit/1be632d82363b2da0d41fb041e3bb64826517843))

### Releases:

- Prepare for version 0.1.5 - ([18846a2](https://github.com/DroidWorksStudio/EasyLauncher/commit/18846a25c1d912a5dc9a0aec555489f596e1e321))

## [0.1.4](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.1.4) - (10, June 2024)

### Implemented Enhancements:

- Added auto update. - ([2dcb4ae](https://github.com/DroidWorksStudio/EasyLauncher/commit/2dcb4ae4b8dacb229ae4664470cbb3b08d8348b4))
- Fixed settings location to click. - ([c5e9117](https://github.com/DroidWorksStudio/EasyLauncher/commit/c5e91179deedceee9be795f81552a5d141448ec5))

### Housekeeping:

- Removed unneeded imports - ([5066d2b](https://github.com/DroidWorksStudio/EasyLauncher/commit/5066d2b3598e2ff0a4db9a3618dd157134659839))

### Language Support:

- Updated Language Files. ([#66](https://github.com/DroidWorksStudio/EasyLauncher/issues/66)) - ([3b95995](https://github.com/DroidWorksStudio/EasyLauncher/commit/3b959953e0e6fa54e1a4d6db7a63fa8afddbe413))
- Updated Language Files. ([#62](https://github.com/DroidWorksStudio/EasyLauncher/issues/62)) - ([803f47f](https://github.com/DroidWorksStudio/EasyLauncher/commit/803f47f6b0e8408e79f73bb3c02ce434a42e3955))

### Refactoring:

- Refactored the settings for widgets. - ([91d34ae](https://github.com/DroidWorksStudio/EasyLauncher/commit/91d34ae6b37a9efc51eda98d6d0351b2c9ce6a50))

### Releases:

- Prepare for version 0.1.4 - ([db9a390](https://github.com/DroidWorksStudio/EasyLauncher/commit/db9a39000ce1200b39738a5bd75853989a35c5de))

## [0.1.3](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.1.3) - (09, June 2024)

### Implemented Enhancements:

- Added batter status widget. - ([316b755](https://github.com/DroidWorksStudio/EasyLauncher/commit/316b755eaddfe9cf53f6c82bfd0368ac461baf91))
- Add icon to weather widget. - ([75afa09](https://github.com/DroidWorksStudio/EasyLauncher/commit/75afa09bea44e66b8c09cc437529e6fa7b933dad))

### Bug Fixes:

- Fixed some widget elements colors. - ([581b142](https://github.com/DroidWorksStudio/EasyLauncher/commit/581b142b43c3084afc7a28713e2cb98f130500a7))

### Language Support:

- Updated Language Files. ([#60](https://github.com/DroidWorksStudio/EasyLauncher/issues/60)) - ([b22d67f](https://github.com/DroidWorksStudio/EasyLauncher/commit/b22d67fdf552a3d73c829525297b09e932cffb86))

### Refactoring:

- Reduce animation timers. - ([84d948f](https://github.com/DroidWorksStudio/EasyLauncher/commit/84d948f8d1eb333e8d1e56203019304b98429249))

### Releases:

- Prepare for version 0.1.3 - ([3d6fbd3](https://github.com/DroidWorksStudio/EasyLauncher/commit/3d6fbd3baf44aefc34ed607f7ccef66d94e15deb))

## [0.1.2](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.1.2) - (07, June 2024)

### Implemented Enhancements:

- Updated the app icon. - ([1e1b81c](https://github.com/DroidWorksStudio/EasyLauncher/commit/1e1b81cf83341e28c43efb788a86e5d99d061ef4))
- Added custom gestures. - ([924e052](https://github.com/DroidWorksStudio/EasyLauncher/commit/924e052598c9f4c8cd990a2d9e0cdb73c4e1dcfa))

### Bug Fixes:

- Fixed proguard building - ([80ecd90](https://github.com/DroidWorksStudio/EasyLauncher/commit/80ecd906e731b14b276944fb3ee07578fd079822))
- Fixed a workflow so it works correctly - ([773a2f5](https://github.com/DroidWorksStudio/EasyLauncher/commit/773a2f546f218f040ce6cf2666692d18818b65d1))

### Dependency Updates:

- Updated Dependencies - ([8e796ca](https://github.com/DroidWorksStudio/EasyLauncher/commit/8e796ca2fe95aa039873c5b47db7ed50dafdbacc))

### Housekeeping:

- Moved around a few files to be cleaner. - ([0677e37](https://github.com/DroidWorksStudio/EasyLauncher/commit/0677e3792cfa662625010d4fa733ae5e87318e54))

### Language Support:

- Updated Language Files. ([#52](https://github.com/DroidWorksStudio/EasyLauncher/issues/52)) - ([e73fabb](https://github.com/DroidWorksStudio/EasyLauncher/commit/e73fabb85a739a358867741fc696b10a05ed8670))
- Updated Language Files. ([#51](https://github.com/DroidWorksStudio/EasyLauncher/issues/51)) - ([8c4ac73](https://github.com/DroidWorksStudio/EasyLauncher/commit/8c4ac73bbf541c4d21c8d403556761326752cd40))
- Updated Language Files. ([#50](https://github.com/DroidWorksStudio/EasyLauncher/issues/50)) - ([81d2242](https://github.com/DroidWorksStudio/EasyLauncher/commit/81d2242b9715d0b47c72391cf985bf7e2359161b))

### Refactoring:

- More widget stuff and fixing of files. - ([327f144](https://github.com/DroidWorksStudio/EasyLauncher/commit/327f1447a77a4fe9f18aeaa6a98700e85e3d25bc))
- Moved the getActionType function into AppHelper class. - ([48b2913](https://github.com/DroidWorksStudio/EasyLauncher/commit/48b2913797a46857df9ec89348bb1b9e01164c81))
- Added widget page to the gestures. - ([94fe747](https://github.com/DroidWorksStudio/EasyLauncher/commit/94fe747ffdfc869237c1dd200966cda8e2b2fe23))

### Reverts:

- Revert "chore(deps): bump androidx.biometric:biometric-ktx ([#53](https://github.com/DroidWorksStudio/EasyLauncher/issues/53))" ([#54](https://github.com/DroidWorksStudio/EasyLauncher/issues/54)) - ([623a353](https://github.com/DroidWorksStudio/EasyLauncher/commit/623a353de56aabf7cf7c4c2cf89ecd80f79a00ff))

## [0.1.1](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.1.1) - (01, June 2024)

### Implemented Enhancements:

- Added extra search engines to the settings. - ([0d2527a](https://github.com/DroidWorksStudio/EasyLauncher/commit/0d2527a1a2753c417a8aa218ace784eb4d50f05f))
- Display app icons in more places if enabled. - ([8311d29](https://github.com/DroidWorksStudio/EasyLauncher/commit/8311d29cedc1e11a9c43ddf465fbfac0d2502b5c))
- Cleaned up backup system to save in a better location. - ([8bbc3b9](https://github.com/DroidWorksStudio/EasyLauncher/commit/8bbc3b9b9569d3dcf589e6ebd85fe27da88e2f41))
- Added a battery icon. - ([d3c12a6](https://github.com/DroidWorksStudio/EasyLauncher/commit/d3c12a6c3765e2a233b85344a80bee85c6da4a33))

### Bug Fixes:

- Fixed locked apps - ([1e0d775](https://github.com/DroidWorksStudio/EasyLauncher/commit/1e0d7755c68898bb0850c484d3f5c9fd35e2eb7b))
- Fixed the font used for home page. - ([62fb291](https://github.com/DroidWorksStudio/EasyLauncher/commit/62fb291c32373ffb8aa80aab3f4865aaa6b3963d))

### Feature Removal:

- Removed the over use of app colors. - ([5f7ae81](https://github.com/DroidWorksStudio/EasyLauncher/commit/5f7ae818fe859fe48213158298077af570711360))

### Language Support:

- Updated Language Files. ([#48](https://github.com/DroidWorksStudio/EasyLauncher/issues/48)) - ([94abcb4](https://github.com/DroidWorksStudio/EasyLauncher/commit/94abcb4d4cfa88f318ab271542bb2c379f49e750))

### Refactoring:

- Replace app icon. - ([4f32f69](https://github.com/DroidWorksStudio/EasyLauncher/commit/4f32f696db2f8bf26fb0be34369ae36dd1bdf078))

### Releases:

- Prepare for version 0.1.1 - ([3b93fa0](https://github.com/DroidWorksStudio/EasyLauncher/commit/3b93fa0ba0ae5245bac08ba78a111ea627c15584))

## [0.1.0](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.1.0) - (28, May 2024)

### Implemented Enhancements:

- Added work profile support with icon. - ([e61a989](https://github.com/DroidWorksStudio/EasyLauncher/commit/e61a9894b2a0bcde0531b8afb0600f8981fe39ea))
- Added app font color to headers of the page. - ([b7ff0d8](https://github.com/DroidWorksStudio/EasyLauncher/commit/b7ff0d8b1ab1de914a9336b98cdb6ec737b10c5b))

### Refactoring:

- Made the animations longer. - ([3136e85](https://github.com/DroidWorksStudio/EasyLauncher/commit/3136e854951901ec00f9f77f333880eaf60579cc))

## [0.0.9](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.0.9) - (27, May 2024)

### Bug Fixes:

- Fixed the search in all apps feature. - ([db64779](https://github.com/DroidWorksStudio/EasyLauncher/commit/db64779260787861c87da233bcf768f9e8f27926))

### Housekeeping:

- Cleaned up functions and deleted AppExtensions - ([707e4e0](https://github.com/DroidWorksStudio/EasyLauncher/commit/707e4e01ba3ea05a809e9a80d2d22aa0b990b46d))

### Language Support:

- Updated Language Files. ([#39](https://github.com/DroidWorksStudio/EasyLauncher/issues/39)) - ([967c651](https://github.com/DroidWorksStudio/EasyLauncher/commit/967c651f6908974334fa18c846652aaeaafd31c2))
- Updated Language Files. ([#38](https://github.com/DroidWorksStudio/EasyLauncher/issues/38)) - ([de423cf](https://github.com/DroidWorksStudio/EasyLauncher/commit/de423cfff1c442ac85a49d3c54bac26a2b6ef820))

### Refactoring:

- Cleaned up the f-droid about page. - ([6ff0374](https://github.com/DroidWorksStudio/EasyLauncher/commit/6ff03745dab5653616011f74e084416c359471c3))
- Moved functions into there correct folders. - ([e45a918](https://github.com/DroidWorksStudio/EasyLauncher/commit/e45a918fb0d6ee81ab883886934e1473457368d0))
- Moved to a better location. - ([d6d7f6f](https://github.com/DroidWorksStudio/EasyLauncher/commit/d6d7f6f7214d71bf08aeae6fce109fe4e5e3aff0))

## [0.0.8](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.0.8) - (26, May 2024)

### Bug Fixes:

- Fixed a few database bugs - ([c998942](https://github.com/DroidWorksStudio/EasyLauncher/commit/c9989428959d6250225f6cb3b5f1d18ddd7cacba))
- Fixed navigation and click issues. - ([b297fb2](https://github.com/DroidWorksStudio/EasyLauncher/commit/b297fb246016787011888151c2cb2a10ae7a7811))
- Fixed the home screen not being reset. - ([80c9ccd](https://github.com/DroidWorksStudio/EasyLauncher/commit/80c9ccd163e414cd2f9c1b90dc36582fba18457e))

### Language Support:

- Updated Language Files. ([#35](https://github.com/DroidWorksStudio/EasyLauncher/issues/35)) - ([16e03a4](https://github.com/DroidWorksStudio/EasyLauncher/commit/16e03a4ba7425aad090e5cf5322f3a9851e33d06))
- Updated Language Files. ([#33](https://github.com/DroidWorksStudio/EasyLauncher/issues/33)) - ([906c5fd](https://github.com/DroidWorksStudio/EasyLauncher/commit/906c5fd08b4d1b044641245732f958178edd1738))
- Updated Language Files. ([#29](https://github.com/DroidWorksStudio/EasyLauncher/issues/29)) - ([103c4e2](https://github.com/DroidWorksStudio/EasyLauncher/commit/103c4e26dc10d9389602d05fa5570faa0ca3e0e1))

### Refactoring:

- Created  more usable functions. - ([bd23849](https://github.com/DroidWorksStudio/EasyLauncher/commit/bd23849c536268d583afcbb1b4fe416a48f90eae))
- Worked out a better way for moving around the app. - ([8b1c0a3](https://github.com/DroidWorksStudio/EasyLauncher/commit/8b1c0a390de1bf3ab7bb9f6162adfb68257ba1fc))
- Cleaned up some TODO junk. - ([45181ba](https://github.com/DroidWorksStudio/EasyLauncher/commit/45181baee8b443d3b0050e7f72568fe5c10a628e))
- Cleaned up the way that we move between fragments - ([9e05fe7](https://github.com/DroidWorksStudio/EasyLauncher/commit/9e05fe7c38a3ddeb08696bf33b3afa038148321c))
- Cleaned up a few functions - ([355096c](https://github.com/DroidWorksStudio/EasyLauncher/commit/355096c20b3c1c7dc2d8e120b73d393340074192))

## [0.0.7](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.0.7) - (22, May 2024)

### Implemented Enhancements:

- Basic starter to add Widget support. - ([a3c4e6f](https://github.com/DroidWorksStudio/EasyLauncher/commit/a3c4e6f0af2eb8e71bc78f9f7d8fe653bf697ffd))

### Language Support:

- Updated Language Files. ([#26](https://github.com/DroidWorksStudio/EasyLauncher/issues/26)) - ([3335975](https://github.com/DroidWorksStudio/EasyLauncher/commit/333597534d31aa68fcb584b1f5b282877b90ed2a))

### Refactoring:

- Added libs file to use Kotlin DLS - ([4e2e41c](https://github.com/DroidWorksStudio/EasyLauncher/commit/4e2e41ce198888e2db25cbe429097de9a24f588e))

## [0.0.6](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.0.6) - (21, May 2024)

### Implemented Enhancements:

- Added Basic Backup / Restore Feature - ([f6c1f9d](https://github.com/DroidWorksStudio/EasyLauncher/commit/f6c1f9d0f6e48821ca9bb9dc2142f12e12d3a7d6))

### Bug Fixes:

- Fixed a few DEPRECATION warning. - ([7dfddc7](https://github.com/DroidWorksStudio/EasyLauncher/commit/7dfddc79452203716716e6688b180566ef07668e))
- Fixed the keyboard from displaying wrong. - ([3d5c704](https://github.com/DroidWorksStudio/EasyLauncher/commit/3d5c70449756d8335a2b47bc85f3f70673b1a707))
- Fixed the keyboard from displaying wrong. - ([3d5c704](https://github.com/DroidWorksStudio/EasyLauncher/commit/3d5c70449756d8335a2b47bc85f3f70673b1a707))
- Removed the auto keyboard from homescreen. - ([96c023e](https://github.com/DroidWorksStudio/EasyLauncher/commit/96c023e94464382eadf2b0dbafaabb1e987a77f0))

### Dependency Updates:

- Updated Android Gradle Plugin - ([f760740](https://github.com/DroidWorksStudio/EasyLauncher/commit/f7607402e93427705a8796b2862e11fe1bd80523))

## [0.0.5](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.0.5) - (20, May 2024)

### Dependency Updates:

- Updated a few of the dependencies - ([871d38f](https://github.com/DroidWorksStudio/EasyLauncher/commit/871d38f4101d587eea8df89c3248db598dc141be))

### Language Support:

- Updated Language Files. ([#23](https://github.com/DroidWorksStudio/EasyLauncher/issues/23)) - ([5099282](https://github.com/DroidWorksStudio/EasyLauncher/commit/5099282616d17cf572e5a126dea9e16624d8a052))

### Refactoring:

- Refactor some of the setting to also work other places. - ([72f212e](https://github.com/DroidWorksStudio/EasyLauncher/commit/72f212ec0876a12d98259cd56dd745f9edf03115))

## [0.0.4](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.0.4) - (19, May 2024)

### Language Support:

- Updated Language Files. ([#17](https://github.com/DroidWorksStudio/EasyLauncher/issues/17)) - ([fd6bd42](https://github.com/DroidWorksStudio/EasyLauncher/commit/fd6bd42cc59db33da1f0109f85bff13782939d2d))
- Updated Language Files. ([#15](https://github.com/DroidWorksStudio/EasyLauncher/issues/15)) - ([2e05dc5](https://github.com/DroidWorksStudio/EasyLauncher/commit/2e05dc59da3654eda7ea6d3083460d754c2d9250))

### Refactoring:

- Refactor settings menu for cleaner look. - ([9cddace](https://github.com/DroidWorksStudio/EasyLauncher/commit/9cddace27a378ac945e40ae4cf3072bcd056d260))

## [0.0.3](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.0.3) - (11, May 2024)

### Implemented Enhancements:

- Added Auto keyboard & Auto Open last app toggle settings. - ([f91bd77](https://github.com/DroidWorksStudio/EasyLauncher/commit/f91bd777b270e4b27e9a679478596a0e71f94e07))
- Added setupOrientation to force portrait mode. - ([60114f6](https://github.com/DroidWorksStudio/EasyLauncher/commit/60114f6e27e1efcab923a0090db30df5b2c8185c))

### Bug Fixes:

- Hide self from app list. - ([d494284](https://github.com/DroidWorksStudio/EasyLauncher/commit/d4942849012251cadb0ef991c4b14adfb402cf80))

### Language Support:

- Updated Language Files. ([#12](https://github.com/DroidWorksStudio/EasyLauncher/issues/12)) - ([70a98fd](https://github.com/DroidWorksStudio/EasyLauncher/commit/70a98fda4f40549b6a143bf4360a3809f0614b98))

## [0.0.2](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.0.2) - (11, May 2024)

### Implemented Enhancements:

- Added support to toggle app icons. - ([f2e80ca](https://github.com/DroidWorksStudio/EasyLauncher/commit/f2e80cad634ff7e79b15805b42a1d7e3761f009e))

### Bug Fixes:

- Fixed the Accessibility settings if required. - ([4c19dbb](https://github.com/DroidWorksStudio/EasyLauncher/commit/4c19dbbd7f47dda5e82cdafc4cbd516805180295))

### Language Support:

- Updated Language Files. ([#9](https://github.com/DroidWorksStudio/EasyLauncher/issues/9)) - ([960aea8](https://github.com/DroidWorksStudio/EasyLauncher/commit/960aea882538a5d13403f5f99e10fce0b4a64437))
- Updated Language Files. ([#7](https://github.com/DroidWorksStudio/EasyLauncher/issues/7)) - ([89ef870](https://github.com/DroidWorksStudio/EasyLauncher/commit/89ef870cf40846216ff366e96d9f2ebb766e4a89))

### Refactoring:

- Refactor keyboard handling and UI consistency - ([c7313a9](https://github.com/DroidWorksStudio/EasyLauncher/commit/c7313a9cdd99c1d370e4fadcb4689c327c48904f))

## [0.0.1](https://github.com/DroidWorksStudio/EasyLauncher/tree/0.0.1) - (08, May 2024)

### Implemented Enhancements:

- Added Swipe Actions / Options. - ([94399ab](https://github.com/DroidWorksStudio/EasyLauncher/commit/94399ab9d1daf66fac370701c09da8e8cbf5dbbe))

### Bug Fixes:

- Fixed Others Text/Links - ([e91771f](https://github.com/DroidWorksStudio/EasyLauncher/commit/e91771f4bbf92915e98f758cfb2d261a12cd9adc))

### Refactoring:

- Accessibility actions and helper methods - ([5d3f1fd](https://github.com/DroidWorksStudio/EasyLauncher/commit/5d3f1fd6e377a5c895ba745dfea5bd198dbf1110))

<!-- Generated by DroidWorks Studio -->
