
package app.crossword.yourealwaysbe.forkyzscanner

import android.os.Bundle
import android.view.View
import android.view.ViewGroup.MarginLayoutParams
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.ViewCompat
import androidx.core.view.WindowCompat
import androidx.core.view.WindowInsetsCompat

import app.crossword.yourealwaysbe.forkyzscanner.databinding.HtmlResourceActivityBinding

abstract class ForkyzScannerBaseActivity() : AppCompatActivity() {
    override fun onCreate(savedInstanceState : Bundle?) {
        super.onCreate(savedInstanceState)
        WindowCompat.setDecorFitsSystemWindows(window, false);
    }

    /**
     * Call on the bottommost view so it does not overlap system windows
     *
     * Some views, such as material navigation bar, do it automatically, so no
     * need to call.
     */
    protected fun setupBottomInsets(view : View) {
        val origMlp = view.getLayoutParams() as MarginLayoutParams
        // keep own copies because above object will change with view
        val origLeftMargin = origMlp.leftMargin
        val origBottomMargin = origMlp.bottomMargin
        val origRightMargin = origMlp.rightMargin

        ViewCompat.setOnApplyWindowInsetsListener(
            view,
            { v, windowInsets ->
                val insets = windowInsets.getInsets(
                    WindowInsetsCompat.Type.systemBars() or
                    WindowInsetsCompat.Type.ime()
                )

                val mlp = v.getLayoutParams() as MarginLayoutParams
                mlp.leftMargin = insets.left + origLeftMargin
                mlp.bottomMargin = insets.bottom + origBottomMargin
                mlp.rightMargin = insets.right + origRightMargin
                v.setLayoutParams(mlp)

                WindowInsetsCompat.CONSUMED
            }
        )
    }
}
