---
title: Directories
---

# Repository Folder Structure

Our [GitHub Repository](https://github.com/immich-app/immich) is a [monorepo](https://en.wikipedia.org/wiki/Monorepo) and includes the following folders:

| Folder              | Description                                                          |
| :------------------ | :------------------------------------------------------------------- |
| `.github/`          | Github templates and action workflows                                |
| `.vscode/`          | VSCode debug launch profiles                                         |
| `cli/`              | Source code for the work-in-progress CLI rewrite                     |
| `docker/`           | Docker compose resources for dev, test, production                   |
| `design/`           | Screenshots and logos for the README                                 |
| `docs/`             | Source code for the [https://immich.app](https://immich.app) website |
| `machine-learning/` | Source code for the `immich-machine-learning` docker image           |
| `misc/release/`     | Scripts for version pumps and draft releases                         |
| `mobile/`           | Source code for the mobile app, both Android and iOS                 |
| `nginx/`            | Source code for the `immich-proxy` docker image                      |
| `server/`           | Source code for the `immich-server` docker image                     |
| `web/`              | Source code for the `immich-web` docker image                        |
