import 'package:analyzer/dart/analysis/utilities.dart';
import 'package:analyzer/dart/ast/ast.dart';
import 'package:auto_route/annotations.dart';



final content = '''
final routes = [
   AutoRoute(children: SecondRoutes.routes),
];

class SecondRoutes {
   final routes = [
   AutoRoute(path: '/path2'),
   ];
 }

''';

main() {
  final res = parseString(content: content);
  final vars = (res.unit.declarations.first.childEntities.first as VariableDeclarationList).variables.first;
  final routes = vars.initializer as ListLiteral;
  final firstRoute = routes.elements.first as MethodInvocation;
  print(firstRoute.argumentList.arguments);
}