import 'package:proj4dart/src/classes/point.dart';

import '../classes/project_and_unproject_result.dart';
import '../data/all_proj4_defs.dart' show blackList;

Map<String, ProjectAndUnProjectResult?> get testResults =>
    Map.from(_testResults)
      ..removeWhere((key, value) => blackList.keys.contains(key));

// We converted point [17.888058560281515, 46.89226406700879] with proj4js which gave us forwardResult
// Then we transformed back the forwardResult to calculate inverseResult
final Map<String, ProjectAndUnProjectResult?> _testResults = {
  'EPSG:3819': ProjectAndUnProjectResult(
      Point(x: 17.889590510079564, y: 46.89133824892714),
      Point(x: 17.888058590372236, y: 46.89226407474856)),
  'EPSG:3821': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3824': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3889': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3906': ProjectAndUnProjectResult(
      Point(x: 17.893343028916338, y: 46.89256923369196),
      Point(x: 17.888058599054727, y: 46.89226406925582)),
  'EPSG:4001': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4002': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4003': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4004': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4005': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4006': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4007': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4008': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4009': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4010': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4011': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4012': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4013': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4014': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4015': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4016': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4018': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4019': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4020': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4021': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4022': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4023': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4024': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4025': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4027': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4028': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4029': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4030': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4031': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4032': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4033': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4034': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4035': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4036': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4041': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4042': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4043': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4044': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4045': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4046': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4047': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4052': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4053': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4054': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4055': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4075': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4081': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4120': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4121': ProjectAndUnProjectResult(
      Point(x: 17.886319111822356, y: 46.88964974015317),
      Point(x: 17.888058542379405, y: 46.892264040019356)),
  'EPSG:4122': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4123': ProjectAndUnProjectResult(
      Point(x: 17.890460923808195, y: 46.8927480842039),
      Point(x: 17.888058569538547, y: 46.892264085278)),
  'EPSG:4124': ProjectAndUnProjectResult(
      Point(x: 17.89111683155867, y: 46.89126953091154),
      Point(x: 17.888058586300215, y: 46.89226403037144)),
  'EPSG:4125': ProjectAndUnProjectResult(
      Point(x: 17.877865063178003, y: 46.89024053372384),
      Point(x: 17.888059821808675, y: 46.89226431815993)),
  'EPSG:4126': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4127': ProjectAndUnProjectResult(
      Point(x: 17.88898485101689, y: 46.895099716216706),
      Point(x: 17.888058517270704, y: 46.89226393491842)),
  'EPSG:4128': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4129': ProjectAndUnProjectResult(
      Point(x: 17.88890013291431, y: 46.89541223457047),
      Point(x: 17.88805850618414, y: 46.892263863991445)),
  'EPSG:4130': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4131': ProjectAndUnProjectResult(
      Point(x: 17.87785401620481, y: 46.891679815946205),
      Point(x: 17.888058908121824, y: 46.89226408697101)),
  'EPSG:4132': ProjectAndUnProjectResult(
      Point(x: 17.88912842628545, y: 46.89112739295186),
      Point(x: 17.888058564279664, y: 46.892264062747735)),
  'EPSG:4133': ProjectAndUnProjectResult(
      Point(x: 17.88807258856188, y: 46.89226281494607),
      Point(x: 17.888058560281266, y: 46.89226406700893)),
  'EPSG:4134': ProjectAndUnProjectResult(
      Point(x: 17.88743199286141, y: 46.89231962115489),
      Point(x: 17.888058574321306, y: 46.89226402004299)),
  'EPSG:4135': ProjectAndUnProjectResult(
      Point(x: 17.89186333824403, y: 46.895318810057795),
      Point(x: 17.888058435522446, y: 46.89226396652039)),
  'EPSG:4136': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4137': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4138': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4139': ProjectAndUnProjectResult(
      Point(x: 17.887203787603656, y: 46.89523479110371),
      Point(x: 17.888058574820874, y: 46.892264016316005)),
  'EPSG:4140': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4141': ProjectAndUnProjectResult(
      Point(x: 17.887178288997255, y: 46.8917553671602),
      Point(x: 17.888058557761525, y: 46.89226406554796)),
  'EPSG:4142': ProjectAndUnProjectResult(
      Point(x: 17.88689293822409, y: 46.89185665511521),
      Point(x: 17.888058524356463, y: 46.89226405441292)),
  'EPSG:4143': ProjectAndUnProjectResult(
      Point(x: 17.88689390545708, y: 46.891859446069745),
      Point(x: 17.888058524385777, y: 46.89226405449903)),
  'EPSG:4144': ProjectAndUnProjectResult(
      Point(x: 17.87888016879856, y: 46.89192581137229),
      Point(x: 17.888058932791115, y: 46.89226408076527)),
  'EPSG:4145': ProjectAndUnProjectResult(
      Point(x: 17.880681888395628, y: 46.89233928505992),
      Point(x: 17.888058839897592, y: 46.89226406413963)),
  'EPSG:4146': ProjectAndUnProjectResult(
      Point(x: 17.880055808022465, y: 46.89236328151591),
      Point(x: 17.888058818502056, y: 46.8922640637884)),
  'EPSG:4147': ProjectAndUnProjectResult(
      Point(x: 17.889340620285022, y: 46.892295366381994),
      Point(x: 17.888058566253854, y: 46.892264067155104)),
  'EPSG:4148': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4149': ProjectAndUnProjectResult(
      Point(x: 17.89058897773099, y: 46.893420533895046),
      Point(x: 17.88805857342885, y: 46.89226407303667)),
  'EPSG:4150': ProjectAndUnProjectResult(
      Point(x: 17.89058897773099, y: 46.893420533895046),
      Point(x: 17.88805857342885, y: 46.89226407303667)),
  'EPSG:4151': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4152': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4153': ProjectAndUnProjectResult(
      Point(x: 17.889486693864647, y: 46.89290650862107),
      Point(x: 17.888058552817974, y: 46.8922640636407)),
  'EPSG:4154': ProjectAndUnProjectResult(
      Point(x: 17.889235305497543, y: 46.893094948907134),
      Point(x: 17.888058556385946, y: 46.892264064249474)),
  'EPSG:4155': ProjectAndUnProjectResult(
      Point(x: 17.887262003930054, y: 46.894195551341284),
      Point(x: 17.888058563957035, y: 46.892264058068044)),
  'EPSG:4156': ProjectAndUnProjectResult(
      Point(x: 17.889483655386478, y: 46.89255090981592),
      Point(x: 17.888058570312527, y: 46.89226406903427)),
  'EPSG:4157': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4158': ProjectAndUnProjectResult(
      Point(x: 17.883410020092334, y: 46.892776246869204),
      Point(x: 17.88805826525789, y: 46.89226409962333)),
  'EPSG:4159': ProjectAndUnProjectResult(
      Point(x: 17.888828579118577, y: 46.89309763553744),
      Point(x: 17.88805855967068, y: 46.892264066345454)),
  'EPSG:4160': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4161': ProjectAndUnProjectResult(
      Point(x: 17.887994572881254, y: 46.89213861426008),
      Point(x: 17.88805855668369, y: 46.892264059932785)),
  'EPSG:4162': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4163': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4164': ProjectAndUnProjectResult(
      Point(x: 17.8894754842712, y: 46.8910745711517),
      Point(x: 17.888058578013172, y: 46.89226405207682)),
  'EPSG:4165': ProjectAndUnProjectResult(
      Point(x: 17.884202019692626, y: 46.89234743893277),
      Point(x: 17.888058462095806, y: 46.89226406913976)),
  'EPSG:4166': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4167': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4168': ProjectAndUnProjectResult(
      Point(x: 17.886856942238104, y: 46.89057447103977),
      Point(x: 17.888058524869066, y: 46.89226401706037)),
  'EPSG:4169': ProjectAndUnProjectResult(
      Point(x: 17.88612155915996, y: 46.891300547834845),
      Point(x: 17.88805849850665, y: 46.8922640361846)),
  'EPSG:4170': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4171': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4172': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4173': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4174': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4175': ProjectAndUnProjectResult(
      Point(x: 17.887653935064552, y: 46.89423892715959),
      Point(x: 17.888058563859218, y: 46.89226404949148)),
  'EPSG:4176': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4178': ProjectAndUnProjectResult(
      Point(x: 17.88967433858724, y: 46.8926376649266),
      Point(x: 17.888058571408713, y: 46.89226406958981)),
  'EPSG:4179': ProjectAndUnProjectResult(
      Point(x: 17.88968389153443, y: 46.89263827240311),
      Point(x: 17.888058572338835, y: 46.892264068796905)),
  'EPSG:4180': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4181': ProjectAndUnProjectResult(
      Point(x: 17.885985188709242, y: 46.891410472758366),
      Point(x: 17.888058557212126, y: 46.8922640628794)),
  'EPSG:4182': ProjectAndUnProjectResult(
      Point(x: 17.888455953540493, y: 46.88958948053483),
      Point(x: 17.88805855714915, y: 46.89226408815598)),
  'EPSG:4183': ProjectAndUnProjectResult(
      Point(x: 17.88555400076387, y: 46.89300479015121),
      Point(x: 17.888058504603237, y: 46.89226408352831)),
  'EPSG:4184': ProjectAndUnProjectResult(
      Point(x: 17.88547971941075, y: 46.89177423856442),
      Point(x: 17.888058504324555, y: 46.89226405634754)),
  'EPSG:4185': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4188': ProjectAndUnProjectResult(
      Point(x: 17.891498090351433, y: 46.89087707592294),
      Point(x: 17.888058682878274, y: 46.89226401887073)),
  'EPSG:4189': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4190': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4191': ProjectAndUnProjectResult(
      Point(x: 17.889780047022388, y: 46.89270927012999),
      Point(x: 17.888058561860525, y: 46.89226406417254)),
  'EPSG:4192': ProjectAndUnProjectResult(
      Point(x: 17.88940937007267, y: 46.891982973463755),
      Point(x: 17.888058553441127, y: 46.89226406843666)),
  'EPSG:4193': ProjectAndUnProjectResult(
      Point(x: 17.889668362724734, y: 46.89490699898191),
      Point(x: 17.88805851442825, y: 46.8922639914871)),
  'EPSG:4194': ProjectAndUnProjectResult(
      Point(x: 17.8869962335548, y: 46.8955494705063),
      Point(x: 17.888058527031806, y: 46.89226417016857)),
  'EPSG:4195': ProjectAndUnProjectResult(
      Point(x: 17.88418455062187, y: 46.895028094947314),
      Point(x: 17.88805841161424, y: 46.892264179570724)),
  'EPSG:4196': ProjectAndUnProjectResult(
      Point(x: 17.882443675058976, y: 46.89366554547311),
      Point(x: 17.888058345867105, y: 46.89226412250776)),
  'EPSG:4197': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4198': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4199': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4200': ProjectAndUnProjectResult(
      Point(x: 17.889755560315955, y: 46.89262999262432),
      Point(x: 17.88805857029885, y: 46.8922640691192)),
  'EPSG:4201': ProjectAndUnProjectResult(
      Point(x: 17.887576830377576, y: 46.89307996961485),
      Point(x: 17.88805856299657, y: 46.892264062395796)),
  'EPSG:4202': ProjectAndUnProjectResult(
      Point(x: 17.888287661997563, y: 46.890674147943486),
      Point(x: 17.88805856087318, y: 46.89226405813346)),
  'EPSG:4203': ProjectAndUnProjectResult(
      Point(x: 17.888117874315867, y: 46.89041918662036),
      Point(x: 17.888058560599372, y: 46.8922640570915)),
  'EPSG:4204': ProjectAndUnProjectResult(
      Point(x: 17.890429142931993, y: 46.891671530046324),
      Point(x: 17.88805858437824, y: 46.89226406096708)),
  'EPSG:4205': ProjectAndUnProjectResult(
      Point(x: 17.889920676804028, y: 46.89136561351612),
      Point(x: 17.888058583628542, y: 46.89226405570901)),
  'EPSG:4206': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4207': ProjectAndUnProjectResult(
      Point(x: 17.887589584381217, y: 46.890424883310125),
      Point(x: 17.888058555320438, y: 46.892264047492375)),
  'EPSG:4208': ProjectAndUnProjectResult(
      Point(x: 17.883861602436856, y: 46.89361973851696),
      Point(x: 17.888058523417733, y: 46.892264078954746)),
  'EPSG:4209': ProjectAndUnProjectResult(
      Point(x: 17.888606057304198, y: 46.896133481889876),
      Point(x: 17.88805852597426, y: 46.89226382376273)),
  'EPSG:4210': ProjectAndUnProjectResult(
      Point(x: 17.887488627766196, y: 46.89624585511823),
      Point(x: 17.888058595929035, y: 46.892263817157705)),
  'EPSG:4211': ProjectAndUnProjectResult(
      Point(x: 17.878035407484088, y: 46.89099159774057),
      Point(x: 17.888059883263967, y: 46.89226423543215)),
  'EPSG:4212': ProjectAndUnProjectResult(
      Point(x: 17.88442861267548, y: 46.89363172676321),
      Point(x: 17.888058380689987, y: 46.892264134891235)),
  'EPSG:4213': ProjectAndUnProjectResult(
      Point(x: 17.88871772398678, y: 46.893408260648066),
      Point(x: 17.888058557832185, y: 46.89226406274371)),
  'EPSG:4214': ProjectAndUnProjectResult(
      Point(x: 17.890050300715586, y: 46.892532970958314),
      Point(x: 17.88805856876601, y: 46.89226406815799)),
  'EPSG:4215': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4216': ProjectAndUnProjectResult(
      Point(x: 17.885104495171113, y: 46.892553822191374),
      Point(x: 17.888058488103763, y: 46.89226407411175)),
  'EPSG:4218': ProjectAndUnProjectResult(
      Point(x: 17.885499486596796, y: 46.897571019234405),
      Point(x: 17.888058466715794, y: 46.89226426167436)),
  'EPSG:4219': ProjectAndUnProjectResult(
      Point(x: 17.878219502434554, y: 46.89090128234533),
      Point(x: 17.888059869224158, y: 46.892264248817156)),
  'EPSG:4220': ProjectAndUnProjectResult(
      Point(x: 17.892193924486552, y: 46.89580216812677),
      Point(x: 17.888058334685727, y: 46.892263873371036)),
  'EPSG:4221': ProjectAndUnProjectResult(
      Point(x: 17.88576379730565, y: 46.89188044521362),
      Point(x: 17.888058488318986, y: 46.89226405494158)),
  'EPSG:4222': ProjectAndUnProjectResult(
      Point(x: 17.88885903683948, y: 46.89612862680453),
      Point(x: 17.888058510401954, y: 46.89226382542354)),
  'EPSG:4223': ProjectAndUnProjectResult(
      Point(x: 17.88692368188675, y: 46.8879829529168),
      Point(x: 17.8880585345503, y: 46.89226396964505)),
  'EPSG:4224': ProjectAndUnProjectResult(
      Point(x: 17.8844396573402, y: 46.892882095940344),
      Point(x: 17.888058483585702, y: 46.892264080149346)),
  'EPSG:4225': ProjectAndUnProjectResult(
      Point(x: 17.88512259072015, y: 46.89216530703706),
      Point(x: 17.888058513826838, y: 46.892264065441836)),
  'EPSG:4226': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4227': ProjectAndUnProjectResult(
      Point(x: 17.887184563300927, y: 46.892761753630296),
      Point(x: 17.888058563233912, y: 46.892264065322266)),
  'EPSG:4228': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4229': ProjectAndUnProjectResult(
      Point(x: 17.88616100866217, y: 46.891727756878986),
      Point(x: 17.888058562190455, y: 46.892264067549995)),
  'EPSG:4230': ProjectAndUnProjectResult(
      Point(x: 17.88893166266119, y: 46.89308670807359),
      Point(x: 17.888058565321924, y: 46.89226407177292)),
  'EPSG:4231': ProjectAndUnProjectResult(
      Point(x: 17.888924847955725, y: 46.8930767617878),
      Point(x: 17.888058566225, y: 46.892264072588254)),
  'EPSG:4232': ProjectAndUnProjectResult(
      Point(x: 17.886699809337195, y: 46.89187962758141),
      Point(x: 17.888058583470187, y: 46.89226407422393)),
  'EPSG:4233': ProjectAndUnProjectResult(
      Point(x: 17.891530821413426, y: 46.891298217036905),
      Point(x: 17.88805860647322, y: 46.89226405412053)),
  'EPSG:4234': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4235': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4236': ProjectAndUnProjectResult(
      Point(x: 17.892346029888245, y: 46.889243935620044),
      Point(x: 17.888058241276223, y: 46.89226429240757)),
  'EPSG:4237': ProjectAndUnProjectResult(
      Point(x: 17.88916569162529, y: 46.892543996221036),
      Point(x: 17.888058565574823, y: 46.892264068351416)),
  'EPSG:4238': ProjectAndUnProjectResult(
      Point(x: 17.888149140889887, y: 46.89206035315574),
      Point(x: 17.888058560387304, y: 46.89226406677013)),
  'EPSG:4239': ProjectAndUnProjectResult(
      Point(x: 17.87865495536962, y: 46.891792293513525),
      Point(x: 17.888058899882886, y: 46.89226408408594)),
  'EPSG:4240': ProjectAndUnProjectResult(
      Point(x: 17.878739158646248, y: 46.89179187013394),
      Point(x: 17.888058916886116, y: 46.8922640851195)),
  'EPSG:4241': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4242': ProjectAndUnProjectResult(
      Point(x: 17.885755708408063, y: 46.892860713000246),
      Point(x: 17.88805844635425, y: 46.8922640966206)),
  'EPSG:4243': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4244': ProjectAndUnProjectResult(
      Point(x: 17.877839573051762, y: 46.89106653380673),
      Point(x: 17.88805951681861, y: 46.892264179410205)),
  'EPSG:4245': ProjectAndUnProjectResult(
      Point(x: 17.877386729833542, y: 46.89223185252286),
      Point(x: 17.88805949588407, y: 46.89226406979833)),
  'EPSG:4246': ProjectAndUnProjectResult(
      Point(x: 17.889369426719277, y: 46.88992588873295),
      Point(x: 17.88805857590451, y: 46.892264039055846)),
  'EPSG:4247': ProjectAndUnProjectResult(
      Point(x: 17.885575231028568, y: 46.89379807115077),
      Point(x: 17.888058643287803, y: 46.89226401557033)),
  'EPSG:4248': ProjectAndUnProjectResult(
      Point(x: 17.88471263263447, y: 46.8939485850594),
      Point(x: 17.888058676900894, y: 46.89226400810805)),
  'EPSG:4249': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4250': ProjectAndUnProjectResult(
      Point(x: 17.887172482230394, y: 46.892410172197),
      Point(x: 17.88805854454938, y: 46.8922640696111)),
  'EPSG:4251': ProjectAndUnProjectResult(
      Point(x: 17.887196330109735, y: 46.894378954910934),
      Point(x: 17.88805856834199, y: 46.892264047174955)),
  'EPSG:4252': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4253': ProjectAndUnProjectResult(
      Point(x: 17.88848403025963, y: 46.89372691088209),
      Point(x: 17.888058547156763, y: 46.8922640217402)),
  'EPSG:4254': ProjectAndUnProjectResult(
      Point(x: 17.885675452411373, y: 46.893008004004194),
      Point(x: 17.888058440261307, y: 46.892264104595334)),
  'EPSG:4255': ProjectAndUnProjectResult(
      Point(x: 17.88948851238981, y: 46.889854644489276),
      Point(x: 17.88805856530313, y: 46.892264058521334)),
  'EPSG:4256': ProjectAndUnProjectResult(
      Point(x: 17.890971046188174, y: 46.896037756494934),
      Point(x: 17.888058473130773, y: 46.89226395372365)),
  'EPSG:4257': ProjectAndUnProjectResult(
      Point(x: 17.879199861644413, y: 46.88814568219285),
      Point(x: 17.888059768494056, y: 46.89226463038157)),
  'EPSG:4258': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4259': ProjectAndUnProjectResult(
      Point(x: 17.88710140026856, y: 46.89210196633683),
      Point(x: 17.888058565856863, y: 46.89226406795597)),
  'EPSG:4260': ProjectAndUnProjectResult(
      Point(x: 17.889668362724734, y: 46.89490681199572),
      Point(x: 17.88805851441718, y: 46.89226399147423)),
  'EPSG:4261': ProjectAndUnProjectResult(
      Point(x: 17.886360298096015, y: 46.89560123818276),
      Point(x: 17.888058557275553, y: 46.89226407293465)),
  'EPSG:4262': ProjectAndUnProjectResult(
      Point(x: 17.885576177667634, y: 46.89610913745565),
      Point(x: 17.888058622476596, y: 46.89226397036131)),
  'EPSG:4263': ProjectAndUnProjectResult(
      Point(x: 17.888849074168615, y: 46.8938891691329),
      Point(x: 17.88805855234784, y: 46.892264050647256)),
  'EPSG:4264': ProjectAndUnProjectResult(
      Point(x: 17.887090426208047, y: 46.89208763998366),
      Point(x: 17.888058565335186, y: 46.89226406793263)),
  'EPSG:4265': ProjectAndUnProjectResult(
      Point(x: 17.88806206252404, y: 46.89153971492727),
      Point(x: 17.88805856483977, y: 46.892264067501486)),
  'EPSG:4266': ProjectAndUnProjectResult(
      Point(x: 17.889383648796457, y: 46.894418962792756),
      Point(x: 17.888058535696295, y: 46.89226402690006)),
  'EPSG:4267': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89439997507818),
      Point(x: 17.888058560281515, y: 46.892264047823126)),
  'EPSG:4268': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4269': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4270': ProjectAndUnProjectResult(
      Point(x: 17.889002961206145, y: 46.89118876133314),
      Point(x: 17.888058561705662, y: 46.89226406538219)),
  'EPSG:4271': ProjectAndUnProjectResult(
      Point(x: 17.883335320057093, y: 46.892763918400064),
      Point(x: 17.888058268284464, y: 46.89226409801385)),
  'EPSG:4272': ProjectAndUnProjectResult(
      Point(x: 17.88819953783656, y: 46.89222622730486),
      Point(x: 17.888058577183052, y: 46.892264068019884)),
  'EPSG:4273': ProjectAndUnProjectResult(
      Point(x: 17.89207245993109, y: 46.89002141197087),
      Point(x: 17.88805856210612, y: 46.89226407696183)),
  'EPSG:4274': ProjectAndUnProjectResult(
      Point(x: 17.88578286214444, y: 46.89168614169353),
      Point(x: 17.888058522143783, y: 46.89226405729353)),
  'EPSG:4275': ProjectAndUnProjectResult(
      Point(x: 17.888130687051746, y: 46.89226381503744),
      Point(x: 17.888058560710174, y: 46.89226406700729)),
  'EPSG:4276': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4277': ProjectAndUnProjectResult(
      Point(x: 17.89125174421817, y: 46.89081593919594),
      Point(x: 17.888058558608275, y: 46.89226406720074)),
  'EPSG:4278': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4279': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4280': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4281': ProjectAndUnProjectResult(
      Point(x: 17.88640309155158, y: 46.89129025552753),
      Point(x: 17.888058483333054, y: 46.892264029983394)),
  'EPSG:4282': ProjectAndUnProjectResult(
      Point(x: 17.88682522003918, y: 46.89636840495731),
      Point(x: 17.88805863204859, y: 46.89226382741024)),
  'EPSG:4283': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4284': ProjectAndUnProjectResult(
      Point(x: 17.88972298822399, y: 46.89269405847744),
      Point(x: 17.888058570172568, y: 46.89226406845011)),
  'EPSG:4285': ProjectAndUnProjectResult(
      Point(x: 17.89106859551569, y: 46.891578847854085),
      Point(x: 17.888058595968577, y: 46.89226405885983)),
  'EPSG:4286': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4287': ProjectAndUnProjectResult(
      Point(x: 17.8869962335548, y: 46.8955494705063),
      Point(x: 17.888058527031806, y: 46.89226417016857)),
  'EPSG:4288': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4289': ProjectAndUnProjectResult(
      Point(x: 17.890149632205905, y: 46.89256626995258),
      Point(x: 17.888058571915472, y: 46.89226406583144)),
  'EPSG:4291': ProjectAndUnProjectResult(
      Point(x: 17.887816338046054, y: 46.89216904811291),
      Point(x: 17.88805856195776, y: 46.89226406766842)),
  'EPSG:4292': ProjectAndUnProjectResult(
      Point(x: 17.886365628239236, y: 46.89046548138973),
      Point(x: 17.88805855273655, y: 46.89226405896806)),
  'EPSG:4293': ProjectAndUnProjectResult(
      Point(x: 17.88933022937584, y: 46.89725835029022),
      Point(x: 17.888058484614003, y: 46.8922637688728)),
  'EPSG:4294': ProjectAndUnProjectResult(
      Point(x: 17.87789321261279, y: 46.89027575009919),
      Point(x: 17.888059822235842, y: 46.8922643145557)),
  'EPSG:4295': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4296': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8246': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4297': ProjectAndUnProjectResult(
      Point(x: 17.890318647376606, y: 46.89197436010706),
      Point(x: 17.8880585469207, y: 46.892264068726696)),
  'EPSG:4298': ProjectAndUnProjectResult(
      Point(x: 17.876968826843065, y: 46.88801569432457),
      Point(x: 17.88806042992997, y: 46.892264785360716)),
  'EPSG:4299': ProjectAndUnProjectResult(
      Point(x: 17.89149816134214, y: 46.89087086536183),
      Point(x: 17.888058558102095, y: 46.89226406852428)),
  'EPSG:4300': ProjectAndUnProjectResult(
      Point(x: 17.891498090351433, y: 46.89087040542061),
      Point(x: 17.88805855810833, y: 46.89226406852212)),
  'EPSG:4301': ProjectAndUnProjectResult(
      Point(x: 17.88113303218112, y: 46.887591671655095),
      Point(x: 17.888058773192473, y: 46.892264211085)),
  'EPSG:4302': ProjectAndUnProjectResult(
      Point(x: 17.88425729588024, y: 46.89216271108818),
      Point(x: 17.888058342544866, y: 46.89226406118848)),
  'EPSG:4303': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4304': ProjectAndUnProjectResult(
      Point(x: 17.890848660074248, y: 46.89305198445358),
      Point(x: 17.8880585570519, y: 46.89226406609385)),
  'EPSG:4306': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4307': ProjectAndUnProjectResult(
      Point(x: 17.88846626695256, y: 46.89234726199596),
      Point(x: 17.88805855500577, y: 46.89226406002642)),
  'EPSG:4308': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4309': ProjectAndUnProjectResult(
      Point(x: 17.885298528576193, y: 46.892233086942255),
      Point(x: 17.888058489235636, y: 46.892264066209684)),
  'EPSG:4310': ProjectAndUnProjectResult(
      Point(x: 17.885564999334463, y: 46.8950505604044),
      Point(x: 17.888058555778105, y: 46.89226407205741)),
  'EPSG:4311': ProjectAndUnProjectResult(
      Point(x: 17.88549210530198, y: 46.89387076538575),
      Point(x: 17.888058643082715, y: 46.892264015006454)),
  'EPSG:4312': ProjectAndUnProjectResult(
      Point(x: 17.893338495202972, y: 46.89256039541229),
      Point(x: 17.888058563174475, y: 46.892264067171745)),
  'EPSG:4313': ProjectAndUnProjectResult(
      Point(x: 17.88651610776974, y: 46.89300980519966),
      Point(x: 17.888058551637616, y: 46.89226407321235)),
  'EPSG:4314': ProjectAndUnProjectResult(
      Point(x: 17.890214109984964, y: 46.892962137254536),
      Point(x: 17.888058558928766, y: 46.892264066569304)),
  'EPSG:4315': ProjectAndUnProjectResult(
      Point(x: 17.884731546747, y: 46.89583586991772),
      Point(x: 17.888058581617305, y: 46.892264044029275)),
  'EPSG:4605': ProjectAndUnProjectResult(
      Point(x: 17.885809584610897, y: 46.89437640511847),
      Point(x: 17.888058510052453, y: 46.89226411433701)),
  'EPSG:4316': ProjectAndUnProjectResult(
      Point(x: 17.889728481044955, y: 46.8954153421914),
      Point(x: 17.888058566597667, y: 46.892264078966164)),
  'EPSG:4317': ProjectAndUnProjectResult(
      Point(x: 17.88968240024422, y: 46.89264401721376),
      Point(x: 17.88805857198031, y: 46.89226406975483)),
  'EPSG:4318': ProjectAndUnProjectResult(
      Point(x: 17.88811684154245, y: 46.89221535782348),
      Point(x: 17.88805856027027, y: 46.89226406701824)),
  'EPSG:4319': ProjectAndUnProjectResult(
      Point(x: 17.887833618004347, y: 46.89214211393298),
      Point(x: 17.88805856061255, y: 46.89226406718884)),
  'EPSG:4322': ProjectAndUnProjectResult(
      Point(x: 17.88790467139263, y: 46.89223644809947),
      Point(x: 17.888058560281515, y: 46.89226406678145)),
  'EPSG:4324': ProjectAndUnProjectResult(
      Point(x: 17.88783244917041, y: 46.89225231422713),
      Point(x: 17.88805856028152, y: 46.89226406656411)),
  'EPSG:4326': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4463': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4470': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4475': ProjectAndUnProjectResult(
      Point(x: 17.887237885734397, y: 46.89216008403257),
      Point(x: 17.888058591798575, y: 46.89226407101459)),
  'EPSG:4483': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4490': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4555': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4558': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4600': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4601': ProjectAndUnProjectResult(
      Point(x: 17.88721814677669, y: 46.89334128558927),
      Point(x: 17.888058585402845, y: 46.892264034706905)),
  'EPSG:4602': ProjectAndUnProjectResult(
      Point(x: 17.882425548003347, y: 46.89802039697476),
      Point(x: 17.88805773821601, y: 46.89226490982518)),
  'EPSG:4603': ProjectAndUnProjectResult(
      Point(x: 17.885680098564837, y: 46.895711113348916),
      Point(x: 17.88805852837462, y: 46.892264113399534)),
  'EPSG:4604': ProjectAndUnProjectResult(
      Point(x: 17.884276605220265, y: 46.8949697304774),
      Point(x: 17.88805833471367, y: 46.892264228902945)),
  'EPSG:4606': ProjectAndUnProjectResult(
      Point(x: 17.885859666543812, y: 46.89290912383417),
      Point(x: 17.888058535426826, y: 46.892264074323336)),
  'EPSG:4607': ProjectAndUnProjectResult(
      Point(x: 17.884694673740547, y: 46.89560743220017),
      Point(x: 17.88805838989711, y: 46.89226423689982)),
  'EPSG:4608': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4609': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4610': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4611': ProjectAndUnProjectResult(
      Point(x: 17.89099923399472, y: 46.89190484851266),
      Point(x: 17.888058516995418, y: 46.892264063154926)),
  'EPSG:4612': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4613': ProjectAndUnProjectResult(
      Point(x: 17.87789321261279, y: 46.89027575009919),
      Point(x: 17.888059822235842, y: 46.8922643145557)),
  'EPSG:4614': ProjectAndUnProjectResult(
      Point(x: 17.891406881740558, y: 46.89174050444905),
      Point(x: 17.888058600353727, y: 46.892264061580484)),
  'EPSG:4615': ProjectAndUnProjectResult(
      Point(x: 17.889156602283535, y: 46.88753333683978),
      Point(x: 17.88805856970177, y: 46.89226402629913)),
  'EPSG:4616': ProjectAndUnProjectResult(
      Point(x: 17.8884421751394, y: 46.89065924577472),
      Point(x: 17.88805856221497, y: 46.89226405889515)),
  'EPSG:4617': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4618': ProjectAndUnProjectResult(
      Point(x: 17.887734475828278, y: 46.892097093209316),
      Point(x: 17.888058562716655, y: 46.89226406826737)),
  'EPSG:4619': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4620': ProjectAndUnProjectResult(
      Point(x: 17.88924218112375, y: 46.89346472795446),
      Point(x: 17.88805855113159, y: 46.89226405769767)),
  'EPSG:4621': ProjectAndUnProjectResult(
      Point(x: 17.885513710819573, y: 46.897083926153584),
      Point(x: 17.888058548504002, y: 46.89226408938738)),
  'EPSG:4622': ProjectAndUnProjectResult(
      Point(x: 17.886376296781005, y: 46.89197759023489),
      Point(x: 17.888058645514224, y: 46.89226408156828)),
  'EPSG:4623': ProjectAndUnProjectResult(
      Point(x: 17.884436847845105, y: 46.891709591178596),
      Point(x: 17.888058441256078, y: 46.892264048731)),
  'EPSG:4624': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4625': ProjectAndUnProjectResult(
      Point(x: 17.88278885238051, y: 46.89429083216939),
      Point(x: 17.88805811931666, y: 46.89226423715717)),
  'EPSG:4626': ProjectAndUnProjectResult(
      Point(x: 17.90027503305275, y: 46.89951537654362),
      Point(x: 17.888056921845994, y: 46.89226309120497)),
  'EPSG:4627': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4628': ProjectAndUnProjectResult(
      Point(x: 17.887250423662014, y: 46.89338618412523),
      Point(x: 17.888058504039414, y: 46.89226414534991)),
  'EPSG:4629': ProjectAndUnProjectResult(
      Point(x: 17.884406106849905, y: 46.89384278599231),
      Point(x: 17.888058313856018, y: 46.892264159538165)),
  'EPSG:4630': ProjectAndUnProjectResult(
      Point(x: 17.884975423977735, y: 46.893762453048616),
      Point(x: 17.888058385637116, y: 46.892264152156805)),
  'EPSG:4631': ProjectAndUnProjectResult(
      Point(x: 17.890978201391995, y: 46.892980160097515),
      Point(x: 17.888058712257504, y: 46.892264104403324)),
  'EPSG:4632': ProjectAndUnProjectResult(
      Point(x: 17.887255748631244, y: 46.89218847940424),
      Point(x: 17.888058591658098, y: 46.89226406997221)),
  'EPSG:4633': ProjectAndUnProjectResult(
      Point(x: 17.886631067875875, y: 46.89704960653234),
      Point(x: 17.888058493571194, y: 46.892264291373415)),
  'EPSG:4634': ProjectAndUnProjectResult(
      Point(x: 17.89235170464927, y: 46.89050602958376),
      Point(x: 17.88805878472249, y: 46.89226397481847)),
  'EPSG:4635': ProjectAndUnProjectResult(
      Point(x: 17.892041183889614, y: 46.88969257925379),
      Point(x: 17.888058581785078, y: 46.892264017988204)),
  'EPSG:4636': ProjectAndUnProjectResult(
      Point(x: 17.88710701957235, y: 46.89473654925238),
      Point(x: 17.888058470694517, y: 46.892264300535274)),
  'EPSG:4637': ProjectAndUnProjectResult(
      Point(x: 17.887445339647073, y: 46.894368959173974),
      Point(x: 17.88805850542791, y: 46.892264255895014)),
  'EPSG:4638': ProjectAndUnProjectResult(
      Point(x: 17.88280763118828, y: 46.893032812684694),
      Point(x: 17.888058304217317, y: 46.89226410462147)),
  'EPSG:4639': ProjectAndUnProjectResult(
      Point(x: 17.8907267486178, y: 46.895179932784885),
      Point(x: 17.888058663196375, y: 46.89226417983814)),
  'EPSG:4640': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4641': ProjectAndUnProjectResult(
      Point(x: 17.886997535873586, y: 46.89607270696852),
      Point(x: 17.888058505847603, y: 46.8922642630332)),
  'EPSG:4642': ProjectAndUnProjectResult(
      Point(x: 17.89235170464927, y: 46.89050602958376),
      Point(x: 17.88805878472249, y: 46.89226397481847)),
  'EPSG:4671': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4643': ProjectAndUnProjectResult(
      Point(x: 17.89911985026825, y: 46.89707061133045),
      Point(x: 17.888057469925077, y: 46.8922641752369)),
  'EPSG:4644': ProjectAndUnProjectResult(
      Point(x: 17.892393416084214, y: 46.89052262337273),
      Point(x: 17.88805878748905, y: 46.89226397545263)),
  'EPSG:4645': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4646': ProjectAndUnProjectResult(
      Point(x: 17.877810348941836, y: 46.89030120340471),
      Point(x: 17.88805948904907, y: 46.89226424540961)),
  'EPSG:4657': ProjectAndUnProjectResult(
      Point(x: 17.88546066911159, y: 46.89131098788118),
      Point(x: 17.88805897605859, y: 46.89226422001618)),
  'EPSG:4658': ProjectAndUnProjectResult(
      Point(x: 17.88717743233147, y: 46.89323310922694),
      Point(x: 17.888058545916724, y: 46.89226408285691)),
  'EPSG:4659': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4660': ProjectAndUnProjectResult(
      Point(x: 17.88964062637946, y: 46.894746227733776),
      Point(x: 17.888057194615087, y: 46.892265015063444)),
  'EPSG:4661': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4662': ProjectAndUnProjectResult(
      Point(x: 17.892364679364178, y: 46.890513441336765),
      Point(x: 17.888058785902057, y: 46.892263975002756)),
  'EPSG:4663': ProjectAndUnProjectResult(
      Point(x: 17.889121534685867, y: 46.88752019786821),
      Point(x: 17.888058568882606, y: 46.89226402850628)),
  'EPSG:4664': ProjectAndUnProjectResult(
      Point(x: 17.885483484701325, y: 46.89174877482454),
      Point(x: 17.888058504245326, y: 46.892264055760975)),
  'EPSG:4665': ProjectAndUnProjectResult(
      Point(x: 17.885552947330282, y: 46.89298894154823),
      Point(x: 17.888058505169003, y: 46.892264083003866)),
  'EPSG:4666': ProjectAndUnProjectResult(
      Point(x: 17.89249247462093, y: 46.89098242462263),
      Point(x: 17.888058559248655, y: 46.89226406730827)),
  'EPSG:4667': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4668': ProjectAndUnProjectResult(
      Point(x: 17.888935693234195, y: 46.8930806639105),
      Point(x: 17.8880585656349, y: 46.8922640720085)),
  'EPSG:4669': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4670': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4746': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4672': ProjectAndUnProjectResult(
      Point(x: 17.889238463056923, y: 46.89340678995979),
      Point(x: 17.88805863242381, y: 46.89226413709957)),
  'EPSG:4673': ProjectAndUnProjectResult(
      Point(x: 17.888924521304972, y: 46.893428776837766),
      Point(x: 17.888058623138072, y: 46.89226413881443)),
  'EPSG:4674': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4675': ProjectAndUnProjectResult(
      Point(x: 17.890752311639893, y: 46.891682599344946),
      Point(x: 17.888058566515163, y: 46.892264065659084)),
  'EPSG:4676': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4677': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4678': ProjectAndUnProjectResult(
      Point(x: 17.889876773236402, y: 46.89249682169752),
      Point(x: 17.88805858362109, y: 46.892264070006156)),
  'EPSG:4679': ProjectAndUnProjectResult(
      Point(x: 17.88457348974185, y: 46.89362252767481),
      Point(x: 17.888058483996815, y: 46.89226409683966)),
  'EPSG:4680': ProjectAndUnProjectResult(
      Point(x: 17.889353342845457, y: 46.89777889891754),
      Point(x: 17.888058517449707, y: 46.89226388398319)),
  'EPSG:4681': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4682': ProjectAndUnProjectResult(
      Point(x: 17.880011527018617, y: 46.89226657819295),
      Point(x: 17.888058854118235, y: 46.89226406690649)),
  'EPSG:4683': ProjectAndUnProjectResult(
      Point(x: 17.88752878305918, y: 46.89531286609277),
      Point(x: 17.888058548246388, y: 46.89226402045779)),
  'EPSG:4684': ProjectAndUnProjectResult(
      Point(x: 17.891530821413426, y: 46.891298217036905),
      Point(x: 17.88805860647322, y: 46.89226405412053)),
  'EPSG:4685': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4686': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4687': ProjectAndUnProjectResult(
      Point(x: 17.888062019684995, y: 46.892266639477235),
      Point(x: 17.888058560281404, y: 46.892264067008945)),
  'EPSG:4688': ProjectAndUnProjectResult(
      Point(x: 17.875491445920094, y: 46.902894781164655),
      Point(x: 17.888053645696168, y: 46.89225762930562)),
  'EPSG:4689': ProjectAndUnProjectResult(
      Point(x: 17.889777663834664, y: 46.895670868507914),
      Point(x: 17.88805865056876, y: 46.89226438035667)),
  'EPSG:7039': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4690': ProjectAndUnProjectResult(
      Point(x: 17.886490230812537, y: 46.89352917427127),
      Point(x: 17.888058465456226, y: 46.89226420182663)),
  'EPSG:4691': ProjectAndUnProjectResult(
      Point(x: 17.886312153203775, y: 46.89348297085436),
      Point(x: 17.888058467903072, y: 46.892264199301934)),
  'EPSG:4692': ProjectAndUnProjectResult(
      Point(x: 17.887847411101863, y: 46.89446897440634),
      Point(x: 17.88805854774968, y: 46.89226419828875)),
  'EPSG:4693': ProjectAndUnProjectResult(
      Point(x: 17.888060433409922, y: 46.8922595843611),
      Point(x: 17.888058560281653, y: 46.89226406700847)),
  'EPSG:4694': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4695': ProjectAndUnProjectResult(
      Point(x: 17.887760475462485, y: 46.895305433836086),
      Point(x: 17.888058574909916, y: 46.89226391727656)),
  'EPSG:4696': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4697': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4698': ProjectAndUnProjectResult(
      Point(x: 17.890978201391995, y: 46.892980160097515),
      Point(x: 17.888058712257504, y: 46.892264104403324)),
  'EPSG:4699': ProjectAndUnProjectResult(
      Point(x: 17.882977455574668, y: 46.89397046380573),
      Point(x: 17.888059280157222, y: 46.892263824466895)),
  'EPSG:4700': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4701': ProjectAndUnProjectResult(
      Point(x: 17.889709505958457, y: 46.895621750107615),
      Point(x: 17.888058487344445, y: 46.892263918193095)),
  'EPSG:4702': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4703': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4704': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4705': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4706': ProjectAndUnProjectResult(
      Point(x: 17.88606284100167, y: 46.89152694466221),
      Point(x: 17.888058561521675, y: 46.892264067468275)),
  'EPSG:4707': ProjectAndUnProjectResult(
      Point(x: 17.889966620179933, y: 46.89560969979221),
      Point(x: 17.888058562981083, y: 46.892264071757495)),
  'EPSG:4708': ProjectAndUnProjectResult(
      Point(x: 17.886354502128633, y: 46.88648237628388),
      Point(x: 17.88805855593484, y: 46.89226405221617)),
  'EPSG:4709': ProjectAndUnProjectResult(
      Point(x: 17.887706403556955, y: 46.895813813158675),
      Point(x: 17.888058554008516, y: 46.89226413044398)),
  'EPSG:4710': ProjectAndUnProjectResult(
      Point(x: 17.8799009205528, y: 46.895230056341475),
      Point(x: 17.88805888070346, y: 46.892263950123855)),
  'EPSG:4711': ProjectAndUnProjectResult(
      Point(x: 17.89148045704814, y: 46.89354091777952),
      Point(x: 17.888058675761418, y: 46.892264110237484)),
  'EPSG:4712': ProjectAndUnProjectResult(
      Point(x: 17.885896226032933, y: 46.891693165360294),
      Point(x: 17.88805851621705, y: 46.89226405533878)),
  'EPSG:4713': ProjectAndUnProjectResult(
      Point(x: 17.88934658256844, y: 46.893789371102564),
      Point(x: 17.888058550783597, y: 46.892264055725384)),
  'EPSG:4714': ProjectAndUnProjectResult(
      Point(x: 17.897148850198207, y: 46.887837526056295),
      Point(x: 17.888058991233653, y: 46.89226385652954)),
  'EPSG:4715': ProjectAndUnProjectResult(
      Point(x: 17.889250242355903, y: 46.89070495421856),
      Point(x: 17.888058612902718, y: 46.89226399794855)),
  'EPSG:4716': ProjectAndUnProjectResult(
      Point(x: 17.89305606977008, y: 46.896638513137226),
      Point(x: 17.88805860607975, y: 46.892264107227625)),
  'EPSG:4717': ProjectAndUnProjectResult(
      Point(x: 17.886164864068693, y: 46.89357945484591),
      Point(x: 17.888058529067077, y: 46.89226408875982)),
  'EPSG:4718': ProjectAndUnProjectResult(
      Point(x: 17.89147071239652, y: 46.898742516286894),
      Point(x: 17.88805843272785, y: 46.89226382403678)),
  'EPSG:4719': ProjectAndUnProjectResult(
      Point(x: 17.887073271478066, y: 46.89401728859372),
      Point(x: 17.888058490667778, y: 46.89226419127359)),
  'EPSG:4720': ProjectAndUnProjectResult(
      Point(x: 17.88790467139263, y: 46.89223644809947),
      Point(x: 17.888058560281515, y: 46.89226406678145)),
  'EPSG:4721': ProjectAndUnProjectResult(
      Point(x: 17.884319612953597, y: 46.89670999008969),
      Point(x: 17.888058376658527, y: 46.89226428606032)),
  'EPSG:4722': ProjectAndUnProjectResult(
      Point(x: 17.883373110749563, y: 46.89019407126835),
      Point(x: 17.888058931805364, y: 46.892264231647864)),
  'EPSG:4723': ProjectAndUnProjectResult(
      Point(x: 17.88505670856662, y: 46.896132550026195),
      Point(x: 17.888058533433984, y: 46.892264007253466)),
  'EPSG:4724': ProjectAndUnProjectResult(
      Point(x: 17.894329066182088, y: 46.894914288264445),
      Point(x: 17.88805863793075, y: 46.892264099934195)),
  'EPSG:4725': ProjectAndUnProjectResult(
      Point(x: 17.889806898751825, y: 46.89534787336956),
      Point(x: 17.8880586043926, y: 46.89226414506381)),
  'EPSG:4726': ProjectAndUnProjectResult(
      Point(x: 17.887608855287716, y: 46.89265580161719),
      Point(x: 17.888058556924786, y: 46.892264048786586)),
  'EPSG:4727': ProjectAndUnProjectResult(
      Point(x: 17.89069455201619, y: 46.893736905282694),
      Point(x: 17.88805882827271, y: 46.89226421722509)),
  'EPSG:4728': ProjectAndUnProjectResult(
      Point(x: 17.887970059662376, y: 46.89019943929116),
      Point(x: 17.888058559227066, y: 46.89226404233306)),
  'EPSG:4729': ProjectAndUnProjectResult(
      Point(x: 17.88674369065092, y: 46.894315245671294),
      Point(x: 17.888058480448866, y: 46.89226419194381)),
  'EPSG:4730': ProjectAndUnProjectResult(
      Point(x: 17.888219273378926, y: 46.89371519581479),
      Point(x: 17.888058569915952, y: 46.892264154277235)),
  'EPSG:4731': ProjectAndUnProjectResult(
      Point(x: 17.883381313005287, y: 46.896730395494146),
      Point(x: 17.888058549238867, y: 46.892264077587775)),
  'EPSG:4732': ProjectAndUnProjectResult(
      Point(x: 17.887820312501738, y: 46.89405674360816),
      Point(x: 17.888058555281884, y: 46.89226410474781)),
  'EPSG:4733': ProjectAndUnProjectResult(
      Point(x: 17.88988286565692, y: 46.89377841359267),
      Point(x: 17.888058696937886, y: 46.89226418080785)),
  'EPSG:4734': ProjectAndUnProjectResult(
      Point(x: 17.88004261530172, y: 46.89376117773054),
      Point(x: 17.8880592645506, y: 46.89226393503251)),
  'EPSG:4735': ProjectAndUnProjectResult(
      Point(x: 17.868470746721638, y: 46.90762007642163),
      Point(x: 17.888058023535276, y: 46.89226448928608)),
  'EPSG:4736': ProjectAndUnProjectResult(
      Point(x: 17.88895668803144, y: 46.89795449656778),
      Point(x: 17.888058558934134, y: 46.89226405844417)),
  'EPSG:4737': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4738': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4739': ProjectAndUnProjectResult(
      Point(x: 17.890813776949443, y: 46.89272448126952),
      Point(x: 17.888058519770908, y: 46.89226406021736)),
  'EPSG:4740': ProjectAndUnProjectResult(
      Point(x: 17.888037449170405, y: 46.892254419819864),
      Point(x: 17.888058560281515, y: 46.89226406700472)),
  'EPSG:4741': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4742': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4743': ProjectAndUnProjectResult(
      Point(x: 17.89253942680843, y: 46.89355166907113),
      Point(x: 17.888058626019056, y: 46.89226408596004)),
  'EPSG:4744': ProjectAndUnProjectResult(
      Point(x: 17.8888917661477, y: 46.89131942682997),
      Point(x: 17.888058561399863, y: 46.89226406573694)),
  'EPSG:4745': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4747': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4748': ProjectAndUnProjectResult(
      Point(x: 17.883381313005287, y: 46.89673214081649),
      Point(x: 17.88805850742944, y: 46.89226411766146)),
  'EPSG:4749': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4750': ProjectAndUnProjectResult(
      Point(x: 17.887630299141588, y: 46.892085486412526),
      Point(x: 17.888058563625414, y: 46.892264068407535)),
  'EPSG:4751': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4752': ProjectAndUnProjectResult(
      Point(x: 17.88358319563896, y: 46.896937840938364),
      Point(x: 17.888058481293985, y: 46.89226414976651)),
  'EPSG:4753': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4754': ProjectAndUnProjectResult(
      Point(x: 17.888590655621456, y: 46.8915760666189),
      Point(x: 17.888058563770603, y: 46.892264062483285)),
  'EPSG:4755': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4756': ProjectAndUnProjectResult(
      Point(x: 17.887775534047428, y: 46.891664589513624),
      Point(x: 17.88805856969633, y: 46.89226408683721)),
  'EPSG:4757': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4758': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4759': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4760': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4761': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4762': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4763': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4764': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4765': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4801': ProjectAndUnProjectResult(
      Point(x: 10.451005644397988, y: 46.893420533895046),
      Point(x: 17.88805857342885, y: 46.89226407303667)),
  'EPSG:4802': ProjectAndUnProjectResult(
      Point(x: 91.96641615326378, y: 46.897571019234405),
      Point(x: 17.888058466715794, y: 46.89226426167436)),
  'EPSG:4803': ProjectAndUnProjectResult(
      Point(x: 27.019495695492218, y: 46.890424883310125),
      Point(x: 17.888058555320445, y: 46.892264047492375)),
  'EPSG:4804': ProjectAndUnProjectResult(
      Point(x: -88.92851958279958, y: 46.88814568219285),
      Point(x: 17.888059768494063, y: 46.89226463038157)),
  'EPSG:4805': ProjectAndUnProjectResult(
      Point(x: 35.56000969558334, y: 46.89256923369196),
      Point(x: 17.88805859905473, y: 46.89226406925582)),
  'EPSG:4806': ProjectAndUnProjectResult(
      Point(x: 5.43572872919104, y: 46.89153971492727),
      Point(x: 17.88805856483977, y: 46.892264067501486)),
  'EPSG:4807': ProjectAndUnProjectResult(
      Point(x: 15.550901520384743, y: 46.89226381503744),
      Point(x: 17.88805856071017, y: 46.89226406700729)),
  'EPSG:4808': ProjectAndUnProjectResult(
      Point(x: -88.9196608841625, y: 46.89226406700879),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:4809': ProjectAndUnProjectResult(
      Point(x: 13.520083560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4810': ProjectAndUnProjectResult(
      Point(x: 15.553089480709607, y: 46.89197436010706),
      Point(x: 17.8880585469207, y: 46.892264068726696)),
  'EPSG:4811': ProjectAndUnProjectResult(
      Point(x: 15.553619493407249, y: 46.89305198445358),
      Point(x: 17.8880585570519, y: 46.89226406609385)),
  'EPSG:4813': ProjectAndUnProjectResult(
      Point(x: -88.92968403695991, y: 46.89099159774057),
      Point(x: 17.888059883263967, y: 46.89226423543215)),
  'EPSG:4814': ProjectAndUnProjectResult(
      Point(x: -0.17021921749648442, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4815': ProjectAndUnProjectResult(
      Point(x: -5.828278939718487, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4816': ProjectAndUnProjectResult(
      Point(x: 15.54969451521975, y: 46.89112086314892),
      Point(x: 17.88805854765618, y: 46.89226405425115)),
  'EPSG:4817': ProjectAndUnProjectResult(
      Point(x: 7.169155793264091, y: 46.89002141197087),
      Point(x: 17.88805856210612, y: 46.89226407696183)),
  'EPSG:4818': ProjectAndUnProjectResult(
      Point(x: 35.55615032205347, y: 46.89255090981592),
      Point(x: 17.888058570312523, y: 46.89226406903427)),
  'EPSG:7041': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4819': ProjectAndUnProjectResult(
      Point(x: 15.55123710028556, y: 46.89234726199596),
      Point(x: 17.88805855500577, y: 46.89226406002642)),
  'EPSG:4820': ProjectAndUnProjectResult(
      Point(x: -88.92982623183121, y: 46.89027575009919),
      Point(x: 17.88805982223584, y: 46.8922643145557)),
  'EPSG:4821': ProjectAndUnProjectResult(
      Point(x: 15.550829393614514, y: 46.89226406700879),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:4823': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4824': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4901': ProjectAndUnProjectResult(
      Point(x: 15.550850226948182, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4902': ProjectAndUnProjectResult(
      Point(x: 15.550829393614514, y: 46.89226406700879),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:4903': ProjectAndUnProjectResult(
      Point(x: 21.575997449170515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4904': ProjectAndUnProjectResult(
      Point(x: 27.024398585731927, y: 46.89098242462263),
      Point(x: 17.888058559248652, y: 46.89226406730827)),
  'EPSG:5013': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5132': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5228': ProjectAndUnProjectResult(
      Point(x: 17.889375102921427, y: 46.89255636815979),
      Point(x: 17.88805857007035, y: 46.89226407109219)),
  'EPSG:5229': ProjectAndUnProjectResult(
      Point(x: 35.556041769588425, y: 46.89255636815979),
      Point(x: 17.88805857007035, y: 46.89226407109219)),
  'EPSG:5233': ProjectAndUnProjectResult(
      Point(x: 17.877723129835083, y: 46.89205125071689),
      Point(x: 17.888059358568963, y: 46.89226411384656)),
  'EPSG:5246': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5252': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5264': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5324': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5340': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5354': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5360': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5365': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5371': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5373': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5381': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5393': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5451': ProjectAndUnProjectResult(
      Point(x: 17.887685988564414, y: 46.89647728834349),
      Point(x: 17.88805855884157, y: 46.89226408334499)),
  'EPSG:5464': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5467': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5489': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5524': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5527': ProjectAndUnProjectResult(
      Point(x: 17.887738660065978, y: 46.89209126084331),
      Point(x: 17.888058562695022, y: 46.892264068316635)),
  'EPSG:5546': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5561': ProjectAndUnProjectResult(
      Point(x: 17.889747303353275, y: 46.89268662292843),
      Point(x: 17.888058571172053, y: 46.89226406866575)),
  'EPSG:5593': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5681': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5886': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6135': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6207': ProjectAndUnProjectResult(
      Point(x: 17.88017108167943, y: 46.89240293551692),
      Point(x: 17.888058857391957, y: 46.89226406175111)),
  'EPSG:6311': ProjectAndUnProjectResult(
      Point(x: 17.88809892246126, y: 46.89227902071313),
      Point(x: 17.888058560426426, y: 46.89226406707394)),
  'EPSG:6318': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6322': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6325': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6365': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6668': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6706': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6783': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6881': ProjectAndUnProjectResult(
      Point(x: 17.890496748184272, y: 46.89319477643712),
      Point(x: 17.88805858454833, y: 46.892264076301544)),
  'EPSG:6882': ProjectAndUnProjectResult(
      Point(x: 17.887508316704572, y: 46.89254957155632),
      Point(x: 17.888058559996683, y: 46.89226406715706)),
  'EPSG:6883': ProjectAndUnProjectResult(
      Point(x: 17.888484998433885, y: 46.888977869744615),
      Point(x: 17.888058581195754, y: 46.8922639053432)),
  'EPSG:6892': ProjectAndUnProjectResult(
      Point(x: 17.89012751193021, y: 46.89641153631479),
      Point(x: 17.888058451660676, y: 46.89226384856166)),
  'EPSG:6894': ProjectAndUnProjectResult(
      Point(x: 17.885606838948544, y: 46.89422577335099),
      Point(x: 17.88805853833933, y: 46.89226408462163)),
  'EPSG:6980': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6983': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6987': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6990': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7035': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7037': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7073': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7084': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7086': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7088': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7133': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7136': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7139': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7373': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7683': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7686': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7798': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7844': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7881': ProjectAndUnProjectResult(
      Point(x: 17.8880572634198, y: 46.89226321647872),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:7886': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8042': ProjectAndUnProjectResult(
      Point(x: 35.55472522694851, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8043': ProjectAndUnProjectResult(
      Point(x: 35.55472522694851, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8086': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8232': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8237': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8240': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8249': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8252': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8255': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:2000': ProjectAndUnProjectResult(
      Point(x: 5526422.202040754, y: 9002751.33369083),
      Point(x: -753956.7023919936, y: 165213.41349147912)),
  'EPSG:2001': ProjectAndUnProjectResult(
      Point(x: 5526247.296160721, y: 9002686.851991432),
      Point(x: 45, y: double.nan)),
  'EPSG:2002': ProjectAndUnProjectResult(
      Point(x: 5525472.087464437, y: 9002288.039227178),
      Point(x: 45, y: double.nan)),
  'EPSG:2003': ProjectAndUnProjectResult(
      Point(x: 5525866.756746404, y: 9002577.378103774),
      Point(x: 45, y: double.nan)),
  'EPSG:2004': ProjectAndUnProjectResult(
      Point(x: 5525960.175422101, y: 9002415.479427967),
      Point(x: 45, y: double.nan)),
  'EPSG:2005': ProjectAndUnProjectResult(
      Point(x: 5526071.0600776775, y: 9002562.350333832),
      Point(x: 45, y: double.nan)),
  'EPSG:2006': ProjectAndUnProjectResult(
      Point(x: 5526294.411225637, y: 9002536.229220128),
      Point(x: 45, y: double.nan)),
  'EPSG:2007': ProjectAndUnProjectResult(
      Point(x: 5525869.091384679, y: 9002472.61080976),
      Point(x: 45, y: double.nan)),
  'EPSG:2008': ProjectAndUnProjectResult(
      Point(x: 5277665.047085337, y: 8355093.439096739),
      Point(x: -15982.089159199548, y: 3524.8365042957075)),
  'EPSG:2009': ProjectAndUnProjectResult(
      Point(x: 5365217.810202819, y: 8648962.351129316),
      Point(x: -76330.92616926054, y: 16627.453910577125)),
  'EPSG:2010': ProjectAndUnProjectResult(
      Point(x: 5425976.622695408, y: 8954435.846844489),
      Point(x: -519762.91469413013, y: 113779.32232853092)),
  'EPSG:2011': ProjectAndUnProjectResult(
      Point(x: 5455768.477256144, y: 9269824.352132047),
      Point(x: -6863032.39823195, y: 1509394.8768156315)),
  'EPSG:2012': ProjectAndUnProjectResult(
      Point(x: 5449900.567813439, y: 9592911.92520874),
      Point(x: -411660671.1172839, y: 90435310.32327807)),
  'EPSG:2013': ProjectAndUnProjectResult(
      Point(x: 5403110.567174674, y: 9920867.004380222),
      Point(x: -34868779061855.633, y: 7591240776477.127)),
  'EPSG:2014': ProjectAndUnProjectResult(
      Point(x: 5309513.557861123, y: 10250142.992226182), Point(x: 0, y: 90)),
  'EPSG:2015': ProjectAndUnProjectResult(
      Point(x: 5162545.494266772, y: 10576367.927553125), Point(x: 0, y: 90)),
  'EPSG:2016': ProjectAndUnProjectResult(
      Point(x: 4954903.074273488, y: 10894222.469686005), Point(x: 0, y: 90)),
  'EPSG:2017': ProjectAndUnProjectResult(
      Point(x: 5309513.557861123, y: 10250142.992226182), Point(x: 0, y: 90)),
  'EPSG:2018': ProjectAndUnProjectResult(
      Point(x: 5162545.494266772, y: 10576367.927553125), Point(x: 0, y: 90)),
  'EPSG:2019': ProjectAndUnProjectResult(
      Point(x: 4954903.074273488, y: 10894222.469686005), Point(x: 0, y: 90)),
  'EPSG:2020': ProjectAndUnProjectResult(
      Point(x: 4678479.898455081, y: 11197305.392896373), Point(x: 0, y: 90)),
  'EPSG:2021': ProjectAndUnProjectResult(
      Point(x: 4825828.925539039, y: 11048056.668702563), Point(x: 0, y: 90)),
  'EPSG:2022': ProjectAndUnProjectResult(
      Point(x: 4511706.106554073, y: 11340975.194605857), Point(x: 0, y: 90)),
  'EPSG:2023': ProjectAndUnProjectResult(
      Point(x: 4114988.0075001256, y: 11607164.510704523), Point(x: 0, y: 90)),
  'EPSG:2024': ProjectAndUnProjectResult(
      Point(x: 3625255.7198369815, y: 11836840.699344885), Point(x: 0, y: 90)),
  'EPSG:2025': ProjectAndUnProjectResult(
      Point(x: 3031032.800231124, y: 12018556.620720338), Point(x: 0, y: 90)),
  'EPSG:2026': ProjectAndUnProjectResult(
      Point(x: 2319703.2157995845, y: 12139000.557800049), Point(x: 0, y: 90)),
  'EPSG:2027': ProjectAndUnProjectResult(
      Point(x: 5324609.907618694, y: 12053364.66978071),
      Point(x: 17.88805856028146, y: 46.89226406700883)),
  'EPSG:9006': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:2028': ProjectAndUnProjectResult(
      Point(x: 5566718.817906034, y: 11503657.385614088),
      Point(x: 17.888058560281564, y: 46.892264067008895)),
  'EPSG:2029': ProjectAndUnProjectResult(
      Point(x: 5736035.34016214, y: 10914074.378320895),
      Point(x: 17.888058560281728, y: 46.89226406700882)),
  'EPSG:2030': ProjectAndUnProjectResult(
      Point(x: 5822624.022223893, y: 10298483.466953503),
      Point(x: 17.888058560281653, y: 46.89226406700864)),
  'EPSG:2031': ProjectAndUnProjectResult(
      Point(x: 5736035.34016214, y: 10914074.378320895),
      Point(x: 17.888058560281728, y: 46.89226406700882)),
  'EPSG:2032': ProjectAndUnProjectResult(
      Point(x: 5822624.022223893, y: 10298483.466953503),
      Point(x: 17.888058560281653, y: 46.89226406700864)),
  'EPSG:2033': ProjectAndUnProjectResult(
      Point(x: 5820960.172786104, y: 9674048.913857404),
      Point(x: 17.888058560281358, y: 46.89226406700865)),
  'EPSG:2034': ProjectAndUnProjectResult(
      Point(x: 5731152.920198566, y: 9059135.240404248),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:2035': ProjectAndUnProjectResult(
      Point(x: 5558920.120957573, y: 8470816.47258435),
      Point(x: 17.88805856028146, y: 46.89226406700888)),
  'EPSG:2036': ProjectAndUnProjectResult(
      Point(x: 8016398.141955978, y: 11184245.693301002),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:2037': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 9674131.646974),
      Point(x: 17.888058560281358, y: 46.892264067008654)),
  'EPSG:4338': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2038': ProjectAndUnProjectResult(
      Point(x: 5731020.405467821, y: 9059228.545130335),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:2039': ProjectAndUnProjectResult(
      Point(x: -1098634.4919505278, y: 2457346.6175213307),
      Point(x: 17.88812604899518, y: 46.892265987217414)),
  'EPSG:2040': ProjectAndUnProjectResult(
      Point(x: 2088185.336907783, y: 5408821.885782874),
      Point(x: 17.888058524356463, y: 46.89226405441292)),
  'EPSG:2041': ProjectAndUnProjectResult(
      Point(x: 2088185.3242582076, y: 5408822.21424697),
      Point(x: 17.888058524385777, y: 46.89226405449902)),
  'EPSG:2042': ProjectAndUnProjectResult(
      Point(x: 2540745.740228584, y: 5555318.890841947),
      Point(x: 17.88805852435648, y: 46.89226405441292)),
  'EPSG:2043': ProjectAndUnProjectResult(
      Point(x: 2540745.6996392542, y: 5555319.223601105),
      Point(x: 17.888058524385766, y: 46.89226405449903)),
  'EPSG:2044': ProjectAndUnProjectResult(
      Point(x: 13375888.420644771, y: 9782000.530853491),
      Point(x: 45, y: double.nan)),
  'EPSG:2045': ProjectAndUnProjectResult(
      Point(x: 14572166.498555884, y: 10439359.049643723),
      Point(x: -99.18246850655717, y: 89.9990176256858)),
  'EPSG:2046': ProjectAndUnProjectResult(
      Point(x: 220089.26554437814, y: 5199321.338629234),
      Point(x: 17.888058560302017, y: 46.892264066956514)),
  'EPSG:2047': ProjectAndUnProjectResult(
      Point(x: 67677.65313369762, y: 5195652.954569092),
      Point(x: 17.88805856028157, y: 46.892264067008746)),
  'EPSG:2048': ProjectAndUnProjectResult(
      Point(x: -84739.31772125408, y: 5195870.378876455),
      Point(x: 17.888058560281344, y: 46.89226406700862)),
  'EPSG:2049': ProjectAndUnProjectResult(
      Point(x: -237149.57186579498, y: 5199974.092369221),
      Point(x: 17.888058560253082, y: 46.892264066927034)),
  'EPSG:2050': ProjectAndUnProjectResult(
      Point(x: -389540.6380220994, y: 5207973.16531258),
      Point(x: 17.888058560563294, y: 46.89226406541965)),
  'EPSG:2051': ProjectAndUnProjectResult(
      Point(x: -541898.93239327, y: 5219885.251365696),
      Point(x: 17.88805857434856, y: 46.89226405586626)),
  'EPSG:2052': ProjectAndUnProjectResult(
      Point(x: -694209.0311684936, y: 5235736.57468188),
      Point(x: 17.888058718641524, y: 46.89226402167793)),
  'EPSG:2053': ProjectAndUnProjectResult(
      Point(x: -846452.9247961688, y: 5255561.908014318),
      Point(x: 17.888059595624597, y: 46.892263943722426)),
  'EPSG:2054': ProjectAndUnProjectResult(
      Point(x: -998609.2468918889, y: 5279404.53863471),
      Point(x: 17.88806345975466, y: 46.89226385836239)),
  'EPSG:2055': ProjectAndUnProjectResult(
      Point(x: -1150652.4706481723, y: 5307316.21782743),
      Point(x: 17.888077173234432, y: 46.89226405998427)),
  'EPSG:2056': ProjectAndUnProjectResult(
      Point(x: 3393998.952123363, y: 1246372.8804294462),
      Point(x: 17.888058573428914, y: 46.89226407167193)),
  'EPSG:2085': ProjectAndUnProjectResult(
      Point(x: 8252693.548778147, y: 5734198.137039982),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:2057': ProjectAndUnProjectResult(
      Point(x: -1967980.2117443858, y: 5814317.985443937),
      Point(x: 17.888058552817974, y: 46.89226406364063)),
  'EPSG:2058': ProjectAndUnProjectResult(
      Point(x: -1557510.5107319206, y: 5562123.039800302),
      Point(x: 17.88805855638595, y: 46.892264064249474)),
  'EPSG:2059': ProjectAndUnProjectResult(
      Point(x: -2005490.489620788, y: 5752060.221245058),
      Point(x: 17.888058556385943, y: 46.892264064249474)),
  'EPSG:2060': ProjectAndUnProjectResult(
      Point(x: -2446087.641665407, y: 5987103.197417655),
      Point(x: 17.888058556385946, y: 46.892264064249474)),
  'EPSG:2061': ProjectAndUnProjectResult(
      Point(x: -2875016.754099869, y: 6270709.607118946),
      Point(x: 17.888058556385946, y: 46.892264064249474)),
  'EPSG:2062': ProjectAndUnProjectResult(
      Point(x: 2238637.4349468937, y: 1566020.0361912022),
      Point(x: 17.888058560281518, y: 46.89226406700873)),
  'EPSG:2063': ProjectAndUnProjectResult(
      Point(x: 2988586.7424041587, y: 5743994.832182371),
      Point(x: 17.888058581617294, y: 46.89226404402927)),
  'EPSG:2064': ProjectAndUnProjectResult(
      Point(x: 2540421.9143028324, y: 5555694.854662288),
      Point(x: 17.888058581617305, y: 46.892264044029275)),
  'EPSG:2065': ProjectAndUnProjectResult(
      Point(x: -528541.4989382785, y: -1425018.4481326628),
      Point(x: 17.888058569293737, y: 46.892264071214214)),
  'EPSG:9009': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:2066': ProjectAndUnProjectResult(
      Point(x: 26485739.50194274, y: 38950634.85449693),
      Point(x: -60205.17429596113, y: 752.8950735452335)),
  'EPSG:2067': ProjectAndUnProjectResult(
      Point(x: 5731077.213830213, y: 9059060.328525454),
      Point(x: 17.888058265257687, y: 46.892264099623354)),
  'EPSG:2068': ProjectAndUnProjectResult(
      Point(x: 877174.2791365524, y: 5233442.711583846),
      Point(x: 17.888058434831024, y: 46.89226402657196)),
  'EPSG:2069': ProjectAndUnProjectResult(
      Point(x: 724868.4445832657, y: 5218033.250551673),
      Point(x: 17.888058549525788, y: 46.89226405704958)),
  'EPSG:2070': ProjectAndUnProjectResult(
      Point(x: 572516.2375633244, y: 5206559.459927045),
      Point(x: 17.888058559553354, y: 46.89226406512193)),
  'EPSG:2071': ProjectAndUnProjectResult(
      Point(x: 420132.8434565015, y: 5198996.0726106735),
      Point(x: 17.888058559691398, y: 46.89226406629287)),
  'EPSG:2072': ProjectAndUnProjectResult(
      Point(x: 267731.6895766501, y: 5195326.393193976),
      Point(x: 17.888058559670743, y: 46.89226406634541)),
  'EPSG:2073': ProjectAndUnProjectResult(
      Point(x: 115325.17106628911, y: 5195542.310019263),
      Point(x: 17.888058559670505, y: 46.89226406634528)),
  'EPSG:2074': ProjectAndUnProjectResult(
      Point(x: -37074.63351051809, y: 5199644.30056243),
      Point(x: 17.88805855964199, y: 46.892264066263465)),
  'EPSG:4340': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2075': ProjectAndUnProjectResult(
      Point(x: -189455.24974488816, y: 5207641.431124745),
      Point(x: 17.888058559947464, y: 46.89226406475083)),
  'EPSG:2076': ProjectAndUnProjectResult(
      Point(x: -341803.09099735273, y: 5219551.350775675),
      Point(x: 17.888058573693698, y: 46.89226405516002)),
  'EPSG:2077': ProjectAndUnProjectResult(
      Point(x: 1176971.1054662648, y: 5231872.521559665),
      Point(x: 17.888058559670682, y: 46.89226406634547)),
  'EPSG:2078': ProjectAndUnProjectResult(
      Point(x: 720066.7969970071, y: 5197436.217802365),
      Point(x: 17.888058559670682, y: 46.89226406634547)),
  'EPSG:2079': ProjectAndUnProjectResult(
      Point(x: 262996.49599516985, y: 5198084.251266245),
      Point(x: 17.88805855967067, y: 46.89226406634547)),
  'EPSG:2080': ProjectAndUnProjectResult(
      Point(x: -193894.47802897613, y: 5233829.5010506995),
      Point(x: 17.888058559670682, y: 46.892264066345454)),
  'EPSG:2081': ProjectAndUnProjectResult(
      Point(x: 7627815.610286063, y: 19760103.57021706),
      Point(x: -14573227050.243431, y: 3190611821.74919)),
  'EPSG:2082': ProjectAndUnProjectResult(
      Point(x: 7627836.604861228, y: 19760099.02032721),
      Point(x: 45, y: double.nan)),
  'EPSG:2083': ProjectAndUnProjectResult(
      Point(x: 7627733.958387017, y: 19759828.399297565),
      Point(x: 45, y: double.nan)),
  'EPSG:2084': ProjectAndUnProjectResult(
      Point(x: 5820935.135240953, y: 19674201.786657892),
      Point(x: 17.888058440261158, y: 46.892264104595185)),
  'EPSG:2086': ProjectAndUnProjectResult(
      Point(x: 8148778.833216205, y: 5547198.979132076),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:2087': ProjectAndUnProjectResult(
      Point(x: 948562.5161284998, y: 5210242.47811393),
      Point(x: 17.88805855781303, y: 46.89226406264945)),
  'EPSG:2088': ProjectAndUnProjectResult(
      Point(x: 1024591.3972585963, y: 5215786.08805497),
      Point(x: 17.888058524414195, y: 46.892263960406844)),
  'EPSG:2089': ProjectAndUnProjectResult(
      Point(x: -1557536.0363929619, y: 5561947.769911137),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:2090': ProjectAndUnProjectResult(
      Point(x: -2005502.501230997, y: 5751885.308911241),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:2091': ProjectAndUnProjectResult(
      Point(x: 6441663.530162457, y: 5564103.330087571),
      Point(x: 17.89339697213266, y: 46.892742762902465)),
  'EPSG:2092': ProjectAndUnProjectResult(
      Point(x: 6993498.98724838, y: 5754124.1644214),
      Point(x: 17.9309147229843, y: 46.897079180364614)),
  'EPSG:2093': ProjectAndUnProjectResult(
      Point(x: -4605022.839155141, y: 9891596.17907378),
      Point(x: 45, y: double.nan)),
  'EPSG:2094': ProjectAndUnProjectResult(
      Point(x: -4602868.964570255, y: 9887637.183972629),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2095': ProjectAndUnProjectResult(
      Point(x: 2988724.7160853767, y: 5744008.928866982),
      Point(x: 17.888058462095806, y: 46.89226406913975)),
  'EPSG:2096': ProjectAndUnProjectResult(
      Point(x: -2477612.1348247016, y: 8322504.999159849), Point(x: 0, y: 90)),
  'EPSG:2097': ProjectAndUnProjectResult(
      Point(x: -2891540.3050450194, y: 8210147.902179337), Point(x: 0, y: 90)),
  'EPSG:2098': ProjectAndUnProjectResult(
      Point(x: -3256833.590421062, y: 8074209.140349129), Point(x: 0, y: 90)),
  'EPSG:2099': ProjectAndUnProjectResult(
      Point(x: -2335874.79579628, y: 3037644.802229198),
      Point(x: 18.660391681670056, y: 46.9111493169039)),
  'EPSG:2100': ProjectAndUnProjectResult(
      Point(x: 34306.32981000986, y: 5211073.220895577),
      Point(x: 17.888058545235562, y: 46.89226403542799)),
  'EPSG:2101': ProjectAndUnProjectResult(
      Point(x: 8487716.541155947, y: 5517836.138907651),
      Point(x: 17.888058560281525, y: 46.89226406700871)),
  'EPSG:2102': ProjectAndUnProjectResult(
      Point(x: 8687716.541155947, y: 5717836.138907651),
      Point(x: 17.888058560281525, y: 46.89226406700871)),
  'EPSG:2103': ProjectAndUnProjectResult(
      Point(x: 8987716.541155947, y: 6017836.138907651),
      Point(x: 17.888058560281525, y: 46.89226406700871)),
  'EPSG:2104': ProjectAndUnProjectResult(
      Point(x: 8470672.541155947, y: 5547381.140907652),
      Point(x: 17.888058560281525, y: 46.89226406700871)),
  'EPSG:2105': ProjectAndUnProjectResult(
      Point(x: 32850550.065560255, y: -3270535.576852885),
      Point(x: -4199764943.5286245, y: -5957715656.169244)),
  'EPSG:2106': ProjectAndUnProjectResult(
      Point(x: 35759476.71623347, y: -5777315.079927069), Point(x: 0, y: -90)),
  'EPSG:2107': ProjectAndUnProjectResult(
      Point(x: 38318911.48100344, y: -8040181.450261377), Point(x: 0, y: -90)),
  'EPSG:2108': ProjectAndUnProjectResult(
      Point(x: 36125762.57713887, y: -5901469.767428318), Point(x: 0, y: -90)),
  'EPSG:2109': ProjectAndUnProjectResult(
      Point(x: 31973641.181411814, y: -2247993.836208177),
      Point(x: -298884534.2929694, y: -423154071.5673603)),
  'EPSG:2110': ProjectAndUnProjectResult(
      Point(x: 34327332.79609692, y: -4289279.409817552),
      Point(x: -32742816039535.246, y: -47525696566486.016)),
  'EPSG:2111': ProjectAndUnProjectResult(
      Point(x: 34068419.96635581, y: -3976456.4830530314),
      Point(x: -2519565311616.5806, y: -3636547354206.4497)),
  'EPSG:2112': ProjectAndUnProjectResult(
      Point(x: 34339673.9589003, y: -4143440.224427971),
      Point(x: -37973903095663.65, y: -55134268755000.69)),
  'EPSG:2113': ProjectAndUnProjectResult(
      Point(x: 32874046.41045196, y: -2797958.525036691),
      Point(x: -4515425166.07598, y: -6406514911.378608)),
  'EPSG:2114': ProjectAndUnProjectResult(
      Point(x: 29513789.58716431, y: 44107.2351280842),
      Point(x: -2611936.0038365964, y: -3936120.7101866063)),
  'EPSG:4342': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2115': ProjectAndUnProjectResult(
      Point(x: 30489035.306998402, y: -725324.512856351),
      Point(x: -12876700.09181123, y: -18658874.29126566)),
  'EPSG:2116': ProjectAndUnProjectResult(
      Point(x: 28656830.8124914, y: 830153.3168542829),
      Point(x: -773156.938411585, y: -1228253.689185668)),
  'EPSG:2117': ProjectAndUnProjectResult(
      Point(x: 27869208.089729458, y: 1544532.5120018146),
      Point(x: -281811.1669623546, y: -476370.1261903999)),
  'EPSG:2118': ProjectAndUnProjectResult(
      Point(x: 27822837.02783532, y: 1641064.5844478845),
      Point(x: -266271.72178309405, y: -451885.84998319583)),
  'EPSG:2119': ProjectAndUnProjectResult(
      Point(x: 30036695.885839436, y: -181239.37348593108),
      Point(x: -5943326.577045224, y: -8746687.248570332)),
  'EPSG:2120': ProjectAndUnProjectResult(
      Point(x: 31286742.00371912, y: -1383042.9101164634),
      Point(x: -60508707.335342064, y: -86182687.46876109)),
  'EPSG:2121': ProjectAndUnProjectResult(
      Point(x: 26989884.593294784, y: 2388592.0331349443),
      Point(x: -100393.16164697426, y: -183187.94481468308)),
  'EPSG:2122': ProjectAndUnProjectResult(
      Point(x: 25963676.639189754, y: 3247587.8181949467),
      Point(x: -33322.17233272656, y: -65146.77183461389)),
  'EPSG:2123': ProjectAndUnProjectResult(
      Point(x: 23701742.26292862, y: 5136799.454106336),
      Point(x: -4624.2225625370465, y: -4574.04745204502)),
  'EPSG:4344': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2124': ProjectAndUnProjectResult(
      Point(x: 29598432.423587836, y: 291775.43540201656),
      Point(x: -2970085.785647243, y: -4456765.992337756)),
  'EPSG:2125': ProjectAndUnProjectResult(
      Point(x: 27544492.860864505, y: 2028444.204376034),
      Point(x: -190505.2633385869, y: -331203.45893672656)),
  'EPSG:2126': ProjectAndUnProjectResult(
      Point(x: 27102127.331886742, y: 2465018.3980043815),
      Point(x: -113982.78651000015, y: -205992.32562848937)),
  'EPSG:2127': ProjectAndUnProjectResult(
      Point(x: 24862053.484980527, y: 4309331.922602151),
      Point(x: -11494.224264886332, y: -21364.563567721947)),
  'EPSG:2128': ProjectAndUnProjectResult(
      Point(x: 23427706.35134291, y: 5477898.539964551),
      Point(x: -3928.8987458178717, y: -2460.4207688839397)),
  'EPSG:2129': ProjectAndUnProjectResult(
      Point(x: 22569959.180864595, y: 6185243.87407861),
      Point(x: -2826.4646871818013, y: 1883.3950870020797)),
  'EPSG:2130': ProjectAndUnProjectResult(
      Point(x: 26484920.948208235, y: 3126186.532855955),
      Point(x: -57608.89888369485, y: -109400.7560537086)),
  'EPSG:2131': ProjectAndUnProjectResult(
      Point(x: 25993190.252229676, y: 3528578.7160891304),
      Point(x: -34383.531734012, y: -67143.59487000619)),
  'EPSG:2132': ProjectAndUnProjectResult(
      Point(x: 23354328.47571193, y: 5697778.310615819),
      Point(x: -3777.7176323807585, y: -1967.9352749532163)),
  'EPSG:4346': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2133': ProjectAndUnProjectResult(
      Point(x: -1988897.8368866723, y: 24251921.064358793),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:2134': ProjectAndUnProjectResult(
      Point(x: -1540720.0453096956, y: 24440239.592344202),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:2135': ProjectAndUnProjectResult(
      Point(x: -1088186.0339291478, y: 24586736.438492097),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:2136': ProjectAndUnProjectResult(
      Point(x: 5614410.538666464, y: 15924700.735644972),
      Point(x: 17.887904271665004, y: 46.892270643403975)),
  'EPSG:2137': ProjectAndUnProjectResult(
      Point(x: 1936735.369318174, y: 5368921.034444872),
      Point(x: 17.887904271665, y: 46.89227064340398)),
  'EPSG:2138': ProjectAndUnProjectResult(
      Point(x: 5088437.181013189, y: 3830039.0128744384),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2139': ProjectAndUnProjectResult(
      Point(x: 5277537.244089515, y: 8355177.8227729015),
      Point(x: -15979.524499782834, y: 3524.3478798098868)),
  'EPSG:2140': ProjectAndUnProjectResult(
      Point(x: 5365095.243901447, y: 8649032.835441044),
      Point(x: -76314.668724916, y: 16624.267920019753)),
  'EPSG:2141': ProjectAndUnProjectResult(
      Point(x: 5425861.74852327, y: 8954491.865918288),
      Point(x: -519603.48216074344, y: 113747.10753176517)),
  'EPSG:2327': ProjectAndUnProjectResult(
      Point(x: 9328491.454432117, y: 7001530.270014272),
      Point(x: 66.4697845990235, y: 55.6853672776166)),
  'EPSG:2142': ProjectAndUnProjectResult(
      Point(x: 5455664.100526009, y: 9269865.456694849),
      Point(x: -6859630.010890731, y: 1508686.9880534173)),
  'EPSG:2143': ProjectAndUnProjectResult(
      Point(x: 5449809.877896608, y: 9592937.814035818),
      Point(x: -411243275.37217355, y: 90346346.30780989)),
  'EPSG:2144': ProjectAndUnProjectResult(
      Point(x: 5403037.173898023, y: 9920877.559935424),
      Point(x: -34661211008946.938, y: 7546306826338.474)),
  'EPSG:2145': ProjectAndUnProjectResult(
      Point(x: 5309461.530223562, y: 10250138.320860693), Point(x: 0, y: 90)),
  'EPSG:2146': ProjectAndUnProjectResult(
      Point(x: 5162519.4015817605, y: 10576348.404652024), Point(x: 0, y: 90)),
  'EPSG:2147': ProjectAndUnProjectResult(
      Point(x: 4954908.029848009, y: 10894188.79017561), Point(x: 0, y: 90)),
  'EPSG:2148': ProjectAndUnProjectResult(
      Point(x: 5558786.502469642, y: 8470922.227642598),
      Point(x: 17.88805856028146, y: 46.89226406700888)),
  'EPSG:2149': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 10298556.41432563),
      Point(x: 17.88805856028164, y: 46.892264067008654)),
  'EPSG:2150': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 10914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:4348': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2151': ProjectAndUnProjectResult(
      Point(x: 4671946.775898903, y: 12999702.032507129),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:2152': ProjectAndUnProjectResult(
      Point(x: 4286275.534235133, y: 13389860.739087315),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:2153': ProjectAndUnProjectResult(
      Point(x: 3875003.072767595, y: 13725397.247874938),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:2154': ProjectAndUnProjectResult(
      Point(x: 1826843.263640678, y: 6750111.643270713),
      Point(x: 17.888058560281515, y: 46.89226406700873)),
  'EPSG:2155': ProjectAndUnProjectResult(
      Point(x: -66397095.827139184, y: 4913195.532080005),
      Point(x: 17.888058498506634, y: 46.892264036184514)),
  'EPSG:2156': ProjectAndUnProjectResult(
      Point(x: -1540720.0453096956, y: 24440239.592344202),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:2157': ProjectAndUnProjectResult(
      Point(x: 2565971.4726937497, y: 350468.4491314345),
      Point(x: 17.884705059466434, y: 46.89254697437338)),
  'EPSG:2158': ProjectAndUnProjectResult(
      Point(x: 2540720.0453096954, y: 5555690.29353334),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:2159': ProjectAndUnProjectResult(
      Point(x: 7936041.96888435, y: 16107250.373495117),
      Point(x: 17.873539829245182, y: 46.893725891566746)),
  'EPSG:4350': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2160': ProjectAndUnProjectResult(
      Point(x: 8236041.968884351, y: 16707250.373495117),
      Point(x: 17.873539829245182, y: 46.893725891566746)),
  'EPSG:2161': ProjectAndUnProjectResult(
      Point(x: 2988885.149592403, y: 5743924.383783524),
      Point(x: 17.88805856385922, y: 46.892264049491494)),
  'EPSG:2162': ProjectAndUnProjectResult(
      Point(x: 2540706.236357931, y: 5555601.125311185),
      Point(x: 17.888058563859214, y: 46.8922640494915)),
  'EPSG:2163': ProjectAndUnProjectResult(
      Point(x: 4791084.455189992, y: 5887725.762451968),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:2164': ProjectAndUnProjectResult(
      Point(x: 2239389.105679148, y: 5453183.305943991),
      Point(x: 17.88706939408443, y: 46.89233277336357)),
  'EPSG:2165': ProjectAndUnProjectResult(
      Point(x: 2239389.0839464013, y: 5453183.635929374),
      Point(x: 17.887069393627435, y: 46.89233277347706)),
  'EPSG:2166': ProjectAndUnProjectResult(
      Point(x: 4177291.738831021, y: 5233913.048442174),
      Point(x: 17.88805844634046, y: 46.892264029990585)),
  'EPSG:2167': ProjectAndUnProjectResult(
      Point(x: 4948796.71822361, y: 5212272.480322573),
      Point(x: 17.88805856953789, y: 46.89226406590728)),
  'EPSG:2168': ProjectAndUnProjectResult(
      Point(x: 5720214.533676548, y: 5199458.992247189),
      Point(x: 17.88805857142926, y: 46.89226406953736)),
  'EPSG:2178': ProjectAndUnProjectResult(
      Point(x: 7262868.68864916, y: 5199573.694242832),
      Point(x: 17.88805856025308, y: 46.89226406692701)),
  'EPSG:2169': ProjectAndUnProjectResult(
      Point(x: 972727.6705186315, y: -160036.37681488332),
      Point(x: 17.88805685051788, y: 46.8922639079873)),
  'EPSG:2170': ProjectAndUnProjectResult(
      Point(x: 720441.5911686714, y: 5198320.184713091),
      Point(x: 17.888058563195006, y: 46.89226406711906)),
  'EPSG:2171': ProjectAndUnProjectResult(
      Point(x: 4393448.659624081, y: 5236980.26449201),
      Point(x: 17.888058572338835, y: 46.89226406879691)),
  'EPSG:2172': ProjectAndUnProjectResult(
      Point(x: 4326990.83530267, y: 5132629.844777857),
      Point(x: 17.888058572338835, y: 46.89226406879691)),
  'EPSG:2173': ProjectAndUnProjectResult(
      Point(x: 3568381.6764939143, y: 5254461.948739831),
      Point(x: 17.88805857233884, y: 46.89226406879691)),
  'EPSG:2174': ProjectAndUnProjectResult(
      Point(x: 3795922.0731681488, y: 5096131.4504086105),
      Point(x: 17.888058572338835, y: 46.89226406879691)),
  'EPSG:2175': ProjectAndUnProjectResult(
      Point(x: 155560.46537570143, y: 495869.3370027859),
      Point(x: 17.888058572338693, y: 46.89226406879674)),
  'EPSG:2176': ProjectAndUnProjectResult(
      Point(x: 5720072.31867286, y: 5198920.990764878),
      Point(x: 17.888058560302017, y: 46.89226406695651)),
  'EPSG:2177': ProjectAndUnProjectResult(
      Point(x: 6491469.740628461, y: 5194876.075589367),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:2179': ProjectAndUnProjectResult(
      Point(x: 8034311.066893917, y: 5213037.208459122),
      Point(x: 17.88805856312982, y: 46.89226406242482)),
  'EPSG:2180': ProjectAndUnProjectResult(
      Point(x: 415319.99980040884, y: -107766.73050999455),
      Point(x: 17.888058560281344, y: 46.89226406700861)),
  'EPSG:2188': ProjectAndUnProjectResult(
      Point(x: 4271771.1159932185, y: 6592513.030206774),
      Point(x: 17.88805855714915, y: 46.892264088155976)),
  'EPSG:2189': ProjectAndUnProjectResult(
      Point(x: 3859199.183303104, y: 6259136.956381631),
      Point(x: 17.88805850460325, y: 46.89226408352831)),
  'EPSG:2190': ProjectAndUnProjectResult(
      Point(x: 3859285.834936196, y: 6259006.927465932),
      Point(x: 17.888058504324544, y: 46.892264056347535)),
  'EPSG:2191': ProjectAndUnProjectResult(
      Point(x: 2989015.105496556, y: 5744135.041603794),
      Point(x: 17.88805856028152, y: 46.89226406700879)),
  'EPSG:2192': ProjectAndUnProjectResult(
      Point(x: 1777352.092885307, y: 2327205.9185266593),
      Point(x: 17.88805856532192, y: 46.89226407177286)),
  'EPSG:2193': ProjectAndUnProjectResult(
      Point(x: 31209288.20939178, y: 4306152.547655749),
      Point(x: -5793696.938596561, y: -8531714.862681149)),
  'EPSG:2194': ProjectAndUnProjectResult(
      Point(x: -73643801.66334432, y: -1156866.5260123087),
      Point(x: 17.888058498506634, y: 46.892264036184514)),
  'EPSG:2328': ProjectAndUnProjectResult(
      Point(x: 9982558.421082169, y: 7451377.632612198),
      Point(x: -29.203550701008353, y: 107.7556902611498)),
  'EPSG:2195': ProjectAndUnProjectResult(
      Point(x: -176891.28615693585, y: 24764258.052049905),
      Point(x: 17.88805856028154, y: 46.892264067008824)),
  'EPSG:2196': ProjectAndUnProjectResult(
      Point(x: 839056.3768331184, y: 5229280.974066414),
      Point(x: 17.888058488739624, y: 46.89226403833658)),
  'EPSG:2197': ProjectAndUnProjectResult(
      Point(x: 948646.8348811632, y: 5211869.284666118),
      Point(x: 17.888058558416994, y: 46.89226406333179)),
  'EPSG:2198': ProjectAndUnProjectResult(
      Point(x: 1120089.2655463072, y: 5199321.338507943),
      Point(x: 17.888058560302017, y: 46.89226406695651)),
  'EPSG:2199': ProjectAndUnProjectResult(
      Point(x: 4262979.618454169, y: 5200109.974276837),
      Point(x: 17.888058561832175, y: 46.89226406409104)),
  'EPSG:2200': ProjectAndUnProjectResult(
      Point(x: 5816396.4201043, y: 4484244.544207149),
      Point(x: 17.888058560281525, y: 46.892264067008796)),
  'EPSG:2201': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 10298556.41432563),
      Point(x: 17.88805856028164, y: 46.892264067008654)),
  'EPSG:2202': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 9674131.646974),
      Point(x: 17.888058560281358, y: 46.892264067008654)),
  'EPSG:2203': ProjectAndUnProjectResult(
      Point(x: 5731020.405467821, y: 9059228.545130335),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:2204': ProjectAndUnProjectResult(
      Point(x: 23787400.95592869, y: 17368660.079644486),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:2205': ProjectAndUnProjectResult(
      Point(x: 6854798.276271999, y: 4982007.395728776),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2206': ProjectAndUnProjectResult(
      Point(x: 8805835.558791894, y: 5235921.738050902),
      Point(x: 17.888058723412236, y: 46.89226402624652)),
  'EPSG:2207': ProjectAndUnProjectResult(
      Point(x: 9577493.88483472, y: 5267161.966714753),
      Point(x: 17.88806088967312, y: 46.892263897270425)),
  'EPSG:2208': ProjectAndUnProjectResult(
      Point(x: 10349377.792572536, y: 5307499.291513194),
      Point(x: 17.88807716577362, y: 46.89226406012086)),
  'EPSG:2209': ProjectAndUnProjectResult(
      Point(x: 11121586.300820123, y: 5357129.58577281),
      Point(x: 17.88816193315454, y: 46.89226781527169)),
  'EPSG:2210': ProjectAndUnProjectResult(
      Point(x: 11894248.322078396, y: 5416290.662010544),
      Point(x: 17.88850900875216, y: 46.89229072693788)),
  'EPSG:2211': ProjectAndUnProjectResult(
      Point(x: 12667529.955258828, y: 5485261.147490877),
      Point(x: 17.88971086715372, y: 46.89238960175352)),
  'EPSG:2212': ProjectAndUnProjectResult(
      Point(x: 13441642.51414534, y: 5564358.804472028),
      Point(x: 17.893398352663354, y: 46.892742746067256)),
  'EPSG:2213': ProjectAndUnProjectResult(
      Point(x: -422174.5031304131, y: 5264871.233027248),
      Point(x: 17.88806088688771, y: 46.89226389365527)),
  'EPSG:2214': ProjectAndUnProjectResult(
      Point(x: 1562499.0954302107, y: 6216696.097143596),
      Point(x: 17.88805853282264, y: 46.892264054463574)),
  'EPSG:2215': ProjectAndUnProjectResult(
      Point(x: 1177012.033743362, y: 5231668.495955737),
      Point(x: 17.88805851442824, y: 46.8922639914871)),
  'EPSG:2216': ProjectAndUnProjectResult(
      Point(x: 5313945.417428831, y: 7923290.509148076),
      Point(x: 17.888058527031845, y: 46.89226417016862)),
  'EPSG:2217': ProjectAndUnProjectResult(
      Point(x: 5009459.370165703, y: 7424934.826327958),
      Point(x: 17.88805852703186, y: 46.89226417016857)),
  'EPSG:2219': ProjectAndUnProjectResult(
      Point(x: 5820827.075424567, y: 9674128.600849438),
      Point(x: 17.888058560281397, y: 46.892264067008654)),
  'EPSG:2220': ProjectAndUnProjectResult(
      Point(x: 5731018.770235398, y: 9059225.69156166),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:2222': ProjectAndUnProjectResult(
      Point(x: -10399806.518539019, y: 25963983.55181139), Point(x: 0, y: 90)),
  'EPSG:2223': ProjectAndUnProjectResult(
      Point(x: -13543801.5364406, y: 24888413.49452938), Point(x: 0, y: 90)),
  'EPSG:2224': ProjectAndUnProjectResult(
      Point(x: -17112193.866983697, y: 23518362.396374583), Point(x: 0, y: 90)),
  'EPSG:2225': ProjectAndUnProjectResult(
      Point(x: 28587111.613013346, y: 26997662.4569494),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2243': ProjectAndUnProjectResult(
      Point(x: -19420021.483049188, y: 17825378.802620757), Point(x: 0, y: 90)),
  'EPSG:2226': ProjectAndUnProjectResult(
      Point(x: 29490928.127553087, y: 27229420.066716958),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:2227': ProjectAndUnProjectResult(
      Point(x: 30172292.14900214, y: 26973096.865134276),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:2228': ProjectAndUnProjectResult(
      Point(x: 30723796.79656839, y: 26753014.189562038),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:2229': ProjectAndUnProjectResult(
      Point(x: 31683048.00808699, y: 26700474.83101188),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2230': ProjectAndUnProjectResult(
      Point(x: 32341774.398609553, y: 26377843.57152736),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:2231': ProjectAndUnProjectResult(
      Point(x: 24966835.570312265, y: 22103331.550557755),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2232': ProjectAndUnProjectResult(
      Point(x: 25415893.18631023, y: 22403922.591381256),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2233': ProjectAndUnProjectResult(
      Point(x: 25926473.257043168, y: 22550664.95360246),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2234': ProjectAndUnProjectResult(
      Point(x: 19813264.617850065, y: 13594950.05734413),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:2235': ProjectAndUnProjectResult(
      Point(x: 16790808.84134736, y: 20514172.84270222), Point(x: 0, y: 90)),
  'EPSG:2236': ProjectAndUnProjectResult(
      Point(x: 15489593.979353804, y: 27416023.75950058), Point(x: 0, y: 90)),
  'EPSG:2237': ProjectAndUnProjectResult(
      Point(x: 15174228.04246971, y: 27744330.38729839), Point(x: 0, y: 90)),
  'EPSG:2238': ProjectAndUnProjectResult(
      Point(x: 25311130.553737484, y: 17855126.624383375),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:2239': ProjectAndUnProjectResult(
      Point(x: 15118403.957847713, y: 25737343.784918793), Point(x: 0, y: 90)),
  'EPSG:2240': ProjectAndUnProjectResult(
      Point(x: 16034054.29733326, y: 26367116.78968559), Point(x: 0, y: 90)),
  'EPSG:2241': ProjectAndUnProjectResult(
      Point(x: -14057937.667923164, y: 20834716.344766937), Point(x: 0, y: 90)),
  'EPSG:2242': ProjectAndUnProjectResult(
      Point(x: -16681202.277333234, y: 19427882.72002641), Point(x: 0, y: 90)),
  'EPSG:2244': ProjectAndUnProjectResult(
      Point(x: 13443875.494497076, y: 24904663.66490966), Point(x: 0, y: 90)),
  'EPSG:2245': ProjectAndUnProjectResult(
      Point(x: 15414189.905530728, y: 25302765.529912125), Point(x: 0, y: 90)),
  'EPSG:2246': ProjectAndUnProjectResult(
      Point(x: 22489450.678402383, y: 16345135.930820161),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2247': ProjectAndUnProjectResult(
      Point(x: 22967474.00105343, y: 18536097.935624205),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:2248': ProjectAndUnProjectResult(
      Point(x: 21190442.582283285, y: 14745735.004731355),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:2249': ProjectAndUnProjectResult(
      Point(x: 19196544.98708545, y: 15324376.324036008),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:2250': ProjectAndUnProjectResult(
      Point(x: 20191338.90486749, y: 12525841.796467042),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:2251': ProjectAndUnProjectResult(
      Point(x: 45461213.70641344, y: 15730349.260780366),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:4352': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2252': ProjectAndUnProjectResult(
      Point(x: 39006952.19021326, y: 15402243.62815605),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:2253': ProjectAndUnProjectResult(
      Point(x: 32899589.65714337, y: 15708442.659052998),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:2254': ProjectAndUnProjectResult(
      Point(x: 12542576.309419384, y: 27849501.87445014), Point(x: 0, y: 90)),
  'EPSG:2255': ProjectAndUnProjectResult(
      Point(x: 12992572.243961738, y: 28200799.426332895), Point(x: 0, y: 90)),
  'EPSG:2256': ProjectAndUnProjectResult(
      Point(x: 21510163.334050607, y: 21622551.551792037),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2257': ProjectAndUnProjectResult(
      Point(x: -1740585.942947746, y: 28162864.26349877), Point(x: 0, y: 90)),
  'EPSG:2258': ProjectAndUnProjectResult(
      Point(x: -3274517.639472816, y: 27651211.139304798), Point(x: 0, y: 90)),
  'EPSG:2259': ProjectAndUnProjectResult(
      Point(x: -4556912.360749827, y: 27080492.584270146), Point(x: 0, y: 90)),
  'EPSG:2260': ProjectAndUnProjectResult(
      Point(x: 16771473.19291651, y: 19881470.240724005), Point(x: 0, y: 90)),
  'EPSG:2261': ProjectAndUnProjectResult(
      Point(x: 16742057.214225767, y: 20198326.19815082), Point(x: 0, y: 90)),
  'EPSG:2262': ProjectAndUnProjectResult(
      Point(x: 16635885.195668627, y: 20897177.962862995), Point(x: 0, y: 90)),
  'EPSG:2263': ProjectAndUnProjectResult(
      Point(x: 20080362.042142667, y: 13503621.26983818),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2264': ProjectAndUnProjectResult(
      Point(x: 23009024.984398805, y: 15969960.634952374),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:2265': ProjectAndUnProjectResult(
      Point(x: 21212141.1777009, y: 18575411.16597377),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2266': ProjectAndUnProjectResult(
      Point(x: 21568125.75435474, y: 18836205.032457754),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2267': ProjectAndUnProjectResult(
      Point(x: 24956378.374106497, y: 19976436.59594429),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:2268': ProjectAndUnProjectResult(
      Point(x: 25553996.407476988, y: 20227709.190562464),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3374': ProjectAndUnProjectResult(
      Point(x: 2540816.1327472506, y: 5555807.278455735),
      Point(x: 17.888058560281504, y: 46.89226406700879)),
  'EPSG:2269': ProjectAndUnProjectResult(
      Point(x: 28205491.53782647, y: 24245461.29358233),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:2270': ProjectAndUnProjectResult(
      Point(x: 25833585.615591403, y: 24599246.142841343),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:2271': ProjectAndUnProjectResult(
      Point(x: 21399134.738047402, y: 14424379.654619897),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2272': ProjectAndUnProjectResult(
      Point(x: 21600173.968596835, y: 14567500.710063381),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:2273': ProjectAndUnProjectResult(
      Point(x: 23724086.117270596, y: 16795620.69326082),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:2274': ProjectAndUnProjectResult(
      Point(x: 23755941.686326686, y: 17389305.165589985),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:2275': ProjectAndUnProjectResult(
      Point(x: 24255654.445273783, y: 24283641.25020052),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2276': ProjectAndUnProjectResult(
      Point(x: 26211047.58759166, y: 27153798.92289697),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:4354': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2277': ProjectAndUnProjectResult(
      Point(x: 27620463.418675568, y: 31078601.6437094),
      Point(x: 17.88805856028155, y: 46.892264067008746)),
  'EPSG:2278': ProjectAndUnProjectResult(
      Point(x: 27843540.280672904, y: 34296206.30905828),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:2279': ProjectAndUnProjectResult(
      Point(x: 27835397.225557923, y: 37629307.37812436),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:2280': ProjectAndUnProjectResult(
      Point(x: 23401765.337626535, y: 25725115.05581844),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:2281': ProjectAndUnProjectResult(
      Point(x: 24004536.819161545, y: 29432949.629476044),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:2282': ProjectAndUnProjectResult(
      Point(x: 24918173.066587433, y: 32865585.764436252),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:2283': ProjectAndUnProjectResult(
      Point(x: 31609131.381488748, y: 21591230.948789444),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:2284': ProjectAndUnProjectResult(
      Point(x: 31900874.224490017, y: 18579489.497676484),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:2285': ProjectAndUnProjectResult(
      Point(x: 20370302.974943724, y: 23626235.95369611),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:2286': ProjectAndUnProjectResult(
      Point(x: 21028688.336513802, y: 23890497.31480848),
      Point(x: 17.88805856028154, y: 46.892264067008746)),
  'EPSG:2287': ProjectAndUnProjectResult(
      Point(x: 21381299.102231305, y: 16301056.100981915),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:2288': ProjectAndUnProjectResult(
      Point(x: 21690411.73560526, y: 16558125.8202394),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:2289': ProjectAndUnProjectResult(
      Point(x: 22059612.239289284, y: 16959866.73353126),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:2290': ProjectAndUnProjectResult(
      Point(x: 6057388.725592133, y: 3704941.0101681734),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:2291': ProjectAndUnProjectResult(
      Point(x: 5757388.725592133, y: 4104941.0101681734),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:2292': ProjectAndUnProjectResult(
      Point(x: 5757390.397843242, y: 4104942.040903113),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:2294': ProjectAndUnProjectResult(
      Point(x: 9621060.146669127, y: 8954489.047766129),
      Point(x: -519603.4928398791, y: 113747.10968959854)),
  'EPSG:2295': ProjectAndUnProjectResult(
      Point(x: 10650862.488601722, y: 9269862.540419921),
      Point(x: -6859630.238764825, y: 1508687.0354645539)),
  'EPSG:2308': ProjectAndUnProjectResult(
      Point(x: -4513134.124233968, y: 20216828.511930987),
      Point(x: 118.9688106325813, y: 89.99303026578566)),
  'EPSG:2309': ProjectAndUnProjectResult(
      Point(x: -4088660.7438535104, y: 20965646.197774395), Point(x: 0, y: 90)),
  'EPSG:2310': ProjectAndUnProjectResult(
      Point(x: -1456461.55427555, y: 22141396.692297444), Point(x: 0, y: 90)),
  'EPSG:2311': ProjectAndUnProjectResult(
      Point(x: 1405147.9833163773, y: 5262228.862753582),
      Point(x: 17.88805660756604, y: 46.89226390459157)),
  'EPSG:2312': ProjectAndUnProjectResult(
      Point(x: 720011.5202624107, y: 5196929.190889371),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:2313': ProjectAndUnProjectResult(
      Point(x: 720011.5202624107, y: 5196929.190889371),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:2314': ProjectAndUnProjectResult(
      Point(x: 17761587.675211947, y: 26351562.307014886),
      Point(x: 45, y: double.nan)),
  'EPSG:2315': ProjectAndUnProjectResult(
      Point(x: 5821106.5240715835, y: 19674198.268468328),
      Point(x: 17.888058488318833, y: 46.89226405494144)),
  'EPSG:2316': ProjectAndUnProjectResult(
      Point(x: 5731260.76704681, y: 19059268.521916512),
      Point(x: 17.888058488318745, y: 46.8922640549416)),
  'EPSG:2317': ProjectAndUnProjectResult(
      Point(x: 9479662.195388306, y: 6627480.319235176),
      Point(x: 17.888058676900886, y: 46.892264008108)),
  'EPSG:2318': ProjectAndUnProjectResult(
      Point(x: -2439841.30386344, y: 2731845.1191254184),
      Point(x: 17.88805858437824, y: 46.89226406096703)),
  'EPSG:2319': ProjectAndUnProjectResult(
      Point(x: -194164.44120810507, y: 5235921.738050902),
      Point(x: 17.888058723412243, y: 46.89226402624652)),
  'EPSG:2320': ProjectAndUnProjectResult(
      Point(x: -422506.1151652804, y: 5267161.966714753),
      Point(x: 17.88806088967312, y: 46.892263897270425)),
  'EPSG:2321': ProjectAndUnProjectResult(
      Point(x: -650622.2074274644, y: 5307499.291513194),
      Point(x: 17.88807716577362, y: 46.89226406012086)),
  'EPSG:2322': ProjectAndUnProjectResult(
      Point(x: -878413.6991798768, y: 5357129.58577281),
      Point(x: 17.88816193315454, y: 46.89226781527169)),
  'EPSG:2323': ProjectAndUnProjectResult(
      Point(x: -1105751.6779216034, y: 5416290.662010544),
      Point(x: 17.888509008752173, y: 46.89229072693788)),
  'EPSG:2324': ProjectAndUnProjectResult(
      Point(x: -1332470.0447411719, y: 5485261.147490877),
      Point(x: 17.889710867153727, y: 46.89238960175352)),
  'EPSG:2325': ProjectAndUnProjectResult(
      Point(x: -1558357.485854659, y: 5564358.804472028),
      Point(x: 17.893398352663354, y: 46.892742746067256)),
  'EPSG:2326': ProjectAndUnProjectResult(
      Point(x: -3897811.017792186, y: 9131123.390083745),
      Point(x: -129.7117865736333, y: 89.99675233963234)),
  'EPSG:2329': ProjectAndUnProjectResult(
      Point(x: 10690682.231286068, y: 7959555.272730982),
      Point(x: 2295.099378965289, y: 590.2186964154122)),
  'EPSG:2330': ProjectAndUnProjectResult(
      Point(x: 11473395.285630517, y: 8523391.62570668),
      Point(x: 38040.257227164446, y: 8289.769529110425)),
  'EPSG:2331': ProjectAndUnProjectResult(
      Point(x: 12357223.443468181, y: 9135549.477252303),
      Point(x: 2043698.8088216712, y: 448818.12876096036)),
  'EPSG:2332': ProjectAndUnProjectResult(
      Point(x: 13375988.734144807, y: 9781978.876150142),
      Point(x: 30362283770.78012, y: 6642887993.212868)),
  'EPSG:2333': ProjectAndUnProjectResult(
      Point(x: 14572307.36085798, y: 10439327.3499834), Point(x: 0, y: 90)),
  'EPSG:2334': ProjectAndUnProjectResult(
      Point(x: 15999298.597274099, y: 11071718.188016934), Point(x: 0, y: 90)),
  'EPSG:2335': ProjectAndUnProjectResult(
      Point(x: 17722520.177030027, y: 11626800.700874822), Point(x: 0, y: 90)),
  'EPSG:2336': ProjectAndUnProjectResult(
      Point(x: 19822145.776246022, y: 12030969.51220035), Point(x: 0, y: 90)),
  'EPSG:2337': ProjectAndUnProjectResult(
      Point(x: 22395400.18917641, y: 12183643.083021963), Point(x: 0, y: 90)),
  'EPSG:2338': ProjectAndUnProjectResult(
      Point(x: -3671508.545567883, y: 7001530.270014272),
      Point(x: 66.4697845990235, y: 55.6853672776166)),
  'EPSG:2339': ProjectAndUnProjectResult(
      Point(x: -4017441.578917832, y: 7451377.632612198),
      Point(x: -29.203550701007593, y: 107.75569026114995)),
  'EPSG:2340': ProjectAndUnProjectResult(
      Point(x: -4309317.768713932, y: 7959555.272730982),
      Point(x: 2295.0993789652853, y: 590.2186964154114)),
  'EPSG:2341': ProjectAndUnProjectResult(
      Point(x: -4526604.714369482, y: 8523391.62570668),
      Point(x: 38040.25722716442, y: 8289.769529110417)),
  'EPSG:2342': ProjectAndUnProjectResult(
      Point(x: -4642776.556531819, y: 9135549.477252303),
      Point(x: 2043698.8088216712, y: 448818.12876096036)),
  'EPSG:2343': ProjectAndUnProjectResult(
      Point(x: -4624011.265855193, y: 9781978.876150142),
      Point(x: 30362283770.78012, y: 6642887993.212868)),
  'EPSG:2344': ProjectAndUnProjectResult(
      Point(x: -4427692.63914202, y: 10439327.3499834), Point(x: 0, y: 90)),
  'EPSG:2345': ProjectAndUnProjectResult(
      Point(x: -4000701.4027259024, y: 11071718.188016934), Point(x: 0, y: 90)),
  'EPSG:2346': ProjectAndUnProjectResult(
      Point(x: -3277479.822969972, y: 11626800.700874822), Point(x: 0, y: 90)),
  'EPSG:2347': ProjectAndUnProjectResult(
      Point(x: -2177854.223753977, y: 12030969.51220035), Point(x: 0, y: 90)),
  'EPSG:2348': ProjectAndUnProjectResult(
      Point(x: -604599.8108235879, y: 12183643.083021963), Point(x: 0, y: 90)),
  'EPSG:2349': ProjectAndUnProjectResult(
      Point(x: 21328491.454432115, y: 7001530.270014272),
      Point(x: 66.46978459902368, y: 55.685367277616635)),
  'EPSG:2350': ProjectAndUnProjectResult(
      Point(x: 22149848.855221204, y: 7219131.752109879),
      Point(x: 138.3748537244591, y: 69.53969103450645)),
  'EPSG:2351': ProjectAndUnProjectResult(
      Point(x: 22982558.42108217, y: 7451377.632612198),
      Point(x: -29.203550701008353, y: 107.7556902611498)),
  'EPSG:2352': ProjectAndUnProjectResult(
      Point(x: 23828706.417698834, y: 7698253.440512754),
      Point(x: 525.4502407500546, y: 220.88766096951426)),
  'EPSG:2353': ProjectAndUnProjectResult(
      Point(x: 24690682.231286068, y: 7959555.272730982),
      Point(x: 2295.099378965289, y: 590.2186964154122)),
  'EPSG:2354': ProjectAndUnProjectResult(
      Point(x: 25571212.059077147, y: 8234843.78697684),
      Point(x: 8796.331779592017, y: 1973.2780900632254)),
  'EPSG:2355': ProjectAndUnProjectResult(
      Point(x: 26473395.285630517, y: 8523391.62570668),
      Point(x: 38040.257227164446, y: 8289.769529110425)),
  'EPSG:2356': ProjectAndUnProjectResult(
      Point(x: 27400743.66683197, y: 8824123.667730357),
      Point(x: 216927.1895825029, y: 47354.207212484)),
  'EPSG:2357': ProjectAndUnProjectResult(
      Point(x: 28357223.443468183, y: 9135549.477252303),
      Point(x: 2043698.8088216654, y: 448818.12876095885)),
  'EPSG:2358': ProjectAndUnProjectResult(
      Point(x: 29347300.506247617, y: 9455687.293354005),
      Point(x: 53527737.62873764, y: 11775410.771296015)),
  'EPSG:2359': ProjectAndUnProjectResult(
      Point(x: 30375988.734144807, y: 9781978.876150142),
      Point(x: 30362283770.78012, y: 6642887993.212868)),
  'EPSG:2360': ProjectAndUnProjectResult(
      Point(x: 31448901.627943974, y: 10111194.499075353), Point(x: 0, y: 90)),
  'EPSG:2361': ProjectAndUnProjectResult(
      Point(x: 32572307.36085798, y: 10439327.3499834), Point(x: 0, y: 90)),
  'EPSG:2362': ProjectAndUnProjectResult(
      Point(x: 33753187.368098594, y: 10761476.576965183), Point(x: 0, y: 90)),
  'EPSG:2363': ProjectAndUnProjectResult(
      Point(x: 34999298.597274095, y: 11071718.188016934), Point(x: 0, y: 90)),
  'EPSG:2364': ProjectAndUnProjectResult(
      Point(x: 36319239.54149016, y: 11362962.986914543), Point(x: 0, y: 90)),
  'EPSG:2365': ProjectAndUnProjectResult(
      Point(x: 37722520.17703003, y: 11626800.700874822), Point(x: 0, y: 90)),
  'EPSG:2366': ProjectAndUnProjectResult(
      Point(x: 39219635.92748997, y: 11853329.428809231), Point(x: 0, y: 90)),
  'EPSG:2367': ProjectAndUnProjectResult(
      Point(x: 40822145.776246026, y: 12030969.51220035), Point(x: 0, y: 90)),
  'EPSG:2368': ProjectAndUnProjectResult(
      Point(x: 42542754.64912794, y: 12146260.903856175), Point(x: 0, y: 90)),
  'EPSG:2369': ProjectAndUnProjectResult(
      Point(x: 44395400.18917641, y: 12183643.083021963), Point(x: 0, y: 90)),
  'EPSG:2370': ProjectAndUnProjectResult(
      Point(x: -3671508.545567883, y: 7001530.270014272),
      Point(x: 66.4697845990235, y: 55.6853672776166)),
  'EPSG:2371': ProjectAndUnProjectResult(
      Point(x: -3850151.1447787965, y: 7219131.752109879),
      Point(x: 138.37485372445923, y: 69.53969103450649)),
  'EPSG:2372': ProjectAndUnProjectResult(
      Point(x: -4017441.578917832, y: 7451377.632612198),
      Point(x: -29.203550701007593, y: 107.75569026114995)),
  'EPSG:2373': ProjectAndUnProjectResult(
      Point(x: -4171293.582301167, y: 7698253.440512754),
      Point(x: 525.450240750056, y: 220.8876609695145)),
  'EPSG:2374': ProjectAndUnProjectResult(
      Point(x: -4309317.768713932, y: 7959555.272730982),
      Point(x: 2295.0993789652853, y: 590.2186964154114)),
  'EPSG:2375': ProjectAndUnProjectResult(
      Point(x: -4428787.940922854, y: 8234843.78697684),
      Point(x: 8796.331779592037, y: 1973.2780900632297)),
  'EPSG:2376': ProjectAndUnProjectResult(
      Point(x: -4526604.714369482, y: 8523391.62570668),
      Point(x: 38040.25722716442, y: 8289.769529110417)),
  'EPSG:2377': ProjectAndUnProjectResult(
      Point(x: -4599256.333168028, y: 8824123.667730357),
      Point(x: 216927.1895825022, y: 47354.20721248383)),
  'EPSG:2378': ProjectAndUnProjectResult(
      Point(x: -4642776.556531819, y: 9135549.477252303),
      Point(x: 2043698.8088216712, y: 448818.12876096036)),
  'EPSG:2379': ProjectAndUnProjectResult(
      Point(x: -4652699.493752384, y: 9455687.293354005),
      Point(x: 53527737.62873775, y: 11775410.771296037)),
  'EPSG:2380': ProjectAndUnProjectResult(
      Point(x: -4624011.265855193, y: 9781978.876150142),
      Point(x: 30362283770.78012, y: 6642887993.212868)),
  'EPSG:2381': ProjectAndUnProjectResult(
      Point(x: -4551098.372056025, y: 10111194.499075353), Point(x: 0, y: 90)),
  'EPSG:2382': ProjectAndUnProjectResult(
      Point(x: -4427692.63914202, y: 10439327.3499834), Point(x: 0, y: 90)),
  'EPSG:2383': ProjectAndUnProjectResult(
      Point(x: -4246812.631901407, y: 10761476.576965183), Point(x: 0, y: 90)),
  'EPSG:2384': ProjectAndUnProjectResult(
      Point(x: -4000701.4027259024, y: 11071718.188016934), Point(x: 0, y: 90)),
  'EPSG:2385': ProjectAndUnProjectResult(
      Point(x: -3680760.4585098424, y: 11362962.986914543), Point(x: 0, y: 90)),
  'EPSG:2386': ProjectAndUnProjectResult(
      Point(x: -3277479.822969972, y: 11626800.700874822), Point(x: 0, y: 90)),
  'EPSG:2387': ProjectAndUnProjectResult(
      Point(x: -2780364.0725100273, y: 11853329.428809231), Point(x: 0, y: 90)),
  'EPSG:2388': ProjectAndUnProjectResult(
      Point(x: -2177854.223753977, y: 12030969.51220035), Point(x: 0, y: 90)),
  'EPSG:2389': ProjectAndUnProjectResult(
      Point(x: -1457245.3508720614, y: 12146260.903856175), Point(x: 0, y: 90)),
  'EPSG:2390': ProjectAndUnProjectResult(
      Point(x: -604599.8108235879, y: 12183643.083021963), Point(x: 0, y: 90)),
  'EPSG:2391': ProjectAndUnProjectResult(
      Point(x: 1263024.506404655, y: 5200120.525379185),
      Point(x: 17.888058569509923, y: 46.89226408519625)),
  'EPSG:2392': ProjectAndUnProjectResult(
      Point(x: 2034440.5716829193, y: 5213578.652113191),
      Point(x: 17.888058572362624, y: 46.892264080684676)),
  'EPSG:2393': ProjectAndUnProjectResult(
      Point(x: 2805947.597461324, y: 5235870.493398355),
      Point(x: 17.888058727374972, y: 46.89226403979681)),
  'EPSG:4356': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2394': ProjectAndUnProjectResult(
      Point(x: 3577604.3454710813, y: 5267106.15784692),
      Point(x: 17.888060891114286, y: 46.892263910899054)),
  'EPSG:2395': ProjectAndUnProjectResult(
      Point(x: 6441663.530162457, y: 5564103.330087571),
      Point(x: 17.89339697213266, y: 46.892742762902465)),
  'EPSG:2396': ProjectAndUnProjectResult(
      Point(x: 6993498.98724838, y: 5754124.1644214),
      Point(x: 17.9309147229843, y: 46.897079180364614)),
  'EPSG:2397': ProjectAndUnProjectResult(
      Point(x: 4177294.151646561, y: 5233915.120827863),
      Point(x: 17.888058445012796, y: 46.892264030067174)),
  'EPSG:2398': ProjectAndUnProjectResult(
      Point(x: 4948799.201240658, y: 5212274.451999459),
      Point(x: 17.888058568215087, y: 46.89226406598465)),
  'EPSG:2399': ProjectAndUnProjectResult(
      Point(x: 5720217.08564427, y: 5199460.86379259),
      Point(x: 17.88805857010659, y: 46.89226406961487)),
  'EPSG:2400': ProjectAndUnProjectResult(
      Point(x: 1658711.959966589, y: 5196737.44236798),
      Point(x: 17.88805858630439, y: 46.8922640303641)),
  'EPSG:2401': ProjectAndUnProjectResult(
      Point(x: 21328573.28048693, y: 7001532.8404073985),
      Point(x: 66.44236062758634, y: 55.68084177388956)),
  'EPSG:2402': ProjectAndUnProjectResult(
      Point(x: 22149922.7599575, y: 7219126.768205585),
      Point(x: 138.30647601081196, y: 69.52623410327858)),
  'EPSG:2403': ProjectAndUnProjectResult(
      Point(x: 22982623.296146363, y: 7451365.034696903),
      Point(x: 45, y: double.nan)),
  'EPSG:2404': ProjectAndUnProjectResult(
      Point(x: 23828760.974070355, y: 7698233.245223834),
      Point(x: 45, y: double.nan)),
  'EPSG:2405': ProjectAndUnProjectResult(
      Point(x: 24690724.97687363, y: 7959527.594984778),
      Point(x: 45, y: double.nan)),
  'EPSG:2406': ProjectAndUnProjectResult(
      Point(x: 25571241.274286646, y: 8234808.865123581),
      Point(x: 45, y: double.nan)),
  'EPSG:2407': ProjectAndUnProjectResult(
      Point(x: 26473408.996789828, y: 8523349.850202367),
      Point(x: 45, y: double.nan)),
  'EPSG:2408': ProjectAndUnProjectResult(
      Point(x: 27400739.617356338, y: 8824075.613625502),
      Point(x: 45, y: double.nan)),
  'EPSG:2409': ProjectAndUnProjectResult(
      Point(x: 28357199.0626484, y: 9135495.940806963),
      Point(x: 45, y: double.nan)),
  'EPSG:2410': ProjectAndUnProjectResult(
      Point(x: 29347252.875541657, y: 9455629.333097685),
      Point(x: 45, y: double.nan)),
  'EPSG:2411': ProjectAndUnProjectResult(
      Point(x: 30375914.550852004, y: 9781917.858713986),
      Point(x: 45, y: double.nan)),
  'EPSG:2412': ProjectAndUnProjectResult(
      Point(x: 31448797.166139334, y: 10111132.15013253),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2413': ProjectAndUnProjectResult(
      Point(x: 32572168.42946268, y: 10439265.810641618),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2414': ProjectAndUnProjectResult(
      Point(x: 33753009.265961155, y: 10761418.465963187),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2415': ProjectAndUnProjectResult(
      Point(x: 34999076.06513523, y: 11071666.670084072),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2416': ProjectAndUnProjectResult(
      Point(x: 36318966.71070275, y: 11362921.847659718),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2417': ProjectAndUnProjectResult(
      Point(x: 37722190.51490404, y: 11626774.428577727),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2418': ProjectAndUnProjectResult(
      Point(x: 39219242.179130815, y: 11853323.303493233),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2419': ProjectAndUnProjectResult(
      Point(x: 40821679.90275308, y: 12030989.702372357),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2420': ProjectAndUnProjectResult(
      Point(x: 42542207.76201861, y: 12146314.571304422),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2421': ProjectAndUnProjectResult(
      Point(x: 44394762.48089945, y: 12183738.496068094),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2422': ProjectAndUnProjectResult(
      Point(x: -3671426.71951307, y: 7001532.8404073985),
      Point(x: 66.44236062758634, y: 55.68084177388956)),
  'EPSG:2423': ProjectAndUnProjectResult(
      Point(x: -3850077.240042502, y: 7219126.768205585),
      Point(x: 138.30647601081242, y: 69.52623410327867)),
  'EPSG:2424': ProjectAndUnProjectResult(
      Point(x: -4017376.703853639, y: 7451365.034696903),
      Point(x: 45, y: double.nan)),
  'EPSG:2425': ProjectAndUnProjectResult(
      Point(x: -4171239.0259296447, y: 7698233.245223834),
      Point(x: 45, y: double.nan)),
  'EPSG:2426': ProjectAndUnProjectResult(
      Point(x: -4309275.023126369, y: 7959527.594984778),
      Point(x: 45, y: double.nan)),
  'EPSG:2427': ProjectAndUnProjectResult(
      Point(x: -4428758.725713354, y: 8234808.865123581),
      Point(x: 45, y: double.nan)),
  'EPSG:2428': ProjectAndUnProjectResult(
      Point(x: -4526591.003210171, y: 8523349.850202367),
      Point(x: 45, y: double.nan)),
  'EPSG:2429': ProjectAndUnProjectResult(
      Point(x: -4599260.382643661, y: 8824075.613625502),
      Point(x: 45, y: double.nan)),
  'EPSG:2430': ProjectAndUnProjectResult(
      Point(x: -4642800.937351601, y: 9135495.940806963),
      Point(x: 45, y: double.nan)),
  'EPSG:2431': ProjectAndUnProjectResult(
      Point(x: -4652747.124458343, y: 9455629.333097685),
      Point(x: 45, y: double.nan)),
  'EPSG:2432': ProjectAndUnProjectResult(
      Point(x: -4624085.449147995, y: 9781917.858713986),
      Point(x: 45, y: double.nan)),
  'EPSG:2433': ProjectAndUnProjectResult(
      Point(x: -4551202.833860664, y: 10111132.15013253),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2434': ProjectAndUnProjectResult(
      Point(x: -4427831.570537322, y: 10439265.810641618),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2435': ProjectAndUnProjectResult(
      Point(x: -4246990.734038848, y: 10761418.465963187),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2436': ProjectAndUnProjectResult(
      Point(x: -4000923.934864768, y: 11071666.670084072),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2437': ProjectAndUnProjectResult(
      Point(x: -3681033.2892972548, y: 11362921.847659718),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2438': ProjectAndUnProjectResult(
      Point(x: -3277809.485095963, y: 11626774.428577727),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2439': ProjectAndUnProjectResult(
      Point(x: -2780757.820869183, y: 11853323.303493233),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2440': ProjectAndUnProjectResult(
      Point(x: -2178320.097246922, y: 12030989.702372357),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2441': ProjectAndUnProjectResult(
      Point(x: -1457792.2379813858, y: 12146314.571304422),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2442': ProjectAndUnProjectResult(
      Point(x: -605237.519100545, y: 12183738.496068094),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:2443': ProjectAndUnProjectResult(
      Point(x: -2566056.9116173303, y: 8401313.58870162), Point(x: 0, y: 90)),
  'EPSG:2444': ProjectAndUnProjectResult(
      Point(x: -2211182.2634812854, y: 8462072.812029004), Point(x: 0, y: 90)),
  'EPSG:2445': ProjectAndUnProjectResult(
      Point(x: -1913282.6153144585, y: 8164170.9970185), Point(x: 0, y: 90)),
  'EPSG:2446': ProjectAndUnProjectResult(
      Point(x: -1548193.3456383753, y: 8522145.552706772), Point(x: 0, y: 90)),
  'EPSG:2447': ProjectAndUnProjectResult(
      Point(x: -1306115.9982166318, y: 8196578.576068864), Point(x: 0, y: 90)),
  'EPSG:2448': ProjectAndUnProjectResult(
      Point(x: -788366.1033867978, y: 8189401.718133621), Point(x: 0, y: 90)),
  'EPSG:2449': ProjectAndUnProjectResult(
      Point(x: -398086.9536182322, y: 8165821.33190225), Point(x: 0, y: 90)),
  'EPSG:2450': ProjectAndUnProjectResult(
      Point(x: 77463.83204888566, y: 8118405.0916535165), Point(x: 0, y: 90)),
  'EPSG:2451': ProjectAndUnProjectResult(
      Point(x: 585959.9308690846, y: 8047327.498372015), Point(x: 0, y: 90)),
  'EPSG:2452': ProjectAndUnProjectResult(
      Point(x: 989901.510910523, y: 7533339.024756886), Point(x: 0, y: 90)),
  'EPSG:2453': ProjectAndUnProjectResult(
      Point(x: 751869.6886925661, y: 7131756.363145234), Point(x: 0, y: 90)),
  'EPSG:2454': ProjectAndUnProjectResult(
      Point(x: 1596744.7812366635, y: 6963379.403117015), Point(x: 0, y: 90)),
  'EPSG:2455': ProjectAndUnProjectResult(
      Point(x: 2526128.1328379745, y: 6728261.832241865), Point(x: 0, y: 90)),
  'EPSG:2456': ProjectAndUnProjectResult(
      Point(x: 1486633.193392855, y: 8984705.502253164), Point(x: 0, y: 90)),
  'EPSG:2457': ProjectAndUnProjectResult(
      Point(x: -2992748.9178998745, y: 9071307.830204587), Point(x: 0, y: 90)),
  'EPSG:2458': ProjectAndUnProjectResult(
      Point(x: -3622384.886812397, y: 8829268.069555495), Point(x: 0, y: 90)),
  'EPSG:2459': ProjectAndUnProjectResult(
      Point(x: -2211182.2634812854, y: 9237908.69123874), Point(x: 0, y: 90)),
  'EPSG:2460': ProjectAndUnProjectResult(
      Point(x: -788366.1033867978, y: 9962400.81668543), Point(x: 0, y: 90)),
  'EPSG:2461': ProjectAndUnProjectResult(
      Point(x: 8475126.70697138, y: 6334051.65944307),
      Point(x: -131825587.42186226, y: 47833306.95865751)),
  'EPSG:2462': ProjectAndUnProjectResult(
      Point(x: 4262979.618454169, y: 5200109.974276837),
      Point(x: 17.888058561832175, y: 46.89226406409104)),
  'EPSG:2463': ProjectAndUnProjectResult(
      Point(x: 262977.40292099846, y: 5200101.235815557),
      Point(x: 17.88805857027049, y: 46.89226406903771)),
  'EPSG:2464': ProjectAndUnProjectResult(
      Point(x: -194086.63716134313, y: 5235854.283937308),
      Point(x: 17.888058728388476, y: 46.89226402384307)),
  'EPSG:2465': ProjectAndUnProjectResult(
      Point(x: -650534.705398909, y: 5307424.743197788),
      Point(x: 17.888077164108275, y: 46.89226406201648)),
  'EPSG:2466': ProjectAndUnProjectResult(
      Point(x: -1105654.7796934056, y: 5416207.687562138),
      Point(x: 17.88850885829136, y: 46.89229074846724)),
  'EPSG:2467': ProjectAndUnProjectResult(
      Point(x: -1558251.691909319, y: 5564265.926028976),
      Point(x: 17.89339665661175, y: 46.892742750704436)),
  'EPSG:2468': ProjectAndUnProjectResult(
      Point(x: -2006400.0574959628, y: 5754282.564756225),
      Point(x: 17.930912766487186, y: 46.89707896829051)),
  'EPSG:2469': ProjectAndUnProjectResult(
      Point(x: -2447142.3192905476, y: 5989465.549310994),
      Point(x: 18.163085249950498, y: 46.92853675095355)),
  'EPSG:2470': ProjectAndUnProjectResult(
      Point(x: -2876116.3057343345, y: 6273376.642920781),
      Point(x: 19.453977225641804, y: 47.12654815721369)),
  'EPSG:2471': ProjectAndUnProjectResult(
      Point(x: -3287096.703733949, y: 6609650.442058996),
      Point(x: 26.45354646467008, y: 48.31387174213733)),
  'EPSG:2472': ProjectAndUnProjectResult(
      Point(x: -3671434.8463999643, y: 7001562.176153691),
      Point(x: 66.44656806390067, y: 55.68157108625792)),
  'EPSG:2473': ProjectAndUnProjectResult(
      Point(x: -4017381.2158948015, y: 7451396.183664046),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2474': ProjectAndUnProjectResult(
      Point(x: -4309275.061622056, y: 7959560.102225089),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2475': ProjectAndUnProjectResult(
      Point(x: -4526585.5339893205, y: 8523382.956016758),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2476': ProjectAndUnProjectResult(
      Point(x: -4642788.733976571, y: 9135528.468969345),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2477': ProjectAndUnProjectResult(
      Point(x: -4624065.078742239, y: 9781948.077873092),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2478': ProjectAndUnProjectResult(
      Point(x: -4427801.383499, y: 10439291.264915409),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2479': ProjectAndUnProjectResult(
      Point(x: -4000882.0598914055, y: 11071683.97462519),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2480': ProjectAndUnProjectResult(
      Point(x: -3277753.8311074045, y: 11626779.025659218),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2481': ProjectAndUnProjectResult(
      Point(x: -2178248.363955864, y: 12030975.573321657),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2482': ProjectAndUnProjectResult(
      Point(x: -605147.2181421507, y: 12183697.82416335),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2483': ProjectAndUnProjectResult(
      Point(x: 1558526.4870261499, y: 11950616.349463312),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2484': ProjectAndUnProjectResult(
      Point(x: 4452505.288271218, y: 11155688.489850847),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2485': ProjectAndUnProjectResult(
      Point(x: 8242579.076082804, y: 9571887.488782195),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2486': ProjectAndUnProjectResult(
      Point(x: 13124216.874329505, y: 6910483.138041684),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2487': ProjectAndUnProjectResult(
      Point(x: 19326524.301511526, y: 2808729.8638930563),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2488': ProjectAndUnProjectResult(
      Point(x: 27116552.31342323, y: -3184188.6720379107),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2489': ProjectAndUnProjectResult(
      Point(x: 36803972.82699252, y: -11623116.237611713),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2490': ProjectAndUnProjectResult(
      Point(x: 48746136.82506581, y: -23184946.595761795),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2491': ProjectAndUnProjectResult(
      Point(x: 63353530.541906394, y: -38688883.46037097),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2492': ProjectAndUnProjectResult(
      Point(x: 1177294.7279087103, y: 5233919.735428686),
      Point(x: 17.88805844509745, y: 46.89226402884926)),
  'EPSG:2493': ProjectAndUnProjectResult(
      Point(x: 720218.0099101962, y: 5199465.397656718),
      Point(x: 17.888058570193113, y: 46.892264068397665)),
  'EPSG:2494': ProjectAndUnProjectResult(
      Point(x: 262975.2033760503, y: 5200108.455837973),
      Point(x: 17.88805857014421, y: 46.89226406836862)),
  'EPSG:2495': ProjectAndUnProjectResult(
      Point(x: -194088.28412423097, y: 5235861.690128276),
      Point(x: 17.88805872826832, y: 46.89226402317326)),
  'EPSG:2496': ProjectAndUnProjectResult(
      Point(x: -650535.7804342315, y: 5307432.332827369),
      Point(x: 17.88807716440437, y: 46.89226406138663)),
  'EPSG:2497': ProjectAndUnProjectResult(
      Point(x: -1105655.2508189164, y: 5416215.45576819),
      Point(x: 17.888508865759512, y: 46.89229074905092)),
  'EPSG:2498': ProjectAndUnProjectResult(
      Point(x: -1558251.513767628, y: 5564273.862147296),
      Point(x: 17.893396730554738, y: 46.89274276585422)),
  'EPSG:2499': ProjectAndUnProjectResult(
      Point(x: -2006399.1709308936, y: 5754290.647735119),
      Point(x: 17.930913287470418, y: 46.89707909919423)),
  'EPSG:2500': ProjectAndUnProjectResult(
      Point(x: -2447140.6515301783, y: 5989473.74186563),
      Point(x: 18.163088321316437, y: 46.92853762419354)),
  'EPSG:2501': ProjectAndUnProjectResult(
      Point(x: -2876113.771579705, y: 6273384.884065807),
      Point(x: 19.45399395295535, y: 47.12655335465394)),
  'EPSG:2502': ProjectAndUnProjectResult(
      Point(x: -3287093.208259472, y: 6609658.637646196),
      Point(x: 26.45363795646325, y: 48.31390228746322)),
  'EPSG:2503': ProjectAndUnProjectResult(
      Point(x: -3671430.2897785814, y: 7001570.187034681),
      Point(x: 66.4471378153942, y: 55.6817679617501)),
  'EPSG:2504': ProjectAndUnProjectResult(
      Point(x: -4017375.5010680165, y: 7451403.811096456),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2505': ProjectAndUnProjectResult(
      Point(x: -4309268.105641998, y: 7959567.070144047),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2506': ProjectAndUnProjectResult(
      Point(x: -4526577.283967023, y: 8523388.889802082),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2507': ProjectAndUnProjectResult(
      Point(x: -4642779.188677735, y: 9135532.870352365),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2508': ProjectAndUnProjectResult(
      Point(x: -4624054.316978742, y: 9781950.295645684),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2509': ProjectAndUnProjectResult(
      Point(x: -4427789.600571497, y: 10439290.461127605),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2510': ProjectAndUnProjectResult(
      Point(x: -4000869.6134453984, y: 11071679.08598643),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2511': ProjectAndUnProjectResult(
      Point(x: -3277741.2978721927, y: 11626768.71989223),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2512': ProjectAndUnProjectResult(
      Point(x: -2178236.608942848, y: 12030958.200256905),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2513': ProjectAndUnProjectResult(
      Point(x: -605137.4779859737, y: 12183671.361405866),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2514': ProjectAndUnProjectResult(
      Point(x: 1558532.5047930002, y: 11950578.342513002),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2515': ProjectAndUnProjectResult(
      Point(x: 4452505.288112892, y: 11155635.986611271),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2516': ProjectAndUnProjectResult(
      Point(x: 8242570.037518824, y: 9571816.968452249),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2517': ProjectAndUnProjectResult(
      Point(x: 13124194.893046256, y: 6910390.434448714),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2518': ProjectAndUnProjectResult(
      Point(x: 19326484.40630764, y: 2808610.083395421),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2519': ProjectAndUnProjectResult(
      Point(x: 27116488.25666316, y: -3184341.2378764953),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2520': ProjectAndUnProjectResult(
      Point(x: 36803876.84613541, y: -11623308.20429408),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2521': ProjectAndUnProjectResult(
      Point(x: 48745999.37273005, y: -23185185.58270928),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2522': ProjectAndUnProjectResult(
      Point(x: 63353339.98182248, y: -38689178.19189904),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2523': ProjectAndUnProjectResult(
      Point(x: 7262975.20337605, y: 5200108.455837973),
      Point(x: 17.88805857014421, y: 46.89226406836862)),
  'EPSG:2524': ProjectAndUnProjectResult(
      Point(x: 8034397.971578807, y: 5213568.339213907),
      Point(x: 17.888058573013023, y: 46.89226406387413)),
  'EPSG:2525': ProjectAndUnProjectResult(
      Point(x: 8805911.715875769, y: 5235861.690128276),
      Point(x: 17.88805872826832, y: 46.89226402317326)),
  'EPSG:2526': ProjectAndUnProjectResult(
      Point(x: 9577575.20169213, y: 5267098.6213854635),
      Point(x: 17.888060893877114, y: 46.8922638952511)),
  'EPSG:2527': ProjectAndUnProjectResult(
      Point(x: 10349464.219565768, y: 5307432.332827369),
      Point(x: 17.888077164404354, y: 46.89226406138663)),
  'EPSG:2528': ProjectAndUnProjectResult(
      Point(x: 11121677.771482574, y: 5357058.679738873),
      Point(x: 17.888161903085418, y: 46.89226782416723)),
  'EPSG:2529': ProjectAndUnProjectResult(
      Point(x: 11894344.749181084, y: 5416215.45576819),
      Point(x: 17.88850886575952, y: 46.892290749050915)),
  'EPSG:2530': ProjectAndUnProjectResult(
      Point(x: 12667631.226298774, y: 5485181.2688879585),
      Point(x: 17.8897103496953, y: 46.892389637173814)),
  'EPSG:2531': ProjectAndUnProjectResult(
      Point(x: 13441748.486232372, y: 5564273.862147296),
      Point(x: 17.893396730554738, y: 46.89274276585422)),
  'EPSG:2532': ProjectAndUnProjectResult(
      Point(x: 14216961.907584509, y: 5653847.704189581),
      Point(x: 17.903741895646384, y: 46.89385695428033)),
  'EPSG:3013': ProjectAndUnProjectResult(
      Point(x: 312936.3103335998, y: 5197489.998984287),
      Point(x: 17.8880585602863, y: 46.89226406700016)),
  'EPSG:2533': ProjectAndUnProjectResult(
      Point(x: 14993600.829069106, y: 5754290.647735119),
      Point(x: 17.930913287470414, y: 46.89707909919423)),
  'EPSG:2534': ProjectAndUnProjectResult(
      Point(x: 15772069.515747806, y: 5866019.427452342),
      Point(x: 17.998882442621085, y: 46.90582889002483)),
  'EPSG:2535': ProjectAndUnProjectResult(
      Point(x: 16552859.348469822, y: 5989473.74186563),
      Point(x: 18.163088321316437, y: 46.92853762419354)),
  'EPSG:2536': ProjectAndUnProjectResult(
      Point(x: 17336562.358387552, y: 6125108.637172303),
      Point(x: 18.550708939450903, y: 46.9856578147775)),
  'EPSG:2537': ProjectAndUnProjectResult(
      Point(x: 18123886.228420295, y: 6273384.884065807),
      Point(x: 19.45399395295535, y: 47.12655335465394)),
  'EPSG:2538': ProjectAndUnProjectResult(
      Point(x: 18915670.883538455, y: 6434757.011886531),
      Point(x: 21.551887363787515, y: 47.47098438727558)),
  'EPSG:2539': ProjectAndUnProjectResult(
      Point(x: 19712906.79174053, y: 6609658.637646196),
      Point(x: 26.453637956463236, y: 48.31390228746322)),
  'EPSG:2540': ProjectAndUnProjectResult(
      Point(x: 20516755.09759528, y: 6798484.700696194),
      Point(x: 38.08853620835505, y: 50.40030765814774)),
  'EPSG:2541': ProjectAndUnProjectResult(
      Point(x: 21328569.710221417, y: 7001570.187034681),
      Point(x: 66.44713781539431, y: 55.68176796175012)),
  'EPSG:3014': ProjectAndUnProjectResult(
      Point(x: 198625.57705212594, y: 5195467.700063693),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:2542': ProjectAndUnProjectResult(
      Point(x: 22149921.467577163, y: 7219164.900471759),
      Point(x: 138.3187917769007, y: 69.52887325997268)),
  'EPSG:2543': ProjectAndUnProjectResult(
      Point(x: 22982624.49893198, y: 7451403.811096456),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2544': ProjectAndUnProjectResult(
      Point(x: 23828764.907392956, y: 7698272.484713709),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2545': ProjectAndUnProjectResult(
      Point(x: 24690731.894358, y: 7959567.070144047),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2546': ProjectAndUnProjectResult(
      Point(x: 25571251.447768413, y: 8234848.294503033),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2547': ProjectAndUnProjectResult(
      Point(x: 26473422.71603298, y: 8523388.889802082),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2548': ProjectAndUnProjectResult(
      Point(x: 27400757.18949611, y: 8824113.847436663),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2549': ProjectAndUnProjectResult(
      Point(x: 28357220.811322264, y: 9135532.870352365),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2550': ProjectAndUnProjectResult(
      Point(x: -4730465.448497609, y: 20936573.03259654),
      Point(x: 17.88805982180847, y: 46.89226431815996)),
  'EPSG:3015': ProjectAndUnProjectResult(
      Point(x: 84312.6848457014, y: 5195630.7617201),
      Point(x: 17.88805856028147, y: 46.89226406700875)),
  'EPSG:2551': ProjectAndUnProjectResult(
      Point(x: 29347279.13966903, y: 9455664.3659038),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2552': ProjectAndUnProjectResult(
      Point(x: 30375945.68302126, y: 9781950.295645684),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2553': ProjectAndUnProjectResult(
      Point(x: 31448833.53055856, y: 10111161.171520011),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2554': ProjectAndUnProjectResult(
      Point(x: 32572210.3994285, y: 10439290.461127605),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2555': ProjectAndUnProjectResult(
      Point(x: 33753057.22079792, y: 10761437.637996785),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2556': ProjectAndUnProjectResult(
      Point(x: 34999130.3865546, y: 11071679.08598643),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2557': ProjectAndUnProjectResult(
      Point(x: 36319027.77853179, y: 11362926.04018508),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2558': ProjectAndUnProjectResult(
      Point(x: 37722258.70212781, y: 11626768.71989223),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2559': ProjectAndUnProjectResult(
      Point(x: 39219317.84619309, y: 11853305.782492371),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:3016': ProjectAndUnProjectResult(
      Point(x: -29997.2884961167, y: 5197979.386805543),
      Point(x: 17.88805856027366, y: 46.892264066993114)),
  'EPSG:2560': ProjectAndUnProjectResult(
      Point(x: 40821763.39105715, y: 12030958.200256905),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2561': ProjectAndUnProjectResult(
      Point(x: 42542299.38656767, y: 12146266.635333346),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2562': ProjectAndUnProjectResult(
      Point(x: 44394862.52201403, y: 12183671.361405866),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2563': ProjectAndUnProjectResult(
      Point(x: 46394713.40980792, y: 12125273.753735503),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2564': ProjectAndUnProjectResult(
      Point(x: 48558532.504793, y: 11950578.342513002),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2565': ProjectAndUnProjectResult(
      Point(x: 50904520.78105618, y: 11636214.397681559),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2566': ProjectAndUnProjectResult(
      Point(x: 53452505.28811289, y: 11155635.986611271),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2567': ProjectAndUnProjectResult(
      Point(x: 56224049.70833858, y: 10478799.419231562),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2568': ProjectAndUnProjectResult(
      Point(x: 59242570.03751882, y: 9571816.968452249),
      Point(x: double.nan, y: double.nan)),
  'EPSG:3017': ProjectAndUnProjectResult(
      Point(x: -144299.16811836342, y: 5202516.496162767),
      Point(x: 17.88805856022543, y: 46.892264066710894)),
  'EPSG:2569': ProjectAndUnProjectResult(
      Point(x: 62533455.5103905, y: 8396585.726928417),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2570': ProjectAndUnProjectResult(
      Point(x: 66124194.89304626, y: 6910390.434448714),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2571': ProjectAndUnProjectResult(
      Point(x: 70044508.26407446, y: 5065479.08345128),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2572': ProjectAndUnProjectResult(
      Point(x: 74326484.40630764, y: 2808610.083395421),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2573': ProjectAndUnProjectResult(
      Point(x: 79004723.9310509, y: 80569.73794255334),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2574': ProjectAndUnProjectResult(
      Point(x: 84116488.25666316, y: -3184341.2378764953),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2575': ProjectAndUnProjectResult(
      Point(x: 89701854.56336358, y: -7058853.460105787),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2576': ProjectAndUnProjectResult(
      Point(x: 95803876.84613541, y: -11623308.20429408),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2577': ProjectAndUnProjectResult(
      Point(x: 101968753.1875995, y: -16966271.673058722),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:3018': ProjectAndUnProjectResult(
      Point(x: -258587.512644806, y: 5209247.727562542),
      Point(x: 17.88805856085824, y: 46.892264064897844)),
  'EPSG:2578': ProjectAndUnProjectResult(
      Point(x: 109745999.37273005, y: -23185185.58270928),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2579': ProjectAndUnProjectResult(
      Point(x: 117688628.96728492, y: -30387055.475630186),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2580': ProjectAndUnProjectResult(
      Point(x: 126353339.98182249, y: -38689178.19189904),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2581': ProjectAndUnProjectResult(
      Point(x: 135800708.24317816, y: -48219909.96039137),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2582': ProjectAndUnProjectResult(
      Point(x: 262975.2033760503, y: 5200108.455837973),
      Point(x: 17.88805857014421, y: 46.89226406836862)),
  'EPSG:2583': ProjectAndUnProjectResult(
      Point(x: 34397.97157880687, y: 5213568.339213907),
      Point(x: 17.888058573013026, y: 46.89226406387413)),
  'EPSG:2584': ProjectAndUnProjectResult(
      Point(x: -194088.28412423097, y: 5235861.690128276),
      Point(x: 17.88805872826832, y: 46.89226402317326)),
  'EPSG:2585': ProjectAndUnProjectResult(
      Point(x: -422424.7983078696, y: 5267098.6213854635),
      Point(x: 17.888060893877114, y: 46.8922638952511)),
  'EPSG:2586': ProjectAndUnProjectResult(
      Point(x: -650535.7804342315, y: 5307432.332827369),
      Point(x: 17.88807716440437, y: 46.89226406138663)),
  'EPSG:3029': ProjectAndUnProjectResult(
      Point(x: 1315584.0679567705, y: 5197585.882434869),
      Point(x: 17.888058560272714, y: 46.89226406699073)),
  'EPSG:2587': ProjectAndUnProjectResult(
      Point(x: -878322.2285174257, y: 5357058.679738873),
      Point(x: 17.888161903085425, y: 46.89226782416723)),
  'EPSG:2588': ProjectAndUnProjectResult(
      Point(x: -1105655.2508189164, y: 5416215.45576819),
      Point(x: 17.888508865759512, y: 46.89229074905092)),
  'EPSG:2589': ProjectAndUnProjectResult(
      Point(x: -1332368.7737012256, y: 5485181.2688879585),
      Point(x: 17.889710349695306, y: 46.892389637173814)),
  'EPSG:2590': ProjectAndUnProjectResult(
      Point(x: -1558251.513767628, y: 5564273.862147296),
      Point(x: 17.893396730554738, y: 46.89274276585422)),
  'EPSG:2591': ProjectAndUnProjectResult(
      Point(x: -1783038.0924154916, y: 5653847.704189581),
      Point(x: 17.903741895646384, y: 46.89385695428033)),
  'EPSG:2592': ProjectAndUnProjectResult(
      Point(x: -2006399.1709308936, y: 5754290.647735119),
      Point(x: 17.930913287470418, y: 46.89707909919423)),
  'EPSG:2593': ProjectAndUnProjectResult(
      Point(x: -2227930.4842521935, y: 5866019.427452342),
      Point(x: 17.9988824426211, y: 46.90582889002483)),
  'EPSG:2594': ProjectAndUnProjectResult(
      Point(x: -2447140.6515301783, y: 5989473.74186563),
      Point(x: 18.163088321316437, y: 46.92853762419354)),
  'EPSG:2595': ProjectAndUnProjectResult(
      Point(x: -2663437.6416124497, y: 6125108.637172303),
      Point(x: 18.550708939450896, y: 46.98565781477748)),
  'EPSG:3030': ProjectAndUnProjectResult(
      Point(x: 1144157.48926002, y: 5205340.722853656),
      Point(x: 17.888058560309897, y: 46.89226406608421)),
  'EPSG:2596': ProjectAndUnProjectResult(
      Point(x: -2876113.771579705, y: 6273384.884065807),
      Point(x: 19.45399395295535, y: 47.12655335465394)),
  'EPSG:2597': ProjectAndUnProjectResult(
      Point(x: -3084329.1164615457, y: 6434757.011886531),
      Point(x: 21.55188736378752, y: 47.47098438727558)),
  'EPSG:2598': ProjectAndUnProjectResult(
      Point(x: -3287093.208259472, y: 6609658.637646196),
      Point(x: 26.45363795646325, y: 48.31390228746322)),
  'EPSG:2599': ProjectAndUnProjectResult(
      Point(x: -3483244.9024047223, y: 6798484.700696194),
      Point(x: 38.088536208355066, y: 50.40030765814774)),
  'EPSG:2600': ProjectAndUnProjectResult(
      Point(x: 34368.35104356846, y: 5212395.955506003),
      Point(x: 17.888058563129828, y: 46.892264062424815)),
  'EPSG:2601': ProjectAndUnProjectResult(
      Point(x: -3671430.2897785814, y: 7001570.187034681),
      Point(x: 66.4471378153942, y: 55.6817679617501)),
  'EPSG:2602': ProjectAndUnProjectResult(
      Point(x: -3850078.532422838, y: 7219164.900471759),
      Point(x: 138.31879177690084, y: 69.5288732599727)),
  'EPSG:2603': ProjectAndUnProjectResult(
      Point(x: -4017375.5010680165, y: 7451403.811096456),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2604': ProjectAndUnProjectResult(
      Point(x: -4171235.0926070437, y: 7698272.484713709),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2605': ProjectAndUnProjectResult(
      Point(x: -4309268.105641998, y: 7959567.070144047),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2606': ProjectAndUnProjectResult(
      Point(x: -4428748.552231589, y: 8234848.294503033),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2607': ProjectAndUnProjectResult(
      Point(x: -4526577.283967023, y: 8523388.889802082),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2608': ProjectAndUnProjectResult(
      Point(x: -4599242.81050389, y: 8824113.847436663),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2609': ProjectAndUnProjectResult(
      Point(x: -4642779.188677735, y: 9135532.870352365),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2610': ProjectAndUnProjectResult(
      Point(x: -4652720.860330971, y: 9455664.3659038),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2611': ProjectAndUnProjectResult(
      Point(x: -4624054.316978742, y: 9781950.295645684),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2612': ProjectAndUnProjectResult(
      Point(x: -4551166.469441441, y: 10111161.171520011),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2613': ProjectAndUnProjectResult(
      Point(x: -4427789.600571497, y: 10439290.461127605),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2614': ProjectAndUnProjectResult(
      Point(x: -4246942.779202082, y: 10761437.637996785),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:3031': ProjectAndUnProjectResult(
      Point(x: 9570214.988964928, y: 29651083.52658238),
      Point(x: 17.888058560281515, y: 46.89226406700872)),
  'EPSG:2615': ProjectAndUnProjectResult(
      Point(x: -4000869.6134453984, y: 11071679.08598643),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2616': ProjectAndUnProjectResult(
      Point(x: -3680972.2214682084, y: 11362926.04018508),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2617': ProjectAndUnProjectResult(
      Point(x: -3277741.2978721927, y: 11626768.71989223),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2618': ProjectAndUnProjectResult(
      Point(x: -2780682.1538069127, y: 11853305.782492371),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2619': ProjectAndUnProjectResult(
      Point(x: -2178236.608942848, y: 12030958.200256905),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2620': ProjectAndUnProjectResult(
      Point(x: -1457700.6134323366, y: 12146266.635333346),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2621': ProjectAndUnProjectResult(
      Point(x: -605137.4779859737, y: 12183671.361405866),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2622': ProjectAndUnProjectResult(
      Point(x: 394713.4098079185, y: 12125273.753735503),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2623': ProjectAndUnProjectResult(
      Point(x: 1558532.5047930002, y: 11950578.342513002),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:3042': ProjectAndUnProjectResult(
      Point(x: 2088186.0339291478, y: 5409193.447385448),
      Point(x: 17.888058560281504, y: 46.89226406700878)),
  'EPSG:2624': ProjectAndUnProjectResult(
      Point(x: 2904520.781056181, y: 11636214.397681559),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2625': ProjectAndUnProjectResult(
      Point(x: 4452505.288112892, y: 11155635.986611271),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2626': ProjectAndUnProjectResult(
      Point(x: 6224049.708338583, y: 10478799.419231562),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:2627': ProjectAndUnProjectResult(
      Point(x: 8242570.037518824, y: 9571816.968452249),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2628': ProjectAndUnProjectResult(
      Point(x: 10533455.5103905, y: 8396585.726928417),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2629': ProjectAndUnProjectResult(
      Point(x: 13124194.893046256, y: 6910390.434448714),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2630': ProjectAndUnProjectResult(
      Point(x: 16044508.264074454, y: 5065479.08345128),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2631': ProjectAndUnProjectResult(
      Point(x: 19326484.40630764, y: 2808610.083395421),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2632': ProjectAndUnProjectResult(
      Point(x: 23004723.931050893, y: 80569.73794255334),
      Point(x: double.nan, y: double.nan)),
  'EPSG:3043': ProjectAndUnProjectResult(
      Point(x: 1633185.5802525284, y: 5301866.074714836),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:2633': ProjectAndUnProjectResult(
      Point(x: 27116488.25666316, y: -3184341.2378764953),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2634': ProjectAndUnProjectResult(
      Point(x: 31701854.563363586, y: -7058853.460105787),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2635': ProjectAndUnProjectResult(
      Point(x: 36803876.84613541, y: -11623308.20429408),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2636': ProjectAndUnProjectResult(
      Point(x: 42468753.187599495, y: -16966271.673058722),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2637': ProjectAndUnProjectResult(
      Point(x: 48745999.37273005, y: -23185185.58270928),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2638': ProjectAndUnProjectResult(
      Point(x: 55688628.96728491, y: -30387055.475630186),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2639': ProjectAndUnProjectResult(
      Point(x: 63353339.98182248, y: -38689178.19189904),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2640': ProjectAndUnProjectResult(
      Point(x: 71800708.24317816, y: -48219909.96039137),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:2641': ProjectAndUnProjectResult(
      Point(x: 7262977.402920999, y: 5200101.235815557),
      Point(x: 17.888058570270495, y: 46.89226406903771)),
  'EPSG:3044': ProjectAndUnProjectResult(
      Point(x: 1176891.2861569354, y: 5231671.8338276325),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:2642': ProjectAndUnProjectResult(
      Point(x: 8034399.896494305, y: 5213561.025774186),
      Point(x: 17.8880585731391, y: 46.892264064543355)),
  'EPSG:2643': ProjectAndUnProjectResult(
      Point(x: 8805913.362838658, y: 5235854.283937308),
      Point(x: 17.888058728388486, y: 46.89226402384307)),
  'EPSG:2644': ProjectAndUnProjectResult(
      Point(x: 9577576.565879751, y: 5267091.123078233),
      Point(x: 17.88806089393773, y: 46.89226389591836)),
  'EPSG:2645': ProjectAndUnProjectResult(
      Point(x: 10349465.29460109, y: 5307424.743197788),
      Point(x: 17.888077164108264, y: 46.89226406201648)),
  'EPSG:2646': ProjectAndUnProjectResult(
      Point(x: 11121678.549381936, y: 5357050.999945765),
      Point(x: 17.888161901223476, y: 46.89226782456999)),
  'EPSG:2647': ProjectAndUnProjectResult(
      Point(x: 11894345.220306594, y: 5416207.687562138),
      Point(x: 17.888508858291356, y: 46.89229074846724)),
  'EPSG:2648': ProjectAndUnProjectResult(
      Point(x: 12667631.379318276, y: 5485173.414864039),
      Point(x: 17.88971032479296, y: 46.892389633066195)),
  'EPSG:2649': ProjectAndUnProjectResult(
      Point(x: 13441748.308090681, y: 5564265.926028976),
      Point(x: 17.89339665661175, y: 46.89274275070445)),
  'EPSG:2650': ProjectAndUnProjectResult(
      Point(x: 14216961.383490501, y: 5653839.691149153),
      Point(x: 17.903741693390224, y: 46.893856907596486)),
  'EPSG:2736': ProjectAndUnProjectResult(
      Point(x: -650095.4372146509, y: 15305278.654938322),
      Point(x: 17.888058517270693, y: 46.892263934918425)),
  'EPSG:2651': ProjectAndUnProjectResult(
      Point(x: 14993599.942504037, y: 5754282.564756225),
      Point(x: 17.930912766487186, y: 46.89707896829051)),
  'EPSG:2652': ProjectAndUnProjectResult(
      Point(x: 15772068.24850111, y: 5866011.283740241),
      Point(x: 17.998881158089443, y: 46.90582854474073)),
  'EPSG:2653': ProjectAndUnProjectResult(
      Point(x: 16552857.680709451, y: 5989465.549310994),
      Point(x: 18.163085249950498, y: 46.92853675095355)),
  'EPSG:2654': ProjectAndUnProjectResult(
      Point(x: 17336560.26877277, y: 6125100.410874365),
      Point(x: 18.550701738008826, y: 46.98565566739176)),
  'EPSG:2655': ProjectAndUnProjectResult(
      Point(x: 18123883.694265664, y: 6273376.642920781),
      Point(x: 19.45397722564179, y: 47.12654815721367)),
  'EPSG:2656': ProjectAndUnProjectResult(
      Point(x: 18915667.88103859, y: 6434748.779247259),
      Point(x: 21.551848481426067, y: 47.47097185323702)),
  'EPSG:2657': ProjectAndUnProjectResult(
      Point(x: 19712903.29626605, y: 6609650.442058996),
      Point(x: 26.453546464670094, y: 48.31387174213733)),
  'EPSG:2658': ProjectAndUnProjectResult(
      Point(x: 20516751.084071193, y: 6798476.576720871),
      Point(x: 38.08831473467017, y: 50.40023120211537)),
  'EPSG:2659': ProjectAndUnProjectResult(
      Point(x: 21328565.153600037, y: 7001562.176153691),
      Point(x: 66.44656806390056, y: 55.6815710862579)),
  'EPSG:3045': ProjectAndUnProjectResult(
      Point(x: 720001.2298382937, y: 5197241.609971515),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:2660': ProjectAndUnProjectResult(
      Point(x: 22149916.343418464, y: 7219157.052094408),
      Point(x: 138.3170738035686, y: 69.52842660642159)),
  'EPSG:2661': ProjectAndUnProjectResult(
      Point(x: 22982618.784105197, y: 7451396.183664046),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2662': ProjectAndUnProjectResult(
      Point(x: 23828758.58091396, y: 7698265.146911397),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2663': ProjectAndUnProjectResult(
      Point(x: 24690724.938377943, y: 7959560.102225089),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2664': ProjectAndUnProjectResult(
      Point(x: 25571243.848729856, y: 8234841.789731057),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2665': ProjectAndUnProjectResult(
      Point(x: 26473414.46601068, y: 8523382.956016758),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2666': ProjectAndUnProjectResult(
      Point(x: 27400748.28774033, y: 8824108.608748099),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2667': ProjectAndUnProjectResult(
      Point(x: 28357211.266023427, y: 9135528.468969345),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2668': ProjectAndUnProjectResult(
      Point(x: 29347268.969963353, y: 9455660.96410075),
      Point(x: double.nan, y: double.nan)),
  'EPSG:3046': ProjectAndUnProjectResult(
      Point(x: 262945.28796354064, y: 5197894.102609971),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:2669': ProjectAndUnProjectResult(
      Point(x: 30375934.92125776, y: 9781948.077873092),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2670': ProjectAndUnProjectResult(
      Point(x: 31448822.224848773, y: 10111160.346662756),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2671': ProjectAndUnProjectResult(
      Point(x: 32572198.616501, y: 10439291.264915409),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2672': ProjectAndUnProjectResult(
      Point(x: 33753045.04918061, y: 10761440.335570734),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2673': ProjectAndUnProjectResult(
      Point(x: 34999117.9401086, y: 11071683.97462519),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2674': ProjectAndUnProjectResult(
      Point(x: 36319015.20036148, y: 11362933.452194152),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2675': ProjectAndUnProjectResult(
      Point(x: 37722246.16889259, y: 11626779.025659218),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2676': ProjectAndUnProjectResult(
      Point(x: 39219305.57284712, y: 11853319.39371094),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2677': ProjectAndUnProjectResult(
      Point(x: 40821751.63604414, y: 12030975.573321657),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:3047': ProjectAndUnProjectResult(
      Point(x: -193931.34632474044, y: 5233642.279699988),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:2678': ProjectAndUnProjectResult(
      Point(x: 42542288.4574988, y: 12146288.274907539),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2679': ProjectAndUnProjectResult(
      Point(x: 44394852.78185785, y: 12183697.82416335),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2680': ProjectAndUnProjectResult(
      Point(x: 46394705.28362169, y: 12125305.652278015),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2681': ProjectAndUnProjectResult(
      Point(x: 48558526.48702615, y: 11950616.349463312),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2682': ProjectAndUnProjectResult(
      Point(x: 50904517.44345708, y: 11636259.249952596),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2683': ProjectAndUnProjectResult(
      Point(x: 53452505.28827122, y: 11155688.489850847),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2684': ProjectAndUnProjectResult(
      Point(x: 56224053.798896156, y: 10478860.452441784),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2685': ProjectAndUnProjectResult(
      Point(x: 59242579.0760828, y: 9571887.488782195),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2686': ProjectAndUnProjectResult(
      Point(x: 62533470.4701836, y: 8396666.774638083),
      Point(x: double.nan, y: double.nan)),
  'EPSG:3048': ProjectAndUnProjectResult(
      Point(x: -650192.1809783222, y: 5305193.277268217),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:2687': ProjectAndUnProjectResult(
      Point(x: 66124216.87432951, y: 6910483.138041684),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2688': ProjectAndUnProjectResult(
      Point(x: 70044538.50637878, y: 5065584.664972954),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2689': ProjectAndUnProjectResult(
      Point(x: 74326524.30151153, y: 2808729.8638930563),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2690': ProjectAndUnProjectResult(
      Point(x: 79004775.0373421, y: 80705.1430827397),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2691': ProjectAndUnProjectResult(
      Point(x: 84116552.31342323, y: -3184188.6720379107),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2692': ProjectAndUnProjectResult(
      Point(x: 89701933.50701517, y: -7058682.08120732),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2693': ProjectAndUnProjectResult(
      Point(x: 95803972.82699251, y: -11623116.237611713),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2694': ProjectAndUnProjectResult(
      Point(x: 101968868.58776212, y: -16966057.215315938),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2695': ProjectAndUnProjectResult(
      Point(x: 109746136.8250658, y: -23184946.595761795),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:3049': ProjectAndUnProjectResult(
      Point(x: -1105125.3251090779, y: 5413941.604463775),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:2696': ProjectAndUnProjectResult(
      Point(x: 117688791.37553996, y: -30386789.780033987),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2697': ProjectAndUnProjectResult(
      Point(x: 126353530.54190639, y: -38688883.46037097),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2698': ProjectAndUnProjectResult(
      Point(x: 135800930.4656664, y: -48219583.711172454),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2699': ProjectAndUnProjectResult(
      Point(x: 262977.40292099846, y: 5200101.235815557),
      Point(x: 17.88805857027049, y: 46.89226406903771)),
  'EPSG:2700': ProjectAndUnProjectResult(
      Point(x: 34399.89649430476, y: 5213561.025774186),
      Point(x: 17.8880585731391, y: 46.892264064543355)),
  'EPSG:2701': ProjectAndUnProjectResult(
      Point(x: -194086.63716134313, y: 5235854.283937308),
      Point(x: 17.888058728388476, y: 46.89226402384307)),
  'EPSG:2702': ProjectAndUnProjectResult(
      Point(x: -422423.43412024935, y: 5267091.123078233),
      Point(x: 17.888060893937723, y: 46.89226389591836)),
  'EPSG:2703': ProjectAndUnProjectResult(
      Point(x: -650534.705398909, y: 5307424.743197788),
      Point(x: 17.888077164108275, y: 46.89226406201648)),
  'EPSG:2704': ProjectAndUnProjectResult(
      Point(x: -878321.4506180638, y: 5357050.999945765),
      Point(x: 17.888161901223476, y: 46.89226782456999)),
  'EPSG:2705': ProjectAndUnProjectResult(
      Point(x: -1105654.7796934056, y: 5416207.687562138),
      Point(x: 17.88850885829136, y: 46.89229074846724)),
  'EPSG:2706': ProjectAndUnProjectResult(
      Point(x: -1332368.6206817243, y: 5485173.414864039),
      Point(x: 17.889710324792958, y: 46.892389633066195)),
  'EPSG:2707': ProjectAndUnProjectResult(
      Point(x: -1558251.691909319, y: 5564265.926028976),
      Point(x: 17.89339665661175, y: 46.892742750704436)),
  'EPSG:2708': ProjectAndUnProjectResult(
      Point(x: -1783038.6165094986, y: 5653839.691149153),
      Point(x: 17.90374169339023, y: 46.893856907596486)),
  'EPSG:2709': ProjectAndUnProjectResult(
      Point(x: -2006400.0574959628, y: 5754282.564756225),
      Point(x: 17.930912766487186, y: 46.89707896829051)),
  'EPSG:2710': ProjectAndUnProjectResult(
      Point(x: -2227931.7514988896, y: 5866011.283740241),
      Point(x: 17.99888115808944, y: 46.90582854474073)),
  'EPSG:2711': ProjectAndUnProjectResult(
      Point(x: -2447142.3192905476, y: 5989465.549310994),
      Point(x: 18.163085249950498, y: 46.92853675095355)),
  'EPSG:2712': ProjectAndUnProjectResult(
      Point(x: -2663439.73122723, y: 6125100.410874365),
      Point(x: 18.55070173800883, y: 46.98565566739177)),
  'EPSG:2713': ProjectAndUnProjectResult(
      Point(x: -2876116.3057343345, y: 6273376.642920781),
      Point(x: 19.453977225641804, y: 47.12654815721369)),
  'EPSG:2714': ProjectAndUnProjectResult(
      Point(x: -3084332.118961408, y: 6434748.779247259),
      Point(x: 21.551848481426063, y: 47.47097185323701)),
  'EPSG:2715': ProjectAndUnProjectResult(
      Point(x: -3287096.703733949, y: 6609650.442058996),
      Point(x: 26.45354646467008, y: 48.31387174213733)),
  'EPSG:2716': ProjectAndUnProjectResult(
      Point(x: -3483248.915928807, y: 6798476.576720871),
      Point(x: 38.08831473467017, y: 50.40023120211537)),
  'EPSG:2717': ProjectAndUnProjectResult(
      Point(x: -3671434.8463999643, y: 7001562.176153691),
      Point(x: 66.44656806390067, y: 55.68157108625792)),
  'EPSG:2718': ProjectAndUnProjectResult(
      Point(x: -3850083.656581538, y: 7219157.052094408),
      Point(x: 138.3170738035691, y: 69.52842660642166)),
  'EPSG:2719': ProjectAndUnProjectResult(
      Point(x: -4017381.2158948015, y: 7451396.183664046),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2720': ProjectAndUnProjectResult(
      Point(x: -4171241.419086039, y: 7698265.146911397),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2721': ProjectAndUnProjectResult(
      Point(x: -4309275.061622056, y: 7959560.102225089),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2722': ProjectAndUnProjectResult(
      Point(x: -4428756.151270143, y: 8234841.789731057),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2723': ProjectAndUnProjectResult(
      Point(x: -4526585.5339893205, y: 8523382.956016758),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2724': ProjectAndUnProjectResult(
      Point(x: -4599251.71225967, y: 8824108.608748099),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2725': ProjectAndUnProjectResult(
      Point(x: -4642788.733976571, y: 9135528.468969345),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2726': ProjectAndUnProjectResult(
      Point(x: -4652731.030036646, y: 9455660.96410075),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2727': ProjectAndUnProjectResult(
      Point(x: -4624065.078742239, y: 9781948.077873092),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2728': ProjectAndUnProjectResult(
      Point(x: -4551177.775151228, y: 10111160.346662756),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2729': ProjectAndUnProjectResult(
      Point(x: -4427801.383499, y: 10439291.264915409),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2730': ProjectAndUnProjectResult(
      Point(x: -4246954.950819392, y: 10761440.335570734),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2731': ProjectAndUnProjectResult(
      Point(x: -4000882.0598914055, y: 11071683.97462519),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2732': ProjectAndUnProjectResult(
      Point(x: -3680984.799638518, y: 11362933.452194152),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2733': ProjectAndUnProjectResult(
      Point(x: -3277753.8311074045, y: 11626779.025659218),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2734': ProjectAndUnProjectResult(
      Point(x: -2780694.4271528777, y: 11853319.39371094),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2735': ProjectAndUnProjectResult(
      Point(x: -2178248.363955864, y: 12030975.573321657),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2737': ProjectAndUnProjectResult(
      Point(x: -1105016.8657866523, y: 15414023.439965632),
      Point(x: 17.8880585172707, y: 46.89226393491841)),
  'EPSG:2738': ProjectAndUnProjectResult(
      Point(x: -1457711.5425012028, y: 12146288.274907539),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2739': ProjectAndUnProjectResult(
      Point(x: -605147.2181421507, y: 12183697.82416335),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2740': ProjectAndUnProjectResult(
      Point(x: 394705.28362169425, y: 12125305.652278015),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2741': ProjectAndUnProjectResult(
      Point(x: 1558526.4870261499, y: 11950616.349463312),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2742': ProjectAndUnProjectResult(
      Point(x: 2904517.443457079, y: 11636259.249952596),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2743': ProjectAndUnProjectResult(
      Point(x: 4452505.288271218, y: 11155688.489850847),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2744': ProjectAndUnProjectResult(
      Point(x: 6224053.798896154, y: 10478860.452441784),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:2745': ProjectAndUnProjectResult(
      Point(x: 8242579.076082804, y: 9571887.488782195),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2746': ProjectAndUnProjectResult(
      Point(x: 10533470.470183605, y: 8396666.774638083),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2747': ProjectAndUnProjectResult(
      Point(x: 13124216.874329505, y: 6910483.138041684),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2748': ProjectAndUnProjectResult(
      Point(x: 16044538.506378785, y: 5065584.664972954),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2749': ProjectAndUnProjectResult(
      Point(x: 19326524.301511526, y: 2808729.8638930563),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2750': ProjectAndUnProjectResult(
      Point(x: 23004775.037342105, y: 80705.1430827397),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2751': ProjectAndUnProjectResult(
      Point(x: 27116552.31342323, y: -3184188.6720379107),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2752': ProjectAndUnProjectResult(
      Point(x: 31701933.507015165, y: -7058682.08120732),
      Point(x: double.nan, y: double.nan)),
  'EPSG:2753': ProjectAndUnProjectResult(
      Point(x: 36803972.82699252, y: -11623116.237611713),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2754': ProjectAndUnProjectResult(
      Point(x: 42468868.58776212, y: -16966057.215315938),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2755': ProjectAndUnProjectResult(
      Point(x: 48746136.82506581, y: -23184946.595761795),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2756': ProjectAndUnProjectResult(
      Point(x: 55688791.37553995, y: -30386789.780033987),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2757': ProjectAndUnProjectResult(
      Point(x: 63353530.541906394, y: -38688883.46037097),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2758': ProjectAndUnProjectResult(
      Point(x: 71800930.46566641, y: -48219583.711172454),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:2759': ProjectAndUnProjectResult(
      Point(x: 4175252.6559100477, y: 8132636.419234506), Point(x: 0, y: 90)),
  'EPSG:2760': ProjectAndUnProjectResult(
      Point(x: 4335563.615183162, y: 8328698.3072116645), Point(x: 0, y: 90)),
  'EPSG:2761': ProjectAndUnProjectResult(
      Point(x: -3169861.026850693, y: 7913822.186592112), Point(x: 0, y: 90)),
  'EPSG:2762': ProjectAndUnProjectResult(
      Point(x: -4128150.708307095, y: 7585988.433132556), Point(x: 0, y: 90)),
  'EPSG:2763': ProjectAndUnProjectResult(
      Point(x: -5215796.690656631, y: 7168396.858414973), Point(x: 0, y: 90)),
  'EPSG:2764': ProjectAndUnProjectResult(
      Point(x: 7280845.10476574, y: 5698018.880729793),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:2765': ProjectAndUnProjectResult(
      Point(x: 7441828.743390062, y: 6181711.961229637),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:2766': ProjectAndUnProjectResult(
      Point(x: 8713369.04628296, y: 8228903.974584526),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2767': ProjectAndUnProjectResult(
      Point(x: 8988852.870882323, y: 8299543.835321399),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:2768': ProjectAndUnProjectResult(
      Point(x: 9196533.03998033, y: 8221416.367224062),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2769': ProjectAndUnProjectResult(
      Point(x: 9364631.99275643, y: 8154335.033546976),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:2770': ProjectAndUnProjectResult(
      Point(x: 9657012.346788008, y: 8138321.005032831),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2771': ProjectAndUnProjectResult(
      Point(x: 9857792.552179694, y: 8039982.800465539),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:2772': ProjectAndUnProjectResult(
      Point(x: 7609906.701740923, y: 6737108.930826646),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2773': ProjectAndUnProjectResult(
      Point(x: 7746779.736843174, y: 6828729.263310314),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:9012': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:2774': ProjectAndUnProjectResult(
      Point(x: 7902404.853652807, y: 6873456.4247696595),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2775': ProjectAndUnProjectResult(
      Point(x: 6039095.133709748, y: 4143749.064976011),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:2776': ProjectAndUnProjectResult(
      Point(x: 5117848.770438616, y: 6252732.387920412), Point(x: 0, y: 90)),
  'EPSG:2777': ProjectAndUnProjectResult(
      Point(x: 4721237.687280814, y: 8356420.754737286), Point(x: 0, y: 90)),
  'EPSG:2778': ProjectAndUnProjectResult(
      Point(x: 4625113.957471083, y: 8456488.815026179), Point(x: 0, y: 90)),
  'EPSG:2779': ProjectAndUnProjectResult(
      Point(x: 7714848.02247523, y: 5442253.479619011),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:2780': ProjectAndUnProjectResult(
      Point(x: 4608098.742447868, y: 7844758.075159398), Point(x: 0, y: 90)),
  'EPSG:2781': ProjectAndUnProjectResult(
      Point(x: 4887189.5243078265, y: 8036713.270922709), Point(x: 0, y: 90)),
  'EPSG:2782': ProjectAndUnProjectResult(
      Point(x: -68690821.23140611, y: -47885351.84872058), Point(x: 0, y: -90)),
  'EPSG:2783': ProjectAndUnProjectResult(
      Point(x: -72121220.72359695, y: -51990013.836311065),
      Point(x: 0, y: -90)),
  'EPSG:2784': ProjectAndUnProjectResult(
      Point(x: -76202390.86573209, y: -56842739.61567939), Point(x: 0, y: -90)),
  'EPSG:2785': ProjectAndUnProjectResult(
      Point(x: -81001618.96536075, y: -62615395.648396604),
      Point(x: 0, y: -90)),
  'EPSG:2786': ProjectAndUnProjectResult(
      Point(x: -83208947.34861997, y: -65252448.177499056),
      Point(x: 0, y: -90)),
  'EPSG:2787': ProjectAndUnProjectResult(
      Point(x: -4284867.971020522, y: 6350434.242753448), Point(x: 0, y: 90)),
  'EPSG:2788': ProjectAndUnProjectResult(
      Point(x: -5084440.623114015, y: 5921630.496325042), Point(x: 0, y: 90)),
  'EPSG:2789': ProjectAndUnProjectResult(
      Point(x: -5919234.386603765, y: 5433186.325411458), Point(x: 0, y: 90)),
  'EPSG:2790': ProjectAndUnProjectResult(
      Point(x: 3905071.6147695784, y: 7655783.660641345), Point(x: 0, y: 90)),
  'EPSG:2791': ProjectAndUnProjectResult(
      Point(x: 3990597.385999085, y: 7789443.487367855), Point(x: 0, y: 90)),
  'EPSG:2792': ProjectAndUnProjectResult(
      Point(x: 4097701.446227201, y: 7591591.6682478), Point(x: 0, y: 90)),
  'EPSG:2793': ProjectAndUnProjectResult(
      Point(x: 4698254.479714725, y: 7712933.359383934), Point(x: 0, y: 90)),
  'EPSG:2794': ProjectAndUnProjectResult(
      Point(x: 7754185.385967116, y: 6441441.897699313),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:2795': ProjectAndUnProjectResult(
      Point(x: 6883654.037123509, y: 5522527.676852138),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:2796': ProjectAndUnProjectResult(
      Point(x: 7071987.862697571, y: 5919601.754797991),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:2797': ProjectAndUnProjectResult(
      Point(x: 7225695.016863069, y: 6455856.986343259),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:2798': ProjectAndUnProjectResult(
      Point(x: 6854798.276271999, y: 4982007.395728776),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2799': ProjectAndUnProjectResult(
      Point(x: 7000500.0764196385, y: 5649813.9503045585),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:4358': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2800': ProjectAndUnProjectResult(
      Point(x: 8293004.335917232, y: 5912444.595764324),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:2801': ProjectAndUnProjectResult(
      Point(x: 8460640.04761491, y: 5922044.6080015665),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2802': ProjectAndUnProjectResult(
      Point(x: 5434242.727510438, y: 4865567.286727372),
      Point(x: -3577911303.5949883, y: 784422263.488511)),
  'EPSG:2803': ProjectAndUnProjectResult(
      Point(x: 6005972.529556511, y: 5140915.469168544),
      Point(x: -2514978608650.738, y: 548342325600.6209)),
  'EPSG:2804': ProjectAndUnProjectResult(
      Point(x: 6458859.816901178, y: 4494509.018460154),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:2805': ProjectAndUnProjectResult(
      Point(x: 5851118.614199274, y: 4670879.245324666),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:2806': ProjectAndUnProjectResult(
      Point(x: 6154332.406766824, y: 3817884.2153315847),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:2807': ProjectAndUnProjectResult(
      Point(x: 13856577.937746815, y: 4794610.454685856),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3050': ProjectAndUnProjectResult(
      Point(x: -1557536.0364113871, y: 5561947.769793502),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:2808': ProjectAndUnProjectResult(
      Point(x: 11889319.027601004, y: 4694603.857861964),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:2809': ProjectAndUnProjectResult(
      Point(x: 10027794.9275133, y: 4787933.322479354),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:2810': ProjectAndUnProjectResult(
      Point(x: 6637522.089340442, y: 5241976.733282339),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:2811': ProjectAndUnProjectResult(
      Point(x: 6763552.011142525, y: 5414428.169782657),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:2812': ProjectAndUnProjectResult(
      Point(x: 6907731.6671998175, y: 5516216.609642071),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:2813': ProjectAndUnProjectResult(
      Point(x: 3822984.905080838, y: 8488545.1484227), Point(x: 0, y: 90)),
  'EPSG:2814': ProjectAndUnProjectResult(
      Point(x: 3960143.9403490187, y: 8595620.856387978), Point(x: 0, y: 90)),
  'EPSG:2815': ProjectAndUnProjectResult(
      Point(x: 3479281.287680031, y: 7904330.11893151), Point(x: 0, y: 90)),
  'EPSG:2960': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 9674131.646974),
      Point(x: 17.888058560281358, y: 46.892264067008654)),
  'EPSG:2816': ProjectAndUnProjectResult(
      Point(x: 3333355.4118026467, y: 8025679.559234873), Point(x: 0, y: 90)),
  'EPSG:2817': ProjectAndUnProjectResult(
      Point(x: 3236399.2997552953, y: 8083966.915915788), Point(x: 0, y: 90)),
  'EPSG:2818': ProjectAndUnProjectResult(
      Point(x: 6556297.784221025, y: 6590553.712986213),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2819': ProjectAndUnProjectResult(
      Point(x: 6975000.373432801, y: 6039872.843451777),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:2820': ProjectAndUnProjectResult(
      Point(x: -6407205.481935473, y: 14250720.322452161), Point(x: 0, y: 90)),
  'EPSG:2821': ProjectAndUnProjectResult(
      Point(x: -6848369.235542074, y: 11911589.980849914),
      Point(x: 189531435637.07315, y: 59487357072.499916)),
  'EPSG:2822': ProjectAndUnProjectResult(
      Point(x: -7945837.346430153, y: 9227187.99242025),
      Point(x: 53494776.36427391, y: 20053499.392547227)),
  'EPSG:2823': ProjectAndUnProjectResult(
      Point(x: 5368091.402649273, y: 5342638.370730873), Point(x: 0, y: 90)),
  'EPSG:2824': ProjectAndUnProjectResult(
      Point(x: 5111955.253111458, y: 6059884.249141174), Point(x: 0, y: 90)),
  'EPSG:2825': ProjectAndUnProjectResult(
      Point(x: -530531.6564737859, y: 8584058.195630815), Point(x: 0, y: 90)),
  'EPSG:2826': ProjectAndUnProjectResult(
      Point(x: -998074.9727628597, y: 8428106.011472125), Point(x: 0, y: 90)),
  'EPSG:2827': ProjectAndUnProjectResult(
      Point(x: -1388949.665557478, y: 8254150.647986836), Point(x: 0, y: 90)),
  'EPSG:2828': ProjectAndUnProjectResult(
      Point(x: 5111955.253111458, y: 6059884.249141174), Point(x: 0, y: 90)),
  'EPSG:2829': ProjectAndUnProjectResult(
      Point(x: 5102989.244976103, y: 6156462.138120647), Point(x: 0, y: 90)),
  'EPSG:2830': ProjectAndUnProjectResult(
      Point(x: 5070627.948794095, y: 6369472.582025805), Point(x: 0, y: 90)),
  'EPSG:2831': ProjectAndUnProjectResult(
      Point(x: 6120506.5914582675, y: 4115911.994870667),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2832': ProjectAndUnProjectResult(
      Point(x: 6465460.630965634, y: 5661785.323388806),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2833': ProjectAndUnProjectResult(
      Point(x: 6573964.729929726, y: 5741275.293893124),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2834': ProjectAndUnProjectResult(
      Point(x: 6701563.894453452, y: 4762473.447759279),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:2835': ProjectAndUnProjectResult(
      Point(x: 6823927.076346041, y: 4856567.2808180135),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:2836': ProjectAndUnProjectResult(
      Point(x: 7606719.341866343, y: 6088830.052103923),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:2837': ProjectAndUnProjectResult(
      Point(x: 7788873.682746351, y: 6165418.092119623),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:2838': ProjectAndUnProjectResult(
      Point(x: 8597033.820587108, y: 7390016.602283895),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2839': ProjectAndUnProjectResult(
      Point(x: 7874076.89548586, y: 7497850.224338042),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:2840': ProjectAndUnProjectResult(
      Point(x: 5173030.8098551845, y: 5481823.207905864), Point(x: 0, y: 90)),
  'EPSG:2841': ProjectAndUnProjectResult(
      Point(x: 6731916.633515107, y: 5806582.369900572),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:4360': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2842': ProjectAndUnProjectResult(
      Point(x: 6870716.757738419, y: 5915239.061073107),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:2843': ProjectAndUnProjectResult(
      Point(x: 7240825.507643389, y: 5300270.815013457),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:2844': ProjectAndUnProjectResult(
      Point(x: 7393138.261094371, y: 7401668.656500031),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2845': ProjectAndUnProjectResult(
      Point(x: 7989143.282984504, y: 8276494.464586326),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2846': ProjectAndUnProjectResult(
      Point(x: 8418734.087582087, y: 9472776.726556078),
      Point(x: 17.88805856028155, y: 46.892264067008746)),
  'EPSG:2847': ProjectAndUnProjectResult(
      Point(x: 8486728.051005203, y: 10453504.590111742),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:2848': ProjectAndUnProjectResult(
      Point(x: 8484246.042842139, y: 11469435.827622361),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:2849': ProjectAndUnProjectResult(
      Point(x: 7132858.074758168, y: 7841015.069017461),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:2850': ProjectAndUnProjectResult(
      Point(x: 7316582.822330039, y: 8971163.047072299),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:2851': ProjectAndUnProjectResult(
      Point(x: 7595059.15054545, y: 10017430.541012172),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:2852': ProjectAndUnProjectResult(
      Point(x: 5541768.404689928, y: 5434133.661562179), Point(x: 0, y: 90)),
  'EPSG:2853': ProjectAndUnProjectResult(
      Point(x: 9634482.513941199, y: 6581020.355130133),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:2854': ProjectAndUnProjectResult(
      Point(x: 9723405.910334777, y: 5663039.725072842),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:2855': ProjectAndUnProjectResult(
      Point(x: 6208880.764422776, y: 7201291.121268816),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:2856': ProjectAndUnProjectResult(
      Point(x: 6409557.023981855, y: 7281838.145229915),
      Point(x: 17.88805856028154, y: 46.892264067008746)),
  'EPSG:2857': ProjectAndUnProjectResult(
      Point(x: 6701578.612677592, y: 4608732.256874052),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:4362': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2858': ProjectAndUnProjectResult(
      Point(x: 6860107.275988375, y: 4799756.489364472),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2859': ProjectAndUnProjectResult(
      Point(x: 6517033.000426102, y: 4968571.836722961),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:2860': ProjectAndUnProjectResult(
      Point(x: 6611250.719513921, y: 5046926.8438626565),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:2861': ProjectAndUnProjectResult(
      Point(x: 6723783.25810189, y: 5169377.719135766),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:2862': ProjectAndUnProjectResult(
      Point(x: -835360.288822798, y: 7469523.565254046), Point(x: 0, y: 90)),
  'EPSG:2863': ProjectAndUnProjectResult(
      Point(x: -1585501.348464507, y: 7359986.274514455), Point(x: 0, y: 90)),
  'EPSG:2864': ProjectAndUnProjectResult(
      Point(x: -2061507.894929119, y: 7079113.201731387), Point(x: 0, y: 90)),
  'EPSG:2865': ProjectAndUnProjectResult(
      Point(x: -2539578.0552160507, y: 6974103.5782705145), Point(x: 0, y: 90)),
  'EPSG:2939': ProjectAndUnProjectResult(
      Point(x: -189086.55047460692, y: 5731335.689237101),
      Point(x: 17.92777665801155, y: 46.89669453733006)),
  'EPSG:2866': ProjectAndUnProjectResult(
      Point(x: 7328037.617013937, y: 5241769.00316173),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:2867': ProjectAndUnProjectResult(
      Point(x: -10399806.518539019, y: 25963983.55181139), Point(x: 0, y: 90)),
  'EPSG:2868': ProjectAndUnProjectResult(
      Point(x: -13543801.5364406, y: 24888413.49452938), Point(x: 0, y: 90)),
  'EPSG:2869': ProjectAndUnProjectResult(
      Point(x: -17112193.866983697, y: 23518362.396374583), Point(x: 0, y: 90)),
  'EPSG:2870': ProjectAndUnProjectResult(
      Point(x: 28587111.613013346, y: 26997662.4569494),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2871': ProjectAndUnProjectResult(
      Point(x: 29490928.127553087, y: 27229420.066716958),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:2872': ProjectAndUnProjectResult(
      Point(x: 30172292.14900214, y: 26973096.865134276),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:2873': ProjectAndUnProjectResult(
      Point(x: 30723796.79656839, y: 26753014.189562038),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:4364': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2874': ProjectAndUnProjectResult(
      Point(x: 31683048.00808699, y: 26700474.83101188),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2875': ProjectAndUnProjectResult(
      Point(x: 32341774.398609553, y: 26377843.57152736),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:2876': ProjectAndUnProjectResult(
      Point(x: 24966835.570312265, y: 22103331.550557755),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2877': ProjectAndUnProjectResult(
      Point(x: 25415893.18631023, y: 22403922.591381256),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2878': ProjectAndUnProjectResult(
      Point(x: 25926473.257043168, y: 22550664.95360246),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2879': ProjectAndUnProjectResult(
      Point(x: 19813264.617850065, y: 13594950.05734413),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:2880': ProjectAndUnProjectResult(
      Point(x: 16790808.84134736, y: 20514172.84270222), Point(x: 0, y: 90)),
  'EPSG:2881': ProjectAndUnProjectResult(
      Point(x: 15489593.979353804, y: 27416023.75950058), Point(x: 0, y: 90)),
  'EPSG:2882': ProjectAndUnProjectResult(
      Point(x: 15174228.04246971, y: 27744330.38729839), Point(x: 0, y: 90)),
  'EPSG:2883': ProjectAndUnProjectResult(
      Point(x: 25311130.553737484, y: 17855126.624383375),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:2884': ProjectAndUnProjectResult(
      Point(x: 15118403.957847713, y: 25737343.784918793), Point(x: 0, y: 90)),
  'EPSG:2885': ProjectAndUnProjectResult(
      Point(x: 16034054.29733326, y: 26367116.78968559), Point(x: 0, y: 90)),
  'EPSG:2886': ProjectAndUnProjectResult(
      Point(x: -14057937.667923164, y: 20834716.344766937), Point(x: 0, y: 90)),
  'EPSG:2887': ProjectAndUnProjectResult(
      Point(x: -16681202.277333234, y: 19427882.72002641), Point(x: 0, y: 90)),
  'EPSG:2888': ProjectAndUnProjectResult(
      Point(x: -19420021.483049188, y: 17825378.802620757), Point(x: 0, y: 90)),
  'EPSG:2889': ProjectAndUnProjectResult(
      Point(x: 13443875.494497076, y: 24904663.66490966), Point(x: 0, y: 90)),
  'EPSG:3573': ProjectAndUnProjectResult(
      Point(x: 4149159.5345805907, y: 2195759.8266752437),
      Point(x: 17.888058560281525, y: 46.892264069112215)),
  'EPSG:2890': ProjectAndUnProjectResult(
      Point(x: 15414189.905530728, y: 25302765.529912125), Point(x: 0, y: 90)),
  'EPSG:2891': ProjectAndUnProjectResult(
      Point(x: 22489450.678402383, y: 16345135.930820161),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2892': ProjectAndUnProjectResult(
      Point(x: 22967474.00105343, y: 18536097.935624205),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:2893': ProjectAndUnProjectResult(
      Point(x: 21190442.582283285, y: 14745735.004731355),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:2894': ProjectAndUnProjectResult(
      Point(x: 19196544.98708545, y: 15324376.324036008),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:2895': ProjectAndUnProjectResult(
      Point(x: 20191338.90486749, y: 12525841.796467042),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:2896': ProjectAndUnProjectResult(
      Point(x: 45461213.70641344, y: 15730349.260780366),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2897': ProjectAndUnProjectResult(
      Point(x: 39006952.19021326, y: 15402243.62815605),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:2898': ProjectAndUnProjectResult(
      Point(x: 32899589.65714337, y: 15708442.659052998),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:2899': ProjectAndUnProjectResult(
      Point(x: 12542576.309419384, y: 27849501.87445014), Point(x: 0, y: 90)),
  'EPSG:2900': ProjectAndUnProjectResult(
      Point(x: 12992572.243961738, y: 28200799.426332895), Point(x: 0, y: 90)),
  'EPSG:2901': ProjectAndUnProjectResult(
      Point(x: 21510163.334050607, y: 21622551.551792037),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2902': ProjectAndUnProjectResult(
      Point(x: -1740585.942947746, y: 28162864.26349877), Point(x: 0, y: 90)),
  'EPSG:2903': ProjectAndUnProjectResult(
      Point(x: -3274517.639472816, y: 27651211.139304798), Point(x: 0, y: 90)),
  'EPSG:2904': ProjectAndUnProjectResult(
      Point(x: -4556912.360749827, y: 27080492.584270146), Point(x: 0, y: 90)),
  'EPSG:2905': ProjectAndUnProjectResult(
      Point(x: 16771473.19291651, y: 19881470.240724005), Point(x: 0, y: 90)),
  'EPSG:2949': ProjectAndUnProjectResult(
      Point(x: 5403037.173898023, y: 9920877.559935424),
      Point(x: -34661211008946.938, y: 7546306826338.474)),
  'EPSG:2906': ProjectAndUnProjectResult(
      Point(x: 16742057.214225767, y: 20198326.19815082), Point(x: 0, y: 90)),
  'EPSG:2907': ProjectAndUnProjectResult(
      Point(x: 16635885.195668627, y: 20897177.962862995), Point(x: 0, y: 90)),
  'EPSG:2908': ProjectAndUnProjectResult(
      Point(x: 20080362.042142667, y: 13503621.26983818),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2909': ProjectAndUnProjectResult(
      Point(x: 21212141.1777009, y: 18575411.16597377),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2910': ProjectAndUnProjectResult(
      Point(x: 21568125.75435474, y: 18836205.032457754),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2911': ProjectAndUnProjectResult(
      Point(x: 24956378.374106497, y: 19976436.59594429),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:2912': ProjectAndUnProjectResult(
      Point(x: 25553996.407476988, y: 20227709.190562464),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:2913': ProjectAndUnProjectResult(
      Point(x: 28205491.53782647, y: 24245461.29358233),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:2914': ProjectAndUnProjectResult(
      Point(x: 25833585.615591403, y: 24599246.142841343),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:2915': ProjectAndUnProjectResult(
      Point(x: 23755941.686326686, y: 17389305.165589985),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:2916': ProjectAndUnProjectResult(
      Point(x: 24255654.445273783, y: 24283641.25020052),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2917': ProjectAndUnProjectResult(
      Point(x: 26211047.58759166, y: 27153798.92289697),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:2918': ProjectAndUnProjectResult(
      Point(x: 27620463.418675568, y: 31078601.6437094),
      Point(x: 17.88805856028155, y: 46.892264067008746)),
  'EPSG:2919': ProjectAndUnProjectResult(
      Point(x: 27843540.280672904, y: 34296206.30905828),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:2920': ProjectAndUnProjectResult(
      Point(x: 27835397.225557923, y: 37629307.37812436),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:2921': ProjectAndUnProjectResult(
      Point(x: 23401765.337626535, y: 25725115.05581844),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:2922': ProjectAndUnProjectResult(
      Point(x: 24004536.819161545, y: 29432949.629476044),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:2923': ProjectAndUnProjectResult(
      Point(x: 24918173.066587433, y: 32865585.764436252),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:2924': ProjectAndUnProjectResult(
      Point(x: 31609131.381488748, y: 21591230.948789444),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:2925': ProjectAndUnProjectResult(
      Point(x: 31900874.224490017, y: 18579489.497676484),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:2926': ProjectAndUnProjectResult(
      Point(x: 20370302.974943724, y: 23626235.95369611),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:2927': ProjectAndUnProjectResult(
      Point(x: 21028688.336513802, y: 23890497.31480848),
      Point(x: 17.88805856028154, y: 46.892264067008746)),
  'EPSG:2928': ProjectAndUnProjectResult(
      Point(x: 21381299.102231305, y: 16301056.100981915),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:2929': ProjectAndUnProjectResult(
      Point(x: 21690411.73560526, y: 16558125.8202394),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:2930': ProjectAndUnProjectResult(
      Point(x: 22059612.239289284, y: 16959866.73353126),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:2931': ProjectAndUnProjectResult(
      Point(x: 872393.827671501, y: 5204619.094332747),
      Point(x: 17.88805855772476, y: 46.89226406150547)),
  'EPSG:2932': ProjectAndUnProjectResult(
      Point(x: -2322441.615643253, y: 3356641.705803981),
      Point(x: 17.93400798832915, y: 46.897461336768856)),
  'EPSG:2933': ProjectAndUnProjectResult(
      Point(x: -4730460.897764476, y: 20936569.06347169),
      Point(x: 17.888059822235636, y: 46.89226431455571)),
  'EPSG:2934': ProjectAndUnProjectResult(
      Point(x: 21774385.36038773, y: 6774706.861113531),
      Point(x: 17.888059822235878, y: 46.89226431455566)),
  'EPSG:2935': ProjectAndUnProjectResult(
      Point(x: -497150.86136644287, y: 5460896.054330236),
      Point(x: 17.889420558941982, y: 46.89236440013524)),
  'EPSG:2936': ProjectAndUnProjectResult(
      Point(x: 276821.2142744588, y: 5538390.984857211),
      Point(x: 17.892537316600897, y: 46.892656808665606)),
  'EPSG:2937': ProjectAndUnProjectResult(
      Point(x: 1051844.2311837403, y: 5626309.735105842),
      Point(x: 17.901391234225017, y: 46.89359466914904)),
  'EPSG:2938': ProjectAndUnProjectResult(
      Point(x: 1828236.8877569116, y: 5725035.22820721),
      Point(x: 17.92485713545289, y: 46.896338925427834)),
  'EPSG:2940': ProjectAndUnProjectResult(
      Point(x: 589223.4007894667, y: 5842171.1657247655),
      Point(x: 17.991156893829547, y: 46.90480499334767)),
  'EPSG:2941': ProjectAndUnProjectResult(
      Point(x: 1369812.852999465, y: 5964697.31797293),
      Point(x: 18.14462398150659, y: 46.92591733038659)),
  'EPSG:2942': ProjectAndUnProjectResult(
      Point(x: 2989338.4012896237, y: 5743661.526511305),
      Point(x: 17.888058569701755, y: 46.892264026299124)),
  'EPSG:2943': ProjectAndUnProjectResult(
      Point(x: 2989125.6026844718, y: 5743974.800354819),
      Point(x: 17.888058562214976, y: 46.89226405889515)),
  'EPSG:2944': ProjectAndUnProjectResult(
      Point(x: 5277537.244089515, y: 8355177.8227729015),
      Point(x: -15979.524499782834, y: 3524.3478798098868)),
  'EPSG:2945': ProjectAndUnProjectResult(
      Point(x: 5365095.243901447, y: 8649032.835441044),
      Point(x: -76314.668724916, y: 16624.267920019753)),
  'EPSG:2946': ProjectAndUnProjectResult(
      Point(x: 5425861.74852327, y: 8954491.865918288),
      Point(x: -519603.48216074344, y: 113747.10753176517)),
  'EPSG:2947': ProjectAndUnProjectResult(
      Point(x: 5455664.100526009, y: 9269865.456694849),
      Point(x: -6859630.010890731, y: 1508686.9880534173)),
  'EPSG:2948': ProjectAndUnProjectResult(
      Point(x: 5449809.877896608, y: 9592937.814035818),
      Point(x: -411243275.37217355, y: 90346346.30780989)),
  'EPSG:3574': ProjectAndUnProjectResult(
      Point(x: 3976163.557800372, y: -2495397.6479635886),
      Point(x: 17.888058560281518, y: 46.892264069112215)),
  'EPSG:2950': ProjectAndUnProjectResult(
      Point(x: 5309461.530223562, y: 10250138.320860693), Point(x: 0, y: 90)),
  'EPSG:2951': ProjectAndUnProjectResult(
      Point(x: 5162519.4015817605, y: 10576348.404652024), Point(x: 0, y: 90)),
  'EPSG:2952': ProjectAndUnProjectResult(
      Point(x: 4954908.029848009, y: 10894188.79017561), Point(x: 0, y: 90)),
  'EPSG:2953': ProjectAndUnProjectResult(
      Point(x: 8016398.141955978, y: 11184245.693301002),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:2954': ProjectAndUnProjectResult(
      Point(x: 5757390.397843242, y: 4104942.040903113),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:2955': ProjectAndUnProjectResult(
      Point(x: 3875003.072767595, y: 13725397.247874938),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:2956': ProjectAndUnProjectResult(
      Point(x: 4286275.534235133, y: 13389860.739087315),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:2957': ProjectAndUnProjectResult(
      Point(x: 4671946.775898903, y: 12999702.032507129),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:2958': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 10914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:2959': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 10298556.41432563),
      Point(x: 17.88805856028164, y: 46.892264067008654)),
  'EPSG:2961': ProjectAndUnProjectResult(
      Point(x: 5731020.405467821, y: 9059228.545130335),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:2962': ProjectAndUnProjectResult(
      Point(x: 5558786.502469642, y: 8470922.227642598),
      Point(x: 17.88805856028146, y: 46.89226406700888)),
  'EPSG:2964': ProjectAndUnProjectResult(
      Point(x: 8871383.233963447, y: 30123220.645564575),
      Point(x: 17.88805856028151, y: 46.89226404782316)),
  'EPSG:2965': ProjectAndUnProjectResult(
      Point(x: 13443875.494497076, y: 24906746.99790966), Point(x: 0, y: 90)),
  'EPSG:2966': ProjectAndUnProjectResult(
      Point(x: 15414189.905530728, y: 25304848.862912126), Point(x: 0, y: 90)),
  'EPSG:2967': ProjectAndUnProjectResult(
      Point(x: 13443875.494497076, y: 24906746.99790966), Point(x: 0, y: 90)),
  'EPSG:2968': ProjectAndUnProjectResult(
      Point(x: 15414189.905530728, y: 25304848.862912126), Point(x: 0, y: 90)),
  'EPSG:2969': ProjectAndUnProjectResult(
      Point(x: 5730490.86592958, y: 9059410.864174804),
      Point(x: 17.888058548503803, y: 46.89226408938741)),
  'EPSG:2970': ProjectAndUnProjectResult(
      Point(x: 5731260.014856518, y: 9059333.333275096),
      Point(x: 17.88805864551403, y: 46.89226408156829)),
  'EPSG:4366': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2971': ProjectAndUnProjectResult(
      Point(x: 5314316.882592498, y: 7922808.490801433),
      Point(x: 17.888058441256128, y: 46.89226404873106)),
  'EPSG:2972': ProjectAndUnProjectResult(
      Point(x: 5314192.97843734, y: 7922929.14904744),
      Point(x: 17.88805856028157, y: 46.89226406700883)),
  'EPSG:2973': ProjectAndUnProjectResult(
      Point(x: 5730841.011870172, y: 9059046.5529167),
      Point(x: 17.888058119316472, y: 46.8922642371572)),
  'EPSG:2975': ProjectAndUnProjectResult(
      Point(x: -2446086.561687547, y: 15986927.666624561),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:2976': ProjectAndUnProjectResult(
      Point(x: 1650283.0939078461, y: 24691140.124983132),
      Point(x: 17.888058504039417, y: 46.89226414534989)),
  'EPSG:2977': ProjectAndUnProjectResult(
      Point(x: 1194221.3892977247, y: 24762623.111159246),
      Point(x: 17.88805831385603, y: 46.892264159538165)),
  'EPSG:2978': ProjectAndUnProjectResult(
      Point(x: 2105387.455857314, y: 24582291.90198673),
      Point(x: 17.888058385637127, y: 46.892264152156805)),
  'EPSG:2979': ProjectAndUnProjectResult(
      Point(x: -3286195.2284794194, y: 16606131.706282284),
      Point(x: 17.888058712257504, y: 46.89226410440332)),
  'EPSG:2980': ProjectAndUnProjectResult(
      Point(x: -1557696.3070654601, y: 15562079.323209908),
      Point(x: 17.888058591658083, y: 46.89226406997221)),
  'EPSG:2981': ProjectAndUnProjectResult(
      Point(x: -1988664.574601775, y: 24251971.832477063),
      Point(x: 17.888058493571197, y: 46.892264291373436)),
  'EPSG:2982': ProjectAndUnProjectResult(
      Point(x: -1989423.5035707685, y: 24252479.533696525),
      Point(x: 17.888058784722478, y: 46.89226397481844)),
  'EPSG:2983': ProjectAndUnProjectResult(
      Point(x: -1989442.0514765643, y: 24252578.453905605),
      Point(x: 17.888058581785046, y: 46.89226401798819)),
  'EPSG:2984': ProjectAndUnProjectResult(
      Point(x: -20824179.822686467, y: -638055.6067423951),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:2987': ProjectAndUnProjectResult(
      Point(x: 5558629.455894565, y: 8470356.891321244),
      Point(x: 17.88805830421726, y: 46.89226410462157)),
  'EPSG:2988': ProjectAndUnProjectResult(
      Point(x: -633378.7860614453, y: 24694241.44682131),
      Point(x: 17.888058663196386, y: 46.89226417983815)),
  'EPSG:2989': ProjectAndUnProjectResult(
      Point(x: 5731020.405434482, y: 9059228.545214958),
      Point(x: 17.888058560281323, y: 46.89226406700882)),
  'EPSG:2990': ProjectAndUnProjectResult(
      Point(x: -2789201.6978123337, y: 8423972.817739557),
      Point(x: 18.064677355390117, y: 46.91475667121765)),
  'EPSG:2991': ProjectAndUnProjectResult(
      Point(x: 6621080.326600361, y: 7550611.109639786),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:2992': ProjectAndUnProjectResult(
      Point(x: 21722704.48359173, y: 24772346.160235517),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:4368': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:2993': ProjectAndUnProjectResult(
      Point(x: 6621080.326600361, y: 7550611.109639786),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:2994': ProjectAndUnProjectResult(
      Point(x: 21722704.48359173, y: 24772346.160235517),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:2995': ProjectAndUnProjectResult(
      Point(x: -1988741.6983107268, y: 24252064.71521464),
      Point(x: 17.888058505847603, y: 46.89226426303318)),
  'EPSG:2996': ProjectAndUnProjectResult(
      Point(x: -1989423.5035707685, y: 24252479.533696525),
      Point(x: 17.888058784722478, y: 46.89226397481844)),
  'EPSG:2997': ProjectAndUnProjectResult(
      Point(x: -1989589.9546094108, y: 24251531.855844844),
      Point(x: 17.888057469925077, y: 46.8922641752369)),
  'EPSG:2998': ProjectAndUnProjectResult(
      Point(x: -1989425.7499895166, y: 24252476.27587178),
      Point(x: 17.888058787489047, y: 46.89226397545263)),
  'EPSG:2999': ProjectAndUnProjectResult(
      Point(x: -1558482.9983546815, y: 15562137.872644074),
      Point(x: 17.88805948904906, y: 46.89226424540962)),
  'EPSG:3000': ProjectAndUnProjectResult(
      Point(x: -6323035.080961468, y: 6774706.861113531),
      Point(x: 17.888059822235856, y: 46.89226431455566)),
  'EPSG:3001': ProjectAndUnProjectResult(
      Point(x: -6323019.301218599, y: 6774822.740257204),
      Point(x: 17.888059883263967, y: 46.89226423543208)),
  'EPSG:3002': ProjectAndUnProjectResult(
      Point(x: -6322890.078644928, y: 6774362.061687819),
      Point(x: 17.888059768494053, y: 46.8922646303815)),
  'EPSG:3003': ProjectAndUnProjectResult(
      Point(x: 2176932.512591173, y: 5231692.879029004),
      Point(x: 17.888058440115767, y: 46.89226402774989)),
  'EPSG:3004': ProjectAndUnProjectResult(
      Point(x: 2740014.784146443, y: 5197260.952675889),
      Point(x: 17.888058564860476, y: 46.89226406744901)),
  'EPSG:3005': ProjectAndUnProjectResult(
      Point(x: 5852641.094495805, y: 8044112.188266415),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:3006': ProjectAndUnProjectResult(
      Point(x: 720001.2298382937, y: 5197241.609971515),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3007': ProjectAndUnProjectResult(
      Point(x: 598669.2683445803, y: 5212129.891160676),
      Point(x: 17.888058558416994, y: 46.89226406333179)),
  'EPSG:3008': ProjectAndUnProjectResult(
      Point(x: 484387.03616155894, y: 5204627.243488797),
      Point(x: 17.888058560316225, y: 46.89226406636951)),
  'EPSG:3009': ProjectAndUnProjectResult(
      Point(x: 370089.2655463072, y: 5199321.338507943),
      Point(x: 17.888058560302017, y: 46.89226406695651)),
  'EPSG:3010': ProjectAndUnProjectResult(
      Point(x: 255781.53174686513, y: 5196205.585950036),
      Point(x: 17.88805856028205, y: 46.892264067008135)),
  'EPSG:3011': ProjectAndUnProjectResult(
      Point(x: 141469.08374790964, y: 5195276.111849979),
      Point(x: 17.888058560281515, y: 46.892264067008774)),
  'EPSG:3012': ProjectAndUnProjectResult(
      Point(x: 427239.7350572513, y: 5201700.173692855),
      Point(x: 17.888058560331274, y: 46.89226406680042)),
  'EPSG:4370': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3019': ProjectAndUnProjectResult(
      Point(x: 2001544.817457878, y: 5215710.302426993),
      Point(x: 17.88805857994177, y: 46.89226402330031)),
  'EPSG:3020': ProjectAndUnProjectResult(
      Point(x: 1830145.677861884, y: 5203752.839792749),
      Point(x: 17.888058586340236, y: 46.892264029780634)),
  'EPSG:3021': ProjectAndUnProjectResult(
      Point(x: 1658711.959966589, y: 5196737.44236798),
      Point(x: 17.88805858630439, y: 46.8922640303641)),
  'EPSG:3022': ProjectAndUnProjectResult(
      Point(x: 1487262.185685372, y: 5194644.499455127),
      Point(x: 17.888058586300215, y: 46.89226403037144)),
  'EPSG:3023': ProjectAndUnProjectResult(
      Point(x: 1315813.6865043738, y: 5197468.153934496),
      Point(x: 17.888058586291464, y: 46.89226403035352)),
  'EPSG:3024': ProjectAndUnProjectResult(
      Point(x: 1144383.8892775094, y: 5205216.307122136),
      Point(x: 17.888058586327574, y: 46.8922640294506)),
  'EPSG:3025': ProjectAndUnProjectResult(
      Point(x: 2001302.573556974, y: 5215801.181182023),
      Point(x: 17.88805855395245, y: 46.89226405995596)),
  'EPSG:3026': ProjectAndUnProjectResult(
      Point(x: 1829906.5692325016, y: 5203850.484203292),
      Point(x: 17.88805856032182, y: 46.89226406642038)),
  'EPSG:3027': ProjectAndUnProjectResult(
      Point(x: 1658475.9961143748, y: 5196841.80384481),
      Point(x: 17.888058560285657, y: 46.89226406700151)),
  'EPSG:3028': ProjectAndUnProjectResult(
      Point(x: 1487029.3824840193, y: 5194755.5492781),
      Point(x: 17.888058560281515, y: 46.892264067008796)),
  'EPSG:3032': ProjectAndUnProjectResult(
      Point(x: -18589698.086052824, y: 25134328.24198812),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3033': ProjectAndUnProjectResult(
      Point(x: -15691757.104784992, y: 19987677.563023202),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3034': ProjectAndUnProjectResult(
      Point(x: 4580708.59132307, y: 2282143.4053414315),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3035': ProjectAndUnProjectResult(
      Point(x: 4921381.502448138, y: 2674052.203833336),
      Point(x: 17.888058560281518, y: 46.89226406911223)),
  'EPSG:3036': ProjectAndUnProjectResult(
      Point(x: -650192.180968157, y: 15305193.277388472),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:3037': ProjectAndUnProjectResult(
      Point(x: -1105125.3250947963, y: 15413941.604582964),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:3038': ProjectAndUnProjectResult(
      Point(x: 3859272.60100763, y: 6259037.26365852),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:3039': ProjectAndUnProjectResult(
      Point(x: 3429824.9011676833, y: 5977306.903604053),
      Point(x: 17.888058560281515, y: 46.89226406700878)),
  'EPSG:3040': ProjectAndUnProjectResult(
      Point(x: 2988897.836886672, y: 5744008.821518749),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:3041': ProjectAndUnProjectResult(
      Point(x: 2540720.0453096954, y: 5555690.29353334),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:9014': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3051': ProjectAndUnProjectResult(
      Point(x: -2005502.5012535215, y: 5751885.308795742),
      Point(x: 17.888058560281532, y: 46.892264067008796)),
  'EPSG:3054': ProjectAndUnProjectResult(
      Point(x: 3859296.292803111, y: 6259243.469569638),
      Point(x: 17.888058545916724, y: 46.8922640828569)),
  'EPSG:3055': ProjectAndUnProjectResult(
      Point(x: 3429838.353884564, y: 5977509.700756289),
      Point(x: 17.888058545916728, y: 46.89226408285691)),
  'EPSG:3056': ProjectAndUnProjectResult(
      Point(x: 2988900.197977467, y: 5744209.040379982),
      Point(x: 17.88805854591672, y: 46.89226408285691)),
  'EPSG:3057': ProjectAndUnProjectResult(
      Point(x: 3270199.377220549, y: -713939.791333823),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3058': ProjectAndUnProjectResult(
      Point(x: 2054060.1313930212, y: -2255423.451762745),
      Point(x: 17.883990728740315, y: 46.89261711237233)),
  'EPSG:3059': ProjectAndUnProjectResult(
      Point(x: 34461.49600235146, y: -788646.7322226427),
      Point(x: 17.888058563129825, y: 46.89226406242482)),
  'EPSG:3060': ProjectAndUnProjectResult(
      Point(x: -1989424.087303055, y: 24252478.276800938),
      Point(x: 17.888058785902032, y: 46.89226397500273)),
  'EPSG:3061': ProjectAndUnProjectResult(
      Point(x: 2989336.47087043, y: 5743658.875522178),
      Point(x: 17.8880585688826, y: 46.8922640285063)),
  'EPSG:3062': ProjectAndUnProjectResult(
      Point(x: 3859288.000875412, y: 6259004.508158689),
      Point(x: 17.888058504245315, y: 46.892264055760975)),
  'EPSG:3063': ProjectAndUnProjectResult(
      Point(x: 3859200.2925158725, y: 6259135.276764582),
      Point(x: 17.888058505169, y: 46.892264083003866)),
  'EPSG:3064': ProjectAndUnProjectResult(
      Point(x: 1176891.2861509859, y: 5231671.833948568),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:3065': ProjectAndUnProjectResult(
      Point(x: 720001.2298363654, y: 5197241.610092757),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3066': ProjectAndUnProjectResult(
      Point(x: -953959.9291653531, y: 2374702.880146075),
      Point(x: 17.888231299026007, y: 46.892271822834914)),
  'EPSG:3067': ProjectAndUnProjectResult(
      Point(x: -193931.34632474044, y: 5233642.279699988),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:3068': ProjectAndUnProjectResult(
      Point(x: 364675.4295521466, y: -595679.8432950808),
      Point(x: 17.888042957094218, y: 46.8922646247367)),
  'EPSG:3069': ProjectAndUnProjectResult(
      Point(x: 3819244.9687302676, y: 7332769.1263250355), Point(x: 0, y: 90)),
  'EPSG:3070': ProjectAndUnProjectResult(
      Point(x: 3839622.300083163, y: 7353217.56768338), Point(x: 0, y: 90)),
  'EPSG:3071': ProjectAndUnProjectResult(
      Point(x: 3839622.300083163, y: 7353217.56768338), Point(x: 0, y: 90)),
  'EPSG:3072': ProjectAndUnProjectResult(
      Point(x: 5841926.85039724, y: 4779293.471123142),
      Point(x: -856956604.9425999, y: 188140569.70074788)),
  'EPSG:3073': ProjectAndUnProjectResult(
      Point(x: 5625524.243963247, y: 5008333.052615764),
      Point(x: -21737319794.916904, y: 4757338589.639994)),
  'EPSG:3074': ProjectAndUnProjectResult(
      Point(x: 5401485.579875652, y: 5163842.641810937),
      Point(x: -11503948981851.02, y: 2505985965549.347)),
  'EPSG:3075': ProjectAndUnProjectResult(
      Point(x: 5841926.85039724, y: 4779293.471123142),
      Point(x: -856956604.9425999, y: 188140569.70074788)),
  'EPSG:3076': ProjectAndUnProjectResult(
      Point(x: 5625524.243963247, y: 5008333.052615764),
      Point(x: -21737319794.916904, y: 4757338589.639994)),
  'EPSG:3077': ProjectAndUnProjectResult(
      Point(x: 5401485.579875652, y: 5163842.641810937),
      Point(x: -11503948981851.02, y: 2505985965549.347)),
  'EPSG:3078': ProjectAndUnProjectResult(
      Point(x: 8386430.7898983145, y: 2796245.837725366),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3079': ProjectAndUnProjectResult(
      Point(x: 8386430.7898983145, y: 2796245.837725366),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3080': ProjectAndUnProjectResult(
      Point(x: 28148468.047498412, y: 23622097.92894205),
      Point(x: 17.888058560281525, y: 46.89226404782303)),
  'EPSG:3081': ProjectAndUnProjectResult(
      Point(x: 8665245.955593321, y: 7285398.725447465),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:3082': ProjectAndUnProjectResult(
      Point(x: 9154307.075487461, y: 12759946.896370977),
      Point(x: 17.88805856028155, y: 46.892264067008725)),
  'EPSG:3083': ProjectAndUnProjectResult(
      Point(x: 9202342.771606717, y: 13714424.334539425),
      Point(x: 17.88805856028155, y: 46.89226406700876)),
  'EPSG:3084': ProjectAndUnProjectResult(
      Point(x: 9154307.075487461, y: 12759946.896370977),
      Point(x: 17.88805856028155, y: 46.892264067008725)),
  'EPSG:3085': ProjectAndUnProjectResult(
      Point(x: 9202342.771606717, y: 13714424.334539425),
      Point(x: 17.88805856028155, y: 46.89226406700876)),
  'EPSG:3086': ProjectAndUnProjectResult(
      Point(x: 7788718.898020689, y: 5738991.145189423),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:3087': ProjectAndUnProjectResult(
      Point(x: 7788718.898020689, y: 5738991.145189423),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:3088': ProjectAndUnProjectResult(
      Point(x: 7954314.818287251, y: 6181092.986200401),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3089': ProjectAndUnProjectResult(
      Point(x: 26096781.19966409, y: 20279135.905225817),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3099': ProjectAndUnProjectResult(
      Point(x: -4009686.094082634, y: 12571384.874783527),
      Point(x: 17.88805856028154, y: 46.892264067008796)),
  'EPSG:3090': ProjectAndUnProjectResult(
      Point(x: 7954314.818287251, y: 6181092.986200401),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3091': ProjectAndUnProjectResult(
      Point(x: 26096781.19966409, y: 20279135.905225817),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3092': ProjectAndUnProjectResult(
      Point(x: -4558583.196725136, y: 11524614.8764092),
      Point(x: 17.88805877319241, y: 46.89226421108508)),
  'EPSG:3093': ProjectAndUnProjectResult(
      Point(x: -4313888.879981974, y: 12072564.673794623),
      Point(x: 17.88805877319251, y: 46.89226421108505)),
  'EPSG:3094': ProjectAndUnProjectResult(
      Point(x: -4009295.661016194, y: 12570887.991396926),
      Point(x: 17.888058773192498, y: 46.892264211085)),
  'EPSG:3095': ProjectAndUnProjectResult(
      Point(x: -3657668.097423616, y: 13014692.43950213),
      Point(x: 17.888058773192473, y: 46.89226421108498)),
  'EPSG:3096': ProjectAndUnProjectResult(
      Point(x: -3270822.4973803293, y: 13402701.523787498),
      Point(x: 17.888058773192473, y: 46.89226421108498)),
  'EPSG:3097': ProjectAndUnProjectResult(
      Point(x: -4558786.502469642, y: 11525007.658234945),
      Point(x: 17.888058560281475, y: 46.89226406700889)),
  'EPSG:3098': ProjectAndUnProjectResult(
      Point(x: -4314192.978437341, y: 12073000.736830102),
      Point(x: 17.88805856028155, y: 46.89226406700883)),
  'EPSG:4372': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3100': ProjectAndUnProjectResult(
      Point(x: -3658127.571879782, y: 13015261.604972484),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:3101': ProjectAndUnProjectResult(
      Point(x: -3271333.3919436852, y: 13403348.660882948),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:3102': ProjectAndUnProjectResult(
      Point(x: -73643801.66334432, y: -844631.8760123086),
      Point(x: 17.888058498506634, y: 46.892264036184514)),
  'EPSG:3103': ProjectAndUnProjectResult(
      Point(x: 2989016.1173230456, y: 5743724.840412613),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3104': ProjectAndUnProjectResult(
      Point(x: 2540816.7780718436, y: 5555395.965894984),
      Point(x: 17.888058560281532, y: 46.89226406700878)),
  'EPSG:3105': ProjectAndUnProjectResult(
      Point(x: 2088261.0114847391, y: 5408891.435744324),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:3106': ProjectAndUnProjectResult(
      Point(x: -4426383.991075835, y: 8231328.301935496),
      Point(x: 45, y: double.nan)),
  'EPSG:3107': ProjectAndUnProjectResult(
      Point(x: -19053509.31088796, y: 2429151.340795912),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3108': ProjectAndUnProjectResult(
      Point(x: 1591648.0571654972, y: -35997.282725631696),
      Point(x: 17.88774938384045, y: 46.89228072495099)),
  'EPSG:3575': ProjectAndUnProjectResult(
      Point(x: 644243.1674465525, y: -4649928.687737088),
      Point(x: 17.88805856028151, y: 46.89226406911223)),
  'EPSG:3109': ProjectAndUnProjectResult(
      Point(x: 1563317.4333017708, y: 8866.23042817536),
      Point(x: 17.887788309575704, y: 46.89227809050608)),
  'EPSG:3110': ProjectAndUnProjectResult(
      Point(x: -19287915.88389734, y: 1257475.2044985937),
      Point(x: 17.888058560873176, y: 46.89226405813341)),
  'EPSG:3111': ProjectAndUnProjectResult(
      Point(x: -19288382.890973657, y: -742437.3449551277),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:3112': ProjectAndUnProjectResult(
      Point(x: -18704187.61509478, y: -1254790.7080928627),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3113': ProjectAndUnProjectResult(
      Point(x: 7793785.573916676, y: 12769791.385874765),
      Point(x: -4967267525.63053, y: 1643558557.1708627)),
  'EPSG:3114': ProjectAndUnProjectResult(
      Point(x: 5602973.338735154, y: 11446759.200280566), Point(x: 0, y: 90)),
  'EPSG:3115': ProjectAndUnProjectResult(
      Point(x: 5823190.1736905165, y: 11131197.294986518), Point(x: 0, y: 90)),
  'EPSG:3116': ProjectAndUnProjectResult(
      Point(x: 5981235.610502521, y: 10806121.017854199), Point(x: 0, y: 90)),
  'EPSG:3117': ProjectAndUnProjectResult(
      Point(x: 828646.8766494016, y: 913215.0489469176),
      Point(
          x: -72.61999999999692,
          y: 3.809999999999964)), // cannot represent as 64 bit double without overflow, therefore used Point(x: -72.62, y: 3.81)
  'EPSG:3118': ProjectAndUnProjectResult(
      Point(x: 6139873.062745825, y: 10148520.923470223),
      Point(x: -1319338140.740411, y: 289535161.569949)),
  'EPSG:3119': ProjectAndUnProjectResult(
      Point(x: 1562499.0954302107, y: 6216696.097143596),
      Point(x: 17.88805853282264, y: 46.892264054463574)),
  'EPSG:3120': ProjectAndUnProjectResult(
      Point(x: 4393448.659624081, y: 5056980.26449201),
      Point(x: 17.888058572338835, y: 46.89226406879691)),
  'EPSG:3121': ProjectAndUnProjectResult(
      Point(x: -3999952.4295648923, y: 11070865.301464126),
      Point(x: 49.31246603655868, y: 89.99967755776827)),
  'EPSG:3122': ProjectAndUnProjectResult(
      Point(x: -3795425.8148139464, y: 11267554.54350462),
      Point(x: 49.31246603655868, y: 89.99967755776827)),
  'EPSG:3123': ProjectAndUnProjectResult(
      Point(x: -3555338.8268887005, y: 11453401.630602693),
      Point(x: 49.31246603655868, y: 89.99967755776827)),
  'EPSG:3124': ProjectAndUnProjectResult(
      Point(x: -3276732.630196556, y: 11625703.487254022),
      Point(x: 49.31246603655868, y: 89.99967755776827)),
  'EPSG:3125': ProjectAndUnProjectResult(
      Point(x: -2956448.8089276785, y: 11781450.763102124),
      Point(x: 49.31246603655868, y: 89.99967755776827)),
  'EPSG:3126': ProjectAndUnProjectResult(
      Point(x: 415260.6822780034, y: 5195870.378755134),
      Point(x: 17.888058560281344, y: 46.892264067008604)),
  'EPSG:3127': ProjectAndUnProjectResult(
      Point(x: 339053.9538040216, y: 5197436.0837356355),
      Point(x: 17.888058560277017, y: 46.892264067000774)),
  'EPSG:3128': ProjectAndUnProjectResult(
      Point(x: 262850.42813212634, y: 5199974.092247936),
      Point(x: 17.888058560253082, y: 46.89226406692702)),
  'EPSG:3129': ProjectAndUnProjectResult(
      Point(x: 186651.6820958571, y: 5203485.806494309),
      Point(x: 17.888058560226206, y: 46.892264066575265)),
  'EPSG:3130': ProjectAndUnProjectResult(
      Point(x: 110459.36197448388, y: 5207973.165191365),
      Point(x: 17.888058560563294, y: 46.89226406541965)),
  'EPSG:3131': ProjectAndUnProjectResult(
      Point(x: 34275.2060847854, y: 5213438.643234651),
      Point(x: 17.888058563129828, y: 46.892264062424815)),
  'EPSG:3132': ProjectAndUnProjectResult(
      Point(x: -41898.93239802774, y: 5219885.251244588),
      Point(x: 17.888058574348563, y: 46.89226405586626)),
  'EPSG:3133': ProjectAndUnProjectResult(
      Point(x: -118061.06233451399, y: 5227316.534974944),
      Point(x: 17.888058612001338, y: 46.89226404327183)),
  'EPSG:3134': ProjectAndUnProjectResult(
      Point(x: -194209.03117459663, y: 5235736.574560914),
      Point(x: 17.88805871864152, y: 46.892264021677924)),
  'EPSG:3135': ProjectAndUnProjectResult(
      Point(x: -270340.5011148328, y: 5245149.983579845),
      Point(x: 17.8880589858763, y: 46.89226398852624)),
  'EPSG:3136': ProjectAndUnProjectResult(
      Point(x: -346452.9248036217, y: 5255561.907893532),
      Point(x: 17.888059595624604, y: 46.892263943722426)),
  'EPSG:4374': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3137': ProjectAndUnProjectResult(
      Point(x: -422543.52053862845, y: 5266978.024236943),
      Point(x: 17.88806088688771, y: 46.892263893655276)),
  'EPSG:3138': ProjectAndUnProjectResult(
      Point(x: -498609.24690069736, y: 5279404.538514145),
      Point(x: 17.88806345975466, y: 46.892263858362384)),
  'EPSG:3140': ProjectAndUnProjectResult(
      Point(x: -14251991.518381068, y: 34443234.6911829),
      Point(x: -135, y: double.nan)),
  'EPSG:3141': ProjectAndUnProjectResult(
      Point(x: -1087841.0608252329, y: 24586859.49951018),
      Point(x: 17.888058376658513, y: 46.89226428606031)),
  'EPSG:3142': ProjectAndUnProjectResult(
      Point(x: -632859.1599655428, y: 24694166.368345447),
      Point(x: 17.88805837665849, y: 46.89226428606031)),
  'EPSG:3143': ProjectAndUnProjectResult(
      Point(x: 41534995.48338613, y: -8759166.666704135), Point(x: 0, y: -90)),
  'EPSG:3146': ProjectAndUnProjectResult(
      Point(x: 6491595.854716621, y: 5195415.255041711),
      Point(x: 17.888058570172564, y: 46.8922640684501)),
  'EPSG:3147': ProjectAndUnProjectResult(
      Point(x: 491595.85471662134, y: 5195415.255041711),
      Point(x: 17.888058570172564, y: 46.8922640684501)),
  'EPSG:3148': ProjectAndUnProjectResult(
      Point(x: -4821879.856401356, y: 9697261.334537376),
      Point(x: 17.888058908121934, y: 46.89226408697088)),
  'EPSG:3149': ProjectAndUnProjectResult(
      Point(x: -4820064.463325119, y: 10321611.617193418),
      Point(x: 17.88805890812168, y: 46.892264086970876)),
  'EPSG:3150': ProjectAndUnProjectResult(
      Point(x: 6491598.327011086, y: 5195408.12931237),
      Point(x: 17.88805857029885, y: 46.8922640691192)),
  'EPSG:3151': ProjectAndUnProjectResult(
      Point(x: 491598.32701108593, y: 5195408.12931237),
      Point(x: 17.88805857029885, y: 46.8922640691192)),
  'EPSG:3152': ProjectAndUnProjectResult(
      Point(x: 87243.23643798723, y: -1305360.6412097253),
      Point(x: 17.888058560281515, y: 46.892264067008774)),
  'EPSG:3153': ProjectAndUnProjectResult(
      Point(x: 5852641.094495805, y: 8044112.188266415),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:3154': ProjectAndUnProjectResult(
      Point(x: 2105125.3251090776, y: 14581988.281413767),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:3155': ProjectAndUnProjectResult(
      Point(x: 2557536.036411387, y: 14433982.116084043),
      Point(x: 17.88805856028154, y: 46.892264067008774)),
  'EPSG:3156': ProjectAndUnProjectResult(
      Point(x: 3005502.501253523, y: 14244044.5770818),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:3157': ProjectAndUnProjectResult(
      Point(x: 3446086.561687547, y: 14009002.219252983),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:3158': ProjectAndUnProjectResult(
      Point(x: 5021971.586011266, y: 12553749.126989897),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:3159': ProjectAndUnProjectResult(
      Point(x: 5324476.5639229575, y: 12053400.324134082),
      Point(x: 17.88805856028146, y: 46.89226406700884)),
  'EPSG:3160': ProjectAndUnProjectResult(
      Point(x: 5566585.223791351, y: 11503707.444009647),
      Point(x: 17.888058560281575, y: 46.892264067008874)),
  'EPSG:3161': ProjectAndUnProjectResult(
      Point(x: 6564186.411249067, y: 16793420.77755385),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3162': ProjectAndUnProjectResult(
      Point(x: 6564186.411249067, y: 16793420.77755385),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3163': ProjectAndUnProjectResult(
      Point(x: -20823545.932266816, y: -637843.0603015926),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3164': ProjectAndUnProjectResult(
      Point(x: -1988875.1927683, y: 24251955.39763535),
      Point(x: 17.888058563625428, y: 46.89226406840758)),
  'EPSG:3165': ProjectAndUnProjectResult(
      Point(x: -21380462.210016996, y: -1321687.6461589648),
      Point(x: 17.888058787489044, y: 46.89226397545256)),
  'EPSG:3166': ProjectAndUnProjectResult(
      Point(x: -21380465.884373542, y: -1321714.4450936352),
      Point(x: 17.888058787489044, y: 46.89226397545256)),
  'EPSG:3167': ProjectAndUnProjectResult(
      Point(x: -302278.21199383383, y: 346453.43067258224),
      Point(x: 17.888058560281486, y: 46.892264066990926)),
  'EPSG:3178': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 10298556.41432563),
      Point(x: 17.88805856028164, y: 46.892264067008654)),
  'EPSG:3168': ProjectAndUnProjectResult(
      Point(x: -5316186.7947962275, y: 6969519.130203253),
      Point(x: 17.888058560281525, y: 46.892264066990926)),
  'EPSG:3169': ProjectAndUnProjectResult(
      Point(x: -2429824.9011676833, y: 24018622.98227349),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:3170': ProjectAndUnProjectResult(
      Point(x: -1988897.8368866723, y: 24251921.064358793),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:3171': ProjectAndUnProjectResult(
      Point(x: -1540720.0453096956, y: 24440239.592344202),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:3172': ProjectAndUnProjectResult(
      Point(x: -1540581.8567567107, y: 24440379.619964402),
      Point(x: 17.888058505847603, y: 46.892264263033205)),
  'EPSG:3174': ProjectAndUnProjectResult(
      Point(x: 6847270.573878591, y: 5470326.95949224),
      Point(x: 17.8880585602815, y: 46.89226406700877)),
  'EPSG:3175': ProjectAndUnProjectResult(
      Point(x: 6819680.24281576, y: 5382704.742806314),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:3176': ProjectAndUnProjectResult(
      Point(x: -4602041.108342849, y: 9887504.204212872),
      Point(x: 45, y: double.nan)),
  'EPSG:3177': ProjectAndUnProjectResult(
      Point(x: 1067485.2187028376, y: 5177491.749015629),
      Point(x: 17.888058563770656, y: 46.892264062483235)),
  'EPSG:7664': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3179': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 9674131.646974),
      Point(x: 17.888058560281358, y: 46.892264067008654)),
  'EPSG:3180': ProjectAndUnProjectResult(
      Point(x: 5731020.405467821, y: 9059228.545130335),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:3181': ProjectAndUnProjectResult(
      Point(x: 5558786.502469642, y: 8470922.227642598),
      Point(x: 17.88805856028146, y: 46.89226406700888)),
  'EPSG:3182': ProjectAndUnProjectResult(
      Point(x: 5314192.97843734, y: 7922929.14904744),
      Point(x: 17.88805856028157, y: 46.89226406700883)),
  'EPSG:3183': ProjectAndUnProjectResult(
      Point(x: 5009686.094082634, y: 7424545.011094015),
      Point(x: 17.888058560281564, y: 46.89226406700879)),
  'EPSG:3184': ProjectAndUnProjectResult(
      Point(x: 4658127.571879782, y: 6980668.280905059),
      Point(x: 17.888058560281525, y: 46.89226406700877)),
  'EPSG:3185': ProjectAndUnProjectResult(
      Point(x: 4271333.391943685, y: 6592581.224994595),
      Point(x: 17.888058560281507, y: 46.892264067008774)),
  'EPSG:3186': ProjectAndUnProjectResult(
      Point(x: 3859272.60100763, y: 6259037.26365852),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:3187': ProjectAndUnProjectResult(
      Point(x: 3429824.9011676833, y: 5977306.903604053),
      Point(x: 17.888058560281515, y: 46.89226406700878)),
  'EPSG:3188': ProjectAndUnProjectResult(
      Point(x: 2988897.836886672, y: 5744008.821518749),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:4376': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3189': ProjectAndUnProjectResult(
      Point(x: 2540720.0453096954, y: 5555690.29353334),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:3190': ProjectAndUnProjectResult(
      Point(x: 877209.3222541497, y: 5233533.337462733),
      Point(x: 17.88805843897405, y: 46.8922640227178)),
  'EPSG:3191': ProjectAndUnProjectResult(
      Point(x: 724891.4800218983, y: 5218123.515214661),
      Point(x: 17.888058553630767, y: 46.89226405318974)),
  'EPSG:3192': ProjectAndUnProjectResult(
      Point(x: 572527.2977369023, y: 5206649.574759262),
      Point(x: 17.88805856365352, y: 46.892264061260164)),
  'EPSG:3193': ProjectAndUnProjectResult(
      Point(x: 420131.9517814456, y: 5199086.2463922445),
      Point(x: 17.88805856379132, y: 46.89226406243074)),
  'EPSG:3194': ProjectAndUnProjectResult(
      Point(x: 267718.86045348976, y: 5195416.833344885),
      Point(x: 17.888058563770656, y: 46.892264062483235)),
  'EPSG:3195': ProjectAndUnProjectResult(
      Point(x: 115300.40990425537, y: 5195633.223828336),
      Point(x: 17.88805856377042, y: 46.89226406248311)),
  'EPSG:3196': ProjectAndUnProjectResult(
      Point(x: -37111.330227248225, y: 5199735.896408298),
      Point(x: 17.88805856374189, y: 46.89226406240126)),
  'EPSG:3197': ProjectAndUnProjectResult(
      Point(x: -189503.8943491241, y: 5207733.9196965825),
      Point(x: 17.88805856404742, y: 46.89226406088829)),
  'EPSG:4378': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3198': ProjectAndUnProjectResult(
      Point(x: -341863.70448730537, y: 5219644.946301369),
      Point(x: 17.888058577796404, y: 46.89226405129616)),
  'EPSG:3199': ProjectAndUnProjectResult(
      Point(x: 1176972.2860701587, y: 5231701.509011503),
      Point(x: 17.888058563770592, y: 46.89226406248328)),
  'EPSG:3200': ProjectAndUnProjectResult(
      Point(x: -611620.1160348374, y: 3049714.398032699),
      Point(x: 17.88805856427966, y: 46.89226406274768)),
  'EPSG:3201': ProjectAndUnProjectResult(
      Point(x: 720054.9017440092, y: 5197266.475216404),
      Point(x: 17.888058563770606, y: 46.89226406248328)),
  'EPSG:3202': ProjectAndUnProjectResult(
      Point(x: 262971.6628906729, y: 5197915.897843541),
      Point(x: 17.888058563770603, y: 46.89226406248328)),
  'EPSG:3203': ProjectAndUnProjectResult(
      Point(x: -193932.36799514596, y: 5233662.6847553775),
      Point(x: 17.888058563770596, y: 46.89226406248328)),
  'EPSG:3204': ProjectAndUnProjectResult(
      Point(x: 25066432.253421612, y: 7151955.946894791),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3205': ProjectAndUnProjectResult(
      Point(x: 23323815.20985978, y: 11639421.971816815),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3206': ProjectAndUnProjectResult(
      Point(x: 20785721.617491703, y: 15729916.612043316),
      Point(x: 17.888058560281518, y: 46.89226406700873)),
  'EPSG:4380': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3207': ProjectAndUnProjectResult(
      Point(x: -12052973.866507681, y: -24271874.65087082),
      Point(x: 17.888058560281486, y: 46.89226406700873)),
  'EPSG:3208': ProjectAndUnProjectResult(
      Point(x: 26366664.576902073, y: 6260756.917772714),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3209': ProjectAndUnProjectResult(
      Point(x: 24694733.172770705, y: 11161013.915409265),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3210': ProjectAndUnProjectResult(
      Point(x: -10164627.588845657, y: 25121274.33221449),
      Point(x: 17.888058560281518, y: 46.89226406700873)),
  'EPSG:3211': ProjectAndUnProjectResult(
      Point(x: -14756779.039045539, y: 22729618.353309125),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3212': ProjectAndUnProjectResult(
      Point(x: -18810260.96647724, y: 19508258.775896005),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3213': ProjectAndUnProjectResult(
      Point(x: -22177108.346414044, y: 15574785.50368234),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3214': ProjectAndUnProjectResult(
      Point(x: -24734420.506115302, y: 11072782.862540206),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3215': ProjectAndUnProjectResult(
      Point(x: -26388847.39154885, y: 6166588.314444775),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:9017': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3216': ProjectAndUnProjectResult(
      Point(x: -27079997.14223665, y: 1035293.6157229327),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3217': ProjectAndUnProjectResult(
      Point(x: -26782640.58686839, y: -4133792.6035218327),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:3218': ProjectAndUnProjectResult(
      Point(x: -25507632.188558858, y: -9151982.20209688),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3219': ProjectAndUnProjectResult(
      Point(x: -23301513.822308376, y: -13836095.246964507),
      Point(x: 17.88805856028146, y: 46.89226406700873)),
  'EPSG:3220': ProjectAndUnProjectResult(
      Point(x: -20244815.848053504, y: -18015146.66531206),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3221': ProjectAndUnProjectResult(
      Point(x: 25990281.16802446, y: -10854991.565167855),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3222': ProjectAndUnProjectResult(
      Point(x: 27611245.951654006, y: -5562791.93122503),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3223': ProjectAndUnProjectResult(
      Point(x: 28165980.28820513, y: -55780.617352245325),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3224': ProjectAndUnProjectResult(
      Point(x: 27633062.66556257, y: 5453384.7098773355),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3225': ProjectAndUnProjectResult(
      Point(x: 15638727.285663286, y: 23425536.6204807),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3226': ProjectAndUnProjectResult(
      Point(x: 10755720.571876656, y: 26031519.971998196),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3227': ProjectAndUnProjectResult(
      Point(x: 5457373.066367603, y: 27632275.264395382),
      Point(x: 17.888058560281518, y: 46.89226406700871)),
  'EPSG:3228': ProjectAndUnProjectResult(
      Point(x: -51715.284904636, y: 28165988.04590634),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:3229': ProjectAndUnProjectResult(
      Point(x: -5558806.608898887, y: 27612048.568653747),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3230': ProjectAndUnProjectResult(
      Point(x: -10851240.149386862, y: 25991847.65062242),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:3231': ProjectAndUnProjectResult(
      Point(x: -15724644.332920264, y: 23367950.65203601),
      Point(x: 17.888058560281518, y: 46.892264067008725)),
  'EPSG:3232': ProjectAndUnProjectResult(
      Point(x: -19990828.74134481, y: 19841681.46370297),
      Point(x: 17.888058560281518, y: 46.892264067008725)),
  'EPSG:3233': ProjectAndUnProjectResult(
      Point(x: -23485051.23600155, y: 15549209.803562805),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:9019': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3234': ProjectAndUnProjectResult(
      Point(x: -26072379.607775677, y: 10656292.913620332),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3235': ProjectAndUnProjectResult(
      Point(x: -27652902.09276468, y: 5351874.710865592),
      Point(x: 17.8880585602815, y: 46.892264067008725)),
  'EPSG:3236': ProjectAndUnProjectResult(
      Point(x: -28165585.545317043, y: -159210.43389043925),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3237': ProjectAndUnProjectResult(
      Point(x: -27590632.281989515, y: -5664147.539821861),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3238': ProjectAndUnProjectResult(
      Point(x: -25950244.585000012, y: -10950359.03756172),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3239': ProjectAndUnProjectResult(
      Point(x: -23307767.34326102, y: -15813713.622841641),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3240': ProjectAndUnProjectResult(
      Point(x: -19765241.938598897, y: -20066408.950818367),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3241': ProjectAndUnProjectResult(
      Point(x: -15459465.835807992, y: -23544223.77451246),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:3242': ProjectAndUnProjectResult(
      Point(x: 7915976.904349618, y: -28130001.131981343),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3243': ProjectAndUnProjectResult(
      Point(x: 15924849.697899364, y: -24502220.63680724),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3244': ProjectAndUnProjectResult(
      Point(x: 22492160.213056713, y: -18656430.070773367),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3245': ProjectAndUnProjectResult(
      Point(x: 27023416.992210645, y: -11121806.872112503),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3246': ProjectAndUnProjectResult(
      Point(x: 29108437.900493056, y: -2580406.3688898585),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3247': ProjectAndUnProjectResult(
      Point(x: 28558480.96871375, y: 6194579.791647082),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3248': ProjectAndUnProjectResult(
      Point(x: 19986787.255225956, y: 21318723.912321888),
      Point(x: 17.888058560281507, y: 46.892264067008725)),
  'EPSG:3249': ProjectAndUnProjectResult(
      Point(x: 12740984.347538726, y: 26298801.719683748),
      Point(x: 17.888058560281518, y: 46.89226406700872)),
  'EPSG:3250': ProjectAndUnProjectResult(
      Point(x: 4341831.6266081985, y: 28898237.872950878),
      Point(x: 17.888058560281518, y: 46.892264067008725)),
  'EPSG:3251': ProjectAndUnProjectResult(
      Point(x: -4450355.930492564, y: 28881724.085092243),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:3252': ProjectAndUnProjectResult(
      Point(x: -12839684.7255628, y: 26250755.23072845),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:3253': ProjectAndUnProjectResult(
      Point(x: -20066729.070986774, y: 21243494.025867827),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3254': ProjectAndUnProjectResult(
      Point(x: -25477276.543396596, y: 14313211.867598465),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3255': ProjectAndUnProjectResult(
      Point(x: -28581549.136114668, y: 6087257.429691194),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3256': ProjectAndUnProjectResult(
      Point(x: -29098539.344743643, y: -2689732.707514648),
      Point(x: 17.8880585602815, y: 46.89226406700872)),
  'EPSG:3257': ProjectAndUnProjectResult(
      Point(x: -26981447.758476138, y: -11223240.659100695),
      Point(x: 17.888058560281486, y: 46.892264067008725)),
  'EPSG:3258': ProjectAndUnProjectResult(
      Point(x: -22421919.474663854, y: -18740789.23383852),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3259': ProjectAndUnProjectResult(
      Point(x: -15832695.844459012, y: -24561868.74674479),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3260': ProjectAndUnProjectResult(
      Point(x: -5079505.619102587, y: -29787133.712741956),
      Point(x: 17.888058560281486, y: 46.892264067008725)),
  'EPSG:3261': ProjectAndUnProjectResult(
      Point(x: 11140937.19215027, y: -28088329.08230438),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3262': ProjectAndUnProjectResult(
      Point(x: 21408794.86977613, y: -21324591.77520429),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3263': ProjectAndUnProjectResult(
      Point(x: 28132015.648163404, y: -11030159.007319545),
      Point(x: 17.8880585602815, y: 46.892264067008725)),
  'EPSG:3264': ProjectAndUnProjectResult(
      Point(x: 30197441.285675492, y: 1090528.2909876592),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3265': ProjectAndUnProjectResult(
      Point(x: 27263100.925386924, y: 13030657.699726043),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3266': ProjectAndUnProjectResult(
      Point(x: 19814830.93404658, y: 22813311.623050563),
      Point(x: 17.888058560281518, y: 46.892264067008725)),
  'EPSG:3267': ProjectAndUnProjectResult(
      Point(x: 9085835.366688324, y: 28818783.94111554),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:3268': ProjectAndUnProjectResult(
      Point(x: -3147494.634115184, y: 30052753.445956983),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:3269': ProjectAndUnProjectResult(
      Point(x: -14859696.486972794, y: 26310912.8019214),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3270': ProjectAndUnProjectResult(
      Point(x: -24111590.377630733, y: 18212795.54644504),
      Point(x: 17.888058560281507, y: 46.892264067008725)),
  'EPSG:3271': ProjectAndUnProjectResult(
      Point(x: -29371347.69676528, y: 7099200.421947815),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3272': ProjectAndUnProjectResult(
      Point(x: -29768114.667325903, y: -5189803.590522423),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3273': ProjectAndUnProjectResult(
      Point(x: -25236198.902010895, y: -16619536.008367002),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3274': ProjectAndUnProjectResult(
      Point(x: -16525946.03884843, y: -25297585.25386036),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3275': ProjectAndUnProjectResult(
      Point(x: -1602117.1613092974, y: -31757249.151661653),
      Point(x: 17.888058560281486, y: 46.89226406700872)),
  'EPSG:3276': ProjectAndUnProjectResult(
      Point(x: 14491150.414297959, y: -28303643.100305457),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3277': ProjectAndUnProjectResult(
      Point(x: 26701525.93899615, y: -17266098.7373637),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3278': ProjectAndUnProjectResult(
      Point(x: 31757249.151661653, y: -1602117.1613093065),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3576': ProjectAndUnProjectResult(
      Point(x: -4467414.170635901, y: -1441907.3090332332),
      Point(x: 17.88805856028151, y: 46.89226406911223)),
  'EPSG:3279': ProjectAndUnProjectResult(
      Point(x: 28303643.100305457, y: 14491150.414297957),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3280': ProjectAndUnProjectResult(
      Point(x: 17266098.7373637, y: 26701525.938996155),
      Point(x: 17.888058560281515, y: 46.892264067008746)),
  'EPSG:3281': ProjectAndUnProjectResult(
      Point(x: 1602117.1613093081, y: 31757249.151661653),
      Point(x: 17.888058560281515, y: 46.89226406700872)),
  'EPSG:3282': ProjectAndUnProjectResult(
      Point(x: -14491150.414297955, y: 28303643.100305457),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3283': ProjectAndUnProjectResult(
      Point(x: -26701525.938996155, y: 17266098.737363696),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3284': ProjectAndUnProjectResult(
      Point(x: -31757249.151661653, y: 1602117.161309303),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3285': ProjectAndUnProjectResult(
      Point(x: -28303643.100305457, y: -14491150.414297955),
      Point(x: 17.888058560281486, y: 46.89226406700872)),
  'EPSG:3286': ProjectAndUnProjectResult(
      Point(x: -17266098.737363704, y: -26701525.93899615),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3287': ProjectAndUnProjectResult(
      Point(x: 6671854.5576663185, y: -31089805.56131903),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3288': ProjectAndUnProjectResult(
      Point(x: 30260488.693654157, y: -9766907.243365493),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'ESRI:37001': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3289': ProjectAndUnProjectResult(
      Point(x: 23588634.135987844, y: 21322898.317953534),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:3290': ProjectAndUnProjectResult(
      Point(x: -6671854.557666316, y: 31089805.56131903),
      Point(x: 17.888058560281515, y: 46.89226406700872)),
  'EPSG:3291': ProjectAndUnProjectResult(
      Point(x: -30260488.693654157, y: 9766907.243365496),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3292': ProjectAndUnProjectResult(
      Point(x: -23588634.13598784, y: -21322898.31795354),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3293': ProjectAndUnProjectResult(
      Point(x: 9766907.243365496, y: 30260488.693654157),
      Point(x: 17.888058560281515, y: 46.89226406700872)),
  'EPSG:3294': ProjectAndUnProjectResult(
      Point(x: -19026280.71559294, y: -24834579.9604708),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3296': ProjectAndUnProjectResult(
      Point(x: 1193931.0495865713, y: 24762287.351402655),
      Point(x: 17.888058560281397, y: 46.89226406700895)),
  'EPSG:3297': ProjectAndUnProjectResult(
      Point(x: 1650191.8620074247, y: 24690736.37538262),
      Point(x: 17.888058560281397, y: 46.89226406700895)),
  'EPSG:3298': ProjectAndUnProjectResult(
      Point(x: 2105124.9833497843, y: 24581988.07130737),
      Point(x: 17.888058560281394, y: 46.89226406700893)),
  'EPSG:3299': ProjectAndUnProjectResult(
      Point(x: 2557535.6712482763, y: 24433981.93141687),
      Point(x: 17.888058560281397, y: 46.892264067008966)),
  'EPSG:3300': ProjectAndUnProjectResult(
      Point(x: 25839.563645003887, y: 5205792.531377736),
      Point(x: 17.88805856028127, y: 46.89226406700888)),
  'EPSG:3301': ProjectAndUnProjectResult(
      Point(x: 25838.491262051102, y: 5205792.771843453),
      Point(x: 17.888058560281515, y: 46.89226406700873)),
  'EPSG:3302': ProjectAndUnProjectResult(
      Point(x: 2104964.7634724667, y: 24582183.724178776),
      Point(x: 17.88805865056877, y: 46.89226438035667)),
  'EPSG:3303': ProjectAndUnProjectResult(
      Point(x: 2105820.592348105, y: 24581081.673677363),
      Point(x: 17.888053645696136, y: 46.89225762930566)),
  'EPSG:3304': ProjectAndUnProjectResult(
      Point(x: 1650337.7136560117, y: 24691112.894064408),
      Point(x: 17.88805846545623, y: 46.89226420182663)),
  'EPSG:3305': ProjectAndUnProjectResult(
      Point(x: 1650352.2499668829, y: 24691115.3462587),
      Point(x: 17.888058467903075, y: 46.892264199301955)),
  'EPSG:3306': ProjectAndUnProjectResult(
      Point(x: 1193951.326781245, y: 24762584.264787637),
      Point(x: 17.888058547749687, y: 46.89226419828872)),
  'EPSG:3307': ProjectAndUnProjectResult(
      Point(x: -2005502.5933159986, y: 5751884.757919171),
      Point(x: 17.888058560281653, y: 46.89226406700846)),
  'EPSG:3308': ProjectAndUnProjectResult(
      Point(x: -12032145.999217626, y: 2197042.8317936016),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3309': ProjectAndUnProjectResult(
      Point(x: 7280996.841594052, y: 7461281.7510663625),
      Point(x: 17.88805856028151, y: 46.892264047823176)),
  'EPSG:3310': ProjectAndUnProjectResult(
      Point(x: 7281011.174753069, y: 7461253.495639747),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:3311': ProjectAndUnProjectResult(
      Point(x: 7281011.174753069, y: 7461253.495639747),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:3312': ProjectAndUnProjectResult(
      Point(x: 5558965.363814795, y: 8470807.715011522),
      Point(x: 17.888058441256042, y: 46.89226404873109)),
  'EPSG:3313': ProjectAndUnProjectResult(
      Point(x: 5558786.502469642, y: 8470922.227642598),
      Point(x: 17.88805856028146, y: 46.89226406700888)),
  'EPSG:3314': ProjectAndUnProjectResult(
      Point(x: -1055285.432354479, y: 6401037.133927785),
      Point(x: 17.888058574909916, y: 46.89226391727645)),
  'EPSG:3315': ProjectAndUnProjectResult(
      Point(x: -617944.0258468045, y: 6221382.2504441235),
      Point(x: 17.88805862648417, y: 46.89226389324595)),
  'EPSG:3316': ProjectAndUnProjectResult(
      Point(x: 186668.35845931835, y: 15202653.140376616),
      Point(x: 17.88805856022113, y: 46.89226406656813)),
  'EPSG:3317': ProjectAndUnProjectResult(
      Point(x: 34299.98048061441, y: 15212605.450192865),
      Point(x: 17.888058563081806, y: 46.89226406234798)),
  'EPSG:4579': ProjectAndUnProjectResult(
      Point(x: -3671576.176477474, y: 7001648.429185124),
      Point(x: 66.46975246309024, y: 55.68536132961957)),
  'EPSG:3318': ProjectAndUnProjectResult(
      Point(x: 948645.399786727, y: 15211296.767279921),
      Point(x: 17.888058558455615, y: 46.89226406327035)),
  'EPSG:3319': ProjectAndUnProjectResult(
      Point(x: 796273.4527514861, y: 15201782.287382953),
      Point(x: 17.88805856034174, y: 46.892264066693535)),
  'EPSG:3320': ProjectAndUnProjectResult(
      Point(x: 643877.2279745995, y: 15196168.793309873),
      Point(x: 17.88805856028415, y: 46.89226406700462)),
  'EPSG:3321': ProjectAndUnProjectResult(
      Point(x: 491469.53793772496, y: 15194443.882054033),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3322': ProjectAndUnProjectResult(
      Point(x: 339062.5217688145, y: 15196603.738995139),
      Point(x: 17.88805856027687, y: 46.89226406700063)),
  'EPSG:3323': ProjectAndUnProjectResult(
      Point(x: 186668.35845931835, y: 15202653.140376616),
      Point(x: 17.88805856022113, y: 46.89226406656813)),
  'EPSG:3324': ProjectAndUnProjectResult(
      Point(x: 34299.98048061441, y: 15212605.450192865),
      Point(x: 17.888058563081806, y: 46.89226406234798)),
  'EPSG:3325': ProjectAndUnProjectResult(
      Point(x: -118028.20506760466, y: 15226482.610905588),
      Point(x: 17.888058611739464, y: 46.892264042852446)),
  'EPSG:3326': ProjectAndUnProjectResult(
      Point(x: -270299.5806442528, y: 15244315.126363747),
      Point(x: 17.88805898484117, y: 46.89226398695581)),
  'EPSG:3345': ProjectAndUnProjectResult(
      Point(x: 2088186.0339291478, y: 5409193.447385448),
      Point(x: 17.888058560281504, y: 46.89226406700878)),
  'EPSG:3327': ProjectAndUnProjectResult(
      Point(x: -422494.56065634754, y: 15266142.034256946),
      Point(x: 17.8880608835956, y: 46.89226388902985)),
  'EPSG:3328': ProjectAndUnProjectResult(
      Point(x: 402506.7856733964, y: -86004.79593155836),
      Point(x: 17.888058572338835, y: 46.89226406879691)),
  'EPSG:3329': ProjectAndUnProjectResult(
      Point(x: 5720215.259152802, y: 5199459.086602302),
      Point(x: 17.88805857235939, y: 46.89226406874446)),
  'EPSG:3330': ProjectAndUnProjectResult(
      Point(x: 6491592.8664638065, y: 5195409.057455721),
      Point(x: 17.888058572338835, y: 46.892264068796905)),
  'EPSG:3331': ProjectAndUnProjectResult(
      Point(x: 7262971.978117633, y: 5200102.372851052),
      Point(x: 17.888058572310474, y: 46.8922640687154)),
  'EPSG:3332': ProjectAndUnProjectResult(
      Point(x: 8034394.508663201, y: 5213562.372602202),
      Point(x: 17.88805857517946, y: 46.892264064220754)),
  'EPSG:3333': ProjectAndUnProjectResult(
      Point(x: 3720215.2591528012, y: 5199459.086602302),
      Point(x: 17.888058572359384, y: 46.89226406874446)),
  'EPSG:3334': ProjectAndUnProjectResult(
      Point(x: 4262971.978117633, y: 5200102.372851052),
      Point(x: 17.888058572310474, y: 46.8922640687154)),
  'EPSG:3335': ProjectAndUnProjectResult(
      Point(x: 4805908.013583425, y: 5235855.842461305),
      Point(x: 17.888058730440267, y: 46.89226402351891)),
  'EPSG:4382': ProjectAndUnProjectResult(
      Point(x: 4155553.9165052753, y: 1341250.964523339),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3336': ProjectAndUnProjectResult(
      Point(x: -3286195.2284794194, y: 16606131.706282284),
      Point(x: 17.888058712257504, y: 46.89226410440332)),
  'EPSG:3337': ProjectAndUnProjectResult(
      Point(x: -5387483.085416729, y: 9887088.364511847),
      Point(x: 17.888059280157233, y: 46.892263824466866)),
  'EPSG:3338': ProjectAndUnProjectResult(
      Point(x: 2704046.3736966117, y: 9181485.899239805),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3339': ProjectAndUnProjectResult(
      Point(x: 948743.0646029569, y: 15211679.335447896),
      Point(x: 17.888058485511483, y: 46.892263914447966)),
  'EPSG:3340': ProjectAndUnProjectResult(
      Point(x: 796380.7187252674, y: 15202161.704129413),
      Point(x: 17.88805848740466, y: 46.892263917876996)),
  'EPSG:3341': ProjectAndUnProjectResult(
      Point(x: 643994.0431557528, y: 15196545.039603058),
      Point(x: 17.88805848734709, y: 46.89226391818892)),
  'EPSG:3342': ProjectAndUnProjectResult(
      Point(x: 720123.5323359974, y: 15197306.911670068),
      Point(x: 17.888058487344455, y: 46.8922639181931)),
  'EPSG:3343': ProjectAndUnProjectResult(
      Point(x: 2988897.836886672, y: 5744008.821518749),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:3344': ProjectAndUnProjectResult(
      Point(x: 2540720.0453096954, y: 5555690.29353334),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:4384': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3346': ProjectAndUnProjectResult(
      Point(x: 34368.35104356846, y: 5212395.955506003),
      Point(x: 17.888058563129828, y: 46.892264062424815)),
  'EPSG:3347': ProjectAndUnProjectResult(
      Point(x: 11031109.518585373, y: 6836755.258922908),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3348': ProjectAndUnProjectResult(
      Point(x: 11031109.518585373, y: 6836755.258922908),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3349': ProjectAndUnProjectResult(
      Point(x: 18689213.18920183, y: 5893297.075909311),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3350': ProjectAndUnProjectResult(
      Point(x: -59414.37916993268, y: 5192362.31648339),
      Point(x: 17.888058570116137, y: 46.89226406804821)),
  'EPSG:3351': ProjectAndUnProjectResult(
      Point(x: 712031.6335790958, y: 5208610.178109246),
      Point(x: 17.888058583240415, y: 46.89226405777175)),
  'EPSG:3352': ProjectAndUnProjectResult(
      Point(x: 1483585.748638447, y: 5233721.696957675),
      Point(x: 17.88805897567233, y: 46.89226399200145)),
  'EPSG:3353': ProjectAndUnProjectResult(
      Point(x: 1176923.0622932846, y: 15231773.275567364),
      Point(x: 17.888058560281518, y: 46.89226406700879)),
  'EPSG:3354': ProjectAndUnProjectResult(
      Point(x: 1176923.0622932846, y: 15231773.275567364),
      Point(x: 17.888058560281518, y: 46.89226406700879)),
  'EPSG:3355': ProjectAndUnProjectResult(
      Point(x: -383784.54290119535, y: 2769255.2682439834),
      Point(x: 17.888063467962947, y: 46.892263858774484)),
  'EPSG:3356': ProjectAndUnProjectResult(
      Point(x: 5735530.8138339855, y: 10913650.016288968),
      Point(x: 17.888058533434197, y: 46.89226400725348)),
  'EPSG:3357': ProjectAndUnProjectResult(
      Point(x: 5735987.391095634, y: 10914016.702522453),
      Point(x: 17.888058556925007, y: 46.89226404878659)),
  'EPSG:3358': ProjectAndUnProjectResult(
      Point(x: 7013164.842371999, y: 4867653.736840957),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3359': ProjectAndUnProjectResult(
      Point(x: 23009071.002540804, y: 15969992.574937522),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3360': ProjectAndUnProjectResult(
      Point(x: 7231101.448544078, y: 5119305.1873058975),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3361': ProjectAndUnProjectResult(
      Point(x: 23724086.117270596, y: 16795620.69326082),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:3362': ProjectAndUnProjectResult(
      Point(x: 6522469.313095474, y: 4396559.711847568),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3363': ProjectAndUnProjectResult(
      Point(x: 21399134.738047402, y: 14424379.654619897),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:4385': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3364': ProjectAndUnProjectResult(
      Point(x: 6583746.193120701, y: 4440183.096793512),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3365': ProjectAndUnProjectResult(
      Point(x: 21600173.968596835, y: 14567500.710063381),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3366': ProjectAndUnProjectResult(
      Point(x: -6292985.2182573285, y: 9166779.390456945),
      Point(x: -10521.426411563685, y: -17.210613708893074)),
  'EPSG:3367': ProjectAndUnProjectResult(
      Point(x: 2989016.1173230456, y: 5743724.840412613),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3368': ProjectAndUnProjectResult(
      Point(x: 2540816.7780718436, y: 5555395.965894984),
      Point(x: 17.888058560281532, y: 46.89226406700878)),
  'EPSG:3369': ProjectAndUnProjectResult(
      Point(x: 2088261.0114847391, y: 5408891.435744324),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:3370': ProjectAndUnProjectResult(
      Point(x: -1540696.9978496272, y: 14440056.650622983),
      Point(x: 17.888058560281515, y: 46.89226404782313)),
  'EPSG:3371': ProjectAndUnProjectResult(
      Point(x: -1088169.6478126203, y: 14586556.87033251),
      Point(x: 17.88805856028154, y: 46.89226404782314)),
  'EPSG:3372': ProjectAndUnProjectResult(
      Point(x: -1540720.0453096956, y: 14440239.5923442),
      Point(x: 17.88805856028151, y: 46.89226406700882)),
  'EPSG:3373': ProjectAndUnProjectResult(
      Point(x: -1088186.0339291478, y: 14586736.438492097),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:3375': ProjectAndUnProjectResult(
      Point(x: -5316992.27272053, y: 6970349.875876519),
      Point(x: 17.8880585602815, y: 46.89226406700872)),
  'EPSG:3376': ProjectAndUnProjectResult(
      Point(x: -20667926.15717817, y: 7397843.038706061),
      Point(x: 17.888058560281486, y: 46.89226406700866)),
  'EPSG:3377': ProjectAndUnProjectResult(
      Point(x: -5705379.234758854, y: 9716999.979202269),
      Point(x: 94692083409.60115, y: 5676562.371421338)),
  'EPSG:3378': ProjectAndUnProjectResult(
      Point(x: -5602862.580164545, y: 9443189.715987837),
      Point(x: 55719602.863625646, y: 63729.94375745346)),
  'EPSG:3379': ProjectAndUnProjectResult(
      Point(x: -5636618.162312897, y: 9386937.853361819),
      Point(x: 180421399.4631877, y: 130124.96319345839)),
  'EPSG:3380': ProjectAndUnProjectResult(
      Point(x: -5607595.484272222, y: 9314627.423811605),
      Point(x: 14355450.81207967, y: 27803.04191092491)),
  'EPSG:3381': ProjectAndUnProjectResult(
      Point(x: -5650253.512894152, y: 9346448.277887724),
      Point(x: 4441144281.598458, y: 900733.2604377113)),
  'EPSG:3382': ProjectAndUnProjectResult(
      Point(x: -5512661.1732170805, y: 8928688.985765466),
      Point(x: 2460159.551547343, y: 9298.755975760438)),
  'EPSG:3383': ProjectAndUnProjectResult(
      Point(x: -5529427.544852741, y: 8906674.954400184),
      Point(x: 3794590.2338328245, y: 12200.08423819763)),
  'EPSG:3413': ProjectAndUnProjectResult(
      Point(x: 4356553.99963951, y: -2230507.1849957784),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3384': ProjectAndUnProjectResult(
      Point(x: -5539729.187695043, y: 9185880.408929028),
      Point(x: 5049506.595575011, y: 14577.275165292263)),
  'EPSG:3385': ProjectAndUnProjectResult(
      Point(x: -5611801.979102653, y: 9135643.677975701),
      Point(x: 141899987.77163473, y: 112487.87681589273)),
  'EPSG:3386': ProjectAndUnProjectResult(
      Point(x: 491651.84826049313, y: 5195429.334983544),
      Point(x: 17.888058569538547, y: 46.892264085278)),
  'EPSG:3387': ProjectAndUnProjectResult(
      Point(x: 4349486.602413602, y: 5307438.843630845),
      Point(x: 17.88807715206505, y: 46.892264073559815)),
  'EPSG:3388': ProjectAndUnProjectResult(
      Point(x: -2743257.5267757266, y: 4386280.119565143),
      Point(x: 17.888058570172564, y: 46.89226406845006)),
  'EPSG:3389': ProjectAndUnProjectResult(
      Point(x: 102468753.1875995, y: -16966271.673058722),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:3390': ProjectAndUnProjectResult(
      Point(x: 102468868.58776212, y: -16966057.215315938),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:3391': ProjectAndUnProjectResult(
      Point(x: -1104822.0481387465, y: 5413686.36369607),
      Point(x: 17.888058626019056, y: 46.89226408596004)),
  'EPSG:3392': ProjectAndUnProjectResult(
      Point(x: -1557244.3286468377, y: 5561669.014161654),
      Point(x: 17.888058626019067, y: 46.89226408596003)),
  'EPSG:3393': ProjectAndUnProjectResult(
      Point(x: -2005222.9942491958, y: 5751582.767743938),
      Point(x: 17.888058626019056, y: 46.89226408596004)),
  'EPSG:3394': ProjectAndUnProjectResult(
      Point(x: -611632.6034817761, y: 3049740.4293768127),
      Point(x: 17.888058561399866, y: 46.89226406573685)),
  'EPSG:3395': ProjectAndUnProjectResult(
      Point(x: 1991289.5702107965, y: 5893297.075909311),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:3396': ProjectAndUnProjectResult(
      Point(x: 4177079.968440652, y: 5233232.120986678),
      Point(x: 17.888058435353244, y: 46.89226402757831)),
  'EPSG:3397': ProjectAndUnProjectResult(
      Point(x: 4948614.819973172, y: 5211599.299867989),
      Point(x: 17.888058558409952, y: 46.89226406334307)),
  'EPSG:3398': ProjectAndUnProjectResult(
      Point(x: 4948614.819973172, y: 5211599.299867989),
      Point(x: 17.888058558409952, y: 46.89226406334307)),
  'EPSG:3399': ProjectAndUnProjectResult(
      Point(x: 5720062.557838639, y: 5198792.3020578),
      Point(x: 17.888058560301875, y: 46.89226406695668)),
  'EPSG:3400': ProjectAndUnProjectResult(
      Point(x: -5717776.119356243, y: 10259186.452845959), Point(x: 0, y: 90)),
  'EPSG:3401': ProjectAndUnProjectResult(
      Point(x: -6217776.119356243, y: 10259186.452845959), Point(x: 0, y: 90)),
  'EPSG:3402': ProjectAndUnProjectResult(
      Point(x: -5717776.119356243, y: 10259186.452845959), Point(x: 0, y: 90)),
  'EPSG:3403': ProjectAndUnProjectResult(
      Point(x: -6217776.119356243, y: 10259186.452845959), Point(x: 0, y: 90)),
  'EPSG:4387': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3404': ProjectAndUnProjectResult(
      Point(x: 23009024.984398805, y: 15969960.634952374),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:3405': ProjectAndUnProjectResult(
      Point(x: -4822585.444684273, y: 9697396.604055718),
      Point(x: 17.88805856969646, y: 46.89226408683707)),
  'EPSG:3406': ProjectAndUnProjectResult(
      Point(x: -4820917.314234555, y: 10321834.353157688),
      Point(x: 17.888058569696177, y: 46.89226408683707)),
  'EPSG:3407': ProjectAndUnProjectResult(
      Point(x: -20646462.198401757, y: 30075005.35947047),
      Point(x: -10521.426411563674, y: -17.21061370889277)),
  'EPSG:3408': ProjectAndUnProjectResult(
      Point(x: 1437890.914009675, y: -4454970.305533958),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3409': ProjectAndUnProjectResult(
      Point(x: 3640258.4167918605, y: 11278493.377536342),
      Point(x: 17.888058560281515, y: 46.892264067008824)),
  'EPSG:3410': ProjectAndUnProjectResult(
      Point(x: 1722639.313110822, y: 5371023.191559015),
      Point(x: 17.888058560281518, y: 46.892264067008796)),
  'EPSG:3411': ProjectAndUnProjectResult(
      Point(x: 4356646.390125803, y: -2230554.487896997),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3412': ProjectAndUnProjectResult(
      Point(x: 9541787.270314474, y: 29563006.85733861),
      Point(x: 17.888058560281515, y: 46.89226406700872)),
  'EPSG:3414': ProjectAndUnProjectResult(
      Point(x: -5112096.108141312, y: 9542168.098918451),
      Point(x: 1261949784.1230948, y: 276952866.8896538)),
  'EPSG:3415': ProjectAndUnProjectResult(
      Point(x: -7204355.682652707, y: 5865506.922237592),
      Point(x: 17.888058560281543, y: 46.89226406656406)),
  'EPSG:3416': ProjectAndUnProjectResult(
      Point(x: 746812.466775743, y: 342624.3366221152),
      Point(x: 17.888058560281515, y: 46.892264067008746)),
  'EPSG:3417': ProjectAndUnProjectResult(
      Point(x: 25440189.887127113, y: 21133297.2926685),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3418': ProjectAndUnProjectResult(
      Point(x: 22584121.62016271, y: 18118492.88647239),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3419': ProjectAndUnProjectResult(
      Point(x: 23202013.512833614, y: 19421226.757199746),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3420': ProjectAndUnProjectResult(
      Point(x: 23706301.067791585, y: 21180590.79599451),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3421': ProjectAndUnProjectResult(
      Point(x: -21020973.318616632, y: 46754238.25794514), Point(x: 0, y: 90)),
  'EPSG:3463': ProjectAndUnProjectResult(
      Point(x: 5625524.243963247, y: 4952785.35904863),
      Point(x: -21737319794.91784, y: 4757338589.640197)),
  'EPSG:3422': ProjectAndUnProjectResult(
      Point(x: -22468358.066907622, y: 39079941.46217176),
      Point(x: 189531435637.07315, y: 59487357072.499916)),
  'EPSG:3423': ProjectAndUnProjectResult(
      Point(x: -26068968.027379595, y: 30272865.938432105),
      Point(x: 53494776.36427391, y: 20053499.392547227)),
  'EPSG:3424': ProjectAndUnProjectResult(
      Point(x: 16771473.19291651, y: 19881470.240724005), Point(x: 0, y: 90)),
  'EPSG:3425': ProjectAndUnProjectResult(
      Point(x: 25440189.887127113, y: 21133297.2926685),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3426': ProjectAndUnProjectResult(
      Point(x: 22584121.62016271, y: 18118492.88647239),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3427': ProjectAndUnProjectResult(
      Point(x: 23202013.512833614, y: 19421226.757199746),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3428': ProjectAndUnProjectResult(
      Point(x: 23706301.067791585, y: 21180590.79599451),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3429': ProjectAndUnProjectResult(
      Point(x: -21020973.318616632, y: 46754238.25794514), Point(x: 0, y: 90)),
  'EPSG:4389': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3430': ProjectAndUnProjectResult(
      Point(x: -22468358.066907622, y: 39079941.46217176),
      Point(x: 189531435637.07315, y: 59487357072.499916)),
  'EPSG:3431': ProjectAndUnProjectResult(
      Point(x: -26068968.027379595, y: 30272865.938432105),
      Point(x: 53494776.36427391, y: 20053499.392547227)),
  'EPSG:3432': ProjectAndUnProjectResult(
      Point(x: 16771473.19291651, y: 19881470.240724005), Point(x: 0, y: 90)),
  'EPSG:3433': ProjectAndUnProjectResult(
      Point(x: 23887239.314518936, y: 18694250.277860995),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3434': ProjectAndUnProjectResult(
      Point(x: 24415399.802238896, y: 20281166.659434237),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3435': ProjectAndUnProjectResult(
      Point(x: 12811889.12278986, y: 25117350.226620816), Point(x: 0, y: 90)),
  'EPSG:3436': ProjectAndUnProjectResult(
      Point(x: 13092484.923865333, y: 25555865.841472708), Point(x: 0, y: 90)),
  'EPSG:3437': ProjectAndUnProjectResult(
      Point(x: 17611813.210191824, y: 17528306.05463954), Point(x: 0, y: 90)),
  'EPSG:3881': ProjectAndUnProjectResult(
      Point(x: 26805790.968825404, y: 5235736.574560914),
      Point(x: 17.888058718641528, y: 46.892264021677924)),
  'EPSG:3438': ProjectAndUnProjectResult(
      Point(x: 16971851.915299885, y: 17984948.307937823), Point(x: 0, y: 90)),
  'EPSG:3439': ProjectAndUnProjectResult(
      Point(x: -2005665.1722868974, y: 5751629.911337893),
      Point(x: 17.888058574321306, y: 46.89226402004299)),
  'EPSG:3440': ProjectAndUnProjectResult(
      Point(x: -2446268.457214241, y: 5986690.509216219),
      Point(x: 17.888058574321306, y: 46.892264020042994)),
  'EPSG:3441': ProjectAndUnProjectResult(
      Point(x: 23887239.314518936, y: 18694250.277860995),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3442': ProjectAndUnProjectResult(
      Point(x: 24415399.802238896, y: 20281166.659434237),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3443': ProjectAndUnProjectResult(
      Point(x: 12811889.12278986, y: 25117350.226620816), Point(x: 0, y: 90)),
  'EPSG:3444': ProjectAndUnProjectResult(
      Point(x: 13092484.923865333, y: 25555865.841472708), Point(x: 0, y: 90)),
  'EPSG:3445': ProjectAndUnProjectResult(
      Point(x: 17611813.210191824, y: 17528306.05463954), Point(x: 0, y: 90)),
  'EPSG:3974': ProjectAndUnProjectResult(
      Point(x: 3638523.4746012595, y: 11273118.062993607),
      Point(x: 17.888058560281515, y: 46.89226406911217)),
  'EPSG:3446': ProjectAndUnProjectResult(
      Point(x: 16971851.915299885, y: 17984948.307937823), Point(x: 0, y: 90)),
  'EPSG:3447': ProjectAndUnProjectResult(
      Point(x: 1177562.2460995112, y: -174450.21423480567),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:3448': ProjectAndUnProjectResult(
      Point(x: 8722502.953889899, y: 6092117.725645116),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3449': ProjectAndUnProjectResult(
      Point(x: 5735902.874809236, y: 10914136.808042282),
      Point(x: 17.888058560281717, y: 46.89226406700881)),
  'EPSG:3450': ProjectAndUnProjectResult(
      Point(x: 5822492.611904318, y: 10298556.414407223),
      Point(x: 17.888058560281653, y: 46.89226406700865)),
  'EPSG:3451': ProjectAndUnProjectResult(
      Point(x: 27207965.058721785, y: 19397745.31127012),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3452': ProjectAndUnProjectResult(
      Point(x: 27757949.88951659, y: 19429241.351418473),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3453': ProjectAndUnProjectResult(
      Point(x: 28933630.503382377, y: 19794529.601754144),
      Point(x: 17.888058560281486, y: 46.89226406700874)),
  'EPSG:3454': ProjectAndUnProjectResult(
      Point(x: 22541676.56268013, y: 19406913.486204017),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:3455': ProjectAndUnProjectResult(
      Point(x: 22541676.56268013, y: 19406913.486204017),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:3456': ProjectAndUnProjectResult(
      Point(x: 27207965.058721785, y: 19397745.31127012),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3457': ProjectAndUnProjectResult(
      Point(x: 27757949.88951659, y: 19429241.351418473),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3458': ProjectAndUnProjectResult(
      Point(x: 22086296.488457482, y: 19050428.99191546),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3459': ProjectAndUnProjectResult(
      Point(x: 22541676.56268013, y: 19406913.486204017),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:3460': ProjectAndUnProjectResult(
      Point(x: 41534995.48338613, y: -8759166.666704135), Point(x: 0, y: -90)),
  'EPSG:3461': ProjectAndUnProjectResult(
      Point(x: 2988858.315622807, y: 5743905.9823116325),
      Point(x: 17.88805856395703, y: 46.892264058068044)),
  'EPSG:3462': ProjectAndUnProjectResult(
      Point(x: 2540678.5742238667, y: 5555585.493078715),
      Point(x: 17.888058563957046, y: 46.892264058068044)),
  'EPSG:3975': ProjectAndUnProjectResult(
      Point(x: 1725952.2313917708, y: 5349116.620095357),
      Point(x: 17.888058560281515, y: 46.8922640670088)),
  'EPSG:3464': ProjectAndUnProjectResult(
      Point(x: 5625524.243963247, y: 4952785.35904863),
      Point(x: -21737319794.91784, y: 4757338589.640197)),
  'EPSG:3465': ProjectAndUnProjectResult(
      Point(x: 4175252.6559100477, y: 8132636.419234506), Point(x: 0, y: 90)),
  'EPSG:3466': ProjectAndUnProjectResult(
      Point(x: 4335563.615183162, y: 8328698.3072116645), Point(x: 0, y: 90)),
  'EPSG:3467': ProjectAndUnProjectResult(
      Point(x: 2704046.3736966117, y: 9181485.899239805),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3468': ProjectAndUnProjectResult(
      Point(x: 6508725.5759530235, y: 4717646.787048834),
      Point(x: 17.88805856028155, y: 46.89226406700871)),
  'EPSG:3469': ProjectAndUnProjectResult(
      Point(x: -37213279.522647545, y: -18912875.961270504),
      Point(x: 0, y: -90)),
  'EPSG:3470': ProjectAndUnProjectResult(
      Point(x: -45107405.43757957, y: -26521048.301904406),
      Point(x: 0, y: -90)),
  'EPSG:3471': ProjectAndUnProjectResult(
      Point(x: -54145589.80520173, y: -35798007.60070698), Point(x: 0, y: -90)),
  'EPSG:3472': ProjectAndUnProjectResult(
      Point(x: -64460118.121024735, y: -47015897.944632985),
      Point(x: 0, y: -90)),
  'EPSG:3473': ProjectAndUnProjectResult(
      Point(x: -76195487.58152132, y: -60481645.41980923), Point(x: 0, y: -90)),
  'EPSG:3474': ProjectAndUnProjectResult(
      Point(x: -89509253.44187886, y: -76540389.67400539), Point(x: 0, y: -90)),
  'EPSG:3475': ProjectAndUnProjectResult(
      Point(x: 77897438.88146861, y: -61308557.825420626), Point(x: 0, y: -90)),
  'EPSG:3476': ProjectAndUnProjectResult(
      Point(x: 66078013.4794075, y: -47707169.16826724), Point(x: 0, y: -90)),
  'EPSG:3477': ProjectAndUnProjectResult(
      Point(x: -3067782.7230528235, y: 8760315.521445647),
      Point(x: 17.888058560281486, y: 46.89226406700873)),
  'EPSG:3478': ProjectAndUnProjectResult(
      Point(x: -4128150.708307095, y: 7585988.433132556), Point(x: 0, y: 90)),
  'EPSG:3479': ProjectAndUnProjectResult(
      Point(x: -13543801.5364406, y: 24888413.49452938), Point(x: 0, y: 90)),
  'EPSG:3480': ProjectAndUnProjectResult(
      Point(x: -3169861.026850693, y: 7913822.186592112), Point(x: 0, y: 90)),
  'EPSG:3481': ProjectAndUnProjectResult(
      Point(x: -10399806.518539019, y: 25963983.55181139), Point(x: 0, y: 90)),
  'EPSG:3482': ProjectAndUnProjectResult(
      Point(x: -5215796.690656631, y: 7168396.858414973), Point(x: 0, y: 90)),
  'EPSG:3483': ProjectAndUnProjectResult(
      Point(x: -17112193.866983697, y: 23518362.396374583), Point(x: 0, y: 90)),
  'EPSG:3484': ProjectAndUnProjectResult(
      Point(x: 7280845.10476574, y: 5698018.880729793),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3485': ProjectAndUnProjectResult(
      Point(x: 23887239.314518936, y: 18694250.277860995),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3486': ProjectAndUnProjectResult(
      Point(x: 7441828.743390062, y: 6181711.961229637),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3487': ProjectAndUnProjectResult(
      Point(x: 24415399.802238896, y: 20281166.659434237),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3488': ProjectAndUnProjectResult(
      Point(x: 7281011.174753069, y: 7461253.495639747),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:3489': ProjectAndUnProjectResult(
      Point(x: 8713369.04628296, y: 8228903.974584526),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:4465': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3490': ProjectAndUnProjectResult(
      Point(x: 28587111.613013346, y: 26997662.4569494),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3491': ProjectAndUnProjectResult(
      Point(x: 8988852.870882323, y: 8299543.835321399),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3492': ProjectAndUnProjectResult(
      Point(x: 29490928.127553087, y: 27229420.066716958),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3493': ProjectAndUnProjectResult(
      Point(x: 9196533.03998033, y: 8221416.367224062),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3494': ProjectAndUnProjectResult(
      Point(x: 30172292.14900214, y: 26973096.865134276),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3495': ProjectAndUnProjectResult(
      Point(x: 9364631.99275643, y: 8154335.033546976),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:3496': ProjectAndUnProjectResult(
      Point(x: 30723796.79656839, y: 26753014.189562038),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:3497': ProjectAndUnProjectResult(
      Point(x: 9657012.346788008, y: 8138321.005032831),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3498': ProjectAndUnProjectResult(
      Point(x: 31683048.00808699, y: 26700474.83101188),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3499': ProjectAndUnProjectResult(
      Point(x: 9857792.552179694, y: 8039982.800465539),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3500': ProjectAndUnProjectResult(
      Point(x: 32341774.398609553, y: 26377843.57152736),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:3501': ProjectAndUnProjectResult(
      Point(x: 7746779.736843174, y: 6828729.263310314),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3502': ProjectAndUnProjectResult(
      Point(x: 25415893.18631023, y: 22403922.591381256),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3503': ProjectAndUnProjectResult(
      Point(x: 7609906.701740923, y: 6737108.930826646),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3504': ProjectAndUnProjectResult(
      Point(x: 24966835.570312265, y: 22103331.550557755),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3513': ProjectAndUnProjectResult(
      Point(x: 7788718.898020689, y: 5738991.145189423),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:3505': ProjectAndUnProjectResult(
      Point(x: 7902404.853652807, y: 6873456.4247696595),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3506': ProjectAndUnProjectResult(
      Point(x: 25926473.257043168, y: 22550664.95360246),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3507': ProjectAndUnProjectResult(
      Point(x: 6039095.133709748, y: 4143749.064976011),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:3508': ProjectAndUnProjectResult(
      Point(x: 19813264.617850065, y: 13594950.05734413),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:3509': ProjectAndUnProjectResult(
      Point(x: 5117848.770438616, y: 6252732.387920412), Point(x: 0, y: 90)),
  'EPSG:3510': ProjectAndUnProjectResult(
      Point(x: 16790808.84134736, y: 20514172.84270222), Point(x: 0, y: 90)),
  'EPSG:3511': ProjectAndUnProjectResult(
      Point(x: 4721237.687280814, y: 8356420.754737286), Point(x: 0, y: 90)),
  'EPSG:3512': ProjectAndUnProjectResult(
      Point(x: 15489593.979353804, y: 27416023.75950058), Point(x: 0, y: 90)),
  'EPSG:4468': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3514': ProjectAndUnProjectResult(
      Point(x: 7714848.02247523, y: 5442253.479619011),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:3515': ProjectAndUnProjectResult(
      Point(x: 25311130.553737484, y: 17855126.624383375),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:3516': ProjectAndUnProjectResult(
      Point(x: 4625113.957471083, y: 8456488.815026179), Point(x: 0, y: 90)),
  'EPSG:3517': ProjectAndUnProjectResult(
      Point(x: 15174228.04246971, y: 27744330.38729839), Point(x: 0, y: 90)),
  'EPSG:3518': ProjectAndUnProjectResult(
      Point(x: 4608098.742447868, y: 7844758.075159398), Point(x: 0, y: 90)),
  'EPSG:3519': ProjectAndUnProjectResult(
      Point(x: 15118403.957847713, y: 25737343.784918793), Point(x: 0, y: 90)),
  'EPSG:3520': ProjectAndUnProjectResult(
      Point(x: 4887189.5243078265, y: 8036713.270922709), Point(x: 0, y: 90)),
  'EPSG:3521': ProjectAndUnProjectResult(
      Point(x: 16034054.29733326, y: 26367116.78968559), Point(x: 0, y: 90)),
  'EPSG:3554': ProjectAndUnProjectResult(
      Point(x: 5625524.243963247, y: 4952785.35904863),
      Point(x: -21737319794.91784, y: 4757338589.640197)),
  'EPSG:3522': ProjectAndUnProjectResult(
      Point(x: -5084440.623114015, y: 5921630.496325042), Point(x: 0, y: 90)),
  'EPSG:3523': ProjectAndUnProjectResult(
      Point(x: -16681202.277333234, y: 19427882.72002641), Point(x: 0, y: 90)),
  'EPSG:3524': ProjectAndUnProjectResult(
      Point(x: -4284867.971020522, y: 6350434.242753448), Point(x: 0, y: 90)),
  'EPSG:3525': ProjectAndUnProjectResult(
      Point(x: -14057937.667923164, y: 20834716.344766937), Point(x: 0, y: 90)),
  'EPSG:3526': ProjectAndUnProjectResult(
      Point(x: -5919234.386603765, y: 5433186.325411458), Point(x: 0, y: 90)),
  'EPSG:3527': ProjectAndUnProjectResult(
      Point(x: -19420021.483049188, y: 17825378.802620757), Point(x: 0, y: 90)),
  'EPSG:3528': ProjectAndUnProjectResult(
      Point(x: 3905071.6147695784, y: 7655783.660641345), Point(x: 0, y: 90)),
  'EPSG:3529': ProjectAndUnProjectResult(
      Point(x: 12811889.12278986, y: 25117350.226620816), Point(x: 0, y: 90)),
  'EPSG:3571': ProjectAndUnProjectResult(
      Point(x: -1441907.3090332334, y: 4467414.170635901),
      Point(x: 17.88805856028151, y: 46.892264069112215)),
  'EPSG:3530': ProjectAndUnProjectResult(
      Point(x: 3990597.385999085, y: 7789443.487367855), Point(x: 0, y: 90)),
  'EPSG:3531': ProjectAndUnProjectResult(
      Point(x: 13092484.923865333, y: 25555865.841472708), Point(x: 0, y: 90)),
  'EPSG:3532': ProjectAndUnProjectResult(
      Point(x: 4097701.446227201, y: 7591591.6682478), Point(x: 0, y: 90)),
  'EPSG:3533': ProjectAndUnProjectResult(
      Point(x: 13443875.494497076, y: 24906746.99790966), Point(x: 0, y: 90)),
  'EPSG:3534': ProjectAndUnProjectResult(
      Point(x: 4698254.479714725, y: 7712933.359383934), Point(x: 0, y: 90)),
  'EPSG:3535': ProjectAndUnProjectResult(
      Point(x: 15414189.905530728, y: 25304848.862912126), Point(x: 0, y: 90)),
  'EPSG:3536': ProjectAndUnProjectResult(
      Point(x: 7754185.385967116, y: 6441441.897699313),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3537': ProjectAndUnProjectResult(
      Point(x: 25440189.887127113, y: 21133297.2926685),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:4473': ProjectAndUnProjectResult(
      Point(x: 4155553.9165052753, y: 1341250.964523339),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3538': ProjectAndUnProjectResult(
      Point(x: 6883654.037123509, y: 5522527.676852138),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3539': ProjectAndUnProjectResult(
      Point(x: 22584121.62016271, y: 18118492.88647239),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3540': ProjectAndUnProjectResult(
      Point(x: 7071987.862697571, y: 5919601.754797991),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3541': ProjectAndUnProjectResult(
      Point(x: 23202013.512833614, y: 19421226.757199746),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3542': ProjectAndUnProjectResult(
      Point(x: 7225695.016863069, y: 6455856.986343259),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3543': ProjectAndUnProjectResult(
      Point(x: 23706301.067791585, y: 21180590.79599451),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3544': ProjectAndUnProjectResult(
      Point(x: 6854798.276271999, y: 4982007.395728776),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3545': ProjectAndUnProjectResult(
      Point(x: 22489450.678402383, y: 16345135.930820161),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3546': ProjectAndUnProjectResult(
      Point(x: 7954314.818287251, y: 6181092.986200401),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3547': ProjectAndUnProjectResult(
      Point(x: 26096781.19966409, y: 20279135.905225817),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3548': ProjectAndUnProjectResult(
      Point(x: 7000500.0764196385, y: 5649813.9503045585),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:3549': ProjectAndUnProjectResult(
      Point(x: 22967474.00105343, y: 18536097.935624205),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:3550': ProjectAndUnProjectResult(
      Point(x: 8293004.335917232, y: 5912444.595764324),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3551': ProjectAndUnProjectResult(
      Point(x: 27207965.058721785, y: 19397745.31127012),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3552': ProjectAndUnProjectResult(
      Point(x: 8460640.04761491, y: 5922044.6080015665),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3553': ProjectAndUnProjectResult(
      Point(x: 27757949.88951659, y: 19429241.351418473),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3555': ProjectAndUnProjectResult(
      Point(x: 5841926.85039724, y: 4779293.471123142),
      Point(x: -856956604.9425999, y: 188140569.70074788)),
  'EPSG:3556': ProjectAndUnProjectResult(
      Point(x: 5401485.579875652, y: 5163842.641810937),
      Point(x: -11503948981851.02, y: 2505985965549.347)),
  'EPSG:3557': ProjectAndUnProjectResult(
      Point(x: 5434242.727510438, y: 4865567.286727372),
      Point(x: -3577911303.5949883, y: 784422263.488511)),
  'EPSG:3558': ProjectAndUnProjectResult(
      Point(x: 6005972.529556511, y: 5140915.469168544),
      Point(x: -2514978608650.738, y: 548342325600.6209)),
  'EPSG:3559': ProjectAndUnProjectResult(
      Point(x: 6458859.816901178, y: 4494509.018460154),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:3560': ProjectAndUnProjectResult(
      Point(x: 23401718.533635758, y: 25725063.605568122),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:3561': ProjectAndUnProjectResult(
      Point(x: -226509367.85061833, y: -157187120.40956476),
      Point(x: -77.91897303995458, y: -89.9973905988209)),
  'EPSG:3562': ProjectAndUnProjectResult(
      Point(x: -237763453.1298117, y: -170657720.7220814),
      Point(x: -77.91897303995458, y: -89.9973905988209)),
  'EPSG:3572': ProjectAndUnProjectResult(
      Point(x: 984978.7257927118, y: 4589847.815513896),
      Point(x: 17.88805856028151, y: 46.89226406911223)),
  'EPSG:3563': ProjectAndUnProjectResult(
      Point(x: -251152486.4530942, y: -186583351.1754257),
      Point(x: -77.91897303995458, y: -89.9973905988209)),
  'EPSG:3564': ProjectAndUnProjectResult(
      Point(x: -266897201.1541538, y: -205527944.67993367),
      Point(x: -77.91897303995458, y: -89.9973905988209)),
  'EPSG:3565': ProjectAndUnProjectResult(
      Point(x: -274138717.7977724, y: -214182199.98964313),
      Point(x: -77.91897303995458, y: -89.9973905988209)),
  'EPSG:3566': ProjectAndUnProjectResult(
      Point(x: 24004488.809627805, y: 29432890.76363637),
      Point(x: 17.88805856028155, y: 46.892264067008725)),
  'EPSG:3567': ProjectAndUnProjectResult(
      Point(x: 24918123.2297812, y: 32865520.033304103),
      Point(x: 17.88805856028155, y: 46.89226406700872)),
  'EPSG:3568': ProjectAndUnProjectResult(
      Point(x: 23401718.533635758, y: 25725063.605568122),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:3569': ProjectAndUnProjectResult(
      Point(x: 24004488.809627805, y: 29432890.76363637),
      Point(x: 17.88805856028155, y: 46.892264067008725)),
  'EPSG:3570': ProjectAndUnProjectResult(
      Point(x: 24918123.2297812, y: 32865520.033304103),
      Point(x: 17.88805856028155, y: 46.89226406700872)),
  'EPSG:3577': ProjectAndUnProjectResult(
      Point(x: -14998999.735860841, y: -3382655.442324089),
      Point(x: 17.888058560281525, y: 46.89226406700871)),
  'EPSG:3578': ProjectAndUnProjectResult(
      Point(x: 3966851.041648818, y: 7733236.104704684),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:3579': ProjectAndUnProjectResult(
      Point(x: 3966851.041648818, y: 7733236.104704684),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:3580': ProjectAndUnProjectResult(
      Point(x: 4380052.028530439, y: 14032309.962545056),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3581': ProjectAndUnProjectResult(
      Point(x: 4380052.028530439, y: 14032309.962545056),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3582': ProjectAndUnProjectResult(
      Point(x: 21190442.582283285, y: 14745735.004731355),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:3583': ProjectAndUnProjectResult(
      Point(x: 6154332.406766824, y: 3817884.2153315847),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3584': ProjectAndUnProjectResult(
      Point(x: 20191338.90486749, y: 12525841.796467042),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3709': ProjectAndUnProjectResult(
      Point(x: -176891.28615693585, y: 14764258.052049907),
      Point(x: 17.888058560281486, y: 46.892264067008796)),
  'EPSG:3585': ProjectAndUnProjectResult(
      Point(x: 5851118.614199274, y: 4670879.245324666),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:3586': ProjectAndUnProjectResult(
      Point(x: 19196544.98708545, y: 15324376.324036008),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:3587': ProjectAndUnProjectResult(
      Point(x: 11889319.027601004, y: 4694603.857861964),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:3588': ProjectAndUnProjectResult(
      Point(x: 39006952.19021326, y: 15402243.62815605),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3589': ProjectAndUnProjectResult(
      Point(x: 13856577.937746815, y: 4794610.454685856),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3590': ProjectAndUnProjectResult(
      Point(x: 45461213.70641344, y: 15730349.260780366),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3591': ProjectAndUnProjectResult(
      Point(x: 8386430.7898983145, y: 2796245.837725366),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3592': ProjectAndUnProjectResult(
      Point(x: 10027794.9275133, y: 4787933.322479354),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:3593': ProjectAndUnProjectResult(
      Point(x: 32899589.65714337, y: 15708442.659052998),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:3594': ProjectAndUnProjectResult(
      Point(x: 6763552.011142525, y: 5414428.169782657),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3595': ProjectAndUnProjectResult(
      Point(x: 6637522.089340442, y: 5241976.733282339),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3596': ProjectAndUnProjectResult(
      Point(x: 6907731.6671998175, y: 5516216.609642071),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3597': ProjectAndUnProjectResult(
      Point(x: 3822984.905080838, y: 8488545.1484227), Point(x: 0, y: 90)),
  'EPSG:3598': ProjectAndUnProjectResult(
      Point(x: 12542576.309419384, y: 27849501.87445014), Point(x: 0, y: 90)),
  'EPSG:3599': ProjectAndUnProjectResult(
      Point(x: 3960143.9403490187, y: 8595620.856387978), Point(x: 0, y: 90)),
  'EPSG:3600': ProjectAndUnProjectResult(
      Point(x: 12992572.243961738, y: 28200799.426332895), Point(x: 0, y: 90)),
  'EPSG:4479': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3601': ProjectAndUnProjectResult(
      Point(x: 3333355.4118026467, y: 8025679.559234873), Point(x: 0, y: 90)),
  'EPSG:3602': ProjectAndUnProjectResult(
      Point(x: 3479281.287680031, y: 7904330.11893151), Point(x: 0, y: 90)),
  'EPSG:3603': ProjectAndUnProjectResult(
      Point(x: 3236399.2997552953, y: 8083966.915915788), Point(x: 0, y: 90)),
  'EPSG:3604': ProjectAndUnProjectResult(
      Point(x: 6556297.784221025, y: 6590553.712986213),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3605': ProjectAndUnProjectResult(
      Point(x: 21510163.334050607, y: 21622551.551792037),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3606': ProjectAndUnProjectResult(
      Point(x: 6975000.373432801, y: 6039872.843451777),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3607': ProjectAndUnProjectResult(
      Point(x: -6848369.235542074, y: 11911589.980849914),
      Point(x: 189531435637.07315, y: 59487357072.499916)),
  'EPSG:3608': ProjectAndUnProjectResult(
      Point(x: -22468358.066907622, y: 39079941.46217176),
      Point(x: 189531435637.07315, y: 59487357072.499916)),
  'EPSG:3609': ProjectAndUnProjectResult(
      Point(x: -6407205.481935473, y: 14250720.322452161), Point(x: 0, y: 90)),
  'EPSG:3610': ProjectAndUnProjectResult(
      Point(x: -21020973.318616632, y: 46754238.25794514), Point(x: 0, y: 90)),
  'EPSG:3611': ProjectAndUnProjectResult(
      Point(x: -7945837.346430153, y: 9227187.99242025),
      Point(x: 53494776.36427391, y: 20053499.392547227)),
  'EPSG:3612': ProjectAndUnProjectResult(
      Point(x: -26068968.027379595, y: 30272865.938432105),
      Point(x: 53494776.36427391, y: 20053499.392547227)),
  'EPSG:3613': ProjectAndUnProjectResult(
      Point(x: 5368091.402649273, y: 5342638.370730873), Point(x: 0, y: 90)),
  'EPSG:3614': ProjectAndUnProjectResult(
      Point(x: 17611813.210191824, y: 17528306.05463954), Point(x: 0, y: 90)),
  'EPSG:3615': ProjectAndUnProjectResult(
      Point(x: 5111955.253111458, y: 6059884.249141174), Point(x: 0, y: 90)),
  'EPSG:3616': ProjectAndUnProjectResult(
      Point(x: 16771473.19291651, y: 19881470.240724005), Point(x: 0, y: 90)),
  'EPSG:3617': ProjectAndUnProjectResult(
      Point(x: -998074.9727628597, y: 8428106.011472125), Point(x: 0, y: 90)),
  'EPSG:3618': ProjectAndUnProjectResult(
      Point(x: -3274517.639472816, y: 27651211.139304798), Point(x: 0, y: 90)),
  'EPSG:3619': ProjectAndUnProjectResult(
      Point(x: -530531.6564737859, y: 8584058.195630815), Point(x: 0, y: 90)),
  'EPSG:3620': ProjectAndUnProjectResult(
      Point(x: -1740585.942947746, y: 28162864.26349877), Point(x: 0, y: 90)),
  'EPSG:3621': ProjectAndUnProjectResult(
      Point(x: -1388949.665557478, y: 8254150.647986836), Point(x: 0, y: 90)),
  'EPSG:3622': ProjectAndUnProjectResult(
      Point(x: -4556912.360749827, y: 27080492.584270146), Point(x: 0, y: 90)),
  'EPSG:3623': ProjectAndUnProjectResult(
      Point(x: 5102989.244976103, y: 6156462.138120647), Point(x: 0, y: 90)),
  'EPSG:3624': ProjectAndUnProjectResult(
      Point(x: 16742057.214225767, y: 20198326.19815082), Point(x: 0, y: 90)),
  'EPSG:3625': ProjectAndUnProjectResult(
      Point(x: 5111955.253111458, y: 6059884.249141174), Point(x: 0, y: 90)),
  'EPSG:3626': ProjectAndUnProjectResult(
      Point(x: 16771473.19291651, y: 19881470.240724005), Point(x: 0, y: 90)),
  'EPSG:3643': ProjectAndUnProjectResult(
      Point(x: 6621080.326600361, y: 7550611.109639786),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3627': ProjectAndUnProjectResult(
      Point(x: 6120506.5914582675, y: 4115911.994870667),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3628': ProjectAndUnProjectResult(
      Point(x: 20080362.042142667, y: 13503621.26983818),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3629': ProjectAndUnProjectResult(
      Point(x: 5070627.948794095, y: 6369472.582025805), Point(x: 0, y: 90)),
  'EPSG:3630': ProjectAndUnProjectResult(
      Point(x: 16635885.195668627, y: 20897177.962862995), Point(x: 0, y: 90)),
  'EPSG:3631': ProjectAndUnProjectResult(
      Point(x: 7013164.842371999, y: 4867653.736840957),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3632': ProjectAndUnProjectResult(
      Point(x: 23009024.984398805, y: 15969960.634952374),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:3633': ProjectAndUnProjectResult(
      Point(x: 6465460.630965634, y: 5661785.323388806),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3634': ProjectAndUnProjectResult(
      Point(x: 21212141.1777009, y: 18575411.16597377),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3635': ProjectAndUnProjectResult(
      Point(x: 6573964.729929726, y: 5741275.293893124),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3636': ProjectAndUnProjectResult(
      Point(x: 21568125.75435474, y: 18836205.032457754),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3637': ProjectAndUnProjectResult(
      Point(x: 6701563.894453452, y: 4762473.447759279),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3638': ProjectAndUnProjectResult(
      Point(x: 6823927.076346041, y: 4856567.2808180135),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3639': ProjectAndUnProjectResult(
      Point(x: 7606719.341866343, y: 6088830.052103923),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3640': ProjectAndUnProjectResult(
      Point(x: 24956378.374106497, y: 19976436.59594429),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3641': ProjectAndUnProjectResult(
      Point(x: 7788873.682746351, y: 6165418.092119623),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3642': ProjectAndUnProjectResult(
      Point(x: 25553996.407476988, y: 20227709.190562464),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3644': ProjectAndUnProjectResult(
      Point(x: 21722704.48359173, y: 24772346.160235517),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3645': ProjectAndUnProjectResult(
      Point(x: 8597033.820587108, y: 7390016.602283895),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3646': ProjectAndUnProjectResult(
      Point(x: 28205491.53782647, y: 24245461.29358233),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3647': ProjectAndUnProjectResult(
      Point(x: 7874076.89548586, y: 7497850.224338042),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:3648': ProjectAndUnProjectResult(
      Point(x: 25833585.615591403, y: 24599246.142841343),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:3649': ProjectAndUnProjectResult(
      Point(x: 6522469.313095474, y: 4396559.711847568),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3650': ProjectAndUnProjectResult(
      Point(x: 21399134.738047402, y: 14424379.654619897),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3651': ProjectAndUnProjectResult(
      Point(x: 6583746.193120701, y: 4440183.096793512),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3652': ProjectAndUnProjectResult(
      Point(x: 21600173.968596835, y: 14567500.710063381),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3653': ProjectAndUnProjectResult(
      Point(x: 5173030.8098551845, y: 5481823.207905864), Point(x: 0, y: 90)),
  'EPSG:3654': ProjectAndUnProjectResult(
      Point(x: 16971851.915299885, y: 17984948.307937823), Point(x: 0, y: 90)),
  'EPSG:3655': ProjectAndUnProjectResult(
      Point(x: 7231101.448544078, y: 5119305.1873058975),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3656': ProjectAndUnProjectResult(
      Point(x: 23724086.117270596, y: 16795620.69326082),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:3657': ProjectAndUnProjectResult(
      Point(x: 6731916.633515107, y: 5806582.369900572),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3658': ProjectAndUnProjectResult(
      Point(x: 22086296.488457482, y: 19050428.99191546),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3659': ProjectAndUnProjectResult(
      Point(x: 6870716.757738419, y: 5915239.061073107),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3660': ProjectAndUnProjectResult(
      Point(x: 22541676.56268013, y: 19406913.486204017),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:3661': ProjectAndUnProjectResult(
      Point(x: 7240825.507643389, y: 5300270.815013457),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3662': ProjectAndUnProjectResult(
      Point(x: 23755941.686326686, y: 17389305.165589985),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3663': ProjectAndUnProjectResult(
      Point(x: 8418734.087582087, y: 9472776.726556078),
      Point(x: 17.88805856028155, y: 46.892264067008746)),
  'EPSG:3664': ProjectAndUnProjectResult(
      Point(x: 27620463.418675568, y: 31078601.6437094),
      Point(x: 17.88805856028155, y: 46.892264067008746)),
  'EPSG:3665': ProjectAndUnProjectResult(
      Point(x: 9202342.771606717, y: 13714424.334539425),
      Point(x: 17.88805856028155, y: 46.89226406700876)),
  'EPSG:3666': ProjectAndUnProjectResult(
      Point(x: 9154307.075487461, y: 12759946.896370977),
      Point(x: 17.88805856028155, y: 46.892264067008725)),
  'EPSG:3667': ProjectAndUnProjectResult(
      Point(x: 7393138.261094371, y: 7401668.656500031),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3668': ProjectAndUnProjectResult(
      Point(x: 24255654.445273783, y: 24283641.25020052),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3669': ProjectAndUnProjectResult(
      Point(x: 7989143.282984504, y: 8276494.464586326),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3670': ProjectAndUnProjectResult(
      Point(x: 26211047.58759166, y: 27153798.92289697),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3671': ProjectAndUnProjectResult(
      Point(x: 8484246.042842139, y: 11469435.827622361),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:3672': ProjectAndUnProjectResult(
      Point(x: 27835397.225557923, y: 37629307.37812436),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:3673': ProjectAndUnProjectResult(
      Point(x: 8486728.051005203, y: 10453504.590111742),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:3674': ProjectAndUnProjectResult(
      Point(x: 27843540.280672904, y: 34296206.30905828),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:3699': ProjectAndUnProjectResult(
      Point(x: 6723783.25810189, y: 5169377.719135766),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:3675': ProjectAndUnProjectResult(
      Point(x: 7316582.822330039, y: 8971163.047072299),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:3676': ProjectAndUnProjectResult(
      Point(x: 24004536.819161545, y: 29432949.629476044),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:3677': ProjectAndUnProjectResult(
      Point(x: 24004488.809627805, y: 29432890.76363637),
      Point(x: 17.88805856028155, y: 46.892264067008725)),
  'EPSG:3678': ProjectAndUnProjectResult(
      Point(x: 7132858.074758168, y: 7841015.069017461),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:3679': ProjectAndUnProjectResult(
      Point(x: 23401765.337626535, y: 25725115.05581844),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:3680': ProjectAndUnProjectResult(
      Point(x: 23401718.533635758, y: 25725063.605568122),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:3681': ProjectAndUnProjectResult(
      Point(x: 7595059.15054545, y: 10017430.541012172),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3682': ProjectAndUnProjectResult(
      Point(x: 24918173.066587433, y: 32865585.764436252),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:3683': ProjectAndUnProjectResult(
      Point(x: 24918123.2297812, y: 32865520.033304103),
      Point(x: 17.88805856028155, y: 46.89226406700872)),
  'EPSG:3684': ProjectAndUnProjectResult(
      Point(x: 5541768.404689928, y: 5434133.661562179), Point(x: 0, y: 90)),
  'EPSG:3685': ProjectAndUnProjectResult(
      Point(x: 9634482.513941199, y: 6581020.355130133),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3686': ProjectAndUnProjectResult(
      Point(x: 31609131.381488748, y: 21591230.948789444),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:3687': ProjectAndUnProjectResult(
      Point(x: 9723405.910334777, y: 5663039.725072842),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:3688': ProjectAndUnProjectResult(
      Point(x: 31900874.224490017, y: 18579489.497676484),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:3689': ProjectAndUnProjectResult(
      Point(x: 6208880.764422776, y: 7201291.121268816),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:3690': ProjectAndUnProjectResult(
      Point(x: 20370302.974943724, y: 23626235.95369611),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:3691': ProjectAndUnProjectResult(
      Point(x: 6409557.023981855, y: 7281838.145229915),
      Point(x: 17.88805856028154, y: 46.892264067008746)),
  'EPSG:3692': ProjectAndUnProjectResult(
      Point(x: 21028688.336513802, y: 23890497.31480848),
      Point(x: 17.88805856028154, y: 46.892264067008746)),
  'EPSG:3693': ProjectAndUnProjectResult(
      Point(x: 6701578.612677592, y: 4608732.256874052),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3694': ProjectAndUnProjectResult(
      Point(x: 6860107.275988375, y: 4799756.489364472),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3695': ProjectAndUnProjectResult(
      Point(x: 6611250.719513921, y: 5046926.8438626565),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3696': ProjectAndUnProjectResult(
      Point(x: 21690411.73560526, y: 16558125.8202394),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3697': ProjectAndUnProjectResult(
      Point(x: 6517033.000426102, y: 4968571.836722961),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3698': ProjectAndUnProjectResult(
      Point(x: 21381299.102231305, y: 16301056.100981915),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:3700': ProjectAndUnProjectResult(
      Point(x: 22059612.239289284, y: 16959866.73353126),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:3701': ProjectAndUnProjectResult(
      Point(x: 3839622.300083163, y: 7353217.56768338), Point(x: 0, y: 90)),
  'EPSG:3702': ProjectAndUnProjectResult(
      Point(x: -835360.288822798, y: 7469523.565254046), Point(x: 0, y: 90)),
  'EPSG:3703': ProjectAndUnProjectResult(
      Point(x: -1585501.348464507, y: 7359986.274514455), Point(x: 0, y: 90)),
  'EPSG:3704': ProjectAndUnProjectResult(
      Point(x: -2061507.894929119, y: 7079113.201731387), Point(x: 0, y: 90)),
  'EPSG:3705': ProjectAndUnProjectResult(
      Point(x: -2539578.0552160507, y: 6974103.5782705145), Point(x: 0, y: 90)),
  'EPSG:3706': ProjectAndUnProjectResult(
      Point(x: -1540720.0453096956, y: 14440239.5923442),
      Point(x: 17.88805856028151, y: 46.89226406700882)),
  'EPSG:3707': ProjectAndUnProjectResult(
      Point(x: -1088186.0339291478, y: 14586736.438492097),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:3708': ProjectAndUnProjectResult(
      Point(x: -633185.5802525296, y: 14694063.811162705),
      Point(x: 17.888058560281486, y: 46.8922640670088)),
  'EPSG:3710': ProjectAndUnProjectResult(
      Point(x: 279998.7701617067, y: 14798688.275906026),
      Point(x: 17.888058560281486, y: 46.89226406700881)),
  'EPSG:3711': ProjectAndUnProjectResult(
      Point(x: 737054.7120364595, y: 14798035.78326757),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:3712': ProjectAndUnProjectResult(
      Point(x: 1193931.3463247414, y: 14762287.606177554),
      Point(x: 17.888058560281486, y: 46.892264067008796)),
  'EPSG:3713': ProjectAndUnProjectResult(
      Point(x: 1650192.1809783236, y: 14690736.608609322),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:3714': ProjectAndUnProjectResult(
      Point(x: 2105125.3251090776, y: 14581988.281413767),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:3715': ProjectAndUnProjectResult(
      Point(x: 2557536.036411387, y: 14433982.116084043),
      Point(x: 17.88805856028154, y: 46.892264067008774)),
  'EPSG:3716': ProjectAndUnProjectResult(
      Point(x: 3005502.501253523, y: 14244044.5770818),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:3717': ProjectAndUnProjectResult(
      Point(x: 3446086.561687547, y: 14009002.219252983),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:3718': ProjectAndUnProjectResult(
      Point(x: 3875003.072767595, y: 13725397.247874938),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:3719': ProjectAndUnProjectResult(
      Point(x: 4286275.534235133, y: 13389860.739087315),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:3720': ProjectAndUnProjectResult(
      Point(x: 4671946.775898903, y: 12999702.032507129),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:3721': ProjectAndUnProjectResult(
      Point(x: 5021971.586011266, y: 12553749.126989897),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:3722': ProjectAndUnProjectResult(
      Point(x: 5324476.5639229575, y: 12053400.324134082),
      Point(x: 17.88805856028146, y: 46.89226406700884)),
  'EPSG:3723': ProjectAndUnProjectResult(
      Point(x: 5566585.223791351, y: 11503707.444009647),
      Point(x: 17.888058560281575, y: 46.892264067008874)),
  'EPSG:3724': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 10914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:3725': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 10298556.41432563),
      Point(x: 17.88805856028164, y: 46.892264067008654)),
  'EPSG:3726': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 9674131.646974),
      Point(x: 17.888058560281358, y: 46.892264067008654)),
  'EPSG:3727': ProjectAndUnProjectResult(
      Point(x: -2679201.6978123337, y: 8313972.817739558),
      Point(x: 18.06467735539011, y: 46.91475667121766)),
  'EPSG:3728': ProjectAndUnProjectResult(
      Point(x: 21986714.210386034, y: 15624881.636523569),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:4481': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3729': ProjectAndUnProjectResult(
      Point(x: 22388167.416311968, y: 15933587.820483766),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3730': ProjectAndUnProjectResult(
      Point(x: -2740677.880879463, y: 24506261.897004317), Point(x: 0, y: 90)),
  'EPSG:3731': ProjectAndUnProjectResult(
      Point(x: -5201765.674120637, y: 24146888.30226951), Point(x: 0, y: 90)),
  'EPSG:3732': ProjectAndUnProjectResult(
      Point(x: -6763463.818613284, y: 23225390.562680393), Point(x: 0, y: 90)),
  'EPSG:3733': ProjectAndUnProjectResult(
      Point(x: -8331932.336121327, y: 22880871.48967585), Point(x: 0, y: 90)),
  'EPSG:3734': ProjectAndUnProjectResult(
      Point(x: 21986714.210386034, y: 15624881.636523569),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3735': ProjectAndUnProjectResult(
      Point(x: 22388167.416311968, y: 15933587.820483766),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3736': ProjectAndUnProjectResult(
      Point(x: -2740677.880879463, y: 24506261.897004317), Point(x: 0, y: 90)),
  'EPSG:4556': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3737': ProjectAndUnProjectResult(
      Point(x: -5201765.674120637, y: 24146888.30226951), Point(x: 0, y: 90)),
  'EPSG:3738': ProjectAndUnProjectResult(
      Point(x: -6763463.818613284, y: 23225390.562680393), Point(x: 0, y: 90)),
  'EPSG:3739': ProjectAndUnProjectResult(
      Point(x: -8331932.336121327, y: 22880871.48967585), Point(x: 0, y: 90)),
  'EPSG:3740': ProjectAndUnProjectResult(
      Point(x: 3446086.561687547, y: 14009002.219252983),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:3741': ProjectAndUnProjectResult(
      Point(x: 3875003.072767595, y: 13725397.247874938),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:3742': ProjectAndUnProjectResult(
      Point(x: 4286275.534235133, y: 13389860.739087315),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:3743': ProjectAndUnProjectResult(
      Point(x: 4671946.775898903, y: 12999702.032507129),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:3744': ProjectAndUnProjectResult(
      Point(x: 5021971.586011266, y: 12553749.126989897),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:3745': ProjectAndUnProjectResult(
      Point(x: 5324476.5639229575, y: 12053400.324134082),
      Point(x: 17.88805856028146, y: 46.89226406700884)),
  'EPSG:3746': ProjectAndUnProjectResult(
      Point(x: 5566585.223791351, y: 11503707.444009647),
      Point(x: 17.888058560281575, y: 46.892264067008874)),
  'EPSG:3747': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 10914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:3748': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 10298556.41432563),
      Point(x: 17.88805856028164, y: 46.892264067008654)),
  'EPSG:3749': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 9674131.646974),
      Point(x: 17.888058560281358, y: 46.892264067008654)),
  'EPSG:3750': ProjectAndUnProjectResult(
      Point(x: 737054.7120364595, y: 14798035.78326757),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:3751': ProjectAndUnProjectResult(
      Point(x: 1193931.3463247414, y: 14762287.606177554),
      Point(x: 17.888058560281486, y: 46.892264067008796)),
  'EPSG:3752': ProjectAndUnProjectResult(
      Point(x: -6908503.39310654, y: 4454149.375643825),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3753': ProjectAndUnProjectResult(
      Point(x: 21986714.210386034, y: 15624881.636523569),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3754': ProjectAndUnProjectResult(
      Point(x: 22388167.416311968, y: 15933587.820483766),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3755': ProjectAndUnProjectResult(
      Point(x: -2740677.880879463, y: 24506261.897004317), Point(x: 0, y: 90)),
  'EPSG:4882': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3756': ProjectAndUnProjectResult(
      Point(x: -5201765.674120637, y: 24146888.30226951), Point(x: 0, y: 90)),
  'EPSG:3757': ProjectAndUnProjectResult(
      Point(x: -6763463.818613284, y: 23225390.562680393), Point(x: 0, y: 90)),
  'EPSG:3758': ProjectAndUnProjectResult(
      Point(x: -8331932.336121327, y: 22880871.48967585), Point(x: 0, y: 90)),
  'EPSG:3759': ProjectAndUnProjectResult(
      Point(x: -250007344.03195605, y: -186491554.88910815),
      Point(x: 0, y: -90)),
  'EPSG:3760': ProjectAndUnProjectResult(
      Point(x: -250007344.03195605, y: -186491554.88910815),
      Point(x: 0, y: -90)),
  'EPSG:3761': ProjectAndUnProjectResult(
      Point(x: 5314192.97843734, y: 7922929.14904744),
      Point(x: 17.88805856028157, y: 46.89226406700883)),
  'EPSG:3762': ProjectAndUnProjectResult(
      Point(x: 17081659.805985913, y: 12801289.11576897),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3763': ProjectAndUnProjectResult(
      Point(x: 1976343.1973906928, y: 1141528.2391083618),
      Point(x: 17.88452802467779, y: 46.8925640012033)),
  'EPSG:3764': ProjectAndUnProjectResult(
      Point(x: 49759786.10502441, y: -18642657.73954776), Point(x: 0, y: -90)),
  'EPSG:3765': ProjectAndUnProjectResult(
      Point(x: 605770.9535936904, y: 5195685.96539144),
      Point(x: 17.88805856028205, y: 46.89226406700813)),
  'EPSG:3766': ProjectAndUnProjectResult(
      Point(x: 105837.67697366881, y: 5679623.375791372),
      Point(x: 17.888058560281515, y: 46.89226406700873)),
  'EPSG:3767': ProjectAndUnProjectResult(
      Point(x: 720001.2298382937, y: 5197241.609971515),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3768': ProjectAndUnProjectResult(
      Point(x: 262945.28796354064, y: 5197894.102609971),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:3769': ProjectAndUnProjectResult(
      Point(x: 5731045.162975267, y: 9058847.080399275),
      Point(x: 17.88805848810356, y: 46.892264074111786)),
  'EPSG:3770': ProjectAndUnProjectResult(
      Point(x: 5702322.033172766, y: 5855606.138266369),
      Point(x: -8926004.214320635, y: 1963487.1834776804)),
  'EPSG:3771': ProjectAndUnProjectResult(
      Point(x: -3830366.5034900955, y: 11195042.8496128), Point(x: 0, y: 90)),
  'EPSG:3772': ProjectAndUnProjectResult(
      Point(x: -5584339.8977337275, y: 10533727.568597334), Point(x: 0, y: 90)),
  'EPSG:3773': ProjectAndUnProjectResult(
      Point(x: -7583447.275791653, y: 9644915.93419388),
      Point(x: 45, y: double.nan)),
  'EPSG:3774': ProjectAndUnProjectResult(
      Point(x: -9852922.31173094, y: 8490832.235667415),
      Point(x: 45, y: double.nan)),
  'EPSG:3775': ProjectAndUnProjectResult(
      Point(x: -3830130.3701628856, y: 11196570.080076331), Point(x: 0, y: 90)),
  'EPSG:3776': ProjectAndUnProjectResult(
      Point(x: -5584176.085407431, y: 10535502.054303104), Point(x: 0, y: 90)),
  'EPSG:3777': ProjectAndUnProjectResult(
      Point(x: -7583376.049417379, y: 9646968.415678004),
      Point(x: 16894389367.28522, y: 5473429537.796048)),
  'EPSG:3778': ProjectAndUnProjectResult(
      Point(x: -9852967.05118569, y: 8493196.416506361),
      Point(x: 4033210.384574377, y: 1716529.2179819506)),
  'EPSG:3779': ProjectAndUnProjectResult(
      Point(x: -3830130.3701628856, y: 11196570.080076331), Point(x: 0, y: 90)),
  'EPSG:3780': ProjectAndUnProjectResult(
      Point(x: -5584176.085407431, y: 10535502.054303104), Point(x: 0, y: 90)),
  'EPSG:3781': ProjectAndUnProjectResult(
      Point(x: -7583376.049417379, y: 9646968.415678004),
      Point(x: 16894389367.28522, y: 5473429537.796048)),
  'EPSG:3782': ProjectAndUnProjectResult(
      Point(x: -9852967.05118569, y: 8493196.416506361),
      Point(x: 4033210.384574377, y: 1716529.2179819506)),
  'EPSG:3783': ProjectAndUnProjectResult(
      Point(x: -19861661.407229125, y: 4840375.223816268),
      Point(x: 3672.385536278773, y: 6427.295982975643)),
  'EPSG:4500': ProjectAndUnProjectResult(
      Point(x: 19822147.018433835, y: 12030963.856938452), Point(x: 0, y: 90)),
  'EPSG:3784': ProjectAndUnProjectResult(
      Point(x: 3005612.3520153333, y: 24244294.5482259),
      Point(x: 17.88805848044886, y: 46.89226419194381)),
  'EPSG:3785': ProjectAndUnProjectResult(
      Point(x: 1991289.5702107965, y: 5924506.521570054),
      Point(x: 17.888058560281515, y: 46.89226406700878)),
  'EPSG:3786': ProjectAndUnProjectResult(
      Point(x: 1989063.5448627048, y: 5214187.592099131),
      Point(x: 17.888058560281515, y: 46.89226406700878)),
  'EPSG:3787': ProjectAndUnProjectResult(
      Point(x: 720441.5911686714, y: 198320.18471309077),
      Point(x: 17.888058563195006, y: 46.89226406711906)),
  'EPSG:3788': ProjectAndUnProjectResult(
      Point(x: 23508992.97721879, y: 11953860.642492454),
      Point(x: -3495.2654541591555, y: 6261.852299637183)),
  'EPSG:3789': ProjectAndUnProjectResult(
      Point(x: 27327750.28054091, y: 9054325.12605308),
      Point(x: -6731.8090189592995, y: -10215.908700804841)),
  'EPSG:3790': ProjectAndUnProjectResult(
      Point(x: 43518643.3112175, y: -5094769.094075678), Point(x: 0, y: -90)),
  'EPSG:3791': ProjectAndUnProjectResult(
      Point(x: 49586485.74482371, y: -11010600.087366953), Point(x: 0, y: -90)),
  'EPSG:3793': ProjectAndUnProjectResult(
      Point(x: 52859786.10502441, y: -14316480.109144565), Point(x: 0, y: -90)),
  'EPSG:3843': ProjectAndUnProjectResult(
      Point(x: 6491592.1383437645, y: 5195408.990945579),
      Point(x: 17.88805857140871, y: 46.8922640695898)),
  'EPSG:3794': ProjectAndUnProjectResult(
      Point(x: 720067.2566197526, y: 198801.4063740922),
      Point(x: 17.888058560302017, y: 46.8922640669565)),
  'EPSG:3795': ProjectAndUnProjectResult(
      Point(x: 8252634.361718159, y: 5734234.3314232705),
      Point(x: 17.888058560281486, y: 46.89226404782306)),
  'EPSG:3796': ProjectAndUnProjectResult(
      Point(x: 8148736.411561452, y: 5547224.271027205),
      Point(x: 17.8880585602815, y: 46.89226404782307)),
  'EPSG:3797': ProjectAndUnProjectResult(
      Point(x: 6135826.579964523, y: 3742577.6135534844),
      Point(x: 17.8880585602815, y: 46.89226404782307)),
  'EPSG:3798': ProjectAndUnProjectResult(
      Point(x: 6135878.182828185, y: 3742375.532173249),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3799': ProjectAndUnProjectResult(
      Point(x: 6135878.182828185, y: 3742375.532173249),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3800': ProjectAndUnProjectResult(
      Point(x: -9852922.31173094, y: 8490832.235667415),
      Point(x: 45, y: double.nan)),
  'EPSG:3801': ProjectAndUnProjectResult(
      Point(x: -9852967.05118569, y: 8493196.416506361),
      Point(x: 4033210.384574377, y: 1716529.2179819506)),
  'EPSG:3802': ProjectAndUnProjectResult(
      Point(x: -9852967.05118569, y: 8493196.416506361),
      Point(x: 4033210.384574377, y: 1716529.2179819506)),
  'EPSG:4580': ProjectAndUnProjectResult(
      Point(x: -4017514.88239266, y: 7451502.995498293),
      Point(x: -29.203847854141863, y: 107.75563598640142)),
  'EPSG:3812': ProjectAndUnProjectResult(
      Point(x: 1676562.2460995112, y: 324549.78576519433),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:3814': ProjectAndUnProjectResult(
      Point(x: 3865026.376812202, y: 9521806.905574037), Point(x: 0, y: 90)),
  'EPSG:3815': ProjectAndUnProjectResult(
      Point(x: 3865026.376812202, y: 9521806.905574037), Point(x: 0, y: 90)),
  'EPSG:3816': ProjectAndUnProjectResult(
      Point(x: 3865026.376812202, y: 9521806.905574037), Point(x: 0, y: 90)),
  'EPSG:3825': ProjectAndUnProjectResult(
      Point(x: -4045746.5963645335, y: 11267350.164167067), Point(x: 0, y: 90)),
  'EPSG:3826': ProjectAndUnProjectResult(
      Point(x: -3805683.3210804434, y: 11453259.871461695), Point(x: 0, y: 90)),
  'EPSG:3827': ProjectAndUnProjectResult(
      Point(x: -4045761.8731131637, y: 11267390.636191206), Point(x: 0, y: 90)),
  'EPSG:3828': ProjectAndUnProjectResult(
      Point(x: -3805697.674542349, y: 11453301.026120776), Point(x: 0, y: 90)),
  'EPSG:3829': ProjectAndUnProjectResult(
      Point(x: -4559584.4478432285, y: 11525141.600966185),
      Point(x: 17.888058241276156, y: 46.892264292407674)),
  'EPSG:3832': ProjectAndUnProjectResult(
      Point(x: -14706634.04878024, y: 5893297.075909311),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3833': ProjectAndUnProjectResult(
      Point(x: 3177292.4585295245, y: 5233913.198984689),
      Point(x: 17.888058447269415, y: 46.89226402919728)),
  'EPSG:3834': ProjectAndUnProjectResult(
      Point(x: 3177291.738831021, y: 5233913.048442174),
      Point(x: 17.88805844634046, y: 46.892264029990585)),
  'EPSG:3835': ProjectAndUnProjectResult(
      Point(x: 3720214.533676548, y: 5199458.992247189),
      Point(x: 17.88805857142926, y: 46.89226406953736)),
  'EPSG:3836': ProjectAndUnProjectResult(
      Point(x: 4262971.247483608, y: 5200102.334203057),
      Point(x: 17.88805857138035, y: 46.89226406950829)),
  'EPSG:3837': ProjectAndUnProjectResult(
      Point(x: 4177292.4585295245, y: 5233913.198984689),
      Point(x: 17.888058447269415, y: 46.89226402919728)),
  'EPSG:3838': ProjectAndUnProjectResult(
      Point(x: 4948797.440905435, y: 5212272.602643184),
      Point(x: 17.888058570467997, y: 46.89226406511432)),
  'EPSG:3839': ProjectAndUnProjectResult(
      Point(x: 8805908.013583425, y: 5235855.842461305),
      Point(x: 17.888058730440267, y: 46.89226402351891)),
  'EPSG:3840': ProjectAndUnProjectResult(
      Point(x: 9577571.257314079, y: 5267092.896177837),
      Point(x: 17.888060896105355, y: 46.89226389559344)),
  'EPSG:3841': ProjectAndUnProjectResult(
      Point(x: 6491592.1383437645, y: 5195408.990945579),
      Point(x: 17.88805857140871, y: 46.8922640695898)),
  'EPSG:3842': ProjectAndUnProjectResult(
      Point(x: 6491592.1383437645, y: 5195408.990945579),
      Point(x: 17.88805857140871, y: 46.8922640695898)),
  'EPSG:3844': ProjectAndUnProjectResult(
      Point(x: -41341.30947954103, y: 623553.6394246925),
      Point(x: 17.88805857428828, y: 46.89226406887063)),
  'EPSG:3845': ProjectAndUnProjectResult(
      Point(x: 2001546.03277511, y: 5215709.308746594),
      Point(x: 17.888058553945477, y: 46.892264059921224)),
  'EPSG:3846': ProjectAndUnProjectResult(
      Point(x: 1830146.453751276, y: 5203751.662381472),
      Point(x: 17.888058560322833, y: 46.89226406641694)),
  'EPSG:3847': ProjectAndUnProjectResult(
      Point(x: 1658712.2897811641, y: 5196736.080162084),
      Point(x: 17.8880585602857, y: 46.892264067001435)),
  'EPSG:3848': ProjectAndUnProjectResult(
      Point(x: 1487261.984023453, y: 5194642.981301733),
      Point(x: 17.888058560281515, y: 46.89226406700878)),
  'EPSG:3849': ProjectAndUnProjectResult(
      Point(x: 1315812.9384282234, y: 5197466.4870422),
      Point(x: 17.888058560272697, y: 46.89226406699075)),
  'EPSG:3850': ProjectAndUnProjectResult(
      Point(x: 1144382.5556121343, y: 5205214.671890977),
      Point(x: 17.888058560307403, y: 46.89226406608369)),
  'EPSG:3851': ProjectAndUnProjectResult(
      Point(x: -18977849.49411334, y: -4931722.017871851),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:3852': ProjectAndUnProjectResult(
      Point(x: -20458557.0628475, y: -21767259.770745546),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:4884': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3854': ProjectAndUnProjectResult(
      Point(x: 87241.68909288984, y: -1305361.7569410224),
      Point(x: 17.888058560281515, y: 46.892264067008796)),
  'EPSG:3857': ProjectAndUnProjectResult(
      Point(x: 1991289.5702107965, y: 5924506.521570054),
      Point(x: 17.888058560281515, y: 46.89226406700878)),
  'EPSG:3873': ProjectAndUnProjectResult(
      Point(x: 19415260.682278004, y: 5195870.378755134),
      Point(x: 17.888058560281344, y: 46.892264067008604)),
  'EPSG:3874': ProjectAndUnProjectResult(
      Point(x: 20339053.95380402, y: 5197436.0837356355),
      Point(x: 17.888058560276995, y: 46.892264067000774)),
  'EPSG:3875': ProjectAndUnProjectResult(
      Point(x: 21262850.428132128, y: 5199974.092247936),
      Point(x: 17.888058560253103, y: 46.89226406692703)),
  'EPSG:3876': ProjectAndUnProjectResult(
      Point(x: 22186651.682095855, y: 5203485.806494309),
      Point(x: 17.888058560226185, y: 46.892264066575265)),
  'EPSG:3877': ProjectAndUnProjectResult(
      Point(x: 23110459.361974485, y: 5207973.165191365),
      Point(x: 17.88805856056331, y: 46.89226406541965)),
  'EPSG:3878': ProjectAndUnProjectResult(
      Point(x: 24034275.206084784, y: 5213438.643234651),
      Point(x: 17.888058563129807, y: 46.892264062424815)),
  'EPSG:3879': ProjectAndUnProjectResult(
      Point(x: 24958101.06760197, y: 5219885.251244588),
      Point(x: 17.88805857434855, y: 46.89226405586626)),
  'EPSG:3880': ProjectAndUnProjectResult(
      Point(x: 25881938.937665485, y: 5227316.534974944),
      Point(x: 17.888058612001327, y: 46.89226404327183)),
  'EPSG:3882': ProjectAndUnProjectResult(
      Point(x: 27729659.498885166, y: 5245149.983579845),
      Point(x: 17.888058985876285, y: 46.89226398852624)),
  'EPSG:3883': ProjectAndUnProjectResult(
      Point(x: 28653547.075196378, y: 5255561.907893532),
      Point(x: 17.888059595624597, y: 46.892263943722426)),
  'EPSG:3884': ProjectAndUnProjectResult(
      Point(x: 29577456.479461372, y: 5266978.024236943),
      Point(x: 17.88806088688771, y: 46.892263893655276)),
  'EPSG:3885': ProjectAndUnProjectResult(
      Point(x: 30501390.753099304, y: 5279404.538514145),
      Point(x: 17.888063459754676, y: 46.89226385836239)),
  'EPSG:3890': ProjectAndUnProjectResult(
      Point(x: -1105125.3251090779, y: 5413941.604463775),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:3891': ProjectAndUnProjectResult(
      Point(x: -1557536.0364113871, y: 5561947.769793502),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:3892': ProjectAndUnProjectResult(
      Point(x: -2005502.5012535215, y: 5751885.308795742),
      Point(x: 17.888058560281532, y: 46.892264067008796)),
  'EPSG:3893': ProjectAndUnProjectResult(
      Point(x: -1369606.4975917106, y: 2394150.580290248),
      Point(x: 17.897306238005868, y: 46.89314965105123)),
  'EPSG:3907': ProjectAndUnProjectResult(
      Point(x: 5720441.9003260825, y: 5198321.17970864),
      Point(x: 17.888058599075265, y: 46.89226406920315)),
  'EPSG:3908': ProjectAndUnProjectResult(
      Point(x: 6491873.651574707, y: 5194261.4486098),
      Point(x: 17.888058599054723, y: 46.89226406925582)),
  'EPSG:4886': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3909': ProjectAndUnProjectResult(
      Point(x: 7263306.8569601495, y: 5198942.980445724),
      Point(x: 17.88805859902672, y: 46.892264069175155)),
  'EPSG:3910': ProjectAndUnProjectResult(
      Point(x: 8034783.418643825, y: 5212389.0560713485),
      Point(x: 17.888058601884644, y: 46.89226406470986)),
  'EPSG:3911': ProjectAndUnProjectResult(
      Point(x: 720441.9003260823, y: 5198321.17970864),
      Point(x: 17.888058599075265, y: 46.89226406920315)),
  'EPSG:3912': ProjectAndUnProjectResult(
      Point(x: 720441.9003260823, y: 198321.1797086401),
      Point(x: 17.888058599075265, y: 46.89226406920315)),
  'EPSG:3920': ProjectAndUnProjectResult(
      Point(x: 5730697.674323728, y: 9059144.78264604),
      Point(x: 17.888058574820644, y: 46.89226401631602)),
  'EPSG:3942': ProjectAndUnProjectResult(
      Point(x: 2833019.020964736, y: 1843010.238864202),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3943': ProjectAndUnProjectResult(
      Point(x: 2831230.4452139637, y: 2733351.460029819),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:3944': ProjectAndUnProjectResult(
      Point(x: 2829809.467316524, y: 3623806.128266886),
      Point(x: 17.888058560281515, y: 46.89226406700873)),
  'EPSG:3945': ProjectAndUnProjectResult(
      Point(x: 2828749.7083356986, y: 4514339.235565409),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:4501': ProjectAndUnProjectResult(
      Point(x: 22395400.682228316, y: 12183637.356165713), Point(x: 0, y: 90)),
  'EPSG:3946': ProjectAndUnProjectResult(
      Point(x: 2828044.8465021546, y: 5404916.276155287),
      Point(x: 17.888058560281515, y: 46.89226406700872)),
  'EPSG:3947': ProjectAndUnProjectResult(
      Point(x: 2827688.5944718597, y: 6295503.259692606),
      Point(x: 17.888058560281518, y: 46.89226406700873)),
  'EPSG:3948': ProjectAndUnProjectResult(
      Point(x: 2827674.6755720135, y: 7186066.727791753),
      Point(x: 17.888058560281515, y: 46.89226406700873)),
  'EPSG:3949': ProjectAndUnProjectResult(
      Point(x: 2827996.798953069, y: 8076573.774209488),
      Point(x: 17.888058560281515, y: 46.89226406700874)),
  'EPSG:3950': ProjectAndUnProjectResult(
      Point(x: 2828648.6335579734, y: 8966992.069017563),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:3968': ProjectAndUnProjectResult(
      Point(x: 6197425.928759272, y: 4812816.468950871),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3969': ProjectAndUnProjectResult(
      Point(x: 6197425.928759272, y: 4812816.468950871),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3970': ProjectAndUnProjectResult(
      Point(x: 6197425.928759272, y: 4812816.468950871),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:3973': ProjectAndUnProjectResult(
      Point(x: 1441907.3090332332, y: -4467414.170635901),
      Point(x: 17.888058560281515, y: 46.89226406911223)),
  'EPSG:4888': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3976': ProjectAndUnProjectResult(
      Point(x: 9541577.97711848, y: 29562358.411087077),
      Point(x: 17.888058560281515, y: 46.89226406700872)),
  'EPSG:3978': ProjectAndUnProjectResult(
      Point(x: 4788140.837784415, y: 5644744.4698402),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3979': ProjectAndUnProjectResult(
      Point(x: 4788140.837784415, y: 5644744.4698402),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:3985': ProjectAndUnProjectResult(
      Point(x: -555285.4323544791, y: 5877947.93768952),
      Point(x: 17.888058574909916, y: 46.89226391727645)),
  'EPSG:3986': ProjectAndUnProjectResult(
      Point(x: -722541.7847238699, y: 6762290.366029819),
      Point(x: 17.88806090026733, y: 46.89226374072787)),
  'EPSG:3987': ProjectAndUnProjectResult(
      Point(x: -570342.9657933954, y: 6740461.229478745),
      Point(x: 17.88805900001187, y: 46.892263837701535)),
  'EPSG:3988': ProjectAndUnProjectResult(
      Point(x: -418067.6393746793, y: 6722626.775799283),
      Point(x: 17.88805862648417, y: 46.89226389324595)),
  'EPSG:3989': ProjectAndUnProjectResult(
      Point(x: -265735.4130786186, y: 6708747.971663814),
      Point(x: 17.8880585777285, y: 46.89226391263836)),
  'EPSG:3991': ProjectAndUnProjectResult(
      Point(x: 23885697.09035628, y: 16541981.799064778),
      Point(x: 17.888058574820878, y: 46.892264016315934)),
  'EPSG:3992': ProjectAndUnProjectResult(
      Point(x: 23885697.09035628, y: 16641981.799064776),
      Point(x: 17.888058574820878, y: 46.892264016315934)),
  'EPSG:3994': ProjectAndUnProjectResult(
      Point(x: -6908503.39310654, y: 4454149.375643825),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:3995': ProjectAndUnProjectResult(
      Point(x: 1507854.0805850122, y: -4671734.892149989),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:3996': ProjectAndUnProjectResult(
      Point(x: 1523661.2362762848, y: -4720709.684697498),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:3997': ProjectAndUnProjectResult(
      Point(x: -2325776.769166882, y: 5919332.318772699),
      Point(x: 18.05485171379697, y: 46.913391088377765)),
  'EPSG:4026': ProjectAndUnProjectResult(
      Point(x: -600739.8591220279, y: 248879.67376995925),
      Point(x: 17.8880591741222, y: 46.89226397184953)),
  'EPSG:4037': ProjectAndUnProjectResult(
      Point(x: -193931.34631864005, y: 5233642.279820906),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:4038': ProjectAndUnProjectResult(
      Point(x: -650192.180968157, y: 5305193.277388473),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:4048': ProjectAndUnProjectResult(
      Point(x: 948624.4014177459, y: 15211608.67817156),
      Point(x: 17.888058558416994, y: 46.89226406333179)),
  'EPSG:4049': ProjectAndUnProjectResult(
      Point(x: 796259.5929516172, y: 15202094.645796508),
      Point(x: 17.88805856033801, y: 46.892264066698644)),
  'EPSG:4890': ProjectAndUnProjectResult(
      Point(x: 4155364.3394141337, y: 1341189.7764214745),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:4050': ProjectAndUnProjectResult(
      Point(x: 643870.49935693, y: 15196481.41480021),
      Point(x: 17.88805856028407, y: 46.892264067004696)),
  'EPSG:4051': ProjectAndUnProjectResult(
      Point(x: 491469.93683953484, y: 15194756.584238794),
      Point(x: 17.888058560281515, y: 46.89226406700878)),
  'EPSG:4056': ProjectAndUnProjectResult(
      Point(x: 339070.0484086412, y: 15196916.340127263),
      Point(x: 17.888058560277017, y: 46.89226406700078)),
  'EPSG:4057': ProjectAndUnProjectResult(
      Point(x: 186683.01692764752, y: 15202965.45791366),
      Point(x: 17.888058560226206, y: 46.89226406657527)),
  'EPSG:4058': ProjectAndUnProjectResult(
      Point(x: 34321.77856417687, y: 15212917.299370328),
      Point(x: 17.888058563129825, y: 46.89226406242482)),
  'EPSG:4059': ProjectAndUnProjectResult(
      Point(x: -117999.2562282806, y: 15226793.803321447),
      Point(x: 17.888058612001338, y: 46.89226404327183)),
  'EPSG:4060': ProjectAndUnProjectResult(
      Point(x: -270263.4670647214, y: 15244625.468581486),
      Point(x: 17.8880589858763, y: 46.89226398852623)),
  'EPSG:4061': ProjectAndUnProjectResult(
      Point(x: 720001.2298382937, y: 15197241.609971516),
      Point(x: 17.888058560281515, y: 46.892264067008796)),
  'EPSG:4062': ProjectAndUnProjectResult(
      Point(x: 262945.28796354064, y: 15197894.10260997),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:4063': ProjectAndUnProjectResult(
      Point(x: -193931.34632474044, y: 15233642.279699989),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:4071': ProjectAndUnProjectResult(
      Point(x: 5009624.535923446, y: 17424519.78737468),
      Point(x: 17.88805848358572, y: 46.89226408014934)),
  'EPSG:4082': ProjectAndUnProjectResult(
      Point(x: 3429824.9011676833, y: 5977306.903604053),
      Point(x: 17.888058560281515, y: 46.89226406700878)),
  'EPSG:4083': ProjectAndUnProjectResult(
      Point(x: 2988897.836886672, y: 5744008.821518749),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:4087': ProjectAndUnProjectResult(
      Point(x: 1991289.5702107965, y: 5220022.958083138),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4088': ProjectAndUnProjectResult(
      Point(x: 1989063.5448627048, y: 5214187.592099131),
      Point(x: 17.888058560281515, y: 46.89226406700878)),
  'EPSG:4093': ProjectAndUnProjectResult(
      Point(x: 877148.6088370954, y: 233660.6648475537),
      Point(x: 17.88805843543735, y: 46.892264027445336)),
  'EPSG:4094': ProjectAndUnProjectResult(
      Point(x: 1000998.7964341316, y: 225462.53667102847),
      Point(x: 17.88805852091921, y: 46.89226404676562)),
  'EPSG:4095': ProjectAndUnProjectResult(
      Point(x: 1067705.024527477, y: 213490.246378907),
      Point(x: 17.88805855729504, y: 46.89226406230804)),
  'EPSG:4096': ProjectAndUnProjectResult(
      Point(x: 1020089.2655463072, y: 199321.33850794286),
      Point(x: 17.888058560302017, y: 46.89226406695651)),
  'EPSG:4217': ProjectAndUnProjectResult(
      Point(x: 88938715.0033994, y: -10446932.952938655),
      Point(x: -103767.21820745953, y: -188871.77584871996)),
  'EPSG:4390': ProjectAndUnProjectResult(
      Point(x: -5698165.362472042, y: 9736035.912200946),
      Point(x: 45, y: double.nan)),
  'EPSG:4391': ProjectAndUnProjectResult(
      Point(x: -5604622.307152719, y: 9438907.891860066),
      Point(x: 45, y: double.nan)),
  'EPSG:4392': ProjectAndUnProjectResult(
      Point(x: -5632958.824296879, y: 9396433.12592997),
      Point(x: 45, y: double.nan)),
  'EPSG:4393': ProjectAndUnProjectResult(
      Point(x: -5601177.96215366, y: 9330757.128539324),
      Point(x: 45, y: double.nan)),
  'EPSG:4394': ProjectAndUnProjectResult(
      Point(x: -5659498.2444535075, y: 9322620.390490994),
      Point(x: 45, y: double.nan)),
  'EPSG:4395': ProjectAndUnProjectResult(
      Point(x: -5512526.412522346, y: 8929130.571910942),
      Point(x: 45, y: double.nan)),
  'EPSG:4396': ProjectAndUnProjectResult(
      Point(x: -5529298.499217718, y: 8907078.102076367),
      Point(x: 45, y: double.nan)),
  'EPSG:4397': ProjectAndUnProjectResult(
      Point(x: -5539604.655705645, y: 9186310.35590149),
      Point(x: 45, y: double.nan)),
  'EPSG:4398': ProjectAndUnProjectResult(
      Point(x: -5618007.426769636, y: 9119926.757573389),
      Point(x: 45, y: double.nan)),
  'EPSG:4399': ProjectAndUnProjectResult(
      Point(x: 88935000.54071158, y: -10461985.857209712),
      Point(x: -135, y: double.nan)),
  'EPSG:4400': ProjectAndUnProjectResult(
      Point(x: 120704859.06530087, y: -38143370.72328647), Point(x: 0, y: -90)),
  'EPSG:4401': ProjectAndUnProjectResult(
      Point(x: 159868822.122673, y: -76067708.87164263), Point(x: 0, y: -90)),
  'EPSG:4402': ProjectAndUnProjectResult(
      Point(x: 207772968.42297474, y: -126921833.20002197),
      Point(x: 0, y: -90)),
  'EPSG:4403': ProjectAndUnProjectResult(
      Point(x: 265956861.69256803, y: -193933682.1282317), Point(x: 0, y: -90)),
  'EPSG:4404': ProjectAndUnProjectResult(
      Point(x: -260300418.2619906, y: -191099809.5784561), Point(x: 0, y: -90)),
  'EPSG:4405': ProjectAndUnProjectResult(
      Point(x: -202530203.9613096, y: -124755906.71256794),
      Point(x: 0, y: -90)),
  'EPSG:4406': ProjectAndUnProjectResult(
      Point(x: -154978576.1760372, y: -74438616.12302032), Point(x: 0, y: -90)),
  'EPSG:4407': ProjectAndUnProjectResult(
      Point(x: -116113552.92774132, y: -36941624.14776285),
      Point(x: 0, y: -90)),
  'EPSG:4408': ProjectAndUnProjectResult(
      Point(x: -84595894.09133668, y: -9596798.322538331),
      Point(x: -135, y: double.nan)),
  'EPSG:4409': ProjectAndUnProjectResult(
      Point(x: -59259905.39206796, y: 9799874.399589209),
      Point(x: 45, y: double.nan)),
  'EPSG:4410': ProjectAndUnProjectResult(
      Point(x: -39095596.9440437, y: 23054449.05308375),
      Point(x: 45, y: double.nan)),
  'EPSG:4411': ProjectAndUnProjectResult(
      Point(x: -23232145.17953647, y: 31633867.73619707),
      Point(x: 45, y: double.nan)),
  'EPSG:4412': ProjectAndUnProjectResult(
      Point(x: -10922607.018261168, y: 36718049.92619765), Point(x: 0, y: 90)),
  'EPSG:4413': ProjectAndUnProjectResult(
      Point(x: -1529835.1258436253, y: 39245767.121649496), Point(x: 0, y: 90)),
  'EPSG:4414': ProjectAndUnProjectResult(
      Point(x: 2872651.044108846, y: 10239580.122362612), Point(x: 0, y: 90)),
  'EPSG:4415': ProjectAndUnProjectResult(
      Point(x: -555285.4323544791, y: 7899348.5500682),
      Point(x: 17.888058574909916, y: 46.89226391727645)),
  'EPSG:4417': ProjectAndUnProjectResult(
      Point(x: 7262971.247483608, y: 5200102.334203057),
      Point(x: 17.88805857138035, y: 46.89226406950829)),
  'EPSG:4418': ProjectAndUnProjectResult(
      Point(x: 17836313.255478315, y: 34155707.45323411), Point(x: 0, y: 90)),
  'EPSG:4419': ProjectAndUnProjectResult(
      Point(x: 18455654.406312, y: 31999659.633512203),
      Point(x: 45, y: double.nan)),
  'EPSG:4420': ProjectAndUnProjectResult(
      Point(x: 120711027.01744448, y: -38124224.251886696),
      Point(x: 0, y: -90)),
  'EPSG:4421': ProjectAndUnProjectResult(
      Point(x: 159878270.15268376, y: -76043595.72386795), Point(x: 0, y: -90)),
  'EPSG:4422': ProjectAndUnProjectResult(
      Point(x: 207786717.28854117, y: -126891735.77586052),
      Point(x: 0, y: -90)),
  'EPSG:4423': ProjectAndUnProjectResult(
      Point(x: 265976159.2703571, y: -193896420.40558997), Point(x: 0, y: -90)),
  'EPSG:4424': ProjectAndUnProjectResult(
      Point(x: -260319483.40132633, y: -191062838.45258427),
      Point(x: 0, y: -90)),
  'EPSG:4425': ProjectAndUnProjectResult(
      Point(x: -202543771.45124903, y: -124726052.71252203),
      Point(x: 0, y: -90)),
  'EPSG:4426': ProjectAndUnProjectResult(
      Point(x: -154987884.78186262, y: -74414705.62767036),
      Point(x: 0, y: -90)),
  'EPSG:4427': ProjectAndUnProjectResult(
      Point(x: -116119615.59344277, y: -36922645.26111874),
      Point(x: 0, y: -90)),
  'EPSG:4428': ProjectAndUnProjectResult(
      Point(x: -84599530.74940829, y: -9581882.999723151),
      Point(x: 72517.82979839812, y: -135482.78856909217)),
  'EPSG:4429': ProjectAndUnProjectResult(
      Point(x: -59261772.16655555, y: 9811466.737202346),
      Point(x: 5728.679566272616, y: 8118.480468517206)),
  'EPSG:4430': ProjectAndUnProjectResult(
      Point(x: -39096212.01512539, y: 23063346.500061978),
      Point(x: 169423.46825792495, y: 95274.64648021973)),
  'EPSG:4431': ProjectAndUnProjectResult(
      Point(x: -23231911.56778511, y: 31640599.5655093),
      Point(x: 16894389367.285646, y: 5473429537.796183)),
  'EPSG:4432': ProjectAndUnProjectResult(
      Point(x: -10921832.53660762, y: 36723059.011483155), Point(x: 0, y: 90)),
  'EPSG:4433': ProjectAndUnProjectResult(
      Point(x: -1528749.7371275797, y: 39249421.19555604), Point(x: 0, y: 90)),
  'EPSG:4434': ProjectAndUnProjectResult(
      Point(x: 8034393.775641421, y: 5213562.361972831),
      Point(x: 17.888058574249374, y: 46.8922640650136)),
  'EPSG:4437': ProjectAndUnProjectResult(
      Point(x: 7328037.617013937, y: 5241769.00316173),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:4438': ProjectAndUnProjectResult(
      Point(x: 17837293.744256232, y: 34156128.956405975), Point(x: 0, y: 90)),
  'EPSG:4439': ProjectAndUnProjectResult(
      Point(x: 18456500.482903223, y: 31999856.186349962),
      Point(x: -14563147143.452982, y: 3188443837.820243)),
  'EPSG:4455': ProjectAndUnProjectResult(
      Point(x: 21631580.131799556, y: 14568195.981304659),
      Point(x: 17.88805856028152, y: 46.89226404782306)),
  'EPSG:4892': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:4456': ProjectAndUnProjectResult(
      Point(x: 21096015.858215142, y: 13482884.173489098),
      Point(x: 17.88805856028152, y: 46.89226404782306)),
  'EPSG:4457': ProjectAndUnProjectResult(
      Point(x: 22086296.488457482, y: 19050428.99191546),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:4462': ProjectAndUnProjectResult(
      Point(x: -18477009.85363386, y: 2101847.384202445),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:4467': ProjectAndUnProjectResult(
      Point(x: 5558786.502469642, y: 8470922.227642598),
      Point(x: 17.88805856028146, y: 46.89226406700888)),
  'EPSG:4471': ProjectAndUnProjectResult(
      Point(x: -1557536.0364113871, y: 15561947.769793503),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:4474': ProjectAndUnProjectResult(
      Point(x: -1557696.3070654601, y: 15562079.323209908),
      Point(x: 17.888058591658083, y: 46.89226406997221)),
  'EPSG:4484': ProjectAndUnProjectResult(
      Point(x: 3875003.072767595, y: 13725397.247874938),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:4485': ProjectAndUnProjectResult(
      Point(x: 4286275.534235133, y: 13389860.739087315),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:4486': ProjectAndUnProjectResult(
      Point(x: 4671946.775898903, y: 12999702.032507129),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:4487': ProjectAndUnProjectResult(
      Point(x: 5021971.586011266, y: 12553749.126989897),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:4488': ProjectAndUnProjectResult(
      Point(x: 5324476.5639229575, y: 12053400.324134082),
      Point(x: 17.88805856028146, y: 46.89226406700884)),
  'EPSG:4489': ProjectAndUnProjectResult(
      Point(x: 5566585.223791351, y: 11503707.444009647),
      Point(x: 17.888058560281575, y: 46.892264067008874)),
  'EPSG:4491': ProjectAndUnProjectResult(
      Point(x: 9328493.421913693, y: 7001526.991761912),
      Point(x: 66.46978443301275, y: 55.68536724688989)),
  'EPSG:4492': ProjectAndUnProjectResult(
      Point(x: 9982560.551391073, y: 7451374.141728269),
      Point(x: -29.203552236066788, y: 107.75568998077281)),
  'EPSG:4493': ProjectAndUnProjectResult(
      Point(x: 10690684.498695083, y: 7959551.541609481),
      Point(x: 2295.099359534543, y: 590.2186928219294)),
  'EPSG:4494': ProjectAndUnProjectResult(
      Point(x: 11473397.65464337, y: 8523387.62801148),
      Point(x: 38040.256750950364, y: 8289.769436944347)),
  'EPSG:4495': ProjectAndUnProjectResult(
      Point(x: 12357225.865975516, y: 9135545.190129392),
      Point(x: 2043698.7544900102, y: 448818.1175920101)),
  'EPSG:4496': ProjectAndUnProjectResult(
      Point(x: 13375991.145964216, y: 9781974.28340822),
      Point(x: 30362279619.50587, y: 6642887099.33437)),
  'EPSG:4497': ProjectAndUnProjectResult(
      Point(x: 14572309.67756597, y: 10439322.446499031), Point(x: 0, y: 90)),
  'EPSG:4498': ProjectAndUnProjectResult(
      Point(x: 15999300.709230509, y: 11071712.985662593), Point(x: 0, y: 90)),
  'EPSG:4499': ProjectAndUnProjectResult(
      Point(x: 17722521.94348809, y: 11626795.236313414), Point(x: 0, y: 90)),
  'EPSG:4502': ProjectAndUnProjectResult(
      Point(x: -3671506.5780863077, y: 7001526.991761912),
      Point(x: 66.4697844330128, y: 55.685367246889896)),
  'EPSG:4503': ProjectAndUnProjectResult(
      Point(x: -4017439.4486089284, y: 7451374.141728269),
      Point(x: -29.203552236066432, y: 107.75568998077289)),
  'EPSG:4504': ProjectAndUnProjectResult(
      Point(x: -4309315.501304916, y: 7959551.541609481),
      Point(x: 2295.09935953454, y: 590.2186928219286)),
  'EPSG:4505': ProjectAndUnProjectResult(
      Point(x: -4526602.34535663, y: 8523387.62801148),
      Point(x: 38040.256750950364, y: 8289.769436944347)),
  'EPSG:4506': ProjectAndUnProjectResult(
      Point(x: -4642774.134024484, y: 9135545.190129392),
      Point(x: 2043698.7544900102, y: 448818.1175920101)),
  'EPSG:4507': ProjectAndUnProjectResult(
      Point(x: -4624008.8540357845, y: 9781974.28340822),
      Point(x: 30362279619.50589, y: 6642887099.334377)),
  'EPSG:4508': ProjectAndUnProjectResult(
      Point(x: -4427690.32243403, y: 10439322.446499031), Point(x: 0, y: 90)),
  'EPSG:4509': ProjectAndUnProjectResult(
      Point(x: -4000699.2907694904, y: 11071712.985662593), Point(x: 0, y: 90)),
  'EPSG:4510': ProjectAndUnProjectResult(
      Point(x: -3277478.0565119097, y: 11626795.236313414), Point(x: 0, y: 90)),
  'EPSG:4511': ProjectAndUnProjectResult(
      Point(x: -2177852.9815661646, y: 12030963.856938452), Point(x: 0, y: 90)),
  'EPSG:4512': ProjectAndUnProjectResult(
      Point(x: -604599.3177716827, y: 12183637.356165713), Point(x: 0, y: 90)),
  'EPSG:4513': ProjectAndUnProjectResult(
      Point(x: 21328493.42191369, y: 7001526.991761912),
      Point(x: 66.46978443301293, y: 55.68536724688992)),
  'EPSG:4514': ProjectAndUnProjectResult(
      Point(x: 22149850.9068178, y: 7219128.371007296),
      Point(x: 138.3748532318848, y: 69.53969094405605)),
  'EPSG:4515': ProjectAndUnProjectResult(
      Point(x: 22982560.551391073, y: 7451374.141728269),
      Point(x: -29.203552236066788, y: 107.75568998077281)),
  'EPSG:4516': ProjectAndUnProjectResult(
      Point(x: 23828708.620324224, y: 7698249.8329235),
      Point(x: 525.4502355842208, y: 220.8876600242989)),
  'EPSG:4517': ProjectAndUnProjectResult(
      Point(x: 24690684.498695083, y: 7959551.541609481),
      Point(x: 2295.099359534543, y: 590.2186928219294)),
  'EPSG:4518': ProjectAndUnProjectResult(
      Point(x: 25571214.38243999, y: 8234839.92570492),
      Point(x: 8796.331693915801, y: 1973.2780739093816)),
  'EPSG:4519': ProjectAndUnProjectResult(
      Point(x: 26473397.65464337, y: 8523387.62801148),
      Point(x: 38040.25675095029, y: 8289.769436944327)),
  'EPSG:4520': ProjectAndUnProjectResult(
      Point(x: 27400746.069521375, y: 8824119.52784918),
      Point(x: 216927.18580758735, y: 47354.206459627494)),
  'EPSG:4521': ProjectAndUnProjectResult(
      Point(x: 28357225.865975514, y: 9135545.190129392),
      Point(x: 2043698.7544900167, y: 448818.1175920118)),
  'EPSG:4522': ProjectAndUnProjectResult(
      Point(x: 29347302.932592206, y: 9455682.854873288),
      Point(x: 53527735.06390822, y: 11775410.229742318)),
  'EPSG:4523': ProjectAndUnProjectResult(
      Point(x: 30375991.145964216, y: 9781974.28340822),
      Point(x: 30362279619.50587, y: 6642887099.33437)),
  'EPSG:4524': ProjectAndUnProjectResult(
      Point(x: 31448904.00420986, y: 10111189.750699412), Point(x: 0, y: 90)),
  'EPSG:4525': ProjectAndUnProjectResult(
      Point(x: 32572309.67756597, y: 10439322.446499031), Point(x: 0, y: 90)),
  'EPSG:4526': ProjectAndUnProjectResult(
      Point(x: 33753189.59793045, y: 10761471.521219483), Point(x: 0, y: 90)),
  'EPSG:4527': ProjectAndUnProjectResult(
      Point(x: 34999300.70923051, y: 11071712.985662593), Point(x: 0, y: 90)),
  'EPSG:4528': ProjectAndUnProjectResult(
      Point(x: 36319241.50049229, y: 11362957.64696107), Point(x: 0, y: 90)),
  'EPSG:4529': ProjectAndUnProjectResult(
      Point(x: 37722521.94348809, y: 11626795.236313414), Point(x: 0, y: 90)),
  'EPSG:4530': ProjectAndUnProjectResult(
      Point(x: 39219637.456836805, y: 11853323.85731819), Point(x: 0, y: 90)),
  'EPSG:4531': ProjectAndUnProjectResult(
      Point(x: 40822147.01843384, y: 12030963.856938452), Point(x: 0, y: 90)),
  'EPSG:4532': ProjectAndUnProjectResult(
      Point(x: 42542755.54808611, y: 12146255.194351697), Point(x: 0, y: 90)),
  'EPSG:4533': ProjectAndUnProjectResult(
      Point(x: 44395400.68222832, y: 12183637.356165713), Point(x: 0, y: 90)),
  'EPSG:4894': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:4534': ProjectAndUnProjectResult(
      Point(x: -3671506.5780863077, y: 7001526.991761912),
      Point(x: 66.4697844330128, y: 55.685367246889896)),
  'EPSG:4535': ProjectAndUnProjectResult(
      Point(x: -3850149.093182198, y: 7219128.371007296),
      Point(x: 138.37485323188466, y: 69.53969094405603)),
  'EPSG:4536': ProjectAndUnProjectResult(
      Point(x: -4017439.4486089284, y: 7451374.141728269),
      Point(x: -29.203552236066432, y: 107.75568998077289)),
  'EPSG:4537': ProjectAndUnProjectResult(
      Point(x: -4171291.379675775, y: 7698249.8329235),
      Point(x: 525.4502355842197, y: 220.88766002429873)),
  'EPSG:4538': ProjectAndUnProjectResult(
      Point(x: -4309315.501304916, y: 7959551.541609481),
      Point(x: 2295.09935953454, y: 590.2186928219286)),
  'EPSG:4539': ProjectAndUnProjectResult(
      Point(x: -4428785.617560011, y: 8234839.92570492),
      Point(x: 8796.331693915807, y: 1973.2780739093832)),
  'EPSG:4540': ProjectAndUnProjectResult(
      Point(x: -4526602.34535663, y: 8523387.62801148),
      Point(x: 38040.256750950364, y: 8289.769436944347)),
  'EPSG:4541': ProjectAndUnProjectResult(
      Point(x: -4599253.930478623, y: 8824119.52784918),
      Point(x: 216927.18580758662, y: 47354.20645962731)),
  'EPSG:4542': ProjectAndUnProjectResult(
      Point(x: -4642774.134024484, y: 9135545.190129392),
      Point(x: 2043698.7544900102, y: 448818.1175920101)),
  'EPSG:4543': ProjectAndUnProjectResult(
      Point(x: -4652697.067407792, y: 9455682.854873288),
      Point(x: 53527735.06390806, y: 11775410.22974228)),
  'EPSG:4544': ProjectAndUnProjectResult(
      Point(x: -4624008.8540357845, y: 9781974.28340822),
      Point(x: 30362279619.50589, y: 6642887099.334377)),
  'EPSG:4545': ProjectAndUnProjectResult(
      Point(x: -4551095.995790138, y: 10111189.750699412), Point(x: 0, y: 90)),
  'EPSG:4546': ProjectAndUnProjectResult(
      Point(x: -4427690.32243403, y: 10439322.446499031), Point(x: 0, y: 90)),
  'EPSG:4547': ProjectAndUnProjectResult(
      Point(x: -4246810.402069545, y: 10761471.521219483), Point(x: 0, y: 90)),
  'EPSG:4548': ProjectAndUnProjectResult(
      Point(x: -4000699.2907694904, y: 11071712.985662593), Point(x: 0, y: 90)),
  'EPSG:4549': ProjectAndUnProjectResult(
      Point(x: -3680758.499507707, y: 11362957.64696107), Point(x: 0, y: 90)),
  'EPSG:4550': ProjectAndUnProjectResult(
      Point(x: -3277478.0565119097, y: 11626795.236313414), Point(x: 0, y: 90)),
  'EPSG:4551': ProjectAndUnProjectResult(
      Point(x: -2780362.5431631915, y: 11853323.85731819), Point(x: 0, y: 90)),
  'EPSG:4552': ProjectAndUnProjectResult(
      Point(x: -2177852.9815661646, y: 12030963.856938452), Point(x: 0, y: 90)),
  'EPSG:4553': ProjectAndUnProjectResult(
      Point(x: -1457244.451913892, y: 12146255.194351697), Point(x: 0, y: 90)),
  'EPSG:4554': ProjectAndUnProjectResult(
      Point(x: -604599.3177716827, y: 12183637.356165713), Point(x: 0, y: 90)),
  'EPSG:4578': ProjectAndUnProjectResult(
      Point(x: 22395376.874081958, y: 12183844.391650796), Point(x: 0, y: 90)),
  'EPSG:4559': ProjectAndUnProjectResult(
      Point(x: 5731020.405467821, y: 9059228.545130335),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:4568': ProjectAndUnProjectResult(
      Point(x: 9328423.823522527, y: 7001648.429185124),
      Point(x: 66.4697524630901, y: 55.68536132961955)),
  'EPSG:4569': ProjectAndUnProjectResult(
      Point(x: 9982485.11760734, y: 7451502.995498293),
      Point(x: -29.203847854141863, y: 107.75563598640142)),
  'EPSG:4570': ProjectAndUnProjectResult(
      Point(x: 10690604.086843932, y: 7959688.766689891),
      Point(x: 2295.0956176115287, y: 590.2180007982697)),
  'EPSG:4571': ProjectAndUnProjectResult(
      Point(x: 11473313.44824759, y: 8523534.136687467),
      Point(x: 38040.16504294397, y: 8289.751687853042)),
  'EPSG:4572': ProjectAndUnProjectResult(
      Point(x: 12357139.471434671, y: 9135701.776417833),
      Point(x: 2043688.2914743382, y: 448815.9667116775)),
  'EPSG:4573': ProjectAndUnProjectResult(
      Point(x: 13375904.71067448, y: 9782141.513862558),
      Point(x: 30361480189.657455, y: 6642714961.040383)),
  'EPSG:4574': ProjectAndUnProjectResult(
      Point(x: 14572226.03273746, y: 10439500.508403026), Point(x: 0, y: 90)),
  'EPSG:4575': ProjectAndUnProjectResult(
      Point(x: 15999223.540919095, y: 11071901.482118862), Point(x: 0, y: 90)),
  'EPSG:4576': ProjectAndUnProjectResult(
      Point(x: 17722455.995618764, y: 11626992.916130254), Point(x: 0, y: 90)),
  'EPSG:4577': ProjectAndUnProjectResult(
      Point(x: 19822098.331852928, y: 12031168.265501607), Point(x: 0, y: 90)),
  'EPSG:4581': ProjectAndUnProjectResult(
      Point(x: -4309395.913156068, y: 7959688.766689891),
      Point(x: 2295.0956176115287, y: 590.2180007982697)),
  'EPSG:4582': ProjectAndUnProjectResult(
      Point(x: -4526686.551752411, y: 8523534.136687467),
      Point(x: 38040.16504294397, y: 8289.751687853042)),
  'EPSG:4583': ProjectAndUnProjectResult(
      Point(x: -4642860.528565329, y: 9135701.776417833),
      Point(x: 2043688.2914743382, y: 448815.9667116775)),
  'EPSG:4584': ProjectAndUnProjectResult(
      Point(x: -4624095.28932552, y: 9782141.513862558),
      Point(x: 30361480189.657455, y: 6642714961.040383)),
  'EPSG:4585': ProjectAndUnProjectResult(
      Point(x: -4427773.96726254, y: 10439500.508403026), Point(x: 0, y: 90)),
  'EPSG:4586': ProjectAndUnProjectResult(
      Point(x: -4000776.4590809047, y: 11071901.482118862), Point(x: 0, y: 90)),
  'EPSG:4587': ProjectAndUnProjectResult(
      Point(x: -3277544.0043812343, y: 11626992.916130254), Point(x: 0, y: 90)),
  'EPSG:4588': ProjectAndUnProjectResult(
      Point(x: -2177901.6681470713, y: 12031168.265501607), Point(x: 0, y: 90)),
  'EPSG:4589': ProjectAndUnProjectResult(
      Point(x: -604623.1259180433, y: 12183844.391650796), Point(x: 0, y: 90)),
  'EPSG:4647': ProjectAndUnProjectResult(
      Point(x: 33176891.287219305, y: 5231671.834018296),
      Point(x: 17.888058435437348, y: 46.892264027445336)),
  'EPSG:4652': ProjectAndUnProjectResult(
      Point(x: 21328423.823522527, y: 7001648.429185124),
      Point(x: 66.4697524630901, y: 55.68536132961955)),
  'EPSG:4653': ProjectAndUnProjectResult(
      Point(x: 22149778.300699208, y: 7219253.396762118),
      Point(x: 138.37475837297316, y: 69.53967352530888)),
  'EPSG:4654': ProjectAndUnProjectResult(
      Point(x: 22982485.11760734, y: 7451502.995498293),
      Point(x: -29.203847854141863, y: 107.75563598640142)),
  'EPSG:4655': ProjectAndUnProjectResult(
      Point(x: 23828630.571989566, y: 7698382.75421247),
      Point(x: 525.4492407600404, y: 220.8874779968966)),
  'EPSG:4656': ProjectAndUnProjectResult(
      Point(x: 24690604.08684393, y: 7959688.766689891),
      Point(x: 2295.0956176115374, y: 590.2180007982714)),
  'EPSG:4766': ProjectAndUnProjectResult(
      Point(x: 25571131.901448283, y: 8234981.683814286),
      Point(x: 8796.315194603138, y: 1973.274963042184)),
  'EPSG:4767': ProjectAndUnProjectResult(
      Point(x: 26473313.44824759, y: 8523534.136687467),
      Point(x: 38040.16504294397, y: 8289.751687853042)),
  'EPSG:4768': ProjectAndUnProjectResult(
      Point(x: 27400660.53748215, y: 8824270.987284627),
      Point(x: 216926.45884545153, y: 47354.061476737064)),
  'EPSG:4769': ProjectAndUnProjectResult(
      Point(x: 28357139.47143467, y: 9135701.776417833),
      Point(x: 2043688.2914743382, y: 448815.9667116775)),
  'EPSG:4770': ProjectAndUnProjectResult(
      Point(x: 29347216.210174136, y: 9455844.712004598),
      Point(x: 53527241.13814197, y: 11775305.939235508)),
  'EPSG:4771': ProjectAndUnProjectResult(
      Point(x: 30375904.71067448, y: 9782141.513862558),
      Point(x: 30361480189.657455, y: 6642714961.040383)),
  'EPSG:4772': ProjectAndUnProjectResult(
      Point(x: 31448818.561185997, y: 10111362.404475871), Point(x: 0, y: 90)),
  'EPSG:4773': ProjectAndUnProjectResult(
      Point(x: 32572226.03273746, y: 10439500.508403026), Point(x: 0, y: 90)),
  'EPSG:4774': ProjectAndUnProjectResult(
      Point(x: 33753108.66964691, y: 10761654.896220244), Point(x: 0, y: 90)),
  'EPSG:4775': ProjectAndUnProjectResult(
      Point(x: 34999223.540919095, y: 11071901.482118862), Point(x: 0, y: 90)),
  'EPSG:4776': ProjectAndUnProjectResult(
      Point(x: 36319169.274407454, y: 11363150.957499532), Point(x: 0, y: 90)),
  'EPSG:4777': ProjectAndUnProjectResult(
      Point(x: 37722455.99561877, y: 11626992.916130254), Point(x: 0, y: 90)),
  'EPSG:4778': ProjectAndUnProjectResult(
      Point(x: 39219579.29303819, y: 11853525.299659705), Point(x: 0, y: 90)),
  'EPSG:4779': ProjectAndUnProjectResult(
      Point(x: 40822098.33185293, y: 12031168.265501607), Point(x: 0, y: 90)),
  'EPSG:4780': ProjectAndUnProjectResult(
      Point(x: 42542718.237952255, y: 12146461.552330129), Point(x: 0, y: 90)),
  'EPSG:4781': ProjectAndUnProjectResult(
      Point(x: 44395376.874081954, y: 12183844.391650796), Point(x: 0, y: 90)),
  'EPSG:4782': ProjectAndUnProjectResult(
      Point(x: -3671576.176477474, y: 7001648.429185124),
      Point(x: 66.46975246309024, y: 55.68536132961957)),
  'EPSG:4783': ProjectAndUnProjectResult(
      Point(x: -3850221.699300793, y: 7219253.396762118),
      Point(x: 138.37475837297333, y: 69.53967352530893)),
  'EPSG:4784': ProjectAndUnProjectResult(
      Point(x: -4017514.88239266, y: 7451502.995498293),
      Point(x: -29.203847854141863, y: 107.75563598640142)),
  'EPSG:4785': ProjectAndUnProjectResult(
      Point(x: -4171369.428010434, y: 7698382.75421247),
      Point(x: 525.4492407600404, y: 220.8874779968966)),
  'EPSG:4786': ProjectAndUnProjectResult(
      Point(x: -4309395.913156068, y: 7959688.766689891),
      Point(x: 2295.0956176115287, y: 590.2180007982697)),
  'EPSG:4787': ProjectAndUnProjectResult(
      Point(x: -4428868.098551717, y: 8234981.683814286),
      Point(x: 8796.315194603138, y: 1973.274963042184)),
  'EPSG:4788': ProjectAndUnProjectResult(
      Point(x: -4526686.551752411, y: 8523534.136687467),
      Point(x: 38040.16504294397, y: 8289.751687853042)),
  'EPSG:4789': ProjectAndUnProjectResult(
      Point(x: -4599339.462517849, y: 8824270.987284627),
      Point(x: 216926.4588454513, y: 47354.06147673701)),
  'EPSG:4790': ProjectAndUnProjectResult(
      Point(x: -4642860.528565329, y: 9135701.776417833),
      Point(x: 2043688.2914743382, y: 448815.9667116775)),
  'EPSG:4791': ProjectAndUnProjectResult(
      Point(x: -4652783.789825863, y: 9455844.712004598),
      Point(x: 53527241.138141856, y: 11775305.939235486)),
  'EPSG:4792': ProjectAndUnProjectResult(
      Point(x: -4624095.28932552, y: 9782141.513862558),
      Point(x: 30361480189.657455, y: 6642714961.040383)),
  'EPSG:4793': ProjectAndUnProjectResult(
      Point(x: -4551181.438814004, y: 10111362.404475871), Point(x: 0, y: 90)),
  'EPSG:4794': ProjectAndUnProjectResult(
      Point(x: -4427773.96726254, y: 10439500.508403026), Point(x: 0, y: 90)),
  'EPSG:4795': ProjectAndUnProjectResult(
      Point(x: -4246891.330353086, y: 10761654.896220244), Point(x: 0, y: 90)),
  'EPSG:4796': ProjectAndUnProjectResult(
      Point(x: -4000776.4590809047, y: 11071901.482118862), Point(x: 0, y: 90)),
  'EPSG:4797': ProjectAndUnProjectResult(
      Point(x: -3680830.7255925434, y: 11363150.957499532), Point(x: 0, y: 90)),
  'EPSG:4798': ProjectAndUnProjectResult(
      Point(x: -3277544.0043812343, y: 11626992.916130254), Point(x: 0, y: 90)),
  'EPSG:4799': ProjectAndUnProjectResult(
      Point(x: -2780420.706961809, y: 11853525.299659705), Point(x: 0, y: 90)),
  'EPSG:4800': ProjectAndUnProjectResult(
      Point(x: -2177901.6681470713, y: 12031168.265501607), Point(x: 0, y: 90)),
  'EPSG:4812': ProjectAndUnProjectResult(
      Point(x: -1457281.7620477462, y: 12146461.552330129), Point(x: 0, y: 90)),
  'EPSG:4822': ProjectAndUnProjectResult(
      Point(x: -604623.1259180433, y: 12183844.391650796), Point(x: 0, y: 90)),
  'EPSG:4826': ProjectAndUnProjectResult(
      Point(x: 3898447.9405131047, y: 4136629.738735613),
      Point(x: 17.888058560281518, y: 46.89226406700872)),
  'EPSG:4839': ProjectAndUnProjectResult(
      Point(x: 563086.4346155266, y: -428506.2201042669),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:4896': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:4855': ProjectAndUnProjectResult(
      Point(x: 1043549.191261411, y: 6270307.943609711),
      Point(x: 17.888055685365153, y: 46.89226388108927)),
  'EPSG:4856': ProjectAndUnProjectResult(
      Point(x: 967465.1467680301, y: 6258613.481754404),
      Point(x: 17.888057256158355, y: 46.89226392990055)),
  'EPSG:4857': ProjectAndUnProjectResult(
      Point(x: 891358.461581458, y: 6247924.87268115),
      Point(x: 17.88805801138619, y: 46.892263977212124)),
  'EPSG:4858': ProjectAndUnProjectResult(
      Point(x: 815231.9865559447, y: 6238236.293358575),
      Point(x: 17.888058349819428, y: 46.892264013752765)),
  'EPSG:4859': ProjectAndUnProjectResult(
      Point(x: 739088.331249681, y: 6229542.451188974),
      Point(x: 17.888058488739624, y: 46.892264038336585)),
  'EPSG:4860': ProjectAndUnProjectResult(
      Point(x: 662929.8888774, y: 6221838.585496351),
      Point(x: 17.88805853966254, y: 46.89226405311322)),
  'EPSG:4861': ProjectAndUnProjectResult(
      Point(x: 586758.8607398072, y: 6215120.46875045),
      Point(x: 17.88805855566743, y: 46.89226406106193)),
  'EPSG:4862': ProjectAndUnProjectResult(
      Point(x: 510577.2801855649, y: 6209384.40756306),
      Point(x: 17.888058559664973, y: 46.89226406483602)),
  'EPSG:4863': ProjectAndUnProjectResult(
      Point(x: 434387.03616155894, y: 6204627.243488797),
      Point(x: 17.888058560316225, y: 46.89226406636951)),
  'EPSG:4864': ProjectAndUnProjectResult(
      Point(x: 358189.8964071749, y: 6200846.353658465),
      Point(x: 17.888058560321223, y: 46.89226406687275)),
  'EPSG:4865': ProjectAndUnProjectResult(
      Point(x: 281987.530348313, y: 6198039.651269007),
      Point(x: 17.888058560289807, y: 46.892264066992055)),
  'EPSG:4866': ProjectAndUnProjectResult(
      Point(x: 205781.53174686513, y: 6196205.585950036),
      Point(x: 17.88805856028205, y: 46.892264067008135)),
  'EPSG:4867': ProjectAndUnProjectResult(
      Point(x: 129573.44116138725, y: 6195343.144022762),
      Point(x: 17.888058560281515, y: 46.892264067008774)),
  'EPSG:4868': ProjectAndUnProjectResult(
      Point(x: 53364.7682746877, y: 6195451.84866315),
      Point(x: 17.888058560281507, y: 46.892264067008774)),
  'EPSG:4869': ProjectAndUnProjectResult(
      Point(x: -22842.985855933424, y: 6196531.759976973),
      Point(x: 17.888058560280374, y: 46.89226406700719)),
  'EPSG:4870': ProjectAndUnProjectResult(
      Point(x: -99048.30657007455, y: 6198583.4749904135),
      Point(x: 17.888058560268696, y: 46.89226406698017)),
  'EPSG:4871': ProjectAndUnProjectResult(
      Point(x: -175249.64334151713, y: 6201608.127555738),
      Point(x: 17.888058560232725, y: 46.89226406680921)),
  'EPSG:4872': ProjectAndUnProjectResult(
      Point(x: -251445.38742568332, y: 6205607.388167524),
      Point(x: 17.88805856029077, y: 46.89226406614835)),
  'EPSG:4873': ProjectAndUnProjectResult(
      Point(x: -327633.84936153685, y: 6210583.463680795),
      Point(x: 17.888058561328975, y: 46.89226406424212)),
  'EPSG:4874': ProjectAndUnProjectResult(
      Point(x: -403813.23627219687, y: 6216539.096918398),
      Point(x: 17.88805856692873, y: 46.892264059728824)),
  'EPSG:4875': ProjectAndUnProjectResult(
      Point(x: -479981.62890854396, y: 6223477.566150808),
      Point(x: 17.88805858801052, y: 46.892264050503584)),
  'EPSG:4876': ProjectAndUnProjectResult(
      Point(x: -556136.9583800837, y: 6231402.684427525),
      Point(x: 17.88805865250497, y: 46.892264033786056)),
  'EPSG:4877': ProjectAndUnProjectResult(
      Point(x: -632276.9825173458, y: 6240318.798735105),
      Point(x: 17.888058823564478, y: 46.89226400664556)),
  'EPSG:4878': ProjectAndUnProjectResult(
      Point(x: -708399.2618100875, y: 6250230.78895281),
      Point(x: 17.888059231433566, y: 46.89226396739856)),
  'EPSG:4879': ProjectAndUnProjectResult(
      Point(x: -784501.1348655766, y: 6261144.066572763),
      Point(x: 17.88806012621695, y: 46.892263918526474)),
  'EPSG:4880': ProjectAndUnProjectResult(
      Point(x: -860579.6933312244, y: 6273064.573147433),
      Point(x: 17.888061961568134, y: 46.89226387209039)),
  'EPSG:5014': ProjectAndUnProjectResult(
      Point(x: 4271333.391943685, y: 6592581.224994595),
      Point(x: 17.888058560281507, y: 46.892264067008774)),
  'EPSG:5015': ProjectAndUnProjectResult(
      Point(x: 3859272.60100763, y: 6259037.26365852),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:5016': ProjectAndUnProjectResult(
      Point(x: 2988897.836886672, y: 5744008.821518749),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:5018': ProjectAndUnProjectResult(
      Point(x: 1976382.4560408075, y: 1141499.2187266692),
      Point(x: 17.884530474033227, y: 46.8925636667179)),
  'EPSG:5041': ProjectAndUnProjectResult(
      Point(x: 3540763.466186003, y: -2773696.9632621473),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:5042': ProjectAndUnProjectResult(
      Point(x: 11779087.916001765, y: 32298227.672576204),
      Point(x: 17.888058560281515, y: 46.89226406700872)),
  'EPSG:5048': ProjectAndUnProjectResult(
      Point(x: -193931.34632474044, y: 5233642.279699988),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:5069': ProjectAndUnProjectResult(
      Point(x: 6774643.618959672, y: 7282784.610993413),
      Point(x: 17.88805856028151, y: 46.89226404782314)),
  'EPSG:5070': ProjectAndUnProjectResult(
      Point(x: 6774661.149690735, y: 7282623.854975374),
      Point(x: 17.88805856028151, y: 46.89226406700876)),
  'EPSG:5071': ProjectAndUnProjectResult(
      Point(x: 6774661.149690735, y: 7282623.854975374),
      Point(x: 17.88805856028151, y: 46.89226406700876)),
  'EPSG:5072': ProjectAndUnProjectResult(
      Point(x: 6774661.149690735, y: 7282623.854975374),
      Point(x: 17.88805856028151, y: 46.89226406700876)),
  'EPSG:5105': ProjectAndUnProjectResult(
      Point(x: 1043549.191261411, y: -160974.72827168927),
      Point(x: 17.888055685365156, y: 46.89226388108928)),
  'EPSG:5106': ProjectAndUnProjectResult(
      Point(x: 967465.1467680301, y: -172669.19012699788),
      Point(x: 17.888057256158355, y: 46.89226392990055)),
  'EPSG:5107': ProjectAndUnProjectResult(
      Point(x: 891358.461581458, y: -183357.79920025077),
      Point(x: 17.88805801138619, y: 46.892263977212124)),
  'EPSG:5108': ProjectAndUnProjectResult(
      Point(x: 815231.9865559447, y: -193046.3785228266),
      Point(x: 17.888058349819428, y: 46.892264013752765)),
  'EPSG:5109': ProjectAndUnProjectResult(
      Point(x: 739088.331249681, y: -201740.22069242736),
      Point(x: 17.888058488739624, y: 46.892264038336585)),
  'EPSG:5110': ProjectAndUnProjectResult(
      Point(x: 662929.8888774, y: -209444.0863850494),
      Point(x: 17.88805853966254, y: 46.89226405311323)),
  'EPSG:5111': ProjectAndUnProjectResult(
      Point(x: 586758.8607398072, y: -216162.20313095092),
      Point(x: 17.888058555667435, y: 46.89226406106194)),
  'EPSG:5112': ProjectAndUnProjectResult(
      Point(x: 510577.2801855649, y: -221898.26431834162),
      Point(x: 17.888058559664973, y: 46.89226406483602)),
  'EPSG:5113': ProjectAndUnProjectResult(
      Point(x: 434387.03616155894, y: -226655.42839260353),
      Point(x: 17.888058560316225, y: 46.89226406636952)),
  'EPSG:5114': ProjectAndUnProjectResult(
      Point(x: 358189.8964071749, y: -230436.31822293648),
      Point(x: 17.888058560321223, y: 46.89226406687275)),
  'EPSG:5115': ProjectAndUnProjectResult(
      Point(x: 281987.530348313, y: -233243.0206123935),
      Point(x: 17.88805856028981, y: 46.89226406699207)),
  'EPSG:5116': ProjectAndUnProjectResult(
      Point(x: 205781.53174686513, y: -235077.08593136515),
      Point(x: 17.88805856028205, y: 46.892264067008135)),
  'EPSG:5117': ProjectAndUnProjectResult(
      Point(x: 129573.44116138725, y: -235939.52785863844),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5118': ProjectAndUnProjectResult(
      Point(x: 53364.7682746877, y: -235830.82321825065),
      Point(x: 17.888058560281507, y: 46.892264067008774)),
  'EPSG:5119': ProjectAndUnProjectResult(
      Point(x: -22842.985855933424, y: -234750.9119044277),
      Point(x: 17.888058560280374, y: 46.8922640670072)),
  'EPSG:5120': ProjectAndUnProjectResult(
      Point(x: -99048.30657007455, y: -232699.1968909877),
      Point(x: 17.888058560268696, y: 46.89226406698017)),
  'EPSG:5121': ProjectAndUnProjectResult(
      Point(x: -175249.64334151713, y: -229674.54432566254),
      Point(x: 17.88805856023272, y: 46.89226406680922)),
  'EPSG:5122': ProjectAndUnProjectResult(
      Point(x: -251445.38742568332, y: -225675.28371387697),
      Point(x: 17.88805856029077, y: 46.89226406614835)),
  'EPSG:5123': ProjectAndUnProjectResult(
      Point(x: -327633.84936153685, y: -220699.20820060535),
      Point(x: 17.88805856132897, y: 46.89226406424213)),
  'EPSG:5124': ProjectAndUnProjectResult(
      Point(x: -403813.23627219687, y: -214743.5749630027),
      Point(x: 17.888058566928727, y: 46.89226405972883)),
  'EPSG:5125': ProjectAndUnProjectResult(
      Point(x: -479981.62890854396, y: -207805.10573059297),
      Point(x: 17.88805858801052, y: 46.892264050503584)),
  'EPSG:5126': ProjectAndUnProjectResult(
      Point(x: -556136.9583800837, y: -199879.98745387606),
      Point(x: 17.88805865250497, y: 46.892264033786056)),
  'EPSG:5127': ProjectAndUnProjectResult(
      Point(x: -632276.9825173458, y: -190963.87314629555),
      Point(x: 17.888058823564478, y: 46.89226400664556)),
  'EPSG:5128': ProjectAndUnProjectResult(
      Point(x: -708399.2618100875, y: -181051.882928591),
      Point(x: 17.888059231433566, y: 46.89226396739856)),
  'EPSG:5129': ProjectAndUnProjectResult(
      Point(x: -784501.1348655766, y: -170138.6053086382),
      Point(x: 17.88806012621695, y: 46.892263918526474)),
  'EPSG:5130': ProjectAndUnProjectResult(
      Point(x: -860579.6933312244, y: -158218.0987339674),
      Point(x: 17.888061961568134, y: 46.8922638720904)),
  'EPSG:5167': ProjectAndUnProjectResult(
      Point(x: -2011227.9057091656, y: 8407198.324366905), Point(x: 0, y: 90)),
  'EPSG:5168': ProjectAndUnProjectResult(
      Point(x: -2891540.3050450194, y: 8260147.902179337), Point(x: 0, y: 90)),
  'EPSG:5169': ProjectAndUnProjectResult(
      Point(x: -3256833.590421062, y: 8074209.140349129), Point(x: 0, y: 90)),
  'EPSG:5170': ProjectAndUnProjectResult(
      Point(x: -2891540.3050450194, y: 8210147.902179337), Point(x: 0, y: 90)),
  'EPSG:5171': ProjectAndUnProjectResult(
      Point(x: -2477612.1348247016, y: 8322504.999159849), Point(x: 0, y: 90)),
  'EPSG:5172': ProjectAndUnProjectResult(
      Point(x: -2011227.9057091656, y: 8407198.324366905), Point(x: 0, y: 90)),
  'EPSG:5173': ProjectAndUnProjectResult(
      Point(x: -3256339.0298241572, y: 8074420.784190255), Point(x: 0, y: 90)),
  'EPSG:4897': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:5174': ProjectAndUnProjectResult(
      Point(x: -2890978.1045498173, y: 8210328.224029041), Point(x: 0, y: 90)),
  'EPSG:5175': ProjectAndUnProjectResult(
      Point(x: -2890978.1045498173, y: 8260328.224029041), Point(x: 0, y: 90)),
  'EPSG:5176': ProjectAndUnProjectResult(
      Point(x: -2476976.942327858, y: 8322648.384590034), Point(x: 0, y: 90)),
  'EPSG:5177': ProjectAndUnProjectResult(
      Point(x: -2010514.0257884525, y: 8407298.58147797), Point(x: 0, y: 90)),
  'EPSG:5178': ProjectAndUnProjectResult(
      Point(x: -1991565.892606792, y: 9737504.372047529), Point(x: 0, y: 90)),
  'EPSG:5179': ProjectAndUnProjectResult(
      Point(x: -1991851.0034330576, y: 9738454.984542359), Point(x: 0, y: 90)),
  'EPSG:5180': ProjectAndUnProjectResult(
      Point(x: -3257184.580860154, y: 8075139.859388716), Point(x: 0, y: 90)),
  'EPSG:5181': ProjectAndUnProjectResult(
      Point(x: -2891839.482595572, y: 8211095.205943269), Point(x: 0, y: 90)),
  'EPSG:5182': ProjectAndUnProjectResult(
      Point(x: -2891839.482595572, y: 8261095.205943269), Point(x: 0, y: 90)),
  'EPSG:5183': ProjectAndUnProjectResult(
      Point(x: -2477852.9815661646, y: 8323465.837894738), Point(x: 0, y: 90)),
  'EPSG:4899': ProjectAndUnProjectResult(
      Point(x: 4155553.9165052753, y: 1341250.964523339),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:5184': ProjectAndUnProjectResult(
      Point(x: -2011403.4038216677, y: 8408169.127970863), Point(x: 0, y: 90)),
  'EPSG:5185': ProjectAndUnProjectResult(
      Point(x: -3257184.580860154, y: 8175139.859388716), Point(x: 0, y: 90)),
  'EPSG:5186': ProjectAndUnProjectResult(
      Point(x: -2891839.482595572, y: 8311095.205943269), Point(x: 0, y: 90)),
  'EPSG:5187': ProjectAndUnProjectResult(
      Point(x: -2477852.9815661646, y: 8423465.837894738), Point(x: 0, y: 90)),
  'EPSG:5188': ProjectAndUnProjectResult(
      Point(x: -2011403.4038216677, y: 8508169.127970863), Point(x: 0, y: 90)),
  'EPSG:5221': ProjectAndUnProjectResult(
      Point(x: -528533.1922473079, y: -1425019.793700168),
      Point(x: 17.888058570312513, y: 46.89226406903087)),
  'EPSG:5223': ProjectAndUnProjectResult(
      Point(x: 948489.8006333073, y: 5710045.039325342),
      Point(x: 17.888058558416994, y: 46.892264063331794)),
  'EPSG:5234': ProjectAndUnProjectResult(
      Point(x: -4304830.484181836, y: 6858500.89478185),
      Point(x: 45, y: double.nan)),
  'EPSG:5235': ProjectAndUnProjectResult(
      Point(x: -4004722.705631966, y: 7158588.972797912),
      Point(x: double.nan, y: double.nan)),
  'EPSG:4906': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:5243': ProjectAndUnProjectResult(
      Point(x: 563086.4346155266, y: -428506.2201042669),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:5247': ProjectAndUnProjectResult(
      Point(x: -20667926.15717817, y: 7397843.038706061),
      Point(x: 17.888058560281486, y: 46.89226406700866)),
  'EPSG:5253': ProjectAndUnProjectResult(
      Point(x: -194209.03117459663, y: 5235736.574560914),
      Point(x: 17.88805871864152, y: 46.892264021677924)),
  'EPSG:5254': ProjectAndUnProjectResult(
      Point(x: -422543.52053862845, y: 5266978.024236943),
      Point(x: 17.88806088688771, y: 46.892263893655276)),
  'EPSG:5255': ProjectAndUnProjectResult(
      Point(x: -650652.4706583421, y: 5307316.217707126),
      Point(x: 17.888077173234436, y: 46.89226405998426)),
  'EPSG:5256': ProjectAndUnProjectResult(
      Point(x: -878436.8754140371, y: 5356947.036220895),
      Point(x: 17.888161981005887, y: 46.89226782538483)),
  'EPSG:5257': ProjectAndUnProjectResult(
      Point(x: -1105767.8353347534, y: 5416108.299687305),
      Point(x: 17.888509189327227, y: 46.89229076369037)),
  'EPSG:5258': ProjectAndUnProjectResult(
      Point(x: -1332479.2650904243, y: 5485078.642525739),
      Point(x: 17.88971143187752, y: 46.89238970293439)),
  'EPSG:5259': ProjectAndUnProjectResult(
      Point(x: -1558359.8651807948, y: 5564175.834249844),
      Point(x: 17.893399933574372, y: 46.89274299727957)),
  'EPSG:5266': ProjectAndUnProjectResult(
      Point(x: -4678785.617560011, y: 8234839.92570492),
      Point(x: 8796.331693915807, y: 1973.2780739093832)),
  'EPSG:5269': ProjectAndUnProjectResult(
      Point(x: 8805790.968825404, y: 5235736.574560914),
      Point(x: 17.888058718641528, y: 46.892264021677924)),
  'EPSG:5270': ProjectAndUnProjectResult(
      Point(x: 9577456.479461372, y: 5266978.024236943),
      Point(x: 17.88806088688771, y: 46.892263893655276)),
  'EPSG:5271': ProjectAndUnProjectResult(
      Point(x: 10349347.529341659, y: 5307316.217707126),
      Point(x: 17.888077173234446, y: 46.89226405998426)),
  'EPSG:5272': ProjectAndUnProjectResult(
      Point(x: 11121563.124585964, y: 5356947.036220895),
      Point(x: 17.888161981005897, y: 46.89226782538483)),
  'EPSG:5273': ProjectAndUnProjectResult(
      Point(x: 11894232.164665246, y: 5416108.299687305),
      Point(x: 17.888509189327227, y: 46.89229076369037)),
  'EPSG:5274': ProjectAndUnProjectResult(
      Point(x: 12667520.734909575, y: 5485078.642525739),
      Point(x: 17.88971143187752, y: 46.89238970293439)),
  'EPSG:5275': ProjectAndUnProjectResult(
      Point(x: 13441640.134819206, y: 5564175.834249844),
      Point(x: 17.89339993357438, y: 46.89274299727957)),
  'EPSG:5292': ProjectAndUnProjectResult(
      Point(x: -4704823.252256, y: 5804184.223305238),
      Point(x: 12368.947008544978, y: 2739.7138155769444)),
  'EPSG:5293': ProjectAndUnProjectResult(
      Point(x: -4662165.298772348, y: 5692679.988942387),
      Point(x: 7163.607859871399, y: 1624.0876138576555)),
  'EPSG:5294': ProjectAndUnProjectResult(
      Point(x: -4673299.012484079, y: 5720753.247693101),
      Point(x: 8212.083846821457, y: 1848.2317842876012)),
  'EPSG:5295': ProjectAndUnProjectResult(
      Point(x: -4679997.537808284, y: 5737974.8139026435),
      Point(x: 8932.082225317181, y: 2002.3463047345429)),
  'EPSG:5296': ProjectAndUnProjectResult(
      Point(x: -4684218.174779552, y: 5748959.82406592),
      Point(x: 9425.095828579717, y: 2107.955968287918)),
  'EPSG:5297': ProjectAndUnProjectResult(
      Point(x: -4718463.647594405, y: 5842338.209170545),
      Point(x: 14954.685552803032, y: 3295.920727193336)),
  'EPSG:5298': ProjectAndUnProjectResult(
      Point(x: -4721810.471064476, y: 5851912.711262178),
      Point(x: 15689.153491218593, y: 3454.088930198865)),
  'EPSG:5299': ProjectAndUnProjectResult(
      Point(x: -4654625.2365574995, y: 5674038.970150215),
      Point(x: 6543.869347754224, y: 1491.7769995806423)),
  'EPSG:5300': ProjectAndUnProjectResult(
      Point(x: -4725682.777172484, y: 5863101.068562257),
      Point(x: 16596.04987922655, y: 3649.486874227715)),
  'EPSG:5301': ProjectAndUnProjectResult(
      Point(x: -4673299.012484079, y: 5720753.247693101),
      Point(x: 8212.083846821457, y: 1848.2317842876012)),
  'EPSG:5302': ProjectAndUnProjectResult(
      Point(x: -4732781.183870271, y: 5883930.972853467),
      Point(x: 18435.81554512733, y: 4046.180057951108)),
  'EPSG:5303': ProjectAndUnProjectResult(
      Point(x: -4643784.586701601, y: 5647733.411315759),
      Point(x: 5760.501454903568, y: 1324.7507163936098)),
  'EPSG:4908': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:5304': ProjectAndUnProjectResult(
      Point(x: -4688405.866214727, y: 5759964.86292654),
      Point(x: 9947.317307311861, y: 2219.888560237287)),
  'EPSG:5305': ProjectAndUnProjectResult(
      Point(x: -4662165.298772348, y: 5692679.988942387),
      Point(x: 7163.607859871399, y: 1624.0876138576555)),
  'EPSG:5306': ProjectAndUnProjectResult(
      Point(x: -4738692.258740151, y: 5901608.346899323),
      Point(x: 20167.35354048827, y: 4419.867670027745)),
  'EPSG:5307': ProjectAndUnProjectResult(
      Point(x: -4696681.629514149, y: 5782034.811950033),
      Point(x: 11087.222373618311, y: 2464.431164926013)),
  'EPSG:5308': ProjectAndUnProjectResult(
      Point(x: -4684818.438036357, y: 5750530.747466841),
      Point(x: 9497.867227148303, y: 2123.549755149675)),
  'EPSG:5309': ProjectAndUnProjectResult(
      Point(x: -4683015.6317654345, y: 5745819.203669482),
      Point(x: 9281.335232246713, y: 2077.1541965185925)),
  'EPSG:5310': ProjectAndUnProjectResult(
      Point(x: -4732781.183870271, y: 5883930.972853467),
      Point(x: 18435.81554512733, y: 4046.180057951108)),
  'EPSG:5311': ProjectAndUnProjectResult(
      Point(x: -4709414.770178517, y: 5816876.53384172),
      Point(x: 13172.526666417933, y: 2912.4542979513362)),
  'EPSG:5316': ProjectAndUnProjectResult(
      Point(x: 2090999.5151226467, y: -495459.66639980115),
      Point(x: 17.885795631862905, y: 46.89244457913767)),
  'EPSG:4910': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:5320': ProjectAndUnProjectResult(
      Point(x: 6585325.179032699, y: 10327216.83405834),
      Point(x: 17.8880585602815, y: 46.89226406700872)),
  'EPSG:5321': ProjectAndUnProjectResult(
      Point(x: 6585325.179032699, y: 10327216.83405834),
      Point(x: 17.8880585602815, y: 46.89226406700872)),
  'EPSG:5325': ProjectAndUnProjectResult(
      Point(x: 4470199.377220549, y: -913939.791333823),
      Point(x: 17.888058560281507, y: 46.89226406700873)),
  'EPSG:5329': ProjectAndUnProjectResult(
      Point(x: -6323035.080961419, y: 6774706.861113531),
      Point(x: 17.888059822235842, y: 46.89226431455566)),
  'EPSG:5330': ProjectAndUnProjectResult(
      Point(x: -6323019.301218551, y: 6774822.740257204),
      Point(x: 17.888059883263967, y: 46.89226423543208)),
  'EPSG:5331': ProjectAndUnProjectResult(
      Point(x: -6322890.078644877, y: 6774362.061687819),
      Point(x: 17.888059768494063, y: 46.8922646303815)),
  'EPSG:5337': ProjectAndUnProjectResult(
      Point(x: 4271110.913740331, y: 16592629.880006336),
      Point(x: 17.888058523417712, y: 46.89226407895471)),
  'EPSG:5343': ProjectAndUnProjectResult(
      Point(x: 6558199.158144748, y: 20088569.71969266), Point(x: 0, y: 90)),
  'EPSG:5344': ProjectAndUnProjectResult(
      Point(x: 7627603.63873359, y: 19759444.393447872),
      Point(x: -14563147143.451214, y: 3188443837.8198547)),
  'EPSG:4911': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:5345': ProjectAndUnProjectResult(
      Point(x: 8653224.300104942, y: 19433509.59298006),
      Point(x: -39521738.61122337, y: 8695128.741618276)),
  'EPSG:5346': ProjectAndUnProjectResult(
      Point(x: 9640628.03418475, y: 19113941.421131436),
      Point(x: -1685042.2535845686, y: 369929.7983349795)),
  'EPSG:5347': ProjectAndUnProjectResult(
      Point(x: 10594786.08114166, y: 18803251.941004626),
      Point(x: -187879.9335986475, y: 41002.61340262109)),
  'EPSG:5348': ProjectAndUnProjectResult(
      Point(x: 11520125.412785191, y: 18503383.42313258),
      Point(x: -33811.090133644844, y: 7380.196889868265)),
  'EPSG:5349': ProjectAndUnProjectResult(
      Point(x: 12420576.82986139, y: 18215792.792734504),
      Point(x: -7903.831319008155, y: 1789.9479071178757)),
  'EPSG:5355': ProjectAndUnProjectResult(
      Point(x: 5731020.405467821, y: 19059228.545130335),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:5356': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 19674131.646973997),
      Point(x: 17.888058560281348, y: 46.892264067008654)),
  'EPSG:5357': ProjectAndUnProjectResult(
      Point(x: 5558786.502469642, y: 18470922.227642596),
      Point(x: 17.88805856028145, y: 46.89226406700888)),
  'EPSG:5361': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 19674131.646973997),
      Point(x: 17.888058560281348, y: 46.892264067008654)),
  'EPSG:5362': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 20298556.414325632),
      Point(x: 17.888058560281653, y: 46.892264067008654)),
  'EPSG:5367': ProjectAndUnProjectResult(
      Point(x: 4706968.526695035, y: 11340922.422292411), Point(x: 0, y: 90)),
  'EPSG:5382': ProjectAndUnProjectResult(
      Point(x: 5558786.502434989, y: 18470922.227729887),
      Point(x: 17.88805856028145, y: 46.892264067008874)),
  'EPSG:5383': ProjectAndUnProjectResult(
      Point(x: 5314192.978401657, y: 17922929.14913848),
      Point(x: 17.888058560281543, y: 46.89226406700883)),
  'EPSG:5387': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 20298556.414325632),
      Point(x: 17.888058560281653, y: 46.892264067008654)),
  'EPSG:5388': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 10914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:5389': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 19674131.646973997),
      Point(x: 17.888058560281348, y: 46.892264067008654)),
  'EPSG:5396': ProjectAndUnProjectResult(
      Point(x: 3859272.60100763, y: 16259037.26365852),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:5456': ProjectAndUnProjectResult(
      Point(x: 10109984.15811621, y: 6194682.236141637),
      Point(x: 17.88805855884158, y: 46.8922640833449)),
  'EPSG:5457': ProjectAndUnProjectResult(
      Point(x: 10276845.235455556, y: 6247629.437264094),
      Point(x: 17.88805855884156, y: 46.892264083344934)),
  'EPSG:5458': ProjectAndUnProjectResult(
      Point(x: 9646219.06494938, y: 6362764.2880742885),
      Point(x: 17.888058560281486, y: 46.89226404782306)),
  'EPSG:5459': ProjectAndUnProjectResult(
      Point(x: 9937737.098033627, y: 6420297.689050992),
      Point(x: 17.888058558841557, y: 46.89226408334495)),
  'EPSG:5460': ProjectAndUnProjectResult(
      Point(x: 10002668.089173343, y: 6346862.721311233),
      Point(x: 17.88805855884158, y: 46.892264083344976)),
  'EPSG:5461': ProjectAndUnProjectResult(
      Point(x: 9698407.294286344, y: 6272941.616957501),
      Point(x: 17.888058558841575, y: 46.892264083344934)),
  'EPSG:5462': ProjectAndUnProjectResult(
      Point(x: 10019071.130681543, y: 6233765.657205225),
      Point(x: 17.888058558841575, y: 46.89226408334497)),
  'EPSG:5463': ProjectAndUnProjectResult(
      Point(x: 5735953.473403359, y: 10914148.328739677),
      Point(x: 17.88805856271687, y: 46.89226406826735)),
  'EPSG:5466': ProjectAndUnProjectResult(
      Point(x: 3622626.1390046105, y: 9987450.67720011), Point(x: 0, y: 90)),
  'EPSG:5469': ProjectAndUnProjectResult(
      Point(x: 10019870.634872716, y: 6128041.074577379),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:5472': ProjectAndUnProjectResult(
      Point(x: 7227708.345231998, y: 10317674.15723594),
      Point(x: double.nan, y: double.nan)),
  'EPSG:5479': ProjectAndUnProjectResult(
      Point(x: -11622728.1476195, y: -20155986.891862214),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:5480': ProjectAndUnProjectResult(
      Point(x: -13165854.550953317, y: -21831066.27411452),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:5481': ProjectAndUnProjectResult(
      Point(x: -15185803.60358078, y: -23172406.771932896),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:5482': ProjectAndUnProjectResult(
      Point(x: -4779087.915606787, y: -29298227.67135245),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:5490': ProjectAndUnProjectResult(
      Point(x: 5731020.405467821, y: 9059228.545130335),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:5513': ProjectAndUnProjectResult(
      Point(x: -528533.1922473328, y: -1425019.793700168),
      Point(x: 17.888058570312516, y: 46.89226406903086)),
  'EPSG:5514': ProjectAndUnProjectResult(
      Point(x: -528533.1922473328, y: -1425019.793700168),
      Point(x: 17.888058570312516, y: 46.89226406903086)),
  'EPSG:5518': ProjectAndUnProjectResult(
      Point(x: 49706648.65922565, y: -18794448.933160026),
      Point(x: -12.251180423372775, y: -89.99839671850718)),
  'EPSG:5519': ProjectAndUnProjectResult(
      Point(x: 49707277.556579426, y: -18795224.49748884),
      Point(x: -8.331860198392532, y: -89.99842511388825)),
  'EPSG:5520': ProjectAndUnProjectResult(
      Point(x: 2633650.2173375282, y: 5303555.09634357),
      Point(x: 17.888042364500645, y: 46.89226400301286)),
  'EPSG:5523': ProjectAndUnProjectResult(
      Point(x: 1986564.1571912412, y: 10713034.420684053),
      Point(x: 17.888058555667435, y: 46.89226406106194)),
  'EPSG:5530': ProjectAndUnProjectResult(
      Point(x: 9743888.799047105, y: 17533817.779493183),
      Point(x: 17.888058562695008, y: 46.89226406831664)),
  'EPSG:5531': ProjectAndUnProjectResult(
      Point(x: 5558817.651194667, y: 18470913.110016327),
      Point(x: 17.888058562694987, y: 46.89226406831672)),
  'EPSG:5532': ProjectAndUnProjectResult(
      Point(x: 5314216.854458378, y: 17922917.71369942),
      Point(x: 17.888058562716704, y: 46.89226406826742)),
  'EPSG:5533': ProjectAndUnProjectResult(
      Point(x: 5009704.745899673, y: 17424532.297634605),
      Point(x: 17.888058562695086, y: 46.89226406831666)),
  'EPSG:5534': ProjectAndUnProjectResult(
      Point(x: 4658140.432964144, y: 16980655.193096045),
      Point(x: 17.88805856269503, y: 46.89226406831663)),
  'EPSG:5535': ProjectAndUnProjectResult(
      Point(x: 4271340.921932219, y: 16592568.416900882),
      Point(x: 17.888058562695022, y: 46.89226406831663)),
  'EPSG:5536': ProjectAndUnProjectResult(
      Point(x: 5559015.508627503, y: 18471180.20035238),
      Point(x: 17.888058560281486, y: 46.89226406700888)),
  'EPSG:5537': ProjectAndUnProjectResult(
      Point(x: 5314413.247681583, y: 17923162.316092744),
      Point(x: 17.88805856028157, y: 46.89226406700883)),
  'EPSG:5538': ProjectAndUnProjectResult(
      Point(x: 5009894.529040156, y: 17424754.63445031),
      Point(x: 17.88805856028159, y: 46.89226406700879)),
  'EPSG:5539': ProjectAndUnProjectResult(
      Point(x: 4658321.346281655, y: 16980856.240328066),
      Point(x: 17.888058560281525, y: 46.89226406700879)),
  'EPSG:5550': ProjectAndUnProjectResult(
      Point(x: -3658127.571879782, y: 23015261.60497248),
      Point(x: 17.88805856028154, y: 46.89226406700878)),
  'EPSG:5551': ProjectAndUnProjectResult(
      Point(x: -3271333.3919436852, y: 23403348.66088295),
      Point(x: 17.888058560281486, y: 46.892264067008774)),
  'EPSG:5552': ProjectAndUnProjectResult(
      Point(x: -2859272.60100763, y: 23736892.622219022),
      Point(x: 17.88805856028154, y: 46.892264067008796)),
  'EPSG:5559': ProjectAndUnProjectResult(
      Point(x: 9646050.827205634, y: 6362977.171148274),
      Point(x: 17.88805855884156, y: 46.89226408334497)),
  'EPSG:5562': ProjectAndUnProjectResult(
      Point(x: 4262977.023450082, y: 5200107.5557981115),
      Point(x: 17.888058571143702, y: 46.89226406858427)),
  'EPSG:5563': ProjectAndUnProjectResult(
      Point(x: 4805913.470558321, y: 5235860.647503206),
      Point(x: 17.888058729263665, y: 46.8922640233896)),
  'EPSG:5564': ProjectAndUnProjectResult(
      Point(x: 5349465.904755867, y: 5307431.144329979),
      Point(x: 17.888077165110133, y: 46.89226406159528)),
  'EPSG:5565': ProjectAndUnProjectResult(
      Point(x: 5894346.358031101, y: 5416214.116028281),
      Point(x: 17.888508861463574, y: 46.89229074889061)),
  'EPSG:5566': ProjectAndUnProjectResult(
      Point(x: 262977.02345008205, y: 5200107.5557981115),
      Point(x: 17.8880585711437, y: 46.89226406858427)),
  'EPSG:5567': ProjectAndUnProjectResult(
      Point(x: -194086.52944167913, y: 5235860.647503206),
      Point(x: 17.888058729263665, y: 46.8922640233896)),
  'EPSG:5568': ProjectAndUnProjectResult(
      Point(x: -650534.0952441327, y: 5307431.144329979),
      Point(x: 17.888077165110136, y: 46.89226406159528)),
  'EPSG:5569': ProjectAndUnProjectResult(
      Point(x: -1105653.6419688992, y: 5416214.116028281),
      Point(x: 17.888508861463574, y: 46.89229074889061)),
  'EPSG:5570': ProjectAndUnProjectResult(
      Point(x: 7262977.023450082, y: 5200107.5557981115),
      Point(x: 17.888058571143702, y: 46.89226406858427)),
  'EPSG:5571': ProjectAndUnProjectResult(
      Point(x: 8034399.759328651, y: 5213567.368145596),
      Point(x: 17.88805857401238, y: 46.89226406408987)),
  'EPSG:5572': ProjectAndUnProjectResult(
      Point(x: 8805913.470558321, y: 5235860.647503206),
      Point(x: 17.888058729263665, y: 46.8922640233896)),
  'EPSG:5573': ProjectAndUnProjectResult(
      Point(x: 9577576.922293972, y: 5267097.50637579),
      Point(x: 17.888060894831238, y: 46.89226389546803)),
  'EPSG:5574': ProjectAndUnProjectResult(
      Point(x: 10349465.904755868, y: 5307431.144329979),
      Point(x: 17.88807716511015, y: 46.89226406159528)),
  'EPSG:5575': ProjectAndUnProjectResult(
      Point(x: 11121679.419562321, y: 5357057.416403098),
      Point(x: 17.8881619026993, y: 46.89226782431081)),
  'EPSG:5576': ProjectAndUnProjectResult(
      Point(x: 11894346.358031102, y: 5416214.116028281),
      Point(x: 17.88850886146358, y: 46.892290748890616)),
  'EPSG:5577': ProjectAndUnProjectResult(
      Point(x: 262977.02345008205, y: 5200107.5557981115),
      Point(x: 17.8880585711437, y: 46.89226406858427)),
  'EPSG:5578': ProjectAndUnProjectResult(
      Point(x: 34399.75932865159, y: 5213567.368145596),
      Point(x: 17.888058574012387, y: 46.892264064089886)),
  'EPSG:5579': ProjectAndUnProjectResult(
      Point(x: -194086.52944167913, y: 5235860.647503206),
      Point(x: 17.888058729263665, y: 46.8922640233896)),
  'EPSG:5580': ProjectAndUnProjectResult(
      Point(x: -422423.0777060273, y: 5267097.50637579),
      Point(x: 17.888060894831245, y: 46.89226389546803)),
  'EPSG:5581': ProjectAndUnProjectResult(
      Point(x: -650534.0952441327, y: 5307431.144329979),
      Point(x: 17.888077165110136, y: 46.89226406159528)),
  'EPSG:5582': ProjectAndUnProjectResult(
      Point(x: -878320.5804376781, y: 5357057.416403098),
      Point(x: 17.888161902699313, y: 46.892267824310814)),
  'EPSG:5583': ProjectAndUnProjectResult(
      Point(x: -1105653.6419688992, y: 5416214.116028281),
      Point(x: 17.888508861463574, y: 46.89229074889061)),
  'EPSG:5588': ProjectAndUnProjectResult(
      Point(x: 19098094.57440187, y: 13088243.457659297),
      Point(x: 17.88805856028152, y: 46.892264047823105)),
  'EPSG:5589': ProjectAndUnProjectResult(
      Point(x: 11885362.994482463, y: 32767520.614376582), Point(x: 0, y: 90)),
  'EPSG:5596': ProjectAndUnProjectResult(
      Point(x: 1499454.8179030179, y: 5216171.863445401),
      Point(x: 17.888058554214552, y: 46.892264060090596)),
  'EPSG:5623': ProjectAndUnProjectResult(
      Point(x: 14429087.739256004, y: 22027871.647838622), Point(x: 0, y: 90)),
  'EPSG:5624': ProjectAndUnProjectResult(
      Point(x: 13577181.714980586, y: 22651971.964210976), Point(x: 0, y: 90)),
  'EPSG:5625': ProjectAndUnProjectResult(
      Point(x: 12102088.540377058, y: 23459364.607388716), Point(x: 0, y: 90)),
  'EPSG:5627': ProjectAndUnProjectResult(
      Point(x: 1405242.8678058116, y: 5262433.223564823),
      Point(x: 17.88805661187514, y: 46.89226390821537)),
  'EPSG:5629': ProjectAndUnProjectResult(
      Point(x: -1557536.0363929619, y: 15561947.769911136),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:5631': ProjectAndUnProjectResult(
      Point(x: 3177292.4585295245, y: 5233913.198984689),
      Point(x: 17.888058447269415, y: 46.89226402919728)),
  'EPSG:5632': ProjectAndUnProjectResult(
      Point(x: 4580708.59132307, y: 2282143.4053414315),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:5633': ProjectAndUnProjectResult(
      Point(x: 4921381.502448138, y: 2674052.203833336),
      Point(x: 17.888058560281518, y: 46.89226406911223)),
  'EPSG:5634': ProjectAndUnProjectResult(
      Point(x: 4580708.59132307, y: 2282143.4053414315),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:5635': ProjectAndUnProjectResult(
      Point(x: 4921381.502448138, y: 2674052.203833336),
      Point(x: 17.888058560281518, y: 46.89226406911223)),
  'EPSG:5636': ProjectAndUnProjectResult(
      Point(x: 4921381.502448138, y: 2674052.203833336),
      Point(x: 17.888058560281518, y: 46.89226406911223)),
  'EPSG:5637': ProjectAndUnProjectResult(
      Point(x: 4580708.59132307, y: 2282143.4053414315),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:5638': ProjectAndUnProjectResult(
      Point(x: 4921381.502448138, y: 2674052.203833336),
      Point(x: 17.888058560281518, y: 46.89226406911223)),
  'EPSG:5639': ProjectAndUnProjectResult(
      Point(x: 4580708.59132307, y: 2282143.4053414315),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:5641': ProjectAndUnProjectResult(
      Point(x: 11773926.298952317, y: 15889731.049674552),
      Point(x: 17.888058560281518, y: 46.89226406700873)),
  'EPSG:5643': ProjectAndUnProjectResult(
      Point(x: 1418749.1386416086, y: -90270.6623273138),
      Point(x: 17.888058565321924, y: 46.89226407177286)),
  'EPSG:5644': ProjectAndUnProjectResult(
      Point(x: -2005502.5012535215, y: 15751885.308795743),
      Point(x: 17.888058560281532, y: 46.8922640670088)),
  'EPSG:5646': ProjectAndUnProjectResult(
      Point(x: 18181618.507753536, y: 17828486.854641918), Point(x: 0, y: 90)),
  'EPSG:5649': ProjectAndUnProjectResult(
      Point(x: 32633185.606417127, y: 5301866.087016829),
      Point(x: 17.888042388656366, y: 46.892264000337974)),
  'EPSG:5650': ProjectAndUnProjectResult(
      Point(x: 33720001.22984009, y: 5197241.60997254),
      Point(x: 17.888058560302063, y: 46.89226406695651)),
  'EPSG:5651': ProjectAndUnProjectResult(
      Point(x: 32633185.606417127, y: 5301866.087016829),
      Point(x: 17.888042388656366, y: 46.892264000337974)),
  'EPSG:5652': ProjectAndUnProjectResult(
      Point(x: 33176891.287219305, y: 5231671.834018296),
      Point(x: 17.888058435437348, y: 46.892264027445336)),
  'EPSG:5653': ProjectAndUnProjectResult(
      Point(x: 33720001.22984009, y: 5197241.60997254),
      Point(x: 17.888058560302063, y: 46.89226406695651)),
  'EPSG:5654': ProjectAndUnProjectResult(
      Point(x: 18181618.507753536, y: 17828486.854641918), Point(x: 0, y: 90)),
  'EPSG:5655': ProjectAndUnProjectResult(
      Point(x: 18181618.507753536, y: 17828486.854641918), Point(x: 0, y: 90)),
  'EPSG:5659': ProjectAndUnProjectResult(
      Point(x: 1176985.5125911732, y: 1231872.879029004),
      Point(x: 17.888058440115774, y: 46.89226402774989)),
  'EPSG:5663': ProjectAndUnProjectResult(
      Point(x: 3720215.2591528012, y: 5199459.086602302),
      Point(x: 17.888058572359384, y: 46.89226406874446)),
  'EPSG:5664': ProjectAndUnProjectResult(
      Point(x: 3177291.738831021, y: 5233913.048442174),
      Point(x: 17.88805844634046, y: 46.892264029990585)),
  'EPSG:5665': ProjectAndUnProjectResult(
      Point(x: 3720214.533676548, y: 5199458.992247189),
      Point(x: 17.88805857142926, y: 46.89226406953736)),
  'EPSG:4912': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:5666': ProjectAndUnProjectResult(
      Point(x: 4177079.968440652, y: 5233232.120986678),
      Point(x: 17.888058435353244, y: 46.89226402757831)),
  'EPSG:5667': ProjectAndUnProjectResult(
      Point(x: 4948614.819973172, y: 5211599.299867989),
      Point(x: 17.888058558409952, y: 46.89226406334307)),
  'EPSG:5668': ProjectAndUnProjectResult(
      Point(x: 4948614.819973172, y: 5211599.299867989),
      Point(x: 17.888058558409952, y: 46.89226406334307)),
  'EPSG:5669': ProjectAndUnProjectResult(
      Point(x: 5720062.557838639, y: 5198792.3020578),
      Point(x: 17.888058560301875, y: 46.89226406695668)),
  'EPSG:5670': ProjectAndUnProjectResult(
      Point(x: 4177292.4585295245, y: 5233913.198984689),
      Point(x: 17.888058447269415, y: 46.89226402919728)),
  'EPSG:5671': ProjectAndUnProjectResult(
      Point(x: 4948797.440905435, y: 5212272.602643184),
      Point(x: 17.888058570467997, y: 46.89226406511432)),
  'EPSG:5672': ProjectAndUnProjectResult(
      Point(x: 5720215.259152802, y: 5199459.086602302),
      Point(x: 17.88805857235939, y: 46.89226406874446)),
  'EPSG:5673': ProjectAndUnProjectResult(
      Point(x: 4177291.738831021, y: 5233913.048442174),
      Point(x: 17.88805844634046, y: 46.892264029990585)),
  'EPSG:5674': ProjectAndUnProjectResult(
      Point(x: 4948796.71822361, y: 5212272.480322573),
      Point(x: 17.88805856953789, y: 46.89226406590728)),
  'EPSG:6686': ProjectAndUnProjectResult(
      Point(x: -788366.1033867978, y: 9962400.81668543), Point(x: 0, y: 90)),
  'EPSG:5675': ProjectAndUnProjectResult(
      Point(x: 5720214.533676548, y: 5199458.992247189),
      Point(x: 17.88805857142926, y: 46.89226406953736)),
  'EPSG:5676': ProjectAndUnProjectResult(
      Point(x: 3405552.352774285, y: 5263900.335799437),
      Point(x: 17.88805660254163, y: 46.892263904781714)),
  'EPSG:5677': ProjectAndUnProjectResult(
      Point(x: 4177235.2261281675, y: 5233328.38928267),
      Point(x: 17.88805843372212, y: 46.89226402708752)),
  'EPSG:5678': ProjectAndUnProjectResult(
      Point(x: 4948773.170928149, y: 5211689.23202899),
      Point(x: 17.88805855704943, y: 46.892264062895954)),
  'EPSG:5679': ProjectAndUnProjectResult(
      Point(x: 5720223.93618536, y: 5198875.94190293),
      Point(x: 17.8880585589492, y: 46.89226406651698)),
  'EPSG:5680': ProjectAndUnProjectResult(
      Point(x: 2633650.2173375282, y: 5303555.09634357),
      Point(x: 17.888042364500645, y: 46.89226400301286)),
  'EPSG:5682': ProjectAndUnProjectResult(
      Point(x: 3405400.2787059825, y: 5263797.661108687),
      Point(x: 17.888056607032425, y: 46.892263905350184)),
  'EPSG:5683': ProjectAndUnProjectResult(
      Point(x: 4177079.968440652, y: 5233232.120986678),
      Point(x: 17.888058435353244, y: 46.89226402757831)),
  'EPSG:5684': ProjectAndUnProjectResult(
      Point(x: 4948614.819973172, y: 5211599.299867989),
      Point(x: 17.888058558409952, y: 46.89226406334307)),
  'EPSG:5685': ProjectAndUnProjectResult(
      Point(x: 5720062.557838639, y: 5198792.3020578),
      Point(x: 17.888058560301875, y: 46.89226406695668)),
  'EPSG:5700': ProjectAndUnProjectResult(
      Point(x: -633185.5802525296, y: 24694063.811162703),
      Point(x: 17.888058560281486, y: 46.8922640670088)),
  'EPSG:5825': ProjectAndUnProjectResult(
      Point(x: 5314852.692242589, y: 15238241.176835464),
      Point(x: -149.67352147660628, y: 89.99892064788257)),
  'EPSG:5836': ProjectAndUnProjectResult(
      Point(x: -1105125.3250947963, y: 5413941.6045829635),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:5837': ProjectAndUnProjectResult(
      Point(x: -2446086.561661094, y: 5986927.666737254),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:5839': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 20914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:5842': ProjectAndUnProjectResult(
      Point(x: 948489.8006333073, y: 15210045.039325342),
      Point(x: 17.888058558416994, y: 46.892264063331794)),
  'EPSG:5844': ProjectAndUnProjectResult(
      Point(x: -422451.2661865746, y: 15266451.32643452),
      Point(x: 17.88806088688771, y: 46.892263893655276)),
  'EPSG:5858': ProjectAndUnProjectResult(
      Point(x: 5314217.790965649, y: 17922917.686981164),
      Point(x: 17.888058562695093, y: 46.89226406831667)),
  'EPSG:5875': ProjectAndUnProjectResult(
      Point(x: 5822540.430747959, y: 20298561.733390145),
      Point(x: 17.888058562695175, y: 46.892264068316486)),
  'EPSG:5876': ProjectAndUnProjectResult(
      Point(x: 5820871.782343163, y: 19674130.97947071),
      Point(x: 17.888058562694923, y: 46.89226406831649)),
  'EPSG:5877': ProjectAndUnProjectResult(
      Point(x: 5731057.760059358, y: 19059223.017331176),
      Point(x: 17.88805856269482, y: 46.89226406831667)),
  'EPSG:5879': ProjectAndUnProjectResult(
      Point(x: -1557698.8117733428, y: 15562076.714101901),
      Point(x: 17.888058591798575, y: 46.89226407101458)),
  'EPSG:5880': ProjectAndUnProjectResult(
      Point(x: 9743867.12290849, y: 17533827.812023543),
      Point(x: 17.88805856028146, y: 46.89226406700877)),
  'EPSG:5887': ProjectAndUnProjectResult(
      Point(x: 49730994.20351042, y: -18178134.332903616), Point(x: 0, y: -90)),
  'EPSG:5890': ProjectAndUnProjectResult(
      Point(x: -4657854.4098879015, y: -1503374.0014917946),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:5921': ProjectAndUnProjectResult(
      Point(x: 3946363.3033214873, y: 3993207.894882794),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:5922': ProjectAndUnProjectResult(
      Point(x: 4130370.1796850013, y: -1786482.5598647278),
      Point(x: 17.888058560281518, y: 46.89226406700873)),
  'EPSG:5923': ProjectAndUnProjectResult(
      Point(x: -1280775.1754836992, y: -3825645.6795010297),
      Point(x: 17.888058560281515, y: 46.89226406700873)),
  'EPSG:5924': ProjectAndUnProjectResult(
      Point(x: -4956935.100909344, y: 638044.32832245),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6329': ProjectAndUnProjectResult(
      Point(x: -1088186.0339291478, y: 14586736.438492097),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:5925': ProjectAndUnProjectResult(
      Point(x: -1918247.3771278067, y: 5557907.863075018),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:5926': ProjectAndUnProjectResult(
      Point(x: 4122043.342458628, y: 4645933.03942385),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:5927': ProjectAndUnProjectResult(
      Point(x: 4015111.868376117, y: -937269.0846227852),
      Point(x: 17.888058560281518, y: 46.892264067008725)),
  'EPSG:5928': ProjectAndUnProjectResult(
      Point(x: -1232614.864771781, y: -2846442.8410716876),
      Point(x: 17.888058560281518, y: 46.892264067008725)),
  'EPSG:5929': ProjectAndUnProjectResult(
      Point(x: -4902148.795128584, y: 1362844.632131881),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:5930': ProjectAndUnProjectResult(
      Point(x: -2295159.4027560353, y: 6301183.0780229),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:5931': ProjectAndUnProjectResult(
      Point(x: 4471341.859223193, y: 5230666.620786624),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:5932': ProjectAndUnProjectResult(
      Point(x: 3929641.8091766406, y: -153133.01290731132),
      Point(x: 17.888058560281518, y: 46.892264067008725)),
  'EPSG:5933': ProjectAndUnProjectResult(
      Point(x: -1188183.3054560896, y: -1910006.2399837212),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:4913': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:5934': ProjectAndUnProjectResult(
      Point(x: -4922351.672361038, y: 2005951.3756691637),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:5935': ProjectAndUnProjectResult(
      Point(x: -2924369.894691192, y: 7034550.211933859),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:5936': ProjectAndUnProjectResult(
      Point(x: 3052508.1786910295, y: 6904524.573246651),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:5937': ProjectAndUnProjectResult(
      Point(x: 6433623.011832413, y: 4346299.58546257),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:5938': ProjectAndUnProjectResult(
      Point(x: 5892134.678781036, y: -1164399.2159684575),
      Point(x: 17.888058560281518, y: 46.892264067008725)),
  'EPSG:5939': ProjectAndUnProjectResult(
      Point(x: 1990199.6469416232, y: -3016177.699092376),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:5940': ProjectAndUnProjectResult(
      Point(x: -3009816.1127397176, y: 1747260.4654485888),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6050': ProjectAndUnProjectResult(
      Point(x: 29211939.128542803, y: -1362813.9361472572),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6051': ProjectAndUnProjectResult(
      Point(x: 23160659.981976435, y: 1623551.285055918),
      Point(x: 17.888058560281518, y: 46.89226406700871)),
  'EPSG:32605': ProjectAndUnProjectResult(
      Point(x: 1193931.3463186407, y: 14762287.606221085),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:6052': ProjectAndUnProjectResult(
      Point(x: 22962409.679766644, y: -942061.73976574),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:6053': ProjectAndUnProjectResult(
      Point(x: 34442149.482131094, y: 4362713.145756536),
      Point(x: 17.88805856028151, y: 46.89226406700875)),
  'EPSG:6054': ProjectAndUnProjectResult(
      Point(x: 35601258.94243822, y: 1988600.4054723177),
      Point(x: 17.888058560281493, y: 46.89226406700875)),
  'EPSG:6055': ProjectAndUnProjectResult(
      Point(x: 35778374.666366816, y: 372020.9731122027),
      Point(x: 17.88805856028148, y: 46.892264067008746)),
  'EPSG:6056': ProjectAndUnProjectResult(
      Point(x: 25358466.57476475, y: 5246069.499067494),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:6057': ProjectAndUnProjectResult(
      Point(x: 26553257.26057827, y: 3336471.7030962096),
      Point(x: 17.888058560281532, y: 46.892264067008725)),
  'EPSG:6058': ProjectAndUnProjectResult(
      Point(x: 27036297.27512765, y: 1924466.6802394548),
      Point(x: 17.888058560281507, y: 46.89226406700874)),
  'EPSG:6059': ProjectAndUnProjectResult(
      Point(x: 46300896.26590719, y: 6376729.593240524),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:4914': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6060': ProjectAndUnProjectResult(
      Point(x: 47648187.08747809, y: 4877253.733754402),
      Point(x: 17.888058560281543, y: 46.89226406700871)),
  'EPSG:6061': ProjectAndUnProjectResult(
      Point(x: 48542355.72864429, y: 3672432.5309997974),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:6062': ProjectAndUnProjectResult(
      Point(x: 31136068.49182696, y: 7199586.558391113),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6063': ProjectAndUnProjectResult(
      Point(x: 32421052.784847174, y: 5938345.176547724),
      Point(x: 17.888058560281507, y: 46.892264067008746)),
  'EPSG:6064': ProjectAndUnProjectResult(
      Point(x: 33372556.836155962, y: 4937029.277303068),
      Point(x: 17.88805856028152, y: 46.89226406700873)),
  'EPSG:6065': ProjectAndUnProjectResult(
      Point(x: 15956946.664678477, y: 8124441.911095215),
      Point(x: 17.888058560281518, y: 46.892264067008746)),
  'EPSG:6066': ProjectAndUnProjectResult(
      Point(x: 17180671.17857993, y: 7020507.474058315),
      Point(x: 17.888058560281507, y: 46.892264067008746)),
  'EPSG:6067': ProjectAndUnProjectResult(
      Point(x: 24988565.14662123, y: 9481374.641974468),
      Point(x: 17.888058560281518, y: 46.89226406700872)),
  'EPSG:4915': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6068': ProjectAndUnProjectResult(
      Point(x: 26315741.595585834, y: 8517148.25571841),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6069': ProjectAndUnProjectResult(
      Point(x: 22662665.73711388, y: -1590036.3203811347),
      Point(x: 17.888058560281497, y: 46.892264067008725)),
  'EPSG:6070': ProjectAndUnProjectResult(
      Point(x: 11235971.467963241, y: -175261.59021839453),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6071': ProjectAndUnProjectResult(
      Point(x: 27156829.82146629, y: 1268394.4999872595),
      Point(x: 17.888058560281507, y: 46.89226406700874)),
  'EPSG:6072': ProjectAndUnProjectResult(
      Point(x: 27170941.64473368, y: 1406513.1612420408),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:6073': ProjectAndUnProjectResult(
      Point(x: 11819165.364626842, y: 2636916.2905788487),
      Point(x: 17.888058560281507, y: 46.89226406700873)),
  'EPSG:6074': ProjectAndUnProjectResult(
      Point(x: 12192199.929272791, y: 2802568.3263358837),
      Point(x: 17.888058560281518, y: 46.892264067008746)),
  'EPSG:6075': ProjectAndUnProjectResult(
      Point(x: 21656762.289162662, y: -702350.0480100727),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:6076': ProjectAndUnProjectResult(
      Point(x: 21698827.159274917, y: 2051041.4263859903),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6077': ProjectAndUnProjectResult(
      Point(x: 10766168.114906056, y: 639234.3425649977),
      Point(x: 17.888058560281518, y: 46.892264067008725)),
  'EPSG:6078': ProjectAndUnProjectResult(
      Point(x: 11048085.685612302, y: 2591547.0719774826),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6079': ProjectAndUnProjectResult(
      Point(x: 12554144.784253523, y: 5144849.75932946),
      Point(x: 17.8880585602815, y: 46.89226406700872)),
  'EPSG:6080': ProjectAndUnProjectResult(
      Point(x: 15420164.190572355, y: 7597061.539570538),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6081': ProjectAndUnProjectResult(
      Point(x: 27400389.84062728, y: 2316444.435553908),
      Point(x: 17.8880585602815, y: 46.89226406700872)),
  'EPSG:6082': ProjectAndUnProjectResult(
      Point(x: 28132042.326904997, y: 3850759.657223044),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:6083': ProjectAndUnProjectResult(
      Point(x: 29571398.998838726, y: 5760866.3751071235),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6084': ProjectAndUnProjectResult(
      Point(x: 31809296.274642088, y: 7737285.738799064),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:6085': ProjectAndUnProjectResult(
      Point(x: 34807189.61921593, y: 9459794.806370655),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6086': ProjectAndUnProjectResult(
      Point(x: 38479333.41646298, y: 10684074.555158485),
      Point(x: 17.888058560281486, y: 46.892264067008725)),
  'EPSG:6087': ProjectAndUnProjectResult(
      Point(x: 12708090.446935492, y: 3489500.7605388165),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6088': ProjectAndUnProjectResult(
      Point(x: 13528951.815106094, y: 4622677.362694095),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6089': ProjectAndUnProjectResult(
      Point(x: 14759394.428896282, y: 6156818.745237717),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:6090': ProjectAndUnProjectResult(
      Point(x: 16560210.960804481, y: 7861557.522394458),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6091': ProjectAndUnProjectResult(
      Point(x: 18955366.504196048, y: 9531785.18616663),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6092': ProjectAndUnProjectResult(
      Point(x: 21897317.256455526, y: 10966545.49110287),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6117': ProjectAndUnProjectResult(
      Point(x: 27754657.779008288, y: 5346680.714011554),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6093': ProjectAndUnProjectResult(
      Point(x: 25272730.83141788, y: 11993212.842347767),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6094': ProjectAndUnProjectResult(
      Point(x: 28672231.949399307, y: 12453101.772669625),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:6095': ProjectAndUnProjectResult(
      Point(x: 33446085.147038214, y: 12124067.20999254),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6096': ProjectAndUnProjectResult(
      Point(x: 13213266.737754596, y: 13796554.57464162),
      Point(x: 17.888058560281486, y: 46.89226406700873)),
  'EPSG:6097': ProjectAndUnProjectResult(
      Point(x: 18709561.0091406, y: 13447950.448874282),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6098': ProjectAndUnProjectResult(
      Point(x: 28282386.94989309, y: 3522610.5991332335),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6099': ProjectAndUnProjectResult(
      Point(x: 18226991.753159028, y: 6702873.251982847),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6100': ProjectAndUnProjectResult(
      Point(x: 21481976.439178005, y: 3566045.551557177),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6101': ProjectAndUnProjectResult(
      Point(x: 28412020.37379972, y: 8791777.2991312),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6102': ProjectAndUnProjectResult(
      Point(x: 32008452.988568272, y: 6843724.140249735),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6103': ProjectAndUnProjectResult(
      Point(x: 34442149.482131094, y: 4362713.145756536),
      Point(x: 17.88805856028151, y: 46.89226406700875)),
  'EPSG:6104': ProjectAndUnProjectResult(
      Point(x: 17536496.56207289, y: 10073776.32950361),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6105': ProjectAndUnProjectResult(
      Point(x: 20869384.07738987, y: 8486849.534234472),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:6106': ProjectAndUnProjectResult(
      Point(x: 23435009.154089913, y: 6493110.821504261),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:6107': ProjectAndUnProjectResult(
      Point(x: 36572083.99074524, y: 11453650.89477485),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6108': ProjectAndUnProjectResult(
      Point(x: 39668677.127104156, y: 10240415.296023415),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:6109': ProjectAndUnProjectResult(
      Point(x: 42309909.87845571, y: 8735995.911881693),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6110': ProjectAndUnProjectResult(
      Point(x: 44425737.963693015, y: 7104726.16733988),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:6111': ProjectAndUnProjectResult(
      Point(x: 21719597.49526016, y: 12782575.461948223),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6112': ProjectAndUnProjectResult(
      Point(x: 24718902.326839015, y: 11624345.555039367),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6113': ProjectAndUnProjectResult(
      Point(x: 27318746.029775776, y: 10217116.293077389),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6114': ProjectAndUnProjectResult(
      Point(x: 29462333.20469378, y: 8694129.298098769),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6115': ProjectAndUnProjectResult(
      Point(x: 26450870.175606057, y: -2894301.400468095),
      Point(x: 17.8880585602815, y: 46.892264067008725)),
  'EPSG:6116': ProjectAndUnProjectResult(
      Point(x: 24732905.80108915, y: 450840.2015568176),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7677': ProjectAndUnProjectResult(
      Point(x: 4155358.2806846127, y: 1341187.820899545),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6118': ProjectAndUnProjectResult(
      Point(x: 22597913.495447412, y: 6904605.098151971),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6119': ProjectAndUnProjectResult(
      Point(x: 23946253.226905465, y: 5420530.248920105),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6120': ProjectAndUnProjectResult(
      Point(x: 7762498.399899033, y: 7558409.844559555),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6121': ProjectAndUnProjectResult(
      Point(x: 13345103.129377346, y: 8305161.42974583),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6122': ProjectAndUnProjectResult(
      Point(x: 19408014.81123779, y: 9273898.483698972),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:6123': ProjectAndUnProjectResult(
      Point(x: 24566702.636361282, y: 9620633.58516803),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6124': ProjectAndUnProjectResult(
      Point(x: 13589094.96411597, y: 10994305.853383258),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6125': ProjectAndUnProjectResult(
      Point(x: 49335237.01547448, y: 2979540.0928082597),
      Point(x: 17.888058560281507, y: 46.89226406700873)),
  'EPSG:6328': ProjectAndUnProjectResult(
      Point(x: -1540720.0453096956, y: 14440239.5923442),
      Point(x: 17.88805856028151, y: 46.89226406700882)),
  'EPSG:6128': ProjectAndUnProjectResult(
      Point(x: 18817358.313103627, y: 35805938.37365147),
      Point(x: 17.888058533434197, y: 46.89226400725348)),
  'EPSG:6129': ProjectAndUnProjectResult(
      Point(x: 18818856.269998796, y: 35807141.412475236),
      Point(x: 17.888058556925007, y: 46.89226404878659)),
  'EPSG:6141': ProjectAndUnProjectResult(
      Point(x: -14445916.42367035, y: 15565177.316419605),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6204': ProjectAndUnProjectResult(
      Point(x: 263306.856960149, y: 5198942.980445724),
      Point(x: 17.888058599026714, y: 46.892264069175155)),
  'EPSG:6210': ProjectAndUnProjectResult(
      Point(x: 5009686.094082634, y: 7424545.011094015),
      Point(x: 17.888058560281564, y: 46.89226406700879)),
  'EPSG:6211': ProjectAndUnProjectResult(
      Point(x: 4658127.571879782, y: 6980668.280905059),
      Point(x: 17.888058560281525, y: 46.89226406700877)),
  'EPSG:6307': ProjectAndUnProjectResult(
      Point(x: 7328037.617013937, y: 5241769.00316173),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6312': ProjectAndUnProjectResult(
      Point(x: -950591.5443067134, y: 1807051.9048065823),
      Point(x: 17.88807717290827, y: 46.89226406004759)),
  'EPSG:6316': ProjectAndUnProjectResult(
      Point(x: 7263306.8569601495, y: 5198942.980445724),
      Point(x: 17.88805859902672, y: 46.892264069175155)),
  'EPSG:6330': ProjectAndUnProjectResult(
      Point(x: -633185.5802525296, y: 14694063.811162705),
      Point(x: 17.888058560281486, y: 46.8922640670088)),
  'EPSG:6331': ProjectAndUnProjectResult(
      Point(x: -176891.28615693585, y: 14764258.052049907),
      Point(x: 17.888058560281486, y: 46.892264067008796)),
  'EPSG:6332': ProjectAndUnProjectResult(
      Point(x: 279998.7701617067, y: 14798688.275906026),
      Point(x: 17.888058560281486, y: 46.89226406700881)),
  'EPSG:6333': ProjectAndUnProjectResult(
      Point(x: 737054.7120364595, y: 14798035.78326757),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:6334': ProjectAndUnProjectResult(
      Point(x: 1193931.3463247414, y: 14762287.606177554),
      Point(x: 17.888058560281486, y: 46.892264067008796)),
  'EPSG:6335': ProjectAndUnProjectResult(
      Point(x: 1650192.1809783236, y: 14690736.608609322),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:6336': ProjectAndUnProjectResult(
      Point(x: 2105125.3251090776, y: 14581988.281413767),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:6337': ProjectAndUnProjectResult(
      Point(x: 2557536.036411387, y: 14433982.116084043),
      Point(x: 17.88805856028154, y: 46.892264067008774)),
  'EPSG:6338': ProjectAndUnProjectResult(
      Point(x: 3005502.501253523, y: 14244044.5770818),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:6339': ProjectAndUnProjectResult(
      Point(x: 3446086.561687547, y: 14009002.219252983),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:4916': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6340': ProjectAndUnProjectResult(
      Point(x: 3875003.072767595, y: 13725397.247874938),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:6341': ProjectAndUnProjectResult(
      Point(x: 4286275.534235133, y: 13389860.739087315),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:6342': ProjectAndUnProjectResult(
      Point(x: 4671946.775898903, y: 12999702.032507129),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:6343': ProjectAndUnProjectResult(
      Point(x: 5021971.586011266, y: 12553749.126989897),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:6344': ProjectAndUnProjectResult(
      Point(x: 5324476.5639229575, y: 12053400.324134082),
      Point(x: 17.88805856028146, y: 46.89226406700884)),
  'EPSG:6345': ProjectAndUnProjectResult(
      Point(x: 5566585.223791351, y: 11503707.444009647),
      Point(x: 17.888058560281575, y: 46.892264067008874)),
  'EPSG:6346': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 10914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:6347': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 10298556.41432563),
      Point(x: 17.88805856028164, y: 46.892264067008654)),
  'EPSG:6348': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 9674131.646974),
      Point(x: 17.888058560281358, y: 46.892264067008654)),
  'EPSG:6350': ProjectAndUnProjectResult(
      Point(x: 6774661.149690735, y: 7282623.854975374),
      Point(x: 17.88805856028151, y: 46.89226406700876)),
  'EPSG:4917': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6351': ProjectAndUnProjectResult(
      Point(x: 28672231.949399307, y: 12453101.772669625),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:6352': ProjectAndUnProjectResult(
      Point(x: 33446085.147038214, y: 12124067.20999254),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6353': ProjectAndUnProjectResult(
      Point(x: 13213266.737754596, y: 13796554.57464162),
      Point(x: 17.888058560281486, y: 46.89226406700873)),
  'EPSG:6354': ProjectAndUnProjectResult(
      Point(x: 18709561.0091406, y: 13447950.448874282),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6355': ProjectAndUnProjectResult(
      Point(x: 4175252.6559100477, y: 8132636.419234506), Point(x: 0, y: 90)),
  'EPSG:6356': ProjectAndUnProjectResult(
      Point(x: 4335563.615183162, y: 8328698.3072116645), Point(x: 0, y: 90)),
  'EPSG:6362': ProjectAndUnProjectResult(
      Point(x: 11336127.570348896, y: 7858098.963668537),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6366': ProjectAndUnProjectResult(
      Point(x: 3875003.072767595, y: 13725397.247874938),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:6367': ProjectAndUnProjectResult(
      Point(x: 4286275.534235133, y: 13389860.739087315),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:6368': ProjectAndUnProjectResult(
      Point(x: 4671946.775898903, y: 12999702.032507129),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:6369': ProjectAndUnProjectResult(
      Point(x: 5021971.586011266, y: 12553749.126989897),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:6370': ProjectAndUnProjectResult(
      Point(x: 5324476.5639229575, y: 12053400.324134082),
      Point(x: 17.88805856028146, y: 46.89226406700884)),
  'EPSG:6371': ProjectAndUnProjectResult(
      Point(x: 5566585.223791351, y: 11503707.444009647),
      Point(x: 17.888058560281575, y: 46.892264067008874)),
  'EPSG:6372': ProjectAndUnProjectResult(
      Point(x: 11336127.570348896, y: 7858098.963668537),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6381': ProjectAndUnProjectResult(
      Point(x: 62977.02345008202, y: 5200107.5557981115),
      Point(x: 17.8880585711437, y: 46.89226406858427)),
  'EPSG:6382': ProjectAndUnProjectResult(
      Point(x: -165600.2406713484, y: 5213567.368145596),
      Point(x: 17.888058574012387, y: 46.892264064089886)),
  'EPSG:6383': ProjectAndUnProjectResult(
      Point(x: -394086.52944167913, y: 5235860.647503206),
      Point(x: 17.888058729263665, y: 46.8922640233896)),
  'EPSG:6384': ProjectAndUnProjectResult(
      Point(x: -622423.0777060273, y: 5267097.50637579),
      Point(x: 17.888060894831245, y: 46.89226389546803)),
  'EPSG:6385': ProjectAndUnProjectResult(
      Point(x: -850534.0952441327, y: 5307431.144329979),
      Point(x: 17.888077165110136, y: 46.89226406159528)),
  'EPSG:6386': ProjectAndUnProjectResult(
      Point(x: -1078320.5804376781, y: 5357057.416403098),
      Point(x: 17.888161902699313, y: 46.892267824310814)),
  'EPSG:6387': ProjectAndUnProjectResult(
      Point(x: -1305653.6419688992, y: 5416214.116028281),
      Point(x: 17.888508861463574, y: 46.89229074889061)),
  'EPSG:6391': ProjectAndUnProjectResult(
      Point(x: 29383452.903728507, y: 20153323.98735387),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:6393': ProjectAndUnProjectResult(
      Point(x: 2704046.3736966117, y: 9181485.899239805),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6394': ProjectAndUnProjectResult(
      Point(x: 6508725.5759530235, y: 4717646.787048834),
      Point(x: 17.88805856028155, y: 46.89226406700871)),
  'EPSG:6395': ProjectAndUnProjectResult(
      Point(x: -37213279.522647545, y: -18912875.961270504),
      Point(x: 0, y: -90)),
  'EPSG:6396': ProjectAndUnProjectResult(
      Point(x: -45107405.43757957, y: -26521048.301904406),
      Point(x: 0, y: -90)),
  'EPSG:6397': ProjectAndUnProjectResult(
      Point(x: -54145589.80520173, y: -35798007.60070698), Point(x: 0, y: -90)),
  'EPSG:6398': ProjectAndUnProjectResult(
      Point(x: -64460118.121024735, y: -47015897.944632985),
      Point(x: 0, y: -90)),
  'EPSG:4918': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6399': ProjectAndUnProjectResult(
      Point(x: -76195487.58152132, y: -60481645.41980923), Point(x: 0, y: -90)),
  'EPSG:6400': ProjectAndUnProjectResult(
      Point(x: -89509253.44187886, y: -76540389.67400539), Point(x: 0, y: -90)),
  'EPSG:6401': ProjectAndUnProjectResult(
      Point(x: 77897438.88146861, y: -61308557.825420626), Point(x: 0, y: -90)),
  'EPSG:6402': ProjectAndUnProjectResult(
      Point(x: 66078013.4794075, y: -47707169.16826724), Point(x: 0, y: -90)),
  'EPSG:6403': ProjectAndUnProjectResult(
      Point(x: -3067782.7230528235, y: 8760315.521445647),
      Point(x: 17.888058560281486, y: 46.89226406700873)),
  'EPSG:6404': ProjectAndUnProjectResult(
      Point(x: -4128150.708307095, y: 7585988.433132556), Point(x: 0, y: 90)),
  'EPSG:6405': ProjectAndUnProjectResult(
      Point(x: -13543801.5364406, y: 24888413.49452938), Point(x: 0, y: 90)),
  'EPSG:6406': ProjectAndUnProjectResult(
      Point(x: -3169861.026850693, y: 7913822.186592112), Point(x: 0, y: 90)),
  'EPSG:6407': ProjectAndUnProjectResult(
      Point(x: -10399806.518539019, y: 25963983.55181139), Point(x: 0, y: 90)),
  'EPSG:6408': ProjectAndUnProjectResult(
      Point(x: -5215796.690656631, y: 7168396.858414973), Point(x: 0, y: 90)),
  'EPSG:6409': ProjectAndUnProjectResult(
      Point(x: -17112193.866983697, y: 23518362.396374583), Point(x: 0, y: 90)),
  'EPSG:6410': ProjectAndUnProjectResult(
      Point(x: 7280845.10476574, y: 5698018.880729793),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6411': ProjectAndUnProjectResult(
      Point(x: 23887239.314518936, y: 18694250.277860995),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6412': ProjectAndUnProjectResult(
      Point(x: 7441828.743390062, y: 6181711.961229637),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6413': ProjectAndUnProjectResult(
      Point(x: 24415399.802238896, y: 20281166.659434237),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6414': ProjectAndUnProjectResult(
      Point(x: 7281011.174753069, y: 7461253.495639747),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:6415': ProjectAndUnProjectResult(
      Point(x: 8713369.04628296, y: 8228903.974584526),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6416': ProjectAndUnProjectResult(
      Point(x: 28587111.613013346, y: 26997662.4569494),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6528': ProjectAndUnProjectResult(
      Point(x: -998074.9727628597, y: 8428106.011472125), Point(x: 0, y: 90)),
  'EPSG:6417': ProjectAndUnProjectResult(
      Point(x: 8988852.870882323, y: 8299543.835321399),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6418': ProjectAndUnProjectResult(
      Point(x: 29490928.127553087, y: 27229420.066716958),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6419': ProjectAndUnProjectResult(
      Point(x: 9196533.03998033, y: 8221416.367224062),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6420': ProjectAndUnProjectResult(
      Point(x: 30172292.14900214, y: 26973096.865134276),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6421': ProjectAndUnProjectResult(
      Point(x: 9364631.99275643, y: 8154335.033546976),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:6422': ProjectAndUnProjectResult(
      Point(x: 30723796.79656839, y: 26753014.189562038),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:6423': ProjectAndUnProjectResult(
      Point(x: 9657012.346788008, y: 8138321.005032831),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6424': ProjectAndUnProjectResult(
      Point(x: 31683048.00808699, y: 26700474.83101188),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:4919': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6425': ProjectAndUnProjectResult(
      Point(x: 9857792.552179694, y: 8039982.800465539),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6426': ProjectAndUnProjectResult(
      Point(x: 32341774.398609553, y: 26377843.57152736),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:6427': ProjectAndUnProjectResult(
      Point(x: 7746779.736843174, y: 6828729.263310314),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6428': ProjectAndUnProjectResult(
      Point(x: 25415893.18631023, y: 22403922.591381256),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6429': ProjectAndUnProjectResult(
      Point(x: 7609906.701740923, y: 6737108.930826646),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6430': ProjectAndUnProjectResult(
      Point(x: 24966835.570312265, y: 22103331.550557755),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6431': ProjectAndUnProjectResult(
      Point(x: 7902404.853652807, y: 6873456.4247696595),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6432': ProjectAndUnProjectResult(
      Point(x: 25926473.257043168, y: 22550664.95360246),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6433': ProjectAndUnProjectResult(
      Point(x: 6039095.133709748, y: 4143749.064976011),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:6434': ProjectAndUnProjectResult(
      Point(x: 19813264.617850065, y: 13594950.05734413),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:6435': ProjectAndUnProjectResult(
      Point(x: 5117848.770438616, y: 6252732.387920412), Point(x: 0, y: 90)),
  'EPSG:6436': ProjectAndUnProjectResult(
      Point(x: 16790808.84134736, y: 20514172.84270222), Point(x: 0, y: 90)),
  'EPSG:6437': ProjectAndUnProjectResult(
      Point(x: 4721237.687280814, y: 8356420.754737286), Point(x: 0, y: 90)),
  'EPSG:6438': ProjectAndUnProjectResult(
      Point(x: 15489593.979353804, y: 27416023.75950058), Point(x: 0, y: 90)),
  'EPSG:6439': ProjectAndUnProjectResult(
      Point(x: 7788718.898020689, y: 5738991.145189423),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:6440': ProjectAndUnProjectResult(
      Point(x: 7714848.02247523, y: 5442253.479619011),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:6441': ProjectAndUnProjectResult(
      Point(x: 25311130.553737484, y: 17855126.624383375),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:6442': ProjectAndUnProjectResult(
      Point(x: 4625113.957471083, y: 8456488.815026179), Point(x: 0, y: 90)),
  'EPSG:6443': ProjectAndUnProjectResult(
      Point(x: 15174228.04246971, y: 27744330.38729839), Point(x: 0, y: 90)),
  'EPSG:6444': ProjectAndUnProjectResult(
      Point(x: 4608098.742447868, y: 7844758.075159398), Point(x: 0, y: 90)),
  'EPSG:6445': ProjectAndUnProjectResult(
      Point(x: 15118403.957847713, y: 25737343.784918793), Point(x: 0, y: 90)),
  'EPSG:6446': ProjectAndUnProjectResult(
      Point(x: 4887189.5243078265, y: 8036713.270922709), Point(x: 0, y: 90)),
  'EPSG:6447': ProjectAndUnProjectResult(
      Point(x: 16034054.29733326, y: 26367116.78968559), Point(x: 0, y: 90)),
  'EPSG:6448': ProjectAndUnProjectResult(
      Point(x: -5084440.623114015, y: 5921630.496325042), Point(x: 0, y: 90)),
  'EPSG:6449': ProjectAndUnProjectResult(
      Point(x: -16681202.277333234, y: 19427882.72002641), Point(x: 0, y: 90)),
  'EPSG:6450': ProjectAndUnProjectResult(
      Point(x: -4284867.971020522, y: 6350434.242753448), Point(x: 0, y: 90)),
  'EPSG:4920': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6451': ProjectAndUnProjectResult(
      Point(x: -14057937.667923164, y: 20834716.344766937), Point(x: 0, y: 90)),
  'EPSG:6452': ProjectAndUnProjectResult(
      Point(x: -5919234.386603765, y: 5433186.325411458), Point(x: 0, y: 90)),
  'EPSG:6453': ProjectAndUnProjectResult(
      Point(x: -19420021.483049188, y: 17825378.802620757), Point(x: 0, y: 90)),
  'EPSG:6454': ProjectAndUnProjectResult(
      Point(x: 3905071.6147695784, y: 7655783.660641345), Point(x: 0, y: 90)),
  'EPSG:6455': ProjectAndUnProjectResult(
      Point(x: 12811889.12278986, y: 25117350.226620816), Point(x: 0, y: 90)),
  'EPSG:6456': ProjectAndUnProjectResult(
      Point(x: 3990597.385999085, y: 7789443.487367855), Point(x: 0, y: 90)),
  'EPSG:6457': ProjectAndUnProjectResult(
      Point(x: 13092484.923865333, y: 25555865.841472708), Point(x: 0, y: 90)),
  'EPSG:6458': ProjectAndUnProjectResult(
      Point(x: 4097701.446227201, y: 7591591.6682478), Point(x: 0, y: 90)),
  'EPSG:6459': ProjectAndUnProjectResult(
      Point(x: 13443875.494497076, y: 24906746.99790966), Point(x: 0, y: 90)),
  'EPSG:6460': ProjectAndUnProjectResult(
      Point(x: 4698254.479714725, y: 7712933.359383934), Point(x: 0, y: 90)),
  'EPSG:6461': ProjectAndUnProjectResult(
      Point(x: 15414189.905530728, y: 25304848.862912126), Point(x: 0, y: 90)),
  'EPSG:6462': ProjectAndUnProjectResult(
      Point(x: 7754185.385967116, y: 6441441.897699313),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6463': ProjectAndUnProjectResult(
      Point(x: 25440189.887127113, y: 21133297.2926685),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6464': ProjectAndUnProjectResult(
      Point(x: 6883654.037123509, y: 5522527.676852138),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6465': ProjectAndUnProjectResult(
      Point(x: 22584121.62016271, y: 18118492.88647239),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6466': ProjectAndUnProjectResult(
      Point(x: 7071987.862697571, y: 5919601.754797991),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:6467': ProjectAndUnProjectResult(
      Point(x: 23202013.512833614, y: 19421226.757199746),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:6673': ProjectAndUnProjectResult(
      Point(x: -1306115.9982166318, y: 8196578.576068864), Point(x: 0, y: 90)),
  'EPSG:6468': ProjectAndUnProjectResult(
      Point(x: 7225695.016863069, y: 6455856.986343259),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6469': ProjectAndUnProjectResult(
      Point(x: 23706301.067791585, y: 21180590.79599451),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6470': ProjectAndUnProjectResult(
      Point(x: 6854798.276271999, y: 4982007.395728776),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6471': ProjectAndUnProjectResult(
      Point(x: 22489450.678402383, y: 16345135.930820161),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6472': ProjectAndUnProjectResult(
      Point(x: 7954314.818287251, y: 6181092.986200401),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6473': ProjectAndUnProjectResult(
      Point(x: 26096781.19966409, y: 20279135.905225817),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6474': ProjectAndUnProjectResult(
      Point(x: 7000500.0764196385, y: 5649813.9503045585),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:6475': ProjectAndUnProjectResult(
      Point(x: 22967474.00105343, y: 18536097.935624205),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'ESRI:37002': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6476': ProjectAndUnProjectResult(
      Point(x: 8293004.335917232, y: 5912444.595764324),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6477': ProjectAndUnProjectResult(
      Point(x: 27207965.058721785, y: 19397745.31127012),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6478': ProjectAndUnProjectResult(
      Point(x: 8460640.04761491, y: 5922044.6080015665),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6479': ProjectAndUnProjectResult(
      Point(x: 27757949.88951659, y: 19429241.351418473),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6480': ProjectAndUnProjectResult(
      Point(x: 5625524.243963247, y: 4952785.35904863),
      Point(x: -21737319794.91784, y: 4757338589.640197)),
  'EPSG:6481': ProjectAndUnProjectResult(
      Point(x: 5841926.85039724, y: 4779293.471123142),
      Point(x: -856956604.9425999, y: 188140569.70074788)),
  'EPSG:6482': ProjectAndUnProjectResult(
      Point(x: 5401485.579875652, y: 5163842.641810937),
      Point(x: -11503948981851.02, y: 2505985965549.347)),
  'EPSG:6483': ProjectAndUnProjectResult(
      Point(x: 5434242.727510438, y: 4865567.286727372),
      Point(x: -3577911303.5949883, y: 784422263.488511)),
  'EPSG:6484': ProjectAndUnProjectResult(
      Point(x: 17828844.681840498, y: 15963115.339871386),
      Point(x: -3577911303.5949883, y: 784422263.488511)),
  'EPSG:6485': ProjectAndUnProjectResult(
      Point(x: 6005972.529556511, y: 5140915.469168544),
      Point(x: -2514978608650.738, y: 548342325600.6209)),
  'EPSG:6486': ProjectAndUnProjectResult(
      Point(x: 19704594.87405332, y: 16866486.83509713),
      Point(x: -2514978608650.738, y: 548342325600.6209)),
  'EPSG:6487': ProjectAndUnProjectResult(
      Point(x: 6458859.816901178, y: 4494509.018460154),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:6488': ProjectAndUnProjectResult(
      Point(x: 21190442.582283285, y: 14745735.004731355),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:6489': ProjectAndUnProjectResult(
      Point(x: 6154332.406766824, y: 3817884.2153315847),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6490': ProjectAndUnProjectResult(
      Point(x: 20191338.90486749, y: 12525841.796467042),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6491': ProjectAndUnProjectResult(
      Point(x: 5851118.614199274, y: 4670879.245324666),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:6492': ProjectAndUnProjectResult(
      Point(x: 19196544.98708545, y: 15324376.324036008),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:6610': ProjectAndUnProjectResult(
      Point(x: 3839622.300083163, y: 7353217.56768338), Point(x: 0, y: 90)),
  'EPSG:6493': ProjectAndUnProjectResult(
      Point(x: 11889319.027601004, y: 4694603.857861964),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:6494': ProjectAndUnProjectResult(
      Point(x: 39006952.19021326, y: 15402243.62815605),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6495': ProjectAndUnProjectResult(
      Point(x: 13856577.937746815, y: 4794610.454685856),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6496': ProjectAndUnProjectResult(
      Point(x: 45461213.70641344, y: 15730349.260780366),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6497': ProjectAndUnProjectResult(
      Point(x: 8386430.7898983145, y: 2796245.837725366),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6498': ProjectAndUnProjectResult(
      Point(x: 10027794.9275133, y: 4787933.322479354),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:6499': ProjectAndUnProjectResult(
      Point(x: 32899589.65714337, y: 15708442.659052998),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:6500': ProjectAndUnProjectResult(
      Point(x: 6763552.011142525, y: 5414428.169782657),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:4922': ProjectAndUnProjectResult(
      Point(x: 4155358.2806846127, y: 1341187.820899545),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6501': ProjectAndUnProjectResult(
      Point(x: 22190086.889923435, y: 17763836.420328602),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6502': ProjectAndUnProjectResult(
      Point(x: 6637522.089340442, y: 5241976.733282339),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6503': ProjectAndUnProjectResult(
      Point(x: 21776603.721477766, y: 17198051.99907714),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6504': ProjectAndUnProjectResult(
      Point(x: 6907731.6671998175, y: 5516216.609642071),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6505': ProjectAndUnProjectResult(
      Point(x: 22663116.311504737, y: 18097787.326767363),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6506': ProjectAndUnProjectResult(
      Point(x: 3822984.905080838, y: 8488545.1484227), Point(x: 0, y: 90)),
  'EPSG:6507': ProjectAndUnProjectResult(
      Point(x: 12542576.309419384, y: 27849501.87445014), Point(x: 0, y: 90)),
  'EPSG:6508': ProjectAndUnProjectResult(
      Point(x: 3865026.376812202, y: 9521806.905574037), Point(x: 0, y: 90)),
  'EPSG:6509': ProjectAndUnProjectResult(
      Point(x: 3960143.9403490187, y: 8595620.856387978), Point(x: 0, y: 90)),
  'EPSG:6510': ProjectAndUnProjectResult(
      Point(x: 12992572.243961738, y: 28200799.426332895), Point(x: 0, y: 90)),
  'EPSG:6511': ProjectAndUnProjectResult(
      Point(x: 3333355.4118026467, y: 8025679.559234873), Point(x: 0, y: 90)),
  'EPSG:6512': ProjectAndUnProjectResult(
      Point(x: 3479281.287680031, y: 7904330.11893151), Point(x: 0, y: 90)),
  'EPSG:6513': ProjectAndUnProjectResult(
      Point(x: 3236399.2997552953, y: 8083966.915915788), Point(x: 0, y: 90)),
  'EPSG:6514': ProjectAndUnProjectResult(
      Point(x: 6556297.784221025, y: 6590553.712986213),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6515': ProjectAndUnProjectResult(
      Point(x: 21510163.334050607, y: 21622551.551792037),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6516': ProjectAndUnProjectResult(
      Point(x: 6975000.373432801, y: 6039872.843451777),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:6517': ProjectAndUnProjectResult(
      Point(x: 22883813.725204114, y: 19815816.15389137),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:6518': ProjectAndUnProjectResult(
      Point(x: -6848369.235542074, y: 11911589.980849914),
      Point(x: 189531435637.07315, y: 59487357072.499916)),
  'EPSG:4924': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6519': ProjectAndUnProjectResult(
      Point(x: -22468358.066907622, y: 39079941.46217176),
      Point(x: 189531435637.07315, y: 59487357072.499916)),
  'EPSG:6520': ProjectAndUnProjectResult(
      Point(x: -6407205.481935473, y: 14250720.322452161), Point(x: 0, y: 90)),
  'EPSG:6521': ProjectAndUnProjectResult(
      Point(x: -21020973.318616632, y: 46754238.25794514), Point(x: 0, y: 90)),
  'EPSG:6522': ProjectAndUnProjectResult(
      Point(x: -7945837.346430153, y: 9227187.99242025),
      Point(x: 53494776.36427391, y: 20053499.392547227)),
  'EPSG:6523': ProjectAndUnProjectResult(
      Point(x: -26068968.027379595, y: 30272865.938432105),
      Point(x: 53494776.36427391, y: 20053499.392547227)),
  'EPSG:6524': ProjectAndUnProjectResult(
      Point(x: 5368091.402649273, y: 5342638.370730873), Point(x: 0, y: 90)),
  'EPSG:6525': ProjectAndUnProjectResult(
      Point(x: 17611813.210191824, y: 17528306.05463954), Point(x: 0, y: 90)),
  'EPSG:6526': ProjectAndUnProjectResult(
      Point(x: 5111955.253111458, y: 6059884.249141174), Point(x: 0, y: 90)),
  'EPSG:6527': ProjectAndUnProjectResult(
      Point(x: 16771473.19291651, y: 19881470.240724005), Point(x: 0, y: 90)),
  'EPSG:4926': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6529': ProjectAndUnProjectResult(
      Point(x: -3274517.639472816, y: 27651211.139304798), Point(x: 0, y: 90)),
  'EPSG:6530': ProjectAndUnProjectResult(
      Point(x: -530531.6564737859, y: 8584058.195630815), Point(x: 0, y: 90)),
  'EPSG:6531': ProjectAndUnProjectResult(
      Point(x: -1740585.942947746, y: 28162864.26349877), Point(x: 0, y: 90)),
  'EPSG:6532': ProjectAndUnProjectResult(
      Point(x: -1388949.665557478, y: 8254150.647986836), Point(x: 0, y: 90)),
  'EPSG:6533': ProjectAndUnProjectResult(
      Point(x: -4556912.360749827, y: 27080492.584270146), Point(x: 0, y: 90)),
  'EPSG:6534': ProjectAndUnProjectResult(
      Point(x: 5102989.244976103, y: 6156462.138120647), Point(x: 0, y: 90)),
  'EPSG:6535': ProjectAndUnProjectResult(
      Point(x: 16742057.214225767, y: 20198326.19815082), Point(x: 0, y: 90)),
  'EPSG:6536': ProjectAndUnProjectResult(
      Point(x: 5111955.253111458, y: 6059884.249141174), Point(x: 0, y: 90)),
  'EPSG:6537': ProjectAndUnProjectResult(
      Point(x: 16771473.19291651, y: 19881470.240724005), Point(x: 0, y: 90)),
  'EPSG:4928': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6538': ProjectAndUnProjectResult(
      Point(x: 6120506.5914582675, y: 4115911.994870667),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6539': ProjectAndUnProjectResult(
      Point(x: 20080362.042142667, y: 13503621.26983818),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6540': ProjectAndUnProjectResult(
      Point(x: 5070627.948794095, y: 6369472.582025805), Point(x: 0, y: 90)),
  'EPSG:6541': ProjectAndUnProjectResult(
      Point(x: 16635885.195668627, y: 20897177.962862995), Point(x: 0, y: 90)),
  'EPSG:6542': ProjectAndUnProjectResult(
      Point(x: 7013164.842371999, y: 4867653.736840957),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6543': ProjectAndUnProjectResult(
      Point(x: 23009024.984398805, y: 15969960.634952374),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:6544': ProjectAndUnProjectResult(
      Point(x: 6465460.630965634, y: 5661785.323388806),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6545': ProjectAndUnProjectResult(
      Point(x: 21212141.1777009, y: 18575411.16597377),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6611': ProjectAndUnProjectResult(
      Point(x: -835360.288822798, y: 7469523.565254046), Point(x: 0, y: 90)),
  'EPSG:6546': ProjectAndUnProjectResult(
      Point(x: 6573964.729929726, y: 5741275.293893124),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6547': ProjectAndUnProjectResult(
      Point(x: 21568125.75435474, y: 18836205.032457754),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6548': ProjectAndUnProjectResult(
      Point(x: 6701563.894453452, y: 4762473.447759279),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6549': ProjectAndUnProjectResult(
      Point(x: 21986714.210386034, y: 15624881.636523569),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6550': ProjectAndUnProjectResult(
      Point(x: 6823927.076346041, y: 4856567.2808180135),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6551': ProjectAndUnProjectResult(
      Point(x: 22388167.416311968, y: 15933587.820483766),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6552': ProjectAndUnProjectResult(
      Point(x: 7606719.341866343, y: 6088830.052103923),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:6553': ProjectAndUnProjectResult(
      Point(x: 24956378.374106497, y: 19976436.59594429),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:6674': ProjectAndUnProjectResult(
      Point(x: -788366.1033867978, y: 8189401.718133621), Point(x: 0, y: 90)),
  'EPSG:6554': ProjectAndUnProjectResult(
      Point(x: 7788873.682746351, y: 6165418.092119623),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6555': ProjectAndUnProjectResult(
      Point(x: 25553996.407476988, y: 20227709.190562464),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6556': ProjectAndUnProjectResult(
      Point(x: 6621080.326600361, y: 7550611.109639786),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6557': ProjectAndUnProjectResult(
      Point(x: 21722704.48359173, y: 24772346.160235517),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6558': ProjectAndUnProjectResult(
      Point(x: 8597033.820587108, y: 7390016.602283895),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6559': ProjectAndUnProjectResult(
      Point(x: 28205491.53782647, y: 24245461.29358233),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6560': ProjectAndUnProjectResult(
      Point(x: 7874076.89548586, y: 7497850.224338042),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:6561': ProjectAndUnProjectResult(
      Point(x: 25833585.615591403, y: 24599246.142841343),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:6612': ProjectAndUnProjectResult(
      Point(x: -2740677.880879463, y: 24506261.897004317), Point(x: 0, y: 90)),
  'EPSG:6562': ProjectAndUnProjectResult(
      Point(x: 6522469.313095474, y: 4396559.711847568),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6563': ProjectAndUnProjectResult(
      Point(x: 21399134.738047402, y: 14424379.654619897),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6564': ProjectAndUnProjectResult(
      Point(x: 6583746.193120701, y: 4440183.096793512),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6565': ProjectAndUnProjectResult(
      Point(x: 21600173.968596835, y: 14567500.710063381),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6566': ProjectAndUnProjectResult(
      Point(x: 7328037.617013937, y: 5241769.00316173),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6567': ProjectAndUnProjectResult(
      Point(x: 5173030.8098551845, y: 5481823.207905864), Point(x: 0, y: 90)),
  'EPSG:6568': ProjectAndUnProjectResult(
      Point(x: 16971851.915299885, y: 17984948.307937823), Point(x: 0, y: 90)),
  'EPSG:6569': ProjectAndUnProjectResult(
      Point(x: 7231101.448544078, y: 5119305.1873058975),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6671': ProjectAndUnProjectResult(
      Point(x: -1913282.6153144585, y: 8164170.9970185), Point(x: 0, y: 90)),
  'EPSG:6570': ProjectAndUnProjectResult(
      Point(x: 23724086.117270596, y: 16795620.69326082),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:6571': ProjectAndUnProjectResult(
      Point(x: 6731916.633515107, y: 5806582.369900572),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:6572': ProjectAndUnProjectResult(
      Point(x: 22086296.488457482, y: 19050428.99191546),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:6573': ProjectAndUnProjectResult(
      Point(x: 6870716.757738419, y: 5915239.061073107),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6574': ProjectAndUnProjectResult(
      Point(x: 22541676.56268013, y: 19406913.486204017),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:6575': ProjectAndUnProjectResult(
      Point(x: 7240825.507643389, y: 5300270.815013457),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:6576': ProjectAndUnProjectResult(
      Point(x: 23755941.686326686, y: 17389305.165589985),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:6577': ProjectAndUnProjectResult(
      Point(x: 8418734.087582087, y: 9472776.726556078),
      Point(x: 17.88805856028155, y: 46.892264067008746)),
  'EPSG:4930': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6578': ProjectAndUnProjectResult(
      Point(x: 27620463.418675568, y: 31078601.6437094),
      Point(x: 17.88805856028155, y: 46.892264067008746)),
  'EPSG:6579': ProjectAndUnProjectResult(
      Point(x: 9202342.771606717, y: 13714424.334539425),
      Point(x: 17.88805856028155, y: 46.89226406700876)),
  'EPSG:6580': ProjectAndUnProjectResult(
      Point(x: 9154307.075487461, y: 12759946.896370977),
      Point(x: 17.88805856028155, y: 46.892264067008725)),
  'EPSG:6581': ProjectAndUnProjectResult(
      Point(x: 7393138.261094371, y: 7401668.656500031),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6582': ProjectAndUnProjectResult(
      Point(x: 24255654.445273783, y: 24283641.25020052),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6583': ProjectAndUnProjectResult(
      Point(x: 7989143.282984504, y: 8276494.464586326),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6584': ProjectAndUnProjectResult(
      Point(x: 26211047.58759166, y: 27153798.92289697),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6585': ProjectAndUnProjectResult(
      Point(x: 8484246.042842139, y: 11469435.827622361),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:4932': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6586': ProjectAndUnProjectResult(
      Point(x: 27835397.225557923, y: 37629307.37812436),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:6587': ProjectAndUnProjectResult(
      Point(x: 8486728.051005203, y: 10453504.590111742),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:6588': ProjectAndUnProjectResult(
      Point(x: 27843540.280672904, y: 34296206.30905828),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:6589': ProjectAndUnProjectResult(
      Point(x: 5541768.404689928, y: 5434133.661562179), Point(x: 0, y: 90)),
  'EPSG:6590': ProjectAndUnProjectResult(
      Point(x: 18181618.507753536, y: 17828486.854641918), Point(x: 0, y: 90)),
  'EPSG:6591': ProjectAndUnProjectResult(
      Point(x: 6197425.928759272, y: 4812816.468950871),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:6592': ProjectAndUnProjectResult(
      Point(x: 9634482.513941199, y: 6581020.355130133),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:6593': ProjectAndUnProjectResult(
      Point(x: 31609131.381488748, y: 21591230.948789444),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:6672': ProjectAndUnProjectResult(
      Point(x: -1548193.3456383753, y: 8522145.552706772), Point(x: 0, y: 90)),
  'EPSG:6594': ProjectAndUnProjectResult(
      Point(x: 9723405.910334777, y: 5663039.725072842),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:6595': ProjectAndUnProjectResult(
      Point(x: 31900874.224490017, y: 18579489.497676484),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:6596': ProjectAndUnProjectResult(
      Point(x: 6208880.764422776, y: 7201291.121268816),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:6597': ProjectAndUnProjectResult(
      Point(x: 20370302.974943724, y: 23626235.95369611),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:6598': ProjectAndUnProjectResult(
      Point(x: 6409557.023981855, y: 7281838.145229915),
      Point(x: 17.88805856028154, y: 46.892264067008746)),
  'EPSG:6599': ProjectAndUnProjectResult(
      Point(x: 21028688.336513802, y: 23890497.31480848),
      Point(x: 17.88805856028154, y: 46.892264067008746)),
  'EPSG:6600': ProjectAndUnProjectResult(
      Point(x: 6701578.612677592, y: 4608732.256874052),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6601': ProjectAndUnProjectResult(
      Point(x: 21986762.4984264, y: 15120482.412760952),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:4934': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6602': ProjectAndUnProjectResult(
      Point(x: 6860107.275988375, y: 4799756.489364472),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6603': ProjectAndUnProjectResult(
      Point(x: 22506868.621305194, y: 15747201.08218994),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6604': ProjectAndUnProjectResult(
      Point(x: 6611250.719513921, y: 5046926.8438626565),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6605': ProjectAndUnProjectResult(
      Point(x: 21690411.73560526, y: 16558125.8202394),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6606': ProjectAndUnProjectResult(
      Point(x: 6517033.000426102, y: 4968571.836722961),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6607': ProjectAndUnProjectResult(
      Point(x: 21381299.102231305, y: 16301056.100981915),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6608': ProjectAndUnProjectResult(
      Point(x: 6723783.25810189, y: 5169377.719135766),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:6609': ProjectAndUnProjectResult(
      Point(x: 22059612.239289284, y: 16959866.73353126),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:32606': ProjectAndUnProjectResult(
      Point(x: 1650192.180968158, y: 14690736.60865352),
      Point(x: 17.88805856028151, y: 46.89226406700882)),
  'EPSG:6613': ProjectAndUnProjectResult(
      Point(x: -1585501.348464507, y: 7359986.274514455), Point(x: 0, y: 90)),
  'EPSG:6614': ProjectAndUnProjectResult(
      Point(x: -5201765.674120637, y: 24146888.30226951), Point(x: 0, y: 90)),
  'EPSG:6615': ProjectAndUnProjectResult(
      Point(x: -2539578.0552160507, y: 6974103.5782705145), Point(x: 0, y: 90)),
  'EPSG:6616': ProjectAndUnProjectResult(
      Point(x: -8331932.336121327, y: 22880871.48967585), Point(x: 0, y: 90)),
  'EPSG:6617': ProjectAndUnProjectResult(
      Point(x: -2061507.894929119, y: 7079113.201731387), Point(x: 0, y: 90)),
  'EPSG:6618': ProjectAndUnProjectResult(
      Point(x: -6763463.818613284, y: 23225390.562680393), Point(x: 0, y: 90)),
  'EPSG:6619': ProjectAndUnProjectResult(
      Point(x: 7316582.822330039, y: 8971163.047072299),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:6620': ProjectAndUnProjectResult(
      Point(x: 7132858.074758168, y: 7841015.069017461),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:6621': ProjectAndUnProjectResult(
      Point(x: 7595059.15054545, y: 10017430.541012172),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:6622': ProjectAndUnProjectResult(
      Point(x: 5088281.174172236, y: 3829932.5590575594),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6623': ProjectAndUnProjectResult(
      Point(x: 5116259.683303194, y: 3803425.7722843275),
      Point(x: 17.8880585602815, y: 46.892264067008796)),
  'EPSG:6624': ProjectAndUnProjectResult(
      Point(x: 5116259.683303194, y: 3803425.7722843275),
      Point(x: 17.8880585602815, y: 46.892264067008796)),
  'EPSG:6625': ProjectAndUnProjectResult(
      Point(x: 24004488.809627805, y: 29432890.76363637),
      Point(x: 17.88805856028155, y: 46.892264067008725)),
  'EPSG:6626': ProjectAndUnProjectResult(
      Point(x: 23401718.533635758, y: 25725063.605568122),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:6627': ProjectAndUnProjectResult(
      Point(x: 24918123.2297812, y: 32865520.033304103),
      Point(x: 17.88805856028155, y: 46.89226406700872)),
  'EPSG:6628': ProjectAndUnProjectResult(
      Point(x: -68690821.23140611, y: -47885351.84872058), Point(x: 0, y: -90)),
  'EPSG:6629': ProjectAndUnProjectResult(
      Point(x: -72121220.72359695, y: -51990013.836311065),
      Point(x: 0, y: -90)),
  'EPSG:6630': ProjectAndUnProjectResult(
      Point(x: -76202390.86573209, y: -56842739.61567939), Point(x: 0, y: -90)),
  'EPSG:6631': ProjectAndUnProjectResult(
      Point(x: -81001618.96536075, y: -62615395.648396604),
      Point(x: 0, y: -90)),
  'EPSG:6632': ProjectAndUnProjectResult(
      Point(x: -83208947.34861997, y: -65252448.177499056),
      Point(x: 0, y: -90)),
  'EPSG:6633': ProjectAndUnProjectResult(
      Point(x: -250007344.03195605, y: -186491554.88910815),
      Point(x: 0, y: -90)),
  'EPSG:6634': ProjectAndUnProjectResult(
      Point(x: 737054.7120364595, y: 14798035.78326757),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:6635': ProjectAndUnProjectResult(
      Point(x: 1193931.3463247414, y: 14762287.606177554),
      Point(x: 17.888058560281486, y: 46.892264067008796)),
  'EPSG:6636': ProjectAndUnProjectResult(
      Point(x: -176891.28615693585, y: 24764258.052049905),
      Point(x: 17.88805856028154, y: 46.892264067008824)),
  'EPSG:6637': ProjectAndUnProjectResult(
      Point(x: 2872651.044108846, y: 10239580.122362612), Point(x: 0, y: 90)),
  'EPSG:6646': ProjectAndUnProjectResult(
      Point(x: -1369316.867446167, y: 2393982.176129121),
      Point(x: 17.89729361915186, y: 46.89314810588617)),
  'EPSG:6669': ProjectAndUnProjectResult(
      Point(x: -2566056.9116173303, y: 8401313.58870162), Point(x: 0, y: 90)),
  'EPSG:6670': ProjectAndUnProjectResult(
      Point(x: -2211182.2634812854, y: 8462072.812029004), Point(x: 0, y: 90)),
  'EPSG:6675': ProjectAndUnProjectResult(
      Point(x: -398086.9536182322, y: 8165821.33190225), Point(x: 0, y: 90)),
  'EPSG:6676': ProjectAndUnProjectResult(
      Point(x: 77463.83204888566, y: 8118405.0916535165), Point(x: 0, y: 90)),
  'EPSG:6677': ProjectAndUnProjectResult(
      Point(x: 585959.9308690846, y: 8047327.498372015), Point(x: 0, y: 90)),
  'EPSG:6678': ProjectAndUnProjectResult(
      Point(x: 989901.510910523, y: 7533339.024756886), Point(x: 0, y: 90)),
  'EPSG:6679': ProjectAndUnProjectResult(
      Point(x: 751869.6886925661, y: 7131756.363145234), Point(x: 0, y: 90)),
  'EPSG:6680': ProjectAndUnProjectResult(
      Point(x: 1596744.7812366635, y: 6963379.403117015), Point(x: 0, y: 90)),
  'EPSG:6681': ProjectAndUnProjectResult(
      Point(x: 2526128.1328379745, y: 6728261.832241865), Point(x: 0, y: 90)),
  'EPSG:6682': ProjectAndUnProjectResult(
      Point(x: 1486633.193392855, y: 8984705.502253164), Point(x: 0, y: 90)),
  'EPSG:6683': ProjectAndUnProjectResult(
      Point(x: -2992748.9178998745, y: 9071307.830204587), Point(x: 0, y: 90)),
  'EPSG:6684': ProjectAndUnProjectResult(
      Point(x: -3622384.886812397, y: 8829268.069555495), Point(x: 0, y: 90)),
  'EPSG:6685': ProjectAndUnProjectResult(
      Point(x: -2211182.2634812854, y: 9237908.69123874), Point(x: 0, y: 90)),
  'EPSG:6687': ProjectAndUnProjectResult(
      Point(x: 8475126.70697138, y: 6334051.65944307),
      Point(x: -131825587.42186226, y: 47833306.95865751)),
  'EPSG:6688': ProjectAndUnProjectResult(
      Point(x: -4558786.502469642, y: 11525007.658234945),
      Point(x: 17.888058560281475, y: 46.89226406700889)),
  'EPSG:6689': ProjectAndUnProjectResult(
      Point(x: -4314192.978437341, y: 12073000.736830102),
      Point(x: 17.88805856028155, y: 46.89226406700883)),
  'EPSG:6690': ProjectAndUnProjectResult(
      Point(x: -4009686.094082634, y: 12571384.874783527),
      Point(x: 17.88805856028154, y: 46.892264067008796)),
  'EPSG:6691': ProjectAndUnProjectResult(
      Point(x: -3658127.571879782, y: 13015261.604972484),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:6692': ProjectAndUnProjectResult(
      Point(x: -3271333.3919436852, y: 13403348.660882948),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:6703': ProjectAndUnProjectResult(
      Point(x: 5592748.166681155, y: 18797765.697358683),
      Point(x: -187879.93357770934, y: 41002.61339845493)),
  'EPSG:6707': ProjectAndUnProjectResult(
      Point(x: 1176891.2861569354, y: 5231671.8338276325),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:6708': ProjectAndUnProjectResult(
      Point(x: 720001.2298382937, y: 5197241.609971515),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6709': ProjectAndUnProjectResult(
      Point(x: 262945.28796354064, y: 5197894.102609971),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:6720': ProjectAndUnProjectResult(
      Point(x: -5062786.461219813, y: 11150676.91109798),
      Point(x: 407030514275.89813, y: 88857755316.43858)),
  'EPSG:6721': ProjectAndUnProjectResult(
      Point(x: -5062792.289666137, y: 11150688.140546752),
      Point(x: 407030514824.1814, y: 88857755434.83792)),
  'EPSG:6722': ProjectAndUnProjectResult(
      Point(x: -5065145.27941917, y: 10313925.465505805),
      Point(x: 390580.8116510452, y: 85422.32821383733)),
  'EPSG:6723': ProjectAndUnProjectResult(
      Point(x: -5065113.923605251, y: 10413870.82307435),
      Point(x: 390580.8117010934, y: 85422.32822390879)),
  'EPSG:6732': ProjectAndUnProjectResult(
      Point(x: -2875003.072767595, y: 16270532.6380026),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:6733': ProjectAndUnProjectResult(
      Point(x: -3286275.5342351324, y: 16606069.146790225),
      Point(x: 17.888058560281532, y: 46.892264067008774)),
  'EPSG:6734': ProjectAndUnProjectResult(
      Point(x: -3671946.7758989027, y: 16996227.853370413),
      Point(x: 17.8880585602815, y: 46.892264067008774)),
  'EPSG:6735': ProjectAndUnProjectResult(
      Point(x: -4021971.5860112663, y: 17442180.758887645),
      Point(x: 17.88805856028146, y: 46.89226406700879)),
  'EPSG:6736': ProjectAndUnProjectResult(
      Point(x: -4566585.223791351, y: 18492222.441867895),
      Point(x: 17.888058560281575, y: 46.892264067008874)),
  'EPSG:6737': ProjectAndUnProjectResult(
      Point(x: -4735902.874842531, y: 19081793.077915166),
      Point(x: 17.888058560281717, y: 46.8922640670088)),
  'EPSG:6738': ProjectAndUnProjectResult(
      Point(x: -1540720.0453096956, y: 24440239.592344202),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:6784': ProjectAndUnProjectResult(
      Point(x: -8147695.9153572135, y: 4427066.586894405),
      Point(x: 424825018.9543009, y: 148741912.75836068)),
  'EPSG:6785': ProjectAndUnProjectResult(
      Point(x: -26731285.811539937, y: 14524496.676162746),
      Point(x: 424825018.9543003, y: 148741912.75836045)),
  'EPSG:6786': ProjectAndUnProjectResult(
      Point(x: -8147695.9153572135, y: 4427066.586894405),
      Point(x: 424825018.9543009, y: 148741912.75836068)),
  'EPSG:6787': ProjectAndUnProjectResult(
      Point(x: -26731285.811539937, y: 14524496.676162746),
      Point(x: 424825018.9543003, y: 148741912.75836045)),
  'EPSG:6788': ProjectAndUnProjectResult(
      Point(x: -11235933.756508114, y: 3058544.0947498605),
      Point(x: 506388.781575293, y: 252544.63146005027)),
  'EPSG:6789': ProjectAndUnProjectResult(
      Point(x: -36863299.72607754, y: 10034593.486712141),
      Point(x: 506388.7815752957, y: 252544.63146005166)),
  'EPSG:6790': ProjectAndUnProjectResult(
      Point(x: -11235933.756508114, y: 3058544.0947498605),
      Point(x: 506388.781575293, y: 252544.63146005027)),
  'EPSG:6791': ProjectAndUnProjectResult(
      Point(x: -36863299.72607754, y: 10034593.486712141),
      Point(x: 506388.7815752957, y: 252544.63146005166)),
  'EPSG:6792': ProjectAndUnProjectResult(
      Point(x: 6239113.0574741205, y: 7439205.165307455),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:4936': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6793': ProjectAndUnProjectResult(
      Point(x: 20469531.028457347, y: 24406841.093576685),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6794': ProjectAndUnProjectResult(
      Point(x: 6239113.0574741205, y: 7439205.165307455),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6795': ProjectAndUnProjectResult(
      Point(x: 20469531.028457347, y: 24406841.093576685),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6796': ProjectAndUnProjectResult(
      Point(x: 6430962.562449161, y: 7310034.865493259),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:6797': ProjectAndUnProjectResult(
      Point(x: 21098958.53821746, y: 23983054.020646386),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:6798': ProjectAndUnProjectResult(
      Point(x: 6430962.562449161, y: 7310034.865493259),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:6799': ProjectAndUnProjectResult(
      Point(x: 21098958.53821746, y: 23983054.020646386),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:6800': ProjectAndUnProjectResult(
      Point(x: -12687334.617845144, y: 2142123.4901495352),
      Point(x: 131147.12864422146, y: 76287.34812805503)),
  'EPSG:6801': ProjectAndUnProjectResult(
      Point(x: -41625113.57560795, y: 7027964.206527346),
      Point(x: 131147.12864422126, y: 76287.3481280549)),
  'EPSG:6802': ProjectAndUnProjectResult(
      Point(x: -12687334.617845144, y: 2142123.4901495352),
      Point(x: 131147.12864422146, y: 76287.34812805503)),
  'EPSG:6803': ProjectAndUnProjectResult(
      Point(x: -41625113.57560795, y: 7027964.206527346),
      Point(x: 131147.12864422126, y: 76287.3481280549)),
  'EPSG:6804': ProjectAndUnProjectResult(
      Point(x: 6180956.877241362, y: 7225976.401085521),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6805': ProjectAndUnProjectResult(
      Point(x: 20278729.912257224, y: 23707271.657154333),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6806': ProjectAndUnProjectResult(
      Point(x: 6180956.877241362, y: 7225976.401085521),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6807': ProjectAndUnProjectResult(
      Point(x: 20278729.912257224, y: 23707271.657154333),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6808': ProjectAndUnProjectResult(
      Point(x: 14427099.751763076, y: 11533305.931524668),
      Point(x: 17.88805856028155, y: 46.892264067008696)),
  'EPSG:6809': ProjectAndUnProjectResult(
      Point(x: 47333004.43492636, y: 37838930.22157699),
      Point(x: 17.88805856028155, y: 46.892264067008696)),
  'EPSG:6819': ProjectAndUnProjectResult(
      Point(x: -34765375.73372051, y: 10217353.259960476),
      Point(x: 1116509.7241064152, y: 519843.67865306913)),
  'EPSG:6810': ProjectAndUnProjectResult(
      Point(x: 14427099.751763076, y: 11533305.931524668),
      Point(x: 17.88805856028155, y: 46.892264067008696)),
  'EPSG:6811': ProjectAndUnProjectResult(
      Point(x: 47333004.43492636, y: 37838930.22157699),
      Point(x: 17.88805856028155, y: 46.892264067008696)),
  'EPSG:6812': ProjectAndUnProjectResult(
      Point(x: -12676736.474988107, y: 2104993.2173343156),
      Point(x: 131147.12864422146, y: 76287.34812805503)),
  'EPSG:6813': ProjectAndUnProjectResult(
      Point(x: -41590342.76565966, y: 6906145.726162452),
      Point(x: 131147.12864422146, y: 76287.34812805503)),
  'EPSG:6814': ProjectAndUnProjectResult(
      Point(x: -12676736.474988107, y: 2104993.2173343156),
      Point(x: 131147.12864422146, y: 76287.34812805503)),
  'EPSG:6815': ProjectAndUnProjectResult(
      Point(x: -41590342.76565966, y: 6906145.726162452),
      Point(x: 131147.12864422146, y: 76287.34812805503)),
  'EPSG:6816': ProjectAndUnProjectResult(
      Point(x: -10596486.523637692, y: 3114249.273635953),
      Point(x: 1116509.7241064152, y: 519843.67865306913)),
  'EPSG:6817': ProjectAndUnProjectResult(
      Point(x: -34765375.73372051, y: 10217353.259960476),
      Point(x: 1116509.7241064152, y: 519843.67865306913)),
  'EPSG:6818': ProjectAndUnProjectResult(
      Point(x: -10596486.523637692, y: 3114249.273635953),
      Point(x: 1116509.7241064152, y: 519843.67865306913)),
  'EPSG:6820': ProjectAndUnProjectResult(
      Point(x: -12523661.992439302, y: 2095380.2220970227),
      Point(x: 148821.25440342294, y: 85106.37172100703)),
  'EPSG:6821': ProjectAndUnProjectResult(
      Point(x: -41088129.896405056, y: 6874607.027877371),
      Point(x: 148821.25440342294, y: 85106.37172100703)),
  'EPSG:6822': ProjectAndUnProjectResult(
      Point(x: -12523661.992439302, y: 2095380.2220970227),
      Point(x: 148821.25440342294, y: 85106.37172100703)),
  'EPSG:6823': ProjectAndUnProjectResult(
      Point(x: -41088129.896405056, y: 6874607.027877371),
      Point(x: 148821.25440342294, y: 85106.37172100703)),
  'EPSG:6824': ProjectAndUnProjectResult(
      Point(x: -12676991.00386344, y: 2225376.02393809),
      Point(x: 131147.12864422158, y: 76287.34812805509)),
  'EPSG:6825': ProjectAndUnProjectResult(
      Point(x: -41591177.834148295, y: 7301102.440741765),
      Point(x: 131147.1286442217, y: 76287.34812805516)),
  'EPSG:6826': ProjectAndUnProjectResult(
      Point(x: -12676991.00386344, y: 2225376.02393809),
      Point(x: 131147.12864422158, y: 76287.34812805509)),
  'EPSG:6827': ProjectAndUnProjectResult(
      Point(x: -41591177.834148295, y: 7301102.440741765),
      Point(x: 131147.1286442217, y: 76287.34812805516)),
  'EPSG:6828': ProjectAndUnProjectResult(
      Point(x: -11814330.286069289, y: 2401419.0651764544),
      Point(x: 294986.9593849864, y: 155421.92309333876)),
  'EPSG:4938': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6829': ProjectAndUnProjectResult(
      Point(x: -38760926.13534806, y: 7878671.473676031),
      Point(x: 294986.9593849864, y: 155421.92309333876)),
  'EPSG:6830': ProjectAndUnProjectResult(
      Point(x: -11814330.286069289, y: 2401419.0651764544),
      Point(x: 294986.9593849864, y: 155421.92309333876)),
  'EPSG:6831': ProjectAndUnProjectResult(
      Point(x: -38760926.13534806, y: 7878671.473676031),
      Point(x: 294986.9593849864, y: 155421.92309333876)),
  'EPSG:6832': ProjectAndUnProjectResult(
      Point(x: -8270468.869705044, y: 4310387.415937599),
      Point(x: 250531415.2064754, y: 89068140.86510274)),
  'EPSG:6833': ProjectAndUnProjectResult(
      Point(x: -27134084.218192924, y: 14141690.9971706),
      Point(x: 250531415.2064754, y: 89068140.86510274)),
  'EPSG:6834': ProjectAndUnProjectResult(
      Point(x: -8270468.869705044, y: 4310387.415937599),
      Point(x: 250531415.2064754, y: 89068140.86510274)),
  'EPSG:6835': ProjectAndUnProjectResult(
      Point(x: -27134084.218192924, y: 14141690.9971706),
      Point(x: 250531415.2064754, y: 89068140.86510274)),
  'EPSG:6836': ProjectAndUnProjectResult(
      Point(x: -7504892.876309951, y: 4857925.275995098),
      Point(x: 16894389367.285202, y: 5473429537.796041)),
  'EPSG:6837': ProjectAndUnProjectResult(
      Point(x: -24622351.956398528, y: 15938075.052477354),
      Point(x: 16894389367.285202, y: 5473429537.796041)),
  'EPSG:7847': ProjectAndUnProjectResult(
      Point(x: -4735902.874842531, y: 19081793.077915166),
      Point(x: 17.888058560281717, y: 46.8922640670088)),
  'EPSG:6838': ProjectAndUnProjectResult(
      Point(x: -7504892.876309951, y: 4857925.275995098),
      Point(x: 16894389367.285202, y: 5473429537.796041)),
  'EPSG:6839': ProjectAndUnProjectResult(
      Point(x: -24622351.956398528, y: 15938075.052477354),
      Point(x: 16894389367.285202, y: 5473429537.796041)),
  'EPSG:6840': ProjectAndUnProjectResult(
      Point(x: 2751127.6973184827, y: 4303936.442977292),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:6841': ProjectAndUnProjectResult(
      Point(x: 9026009.505642002, y: 14120526.387681141),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:6842': ProjectAndUnProjectResult(
      Point(x: 2751127.6973184827, y: 4303936.442977292),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:6843': ProjectAndUnProjectResult(
      Point(x: 9026009.505642002, y: 14120526.387681141),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:6844': ProjectAndUnProjectResult(
      Point(x: -9135201.937584285, y: 3830973.6946668853),
      Point(x: 15892243.09761257, y: 6278261.590776778)),
  'EPSG:6845': ProjectAndUnProjectResult(
      Point(x: -29971134.965828493, y: 12568811.334208941),
      Point(x: 15892243.09761257, y: 6278261.590776778)),
  'EPSG:6846': ProjectAndUnProjectResult(
      Point(x: -9135201.937584285, y: 3830973.6946668853),
      Point(x: 15892243.09761257, y: 6278261.590776778)),
  'EPSG:6847': ProjectAndUnProjectResult(
      Point(x: -29971134.965828493, y: 12568811.334208941),
      Point(x: 15892243.09761257, y: 6278261.590776778)),
  'EPSG:6848': ProjectAndUnProjectResult(
      Point(x: -8529480.410920456, y: 4176775.823128944),
      Point(x: 98652277.72918534, y: 36154061.091848835)),
  'EPSG:6849': ProjectAndUnProjectResult(
      Point(x: -27983859.615831155, y: 13703332.753047716),
      Point(x: 98652277.72918534, y: 36154061.091848835)),
  'EPSG:6850': ProjectAndUnProjectResult(
      Point(x: -8529480.410920456, y: 4176775.823128944),
      Point(x: 98652277.72918534, y: 36154061.091848835)),
  'EPSG:6851': ProjectAndUnProjectResult(
      Point(x: -27983859.615831155, y: 13703332.753047716),
      Point(x: 98652277.72918534, y: 36154061.091848835)),
  'EPSG:6852': ProjectAndUnProjectResult(
      Point(x: 6124839.853327609, y: 7424492.934825233),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:6853': ProjectAndUnProjectResult(
      Point(x: 20094618.941362232, y: 24358572.620867036),
      Point(x: 17.88805856028154, y: 46.89226406700876)),
  'EPSG:6854': ProjectAndUnProjectResult(
      Point(x: 6124839.853327609, y: 7424492.934825233),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:6855': ProjectAndUnProjectResult(
      Point(x: 20094618.941362232, y: 24358572.620867036),
      Point(x: 17.88805856028154, y: 46.89226406700876)),
  'EPSG:6856': ProjectAndUnProjectResult(
      Point(x: -12447494.07457886, y: 2076261.6085382975),
      Point(x: 158722.84328641556, y: 90007.24762701495)),
  'EPSG:6857': ProjectAndUnProjectResult(
      Point(x: -40838235.15276843, y: 6811881.917776566),
      Point(x: 158722.84328641556, y: 90007.24762701495)),
  'EPSG:6858': ProjectAndUnProjectResult(
      Point(x: -12447494.07457886, y: 2076261.6085382975),
      Point(x: 158722.84328641556, y: 90007.24762701495)),
  'EPSG:6859': ProjectAndUnProjectResult(
      Point(x: -40838235.15276843, y: 6811881.917776566),
      Point(x: 158722.84328641556, y: 90007.24762701495)),
  'EPSG:6860': ProjectAndUnProjectResult(
      Point(x: -11973543.359605001, y: 2416720.646855334),
      Point(x: 255319.9002424107, y: 136694.2384865875)),
  'EPSG:6861': ProjectAndUnProjectResult(
      Point(x: -39283278.73886155, y: 7928873.5133049),
      Point(x: 255319.9002424107, y: 136694.2384865875)),
  'EPSG:6862': ProjectAndUnProjectResult(
      Point(x: -11973543.359605001, y: 2416720.646855334),
      Point(x: 255319.9002424107, y: 136694.2384865875)),
  'EPSG:6863': ProjectAndUnProjectResult(
      Point(x: -39283278.73886155, y: 7928873.5133049),
      Point(x: 255319.9002424107, y: 136694.2384865875)),
  'EPSG:6867': ProjectAndUnProjectResult(
      Point(x: 6621080.326600361, y: 7550611.109639786),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:4940': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6868': ProjectAndUnProjectResult(
      Point(x: 21722704.48359173, y: 24772346.160235517),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:6870': ProjectAndUnProjectResult(
      Point(x: 339053.9538040216, y: 5197436.0837356355),
      Point(x: 17.888058560277017, y: 46.892264067000774)),
  'EPSG:6875': ProjectAndUnProjectResult(
      Point(x: 7447996.264442064, y: 5204311.696323936),
      Point(x: 17.888058558416997, y: 46.892264063331794)),
  'EPSG:6876': ProjectAndUnProjectResult(
      Point(x: 3448669.26834458, y: 5212129.891160676),
      Point(x: 17.888058558416994, y: 46.89226406333179)),
  'EPSG:6879': ProjectAndUnProjectResult(
      Point(x: 6611250.719513921, y: 5046926.8438626565),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:6880': ProjectAndUnProjectResult(
      Point(x: 22883813.725204114, y: 19815816.15389137),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:6884': ProjectAndUnProjectResult(
      Point(x: 8597033.820587108, y: 7390016.602283895),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:6885': ProjectAndUnProjectResult(
      Point(x: 28205491.53782647, y: 24245461.29358233),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:6886': ProjectAndUnProjectResult(
      Point(x: 7874076.89548586, y: 7497850.224338042),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:6887': ProjectAndUnProjectResult(
      Point(x: 25833585.615591403, y: 24599246.142841343),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:6915': ProjectAndUnProjectResult(
      Point(x: -2445815.3623071006, y: 5987007.606477543),
      Point(x: 17.888058451660676, y: 46.89226384856166)),
  'EPSG:6922': ProjectAndUnProjectResult(
      Point(x: 7155977.5092980275, y: 6148778.096964074),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:6923': ProjectAndUnProjectResult(
      Point(x: 23477569.54505528, y: 20173116.139789633),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:6924': ProjectAndUnProjectResult(
      Point(x: 7155977.5092980275, y: 6148778.096964074),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:6925': ProjectAndUnProjectResult(
      Point(x: 23477569.54505528, y: 20173116.139789633),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:6931': ProjectAndUnProjectResult(
      Point(x: 1441907.3090332332, y: -4467414.170635901),
      Point(x: 17.888058560281515, y: 46.89226406911223)),
  'EPSG:6932': ProjectAndUnProjectResult(
      Point(x: 3638523.4746012595, y: 11273118.062993607),
      Point(x: 17.888058560281515, y: 46.89226406911217)),
  'EPSG:6933': ProjectAndUnProjectResult(
      Point(x: 1725952.2313917708, y: 5349116.620095357),
      Point(x: 17.888058560281515, y: 46.8922640670088)),
  'EPSG:7005': ProjectAndUnProjectResult(
      Point(x: -1105167.4673126242, y: 5413517.81368155),
      Point(x: 17.88805856139987, y: 46.89226406573693)),
  'EPSG:6956': ProjectAndUnProjectResult(
      Point(x: -5152275.287064603, y: 9954768.882961797),
      Point(x: double.nan, y: double.nan)),
  'EPSG:6957': ProjectAndUnProjectResult(
      Point(x: -5123587.388099429, y: 10281039.67478536),
      Point(x: double.nan, y: double.nan)),
  'EPSG:6958': ProjectAndUnProjectResult(
      Point(x: -5050677.6545024095, y: 10610235.462374557),
      Point(x: -168.37939778999916, y: 89.99824032468668)),
  'EPSG:6959': ProjectAndUnProjectResult(
      Point(x: -5058590.894691086, y: 10582782.95357802),
      Point(x: -168.37939778999916, y: 89.99824032468668)),
  'EPSG:6962': ProjectAndUnProjectResult(
      Point(x: -161710.69187815275, y: 657428.9710477525),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:6984': ProjectAndUnProjectResult(
      Point(x: -1098554.857504982, y: 2457387.7290571346),
      Point(x: 17.88812602014107, y: 46.892265987645935)),
  'EPSG:6991': ProjectAndUnProjectResult(
      Point(x: -1098554.857504982, y: 2457387.7290571346),
      Point(x: 17.88812602014107, y: 46.892265987645935)),
  'EPSG:6996': ProjectAndUnProjectResult(
      Point(x: -11879282.52202792, y: 3169856.913904962),
      Point(x: 266510.07956063334, y: 141998.87855360404)),
  'EPSG:6997': ProjectAndUnProjectResult(
      Point(x: -38973946.07435327, y: 10399772.22503653),
      Point(x: 266510.0795606337, y: 141998.8785536042)),
  'EPSG:7006': ProjectAndUnProjectResult(
      Point(x: -1557609.6968929803, y: 5561526.898136826),
      Point(x: 17.888058561399856, y: 46.89226406573694)),
  'EPSG:7007': ProjectAndUnProjectResult(
      Point(x: -2005608.4665236669, y: 5751470.169158288),
      Point(x: 17.88805856139985, y: 46.892264065736946)),
  'EPSG:7057': ProjectAndUnProjectResult(
      Point(x: 31971224.779348012, y: 27361966.883673508),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:7058': ProjectAndUnProjectResult(
      Point(x: 32834945.667981394, y: 26958411.64779916),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:7059': ProjectAndUnProjectResult(
      Point(x: 23659396.327111464, y: 32775259.236593112), Point(x: 0, y: 90)),
  'EPSG:7060': ProjectAndUnProjectResult(
      Point(x: 35141421.51843127, y: 26376303.97628609),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:7061': ProjectAndUnProjectResult(
      Point(x: 35944832.919376746, y: 26028750.25628811),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:7062': ProjectAndUnProjectResult(
      Point(x: 23336606.10109816, y: 31781388.117976915), Point(x: 0, y: 90)),
  'EPSG:7063': ProjectAndUnProjectResult(
      Point(x: 25226146.542599436, y: 31855225.490231134), Point(x: 0, y: 90)),
  'EPSG:7064': ProjectAndUnProjectResult(
      Point(x: 26925283.91182929, y: 31926234.221029263), Point(x: 0, y: 90)),
  'EPSG:7065': ProjectAndUnProjectResult(
      Point(x: 28575914.851010647, y: 31980476.745277643), Point(x: 0, y: 90)),
  'EPSG:7066': ProjectAndUnProjectResult(
      Point(x: 41130511.63331108, y: 25131871.810833354),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7067': ProjectAndUnProjectResult(
      Point(x: 32075379.757604606, y: 31934051.78469484), Point(x: 0, y: 90)),
  'EPSG:7068': ProjectAndUnProjectResult(
      Point(x: 43548314.86794333, y: 23991089.55662942),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:7069': ProjectAndUnProjectResult(
      Point(x: 33192213.201036148, y: 31016906.6763871), Point(x: 0, y: 90)),
  'EPSG:7070': ProjectAndUnProjectResult(
      Point(x: 34627310.72671446, y: 30685079.319513485), Point(x: 0, y: 90)),
  'EPSG:7074': ProjectAndUnProjectResult(
      Point(x: -1105125.3251090779, y: 15413941.604463775),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:7075': ProjectAndUnProjectResult(
      Point(x: -1557536.0364113871, y: 15561947.769793503),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:7076': ProjectAndUnProjectResult(
      Point(x: -2005502.5012535215, y: 15751885.308795743),
      Point(x: 17.888058560281532, y: 46.8922640670088)),
  'EPSG:7077': ProjectAndUnProjectResult(
      Point(x: -2446086.561687547, y: 15986927.666624561),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:7078': ProjectAndUnProjectResult(
      Point(x: -2875003.072767595, y: 16270532.6380026),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:7079': ProjectAndUnProjectResult(
      Point(x: -3286275.5342351324, y: 16606069.146790225),
      Point(x: 17.888058560281532, y: 46.892264067008774)),
  'EPSG:7080': ProjectAndUnProjectResult(
      Point(x: -3671946.7758989027, y: 16996227.853370413),
      Point(x: 17.8880585602815, y: 46.892264067008774)),
  'EPSG:7081': ProjectAndUnProjectResult(
      Point(x: -4021971.5860112663, y: 17442180.758887645),
      Point(x: 17.88805856028146, y: 46.89226406700879)),
  'EPSG:7109': ProjectAndUnProjectResult(
      Point(x: -4529224.4946787935, y: 5520223.694971471), Point(x: 0, y: 90)),
  'EPSG:7110': ProjectAndUnProjectResult(
      Point(x: -4579364.848956948, y: 5575997.430125581), Point(x: 0, y: 90)),
  'EPSG:7111': ProjectAndUnProjectResult(
      Point(x: 5945288.145399296, y: 6517855.612920973),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:7112': ProjectAndUnProjectResult(
      Point(x: 6013727.874838598, y: 6277995.577138961),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:7113': ProjectAndUnProjectResult(
      Point(x: 6043423.63493381, y: 6009197.84958284),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:7114': ProjectAndUnProjectResult(
      Point(x: 5943248.353258563, y: 5959020.594917912),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:7115': ProjectAndUnProjectResult(
      Point(x: -1980157.3253148668, y: 6739903.780372046), Point(x: 0, y: 90)),
  'EPSG:7116': ProjectAndUnProjectResult(
      Point(x: 6136218.554719384, y: 6563988.5014246),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7117': ProjectAndUnProjectResult(
      Point(x: 6294170.682458561, y: 6323409.147422968),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7118': ProjectAndUnProjectResult(
      Point(x: -2358766.854885466, y: 6897593.647641159), Point(x: 0, y: 90)),
  'EPSG:7119': ProjectAndUnProjectResult(
      Point(x: -14859660.415564805, y: 18110970.127859157), Point(x: 0, y: 90)),
  'EPSG:7120': ProjectAndUnProjectResult(
      Point(x: -15024162.890280012, y: 18293954.823246658), Point(x: 0, y: 90)),
  'EPSG:7121': ProjectAndUnProjectResult(
      Point(x: 19505538.534822624, y: 21384040.724803716),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:4942': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7122': ProjectAndUnProjectResult(
      Point(x: 19730078.329520334, y: 20597098.350241475),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:7123': ProjectAndUnProjectResult(
      Point(x: 19827505.36395344, y: 19715216.04193714),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:7124': ProjectAndUnProjectResult(
      Point(x: 19498846.30334043, y: 19550592.502060868),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:7125': ProjectAndUnProjectResult(
      Point(x: -6496579.15129812, y: 22112545.211194374), Point(x: 0, y: 90)),
  'EPSG:7126': ProjectAndUnProjectResult(
      Point(x: 20131950.63884181, y: 21535395.345879924),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7127': ProjectAndUnProjectResult(
      Point(x: 20650166.2810294, y: 20746093.003405537),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7128': ProjectAndUnProjectResult(
      Point(x: -7738720.9231034005, y: 22629855.15896937), Point(x: 0, y: 90)),
  'EPSG:7131': ProjectAndUnProjectResult(
      Point(x: -11879282.52202792, y: 3169856.913904962),
      Point(x: 266510.07956063334, y: 141998.87855360404)),
  'EPSG:7132': ProjectAndUnProjectResult(
      Point(x: -38973946.07435327, y: 10399772.22503653),
      Point(x: 266510.0795606337, y: 141998.8785536042)),
  'EPSG:7142': ProjectAndUnProjectResult(
      Point(x: -1148621.110313324, y: 1957398.2976502348),
      Point(x: 17.88812625153329, y: 46.89226592347)),
  'EPSG:7257': ProjectAndUnProjectResult(
      Point(x: 4331314.136537872, y: 6975315.389059721), Point(x: 0, y: 90)),
  'EPSG:7258': ProjectAndUnProjectResult(
      Point(x: 14210319.796291336, y: 22884847.2389401), Point(x: 0, y: 90)),
  'EPSG:7259': ProjectAndUnProjectResult(
      Point(x: 4318574.046028171, y: 6945483.081037194), Point(x: 0, y: 90)),
  'EPSG:7260': ProjectAndUnProjectResult(
      Point(x: 14168521.682677424, y: 22786972.408369526), Point(x: 0, y: 90)),
  'EPSG:7261': ProjectAndUnProjectResult(
      Point(x: 4213257.633919751, y: 7227647.487010904), Point(x: 0, y: 90)),
  'EPSG:7262': ProjectAndUnProjectResult(
      Point(x: 13822996.087285051, y: 23712706.796968274), Point(x: 0, y: 90)),
  'EPSG:7263': ProjectAndUnProjectResult(
      Point(x: 4006181.03954188, y: 7189760.266630081), Point(x: 0, y: 90)),
  'EPSG:7264': ProjectAndUnProjectResult(
      Point(x: 13143612.293896986, y: 23588405.141435526), Point(x: 0, y: 90)),
  'EPSG:4944': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7265': ProjectAndUnProjectResult(
      Point(x: 4273299.505410438, y: 7071357.478190964), Point(x: 0, y: 90)),
  'EPSG:7266': ProjectAndUnProjectResult(
      Point(x: 14019983.460667415, y: 23199945.326364856), Point(x: 0, y: 90)),
  'EPSG:7267': ProjectAndUnProjectResult(
      Point(x: 4123101.7501443964, y: 7217288.116291453), Point(x: 0, y: 90)),
  'EPSG:7268': ProjectAndUnProjectResult(
      Point(x: 13527209.658598742, y: 23678719.428199545), Point(x: 0, y: 90)),
  'EPSG:7269': ProjectAndUnProjectResult(
      Point(x: 4151281.3535266537, y: 7266740.90194746), Point(x: 0, y: 90)),
  'EPSG:7270': ProjectAndUnProjectResult(
      Point(x: 13619662.240695363, y: 23840965.77580596), Point(x: 0, y: 90)),
  'EPSG:7271': ProjectAndUnProjectResult(
      Point(x: 4101645.22528056, y: 7141124.513940572), Point(x: 0, y: 90)),
  'EPSG:7272': ProjectAndUnProjectResult(
      Point(x: 13456814.376607971, y: 23428839.342820026), Point(x: 0, y: 90)),
  'EPSG:7273': ProjectAndUnProjectResult(
      Point(x: 4137222.5344148865, y: 7103203.082842901), Point(x: 0, y: 90)),
  'EPSG:32607': ProjectAndUnProjectResult(
      Point(x: 2105125.3250947963, y: 14581988.281459032),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:7274': ProjectAndUnProjectResult(
      Point(x: 13573537.598326175, y: 23304425.447627086), Point(x: 0, y: 90)),
  'EPSG:7275': ProjectAndUnProjectResult(
      Point(x: 4246811.760105154, y: 7299949.78739525), Point(x: 0, y: 90)),
  'EPSG:7276': ProjectAndUnProjectResult(
      Point(x: 13933081.582944993, y: 23949918.594145916), Point(x: 0, y: 90)),
  'EPSG:7277': ProjectAndUnProjectResult(
      Point(x: 4028582.689358129, y: 7321720.117252209), Point(x: 0, y: 90)),
  'EPSG:7278': ProjectAndUnProjectResult(
      Point(x: 13217108.373335795, y: 24021343.418018293), Point(x: 0, y: 90)),
  'EPSG:7279': ProjectAndUnProjectResult(
      Point(x: 4108833.0645097396, y: 7164691.613104125), Point(x: 0, y: 90)),
  'EPSG:7280': ProjectAndUnProjectResult(
      Point(x: 13480396.479145706, y: 23506159.067325782), Point(x: 0, y: 90)),
  'EPSG:7281': ProjectAndUnProjectResult(
      Point(x: 4123059.037562798, y: 7383732.239831039), Point(x: 0, y: 90)),
  'EPSG:7282': ProjectAndUnProjectResult(
      Point(x: 13527069.52573728, y: 24224794.85684567), Point(x: 0, y: 90)),
  'EPSG:4946': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7283': ProjectAndUnProjectResult(
      Point(x: 4035981.4071827894, y: 7395249.464870051), Point(x: 0, y: 90)),
  'EPSG:7284': ProjectAndUnProjectResult(
      Point(x: 13241382.33339887, y: 24262580.95266116), Point(x: 0, y: 90)),
  'EPSG:7285': ProjectAndUnProjectResult(
      Point(x: 4337621.842092536, y: 7181697.385461008), Point(x: 0, y: 90)),
  'EPSG:7286': ProjectAndUnProjectResult(
      Point(x: 14231014.326931931, y: 23561952.172133327), Point(x: 0, y: 90)),
  'EPSG:7287': ProjectAndUnProjectResult(
      Point(x: 4240206.014137559, y: 7199018.8409899585), Point(x: 0, y: 90)),
  'EPSG:7288': ProjectAndUnProjectResult(
      Point(x: 13911409.231382973, y: 23618780.980814558), Point(x: 0, y: 90)),
  'EPSG:7289': ProjectAndUnProjectResult(
      Point(x: 4331322.318887944, y: 6897590.084435026), Point(x: 0, y: 90)),
  'EPSG:7290': ProjectAndUnProjectResult(
      Point(x: 14210346.641218198, y: 22629843.468683917), Point(x: 0, y: 90)),
  'EPSG:7291': ProjectAndUnProjectResult(
      Point(x: 4058098.101393937, y: 7410544.829712538), Point(x: 0, y: 90)),
  'EPSG:4948': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7292': ProjectAndUnProjectResult(
      Point(x: 13313943.520989943, y: 24312762.495481886), Point(x: 0, y: 90)),
  'EPSG:7293': ProjectAndUnProjectResult(
      Point(x: 4213285.446000075, y: 7044490.1597183645), Point(x: 0, y: 90)),
  'EPSG:7294': ProjectAndUnProjectResult(
      Point(x: 13823087.334085247, y: 23111798.13234267), Point(x: 0, y: 90)),
  'EPSG:7295': ProjectAndUnProjectResult(
      Point(x: 4318602.5951614715, y: 7128747.953189529), Point(x: 0, y: 90)),
  'EPSG:7296': ProjectAndUnProjectResult(
      Point(x: 14168615.347625595, y: 23388233.90975598), Point(x: 0, y: 90)),
  'EPSG:7297': ProjectAndUnProjectResult(
      Point(x: 4006165.975254586, y: 7245252.280258383), Point(x: 0, y: 90)),
  'EPSG:7298': ProjectAndUnProjectResult(
      Point(x: 13143562.870481089, y: 23770465.189481046), Point(x: 0, y: 90)),
  'EPSG:7299': ProjectAndUnProjectResult(
      Point(x: 4151285.2646906725, y: 7055777.580320902), Point(x: 0, y: 90)),
  'EPSG:7300': ProjectAndUnProjectResult(
      Point(x: 13619675.072572649, y: 23148830.278102826), Point(x: 0, y: 90)),
  'EPSG:4950': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7301': ProjectAndUnProjectResult(
      Point(x: 3952890.3566686762, y: 7473443.057522163), Point(x: 0, y: 90)),
  'EPSG:7302': ProjectAndUnProjectResult(
      Point(x: 12968774.445170483, y: 24519121.097887296), Point(x: 0, y: 90)),
  'EPSG:7303': ProjectAndUnProjectResult(
      Point(x: 4233507.7029059185, y: 7064626.07468358), Point(x: 0, y: 90)),
  'EPSG:7304': ProjectAndUnProjectResult(
      Point(x: 13889433.188617168, y: 23177860.713357713), Point(x: 0, y: 90)),
  'EPSG:7305': ProjectAndUnProjectResult(
      Point(x: 4192849.0877581015, y: 7140884.329141924), Point(x: 0, y: 90)),
  'EPSG:7306': ProjectAndUnProjectResult(
      Point(x: 13756039.048753038, y: 23428051.336526465), Point(x: 0, y: 90)),
  'EPSG:7307': ProjectAndUnProjectResult(
      Point(x: 4220061.413900266, y: 7151166.4786150865), Point(x: 0, y: 90)),
  'EPSG:7308': ProjectAndUnProjectResult(
      Point(x: 13845318.155437792, y: 23461785.35525633), Point(x: 0, y: 90)),
  'EPSG:7309': ProjectAndUnProjectResult(
      Point(x: 4172157.8650031947, y: 7370339.8157332875), Point(x: 0, y: 90)),
  'EPSG:32608': ProjectAndUnProjectResult(
      Point(x: 2557536.0363929626, y: 14433982.116130857),
      Point(x: 17.888058560281486, y: 46.89226406700882)),
  'EPSG:7310': ProjectAndUnProjectResult(
      Point(x: 13688154.595431315, y: 24180856.54545163), Point(x: 0, y: 90)),
  'EPSG:7311': ProjectAndUnProjectResult(
      Point(x: 4266751.205587671, y: 7109160.613688538), Point(x: 0, y: 90)),
  'EPSG:7312': ProjectAndUnProjectResult(
      Point(x: 13998499.580332218, y: 23323971.113409813), Point(x: 0, y: 90)),
  'EPSG:7313': ProjectAndUnProjectResult(
      Point(x: 4172173.593209992, y: 7103916.781828795), Point(x: 0, y: 90)),
  'EPSG:7314': ProjectAndUnProjectResult(
      Point(x: 13688206.19705645, y: 23306766.975049973), Point(x: 0, y: 90)),
  'EPSG:7315': ProjectAndUnProjectResult(
      Point(x: 4260122.275477586, y: 7013606.951546695), Point(x: 0, y: 90)),
  'EPSG:7316': ProjectAndUnProjectResult(
      Point(x: 13976751.165462716, y: 23010475.473532785), Point(x: 0, y: 90)),
  'EPSG:7317': ProjectAndUnProjectResult(
      Point(x: 4199639.770194668, y: 7269668.482471146), Point(x: 0, y: 90)),
  'EPSG:7318': ProjectAndUnProjectResult(
      Point(x: 13778318.14604701, y: 23850570.679574084), Point(x: 0, y: 90)),
  'EPSG:4952': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7319': ProjectAndUnProjectResult(
      Point(x: 4036015.570400516, y: 7145499.315997849), Point(x: 0, y: 90)),
  'EPSG:7320': ProjectAndUnProjectResult(
      Point(x: 13241494.41722236, y: 23443192.339236278), Point(x: 0, y: 90)),
  'EPSG:7321': ProjectAndUnProjectResult(
      Point(x: 4324978.475543668, y: 7007637.420068591), Point(x: 0, y: 90)),
  'EPSG:7322': ProjectAndUnProjectResult(
      Point(x: 14189533.54851285, y: 22990890.435675036), Point(x: 0, y: 90)),
  'EPSG:7323': ProjectAndUnProjectResult(
      Point(x: 4279803.304733651, y: 7233358.377435937), Point(x: 0, y: 90)),
  'EPSG:7324': ProjectAndUnProjectResult(
      Point(x: 14041321.34228032, y: 23731443.276637737), Point(x: 0, y: 90)),
  'EPSG:7325': ProjectAndUnProjectResult(
      Point(x: 4220017.63480076, y: 7245457.388853361), Point(x: 0, y: 90)),
  'EPSG:7326': ProjectAndUnProjectResult(
      Point(x: 13845174.523508828, y: 23771138.116596404), Point(x: 0, y: 90)),
  'EPSG:7327': ProjectAndUnProjectResult(
      Point(x: 4172173.593209992, y: 7220503.237108599), Point(x: 0, y: 90)),
  'EPSG:32609': ProjectAndUnProjectResult(
      Point(x: 3005502.501230998, y: 14244044.577130752),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:7328': ProjectAndUnProjectResult(
      Point(x: 13688206.19705645, y: 23689267.70374713), Point(x: 0, y: 90)),
  'EPSG:7329': ProjectAndUnProjectResult(
      Point(x: 3983472.9667909928, y: 7429516.138336472), Point(x: 0, y: 90)),
  'EPSG:7330': ProjectAndUnProjectResult(
      Point(x: 13069110.891880115, y: 24375004.197192244), Point(x: 0, y: 90)),
  'EPSG:7331': ProjectAndUnProjectResult(
      Point(x: 4266727.046119294, y: 6942545.61351483), Point(x: 0, y: 90)),
  'EPSG:7332': ProjectAndUnProjectResult(
      Point(x: 13998420.317143051, y: 22777335.067006573), Point(x: 0, y: 90)),
  'EPSG:7333': ProjectAndUnProjectResult(
      Point(x: 3991092.2143407646, y: 7170156.678924834), Point(x: 0, y: 90)),
  'EPSG:7334': ProjectAndUnProjectResult(
      Point(x: 13094108.373216325, y: 23524089.037439227), Point(x: 0, y: 90)),
  'EPSG:7335': ProjectAndUnProjectResult(
      Point(x: 4087243.382869298, y: 7094049.956822051), Point(x: 0, y: 90)),
  'EPSG:7336': ProjectAndUnProjectResult(
      Point(x: 13409564.33196369, y: 23274395.56667368), Point(x: 0, y: 90)),
  'EPSG:4954': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7337': ProjectAndUnProjectResult(
      Point(x: 4123070.686448688, y: 7289396.167388706), Point(x: 0, y: 90)),
  'EPSG:7338': ProjectAndUnProjectResult(
      Point(x: 13527107.743790405, y: 23915293.92584111), Point(x: 0, y: 90)),
  'EPSG:7339': ProjectAndUnProjectResult(
      Point(x: 4058140.0996330883, y: 7271856.4540123865), Point(x: 0, y: 90)),
  'EPSG:7340': ProjectAndUnProjectResult(
      Point(x: 13314081.310212892, y: 23857749.049538974), Point(x: 0, y: 90)),
  'EPSG:7341': ProjectAndUnProjectResult(
      Point(x: 4065439.160186458, y: 7300950.447947321), Point(x: 0, y: 90)),
  'EPSG:7342': ProjectAndUnProjectResult(
      Point(x: 13338028.311378404, y: 23953201.594640505), Point(x: 0, y: 90)),
  'EPSG:7343': ProjectAndUnProjectResult(
      Point(x: 3998629.0287359925, y: 7288187.3363547595), Point(x: 0, y: 90)),
  'EPSG:7344': ProjectAndUnProjectResult(
      Point(x: 13118835.405111335, y: 23911327.952690575), Point(x: 0, y: 90)),
  'EPSG:7345': ProjectAndUnProjectResult(
      Point(x: 4094432.01033165, y: 7433959.560401595), Point(x: 0, y: 90)),
  'EPSG:4956': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7346': ProjectAndUnProjectResult(
      Point(x: 13433149.020563088, y: 24389582.32441757), Point(x: 0, y: 90)),
  'EPSG:7347': ProjectAndUnProjectResult(
      Point(x: 4006128.314536352, y: 7478312.248754668), Point(x: 0, y: 90)),
  'EPSG:7348': ProjectAndUnProjectResult(
      Point(x: 13143439.31194135, y: 24535096.102789275), Point(x: 0, y: 90)),
  'EPSG:7349': ProjectAndUnProjectResult(
      Point(x: 3906232.2832556735, y: 7541804.664876676), Point(x: 0, y: 90)),
  'EPSG:7350': ProjectAndUnProjectResult(
      Point(x: 12815697.082647989, y: 24743404.13801623), Point(x: 0, y: 90)),
  'EPSG:7351': ProjectAndUnProjectResult(
      Point(x: 4318627.065847156, y: 7078827.256747827), Point(x: 0, y: 90)),
  'EPSG:7352': ProjectAndUnProjectResult(
      Point(x: 14168695.631866878, y: 23224452.42484683), Point(x: 0, y: 90)),
  'EPSG:7353': ProjectAndUnProjectResult(
      Point(x: 4286363.709370842, y: 7190101.434668174), Point(x: 0, y: 90)),
  'EPSG:7354': ProjectAndUnProjectResult(
      Point(x: 14062844.936494172, y: 23589524.456907168), Point(x: 0, y: 90)),
  'EPSG:7848': ProjectAndUnProjectResult(
      Point(x: -4822492.611936731, y: 19697373.47155191),
      Point(x: 17.888058560281653, y: 46.892264067008654)),
  'EPSG:7355': ProjectAndUnProjectResult(
      Point(x: 4206484.846873669, y: 7198746.935639589), Point(x: 0, y: 90)),
  'EPSG:7356': ProjectAndUnProjectResult(
      Point(x: 13800775.701784696, y: 23617888.904677555), Point(x: 0, y: 90)),
  'EPSG:7357': ProjectAndUnProjectResult(
      Point(x: 4043361.727567253, y: 7468773.283861903), Point(x: 0, y: 90)),
  'EPSG:7358': ProjectAndUnProjectResult(
      Point(x: 13265595.934526898, y: 24503800.348803595), Point(x: 0, y: 90)),
  'EPSG:7359': ProjectAndUnProjectResult(
      Point(x: 4324990.7300134245, y: 6874390.492505989), Point(x: 0, y: 90)),
  'EPSG:7360': ProjectAndUnProjectResult(
      Point(x: 14189573.753385711, y: 22553729.474163402), Point(x: 0, y: 90)),
  'EPSG:7361': ProjectAndUnProjectResult(
      Point(x: 3975876.1794218733, y: 7378089.272834579), Point(x: 0, y: 90)),
  'EPSG:7362': ProjectAndUnProjectResult(
      Point(x: 13044187.098653262, y: 24206281.222624782), Point(x: 0, y: 90)),
  'EPSG:7363': ProjectAndUnProjectResult(
      Point(x: 4065439.160186458, y: 7184367.597219087), Point(x: 0, y: 90)),
  'EPSG:7849': ProjectAndUnProjectResult(
      Point(x: -4820828.738956195, y: 20321798.23890354),
      Point(x: 17.888058560281387, y: 46.89226406700866)),
  'EPSG:7364': ProjectAndUnProjectResult(
      Point(x: 13338028.311378404, y: 23570712.69187629), Point(x: 0, y: 90)),
  'EPSG:7365': ProjectAndUnProjectResult(
      Point(x: 3968238.1250428315, y: 7504232.939900378), Point(x: 0, y: 90)),
  'EPSG:7366': ProjectAndUnProjectResult(
      Point(x: 13019127.915244691, y: 24620137.570323158), Point(x: 0, y: 90)),
  'EPSG:7367': ProjectAndUnProjectResult(
      Point(x: 3983491.6838750695, y: 7335190.891852938), Point(x: 0, y: 90)),
  'EPSG:7368': ProjectAndUnProjectResult(
      Point(x: 13069172.299513457, y: 24065538.78435418), Point(x: 0, y: 90)),
  'EPSG:7369': ProjectAndUnProjectResult(
      Point(x: 4292843.365713758, y: 7002385.784690029), Point(x: 0, y: 90)),
  'EPSG:7370': ProjectAndUnProjectResult(
      Point(x: 14084103.609012557, y: 22973660.69527054), Point(x: 0, y: 90)),
  'EPSG:7374': ProjectAndUnProjectResult(
      Point(x: -2005502.5012535215, y: 5751885.308795742),
      Point(x: 17.888058560281532, y: 46.892264067008796)),
  'EPSG:7375': ProjectAndUnProjectResult(
      Point(x: -2446086.561687547, y: 5986927.66662456),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:7376': ProjectAndUnProjectResult(
      Point(x: -2875003.072767595, y: 6270532.638002601),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:7528': ProjectAndUnProjectResult(
      Point(x: 3468290.683902232, y: 7034754.514808692), Point(x: 0, y: 90)),
  'EPSG:7529': ProjectAndUnProjectResult(
      Point(x: 3379674.584728664, y: 6816915.478636543), Point(x: 0, y: 90)),
  'EPSG:7530': ProjectAndUnProjectResult(
      Point(x: 3060937.2787154065, y: 6957068.465882632), Point(x: 0, y: 90)),
  'EPSG:7531': ProjectAndUnProjectResult(
      Point(x: 6127532.902492125, y: 5063502.719266117),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:7532': ProjectAndUnProjectResult(
      Point(x: 3689988.0851689526, y: 6931430.5799844805), Point(x: 0, y: 90)),
  'EPSG:7533': ProjectAndUnProjectResult(
      Point(x: 3153672.940117676, y: 7137461.697173122), Point(x: 0, y: 90)),
  'EPSG:7534': ProjectAndUnProjectResult(
      Point(x: 6038695.637881377, y: 5116149.00293443),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:7535': ProjectAndUnProjectResult(
      Point(x: 3822990.361101892, y: 6996993.411303278), Point(x: 0, y: 90)),
  'EPSG:7536': ProjectAndUnProjectResult(
      Point(x: 6086999.10094148, y: 5065927.892679145),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:7537': ProjectAndUnProjectResult(
      Point(x: 3390618.4191545607, y: 7056596.4442245625), Point(x: 0, y: 90)),
  'EPSG:7538': ProjectAndUnProjectResult(
      Point(x: 6276049.2952974085, y: 5077947.841716385),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:7539': ProjectAndUnProjectResult(
      Point(x: 6273425.123029883, y: 5148067.887488653),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7540': ProjectAndUnProjectResult(
      Point(x: 6385132.533988685, y: 5136893.419587115),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7541': ProjectAndUnProjectResult(
      Point(x: 3796339.751557811, y: 7156497.446786959), Point(x: 0, y: 90)),
  'EPSG:7542': ProjectAndUnProjectResult(
      Point(x: 3929113.1757629644, y: 6712626.8544382695), Point(x: 0, y: 90)),
  'EPSG:7543': ProjectAndUnProjectResult(
      Point(x: 3013378.5853116503, y: 6877533.049658766), Point(x: 0, y: 90)),
  'EPSG:7544': ProjectAndUnProjectResult(
      Point(x: 3010580.2176696234, y: 7040185.373915163), Point(x: 0, y: 90)),
  'EPSG:7545': ProjectAndUnProjectResult(
      Point(x: 6155021.214817072, y: 5119025.0660186),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7546': ProjectAndUnProjectResult(
      Point(x: 3769574.888567513, y: 6667205.568796816), Point(x: 0, y: 90)),
  'EPSG:7547': ProjectAndUnProjectResult(
      Point(x: 3832374.9261409976, y: 6864556.294344704), Point(x: 0, y: 90)),
  'EPSG:7548': ProjectAndUnProjectResult(
      Point(x: 3415636.1902642823, y: 7305642.758030209), Point(x: 0, y: 90)),
  'EPSG:7549': ProjectAndUnProjectResult(
      Point(x: 6351315.319985553, y: 5090453.3452227255),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7550': ProjectAndUnProjectResult(
      Point(x: 6228233.02143633, y: 5015056.442424751),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7551': ProjectAndUnProjectResult(
      Point(x: 3405012.5367005337, y: 7137827.349102414), Point(x: 0, y: 90)),
  'EPSG:7552': ProjectAndUnProjectResult(
      Point(x: 3495775.4923990215, y: 6822835.282791732), Point(x: 0, y: 90)),
  'EPSG:7553': ProjectAndUnProjectResult(
      Point(x: 3191918.450618008, y: 7017760.476250788), Point(x: 0, y: 90)),
  'EPSG:7554': ProjectAndUnProjectResult(
      Point(x: 3860921.4795736372, y: 7005528.164366286), Point(x: 0, y: 90)),
  'EPSG:7555': ProjectAndUnProjectResult(
      Point(x: 3808127.092819137, y: 6861235.0608257), Point(x: 0, y: 90)),
  'EPSG:7556': ProjectAndUnProjectResult(
      Point(x: 3204291.414114237, y: 7111748.531335806), Point(x: 0, y: 90)),
  'EPSG:7557': ProjectAndUnProjectResult(
      Point(x: 6172131.065819239, y: 4949587.034894236),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7558': ProjectAndUnProjectResult(
      Point(x: 3484867.686109837, y: 6852050.195405609), Point(x: 0, y: 90)),
  'EPSG:7559': ProjectAndUnProjectResult(
      Point(x: 6080538.074505244, y: 4968228.495762084),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:7560': ProjectAndUnProjectResult(
      Point(x: 3942161.367084428, y: 6715885.210692157), Point(x: 0, y: 90)),
  'EPSG:7561': ProjectAndUnProjectResult(
      Point(x: 3697276.437847649, y: 6768723.763080934), Point(x: 0, y: 90)),
  'EPSG:7562': ProjectAndUnProjectResult(
      Point(x: 6295161.306066516, y: 5150148.332907723),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:7563': ProjectAndUnProjectResult(
      Point(x: 3855689.606143715, y: 6764352.072904594), Point(x: 0, y: 90)),
  'EPSG:7564': ProjectAndUnProjectResult(
      Point(x: 6013452.177684069, y: 4908264.891016306),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:7565': ProjectAndUnProjectResult(
      Point(x: 6236844.650412206, y: 5196401.918748533),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7566': ProjectAndUnProjectResult(
      Point(x: 2947228.968603797, y: 7053493.02016694), Point(x: 0, y: 90)),
  'EPSG:7567': ProjectAndUnProjectResult(
      Point(x: 6093072.399433181, y: 4970601.337317026),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7568': ProjectAndUnProjectResult(
      Point(x: 3459761.570267035, y: 6936063.286349483), Point(x: 0, y: 90)),
  'EPSG:7569': ProjectAndUnProjectResult(
      Point(x: 6341958.1822602, y: 5184504.957866001),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7570': ProjectAndUnProjectResult(
      Point(x: 3629429.2884092713, y: 7126247.272572763), Point(x: 0, y: 90)),
  'EPSG:7571': ProjectAndUnProjectResult(
      Point(x: 3372972.8871539193, y: 7044187.319239815), Point(x: 0, y: 90)),
  'EPSG:7572': ProjectAndUnProjectResult(
      Point(x: 3524640.118549972, y: 7088603.953742174), Point(x: 0, y: 90)),
  'EPSG:7573': ProjectAndUnProjectResult(
      Point(x: 6171484.354307097, y: 5077190.847684618),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7574': ProjectAndUnProjectResult(
      Point(x: 3823405.313439519, y: 6858804.031463695), Point(x: 0, y: 90)),
  'EPSG:7575': ProjectAndUnProjectResult(
      Point(x: 2970988.8156491998, y: 7122908.373712409), Point(x: 0, y: 90)),
  'EPSG:7576': ProjectAndUnProjectResult(
      Point(x: 6185217.781532984, y: 5058126.517897963),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7577': ProjectAndUnProjectResult(
      Point(x: 3320998.1229724446, y: 7147083.394483467), Point(x: 0, y: 90)),
  'EPSG:7578': ProjectAndUnProjectResult(
      Point(x: 6349249.281911696, y: 5109794.297470344),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:7579': ProjectAndUnProjectResult(
      Point(x: 6050222.56610098, y: 4875399.64449111),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:7580': ProjectAndUnProjectResult(
      Point(x: 6381554.159558333, y: 5059358.815598653),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:7692': ProjectAndUnProjectResult(
      Point(x: -2454926.226432084, y: 6595235.458561134),
      Point(x: 25.359226227943847, y: 48.12268107212026)),
  'EPSG:7581': ProjectAndUnProjectResult(
      Point(x: 6194326.718149486, y: 5191093.082494468),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7582': ProjectAndUnProjectResult(
      Point(x: 3768447.9297039146, y: 6941092.747986726), Point(x: 0, y: 90)),
  'EPSG:7583': ProjectAndUnProjectResult(
      Point(x: 3831482.1536448947, y: 6992424.743299675), Point(x: 0, y: 90)),
  'EPSG:7584': ProjectAndUnProjectResult(
      Point(x: 3711070.401249271, y: 6943225.986154948), Point(x: 0, y: 90)),
  'EPSG:7585': ProjectAndUnProjectResult(
      Point(x: 6174320.100826744, y: 4963712.138234687),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:7586': ProjectAndUnProjectResult(
      Point(x: 6258945.117242297, y: 5095130.3786482215),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7587': ProjectAndUnProjectResult(
      Point(x: 11378883.685214741, y: 23079857.103862435), Point(x: 0, y: 90)),
  'EPSG:7588': ProjectAndUnProjectResult(
      Point(x: 11088149.032900875, y: 22365163.53324931), Point(x: 0, y: 90)),
  'EPSG:7589': ProjectAndUnProjectResult(
      Point(x: 10042425.055252131, y: 22824982.125635523), Point(x: 0, y: 90)),
  'EPSG:7590': ProjectAndUnProjectResult(
      Point(x: 20103414.197611663, y: 16612508.504353167),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:7591': ProjectAndUnProjectResult(
      Point(x: 12106235.909091806, y: 22740868.494165752), Point(x: 0, y: 90)),
  'EPSG:7592': ProjectAndUnProjectResult(
      Point(x: 10346675.304421574, y: 23416822.251727488), Point(x: 0, y: 90)),
  'EPSG:7593': ProjectAndUnProjectResult(
      Point(x: 19811953.938981485, y: 16785232.186769795),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:7594': ProjectAndUnProjectResult(
      Point(x: 12542594.209403375, y: 22955969.216841422), Point(x: 0, y: 90)),
  'EPSG:7595': ProjectAndUnProjectResult(
      Point(x: 19970429.55063884, y: 16620465.09421466),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:7596': ProjectAndUnProjectResult(
      Point(x: 11124053.930451838, y: 23151516.833878253), Point(x: 0, y: 90)),
  'EPSG:7597': ProjectAndUnProjectResult(
      Point(x: 20590671.729405165, y: 16659900.544401342),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:4958': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7598': ProjectAndUnProjectResult(
      Point(x: 20582062.25774571, y: 16889952.728007607),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7599': ProjectAndUnProjectResult(
      Point(x: 20948555.655217215, y: 16853291.16088273),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:7600': ProjectAndUnProjectResult(
      Point(x: 12455158.00186667, y: 23479275.373399213), Point(x: 0, y: 90)),
  'EPSG:7601': ProjectAndUnProjectResult(
      Point(x: 12890765.47748966, y: 22023009.93872364), Point(x: 0, y: 90)),
  'EPSG:7602': ProjectAndUnProjectResult(
      Point(x: 9886392.908520725, y: 22564039.67997072), Point(x: 0, y: 90)),
  'EPSG:7603': ProjectAndUnProjectResult(
      Point(x: 9877211.930597758, y: 23097674.847744167), Point(x: 0, y: 90)),
  'EPSG:7604': ProjectAndUnProjectResult(
      Point(x: 20193598.768889513, y: 16794668.070767444),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7605': ProjectAndUnProjectResult(
      Point(x: 12367346.946661, y: 21873990.270624973), Point(x: 0, y: 90)),
  'EPSG:4960': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7606': ProjectAndUnProjectResult(
      Point(x: 12573383.403229175, y: 22521465.109520163), Point(x: 0, y: 90)),
  'EPSG:7607': ProjectAndUnProjectResult(
      Point(x: 11206133.067307316, y: 23968596.282162443), Point(x: 0, y: 90)),
  'EPSG:7608': ProjectAndUnProjectResult(
      Point(x: 20837607.011851687, y: 16700929.017256644),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7609': ProjectAndUnProjectResult(
      Point(x: 20433794.504340194, y: 16453564.344445622),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7610': ProjectAndUnProjectResult(
      Point(x: 11171278.631028585, y: 23418021.894749753), Point(x: 0, y: 90)),
  'EPSG:7611': ProjectAndUnProjectResult(
      Point(x: 11469056.761512207, y: 22384585.423738793), Point(x: 0, y: 90)),
  'EPSG:7612': ProjectAndUnProjectResult(
      Point(x: 10472152.450069249, y: 23024102.495499462), Point(x: 0, y: 90)),
  'EPSG:7613': ProjectAndUnProjectResult(
      Point(x: 12667039.887473175, y: 22983970.31930564), Point(x: 0, y: 90)),
  'EPSG:4962': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7614': ProjectAndUnProjectResult(
      Point(x: 12493830.304164285, y: 22510568.69545532), Point(x: 0, y: 90)),
  'EPSG:7615': ProjectAndUnProjectResult(
      Point(x: 10512746.080779292, y: 23332461.64006414), Point(x: 0, y: 90)),
  'EPSG:7616': ProjectAndUnProjectResult(
      Point(x: 20249733.337951124, y: 16238770.130251091),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7617': ProjectAndUnProjectResult(
      Point(x: 11433270.066707775, y: 22480434.68273107), Point(x: 0, y: 90)),
  'EPSG:7618': ProjectAndUnProjectResult(
      Point(x: 19949231.999610875, y: 16299929.656691685),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:7619': ProjectAndUnProjectResult(
      Point(x: 12933574.418677995, y: 22033700.06158052), Point(x: 0, y: 90)),
  'EPSG:7620': ProjectAndUnProjectResult(
      Point(x: 12130147.779973747, y: 22207054.54652695), Point(x: 0, y: 90)),
  'EPSG:7621': ProjectAndUnProjectResult(
      Point(x: 20653375.051792394, y: 16896778.322485004),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:4964': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7622': ProjectAndUnProjectResult(
      Point(x: 12649874.982788838, y: 22192711.759361073), Point(x: 0, y: 90)),
  'EPSG:7623': ProjectAndUnProjectResult(
      Point(x: 19729134.353307065, y: 16103199.063759169),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:7624': ProjectAndUnProjectResult(
      Point(x: 20462047.823502544, y: 17048528.628859814),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7625': ProjectAndUnProjectResult(
      Point(x: 9669367.040981706, y: 23141335.016640786), Point(x: 0, y: 90)),
  'EPSG:7626': ProjectAndUnProjectResult(
      Point(x: 19990355.030395694, y: 16307714.554352777),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7627': ProjectAndUnProjectResult(
      Point(x: 11350901.084650932, y: 22756067.632203847), Point(x: 0, y: 90)),
  'EPSG:7628': ProjectAndUnProjectResult(
      Point(x: 20806907.80288401, y: 17009496.683093622),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7629': ProjectAndUnProjectResult(
      Point(x: 11907552.590417586, y: 23380029.59312281), Point(x: 0, y: 90)),
  'EPSG:4966': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7630': ProjectAndUnProjectResult(
      Point(x: 11066161.8809224, y: 23110804.56343446), Point(x: 0, y: 90)),
  'EPSG:7631': ProjectAndUnProjectResult(
      Point(x: 11563756.788785035, y: 23256528.138503537), Point(x: 0, y: 90)),
  'EPSG:7632': ProjectAndUnProjectResult(
      Point(x: 20247611.586186536, y: 16657416.973008037),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:7633': ProjectAndUnProjectResult(
      Point(x: 12543955.598754406, y: 22502592.892731138), Point(x: 0, y: 90)),
  'EPSG:7634': ProjectAndUnProjectResult(
      Point(x: 9747319.139011249, y: 23369075.222962216), Point(x: 0, y: 90)),
  'EPSG:7635': ProjectAndUnProjectResult(
      Point(x: 20292668.671235465, y: 16594870.083960734),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7636': ProjectAndUnProjectResult(
      Point(x: 10895641.342093261, y: 23448389.436283093), Point(x: 0, y: 90)),
  'EPSG:7637': ProjectAndUnProjectResult(
      Point(x: 20830828.685439706, y: 16764383.45811112),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:4968': ProjectAndUnProjectResult(
      Point(x: 4155553.9165052753, y: 1341250.964523339),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7638': ProjectAndUnProjectResult(
      Point(x: 19849771.86873355, y: 15995373.66720092),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:7639': ProjectAndUnProjectResult(
      Point(x: 20936815.605235383, y: 16598913.047519246),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:7640': ProjectAndUnProjectResult(
      Point(x: 20322553.57437594, y: 17031111.221955102),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7641': ProjectAndUnProjectResult(
      Point(x: 12363649.582382344, y: 22772568.457510624), Point(x: 0, y: 90)),
  'EPSG:7642': ProjectAndUnProjectResult(
      Point(x: 12570454.365361627, y: 22940980.17848752), Point(x: 0, y: 90)),
  'EPSG:7643': ProjectAndUnProjectResult(
      Point(x: 12175403.474904234, y: 22779567.256277528), Point(x: 0, y: 90)),
  'EPSG:7644': ProjectAndUnProjectResult(
      Point(x: 20256915.197406244, y: 16285112.240523387),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:7645': ProjectAndUnProjectResult(
      Point(x: 20534555.77206069, y: 16716273.58370004),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:4970': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7693': ProjectAndUnProjectResult(
      Point(x: -1652225.1502001407, y: 6781799.831137376),
      Point(x: 35.47110857973571, y: 49.92415331328578)),
  'EPSG:7694': ProjectAndUnProjectResult(
      Point(x: -841789.2963218018, y: 6982574.935512391),
      Point(x: 59.99335786653508, y: 54.464347104253086)),
  'EPSG:7695': ProjectAndUnProjectResult(
      Point(x: -22084.37828948628, y: 7197826.1699963305),
      Point(x: 121.69387903402314, y: 66.29050681235447)),
  'EPSG:7696': ProjectAndUnProjectResult(
      Point(x: 808662.7986178342, y: 7427709.184928953),
      Point(x: -74.82963703740957, y: 98.60767852673067)),
  'EPSG:7755': ProjectAndUnProjectResult(
      Point(x: -904525.2242868403, y: 7662006.413411753),
      Point(x: 17.8880585602815, y: 46.89226406700871)),
  'EPSG:7756': ProjectAndUnProjectResult(
      Point(x: -4537812.944278624, y: 5435359.218201913),
      Point(x: 17.888058560281525, y: 46.89226406700875)),
  'EPSG:7757': ProjectAndUnProjectResult(
      Point(x: -4793894.862831452, y: 5018079.864321054),
      Point(x: 17.888058560281486, y: 46.892264067008725)),
  'EPSG:7758': ProjectAndUnProjectResult(
      Point(x: -4803396.080620209, y: 5082432.190703118),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:7759': ProjectAndUnProjectResult(
      Point(x: -4329396.652758994, y: 4799971.999702074),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:7805': ProjectAndUnProjectResult(
      Point(x: -650192.1809783222, y: 5305193.277268217),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:7760': ProjectAndUnProjectResult(
      Point(x: -3568570.213336141, y: 4217053.680079004),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7761': ProjectAndUnProjectResult(
      Point(x: -3413364.65840997, y: 4602536.007463008),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:7762': ProjectAndUnProjectResult(
      Point(x: -3472245.046728124, y: 4122318.2053158665),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7763': ProjectAndUnProjectResult(
      Point(x: -3475071.64293346, y: 3955315.380494032),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:7764': ProjectAndUnProjectResult(
      Point(x: -3317546.9843740584, y: 3653661.867309805),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7765': ProjectAndUnProjectResult(
      Point(x: -4442118.553801264, y: 4972542.376448838),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7766': ProjectAndUnProjectResult(
      Point(x: -3875815.2016120413, y: 4675137.308257107),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:7767': ProjectAndUnProjectResult(
      Point(x: -4025661.4910184806, y: 5085650.173013702),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:7768': ProjectAndUnProjectResult(
      Point(x: -4975466.610302306, y: 5229258.121154087),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'ESRI:37003': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7769': ProjectAndUnProjectResult(
      Point(x: -4733681.140773422, y: 5051119.995353898),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7770': ProjectAndUnProjectResult(
      Point(x: -4907661.545821067, y: 5147218.432244681),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:7771': ProjectAndUnProjectResult(
      Point(x: -4874963.778807075, y: 5139522.661585951),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7772': ProjectAndUnProjectResult(
      Point(x: -4557309.668833531, y: 5203221.256473009),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:7773': ProjectAndUnProjectResult(
      Point(x: -3364837.9800113374, y: 3941542.3492837846),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:7774': ProjectAndUnProjectResult(
      Point(x: -3408508.6930815615, y: 4257077.738464732),
      Point(x: 17.8880585602815, y: 46.89226406700871)),
  'EPSG:7775': ProjectAndUnProjectResult(
      Point(x: -3905776.862201918, y: 4494400.98317029),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7776': ProjectAndUnProjectResult(
      Point(x: -3677837.4077699594, y: 4189795.4945500074),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:7777': ProjectAndUnProjectResult(
      Point(x: -4033381.4670982556, y: 8414069.773018373),
      Point(x: 43417.311257047084, y: 9457.129707704946)),
  'EPSG:4972': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7778': ProjectAndUnProjectResult(
      Point(x: -3582542.945106227, y: 6228518.862826186),
      Point(x: 132.0497408210313, y: 140.34639719975036)),
  'EPSG:7779': ProjectAndUnProjectResult(
      Point(x: -3109721.4653790244, y: 6231698.743099098),
      Point(x: 54.05194477113698, y: 53.35066333534962)),
  'EPSG:7780': ProjectAndUnProjectResult(
      Point(x: -3253826.0269146403, y: 6425549.121555907),
      Point(x: 91.20978257437393, y: 60.40106670039202)),
  'EPSG:7781': ProjectAndUnProjectResult(
      Point(x: -3231849.8605702557, y: 6910793.2310705315),
      Point(x: 83.37689035852588, y: 58.900522520461685)),
  'EPSG:7782': ProjectAndUnProjectResult(
      Point(x: -3054718.683256847, y: 6766785.493810551),
      Point(x: 45.88871152468898, y: 51.832863596870496)),
  'EPSG:7783': ProjectAndUnProjectResult(
      Point(x: -4019270.954122158, y: 6940372.217550638),
      Point(x: 33392.01075465661, y: 7281.584194438904)),
  'EPSG:7784': ProjectAndUnProjectResult(
      Point(x: -3871518.2802565703, y: 6038562.57568622),
      Point(x: 4472.214085329623, y: 1050.7053892111003)),
  'EPSG:7785': ProjectAndUnProjectResult(
      Point(x: -3370821.5563283507, y: 7043473.695279143),
      Point(x: 153.2526404573087, y: 72.45024304302119)),
  'EPSG:7786': ProjectAndUnProjectResult(
      Point(x: -3988603.459985815, y: 6773906.02038821),
      Point(x: 20167.353539006373, y: 4419.867669744238)),
  'EPSG:7787': ProjectAndUnProjectResult(
      Point(x: -3845521.7607766697, y: 6340845.19478786),
      Point(x: 3388.1823641108126, y: 820.9021764409059)),
  'EPSG:4974': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7791': ProjectAndUnProjectResult(
      Point(x: 1176891.2861569354, y: 5231671.8338276325),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:7792': ProjectAndUnProjectResult(
      Point(x: 720001.2298382937, y: 5197241.609971515),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7793': ProjectAndUnProjectResult(
      Point(x: 262945.28796354064, y: 5197894.102609971),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:7794': ProjectAndUnProjectResult(
      Point(x: 7447996.264442064, y: 5204311.696323936),
      Point(x: 17.888058558416997, y: 46.892264063331794)),
  'EPSG:7795': ProjectAndUnProjectResult(
      Point(x: 3448669.26834458, y: 5212129.891160676),
      Point(x: 17.888058558416994, y: 46.89226406333179)),
  'EPSG:7799': ProjectAndUnProjectResult(
      Point(x: 262945.28796354064, y: 5197894.102609971),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:7800': ProjectAndUnProjectResult(
      Point(x: -193931.34632474044, y: 5233642.279699988),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:7801': ProjectAndUnProjectResult(
      Point(x: -80884.42055719334, y: 5221839.828291411),
      Point(x: 17.888058560281518, y: 46.89226406700873)),
  'EPSG:7803': ProjectAndUnProjectResult(
      Point(x: 262945.28796354064, y: 5197894.102609971),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:7804': ProjectAndUnProjectResult(
      Point(x: 262945.28796354064, y: 5197894.102609971),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:4976': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7825': ProjectAndUnProjectResult(
      Point(x: 872489.2518016153, y: 5201499.242895964),
      Point(x: 17.888058571216604, y: 46.89226406568868)),
  'EPSG:7826': ProjectAndUnProjectResult(
      Point(x: 1643984.1255450116, y: 5222313.870437039),
      Point(x: 17.88805866223247, y: 46.89226403526917)),
  'EPSG:7827': ProjectAndUnProjectResult(
      Point(x: 2415617.925272428, y: 5252050.725598798),
      Point(x: 17.88806013407137, y: 46.892263920106515)),
  'EPSG:7828': ProjectAndUnProjectResult(
      Point(x: 3187463.18589976, y: 5290855.850841106),
      Point(x: 17.888072114772392, y: 46.89226394621387)),
  'EPSG:7829': ProjectAndUnProjectResult(
      Point(x: 3959614.5918617975, y: 5338918.0329357125),
      Point(x: 17.888137727990788, y: 46.89226656331775)),
  'EPSG:7830': ProjectAndUnProjectResult(
      Point(x: 4732195.564958615, y: 5396468.1411800645),
      Point(x: 17.88841568534829, y: 46.892284060889814)),
  'EPSG:7831': ProjectAndUnProjectResult(
      Point(x: 5505365.445731573, y: 5463778.080756947),
      Point(x: 17.88940175952805, y: 46.89236278537433)),
  'EPSG:7845': ProjectAndUnProjectResult(
      Point(x: -18704187.61509478, y: -1254790.7080928627),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:7846': ProjectAndUnProjectResult(
      Point(x: -4566585.223791351, y: 18492222.441867895),
      Point(x: 17.888058560281575, y: 46.892264067008874)),
  'EPSG:32610': ProjectAndUnProjectResult(
      Point(x: 3446086.561661094, y: 14009002.219304737),
      Point(x: 17.888058560281486, y: 46.89226406700882)),
  'EPSG:7850': ProjectAndUnProjectResult(
      Point(x: -4731020.405467821, y: 20936701.340747207),
      Point(x: 17.888058560281298, y: 46.89226406700882)),
  'EPSG:7851': ProjectAndUnProjectResult(
      Point(x: -4558786.502469642, y: 21525007.658234946),
      Point(x: 17.88805856028145, y: 46.89226406700888)),
  'EPSG:7852': ProjectAndUnProjectResult(
      Point(x: -4314192.978437341, y: 22073000.7368301),
      Point(x: 17.888058560281564, y: 46.89226406700883)),
  'EPSG:7853': ProjectAndUnProjectResult(
      Point(x: -4009686.094082634, y: 22571384.874783527),
      Point(x: 17.88805856028154, y: 46.892264067008796)),
  'EPSG:7854': ProjectAndUnProjectResult(
      Point(x: -3658127.571879782, y: 23015261.60497248),
      Point(x: 17.88805856028154, y: 46.89226406700878)),
  'EPSG:7855': ProjectAndUnProjectResult(
      Point(x: -3271333.3919436852, y: 23403348.66088295),
      Point(x: 17.888058560281486, y: 46.892264067008774)),
  'EPSG:7856': ProjectAndUnProjectResult(
      Point(x: -2859272.60100763, y: 23736892.622219022),
      Point(x: 17.88805856028154, y: 46.892264067008796)),
  'EPSG:7857': ProjectAndUnProjectResult(
      Point(x: -2429824.9011676833, y: 24018622.98227349),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:7858': ProjectAndUnProjectResult(
      Point(x: -1988897.8368866723, y: 24251921.064358793),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:7859': ProjectAndUnProjectResult(
      Point(x: -1540720.0453096956, y: 24440239.592344202),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:8036': ProjectAndUnProjectResult(
      Point(x: 18237452.05007213, y: 27791684.00881048),
      Point(x: 17.888058560281475, y: 46.89226406700888)),
  'EPSG:7877': ProjectAndUnProjectResult(
      Point(x: 2093565.0269075555, y: 9238934.276275959),
      Point(x: 17.886723245397423, y: 46.892362026466806)),
  'EPSG:7878': ProjectAndUnProjectResult(
      Point(x: 2087552.2238160435, y: 15409458.75670271),
      Point(x: 17.888058880703458, y: 46.892263950123855)),
  'EPSG:7882': ProjectAndUnProjectResult(
      Point(x: 2093684.3122717913, y: 9239197.884007037),
      Point(x: 17.88671850889464, y: 46.892362491008505)),
  'EPSG:7883': ProjectAndUnProjectResult(
      Point(x: 2088185.9619449263, y: 15409193.326275803),
      Point(x: 17.8880585602815, y: 46.89226406700879)),
  'EPSG:7887': ProjectAndUnProjectResult(
      Point(x: 2088186.0339291478, y: 15409193.447385449),
      Point(x: 17.888058560281504, y: 46.89226406700879)),
  'EPSG:7899': ProjectAndUnProjectResult(
      Point(x: -19288382.890973657, y: -742437.3449551277),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:7991': ProjectAndUnProjectResult(
      Point(x: 4954580.012644431, y: 10893989.875088919), Point(x: 0, y: 90)),
  'EPSG:7992': ProjectAndUnProjectResult(
      Point(x: 719939.303882269, y: 15197320.734538205),
      Point(x: 17.88805856585687, y: 46.89226406795597)),
  'EPSG:8013': ProjectAndUnProjectResult(
      Point(x: -4364591.050940062, y: 15259840.986237284), Point(x: 0, y: 90)),
  'EPSG:26707': ProjectAndUnProjectResult(
      Point(x: 2105108.714430198, y: 14581808.599994019),
      Point(x: 17.88805856028151, y: 46.892264047823105)),
  'EPSG:8014': ProjectAndUnProjectResult(
      Point(x: -4592675.328544364, y: 13592588.58950644), Point(x: 0, y: 90)),
  'EPSG:8015': ProjectAndUnProjectResult(
      Point(x: -3824831.0743253115, y: 13871049.84056003), Point(x: 0, y: 90)),
  'EPSG:8016': ProjectAndUnProjectResult(
      Point(x: -4587850.778673121, y: 14911545.652162079), Point(x: 0, y: 90)),
  'EPSG:8017': ProjectAndUnProjectResult(
      Point(x: -4719970.839155637, y: 13776125.45713849), Point(x: 0, y: 90)),
  'EPSG:8018': ProjectAndUnProjectResult(
      Point(x: -5062792.289666137, y: 11250688.140546752),
      Point(x: 407030514824.1814, y: 88857755434.83792)),
  'EPSG:8019': ProjectAndUnProjectResult(
      Point(x: -5065113.923605251, y: 10513870.82307435),
      Point(x: 390580.8117010934, y: 85422.32822390879)),
  'EPSG:8020': ProjectAndUnProjectResult(
      Point(x: -4556287.499120629, y: 15063396.152821098), Point(x: 0, y: 90)),
  'EPSG:8021': ProjectAndUnProjectResult(
      Point(x: -3887989.812019491, y: 15582447.82671999), Point(x: 0, y: 90)),
  'EPSG:8022': ProjectAndUnProjectResult(
      Point(x: -4692091.381984846, y: 13518544.556688145), Point(x: 0, y: 90)),
  'EPSG:8023': ProjectAndUnProjectResult(
      Point(x: -4654349.630470202, y: 14273000.531162012), Point(x: 0, y: 90)),
  'EPSG:8024': ProjectAndUnProjectResult(
      Point(x: -3930365.1803026157, y: 15299453.2110002), Point(x: 0, y: 90)),
  'EPSG:8025': ProjectAndUnProjectResult(
      Point(x: -4623743.292212465, y: 14514828.252957111), Point(x: 0, y: 90)),
  'EPSG:8026': ProjectAndUnProjectResult(
      Point(x: -4669221.323802059, y: 14494899.394310832), Point(x: 0, y: 90)),
  'EPSG:8027': ProjectAndUnProjectResult(
      Point(x: -4456932.123524749, y: 13614984.40370194), Point(x: 0, y: 90)),
  'EPSG:8028': ProjectAndUnProjectResult(
      Point(x: -2682434.7868312746, y: 14118541.30040039), Point(x: 0, y: 90)),
  'EPSG:8029': ProjectAndUnProjectResult(
      Point(x: -4593286.913603303, y: 14654695.324798925), Point(x: 0, y: 90)),
  'EPSG:8030': ProjectAndUnProjectResult(
      Point(x: -4609331.0448838845, y: 14933958.380309822), Point(x: 0, y: 90)),
  'EPSG:8031': ProjectAndUnProjectResult(
      Point(x: -4556092.659783599, y: 14851177.193981452), Point(x: 0, y: 90)),
  'EPSG:8032': ProjectAndUnProjectResult(
      Point(x: -4289840.523989684, y: 13729924.861604918), Point(x: 0, y: 90)),
  'EPSG:8035': ProjectAndUnProjectResult(
      Point(x: 18802522.780162964, y: 29721818.98542608),
      Point(x: 17.888058560281323, y: 46.89226406700882)),
  'EPSG:8044': ProjectAndUnProjectResult(
      Point(x: 285602.5268496323, y: -120567.2297253191),
      Point(x: 17.888050353604346, y: 46.89226438886983)),
  'EPSG:8045': ProjectAndUnProjectResult(
      Point(x: 115312.22892238077, y: -145216.80676771345),
      Point(x: 17.888058472917784, y: 46.89226407547426)),
  'EPSG:8058': ProjectAndUnProjectResult(
      Point(x: -12032145.999217626, y: 2197042.8317936016),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:8059': ProjectAndUnProjectResult(
      Point(x: -19053509.31088796, y: 2429151.340795912),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8065': ProjectAndUnProjectResult(
      Point(x: 19655901.422633134, y: 27122964.813796055),
      Point(x: 17.888058560281486, y: 46.89226406700875)),
  'EPSG:8066': ProjectAndUnProjectResult(
      Point(x: -12916232.579982523, y: 25630463.91394005), Point(x: 0, y: 90)),
  'EPSG:8067': ProjectAndUnProjectResult(
      Point(x: -16047526.030278021, y: 23804140.53235026), Point(x: 0, y: 90)),
  'EPSG:8068': ProjectAndUnProjectResult(
      Point(x: 26821584.197648898, y: 22599130.635271773),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8082': ProjectAndUnProjectResult(
      Point(x: 29621061.74852327, y: 8954491.865918288),
      Point(x: -519603.4821607426, y: 113747.10753176491)),
  'EPSG:4978': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8083': ProjectAndUnProjectResult(
      Point(x: 30650864.10052601, y: 9269865.456694849),
      Point(x: -6859630.010890731, y: 1508686.9880534173)),
  'EPSG:8088': ProjectAndUnProjectResult(
      Point(x: 5470199.377220549, y: -913939.791333823),
      Point(x: 17.888058560281507, y: 46.89226406700873)),
  'EPSG:8090': ProjectAndUnProjectResult(
      Point(x: 3769574.888567513, y: 6667205.568796816), Point(x: 0, y: 90)),
  'EPSG:8091': ProjectAndUnProjectResult(
      Point(x: 12367346.946661, y: 21873990.270624973), Point(x: 0, y: 90)),
  'EPSG:8092': ProjectAndUnProjectResult(
      Point(x: 6155021.214817072, y: 5119025.0660186),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8093': ProjectAndUnProjectResult(
      Point(x: 20193598.768889513, y: 16794668.070767444),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8095': ProjectAndUnProjectResult(
      Point(x: 6258945.117242297, y: 5095130.3786482215),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8096': ProjectAndUnProjectResult(
      Point(x: 20534555.77206069, y: 16716273.58370004),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26708': ProjectAndUnProjectResult(
      Point(x: 2557512.711474267, y: 14433799.036135145),
      Point(x: 17.888058560281486, y: 46.89226404782313)),
  'EPSG:8097': ProjectAndUnProjectResult(
      Point(x: 6174320.100826744, y: 4963712.138234687),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8098': ProjectAndUnProjectResult(
      Point(x: 20256915.197406244, y: 16285112.240523387),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8099': ProjectAndUnProjectResult(
      Point(x: 3711070.401249271, y: 6943225.986154948), Point(x: 0, y: 90)),
  'EPSG:8100': ProjectAndUnProjectResult(
      Point(x: 12175403.474904234, y: 22779567.256277528), Point(x: 0, y: 90)),
  'EPSG:8101': ProjectAndUnProjectResult(
      Point(x: 3831482.1536448947, y: 6992424.743299675), Point(x: 0, y: 90)),
  'EPSG:8102': ProjectAndUnProjectResult(
      Point(x: 12570454.365361627, y: 22940980.17848752), Point(x: 0, y: 90)),
  'EPSG:8103': ProjectAndUnProjectResult(
      Point(x: 3768447.9297039146, y: 6941092.747986726), Point(x: 0, y: 90)),
  'EPSG:8104': ProjectAndUnProjectResult(
      Point(x: 12363649.582382344, y: 22772568.457510624), Point(x: 0, y: 90)),
  'EPSG:4980': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8105': ProjectAndUnProjectResult(
      Point(x: 6194326.718149486, y: 5191093.082494468),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8106': ProjectAndUnProjectResult(
      Point(x: 20322553.57437594, y: 17031111.221955102),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8107': ProjectAndUnProjectResult(
      Point(x: 6381554.159558333, y: 5059358.815598653),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:8108': ProjectAndUnProjectResult(
      Point(x: 20936815.605235383, y: 16598913.047519246),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:8109': ProjectAndUnProjectResult(
      Point(x: 6050222.56610098, y: 4875399.64449111),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:8110': ProjectAndUnProjectResult(
      Point(x: 19849771.86873355, y: 15995373.66720092),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:8111': ProjectAndUnProjectResult(
      Point(x: 6349249.281911696, y: 5109794.297470344),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:8112': ProjectAndUnProjectResult(
      Point(x: 20830828.685439706, y: 16764383.45811112),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:8113': ProjectAndUnProjectResult(
      Point(x: 3320998.1229724446, y: 7147083.394483467), Point(x: 0, y: 90)),
  'EPSG:8114': ProjectAndUnProjectResult(
      Point(x: 10895641.342093261, y: 23448389.436283093), Point(x: 0, y: 90)),
  'EPSG:8115': ProjectAndUnProjectResult(
      Point(x: 6185217.781532984, y: 5058126.517897963),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8116': ProjectAndUnProjectResult(
      Point(x: 20292668.671235465, y: 16594870.083960734),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8117': ProjectAndUnProjectResult(
      Point(x: 2970988.8156491998, y: 7122908.373712409), Point(x: 0, y: 90)),
  'EPSG:8118': ProjectAndUnProjectResult(
      Point(x: 9747319.139011249, y: 23369075.222962216), Point(x: 0, y: 90)),
  'EPSG:8119': ProjectAndUnProjectResult(
      Point(x: 3823405.313439519, y: 6858804.031463695), Point(x: 0, y: 90)),
  'EPSG:8120': ProjectAndUnProjectResult(
      Point(x: 12543955.598754406, y: 22502592.892731138), Point(x: 0, y: 90)),
  'EPSG:4982': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8121': ProjectAndUnProjectResult(
      Point(x: 6171484.354307097, y: 5077190.847684618),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8122': ProjectAndUnProjectResult(
      Point(x: 20247611.586186536, y: 16657416.973008037),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:8123': ProjectAndUnProjectResult(
      Point(x: 3524640.118549972, y: 7088603.953742174), Point(x: 0, y: 90)),
  'EPSG:8124': ProjectAndUnProjectResult(
      Point(x: 11563756.788785035, y: 23256528.138503537), Point(x: 0, y: 90)),
  'EPSG:8125': ProjectAndUnProjectResult(
      Point(x: 3372972.8871539193, y: 7044187.319239815), Point(x: 0, y: 90)),
  'EPSG:8126': ProjectAndUnProjectResult(
      Point(x: 11066161.8809224, y: 23110804.56343446), Point(x: 0, y: 90)),
  'EPSG:8127': ProjectAndUnProjectResult(
      Point(x: 3629429.2884092713, y: 7126247.272572763), Point(x: 0, y: 90)),
  'EPSG:8128': ProjectAndUnProjectResult(
      Point(x: 11907552.590417586, y: 23380029.59312281), Point(x: 0, y: 90)),
  'EPSG:4984': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8129': ProjectAndUnProjectResult(
      Point(x: 6341958.1822602, y: 5184504.957866001),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8130': ProjectAndUnProjectResult(
      Point(x: 20806907.80288401, y: 17009496.683093622),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8131': ProjectAndUnProjectResult(
      Point(x: 3459761.570267035, y: 6936063.286349483), Point(x: 0, y: 90)),
  'EPSG:8132': ProjectAndUnProjectResult(
      Point(x: 11350901.084650932, y: 22756067.632203847), Point(x: 0, y: 90)),
  'EPSG:8133': ProjectAndUnProjectResult(
      Point(x: 6093072.399433181, y: 4970601.337317026),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8134': ProjectAndUnProjectResult(
      Point(x: 19990355.030395694, y: 16307714.554352777),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8135': ProjectAndUnProjectResult(
      Point(x: 2947228.968603797, y: 7053493.02016694), Point(x: 0, y: 90)),
  'EPSG:8136': ProjectAndUnProjectResult(
      Point(x: 9669367.040981706, y: 23141335.016640786), Point(x: 0, y: 90)),
  'EPSG:4986': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8137': ProjectAndUnProjectResult(
      Point(x: 6236844.650412206, y: 5196401.918748533),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8138': ProjectAndUnProjectResult(
      Point(x: 20462047.823502544, y: 17048528.628859814),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8139': ProjectAndUnProjectResult(
      Point(x: 6013452.177684069, y: 4908264.891016306),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8140': ProjectAndUnProjectResult(
      Point(x: 19729134.353307065, y: 16103199.063759169),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8141': ProjectAndUnProjectResult(
      Point(x: 3855689.606143715, y: 6764352.072904594), Point(x: 0, y: 90)),
  'EPSG:8142': ProjectAndUnProjectResult(
      Point(x: 12649874.982788838, y: 22192711.759361073), Point(x: 0, y: 90)),
  'EPSG:8143': ProjectAndUnProjectResult(
      Point(x: 6295161.306066516, y: 5150148.332907723),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:8144': ProjectAndUnProjectResult(
      Point(x: 20653375.051792394, y: 16896778.322485004),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:8145': ProjectAndUnProjectResult(
      Point(x: 3697276.437847649, y: 6768723.763080934), Point(x: 0, y: 90)),
  'EPSG:8146': ProjectAndUnProjectResult(
      Point(x: 12130147.779973747, y: 22207054.54652695), Point(x: 0, y: 90)),
  'EPSG:8147': ProjectAndUnProjectResult(
      Point(x: 3942161.367084428, y: 6715885.210692157), Point(x: 0, y: 90)),
  'EPSG:8148': ProjectAndUnProjectResult(
      Point(x: 12933574.418677995, y: 22033700.06158052), Point(x: 0, y: 90)),
  'EPSG:8149': ProjectAndUnProjectResult(
      Point(x: 6080538.074505244, y: 4968228.495762084),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:8150': ProjectAndUnProjectResult(
      Point(x: 19949231.999610875, y: 16299929.656691685),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:8151': ProjectAndUnProjectResult(
      Point(x: 3484867.686109837, y: 6852050.195405609), Point(x: 0, y: 90)),
  'EPSG:8152': ProjectAndUnProjectResult(
      Point(x: 11433270.066707775, y: 22480434.68273107), Point(x: 0, y: 90)),
  'EPSG:4988': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8153': ProjectAndUnProjectResult(
      Point(x: 6172131.065819239, y: 4949587.034894236),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8154': ProjectAndUnProjectResult(
      Point(x: 20249733.337951124, y: 16238770.130251091),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8155': ProjectAndUnProjectResult(
      Point(x: 3204291.414114237, y: 7111748.531335806), Point(x: 0, y: 90)),
  'EPSG:8156': ProjectAndUnProjectResult(
      Point(x: 10512746.080779292, y: 23332461.64006414), Point(x: 0, y: 90)),
  'EPSG:8157': ProjectAndUnProjectResult(
      Point(x: 3808127.092819137, y: 6861235.0608257), Point(x: 0, y: 90)),
  'EPSG:8158': ProjectAndUnProjectResult(
      Point(x: 12493830.304164285, y: 22510568.69545532), Point(x: 0, y: 90)),
  'EPSG:8159': ProjectAndUnProjectResult(
      Point(x: 3860921.4795736372, y: 7005528.164366286), Point(x: 0, y: 90)),
  'EPSG:8160': ProjectAndUnProjectResult(
      Point(x: 12667039.887473175, y: 22983970.31930564), Point(x: 0, y: 90)),
  'EPSG:4990': ProjectAndUnProjectResult(
      Point(x: 4155428.244442961, y: 1341210.402475973),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8161': ProjectAndUnProjectResult(
      Point(x: 3191918.450618008, y: 7017760.476250788), Point(x: 0, y: 90)),
  'EPSG:8162': ProjectAndUnProjectResult(
      Point(x: 10472152.450069249, y: 23024102.495499462), Point(x: 0, y: 90)),
  'EPSG:8163': ProjectAndUnProjectResult(
      Point(x: 3495775.4923990215, y: 6822835.282791732), Point(x: 0, y: 90)),
  'EPSG:8164': ProjectAndUnProjectResult(
      Point(x: 11469056.761512207, y: 22384585.423738793), Point(x: 0, y: 90)),
  'EPSG:8165': ProjectAndUnProjectResult(
      Point(x: 3405012.5367005337, y: 7137827.349102414), Point(x: 0, y: 90)),
  'EPSG:8166': ProjectAndUnProjectResult(
      Point(x: 11171278.631028585, y: 23418021.894749753), Point(x: 0, y: 90)),
  'EPSG:8167': ProjectAndUnProjectResult(
      Point(x: 6228233.02143633, y: 5015056.442424751),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8168': ProjectAndUnProjectResult(
      Point(x: 20433794.504340194, y: 16453564.344445622),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:4992': ProjectAndUnProjectResult(
      Point(x: 4155428.244442961, y: 1341210.402475973),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8169': ProjectAndUnProjectResult(
      Point(x: 6351315.319985553, y: 5090453.3452227255),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8170': ProjectAndUnProjectResult(
      Point(x: 20837607.011851687, y: 16700929.017256644),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8171': ProjectAndUnProjectResult(
      Point(x: 3415636.1902642823, y: 7305642.758030209), Point(x: 0, y: 90)),
  'EPSG:8172': ProjectAndUnProjectResult(
      Point(x: 11206133.067307316, y: 23968596.282162443), Point(x: 0, y: 90)),
  'EPSG:8173': ProjectAndUnProjectResult(
      Point(x: 3832374.9261409976, y: 6864556.294344704), Point(x: 0, y: 90)),
  'EPSG:8177': ProjectAndUnProjectResult(
      Point(x: 12573383.403229175, y: 22521465.109520163), Point(x: 0, y: 90)),
  'EPSG:8179': ProjectAndUnProjectResult(
      Point(x: 3010580.2176696234, y: 7040185.373915163), Point(x: 0, y: 90)),
  'EPSG:8180': ProjectAndUnProjectResult(
      Point(x: 9877211.930597758, y: 23097674.847744167), Point(x: 0, y: 90)),
  'EPSG:4994': ProjectAndUnProjectResult(
      Point(x: 4155486.7156003243, y: 1341229.2746883868),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8181': ProjectAndUnProjectResult(
      Point(x: 3013378.5853116503, y: 6877533.049658766), Point(x: 0, y: 90)),
  'EPSG:8182': ProjectAndUnProjectResult(
      Point(x: 9886392.908520725, y: 22564039.67997072), Point(x: 0, y: 90)),
  'EPSG:8184': ProjectAndUnProjectResult(
      Point(x: 3929113.1757629644, y: 6712626.8544382695), Point(x: 0, y: 90)),
  'EPSG:8185': ProjectAndUnProjectResult(
      Point(x: 12890765.47748966, y: 22023009.93872364), Point(x: 0, y: 90)),
  'EPSG:8187': ProjectAndUnProjectResult(
      Point(x: 3796339.751557811, y: 7156497.446786959), Point(x: 0, y: 90)),
  'EPSG:8189': ProjectAndUnProjectResult(
      Point(x: 12455158.00186667, y: 23479275.373399213), Point(x: 0, y: 90)),
  'EPSG:8191': ProjectAndUnProjectResult(
      Point(x: 6385132.533988685, y: 5136893.419587115),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8193': ProjectAndUnProjectResult(
      Point(x: 20948555.655217215, y: 16853291.16088273),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:4996': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8196': ProjectAndUnProjectResult(
      Point(x: 6273425.123029883, y: 5148067.887488653),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8197': ProjectAndUnProjectResult(
      Point(x: 20582062.25774571, y: 16889952.728007607),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8198': ProjectAndUnProjectResult(
      Point(x: 6276049.2952974085, y: 5077947.841716385),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8200': ProjectAndUnProjectResult(
      Point(x: 20590671.729405165, y: 16659900.544401342),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8201': ProjectAndUnProjectResult(
      Point(x: 3390618.4191545607, y: 7056596.4442245625), Point(x: 0, y: 90)),
  'EPSG:8202': ProjectAndUnProjectResult(
      Point(x: 11124053.930451838, y: 23151516.833878253), Point(x: 0, y: 90)),
  'EPSG:8203': ProjectAndUnProjectResult(
      Point(x: 6086999.10094148, y: 5065927.892679145),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:8204': ProjectAndUnProjectResult(
      Point(x: 19970429.55063884, y: 16620465.09421466),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:4998': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8205': ProjectAndUnProjectResult(
      Point(x: 3822990.361101892, y: 6996993.411303278), Point(x: 0, y: 90)),
  'EPSG:8206': ProjectAndUnProjectResult(
      Point(x: 12542594.209403375, y: 22955969.216841422), Point(x: 0, y: 90)),
  'EPSG:8207': ProjectAndUnProjectResult(
      Point(x: 6038695.637881377, y: 5116149.00293443),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8208': ProjectAndUnProjectResult(
      Point(x: 19811953.938981485, y: 16785232.186769795),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8209': ProjectAndUnProjectResult(
      Point(x: 3153672.940117676, y: 7137461.697173122), Point(x: 0, y: 90)),
  'EPSG:8210': ProjectAndUnProjectResult(
      Point(x: 10346675.304421574, y: 23416822.251727488), Point(x: 0, y: 90)),
  'EPSG:8212': ProjectAndUnProjectResult(
      Point(x: 3689988.0851689526, y: 6931430.5799844805), Point(x: 0, y: 90)),
  'EPSG:8213': ProjectAndUnProjectResult(
      Point(x: 12106235.909091806, y: 22740868.494165752), Point(x: 0, y: 90)),
  'EPSG:5011': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8214': ProjectAndUnProjectResult(
      Point(x: 6127532.902492125, y: 5063502.719266117),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:8216': ProjectAndUnProjectResult(
      Point(x: 20103414.197611663, y: 16612508.504353167),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:8218': ProjectAndUnProjectResult(
      Point(x: 3060937.2787154065, y: 6957068.465882632), Point(x: 0, y: 90)),
  'EPSG:8220': ProjectAndUnProjectResult(
      Point(x: 10042425.055252131, y: 22824982.125635523), Point(x: 0, y: 90)),
  'EPSG:8222': ProjectAndUnProjectResult(
      Point(x: 3379674.584728664, y: 6816915.478636543), Point(x: 0, y: 90)),
  'EPSG:8224': ProjectAndUnProjectResult(
      Point(x: 11088149.032900875, y: 22365163.53324931), Point(x: 0, y: 90)),
  'EPSG:8225': ProjectAndUnProjectResult(
      Point(x: 3468290.683902232, y: 7034754.514808692), Point(x: 0, y: 90)),
  'EPSG:8226': ProjectAndUnProjectResult(
      Point(x: 11378883.685214741, y: 23079857.103862435), Point(x: 0, y: 90)),
  'EPSG:5244': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8311': ProjectAndUnProjectResult(
      Point(x: -7975369.376852105, y: 4598229.7015076615),
      Point(x: 758426831.2235305, y: 261498166.30999714)),
  'EPSG:8312': ProjectAndUnProjectResult(
      Point(x: -26165910.02899352, y: 15086055.451140622),
      Point(x: 758426831.2235305, y: 261498166.30999714)),
  'EPSG:8313': ProjectAndUnProjectResult(
      Point(x: -9047651.86909182, y: 4093296.390494441),
      Point(x: 21903007.92161727, y: 8524499.952568647)),
  'EPSG:8314': ProjectAndUnProjectResult(
      Point(x: -29683897.208306756, y: 13429450.100047378),
      Point(x: 21903007.92161727, y: 8524499.952568647)),
  'EPSG:8315': ProjectAndUnProjectResult(
      Point(x: 6034114.079328784, y: 7439977.696788592),
      Point(x: 17.88805856028154, y: 46.89226406700872)),
  'EPSG:8316': ProjectAndUnProjectResult(
      Point(x: 19796962.20257186, y: 24409375.6456316),
      Point(x: 17.88805856028154, y: 46.89226406700872)),
  'EPSG:8317': ProjectAndUnProjectResult(
      Point(x: -9542274.605646268, y: 3749531.5095347357),
      Point(x: 7069759.790099894, y: 2911934.865820695)),
  'EPSG:8318': ProjectAndUnProjectResult(
      Point(x: -31306675.215375155, y: 12301612.56409034),
      Point(x: 7069759.790099894, y: 2911934.865820695)),
  'EPSG:8319': ProjectAndUnProjectResult(
      Point(x: -8542311.979663761, y: 4515564.93732704),
      Point(x: 79858529.9392508, y: 29488526.316998694)),
  'EPSG:5250': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8320': ProjectAndUnProjectResult(
      Point(x: -28025957.93853045, y: 14814845.594904987),
      Point(x: 79858529.9392508, y: 29488526.316998694)),
  'EPSG:8321': ProjectAndUnProjectResult(
      Point(x: 6157979.083731409, y: 7044076.815397696),
      Point(x: 17.88805856028154, y: 46.89226406700871)),
  'EPSG:8322': ProjectAndUnProjectResult(
      Point(x: 20203343.45056184, y: 23110488.23954283),
      Point(x: 17.88805856028154, y: 46.89226406700871)),
  'EPSG:8323': ProjectAndUnProjectResult(
      Point(x: 6596054.994927874, y: 7465325.542898033),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:8324': ProjectAndUnProjectResult(
      Point(x: 21640600.377059165, y: 24492537.87040116),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:8325': ProjectAndUnProjectResult(
      Point(x: 5885839.747371155, y: 7385243.211919462),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:8326': ProjectAndUnProjectResult(
      Point(x: 19310497.858878855, y: 24229800.564086422),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:8327': ProjectAndUnProjectResult(
      Point(x: 6064748.055779849, y: 7307447.109670261),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:8328': ProjectAndUnProjectResult(
      Point(x: 19897467.374604493, y: 23974564.008102693),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'ESRI:37004': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8329': ProjectAndUnProjectResult(
      Point(x: 6368234.417859034, y: 7234845.958448322),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8330': ProjectAndUnProjectResult(
      Point(x: 20893157.538907066, y: 23736371.254752763),
      Point(x: 17.88805856028154, y: 46.89226406700872)),
  'EPSG:8331': ProjectAndUnProjectResult(
      Point(x: -7934928.037013731, y: 4822593.757571801),
      Point(x: 1036345618.5015662, y: 354578869.8149666)),
  'EPSG:8332': ProjectAndUnProjectResult(
      Point(x: -26033228.467843737, y: 15822157.99728281),
      Point(x: 1036345618.5015662, y: 354578869.8149666)),
  'EPSG:8333': ProjectAndUnProjectResult(
      Point(x: 6033345.179830088, y: 7184801.105918447),
      Point(x: 17.88805856028154, y: 46.89226406700871)),
  'EPSG:8334': ProjectAndUnProjectResult(
      Point(x: 19794439.566421025, y: 23572182.10607994),
      Point(x: 17.88805856028154, y: 46.89226406700871)),
  'EPSG:8335': ProjectAndUnProjectResult(
      Point(x: 6336415.306628487, y: 7099051.198896116),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:8336': ProjectAndUnProjectResult(
      Point(x: 20788764.129357763, y: 23290850.39007912),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:8337': ProjectAndUnProjectResult(
      Point(x: -10056189.773874594, y: 3724599.912720571),
      Point(x: 2536611.3873870787, y: 1112250.8758671032)),
  'EPSG:5262': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8338': ProjectAndUnProjectResult(
      Point(x: -32992748.60190168, y: 12219815.986616045),
      Point(x: 2536611.3873870787, y: 1112250.8758671032)),
  'EPSG:8339': ProjectAndUnProjectResult(
      Point(x: 6469859.547738366, y: 7586148.925621023),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8340': ProjectAndUnProjectResult(
      Point(x: 21226573.31940146, y: 24888940.044687606),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8341': ProjectAndUnProjectResult(
      Point(x: 6132991.487922666, y: 7197014.0492745),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:8342': ProjectAndUnProjectResult(
      Point(x: 20121363.149402183, y: 23612250.817878544),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:8343': ProjectAndUnProjectResult(
      Point(x: -7884495.80102217, y: 4463267.0818563495),
      Point(x: 1440376520.9247227, y: 489022394.8755672)),
  'EPSG:8344': ProjectAndUnProjectResult(
      Point(x: -25867768.376057774, y: 14643264.704253115),
      Point(x: 1440376520.92472, y: 489022394.87556624)),
  'EPSG:8345': ProjectAndUnProjectResult(
      Point(x: 6514348.302995001, y: 7389846.129226663),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:8346': ProjectAndUnProjectResult(
      Point(x: 21372533.80247651, y: 24244901.998774353),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:5322': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8347': ProjectAndUnProjectResult(
      Point(x: -11513374.110879114, y: 2794604.711851623),
      Point(x: 398884.89595851535, y: 203629.51671519192)),
  'EPSG:8348': ProjectAndUnProjectResult(
      Point(x: -37773537.10918371, y: 9168650.629434457),
      Point(x: 398884.89595851535, y: 203629.51671519192)),
  'EPSG:20004': ProjectAndUnProjectResult(
      Point(x: 4262977.402920999, y: 5200101.235815557),
      Point(x: 17.888058570270495, y: 46.89226406903771)),
  'EPSG:20005': ProjectAndUnProjectResult(
      Point(x: 4805913.362838657, y: 5235854.283937308),
      Point(x: 17.888058728388472, y: 46.89226402384307)),
  'EPSG:20006': ProjectAndUnProjectResult(
      Point(x: 5349465.294601091, y: 5307424.743197788),
      Point(x: 17.888077164108278, y: 46.89226406201648)),
  'EPSG:20007': ProjectAndUnProjectResult(
      Point(x: 5894345.220306594, y: 5416207.687562138),
      Point(x: 17.888508858291356, y: 46.89229074846724)),
  'EPSG:20008': ProjectAndUnProjectResult(
      Point(x: 6441748.308090681, y: 5564265.926028976),
      Point(x: 17.89339665661175, y: 46.89274275070445)),
  'EPSG:20009': ProjectAndUnProjectResult(
      Point(x: 6993599.942504037, y: 5754282.564756225),
      Point(x: 17.930912766487186, y: 46.89707896829051)),
  'EPSG:20010': ProjectAndUnProjectResult(
      Point(x: 7552857.680709452, y: 5989465.549310994),
      Point(x: 18.163085249950498, y: 46.92853675095355)),
  'EPSG:20011': ProjectAndUnProjectResult(
      Point(x: 8123883.6942656655, y: 6273376.642920781),
      Point(x: 19.453977225641804, y: 47.12654815721369)),
  'EPSG:20012': ProjectAndUnProjectResult(
      Point(x: 8712903.296266051, y: 6609650.442058996),
      Point(x: 26.45354646467008, y: 48.31387174213733)),
  'EPSG:20013': ProjectAndUnProjectResult(
      Point(x: 9328565.153600035, y: 7001562.176153691),
      Point(x: 66.44656806390067, y: 55.68157108625792)),
  'EPSG:20014': ProjectAndUnProjectResult(
      Point(x: 9982618.784105198, y: 7451396.183664046),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20015': ProjectAndUnProjectResult(
      Point(x: 10690724.938377943, y: 7959560.102225089),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20016': ProjectAndUnProjectResult(
      Point(x: 11473414.466010679, y: 8523382.956016758),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20017': ProjectAndUnProjectResult(
      Point(x: 12357211.26602343, y: 9135528.468969345),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20018': ProjectAndUnProjectResult(
      Point(x: 13375934.92125776, y: 9781948.077873092),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20019': ProjectAndUnProjectResult(
      Point(x: 14572198.616501, y: 10439291.264915409),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20020': ProjectAndUnProjectResult(
      Point(x: 15999117.940108594, y: 11071683.97462519),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20021': ProjectAndUnProjectResult(
      Point(x: 17722246.168892596, y: 11626779.025659218),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20022': ProjectAndUnProjectResult(
      Point(x: 19821751.636044137, y: 12030975.573321657),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20023': ProjectAndUnProjectResult(
      Point(x: 22394852.78185785, y: 12183697.82416335),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20024': ProjectAndUnProjectResult(
      Point(x: 25558526.48702615, y: 11950616.349463312),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20025': ProjectAndUnProjectResult(
      Point(x: 29452505.28827122, y: 11155688.489850847),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20026': ProjectAndUnProjectResult(
      Point(x: 34242579.0760828, y: 9571887.488782195),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20027': ProjectAndUnProjectResult(
      Point(x: 40124216.87432951, y: 6910483.138041684),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20028': ProjectAndUnProjectResult(
      Point(x: 47326524.301511526, y: 2808729.8638930563),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20029': ProjectAndUnProjectResult(
      Point(x: 56116552.31342323, y: -3184188.6720379107),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20030': ProjectAndUnProjectResult(
      Point(x: 66803972.82699252, y: -11623116.237611713),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:20031': ProjectAndUnProjectResult(
      Point(x: 79746136.8250658, y: -23184946.595761795),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:20032': ProjectAndUnProjectResult(
      Point(x: 95353530.54190639, y: -38688883.46037097),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:20064': ProjectAndUnProjectResult(
      Point(x: 262977.40292099846, y: 5200101.235815557),
      Point(x: 17.88805857027049, y: 46.89226406903771)),
  'EPSG:20065': ProjectAndUnProjectResult(
      Point(x: -194086.63716134313, y: 5235854.283937308),
      Point(x: 17.888058728388476, y: 46.89226402384307)),
  'EPSG:20066': ProjectAndUnProjectResult(
      Point(x: -650534.705398909, y: 5307424.743197788),
      Point(x: 17.888077164108275, y: 46.89226406201648)),
  'EPSG:20067': ProjectAndUnProjectResult(
      Point(x: -1105654.7796934056, y: 5416207.687562138),
      Point(x: 17.88850885829136, y: 46.89229074846724)),
  'EPSG:20068': ProjectAndUnProjectResult(
      Point(x: -1558251.691909319, y: 5564265.926028976),
      Point(x: 17.89339665661175, y: 46.892742750704436)),
  'EPSG:20069': ProjectAndUnProjectResult(
      Point(x: -2006400.0574959628, y: 5754282.564756225),
      Point(x: 17.930912766487186, y: 46.89707896829051)),
  'EPSG:20070': ProjectAndUnProjectResult(
      Point(x: -2447142.3192905476, y: 5989465.549310994),
      Point(x: 18.163085249950498, y: 46.92853675095355)),
  'EPSG:20071': ProjectAndUnProjectResult(
      Point(x: -2876116.3057343345, y: 6273376.642920781),
      Point(x: 19.453977225641804, y: 47.12654815721369)),
  'EPSG:20072': ProjectAndUnProjectResult(
      Point(x: -3287096.703733949, y: 6609650.442058996),
      Point(x: 26.45354646467008, y: 48.31387174213733)),
  'EPSG:20073': ProjectAndUnProjectResult(
      Point(x: -3671434.8463999643, y: 7001562.176153691),
      Point(x: 66.44656806390067, y: 55.68157108625792)),
  'EPSG:20074': ProjectAndUnProjectResult(
      Point(x: -4017381.2158948015, y: 7451396.183664046),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20075': ProjectAndUnProjectResult(
      Point(x: -4309275.061622056, y: 7959560.102225089),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20076': ProjectAndUnProjectResult(
      Point(x: -4526585.5339893205, y: 8523382.956016758),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20077': ProjectAndUnProjectResult(
      Point(x: -4642788.733976571, y: 9135528.468969345),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20078': ProjectAndUnProjectResult(
      Point(x: -4624065.078742239, y: 9781948.077873092),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20079': ProjectAndUnProjectResult(
      Point(x: -4427801.383499, y: 10439291.264915409),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20080': ProjectAndUnProjectResult(
      Point(x: -4000882.0598914055, y: 11071683.97462519),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20081': ProjectAndUnProjectResult(
      Point(x: -3277753.8311074045, y: 11626779.025659218),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20082': ProjectAndUnProjectResult(
      Point(x: -2178248.363955864, y: 12030975.573321657),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20083': ProjectAndUnProjectResult(
      Point(x: -605147.2181421507, y: 12183697.82416335),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20084': ProjectAndUnProjectResult(
      Point(x: 1558526.4870261499, y: 11950616.349463312),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20085': ProjectAndUnProjectResult(
      Point(x: 4452505.288271218, y: 11155688.489850847),
      Point(x: -79.4107417620655, y: 89.99880783975169)),
  'EPSG:20086': ProjectAndUnProjectResult(
      Point(x: 8242579.076082804, y: 9571887.488782195),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20087': ProjectAndUnProjectResult(
      Point(x: 13124216.874329505, y: 6910483.138041684),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20088': ProjectAndUnProjectResult(
      Point(x: 19326524.301511526, y: 2808729.8638930563),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20089': ProjectAndUnProjectResult(
      Point(x: 27116552.31342323, y: -3184188.6720379107),
      Point(x: double.nan, y: double.nan)),
  'EPSG:20090': ProjectAndUnProjectResult(
      Point(x: 36803972.82699252, y: -11623116.237611713),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:20091': ProjectAndUnProjectResult(
      Point(x: 48746136.82506581, y: -23184946.595761795),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:20092': ProjectAndUnProjectResult(
      Point(x: 63353530.541906394, y: -38688883.46037097),
      Point(x: -79.4107417620655, y: -89.9988078701379)),
  'EPSG:20135': ProjectAndUnProjectResult(
      Point(x: -193989.9238916505, y: 5233426.459265212),
      Point(x: 17.888058562996562, y: 46.892264062395796)),
  'EPSG:20136': ProjectAndUnProjectResult(
      Point(x: -650265.0299370578, y: 5304983.663505262),
      Point(x: 17.888058562996562, y: 46.89226406239579)),
  'EPSG:20137': ProjectAndUnProjectResult(
      Point(x: -1105212.1734179943, y: 5413740.153995019),
      Point(x: 17.88805856299655, y: 46.89226406239581)),
  'EPSG:20138': ProjectAndUnProjectResult(
      Point(x: -1557636.3361236535, y: 5561756.685279963),
      Point(x: 17.888058562996566, y: 46.89226406239581)),
  'EPSG:20248': ProjectAndUnProjectResult(
      Point(x: -4822751.165661082, y: 19697367.642678708),
      Point(x: 17.888058560873326, y: 46.892264058133314)),
  'EPSG:20249': ProjectAndUnProjectResult(
      Point(x: -4821090.5583184445, y: 20321829.155464903),
      Point(x: 17.888058560873056, y: 46.89226405813332)),
  'EPSG:20250': ProjectAndUnProjectResult(
      Point(x: -4731278.053938921, y: 20936768.49047432),
      Point(x: 17.888058560872967, y: 46.89226405813347)),
  'EPSG:20251': ProjectAndUnProjectResult(
      Point(x: -4559033.315478885, y: 21525108.384023916),
      Point(x: 17.888058560873134, y: 46.89226405813354)),
  'EPSG:20252': ProjectAndUnProjectResult(
      Point(x: -4314423.77150705, y: 22073130.8546136),
      Point(x: 17.888058560873237, y: 46.89226405813349)),
  'EPSG:32611': ProjectAndUnProjectResult(
      Point(x: 3875003.0727375885, y: 13725397.247930216),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:20253': ProjectAndUnProjectResult(
      Point(x: -4009897.44078305, y: 22571539.4712594),
      Point(x: 17.888058560873244, y: 46.89226405813344)),
  'EPSG:20254': ProjectAndUnProjectResult(
      Point(x: -3658317.68984203, y: 23015435.754052475),
      Point(x: 17.88805856087322, y: 46.89226405813347)),
  'EPSG:20255': ProjectAndUnProjectResult(
      Point(x: -3271501.7949165944, y: 23403537.912206084),
      Point(x: 17.888058560873176, y: 46.89226405813347)),
  'EPSG:20256': ProjectAndUnProjectResult(
      Point(x: -2859419.6827840405, y: 23737093.2434332),
      Point(x: 17.888058560873198, y: 46.89226405813347)),
  'EPSG:20257': ProjectAndUnProjectResult(
      Point(x: -2429951.5607453613, y: 24018832.01252198),
      Point(x: 17.888058560873173, y: 46.89226405813344)),
  'EPSG:20258': ProjectAndUnProjectResult(
      Point(x: -1989005.190430156, y: 24252136.254723914),
      Point(x: 17.888058560873148, y: 46.892264058133435)),
  'EPSG:20348': ProjectAndUnProjectResult(
      Point(x: -4822791.002786585, y: 19697382.612910822),
      Point(x: 17.88805856059953, y: 46.89226405709136)),
  'EPSG:20349': ProjectAndUnProjectResult(
      Point(x: -4821127.850081333, y: 20321849.644347027),
      Point(x: 17.888058560599188, y: 46.89226405709135)),
  'EPSG:20350': ProjectAndUnProjectResult(
      Point(x: -4731311.7623947095, y: 20936793.797010742),
      Point(x: 17.88805856059919, y: 46.89226405709152)),
  'EPSG:5332': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:20351': ProjectAndUnProjectResult(
      Point(x: -4559062.700979455, y: 21525137.557324313),
      Point(x: 17.888058560599312, y: 46.892264057091595)),
  'EPSG:20352': ProjectAndUnProjectResult(
      Point(x: -4314448.44425732, y: 22073162.84725692),
      Point(x: 17.888058560599404, y: 46.89226405709155)),
  'EPSG:20353': ProjectAndUnProjectResult(
      Point(x: -4009917.3324703127, y: 22571573.28187865),
      Point(x: 17.888058560599433, y: 46.8922640570915)),
  'EPSG:20354': ProjectAndUnProjectResult(
      Point(x: -3658332.974011932, y: 23015470.523424894),
      Point(x: 17.88805856059938, y: 46.892264057091474)),
  'EPSG:20355': ProjectAndUnProjectResult(
      Point(x: -3271512.7926216377, y: 23403572.964866444),
      Point(x: 17.888058560599383, y: 46.8922640570915)),
  'EPSG:20356': ProjectAndUnProjectResult(
      Point(x: -2859426.7798491446, y: 23737128.0867358),
      Point(x: 17.888058560599355, y: 46.89226405709148)),
  'EPSG:20357': ProjectAndUnProjectResult(
      Point(x: -2429955.147843014, y: 24018866.311389424),
      Point(x: 17.888058560599404, y: 46.89226405709152)),
  'EPSG:20358': ProjectAndUnProjectResult(
      Point(x: -1989005.6260110196, y: 24252169.797387328),
      Point(x: 17.888058560599383, y: 46.8922640570915)),
  'EPSG:20436': ProjectAndUnProjectResult(
      Point(x: -650079.094171531, y: 5305197.0403558845),
      Point(x: 17.88805858437824, y: 46.89226406096707)),
  'EPSG:20437': ProjectAndUnProjectResult(
      Point(x: -1105039.9087669004, y: 5413935.769729746),
      Point(x: 17.88805858437824, y: 46.89226406096708)),
  'EPSG:20438': ProjectAndUnProjectResult(
      Point(x: -1557479.1555742663, y: 5561933.580478198),
      Point(x: 17.888058584378253, y: 46.89226406096709)),
  'EPSG:20439': ProjectAndUnProjectResult(
      Point(x: -2005475.3083187179, y: 5751864.0950699095),
      Point(x: 17.888058584378264, y: 46.892264060967065)),
  'EPSG:20440': ProjectAndUnProjectResult(
      Point(x: -2446090.505052628, y: 5986900.965139546),
      Point(x: 17.88805858437824, y: 46.89226406096708)),
  'EPSG:20499': ProjectAndUnProjectResult(
      Point(x: -2005475.3083187179, y: 5751864.0950699095),
      Point(x: 17.888058584378264, y: 46.892264060967065)),
  'EPSG:20538': ProjectAndUnProjectResult(
      Point(x: -1557467.2944370413, y: 5561894.6787379375),
      Point(x: 17.888058583628546, y: 46.89226405570901)),
  'EPSG:20539': ProjectAndUnProjectResult(
      Point(x: -2005452.48961449, y: 5751823.135658465),
      Point(x: 17.88805858362855, y: 46.89226405570901)),
  'EPSG:20790': ProjectAndUnProjectResult(
      Point(x: 2176382.456040799, y: 1441499.218726666),
      Point(x: 17.884530474033223, y: 46.8925636667179)),
  'EPSG:20791': ProjectAndUnProjectResult(
      Point(x: 1976382.4560407992, y: 1141499.218726666),
      Point(x: 17.884530474033223, y: 46.8925636667179)),
  'EPSG:20822': ProjectAndUnProjectResult(
      Point(x: 5314046.845036607, y: 17922886.748473905),
      Point(x: 17.888058523417776, y: 46.892264078954796)),
  'EPSG:20823': ProjectAndUnProjectResult(
      Point(x: 5009508.15376271, y: 17424533.563654304),
      Point(x: 17.888058523417754, y: 46.89226407895474)),
  'EPSG:20824': ProjectAndUnProjectResult(
      Point(x: 4657924.722954208, y: 16980687.580012858),
      Point(x: 17.888058523417737, y: 46.89226407895473)),
  'EPSG:20934': ProjectAndUnProjectResult(
      Point(x: 262992.96759922017, y: 15198010.00214612),
      Point(x: 17.88805852597426, y: 46.892263823762725)),
  'EPSG:20935': ProjectAndUnProjectResult(
      Point(x: -193871.89026613836, y: 15233756.29884258),
      Point(x: 17.88805852597426, y: 46.89226382376275)),
  'EPSG:20936': ProjectAndUnProjectResult(
      Point(x: -650120.138856434, y: 15305306.58542673),
      Point(x: 17.888058525974262, y: 46.89226382376273)),
  'EPSG:21035': ProjectAndUnProjectResult(
      Point(x: -193955.47410965525, y: 15233778.733564388),
      Point(x: 17.888058595929035, y: 46.89226381715768)),
  'EPSG:21036': ProjectAndUnProjectResult(
      Point(x: -650202.5589464768, y: 15305335.772070814),
      Point(x: 17.888058595929035, y: 46.892263817157705)),
  'EPSG:21037': ProjectAndUnProjectResult(
      Point(x: -1105120.3338509805, y: 15414091.416847412),
      Point(x: 17.888058595929028, y: 46.89226381715772)),
  'EPSG:21095': ProjectAndUnProjectResult(
      Point(x: -193955.47410965525, y: 5233778.733564389),
      Point(x: 17.888058595929035, y: 46.892263817157705)),
  'EPSG:21096': ProjectAndUnProjectResult(
      Point(x: -650202.5589464768, y: 5305335.772070815),
      Point(x: 17.888058595929035, y: 46.892263817157705)),
  'EPSG:21097': ProjectAndUnProjectResult(
      Point(x: -1105120.3338509805, y: 5414091.416847412),
      Point(x: 17.888058595929028, y: 46.89226381715772)),
  'EPSG:21100': ProjectAndUnProjectResult(
      Point(x: 21774401.140130598, y: 6774822.740257204),
      Point(x: 17.888059883263967, y: 46.89226423543208)),
  'EPSG:21148': ProjectAndUnProjectResult(
      Point(x: -4822119.754631928, y: 19697326.673446048),
      Point(x: 17.888059883264063, y: 46.892264235432016)),
  'EPSG:21149': ProjectAndUnProjectResult(
      Point(x: -4820306.9822267555, y: 20321705.186393723),
      Point(x: 17.88805988326382, y: 46.89226423543201)),
  'EPSG:21150': ProjectAndUnProjectResult(
      Point(x: -4730358.896517999, y: 20936531.680758826),
      Point(x: 17.888059883263768, y: 46.892264235432165)),
  'EPSG:21291': ProjectAndUnProjectResult(
      Point(x: 5526165.2874376215, y: 9002402.71657912),
      Point(x: 45, y: double.nan)),
  'EPSG:21292': ProjectAndUnProjectResult(
      Point(x: 5115430.587639164, y: 7374050.501041679),
      Point(x: 45, y: double.nan)),
  'EPSG:21413': ProjectAndUnProjectResult(
      Point(x: 9328573.28048693, y: 7001532.8404073985),
      Point(x: 66.44236062758634, y: 55.68084177388956)),
  'EPSG:21414': ProjectAndUnProjectResult(
      Point(x: 9982623.296146361, y: 7451365.034696903),
      Point(x: 45, y: double.nan)),
  'EPSG:21415': ProjectAndUnProjectResult(
      Point(x: 10690724.97687363, y: 7959527.594984778),
      Point(x: 45, y: double.nan)),
  'EPSG:21416': ProjectAndUnProjectResult(
      Point(x: 11473408.996789828, y: 8523349.850202367),
      Point(x: 45, y: double.nan)),
  'EPSG:21417': ProjectAndUnProjectResult(
      Point(x: 12357199.062648399, y: 9135495.940806963),
      Point(x: 45, y: double.nan)),
  'EPSG:21418': ProjectAndUnProjectResult(
      Point(x: 13375914.550852004, y: 9781917.858713986),
      Point(x: 45, y: double.nan)),
  'EPSG:21419': ProjectAndUnProjectResult(
      Point(x: 14572168.429462679, y: 10439265.810641618),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21420': ProjectAndUnProjectResult(
      Point(x: 15999076.065135233, y: 11071666.670084072),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21421': ProjectAndUnProjectResult(
      Point(x: 17722190.514904037, y: 11626774.428577727),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21422': ProjectAndUnProjectResult(
      Point(x: 19821679.902753077, y: 12030989.702372357),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21423': ProjectAndUnProjectResult(
      Point(x: 22394762.480899453, y: 12183738.496068094),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21453': ProjectAndUnProjectResult(
      Point(x: -3671426.71951307, y: 7001532.8404073985),
      Point(x: 66.44236062758634, y: 55.68084177388956)),
  'EPSG:21454': ProjectAndUnProjectResult(
      Point(x: -4017376.703853639, y: 7451365.034696903),
      Point(x: 45, y: double.nan)),
  'EPSG:21455': ProjectAndUnProjectResult(
      Point(x: -4309275.023126369, y: 7959527.594984778),
      Point(x: 45, y: double.nan)),
  'EPSG:21456': ProjectAndUnProjectResult(
      Point(x: -4526591.003210171, y: 8523349.850202367),
      Point(x: 45, y: double.nan)),
  'EPSG:21457': ProjectAndUnProjectResult(
      Point(x: -4642800.937351601, y: 9135495.940806963),
      Point(x: 45, y: double.nan)),
  'EPSG:21458': ProjectAndUnProjectResult(
      Point(x: -4624085.449147995, y: 9781917.858713986),
      Point(x: 45, y: double.nan)),
  'EPSG:21459': ProjectAndUnProjectResult(
      Point(x: -4427831.570537322, y: 10439265.810641618),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21460': ProjectAndUnProjectResult(
      Point(x: -4000923.934864768, y: 11071666.670084072),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21461': ProjectAndUnProjectResult(
      Point(x: -3277809.485095963, y: 11626774.428577727),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21462': ProjectAndUnProjectResult(
      Point(x: -2178320.097246922, y: 12030989.702372357),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21463': ProjectAndUnProjectResult(
      Point(x: -605237.519100545, y: 12183738.496068094),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21473': ProjectAndUnProjectResult(
      Point(x: -3671426.71951307, y: 7001532.8404073985),
      Point(x: 66.44236062758634, y: 55.68084177388956)),
  'EPSG:21474': ProjectAndUnProjectResult(
      Point(x: -4017376.703853639, y: 7451365.034696903),
      Point(x: 45, y: double.nan)),
  'EPSG:21475': ProjectAndUnProjectResult(
      Point(x: -4309275.023126369, y: 7959527.594984778),
      Point(x: 45, y: double.nan)),
  'EPSG:21476': ProjectAndUnProjectResult(
      Point(x: -4526591.003210171, y: 8523349.850202367),
      Point(x: 45, y: double.nan)),
  'EPSG:21477': ProjectAndUnProjectResult(
      Point(x: -4642800.937351601, y: 9135495.940806963),
      Point(x: 45, y: double.nan)),
  'EPSG:21478': ProjectAndUnProjectResult(
      Point(x: -4624085.449147995, y: 9781917.858713986),
      Point(x: 45, y: double.nan)),
  'EPSG:21479': ProjectAndUnProjectResult(
      Point(x: -4427831.570537322, y: 10439265.810641618),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21480': ProjectAndUnProjectResult(
      Point(x: -4000923.934864768, y: 11071666.670084072),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21481': ProjectAndUnProjectResult(
      Point(x: -3277809.485095963, y: 11626774.428577727),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21482': ProjectAndUnProjectResult(
      Point(x: -2178320.097246922, y: 12030989.702372357),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21483': ProjectAndUnProjectResult(
      Point(x: -605237.519100545, y: 12183738.496068094),
      Point(x: -84.15716911392471, y: 89.9986104387541)),
  'EPSG:21500': ProjectAndUnProjectResult(
      Point(x: 1176624.6808532546, y: -175731.81287494022),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:21780': ProjectAndUnProjectResult(
      Point(x: 793998.9521233882, y: 46372.88042945036),
      Point(x: 17.888058573428914, y: 46.89226407167193)),
  'EPSG:21781': ProjectAndUnProjectResult(
      Point(x: 1393998.952123363, y: 246372.88042944617),
      Point(x: 17.888058573428914, y: 46.89226407167193)),
  'EPSG:21782': ProjectAndUnProjectResult(
      Point(x: 793998.9521233632, y: 46372.88042944617),
      Point(x: 17.888058573428914, y: 46.89226407167193)),
  'EPSG:21817': ProjectAndUnProjectResult(
      Point(x: 5735411.93503156, y: 10914072.386430372),
      Point(x: 17.888058466716004, y: 46.89226426167436)),
  'EPSG:21818': ProjectAndUnProjectResult(
      Point(x: 5821944.492666505, y: 10298570.137290766),
      Point(x: 17.888058466715936, y: 46.89226426167422)),
  'EPSG:21891': ProjectAndUnProjectResult(
      Point(x: 5822486.707817163, y: 11130901.20700542),
      Point(x: 44.71868092095189, y: 89.9961317687478)),
  'EPSG:21892': ProjectAndUnProjectResult(
      Point(x: 5980547.218128094, y: 10805951.985049851),
      Point(x: 44.71868092095189, y: 89.9961317687478)),
  'EPSG:21893': ProjectAndUnProjectResult(
      Point(x: 6083896.608132482, y: 10476987.143738788),
      Point(x: 45, y: double.nan)),
  'EPSG:21894': ProjectAndUnProjectResult(
      Point(x: 6139234.891233048, y: 10148553.39473207),
      Point(x: 45, y: double.nan)),
  'EPSG:21896': ProjectAndUnProjectResult(
      Point(x: 5822486.707817163, y: 11130901.20700542),
      Point(x: 44.71868092095189, y: 89.9961317687478)),
  'EPSG:21897': ProjectAndUnProjectResult(
      Point(x: 5980547.218128094, y: 10805951.985049851),
      Point(x: 44.71868092095189, y: 89.9961317687478)),
  'EPSG:21898': ProjectAndUnProjectResult(
      Point(x: 6083896.608132482, y: 10476987.143738788),
      Point(x: 45, y: double.nan)),
  'EPSG:21899': ProjectAndUnProjectResult(
      Point(x: 6139234.891233048, y: 10148553.39473207),
      Point(x: 45, y: double.nan)),
  'EPSG:22032': ProjectAndUnProjectResult(
      Point(x: 1177192.9011734154, y: 15231789.81987983),
      Point(x: 17.888058334685734, y: 46.892263873371036)),
  'EPSG:22033': ProjectAndUnProjectResult(
      Point(x: 720312.0328665744, y: 15197333.936080996),
      Point(x: 17.888058334685738, y: 46.892263873371036)),
  'EPSG:22091': ProjectAndUnProjectResult(
      Point(x: 986869.6967178873, y: 15213141.493698597),
      Point(x: 17.88805833010009, y: 46.89226386729995)),
  'EPSG:22092': ProjectAndUnProjectResult(
      Point(x: 948796.1063752132, y: 15210149.96922244),
      Point(x: 17.88805833284379, y: 46.89226386961646)),
  'EPSG:22171': ProjectAndUnProjectResult(
      Point(x: 6558199.158144748, y: 20088569.71969266), Point(x: 0, y: 90)),
  'EPSG:32612': ProjectAndUnProjectResult(
      Point(x: 4286275.534202199, y: 13389860.739146797),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:22172': ProjectAndUnProjectResult(
      Point(x: 7627603.63873359, y: 19759444.393447872),
      Point(x: -14563147143.451214, y: 3188443837.8198547)),
  'EPSG:22173': ProjectAndUnProjectResult(
      Point(x: 8653224.300104942, y: 19433509.59298006),
      Point(x: -39521738.61122337, y: 8695128.741618276)),
  'EPSG:22174': ProjectAndUnProjectResult(
      Point(x: 9640628.03418475, y: 19113941.421131436),
      Point(x: -1685042.2535845686, y: 369929.7983349795)),
  'EPSG:22175': ProjectAndUnProjectResult(
      Point(x: 10594786.08114166, y: 18803251.941004626),
      Point(x: -187879.9335986475, y: 41002.61340262109)),
  'EPSG:22176': ProjectAndUnProjectResult(
      Point(x: 11520125.412785191, y: 18503383.42313258),
      Point(x: -33811.090133644844, y: 7380.196889868265)),
  'EPSG:22177': ProjectAndUnProjectResult(
      Point(x: 12420576.82986139, y: 18215792.792734504),
      Point(x: -7903.831319008155, y: 1789.9479071178757)),
  'EPSG:22181': ProjectAndUnProjectResult(
      Point(x: 6558199.15814112, y: 20088569.719824612), Point(x: 0, y: 90)),
  'EPSG:22182': ProjectAndUnProjectResult(
      Point(x: 7627603.638721798, y: 19759444.393584996),
      Point(x: -14563147131.784145, y: 3188443835.3104944)),
  'EPSG:22183': ProjectAndUnProjectResult(
      Point(x: 8653224.300086465, y: 19433509.593122367),
      Point(x: -39521738.5994028, y: 8695128.739126878)),
  'EPSG:22184': ProjectAndUnProjectResult(
      Point(x: 9640628.034160899, y: 19113941.421278868),
      Point(x: -1685042.253300147, y: 369929.79827663914)),
  'EPSG:22185': ProjectAndUnProjectResult(
      Point(x: 10594786.0811136, y: 18803251.941157054),
      Point(x: -187879.9335777107, y: 41002.613398455236)),
  'EPSG:22186': ProjectAndUnProjectResult(
      Point(x: 11520125.41275394, y: 18503383.423289828),
      Point(x: -33811.090130915225, y: 7380.196889341112)),
  'EPSG:22187': ProjectAndUnProjectResult(
      Point(x: 12420576.829827838, y: 18215792.79289636),
      Point(x: -7903.831318506849, y: 1789.947907023519)),
  'EPSG:22191': ProjectAndUnProjectResult(
      Point(x: 6558534.121290168, y: 20089010.094499655),
      Point(x: 137.41950921658076, y: 89.99820053262447)),
  'EPSG:22192': ProjectAndUnProjectResult(
      Point(x: 7627912.361139339, y: 19759860.055252463),
      Point(x: 45, y: double.nan)),
  'EPSG:22193': ProjectAndUnProjectResult(
      Point(x: 8653507.61669164, y: 19433904.376927037),
      Point(x: 45, y: double.nan)),
  'EPSG:22194': ProjectAndUnProjectResult(
      Point(x: 9640886.800785124, y: 19114318.70612948),
      Point(x: 45, y: double.nan)),
  'EPSG:22195': ProjectAndUnProjectResult(
      Point(x: 10595021.161234654, y: 18803614.694944397),
      Point(x: 45, y: double.nan)),
  'EPSG:22196': ProjectAndUnProjectResult(
      Point(x: 11520337.666243229, y: 18503734.24509125),
      Point(x: 45, y: double.nan)),
  'EPSG:22197': ProjectAndUnProjectResult(
      Point(x: 12420767.103514891, y: 18216133.95221853),
      Point(x: 45, y: double.nan)),
  'EPSG:22234': ProjectAndUnProjectResult(
      Point(x: 263012.2153885733, y: 15198008.697967894),
      Point(x: 17.88805851040196, y: 46.89226382542354)),
  'EPSG:22235': ProjectAndUnProjectResult(
      Point(x: -193852.69970459363, y: 15233753.505258016),
      Point(x: 17.88805851040196, y: 46.89226382542354)),
  'EPSG:22236': ProjectAndUnProjectResult(
      Point(x: -650101.0296436828, y: 15305302.258695006),
      Point(x: 17.888058510401958, y: 46.89226382542353)),
  'EPSG:22275': ProjectAndUnProjectResult(
      Point(x: 220144.73426353507, y: 5199440.622867489),
      Point(x: 17.888058510423235, y: 46.89226382537031)),
  'EPSG:22277': ProjectAndUnProjectResult(
      Point(x: 67736.95745847678, y: 5195770.542987711),
      Point(x: 17.88805851040201, y: 46.892263825423484)),
  'EPSG:22279': ProjectAndUnProjectResult(
      Point(x: -84676.19166841115, y: 5195986.42073681),
      Point(x: 17.88805851040178, y: 46.89226382542335)),
  'EPSG:22281': ProjectAndUnProjectResult(
      Point(x: -237082.61766123463, y: 5200088.73346243),
      Point(x: 17.888058510372446, y: 46.89226382534054)),
  'EPSG:22283': ProjectAndUnProjectResult(
      Point(x: -389469.82914270804, y: 5208086.547379509),
      Point(x: 17.888058510666365, y: 46.892263823809344)),
  'EPSG:22285': ProjectAndUnProjectResult(
      Point(x: -541824.2222720046, y: 5219997.511490319),
      Point(x: 17.88805852434154, y: 46.892263814096154)),
  'EPSG:22287': ProjectAndUnProjectResult(
      Point(x: -694130.35311062, y: 5235847.844631069),
      Point(x: 17.88805866814209, y: 46.8922637792668)),
  'EPSG:22289': ProjectAndUnProjectResult(
      Point(x: -846370.1917657558, y: 5255672.313497574),
      Point(x: 17.88805954343561, y: 46.89226369940145)),
  'EPSG:22291': ProjectAndUnProjectResult(
      Point(x: -998522.3511807241, y: 5279514.198457728),
      Point(x: 17.88806340276551, y: 46.89226360934863)),
  'EPSG:22293': ProjectAndUnProjectResult(
      Point(x: -1150561.2834418882, y: 5307425.242913828),
      Point(x: 17.88807710440632, y: 46.892263800891186)),
  'EPSG:22300': null /* blacklist */,
  'EPSG:22332': ProjectAndUnProjectResult(
      Point(x: 1176859.1682733605, y: 5231186.641959781),
      Point(x: 17.888058534550296, y: 46.89226396964504)),
  'EPSG:22391': ProjectAndUnProjectResult(
      Point(x: 1119500.2645786216, y: 1541790.4671300447),
      Point(x: 17.888058534550296, y: 46.892263969644986)),
  'EPSG:22392': ProjectAndUnProjectResult(
      Point(x: 1126407.6150191748, y: 1847114.7670971162),
      Point(x: 17.888058534550296, y: 46.892263969645)),
  'EPSG:22521': ProjectAndUnProjectResult(
      Point(x: 5558926.249467454, y: 18470896.183078445),
      Point(x: 17.88805851382678, y: 46.892264065441935)),
  'EPSG:22522': ProjectAndUnProjectResult(
      Point(x: 5314290.4192457525, y: 17922899.083457507),
      Point(x: 17.888058513826913, y: 46.892264065441914)),
  'EPSG:22523': ProjectAndUnProjectResult(
      Point(x: 5009744.300059951, y: 17424515.92978483),
      Point(x: 17.88805851382688, y: 46.89226406544184)),
  'EPSG:22524': ProjectAndUnProjectResult(
      Point(x: 4658149.77662085, y: 16980643.79323323),
      Point(x: 17.888058513826838, y: 46.892264065441836)),
  'EPSG:22525': ProjectAndUnProjectResult(
      Point(x: 4271322.628677363, y: 16592563.855843954),
      Point(x: 17.88805851382682, y: 46.892264065441836)),
  'EPSG:22700': ProjectAndUnProjectResult(
      Point(x: -1209653.989462059, y: 1816117.8149505872),
      Point(x: 17.888058563233916, y: 46.8922640653222)),
  'EPSG:22770': ProjectAndUnProjectResult(
      Point(x: -1209653.989462059, y: 1816117.8149505872),
      Point(x: 17.888058563233916, y: 46.8922640653222)),
  'EPSG:22780': ProjectAndUnProjectResult(
      Point(x: -1634162.8158513, y: 1615233.2285455111),
      Point(x: 17.888058563233912, y: 46.8922640653223)),
  'EPSG:22832': ProjectAndUnProjectResult(
      Point(x: 1176923.0110032805, y: 5231361.062616964),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:22991': ProjectAndUnProjectResult(
      Point(x: -1002721.9861235754, y: 3119237.3518837616),
      Point(x: 17.88811889074069, y: 46.892265653208206)),
  'EPSG:22992': ProjectAndUnProjectResult(
      Point(x: -383773.28752670775, y: 2769276.276746139),
      Point(x: 17.88806346832421, y: 46.8922638588602)),
  'EPSG:22993': ProjectAndUnProjectResult(
      Point(x: 5632.832389040384, y: 2115600.1999049373),
      Point(x: 17.88805872086583, y: 46.89226402217269)),
  'EPSG:5341': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:22994': ProjectAndUnProjectResult(
      Point(x: 5632.832389040384, y: 3115600.1999049373),
      Point(x: 17.88805872086583, y: 46.89226402217269)),
  'EPSG:23028': ProjectAndUnProjectResult(
      Point(x: 2989037.829811718, y: 5744254.669223934),
      Point(x: 17.888058565321913, y: 46.89226407177291)),
  'EPSG:23029': ProjectAndUnProjectResult(
      Point(x: 2540848.3399694227, y: 5555921.722669183),
      Point(x: 17.888058565321916, y: 46.89226407177292)),
  'EPSG:23030': ProjectAndUnProjectResult(
      Point(x: 2088301.4982777836, y: 5409412.561746567),
      Point(x: 17.888058565321927, y: 46.892264071772935)),
  'EPSG:23031': ProjectAndUnProjectResult(
      Point(x: 1633287.454190746, y: 5302074.878754151),
      Point(x: 17.88805856532192, y: 46.892264071772935)),
  'EPSG:23032': ProjectAndUnProjectResult(
      Point(x: 1176979.090281974, y: 5231872.204185756),
      Point(x: 17.88805856532191, y: 46.892264071772914)),
  'EPSG:23033': ProjectAndUnProjectResult(
      Point(x: 720074.6940542399, y: 5197435.292853496),
      Point(x: 17.888058565321924, y: 46.89226407177292)),
  'EPSG:23034': ProjectAndUnProjectResult(
      Point(x: 263004.3000283706, y: 5198082.725444168),
      Point(x: 17.888058565321924, y: 46.892264071772914)),
  'EPSG:23035': ProjectAndUnProjectResult(
      Point(x: -193886.77418761922, y: 5233827.3691236405),
      Point(x: 17.888058565321927, y: 46.892264071772935)),
  'EPSG:23036': ProjectAndUnProjectResult(
      Point(x: -650161.9297040745, y: 5305376.277805224),
      Point(x: 17.888058565321927, y: 46.89226407177292)),
  'EPSG:5352': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:23037': ProjectAndUnProjectResult(
      Point(x: -1105109.1728897947, y: 5414123.893329181),
      Point(x: 17.888058565321916, y: 46.89226407177292)),
  'EPSG:23038': ProjectAndUnProjectResult(
      Point(x: -1557533.6517030364, y: 5562130.663283652),
      Point(x: 17.88805856532192, y: 46.892264071772935)),
  'EPSG:23090': ProjectAndUnProjectResult(
      Point(x: 1861015.8906361766, y: 5350989.865132068),
      Point(x: 17.887966662085727, y: 46.892267205330604)),
  'EPSG:23095': ProjectAndUnProjectResult(
      Point(x: 1481286.3531255915, y: 5274629.510778771),
      Point(x: 17.888054395605916, y: 46.892263866130484)),
  'EPSG:23239': ProjectAndUnProjectResult(
      Point(x: -2005742.1335449559, y: 5751608.187208896),
      Point(x: 17.888058583470187, y: 46.89226407422391)),
  'EPSG:23240': ProjectAndUnProjectResult(
      Point(x: -2446349.294537417, y: 5986675.489867264),
      Point(x: 17.88805858347019, y: 46.89226407422393)),
  'EPSG:23433': ProjectAndUnProjectResult(
      Point(x: 720011.5225392925, y: 5196929.211828649),
      Point(x: 17.888058560281515, y: 46.892264067008774)),
  'EPSG:23700': ProjectAndUnProjectResult(
      Point(x: 561651.8408065989, y: 172658.61998377228),
      Point(x: 17.888058565574852, y: 46.89226406698969)),
  'EPSG:23830': ProjectAndUnProjectResult(
      Point(x: -4865803.87353834, y: 10171445.892459726),
      Point(x: 86801.12439229246, y: 18902.901110545685)),
  'EPSG:23831': ProjectAndUnProjectResult(
      Point(x: -4924409.819516362, y: 10477709.171074785),
      Point(x: 612358.6101960705, y: 134106.8769964249)),
  'EPSG:23832': ProjectAndUnProjectResult(
      Point(x: -4951719.971071311, y: 10793740.870434482),
      Point(x: 8679839.573799483, y: 1909300.050652217)),
  'EPSG:23833': ProjectAndUnProjectResult(
      Point(x: -4943001.164361036, y: 11117282.460213631),
      Point(x: 631489570.7011461, y: 138679560.43961534)),
  'EPSG:23834': ProjectAndUnProjectResult(
      Point(x: -4892946.907632945, y: 11445452.767017543),
      Point(x: 447699232839297.1, y: 97370524608020.88)),
  'EPSG:23835': ProjectAndUnProjectResult(
      Point(x: -4795624.059735097, y: 11774647.774981525), Point(x: 0, y: 90)),
  'EPSG:23836': ProjectAndUnProjectResult(
      Point(x: -4644416.030963411, y: 12100429.457585078), Point(x: 0, y: 90)),
  'EPSG:23837': ProjectAndUnProjectResult(
      Point(x: -4431962.384381246, y: 12417402.863277849), Point(x: 0, y: 90)),
  'EPSG:23838': ProjectAndUnProjectResult(
      Point(x: -4150094.7157475958, y: 12719080.650741648), Point(x: 0, y: 90)),
  'EPSG:23839': ProjectAndUnProjectResult(
      Point(x: -3789768.690190188, y: 12997734.242840523), Point(x: 0, y: 90)),
  'EPSG:23840': ProjectAndUnProjectResult(
      Point(x: -3340992.1137596876, y: 13244230.741538242), Point(x: 0, y: 90)),
  'EPSG:26709': ProjectAndUnProjectResult(
      Point(x: 3005470.784886458, y: 14243857.557223286),
      Point(x: 17.88805856028149, y: 46.89226404782314)),
  'EPSG:23841': ProjectAndUnProjectResult(
      Point(x: -2792748.9180013267, y: 13447854.719289873), Point(x: 0, y: 90)),
  'EPSG:23842': ProjectAndUnProjectResult(
      Point(x: -2132918.9356801813, y: 13596113.975641776), Point(x: 0, y: 90)),
  'EPSG:23843': ProjectAndUnProjectResult(
      Point(x: -1348193.3457963404, y: 13674528.321001673), Point(x: 0, y: 90)),
  'EPSG:23844': ProjectAndUnProjectResult(
      Point(x: -423985.6660262288, y: 13666400.4227679), Point(x: 0, y: 90)),
  'EPSG:23845': ProjectAndUnProjectResult(
      Point(x: 655661.8292735498, y: 13552567.722234422), Point(x: 0, y: 90)),
  'EPSG:23846': ProjectAndUnProjectResult(
      Point(x: -4566628.91119386, y: 8492233.542398471),
      Point(x: 17.888058560387368, y: 46.89226406677024)),
  'EPSG:23847': ProjectAndUnProjectResult(
      Point(x: -4735950.01173549, y: 9081809.695442988),
      Point(x: 17.88805856038749, y: 46.892264066770174)),
  'EPSG:23848': ProjectAndUnProjectResult(
      Point(x: -4822542.241744762, y: 9697396.328949524),
      Point(x: 17.88805856038743, y: 46.89226406677)),
  'EPSG:23849': ProjectAndUnProjectResult(
      Point(x: -4820879.692098697, y: 10321827.779474681),
      Point(x: 17.88805856038718, y: 46.89226406677001)),
  'EPSG:23850': ProjectAndUnProjectResult(
      Point(x: -4731071.426738424, y: 10936737.656391915),
      Point(x: 17.888058560387105, y: 46.89226406677015)),
  'EPSG:23851': ProjectAndUnProjectResult(
      Point(x: -4558836.397882137, y: 11525050.490865791),
      Point(x: 17.888058560387243, y: 46.89226406677023)),
  'EPSG:23852': ProjectAndUnProjectResult(
      Point(x: -4314240.735989639, y: 12073049.54876158),
      Point(x: 17.88805856038736, y: 46.892264066770196)),
  'EPSG:23853': ProjectAndUnProjectResult(
      Point(x: -4009730.9487883886, y: 12571438.957204472),
      Point(x: 17.888058560387332, y: 46.89226406677013)),
  'EPSG:23866': ProjectAndUnProjectResult(
      Point(x: -4566585.2237567445, y: 8492222.44195507),
      Point(x: 17.88805856028155, y: 46.89226406700888)),
  'EPSG:23867': ProjectAndUnProjectResult(
      Point(x: -4735902.874809236, y: 9081793.077999711),
      Point(x: 17.888058560281717, y: 46.89226406700881)),
  'EPSG:23868': ProjectAndUnProjectResult(
      Point(x: -4822492.611904318, y: 9697373.47163477),
      Point(x: 17.888058560281664, y: 46.89226406700865)),
  'EPSG:23869': ProjectAndUnProjectResult(
      Point(x: -4820828.738923764, y: 10321798.238985082),
      Point(x: 17.888058560281372, y: 46.89226406700865)),
  'EPSG:23870': ProjectAndUnProjectResult(
      Point(x: -4731020.405434482, y: 10936701.340827035),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:23871': ProjectAndUnProjectResult(
      Point(x: -4558786.5024349885, y: 11525007.658312105),
      Point(x: 17.888058560281475, y: 46.89226406700889)),
  'EPSG:23872': ProjectAndUnProjectResult(
      Point(x: -4314192.978401657, y: 12073000.736903511),
      Point(x: 17.88805856028155, y: 46.892264067008846)),
  'EPSG:23877': ProjectAndUnProjectResult(
      Point(x: -4735902.874809236, y: 19081793.07799971),
      Point(x: 17.888058560281717, y: 46.89226406700881)),
  'EPSG:23878': ProjectAndUnProjectResult(
      Point(x: -4822492.611904318, y: 19697373.471634768),
      Point(x: 17.888058560281678, y: 46.89226406700865)),
  'EPSG:23879': ProjectAndUnProjectResult(
      Point(x: -4820828.738923764, y: 20321798.238985084),
      Point(x: 17.888058560281348, y: 46.89226406700865)),
  'EPSG:23880': ProjectAndUnProjectResult(
      Point(x: -4731020.405434482, y: 20936701.340827033),
      Point(x: 17.888058560281323, y: 46.89226406700882)),
  'EPSG:23881': ProjectAndUnProjectResult(
      Point(x: -4558786.5024349885, y: 21525007.658312105),
      Point(x: 17.888058560281475, y: 46.89226406700889)),
  'EPSG:23882': ProjectAndUnProjectResult(
      Point(x: -4314192.978401657, y: 22073000.73690351),
      Point(x: 17.88805856028155, y: 46.892264067008846)),
  'EPSG:23883': ProjectAndUnProjectResult(
      Point(x: -4009686.094046779, y: 22571384.874852385),
      Point(x: 17.88805856028154, y: 46.89226406700879)),
  'EPSG:23884': ProjectAndUnProjectResult(
      Point(x: -3658127.571844882, y: 23015261.605036482),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:23886': ProjectAndUnProjectResult(
      Point(x: -4566628.91119386, y: 18492233.54239847),
      Point(x: 17.888058560387368, y: 46.89226406677024)),
  'EPSG:23887': ProjectAndUnProjectResult(
      Point(x: -4735950.01173549, y: 19081809.69544299),
      Point(x: 17.888058560387474, y: 46.892264066770174)),
  'EPSG:23888': ProjectAndUnProjectResult(
      Point(x: -4822542.241744762, y: 19697396.328949526),
      Point(x: 17.888058560387382, y: 46.892264066770004)),
  'EPSG:23889': ProjectAndUnProjectResult(
      Point(x: -4820879.692098697, y: 20321827.779474683),
      Point(x: 17.888058560387158, y: 46.89226406677001)),
  'EPSG:23890': ProjectAndUnProjectResult(
      Point(x: -4731071.426738424, y: 20936737.656391915),
      Point(x: 17.888058560387105, y: 46.89226406677015)),
  'EPSG:23891': ProjectAndUnProjectResult(
      Point(x: -4558836.397882137, y: 21525050.49086579),
      Point(x: 17.888058560387258, y: 46.89226406677023)),
  'EPSG:23892': ProjectAndUnProjectResult(
      Point(x: -4314240.735989639, y: 22073049.54876158),
      Point(x: 17.88805856038736, y: 46.892264066770196)),
  'EPSG:23893': ProjectAndUnProjectResult(
      Point(x: -4009730.9487883886, y: 22571438.957204472),
      Point(x: 17.888058560387332, y: 46.89226406677013)),
  'EPSG:23894': ProjectAndUnProjectResult(
      Point(x: -3658169.012419305, y: 23015320.187114842),
      Point(x: 17.888058560387357, y: 46.89226406677013)),
  'EPSG:23946': ProjectAndUnProjectResult(
      Point(x: -4566232.703258537, y: 8492098.885259328),
      Point(x: 17.88805889988293, y: 46.89226408408601)),
  'EPSG:23947': ProjectAndUnProjectResult(
      Point(x: -4735410.839632245, y: 9081647.096307455),
      Point(x: 17.88805889988307, y: 46.89226408408595)),
  'EPSG:23948': ProjectAndUnProjectResult(
      Point(x: -4821857.108294817, y: 9697179.342400845),
      Point(x: 17.88805889988302, y: 46.892264084085795)),
  'EPSG:24047': ProjectAndUnProjectResult(
      Point(x: -4735409.089335247, y: 9081638.58994885),
      Point(x: 17.888058916886298, y: 46.89226408511951)),
  'EPSG:24048': ProjectAndUnProjectResult(
      Point(x: -4821856.571855254, y: 9697170.595121203),
      Point(x: 17.888058916886244, y: 46.89226408511938)),
  'EPSG:24100': ProjectAndUnProjectResult(
      Point(x: 26707709.425388157, y: 18254620.51193544),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:24200': ProjectAndUnProjectResult(
      Point(x: 8222481.623461488, y: 5592026.152977822),
      Point(x: 17.88805844635425, y: 46.89226409662052)),
  'EPSG:24305': ProjectAndUnProjectResult(
      Point(x: -4324227.053896871, y: 7942396.974852075),
      Point(x: 17.888058932791072, y: 46.89226408076531)),
  'EPSG:24306': ProjectAndUnProjectResult(
      Point(x: -4566206.359660537, y: 8492084.166815348),
      Point(x: 17.88805893279115, y: 46.892264080765344)),
  'EPSG:24311': ProjectAndUnProjectResult(
      Point(x: -2875021.215847039, y: 6270286.989082635),
      Point(x: 17.888058839897575, y: 46.89226406413963)),
  'EPSG:24312': ProjectAndUnProjectResult(
      Point(x: -3286207.6031005294, y: 6605837.603907184),
      Point(x: 17.888058839897557, y: 46.892264064139646)),
  'EPSG:24313': ProjectAndUnProjectResult(
      Point(x: -3671786.5729463734, y: 6996004.8014074825),
      Point(x: 17.88805883989757, y: 46.892264064139624)),
  'EPSG:5358': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:24342': ProjectAndUnProjectResult(
      Point(x: -3286245.9725406496, y: 6605875.596456064),
      Point(x: 17.888058818502085, y: 46.892264063788375)),
  'EPSG:24343': ProjectAndUnProjectResult(
      Point(x: -3671821.331335457, y: 6996048.284374189),
      Point(x: 17.88805881850205, y: 46.89226406378838)),
  'EPSG:24344': ProjectAndUnProjectResult(
      Point(x: -4021742.124456592, y: 7442007.402837165),
      Point(x: 17.888058818502024, y: 46.89226406378838)),
  'EPSG:24345': ProjectAndUnProjectResult(
      Point(x: -4324134.579882946, y: 7942351.454341761),
      Point(x: 17.888058818502042, y: 46.892264063788424)),
  'EPSG:24346': ProjectAndUnProjectResult(
      Point(x: -4566123.022315185, y: 8492024.615010832),
      Point(x: 17.888058818502117, y: 46.89226406378848)),
  'EPSG:24347': ProjectAndUnProjectResult(
      Point(x: -4735315.391662749, y: 9081556.212433804),
      Point(x: 17.88805881850225, y: 46.89226406378838)),
  'EPSG:24370': ProjectAndUnProjectResult(
      Point(x: -1636521.2916661752, y: 4629201.684887634),
      Point(x: 17.888058560281518, y: 46.89226406699092)),
  'EPSG:24371': ProjectAndUnProjectResult(
      Point(x: -1156935.9414763267, y: 3759810.324447835),
      Point(x: 17.888058560281518, y: 46.89226406699093)),
  'EPSG:24372': ProjectAndUnProjectResult(
      Point(x: -1869317.5986600237, y: 4654656.3545378065),
      Point(x: 17.888058560281518, y: 46.89226406699093)),
  'EPSG:24373': ProjectAndUnProjectResult(
      Point(x: -2775781.944696364, y: 5557595.1980201425),
      Point(x: 17.88805856028151, y: 46.89226406699093)),
  'EPSG:24374': ProjectAndUnProjectResult(
      Point(x: -3313955.6344679785, y: 6238734.084149719),
      Point(x: 17.888058560281525, y: 46.89226406699094)),
  'EPSG:24375': ProjectAndUnProjectResult(
      Point(x: -2864288.1244962043, y: 4873035.843581423),
      Point(x: 17.888058932791125, y: 46.892264080747395)),
  'EPSG:24376': ProjectAndUnProjectResult(
      Point(x: -1058414.6435997584, y: 3438236.711500969),
      Point(x: 17.888058839897596, y: 46.8922640641218)),
  'EPSG:24377': ProjectAndUnProjectResult(
      Point(x: -1709846.952962821, y: 4256471.66008202),
      Point(x: 17.88805883989759, y: 46.8922640641218)),
  'EPSG:24378': ProjectAndUnProjectResult(
      Point(x: -1058456.9880386186, y: 3438260.3603292666),
      Point(x: 17.888058818502053, y: 46.89226406377055)),
  'EPSG:24379': ProjectAndUnProjectResult(
      Point(x: -1709891.7875443911, y: 4256494.199457621),
      Point(x: 17.888058818502067, y: 46.892264063770526)),
  'EPSG:24380': ProjectAndUnProjectResult(
      Point(x: -2864189.0517154066, y: 4873047.309834164),
      Point(x: 17.88805881850204, y: 46.892264063770526)),
  'EPSG:26710': ProjectAndUnProjectResult(
      Point(x: 3446044.2344564507, y: 14008811.095955668),
      Point(x: 17.888058560281515, y: 46.89226404782312)),
  'EPSG:24381': ProjectAndUnProjectResult(
      Point(x: -2538818.4781615827, y: 5082108.680821331),
      Point(x: 17.888058818502074, y: 46.89226406377052)),
  'EPSG:24382': ProjectAndUnProjectResult(
      Point(x: -3131717.1885044524, y: 5328851.593464678),
      Point(x: 17.8880585602815, y: 46.89226406699093)),
  'EPSG:24383': ProjectAndUnProjectResult(
      Point(x: -3031004.264172895, y: 5704869.984740453),
      Point(x: 17.88805881850206, y: 46.89226406377055)),
  'EPSG:24500': ProjectAndUnProjectResult(
      Point(x: -5685006.08355233, y: 9890075.024441343),
      Point(x: -135, y: double.nan)),
  'EPSG:24547': ProjectAndUnProjectResult(
      Point(x: -4735396.217158672, y: 9081828.28878475),
      Point(x: 17.88805949588425, y: 46.89226406979836)),
  'EPSG:24548': ProjectAndUnProjectResult(
      Point(x: -4821822.704542892, y: 9697357.742568763),
      Point(x: 17.88805949588417, y: 46.892264069798195)),
  'EPSG:24571': ProjectAndUnProjectResult(
      Point(x: -264292.2490371383, y: 346484.959807246),
      Point(x: 17.888059495884065, y: 46.89226406978048)),
  'EPSG:24600': ProjectAndUnProjectResult(
      Point(x: -611636.4548234558, y: 3049576.076328644),
      Point(x: 17.888058575904505, y: 46.89226403905578)),
  'EPSG:24718': ProjectAndUnProjectResult(
      Point(x: 5822515.45428309, y: 10298617.34949604),
      Point(x: 17.888058643287952, y: 46.8922640155702)),
  'EPSG:24719': ProjectAndUnProjectResult(
      Point(x: 5820814.75139322, y: 9674200.275155922),
      Point(x: 17.888058643287653, y: 46.89226401557022)),
  'EPSG:24720': ProjectAndUnProjectResult(
      Point(x: 5730974.902593792, y: 9059311.273158433),
      Point(x: 17.888058643287593, y: 46.89226401557036)),
  'EPSG:24817': ProjectAndUnProjectResult(
      Point(x: 5735961.897703111, y: 10914106.849345177),
      Point(x: 17.888058676901103, y: 46.892264008108064)),
  'EPSG:24818': ProjectAndUnProjectResult(
      Point(x: 5822498.820981597, y: 10298526.20755865),
      Point(x: 17.888058676901014, y: 46.89226400810792)),
  'EPSG:24819': ProjectAndUnProjectResult(
      Point(x: 5820785.310405648, y: 9674112.447717065),
      Point(x: 17.88805867690076, y: 46.89226400810792)),
  'EPSG:24820': ProjectAndUnProjectResult(
      Point(x: 5730933.75337356, y: 9059229.25483845),
      Point(x: 17.888058676900698, y: 46.89226400810807)),
  'EPSG:24821': ProjectAndUnProjectResult(
      Point(x: 5558664.714423203, y: 8470948.451317353),
      Point(x: 17.888058676900847, y: 46.89226400810813)),
  'EPSG:24877': ProjectAndUnProjectResult(
      Point(x: 5735961.897703111, y: 20914106.849345177),
      Point(x: 17.888058676901103, y: 46.892264008108064)),
  'EPSG:24878': ProjectAndUnProjectResult(
      Point(x: 5822498.820981597, y: 20298526.20755865),
      Point(x: 17.888058676901014, y: 46.89226400810792)),
  'EPSG:24879': ProjectAndUnProjectResult(
      Point(x: 5820785.310405648, y: 19674112.447717063),
      Point(x: 17.888058676900723, y: 46.89226400810792)),
  'EPSG:24880': ProjectAndUnProjectResult(
      Point(x: 5730933.75337356, y: 19059229.25483845),
      Point(x: 17.888058676900723, y: 46.89226400810807)),
  'EPSG:24881': ProjectAndUnProjectResult(
      Point(x: 5558664.714423203, y: 18470948.451317355),
      Point(x: 17.88805867690088, y: 46.89226400810814)),
  'EPSG:24882': ProjectAndUnProjectResult(
      Point(x: 5314044.177944984, y: 17922983.244370148),
      Point(x: 17.888058676900954, y: 46.89226400810811)),
  'EPSG:24891': ProjectAndUnProjectResult(
      Point(x: 4787924.675622284, y: 13086492.30063288),
      Point(x: 148.71550708554796, y: 89.99698272552143)),
  'EPSG:24892': ProjectAndUnProjectResult(
      Point(x: 5603533.89865322, y: 12606134.272527143),
      Point(x: 148.71550708554796, y: 89.99698272552143)),
  'EPSG:24893': ProjectAndUnProjectResult(
      Point(x: 6420365.305869488, y: 12007287.501391007),
      Point(x: 45, y: double.nan)),
  'EPSG:25000': ProjectAndUnProjectResult(
      Point(x: 1711254.8654738367, y: 4853832.162992306),
      Point(x: 17.887904288353674, y: 46.892270662179136)),
  'EPSG:25231': ProjectAndUnProjectResult(
      Point(x: 1633238.8664384105, y: 5301558.700122211),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:25391': ProjectAndUnProjectResult(
      Point(x: -4000274.461956445, y: 11070971.376384165),
      Point(x: -149.93141717806435, y: 89.99862403720388)),
  'EPSG:26711': ProjectAndUnProjectResult(
      Point(x: 3874947.351612693, y: 13725202.50334834),
      Point(x: 17.888058560281515, y: 46.892264047823126)),
  'EPSG:25392': ProjectAndUnProjectResult(
      Point(x: -3795752.999044556, y: 11267702.004484212),
      Point(x: -149.93141717806435, y: 89.99862403720388)),
  'EPSG:25393': ProjectAndUnProjectResult(
      Point(x: -3555669.5627440363, y: 11453594.597417176),
      Point(x: -149.93141717806435, y: 89.99862403720388)),
  'EPSG:25394': ProjectAndUnProjectResult(
      Point(x: -3277065.0690270634, y: 11625946.3923946),
      Point(x: -149.93141717806435, y: 89.99862403720388)),
  'EPSG:25395': ProjectAndUnProjectResult(
      Point(x: -2956780.8305139486, y: 11781748.36960319),
      Point(x: -149.93141717806435, y: 89.99862403720388)),
  'EPSG:25700': ProjectAndUnProjectResult(
      Point(x: 21774530.36270427, y: 6774362.061687819),
      Point(x: 17.88805976849401, y: 46.8922646303815)),
  'EPSG:25828': ProjectAndUnProjectResult(
      Point(x: 2988897.836886672, y: 5744008.821518749),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:25829': ProjectAndUnProjectResult(
      Point(x: 2540720.0453096954, y: 5555690.29353334),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:25830': ProjectAndUnProjectResult(
      Point(x: 2088186.0339291478, y: 5409193.447385448),
      Point(x: 17.888058560281504, y: 46.89226406700878)),
  'EPSG:25831': ProjectAndUnProjectResult(
      Point(x: 1633185.5802525284, y: 5301866.074714836),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:25832': ProjectAndUnProjectResult(
      Point(x: 1176891.2861569354, y: 5231671.8338276325),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:25833': ProjectAndUnProjectResult(
      Point(x: 720001.2298382937, y: 5197241.609971515),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:25834': ProjectAndUnProjectResult(
      Point(x: 262945.28796354064, y: 5197894.102609971),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:25835': ProjectAndUnProjectResult(
      Point(x: -193931.34632474044, y: 5233642.279699988),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:25836': ProjectAndUnProjectResult(
      Point(x: -650192.1809783222, y: 5305193.277268217),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:25837': ProjectAndUnProjectResult(
      Point(x: -1105125.3251090779, y: 5413941.604463775),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:25838': ProjectAndUnProjectResult(
      Point(x: -1557536.0364113871, y: 5561947.769793502),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:25884': ProjectAndUnProjectResult(
      Point(x: 34461.49600235146, y: 5211353.267777357),
      Point(x: 17.888058563129825, y: 46.89226406242482)),
  'EPSG:25932': ProjectAndUnProjectResult(
      Point(x: 1176852.2610011455, y: 15231746.959183048),
      Point(x: 17.88805856585687, y: 46.892264067955985)),
  'EPSG:26191': ProjectAndUnProjectResult(
      Point(x: 2312869.5150512536, y: 2027069.1564453228),
      Point(x: 17.88805855727555, y: 46.89226407293459)),
  'EPSG:26192': ProjectAndUnProjectResult(
      Point(x: 2349804.9633505344, y: 2425531.4764553728),
      Point(x: 17.88805855727555, y: 46.89226407293457)),
  'EPSG:26193': ProjectAndUnProjectResult(
      Point(x: 3096116.6324841697, y: 2931667.839238696),
      Point(x: 17.88805855727555, y: 46.89226407293459)),
  'EPSG:26194': ProjectAndUnProjectResult(
      Point(x: 3096147.5591404084, y: 2931709.1320682787),
      Point(x: 17.88805855727555, y: 46.89226407293459)),
  'EPSG:26195': ProjectAndUnProjectResult(
      Point(x: 3452570.1737340344, y: 3347445.621524688),
      Point(x: 17.88805855727555, y: 46.89226407293459)),
  'EPSG:26237': ProjectAndUnProjectResult(
      Point(x: -1104998.548204521, y: 5413863.623647454),
      Point(x: 17.888058622476578, y: 46.89226397036132)),
  'EPSG:26331': ProjectAndUnProjectResult(
      Point(x: 1633263.9505341523, y: 5301750.4200163055),
      Point(x: 17.888058552347843, y: 46.892264050647256)),
  'EPSG:26332': ProjectAndUnProjectResult(
      Point(x: 1176962.5724693679, y: 5231548.345073339),
      Point(x: 17.888058552347832, y: 46.892264050647256)),
  'EPSG:26391': ProjectAndUnProjectResult(
      Point(x: 1250167.4936672924, y: 4839422.999430908),
      Point(x: 17.888052596277475, y: 46.89226383160675)),
  'EPSG:26392': ProjectAndUnProjectResult(
      Point(x: 1385679.062732359, y: 4794650.754628747),
      Point(x: 17.888058342337093, y: 46.89226399635613)),
  'EPSG:26393': ProjectAndUnProjectResult(
      Point(x: 1520911.324528775, y: 4765801.717345288),
      Point(x: 17.888058551752966, y: 46.89226404843637)),
  'EPSG:26432': ProjectAndUnProjectResult(
      Point(x: 1176851.6072835776, y: 15231745.273120763),
      Point(x: 17.888058565335182, y: 46.89226406793262)),
  'EPSG:26591': ProjectAndUnProjectResult(
      Point(x: 2176932.5125911986, y: 5231692.879029007),
      Point(x: 17.888058440115774, y: 46.89226402774989)),
  'EPSG:26592': ProjectAndUnProjectResult(
      Point(x: 2740014.7841464686, y: 5197260.95267589),
      Point(x: 17.888058564860472, y: 46.89226406744901)),
  'EPSG:26632': ProjectAndUnProjectResult(
      Point(x: 1176996.5511388506, y: 5231611.835099658),
      Point(x: 17.8880585356963, y: 46.89226402690004)),
  'EPSG:26692': ProjectAndUnProjectResult(
      Point(x: 1176996.5511388506, y: 15231611.835099658),
      Point(x: 17.8880585356963, y: 46.89226402690004)),
  'EPSG:26701': ProjectAndUnProjectResult(
      Point(x: -633174.6698755615, y: 14693886.86646451),
      Point(x: 17.888058560281486, y: 46.892264047823126)),
  'EPSG:26702': ProjectAndUnProjectResult(
      Point(x: -176885.06570787018, y: 14764082.883675203),
      Point(x: 17.888058560281486, y: 46.89226404782313)),
  'EPSG:26703': ProjectAndUnProjectResult(
      Point(x: 280000.74544497853, y: 14798513.994590672),
      Point(x: 17.888058560281486, y: 46.892264047823126)),
  'EPSG:26704': ProjectAndUnProjectResult(
      Point(x: 737052.5826949974, y: 14797861.485050121),
      Point(x: 17.88805856028151, y: 46.892264047823105)),
  'EPSG:26705': ProjectAndUnProjectResult(
      Point(x: 1193924.9608409042, y: 14762112.387339288),
      Point(x: 17.88805856028149, y: 46.89226404782314)),
  'EPSG:26706': ProjectAndUnProjectResult(
      Point(x: 1650181.0826740367, y: 14690559.58084456),
      Point(x: 17.88805856028151, y: 46.892264047823154)),
  'EPSG:26712': ProjectAndUnProjectResult(
      Point(x: 4286203.166118311, y: 13389663.870716177),
      Point(x: 17.88805856028155, y: 46.89226404782312)),
  'EPSG:26713': ProjectAndUnProjectResult(
      Point(x: 4671854.347392978, y: 12999505.987609139),
      Point(x: 17.888058560281486, y: 46.892264047823126)),
  'EPSG:26714': ProjectAndUnProjectResult(
      Point(x: 5021856.1559109455, y: 12553558.67906406),
      Point(x: 17.88805856028146, y: 46.89226404782313)),
  'EPSG:26715': ProjectAndUnProjectResult(
      Point(x: 5324336.654265573, y: 12053222.147139594),
      Point(x: 17.88805856028148, y: 46.8922640478232)),
  'EPSG:26716': ProjectAndUnProjectResult(
      Point(x: 5566422.002845968, y: 11503549.565520922),
      Point(x: 17.888058560281564, y: 46.892264047823204)),
  'EPSG:26717': ProjectAndUnProjectResult(
      Point(x: 5735721.067308236, y: 10914007.239334224),
      Point(x: 17.888058560281728, y: 46.89226404782313)),
  'EPSG:26718': ProjectAndUnProjectResult(
      Point(x: 5822300.493037979, y: 10298461.172385879),
      Point(x: 17.888058560281664, y: 46.892264047822955)),
  'EPSG:26719': ProjectAndUnProjectResult(
      Point(x: 5820636.823615339, y: 9674072.92666674),
      Point(x: 17.888058560281358, y: 46.892264047822955)),
  'EPSG:26720': ProjectAndUnProjectResult(
      Point(x: 5730839.162543837, y: 9059203.986588232),
      Point(x: 17.888058560281287, y: 46.89226404782314)),
  'EPSG:26721': ProjectAndUnProjectResult(
      Point(x: 5558624.090085652, y: 8470925.702797078),
      Point(x: 17.888058560281458, y: 46.892264047823204)),
  'EPSG:26722': ProjectAndUnProjectResult(
      Point(x: 5314053.981155869, y: 7922952.6124800565),
      Point(x: 17.88805856028157, y: 46.892264047823176)),
  'EPSG:26729': ProjectAndUnProjectResult(
      Point(x: 13540952.672929252, y: 26681329.33086539), Point(x: 0, y: 90)),
  'EPSG:26730': ProjectAndUnProjectResult(
      Point(x: 12754550.102946658, y: 27324427.051889222), Point(x: 0, y: 90)),
  'EPSG:26731': ProjectAndUnProjectResult(
      Point(x: 21353858.81447156, y: 15477559.308342675),
      Point(x: 17.88805856028155, y: 46.892264047823055)),
  'EPSG:26732': ProjectAndUnProjectResult(
      Point(x: -123224440.72028051, y: -62069026.32863877),
      Point(x: 0, y: -90)),
  'EPSG:26733': ProjectAndUnProjectResult(
      Point(x: -149121590.5235042, y: -87033458.2572556), Point(x: 0, y: -90)),
  'EPSG:26734': ProjectAndUnProjectResult(
      Point(x: -178771771.0325936, y: -117473340.37625138),
      Point(x: 0, y: -90)),
  'EPSG:26735': ProjectAndUnProjectResult(
      Point(x: -212608925.42390218, y: -154281578.16211516),
      Point(x: 0, y: -90)),
  'EPSG:26736': ProjectAndUnProjectResult(
      Point(x: -251107054.57481885, y: -198465194.71742576),
      Point(x: 0, y: -90)),
  'EPSG:26737': ProjectAndUnProjectResult(
      Point(x: -294582993.2983449, y: -251156589.36744004),
      Point(x: 0, y: -90)),
  'EPSG:5363': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:26738': ProjectAndUnProjectResult(
      Point(x: 254409816.49533752, y: -201178438.84498614),
      Point(x: 0, y: -90)),
  'EPSG:26739': ProjectAndUnProjectResult(
      Point(x: 215735947.83923522, y: -156549774.73228765),
      Point(x: 0, y: -90)),
  'EPSG:26740': ProjectAndUnProjectResult(
      Point(x: -10345546.751141088, y: 28741533.041960657),
      Point(x: 17.888058560281486, y: 46.89226404782306)),
  'EPSG:26741': ProjectAndUnProjectResult(
      Point(x: 24025334.166640844, y: 25357883.419753045),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:26742': ProjectAndUnProjectResult(
      Point(x: 24929171.82020233, y: 25589658.109205153),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:26743': ProjectAndUnProjectResult(
      Point(x: 25610553.106273796, y: 25333348.444989897),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:26744': ProjectAndUnProjectResult(
      Point(x: 26162073.078877464, y: 25113274.117989585),
      Point(x: 17.88805856028149, y: 46.89226404782307)),
  'EPSG:26745': ProjectAndUnProjectResult(
      Point(x: 27121351.011772502, y: 25060745.64628806),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:26746': ProjectAndUnProjectResult(
      Point(x: 27780098.62767097, y: 24738120.783684596),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:26747': ProjectAndUnProjectResult(
      Point(x: 29662768.91755508, y: 25173180.301893957),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:26748': ProjectAndUnProjectResult(
      Point(x: -10600614.407625115, y: 25959733.303937983), Point(x: 0, y: 90)),
  'EPSG:26749': ProjectAndUnProjectResult(
      Point(x: -13744481.745720092, y: 24883719.00400208), Point(x: 0, y: 90)),
  'EPSG:26750': ProjectAndUnProjectResult(
      Point(x: -17312717.880837597, y: 23513168.31691684), Point(x: 0, y: 90)),
  'EPSG:26751': ProjectAndUnProjectResult(
      Point(x: 24574867.249829542, y: 18694944.493995953),
      Point(x: 17.88805856028152, y: 46.89226404782306)),
  'EPSG:26752': ProjectAndUnProjectResult(
      Point(x: 25103048.634996, y: 18969527.16456138),
      Point(x: 17.88805856028151, y: 46.89226404782304)),
  'EPSG:26753': ProjectAndUnProjectResult(
      Point(x: 23966733.370935712, y: 21103998.25541827),
      Point(x: 17.888058560281515, y: 46.892264047823076)),
  'EPSG:26754': ProjectAndUnProjectResult(
      Point(x: 24415805.350481156, y: 21404594.503997188),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:26769': ProjectAndUnProjectResult(
      Point(x: -17822156.410733804, y: 19422759.784687657), Point(x: 0, y: 90)),
  'EPSG:26755': ProjectAndUnProjectResult(
      Point(x: 24926401.801483322, y: 21551344.940342914),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:26756': ProjectAndUnProjectResult(
      Point(x: 19413161.580503326, y: 13095650.267542124),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:26757': ProjectAndUnProjectResult(
      Point(x: 16633652.157782547, y: 20514407.293675017), Point(x: 0, y: 90)),
  'EPSG:26758': ProjectAndUnProjectResult(
      Point(x: 15332321.538734892, y: 27415787.3073374), Point(x: 0, y: 90)),
  'EPSG:26759': ProjectAndUnProjectResult(
      Point(x: 15016936.750985555, y: 27744028.933151823), Point(x: 0, y: 90)),
  'EPSG:26760': ProjectAndUnProjectResult(
      Point(x: 25342665.273250185, y: 17855814.011669874),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:26766': ProjectAndUnProjectResult(
      Point(x: 14961109.645174468, y: 25737114.764642395), Point(x: 0, y: 90)),
  'EPSG:26767': ProjectAndUnProjectResult(
      Point(x: 14236308.377273941, y: 26366745.538341008), Point(x: 0, y: 90)),
  'EPSG:26768': ProjectAndUnProjectResult(
      Point(x: -14214794.099803515, y: 20830100.56091816), Point(x: 0, y: 90)),
  'EPSG:26770': ProjectAndUnProjectResult(
      Point(x: -21545057.122096922, y: 17819736.752712287), Point(x: 0, y: 90)),
  'EPSG:26771': ProjectAndUnProjectResult(
      Point(x: 12326417.543693507, y: 25116703.597260717), Point(x: 0, y: 90)),
  'EPSG:26772': ProjectAndUnProjectResult(
      Point(x: 11294661.771853184, y: 25555041.15774765), Point(x: 0, y: 90)),
  'EPSG:26773': ProjectAndUnProjectResult(
      Point(x: 13614605.874607047, y: 24086130.607448142), Point(x: 0, y: 90)),
  'EPSG:26774': ProjectAndUnProjectResult(
      Point(x: 12960233.70569124, y: 24484113.391140167), Point(x: 0, y: 90)),
  'EPSG:26775': ProjectAndUnProjectResult(
      Point(x: 22518812.462925527, y: 17853127.638236355),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:26776': ProjectAndUnProjectResult(
      Point(x: 22943594.736897018, y: 18119165.906489335),
      Point(x: 17.8880585602815, y: 46.89226404782307)),
  'EPSG:26777': ProjectAndUnProjectResult(
      Point(x: 23889592.3283327, y: 19421907.780755736),
      Point(x: 17.88805856028152, y: 46.89226404782306)),
  'EPSG:26778': ProjectAndUnProjectResult(
      Point(x: 24393896.768239986, y: 19868941.672639795),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:26779': ProjectAndUnProjectResult(
      Point(x: 22848960.712111842, y: 16345831.798596852),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:26780': ProjectAndUnProjectResult(
      Point(x: 23326997.57570648, y: 16896378.328378435),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:26781': ProjectAndUnProjectResult(
      Point(x: 25927143.29020576, y: 19337807.27167928),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:26782': ProjectAndUnProjectResult(
      Point(x: 26477155.263753057, y: 19369312.24598139),
      Point(x: 17.888058560281515, y: 46.892264047823076)),
  'EPSG:26783': ProjectAndUnProjectResult(
      Point(x: 17343759.604607183, y: 15902894.703349115),
      Point(x: 45, y: double.nan)),
  'EPSG:26784': ProjectAndUnProjectResult(
      Point(x: 17250972.18395992, y: 16866957.72867519),
      Point(x: 45, y: double.nan)),
  'EPSG:26785': ProjectAndUnProjectResult(
      Point(x: 20678034.22257629, y: 14685735.761566138),
      Point(x: 17.88805856028152, y: 46.89226404782307)),
  'EPSG:26786': ProjectAndUnProjectResult(
      Point(x: 19140268.795507424, y: 12864448.03351053),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:26892': ProjectAndUnProjectResult(
      Point(x: 4825851.505324784, y: 11048016.28656974), Point(x: 0, y: 90)),
  'EPSG:26787': ProjectAndUnProjectResult(
      Point(x: 18750822.430482328, y: 12526546.955072846),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:26791': ProjectAndUnProjectResult(
      Point(x: 21151753.880825303, y: 16870587.167903997),
      Point(x: 17.88805856028152, y: 46.89226404782307)),
  'EPSG:26792': ProjectAndUnProjectResult(
      Point(x: 21565252.12495544, y: 17436384.053430807),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:26793': ProjectAndUnProjectResult(
      Point(x: 22038301.355570488, y: 17770351.21581601),
      Point(x: 17.888058560281486, y: 46.89226404782306)),
  'EPSG:26794': ProjectAndUnProjectResult(
      Point(x: 12057214.824388552, y: 27788400.802656632), Point(x: 0, y: 90)),
  'EPSG:26795': ProjectAndUnProjectResult(
      Point(x: 11194653.329841098, y: 27835975.2390737), Point(x: 0, y: 90)),
  'EPSG:26796': ProjectAndUnProjectResult(
      Point(x: 11093491.156971142, y: 25931923.377611335), Point(x: 0, y: 90)),
  'EPSG:26797': ProjectAndUnProjectResult(
      Point(x: 9794512.315005204, y: 26329833.847854935), Point(x: 0, y: 90)),
  'EPSG:26798': ProjectAndUnProjectResult(
      Point(x: 8328120.0415641805, y: 26520829.504573006), Point(x: 0, y: 90)),
  'EPSG:26799': ProjectAndUnProjectResult(
      Point(x: 29662768.91755508, y: 28917180.301893957),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:26801': ProjectAndUnProjectResult(
      Point(x: 14430584.87868026, y: 22029807.156154446), Point(x: 0, y: 90)),
  'EPSG:26802': ProjectAndUnProjectResult(
      Point(x: 13578577.73848037, y: 22654117.410362307), Point(x: 0, y: 90)),
  'EPSG:26803': ProjectAndUnProjectResult(
      Point(x: 12103300.372983655, y: 23461835.41867506), Point(x: 0, y: 90)),
  'EPSG:26811': ProjectAndUnProjectResult(
      Point(x: 21215780.902795788, y: 15731373.918567698),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:26812': ProjectAndUnProjectResult(
      Point(x: 21320659.827233706, y: 15395283.563617723),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:26813': ProjectAndUnProjectResult(
      Point(x: 21774636.707358263, y: 15701584.142725255),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26814': ProjectAndUnProjectResult(
      Point(x: 5434242.727510438, y: 4865567.286727372),
      Point(x: -3577911303.5949883, y: 784422263.488511)),
  'EPSG:5368': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:26815': ProjectAndUnProjectResult(
      Point(x: 6005972.529556511, y: 5140915.469168544),
      Point(x: -2514978608650.738, y: 548342325600.6209)),
  'EPSG:26819': ProjectAndUnProjectResult(
      Point(x: 6637522.089350602, y: 5241976.733272179),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26820': ProjectAndUnProjectResult(
      Point(x: 6763552.011152685, y: 5414428.169772497),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:26821': ProjectAndUnProjectResult(
      Point(x: 6907731.667209977, y: 5516216.609631911),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26822': ProjectAndUnProjectResult(
      Point(x: 6975000.373442961, y: 6039872.843451777),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:26823': ProjectAndUnProjectResult(
      Point(x: 8070078.612677592, y: 4608732.256874052),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26824': ProjectAndUnProjectResult(
      Point(x: 8228607.275988375, y: 4799756.489364472),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26825': ProjectAndUnProjectResult(
      Point(x: 5434242.727510438, y: 4865567.286727372),
      Point(x: -3577911303.5949883, y: 784422263.488511)),
  'EPSG:26893': ProjectAndUnProjectResult(
      Point(x: 4511768.526647326, y: 11340922.422261257), Point(x: 0, y: 90)),
  'EPSG:26826': ProjectAndUnProjectResult(
      Point(x: 6005972.529556511, y: 5140915.469168544),
      Point(x: -2514978608650.738, y: 548342325600.6209)),
  'EPSG:26830': ProjectAndUnProjectResult(
      Point(x: 6637522.089350602, y: 5241976.733272179),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26831': ProjectAndUnProjectResult(
      Point(x: 6763552.011152685, y: 5414428.169772497),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:26832': ProjectAndUnProjectResult(
      Point(x: 6907731.667209977, y: 5516216.609631911),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26833': ProjectAndUnProjectResult(
      Point(x: 6975000.373442961, y: 6039872.843451777),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:26834': ProjectAndUnProjectResult(
      Point(x: 8070078.612677592, y: 4608732.256874052),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26835': ProjectAndUnProjectResult(
      Point(x: 8228607.275988375, y: 4799756.489364472),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26836': ProjectAndUnProjectResult(
      Point(x: 5434242.727510438, y: 4865567.286727372),
      Point(x: -3577911303.5949883, y: 784422263.488511)),
  'EPSG:5369': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:26837': ProjectAndUnProjectResult(
      Point(x: 6005972.529556511, y: 5140915.469168544),
      Point(x: -2514978608650.738, y: 548342325600.6209)),
  'EPSG:26841': ProjectAndUnProjectResult(
      Point(x: 6637522.089350602, y: 5241976.733272179),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26842': ProjectAndUnProjectResult(
      Point(x: 6763552.011152685, y: 5414428.169772497),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:26843': ProjectAndUnProjectResult(
      Point(x: 6907731.667209977, y: 5516216.609631911),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26844': ProjectAndUnProjectResult(
      Point(x: 6975000.373442961, y: 6039872.843451777),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:26845': ProjectAndUnProjectResult(
      Point(x: 8070078.612677592, y: 4608732.256874052),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26846': ProjectAndUnProjectResult(
      Point(x: 8228607.275988375, y: 4799756.489364472),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26847': ProjectAndUnProjectResult(
      Point(x: 17828844.681840498, y: 15963115.339871386),
      Point(x: -3577911303.5949883, y: 784422263.488511)),
  'ESRI:37005': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:26848': ProjectAndUnProjectResult(
      Point(x: 19704594.87405332, y: 16866486.83509713),
      Point(x: -2514978608650.738, y: 548342325600.6209)),
  'EPSG:26849': ProjectAndUnProjectResult(
      Point(x: 21776603.721477766, y: 17198051.99907714),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26850': ProjectAndUnProjectResult(
      Point(x: 22190086.889923435, y: 17763836.420328602),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:26851': ProjectAndUnProjectResult(
      Point(x: 22663116.311504737, y: 18097787.326767363),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26852': ProjectAndUnProjectResult(
      Point(x: 22883813.725204114, y: 19815816.15389137),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:26853': ProjectAndUnProjectResult(
      Point(x: 21986762.4984264, y: 15120482.412760952),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26854': ProjectAndUnProjectResult(
      Point(x: 22506868.621305194, y: 15747201.08218994),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26855': ProjectAndUnProjectResult(
      Point(x: 17828844.681840498, y: 15963115.339871386),
      Point(x: -3577911303.5949883, y: 784422263.488511)),
  'EPSG:32613': ProjectAndUnProjectResult(
      Point(x: 4671946.775863947, y: 12999702.032571306),
      Point(x: 17.88805856028146, y: 46.89226406700879)),
  'EPSG:26856': ProjectAndUnProjectResult(
      Point(x: 19704594.87405332, y: 16866486.83509713),
      Point(x: -2514978608650.738, y: 548342325600.6209)),
  'EPSG:26857': ProjectAndUnProjectResult(
      Point(x: 21776603.721477766, y: 17198051.99907714),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26858': ProjectAndUnProjectResult(
      Point(x: 22190086.889923435, y: 17763836.420328602),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:26859': ProjectAndUnProjectResult(
      Point(x: 22663116.311504737, y: 18097787.326767363),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26860': ProjectAndUnProjectResult(
      Point(x: 22883813.725204114, y: 19815816.15389137),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:26861': ProjectAndUnProjectResult(
      Point(x: 21986762.4984264, y: 15120482.412760952),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26862': ProjectAndUnProjectResult(
      Point(x: 22506868.621305194, y: 15747201.08218994),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26863': ProjectAndUnProjectResult(
      Point(x: 17828844.681840498, y: 15963115.339871386),
      Point(x: -3577911303.5949883, y: 784422263.488511)),
  'EPSG:26864': ProjectAndUnProjectResult(
      Point(x: 19704594.87405332, y: 16866486.83509713),
      Point(x: -2514978608650.738, y: 548342325600.6209)),
  'EPSG:26865': ProjectAndUnProjectResult(
      Point(x: 21776603.721477766, y: 17198051.99907714),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26866': ProjectAndUnProjectResult(
      Point(x: 22190086.889923435, y: 17763836.420328602),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:26867': ProjectAndUnProjectResult(
      Point(x: 22663116.311504737, y: 18097787.326767363),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26868': ProjectAndUnProjectResult(
      Point(x: 22883813.725204114, y: 19815816.15389137),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:26869': ProjectAndUnProjectResult(
      Point(x: 21986762.4984264, y: 15120482.412760952),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26870': ProjectAndUnProjectResult(
      Point(x: 22506868.621305194, y: 15747201.08218994),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26891': ProjectAndUnProjectResult(
      Point(x: 4678521.605919208, y: 11197258.627550166), Point(x: 0, y: 90)),
  'EPSG:26894': ProjectAndUnProjectResult(
      Point(x: 4115096.9499727935, y: 11607101.102096744), Point(x: 0, y: 90)),
  'EPSG:26895': ProjectAndUnProjectResult(
      Point(x: 3625418.58528727, y: 11836768.953508014), Point(x: 0, y: 90)),
  'EPSG:26896': ProjectAndUnProjectResult(
      Point(x: 3031257.7643432096, y: 12018479.462197395), Point(x: 0, y: 90)),
  'EPSG:26897': ProjectAndUnProjectResult(
      Point(x: 2319999.2891139016, y: 12138921.625162058), Point(x: 0, y: 90)),
  'EPSG:26898': ProjectAndUnProjectResult(
      Point(x: 5186788.657734889, y: 8120071.285067176),
      Point(x: -5022.218661072394, y: 1175.203638907414)),
  'EPSG:26899': ProjectAndUnProjectResult(
      Point(x: 5293828.222920929, y: 8403290.068502737),
      Point(x: -20392.421758802197, y: 4476.186579255094)),
  'EPSG:26901': ProjectAndUnProjectResult(
      Point(x: -633185.5802525296, y: 14694063.811162705),
      Point(x: 17.888058560281486, y: 46.8922640670088)),
  'EPSG:26902': ProjectAndUnProjectResult(
      Point(x: -176891.28615693585, y: 14764258.052049907),
      Point(x: 17.888058560281486, y: 46.892264067008796)),
  'EPSG:26903': ProjectAndUnProjectResult(
      Point(x: 279998.7701617067, y: 14798688.275906026),
      Point(x: 17.888058560281486, y: 46.89226406700881)),
  'EPSG:26904': ProjectAndUnProjectResult(
      Point(x: 737054.7120364595, y: 14798035.78326757),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:26905': ProjectAndUnProjectResult(
      Point(x: 1193931.3463247414, y: 14762287.606177554),
      Point(x: 17.888058560281486, y: 46.892264067008796)),
  'EPSG:26906': ProjectAndUnProjectResult(
      Point(x: 1650192.1809783236, y: 14690736.608609322),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:26907': ProjectAndUnProjectResult(
      Point(x: 2105125.3251090776, y: 14581988.281413767),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:26908': ProjectAndUnProjectResult(
      Point(x: 2557536.036411387, y: 14433982.116084043),
      Point(x: 17.88805856028154, y: 46.892264067008774)),
  'EPSG:26909': ProjectAndUnProjectResult(
      Point(x: 3005502.501253523, y: 14244044.5770818),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:26910': ProjectAndUnProjectResult(
      Point(x: 3446086.561687547, y: 14009002.219252983),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:26911': ProjectAndUnProjectResult(
      Point(x: 3875003.072767595, y: 13725397.247874938),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:26912': ProjectAndUnProjectResult(
      Point(x: 4286275.534235133, y: 13389860.739087315),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:26913': ProjectAndUnProjectResult(
      Point(x: 4671946.775898903, y: 12999702.032507129),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:26914': ProjectAndUnProjectResult(
      Point(x: 5021971.586011266, y: 12553749.126989897),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:26915': ProjectAndUnProjectResult(
      Point(x: 5324476.5639229575, y: 12053400.324134082),
      Point(x: 17.88805856028146, y: 46.89226406700884)),
  'EPSG:26916': ProjectAndUnProjectResult(
      Point(x: 5566585.223791351, y: 11503707.444009647),
      Point(x: 17.888058560281575, y: 46.892264067008874)),
  'EPSG:26917': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 10914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:26918': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 10298556.41432563),
      Point(x: 17.88805856028164, y: 46.892264067008654)),
  'EPSG:26919': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 9674131.646974),
      Point(x: 17.888058560281358, y: 46.892264067008654)),
  'EPSG:26920': ProjectAndUnProjectResult(
      Point(x: 5731020.405467821, y: 9059228.545130335),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:26921': ProjectAndUnProjectResult(
      Point(x: 5558786.502469642, y: 8470922.227642598),
      Point(x: 17.88805856028146, y: 46.89226406700888)),
  'EPSG:26922': ProjectAndUnProjectResult(
      Point(x: 5314192.97843734, y: 7922929.14904744),
      Point(x: 17.88805856028157, y: 46.89226406700883)),
  'EPSG:26923': ProjectAndUnProjectResult(
      Point(x: 5009686.094082634, y: 7424545.011094015),
      Point(x: 17.888058560281564, y: 46.89226406700879)),
  'EPSG:26929': ProjectAndUnProjectResult(
      Point(x: 4175252.6559100477, y: 8132636.419234506), Point(x: 0, y: 90)),
  'EPSG:26930': ProjectAndUnProjectResult(
      Point(x: 4335563.615183162, y: 8328698.3072116645), Point(x: 0, y: 90)),
  'EPSG:5379': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:26931': ProjectAndUnProjectResult(
      Point(x: 6508725.5759530235, y: 4717646.787048834),
      Point(x: 17.88805856028155, y: 46.89226406700871)),
  'EPSG:26932': ProjectAndUnProjectResult(
      Point(x: -37213279.522647545, y: -18912875.961270504),
      Point(x: 0, y: -90)),
  'EPSG:26933': ProjectAndUnProjectResult(
      Point(x: -45107405.43757957, y: -26521048.301904406),
      Point(x: 0, y: -90)),
  'EPSG:26934': ProjectAndUnProjectResult(
      Point(x: -54145589.80520173, y: -35798007.60070698), Point(x: 0, y: -90)),
  'EPSG:26935': ProjectAndUnProjectResult(
      Point(x: -64460118.121024735, y: -47015897.944632985),
      Point(x: 0, y: -90)),
  'EPSG:26936': ProjectAndUnProjectResult(
      Point(x: -76195487.58152132, y: -60481645.41980923), Point(x: 0, y: -90)),
  'EPSG:26937': ProjectAndUnProjectResult(
      Point(x: -89509253.44187886, y: -76540389.67400539), Point(x: 0, y: -90)),
  'EPSG:26938': ProjectAndUnProjectResult(
      Point(x: 77897438.88146861, y: -61308557.825420626), Point(x: 0, y: -90)),
  'EPSG:26939': ProjectAndUnProjectResult(
      Point(x: 66078013.4794075, y: -47707169.16826724), Point(x: 0, y: -90)),
  'EPSG:26940': ProjectAndUnProjectResult(
      Point(x: -3067782.7230528235, y: 8760315.521445647),
      Point(x: 17.888058560281486, y: 46.89226406700873)),
  'EPSG:26941': ProjectAndUnProjectResult(
      Point(x: 8713369.04628296, y: 8228903.974584526),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26942': ProjectAndUnProjectResult(
      Point(x: 8988852.870882323, y: 8299543.835321399),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:26943': ProjectAndUnProjectResult(
      Point(x: 9196533.03998033, y: 8221416.367224062),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26944': ProjectAndUnProjectResult(
      Point(x: 9364631.99275643, y: 8154335.033546976),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:26945': ProjectAndUnProjectResult(
      Point(x: 9657012.346788008, y: 8138321.005032831),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26946': ProjectAndUnProjectResult(
      Point(x: 9857792.552179694, y: 8039982.800465539),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:26948': ProjectAndUnProjectResult(
      Point(x: -3169861.026850693, y: 7913822.186592112), Point(x: 0, y: 90)),
  'EPSG:26949': ProjectAndUnProjectResult(
      Point(x: -4128150.708307095, y: 7585988.433132556), Point(x: 0, y: 90)),
  'EPSG:26950': ProjectAndUnProjectResult(
      Point(x: -5215796.690656631, y: 7168396.858414973), Point(x: 0, y: 90)),
  'EPSG:26951': ProjectAndUnProjectResult(
      Point(x: 7280845.10476574, y: 5698018.880729793),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26952': ProjectAndUnProjectResult(
      Point(x: 7441828.743390062, y: 6181711.961229637),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26953': ProjectAndUnProjectResult(
      Point(x: 7609906.701740923, y: 6737108.930826646),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26954': ProjectAndUnProjectResult(
      Point(x: 7746779.736843174, y: 6828729.263310314),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26955': ProjectAndUnProjectResult(
      Point(x: 7902404.853652807, y: 6873456.4247696595),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26956': ProjectAndUnProjectResult(
      Point(x: 6039095.133709748, y: 4143749.064976011),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:26957': ProjectAndUnProjectResult(
      Point(x: 5117848.770438616, y: 6252732.387920412), Point(x: 0, y: 90)),
  'EPSG:26958': ProjectAndUnProjectResult(
      Point(x: 4721237.687280814, y: 8356420.754737286), Point(x: 0, y: 90)),
  'EPSG:26959': ProjectAndUnProjectResult(
      Point(x: 4625113.957471083, y: 8456488.815026179), Point(x: 0, y: 90)),
  'EPSG:26960': ProjectAndUnProjectResult(
      Point(x: 7714848.02247523, y: 5442253.479619011),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:26961': ProjectAndUnProjectResult(
      Point(x: -68690821.23140611, y: -47885351.84872058), Point(x: 0, y: -90)),
  'EPSG:26962': ProjectAndUnProjectResult(
      Point(x: -72121220.72359695, y: -51990013.836311065),
      Point(x: 0, y: -90)),
  'EPSG:26963': ProjectAndUnProjectResult(
      Point(x: -76202390.86573209, y: -56842739.61567939), Point(x: 0, y: -90)),
  'EPSG:26964': ProjectAndUnProjectResult(
      Point(x: -81001618.96536075, y: -62615395.648396604),
      Point(x: 0, y: -90)),
  'EPSG:26965': ProjectAndUnProjectResult(
      Point(x: -83208947.34861997, y: -65252448.177499056),
      Point(x: 0, y: -90)),
  'EPSG:26966': ProjectAndUnProjectResult(
      Point(x: 4608098.742447868, y: 7844758.075159398), Point(x: 0, y: 90)),
  'EPSG:26967': ProjectAndUnProjectResult(
      Point(x: 4887189.5243078265, y: 8036713.270922709), Point(x: 0, y: 90)),
  'EPSG:26968': ProjectAndUnProjectResult(
      Point(x: -4284867.971020522, y: 6350434.242753448), Point(x: 0, y: 90)),
  'EPSG:32614': ProjectAndUnProjectResult(
      Point(x: 5021971.585975397, y: 12553749.127058934),
      Point(x: 17.888058560281486, y: 46.8922640670088)),
  'EPSG:26969': ProjectAndUnProjectResult(
      Point(x: -5084440.623114015, y: 5921630.496325042), Point(x: 0, y: 90)),
  'EPSG:26970': ProjectAndUnProjectResult(
      Point(x: -5919234.386603765, y: 5433186.325411458), Point(x: 0, y: 90)),
  'EPSG:26971': ProjectAndUnProjectResult(
      Point(x: 3905071.6147695784, y: 7655783.660641345), Point(x: 0, y: 90)),
  'EPSG:26972': ProjectAndUnProjectResult(
      Point(x: 3990597.385999085, y: 7789443.487367855), Point(x: 0, y: 90)),
  'EPSG:26973': ProjectAndUnProjectResult(
      Point(x: 4097701.446227201, y: 7591591.6682478), Point(x: 0, y: 90)),
  'EPSG:26974': ProjectAndUnProjectResult(
      Point(x: 4698254.479714725, y: 7712933.359383934), Point(x: 0, y: 90)),
  'EPSG:26975': ProjectAndUnProjectResult(
      Point(x: 7754185.385967116, y: 6441441.897699313),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:26976': ProjectAndUnProjectResult(
      Point(x: 6883654.037123509, y: 5522527.676852138),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26977': ProjectAndUnProjectResult(
      Point(x: 7071987.862697571, y: 5919601.754797991),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:5391': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:26978': ProjectAndUnProjectResult(
      Point(x: 7225695.016863069, y: 6455856.986343259),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:26979': ProjectAndUnProjectResult(
      Point(x: 6895333.619676103, y: 4953881.754771346),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26980': ProjectAndUnProjectResult(
      Point(x: 7000500.0764196385, y: 5649813.9503045585),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:26981': ProjectAndUnProjectResult(
      Point(x: 8293004.335917232, y: 5912444.595764324),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:26982': ProjectAndUnProjectResult(
      Point(x: 8460640.04761491, y: 5922044.6080015665),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26983': ProjectAndUnProjectResult(
      Point(x: 5434242.727510438, y: 4865567.286727372),
      Point(x: -3577911303.5949883, y: 784422263.488511)),
  'EPSG:26984': ProjectAndUnProjectResult(
      Point(x: 6005972.529556511, y: 5140915.469168544),
      Point(x: -2514978608650.738, y: 548342325600.6209)),
  'EPSG:26985': ProjectAndUnProjectResult(
      Point(x: 6458859.816901178, y: 4494509.018460154),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:26986': ProjectAndUnProjectResult(
      Point(x: 5851118.614199274, y: 4670879.245324666),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:26987': ProjectAndUnProjectResult(
      Point(x: 6154332.406766824, y: 3817884.2153315847),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:26988': ProjectAndUnProjectResult(
      Point(x: 13856577.937746815, y: 4794610.454685856),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:26989': ProjectAndUnProjectResult(
      Point(x: 11889319.027601004, y: 4694603.857861964),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:26990': ProjectAndUnProjectResult(
      Point(x: 10027794.9275133, y: 4787933.322479354),
      Point(x: 17.8880585602815, y: 46.892264067008746)),
  'EPSG:26991': ProjectAndUnProjectResult(
      Point(x: 6637522.089340442, y: 5241976.733282339),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26992': ProjectAndUnProjectResult(
      Point(x: 6763552.011142525, y: 5414428.169782657),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:26993': ProjectAndUnProjectResult(
      Point(x: 6907731.6671998175, y: 5516216.609642071),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:26994': ProjectAndUnProjectResult(
      Point(x: 3822984.905080838, y: 8488545.1484227), Point(x: 0, y: 90)),
  'EPSG:26995': ProjectAndUnProjectResult(
      Point(x: 3960143.9403490187, y: 8595620.856387978), Point(x: 0, y: 90)),
  'EPSG:26996': ProjectAndUnProjectResult(
      Point(x: 3479281.287680031, y: 7904330.11893151), Point(x: 0, y: 90)),
  'EPSG:26997': ProjectAndUnProjectResult(
      Point(x: 3333355.4118026467, y: 8025679.559234873), Point(x: 0, y: 90)),
  'EPSG:26998': ProjectAndUnProjectResult(
      Point(x: 3236399.2997552953, y: 8083966.915915788), Point(x: 0, y: 90)),
  'EPSG:27037': ProjectAndUnProjectResult(
      Point(x: -1105163.1198066892, y: 5413501.021726992),
      Point(x: 17.888058561705662, y: 46.89226406538218)),
  'EPSG:27038': ProjectAndUnProjectResult(
      Point(x: -1557606.6978261853, y: 5561509.46163875),
      Point(x: 17.888058561705666, y: 46.89226406538219)),
  'EPSG:27039': ProjectAndUnProjectResult(
      Point(x: -2005606.9536676966, y: 5751452.108988704),
      Point(x: 17.888058561705652, y: 46.8922640653822)),
  'EPSG:27040': ProjectAndUnProjectResult(
      Point(x: -2446225.5366390655, y: 5986502.998507337),
      Point(x: 17.88805856170566, y: 46.89226406538218)),
  'EPSG:27120': ProjectAndUnProjectResult(
      Point(x: 5731077.375734116, y: 9059052.40895709),
      Point(x: 17.888058268284244, y: 46.892264098013854)),
  'EPSG:27200': ProjectAndUnProjectResult(
      Point(x: 2670800.1429357016, y: 6472614.122788343),
      Point(
          x: 174.80089670520277,
          y: -36.934108540127546)), // used point which is inside bounds => Point(x: 174.8009, y: -36.9341)
  'EPSG:27429': ProjectAndUnProjectResult(
      Point(x: 2540668.6164810946, y: 5555680.633798592),
      Point(x: 17.888058522143783, y: 46.89226405729354)),
  'EPSG:27205': ProjectAndUnProjectResult(
      Point(x: 32752966.138749998, y: -3371109.7126332065),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27206': ProjectAndUnProjectResult(
      Point(x: 35661932.30867676, y: -5877891.2530352175),
      Point(x: 8.586443064075317, y: -89.99943361752067)),
  'EPSG:27207': ProjectAndUnProjectResult(
      Point(x: 38221517.530041166, y: -8140850.70342716),
      Point(x: 8.586443064075317, y: -89.99943361752067)),
  'EPSG:27208': ProjectAndUnProjectResult(
      Point(x: 36028211.530873895, y: -6002034.59526986),
      Point(x: 8.586443064075317, y: -89.99943361752067)),
  'EPSG:27209': ProjectAndUnProjectResult(
      Point(x: 31876098.954083707, y: -2348599.2591612106),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27210': ProjectAndUnProjectResult(
      Point(x: 34229614.12892453, y: -4389697.6416421635),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27211': ProjectAndUnProjectResult(
      Point(x: 33970697.79220577, y: -4076899.675460361),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27212': ProjectAndUnProjectResult(
      Point(x: 34242110.9571065, y: -4243992.639892085),
      Point(x: double.nan, y: double.nan)),
  'EPSG:32615': ProjectAndUnProjectResult(
      Point(x: 5324476.563887302, y: 12053400.32420765),
      Point(x: 17.888058560281486, y: 46.89226406700883)),
  'EPSG:27213': ProjectAndUnProjectResult(
      Point(x: 32776566.036459737, y: -2898602.7486160733),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27214': ProjectAndUnProjectResult(
      Point(x: 29415876.30092016, y: -56216.4287707248),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27215': ProjectAndUnProjectResult(
      Point(x: 30391259.787342537, y: -825746.5887205349),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27216': ProjectAndUnProjectResult(
      Point(x: 28558918.972914487, y: 729838.2461928133),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27217': ProjectAndUnProjectResult(
      Point(x: 27771259.13318199, y: 1444248.6388693207),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27218': ProjectAndUnProjectResult(
      Point(x: 27724737.578027647, y: 1540888.4560405558),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27219': ProjectAndUnProjectResult(
      Point(x: 29938864.699345432, y: -281599.5912726079),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27220': ProjectAndUnProjectResult(
      Point(x: 31188985.865262844, y: -1483479.0449241777),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28348': ProjectAndUnProjectResult(
      Point(x: -4822492.611936731, y: 19697373.47155191),
      Point(x: 17.888058560281653, y: 46.892264067008654)),
  'EPSG:27221': ProjectAndUnProjectResult(
      Point(x: 26892054.855501864, y: 2288201.747129887),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27222': ProjectAndUnProjectResult(
      Point(x: 25865522.98551159, y: 3147442.878888669),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27223': ProjectAndUnProjectResult(
      Point(x: 23603528.30360759, y: 5036671.048549576),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27224': ProjectAndUnProjectResult(
      Point(x: 29500751.12892391, y: 191270.50092785468),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27225': ProjectAndUnProjectResult(
      Point(x: 27446587.082927264, y: 1928111.7779986237),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27226': ProjectAndUnProjectResult(
      Point(x: 27003953.49389428, y: 2364923.664651798),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27227': ProjectAndUnProjectResult(
      Point(x: 24764052.09763393, y: 4209076.159203182),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27228': ProjectAndUnProjectResult(
      Point(x: 23329308.710230745, y: 5377925.025070474),
      Point(x: double.nan, y: double.nan)),
  'EPSG:32616': ProjectAndUnProjectResult(
      Point(x: 5566585.2237567445, y: 11503707.444086926),
      Point(x: 17.888058560281575, y: 46.89226406700888)),
  'EPSG:27229': ProjectAndUnProjectResult(
      Point(x: 22471791.834583294, y: 6085085.508028565),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27230': ProjectAndUnProjectResult(
      Point(x: 26387042.29765395, y: 3025828.555928605),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27231': ProjectAndUnProjectResult(
      Point(x: 25895033.691918638, y: 3428445.71100931),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27232': ProjectAndUnProjectResult(
      Point(x: 23256013.183239985, y: 5597734.430803449),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27258': ProjectAndUnProjectResult(
      Point(x: -1989027.4992862125, y: 24252438.880680464),
      Point(x: 17.88805857718306, y: 46.89226406801989)),
  'EPSG:27259': ProjectAndUnProjectResult(
      Point(x: -1540828.2597156668, y: 24440767.713579103),
      Point(x: 17.888058577183063, y: 46.89226406801986)),
  'EPSG:27260': ProjectAndUnProjectResult(
      Point(x: -1088272.566928524, y: 24587272.62873553),
      Point(x: 17.88805857718306, y: 46.892264068019884)),
  'EPSG:27291': ProjectAndUnProjectResult(
      Point(x: 37144909.98928231, y: -4994674.004096187),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28349': ProjectAndUnProjectResult(
      Point(x: -4820828.738956195, y: 20321798.23890354),
      Point(x: 17.888058560281387, y: 46.89226406700866)),
  'EPSG:27292': ProjectAndUnProjectResult(
      Point(x: 30411811.92702717, y: 1688561.9785540658),
      Point(x: double.nan, y: double.nan)),
  'EPSG:27391': ProjectAndUnProjectResult(
      Point(x: 901477.8767372969, y: -1167690.2638157853),
      Point(x: 17.888056688337787, y: 46.892263917852006)),
  'EPSG:27392': ProjectAndUnProjectResult(
      Point(x: 723897.4388511828, y: -1192118.4610804722),
      Point(x: 17.888058325878536, y: 46.89226402034873)),
  'EPSG:27393': ProjectAndUnProjectResult(
      Point(x: 546221.55438381, y: -1211127.1790848929),
      Point(x: 17.888058546836536, y: 46.89226406532615)),
  'EPSG:27394': ProjectAndUnProjectResult(
      Point(x: 355781.6490527072, y: -1225543.833433097),
      Point(x: 17.88805856207829, y: 46.89226407603863)),
  'EPSG:27395': ProjectAndUnProjectResult(
      Point(x: 76393.23631807123, y: -1235650.530632893),
      Point(x: 17.888058562106227, y: 46.89226407696173)),
  'EPSG:27396': ProjectAndUnProjectResult(
      Point(x: -228414.97804442496, y: -1231774.5629086369),
      Point(x: 17.888058562082083, y: 46.892264076896716)),
  'EPSG:27397': ProjectAndUnProjectResult(
      Point(x: -533148.4033358536, y: -1212313.151198981),
      Point(x: 17.88805857405541, y: 46.892264066856534)),
  'EPSG:27398': ProjectAndUnProjectResult(
      Point(x: -850373.4637050426, y: -1175281.2853225083),
      Point(x: 17.888059644305777, y: 46.892263951669406)),
  'EPSG:27492': ProjectAndUnProjectResult(
      Point(x: 1976377.7231515201, y: 1141502.2166061795),
      Point(x: 17.8845328124321, y: 46.89256349786412)),
  'EPSG:27493': ProjectAndUnProjectResult(
      Point(x: 1976377.7231515201, y: 1141502.2166061795),
      Point(x: 17.8845328124321, y: 46.89256349786412)),
  'EPSG:27500': ProjectAndUnProjectResult(
      Point(x: 1271408.5886979008, y: 62181.2159662068),
      Point(x: 17.888058560281515, y: 46.89226406699309)),
  'EPSG:27561': ProjectAndUnProjectResult(
      Point(x: 1777825.1702077333, y: 31948.470010113233),
      Point(x: 17.88805856071017, y: 46.892264067007225)),
  'EPSG:27562': ProjectAndUnProjectResult(
      Point(x: 1777310.0568079422, y: 327103.8227227706),
      Point(x: 17.88805856071017, y: 46.89226406700722)),
  'EPSG:27563': ProjectAndUnProjectResult(
      Point(x: 1779409.8043467712, y: 622135.8275218518),
      Point(x: 17.88805856071017, y: 46.892264067007225)),
  'EPSG:27564': ProjectAndUnProjectResult(
      Point(x: 1182908.9543171676, y: 819774.557776076),
      Point(x: 17.88805856071017, y: 46.89226406700725)),
  'EPSG:27571': ProjectAndUnProjectResult(
      Point(x: 1777825.1702077333, y: 1031948.4700101132),
      Point(x: 17.88805856071017, y: 46.892264067007225)),
  'EPSG:32617': ProjectAndUnProjectResult(
      Point(x: 5735902.874809236, y: 10914136.808042282),
      Point(x: 17.888058560281717, y: 46.89226406700881)),
  'EPSG:27572': ProjectAndUnProjectResult(
      Point(x: 1777310.0568079422, y: 2327103.8227227707),
      Point(x: 17.88805856071017, y: 46.89226406700722)),
  'EPSG:27573': ProjectAndUnProjectResult(
      Point(x: 1779409.8043467712, y: 3622135.8275218518),
      Point(x: 17.88805856071017, y: 46.892264067007225)),
  'EPSG:27574': ProjectAndUnProjectResult(
      Point(x: 1182908.9543171676, y: 4819774.557776076),
      Point(x: 17.88805856071017, y: 46.89226406700725)),
  'EPSG:27581': ProjectAndUnProjectResult(
      Point(x: 1777825.1702077333, y: 1031948.4700101132),
      Point(x: 17.88805856071017, y: 46.892264067007225)),
  'EPSG:27582': ProjectAndUnProjectResult(
      Point(x: 1777310.0568079422, y: 2327103.8227227707),
      Point(x: 17.88805856071017, y: 46.89226406700722)),
  'EPSG:27583': ProjectAndUnProjectResult(
      Point(x: 1779409.8043467712, y: 3622135.8275218518),
      Point(x: 17.88805856071017, y: 46.892264067007225)),
  'EPSG:27584': ProjectAndUnProjectResult(
      Point(x: 1182908.9543171676, y: 4819774.557776076),
      Point(x: 17.88805856071017, y: 46.89226406700725)),
  'EPSG:27591': ProjectAndUnProjectResult(
      Point(x: 1777825.1702077333, y: 31948.470010113233),
      Point(x: 17.88805856071017, y: 46.892264067007225)),
  'EPSG:5487': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:27592': ProjectAndUnProjectResult(
      Point(x: 1777310.0568079422, y: 327103.8227227706),
      Point(x: 17.88805856071017, y: 46.89226406700722)),
  'EPSG:27593': ProjectAndUnProjectResult(
      Point(x: 1779409.8043467712, y: 622135.8275218518),
      Point(x: 17.88805856071017, y: 46.892264067007225)),
  'EPSG:27594': ProjectAndUnProjectResult(
      Point(x: 1182908.9543171676, y: 819774.557776076),
      Point(x: 17.88805856071017, y: 46.89226406700725)),
  'EPSG:27700': ProjectAndUnProjectResult(
      Point(x: 1912625.1078165907, y: -138902.14913871256),
      Point(x: 17.88780496707789, y: 46.89227699578956)),
  'EPSG:28191': ProjectAndUnProjectResult(
      Point(x: -1139644.8678987788, y: 1957397.2449441436),
      Point(x: 17.90819181550383, y: 46.892518132305234)),
  'EPSG:28192': ProjectAndUnProjectResult(
      Point(x: -1148621.110313324, y: 2957398.297650235),
      Point(x: 17.88812625153329, y: 46.89226592347)),
  'EPSG:28193': ProjectAndUnProjectResult(
      Point(x: -1139644.8678987788, y: 2957397.2449441436),
      Point(x: 17.90819181550383, y: 46.892518132305234)),
  'EPSG:28232': ProjectAndUnProjectResult(
      Point(x: 1176777.1093590176, y: 15231806.045412775),
      Point(x: 17.888058632048594, y: 46.89226382741025)),
  'EPSG:32618': ProjectAndUnProjectResult(
      Point(x: 5822492.611904318, y: 10298556.414407223),
      Point(x: 17.888058560281653, y: 46.89226406700865)),
  'EPSG:28350': ProjectAndUnProjectResult(
      Point(x: -4731020.405467821, y: 20936701.340747207),
      Point(x: 17.888058560281298, y: 46.89226406700882)),
  'EPSG:28351': ProjectAndUnProjectResult(
      Point(x: -4558786.502469642, y: 21525007.658234946),
      Point(x: 17.88805856028145, y: 46.89226406700888)),
  'EPSG:28352': ProjectAndUnProjectResult(
      Point(x: -4314192.978437341, y: 22073000.7368301),
      Point(x: 17.888058560281564, y: 46.89226406700883)),
  'EPSG:28353': ProjectAndUnProjectResult(
      Point(x: -4009686.094082634, y: 22571384.874783527),
      Point(x: 17.88805856028154, y: 46.892264067008796)),
  'EPSG:28354': ProjectAndUnProjectResult(
      Point(x: -3658127.571879782, y: 23015261.60497248),
      Point(x: 17.88805856028154, y: 46.89226406700878)),
  'EPSG:28355': ProjectAndUnProjectResult(
      Point(x: -3271333.3919436852, y: 23403348.66088295),
      Point(x: 17.888058560281486, y: 46.892264067008774)),
  'EPSG:28356': ProjectAndUnProjectResult(
      Point(x: -2859272.60100763, y: 23736892.622219022),
      Point(x: 17.88805856028154, y: 46.892264067008796)),
  'EPSG:28357': ProjectAndUnProjectResult(
      Point(x: -2429824.9011676833, y: 24018622.98227349),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:28358': ProjectAndUnProjectResult(
      Point(x: -1988897.8368866723, y: 24251921.064358793),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:28402': ProjectAndUnProjectResult(
      Point(x: 3177294.72790871, y: 5233919.735428686),
      Point(x: 17.888058445097446, y: 46.89226402884926)),
  'EPSG:28403': ProjectAndUnProjectResult(
      Point(x: 3720218.009910196, y: 5199465.397656718),
      Point(x: 17.888058570193113, y: 46.892264068397665)),
  'EPSG:28404': ProjectAndUnProjectResult(
      Point(x: 4262975.20337605, y: 5200108.455837973),
      Point(x: 17.88805857014421, y: 46.89226406836862)),
  'EPSG:28405': ProjectAndUnProjectResult(
      Point(x: 4805911.715875769, y: 5235861.690128276),
      Point(x: 17.88805872826832, y: 46.89226402317326)),
  'EPSG:28406': ProjectAndUnProjectResult(
      Point(x: 5349464.219565769, y: 5307432.332827369),
      Point(x: 17.88807716440437, y: 46.89226406138663)),
  'EPSG:28407': ProjectAndUnProjectResult(
      Point(x: 5894344.749181083, y: 5416215.45576819),
      Point(x: 17.888508865759512, y: 46.89229074905092)),
  'EPSG:28408': ProjectAndUnProjectResult(
      Point(x: 6441748.486232372, y: 5564273.862147296),
      Point(x: 17.893396730554738, y: 46.89274276585422)),
  'EPSG:28409': ProjectAndUnProjectResult(
      Point(x: 6993600.829069106, y: 5754290.647735119),
      Point(x: 17.930913287470414, y: 46.89707909919423)),
  'EPSG:28410': ProjectAndUnProjectResult(
      Point(x: 7552859.348469822, y: 5989473.74186563),
      Point(x: 18.163088321316437, y: 46.92853762419354)),
  'EPSG:28411': ProjectAndUnProjectResult(
      Point(x: 8123886.228420295, y: 6273384.884065807),
      Point(x: 19.45399395295535, y: 47.12655335465394)),
  'EPSG:28412': ProjectAndUnProjectResult(
      Point(x: 8712906.791740527, y: 6609658.637646196),
      Point(x: 26.45363795646325, y: 48.31390228746322)),
  'EPSG:28413': ProjectAndUnProjectResult(
      Point(x: 9328569.71022142, y: 7001570.187034681),
      Point(x: 66.44713781539414, y: 55.68176796175009)),
  'EPSG:28414': ProjectAndUnProjectResult(
      Point(x: 9982624.498931983, y: 7451403.811096456),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28415': ProjectAndUnProjectResult(
      Point(x: 10690731.894358002, y: 7959567.070144047),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28416': ProjectAndUnProjectResult(
      Point(x: 11473422.716032978, y: 8523388.889802082),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28417': ProjectAndUnProjectResult(
      Point(x: 12357220.811322264, y: 9135532.870352365),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28418': ProjectAndUnProjectResult(
      Point(x: 13375945.683021259, y: 9781950.295645684),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28419': ProjectAndUnProjectResult(
      Point(x: 14572210.399428502, y: 10439290.461127605),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:28420': ProjectAndUnProjectResult(
      Point(x: 15999130.386554603, y: 11071679.08598643),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:28421': ProjectAndUnProjectResult(
      Point(x: 17722258.702127807, y: 11626768.71989223),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:28422': ProjectAndUnProjectResult(
      Point(x: 19821763.391057152, y: 12030958.200256905),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:28423': ProjectAndUnProjectResult(
      Point(x: 22394862.522014026, y: 12183671.361405866),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:28424': ProjectAndUnProjectResult(
      Point(x: 25558532.504793, y: 11950578.342513002),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:28425': ProjectAndUnProjectResult(
      Point(x: 29452505.288112894, y: 11155635.986611271),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:28426': ProjectAndUnProjectResult(
      Point(x: 34242570.03751882, y: 9571816.968452249),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28427': ProjectAndUnProjectResult(
      Point(x: 40124194.89304626, y: 6910390.434448714),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28428': ProjectAndUnProjectResult(
      Point(x: 47326484.40630764, y: 2808610.083395421),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28429': ProjectAndUnProjectResult(
      Point(x: 56116488.25666316, y: -3184341.2378764953),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28430': ProjectAndUnProjectResult(
      Point(x: 66803876.84613541, y: -11623308.20429408),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:28431': ProjectAndUnProjectResult(
      Point(x: 79745999.37273005, y: -23185185.58270928),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:28432': ProjectAndUnProjectResult(
      Point(x: 95353339.98182249, y: -38689178.19189904),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:28462': ProjectAndUnProjectResult(
      Point(x: 1177294.7279087103, y: 5233919.735428686),
      Point(x: 17.88805844509745, y: 46.89226402884926)),
  'EPSG:28463': ProjectAndUnProjectResult(
      Point(x: 720218.0099101962, y: 5199465.397656718),
      Point(x: 17.888058570193113, y: 46.892264068397665)),
  'EPSG:28464': ProjectAndUnProjectResult(
      Point(x: 262975.2033760503, y: 5200108.455837973),
      Point(x: 17.88805857014421, y: 46.89226406836862)),
  'EPSG:28465': ProjectAndUnProjectResult(
      Point(x: -194088.28412423097, y: 5235861.690128276),
      Point(x: 17.88805872826832, y: 46.89226402317326)),
  'EPSG:28466': ProjectAndUnProjectResult(
      Point(x: -650535.7804342315, y: 5307432.332827369),
      Point(x: 17.88807716440437, y: 46.89226406138663)),
  'EPSG:28467': ProjectAndUnProjectResult(
      Point(x: -1105655.2508189164, y: 5416215.45576819),
      Point(x: 17.888508865759512, y: 46.89229074905092)),
  'EPSG:28468': ProjectAndUnProjectResult(
      Point(x: -1558251.513767628, y: 5564273.862147296),
      Point(x: 17.893396730554738, y: 46.89274276585422)),
  'EPSG:28469': ProjectAndUnProjectResult(
      Point(x: -2006399.1709308936, y: 5754290.647735119),
      Point(x: 17.930913287470418, y: 46.89707909919423)),
  'EPSG:28470': ProjectAndUnProjectResult(
      Point(x: -2447140.6515301783, y: 5989473.74186563),
      Point(x: 18.163088321316437, y: 46.92853762419354)),
  'EPSG:29635': ProjectAndUnProjectResult(
      Point(x: -193963.87302941235, y: 5233331.602394676),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:28471': ProjectAndUnProjectResult(
      Point(x: -2876113.771579705, y: 6273384.884065807),
      Point(x: 19.45399395295535, y: 47.12655335465394)),
  'EPSG:28472': ProjectAndUnProjectResult(
      Point(x: -3287093.208259472, y: 6609658.637646196),
      Point(x: 26.45363795646325, y: 48.31390228746322)),
  'EPSG:28473': ProjectAndUnProjectResult(
      Point(x: -3671430.2897785814, y: 7001570.187034681),
      Point(x: 66.4471378153942, y: 55.6817679617501)),
  'EPSG:28474': ProjectAndUnProjectResult(
      Point(x: -4017375.5010680165, y: 7451403.811096456),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28475': ProjectAndUnProjectResult(
      Point(x: -4309268.105641998, y: 7959567.070144047),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28476': ProjectAndUnProjectResult(
      Point(x: -4526577.283967023, y: 8523388.889802082),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28477': ProjectAndUnProjectResult(
      Point(x: -4642779.188677735, y: 9135532.870352365),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28478': ProjectAndUnProjectResult(
      Point(x: -4624054.316978742, y: 9781950.295645684),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28479': ProjectAndUnProjectResult(
      Point(x: -4427789.600571497, y: 10439290.461127605),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:29636': ProjectAndUnProjectResult(
      Point(x: -650246.2747174562, y: 5304886.066238032),
      Point(x: 17.888058560281515, y: 46.892264067008796)),
  'EPSG:28480': ProjectAndUnProjectResult(
      Point(x: -4000869.6134453984, y: 11071679.08598643),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:28481': ProjectAndUnProjectResult(
      Point(x: -3277741.2978721927, y: 11626768.71989223),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:28482': ProjectAndUnProjectResult(
      Point(x: -2178236.608942848, y: 12030958.200256905),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:28483': ProjectAndUnProjectResult(
      Point(x: -605137.4779859737, y: 12183671.361405866),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:28484': ProjectAndUnProjectResult(
      Point(x: 1558532.5047930002, y: 11950578.342513002),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:28485': ProjectAndUnProjectResult(
      Point(x: 4452505.288112892, y: 11155635.986611271),
      Point(x: -76.19717406300191, y: 89.99869760060176)),
  'EPSG:28486': ProjectAndUnProjectResult(
      Point(x: 8242570.037518824, y: 9571816.968452249),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28487': ProjectAndUnProjectResult(
      Point(x: 13124194.893046256, y: 6910390.434448714),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28488': ProjectAndUnProjectResult(
      Point(x: 19326484.40630764, y: 2808610.083395421),
      Point(x: double.nan, y: double.nan)),
  'EPSG:30800': ProjectAndUnProjectResult(
      Point(x: 1658475.9961143748, y: 5196841.80384481),
      Point(x: 17.888058560285657, y: 46.89226406700151)),
  'EPSG:28489': ProjectAndUnProjectResult(
      Point(x: 27116488.25666316, y: -3184341.2378764953),
      Point(x: double.nan, y: double.nan)),
  'EPSG:28490': ProjectAndUnProjectResult(
      Point(x: 36803876.84613541, y: -11623308.20429408),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:28491': ProjectAndUnProjectResult(
      Point(x: 48745999.37273005, y: -23185185.58270928),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:28492': ProjectAndUnProjectResult(
      Point(x: 63353339.98182248, y: -38689178.19189904),
      Point(x: -84.68868061818502, y: -89.99872978885845)),
  'EPSG:28600': ProjectAndUnProjectResult(
      Point(x: -2322475.0907781115, y: 3356636.270805078),
      Point(x: 17.934012753486293, y: 46.897461547594204)),
  'EPSG:28991': ProjectAndUnProjectResult(
      Point(x: 951786.3196606983, y: -506313.2441480634),
      Point(x: 17.88805857191546, y: 46.892264065831405)),
  'EPSG:28992': ProjectAndUnProjectResult(
      Point(x: 1106786.3196606983, y: -43313.244148063415),
      Point(x: 17.88805857191546, y: 46.892264065831405)),
  'EPSG:29100': ProjectAndUnProjectResult(
      Point(x: 9743883.837058652, y: 17533830.096176848),
      Point(x: 17.888058561957763, y: 46.892264067668435)),
  'EPSG:29101': ProjectAndUnProjectResult(
      Point(x: 9743887.956464902, y: 17533818.112649657),
      Point(x: 17.88805856271662, y: 46.89226406826736)),
  'EPSG:5544': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:29118': ProjectAndUnProjectResult(
      Point(x: 5822528.154676859, y: 10298568.829588683),
      Point(x: 17.88805856195787, y: 46.89226406766829)),
  'EPSG:29119': ProjectAndUnProjectResult(
      Point(x: 5820860.667472756, y: 9674139.75522695),
      Point(x: 17.888058561957603, y: 46.89226406766831)),
  'EPSG:29120': ProjectAndUnProjectResult(
      Point(x: 5731048.11167365, y: 9059233.17985647),
      Point(x: 17.888058561957575, y: 46.89226406766845)),
  'EPSG:29121': ProjectAndUnProjectResult(
      Point(x: 5558809.660419559, y: 8470924.299804084),
      Point(x: 17.888058561957727, y: 46.89226406766849)),
  'EPSG:29122': ProjectAndUnProjectResult(
      Point(x: 5314211.526115914, y: 7922929.532431368),
      Point(x: 17.888058561957823, y: 46.89226406766846)),
  'EPSG:29168': ProjectAndUnProjectResult(
      Point(x: 5822539.57721245, y: 10298561.23801342),
      Point(x: 17.888058562716772, y: 46.89226406826724)),
  'EPSG:29169': ProjectAndUnProjectResult(
      Point(x: 5820870.8671068605, y: 9674130.61079625),
      Point(x: 17.888058562716505, y: 46.89226406826724)),
  'EPSG:29170': ProjectAndUnProjectResult(
      Point(x: 5731056.810941046, y: 9059222.783700513),
      Point(x: 17.88805856271647, y: 46.89226406826739)),
  'EPSG:29171': ProjectAndUnProjectResult(
      Point(x: 5558816.696120157, y: 8470913.010748772),
      Point(x: 17.888058562716598, y: 46.89226406826745)),
  'EPSG:29172': ProjectAndUnProjectResult(
      Point(x: 5314216.854458378, y: 7922917.713699419),
      Point(x: 17.888058562716704, y: 46.89226406826742)),
  'EPSG:29177': ProjectAndUnProjectResult(
      Point(x: 5735941.186109937, y: 20914154.16948679),
      Point(x: 17.888058561957962, y: 46.89226406766844)),
  'EPSG:29178': ProjectAndUnProjectResult(
      Point(x: 5822528.154676859, y: 20298568.82958868),
      Point(x: 17.888058561957855, y: 46.89226406766829)),
  'EPSG:29179': ProjectAndUnProjectResult(
      Point(x: 5820860.667472756, y: 19674139.755226947),
      Point(x: 17.888058561957592, y: 46.89226406766831)),
  'EPSG:29180': ProjectAndUnProjectResult(
      Point(x: 5731048.11167365, y: 19059233.17985647),
      Point(x: 17.888058561957592, y: 46.89226406766846)),
  'EPSG:29181': ProjectAndUnProjectResult(
      Point(x: 5558809.660419559, y: 18470924.299804084),
      Point(x: 17.888058561957727, y: 46.89226406766849)),
  'EPSG:29182': ProjectAndUnProjectResult(
      Point(x: 5314211.526115914, y: 17922929.532431368),
      Point(x: 17.888058561957823, y: 46.89226406766846)),
  'EPSG:29183': ProjectAndUnProjectResult(
      Point(x: 5009700.170314205, y: 17424544.461462695),
      Point(x: 17.888058561957806, y: 46.89226406766842)),
  'EPSG:29184': ProjectAndUnProjectResult(
      Point(x: 4658137.437498578, y: 16980667.399988603),
      Point(x: 17.888058561957763, y: 46.89226406766842)),
  'EPSG:29185': ProjectAndUnProjectResult(
      Point(x: 4271339.359189044, y: 16592580.461848486),
      Point(x: 17.888058561957788, y: 46.89226406766842)),
  'EPSG:29187': ProjectAndUnProjectResult(
      Point(x: 5735953.473403359, y: 20914148.328739677),
      Point(x: 17.88805856271687, y: 46.89226406826735)),
  'EPSG:29188': ProjectAndUnProjectResult(
      Point(x: 5822539.57721245, y: 20298561.23801342),
      Point(x: 17.888058562716772, y: 46.89226406826724)),
  'EPSG:29189': ProjectAndUnProjectResult(
      Point(x: 5820870.8671068605, y: 19674130.61079625),
      Point(x: 17.888058562716505, y: 46.89226406826724)),
  'EPSG:29190': ProjectAndUnProjectResult(
      Point(x: 5731056.810941046, y: 19059222.78370051),
      Point(x: 17.88805856271644, y: 46.89226406826739)),
  'EPSG:29191': ProjectAndUnProjectResult(
      Point(x: 5558816.696120157, y: 18470913.010748774),
      Point(x: 17.88805856271662, y: 46.892264068267465)),
  'EPSG:29192': ProjectAndUnProjectResult(
      Point(x: 5314216.854458378, y: 17922917.71369942),
      Point(x: 17.888058562716704, y: 46.89226406826742)),
  'EPSG:29193': ProjectAndUnProjectResult(
      Point(x: 5009703.8469378175, y: 17424532.43686673),
      Point(x: 17.888058562716683, y: 46.89226406826737)),
  'EPSG:29194': ProjectAndUnProjectResult(
      Point(x: 4658139.58442449, y: 16980655.42911498),
      Point(x: 17.888058562716665, y: 46.89226406826737)),
  'EPSG:29195': ProjectAndUnProjectResult(
      Point(x: 4271340.131227972, y: 16592568.734028783),
      Point(x: 17.888058562716626, y: 46.89226406826735)),
  'EPSG:29220': ProjectAndUnProjectResult(
      Point(x: 5731481.91713442, y: 19059283.575434245),
      Point(x: 17.888058552736386, y: 46.892264058968074)),
  'EPSG:29221': ProjectAndUnProjectResult(
      Point(x: 5559205.439913697, y: 18470927.343747012),
      Point(x: 17.888058552736524, y: 46.89226405896815)),
  'EPSG:29333': ProjectAndUnProjectResult(
      Point(x: 720053.9317297677, y: 15197341.895806285),
      Point(x: 17.888058484614003, y: 46.892263768872816)),
  'EPSG:29371': ProjectAndUnProjectResult(
      Point(x: 524830.027291518, y: 7651952.311892425),
      Point(x: 17.888058474415747, y: 46.89226375964239)),
  'EPSG:29373': ProjectAndUnProjectResult(
      Point(x: 372500.1397896259, y: 7640478.439719801),
      Point(x: 17.88805848449022, y: 46.8922637676574)),
  'EPSG:29375': ProjectAndUnProjectResult(
      Point(x: 220138.9954071155, y: 7632914.664681439),
      Point(x: 17.888058484634396, y: 46.89226376882054)),
  'EPSG:29377': ProjectAndUnProjectResult(
      Point(x: 67760.04878387022, y: 7629244.295466425),
      Point(x: 17.88805848461406, y: 46.892263768872766)),
  'EPSG:29379': ProjectAndUnProjectResult(
      Point(x: -84624.27761075545, y: 7629459.221290548),
      Point(x: 17.88805848461383, y: 46.89226376887262)),
  'EPSG:29381': ProjectAndUnProjectResult(
      Point(x: -237001.87800936878, y: 7633559.91729796),
      Point(x: 17.888058484585844, y: 46.89226376879147)),
  'EPSG:29383': ProjectAndUnProjectResult(
      Point(x: -389360.2510477339, y: 7641555.4442533245),
      Point(x: 17.8880584848983, y: 46.892263767290714)),
  'EPSG:29385': ProjectAndUnProjectResult(
      Point(x: -541685.783507301, y: 7653463.442466688),
      Point(x: 17.888058498682625, y: 46.89226375777593)),
  'EPSG:5558': ProjectAndUnProjectResult(
      Point(x: 4155428.244442961, y: 1341210.402475973),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:29700': ProjectAndUnProjectResult(
      Point(x: -1385383.755730996, y: 9088716.506591452),
      Point(x: 17.88805854692072, y: 46.89226406872663)),
  'EPSG:29701': null /* blacklist */,
  'EPSG:29702': ProjectAndUnProjectResult(
      Point(x: -1385383.755730996, y: 9088716.506591452),
      Point(x: 17.88805854692072, y: 46.89226406872663)),
  'EPSG:29738': ProjectAndUnProjectResult(
      Point(x: -1557475.0504958164, y: 15561969.858560175),
      Point(x: 17.8880585469207, y: 46.892264068726696)),
  'EPSG:29739': ProjectAndUnProjectResult(
      Point(x: -2005467.8990421374, y: 15751900.752461698),
      Point(x: 17.88805854692069, y: 46.89226406872671)),
  'EPSG:29849': ProjectAndUnProjectResult(
      Point(x: -4820630.813126501, y: 10321780.762965048),
      Point(x: 17.88806042992983, y: 46.892264785360595)),
  'EPSG:29850': ProjectAndUnProjectResult(
      Point(x: -4730654.40206014, y: 10936654.875746388),
      Point(x: 17.88806042992978, y: 46.89226478536073)),
  'EPSG:29871': ProjectAndUnProjectResult(
      Point(x: -997991.9222828604, y: 389395.9273149495),
      Point(x: 17.88806042992995, y: 46.89226478534281)),
  'EPSG:29872': ProjectAndUnProjectResult(
      Point(x: -65867466.86646878, y: 25700131.207586665),
      Point(x: 17.88806042992995, y: 46.892264785342796)),
  'EPSG:29873': ProjectAndUnProjectResult(
      Point(x: -20076369.09523415, y: 7833386.405989658),
      Point(x: 17.88806042992995, y: 46.89226478534281)),
  'EPSG:29900': ProjectAndUnProjectResult(
      Point(x: 2166448.8567273435, y: -149633.2019128304),
      Point(x: 17.88470099955441, y: 46.89254737082415)),
  'EPSG:29901': ProjectAndUnProjectResult(
      Point(x: 2166448.609264751, y: -149632.52213639946),
      Point(x: 17.88470112344352, y: 46.89254732119688)),
  'EPSG:29902': ProjectAndUnProjectResult(
      Point(x: 2166448.8567273435, y: -149633.2019128304),
      Point(x: 17.88470099955441, y: 46.89254737082415)),
  'EPSG:29903': ProjectAndUnProjectResult(
      Point(x: 2166448.8692838466, y: -149633.25430200598),
      Point(x: 17.88470099970021, y: 46.89254737081316)),
  'EPSG:30161': ProjectAndUnProjectResult(
      Point(x: -2564574.876886624, y: 8402036.864471586),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30162': ProjectAndUnProjectResult(
      Point(x: -2209529.1820660145, y: 8462836.915930206),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30163': ProjectAndUnProjectResult(
      Point(x: -1911487.56671277, y: 8165001.851996742),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30164': ProjectAndUnProjectResult(
      Point(x: -1546225.9547115215, y: 8522977.245382551),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:5591': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:30165': ProjectAndUnProjectResult(
      Point(x: -1304035.1793757156, y: 8197467.6810126435),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30166': ProjectAndUnProjectResult(
      Point(x: -786044.5629422882, y: 8190334.924182352),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30167': ProjectAndUnProjectResult(
      Point(x: -395585.3717530748, y: 8166784.9024444),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30168': ProjectAndUnProjectResult(
      Point(x: 80183.44709944718, y: 8119402.726176735),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30169': ProjectAndUnProjectResult(
      Point(x: 588911.3218167224, y: 8048358.382186379),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30170': ProjectAndUnProjectResult(
      Point(x: 993036.1774968327, y: 7534441.8407014785),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30171': ProjectAndUnProjectResult(
      Point(x: 754896.439147769, y: 7132893.637473271),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30172': ProjectAndUnProjectResult(
      Point(x: 1600153.6071265498, y: 6964564.178844889),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30173': ProjectAndUnProjectResult(
      Point(x: 2529954.6104562245, y: 6729491.282519216),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30174': ProjectAndUnProjectResult(
      Point(x: 1489992.367876257, y: 8985673.145076329),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30175': ProjectAndUnProjectResult(
      Point(x: -2991476.077988473, y: 9071896.590616958),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30176': ProjectAndUnProjectResult(
      Point(x: -3621430.9921972794, y: 8829762.17910194),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30177': ProjectAndUnProjectResult(
      Point(x: -2209529.1820660145, y: 9238592.756167458),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30178': ProjectAndUnProjectResult(
      Point(x: -786044.5629422882, y: 9963152.127752924),
      Point(x: 106.09777940057985, y: 89.99527243122452)),
  'EPSG:30179': ProjectAndUnProjectResult(
      Point(x: 8481592.38552262, y: 6335225.710314),
      Point(x: 45, y: double.nan)),
  'EPSG:30200': ProjectAndUnProjectResult(
      Point(x: 26911496.47759386, y: 39926609.556083165),
      Point(x: 45, y: double.nan)),
  'EPSG:30339': ProjectAndUnProjectResult(
      Point(x: -2005526.5903446502, y: 5751945.502046729),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:30340': ProjectAndUnProjectResult(
      Point(x: -2446114.8877621735, y: 5986990.099429649),
      Point(x: 17.8880585602815, y: 46.8922640670088)),
  'EPSG:30491': ProjectAndUnProjectResult(
      Point(x: 1674782.9409374965, y: 1608670.204916644),
      Point(x: 17.8880585570519, y: 46.89226406609377)),
  'EPSG:31028': ProjectAndUnProjectResult(
      Point(x: 2988688.713541896, y: 5743939.048340073),
      Point(x: 17.8880585557781, y: 46.89226407205741)),
  'EPSG:30492': ProjectAndUnProjectResult(
      Point(x: 1688331.4215989625, y: 1910317.0790501875),
      Point(x: 17.8880585570519, y: 46.89226406609377)),
  'EPSG:30493': ProjectAndUnProjectResult(
      Point(x: 1674582.7668584383, y: 1608548.4196520974),
      Point(x: 17.888058560281515, y: 46.89226406700872)),
  'EPSG:30494': ProjectAndUnProjectResult(
      Point(x: 1688127.7891507228, y: 1910196.039122486),
      Point(x: 17.888058560281518, y: 46.89226406700874)),
  'EPSG:30729': ProjectAndUnProjectResult(
      Point(x: 2540844.031841239, y: 5555416.425902881),
      Point(x: 17.888058555005767, y: 46.89226406002643)),
  'EPSG:30730': ProjectAndUnProjectResult(
      Point(x: 2088289.3045803632, y: 5408909.216512288),
      Point(x: 17.88805855500577, y: 46.89226406002641)),
  'EPSG:30731': ProjectAndUnProjectResult(
      Point(x: 1633268.0383780499, y: 5301573.909694857),
      Point(x: 17.888058555005777, y: 46.89226406002641)),
  'EPSG:30732': ProjectAndUnProjectResult(
      Point(x: 1176952.9826687584, y: 5231373.821666703),
      Point(x: 17.888058555005777, y: 46.89226406002642)),
  'EPSG:30791': ProjectAndUnProjectResult(
      Point(x: 1674747.5672537626, y: 1608652.6327321343),
      Point(x: 17.888058555005767, y: 46.89226406002637)),
  'EPSG:30792': ProjectAndUnProjectResult(
      Point(x: 1688293.0638133816, y: 1910300.0967729003),
      Point(x: 17.88805855500577, y: 46.89226406002635)),
  'EPSG:31121': ProjectAndUnProjectResult(
      Point(x: 5558702.831787626, y: 8471018.52841696),
      Point(x: 17.88805864308268, y: 46.892264015006546)),
  'EPSG:31154': ProjectAndUnProjectResult(
      Point(x: 5418516.920074178, y: 8210643.090555323),
      Point(x: 45, y: double.nan)),
  'EPSG:31170': ProjectAndUnProjectResult(
      Point(x: 5477206.619390129, y: 8370359.830228165),
      Point(x: 45, y: double.nan)),
  'EPSG:31171': ProjectAndUnProjectResult(
      Point(x: 5478700.378879742, y: 8372871.94302235),
      Point(x: 45, y: double.nan)),
  'EPSG:31251': ProjectAndUnProjectResult(
      Point(x: 575650.2442142649, y: 222564.259509922),
      Point(x: 17.888058545273374, y: 46.89226405618069)),
  'EPSG:31252': ProjectAndUnProjectResult(
      Point(x: 347141.32095863565, y: 204860.82432084437),
      Point(x: 17.88805857108283, y: 46.89226407115189)),
  'EPSG:31253': ProjectAndUnProjectResult(
      Point(x: 118567.11251136549, y: 195949.62628580164),
      Point(x: 17.888058571080563, y: 46.89226407194811)),
  'EPSG:31254': ProjectAndUnProjectResult(
      Point(x: 575952.9328518903, y: 222593.94859528728),
      Point(x: 17.888058537233796, y: 46.892264051354914)),
  'EPSG:31255': ProjectAndUnProjectResult(
      Point(x: 347444.14238085656, y: 204878.81467454974),
      Point(x: 17.88805856317677, y: 46.89226406637007)),
  'EPSG:5828': ProjectAndUnProjectResult(
      Point(x: 4154854.704858261, y: 1341025.2862347625),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:31256': ProjectAndUnProjectResult(
      Point(x: 118870.00410579969, y: 195956.00531818345),
      Point(x: 17.888058563175434, y: 46.89226406717043)),
  'EPSG:31257': ProjectAndUnProjectResult(
      Point(x: 725952.9328518903, y: 222593.94859528728),
      Point(x: 17.888058537233796, y: 46.892264051354914)),
  'EPSG:31258': ProjectAndUnProjectResult(
      Point(x: 797444.1423808566, y: 204878.81467454974),
      Point(x: 17.88805856317677, y: 46.89226406637007)),
  'EPSG:31259': ProjectAndUnProjectResult(
      Point(x: 868870.0041057997, y: 195956.00531818345),
      Point(x: 17.888058563175438, y: 46.89226406717042)),
  'EPSG:31265': ProjectAndUnProjectResult(
      Point(x: 5720463.637532424, y: 5198840.068719962),
      Point(x: 17.888058563195003, y: 46.89226406711906)),
  'EPSG:31266': ProjectAndUnProjectResult(
      Point(x: 6491872.49205869, y: 5194779.944741582),
      Point(x: 17.88805856317448, y: 46.892264067171745)),
  'EPSG:31267': ProjectAndUnProjectResult(
      Point(x: 7263282.800922377, y: 5199461.958089824),
      Point(x: 17.88805856314645, y: 46.89226406709105)),
  'EPSG:31268': ProjectAndUnProjectResult(
      Point(x: 8034736.470293111, y: 5212909.392026107),
      Point(x: 17.88805856600443, y: 46.89226406262572)),
  'EPSG:31275': ProjectAndUnProjectResult(
      Point(x: 5720441.591168671, y: 5198320.184713091),
      Point(x: 17.888058563195003, y: 46.89226406711906)),
  'EPSG:31466': ProjectAndUnProjectResult(
      Point(x: 3405552.352774285, y: 5263900.335799437),
      Point(x: 17.88805660254163, y: 46.892263904781714)),
  'EPSG:31276': ProjectAndUnProjectResult(
      Point(x: 6491873.304809484, y: 5194260.466747107),
      Point(x: 17.888058563174475, y: 46.892264067171745)),
  'EPSG:31277': ProjectAndUnProjectResult(
      Point(x: 7263306.472642285, y: 5198942.011894015),
      Point(x: 17.88805856314645, y: 46.89226406709105)),
  'EPSG:31278': ProjectAndUnProjectResult(
      Point(x: 7263306.472642285, y: 5198942.011894015),
      Point(x: 17.88805856314645, y: 46.89226406709105)),
  'EPSG:31279': ProjectAndUnProjectResult(
      Point(x: 8034782.996646082, y: 5212388.101086905),
      Point(x: 17.888058566004432, y: 46.89226406262573)),
  'EPSG:31281': ProjectAndUnProjectResult(
      Point(x: 575953.1829719958, y: 5222594.963888772),
      Point(x: 17.888058573114066, y: 46.89226405343905)),
  'EPSG:31282': ProjectAndUnProjectResult(
      Point(x: 347444.4305802124, y: 5204879.817010556),
      Point(x: 17.88805859905704, y: 46.89226406845414)),
  'EPSG:31283': ProjectAndUnProjectResult(
      Point(x: 118870.33002923777, y: 5195956.994593775),
      Point(x: 17.888058599055693, y: 46.892264069254544)),
  'EPSG:31284': ProjectAndUnProjectResult(
      Point(x: 725952.9328518903, y: 5222593.948595287),
      Point(x: 17.888058537233796, y: 46.892264051354914)),
  'EPSG:31285': ProjectAndUnProjectResult(
      Point(x: 797444.1423808566, y: 5204878.81467455),
      Point(x: 17.88805856317677, y: 46.89226406637007)),
  'EPSG:31286': ProjectAndUnProjectResult(
      Point(x: 868870.0041057997, y: 5195956.005318183),
      Point(x: 17.888058563175438, y: 46.89226406717042)),
  'EPSG:31287': ProjectAndUnProjectResult(
      Point(x: 747169.9720105445, y: 342687.1216817284),
      Point(x: 17.88805856317447, y: 46.89226406717169)),
  'EPSG:31288': ProjectAndUnProjectResult(
      Point(x: 725953.1829719958, y: 5222594.963888772),
      Point(x: 17.888058573114066, y: 46.89226405343905)),
  'EPSG:31289': ProjectAndUnProjectResult(
      Point(x: 797444.4305802124, y: 5204879.817010556),
      Point(x: 17.88805859905704, y: 46.89226406845414)),
  'EPSG:31290': ProjectAndUnProjectResult(
      Point(x: 868870.3300292378, y: 5195956.994593775),
      Point(x: 17.888058599055693, y: 46.892264069254544)),
  'EPSG:31291': ProjectAndUnProjectResult(
      Point(x: 575953.1829719958, y: 5222594.963888772),
      Point(x: 17.888058573114066, y: 46.89226405343905)),
  'EPSG:31292': ProjectAndUnProjectResult(
      Point(x: 347444.4305802124, y: 5204879.817010556),
      Point(x: 17.88805859905704, y: 46.89226406845414)),
  'EPSG:31293': ProjectAndUnProjectResult(
      Point(x: 118870.33002923777, y: 5195956.994593775),
      Point(x: 17.888058599055693, y: 46.892264069254544)),
  'EPSG:31294': ProjectAndUnProjectResult(
      Point(x: 725952.9328518903, y: 5222593.948595287),
      Point(x: 17.888058537233796, y: 46.892264051354914)),
  'EPSG:31295': ProjectAndUnProjectResult(
      Point(x: 797444.1423808566, y: 5204878.81467455),
      Point(x: 17.88805856317677, y: 46.89226406637007)),
  'EPSG:5884': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:31296': ProjectAndUnProjectResult(
      Point(x: 868870.0041057997, y: 5195956.005318183),
      Point(x: 17.888058563175438, y: 46.89226406717042)),
  'EPSG:31297': ProjectAndUnProjectResult(
      Point(x: 747169.9720105445, y: 342687.1216817284),
      Point(x: 17.88805856317447, y: 46.89226406717169)),
  'EPSG:31300': ProjectAndUnProjectResult(
      Point(x: 1177322.4717960658, y: -175430.39395839255),
      Point(x: 17.888058551637616, y: 46.89226407321229)),
  'EPSG:31370': ProjectAndUnProjectResult(
      Point(x: 1176530.4986970704, y: -175576.21788469795),
      Point(x: 17.888058551637616, y: 46.8922640732123)),
  'EPSG:31461': ProjectAndUnProjectResult(
      Point(x: 2633650.2173375282, y: 5303555.09634357),
      Point(x: 17.888042364500645, y: 46.89226400301286)),
  'EPSG:31462': ProjectAndUnProjectResult(
      Point(x: 3405552.352774285, y: 5263900.335799437),
      Point(x: 17.88805660254163, y: 46.892263904781714)),
  'EPSG:31463': ProjectAndUnProjectResult(
      Point(x: 4177235.2261281675, y: 5233328.38928267),
      Point(x: 17.88805843372212, y: 46.89226402708752)),
  'EPSG:31464': ProjectAndUnProjectResult(
      Point(x: 4948773.170928149, y: 5211689.23202899),
      Point(x: 17.88805855704943, y: 46.892264062895954)),
  'EPSG:31465': ProjectAndUnProjectResult(
      Point(x: 5720223.93618536, y: 5198875.94190293),
      Point(x: 17.8880585589492, y: 46.89226406651698)),
  'EPSG:31467': ProjectAndUnProjectResult(
      Point(x: 4177235.2261281675, y: 5233328.38928267),
      Point(x: 17.88805843372212, y: 46.89226402708752)),
  'EPSG:31468': ProjectAndUnProjectResult(
      Point(x: 4948773.170928149, y: 5211689.23202899),
      Point(x: 17.88805855704943, y: 46.892264062895954)),
  'EPSG:31469': ProjectAndUnProjectResult(
      Point(x: 5720223.93618536, y: 5198875.94190293),
      Point(x: 17.8880585589492, y: 46.89226406651698)),
  'EPSG:31528': ProjectAndUnProjectResult(
      Point(x: 2988586.7424041587, y: 5743994.832182371),
      Point(x: 17.888058581617294, y: 46.89226404402927)),
  'EPSG:31529': ProjectAndUnProjectResult(
      Point(x: 2540421.9143028324, y: 5555694.854662288),
      Point(x: 17.888058581617305, y: 46.892264044029275)),
  'EPSG:31600': ProjectAndUnProjectResult(
      Point(x: -71151.77160184516, y: 637738.5854183696),
      Point(x: 17.888058566597667, y: 46.892264078966164)),
  'EPSG:31700': ProjectAndUnProjectResult(
      Point(x: -41370.698526213644, y: 623582.1646694599),
      Point(x: 17.888058571980313, y: 46.892264069754845)),
  'EPSG:31838': ProjectAndUnProjectResult(
      Point(x: -1557533.6548192734, y: 5561940.797420758),
      Point(x: 17.888058560270277, y: 46.89226406701824)),
  'EPSG:31839': ProjectAndUnProjectResult(
      Point(x: -2005500.6897258814, y: 5751877.982090551),
      Point(x: 17.88805856027026, y: 46.89226406701824)),
  'EPSG:31900': ProjectAndUnProjectResult(
      Point(x: -1782253.4051442007, y: 5651486.6987863025),
      Point(x: 17.903751822530126, y: 46.893857776361884)),
  'EPSG:31901': ProjectAndUnProjectResult(
      Point(x: -1783166.671812926, y: 5653748.198065529),
      Point(x: 17.903751822530126, y: 46.893857776361884)),
  'EPSG:31965': ProjectAndUnProjectResult(
      Point(x: 3875003.072767595, y: 13725397.247874938),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:31966': ProjectAndUnProjectResult(
      Point(x: 4286275.534235133, y: 13389860.739087315),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:31967': ProjectAndUnProjectResult(
      Point(x: 4671946.775898903, y: 12999702.032507129),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:31968': ProjectAndUnProjectResult(
      Point(x: 5021971.586011266, y: 12553749.126989897),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:31969': ProjectAndUnProjectResult(
      Point(x: 5324476.5639229575, y: 12053400.324134082),
      Point(x: 17.88805856028146, y: 46.89226406700884)),
  'EPSG:31970': ProjectAndUnProjectResult(
      Point(x: 5566585.223791351, y: 11503707.444009647),
      Point(x: 17.888058560281575, y: 46.892264067008874)),
  'EPSG:31971': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 10914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:31972': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 10298556.41432563),
      Point(x: 17.88805856028164, y: 46.892264067008654)),
  'EPSG:31973': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 9674131.646974),
      Point(x: 17.888058560281358, y: 46.892264067008654)),
  'EPSG:31974': ProjectAndUnProjectResult(
      Point(x: 5731020.405467821, y: 9059228.545130335),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:31975': ProjectAndUnProjectResult(
      Point(x: 5558786.502469642, y: 8470922.227642598),
      Point(x: 17.88805856028146, y: 46.89226406700888)),
  'EPSG:31976': ProjectAndUnProjectResult(
      Point(x: 5314192.97843734, y: 7922929.14904744),
      Point(x: 17.88805856028157, y: 46.89226406700883)),
  'EPSG:31977': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 20914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:31978': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 20298556.414325632),
      Point(x: 17.888058560281653, y: 46.892264067008654)),
  'EPSG:31979': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 19674131.646973997),
      Point(x: 17.888058560281348, y: 46.892264067008654)),
  'EPSG:31980': ProjectAndUnProjectResult(
      Point(x: 5731020.405467821, y: 19059228.545130335),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:31981': ProjectAndUnProjectResult(
      Point(x: 5558786.502469642, y: 18470922.227642596),
      Point(x: 17.88805856028145, y: 46.89226406700888)),
  'EPSG:31982': ProjectAndUnProjectResult(
      Point(x: 5314192.97843734, y: 17922929.14904744),
      Point(x: 17.88805856028157, y: 46.89226406700883)),
  'EPSG:31983': ProjectAndUnProjectResult(
      Point(x: 5009686.094082634, y: 17424545.011094015),
      Point(x: 17.888058560281564, y: 46.89226406700879)),
  'EPSG:31984': ProjectAndUnProjectResult(
      Point(x: 4658127.571879782, y: 16980668.28090506),
      Point(x: 17.888058560281543, y: 46.892264067008774)),
  'EPSG:31985': ProjectAndUnProjectResult(
      Point(x: 4271333.391943685, y: 16592581.224994596),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:31986': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 10914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:31987': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 10298556.41432563),
      Point(x: 17.88805856028164, y: 46.892264067008654)),
  'EPSG:31988': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 9674131.646974),
      Point(x: 17.888058560281358, y: 46.892264067008654)),
  'EPSG:31989': ProjectAndUnProjectResult(
      Point(x: 5731020.405467821, y: 9059228.545130335),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:31990': ProjectAndUnProjectResult(
      Point(x: 5558786.502469642, y: 8470922.227642598),
      Point(x: 17.88805856028146, y: 46.89226406700888)),
  'EPSG:31991': ProjectAndUnProjectResult(
      Point(x: 5314192.97843734, y: 7922929.14904744),
      Point(x: 17.88805856028157, y: 46.89226406700883)),
  'EPSG:31992': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 20914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:31993': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 20298556.414325632),
      Point(x: 17.888058560281653, y: 46.892264067008654)),
  'EPSG:31994': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 19674131.646973997),
      Point(x: 17.888058560281348, y: 46.892264067008654)),
  'EPSG:31995': ProjectAndUnProjectResult(
      Point(x: 5731020.405467821, y: 19059228.545130335),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:31996': ProjectAndUnProjectResult(
      Point(x: 5558786.502469642, y: 18470922.227642596),
      Point(x: 17.88805856028145, y: 46.89226406700888)),
  'EPSG:31997': ProjectAndUnProjectResult(
      Point(x: 5314192.97843734, y: 17922929.14904744),
      Point(x: 17.88805856028157, y: 46.89226406700883)),
  'EPSG:31998': ProjectAndUnProjectResult(
      Point(x: 5009686.094082634, y: 17424545.011094015),
      Point(x: 17.888058560281564, y: 46.89226406700879)),
  'EPSG:31999': ProjectAndUnProjectResult(
      Point(x: 4658127.571879782, y: 16980668.28090506),
      Point(x: 17.888058560281543, y: 46.892264067008774)),
  'EPSG:32000': ProjectAndUnProjectResult(
      Point(x: 4271333.391943685, y: 16592581.224994596),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:32001': ProjectAndUnProjectResult(
      Point(x: 21120726.36571095, y: 20860669.89716128),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:32002': ProjectAndUnProjectResult(
      Point(x: 21498035.44225285, y: 21085210.99828248),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:6133': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32003': ProjectAndUnProjectResult(
      Point(x: 22037916.96880421, y: 21471031.300674338),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:32005': ProjectAndUnProjectResult(
      Point(x: 22975266.765149537, y: 19440458.373038888),
      Point(x: 17.88805856028152, y: 46.89226404782307)),
  'EPSG:32006': ProjectAndUnProjectResult(
      Point(x: 23391319.515180737, y: 19658315.34436853),
      Point(x: 17.88805856028152, y: 46.89226404782307)),
  'EPSG:32007': ProjectAndUnProjectResult(
      Point(x: -21177526.018185206, y: 20501927.4816624), Point(x: 0, y: 90)),
  'EPSG:32008': ProjectAndUnProjectResult(
      Point(x: -23609045.758414574, y: 19388960.106355526),
      Point(x: 45, y: double.nan)),
  'EPSG:32009': ProjectAndUnProjectResult(
      Point(x: -28193677.824868068, y: 17142919.333487462),
      Point(x: 45, y: double.nan)),
  'EPSG:32010': ProjectAndUnProjectResult(
      Point(x: 17126656.70441657, y: 17528723.109378744), Point(x: 0, y: 90)),
  'EPSG:32011': ProjectAndUnProjectResult(
      Point(x: 18254292.75654244, y: 19942868.435700156), Point(x: 0, y: 90)),
  'EPSG:32012': ProjectAndUnProjectResult(
      Point(x: -1783032.3863598064, y: 28159943.4746598), Point(x: 0, y: 90)),
  'EPSG:32013': ProjectAndUnProjectResult(
      Point(x: -4415970.897491426, y: 27647904.178247053), Point(x: 0, y: 90)),
  'EPSG:32014': ProjectAndUnProjectResult(
      Point(x: -6780967.248084832, y: 27076842.380646724), Point(x: 0, y: 90)),
  'EPSG:32015': ProjectAndUnProjectResult(
      Point(x: 16804206.672251586, y: 19398470.491679206), Point(x: 0, y: 90)),
  'EPSG:32016': ProjectAndUnProjectResult(
      Point(x: 16420833.602465529, y: 20198519.38342503), Point(x: 0, y: 90)),
  'EPSG:32017': ProjectAndUnProjectResult(
      Point(x: 15986536.034394884, y: 20897266.672446184), Point(x: 0, y: 90)),
  'EPSG:32018': ProjectAndUnProjectResult(
      Point(x: 20096015.858215142, y: 13382884.173489098),
      Point(x: 17.88805856028152, y: 46.89226404782306)),
  'EPSG:32019': ProjectAndUnProjectResult(
      Point(x: 23008993.2574473, y: 15970656.907594701),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:32020': ProjectAndUnProjectResult(
      Point(x: 21243411.594244584, y: 18575972.35477679),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:32021': ProjectAndUnProjectResult(
      Point(x: 21599407.863485917, y: 18836779.99137151),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:32022': ProjectAndUnProjectResult(
      Point(x: 22018110.590105932, y: 15625567.51446421),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:32023': ProjectAndUnProjectResult(
      Point(x: 22419583.739901267, y: 15934279.431293298),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:32024': ProjectAndUnProjectResult(
      Point(x: 24987830.65661771, y: 19977127.8593985),
      Point(x: 17.888058560281554, y: 46.89226404782306)),
  'EPSG:32025': ProjectAndUnProjectResult(
      Point(x: 25585470.348203015, y: 20228402.719816066),
      Point(x: 17.88805856028152, y: 46.89226404782307)),
  'EPSG:32026': ProjectAndUnProjectResult(
      Point(x: 22003195.035465173, y: 24246002.74858822),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:32027': ProjectAndUnProjectResult(
      Point(x: 22912147.23796541, y: 24599811.452602085),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:32028': ProjectAndUnProjectResult(
      Point(x: 21430529.780994296, y: 14425070.89328698),
      Point(x: 17.888058560281497, y: 46.89226404782306)),
  'EPSG:32029': ProjectAndUnProjectResult(
      Point(x: 21649500.871525753, y: 14554426.568311429),
      Point(x: 17.88805856028151, y: 46.89226404782304)),
  'EPSG:32619': ProjectAndUnProjectResult(
      Point(x: 5820828.738923764, y: 9674131.647056911),
      Point(x: 17.888058560281358, y: 46.89226406700865)),
  'EPSG:32030': ProjectAndUnProjectResult(
      Point(x: 17142866.636789955, y: 17985364.970315754), Point(x: 0, y: 90)),
  'EPSG:32031': ProjectAndUnProjectResult(
      Point(x: 23533120.872628823, y: 16505942.014075654),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:32033': ProjectAndUnProjectResult(
      Point(x: 23916672.881076984, y: 16671254.134924103),
      Point(x: 17.88805856028151, y: 46.89226404782304)),
  'EPSG:32034': ProjectAndUnProjectResult(
      Point(x: 22117640.419236757, y: 19051061.1748284),
      Point(x: 17.88805856028152, y: 46.89226404782306)),
  'EPSG:32035': ProjectAndUnProjectResult(
      Point(x: 22573036.10776595, y: 19407558.12575994),
      Point(x: 17.88805856028155, y: 46.89226404782307)),
  'EPSG:32036': ProjectAndUnProjectResult(
      Point(x: 21887400.955928694, y: 17268660.079644486),
      Point(x: 17.888058560281515, y: 46.89226404782303)),
  'EPSG:32037': ProjectAndUnProjectResult(
      Point(x: 25599449.69288968, y: 21003497.02276749),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:32038': ProjectAndUnProjectResult(
      Point(x: 26126278.68173603, y: 20362613.735682715),
      Point(x: 17.88805856028152, y: 46.89226404782306)),
  'EPSG:32620': ProjectAndUnProjectResult(
      Point(x: 5731020.405434482, y: 9059228.545214958),
      Point(x: 17.888058560281323, y: 46.89226406700882)),
  'EPSG:32039': ProjectAndUnProjectResult(
      Point(x: 27323905.74450787, y: 21236793.58681359),
      Point(x: 17.88805856028152, y: 46.89226404782307)),
  'EPSG:32040': ProjectAndUnProjectResult(
      Point(x: 27875090.842656855, y: 21173557.92961591),
      Point(x: 17.88805856028154, y: 46.89226404782306)),
  'EPSG:32041': ProjectAndUnProjectResult(
      Point(x: 28851233.547113057, y: 21225817.291045375),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:32042': ProjectAndUnProjectResult(
      Point(x: 23761186.634705875, y: 22444881.298876897),
      Point(x: 17.88805856028152, y: 46.89226404782306)),
  'EPSG:32043': ProjectAndUnProjectResult(
      Point(x: 24363974.027586855, y: 22871882.968079094),
      Point(x: 17.88805856028152, y: 46.89226404782306)),
  'EPSG:32044': ProjectAndUnProjectResult(
      Point(x: 25277634.74152593, y: 23023696.143152285),
      Point(x: 17.88805856028152, y: 46.89226404782307)),
  'EPSG:32045': ProjectAndUnProjectResult(
      Point(x: 17040276.60568774, y: 17828872.62160684), Point(x: 0, y: 90)),
  'EPSG:32046': ProjectAndUnProjectResult(
      Point(x: 22126142.048386, y: 15030264.520956792),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:32621': ProjectAndUnProjectResult(
      Point(x: 5558786.502434989, y: 8470922.227729889),
      Point(x: 17.888058560281475, y: 46.89226406700888)),
  'EPSG:32047': ProjectAndUnProjectResult(
      Point(x: 22417899.924455542, y: 15299357.381634258),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:32048': ProjectAndUnProjectResult(
      Point(x: 20729703.721203472, y: 23626784.679438435),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:32049': ProjectAndUnProjectResult(
      Point(x: 21388101.90207301, y: 23891068.922298305),
      Point(x: 17.88805856028154, y: 46.89226404782306)),
  'EPSG:32050': ProjectAndUnProjectResult(
      Point(x: 22018177.383287385, y: 15121178.171458086),
      Point(x: 17.88805856028152, y: 46.89226404782307)),
  'EPSG:32051': ProjectAndUnProjectResult(
      Point(x: 22538300.096521433, y: 15747898.252498945),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:32052': ProjectAndUnProjectResult(
      Point(x: 21412634.426541068, y: 16301698.486752158),
      Point(x: 17.88805856028152, y: 46.89226404782306)),
  'EPSG:32053': ProjectAndUnProjectResult(
      Point(x: 21721760.990491796, y: 16558779.166711608),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:32054': ProjectAndUnProjectResult(
      Point(x: 22090977.920215692, y: 16960529.552739237),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:32622': ProjectAndUnProjectResult(
      Point(x: 5314192.978401657, y: 7922929.149138481),
      Point(x: 17.888058560281543, y: 46.89226406700883)),
  'EPSG:32055': ProjectAndUnProjectResult(
      Point(x: -2897936.675358525, y: 24442639.97157788), Point(x: 0, y: 90)),
  'EPSG:32056': ProjectAndUnProjectResult(
      Point(x: -6015110.786894472, y: 23754726.0210987), Point(x: 0, y: 90)),
  'EPSG:32057': ProjectAndUnProjectResult(
      Point(x: -8232910.5806097975, y: 23160989.44597798), Point(x: 0, y: 90)),
  'EPSG:32058': ProjectAndUnProjectResult(
      Point(x: -10457474.71770262, y: 22488066.022809565), Point(x: 0, y: 90)),
  'EPSG:32061': ProjectAndUnProjectResult(
      Point(x: 9646219.06494938, y: 6362764.2880742885),
      Point(x: 17.888058560281486, y: 46.89226404782306)),
  'EPSG:32062': ProjectAndUnProjectResult(
      Point(x: 9937895.34396208, y: 6420070.311478002),
      Point(x: 17.88805856028151, y: 46.892264047823055)),
  'EPSG:32064': ProjectAndUnProjectResult(
      Point(x: 5486456.889307273, y: 39954818.42034174), Point(x: 0, y: 90)),
  'EPSG:32065': ProjectAndUnProjectResult(
      Point(x: 10581530.491512235, y: 39417001.16199298), Point(x: 0, y: 90)),
  'EPSG:32066': ProjectAndUnProjectResult(
      Point(x: 14136410.596506024, y: 38068348.2853755), Point(x: 0, y: 90)),
  'EPSG:4079': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32067': ProjectAndUnProjectResult(
      Point(x: 16467677.464081096, y: 36235081.57002633), Point(x: 0, y: 90)),
  'EPSG:32074': ProjectAndUnProjectResult(
      Point(x: 5486456.889307273, y: 39954818.42034174), Point(x: 0, y: 90)),
  'EPSG:32075': ProjectAndUnProjectResult(
      Point(x: 10581530.491512235, y: 39417001.16199298), Point(x: 0, y: 90)),
  'EPSG:32076': ProjectAndUnProjectResult(
      Point(x: 14136410.596506024, y: 38068348.2853755), Point(x: 0, y: 90)),
  'EPSG:32077': ProjectAndUnProjectResult(
      Point(x: 16467677.464081096, y: 36235081.57002633), Point(x: 0, y: 90)),
  'EPSG:32081': ProjectAndUnProjectResult(
      Point(x: 5186632.024676061, y: 8120099.233874696),
      Point(x: 45, y: double.nan)),
  'EPSG:32082': ProjectAndUnProjectResult(
      Point(x: 5293654.478662069, y: 8403309.09255457),
      Point(x: 45, y: double.nan)),
  'EPSG:32083': ProjectAndUnProjectResult(
      Point(x: 5364906.447262949, y: 8649042.253562601),
      Point(x: 45, y: double.nan)),
  'EPSG:32084': ProjectAndUnProjectResult(
      Point(x: 5425654.034598166, y: 8954486.70998534),
      Point(x: 45, y: double.nan)),
  'EPSG:32085': ProjectAndUnProjectResult(
      Point(x: 5455436.685654514, y: 9269841.860248554),
      Point(x: 45, y: double.nan)),
  'EPSG:32086': ProjectAndUnProjectResult(
      Point(x: 5449562.187313349, y: 9592891.270385174),
      Point(x: 45, y: double.nan)),
  'EPSG:32098': ProjectAndUnProjectResult(
      Point(x: 5088215.637832019, y: 3830123.3104004664),
      Point(x: 17.88805856028151, y: 46.89226404782306)),
  'EPSG:32099': ProjectAndUnProjectResult(
      Point(x: 27652879.64726924, y: 19734613.33762063),
      Point(x: 17.8880585602815, y: 46.89226404782307)),
  'EPSG:32100': ProjectAndUnProjectResult(
      Point(x: 6556297.784221025, y: 6590553.712986213),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:32104': ProjectAndUnProjectResult(
      Point(x: 6975000.373432801, y: 6039872.843451777),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:32107': ProjectAndUnProjectResult(
      Point(x: -6407205.481935473, y: 14250720.322452161), Point(x: 0, y: 90)),
  'EPSG:32108': ProjectAndUnProjectResult(
      Point(x: -6848369.235542074, y: 11911589.980849914),
      Point(x: 189531435637.07315, y: 59487357072.499916)),
  'EPSG:32109': ProjectAndUnProjectResult(
      Point(x: -7945837.346430153, y: 9227187.99242025),
      Point(x: 53494776.36427391, y: 20053499.392547227)),
  'EPSG:32110': ProjectAndUnProjectResult(
      Point(x: 5368091.402649273, y: 5342638.370730873), Point(x: 0, y: 90)),
  'EPSG:4328': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32111': ProjectAndUnProjectResult(
      Point(x: 5111955.253111458, y: 6059884.249141174), Point(x: 0, y: 90)),
  'EPSG:32112': ProjectAndUnProjectResult(
      Point(x: -530531.6564737859, y: 8584058.195630815), Point(x: 0, y: 90)),
  'EPSG:32113': ProjectAndUnProjectResult(
      Point(x: -998074.9727628597, y: 8428106.011472125), Point(x: 0, y: 90)),
  'EPSG:32114': ProjectAndUnProjectResult(
      Point(x: -1388949.665557478, y: 8254150.647986836), Point(x: 0, y: 90)),
  'EPSG:32115': ProjectAndUnProjectResult(
      Point(x: 5111955.253111458, y: 6059884.249141174), Point(x: 0, y: 90)),
  'EPSG:32116': ProjectAndUnProjectResult(
      Point(x: 5102989.244976103, y: 6156462.138120647), Point(x: 0, y: 90)),
  'EPSG:32117': ProjectAndUnProjectResult(
      Point(x: 5070627.948794095, y: 6369472.582025805), Point(x: 0, y: 90)),
  'EPSG:32118': ProjectAndUnProjectResult(
      Point(x: 6120506.5914582675, y: 4115911.994870667),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:32119': ProjectAndUnProjectResult(
      Point(x: 7013164.842371999, y: 4867653.736840957),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:4330': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32120': ProjectAndUnProjectResult(
      Point(x: 6465460.630965634, y: 5661785.323388806),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:32121': ProjectAndUnProjectResult(
      Point(x: 6573964.729929726, y: 5741275.293893124),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:32122': ProjectAndUnProjectResult(
      Point(x: 6701563.894453452, y: 4762473.447759279),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:32123': ProjectAndUnProjectResult(
      Point(x: 6823927.076346041, y: 4856567.2808180135),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:32124': ProjectAndUnProjectResult(
      Point(x: 7606719.341866343, y: 6088830.052103923),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:32125': ProjectAndUnProjectResult(
      Point(x: 7788873.682746351, y: 6165418.092119623),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:32126': ProjectAndUnProjectResult(
      Point(x: 8597033.820587108, y: 7390016.602283895),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:32127': ProjectAndUnProjectResult(
      Point(x: 7874076.89548586, y: 7497850.224338042),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:32128': ProjectAndUnProjectResult(
      Point(x: 6522469.313095474, y: 4396559.711847568),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:32129': ProjectAndUnProjectResult(
      Point(x: 6583746.193120701, y: 4440183.096793512),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:32130': ProjectAndUnProjectResult(
      Point(x: 5173030.8098551845, y: 5481823.207905864), Point(x: 0, y: 90)),
  'EPSG:32133': ProjectAndUnProjectResult(
      Point(x: 7231101.448544078, y: 5119305.1873058975),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:32134': ProjectAndUnProjectResult(
      Point(x: 6731916.633515107, y: 5806582.369900572),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:32135': ProjectAndUnProjectResult(
      Point(x: 6870716.757738419, y: 5915239.061073107),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:32136': ProjectAndUnProjectResult(
      Point(x: 7240825.507643389, y: 5300270.815013457),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:32137': ProjectAndUnProjectResult(
      Point(x: 7393138.261094371, y: 7401668.656500031),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:32138': ProjectAndUnProjectResult(
      Point(x: 7989143.282984504, y: 8276494.464586326),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:32156': ProjectAndUnProjectResult(
      Point(x: -1585501.348464507, y: 7359986.274514455), Point(x: 0, y: 90)),
  'EPSG:32139': ProjectAndUnProjectResult(
      Point(x: 8418734.087582087, y: 9472776.726556078),
      Point(x: 17.88805856028155, y: 46.892264067008746)),
  'EPSG:32140': ProjectAndUnProjectResult(
      Point(x: 8486728.051005203, y: 10453504.590111742),
      Point(x: 17.88805856028154, y: 46.89226406700874)),
  'EPSG:32141': ProjectAndUnProjectResult(
      Point(x: 8484246.042842139, y: 11469435.827622361),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:32142': ProjectAndUnProjectResult(
      Point(x: 7132858.074758168, y: 7841015.069017461),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:32143': ProjectAndUnProjectResult(
      Point(x: 7316582.822330039, y: 8971163.047072299),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:32144': ProjectAndUnProjectResult(
      Point(x: 7595059.15054545, y: 10017430.541012172),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:32145': ProjectAndUnProjectResult(
      Point(x: 5541768.404689928, y: 5434133.661562179), Point(x: 0, y: 90)),
  'EPSG:32146': ProjectAndUnProjectResult(
      Point(x: 9634482.513941199, y: 6581020.355130133),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:32157': ProjectAndUnProjectResult(
      Point(x: -2061507.894929119, y: 7079113.201731387), Point(x: 0, y: 90)),
  'EPSG:32147': ProjectAndUnProjectResult(
      Point(x: 9723405.910334777, y: 5663039.725072842),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:32148': ProjectAndUnProjectResult(
      Point(x: 6208880.764422776, y: 7201291.121268816),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:32149': ProjectAndUnProjectResult(
      Point(x: 6409557.023981855, y: 7281838.145229915),
      Point(x: 17.88805856028154, y: 46.892264067008746)),
  'EPSG:32150': ProjectAndUnProjectResult(
      Point(x: 6701578.612677592, y: 4608732.256874052),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:32151': ProjectAndUnProjectResult(
      Point(x: 6860107.275988375, y: 4799756.489364472),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:32152': ProjectAndUnProjectResult(
      Point(x: 6517033.000426102, y: 4968571.836722961),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:32153': ProjectAndUnProjectResult(
      Point(x: 6611250.719513921, y: 5046926.8438626565),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:32154': ProjectAndUnProjectResult(
      Point(x: 6723783.25810189, y: 5169377.719135766),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:32155': ProjectAndUnProjectResult(
      Point(x: -835360.288822798, y: 7469523.565254046), Point(x: 0, y: 90)),
  'EPSG:32158': ProjectAndUnProjectResult(
      Point(x: -2539578.0552160507, y: 6974103.5782705145), Point(x: 0, y: 90)),
  'EPSG:32161': ProjectAndUnProjectResult(
      Point(x: 7328037.617013937, y: 5241769.00316173),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:32164': ProjectAndUnProjectResult(
      Point(x: 5487686.08144147, y: 39957420.242059514), Point(x: 0, y: 90)),
  'EPSG:32165': ProjectAndUnProjectResult(
      Point(x: 10582786.400749682, y: 39418797.66411147), Point(x: 0, y: 90)),
  'EPSG:32166': ProjectAndUnProjectResult(
      Point(x: 14137615.253530078, y: 38069538.76732615), Point(x: 0, y: 90)),
  'EPSG:32167': ProjectAndUnProjectResult(
      Point(x: 16468782.860413283, y: 36235825.00264775), Point(x: 0, y: 90)),
  'EPSG:32180': ProjectAndUnProjectResult(
      Point(x: 5277537.244089515, y: 8355177.8227729015),
      Point(x: -15979.524499782834, y: 3524.3478798098868)),
  'EPSG:32181': ProjectAndUnProjectResult(
      Point(x: 5186788.657734889, y: 8120071.285067176),
      Point(x: -5022.218661072394, y: 1175.203638907414)),
  'EPSG:32182': ProjectAndUnProjectResult(
      Point(x: 5293828.222920929, y: 8403290.068502737),
      Point(x: -20392.421758802197, y: 4476.186579255094)),
  'EPSG:32183': ProjectAndUnProjectResult(
      Point(x: 5365095.243901447, y: 8649032.835441044),
      Point(x: -76314.668724916, y: 16624.267920019753)),
  'EPSG:32184': ProjectAndUnProjectResult(
      Point(x: 5425861.74852327, y: 8954491.865918288),
      Point(x: -519603.48216074344, y: 113747.10753176517)),
  'EPSG:32185': ProjectAndUnProjectResult(
      Point(x: 5455664.100526009, y: 9269865.456694849),
      Point(x: -6859630.010890731, y: 1508686.9880534173)),
  'EPSG:32186': ProjectAndUnProjectResult(
      Point(x: 5449809.877896608, y: 9592937.814035818),
      Point(x: -411243275.37217355, y: 90346346.30780989)),
  'EPSG:32187': ProjectAndUnProjectResult(
      Point(x: 5403037.173898023, y: 9920877.559935424),
      Point(x: -34661211008946.938, y: 7546306826338.474)),
  'EPSG:32188': ProjectAndUnProjectResult(
      Point(x: 5309461.530223562, y: 10250138.320860693), Point(x: 0, y: 90)),
  'EPSG:32189': ProjectAndUnProjectResult(
      Point(x: 5162519.4015817605, y: 10576348.404652024), Point(x: 0, y: 90)),
  'EPSG:32190': ProjectAndUnProjectResult(
      Point(x: 4954908.029848009, y: 10894188.79017561), Point(x: 0, y: 90)),
  'EPSG:32191': ProjectAndUnProjectResult(
      Point(x: 4678521.605919208, y: 11197258.627550166), Point(x: 0, y: 90)),
  'EPSG:32192': ProjectAndUnProjectResult(
      Point(x: 4825851.505324784, y: 11048016.28656974), Point(x: 0, y: 90)),
  'EPSG:32193': ProjectAndUnProjectResult(
      Point(x: 4511768.526647326, y: 11340922.422261257), Point(x: 0, y: 90)),
  'EPSG:32194': ProjectAndUnProjectResult(
      Point(x: 4115096.9499727935, y: 11607101.102096744), Point(x: 0, y: 90)),
  'EPSG:32195': ProjectAndUnProjectResult(
      Point(x: 3625418.58528727, y: 11836768.953508014), Point(x: 0, y: 90)),
  'EPSG:32196': ProjectAndUnProjectResult(
      Point(x: 3031257.7643432096, y: 12018479.462197395), Point(x: 0, y: 90)),
  'EPSG:32197': ProjectAndUnProjectResult(
      Point(x: 2319999.2891139016, y: 12138921.625162058), Point(x: 0, y: 90)),
  'EPSG:32198': ProjectAndUnProjectResult(
      Point(x: 5088281.174172236, y: 3829932.5590575594),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:32199': ProjectAndUnProjectResult(
      Point(x: 8818988.21541754, y: 6033384.689384041),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:32201': ProjectAndUnProjectResult(
      Point(x: -633174.4840142361, y: 14694069.141018406),
      Point(x: 17.888058560281504, y: 46.89226406678145)),
  'EPSG:32202': ProjectAndUnProjectResult(
      Point(x: -176879.92327033705, y: 14764262.455915662),
      Point(x: 17.888058560281504, y: 46.89226406678145)),
  'EPSG:32203': ProjectAndUnProjectResult(
      Point(x: 280010.37915585114, y: 14798691.776552329),
      Point(x: 17.888058560281504, y: 46.89226406678147)),
  'EPSG:32204': ProjectAndUnProjectResult(
      Point(x: 737066.5557071505, y: 14798038.386871254),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:32205': ProjectAndUnProjectResult(
      Point(x: 1193943.4178246004, y: 14762289.301066155),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:32206': ProjectAndUnProjectResult(
      Point(x: 1650204.4734737936, y: 14690737.36414156),
      Point(x: 17.88805856028153, y: 46.892264066781436)),
  'EPSG:32207': ProjectAndUnProjectResult(
      Point(x: 2105137.826741025, y: 14581988.046991184),
      Point(x: 17.88805856028153, y: 46.892264066781465)),
  'EPSG:32208': ProjectAndUnProjectResult(
      Point(x: 2557548.7243285133, y: 14433980.820506137),
      Point(x: 17.888058560281554, y: 46.892264066781436)),
  'EPSG:32209': ProjectAndUnProjectResult(
      Point(x: 3005515.334270127, y: 14244042.12873936),
      Point(x: 17.888058560281554, y: 46.89226406678144)),
  'EPSG:32210': ProjectAndUnProjectResult(
      Point(x: 3446099.471231383, y: 14008998.508036066),
      Point(x: 17.88805856028153, y: 46.89226406678148)),
  'EPSG:32211': ProjectAndUnProjectResult(
      Point(x: 3875015.9521242925, y: 13725392.150150502),
      Point(x: 17.888058560281504, y: 46.89226406678145)),
  'EPSG:32212': ProjectAndUnProjectResult(
      Point(x: 4286288.2268442605, y: 13389854.1275776),
      Point(x: 17.888058560281515, y: 46.892264066781436)),
  'EPSG:32213': ProjectAndUnProjectResult(
      Point(x: 4671959.064797493, y: 12999693.79307196),
      Point(x: 17.88805856028153, y: 46.892264066781415)),
  'EPSG:32214': ProjectAndUnProjectResult(
      Point(x: 5021983.188442361, y: 12553739.183584167),
      Point(x: 17.888058560281504, y: 46.89226406678145)),
  'EPSG:4331': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32215': ProjectAndUnProjectResult(
      Point(x: 5324487.137026376, y: 12053388.670772329),
      Point(x: 17.888058560281465, y: 46.89226406678149)),
  'EPSG:32216': ProjectAndUnProjectResult(
      Point(x: 5566594.387574033, y: 11503694.17803215),
      Point(x: 17.88805856028158, y: 46.892264066781536)),
  'EPSG:32217': ProjectAndUnProjectResult(
      Point(x: 5735910.255016077, y: 10914122.153534275),
      Point(x: 17.88805856028172, y: 46.89226406678145)),
  'EPSG:32218': ProjectAndUnProjectResult(
      Point(x: 5822497.896746251, y: 10298540.722728362),
      Point(x: 17.888058560281642, y: 46.8922640667813)),
  'EPSG:32219': ProjectAndUnProjectResult(
      Point(x: 5820831.734081482, y: 9674115.365437346),
      Point(x: 17.88805856028136, y: 46.8922640667813)),
  'EPSG:32220': ProjectAndUnProjectResult(
      Point(x: 5731021.066957209, y: 9059212.15893914),
      Point(x: 17.88805856028131, y: 46.892264066781465)),
  'EPSG:32221': ProjectAndUnProjectResult(
      Point(x: 5558784.93505614, y: 8470906.193621092),
      Point(x: 17.888058560281465, y: 46.892264066781536)),
  'EPSG:32222': ProjectAndUnProjectResult(
      Point(x: 5314189.401990963, y: 7922913.842304071),
      Point(x: 17.88805856028157, y: 46.89226406678151)),
  'EPSG:32223': ProjectAndUnProjectResult(
      Point(x: 5009680.793656243, y: 7424530.698507313),
      Point(x: 17.888058560281554, y: 46.892264066781436)),
  'EPSG:32224': ProjectAndUnProjectResult(
      Point(x: 4658120.849163873, y: 6980655.121491416),
      Point(x: 17.88805856028151, y: 46.89226406678145)),
  'EPSG:4332': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32225': ProjectAndUnProjectResult(
      Point(x: 4271325.529518532, y: 6592569.288112628),
      Point(x: 17.88805856028152, y: 46.892264066781436)),
  'EPSG:32226': ProjectAndUnProjectResult(
      Point(x: 3859263.8422775073, y: 6259026.554177254),
      Point(x: 17.888058560281504, y: 46.89226406678145)),
  'EPSG:32227': ProjectAndUnProjectResult(
      Point(x: 3429815.443233207, y: 5977297.3861760665),
      Point(x: 17.888058560281515, y: 46.89226406678145)),
  'EPSG:32228': ProjectAndUnProjectResult(
      Point(x: 2988887.831753871, y: 5744000.440180303),
      Point(x: 17.888058560281507, y: 46.89226406678145)),
  'EPSG:32229': ProjectAndUnProjectResult(
      Point(x: 2540709.605352521, y: 5555682.985855328),
      Point(x: 17.88805856028152, y: 46.89226406678145)),
  'EPSG:32230': ProjectAndUnProjectResult(
      Point(x: 2088175.2388481195, y: 5409187.153929073),
      Point(x: 17.888058560281515, y: 46.89226406678145)),
  'EPSG:32231': ProjectAndUnProjectResult(
      Point(x: 1633174.4840142343, y: 5301860.745023588),
      Point(x: 17.888058560281515, y: 46.89226406678145)),
  'EPSG:32232': ProjectAndUnProjectResult(
      Point(x: 1176879.9232703357, y: 5231667.43012633),
      Point(x: 17.88805856028151, y: 46.89226406678145)),
  'EPSG:32233': ProjectAndUnProjectResult(
      Point(x: 719989.6208441482, y: 5197238.109489665),
      Point(x: 17.888058560281515, y: 46.89226406678145)),
  'EPSG:32234': ProjectAndUnProjectResult(
      Point(x: 262933.4442928486, y: 5197891.49917074),
      Point(x: 17.888058560281515, y: 46.89226406678145)),
  'EPSG:4333': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32235': ProjectAndUnProjectResult(
      Point(x: -193943.41782460047, y: 5233640.58497584),
      Point(x: 17.88805856028151, y: 46.892264066781436)),
  'EPSG:32236': ProjectAndUnProjectResult(
      Point(x: -650204.4734737936, y: 5305192.521900436),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:32237': ProjectAndUnProjectResult(
      Point(x: -1105137.8267410256, y: 5413941.839050807),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:32238': ProjectAndUnProjectResult(
      Point(x: -1557548.7243285135, y: 5561949.065535857),
      Point(x: 17.888058560281518, y: 46.892264066781436)),
  'EPSG:32239': ProjectAndUnProjectResult(
      Point(x: -2005515.3342701267, y: 5751887.757302632),
      Point(x: 17.88805856028154, y: 46.89226406678145)),
  'EPSG:32240': ProjectAndUnProjectResult(
      Point(x: -2446099.471231385, y: 5986931.378005927),
      Point(x: 17.88805856028151, y: 46.89226406678145)),
  'EPSG:32241': ProjectAndUnProjectResult(
      Point(x: -2875015.9521242925, y: 6270537.735891492),
      Point(x: 17.88805856028152, y: 46.89226406678145)),
  'EPSG:32242': ProjectAndUnProjectResult(
      Point(x: -3286288.2268442605, y: 6606075.758464395),
      Point(x: 17.888058560281515, y: 46.892264066781436)),
  'EPSG:32243': ProjectAndUnProjectResult(
      Point(x: -3671959.0647974927, y: 6996236.092970036),
      Point(x: 17.88805856028152, y: 46.892264066781415)),
  'EPSG:32244': ProjectAndUnProjectResult(
      Point(x: -4021983.1884423606, y: 7442190.7024578275),
      Point(x: 17.88805856028148, y: 46.89226406678145)),
  'EPSG:4334': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32245': ProjectAndUnProjectResult(
      Point(x: -4324487.137026376, y: 7942541.215269663),
      Point(x: 17.88805856028148, y: 46.89226406678149)),
  'EPSG:32246': ProjectAndUnProjectResult(
      Point(x: -4566594.387574033, y: 8492235.708009845),
      Point(x: 17.888058560281564, y: 46.892264066781536)),
  'EPSG:32247': ProjectAndUnProjectResult(
      Point(x: -4735910.255016076, y: 9081807.732507719),
      Point(x: 17.888058560281717, y: 46.89226406678146)),
  'EPSG:32248': ProjectAndUnProjectResult(
      Point(x: -4822497.896746251, y: 9697389.163313633),
      Point(x: 17.888058560281657, y: 46.8922640667813)),
  'EPSG:32249': ProjectAndUnProjectResult(
      Point(x: -4820831.734081482, y: 10321814.520604646),
      Point(x: 17.88805856028139, y: 46.8922640667813)),
  'EPSG:32250': ProjectAndUnProjectResult(
      Point(x: -4731021.066957209, y: 10936717.727102853),
      Point(x: 17.888058560281312, y: 46.892264066781465)),
  'EPSG:32251': ProjectAndUnProjectResult(
      Point(x: -4558784.93505614, y: 11525023.692420905),
      Point(x: 17.888058560281465, y: 46.892264066781536)),
  'EPSG:32252': ProjectAndUnProjectResult(
      Point(x: -4314189.401990963, y: 12073016.043737922),
      Point(x: 17.888058560281554, y: 46.89226406678151)),
  'EPSG:32253': ProjectAndUnProjectResult(
      Point(x: -4009680.793656243, y: 12571399.187534679),
      Point(x: 17.88805856028158, y: 46.89226406678145)),
  'EPSG:32254': ProjectAndUnProjectResult(
      Point(x: -3658120.8491638736, y: 13015274.764550578),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:4335': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32255': ProjectAndUnProjectResult(
      Point(x: -3271325.5295185316, y: 13403360.597929366),
      Point(x: 17.88805856028153, y: 46.892264066781436)),
  'EPSG:32256': ProjectAndUnProjectResult(
      Point(x: -2859263.8422775087, y: 13736903.33186474),
      Point(x: 17.888058560281504, y: 46.892264066781415)),
  'EPSG:32257': ProjectAndUnProjectResult(
      Point(x: -2429815.443233207, y: 14018632.499865927),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:32258': ProjectAndUnProjectResult(
      Point(x: -1988887.8317538733, y: 14251929.44586169),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:32259': ProjectAndUnProjectResult(
      Point(x: -1540709.6053525212, y: 14440246.900186665),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:32260': ProjectAndUnProjectResult(
      Point(x: -1088175.2388481197, y: 14586742.73211292),
      Point(x: 17.88805856028153, y: 46.892264066781436)),
  'EPSG:32301': ProjectAndUnProjectResult(
      Point(x: -633174.4840142361, y: 24694069.141018406),
      Point(x: 17.888058560281504, y: 46.89226406678145)),
  'EPSG:32302': ProjectAndUnProjectResult(
      Point(x: -176879.92327033705, y: 24764262.45591566),
      Point(x: 17.888058560281504, y: 46.892264066781465)),
  'EPSG:32303': ProjectAndUnProjectResult(
      Point(x: 280010.37915585114, y: 24798691.776552327),
      Point(x: 17.888058560281504, y: 46.89226406678147)),
  'EPSG:32304': ProjectAndUnProjectResult(
      Point(x: 737066.5557071505, y: 24798038.386871256),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:4336': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32305': ProjectAndUnProjectResult(
      Point(x: 1193943.4178246004, y: 24762289.301066153),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:32306': ProjectAndUnProjectResult(
      Point(x: 1650204.4734737936, y: 24690737.36414156),
      Point(x: 17.88805856028153, y: 46.892264066781436)),
  'EPSG:32307': ProjectAndUnProjectResult(
      Point(x: 2105137.826741025, y: 24581988.046991184),
      Point(x: 17.88805856028153, y: 46.892264066781465)),
  'EPSG:32308': ProjectAndUnProjectResult(
      Point(x: 2557548.7243285133, y: 24433980.820506137),
      Point(x: 17.888058560281554, y: 46.892264066781436)),
  'EPSG:32309': ProjectAndUnProjectResult(
      Point(x: 3005515.334270127, y: 24244042.12873936),
      Point(x: 17.888058560281554, y: 46.89226406678144)),
  'EPSG:32310': ProjectAndUnProjectResult(
      Point(x: 3446099.471231383, y: 24008998.508036066),
      Point(x: 17.88805856028153, y: 46.89226406678148)),
  'EPSG:32311': ProjectAndUnProjectResult(
      Point(x: 3875015.9521242925, y: 23725392.1501505),
      Point(x: 17.888058560281504, y: 46.89226406678147)),
  'EPSG:32312': ProjectAndUnProjectResult(
      Point(x: 4286288.2268442605, y: 23389854.1275776),
      Point(x: 17.888058560281515, y: 46.892264066781436)),
  'EPSG:32313': ProjectAndUnProjectResult(
      Point(x: 4671959.064797493, y: 22999693.79307196),
      Point(x: 17.88805856028153, y: 46.892264066781415)),
  'EPSG:32314': ProjectAndUnProjectResult(
      Point(x: 5021983.188442361, y: 22553739.18358417),
      Point(x: 17.888058560281504, y: 46.89226406678145)),
  'EPSG:32315': ProjectAndUnProjectResult(
      Point(x: 5324487.137026376, y: 22053388.67077233),
      Point(x: 17.888058560281465, y: 46.89226406678149)),
  'EPSG:32316': ProjectAndUnProjectResult(
      Point(x: 5566594.387574033, y: 21503694.178032152),
      Point(x: 17.88805856028158, y: 46.892264066781536)),
  'EPSG:32317': ProjectAndUnProjectResult(
      Point(x: 5735910.255016077, y: 20914122.153534275),
      Point(x: 17.88805856028172, y: 46.89226406678145)),
  'EPSG:32318': ProjectAndUnProjectResult(
      Point(x: 5822497.896746251, y: 20298540.722728364),
      Point(x: 17.888058560281657, y: 46.8922640667813)),
  'EPSG:32319': ProjectAndUnProjectResult(
      Point(x: 5820831.734081482, y: 19674115.365437344),
      Point(x: 17.888058560281355, y: 46.892264066781316)),
  'EPSG:32320': ProjectAndUnProjectResult(
      Point(x: 5731021.066957209, y: 19059212.158939138),
      Point(x: 17.8880585602813, y: 46.89226406678146)),
  'EPSG:32321': ProjectAndUnProjectResult(
      Point(x: 5558784.93505614, y: 18470906.19362109),
      Point(x: 17.888058560281465, y: 46.892264066781536)),
  'EPSG:32322': ProjectAndUnProjectResult(
      Point(x: 5314189.401990963, y: 17922913.842304073),
      Point(x: 17.888058560281586, y: 46.892264066781514)),
  'EPSG:32323': ProjectAndUnProjectResult(
      Point(x: 5009680.793656243, y: 17424530.698507313),
      Point(x: 17.888058560281554, y: 46.892264066781436)),
  'EPSG:32324': ProjectAndUnProjectResult(
      Point(x: 4658120.849163873, y: 16980655.121491417),
      Point(x: 17.88805856028152, y: 46.89226406678145)),
  'ESRI:37206': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:32325': ProjectAndUnProjectResult(
      Point(x: 4271325.529518532, y: 16592569.28811263),
      Point(x: 17.88805856028152, y: 46.892264066781436)),
  'EPSG:32326': ProjectAndUnProjectResult(
      Point(x: 3859263.8422775073, y: 16259026.554177254),
      Point(x: 17.888058560281504, y: 46.89226406678145)),
  'EPSG:32327': ProjectAndUnProjectResult(
      Point(x: 3429815.443233207, y: 15977297.386176066),
      Point(x: 17.888058560281515, y: 46.89226406678145)),
  'EPSG:32328': ProjectAndUnProjectResult(
      Point(x: 2988887.831753871, y: 15744000.440180302),
      Point(x: 17.888058560281507, y: 46.89226406678145)),
  'EPSG:32329': ProjectAndUnProjectResult(
      Point(x: 2540709.605352521, y: 15555682.985855328),
      Point(x: 17.88805856028152, y: 46.89226406678145)),
  'EPSG:32330': ProjectAndUnProjectResult(
      Point(x: 2088175.2388481195, y: 15409187.153929073),
      Point(x: 17.888058560281515, y: 46.89226406678145)),
  'EPSG:32331': ProjectAndUnProjectResult(
      Point(x: 1633174.4840142343, y: 15301860.745023588),
      Point(x: 17.888058560281515, y: 46.89226406678145)),
  'EPSG:32332': ProjectAndUnProjectResult(
      Point(x: 1176879.9232703357, y: 15231667.43012633),
      Point(x: 17.88805856028151, y: 46.89226406678145)),
  'EPSG:32333': ProjectAndUnProjectResult(
      Point(x: 719989.6208441482, y: 15197238.109489664),
      Point(x: 17.888058560281515, y: 46.89226406678145)),
  'EPSG:32334': ProjectAndUnProjectResult(
      Point(x: 262933.4442928486, y: 15197891.49917074),
      Point(x: 17.888058560281515, y: 46.89226406678145)),
  'ESRI:104018': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:32335': ProjectAndUnProjectResult(
      Point(x: -193943.41782460047, y: 15233640.584975839),
      Point(x: 17.888058560281515, y: 46.892264066781436)),
  'EPSG:32336': ProjectAndUnProjectResult(
      Point(x: -650204.4734737936, y: 15305192.521900436),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:32337': ProjectAndUnProjectResult(
      Point(x: -1105137.8267410256, y: 15413941.839050807),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:32338': ProjectAndUnProjectResult(
      Point(x: -1557548.7243285135, y: 15561949.065535858),
      Point(x: 17.88805856028151, y: 46.89226406678144)),
  'EPSG:32339': ProjectAndUnProjectResult(
      Point(x: -2005515.3342701267, y: 15751887.75730263),
      Point(x: 17.88805856028154, y: 46.892264066781436)),
  'EPSG:32340': ProjectAndUnProjectResult(
      Point(x: -2446099.471231385, y: 15986931.378005927),
      Point(x: 17.88805856028151, y: 46.89226406678145)),
  'EPSG:32341': ProjectAndUnProjectResult(
      Point(x: -2875015.9521242925, y: 16270537.735891491),
      Point(x: 17.88805856028153, y: 46.892264066781436)),
  'EPSG:32342': ProjectAndUnProjectResult(
      Point(x: -3286288.2268442605, y: 16606075.758464396),
      Point(x: 17.888058560281515, y: 46.892264066781436)),
  'EPSG:32343': ProjectAndUnProjectResult(
      Point(x: -3671959.0647974927, y: 16996236.092970036),
      Point(x: 17.88805856028152, y: 46.892264066781415)),
  'EPSG:32344': ProjectAndUnProjectResult(
      Point(x: -4021983.1884423606, y: 17442190.702457827),
      Point(x: 17.88805856028149, y: 46.89226406678144)),
  'ESRI:104109': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:32345': ProjectAndUnProjectResult(
      Point(x: -4324487.137026376, y: 17942541.215269662),
      Point(x: 17.88805856028149, y: 46.892264066781486)),
  'EPSG:32346': ProjectAndUnProjectResult(
      Point(x: -4566594.387574033, y: 18492235.708009847),
      Point(x: 17.888058560281554, y: 46.892264066781536)),
  'EPSG:32347': ProjectAndUnProjectResult(
      Point(x: -4735910.255016076, y: 19081807.73250772),
      Point(x: 17.888058560281706, y: 46.89226406678147)),
  'EPSG:32348': ProjectAndUnProjectResult(
      Point(x: -4822497.896746251, y: 19697389.163313635),
      Point(x: 17.888058560281642, y: 46.8922640667813)),
  'EPSG:32349': ProjectAndUnProjectResult(
      Point(x: -4820831.734081482, y: 20321814.520604648),
      Point(x: 17.88805856028136, y: 46.8922640667813)),
  'EPSG:32350': ProjectAndUnProjectResult(
      Point(x: -4731021.066957209, y: 20936717.727102853),
      Point(x: 17.888058560281312, y: 46.892264066781465)),
  'EPSG:32351': ProjectAndUnProjectResult(
      Point(x: -4558784.93505614, y: 21525023.692420907),
      Point(x: 17.888058560281454, y: 46.892264066781536)),
  'EPSG:32352': ProjectAndUnProjectResult(
      Point(x: -4314189.401990963, y: 22073016.043737922),
      Point(x: 17.888058560281554, y: 46.89226406678151)),
  'EPSG:32353': ProjectAndUnProjectResult(
      Point(x: -4009680.793656243, y: 22571399.18753468),
      Point(x: 17.88805856028158, y: 46.89226406678145)),
  'EPSG:32354': ProjectAndUnProjectResult(
      Point(x: -3658120.8491638736, y: 23015274.764550578),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'ESRI:104110': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:32355': ProjectAndUnProjectResult(
      Point(x: -3271325.5295185316, y: 23403360.597929366),
      Point(x: 17.88805856028153, y: 46.892264066781436)),
  'EPSG:32356': ProjectAndUnProjectResult(
      Point(x: -2859263.8422775087, y: 23736903.33186474),
      Point(x: 17.888058560281504, y: 46.892264066781415)),
  'EPSG:32357': ProjectAndUnProjectResult(
      Point(x: -2429815.443233207, y: 24018632.499865927),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:32358': ProjectAndUnProjectResult(
      Point(x: -1988887.8317538733, y: 24251929.44586169),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:32359': ProjectAndUnProjectResult(
      Point(x: -1540709.6053525212, y: 24440246.900186665),
      Point(x: 17.88805856028153, y: 46.89226406678144)),
  'EPSG:32360': ProjectAndUnProjectResult(
      Point(x: -1088175.2388481197, y: 24586742.73211292),
      Point(x: 17.88805856028153, y: 46.892264066781436)),
  'EPSG:32401': ProjectAndUnProjectResult(
      Point(x: -633168.6562950208, y: 14694068.447794057),
      Point(x: 17.888058560281543, y: 46.892264066564145)),
  'EPSG:32402': ProjectAndUnProjectResult(
      Point(x: -176874.2250710379, y: 14764261.321916804),
      Point(x: 17.888058560281493, y: 46.89226406656414)),
  'EPSG:32403': ProjectAndUnProjectResult(
      Point(x: 280015.9453936276, y: 14798690.21619366),
      Point(x: 17.888058560281493, y: 46.8922640665641)),
  'EPSG:32404': ProjectAndUnProjectResult(
      Point(x: 737071.986963561, y: 14798036.405561138),
      Point(x: 17.888058560281518, y: 46.89226406656411)),
  'EPSG:32405': ProjectAndUnProjectResult(
      Point(x: 1193948.7083593074, y: 14762286.895858888),
      Point(x: 17.888058560281518, y: 46.89226406656413)),
  'EPSG:32406': ProjectAndUnProjectResult(
      Point(x: 1650209.6127009403, y: 14690734.524455598),
      Point(x: 17.888058560281518, y: 46.89226406656414)),
  'EPSG:32407': ProjectAndUnProjectResult(
      Point(x: 2105142.7969488017, y: 14581984.755500222),
      Point(x: 17.888058560281518, y: 46.892264066564145)),
  'EPSG:32408': ProjectAndUnProjectResult(
      Point(x: 2557553.498113487, y: 14433977.054405503),
      Point(x: 17.888058560281518, y: 46.892264066564145)),
  'EPSG:32409': ProjectAndUnProjectResult(
      Point(x: 3005519.8716324354, y: 14244037.861701552),
      Point(x: 17.888058560281518, y: 46.89226406656411)),
  'EPSG:32410': ProjectAndUnProjectResult(
      Point(x: 3446103.7164204125, y: 14008993.713293431),
      Point(x: 17.888058560281518, y: 46.89226406656414)),
  'EPSG:32411': ProjectAndUnProjectResult(
      Point(x: 3875019.830584015, y: 13725386.805248741),
      Point(x: 17.888058560281493, y: 46.89226406656411)),
  'EPSG:32412': ProjectAndUnProjectResult(
      Point(x: 4286291.643030327, y: 13389848.221343672),
      Point(x: 17.888058560281507, y: 46.89226406656413)),
  'EPSG:32413': ProjectAndUnProjectResult(
      Point(x: 4671961.902221667, y: 12999687.335066427),
      Point(x: 17.88805856028152, y: 46.8922640665641)),
  'EPSG:32414': ProjectAndUnProjectResult(
      Point(x: 5021985.313885943, y: 12553732.215521969),
      Point(x: 17.888058560281472, y: 46.89226406656411)),
  'EPSG:32415': ProjectAndUnProjectResult(
      Point(x: 5324488.411004737, y: 12053381.277928732),
      Point(x: 17.888058560281472, y: 46.89226406656415)),
  'EPSG:32416': ProjectAndUnProjectResult(
      Point(x: 5566594.682086644, y: 11503686.496753147),
      Point(x: 17.88805856028157, y: 46.892264066564216)),
  'EPSG:32417': ProjectAndUnProjectResult(
      Point(x: 5735909.4767924, y: 10914114.36973618),
      Point(x: 17.888058560281696, y: 46.892264066564145)),
  'EPSG:32418': ProjectAndUnProjectResult(
      Point(x: 5822496.01018585, y: 10298533.057481328),
      Point(x: 17.88805856028163, y: 46.89226406656399)),
  'EPSG:32419': ProjectAndUnProjectResult(
      Point(x: 5820828.775372859, y: 9674108.048383996),
      Point(x: 17.88805856028138, y: 46.892264066563975)),
  'EPSG:32420': ProjectAndUnProjectResult(
      Point(x: 5731017.142523042, y: 9059205.396578167),
      Point(x: 17.8880585602813, y: 46.892264066564145)),
  'EPSG:32421': ProjectAndUnProjectResult(
      Point(x: 5558780.203864786, y: 8470900.142974967),
      Point(x: 17.88805856028148, y: 46.892264066564195)),
  'EPSG:32422': ProjectAndUnProjectResult(
      Point(x: 5314184.048438756, y: 7922908.5980711635),
      Point(x: 17.888058560281575, y: 46.892264066564145)),
  'EPSG:32423': ProjectAndUnProjectResult(
      Point(x: 5009675.000687454, y: 7424526.295169189),
      Point(x: 17.888058560281557, y: 46.89226406656411)),
  'EPSG:32424': ProjectAndUnProjectResult(
      Point(x: 4658114.778832436, y: 6980651.545875812),
      Point(x: 17.88805856028154, y: 46.8922640665641)),
  'EPSG:32425': ProjectAndUnProjectResult(
      Point(x: 4271319.313260295, y: 6592566.495860199),
      Point(x: 17.888058560281525, y: 46.892264066564096)),
  'EPSG:32426': ProjectAndUnProjectResult(
      Point(x: 3859257.579273214, y: 6259024.484999685),
      Point(x: 17.888058560281507, y: 46.89226406656411)),
  'EPSG:32427': ProjectAndUnProjectResult(
      Point(x: 3429809.203748187, y: 5977295.975445289),
      Point(x: 17.888058560281525, y: 46.8922640665641)),
  'EPSG:32428': ProjectAndUnProjectResult(
      Point(x: 2988881.6626370074, y: 5743999.626505502),
      Point(x: 17.888058560281518, y: 46.8922640665641)),
  'EPSG:32429': ProjectAndUnProjectResult(
      Point(x: 2540703.5358530274, y: 5555682.715379689),
      Point(x: 17.888058560281515, y: 46.8922640665641)),
  'EPSG:32430': ProjectAndUnProjectResult(
      Point(x: 2088169.285833557, y: 5409187.382354749),
      Point(x: 17.888058560281515, y: 46.89226406656411)),
  'EPSG:32431': ProjectAndUnProjectResult(
      Point(x: 1633168.6562950192, y: 5301861.438247937),
      Point(x: 17.88805856028152, y: 46.89226406656413)),
  'EPSG:32432': ProjectAndUnProjectResult(
      Point(x: 1176874.2250710377, y: 5231668.56412519),
      Point(x: 17.888058560281532, y: 46.89226406656411)),
  'EPSG:32433': ProjectAndUnProjectResult(
      Point(x: 719984.0546063725, y: 5197239.669848337),
      Point(x: 17.888058560281532, y: 46.89226406656411)),
  'EPSG:32434': ProjectAndUnProjectResult(
      Point(x: 262928.01303643873, y: 5197893.48048086),
      Point(x: 17.888058560281518, y: 46.8922640665641)),
  'EPSG:32435': ProjectAndUnProjectResult(
      Point(x: -193948.7083593069, y: 5233642.990183105),
      Point(x: 17.888058560281518, y: 46.89226406656411)),
  'EPSG:32436': ProjectAndUnProjectResult(
      Point(x: -650209.612700939, y: 5305195.361586394),
      Point(x: 17.88805856028152, y: 46.8922640665641)),
  'EPSG:32437': ProjectAndUnProjectResult(
      Point(x: -1105142.7969488017, y: 5413945.13054177),
      Point(x: 17.888058560281532, y: 46.89226406656411)),
  'EPSG:32438': ProjectAndUnProjectResult(
      Point(x: -1557553.4981134867, y: 5561952.83163649),
      Point(x: 17.888058560281515, y: 46.89226406656413)),
  'EPSG:32439': ProjectAndUnProjectResult(
      Point(x: -2005519.871632433, y: 5751892.024340444),
      Point(x: 17.888058560281543, y: 46.89226406656411)),
  'EPSG:32440': ProjectAndUnProjectResult(
      Point(x: -2446103.7164204125, y: 5986936.172748564),
      Point(x: 17.88805856028153, y: 46.8922640665641)),
  'EPSG:32441': ProjectAndUnProjectResult(
      Point(x: -2875019.830584015, y: 6270543.080793251),
      Point(x: 17.888058560281515, y: 46.892264066564096)),
  'EPSG:32442': ProjectAndUnProjectResult(
      Point(x: -3286291.643030325, y: 6606081.664698319),
      Point(x: 17.888058560281515, y: 46.89226406656411)),
  'EPSG:32443': ProjectAndUnProjectResult(
      Point(x: -3671961.9022216666, y: 6996242.550975568),
      Point(x: 17.888058560281515, y: 46.8922640665641)),
  'EPSG:32444': ProjectAndUnProjectResult(
      Point(x: -4021985.313885941, y: 7442197.670520026),
      Point(x: 17.888058560281472, y: 46.89226406656411)),
  'EPSG:32445': ProjectAndUnProjectResult(
      Point(x: -4324488.411004737, y: 7942548.608113263),
      Point(x: 17.888058560281472, y: 46.89226406656415)),
  'EPSG:32446': ProjectAndUnProjectResult(
      Point(x: -4566594.682086644, y: 8492243.389288845),
      Point(x: 17.888058560281582, y: 46.89226406656421)),
  'EPSG:32447': ProjectAndUnProjectResult(
      Point(x: -4735909.4767924, y: 9081815.516305814),
      Point(x: 17.88805856028171, y: 46.89226406656414)),
  'EPSG:32448': ProjectAndUnProjectResult(
      Point(x: -4822496.01018585, y: 9697396.828560665),
      Point(x: 17.88805856028166, y: 46.89226406656399)),
  'EPSG:32449': ProjectAndUnProjectResult(
      Point(x: -4820828.775372859, y: 10321821.837658),
      Point(x: 17.888058560281365, y: 46.892264066563975)),
  'EPSG:32450': ProjectAndUnProjectResult(
      Point(x: -4731017.142523042, y: 10936724.489463827),
      Point(x: 17.88805856028133, y: 46.89226406656414)),
  'EPSG:32451': ProjectAndUnProjectResult(
      Point(x: -4558780.203864786, y: 11525029.743067028),
      Point(x: 17.88805856028148, y: 46.892264066564195)),
  'EPSG:32452': ProjectAndUnProjectResult(
      Point(x: -4314184.048438756, y: 12073021.28797083),
      Point(x: 17.888058560281557, y: 46.892264066564145)),
  'EPSG:32453': ProjectAndUnProjectResult(
      Point(x: -4009675.000687454, y: 12571403.590872804),
      Point(x: 17.88805856028157, y: 46.89226406656413)),
  'EPSG:32454': ProjectAndUnProjectResult(
      Point(x: -3658114.7788324337, y: 13015278.340166181),
      Point(x: 17.888058560281543, y: 46.89226406656411)),
  'EPSG:32455': ProjectAndUnProjectResult(
      Point(x: -3271319.3132602954, y: 13403363.390181793),
      Point(x: 17.888058560281518, y: 46.89226406656411)),
  'EPSG:32456': ProjectAndUnProjectResult(
      Point(x: -2859257.5792732155, y: 13736905.401042307),
      Point(x: 17.88805856028157, y: 46.892264066564145)),
  'EPSG:32457': ProjectAndUnProjectResult(
      Point(x: -2429809.203748186, y: 14018633.910596702),
      Point(x: 17.888058560281518, y: 46.89226406656413)),
  'EPSG:32458': ProjectAndUnProjectResult(
      Point(x: -1988881.6626370093, y: 14251930.25953649),
      Point(x: 17.888058560281518, y: 46.89226406656413)),
  'EPSG:32459': ProjectAndUnProjectResult(
      Point(x: -1540703.5358530283, y: 14440247.170662306),
      Point(x: 17.888058560281518, y: 46.89226406656411)),
  'EPSG:32460': ProjectAndUnProjectResult(
      Point(x: -1088169.285833557, y: 14586742.503687244),
      Point(x: 17.888058560281518, y: 46.89226406656414)),
  'EPSG:32501': ProjectAndUnProjectResult(
      Point(x: -633168.6562950208, y: 24694068.447794057),
      Point(x: 17.888058560281543, y: 46.892264066564145)),
  'EPSG:32502': ProjectAndUnProjectResult(
      Point(x: -176874.2250710379, y: 24764261.321916804),
      Point(x: 17.888058560281493, y: 46.89226406656414)),
  'EPSG:32503': ProjectAndUnProjectResult(
      Point(x: 280015.9453936276, y: 24798690.21619366),
      Point(x: 17.888058560281493, y: 46.8922640665641)),
  'EPSG:32504': ProjectAndUnProjectResult(
      Point(x: 737071.986963561, y: 24798036.405561138),
      Point(x: 17.888058560281518, y: 46.89226406656411)),
  'EPSG:32505': ProjectAndUnProjectResult(
      Point(x: 1193948.7083593074, y: 24762286.895858888),
      Point(x: 17.888058560281518, y: 46.89226406656413)),
  'EPSG:32506': ProjectAndUnProjectResult(
      Point(x: 1650209.6127009403, y: 24690734.5244556),
      Point(x: 17.88805856028152, y: 46.8922640665641)),
  'EPSG:32507': ProjectAndUnProjectResult(
      Point(x: 2105142.7969488017, y: 24581984.75550022),
      Point(x: 17.888058560281518, y: 46.892264066564145)),
  'EPSG:32508': ProjectAndUnProjectResult(
      Point(x: 2557553.498113487, y: 24433977.054405503),
      Point(x: 17.888058560281518, y: 46.892264066564145)),
  'EPSG:32509': ProjectAndUnProjectResult(
      Point(x: 3005519.8716324354, y: 24244037.86170155),
      Point(x: 17.888058560281518, y: 46.89226406656411)),
  'EPSG:32510': ProjectAndUnProjectResult(
      Point(x: 3446103.7164204125, y: 24008993.713293433),
      Point(x: 17.88805856028152, y: 46.8922640665641)),
  'EPSG:32511': ProjectAndUnProjectResult(
      Point(x: 3875019.830584015, y: 23725386.80524874),
      Point(x: 17.888058560281493, y: 46.89226406656411)),
  'EPSG:32512': ProjectAndUnProjectResult(
      Point(x: 4286291.643030327, y: 23389848.221343674),
      Point(x: 17.888058560281507, y: 46.89226406656411)),
  'EPSG:32513': ProjectAndUnProjectResult(
      Point(x: 4671961.902221667, y: 22999687.335066427),
      Point(x: 17.88805856028152, y: 46.8922640665641)),
  'EPSG:32514': ProjectAndUnProjectResult(
      Point(x: 5021985.313885943, y: 22553732.21552197),
      Point(x: 17.888058560281472, y: 46.89226406656411)),
  'EPSG:32515': ProjectAndUnProjectResult(
      Point(x: 5324488.411004737, y: 22053381.277928732),
      Point(x: 17.888058560281472, y: 46.89226406656415)),
  'EPSG:32516': ProjectAndUnProjectResult(
      Point(x: 5566594.682086644, y: 21503686.49675315),
      Point(x: 17.888058560281582, y: 46.89226406656421)),
  'EPSG:32517': ProjectAndUnProjectResult(
      Point(x: 5735909.4767924, y: 20914114.36973618),
      Point(x: 17.888058560281696, y: 46.892264066564145)),
  'EPSG:32518': ProjectAndUnProjectResult(
      Point(x: 5822496.01018585, y: 20298533.057481326),
      Point(x: 17.88805856028162, y: 46.89226406656399)),
  'EPSG:32519': ProjectAndUnProjectResult(
      Point(x: 5820828.775372859, y: 19674108.048383996),
      Point(x: 17.88805856028138, y: 46.892264066563975)),
  'EPSG:32520': ProjectAndUnProjectResult(
      Point(x: 5731017.142523042, y: 19059205.396578167),
      Point(x: 17.8880585602813, y: 46.892264066564145)),
  'EPSG:32521': ProjectAndUnProjectResult(
      Point(x: 5558780.203864786, y: 18470900.142974965),
      Point(x: 17.888058560281454, y: 46.892264066564195)),
  'EPSG:32522': ProjectAndUnProjectResult(
      Point(x: 5314184.048438756, y: 17922908.598071165),
      Point(x: 17.888058560281593, y: 46.892264066564145)),
  'EPSG:32523': ProjectAndUnProjectResult(
      Point(x: 5009675.000687454, y: 17424526.29516919),
      Point(x: 17.888058560281557, y: 46.89226406656411)),
  'EPSG:32524': ProjectAndUnProjectResult(
      Point(x: 4658114.778832436, y: 16980651.54587581),
      Point(x: 17.888058560281518, y: 46.89226406656409)),
  'EPSG:32525': ProjectAndUnProjectResult(
      Point(x: 4271319.313260295, y: 16592566.4958602),
      Point(x: 17.88805856028154, y: 46.8922640665641)),
  'EPSG:32526': ProjectAndUnProjectResult(
      Point(x: 3859257.579273214, y: 16259024.484999685),
      Point(x: 17.888058560281507, y: 46.89226406656411)),
  'EPSG:32527': ProjectAndUnProjectResult(
      Point(x: 3429809.203748187, y: 15977295.97544529),
      Point(x: 17.888058560281525, y: 46.8922640665641)),
  'EPSG:32528': ProjectAndUnProjectResult(
      Point(x: 2988881.6626370074, y: 15743999.626505502),
      Point(x: 17.888058560281518, y: 46.8922640665641)),
  'EPSG:32529': ProjectAndUnProjectResult(
      Point(x: 2540703.5358530274, y: 15555682.715379689),
      Point(x: 17.888058560281515, y: 46.8922640665641)),
  'EPSG:32530': ProjectAndUnProjectResult(
      Point(x: 2088169.285833557, y: 15409187.38235475),
      Point(x: 17.888058560281515, y: 46.89226406656411)),
  'EPSG:32531': ProjectAndUnProjectResult(
      Point(x: 1633168.6562950192, y: 15301861.438247938),
      Point(x: 17.88805856028152, y: 46.89226406656413)),
  'EPSG:32532': ProjectAndUnProjectResult(
      Point(x: 1176874.2250710377, y: 15231668.56412519),
      Point(x: 17.888058560281532, y: 46.89226406656411)),
  'EPSG:32533': ProjectAndUnProjectResult(
      Point(x: 719984.0546063725, y: 15197239.669848338),
      Point(x: 17.888058560281532, y: 46.89226406656411)),
  'EPSG:32534': ProjectAndUnProjectResult(
      Point(x: 262928.01303643873, y: 15197893.48048086),
      Point(x: 17.888058560281515, y: 46.89226406656411)),
  'EPSG:32535': ProjectAndUnProjectResult(
      Point(x: -193948.7083593069, y: 15233642.990183104),
      Point(x: 17.88805856028152, y: 46.8922640665641)),
  'EPSG:32536': ProjectAndUnProjectResult(
      Point(x: -650209.612700939, y: 15305195.361586394),
      Point(x: 17.88805856028152, y: 46.8922640665641)),
  'EPSG:32537': ProjectAndUnProjectResult(
      Point(x: -1105142.7969488017, y: 15413945.13054177),
      Point(x: 17.888058560281532, y: 46.89226406656411)),
  'EPSG:32538': ProjectAndUnProjectResult(
      Point(x: -1557553.4981134867, y: 15561952.83163649),
      Point(x: 17.888058560281515, y: 46.89226406656413)),
  'EPSG:32539': ProjectAndUnProjectResult(
      Point(x: -2005519.871632433, y: 15751892.024340443),
      Point(x: 17.888058560281543, y: 46.8922640665641)),
  'EPSG:32540': ProjectAndUnProjectResult(
      Point(x: -2446103.7164204125, y: 15986936.172748564),
      Point(x: 17.88805856028153, y: 46.8922640665641)),
  'EPSG:32541': ProjectAndUnProjectResult(
      Point(x: -2875019.830584015, y: 16270543.08079325),
      Point(x: 17.888058560281525, y: 46.892264066564096)),
  'EPSG:32542': ProjectAndUnProjectResult(
      Point(x: -3286291.643030325, y: 16606081.664698318),
      Point(x: 17.888058560281518, y: 46.89226406656411)),
  'EPSG:32543': ProjectAndUnProjectResult(
      Point(x: -3671961.9022216666, y: 16996242.55097557),
      Point(x: 17.888058560281515, y: 46.8922640665641)),
  'EPSG:32544': ProjectAndUnProjectResult(
      Point(x: -4021985.313885941, y: 17442197.670520026),
      Point(x: 17.888058560281472, y: 46.89226406656411)),
  'EPSG:32545': ProjectAndUnProjectResult(
      Point(x: -4324488.411004737, y: 17942548.608113263),
      Point(x: 17.888058560281472, y: 46.89226406656415)),
  'EPSG:32546': ProjectAndUnProjectResult(
      Point(x: -4566594.682086644, y: 18492243.389288843),
      Point(x: 17.888058560281607, y: 46.89226406656421)),
  'EPSG:32547': ProjectAndUnProjectResult(
      Point(x: -4735909.4767924, y: 19081815.51630581),
      Point(x: 17.88805856028172, y: 46.892264066564145)),
  'EPSG:32548': ProjectAndUnProjectResult(
      Point(x: -4822496.01018585, y: 19697396.828560665),
      Point(x: 17.88805856028166, y: 46.89226406656399)),
  'EPSG:32549': ProjectAndUnProjectResult(
      Point(x: -4820828.775372859, y: 20321821.837658),
      Point(x: 17.888058560281365, y: 46.892264066563975)),
  'EPSG:32550': ProjectAndUnProjectResult(
      Point(x: -4731017.142523042, y: 20936724.48946383),
      Point(x: 17.8880585602813, y: 46.892264066564145)),
  'EPSG:32551': ProjectAndUnProjectResult(
      Point(x: -4558780.203864786, y: 21525029.743067026),
      Point(x: 17.888058560281493, y: 46.892264066564195)),
  'EPSG:32552': ProjectAndUnProjectResult(
      Point(x: -4314184.048438756, y: 22073021.28797083),
      Point(x: 17.888058560281557, y: 46.892264066564145)),
  'EPSG:32553': ProjectAndUnProjectResult(
      Point(x: -4009675.000687454, y: 22571403.5908728),
      Point(x: 17.8880585602816, y: 46.89226406656414)),
  'EPSG:32554': ProjectAndUnProjectResult(
      Point(x: -3658114.7788324337, y: 23015278.34016618),
      Point(x: 17.888058560281543, y: 46.89226406656411)),
  'EPSG:32555': ProjectAndUnProjectResult(
      Point(x: -3271319.3132602954, y: 23403363.390181795),
      Point(x: 17.888058560281518, y: 46.89226406656411)),
  'EPSG:32556': ProjectAndUnProjectResult(
      Point(x: -2859257.5792732155, y: 23736905.401042305),
      Point(x: 17.88805856028157, y: 46.892264066564145)),
  'EPSG:32557': ProjectAndUnProjectResult(
      Point(x: -2429809.203748186, y: 24018633.910596702),
      Point(x: 17.888058560281518, y: 46.89226406656413)),
  'EPSG:32558': ProjectAndUnProjectResult(
      Point(x: -1988881.6626370093, y: 24251930.25953649),
      Point(x: 17.888058560281518, y: 46.89226406656413)),
  'EPSG:32559': ProjectAndUnProjectResult(
      Point(x: -1540703.5358530283, y: 24440247.170662306),
      Point(x: 17.888058560281518, y: 46.89226406656411)),
  'EPSG:32560': ProjectAndUnProjectResult(
      Point(x: -1088169.285833557, y: 24586742.503687244),
      Point(x: 17.888058560281518, y: 46.89226406656414)),
  'EPSG:32601': ProjectAndUnProjectResult(
      Point(x: -633185.5802425162, y: 14694063.811206872),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:32602': ProjectAndUnProjectResult(
      Point(x: -176891.2861509861, y: 14764258.052093428),
      Point(x: 17.888058560281486, y: 46.892264067008774)),
  'EPSG:32603': ProjectAndUnProjectResult(
      Point(x: 279998.770163635, y: 14798688.27594924),
      Point(x: 17.888058560281486, y: 46.892264067008774)),
  'EPSG:32604': ProjectAndUnProjectResult(
      Point(x: 737054.7120343816, y: 14798035.783310786),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:4337': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32623': ProjectAndUnProjectResult(
      Point(x: 5009686.094046778, y: 7424545.011189611),
      Point(x: 17.88805856028155, y: 46.892264067008796)),
  'EPSG:32624': ProjectAndUnProjectResult(
      Point(x: 4658127.571844883, y: 6980668.281005512),
      Point(x: 17.888058560281525, y: 46.892264067008774)),
  'EPSG:32625': ProjectAndUnProjectResult(
      Point(x: 4271333.391910846, y: 6592581.225099734),
      Point(x: 17.888058560281507, y: 46.892264067008774)),
  'EPSG:32626': ProjectAndUnProjectResult(
      Point(x: 3859272.6009777463, y: 6259037.263767835),
      Point(x: 17.8880585602815, y: 46.892264067008774)),
  'EPSG:32627': ProjectAndUnProjectResult(
      Point(x: 3429824.901141373, y: 5977306.903716863),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:32628': ProjectAndUnProjectResult(
      Point(x: 2988897.836864297, y: 5744008.82163434),
      Point(x: 17.888058560281504, y: 46.89226406700879)),
  'EPSG:32629': ProjectAndUnProjectResult(
      Point(x: 2540720.0452914257, y: 5555690.2936510425),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:32630': ProjectAndUnProjectResult(
      Point(x: 2088186.0339150208, y: 5409193.447504683),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:32631': ProjectAndUnProjectResult(
      Point(x: 1633185.5802425153, y: 5301866.074835123),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:32632': ProjectAndUnProjectResult(
      Point(x: 1176891.2861509859, y: 5231671.833948568),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:32633': ProjectAndUnProjectResult(
      Point(x: 720001.2298363654, y: 5197241.610092757),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6309': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32634': ProjectAndUnProjectResult(
      Point(x: 262945.28796561854, y: 5197894.1027312055),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:32635': ProjectAndUnProjectResult(
      Point(x: -193931.34631864005, y: 5233642.279820906),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:32636': ProjectAndUnProjectResult(
      Point(x: -650192.180968157, y: 5305193.277388473),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:32637': ProjectAndUnProjectResult(
      Point(x: -1105125.3250947963, y: 5413941.6045829635),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:32638': ProjectAndUnProjectResult(
      Point(x: -1557536.0363929619, y: 5561947.769911137),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:32639': ProjectAndUnProjectResult(
      Point(x: -2005502.501230997, y: 5751885.308911241),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:32640': ProjectAndUnProjectResult(
      Point(x: -2446086.561661094, y: 5986927.666737254),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:32641': ProjectAndUnProjectResult(
      Point(x: -2875003.0727375876, y: 6270532.638111774),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:32642': ProjectAndUnProjectResult(
      Point(x: -3286275.5342021994, y: 6606069.146895197),
      Point(x: 17.888058560281525, y: 46.89226406700879)),
  'EPSG:32643': ProjectAndUnProjectResult(
      Point(x: -3671946.775863947, y: 6996227.853470685),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:32644': ProjectAndUnProjectResult(
      Point(x: -4021971.5859753974, y: 7442180.758983059),
      Point(x: 17.888058560281486, y: 46.892264067008796)),
  'EPSG:7660': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32645': ProjectAndUnProjectResult(
      Point(x: -4324476.563887302, y: 7942529.561834344),
      Point(x: 17.888058560281475, y: 46.89226406700883)),
  'EPSG:32646': ProjectAndUnProjectResult(
      Point(x: -4566585.2237567445, y: 8492222.44195507),
      Point(x: 17.88805856028155, y: 46.89226406700888)),
  'EPSG:32647': ProjectAndUnProjectResult(
      Point(x: -4735902.874809236, y: 9081793.077999711),
      Point(x: 17.888058560281717, y: 46.89226406700881)),
  'EPSG:32648': ProjectAndUnProjectResult(
      Point(x: -4822492.611904318, y: 9697373.47163477),
      Point(x: 17.888058560281664, y: 46.89226406700865)),
  'EPSG:32649': ProjectAndUnProjectResult(
      Point(x: -4820828.738923764, y: 10321798.238985082),
      Point(x: 17.888058560281372, y: 46.89226406700865)),
  'EPSG:32650': ProjectAndUnProjectResult(
      Point(x: -4731020.405434482, y: 10936701.340827035),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:32651': ProjectAndUnProjectResult(
      Point(x: -4558786.5024349885, y: 11525007.658312105),
      Point(x: 17.888058560281475, y: 46.89226406700889)),
  'EPSG:32652': ProjectAndUnProjectResult(
      Point(x: -4314192.978401657, y: 12073000.736903511),
      Point(x: 17.88805856028155, y: 46.892264067008846)),
  'EPSG:32653': ProjectAndUnProjectResult(
      Point(x: -4009686.094046779, y: 12571384.874852385),
      Point(x: 17.88805856028154, y: 46.89226406700879)),
  'EPSG:32654': ProjectAndUnProjectResult(
      Point(x: -3658127.571844882, y: 13015261.605036484),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:32655': ProjectAndUnProjectResult(
      Point(x: -3271333.3919108487, y: 13403348.66094226),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:7662': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:32656': ProjectAndUnProjectResult(
      Point(x: -2859272.6009777463, y: 13736892.62227416),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:32657': ProjectAndUnProjectResult(
      Point(x: -2429824.901141373, y: 14018622.982325131),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:32658': ProjectAndUnProjectResult(
      Point(x: -1988897.8368642977, y: 14251921.064407652),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:32659': ProjectAndUnProjectResult(
      Point(x: -1540720.045291426, y: 14440239.59239095),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:32660': ProjectAndUnProjectResult(
      Point(x: -1088186.0339150205, y: 14586736.43853731),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:32661': ProjectAndUnProjectResult(
      Point(x: 3540763.466186003, y: -2773696.9632621473),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:32662': ProjectAndUnProjectResult(
      Point(x: 1991289.5702107965, y: 5220022.958083138),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:32663': ProjectAndUnProjectResult(
      Point(x: 1991289.5702107965, y: 5220022.958083138),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:32664': ProjectAndUnProjectResult(
      Point(x: 5487686.082005338, y: 39957420.24214098), Point(x: 0, y: 90)),
  'EPSG:32665': ProjectAndUnProjectResult(
      Point(x: 10582786.401117966, y: 39418797.664189056), Point(x: 0, y: 90)),
  'EPSG:32666': ProjectAndUnProjectResult(
      Point(x: 14137615.253747612, y: 38069538.76741713), Point(x: 0, y: 90)),
  'EPSG:32667': ProjectAndUnProjectResult(
      Point(x: 16468782.86051709, y: 36235825.00276324), Point(x: 0, y: 90)),
  'EPSG:32701': ProjectAndUnProjectResult(
      Point(x: -633185.5802425162, y: 24694063.81120687),
      Point(x: 17.888058560281486, y: 46.892264067008824)),
  'EPSG:32702': ProjectAndUnProjectResult(
      Point(x: -176891.2861509861, y: 24764258.052093428),
      Point(x: 17.888058560281486, y: 46.892264067008774)),
  'EPSG:32703': ProjectAndUnProjectResult(
      Point(x: 279998.770163635, y: 24798688.27594924),
      Point(x: 17.888058560281486, y: 46.892264067008774)),
  'EPSG:32704': ProjectAndUnProjectResult(
      Point(x: 737054.7120343816, y: 24798035.783310786),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:32705': ProjectAndUnProjectResult(
      Point(x: 1193931.3463186407, y: 24762287.606221087),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:32706': ProjectAndUnProjectResult(
      Point(x: 1650192.180968158, y: 24690736.60865352),
      Point(x: 17.88805856028151, y: 46.89226406700882)),
  'EPSG:32707': ProjectAndUnProjectResult(
      Point(x: 2105125.3250947963, y: 24581988.281459033),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:32708': ProjectAndUnProjectResult(
      Point(x: 2557536.0363929626, y: 24433982.11613086),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:32709': ProjectAndUnProjectResult(
      Point(x: 3005502.501230998, y: 24244044.57713075),
      Point(x: 17.888058560281486, y: 46.89226406700882)),
  'EPSG:32710': ProjectAndUnProjectResult(
      Point(x: 3446086.561661094, y: 24009002.219304737),
      Point(x: 17.888058560281486, y: 46.89226406700882)),
  'EPSG:32711': ProjectAndUnProjectResult(
      Point(x: 3875003.0727375885, y: 23725397.247930214),
      Point(x: 17.888058560281486, y: 46.89226406700881)),
  'EPSG:32712': ProjectAndUnProjectResult(
      Point(x: 4286275.534202199, y: 23389860.7391468),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:32713': ProjectAndUnProjectResult(
      Point(x: 4671946.775863947, y: 22999702.03257131),
      Point(x: 17.88805856028146, y: 46.89226406700879)),
  'EPSG:32714': ProjectAndUnProjectResult(
      Point(x: 5021971.585975397, y: 22553749.127058934),
      Point(x: 17.888058560281486, y: 46.8922640670088)),
  'EPSG:32715': ProjectAndUnProjectResult(
      Point(x: 5324476.563887302, y: 22053400.32420765),
      Point(x: 17.88805856028146, y: 46.89226406700883)),
  'EPSG:32716': ProjectAndUnProjectResult(
      Point(x: 5566585.2237567445, y: 21503707.444086924),
      Point(x: 17.888058560281564, y: 46.89226406700888)),
  'EPSG:32717': ProjectAndUnProjectResult(
      Point(x: 5735902.874809236, y: 20914136.80804228),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:32718': ProjectAndUnProjectResult(
      Point(x: 5822492.611904318, y: 20298556.414407223),
      Point(x: 17.888058560281653, y: 46.89226406700865)),
  'EPSG:32719': ProjectAndUnProjectResult(
      Point(x: 5820828.738923764, y: 19674131.64705691),
      Point(x: 17.888058560281358, y: 46.89226406700865)),
  'EPSG:32720': ProjectAndUnProjectResult(
      Point(x: 5731020.405434482, y: 19059228.54521496),
      Point(x: 17.888058560281323, y: 46.89226406700882)),
  'EPSG:32721': ProjectAndUnProjectResult(
      Point(x: 5558786.502434989, y: 18470922.227729887),
      Point(x: 17.88805856028145, y: 46.892264067008874)),
  'EPSG:32722': ProjectAndUnProjectResult(
      Point(x: 5314192.978401657, y: 17922929.14913848),
      Point(x: 17.888058560281543, y: 46.89226406700883)),
  'EPSG:32723': ProjectAndUnProjectResult(
      Point(x: 5009686.094046778, y: 17424545.01118961),
      Point(x: 17.88805856028154, y: 46.892264067008796)),
  'EPSG:32724': ProjectAndUnProjectResult(
      Point(x: 4658127.571844883, y: 16980668.281005513),
      Point(x: 17.888058560281525, y: 46.892264067008774)),
  'EPSG:32725': ProjectAndUnProjectResult(
      Point(x: 4271333.391910846, y: 16592581.225099735),
      Point(x: 17.888058560281518, y: 46.89226406700879)),
  'EPSG:32726': ProjectAndUnProjectResult(
      Point(x: 3859272.6009777463, y: 16259037.263767835),
      Point(x: 17.8880585602815, y: 46.892264067008774)),
  'EPSG:32727': ProjectAndUnProjectResult(
      Point(x: 3429824.901141373, y: 15977306.903716862),
      Point(x: 17.888058560281515, y: 46.89226406700877)),
  'EPSG:32728': ProjectAndUnProjectResult(
      Point(x: 2988897.836864297, y: 15744008.821634341),
      Point(x: 17.88805856028151, y: 46.8922640670088)),
  'EPSG:32729': ProjectAndUnProjectResult(
      Point(x: 2540720.0452914257, y: 15555690.293651043),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:32730': ProjectAndUnProjectResult(
      Point(x: 2088186.0339150208, y: 15409193.447504684),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:32731': ProjectAndUnProjectResult(
      Point(x: 1633185.5802425153, y: 15301866.074835122),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:32732': ProjectAndUnProjectResult(
      Point(x: 1176891.2861509859, y: 15231671.833948568),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:32733': ProjectAndUnProjectResult(
      Point(x: 720001.2298363654, y: 15197241.610092757),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:32734': ProjectAndUnProjectResult(
      Point(x: 262945.28796561854, y: 15197894.102731206),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:32735': ProjectAndUnProjectResult(
      Point(x: -193931.34631864005, y: 15233642.279820906),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:32736': ProjectAndUnProjectResult(
      Point(x: -650192.180968157, y: 15305193.277388472),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:32737': ProjectAndUnProjectResult(
      Point(x: -1105125.3250947963, y: 15413941.604582964),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:32738': ProjectAndUnProjectResult(
      Point(x: -1557536.0363929619, y: 15561947.769911136),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:32739': ProjectAndUnProjectResult(
      Point(x: -2005502.501230997, y: 15751885.308911242),
      Point(x: 17.888058560281518, y: 46.8922640670088)),
  'EPSG:32740': ProjectAndUnProjectResult(
      Point(x: -2446086.561661094, y: 15986927.666737255),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:32741': ProjectAndUnProjectResult(
      Point(x: -2875003.0727375876, y: 16270532.638111774),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:32742': ProjectAndUnProjectResult(
      Point(x: -3286275.5342021994, y: 16606069.146895196),
      Point(x: 17.888058560281525, y: 46.892264067008774)),
  'EPSG:32743': ProjectAndUnProjectResult(
      Point(x: -3671946.775863947, y: 16996227.853470683),
      Point(x: 17.88805856028154, y: 46.89226406700877)),
  'EPSG:32744': ProjectAndUnProjectResult(
      Point(x: -4021971.5859753974, y: 17442180.75898306),
      Point(x: 17.888058560281475, y: 46.8922640670088)),
  'EPSG:32745': ProjectAndUnProjectResult(
      Point(x: -4324476.563887302, y: 17942529.561834343),
      Point(x: 17.888058560281475, y: 46.89226406700883)),
  'EPSG:32746': ProjectAndUnProjectResult(
      Point(x: -4566585.2237567445, y: 18492222.441955067),
      Point(x: 17.888058560281575, y: 46.892264067008874)),
  'EPSG:32747': ProjectAndUnProjectResult(
      Point(x: -4735902.874809236, y: 19081793.07799971),
      Point(x: 17.888058560281717, y: 46.89226406700881)),
  'EPSG:32748': ProjectAndUnProjectResult(
      Point(x: -4822492.611904318, y: 19697373.471634768),
      Point(x: 17.888058560281678, y: 46.89226406700865)),
  'EPSG:32749': ProjectAndUnProjectResult(
      Point(x: -4820828.738923764, y: 20321798.238985084),
      Point(x: 17.888058560281348, y: 46.89226406700865)),
  'EPSG:32750': ProjectAndUnProjectResult(
      Point(x: -4731020.405434482, y: 20936701.340827033),
      Point(x: 17.888058560281323, y: 46.89226406700882)),
  'EPSG:32751': ProjectAndUnProjectResult(
      Point(x: -4558786.5024349885, y: 21525007.658312105),
      Point(x: 17.888058560281475, y: 46.89226406700889)),
  'EPSG:32752': ProjectAndUnProjectResult(
      Point(x: -4314192.978401657, y: 22073000.73690351),
      Point(x: 17.88805856028155, y: 46.892264067008846)),
  'EPSG:32753': ProjectAndUnProjectResult(
      Point(x: -4009686.094046779, y: 22571384.874852385),
      Point(x: 17.88805856028154, y: 46.89226406700879)),
  'EPSG:32754': ProjectAndUnProjectResult(
      Point(x: -3658127.571844882, y: 23015261.605036482),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:32755': ProjectAndUnProjectResult(
      Point(x: -3271333.3919108487, y: 23403348.66094226),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:32756': ProjectAndUnProjectResult(
      Point(x: -2859272.6009777463, y: 23736892.62227416),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:32757': ProjectAndUnProjectResult(
      Point(x: -2429824.901141373, y: 24018622.98232513),
      Point(x: 17.88805856028154, y: 46.89226406700878)),
  'EPSG:32758': ProjectAndUnProjectResult(
      Point(x: -1988897.8368642977, y: 24251921.064407654),
      Point(x: 17.888058560281486, y: 46.89226406700877)),
  'EPSG:32759': ProjectAndUnProjectResult(
      Point(x: -1540720.045291426, y: 24440239.59239095),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:32760': ProjectAndUnProjectResult(
      Point(x: -1088186.0339150205, y: 24586736.43853731),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:32761': ProjectAndUnProjectResult(
      Point(x: 11779087.916001765, y: 32298227.672576204),
      Point(x: 17.888058560281515, y: 46.89226406700872)),
  'EPSG:32766': ProjectAndUnProjectResult(
      Point(x: -877885.5006516529, y: 15354804.257526185),
      Point(x: 17.888161981005894, y: 46.89226782538485)),
  'EPSG:3822': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3887': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:4000': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:4039': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:4073': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6317': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6320': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6323': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6363': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6666': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6704': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6781': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6934': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6978': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6981': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6985': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:6988': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7071': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7134': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7137': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7371': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7656': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7658': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7679': ProjectAndUnProjectResult(
      Point(x: 4155358.2806846127, y: 1341187.820899545),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7681': ProjectAndUnProjectResult(
      Point(x: 4155358.641901589, y: 1341187.937486317),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7684': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7789': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7796': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7815': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7842': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7879': ProjectAndUnProjectResult(
      Point(x: 4155358.947518695, y: 1341188.0361276167),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7884': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7914': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7916': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7918': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7920': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7922': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7924': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7926': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7928': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:7930': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8084': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8227': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8230': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8233': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8238': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8242': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8247': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8250': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8253': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:3901': ProjectAndUnProjectResult(
      Point(x: 2805947.597461324, y: 5235870.493398355),
      Point(x: 17.888058727374972, y: 46.89226403979681)),
  'EPSG:3902': ProjectAndUnProjectResult(
      Point(x: -193931.34632474044, y: 5233642.279699988),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:3903': ProjectAndUnProjectResult(
      Point(x: -193931.34632474044, y: 5233642.279699988),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:5500': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4097': ProjectAndUnProjectResult(
      Point(x: 877148.6088370954, y: 233660.6648475537),
      Point(x: 17.88805843543735, y: 46.892264027445336)),
  'EPSG:4098': ProjectAndUnProjectResult(
      Point(x: 1000998.7964341316, y: 225462.53667102847),
      Point(x: 17.88805852091921, y: 46.89226404676562)),
  'EPSG:4099': ProjectAndUnProjectResult(
      Point(x: 1067705.024527477, y: 213490.246378907),
      Point(x: 17.88805855729504, y: 46.89226406230804)),
  'EPSG:4100': ProjectAndUnProjectResult(
      Point(x: 1020089.2655463072, y: 199321.33850794286),
      Point(x: 17.888058560302017, y: 46.89226406695651)),
  'EPSG:5318': ProjectAndUnProjectResult(
      Point(x: 2090999.5151226467, y: -495459.66639980115),
      Point(x: 17.885795631862905, y: 46.89244457913767)),
  'EPSG:5498': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5499': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8999': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:9000': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5554': ProjectAndUnProjectResult(
      Point(x: 1633185.5802525284, y: 5301866.074714836),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:5555': ProjectAndUnProjectResult(
      Point(x: 1176891.2861569354, y: 5231671.8338276325),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:5556': ProjectAndUnProjectResult(
      Point(x: 720001.2298382937, y: 5197241.609971515),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5598': ProjectAndUnProjectResult(
      Point(x: 1499454.8179030179, y: 5216171.863445401),
      Point(x: 17.888058554214552, y: 46.892264060090596)),
  'EPSG:5628': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5698': ProjectAndUnProjectResult(
      Point(x: 1826843.263640678, y: 6750111.643270713),
      Point(x: 17.888058560281515, y: 46.89226406700873)),
  'EPSG:5699': ProjectAndUnProjectResult(
      Point(x: 1826843.263640678, y: 6750111.643270713),
      Point(x: 17.888058560281515, y: 46.89226406700873)),
  'EPSG:5846': ProjectAndUnProjectResult(
      Point(x: 598669.2683445803, y: 5212129.891160676),
      Point(x: 17.888058558416994, y: 46.89226406333179)),
  'EPSG:5707': ProjectAndUnProjectResult(
      Point(x: 1777825.1702077333, y: 1031948.4700101132),
      Point(x: 17.88805856071017, y: 46.892264067007225)),
  'EPSG:5708': ProjectAndUnProjectResult(
      Point(x: 1182908.9543171676, y: 4819774.557776076),
      Point(x: 17.88805856071017, y: 46.89226406700725)),
  'EPSG:5832': ProjectAndUnProjectResult(
      Point(x: 3405400.2787059825, y: 5263797.661108687),
      Point(x: 17.888056607032425, y: 46.892263905350184)),
  'EPSG:5833': ProjectAndUnProjectResult(
      Point(x: 4177079.968440652, y: 5233232.120986678),
      Point(x: 17.888058435353244, y: 46.89226402757831)),
  'EPSG:5834': ProjectAndUnProjectResult(
      Point(x: 4948614.819973172, y: 5211599.299867989),
      Point(x: 17.888058558409952, y: 46.89226406334307)),
  'EPSG:5835': ProjectAndUnProjectResult(
      Point(x: 5720062.557838639, y: 5198792.3020578),
      Point(x: 17.888058560301875, y: 46.89226406695668)),
  'EPSG:5845': ProjectAndUnProjectResult(
      Point(x: 720001.2298382937, y: 5197241.609971515),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:9003': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5847': ProjectAndUnProjectResult(
      Point(x: 484387.03616155894, y: 5204627.243488797),
      Point(x: 17.888058560316225, y: 46.89226406636951)),
  'EPSG:5848': ProjectAndUnProjectResult(
      Point(x: 370089.2655463072, y: 5199321.338507943),
      Point(x: 17.888058560302017, y: 46.89226406695651)),
  'EPSG:5849': ProjectAndUnProjectResult(
      Point(x: 255781.53174686513, y: 5196205.585950036),
      Point(x: 17.88805856028205, y: 46.892264067008135)),
  'EPSG:5850': ProjectAndUnProjectResult(
      Point(x: 141469.08374790964, y: 5195276.111849979),
      Point(x: 17.888058560281515, y: 46.892264067008774)),
  'EPSG:5851': ProjectAndUnProjectResult(
      Point(x: 427239.7350572513, y: 5201700.173692855),
      Point(x: 17.888058560331274, y: 46.89226406680042)),
  'EPSG:5852': ProjectAndUnProjectResult(
      Point(x: 312936.3103335998, y: 5197489.998984287),
      Point(x: 17.8880585602863, y: 46.89226406700016)),
  'EPSG:5853': ProjectAndUnProjectResult(
      Point(x: 198625.57705212594, y: 5195467.700063693),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:5854': ProjectAndUnProjectResult(
      Point(x: 84312.6848457014, y: 5195630.7617201),
      Point(x: 17.88805856028147, y: 46.89226406700875)),
  'EPSG:5855': ProjectAndUnProjectResult(
      Point(x: -29997.2884961167, y: 5197979.386805543),
      Point(x: 17.88805856027366, y: 46.892264066993114)),
  'EPSG:5856': ProjectAndUnProjectResult(
      Point(x: -144299.16811836342, y: 5202516.496162767),
      Point(x: 17.88805856022543, y: 46.892264066710894)),
  'EPSG:5857': ProjectAndUnProjectResult(
      Point(x: -258587.512644806, y: 5209247.727562542),
      Point(x: 17.88805856085824, y: 46.892264064897844)),
  'EPSG:5942': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5945': ProjectAndUnProjectResult(
      Point(x: 1043549.191261411, y: -160974.72827168927),
      Point(x: 17.888055685365156, y: 46.89226388108928)),
  'EPSG:5946': ProjectAndUnProjectResult(
      Point(x: 967465.1467680301, y: -172669.19012699788),
      Point(x: 17.888057256158355, y: 46.89226392990055)),
  'EPSG:5947': ProjectAndUnProjectResult(
      Point(x: 891358.461581458, y: -183357.79920025077),
      Point(x: 17.88805801138619, y: 46.892263977212124)),
  'EPSG:5948': ProjectAndUnProjectResult(
      Point(x: 815231.9865559447, y: -193046.3785228266),
      Point(x: 17.888058349819428, y: 46.892264013752765)),
  'EPSG:5949': ProjectAndUnProjectResult(
      Point(x: 739088.331249681, y: -201740.22069242736),
      Point(x: 17.888058488739624, y: 46.892264038336585)),
  'EPSG:5950': ProjectAndUnProjectResult(
      Point(x: 662929.8888774, y: -209444.0863850494),
      Point(x: 17.88805853966254, y: 46.89226405311323)),
  'EPSG:5951': ProjectAndUnProjectResult(
      Point(x: 586758.8607398072, y: -216162.20313095092),
      Point(x: 17.888058555667435, y: 46.89226406106194)),
  'EPSG:5952': ProjectAndUnProjectResult(
      Point(x: 510577.2801855649, y: -221898.26431834162),
      Point(x: 17.888058559664973, y: 46.89226406483602)),
  'EPSG:5953': ProjectAndUnProjectResult(
      Point(x: 434387.03616155894, y: -226655.42839260353),
      Point(x: 17.888058560316225, y: 46.89226406636952)),
  'EPSG:5954': ProjectAndUnProjectResult(
      Point(x: 358189.8964071749, y: -230436.31822293648),
      Point(x: 17.888058560321223, y: 46.89226406687275)),
  'EPSG:5955': ProjectAndUnProjectResult(
      Point(x: 281987.530348313, y: -233243.0206123935),
      Point(x: 17.88805856028981, y: 46.89226406699207)),
  'EPSG:7409': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5956': ProjectAndUnProjectResult(
      Point(x: 205781.53174686513, y: -235077.08593136515),
      Point(x: 17.88805856028205, y: 46.892264067008135)),
  'EPSG:5957': ProjectAndUnProjectResult(
      Point(x: 129573.44116138725, y: -235939.52785863844),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5958': ProjectAndUnProjectResult(
      Point(x: 53364.7682746877, y: -235830.82321825065),
      Point(x: 17.888058560281507, y: 46.892264067008774)),
  'EPSG:5959': ProjectAndUnProjectResult(
      Point(x: -22842.985855933424, y: -234750.9119044277),
      Point(x: 17.888058560280374, y: 46.8922640670072)),
  'EPSG:5960': ProjectAndUnProjectResult(
      Point(x: -99048.30657007455, y: -232699.1968909877),
      Point(x: 17.888058560268696, y: 46.89226406698017)),
  'EPSG:5961': ProjectAndUnProjectResult(
      Point(x: -175249.64334151713, y: -229674.54432566254),
      Point(x: 17.88805856023272, y: 46.89226406680922)),
  'EPSG:5962': ProjectAndUnProjectResult(
      Point(x: -251445.38742568332, y: -225675.28371387697),
      Point(x: 17.88805856029077, y: 46.89226406614835)),
  'EPSG:7410': ProjectAndUnProjectResult(
      Point(x: 17.88743199286141, y: 46.89231962115489),
      Point(x: 17.888058574321306, y: 46.89226402004299)),
  'EPSG:5963': ProjectAndUnProjectResult(
      Point(x: -327633.84936153685, y: -220699.20820060535),
      Point(x: 17.88805856132897, y: 46.89226406424213)),
  'EPSG:5964': ProjectAndUnProjectResult(
      Point(x: -403813.23627219687, y: -214743.5749630027),
      Point(x: 17.888058566928727, y: 46.89226405972883)),
  'EPSG:5965': ProjectAndUnProjectResult(
      Point(x: -479981.62890854396, y: -207805.10573059297),
      Point(x: 17.88805858801052, y: 46.892264050503584)),
  'EPSG:5966': ProjectAndUnProjectResult(
      Point(x: -556136.9583800837, y: -199879.98745387606),
      Point(x: 17.88805865250497, y: 46.892264033786056)),
  'EPSG:5967': ProjectAndUnProjectResult(
      Point(x: -632276.9825173458, y: -190963.87314629555),
      Point(x: 17.888058823564478, y: 46.89226400664556)),
  'EPSG:5968': ProjectAndUnProjectResult(
      Point(x: -708399.2618100875, y: -181051.882928591),
      Point(x: 17.888059231433566, y: 46.89226396739856)),
  'EPSG:5969': ProjectAndUnProjectResult(
      Point(x: -784501.1348655766, y: -170138.6053086382),
      Point(x: 17.88806012621695, y: 46.892263918526474)),
  'EPSG:8860': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8900': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5970': ProjectAndUnProjectResult(
      Point(x: -860579.6933312244, y: -158218.0987339674),
      Point(x: 17.888061961568134, y: 46.8922638720904)),
  'EPSG:5971': ProjectAndUnProjectResult(
      Point(x: 1633185.5802525284, y: 5301866.074714836),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:5972': ProjectAndUnProjectResult(
      Point(x: 1176891.2861569354, y: 5231671.8338276325),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:5973': ProjectAndUnProjectResult(
      Point(x: 720001.2298382937, y: 5197241.609971515),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5974': ProjectAndUnProjectResult(
      Point(x: 262945.28796354064, y: 5197894.102609971),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:5975': ProjectAndUnProjectResult(
      Point(x: -193931.34632474044, y: 5233642.279699988),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:5976': ProjectAndUnProjectResult(
      Point(x: -650192.1809783222, y: 5305193.277268217),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:6144': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6145': ProjectAndUnProjectResult(
      Point(x: 1043549.191261411, y: -160974.72827168927),
      Point(x: 17.888055685365156, y: 46.89226388108928)),
  'EPSG:6146': ProjectAndUnProjectResult(
      Point(x: 967465.1467680301, y: -172669.19012699788),
      Point(x: 17.888057256158355, y: 46.89226392990055)),
  'EPSG:6147': ProjectAndUnProjectResult(
      Point(x: 891358.461581458, y: -183357.79920025077),
      Point(x: 17.88805801138619, y: 46.892263977212124)),
  'EPSG:6148': ProjectAndUnProjectResult(
      Point(x: 815231.9865559447, y: -193046.3785228266),
      Point(x: 17.888058349819428, y: 46.892264013752765)),
  'EPSG:6149': ProjectAndUnProjectResult(
      Point(x: 739088.331249681, y: -201740.22069242736),
      Point(x: 17.888058488739624, y: 46.892264038336585)),
  'EPSG:6150': ProjectAndUnProjectResult(
      Point(x: 662929.8888774, y: -209444.0863850494),
      Point(x: 17.88805853966254, y: 46.89226405311323)),
  'EPSG:6151': ProjectAndUnProjectResult(
      Point(x: 586758.8607398072, y: -216162.20313095092),
      Point(x: 17.888058555667435, y: 46.89226406106194)),
  'EPSG:8902': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8907': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6152': ProjectAndUnProjectResult(
      Point(x: 510577.2801855649, y: -221898.26431834162),
      Point(x: 17.888058559664973, y: 46.89226406483602)),
  'EPSG:6153': ProjectAndUnProjectResult(
      Point(x: 434387.03616155894, y: -226655.42839260353),
      Point(x: 17.888058560316225, y: 46.89226406636952)),
  'EPSG:6154': ProjectAndUnProjectResult(
      Point(x: 358189.8964071749, y: -230436.31822293648),
      Point(x: 17.888058560321223, y: 46.89226406687275)),
  'EPSG:6155': ProjectAndUnProjectResult(
      Point(x: 281987.530348313, y: -233243.0206123935),
      Point(x: 17.88805856028981, y: 46.89226406699207)),
  'EPSG:6156': ProjectAndUnProjectResult(
      Point(x: 205781.53174686513, y: -235077.08593136515),
      Point(x: 17.88805856028205, y: 46.892264067008135)),
  'EPSG:6157': ProjectAndUnProjectResult(
      Point(x: 129573.44116138725, y: -235939.52785863844),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6158': ProjectAndUnProjectResult(
      Point(x: 53364.7682746877, y: -235830.82321825065),
      Point(x: 17.888058560281507, y: 46.892264067008774)),
  'EPSG:8988': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8989': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6159': ProjectAndUnProjectResult(
      Point(x: -22842.985855933424, y: -234750.9119044277),
      Point(x: 17.888058560280374, y: 46.8922640670072)),
  'EPSG:6160': ProjectAndUnProjectResult(
      Point(x: -99048.30657007455, y: -232699.1968909877),
      Point(x: 17.888058560268696, y: 46.89226406698017)),
  'EPSG:6161': ProjectAndUnProjectResult(
      Point(x: -175249.64334151713, y: -229674.54432566254),
      Point(x: 17.88805856023272, y: 46.89226406680922)),
  'EPSG:6162': ProjectAndUnProjectResult(
      Point(x: -251445.38742568332, y: -225675.28371387697),
      Point(x: 17.88805856029077, y: 46.89226406614835)),
  'EPSG:6163': ProjectAndUnProjectResult(
      Point(x: -327633.84936153685, y: -220699.20820060535),
      Point(x: 17.88805856132897, y: 46.89226406424213)),
  'EPSG:6164': ProjectAndUnProjectResult(
      Point(x: -403813.23627219687, y: -214743.5749630027),
      Point(x: 17.888058566928727, y: 46.89226405972883)),
  'EPSG:6165': ProjectAndUnProjectResult(
      Point(x: -479981.62890854396, y: -207805.10573059297),
      Point(x: 17.88805858801052, y: 46.892264050503584)),
  'EPSG:8990': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8991': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6166': ProjectAndUnProjectResult(
      Point(x: -556136.9583800837, y: -199879.98745387606),
      Point(x: 17.88805865250497, y: 46.892264033786056)),
  'EPSG:6167': ProjectAndUnProjectResult(
      Point(x: -632276.9825173458, y: -190963.87314629555),
      Point(x: 17.888058823564478, y: 46.89226400664556)),
  'EPSG:6168': ProjectAndUnProjectResult(
      Point(x: -708399.2618100875, y: -181051.882928591),
      Point(x: 17.888059231433566, y: 46.89226396739856)),
  'EPSG:6169': ProjectAndUnProjectResult(
      Point(x: -784501.1348655766, y: -170138.6053086382),
      Point(x: 17.88806012621695, y: 46.892263918526474)),
  'EPSG:6170': ProjectAndUnProjectResult(
      Point(x: -860579.6933312244, y: -158218.0987339674),
      Point(x: 17.888061961568134, y: 46.8922638720904)),
  'EPSG:6171': ProjectAndUnProjectResult(
      Point(x: 1633185.5802525284, y: 5301866.074714836),
      Point(x: 17.88805856028151, y: 46.892264067008774)),
  'EPSG:6172': ProjectAndUnProjectResult(
      Point(x: 1176891.2861569354, y: 5231671.8338276325),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:8992': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8993': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6173': ProjectAndUnProjectResult(
      Point(x: 720001.2298382937, y: 5197241.609971515),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6174': ProjectAndUnProjectResult(
      Point(x: 262945.28796354064, y: 5197894.102609971),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:6175': ProjectAndUnProjectResult(
      Point(x: -193931.34632474044, y: 5233642.279699988),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:6176': ProjectAndUnProjectResult(
      Point(x: -650192.1809783222, y: 5305193.277268217),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:6190': ProjectAndUnProjectResult(
      Point(x: 1176530.4986970704, y: -175576.21788469795),
      Point(x: 17.888058551637616, y: 46.8922640732123)),
  'EPSG:6349': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6649': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6650': ProjectAndUnProjectResult(
      Point(x: 2105125.3251090776, y: 14581988.281413767),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:6651': ProjectAndUnProjectResult(
      Point(x: 2557536.036411387, y: 14433982.116084043),
      Point(x: 17.88805856028154, y: 46.892264067008774)),
  'EPSG:6652': ProjectAndUnProjectResult(
      Point(x: 3005502.501253523, y: 14244044.5770818),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:6653': ProjectAndUnProjectResult(
      Point(x: 3446086.561687547, y: 14009002.219252983),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:6654': ProjectAndUnProjectResult(
      Point(x: 3875003.072767595, y: 13725397.247874938),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:6655': ProjectAndUnProjectResult(
      Point(x: 4286275.534235133, y: 13389860.739087315),
      Point(x: 17.888058560281525, y: 46.89226406700878)),
  'EPSG:6656': ProjectAndUnProjectResult(
      Point(x: 4671946.775898903, y: 12999702.032507129),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:6657': ProjectAndUnProjectResult(
      Point(x: 5021971.586011266, y: 12553749.126989897),
      Point(x: 17.888058560281486, y: 46.89226406700879)),
  'EPSG:8994': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6658': ProjectAndUnProjectResult(
      Point(x: 5324476.5639229575, y: 12053400.324134082),
      Point(x: 17.88805856028146, y: 46.89226406700884)),
  'EPSG:6659': ProjectAndUnProjectResult(
      Point(x: 5566585.223791351, y: 11503707.444009647),
      Point(x: 17.888058560281575, y: 46.892264067008874)),
  'EPSG:6660': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 10914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:6661': ProjectAndUnProjectResult(
      Point(x: 5822492.611936731, y: 10298556.41432563),
      Point(x: 17.88805856028164, y: 46.892264067008654)),
  'EPSG:6662': ProjectAndUnProjectResult(
      Point(x: 5820828.738956195, y: 9674131.646974),
      Point(x: 17.888058560281358, y: 46.892264067008654)),
  'EPSG:6663': ProjectAndUnProjectResult(
      Point(x: 5731020.405467821, y: 9059228.545130335),
      Point(x: 17.88805856028131, y: 46.89226406700882)),
  'EPSG:6664': ProjectAndUnProjectResult(
      Point(x: 5558786.502469642, y: 8470922.227642598),
      Point(x: 17.88805856028146, y: 46.89226406700888)),
  'EPSG:8995': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6665': ProjectAndUnProjectResult(
      Point(x: 5314192.97843734, y: 7922929.14904744),
      Point(x: 17.88805856028157, y: 46.89226406700883)),
  'EPSG:6696': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6697': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6700': ProjectAndUnProjectResult(
      Point(x: 17.88113303218112, y: 46.887591671655095),
      Point(x: 17.888058773192473, y: 46.892264211085)),
  'EPSG:6871': ProjectAndUnProjectResult(
      Point(x: 1991289.5702107965, y: 5893297.075909311),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:6893': ProjectAndUnProjectResult(
      Point(x: 1991289.5702107965, y: 5893297.075909311),
      Point(x: 17.888058560281515, y: 46.892264067008725)),
  'EPSG:6917': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6927': ProjectAndUnProjectResult(
      Point(x: -5112096.108141312, y: 9542168.098918451),
      Point(x: 1261949784.1230948, y: 276952866.8896538)),
  'EPSG:7400': ProjectAndUnProjectResult(
      Point(x: 15.550901520384743, y: 46.89226381503744),
      Point(x: 17.88805856071017, y: 46.89226406700729)),
  'EPSG:8996': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7401': ProjectAndUnProjectResult(
      Point(x: 1777310.0568079422, y: 2327103.8227227707),
      Point(x: 17.88805856071017, y: 46.89226406700722)),
  'EPSG:7402': ProjectAndUnProjectResult(
      Point(x: 1777310.0568079422, y: 2327103.8227227707),
      Point(x: 17.88805856071017, y: 46.89226406700722)),
  'EPSG:7403': ProjectAndUnProjectResult(
      Point(x: 1779409.8043467712, y: 3622135.8275218518),
      Point(x: 17.88805856071017, y: 46.892264067007225)),
  'EPSG:7404': ProjectAndUnProjectResult(
      Point(x: 17.89111683155867, y: 46.89126953091154),
      Point(x: 17.888058586300215, y: 46.89226403037144)),
  'EPSG:7405': ProjectAndUnProjectResult(
      Point(x: 1912625.1078165907, y: -138902.14913871256),
      Point(x: 17.88780496707789, y: 46.89227699578956)),
  'EPSG:7406': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89439997507818),
      Point(x: 17.888058560281515, y: 46.892264047823126)),
  'EPSG:7407': ProjectAndUnProjectResult(
      Point(x: 25599449.69288968, y: 21003497.02276749),
      Point(x: 17.88805856028151, y: 46.89226404782307)),
  'EPSG:7408': ProjectAndUnProjectResult(
      Point(x: 17.890149632205905, y: 46.89256626995258),
      Point(x: 17.888058571915472, y: 46.89226406583144)),
  'EPSG:7411': ProjectAndUnProjectResult(
      Point(x: 1777310.0568079422, y: 2327103.8227227707),
      Point(x: 17.88805856071017, y: 46.89226406700722)),
  'EPSG:7412': ProjectAndUnProjectResult(
      Point(x: 1777310.0568079422, y: 2327103.8227227707),
      Point(x: 17.88805856071017, y: 46.89226406700722)),
  'EPSG:7413': ProjectAndUnProjectResult(
      Point(x: 1779409.8043467712, y: 3622135.8275218518),
      Point(x: 17.88805856071017, y: 46.892264067007225)),
  'EPSG:7414': ProjectAndUnProjectResult(
      Point(x: 17.88113303218112, y: 46.887591671655095),
      Point(x: 17.888058773192473, y: 46.892264211085)),
  'EPSG:7415': ProjectAndUnProjectResult(
      Point(x: 1106786.3196606983, y: -43313.244148063415),
      Point(x: 17.88805857191546, y: 46.892264065831405)),
  'EPSG:7416': ProjectAndUnProjectResult(
      Point(x: 1176891.2861569354, y: 5231671.8338276325),
      Point(x: 17.88805856028151, y: 46.89226406700878)),
  'EPSG:7417': ProjectAndUnProjectResult(
      Point(x: 720001.2298382937, y: 5197241.609971515),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8997': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7418': ProjectAndUnProjectResult(
      Point(x: 839056.3768331184, y: 5229280.974066414),
      Point(x: 17.888058488739624, y: 46.89226403833658)),
  'EPSG:7419': ProjectAndUnProjectResult(
      Point(x: 948646.8348811632, y: 5211869.284666118),
      Point(x: 17.888058558416994, y: 46.89226406333179)),
  'EPSG:7420': ProjectAndUnProjectResult(
      Point(x: 1120089.2655463072, y: 5199321.338507943),
      Point(x: 17.888058560302017, y: 46.89226406695651)),
  'EPSG:7421': ProjectAndUnProjectResult(
      Point(x: 1777310.0568079422, y: 2327103.8227227707),
      Point(x: 17.88805856071017, y: 46.89226406700722)),
  'EPSG:7422': ProjectAndUnProjectResult(
      Point(x: 1779409.8043467712, y: 3622135.8275218518),
      Point(x: 17.88805856071017, y: 46.892264067007225)),
  'EPSG:7423': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7954': ProjectAndUnProjectResult(
      Point(x: 2087552.2238160435, y: 15409458.75670271),
      Point(x: 17.888058880703458, y: 46.892263950123855)),
  'EPSG:8998': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7955': ProjectAndUnProjectResult(
      Point(x: 2088185.9619449263, y: 15409193.326275803),
      Point(x: 17.8880585602815, y: 46.89226406700879)),
  'EPSG:7956': ProjectAndUnProjectResult(
      Point(x: 2088186.0339291478, y: 15409193.447385449),
      Point(x: 17.888058560281504, y: 46.89226406700879)),
  'EPSG:8349': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8350': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'spatialreferencing.org:900913': ProjectAndUnProjectResult(
      Point(x: 1991289.5702107965, y: 5924506.521570054),
      Point(x: 17.888058560281515, y: 46.89226406700878)),
  'EPSG:8351': ProjectAndUnProjectResult(
      Point(x: 17.88934004484768, y: 46.89256388598383),
      Point(x: 17.88805852862393, y: 46.892264110072865)),
  'EPSG:8427': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8428': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8431': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8449': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8545': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8685': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8818': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3295': ProjectAndUnProjectResult(
      Point(x: -5176908.587511179, y: 6896459.014384921),
      Point(x: 56.6094895135207, y: 53.41854082099524)),
  'EPSG:3993': ProjectAndUnProjectResult(
      Point(x: -4757490.7174761705, y: 7103119.470512892),
      Point(x: 58.482880209188224, y: 56.833530634191185)),
  'EPSG:5896': ProjectAndUnProjectResult(
      Point(x: -4652275.287064603, y: 9454768.882961797),
      Point(x: double.nan, y: double.nan)),
  'EPSG:5897': ProjectAndUnProjectResult(
      Point(x: -4623587.388099429, y: 9781039.67478536),
      Point(x: double.nan, y: double.nan)),
  'EPSG:5898': ProjectAndUnProjectResult(
      Point(x: -4550677.6545024095, y: 10110235.462374557),
      Point(x: -168.37939778999916, y: 89.99824032468668)),
  'EPSG:5899': ProjectAndUnProjectResult(
      Point(x: -4558590.894691086, y: 10082782.95357802),
      Point(x: -168.37939778999916, y: 89.99824032468668)),
  'EPSG:6200': ProjectAndUnProjectResult(
      Point(x: 21215187.32920057, y: 15731000.38572078),
      Point(x: 17.888058528615417, y: 46.89226408776839)),
  'EPSG:6201': ProjectAndUnProjectResult(
      Point(x: 21320043.627418302, y: 15394947.88050571),
      Point(x: 17.88805852861542, y: 46.89226408776841)),
  'EPSG:6202': ProjectAndUnProjectResult(
      Point(x: 21774004.46741608, y: 15701276.670744624),
      Point(x: 17.888058528615417, y: 46.8922640877684)),
  'EPSG:6966': ProjectAndUnProjectResult(
      Point(x: 21215187.32920057, y: 15731000.38572078),
      Point(x: 17.888058528615417, y: 46.89226408776839)),
  'EPSG:8352': ProjectAndUnProjectResult(
      Point(x: -1425017.3661174874, y: -528543.9649871885),
      Point(x: 17.88805852862392, y: 46.89226411006946)),
  'EPSG:8353': ProjectAndUnProjectResult(
      Point(x: -528543.9649871885, y: -1425017.3661174874),
      Point(x: 17.88805852862392, y: 46.89226411006946)),
  'EPSG:8379': ProjectAndUnProjectResult(
      Point(x: -6101658.922161825, y: 6464136.30032029), Point(x: 0, y: 90)),
  'EPSG:8380': ProjectAndUnProjectResult(
      Point(x: -20018525.980492588, y: 21207753.845334154), Point(x: 0, y: 90)),
  'EPSG:8381': ProjectAndUnProjectResult(
      Point(x: -5901875.958520465, y: 6664355.523168516), Point(x: 0, y: 90)),
  'EPSG:8382': ProjectAndUnProjectResult(
      Point(x: -19363071.373912558, y: 21864639.745562043), Point(x: 0, y: 90)),
  'EPSG:8383': ProjectAndUnProjectResult(
      Point(x: -6101658.922161825, y: 6464136.30032029), Point(x: 0, y: 90)),
  'EPSG:8384': ProjectAndUnProjectResult(
      Point(x: -20018525.980492588, y: 21207753.845334154), Point(x: 0, y: 90)),
  'EPSG:8385': ProjectAndUnProjectResult(
      Point(x: -5901875.958520465, y: 6664355.523168516), Point(x: 0, y: 90)),
  'EPSG:8387': ProjectAndUnProjectResult(
      Point(x: -19363071.373912558, y: 21864639.745562043), Point(x: 0, y: 90)),
  'EPSG:8391': ProjectAndUnProjectResult(
      Point(x: 1359192.0527579375, y: 13949630.71527612), Point(x: 0, y: 90)),
  'EPSG:8395': ProjectAndUnProjectResult(
      Point(x: 1177162.152080137, y: 5233765.340154357),
      Point(x: 17.88805843543735, y: 46.892264027445336)),
  'EPSG:8433': ProjectAndUnProjectResult(
      Point(x: -4758988.061677987, y: 8275347.846315364), Point(x: 0, y: 90)),
  'EPSG:8441': null /* blacklist */,
  'EPSG:8455': ProjectAndUnProjectResult(
      Point(x: -4009686.094082634, y: 22571384.874783527),
      Point(x: 17.88805856028154, y: 46.892264067008796)),
  'EPSG:8456': ProjectAndUnProjectResult(
      Point(x: -3658127.571879782, y: 23015261.60497248),
      Point(x: 17.88805856028154, y: 46.89226406700878)),
  'EPSG:8518': ProjectAndUnProjectResult(
      Point(x: 2568192.1867609676, y: 26231785.496995304), Point(x: 0, y: 90)),
  'EPSG:8519': ProjectAndUnProjectResult(
      Point(x: 4299088.837258913, y: 26286193.938675426), Point(x: 0, y: 90)),
  'EPSG:8520': ProjectAndUnProjectResult(
      Point(x: 5952317.323946274, y: 26321824.754202314), Point(x: 0, y: 90)),
  'EPSG:8521': ProjectAndUnProjectResult(
      Point(x: 7894508.763283362, y: 26349908.758291785), Point(x: 0, y: 90)),
  'EPSG:8816': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8522': ProjectAndUnProjectResult(
      Point(x: 9678901.615483062, y: 26351636.208173033), Point(x: 0, y: 90)),
  'EPSG:8523': ProjectAndUnProjectResult(
      Point(x: 11178511.569606723, y: 26341238.57112168), Point(x: 0, y: 90)),
  'EPSG:8524': ProjectAndUnProjectResult(
      Point(x: 12940183.515098209, y: 26307191.598820515), Point(x: 0, y: 90)),
  'EPSG:8525': ProjectAndUnProjectResult(
      Point(x: 30307906.828323968, y: 19340466.79675964),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8526': ProjectAndUnProjectResult(
      Point(x: 31531982.705605827, y: 19145834.44489342),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8527': ProjectAndUnProjectResult(
      Point(x: 32097261.71382405, y: 19185096.198722728),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8528': ProjectAndUnProjectResult(
      Point(x: 33231047.18458201, y: 19051179.40820873),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8529': ProjectAndUnProjectResult(
      Point(x: 13776808.24656493, y: 26521702.79759533), Point(x: 0, y: 90)),
  'EPSG:8531': ProjectAndUnProjectResult(
      Point(x: 15898636.447117478, y: 26592265.25152975), Point(x: 0, y: 90)),
  'EPSG:8533': ProjectAndUnProjectResult(
      Point(x: 17671771.187067244, y: 26619118.532672744), Point(x: 0, y: 90)),
  'EPSG:8534': ProjectAndUnProjectResult(
      Point(x: 19148432.403053585, y: 26626034.487733066), Point(x: 0, y: 90)),
  'EPSG:8535': ProjectAndUnProjectResult(
      Point(x: 20792906.346516736, y: 26622981.894110702), Point(x: 0, y: 90)),
  'EPSG:8536': ProjectAndUnProjectResult(
      Point(x: 39868258.61199299, y: 19598330.527863298),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:8538': ProjectAndUnProjectResult(
      Point(x: 41075223.247241, y: 19486072.69505846),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:8539': ProjectAndUnProjectResult(
      Point(x: 26140622.95682038, y: 26478605.718207046), Point(x: 0, y: 90)),
  'EPSG:8540': ProjectAndUnProjectResult(
      Point(x: 27868917.517981466, y: 26385093.89649354), Point(x: 0, y: 90)),
  'EPSG:8677': ProjectAndUnProjectResult(
      Point(x: 5720441.9003260825, y: 5198321.17970864),
      Point(x: 17.888058599075265, y: 46.89226406920315)),
  'EPSG:8678': ProjectAndUnProjectResult(
      Point(x: 6491873.651574707, y: 5194261.4486098),
      Point(x: 17.888058599054723, y: 46.89226406925582)),
  'EPSG:8679': ProjectAndUnProjectResult(
      Point(x: 8034783.418643825, y: 5212389.0560713485),
      Point(x: 17.888058601884644, y: 46.89226406470986)),
  'EPSG:8682': ProjectAndUnProjectResult(
      Point(x: 262945.28796354064, y: 5197894.102609971),
      Point(x: 17.888058560281518, y: 46.892264067008774)),
  'EPSG:8686': ProjectAndUnProjectResult(
      Point(x: 720433.4260679072, y: 5198320.70633447),
      Point(x: 17.888058568987322, y: 46.892263983233086)),
  'EPSG:8687': ProjectAndUnProjectResult(
      Point(x: 720001.2298382937, y: 5197241.609971515),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8692': ProjectAndUnProjectResult(
      Point(x: -3658127.571879782, y: 13015261.604972484),
      Point(x: 17.88805856028151, y: 46.89226406700877)),
  'EPSG:8693': ProjectAndUnProjectResult(
      Point(x: -3271333.3919436852, y: 13403348.660882948),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:8826': ProjectAndUnProjectResult(
      Point(x: -3082500.665039772, y: 7082564.862886984), Point(x: 0, y: 90)),
  'EPSG:8836': ProjectAndUnProjectResult(
      Point(x: -650192.1809783222, y: 5305193.277268217),
      Point(x: 17.88805856028152, y: 46.892264067008774)),
  'EPSG:8837': ProjectAndUnProjectResult(
      Point(x: -1105125.3251090779, y: 5413941.604463775),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:8838': ProjectAndUnProjectResult(
      Point(x: -1557536.0364113871, y: 5561947.769793502),
      Point(x: 17.88805856028151, y: 46.89226406700879)),
  'EPSG:8839': ProjectAndUnProjectResult(
      Point(x: -2005502.5012535215, y: 5751885.308795742),
      Point(x: 17.888058560281532, y: 46.892264067008796)),
  'EPSG:8840': ProjectAndUnProjectResult(
      Point(x: -2446086.561687547, y: 5986927.66662456),
      Point(x: 17.888058560281518, y: 46.89226406700878)),
  'EPSG:8857': null /* blacklist */,
  'EPSG:8858': null /* blacklist */,
  'EPSG:8859': null /* blacklist */,
  'EPSG:8903': ProjectAndUnProjectResult(
      Point(x: -633185.5802525296, y: 24694063.811162703),
      Point(x: 17.888058560281486, y: 46.8922640670088)),
  'EPSG:8908': ProjectAndUnProjectResult(
      Point(x: 4706968.526647326, y: 11340922.422261257), Point(x: 0, y: 90)),
  'EPSG:8909': ProjectAndUnProjectResult(
      Point(x: 5566585.223791351, y: 11503707.444009647),
      Point(x: 17.888058560281575, y: 46.892264067008874)),
  'EPSG:8910': ProjectAndUnProjectResult(
      Point(x: 5735902.874842531, y: 10914136.807962373),
      Point(x: 17.888058560281703, y: 46.89226406700881)),
  'EPSG:8397': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8401': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8425': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8429': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8541': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8543': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8683': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8898': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8905': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:9001': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:9004': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:9007': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:9010': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:9015': ProjectAndUnProjectResult(
      Point(x: 4155358.947555103, y: 1341188.0361393676),
      Point(x: 17.888058560281515, y: 0)),
  'EPSG:8360': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8370': ProjectAndUnProjectResult(
      Point(x: 1676562.2460995119, y: 324549.78576519527),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8700': ProjectAndUnProjectResult(
      Point(x: -10399806.518539505, y: 25963983.551811244), Point(x: 0, y: 90)),
  'EPSG:8701': ProjectAndUnProjectResult(
      Point(x: -13543801.536441179, y: 24888413.494529177), Point(x: 0, y: 90)),
  'EPSG:4329': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8702': ProjectAndUnProjectResult(
      Point(x: -17112193.866983697, y: 23518362.396374583), Point(x: 0, y: 90)),
  'EPSG:8703': ProjectAndUnProjectResult(
      Point(x: 45461213.70641347, y: 15730349.260780344),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:8704': ProjectAndUnProjectResult(
      Point(x: 39006952.19021323, y: 15402243.628156064),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:8705': ProjectAndUnProjectResult(
      Point(x: 32899589.657143332, y: 15708442.659053039),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:8706': ProjectAndUnProjectResult(
      Point(x: 21510163.334050607, y: 21622551.551792037),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8707': ProjectAndUnProjectResult(
      Point(x: 21212141.17770074, y: 18575411.165973872),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:7138': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8708': ProjectAndUnProjectResult(
      Point(x: 21568125.75435468, y: 18836205.032457773),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8709': ProjectAndUnProjectResult(
      Point(x: 28205491.537826546, y: 24245461.293582283),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8710': ProjectAndUnProjectResult(
      Point(x: 25833585.61559125, y: 24599246.142841402),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:8711': ProjectAndUnProjectResult(
      Point(x: 23724086.117270596, y: 16795620.693260826),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:8712': ProjectAndUnProjectResult(
      Point(x: 23887239.31451893, y: 18694250.277861007),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:8713': ProjectAndUnProjectResult(
      Point(x: 24415399.802238926, y: 20281166.659434192),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8714': ProjectAndUnProjectResult(
      Point(x: 28587111.613013376, y: 26997662.456949405),
      Point(x: 17.88805856028154, y: 46.892264067008725)),
  'EPSG:8715': ProjectAndUnProjectResult(
      Point(x: 29490928.12755313, y: 27229420.066716935),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8716': ProjectAndUnProjectResult(
      Point(x: 30172292.149002075, y: 26973096.865134303),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:8717': ProjectAndUnProjectResult(
      Point(x: 30723796.79656839, y: 26753014.18956205),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:8718': ProjectAndUnProjectResult(
      Point(x: 31683048.00808688, y: 26700474.83101193),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8719': ProjectAndUnProjectResult(
      Point(x: 32341774.398609743, y: 26377843.571527246),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:8720': ProjectAndUnProjectResult(
      Point(x: 24966835.57031234, y: 22103331.550557733),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8721': ProjectAndUnProjectResult(
      Point(x: 25415893.186310228, y: 22403922.59138127),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:8722': ProjectAndUnProjectResult(
      Point(x: 25926473.25704309, y: 22550664.953602493),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8723': ProjectAndUnProjectResult(
      Point(x: 19813264.617850065, y: 13594950.057344146),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8724': ProjectAndUnProjectResult(
      Point(x: 16790808.841347355, y: 20514172.842702225), Point(x: 0, y: 90)),
  'EPSG:8725': ProjectAndUnProjectResult(
      Point(x: 25311130.553737495, y: 17855126.624383364),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:8726': ProjectAndUnProjectResult(
      Point(x: 15489593.979353804, y: 27416023.75950059), Point(x: 0, y: 90)),
  'EPSG:8727': ProjectAndUnProjectResult(
      Point(x: 15174228.04246971, y: 27744330.387298398), Point(x: 0, y: 90)),
  'EPSG:8728': ProjectAndUnProjectResult(
      Point(x: 15118403.957847703, y: 25737343.7849188), Point(x: 0, y: 90)),
  'EPSG:8729': ProjectAndUnProjectResult(
      Point(x: 16034054.297333244, y: 26367116.7896856), Point(x: 0, y: 90)),
  'EPSG:8730': ProjectAndUnProjectResult(
      Point(x: -14057937.66792367, y: 20834716.34476673), Point(x: 0, y: 90)),
  'EPSG:8731': ProjectAndUnProjectResult(
      Point(x: -16681202.277333234, y: 19427882.720026396), Point(x: 0, y: 90)),
  'EPSG:7372': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8732': ProjectAndUnProjectResult(
      Point(x: -19420021.483049188, y: 17825378.802620746), Point(x: 0, y: 90)),
  'EPSG:8733': ProjectAndUnProjectResult(
      Point(x: 12811889.12278988, y: 25117350.226620797), Point(x: 0, y: 90)),
  'EPSG:8734': ProjectAndUnProjectResult(
      Point(x: 13092484.923865328, y: 25555865.841472704), Point(x: 0, y: 90)),
  'EPSG:8735': ProjectAndUnProjectResult(
      Point(x: 13443875.494497076, y: 24906746.99790967), Point(x: 0, y: 90)),
  'EPSG:8736': ProjectAndUnProjectResult(
      Point(x: 15414189.905530734, y: 25304848.862912122), Point(x: 0, y: 90)),
  'EPSG:8737': ProjectAndUnProjectResult(
      Point(x: 25440189.887127027, y: 21133297.292668562),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'ESRI:37006': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8738': ProjectAndUnProjectResult(
      Point(x: 22584121.620162718, y: 18118492.886472385),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:8739': ProjectAndUnProjectResult(
      Point(x: 23202013.512833808, y: 19421226.75719965),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:8740': ProjectAndUnProjectResult(
      Point(x: 23706301.067791652, y: 21180590.79599445),
      Point(x: 17.88805856028151, y: 46.89226406700871)),
  'EPSG:8741': ProjectAndUnProjectResult(
      Point(x: 22489450.67840238, y: 16345135.930820154),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8742': ProjectAndUnProjectResult(
      Point(x: 22967474.001053203, y: 18536097.935624372),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:8743': ProjectAndUnProjectResult(
      Point(x: 27207965.058721982, y: 19397745.311270002),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8744': ProjectAndUnProjectResult(
      Point(x: 27757949.889516577, y: 19429241.35141847),
      Point(x: 17.8880585602815, y: 46.89226406700873)),
  'EPSG:8745': ProjectAndUnProjectResult(
      Point(x: 17828844.681840498, y: 15963115.339871371),
      Point(x: -3577911303.595106, y: 784422263.4885367)),
  'EPSG:8746': ProjectAndUnProjectResult(
      Point(x: 19704594.874053314, y: 16866486.83509716),
      Point(x: -2514978608651.3716, y: 548342325600.75916)),
  'EPSG:8747': ProjectAndUnProjectResult(
      Point(x: 21190442.582283285, y: 14745735.004731337),
      Point(x: 17.888058560281525, y: 46.892264067008725)),
  'EPSG:8748': ProjectAndUnProjectResult(
      Point(x: 19196544.98708549, y: 15324376.324035974),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8749': ProjectAndUnProjectResult(
      Point(x: 20191338.904867593, y: 12525841.79646695),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'ESRI:37007': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8750': ProjectAndUnProjectResult(
      Point(x: 21776603.7214779, y: 17198051.999077044),
      Point(x: 17.88805856028151, y: 46.89226406700872)),
  'EPSG:8751': ProjectAndUnProjectResult(
      Point(x: 22190086.889923513, y: 17763836.420328554),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:8752': ProjectAndUnProjectResult(
      Point(x: 22663116.311504748, y: 18097787.32676735),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:8753': ProjectAndUnProjectResult(
      Point(x: 12542576.3094194, y: 27849501.874450136), Point(x: 0, y: 90)),
  'EPSG:8754': ProjectAndUnProjectResult(
      Point(x: 12992572.243961746, y: 28200799.426332895), Point(x: 0, y: 90)),
  'EPSG:8755': ProjectAndUnProjectResult(
      Point(x: 22883813.725204114, y: 19815816.15389138),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:8756': ProjectAndUnProjectResult(
      Point(x: -21020973.318615973, y: 46754238.25794544), Point(x: 0, y: 90)),
  'EPSG:8757': ProjectAndUnProjectResult(
      Point(x: -22468358.066908345, y: 39079941.46217142),
      Point(x: 189531435636.54602, y: 59487357072.33621)),
  'EPSG:8758': ProjectAndUnProjectResult(
      Point(x: -26068968.02737887, y: 30272865.938432485),
      Point(x: 53494776.3643111, y: 20053499.392560635)),
  'EPSG:8759': ProjectAndUnProjectResult(
      Point(x: 17611813.21019182, y: 17528306.05463955), Point(x: 0, y: 90)),
  'EPSG:8760': ProjectAndUnProjectResult(
      Point(x: 16771473.19291651, y: 19881470.24072402), Point(x: 0, y: 90)),
  'EPSG:8761': ProjectAndUnProjectResult(
      Point(x: -1740585.9429473812, y: 28162864.263498835), Point(x: 0, y: 90)),
  'EPSG:7657': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8762': ProjectAndUnProjectResult(
      Point(x: -3274517.639472816, y: 27651211.139304798), Point(x: 0, y: 90)),
  'EPSG:8763': ProjectAndUnProjectResult(
      Point(x: -4556912.360749377, y: 27080492.584270272), Point(x: 0, y: 90)),
  'EPSG:8764': ProjectAndUnProjectResult(
      Point(x: 16771473.19291651, y: 19881470.24072402), Point(x: 0, y: 90)),
  'EPSG:8765': ProjectAndUnProjectResult(
      Point(x: 16742057.214225767, y: 20198326.198150814), Point(x: 0, y: 90)),
  'EPSG:8766': ProjectAndUnProjectResult(
      Point(x: 16635885.195668632, y: 20897177.962862983), Point(x: 0, y: 90)),
  'EPSG:8767': ProjectAndUnProjectResult(
      Point(x: 20080362.042142764, y: 13503621.269838082),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:7659': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8768': ProjectAndUnProjectResult(
      Point(x: 23009024.984398738, y: 15969960.634952419),
      Point(x: 17.888058560281525, y: 46.89226406700872)),
  'EPSG:8769': ProjectAndUnProjectResult(
      Point(x: 21986714.210386097, y: 15624881.636523502),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8770': ProjectAndUnProjectResult(
      Point(x: 22388167.41631199, y: 15933587.820483748),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8771': ProjectAndUnProjectResult(
      Point(x: 24956378.3741065, y: 19976436.59594429),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:8772': ProjectAndUnProjectResult(
      Point(x: 25553996.407476872, y: 20227709.19056254),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:8773': ProjectAndUnProjectResult(
      Point(x: 21399134.738047447, y: 14424379.65461984),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8774': ProjectAndUnProjectResult(
      Point(x: 21600173.96859688, y: 14567500.710063362),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:8775': ProjectAndUnProjectResult(
      Point(x: 16971851.915299885, y: 17984948.307937838), Point(x: 0, y: 90)),
  'EPSG:8776': ProjectAndUnProjectResult(
      Point(x: 22086296.48845758, y: 19050428.991915423),
      Point(x: 17.88805856028155, y: 46.89226406700871)),
  'EPSG:8777': ProjectAndUnProjectResult(
      Point(x: 22541676.56268016, y: 19406913.486203928),
      Point(x: 17.888058560281525, y: 46.89226406700874)),
  'EPSG:8778': ProjectAndUnProjectResult(
      Point(x: 23755941.686326504, y: 17389305.165590107),
      Point(x: 17.8880585602815, y: 46.892264067008725)),
  'EPSG:8779': ProjectAndUnProjectResult(
      Point(x: 24255654.445273735, y: 24283641.25020055),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8780': ProjectAndUnProjectResult(
      Point(x: 26211047.587591715, y: 27153798.922896914),
      Point(x: 17.88805856028151, y: 46.89226406700874)),
  'EPSG:8781': ProjectAndUnProjectResult(
      Point(x: 27620463.4186755, y: 31078601.643709328),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:8782': ProjectAndUnProjectResult(
      Point(x: 27843540.280672822, y: 34296206.30905833),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8783': ProjectAndUnProjectResult(
      Point(x: 27835397.225557968, y: 37629307.37812431),
      Point(x: 17.88805856028151, y: 46.8922640670087)),
  'EPSG:8784': ProjectAndUnProjectResult(
      Point(x: 23401718.533635717, y: 25725063.605568156),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:8785': ProjectAndUnProjectResult(
      Point(x: 24004488.809627652, y: 29432890.763636462),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:8786': ProjectAndUnProjectResult(
      Point(x: 24918123.22978142, y: 32865520.03330397),
      Point(x: 17.888058560281525, y: 46.892264067008746)),
  'EPSG:8787': ProjectAndUnProjectResult(
      Point(x: 18181618.507753536, y: 17828486.854641918), Point(x: 0, y: 90)),
  'EPSG:8788': ProjectAndUnProjectResult(
      Point(x: 31609131.381488822, y: 21591230.94878936),
      Point(x: 17.8880585602815, y: 46.89226406700874)),
  'EPSG:8789': ProjectAndUnProjectResult(
      Point(x: 31900874.224490017, y: 18579489.4976765),
      Point(x: 17.888058560281486, y: 46.892264067008746)),
  'EPSG:8790': ProjectAndUnProjectResult(
      Point(x: 20370302.97494371, y: 23626235.95369605),
      Point(x: 17.88805856028154, y: 46.89226406700873)),
  'EPSG:8791': ProjectAndUnProjectResult(
      Point(x: 21028688.336513884, y: 23890497.314808458),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:8792': ProjectAndUnProjectResult(
      Point(x: 21986762.4984264, y: 15120482.412760952),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8793': ProjectAndUnProjectResult(
      Point(x: 22506868.621305138, y: 15747201.082189979),
      Point(x: 17.88805856028151, y: 46.89226406700873)),
  'EPSG:8794': ProjectAndUnProjectResult(
      Point(x: 21381299.102231406, y: 16301056.100981817),
      Point(x: 17.888058560281525, y: 46.89226406700873)),
  'EPSG:8795': ProjectAndUnProjectResult(
      Point(x: 21690411.73560526, y: 16558125.820239417),
      Point(x: 17.88805856028151, y: 46.892264067008725)),
  'EPSG:8796': ProjectAndUnProjectResult(
      Point(x: 22059612.239289355, y: 16959866.733531218),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:8797': ProjectAndUnProjectResult(
      Point(x: -2740677.880879861, y: 24506261.897004243), Point(x: 0, y: 90)),
  'ESRI:37008': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8798': ProjectAndUnProjectResult(
      Point(x: -5201765.674120182, y: 24146888.302269623), Point(x: 0, y: 90)),
  'EPSG:8799': ProjectAndUnProjectResult(
      Point(x: -6763463.818613284, y: 23225390.562680393), Point(x: 0, y: 90)),
  'EPSG:8800': ProjectAndUnProjectResult(
      Point(x: -8331932.336120842, y: 22880871.489676017), Point(x: 0, y: 90)),
  'EPSG:8801': ProjectAndUnProjectResult(
      Point(x: 4175252.6559100533, y: 8132636.419234503), Point(x: 0, y: 90)),
  'EPSG:8802': ProjectAndUnProjectResult(
      Point(x: 4335563.615183162, y: 8328698.3072116645), Point(x: 0, y: 90)),
  'EPSG:8803': ProjectAndUnProjectResult(
      Point(x: 6508725.575952986, y: 4717646.78704884),
      Point(x: 17.88805856028151, y: 46.892264067008746)),
  'EPSG:7661': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8804': ProjectAndUnProjectResult(
      Point(x: -37213279.522647545, y: -18912875.961270504),
      Point(x: 0, y: -90)),
  'EPSG:8805': ProjectAndUnProjectResult(
      Point(x: -45107405.43757957, y: -26521048.301904406),
      Point(x: 0, y: -90)),
  'EPSG:8806': ProjectAndUnProjectResult(
      Point(x: -54145589.80520173, y: -35798007.60070698), Point(x: 0, y: -90)),
  'EPSG:8807': ProjectAndUnProjectResult(
      Point(x: -64460118.121024735, y: -47015897.944632985),
      Point(x: 0, y: -90)),
  'EPSG:8808': ProjectAndUnProjectResult(
      Point(x: -76195487.58152132, y: -60481645.41980923), Point(x: 0, y: -90)),
  'EPSG:8809': ProjectAndUnProjectResult(
      Point(x: -89509253.44187886, y: -76540389.67400539), Point(x: 0, y: -90)),
  'EPSG:8810': ProjectAndUnProjectResult(
      Point(x: 77897438.88146861, y: -61308557.825420626), Point(x: 0, y: -90)),
  'ESRI:37201': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8811': ProjectAndUnProjectResult(
      Point(x: 66078013.4794075, y: -47707169.16826724), Point(x: 0, y: -90)),
  'EPSG:8812': ProjectAndUnProjectResult(
      Point(x: -3067785.3678431604, y: 8760318.770413756),
      Point(x: 17.888058560279454, y: 46.892264066999296)),
  'EPSG:8813': ProjectAndUnProjectResult(
      Point(x: 3479281.287680031, y: 7904330.118931514), Point(x: 0, y: 90)),
  'EPSG:8814': ProjectAndUnProjectResult(
      Point(x: 3333355.4118026467, y: 8025679.559234877), Point(x: 0, y: 90)),
  'EPSG:8815': ProjectAndUnProjectResult(
      Point(x: 3236399.2997552953, y: 8083966.915915783), Point(x: 0, y: 90)),
  'EPSG:8912': ProjectAndUnProjectResult(
      Point(x: 4706968.526647326, y: 11340922.422261257), Point(x: 0, y: 90)),
  'EPSG:3823': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:3888': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4017': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4040': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4074': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4080': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4327': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4339': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4341': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4343': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4345': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4347': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7663': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4349': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4351': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4353': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4355': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4357': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7665': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4359': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4361': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4363': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4365': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4367': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7678': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104111': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4369': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4371': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4373': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4375': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4377': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7680': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4379': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4381': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4383': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4386': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4388': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4466': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7682': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7685': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4469': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4472': ProjectAndUnProjectResult(
      Point(x: 17.887237885734397, y: 46.89216008403257),
      Point(x: 17.888058591798575, y: 46.89226407101459)),
  'EPSG:4480': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4482': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4557': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4883': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4885': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4887': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4889': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4891': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4893': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4895': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104112': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4898': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4900': ProjectAndUnProjectResult(
      Point(x: 17.888590655621456, y: 46.8915760666189),
      Point(x: 17.888058563770603, y: 46.892264062483285)),
  'EPSG:4907': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4909': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4921': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4923': ProjectAndUnProjectResult(
      Point(x: 17.888037449170405, y: 46.892254419819864),
      Point(x: 17.888058560281515, y: 46.89226406700472)),
  'EPSG:4925': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4927': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4929': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4931': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4933': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7902': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4935': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4937': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4939': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4941': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4943': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7903': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4945': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4947': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4949': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4951': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4953': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7904': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4955': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4957': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4959': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4961': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4963': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7905': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104113': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4965': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4967': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4969': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4971': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4973': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7906': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4975': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4977': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4979': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4981': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4983': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4985': ProjectAndUnProjectResult(
      Point(x: 17.88790467139263, y: 46.89223644809947),
      Point(x: 17.888058560281515, y: 46.89226406678145)),
  'EPSG:4987': ProjectAndUnProjectResult(
      Point(x: 17.88783244917041, y: 46.89225231422713),
      Point(x: 17.88805856028152, y: 46.89226406656411)),
  'EPSG:4989': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4991': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4993': ProjectAndUnProjectResult(
      Point(x: 17.889876773236402, y: 46.89249682169752),
      Point(x: 17.88805858362109, y: 46.892264070006156)),
  'EPSG:4995': ProjectAndUnProjectResult(
      Point(x: 17.88752878305918, y: 46.89531286609277),
      Point(x: 17.888058548246388, y: 46.89226402045779)),
  'EPSG:7907': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7908': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4997': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:4999': ProjectAndUnProjectResult(
      Point(x: 17.888068343615753, y: 46.892263359508135),
      Point(x: 17.888058560281415, y: 46.89226406700894)),
  'EPSG:5012': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5245': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5251': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7909': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5263': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5323': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5342': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5353': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5359': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7910': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37202': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5364': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5370': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5372': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5380': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5392': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7911': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37203': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5488': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5545': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5560': ProjectAndUnProjectResult(
      Point(x: 17.889666276937287, y: 46.892612871469694),
      Point(x: 17.888058571393326, y: 46.89226406942727)),
  'EPSG:5592': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5830': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:5885': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7912': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37204': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6134': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6310': ProjectAndUnProjectResult(
      Point(x: 17.88809892246126, y: 46.89227902071313),
      Point(x: 17.888058560426426, y: 46.89226406707394)),
  'EPSG:6319': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6321': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6324': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6364': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6667': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7915': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6705': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6782': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6979': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6982': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6986': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:6989': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7034': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7036': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:9016': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7038': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7040': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7042': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7072': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7085': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7087': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7135': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104114': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7797': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7816': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7843': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7880': ProjectAndUnProjectResult(
      Point(x: 17.8880572634198, y: 46.89226321647872),
      Point(x: 17.88805856028151, y: 46.892264067008796)),
  'EPSG:7885': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7900': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7901': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37205': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7917': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7919': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7921': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7923': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7925': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7927': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7929': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:7931': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8085': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8231': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8235': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8239': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:9018': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8244': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8248': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8251': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8254': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8399': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8403': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8426': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8430': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8542': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8544': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8684': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8817': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8899': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8901': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:8906': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:9002': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:9005': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:9008': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:9011': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'EPSG:9013': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:4305': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37207': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37208': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37211': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37212': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37213': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37214': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37215': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37216': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37217': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37218': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37219': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37220': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37221': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37222': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37223': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37224': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37225': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37226': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37227': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37228': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37229': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37230': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37231': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37232': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37233': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37234': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37235': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37237': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37238': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37239': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37240': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37241': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37242': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37243': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37245': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37246': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37247': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37249': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37250': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37251': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37252': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37253': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37254': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37255': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37257': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37259': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:37260': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104000': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89439997507818),
      Point(x: 17.888058560281515, y: 46.892264047823126)),
  'ESRI:104009': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104010': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104011': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104012': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104013': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104014': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104015': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104016': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104017': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104019': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104020': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104021': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104022': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104023': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104024': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104025': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104026': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104047': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104050': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104100': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104101': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104102': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104103': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104104': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104105': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104106': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104107': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104108': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104115': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104116': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104117': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104118': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104119': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104120': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104121': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104122': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104123': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104124': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104125': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104126': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104127': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104128': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104129': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104130': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104131': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104132': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104133': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104134': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104135': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104136': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104137': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104138': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104139': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104140': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104141': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104142': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104143': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104144': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104145': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104179': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104180': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104181': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104182': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104183': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104184': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104185': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104186': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104199': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104223': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104248': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104256': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104257': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104258': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104259': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104260': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104261': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104286': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104287': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104304': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104305': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104700': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104701': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104702': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104703': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104704': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104705': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104706': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104707': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104708': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104709': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104710': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104711': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104712': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104713': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104714': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104715': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104716': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104717': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104718': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104719': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104720': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104721': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104722': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104723': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104724': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104725': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104726': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104727': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104728': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104729': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104730': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104731': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104732': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104733': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104734': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104735': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104736': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104737': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104738': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104739': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104740': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104741': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104742': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104743': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104744': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104745': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104746': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104747': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104748': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104749': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104750': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104751': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104752': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104753': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104754': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104755': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104756': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104757': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104758': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104759': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104760': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104761': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104762': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104763': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104764': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104765': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104766': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104767': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104768': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104769': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104770': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104771': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104772': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104773': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104774': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104775': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104776': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104777': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104778': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104779': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104780': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104781': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104782': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104783': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104784': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104785': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104786': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104800': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104801': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104802': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104803': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104804': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104805': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104806': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104807': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104808': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104809': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104810': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104811': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104812': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104813': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104814': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104815': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104816': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104817': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104818': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104819': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104820': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104821': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104822': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104823': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104824': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104825': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104826': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104827': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104828': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104829': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104830': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104831': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104832': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104833': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104834': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104835': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104836': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104837': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104838': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104839': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104840': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104841': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104842': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104843': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104844': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104845': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104846': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104847': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104848': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104849': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104850': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104851': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104852': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104853': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104854': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104855': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104856': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104857': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104858': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104859': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104860': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104861': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104862': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104863': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104864': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104865': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104866': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104867': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104868': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104869': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104870': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104871': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104896': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104900': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104901': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104902': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104903': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104904': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104905': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104906': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104907': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104908': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104909': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104910': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104911': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104912': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104913': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104914': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104915': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104916': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104917': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104918': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104919': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104920': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104921': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104922': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104923': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104924': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104925': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104926': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104927': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104928': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104929': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104930': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104931': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104932': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104933': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104934': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104935': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104936': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104937': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104938': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104939': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104940': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104941': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104942': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104943': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104944': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104945': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104946': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104947': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104948': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104949': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104950': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104951': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104952': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104953': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104954': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104955': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104956': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104957': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104958': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104959': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104960': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104961': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104962': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104963': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104964': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104965': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104966': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104967': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104968': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104969': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104970': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104971': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104972': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104973': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104974': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104975': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879),
      Point(x: 17.888058560281515, y: 46.89226406700879)),
  'ESRI:104990': ProjectAndUnProjectResult(
      Point(x: 17.888058560281515, y: 46.89226406700879)