<p align="center">
  <br/>
  <a href="https://opensource.org/license/agpl-v3"><img src="https://img.shields.io/badge/License-AGPL_v3-blue.svg?color=3F51B5&style=for-the-badge&label=License&logoColor=000000&labelColor=ececec" alt="Licencia: MIT"></a>
  <a href="https://discord.immich.app">
    <img src="https://img.shields.io/discord/979116623879368755.svg?label=Discord&logo=Discord&style=for-the-badge&logoColor=000000&labelColor=ececec" atl="Discord"/>
  </a>
  <br/>
  <br/>
</p>

<p align="center">
<img src="../design/immich-logo-stacked-light.svg" width="300" title="Iniciar sesión con URL personalizada">
</p>
<h3 align="center">Immich: Una solución Self-Hosted de alto rendimiento para la copia de seguridad de fotos y videos</h3>
<br/>
<a href="https://immich.app">
<img src="../design/immich-screenshots.png" title="Captura de pantalla principal">
</a>
<br/>
<p align="center">
  <a href="../README.md">English</a>
  <a href="README_ca_ES.md">Català</a>
  <a href="README_fr_FR.md">Français</a>
  <a href="README_it_IT.md">Italiano</a>
  <a href="README_ja_JP.md">日本語</a>
  <a href="README_ko_KR.md">한국어</a>
  <a href="README_de_DE.md">Deutsch</a>
  <a href="README_nl_NL.md">Nederlands</a>
  <a href="README_tr_TR.md">Türkçe</a>
  <a href="README_zh_CN.md">中文</a>
  <a href="README_uk_UA.md">Українська</a>
  <a href="README_ru_RU.md">Русский</a>
  <a href="README_pt_BR.md">Português Brasileiro</a>
  <a href="README_sv_SE.md">Svenska</a>
  <a href="README_ar_JO.md">العربية</a>
  <a href="README_th_TH.md">ภาษาไทย</a>
</p>

## Advertencia

- ⚠️ El proyecto está en **activo desarrollo**.
- ⚠️ Es probable que haya errores y cambios disruptivos.
- ⚠️ **¡No utilices la aplicación como única forma de almacenar tus fotos y videos!**
- ⚠️ Siempre sigue el plan de backups [3-2-1](https://www.backblaze.com/blog/the-3-2-1-backup-strategy/) para tus fotos y videos.

## Contenido

- [Documentación oficial](https://immich.app/docs)
- [Hoja de ruta](https://github.com/orgs/immich-app/projects/1)
- [Demo](#demo)
- [Funciones](#funciones)
- [Introducción](https://immich.app/docs/overview/introduction)
- [Instalación](https://immich.app/docs/install/requirements)
- [Directrices para contribuir](https://immich.app/docs/overview/support-the-project)

## Documentación

Puedes encontrar la documentación oficial, incluidas las guías de instalación, en <https://immich.app/>.

## Demo

Puedes acceder a la demostración web en <https://demo.immich.app>

Para la aplicación móvil, puedes usar `https://demo.immich.app/api` en la `URL del servidor`.

```bash title="Credenciales de la demo"
Credenciales
correo: demo@immich.app
contraseña: demo
```

```bash
Especificaciones: Una VM de nivel gratuito de Oracle - Ámsterdam - CPU ARM64 de cuatro núcleos a 2.4 GHz, 24 GB de RAM
```

## Funciones

| Funcionalidades                                       | Móvil | Web |
| ----------------------------------------------------- | ------ | --- |
| Cargar y ver videos y fotos                          | Sí     | Sí  |
| Copia de seguridad automática al abrir la aplicación | Sí     | N/D |
| Álbum(es) selectivo(s) para copia de seguridad       | Sí     | N/D |
| Descargar fotos y videos al dispositivo local        | Sí     | Sí  |
| Soporte multiusuario                                 | Sí     | Sí  |
| Álbum y álbumes compartidos                          | Sí     | Sí  |
| Barra de desplazamiento con función de búsqueda      | Sí     | Sí  |
| Soporte para formatos RAW                            | Sí     | Sí  |
| Visualización de metadatos (EXIF, map)              | Sí     | Sí  |
| Búsqueda por metadatos, objetos, rostros y CLIP      | Sí     | Sí  |
| Funciones administrativas (gestión de usuarios)      | No     | Sí  |
| Copia de seguridad en segundo plano                  | Sí     | N/D |
| Desplazamiento virtual                               | Sí     | Sí  |
| Soporte de OAuth                                     | Sí     | Sí  |
| Claves de API                                        | N/D    | Sí  |
| Copia de seguridad y reproducción de LivePhoto       | iOS    | Sí  |
| Estructura de almacenamiento definida por el usuario | Sí     | Sí  |
| Compartir públicamente                               | No     | Sí  |
| Archivar y marcar como favorito                      | Sí     | Sí  |
| Mapa global                                          | No     | Sí  |
| Compartir con colaboradores                          | Sí     | Sí  |
| Reconocimiento facial y agrupación                   | Sí     | Sí  |
| Recuerdos (hace x años)                              | Sí     | Sí  |
| Soporte sin conexión                                 | Sí     | No  |
| Galería de solo lectura                              | Sí     | Sí  |

## Traducciones

Lea mas acerca de las traducciones [acá](https://immich.app/docs/developer/translations).

<a href="https://hosted.weblate.org/engage/immich/">
<img src="https://hosted.weblate.org/widget/immich/immich/multi-auto.svg" alt="Translation status" />
</a>

## Actividad del repositorio

![Activities](https://repobeats.axiom.co/api/embed/9e86d9dc3ddd137161f2f6d2e758d7863b1789cb.svg "Repobeats analytics image")

## Historial de Estrellas

<a href="https://star-history.com/#immich-app/immich&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" />
   <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" width="100%" />
 </picture>
</a>

## Contribuidores

<a href="https://github.com/alextran1502/immich/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=immich-app/immich" width="100%"/>
</a>
