// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 23;
// AUTOGENERATED END

const file = 'step_through_simple_linear_2_test.dart';

void code() {
  final a = getA();
  final b = getB();

  print('Hello, World!'); // LINE_A
  print('a: $a; b: $b');
  print('Goodbye, world!');
}

bool getA() => true;
int getB() => 42;

final stops = <String>[];
const expected = <String>[
  '$file:$LINE_A:3', // on call to 'print'
  '$file:${LINE_A + 1}:23', // on ')', i.e. before ';'
  '$file:${LINE_A + 1}:3', // on call to 'print'
  '$file:${LINE_A + 2}:3', // on call to 'print'
  '$file:${LINE_A + 3}:1', // on ending '}'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  runStepThroughProgramRecordingStops(stops),
  checkRecordedStops(stops, expected),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'step_through_simple_linear_2_test.dart',
      testeeConcurrent: code,
      pauseOnStart: true,
      pauseOnExit: true,
    );
