<p align="center"> 
  <br/>  
  <a href="https://opensource.org/license/agpl-v3"><img src="https://img.shields.io/badge/License-AGPL_v3-blue.svg?color=3F51B5&style=for-the-badge&label=License&logoColor=000000&labelColor=ececec" alt="라이선스: AGPLv3"></a>
  <a href="https://discord.immich.app">
    <img src="https://img.shields.io/discord/979116623879368755.svg?label=Discord&logo=Discord&style=for-the-badge&logoColor=000000&labelColor=ececec" alt="Discord"/>
  </a>
  <br/>  
  <br/>   
</p>

<p align="center">
<img src="../design/immich-logo-stacked-light.svg" width="300" title="Login With Custom URL">
</p>
<h3 align="center">고성능 자체 호스팅 사진 및 동영상 관리 솔루션</h3>
<br/>
<a href="https://immich.app">
<img src="../design/immich-screenshots.png" title="메인 스크린샷">
</a>
<br/>
<p align="center">

<a href="../README.md">English</a>
<a href="README_ca_ES.md">Català</a>
<a href="README_es_ES.md">Español</a>
<a href="README_fr_FR.md">Français</a>
<a href="README_it_IT.md">Italiano</a>
<a href="README_ja_JP.md">日本語</a>
<a href="README_de_DE.md">Deutsch</a>
<a href="README_nl_NL.md">Nederlands</a>
<a href="README_tr_TR.md">Türkçe</a>
<a href="README_zh_CN.md">中文</a>
<a href="README_ru_RU.md">Русский</a>
<a href="README_pt_BR.md">Português Brasileiro</a>
<a href="README_sv_SE.md">Svenska</a>
<a href="README_ar_JO.md">العربية</a>
<a href="README_th_TH.md">ภาษาไทย</a>

</p>

## 주의 사항

- ⚠️ 이 프로젝트는 **매우 활발하게** 개발 중입니다.
- ⚠️ 버그와 잦은 변경 사항이 있을 것으로 예상됩니다.
- ⚠️ **사진과 동영상을 이 앱에만 단독으로 저장하지 마세요.**
- ⚠️ 중요한 사진과 동영상을 위해 항상 [3-2-1](https://www.backblaze.com/blog/the-3-2-1-backup-strategy/) 백업 계획을 따르세요!

> [!NOTE]
> 설치하는 방법을 포함한 주요 문서는 https://immich.app/ 에서 확인할 수 있습니다.

## 링크

- [문서](https://immich.app/docs)
- [소개](https://immich.app/docs/overview/introduction)
- [설치](https://immich.app/docs/install/requirements)
- [로드맵](https://immich.app/roadmap)
- [데모](#데모)
- [기능](#기능)
- [번역](https://immich.app/docs/developer/tranlations)
- [기여](https://immich.app/docs/overview/support-the-project)

## 데모

[이곳](https://demo.immich.app)에서 데모를 체험해보세요. 데모 서버는 2.4Ghz 쿼드 코어 ARM64 CPU 및 24GB 램으로 구성된 Oracle Free-tier VM 암스테르담 리전에서 구동됩니다.

모바일 앱의 경우, `서버 엔드포인트 URL`에 `https://demo.immich.app/api`를 입력하세요.

### 로그인 정보

| 이메일            | 비밀번호   |
| --------------- | -------- |
| demo@immich.app | demo     |

## 기능

| 기능                                   | 모바일 | 웹 |
| :------------------------------------ | ------ | ------ |
| 사진, 동영상 업로드 및 보기 | 예 | 예 |
| 앱 실행 시 자동 백업 | 예 | N/A |
| 콘텐츠 중복 방지 | 예 | 예 |
| 백업을 위한 앨범 선택 | 예 | N/A |
| 로컬 기기에 사진 및 동영상 다운로드 | 예 | 예 |
| 여러 사용자 지원 | 예 | 예 |
| 앨범 및 공유 앨범 | 예 | 예 |
| 스크롤/드래그 가능한 스크롤 바 | 예 | 예 |
| RAW 형식 지원 | 예 | 예 |
| 메타데이터 보기 (EXIF, 지도) | 예 | 예 |
| 메타데이터, 사물, 얼굴, CLIP 검색 | 예 | 예 |
| 관리 기능 (사용자 관리) | 아니요 | 예 |
| 백그라운드 백업 | 예 | N/A |
| 가상 스크롤 | 예 | 예 |
| OAuth 지원 | 예 | 예 |
| API 키 | N/A | 예 |
| 라이브 포토/모션 포토 백업 및 재생 | 예 | 예 |
| 360도 이미지 지원 | 아니요 | 예 |
| 사용자 정의 스토리지 구조 | 예 | 예 |
| 공개 공유 | 아니요 | 예 |
| 보관 및 즐겨찾기 | 예 | 예 |
| 글로벌 지도 | 예 | 예 |
| 파트너와 공유 | 예 | 예 |
| 얼굴 인식 및 클러스터링 | 예 | 예 |
| 추억 (~년 전) | 예 | 예 |
| 오프라인 지원 | 예 | 아니요 |
| 읽기 전용 갤러리 | 예 | 예 |
| 사진 스택 | 예 | 예 |

## 번역

번역에 대한 자세한 정보는 [이곳](https://immich.app/docs/developer/translations)에서 확인하세요.

<a href="https://hosted.weblate.org/engage/immich/">
<img src="https://hosted.weblate.org/widget/immich/immich/multi-auto.svg" alt="번역 현황" />
</a>

## 리포지터리 활동

![활동](https://repobeats.axiom.co/api/embed/9e86d9dc3ddd137161f2f6d2e758d7863b1789cb.svg "Repobeats analytics image")

## 스타 기록

<a href="https://star-history.com/#immich-app/immich&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" />
   <img alt="스타 기록 차트" src="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" width="100%" />
 </picture>
</a>

## 기여자

<a href="https://github.com/alextran1502/immich/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=immich-app/immich" width="100%"/>
</a>
