<p align="center"> 
  <br/>  
  <a href="https://opensource.org/license/agpl-v3"><img src="https://img.shields.io/badge/License-AGPL_v3-blue.svg?color=3F51B5&style=for-the-badge&label=License&logoColor=000000&labelColor=ececec" alt="Lizenz: MIT"></a>
  <a href="https://discord.immich.app">
    <img src="https://img.shields.io/discord/979116623879368755.svg?label=Discord&logo=Discord&style=for-the-badge&logoColor=000000&labelColor=ececec" alt="Discord"/>
  </a>
  <br/>  
  <br/>   
</p>

<p align="center">
<img src="../design/immich-logo-stacked-light.svg" width="300" title="Login mit eigener URL">
</p>
<h3 align="center">Immich - Hoch performante, selbst gehostete Backup-Lösung für Fotos und Videos</h3>
<br/>
<a href="https://immich.app">
<img src="../design/immich-screenshots.png" title="Haupt-Screenshot">
</a>
<br/>
<p align="center">
  <a href="../README.md">English</a>
  <a href="README_ca_ES.md">Català</a>
  <a href="README_es_ES.md">Español</a>
  <a href="README_fr_FR.md">Français</a>
  <a href="README_it_IT.md">Italiano</a>
  <a href="README_ja_JP.md">日本語</a>
  <a href="README_ko_KR.md">한국어</a>
  <a href="README_nl_NL.md">Nederlands</a>
  <a href="README_tr_TR.md">Türkçe</a>
  <a href="README_zh_CN.md">中文</a>
  <a href="README_ru_RU.md">Русский</a>
  <a href="README_pt_BR.md">Português Brasileiro</a>
  <a href="README_sv_SE.md">Svenska</a>
  <a href="README_ar_JO.md">العربية</a>
</p>

## Warnung

- ⚠️ Das Projekt befindet sich in **sehr aktiver** Entwicklung.
- ⚠️ Gehe von möglichen Fehlern und von Änderungen mit Breaking-Changes aus.
- ⚠️ **Nutze die App auf keinen Fall als einziges Speichermedium für deine Fotos und Videos.**
- ⚠️ Befolge immer die [3-2-1](https://www.backblaze.com/blog/the-3-2-1-backup-strategy/) Backup-Regel für deine wertvollen Fotos und Videos!

> [!NOTE]
> Die Hauptdokumentation, einschließlich der Installationsanleitungen, befinden sich unter https://immich.app/.


## Inhalt

- [Offizielle Dokumentation](https://immich.app/docs)
- [Über Immich](https://immich.app/docs/overview/introduction)
- [Installation](https://immich.app/docs/install/requirements)
- [Roadmap](https://github.com/orgs/immich-app/projects/1)
- [Demo](#demo)
- [Funktionen](#funktionen)
- [Übersetzungen](https://immich.app/docs/developer/translations)
- [Beitragsrichtlinien](https://immich.app/docs/overview/support-the-project)

## Demo

Die Web-Demo kannst Du unter https://demo.immich.app finden.
Die Demo läuft auf einer Free Tier Oracle VM in Amsterdam mit einer 2.4Ghz Quad-Core ARM64 CPU und 24GB RAM.

Für die Handy-App kannst Du `https://demo.immich.app/api` als `Server Endpoint URL` angeben.

### Login Daten

| Email           | Password |
| --------------- | -------- |
| demo@immich.app | demo     |

## Funktionen

| Funktionen                                           | Mobil  | Web   |
| ---------------------------------------------------- | ------ | ----- |
| Fotos & Videos hochladen und ansehen                 | Ja     | Ja    |
| Automatische Sicherung beim öffnen der App           | Ja     | k. A  |
| Selektive Auswahl von Alben zum Sichern              | Ja     | k. A  |
| Vermeidung von Duplikaten                            | Ja     | Ja    |     
| Fotos und Videos auf das Gerät herunterladen         | Ja     | Ja    |
| Unterstützung mehrerer Benutzer                      | Ja     | Ja    |
| Alben und geteilte Alben                             | Ja     | Ja    |
| Scrollbar mit Scrubbing-/Drag-Funktion               | Ja     | Ja    |
| Unterstützung für RAW Formate                        | Ja     | Ja    |
| Metadaten anzeigen (EXIF, Karte)                     | Ja     | Ja    |
| Suchen nach Metadaten, Objekten, Gesichtern und CLIP | Ja     | Ja    |
| Administrative Funktionen (Benutzerverwaltung)       | Nein   | Ja    |
| Hintergrundsicherung                                 | Ja     | k. A  |
| Virtuelles Scrollen                                  | Ja     | Ja    |
| OAuth Unterstützung                                  | Ja     | Ja    |
| API-Schlüssel                                        | k. A   | Ja    |
| LivePhoto/MotionPhoto Sicherung und Wiedergabe       | Ja     | Ja    |
| Unterstützung für 360-Grad-Bilder     	             | Nein   | Ja    |
| Benutzerdefinierte Speicherstruktur                  | Ja     | Ja    |
| Öffentliches Teilen                                  | Nein   | Ja    |
| Archiv und Favoriten                                 | Ja     | Ja    |
| Globale Karte                                        | Ja     | Ja    |
| Partnerfreigabe (Teilen)                             | Ja     | Ja    |
| Gesichtserkennung und -gruppierung                   | Ja     | Ja    |
| Rückblicke (heute vor x Jahren)                      | Ja     | Ja    |
| Offline Unterstützung                                | Ja     | Nein  |
| Schreibgeschützte Gallerie                           | Ja     | Ja    |
| Gestapelte Bilder                                    | Ja     | Ja    |


## Übersetzungen

Mehr zum Thema Übersetzungen kannst du [hier](https://immich.app/docs/developer/translations) erfahren.

<a href="https://hosted.weblate.org/engage/immich/">
<img src="https://hosted.weblate.org/widget/immich/immich/multi-auto.svg" alt="Translation status" />
</a>

## Repository-Aktivität

![Activities](https://repobeats.axiom.co/api/embed/9e86d9dc3ddd137161f2f6d2e758d7863b1789cb.svg "Repobeats analytics image")

## Github Sterne

<a href="https://star-history.com/#immich-app/immich&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" />
   <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" width="100%" />
 </picture>
</a>

## Mitwirkende

<a href="https://github.com/alextran1502/immich/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=immich-app/immich" width="100%"/>
</a>
