
Privacy Policy – Podcini

Podcini is developed and maintained by individual volunteers and not represented by any legal entity. The community doesn’t need your data, so the app and website are designed to be fully GDPR compliant. Read on to learn more.

## What data the Podcini app might collect, store and process

The app only records data strictly necessary for the app to function. This includes for example the list of podcasts you follow, the app settings, and authentication data provided for specific podcasts or services (such as synchronisation services). The app does not include any advertisement libraries or any 3rd party tracking (analytics) code, such as Google Analytics.

**All data provided and created when using the Podcini app is stored locally on your device. Podcini does not send or upload your data anywhere, except where strictly necessary for the functioning of the app.** Please see the second next section for the cases in which your data may be provided to third parties.

The only case where your data from 3rd parties is handled, is when using a synchronisation service if enabled via the settings. In that case, the app may receive subscriptions and playback events provided by the service.

## App permissions

The app requests the following privacy-relevant Android permissions:

- Read from/write to Storage (Photos/Media/Files): The storage permission is used to open files that are not downloaded directly from within the app. It can also be used to import app settings or OPML files. The permission is only requested if you perform an action that requires reading from storage.

## What app data other parties might collect, store and process

- Podcast hosters: When provided in the podcast settings, a host will receive authentication data you provided. Any web servers that provide the podcast feeds might collect additional data, such as your IP address, access time and what is being accessed. This includes the episodes you are downloading or streaming. Please refer to their respective privacy policies for details. You can view the URL of a podcast by opening the podcast and pressing the info icon. Podcini does not allow remote servers to set cookies. The servers can detect the fact that you are using Podcini and which version of Podcini you are using (HTTP User-Agent). If multiple podcasts are hosted on the same server, the server can detect the list of podcasts that you subscribed to and that are hosted on that server. This might happen if publishers use feedburner, podtrac or similar services to distribute their feeds.
- Discovery and search services: When opening the Discover screen in the app, it sends a call to Apple to collect podcast suggestions. They may store the query, including country (which by default is the device’s country). These suggestions can be disabled by choosing “off” in the region selector. When using the search feature in Podcini, the services PodcastIndex.org, iTunes, fyyd and gpodder.net may store your query, including the search terms. Discovery and search queries also include IP address, time, and app name “Podcini”. After subscribing, the feed is served from the podcast hoster, meaning the discovery/search service is no longer involved.
- Synchronisation services: When enabled via the settings, Podcini synchronises your data. This data may include login credentials, subscribed podcasts, listened episodes, play, pause & favorite actions with date & time stamps and IP address. For more information, see your provider’s privacy policy (e.g. [gpodder.net’s privacy policy](https://gpodder.net/privacy), or the one of your Nextcloud host).
- Google: If you have activated backup & reset in your phone settings (`Settings` » `Backup & Reset` » `Back up my data`), you should be aware that Android itself will periodically save a copy of your phone’s data in Google’s servers. This backup contains private information, including your WiFi passwords, messages and call history. It may also include data from Podcini and from other apps you use. The developers of Podcini do not have access to this data. For more information, see [Google’s privacy policy](https://policies.google.com/).

## What data might be collected, stored and processed from Podcini online services

- The donation system: Podcini uses Open Collective, offered by Open Collective Inc (USA) & Open Collective Europe ASBL (Belgium). When you make a donation, these entities get access to certain data. For more information, see [Open Collective’s privacy policy](https://opencollective.com/privacypolicy).
- The website: Podcini’s website is hosted via GitHub Pages. [GitHub’s privacy policy](https://docs.github.com/en/github/site-policy/github-privacy-statement#github-pages) notices that “GitHub may collect User Personal Information from visitors to your GitHub Pages website, including logs of visitor IP addresses, to comply with legal obligations, and to maintain the security and integrity of the Website and the Service.” The website does not store any cookies on your machine, and no 3rd party tracking (analytics) or other services are used.
- The forum: Podcini’s forum uses the Discourse software, hosted by the core team. Please see the [forum’s privacy policy](https://github.com/XilinJia/Podcini.X/blob/main/PrivacyPolicy.md) for which data is concerned.

## What data the Podcini core team may have access to

The developers of Podcini do **not** have access to any of your information, except when you

- actively share debugging information (either via email using the ‘Crash Report’ function, or via the Android crash reporting functionality of Google):
  - device type
  - Android version
  - Podcini version
- actively share a review in the Google Play store:
  - public profile information
  - Podcini version
  - device type
  - device language
  - Android version
- visit or participate on our forum: as described in the [forum’s privacy policy](https://forum.antennapod.org/privacy)
- actively make a financial contribution via Open Collective (unless you make an [anonymous guest](https://docs.opencollective.com/help/financial-contributors/payments#contributing-as-a-guest) or [incognito](https://docs.opencollective.com/help/financial-contributors/payments#select-a-contributor) contribution):
  - public profile information (name, company, description, image, Twitter, GitHub, website)
  - email address

## Updates of this Privacy Policy

The developers may update this policy in the future. It is advisable to check the policy periodically for any changes. Changes to this Privacy Policy are effective when they are made on this document.

This Privacy Policy was last updated on 2024-02-14. If you have questions, open an issue on GitHub or our forum.
