/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.provisional.symbols;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.ISymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.source.ISymbolConstants;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.JSFAppConfigManager;
import org.eclipse.jst.jsf.designtime.internal.provisional.symbols.FileContextUtil;
import org.eclipse.jst.jsf.designtime.internal.provisional.symbols.SymbolUtil;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;

public class DefaultBeanSymbolSourceProvider {
    private static DefaultBeanSymbolSourceProvider INSTANCE;

    public static DefaultBeanSymbolSourceProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultBeanSymbolSourceProvider();
        }
        return INSTANCE;
    }

    protected DefaultBeanSymbolSourceProvider() {
    }

    public ISymbol[] getSymbols(IAdaptable context, int symbolScopeMask) {
        IFile file = FileContextUtil.deriveIFileFromContext(context);
        if (file != null) {
            IProject myProject = file.getProject();
            List managedBeans = this.getManagedBeanSymbols(myProject, symbolScopeMask);
            return managedBeans.toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
        }
        return ISymbol.EMPTY_SYMBOL_ARRAY;
    }

    public ISymbol getSymbol(String name, IAdaptable context, int symbolScopeMask) {
        return SymbolUtil.findSymbolByName(this.getSymbols(context, symbolScopeMask), name);
    }

    public ISymbol[] getSymbols(String prefix, IAdaptable context, int symbolScopeMask) {
        return SymbolUtil.filterSymbolsByPrefix(this.getSymbols(context, symbolScopeMask), prefix);
    }

    private List getManagedBeanSymbols(IProject iProject, int symbolScopeMask) {
        ArrayList<IBeanInstanceSymbol> symbols = new ArrayList<IBeanInstanceSymbol>();
        JSFAppConfigManager configManager = JSFAppConfigManager.getInstance((IProject)iProject);
        if (configManager != null) {
            Iterator aIt = configManager.getManagedBeans().iterator();
            while (aIt.hasNext()) {
                ManagedBeanType bean = (ManagedBeanType)aIt.next();
                if (!this.isBeanScopeInMask(bean.getManagedBeanScope(), symbolScopeMask)) continue;
                String name = bean.getManagedBeanName().getTextContent();
                String detailedDescription = this.createAdditionalProposalInfo(bean);
                IBeanInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
                symbol.setName(name);
                symbol.setDetailedDescription(detailedDescription);
                symbol.setRuntimeSource(ERuntimeSource.MANAGED_BEAN_SYMBOL_LITERAL);
                try {
                    IJavaProject javaProject = JavaCore.create((IProject)iProject);
                    IType type = javaProject.findType(bean.getManagedBeanClass().getTextContent());
                    if (type != null) {
                        IJavaTypeDescriptor2 javaTypeDescriptor = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
                        javaTypeDescriptor.setType(type);
                        symbol.setJavaTypeDescriptor(javaTypeDescriptor);
                    }
                }
                catch (Exception exception) {}
                symbols.add(symbol);
            }
        }
        return symbols;
    }

    private String createAdditionalProposalInfo(ManagedBeanType beanType) {
        StringBuffer additionalInfo = new StringBuffer("<p><b>");
        additionalInfo.append("Name: </b>");
        additionalInfo.append(beanType.getManagedBeanName().getTextContent());
        additionalInfo.append("</p>");
        additionalInfo.append("<p><b>Type: </b>");
        additionalInfo.append(beanType.getManagedBeanClass().getTextContent());
        additionalInfo.append("</p>");
        additionalInfo.append("<p><b>Scope: </b>");
        additionalInfo.append(beanType.getManagedBeanScope().getTextContent());
        additionalInfo.append("</p>");
        StringBuffer descBuffer = new StringBuffer();
        Iterator it = beanType.getDescription().iterator();
        while (it.hasNext()) {
            DescriptionType descType = (DescriptionType)it.next();
            String appendString = descType.getTextContent();
            if (appendString == null) continue;
            descBuffer.append(appendString);
        }
        if (descBuffer.length() > 0) {
            additionalInfo.append("<p><b>Description: </b>");
            additionalInfo.append(descBuffer);
            additionalInfo.append("</p>");
        }
        return additionalInfo.toString();
    }

    private boolean isBeanScopeInMask(ManagedBeanScopeType scope, int scopeMask) {
        int testScope = ISymbolConstants.getMaskForString((String)scope.getTextContent());
        if (testScope != -1) {
            return (scopeMask & testScope) != 0;
        }
        return false;
    }
}

