/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db;

import java.text.Collator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.dali.db.Column;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.internal.utility.iterators.FilteringIterator;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.emf.common.util.EList;

public class ForeignKey
implements Comparable {
    private final Table baseTable;
    private final org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey rdbForeignKey;
    private Table referencedTable;
    private Set columnPairs;
    private String defaultEntityFieldName;
    private boolean defaultEntityFieldNameCalculated = false;

    ForeignKey(Table baseTable, org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey rdbForeignKey) {
        this.baseTable = baseTable;
        this.rdbForeignKey = rdbForeignKey;
    }

    public Table getBaseTable() {
        return this.baseTable;
    }

    public String getName() {
        return this.rdbForeignKey.getName();
    }

    boolean isCaseSensitive() {
        return this.baseTable.isCaseSensitive();
    }

    boolean wraps(org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey foreignKey) {
        return this.rdbForeignKey == foreignKey;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.getName()) + ": " + this.getColumnPairs()));
    }

    public Table getReferencedTable() {
        if (this.referencedTable == null) {
            this.referencedTable = this.baseTable.table((org.eclipse.wst.rdb.internal.models.sql.tables.Table)this.rdbForeignKey.getUniqueConstraint().getBaseTable());
        }
        return this.referencedTable;
    }

    public Iterator baseColumns() {
        return new TransformationIterator(this.columnPairs()){

            protected Object transform(Object next) {
                return ((ColumnPair)next).getBaseColumn();
            }
        };
    }

    public Iterator nonPrimaryKeyBaseColumns() {
        return new FilteringIterator(this.baseColumns()){

            protected boolean accept(Object o) {
                return !ForeignKey.this.getBaseTable().primaryKeyColumnsContains((Column)o);
            }
        };
    }

    public Iterator referencedColumns() {
        return new TransformationIterator(this.columnPairs()){

            protected Object transform(Object next) {
                return ((ColumnPair)next).getReferencedColumn();
            }
        };
    }

    public String javaFieldName() {
        String fieldName = this.getDefaultEntityFieldName();
        return fieldName == null ? this.nonDefaultEntityFieldName() : fieldName;
    }

    public boolean matchesJavaFieldName(String javaFieldName) {
        return this.isCaseSensitive() ? javaFieldName.equals(this.getDefaultEntityFieldName()) : javaFieldName.equalsIgnoreCase(this.getDefaultEntityFieldName());
    }

    public boolean isDefaultFor(String javaFieldName) {
        if (this.columnPairsSize() != 1) {
            return false;
        }
        if (this.getReferencedTable().primaryKeyColumnsSize() != 1) {
            return false;
        }
        ColumnPair columnPair = (ColumnPair)this.columnPairs().next();
        Column pkColumn = (Column)this.getReferencedTable().primaryKeyColumns().next();
        if (columnPair.getReferencedColumn() != pkColumn) {
            return false;
        }
        return columnPair.getBaseColumn().matchesJavaFieldName(String.valueOf(javaFieldName) + "_" + pkColumn.getName());
    }

    private synchronized Set getColumnPairs() {
        if (this.columnPairs == null) {
            this.columnPairs = this.buildColumnPairs();
        }
        return this.columnPairs;
    }

    private Set buildColumnPairs() {
        EList baseColumns = this.rdbForeignKey.getMembers();
        int size = baseColumns.size();
        EList refColumns = this.rdbForeignKey.getUniqueConstraint().getMembers();
        if (refColumns.size() != size) {
            throw new IllegalStateException("mismatched sizes: " + size + " vs. " + refColumns.size());
        }
        HashSet<ColumnPair> result = new HashSet<ColumnPair>(baseColumns.size());
        int i = baseColumns.size();
        while (i-- > 0) {
            Column baseColumn = this.baseTable.column((org.eclipse.wst.rdb.internal.models.sql.tables.Column)baseColumns.get(i));
            Column refColumn = this.baseTable.column((org.eclipse.wst.rdb.internal.models.sql.tables.Column)refColumns.get(i));
            result.add(new ColumnPair(baseColumn, refColumn));
        }
        return result;
    }

    public Iterator columnPairs() {
        return this.getColumnPairs().iterator();
    }

    public int columnPairsSize() {
        return this.getColumnPairs().size();
    }

    private String getDefaultEntityFieldName() {
        if (!this.defaultEntityFieldNameCalculated) {
            this.defaultEntityFieldNameCalculated = true;
            this.defaultEntityFieldName = this.buildDefaultEntityFieldName();
        }
        return this.defaultEntityFieldName;
    }

    private String buildDefaultEntityFieldName() {
        if (!this.referencesSingleColumnPrimaryKey()) {
            return null;
        }
        ColumnPair columnPair = (ColumnPair)this.columnPairs().next();
        String baseColName = columnPair.getBaseColumn().getName();
        String refColName = columnPair.getReferencedColumn().getName();
        if (baseColName.length() <= refColName.length() + 1) {
            return null;
        }
        if (!baseColName.endsWith(refColName)) {
            return null;
        }
        int _index = baseColName.length() - refColName.length() - 1;
        if (baseColName.charAt(_index) != '_') {
            return null;
        }
        String name = baseColName.substring(0, _index);
        return this.isCaseSensitive() ? name : name.toLowerCase();
    }

    public boolean referencesSingleColumnPrimaryKey() {
        if (this.columnPairsSize() != 1) {
            return false;
        }
        if (this.getReferencedTable().primaryKeyColumnsSize() != 1) {
            return false;
        }
        ColumnPair columnPair = (ColumnPair)this.columnPairs().next();
        return columnPair.getReferencedColumn() == this.getReferencedTable().primaryKeyColumns().next();
    }

    private String nonDefaultEntityFieldName() {
        return this.columnPairsSize() == 1 ? ((ColumnPair)this.columnPairs().next()).getBaseColumn().javaFieldName() : this.getReferencedTable().javaFieldName();
    }

    public int compareTo(Object o) {
        return Collator.getInstance().compare(this.getName(), ((ForeignKey)o).getName());
    }

    public static class ColumnPair
    implements Comparable {
        private final Column baseColumn;
        private final Column referencedColumn;

        ColumnPair(Column baseColumn, Column referencedColumn) {
            this.baseColumn = baseColumn;
            this.referencedColumn = referencedColumn;
        }

        public Column getBaseColumn() {
            return this.baseColumn;
        }

        public Column getReferencedColumn() {
            return this.referencedColumn;
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.baseColumn.getName()) + "=>" + this.referencedColumn.getName()));
        }

        public int compareTo(Object o) {
            return Collator.getInstance().compare(this.getBaseColumn().getName(), ((ColumnPair)o).getBaseColumn().getName());
        }
    }
}

