/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.easymock.internal.AssertionErrorWrapper;
import org.easymock.internal.EasyMockProperties;
import org.easymock.internal.ErrorMessage;
import org.easymock.internal.ExpectedInvocation;
import org.easymock.internal.ExpectedInvocationAndResult;
import org.easymock.internal.IMocksBehavior;
import org.easymock.internal.Invocation;
import org.easymock.internal.Range;
import org.easymock.internal.RecordState;
import org.easymock.internal.Result;
import org.easymock.internal.UnorderedBehavior;

public class MocksBehavior
implements IMocksBehavior,
Serializable {
    private static final long serialVersionUID = 6824996227285837998L;
    private final List<UnorderedBehavior> behaviorLists = new ArrayList<UnorderedBehavior>();
    private final List<ExpectedInvocationAndResult> stubResults = new ArrayList<ExpectedInvocationAndResult>();
    private final List<Invocation> unexpectedCalls = new ArrayList<Invocation>();
    private final boolean nice;
    private volatile boolean checkOrder;
    private volatile boolean isThreadSafe;
    private volatile boolean shouldBeUsedInOneThread;
    private final AtomicInteger position = new AtomicInteger();
    private volatile transient Thread lastThread;

    public MocksBehavior(boolean nice) {
        this.nice = nice;
        this.isThreadSafe = !Boolean.parseBoolean(EasyMockProperties.getInstance().getProperty("easymock.notThreadSafeByDefault"));
        this.shouldBeUsedInOneThread = Boolean.parseBoolean(EasyMockProperties.getInstance().getProperty("easymock.enableThreadSafetyCheckByDefault"));
    }

    @Override
    public final void addStub(ExpectedInvocation expected, Result result) {
        this.stubResults.add(new ExpectedInvocationAndResult(expected, result));
    }

    @Override
    public void addExpected(ExpectedInvocation expected, Result result, Range count) {
        this.addBehaviorListIfNecessary(expected);
        this.lastBehaviorList().addExpected(expected, result, count);
    }

    private Result getStubResult(Invocation actual) {
        for (ExpectedInvocationAndResult each : this.stubResults) {
            if (!each.getExpectedInvocation().matches(actual)) continue;
            return each.getResult();
        }
        return null;
    }

    private void addBehaviorListIfNecessary(ExpectedInvocation expected) {
        if (this.behaviorLists.isEmpty() || !this.lastBehaviorList().allowsExpectedInvocation(expected, this.checkOrder)) {
            this.behaviorLists.add(new UnorderedBehavior(this.checkOrder));
        }
    }

    private UnorderedBehavior lastBehaviorList() {
        return this.behaviorLists.get(this.behaviorLists.size() - 1);
    }

    @Override
    public final Result addActual(Invocation actual) {
        Result stubOrNice;
        int initialPosition = this.position.get();
        while (this.position.get() < this.behaviorLists.size()) {
            int index = this.position.get();
            Result result = this.behaviorLists.get(index).addActual(actual);
            if (result != null) {
                return result;
            }
            if (!this.behaviorLists.get(index).verify()) break;
            this.position.incrementAndGet();
        }
        if ((stubOrNice = this.getStubResult(actual)) == null && this.nice) {
            stubOrNice = Result.createReturnResult(RecordState.emptyReturnValueFor(actual.getMethod().getReturnType()));
        }
        int endPosition = this.position.get();
        this.position.set(initialPosition);
        if (stubOrNice != null) {
            actual.validateCaptures();
            actual.clearCaptures();
            return stubOrNice;
        }
        if (endPosition == this.behaviorLists.size()) {
            --endPosition;
        }
        StringBuilder errorMessage = new StringBuilder(70 * (endPosition - initialPosition + 1));
        errorMessage.append("\n  Unexpected method call ").append(actual.toString());
        ArrayList<ErrorMessage> messages = new ArrayList<ErrorMessage>();
        int matches = 0;
        for (int i = initialPosition; i <= endPosition; ++i) {
            List<ErrorMessage> thisListMessages = this.behaviorLists.get(i).getMessages(actual);
            messages.addAll(thisListMessages);
            for (ErrorMessage m : thisListMessages) {
                if (!m.isMatching()) continue;
                ++matches;
            }
        }
        if (matches > 1) {
            errorMessage.append(". Possible matches are marked with (+1)");
        }
        if (!messages.isEmpty()) {
            errorMessage.append(":");
            for (ErrorMessage m : messages) {
                m.appendTo(errorMessage, matches);
            }
        }
        this.unexpectedCalls.add(actual);
        throw new AssertionErrorWrapper(new AssertionError(errorMessage));
    }

    @Override
    public void verifyRecording() {
        boolean verified = true;
        for (UnorderedBehavior behaviorList : this.behaviorLists.subList(this.position.get(), this.behaviorLists.size())) {
            if (behaviorList.verify()) continue;
            verified = false;
            break;
        }
        if (verified) {
            return;
        }
        StringBuilder errorMessage = new StringBuilder(70 * (this.behaviorLists.size() - this.position.get() + 1));
        errorMessage.append("\n  Expectation failure on verify:");
        for (UnorderedBehavior behaviorList : this.behaviorLists.subList(this.position.get(), this.behaviorLists.size())) {
            for (ErrorMessage m : behaviorList.getMessages(null)) {
                m.appendTo(errorMessage, 0);
            }
        }
        throw new AssertionErrorWrapper(new AssertionError((Object)errorMessage.toString()));
    }

    @Override
    public void verifyUnexpectedCalls() {
        if (this.unexpectedCalls.isEmpty()) {
            return;
        }
        StringBuilder errorMessage = new StringBuilder(70 * this.unexpectedCalls.size());
        errorMessage.append("\n  Unexpected method calls:");
        for (Invocation invocation : this.unexpectedCalls) {
            errorMessage.append("\n    ");
            errorMessage.append(invocation.toString());
        }
        throw new AssertionErrorWrapper(new AssertionError((Object)errorMessage.toString()));
    }

    @Override
    public void verify() {
        AssertionErrorWrapper firstError = null;
        try {
            this.verifyRecording();
        }
        catch (AssertionErrorWrapper e) {
            firstError = e;
        }
        try {
            this.verifyUnexpectedCalls();
        }
        catch (AssertionErrorWrapper e) {
            if (firstError == null) {
                throw e;
            }
            throw new AssertionErrorWrapper(new AssertionError((Object)(((Throwable)((Object)firstError.getAssertionError())).getMessage() + ((Throwable)((Object)e.getAssertionError())).getMessage())));
        }
        if (firstError != null) {
            throw firstError;
        }
    }

    @Override
    public void checkOrder(boolean value) {
        this.checkOrder = value;
    }

    @Override
    public void makeThreadSafe(boolean isThreadSafe) {
        this.isThreadSafe = isThreadSafe;
    }

    @Override
    public void shouldBeUsedInOneThread(boolean shouldBeUsedInOneThread) {
        this.shouldBeUsedInOneThread = shouldBeUsedInOneThread;
    }

    @Override
    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    @Override
    public void checkThreadSafety() {
        if (!this.shouldBeUsedInOneThread) {
            return;
        }
        if (this.lastThread == null) {
            this.lastThread = Thread.currentThread();
        } else if (this.lastThread != Thread.currentThread()) {
            throw new AssertionErrorWrapper(new AssertionError((Object)("\n Mock isn't supposed to be called from multiple threads. Last: " + this.lastThread + " Current: " + Thread.currentThread())));
        }
    }
}

