/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.validation.internal.Tracing;

public class T1AValidator
extends AbstractValidator {
    public static String id() {
        return "org.eclipse.wst.common.tests.validation.T1A";
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        Tracing.log((String)("T1AValidator-01: is validating: " + resource.getName()));
        ValidationResult vr = new ValidationResult();
        this.clearTest(resource.getProject(), vr);
        return vr;
    }

    private void clearTest(IProject project, ValidationResult vr) {
        IResource resource = project.findMember("source/first.test2x");
        try {
            ValidationFramework.getDefault().clearMessages(resource, T1AValidator.id());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        String msg = Tracing.timestampIt((String)"Side effect validation from T1A");
        ValidatorMessage vm = ValidatorMessage.create((String)msg, (IResource)resource);
        vm.setAttribute("lineNumber", 1);
        vm.setAttribute("severity", 2);
        vr.add(vm);
        vr.setValidated(new IResource[]{resource});
    }

    public String getId() {
        return T1AValidator.id();
    }

    public String getName() {
        return "T1AValidator";
    }
}

