/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.set.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.set.ImmutableSet;

/**
 * This file was automatically generated from template file immutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface ImmutableByteSet extends ImmutableByteCollection, ByteSet
{
    ImmutableByteSet select(BytePredicate predicate);

    ImmutableByteSet reject(BytePredicate predicate);

    <V> ImmutableSet<V> collect(ByteToObjectFunction<? extends V> function);

    ImmutableByteSet newWith(byte element);

    ImmutableByteSet newWithout(byte element);

    ImmutableByteSet newWithAll(ByteIterable elements);

    ImmutableByteSet newWithoutAll(ByteIterable elements);
}
