/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl;

import org.eclipse.tracecompass.internal.lttng2.control.core.model.IBaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IFieldInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.EventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.KernelProviderComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.BaseEventPropertySource;
import org.eclipse.ui.views.properties.IPropertySource;

public class BaseEventComponent
extends TraceControlComponent {
    public static final String TRACE_EVENT_ICON_FILE_ENABLED = "icons/obj16/event_enabled.gif";
    private IBaseEventInfo fEventInfo;

    public BaseEventComponent(String name, ITraceControlComponent parent) {
        super(name, parent);
        this.setImage(TRACE_EVENT_ICON_FILE_ENABLED);
        this.fEventInfo = new EventInfo(name);
    }

    public void setEventInfo(IBaseEventInfo eventInfo) {
        this.fEventInfo = eventInfo;
    }

    public TraceEventType getEventType() {
        return this.fEventInfo.getEventType();
    }

    public void setEventType(TraceEventType type) {
        this.fEventInfo.setEventType(type);
    }

    public void setEventType(String typeName) {
        this.fEventInfo.setEventType(typeName);
    }

    public TraceLogLevel getLogLevel() {
        return this.fEventInfo.getLogLevel();
    }

    public void setLogLevel(TraceLogLevel level) {
        this.fEventInfo.setLogLevel(level);
    }

    public void setLogLevel(String levelName) {
        this.fEventInfo.setLogLevel(levelName);
    }

    public String getFieldString() {
        IFieldInfo[] fields = this.fEventInfo.getFields();
        if (fields != null && fields.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < fields.length) {
                buffer.append(fields[i].getName());
                buffer.append("=");
                buffer.append(fields[i].getFieldType());
                if (i != fields.length - 1) {
                    buffer.append(";");
                }
                ++i;
            }
            return buffer.toString();
        }
        return null;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySource.class) {
            return adapter.cast(new BaseEventPropertySource(this));
        }
        return null;
    }

    public TargetNodeComponent getTargetNode() {
        return (TargetNodeComponent)this.getParent().getParent();
    }

    public TraceDomainType getDomain() {
        return this.getParent() instanceof KernelProviderComponent ? TraceDomainType.KERNEL : TraceDomainType.UST;
    }
}

