/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.scattercharts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.extensions.marker.BoxPlotMarker;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesData;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.ScatterChart;

public class BoxPlotChart
extends ScatterChart {
    private Map<String, ILineSeries.PlotSymbolType> symbolTypes = new HashMap<String, ILineSeries.PlotSymbolType>();

    public BoxPlotChart() {
        this.initialize();
    }

    public BoxPlotChart(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        IPlotArea plotArea = this.getBaseChart().getPlotArea();
        BoxPlotMarker boxPlotMarker = new BoxPlotMarker(this.getBaseChart(), this);
        plotArea.addCustomPaintListener((ICustomPaintListener)boxPlotMarker);
    }

    @Override
    public void addSeriesData(List<IScatterSeriesData> scatterSeriesDataList) {
        this.setSymbolTypeToNone(scatterSeriesDataList);
        super.addSeriesData(scatterSeriesDataList);
    }

    private void setSymbolTypeToNone(List<IScatterSeriesData> scatterSeriesDataList) {
        for (IScatterSeriesData scatterSeriesData : scatterSeriesDataList) {
            IScatterSeriesSettings settings = scatterSeriesData.getSettings();
            this.symbolTypes.put(scatterSeriesData.getSeriesData().getId(), settings.getSymbolType());
            settings.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        }
    }

    public ILineSeries.PlotSymbolType getPlotSymbolType(String seriesId) {
        return this.symbolTypes.get(seriesId);
    }
}

