/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public class NM {
    private static Pattern undef_pattern = null;
    private static Pattern normal_pattern = null;
    protected List<String> undef_symbols;
    protected List<AddressNamePair> text_symbols;
    protected List<AddressNamePair> bss_symbols;
    protected List<AddressNamePair> data_symbols;
    private String[] envp;

    private void parseOutput(InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        if (undef_pattern == null) {
            undef_pattern = Pattern.compile("^\\s+U\\s+(\\S+)");
        }
        if (normal_pattern == null) {
            normal_pattern = Pattern.compile("^(\\S+)\\s+([AaTtBbDd])\\s+(\\S+)");
        }
        while ((line = reader.readLine()) != null) {
            Matcher undef_matcher = undef_pattern.matcher(line);
            Matcher normal_matcher = normal_pattern.matcher(line);
            try {
                if (undef_matcher.matches()) {
                    this.undef_symbols.add(undef_matcher.group(1));
                    continue;
                }
                if (!normal_matcher.matches()) continue;
                char type = normal_matcher.group(2).charAt(0);
                String name = normal_matcher.group(3);
                long address = Long.parseLong(normal_matcher.group(1), 16);
                AddressNamePair val = new AddressNamePair(name, address);
                switch (type) {
                    case 'T': 
                    case 't': {
                        this.text_symbols.add(val);
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        this.bss_symbols.add(val);
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        this.data_symbols.add(val);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public NM(String file, boolean dynamic_only) throws IOException {
        this("nm", file, dynamic_only);
    }

    public NM(String command, String file, boolean dynamic_only) throws IOException {
        String[] stringArray;
        if (dynamic_only) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "-C";
            stringArray = stringArray2;
            stringArray2[1] = "-D";
        } else {
            stringArray = null;
        }
        this(command, stringArray, file);
    }

    public NM(String command, String param, String file, String[] envp) throws IOException {
        this.envp = envp;
        String[] params = param == null || param.length() == 0 ? new String[]{} : param.split("\\s");
        this.init(command, params, file);
    }

    public NM(String command, String param, String file) throws IOException {
        this(command, param, file, null);
    }

    public NM(String command, String[] params, String file) throws IOException {
        this.init(command, params, file);
    }

    protected void init(String command, String[] params, String file) throws IOException {
        String[] args = null;
        if (params == null || params.length == 0) {
            args = new String[]{command, "-C", file};
        } else {
            args = new String[params.length + 2];
            args[0] = command;
            System.arraycopy(params, 0, args, 1, params.length);
            args[params.length + 1] = file;
        }
        this.undef_symbols = new ArrayList<String>();
        this.text_symbols = new ArrayList<AddressNamePair>();
        this.data_symbols = new ArrayList<AddressNamePair>();
        this.bss_symbols = new ArrayList<AddressNamePair>();
        Process process = ProcessFactory.getFactory().exec(args, this.envp);
        this.parseOutput(process.getInputStream());
        process.destroy();
    }

    public String[] getUndefSymbols() {
        return this.undef_symbols.toArray(new String[0]);
    }

    public AddressNamePair[] getTextSymbols() {
        return this.text_symbols.toArray(new AddressNamePair[0]);
    }

    public AddressNamePair[] getDataSymbols() {
        return this.data_symbols.toArray(new AddressNamePair[0]);
    }

    public AddressNamePair[] getBSSSymbols() {
        return this.bss_symbols.toArray(new AddressNamePair[0]);
    }

    public class AddressNamePair {
        public String name;
        public long address;

        public AddressNamePair(String n, long a) {
            this.name = n;
            this.address = a;
        }

        public String toString() {
            return this.name + "@" + Long.toHexString(this.address);
        }
    }
}

