/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.gdbtrace.ui.views.events;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tracecompass.internal.gdbtrace.core.event.GdbTraceEvent;
import org.eclipse.tracecompass.internal.gdbtrace.core.event.GdbTraceEventContent;
import org.eclipse.tracecompass.internal.gdbtrace.core.trace.GdbEventAspects;
import org.eclipse.tracecompass.internal.gdbtrace.core.trace.GdbTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ui.viewers.events.TmfEventsTable;

public class GdbEventsTable
extends TmfEventsTable {
    private GdbTrace fSelectedTrace = null;
    private long fSelectedFrame = 0L;

    public GdbEventsTable(Composite parent, int cacheSize) {
        super(parent, cacheSize, GdbEventAspects.getAspects());
        this.fTable.getColumns()[0].setAlignment(131072);
        this.fTable.getColumns()[1].setAlignment(131072);
        this.addSelectionChangedListener(e -> {
            Object data;
            TableItem selectedTableItem;
            TableItem[] selection = this.fTable.getSelection();
            if (selection.length > 0 && (selectedTableItem = selection[0]) != null && (data = selectedTableItem.getData()) instanceof GdbTraceEvent) {
                GdbTraceEvent event = (GdbTraceEvent)data;
                GdbTrace gdbTrace = (GdbTrace)event.getTrace();
                GdbTraceEventContent content = event.getContent();
                this.selectFrame(gdbTrace, content.getFrameNumber());
                return;
            }
            this.fSelectedTrace = null;
        });
    }

    public void setTrace(ITmfTrace trace, boolean disposeOnClose) {
        TmfExperiment experiment;
        List expTraces;
        super.setTrace(trace, disposeOnClose);
        if (trace instanceof GdbTrace) {
            this.fSelectedTrace = (GdbTrace)trace;
            this.fSelectedFrame = 0L;
        } else if (trace instanceof TmfExperiment && !(expTraces = (experiment = (TmfExperiment)trace).getTraces()).isEmpty()) {
            this.fSelectedTrace = (GdbTrace)expTraces.get(0);
            this.fSelectedFrame = 0L;
        }
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
    }

    private void selectFrame(final GdbTrace gdbTrace, final long frameNumber) {
        Job b = new Job("GDB Trace select frame"){

            protected IStatus run(IProgressMonitor monitor) {
                gdbTrace.selectFrame(frameNumber);
                GdbEventsTable.this.fSelectedTrace = gdbTrace;
                GdbEventsTable.this.fSelectedFrame = frameNumber;
                return Status.OK_STATUS;
            }
        };
        b.setSystem(true);
        b.schedule();
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        super.traceUpdated(signal);
        if (this.fSelectedTrace.getNbFrames() == this.fSelectedTrace.getNbEvents()) {
            this.selectFrame(this.fSelectedTrace, this.fSelectedFrame);
        }
    }
}

