/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.io;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.incubator.internal.kernel.core.Activator;
import org.eclipse.tracecompass.incubator.internal.kernel.core.io.LinuxSocketFamily;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class IoStateProvider
extends AbstractTmfStateProvider {
    public static final String ID = "org.eclipse.tracecompass.incubator.io.stateprovider";
    public static final String ATTRIBUTE_TID = "TID";
    public static final String ATTRIBUTE_RESOURCES = "RES";
    public static final String ATTRIBUTE_FDTBL = "FDTBL";
    public static final String ATTRIBUTE_READ = "READ";
    public static final String ATTRIBUTE_WRITE = "WRITE";
    public static final String ATTRIBUTE_CURRENT = "CURRENT";
    public static final String ATTRIBUTE_FD = "FD";
    public static final String ATTRIBUTE_OPERATION = "OPERATION";
    private static final Collection<String> OPEN_FROM_DISK = ImmutableList.of((Object)"open", (Object)"openat");
    private static final Collection<String> OPEN_FROM_NET = ImmutableList.of((Object)"socket", (Object)"accept", (Object)"accept4", (Object)"connect");
    private static final Collection<String> DUP_SYSCALLS = ImmutableList.of((Object)"fcntl", (Object)"dup", (Object)"dup2", (Object)"dup3");
    private static final Collection<String> SYNC_SYSCALLS = ImmutableList.of((Object)"sync", (Object)"sync_file_range", (Object)"fsync", (Object)"fdatasync");
    private static final Collection<String> READ_SYSCALLS = ImmutableList.of((Object)"read", (Object)"recvmsg", (Object)"recvfrom", (Object)"readv", (Object)"pread", (Object)"pread64", (Object)"preadv");
    private static final Collection<String> WRITE_SYSCALLS = ImmutableList.of((Object)"write", (Object)"sendmsg", (Object)"sendto", (Object)"writev", (Object)"pwrite", (Object)"pwrite64", (Object)"pwritev");
    private static final Collection<String> CLOSE_SYSCALL = ImmutableList.of((Object)"close");
    private static final Collection<String> READ_WRITE_SYSCALLS = ImmutableList.of((Object)"splice", (Object)"senfile64");
    private static final Collection<String> CLONE_SYSCALLS = ImmutableList.of((Object)"clone");
    private static final String FIELD_FILENAME = "filename";
    private static final String FIELD_PID = "pid";
    private static final String FIELD_OLDFD = "oldfd";
    private static final String FIELD_FILDES = "fildes";
    private static final String FIELD_DESCRIPTOR = "fd";
    private static final String FIELD_FDIN = "fd_in";
    private static final String FIELD_FDOUT = "fd_out";
    private static final String FIELD_LEN = "len";
    private static final String FIELD_CLONE_FLAGS = "clone_flags";
    private static final String FIELD_CMD = "cmd";
    private static final String FIELD_STATEDUMP_FILE_TABLE = "file_table_address";
    private static final long CLONE_FILES_FLAG = 1024L;
    private static final long FCNTL_CMD_DUP = 0L;
    private static final long FCNTL_CMD_DUP_CLOEXEC = 1030L;
    private static final String UNKNOWN_FILE = "<unknown>";
    private static final int VERSION = 1;
    private final Map<String, EventConsumer> fHandlers = new HashMap<String, EventConsumer>();
    private final IKernelAnalysisEventLayout fLayout;
    private final Map<Integer, @Nullable FdRequestWithPools> fToRead = new HashMap<Integer, FdRequestWithPools>();
    private final Map<Integer, @Nullable FdRequestWithPools> fToWrite = new HashMap<Integer, FdRequestWithPools>();
    private final Map<Integer, String> fOpening = new HashMap<Integer, String>();
    private final Map<Integer, Long> fClosing = new HashMap<Integer, Long>();
    private final Map<Integer, Long> fConnecting = new HashMap<Integer, Long>();
    private final Map<Integer, TmfAttributePool> fPools = new HashMap<Integer, TmfAttributePool>();
    private final Map<Integer, Boolean> fCloning = new HashMap<Integer, Boolean>();
    private final Map<Long, Integer> fFdTblAddresses = new HashMap<Long, Integer>();
    private AtomicInteger fFdCount = new AtomicInteger(0);

    public IoStateProvider(IKernelTrace trace) {
        super((ITmfTrace)trace, ID);
        String statedumpStateEvent;
        this.fLayout = trace.getKernelEventLayout();
        for (String syscall : OPEN_FROM_DISK) {
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + syscall, this::openBegin);
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + syscall, this::openEnd);
        }
        for (String syscall : OPEN_FROM_NET) {
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + syscall, this::netBegin);
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + syscall, this::netEnd);
        }
        for (String syscall : DUP_SYSCALLS) {
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + syscall, this::dupBegin);
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + syscall, this::dupEnd);
        }
        for (String syscall : SYNC_SYSCALLS) {
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + syscall, this::syncBegin);
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + syscall, this::syncEnd);
        }
        for (String syscall : READ_SYSCALLS) {
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + syscall, this::readBegin);
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + syscall, this::readEnd);
        }
        for (String syscall : WRITE_SYSCALLS) {
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + syscall, this::writeBegin);
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + syscall, this::writeEnd);
        }
        for (String syscall : READ_WRITE_SYSCALLS) {
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + syscall, this::readWriteBegin);
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + syscall, this::readWriteEnd);
        }
        for (String syscall : CLOSE_SYSCALL) {
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + syscall, this::closeBegin);
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + syscall, this::closeEnd);
        }
        for (String syscall : CLONE_SYSCALLS) {
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + syscall, this::cloneBegin);
            this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + syscall, this::cloneEnd);
        }
        String statedumpFileEvent = this.fLayout.eventStatedumpFileDescriptor();
        if (statedumpFileEvent != null) {
            this.addEventHandler(statedumpFileEvent, this::statedumpHandle);
        }
        if ((statedumpStateEvent = this.fLayout.eventStatedumpProcessState()) != null) {
            this.addEventHandler(statedumpStateEvent, this::statedumpProcessHandle);
        }
    }

    protected final void addEventHandler(String eventName, EventConsumer handler) {
        this.fHandlers.put(eventName, handler);
    }

    protected final void eventHandle(@NonNull ITmfEvent event) {
        EventConsumer eventHandler = this.fHandlers.get(event.getName());
        if (eventHandler == null) {
            return;
        }
        ITmfStateSystemBuilder ssb = this.getStateSystemBuilder();
        if (ssb == null) {
            return;
        }
        Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            return;
        }
        eventHandler.handleEvent(ssb, event, tid);
    }

    protected final IKernelAnalysisEventLayout getLayout() {
        return this.fLayout;
    }

    private final @Nullable Long isValidFileDescriptor(ITmfStateSystemBuilder ssb, long time, Integer tid, @Nullable Long fd) {
        if (fd == null) {
            return null;
        }
        int fdTblQuark = this.getFdTblQuarkFor(ssb, time, tid);
        int tidFileQuark = ssb.optQuarkRelative(fdTblQuark, new String[]{String.valueOf(fd)});
        if (tidFileQuark == -2) {
            return null;
        }
        return ssb.queryOngoing(tidFileQuark) != null ? fd : null;
    }

    private void openBegin(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        String filename = (String)event.getContent().getFieldValue(String.class, new String[]{FIELD_FILENAME});
        this.fOpening.put(tid, filename != null ? filename : UNKNOWN_FILE);
        if (filename != null) {
            int fileTidQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_RESOURCES, filename, String.valueOf(tid)});
            ssb.modifyAttribute(event.getTimestamp().toNanos(), (Object)0L, fileTidQuark);
        }
    }

    private void openEnd(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        String filename = this.fOpening.remove(tid);
        Long ret = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldSyscallRet()});
        if (ret == null) {
            return;
        }
        long time = event.getTimestamp().toNanos();
        if (ret >= 0L) {
            this.openFile(ssb, time, tid, ret, filename);
        } else if (filename != null) {
            int fileTidQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_RESOURCES, filename, String.valueOf(tid)});
            ssb.updateOngoingState((Object)ret, fileTidQuark);
            ssb.removeAttribute(time, fileTidQuark);
        }
    }

    private static String getV4Or6Address(ITmfEvent event) {
        Object v4addr = event.getContent().getFieldValue(Object.class, new String[]{"v4addr"});
        Object v6addr = event.getContent().getFieldValue(Object.class, new String[]{"v6addr"});
        Integer family = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"family"});
        String socketFamily = LinuxSocketFamily.getSocketFamily(family != null ? family : 0);
        String connectTo = UNKNOWN_FILE;
        if (v4addr instanceof long[] && v6addr instanceof long[]) {
            long[] addr4 = (long[])v4addr;
            long[] addr6 = (long[])v6addr;
            connectTo = Objects.requireNonNull(addr4.length != 0 ? IoStateProvider.longArrayToString(addr4, '.') : (addr6.length != 0 ? IoStateProvider.longArrayToString(addr6, ':') : UNKNOWN_FILE));
        }
        return String.valueOf(connectTo) + ':' + ' ' + socketFamily;
    }

    private static String longArrayToString(long[] array, char separator) {
        ArrayList<Long> list = new ArrayList<Long>();
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            list.add(l);
            ++n2;
        }
        return StringUtils.join(list, (char)separator);
    }

    private void netBegin(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        if (event.getName().contains("connect")) {
            Long fd = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_DESCRIPTOR});
            if (fd == null) {
                return;
            }
            this.fOpening.put(tid, IoStateProvider.getV4Or6Address(event));
            this.fConnecting.put(tid, fd);
        }
    }

    private void netEnd(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        Long ret = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldSyscallRet()});
        if (ret == null || ret < 0L) {
            return;
        }
        if (event.getName().contains("socket")) {
            this.openFile(ssb, event.getTimestamp().toNanos(), tid, ret, "Socket");
        }
        if (event.getName().contains("connect")) {
            Long fd = this.fConnecting.get(tid);
            String serverAddr = this.fOpening.get(tid);
            if (fd != null && serverAddr != null) {
                this.openFile(ssb, event.getTimestamp().toNanos(), tid, fd, serverAddr);
            }
        }
        if (event.getName().contains("accept")) {
            String serverAddr = IoStateProvider.getV4Or6Address(event);
            this.openFile(ssb, event.getTimestamp().toNanos(), tid, ret, serverAddr);
        }
    }

    private void dupBegin(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        Object fileObj;
        Long oldFd = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_OLDFD});
        if (oldFd == null) {
            oldFd = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_FILDES});
        }
        if (oldFd == null) {
            Long fd = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_DESCRIPTOR});
            Long cmd = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_CMD});
            if (fd != null && cmd != null) {
                cmd.longValue();
                if (0L == 1L || (cmd & 0x406L) == 1L) {
                    oldFd = fd;
                }
            }
        }
        if (oldFd == null) {
            return;
        }
        int fdTblQuark = this.getFdTblQuarkFor(ssb, event.getTimestamp().toNanos(), tid);
        int oldFdQuark = ssb.optQuarkRelative(fdTblQuark, new String[]{String.valueOf(oldFd)});
        String filename = UNKNOWN_FILE;
        if (oldFdQuark != -2 && (fileObj = ssb.queryOngoing(oldFdQuark)) instanceof String) {
            filename = (String)fileObj;
        }
        this.fOpening.put(tid, filename);
    }

    private void dupEnd(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        String filename = this.fOpening.remove(tid);
        Long newFd = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldSyscallRet()});
        if (newFd == null || newFd < 0L) {
            return;
        }
        if (event.getName().contains("fcntl") && filename == null) {
            return;
        }
        long time = event.getTimestamp().toNanos();
        this.closeFile(ssb, time, tid, newFd);
        this.openFile(ssb, time, tid, newFd, filename);
    }

    private void syncBegin(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
    }

    private void syncEnd(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
    }

    private void readBegin(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        Long fd = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_DESCRIPTOR});
        Long len = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_LEN});
        if (fd == null) {
            return;
        }
        this.startReadingFd(ssb, event.getTimestamp().toNanos(), tid, fd, len == null ? 0L : len);
    }

    private void readEnd(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        long time = event.getTimestamp().toNanos();
        Long count = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.getLayout().fieldSyscallRet()});
        this.readFromFd(ssb, time, tid, count == null ? 0L : count);
    }

    private void writeBegin(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        Long fd = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_DESCRIPTOR});
        Long len = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_LEN});
        if (fd == null) {
            return;
        }
        this.startWritingFd(ssb, event.getTimestamp().toNanos(), tid, fd, len == null ? 0L : len);
    }

    private void writeEnd(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        long time = event.getTimestamp().toNanos();
        Long count = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.getLayout().fieldSyscallRet()});
        this.writeToFd(ssb, time, tid, count == null ? 0L : count);
    }

    private void readWriteBegin(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        Long fdIn = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_FDIN});
        Long fdOut = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_FDOUT});
        if (fdIn == null || fdOut == null) {
            return;
        }
        this.startReadingFd(ssb, event.getTimestamp().toNanos(), tid, fdIn, 0L);
        this.startWritingFd(ssb, event.getTimestamp().toNanos(), tid, fdOut, 0L);
    }

    private void readWriteEnd(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        long time = event.getTimestamp().toNanos();
        Long count = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.getLayout().fieldSyscallRet()});
        this.readFromFd(ssb, time, tid, count == null ? 0L : count);
        this.writeToFd(ssb, time, tid, count == null ? 0L : count);
    }

    private void closeBegin(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        Long fd = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_DESCRIPTOR});
        fd = this.isValidFileDescriptor(ssb, event.getTimestamp().toNanos(), tid, fd);
        if (fd == null) {
            return;
        }
        this.fClosing.put(tid, fd);
    }

    private void closeEnd(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        try {
            Long ret = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.getLayout().fieldSyscallRet()});
            Long fd = this.fClosing.remove(tid);
            if (ret == null || fd == null || ret < 0L) {
                return;
            }
            this.closeFile(ssb, event.getTimestamp().toNanos(), tid, fd);
        }
        catch (StateValueTypeException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }

    private void cloneBegin(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        Long flags = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_CLONE_FLAGS});
        if (flags == null) {
            return;
        }
        this.fCloning.put(tid, (flags & 0x400L) != 0L);
    }

    private void cloneEnd(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        try {
            Long ret = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.getLayout().fieldSyscallRet()});
            Boolean cloneFiles = this.fCloning.remove(tid);
            if (ret == null || cloneFiles == null || ret <= 0L) {
                return;
            }
            long time = event.getTimestamp().toNanos();
            int parentFdTblQuark = this.getFdTblQuarkFor(ssb, time, tid);
            if (cloneFiles.booleanValue()) {
                String fdTblId = ssb.getAttributeName(parentFdTblQuark);
                try {
                    int fdTblNb = Integer.parseInt(fdTblId);
                    int tidFdTblQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TID, String.valueOf(ret), ATTRIBUTE_FDTBL});
                    ssb.modifyAttribute(time, (Object)fdTblNb, tidFdTblQuark);
                }
                catch (NumberFormatException numberFormatException) {}
                return;
            }
            int childFdTblQuark = this.getFdTblQuarkFor(ssb, time, ret.intValue());
            for (Integer fdQuark : ssb.getSubAttributes(parentFdTblQuark, false)) {
                Object currentFile = ssb.queryOngoing(fdQuark.intValue());
                if (currentFile == null) continue;
                int childFdQuark = ssb.getQuarkRelativeAndAdd(childFdTblQuark, new String[]{ssb.getAttributeName(fdQuark.intValue())});
                ssb.modifyAttribute(time, currentFile, childFdQuark);
            }
        }
        catch (StateValueTypeException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }

    private void statedumpHandle(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        Long pid = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_PID});
        Long fileTblAddress = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_STATEDUMP_FILE_TABLE});
        Long fd = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_DESCRIPTOR});
        String filename = (String)event.getContent().getFieldValue(String.class, new String[]{FIELD_FILENAME});
        if (pid == null && fileTblAddress == null || fd == null || filename == null) {
            return;
        }
        if (pid != null) {
            this.openFile(ssb, -1L, pid.intValue(), fd, filename);
            int fileTidQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_RESOURCES, filename, String.valueOf(tid)});
            ssb.updateOngoingState((Object)fd, fileTidQuark);
            return;
        }
        Integer tblAddressQuark = this.fFdTblAddresses.get(fileTblAddress);
        if (tblAddressQuark == null) {
            Activator.getInstance().logWarning("Statedump file descriptor has an address field which has not been declared. Make sure to enable the lttng_statedump_process_state event, or maybe there are lost events?");
            return;
        }
        int fdQuark = ssb.getQuarkRelativeAndAdd(tblAddressQuark.intValue(), new String[]{String.valueOf(fd)});
        ssb.updateOngoingState((Object)filename, fdQuark);
    }

    private void statedumpProcessHandle(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer tid) {
        Long fileTblAddress = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_STATEDUMP_FILE_TABLE});
        Long procTid = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.getLayout().fieldTid()});
        if (procTid == null || fileTblAddress == null) {
            return;
        }
        Integer fdTblQuark = this.fFdTblAddresses.get(fileTblAddress);
        if (fdTblQuark != null) {
            String fdTblId = ssb.getAttributeName(fdTblQuark.intValue());
            try {
                int fdTblInt = Integer.parseInt(fdTblId);
                int tidFdTblQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TID, String.valueOf(procTid), ATTRIBUTE_FDTBL});
                Object currentTblId = ssb.queryOngoing(tidFdTblQuark);
                if (currentTblId == null) {
                    ssb.updateOngoingState((Object)fdTblInt, tidFdTblQuark);
                } else {
                    ssb.modifyAttribute(event.getTimestamp().toNanos(), (Object)fdTblInt, tidFdTblQuark);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Activator.getInstance().logError("The file table ID is not an integer: " + fdTblId);
            }
            return;
        }
        int fdTblId = this.fFdCount.getAndIncrement();
        fdTblQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_FDTBL, String.valueOf(fdTblId)});
        this.fFdTblAddresses.put(fileTblAddress, fdTblQuark);
        int tidFdTblQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TID, String.valueOf(procTid), ATTRIBUTE_FDTBL});
        Object currentTblId = ssb.queryOngoing(tidFdTblQuark);
        if (currentTblId == null) {
            ssb.updateOngoingState((Object)fdTblId, tidFdTblQuark);
        } else {
            ssb.modifyAttribute(event.getTimestamp().toNanos(), (Object)fdTblId, tidFdTblQuark);
        }
    }

    private void closeFile(ITmfStateSystemBuilder ssb, long time, Integer tid, Long fd) {
        int fileTidQuark;
        int fdTblQuark = this.getFdTblQuarkFor(ssb, time, tid);
        String filename = IoStateProvider.getFilename(ssb, fd, fdTblQuark);
        int fdQuark = ssb.getQuarkRelativeAndAdd(fdTblQuark, new String[]{String.valueOf(fd)});
        ssb.removeAttribute(time, fdQuark);
        if (filename != null && (fileTidQuark = ssb.optQuarkAbsolute(new String[]{ATTRIBUTE_RESOURCES, filename, String.valueOf(tid)})) != -2) {
            ssb.removeAttribute(time, fileTidQuark);
        }
    }

    private void openFile(ITmfStateSystemBuilder ssb, long time, Integer tid, Long fd, @Nullable String filename) {
        int fdTblQuark = this.getFdTblQuarkFor(ssb, time, tid);
        int fdQuark = ssb.getQuarkRelativeAndAdd(fdTblQuark, new String[]{String.valueOf(fd)});
        if (time < 0L) {
            ssb.updateOngoingState((Object)filename, fdQuark);
        } else {
            ssb.modifyAttribute(time, (Object)(filename != null ? filename : UNKNOWN_FILE), fdQuark);
        }
        if (filename != null) {
            int fileTidQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_RESOURCES, filename, String.valueOf(tid)});
            ssb.updateOngoingState(null, fileTidQuark);
            ssb.modifyAttribute(time, (Object)fd, fileTidQuark);
        }
    }

    private int getFdTblQuarkFor(ITmfStateSystemBuilder ssb, long time, Integer tid) {
        int tidFdQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TID, String.valueOf(tid), ATTRIBUTE_FDTBL});
        Object fdTblQuarkObj = ssb.queryOngoing(tidFdQuark);
        if (fdTblQuarkObj instanceof Integer) {
            return ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_FDTBL, String.valueOf(fdTblQuarkObj)});
        }
        int fdTblNumber = this.fFdCount.getAndIncrement();
        int fdTblQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_FDTBL, String.valueOf(fdTblNumber)});
        ssb.modifyAttribute(time, (Object)fdTblNumber, tidFdQuark);
        return fdTblQuark;
    }

    private void startReadingFd(ITmfStateSystemBuilder ssb, long time, Integer tid, Long fd, Long count) {
        this.startRwFd(ssb, time, tid, fd, count, ATTRIBUTE_READ, this.fToRead);
    }

    private void startWritingFd(ITmfStateSystemBuilder ssb, long time, Integer tid, Long fd, Long count) {
        this.startRwFd(ssb, time, tid, fd, count, ATTRIBUTE_WRITE, this.fToWrite);
    }

    private void writeToFd(ITmfStateSystemBuilder ssb, long time, Integer tid, long count) {
        FdRequestWithPools fd = this.fToWrite.remove(tid);
        if (fd == null) {
            return;
        }
        this.rwFromFd(ssb, time, tid, fd, count, ATTRIBUTE_WRITE);
    }

    private void readFromFd(ITmfStateSystemBuilder ssb, long time, Integer tid, long count) {
        FdRequestWithPools fd = this.fToRead.remove(tid);
        if (fd == null) {
            return;
        }
        this.rwFromFd(ssb, time, tid, fd, count, ATTRIBUTE_READ);
    }

    private void rwFromFd(ITmfStateSystemBuilder ssb, long time, Integer tid, FdRequestWithPools fd, Long count, String attribute) {
        Long validFd = this.isValidFileDescriptor(ssb, time, tid, fd.fFd);
        ssb.updateOngoingState((Object)(count > 0L ? count : null), fd.fFdPoolQuark.intValue());
        fd.fFdPool.recycle(fd.fFdPoolQuark.intValue(), time);
        int currentTidQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TID, String.valueOf(tid), attribute});
        int currentDataQuark = ssb.getQuarkRelativeAndAdd(currentTidQuark, new String[]{ATTRIBUTE_CURRENT});
        ssb.updateOngoingState((Object)(count > 0L ? count : null), currentDataQuark);
        ssb.removeAttribute(time, currentDataQuark);
        int fdTblQuark = this.getFdTblQuarkFor(ssb, time, tid);
        String filename = IoStateProvider.getFilename(ssb, fd.fFd, fdTblQuark);
        if (filename != null) {
            int resQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_RESOURCES, filename, String.valueOf(tid), ATTRIBUTE_OPERATION});
            if (count <= 0L) {
                ssb.updateOngoingState(null, resQuark);
            } else {
                ssb.removeAttribute(time, resQuark);
            }
        }
        int currentFdQuark = ssb.getQuarkRelativeAndAdd(currentTidQuark, new String[]{ATTRIBUTE_FD});
        if (count <= 0L) {
            ssb.updateOngoingState(null, currentFdQuark);
            ssb.removeAttribute(time, currentFdQuark);
            return;
        }
        ssb.removeAttribute(time, currentFdQuark);
        if (validFd == null) {
            this.openFile(ssb, time, tid, fd.fFd, null);
        }
        try {
            int fdQuark = ssb.getQuarkRelativeAndAdd(fdTblQuark, new String[]{String.valueOf(fd.fFd), attribute});
            StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ssb, (long)time, (int)fdQuark, (long)count);
            StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ssb, (long)time, (int)currentTidQuark, (long)count);
        }
        catch (StateValueTypeException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }

    private void startRwFd(ITmfStateSystemBuilder ssb, long time, Integer tid, Long fd, Long count, String attribute, Map<Integer, @Nullable FdRequestWithPools> tidMap) {
        try {
            int fdTblQuark = this.getFdTblQuarkFor(ssb, time, tid);
            int fdQuark = ssb.getQuarkRelativeAndAdd(fdTblQuark, new String[]{String.valueOf(fd), attribute});
            TmfAttributePool fdPool = this.fPools.computeIfAbsent(fdQuark, q -> new TmfAttributePool(ssb, q));
            int availableFdQuark = fdPool.getAvailable();
            ssb.modifyAttribute(time, (Object)count, availableFdQuark);
            int currentTidQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TID, String.valueOf(tid), attribute});
            int currentDataQuark = ssb.getQuarkRelativeAndAdd(currentTidQuark, new String[]{ATTRIBUTE_CURRENT});
            ssb.modifyAttribute(time, (Object)count, currentDataQuark);
            int currentFdQuark = ssb.getQuarkRelativeAndAdd(currentTidQuark, new String[]{ATTRIBUTE_FD});
            ssb.modifyAttribute(time, (Object)fd, currentFdQuark);
            String filename = IoStateProvider.getFilename(ssb, fd, fdTblQuark);
            if (filename != null) {
                int resQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_RESOURCES, filename, String.valueOf(tid), ATTRIBUTE_OPERATION});
                ssb.modifyAttribute(time, (Object)attribute, resQuark);
            }
            tidMap.put(tid, new FdRequestWithPools(fd, fdPool, availableFdQuark));
        }
        catch (StateValueTypeException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }

    private static @Nullable String getFilename(ITmfStateSystemBuilder ssb, long fd, Integer fdTblQuark) {
        int fileQuark = ssb.getQuarkRelativeAndAdd(fdTblQuark.intValue(), new String[]{String.valueOf(fd)});
        Object currentFileName = ssb.queryOngoing(fileQuark);
        if (!(currentFileName instanceof String)) {
            return null;
        }
        String fileName = (String)currentFileName;
        return fileName.equals(UNKNOWN_FILE) ? null : fileName;
    }

    public int getVersion() {
        return 1;
    }

    public ITmfStateProvider getNewInstance() {
        return new IoStateProvider((IKernelTrace)this.getTrace());
    }

    @FunctionalInterface
    private static interface EventConsumer {
        public void handleEvent(ITmfStateSystemBuilder var1, ITmfEvent var2, Integer var3);
    }

    private static class FdRequestWithPools {
        private final Long fFd;
        private final Integer fFdPoolQuark;
        private final TmfAttributePool fFdPool;

        public FdRequestWithPools(Long fd, TmfAttributePool fdPool, Integer fdPoolQuark) {
            this.fFd = fd;
            this.fFdPool = fdPool;
            this.fFdPoolQuark = fdPoolQuark;
        }
    }
}

