/* The following code was generated by JFlex 1.6.1 */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.documentModel.parser.php53;

import org.eclipse.php.internal.core.util.collections.IntHashtable;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>highlighting_scanner.jflex</tt>
 */
public class PhpLexer extends org.eclipse.php.internal.core.documentModel.parser.AbstractPhpLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ST_PHP_IN_SCRIPTING = 2;
  public static final int ST_PHP_DOUBLE_QUOTES = 4;
  public static final int ST_PHP_SINGLE_QUOTE = 6;
  public static final int ST_PHP_BACKQUOTE = 8;
  public static final int ST_PHP_QUOTES_AFTER_VARIABLE = 10;
  public static final int ST_PHP_HEREDOC = 12;
  public static final int ST_PHP_NOWDOC = 14;
  public static final int ST_PHP_START_HEREDOC = 16;
  public static final int ST_PHP_START_NOWDOC = 18;
  public static final int ST_PHP_END_HEREDOC = 20;
  public static final int ST_PHP_LOOKING_FOR_PROPERTY = 22;
  public static final int ST_PHP_VAR_OFFSET = 24;
  public static final int ST_PHP_COMMENT = 26;
  public static final int ST_PHP_DOC_COMMENT = 28;
  public static final int ST_PHP_LINE_COMMENT = 30;
  public static final int ST_PHP_HIGHLIGHTING_ERROR = 32;
  public static final int ST_PHP_END_NOWDOC = 34;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 
    16, 16, 17, 17
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\11\2\0\1\15\22\0\1\12\1\26\1\17\1\74"+
    "\1\16\1\32\1\33\1\73\1\63\1\64\1\30\1\25\1\13\1\4"+
    "\1\2\1\31\1\5\11\1\1\61\1\14\1\27\1\23\1\24\1\75"+
    "\1\76\1\40\1\7\1\47\1\42\1\3\1\45\1\56\1\52\1\43"+
    "\1\65\1\55\1\54\1\60\1\41\1\36\1\57\1\67\1\37\1\50"+
    "\1\44\1\46\1\62\1\53\1\6\1\51\1\10\1\71\1\20\1\72"+
    "\1\35\1\66\1\21\1\40\1\7\1\47\1\42\1\3\1\45\1\56"+
    "\1\52\1\43\1\65\1\55\1\54\1\60\1\41\1\36\1\57\1\67"+
    "\1\37\1\50\1\44\1\46\1\62\1\53\1\6\1\51\1\10\1\22"+
    "\1\34\1\70\1\13\261\10\2\43\115\10\1\50\u1faa\10\1\55\uded5\10"+
    "\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\20\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\1\2\12\0\1\3\1\4\1\5\1\6"+
    "\1\5\1\4\3\6\1\7\1\5\1\10\1\5\1\11"+
    "\1\12\1\13\1\14\12\5\17\6\1\5\1\6\1\5"+
    "\1\6\1\15\1\16\1\17\1\5\1\2\1\20\1\21"+
    "\4\20\1\2\3\20\3\22\2\1\3\3\1\2\2\23"+
    "\2\24\2\3\1\0\1\3\1\25\1\26\1\25\1\27"+
    "\1\30\1\27\1\31\1\30\1\6\1\32\2\33\3\34"+
    "\3\35\3\36\1\37\1\40\1\0\1\3\2\4\1\41"+
    "\6\6\1\42\2\0\1\6\2\43\2\0\1\20\2\0"+
    "\2\41\1\44\1\45\1\41\4\6\1\46\4\6\1\47"+
    "\2\6\1\50\30\6\1\51\1\6\12\0\1\6\2\0"+
    "\1\52\3\0\1\53\2\54\1\55\1\56\1\54\4\0"+
    "\3\57\1\60\3\0\1\1\2\54\1\2\1\0\1\61"+
    "\2\0\1\62\6\0\1\63\4\0\1\64\1\4\1\53"+
    "\1\65\1\66\20\0\1\67\1\70\1\0\7\6\1\4"+
    "\1\0\1\6\1\43\1\0\1\71\4\6\1\72\4\6"+
    "\1\73\6\6\1\74\1\6\1\75\5\6\1\76\20\6"+
    "\1\77\12\0\7\6\1\100\1\101\1\1\1\102\1\2"+
    "\3\0\1\103\4\0\1\63\40\0\1\104\1\0\1\105"+
    "\6\6\1\106\1\107\1\6\1\110\1\6\1\43\3\0"+
    "\1\111\5\6\1\112\7\6\1\113\2\6\1\114\7\6"+
    "\1\115\2\6\1\116\3\6\1\117\1\120\6\6\12\0"+
    "\10\6\3\0\1\103\25\0\1\121\14\0\1\122\2\6"+
    "\1\123\4\6\1\124\1\125\1\126\2\127\2\0\3\6"+
    "\1\130\6\6\1\131\1\6\1\132\1\6\1\133\1\134"+
    "\1\6\1\135\1\6\1\136\1\137\1\140\1\141\2\6"+
    "\1\142\2\6\1\143\3\6\7\0\1\144\2\0\10\6"+
    "\7\0\1\145\1\146\3\0\1\147\4\0\1\150\5\0"+
    "\1\151\10\0\2\6\1\152\2\6\1\153\1\0\1\154"+
    "\14\6\1\155\1\156\1\157\2\6\1\160\1\161\4\0"+
    "\10\6\16\0\1\162\3\0\1\163\5\0\1\164\2\0"+
    "\1\165\1\0\1\166\4\6\1\167\2\6\1\170\1\171"+
    "\1\6\1\172\2\6\1\173\3\6\1\174\2\0\1\6"+
    "\1\175\6\6\3\0\1\176\1\0\1\177\1\200\3\0"+
    "\1\201\1\0\1\202\3\0\1\203\2\0\1\204\2\0"+
    "\1\205\1\0\3\6\1\206\1\6\1\207\5\6\1\210"+
    "\1\211\2\6\1\212\3\6\1\213\1\6\1\214\13\0"+
    "\1\215\1\0\1\216\1\217\2\6\1\220\1\6\1\221"+
    "\1\222\3\6\1\223\2\6\1\224\2\6\1\0\1\225"+
    "\2\0\1\226\1\227\2\0\1\230\2\0\1\231\1\232"+
    "\1\233\2\6\1\234\1\235\3\6\1\236\1\237\1\240"+
    "\2\0\1\241\1\242\1\0\5\6\1\243\1\244\1\245"+
    "\1\246\1\247\1\6\1\250\1\6\1\251\2\6\1\252";

  private static int [] zzUnpackAction() {
    int [] result = new int[811];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\77\0\176\0\275\0\374\0\u013b\0\u017a\0\u01b9"+
    "\0\u01f8\0\u0237\0\u0276\0\u02b5\0\u02f4\0\u0333\0\u0372\0\u03b1"+
    "\0\u03f0\0\u042f\0\0\0\u046e\0\u04ad\0\u04ec\0\u052b\0\u056a"+
    "\0\u05a9\0\u05e8\0\u0627\0\u0666\0\0\0\0\0\u06a5\0\u06e4"+
    "\0\0\0\0\0\0\0\u0723\0\u0762\0\u07a1\0\u07e0\0\u081f"+
    "\0\u085e\0\u089d\0\u08dc\0\u091b\0\u095a\0\u0999\0\u09d8\0\u0a17"+
    "\0\u0a56\0\u0a95\0\u0ad4\0\u0b13\0\u0b52\0\u0b91\0\u0bd0\0\u0c0f"+
    "\0\u0c4e\0\u0c8d\0\u0ccc\0\u0d0b\0\u0d4a\0\u0d89\0\u0dc8\0\u0e07"+
    "\0\0\0\u0e46\0\0\0\u0e85\0\u0ec4\0\u0f03\0\0\0\u0f42"+
    "\0\u0f81\0\u0fc0\0\u0fff\0\u103e\0\u107d\0\u10bc\0\u10fb\0\0"+
    "\0\u113a\0\u1179\0\u11b8\0\u11f7\0\u1236\0\u1275\0\u12b4\0\u12f3"+
    "\0\0\0\u1332\0\0\0\u1371\0\u13b0\0\u13ef\0\u142e\0\u142e"+
    "\0\0\0\u146d\0\u14ac\0\u14eb\0\0\0\u152a\0\0\0\u1569"+
    "\0\u15a8\0\0\0\u15e7\0\u1626\0\0\0\u1665\0\u16a4\0\u16e3"+
    "\0\0\0\u1722\0\0\0\u1761\0\u0e85\0\0\0\u17a0\0\u17df"+
    "\0\u181e\0\u185d\0\u189c\0\0\0\u18db\0\u191a\0\u1959\0\u1998"+
    "\0\u19d7\0\u1a16\0\0\0\u1a55\0\u1a94\0\u1ad3\0\u1b12\0\u1b51"+
    "\0\u06e4\0\u1b90\0\0\0\u1bcf\0\u1c0e\0\u085e\0\u1c4d\0\u1c8c"+
    "\0\u1ccb\0\u0627\0\u1d0a\0\u1d49\0\u1d88\0\u1dc7\0\u0627\0\u1e06"+
    "\0\u1e45\0\u1e84\0\u1ec3\0\u0627\0\u1f02\0\u1f41\0\u0627\0\u1f80"+
    "\0\u1fbf\0\u1ffe\0\u203d\0\u207c\0\u20bb\0\u20fa\0\u2139\0\u2178"+
    "\0\u21b7\0\u21f6\0\u2235\0\u2274\0\u22b3\0\u22f2\0\u2331\0\u2370"+
    "\0\u23af\0\u23ee\0\u242d\0\u246c\0\u24ab\0\u24ea\0\u2529\0\0"+
    "\0\u2568\0\u25a7\0\u0dc8\0\u25e6\0\u2625\0\u2664\0\u26a3\0\u26e2"+
    "\0\u2721\0\u2760\0\u279f\0\u27de\0\u0e46\0\u281d\0\u285c\0\u289b"+
    "\0\u0f42\0\u28da\0\u2919\0\u289b\0\0\0\0\0\0\0\u28da"+
    "\0\u2958\0\u2997\0\u10bc\0\u29d6\0\u2997\0\0\0\u29d6\0\0"+
    "\0\u2a15\0\u1275\0\u2a54\0\u2a93\0\u2a15\0\u2a54\0\u2ad2\0\u1332"+
    "\0\0\0\u2b11\0\u1371\0\0\0\u2b50\0\u2b8f\0\u2bce\0\u2c0d"+
    "\0\u2c4c\0\u2c8b\0\0\0\u2cca\0\u2d09\0\u2d48\0\u13b0\0\0"+
    "\0\u2d87\0\u2dc6\0\0\0\0\0\u2e05\0\u2e44\0\u2e83\0\u2ec2"+
    "\0\u2f01\0\u2f40\0\u2f7f\0\u2fbe\0\u2ffd\0\u303c\0\u307b\0\u30ba"+
    "\0\u30f9\0\u3138\0\u3177\0\u31b6\0\0\0\u31f5\0\u3234\0\u3273"+
    "\0\u32b2\0\u32f1\0\u3330\0\u336f\0\u33ae\0\u33ed\0\u1a55\0\u342c"+
    "\0\u346b\0\u34aa\0\u34e9\0\u3528\0\u3567\0\u35a6\0\u35e5\0\u3624"+
    "\0\u0627\0\u3663\0\u36a2\0\u36e1\0\u3720\0\u0627\0\u375f\0\u379e"+
    "\0\u37dd\0\u381c\0\u385b\0\u389a\0\u0627\0\u38d9\0\u3918\0\u3957"+
    "\0\u3996\0\u39d5\0\u3a14\0\u3a53\0\u0627\0\u3a92\0\u3ad1\0\u3b10"+
    "\0\u3b4f\0\u3b8e\0\u3bcd\0\u3c0c\0\u3c4b\0\u3c8a\0\u3cc9\0\u3d08"+
    "\0\u3d47\0\u3d86\0\u3dc5\0\u3e04\0\u3e43\0\u0627\0\u3e82\0\u3ec1"+
    "\0\u3f00\0\u3f3f\0\u3f7e\0\u3fbd\0\u3ffc\0\u403b\0\u407a\0\u40b9"+
    "\0\u40f8\0\u4137\0\u4176\0\u41b5\0\u41f4\0\u4233\0\u4272\0\0"+
    "\0\0\0\u42b1\0\0\0\u42f0\0\u432f\0\u436e\0\u43ad\0\u436e"+
    "\0\u43ec\0\u442b\0\u446a\0\u13ef\0\u436e\0\u44a9\0\u44e8\0\u4527"+
    "\0\u4566\0\u45a5\0\u45e4\0\u4623\0\u4662\0\u46a1\0\u46e0\0\u471f"+
    "\0\u475e\0\u479d\0\u47dc\0\u481b\0\u485a\0\u4899\0\u48d8\0\u4917"+
    "\0\u4956\0\u4995\0\u49d4\0\u4a13\0\u4a52\0\u4a91\0\u4ad0\0\u4b0f"+
    "\0\u4b4e\0\u4b8d\0\u4bcc\0\u4c0b\0\u4c4a\0\0\0\u4c89\0\u0627"+
    "\0\u4cc8\0\u4d07\0\u4d46\0\u4d85\0\u4dc4\0\u4e03\0\u0627\0\u4e42"+
    "\0\u4e81\0\u0627\0\u4ec0\0\u4eff\0\u4f3e\0\u4f7d\0\u4fbc\0\0"+
    "\0\u4ffb\0\u503a\0\u5079\0\u50b8\0\u50f7\0\u0627\0\u5136\0\u5175"+
    "\0\u51b4\0\u51f3\0\u5232\0\u5271\0\u52b0\0\u0627\0\u52ef\0\u532e"+
    "\0\u0627\0\u536d\0\u53ac\0\u53eb\0\u542a\0\u5469\0\u54a8\0\u54e7"+
    "\0\u0627\0\u5526\0\u5565\0\u0627\0\u55a4\0\u55e3\0\u5622\0\u0627"+
    "\0\u0627\0\u5661\0\u56a0\0\u56df\0\u571e\0\u575d\0\u579c\0\u57db"+
    "\0\u581a\0\u5859\0\u5898\0\u58d7\0\u5916\0\u5955\0\u5994\0\u59d3"+
    "\0\u5a12\0\u5a51\0\u5a90\0\u5acf\0\u5b0e\0\u5b4d\0\u5b8c\0\u5bcb"+
    "\0\u5c0a\0\u5c49\0\u5c88\0\u5cc7\0\0\0\u5d06\0\u5d45\0\u5d84"+
    "\0\u5dc3\0\u5e02\0\u5e41\0\u5e80\0\u5ebf\0\u5efe\0\u5f3d\0\u5f7c"+
    "\0\u5fbb\0\u5ffa\0\u6039\0\u6078\0\u60b7\0\u60f6\0\u6135\0\u6174"+
    "\0\u61b3\0\u61f2\0\0\0\u6231\0\u6270\0\u62af\0\u62ee\0\u632d"+
    "\0\u636c\0\u63ab\0\u63ea\0\u6429\0\u6468\0\u64a7\0\u64e6\0\0"+
    "\0\u6525\0\u6564\0\u0627\0\u65a3\0\u65e2\0\u6621\0\u6660\0\u0627"+
    "\0\u0627\0\u1b12\0\0\0\u669f\0\u66de\0\u671d\0\u675c\0\u679b"+
    "\0\u67da\0\u0627\0\u6819\0\u6858\0\u6897\0\u68d6\0\u6915\0\u6954"+
    "\0\u0627\0\u6993\0\u0627\0\u69d2\0\u0627\0\u0627\0\u6a11\0\u0627"+
    "\0\u6a50\0\u0627\0\u0627\0\u0627\0\u0627\0\u6a8f\0\u6ace\0\u0627"+
    "\0\u6b0d\0\u6b4c\0\u0627\0\u6b8b\0\u6bca\0\u6c09\0\u6c48\0\u6c87"+
    "\0\u6cc6\0\u6d05\0\u6d44\0\u6d83\0\u6dc2\0\0\0\u6e01\0\u6e40"+
    "\0\u6e7f\0\u6ebe\0\u6efd\0\u6f3c\0\u6f7b\0\u6fba\0\u6ff9\0\u7038"+
    "\0\u7077\0\u70b6\0\u70f5\0\u7134\0\u7173\0\u71b2\0\u71f1\0\u7230"+
    "\0\0\0\u726f\0\u72ae\0\u72ed\0\0\0\u732c\0\u736b\0\u73aa"+
    "\0\u73e9\0\0\0\u7428\0\u7467\0\u74a6\0\u74e5\0\u7524\0\0"+
    "\0\u7563\0\u75a2\0\u75e1\0\u7620\0\u765f\0\u769e\0\u76dd\0\u771c"+
    "\0\u775b\0\u779a\0\u77d9\0\u7818\0\u7857\0\u0627\0\u7896\0\u0627"+
    "\0\u78d5\0\u7914\0\u7953\0\u7992\0\u79d1\0\u7a10\0\u7a4f\0\u7a8e"+
    "\0\u7acd\0\u7b0c\0\u7b4b\0\u7b8a\0\u0627\0\u0627\0\u0627\0\u7bc9"+
    "\0\u7c08\0\u0627\0\u0627\0\u7c47\0\u7c86\0\u7cc5\0\u7d04\0\u7d43"+
    "\0\u7d82\0\u7dc1\0\u7e00\0\u7e3f\0\u7e7e\0\u7ebd\0\u7efc\0\u7f3b"+
    "\0\u7f7a\0\u7fb9\0\u7ff8\0\u8037\0\u8076\0\u80b5\0\u80f4\0\u8133"+
    "\0\u8172\0\u81b1\0\u81f0\0\u822f\0\u826e\0\0\0\u82ad\0\u82ec"+
    "\0\u832b\0\0\0\u836a\0\u83a9\0\u83e8\0\u8427\0\u8466\0\0"+
    "\0\u84a5\0\u84e4\0\0\0\u8523\0\u0627\0\u8562\0\u85a1\0\u85e0"+
    "\0\u861f\0\u865e\0\u869d\0\u86dc\0\u0627\0\u0627\0\u871b\0\u875a"+
    "\0\u8799\0\u87d8\0\u0627\0\u8817\0\u8856\0\u8895\0\u0627\0\u88d4"+
    "\0\u8913\0\u8952\0\u0627\0\u8991\0\u89d0\0\u8a0f\0\u8a4e\0\u8a8d"+
    "\0\u8acc\0\u8b0b\0\u8b4a\0\u8b89\0\0\0\u8bc8\0\0\0\0"+
    "\0\u8c07\0\u8c46\0\u8c85\0\0\0\u8cc4\0\0\0\u8d03\0\u8d42"+
    "\0\u8d81\0\u8dc0\0\u8dff\0\u8e3e\0\0\0\u8e7d\0\u8ebc\0\0"+
    "\0\u8efb\0\u8f3a\0\u8f79\0\u8fb8\0\u0627\0\u8ff7\0\u0627\0\u9036"+
    "\0\u9075\0\u90b4\0\u90f3\0\u9132\0\u0627\0\u0627\0\u9171\0\u91b0"+
    "\0\u0627\0\u91ef\0\u922e\0\u926d\0\u0627\0\u92ac\0\0\0\u92eb"+
    "\0\u932a\0\u9369\0\u93a8\0\u93e7\0\u9426\0\u9465\0\u94a4\0\u94e3"+
    "\0\u9522\0\u9561\0\0\0\u95a0\0\0\0\0\0\u95df\0\u961e"+
    "\0\u0627\0\u965d\0\u0627\0\u0627\0\u969c\0\u96db\0\u971a\0\u0627"+
    "\0\u9759\0\u9798\0\u0627\0\u97d7\0\u9816\0\u9855\0\0\0\u9894"+
    "\0\u98d3\0\0\0\0\0\u9912\0\u9951\0\0\0\u9990\0\u99cf"+
    "\0\0\0\u0627\0\u0627\0\u9a0e\0\u9a4d\0\u0627\0\u0627\0\u9a8c"+
    "\0\u9acb\0\u9b0a\0\u0627\0\0\0\0\0\u9b49\0\u9b88\0\0"+
    "\0\0\0\u9bc7\0\u9c06\0\u9c45\0\u9c84\0\u9cc3\0\u9d02\0\0"+
    "\0\0\0\0\0\u0627\0\u0627\0\u9d41\0\u0627\0\u9d80\0\u0627"+
    "\0\u9dbf\0\u9dfe\0\u0627";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[811];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\77\0\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\2\34\1\35\1\36\1\34\1\37\1\40"+
    "\1\41\1\42\1\43\1\44\1\45\1\46\1\47\1\50"+
    "\1\51\1\52\1\53\1\54\1\55\1\51\1\56\1\57"+
    "\1\60\1\61\1\62\1\63\1\64\1\65\1\66\1\67"+
    "\1\70\2\33\1\71\1\72\1\33\1\73\1\74\1\33"+
    "\1\75\1\76\1\77\1\35\1\33\1\100\1\33\1\101"+
    "\2\35\1\102\1\103\1\104\1\35\16\105\1\106\1\107"+
    "\1\110\1\105\1\111\54\105\20\112\1\113\52\112\1\107"+
    "\3\112\16\114\1\115\1\114\1\116\1\107\1\117\54\114"+
    "\4\120\1\121\15\120\1\122\54\120\11\123\1\124\3\123"+
    "\1\124\1\125\1\123\1\126\1\123\1\127\54\123\11\10"+
    "\1\130\3\10\1\130\61\10\3\131\1\132\2\131\3\132"+
    "\25\131\23\132\1\131\1\132\2\131\3\132\7\131\3\133"+
    "\1\134\2\133\3\134\25\133\23\134\1\133\1\134\2\133"+
    "\3\134\7\133\3\135\1\136\2\135\3\136\1\137\3\135"+
    "\1\140\20\135\23\136\1\135\1\136\2\135\3\136\7\135"+
    "\3\141\1\142\1\143\1\141\3\142\2\34\2\141\1\34"+
    "\20\141\23\142\1\141\1\142\2\141\3\142\7\141\1\23"+
    "\1\144\1\145\1\33\1\145\1\146\3\33\2\147\2\145"+
    "\1\147\1\150\1\145\1\147\15\145\3\33\1\151\17\33"+
    "\1\145\1\33\2\145\3\33\1\145\1\35\1\152\2\147"+
    "\2\145\30\153\1\154\46\153\30\155\1\156\45\155\1\157"+
    "\11\160\1\161\3\160\1\162\6\160\1\163\5\160\1\164"+
    "\42\160\1\165\1\160\11\166\2\167\2\166\1\167\61\166"+
    "\11\23\1\170\3\23\1\171\61\23\1\0\1\24\1\172"+
    "\1\173\1\0\1\24\72\0\1\172\3\0\1\172\15\0"+
    "\1\174\54\0\1\33\1\0\1\33\1\0\1\33\1\175"+
    "\2\33\25\0\3\33\1\176\5\33\1\177\4\33\1\200"+
    "\3\33\1\201\1\0\1\202\2\0\3\33\13\0\1\174"+
    "\16\0\1\174\1\203\53\0\1\24\1\172\1\173\1\0"+
    "\1\24\1\204\71\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\1\56\22\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\6\0\1\40\7\0"+
    "\1\205\6\0\1\33\1\206\21\33\1\0\1\33\2\0"+
    "\3\33\3\0\1\102\4\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\23\33\1\0\1\33\2\0\3\33\20\0"+
    "\2\34\2\0\1\34\64\0\1\207\2\0\3\207\25\0"+
    "\6\207\1\210\14\207\1\0\1\207\2\0\3\207\7\0"+
    "\16\211\1\212\1\213\1\214\1\211\1\215\54\211\23\0"+
    "\1\216\1\174\75\0\1\174\1\216\75\0\1\174\1\0"+
    "\1\174\74\0\1\216\76\0\2\174\2\0\1\217\72\0"+
    "\1\174\76\0\1\174\4\0\1\220\1\103\70\0\1\174"+
    "\1\221\75\0\1\174\7\0\1\174\66\0\1\174\10\0"+
    "\1\174\43\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\1\33\1\222\21\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\223\1\0\4\33\25\0\23\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\2\33\1\224\1\33\25\0\1\33\1\225\1\33\1\226"+
    "\6\33\1\227\10\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\230\1\0\4\33\25\0\2\33\1\231"+
    "\5\33\1\232\12\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\233\1\0\4\33\25\0\1\234\4\33"+
    "\1\235\15\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\3\33\1\236\3\33"+
    "\1\237\2\33\1\240\7\33\1\241\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\1\33\1\242\12\33\1\243\6\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\1\244\1\245\1\246\2\33\1\247\2\33\1\250\12\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\3\33\1\251\6\33\1\252\10\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\1\253\1\33\1\254\13\33\1\255"+
    "\4\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\256\1\0\4\33\25\0\6\33\1\257\6\33\1\260"+
    "\5\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\14\33\1\261\6\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\5\33\1\262\15\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\1\263\15\33\1\264\4\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\1\33"+
    "\1\265\1\266\5\33\1\267\12\33\1\0\1\33\2\0"+
    "\3\33\70\0\1\270\16\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\2\33\1\271\20\33\1\0\1\33\2\0"+
    "\3\33\16\0\1\272\2\0\1\273\23\0\1\274\1\275"+
    "\1\276\1\0\1\277\1\300\1\0\1\301\1\302\1\0"+
    "\1\303\27\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\23\33\1\0\1\33\2\0\1\33\1\304\1\33\7\0"+
    "\20\305\1\306\52\305\1\213\3\305\24\0\1\307\52\0"+
    "\16\105\1\310\1\0\1\311\1\105\1\312\57\105\1\313"+
    "\2\105\3\313\5\105\1\314\1\315\1\311\1\105\1\316"+
    "\13\105\23\313\1\105\1\313\2\105\3\313\124\105\1\317"+
    "\1\315\1\311\1\105\1\320\54\105\20\112\1\321\52\112"+
    "\1\0\23\112\1\213\52\112\1\213\3\112\16\114\1\322"+
    "\1\114\1\323\1\0\1\324\57\114\1\313\2\114\3\313"+
    "\5\114\1\325\1\114\1\323\1\326\1\316\13\114\23\313"+
    "\1\114\1\313\2\114\3\313\124\114\1\317\1\114\1\323"+
    "\1\326\1\327\54\114\24\0\1\330\70\0\1\317\60\0"+
    "\11\123\1\124\3\123\1\124\1\331\1\123\1\332\1\123"+
    "\1\333\57\123\1\334\2\123\3\334\1\124\3\123\1\124"+
    "\1\331\1\123\1\332\1\123\1\333\13\123\23\334\1\123"+
    "\1\334\2\123\3\334\12\123\1\313\2\123\3\313\1\124"+
    "\3\123\1\124\1\335\1\123\1\332\1\123\1\316\13\123"+
    "\23\313\1\123\1\313\2\123\3\313\20\123\1\124\3\123"+
    "\1\124\72\123\1\124\3\123\1\124\1\317\1\123\1\332"+
    "\1\123\1\336\54\123\3\10\1\337\2\10\3\337\1\130"+
    "\3\10\1\130\20\10\23\337\1\10\1\337\2\10\3\337"+
    "\7\10\1\0\1\340\1\0\1\340\1\0\4\340\1\341"+
    "\2\0\1\342\1\341\20\0\23\340\1\0\1\340\2\0"+
    "\3\340\10\0\1\343\1\0\1\343\1\0\4\343\1\344"+
    "\2\0\1\345\1\344\20\0\23\343\1\0\1\343\2\0"+
    "\3\343\7\0\3\346\1\347\2\346\3\347\1\0\2\346"+
    "\1\350\1\0\20\346\23\347\1\346\1\347\2\346\3\347"+
    "\7\346\1\351\1\352\1\351\1\352\1\351\4\352\1\353"+
    "\2\351\1\354\1\353\20\351\23\352\1\351\1\352\2\351"+
    "\3\352\7\351\3\355\1\356\2\355\3\356\1\137\2\355"+
    "\1\357\1\137\20\355\23\356\1\355\1\356\2\355\3\356"+
    "\7\355\1\0\1\142\1\0\1\142\1\0\4\142\25\0"+
    "\23\142\1\0\1\142\2\0\3\142\33\0\1\360\53\0"+
    "\1\144\3\0\1\144\72\0\1\361\3\0\1\361\1\204"+
    "\73\0\1\362\2\0\3\362\25\0\23\362\1\0\1\362"+
    "\2\0\3\362\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\10\33\1\232\12\33\1\0\1\33\2\0\3\33"+
    "\7\0\30\153\1\0\46\153\31\0\1\363\76\0\1\364"+
    "\50\0\1\365\33\0\1\366\1\367\1\370\1\371\1\372"+
    "\1\373\1\374\1\375\1\376\1\377\3\0\1\u0100\1\0"+
    "\1\u0101\1\u0102\1\u0103\1\0\1\u0104\14\0\11\160\1\161"+
    "\3\160\1\161\6\160\1\161\5\160\1\161\42\160\1\161"+
    "\1\160\11\0\1\u0105\111\0\1\u0106\63\0\2\167\2\0"+
    "\1\167\64\0\1\u0107\2\0\3\u0107\25\0\23\u0107\1\0"+
    "\1\u0107\2\0\3\u0107\12\0\1\u0107\2\0\3\u0107\1\170"+
    "\24\0\23\u0107\1\0\1\u0107\2\0\3\u0107\10\0\1\172"+
    "\1\0\1\173\1\0\1\172\72\0\1\361\2\0\2\361"+
    "\17\0\1\361\52\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\5\33\1\u0108\1\u0109\14\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\4\33\1\u010a\16\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\14\33\1\u010b"+
    "\6\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\12\33\1\u010c\10\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\21\33\1\u010d\1\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\2\33\1\u010e\20\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\u010f\1\0\1\u010f\1\0\1\u010f\1\0\1\u010f\30\0"+
    "\1\u010f\1\0\1\u010f\2\0\1\u010f\1\0\1\u010f\56\0"+
    "\1\u0110\50\0\1\33\1\0\1\u0111\1\0\4\33\25\0"+
    "\23\33\1\0\1\33\2\0\3\33\10\0\1\207\1\0"+
    "\1\207\1\0\4\207\25\0\23\207\1\0\1\207\2\0"+
    "\3\207\10\0\1\207\1\0\1\207\1\0\4\207\25\0"+
    "\14\207\1\u0112\6\207\1\0\1\207\2\0\3\207\7\0"+
    "\3\211\1\0\2\211\3\0\5\211\1\212\1\213\1\214"+
    "\1\211\1\0\13\211\23\0\1\211\1\0\2\211\3\0"+
    "\124\211\1\0\1\213\1\214\1\211\1\215\54\211\23\0"+
    "\1\174\3\0\1\u0113\77\0\1\u0114\57\0\2\221\2\0"+
    "\1\221\62\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\6\33\1\u0115\14\33\1\0\1\33\2\0\2\33\1\u0116"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\12\33"+
    "\1\u0117\10\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\1\33\1\u0118\21\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\4\33\1\222\16\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\15\33\1\u0119\5\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\22\33"+
    "\1\u011a\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\16\33\1\u011b\4\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\7\33\1\u011c\1\33\1\u011d\11\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\u011e\1\0"+
    "\4\33\25\0\23\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\6\33\1\u011f"+
    "\2\33\1\u0120\1\u0121\10\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\12\33"+
    "\1\u0122\10\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\21\33\1\u0123\1\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\10\33\1\u0124\2\33\1\u0125\7\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\1\33\1\u0126\21\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\1\33\1\u0127\21\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\1\u0128"+
    "\22\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\16\33\1\u0129\4\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\3\33\1\u012a\17\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\3\33\1\u012b\17\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\12\33\1\u012c"+
    "\10\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\u012d\1\0\4\33\25\0\23\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\3\33\1\u012e\17\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\6\33\1\u012f"+
    "\3\33\1\u0130\10\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\1\u0131\1\33"+
    "\1\u0132\20\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\16\33\1\u0133\4\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\2\33\1\u0134\20\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\5\33\1\u0135\15\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\5\33"+
    "\1\u0136\15\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\12\33\1\u0137\10\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\6\33\1\u0138\14\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\1\u0139\22\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\1\u013a\4\33"+
    "\1\u013b\15\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\1\33\1\u013c\21\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\2\33\1\u013d\1\33\25\0\23\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\1\33\1\u013e\21\33\1\0\1\33\2\0\3\33"+
    "\45\0\1\u013f\4\0\1\u0140\42\0\1\u0141\72\0\1\u0142"+
    "\132\0\1\u0143\75\0\1\u0144\101\0\1\u0145\111\0\1\u0146"+
    "\63\0\1\u0147\101\0\1\u0148\33\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\3\33\1\u0149\1\u014a\2\33\1\u014b"+
    "\1\33\1\u014c\2\33\1\u014d\1\33\1\u014e\3\33\1\u014f"+
    "\1\0\1\33\2\0\3\33\7\0\77\305\11\0\2\307"+
    "\2\0\1\307\61\0\3\105\1\0\2\105\3\0\5\105"+
    "\1\314\1\315\1\311\1\105\1\0\13\105\23\0\1\105"+
    "\1\0\2\105\3\0\25\105\1\0\1\315\1\311\1\105"+
    "\1\320\54\105\1\0\1\313\1\0\1\313\1\0\4\313"+
    "\25\0\23\313\1\0\1\313\2\0\3\313\1\0\1\u0150"+
    "\5\0\20\112\1\0\52\112\1\0\3\112\3\114\1\0"+
    "\2\114\3\0\5\114\1\325\1\114\1\323\1\326\1\0"+
    "\13\114\23\0\1\114\1\0\2\114\3\0\25\114\1\0"+
    "\1\114\1\323\1\326\1\327\54\114\3\123\1\0\2\123"+
    "\3\0\1\124\3\123\1\124\1\335\1\123\1\332\1\123"+
    "\1\0\13\123\23\0\1\123\1\0\2\123\3\0\20\123"+
    "\1\124\3\123\1\124\1\0\1\123\1\332\1\123\1\336"+
    "\55\123\1\334\1\123\1\334\1\123\4\334\1\u0151\2\123"+
    "\1\u0152\1\u0151\1\331\1\123\1\332\1\123\1\333\13\123"+
    "\23\334\1\123\1\334\2\123\3\334\7\123\1\10\1\337"+
    "\1\10\1\337\1\10\4\337\1\u0153\2\10\1\u0154\1\u0153"+
    "\20\10\23\337\1\10\1\337\2\10\3\337\7\10\11\0"+
    "\1\341\3\0\1\341\72\0\1\344\3\0\1\344\61\0"+
    "\3\357\1\u0155\2\357\3\u0155\1\u0156\3\357\1\u0156\20\357"+
    "\23\u0155\1\357\1\u0155\2\357\3\u0155\10\357\1\u0157\1\357"+
    "\1\u0155\1\357\1\u0157\3\u0155\1\u0158\2\357\1\u0159\1\u0158"+
    "\20\357\23\u0155\1\357\1\u0155\2\357\3\u0155\7\357\3\350"+
    "\1\u015a\2\350\3\u015a\1\0\3\350\1\0\20\350\23\u015a"+
    "\1\350\1\u015a\2\350\3\u015a\7\350\3\u015b\1\u015c\2\u015b"+
    "\3\u015c\1\u0158\3\u015b\1\u0158\20\u015b\23\u015c\1\u015b\1\u015c"+
    "\2\u015b\3\u015c\10\u015b\1\u015c\1\u015b\1\u015c\1\u015b\4\u015c"+
    "\1\u015d\2\u015b\1\u015e\1\u015d\20\u015b\23\u015c\1\u015b\1\u015c"+
    "\2\u015b\3\u015c\7\u015b\11\u015f\1\353\3\u015f\1\353\61\u015f"+
    "\3\355\1\u0160\2\355\3\u0160\1\u0156\2\355\1\357\1\u0156"+
    "\20\355\23\u0160\1\355\1\u0160\2\355\3\u0160\7\355\1\u0161"+
    "\1\356\1\u0161\1\356\1\u0161\4\356\1\u015d\2\u0161\1\u015e"+
    "\1\u015d\20\u0161\23\356\1\u0161\1\356\2\u0161\3\356\7\u0161"+
    "\1\0\1\361\3\0\1\361\72\0\1\362\1\0\1\362"+
    "\1\0\4\362\25\0\23\362\1\0\1\362\2\0\3\362"+
    "\15\0\1\u0162\73\0\1\u0163\102\0\1\u0164\36\0\1\u0165"+
    "\1\u0166\67\0\1\u0167\41\0\1\u0168\134\0\1\u0169\14\0"+
    "\1\u016a\56\0\1\u016b\7\0\1\u016c\3\0\1\u016d\67\0"+
    "\1\u016e\103\0\1\u016f\64\0\1\u0170\1\0\1\u0171\41\0"+
    "\1\u0172\37\0\1\u0173\1\u0174\1\0\1\u0175\73\0\1\u0176"+
    "\107\0\1\u0177\61\0\1\u0178\1\u0179\41\0\1\u017a\34\0"+
    "\1\u017b\41\0\1\u017c\34\0\1\u017d\47\0\2\u0106\2\0"+
    "\1\u0106\62\0\1\u0107\1\0\1\u0107\1\0\4\u0107\1\u017e"+
    "\2\0\1\u017f\1\u017e\20\0\23\u0107\1\0\1\u0107\2\0"+
    "\3\u0107\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\6\33\1\u0180\14\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\u0181\1\0\4\33\25\0\23\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\4\33\1\u0182\1\u0183\1\33\1\u0184\2\33"+
    "\1\u0185\2\33\1\u0186\5\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\1\u0187"+
    "\22\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\u0188\1\0\4\33\25\0\23\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\6\33\1\u0189\14\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\16\33\1\u018a"+
    "\4\33\1\0\1\33\2\0\3\33\36\0\1\u0113\50\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\2\33\1\u018b"+
    "\20\33\1\0\1\33\2\0\3\33\10\0\1\207\1\0"+
    "\1\207\1\0\4\207\25\0\5\207\1\u018c\15\207\1\0"+
    "\1\207\2\0\3\207\12\0\1\u018d\2\0\3\u018d\1\0"+
    "\1\u0113\4\0\1\u018e\16\0\23\u018d\1\0\1\u018d\2\0"+
    "\3\u018d\3\0\1\u018f\34\0\1\u0190\46\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\10\33\1\u0191\12\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\10\33\1\u0192\12\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\6\33\1\u0193\14\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\2\33\1\u0194"+
    "\20\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\u0195\1\0\4\33\25\0\23\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\16\33\1\u0196\4\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\2\33\1\u0197"+
    "\20\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\16\33\1\u0198\4\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\u0199\1\0"+
    "\4\33\25\0\23\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\16\33\1\u019a"+
    "\4\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\6\33\1\u019b\14\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\u019c\1\0"+
    "\4\33\25\0\23\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\16\33\1\u019d"+
    "\4\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\u019e\1\0\4\33\25\0\23\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\1\u019f\22\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\u01a0\1\0\4\33\25\0\23\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\22\33\1\u01a1\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\12\33\1\u01a2"+
    "\10\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\2\33\1\u01a3\20\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\11\33\1\u01a4\11\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\u01a5\1\0\4\33\25\0"+
    "\23\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\6\33\1\u01a6\3\33\1\u01a7"+
    "\10\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\11\33\1\u01a8\11\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\u01a9\1\0"+
    "\4\33\25\0\23\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\3\33\1\u01aa"+
    "\17\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\12\33\1\u01ab\10\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\7\33\1\u01ac\13\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\6\33\1\u01ad\14\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\6\33\1\u01ae"+
    "\14\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\16\33\1\u01af\4\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\6\33\1\u01b0\14\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\1\u01b1\22\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\2\33\1\u01b2\1\33\25\0\23\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\6\33\1\u01b3\14\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\3\33\1\u01b4\17\33\1\0\1\u01b5\2\0\3\33"+
    "\10\0\1\33\1\0\1\u01b6\1\0\4\33\25\0\23\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\16\33\1\u01b7\4\33\1\0\1\33"+
    "\2\0\3\33\45\0\1\u01b8\101\0\1\u01b9\122\0\1\u01ba"+
    "\51\0\1\u01bb\75\0\1\u01bc\105\0\1\u01bd\74\0\1\u01be"+
    "\70\0\1\u01bf\110\0\1\u01c0\65\0\1\u01c1\40\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\2\33\1\u01c2\20\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\5\33\1\u01c3\15\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\5\33\1\u01c4\2\33\1\u01c5\12\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\16\33\1\u01c6\4\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\2\33"+
    "\1\u01c7\20\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\5\33\1\u01c8\15\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\u01c9"+
    "\1\0\4\33\25\0\23\33\1\0\1\33\2\0\3\33"+
    "\7\0\11\123\1\u0151\3\123\1\u0151\1\331\1\123\1\332"+
    "\1\123\1\333\54\123\11\10\1\u0153\3\10\1\u0153\61\10"+
    "\1\346\1\u01ca\1\346\1\u01ca\1\346\4\u01ca\1\353\2\346"+
    "\1\u01cb\1\353\20\346\23\u01ca\1\346\1\u01ca\2\346\3\u01ca"+
    "\7\346\11\u01cc\1\0\2\u01cc\2\0\61\u01cc\1\346\1\347"+
    "\1\346\1\347\1\346\4\347\1\u01cd\2\346\1\u01ce\1\u01cd"+
    "\20\346\23\347\1\346\1\347\2\346\3\347\12\346\1\347"+
    "\2\346\3\347\1\u01cd\2\346\1\350\1\u01cd\20\346\23\347"+
    "\1\346\1\347\2\346\3\347\7\346\1\350\1\u015a\1\350"+
    "\1\u015a\1\350\4\u015a\1\u01cd\2\350\1\u01ce\1\u01cd\20\350"+
    "\23\u015a\1\350\1\u015a\2\350\3\u015a\7\350\11\351\1\u01cd"+
    "\2\351\1\u015f\1\u01cd\72\351\1\353\2\351\1\u015f\1\353"+
    "\61\351\11\u015f\1\u01cd\3\u015f\1\u01cd\61\u015f\1\355\1\u0160"+
    "\1\355\1\u0160\1\355\4\u0160\1\u015d\2\355\1\u01cf\1\u015d"+
    "\20\355\23\u0160\1\355\1\u0160\2\355\3\u0160\7\355\3\u0161"+
    "\1\356\2\u0161\3\356\1\u0158\2\u0161\1\u015b\1\u0158\20\u0161"+
    "\23\356\1\u0161\1\356\2\u0161\3\356\7\u0161\40\0\1\u01d0"+
    "\6\0\1\u01d1\73\0\1\u01d2\102\0\1\u01d3\72\0\1\u01d4"+
    "\101\0\1\u01d5\107\0\1\u01d6\66\0\1\u01d7\6\0\1\u01d8"+
    "\63\0\1\u01d9\73\0\1\u01da\77\0\1\u01db\100\0\1\u01dc"+
    "\71\0\1\u01dd\100\0\1\u01de\12\0\1\u01df\25\0\1\u01e0"+
    "\152\0\1\u01e1\63\0\1\u01e2\35\0\1\u01e3\134\0\1\u01e4"+
    "\75\0\1\u01e5\45\0\1\u01e6\130\0\1\u01e7\5\0\1\u01e8"+
    "\65\0\1\u01e9\76\0\1\u01ea\77\0\1\u01eb\7\0\1\u01ec"+
    "\73\0\1\u01ed\110\0\1\u01ee\57\0\1\u01ef\76\0\1\u01f0"+
    "\50\0\1\u017e\3\0\1\u017e\62\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\3\33\1\u01f1\17\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\u01f2\1\0\4\33"+
    "\25\0\23\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\7\33\1\u01f3\13\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\1\u01f4\22\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\15\33\1\u01f5\5\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\14\33\1\u01f6"+
    "\6\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\5\33\1\u01f7\15\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\13\33\1\u01f8\7\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\17\33\1\u01f9\3\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\207\1\0\1\207\1\0\4\207\25\0\12\207\1\u01fa"+
    "\10\207\1\0\1\207\2\0\3\207\10\0\1\u018d\1\0"+
    "\1\u018d\1\0\4\u018d\1\u01fb\3\0\1\u01fc\20\0\23\u018d"+
    "\1\0\1\u018d\2\0\3\u018d\12\0\1\u01fd\2\0\3\u01fd"+
    "\25\0\23\u01fd\1\0\1\u01fd\2\0\3\u01fd\12\0\1\u01fe"+
    "\2\0\3\u01fe\25\0\23\u01fe\1\0\1\u01fe\2\0\3\u01fe"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\1\33"+
    "\1\u01ff\21\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\5\33\1\u0200\15\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\1\33\1\u0201\21\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\13\33\1\u0202\7\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\12\33"+
    "\1\u0203\10\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\10\33\1\u0204\12\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\2\33\1\u0205\20\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\1\33\1\u0206\21\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\10\33"+
    "\1\u0207\12\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\2\33\1\u0208\20\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\6\33\1\u0209\14\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\u020a\1\0\4\33"+
    "\25\0\23\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\15\33\1\u020b\5\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\2\33\1\u020c\20\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\u020d\1\0\4\33"+
    "\25\0\23\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\16\33\1\u020e\4\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\6\33\1\u020f\14\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\6\33\1\u0210\14\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\5\33"+
    "\1\u0211\15\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\6\33\1\u0212\14\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\14\33\1\u0213\6\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\u0214\1\0\4\33"+
    "\25\0\23\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\12\33\1\u0215\10\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\5\33\1\u0216\15\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\11\33\1\u0217\11\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\u0218\1\0\4\33\25\0\23\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\2\33\1\u0219\20\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\u021a\1\0\4\33"+
    "\25\0\23\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\6\33\1\u021b\14\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\2\33\1\u021c\20\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\3\33\1\u021d\17\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\5\33"+
    "\1\u021e\15\33\1\0\1\33\2\0\3\33\63\0\1\u021f"+
    "\62\0\1\u0220\41\0\1\u0221\147\0\1\u0222\62\0\1\u0223"+
    "\45\0\1\u0224\72\0\1\u0225\6\0\1\u0222\51\0\1\u0226"+
    "\52\0\1\u0227\41\0\1\u0227\136\0\1\u0228\34\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\22\33\1\u0229\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\1\33\1\u022a\21\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\16\33\1\u022b\4\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\3\33\1\u022c"+
    "\17\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\2\33\1\u022d\20\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\16\33\1\u022e\4\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\3\33\1\u022f\17\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\6\33\1\u0230"+
    "\14\33\1\0\1\33\2\0\3\33\7\0\1\357\1\u0155"+
    "\1\357\1\u0155\1\357\4\u0155\1\u015d\2\357\1\u01cf\1\u015d"+
    "\20\357\23\u0155\1\357\1\u0155\2\357\3\u0155\7\357\3\350"+
    "\1\u015a\2\350\3\u015a\1\353\3\350\1\353\20\350\23\u015a"+
    "\1\350\1\u015a\2\350\3\u015a\7\350\3\u0156\1\u0231\2\u0156"+
    "\3\u0231\25\u0156\23\u0231\1\u0156\1\u0231\2\u0156\3\u0231\7\u0156"+
    "\3\350\1\u015a\2\350\3\u015a\1\u01cd\3\350\1\u01cd\20\350"+
    "\23\u015a\1\350\1\u015a\2\350\3\u015a\7\350\3\346\1\347"+
    "\2\346\3\347\1\353\2\346\1\350\1\353\20\346\23\347"+
    "\1\346\1\347\2\346\3\347\7\346\60\0\1\u0232\21\0"+
    "\1\u0233\141\0\1\u0234\74\0\1\u0235\104\0\1\u0236\27\0"+
    "\1\u0237\76\0\1\u0238\142\0\1\u0239\66\0\1\u023a\42\0"+
    "\1\u023b\131\0\1\u023c\76\0\1\u023d\76\0\1\u023e\76\0"+
    "\1\u023f\100\0\1\u0240\41\0\1\u0241\143\0\1\u0242\77\0"+
    "\1\u0243\30\0\1\u0244\142\0\1\u0245\73\0\1\u0246\111\0"+
    "\1\u0247\74\0\1\u0248\24\0\1\u0249\102\0\1\u024a\146\0"+
    "\1\u024b\57\0\1\u024c\113\0\1\u024d\73\0\1\u024e\67\0"+
    "\1\u024f\103\0\1\u0250\27\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\4\33\1\u0251\16\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\11\33\1\u0252\11\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\1\33\1\u0253"+
    "\21\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\5\33\1\u0254\15\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\5\33\1\u0255\15\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\7\33\1\u0256\13\33\1\0\1\33\2\0\3\33\20\0"+
    "\1\u01fb\66\0\1\u01fd\1\0\1\u01fd\1\0\4\u01fd\6\0"+
    "\1\u0257\16\0\23\u01fd\1\0\1\u01fd\2\0\3\u01fd\10\0"+
    "\1\u01fe\1\0\1\u01fe\1\0\4\u01fe\25\0\23\u01fe\1\0"+
    "\1\u01fe\2\0\3\u01fe\3\0\1\u0257\4\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\3\33\1\u0258\17\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\1\33\1\u0259\21\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\2\33\1\u025a\20\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\21\33\1\u025b"+
    "\1\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\16\33\1\u025c\4\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\1\33\1\u025d\21\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\7\33\1\u025e\13\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\4\33\1\u025f"+
    "\16\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\3\33\1\u0260\17\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\22\33\1\u0261\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\11\33"+
    "\1\u0262\11\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\5\33\1\u0263\15\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\3\33\1\u0264\17\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\11\33\1\u0265\11\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\14\33"+
    "\1\u0266\6\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\16\33\1\u0267\4\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\11\33\1\u0268\11\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\6\33\1\u0269\14\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\6\33"+
    "\1\u026a\14\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\11\33\1\u026b\11\33"+
    "\1\0\1\33\2\0\3\33\12\0\1\u026c\6\0\1\u0222"+
    "\51\0\1\u0226\51\0\1\u0223\106\0\1\u0227\41\0\1\u0222"+
    "\51\0\1\u0226\63\0\1\u0222\101\0\1\u026d\100\0\1\u026e"+
    "\64\0\1\u0222\73\0\1\u026f\36\0\1\33\1\0\1\u0270"+
    "\1\0\4\33\25\0\23\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\23\33"+
    "\1\0\1\33\2\0\1\33\1\u0271\1\33\10\0\1\33"+
    "\1\0\1\u0272\1\0\4\33\25\0\23\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\11\33\1\u0273\11\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\12\33"+
    "\1\u0274\10\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\6\33\1\u0275\14\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\u0276"+
    "\1\0\4\33\25\0\23\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\14\33"+
    "\1\u0277\6\33\1\0\1\33\2\0\3\33\7\0\1\u01cc"+
    "\1\u0278\1\u01cc\1\u0278\1\u01cc\4\u0278\1\353\2\u01cc\1\u0279"+
    "\1\353\20\u01cc\23\u0278\1\u01cc\1\u0278\2\u01cc\3\u0278\7\u01cc"+
    "\57\0\1\u027a\76\0\1\u027b\56\0\1\u027c\76\0\1\u027d"+
    "\75\0\1\u027e\110\0\1\u027f\76\0\1\u0280\31\0\1\u0281"+
    "\132\0\1\u0282\76\0\1\u0283\76\0\1\u0284\112\0\1\u0285"+
    "\77\0\1\u0286\72\0\1\u0287\65\0\1\u0288\115\0\1\u0289"+
    "\23\0\1\u028a\136\0\1\u028b\73\0\1\u028c\77\0\1\u028d"+
    "\75\0\1\u028e\41\0\1\u028f\153\0\1\u0290\56\0\1\u0291"+
    "\74\0\1\u0292\107\0\1\u0293\72\0\1\u0294\34\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\12\33\1\u0295\10\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\16\33\1\u0296\4\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\u0297\1\0\4\33"+
    "\25\0\23\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\6\33\1\u0298\14\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\16\33\1\u0299\4\33\1\0\1\33"+
    "\2\0\3\33\20\0\1\u01fb\3\0\1\u01fc\62\0\1\33"+
    "\1\0\1\u029a\1\0\4\33\25\0\23\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\11\33\1\u029b\11\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\2\33"+
    "\1\u029c\20\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\6\33\1\u029d\14\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\u029e"+
    "\1\0\4\33\25\0\23\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\2\33"+
    "\1\u029f\20\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\u02a0\1\0\4\33\25\0\23\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\11\33\1\u02a1\11\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\u02a2\1\0\4\33\25\0\23\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\14\33\1\u02a3\6\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\1\u02a4\22\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\10\33\1\u02a5"+
    "\12\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\6\33\1\u02a6\14\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\u02a7\1\0"+
    "\4\33\25\0\23\33\1\0\1\33\2\0\3\33\47\0"+
    "\1\u02a8\41\0\1\u0222\76\0\1\u02a9\151\0\1\u0222\21\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\12\33\1\u02aa"+
    "\10\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\23\33\1\0\1\33\2\0"+
    "\1\33\1\u02ab\1\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\23\33\1\0\1\33\2\0\1\33\1\u02ac"+
    "\1\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\6\33\1\u02ad\14\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\12\33\1\u02ae"+
    "\10\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\23\33\1\0\1\33\2\0"+
    "\1\33\1\u02af\1\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\23\33\1\0\1\33\2\0\1\33\1\u02b0"+
    "\1\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\1\u02b1\22\33\1\0\1\33\2\0\3\33\7\0\1\u0156"+
    "\1\u0231\1\u0156\1\u0231\1\u0156\4\u0231\1\u015d\2\u0156\1\u02b2"+
    "\1\u015d\20\u0156\23\u0231\1\u0156\1\u0231\2\u0156\3\u0231\7\u0156"+
    "\11\0\1\353\3\0\1\353\135\0\1\u02b3\66\0\1\u02b4"+
    "\73\0\1\u02b5\75\0\1\u02b6\75\0\1\u02b7\107\0\1\u02b8"+
    "\105\0\1\u02b9\66\0\1\u02ba\70\0\1\u02bb\40\0\1\u02bc"+
    "\136\0\1\u02bd\103\0\1\u02be\64\0\1\u02bf\103\0\1\u02c0"+
    "\71\0\1\u02c1\107\0\1\u02c2\76\0\1\u02c3\77\0\1\u02c4"+
    "\102\0\1\u02c5\61\0\1\u02c6\115\0\1\u02c7\62\0\1\u02c8"+
    "\72\0\1\u02c9\41\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\2\33\1\u02ca\20\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\2\33"+
    "\1\u02cb\20\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\11\33\1\u02cc\11\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\u02cd"+
    "\1\0\4\33\25\0\23\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\23\33"+
    "\1\0\1\33\2\0\1\33\1\u02ce\1\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\6\33\1\u02cf\14\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\11\33\1\u02d0\11\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\11\33\1\u02d1\11\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\23\33"+
    "\1\0\1\33\2\0\1\33\1\u02d2\1\33\10\0\1\33"+
    "\1\0\1\u02d3\1\0\4\33\25\0\23\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\3\33\1\u02d4\17\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\3\33"+
    "\1\u02d5\17\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\u02d6\1\0\4\33\25\0\23\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\u02d7\1\0\4\33"+
    "\25\0\23\33\1\0\1\33\2\0\3\33\50\0\1\u0222"+
    "\74\0\1\u0222\40\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\21\33\1\u02d8\1\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\23\33"+
    "\1\0\1\33\2\0\1\33\1\u02d9\1\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\5\33\1\u02da\15\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\23\33\1\0\1\33\2\0\1\33"+
    "\1\u02db\1\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\11\33\1\u02dc\11\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\23\33"+
    "\1\0\1\33\2\0\1\33\1\u02dd\1\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\4\33\1\u02de\16\33"+
    "\1\0\1\33\2\0\3\33\7\0\11\u01cc\1\353\2\u01cc"+
    "\1\0\1\353\61\u01cc\3\0\1\u02df\136\0\1\u02e0\102\0"+
    "\1\u02e1\67\0\1\u02e2\76\0\1\u02e3\76\0\1\u02e4\76\0"+
    "\1\u02e5\104\0\1\u02e6\106\0\1\u02e7\57\0\1\u02e8\121\0"+
    "\1\u02e9\71\0\1\u02ea\24\0\1\u02eb\137\0\1\u02ec\35\0"+
    "\1\u02ed\134\0\1\u02ee\36\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\1\33\1\u02ef\21\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\11\33\1\u02f0\11\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\14\33\1\u02f1"+
    "\6\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\1\u02f2\22\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\u02f3\1\0\4\33"+
    "\25\0\23\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\u02f4\1\0\4\33\25\0\23\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\1\u02f5\22\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\1\u02f6\22\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\6\33\1\u02f7\14\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\4\33\1\u02f8\16\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\2\33"+
    "\1\u02f9\20\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\1\u02fa\22\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\23\33\1\0\1\33\2\0\1\33\1\u02fb"+
    "\1\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\1\u02fc\22\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\23\33\1\0\1\33"+
    "\2\0\1\33\1\u02fd\1\33\45\0\1\u02fe\104\0\1\u02ff"+
    "\101\0\1\u0300\73\0\1\u0301\106\0\1\u0302\76\0\1\u0303"+
    "\61\0\1\u0304\111\0\1\u0305\75\0\1\u0306\65\0\1\u0307"+
    "\76\0\1\u0308\107\0\1\u0309\26\0\1\33\1\0\1\u030a"+
    "\1\0\4\33\25\0\23\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\14\33"+
    "\1\u030b\6\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\3\33\1\u030c\17\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\3\33\1\u030d\17\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\7\33\1\u030e\13\33\1\0\1\33\2\0\3\33"+
    "\10\0\1\33\1\0\1\33\1\0\4\33\25\0\12\33"+
    "\1\u030f\10\33\1\0\1\33\2\0\3\33\10\0\1\33"+
    "\1\0\1\33\1\0\4\33\25\0\11\33\1\u0310\11\33"+
    "\1\0\1\33\2\0\3\33\10\0\1\33\1\0\1\33"+
    "\1\0\4\33\25\0\3\33\1\u0311\17\33\1\0\1\33"+
    "\2\0\3\33\10\0\1\33\1\0\1\33\1\0\4\33"+
    "\25\0\22\33\1\u0312\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\23\33\1\0"+
    "\1\33\2\0\1\33\1\u0313\1\33\50\0\1\u0314\40\0"+
    "\1\u0315\76\0\1\u0316\142\0\1\u0317\73\0\1\u0318\71\0"+
    "\1\u0319\115\0\1\u031a\21\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\11\33\1\u031b\11\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\11\33\1\u031c\11\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\u031d\1\0\4\33\25\0\23\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\23\33\1\0\1\33\2\0\1\33\1\u031e"+
    "\1\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\21\33\1\u031f\1\33\1\0\1\33\2\0\3\33\51\0"+
    "\1\u0320\37\0\1\u0321\76\0\1\u0322\74\0\1\33\1\0"+
    "\1\u0323\1\0\4\33\25\0\23\33\1\0\1\33\2\0"+
    "\3\33\10\0\1\33\1\0\1\u0324\1\0\4\33\25\0"+
    "\23\33\1\0\1\33\2\0\3\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\23\33\1\0\1\33\2\0"+
    "\1\33\1\u0325\1\33\10\0\1\33\1\0\1\33\1\0"+
    "\4\33\25\0\23\33\1\0\1\33\2\0\1\33\1\u0326"+
    "\1\33\10\0\1\33\1\0\1\33\1\0\4\33\25\0"+
    "\5\33\1\u0327\15\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\23\33\1\0"+
    "\1\33\2\0\1\33\1\u0328\1\33\10\0\1\33\1\0"+
    "\1\33\1\0\4\33\25\0\16\33\1\u0329\4\33\1\0"+
    "\1\33\2\0\3\33\10\0\1\33\1\0\1\u032a\1\0"+
    "\4\33\25\0\23\33\1\0\1\33\2\0\3\33\10\0"+
    "\1\33\1\0\1\33\1\0\4\33\25\0\1\33\1\u032b"+
    "\21\33\1\0\1\33\2\0\3\33\7\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[40509];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",		//$NON-NLS-1$
    "Error: could not match input",		//$NON-NLS-1$
    "Error: pushback value was too large"		//$NON-NLS-1$
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\10\5\0\2\1\12\0\1\11\11\1\2\11\2\1"+
    "\3\11\35\1\1\11\1\1\1\11\3\1\1\11\10\1"+
    "\1\11\10\1\1\11\1\1\1\11\3\1\1\0\1\1"+
    "\1\11\3\1\1\11\1\1\1\11\2\1\1\11\2\1"+
    "\1\11\3\1\1\11\1\1\1\11\2\1\1\11\1\1"+
    "\1\0\3\1\1\11\6\1\1\11\2\0\3\1\2\0"+
    "\1\11\2\0\52\1\1\11\1\1\12\0\1\1\2\0"+
    "\1\1\3\0\2\1\3\11\1\1\4\0\1\1\1\11"+
    "\1\1\1\11\3\0\4\1\1\0\1\11\2\0\1\11"+
    "\6\0\1\11\4\0\1\11\2\1\2\11\20\0\1\11"+
    "\1\1\1\0\10\1\1\0\2\1\1\0\53\1\12\0"+
    "\7\1\2\11\1\1\1\11\1\1\3\0\1\1\4\0"+
    "\1\1\40\0\1\11\1\0\15\1\3\0\1\11\47\1"+
    "\12\0\10\1\3\0\1\11\25\0\1\11\14\0\1\11"+
    "\12\1\1\11\1\1\2\0\40\1\7\0\1\11\2\0"+
    "\10\1\7\0\1\1\1\11\3\0\1\11\4\0\1\11"+
    "\5\0\1\11\10\0\6\1\1\0\24\1\4\0\10\1"+
    "\16\0\1\11\3\0\1\11\5\0\1\11\2\0\1\11"+
    "\1\0\23\1\2\0\10\1\3\0\1\11\1\0\2\11"+
    "\3\0\1\11\1\0\1\11\3\0\1\1\2\0\1\11"+
    "\2\0\1\11\1\0\25\1\1\11\13\0\1\11\1\0"+
    "\2\11\17\1\1\0\1\11\2\0\2\11\2\0\1\11"+
    "\2\0\1\11\12\1\2\11\2\0\2\11\1\0\5\1"+
    "\3\11\11\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[811];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
    public PhpLexer(int state){
        initialize(state);
    }

    // NB: this method resets the lexer only partially
    protected void reset(java.io.Reader reader, char[] buffer, int[] parameters){
    	this.zzReader = reader;
    	this.zzBuffer = buffer;
    	this.zzFinalHighSurrogate = 0;
    	this.zzMarkedPos = parameters[0];
    	this._zzPushbackPos = parameters[1];
    	this.zzCurrentPos = parameters[2];
    	this.zzStartRead = parameters[3];
    	this.zzEndRead = parameters[4];
    	this.yyline = parameters[5];
    	initialize(parameters[6]);
    }

    protected boolean isHeredocState(int state){
        return state == ST_PHP_HEREDOC || state == ST_PHP_START_HEREDOC || state == ST_PHP_END_HEREDOC || state == ST_PHP_NOWDOC || state == ST_PHP_START_NOWDOC || state == ST_PHP_END_NOWDOC;
    }

    public int[] getParamenters(){
    	return new int[]{zzMarkedPos, _zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline, zzLexicalState};
    }

    protected int getZZLexicalState() {
        return zzLexicalState;
    }

    protected int getZZMarkedPos() {
        return zzMarkedPos;
    }

    protected int getZZEndRead() {
        return zzEndRead;
    }

    public char[] getZZBuffer() {
        return zzBuffer;
    }

    protected int getZZStartRead() {
    	return this.zzStartRead;
    }

    protected int getZZPushBackPosition() {
    	return this._zzPushbackPos;
    }

	protected void pushBack(int i) {
		yypushback(i);
	}

	public int getScriptingState() {
       return ST_PHP_IN_SCRIPTING;
    }

	// A pool of states. To avoid creation of a new state on each createMemento.
	private static final IntHashtable lexerStates = new IntHashtable(100);

	protected IntHashtable getLexerStates() {
		return lexerStates;
	}

 // End user code


  /** the textposition at the last state to be included in yytext */
  private int _zzPushbackPos;

  /* The following fields are added in order to support the change in zzRefill */
  private String oldString = null;
  private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PhpLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 234) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    oldString = new String(zzBuffer, startPos, zzMarkedPos-startPos);

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      _zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (zzAtEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (zzRefill()) {
        return YYEOF;
    }

    return zzBuffer[zzCurrentPos++];
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = _zzPushbackPos = startPos = 0;
    oldString = null;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		startPos = zzMarkedPos;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public String yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { if(heredoc!=null&&yytext().startsWith(heredoc)){
		String text = yytext();
		if(heredoc_len < text.length() && (text.charAt(heredoc_len) == '\r'
			|| text.charAt(heredoc_len) == '\n'|| text.charAt(heredoc_len) == ';')){
			yypushback(yylength()-heredoc_len-1);
	        heredoc=null;
	        heredoc_len=0;
	        yybegin(ST_PHP_IN_SCRIPTING);
	        return PHP_HEREDOC_TAG;
		}
	}
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 171: break;
          case 2: 
            { return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 172: break;
          case 3: 
            { yypushback(1);
    pushState(ST_PHP_HIGHLIGHTING_ERROR);
            }
          case 173: break;
          case 4: 
            { return PHP_NUMBER;
            }
          case 174: break;
          case 5: 
            { return PHP_TOKEN;
            }
          case 175: break;
          case 6: 
            { return  PHP_LABEL;
            }
          case 176: break;
          case 7: 
            { return WHITESPACE;
            }
          case 177: break;
          case 8: 
            { return PHP_SEMICOLON;
            }
          case 178: break;
          case 9: 
            { pushState(ST_PHP_DOUBLE_QUOTES);
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 179: break;
          case 10: 
            { return PHP_NS_SEPARATOR;
            }
          case 180: break;
          case 11: 
            { pushState(ST_PHP_BACKQUOTE);
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 181: break;
          case 12: 
            { return PHP_CURLY_OPEN;
            }
          case 182: break;
          case 13: 
            { if (!phpStack.isEmpty()) {
        popState();
    }
    return  PHP_CURLY_CLOSE;
            }
          case 183: break;
          case 14: 
            { pushState(ST_PHP_SINGLE_QUOTE);
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 184: break;
          case 15: 
            { pushState(ST_PHP_LINE_COMMENT);
    return PHP_LINE_COMMENT;
            }
          case 185: break;
          case 16: 
            { return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 186: break;
          case 17: 
            { popState();
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 187: break;
          case 18: 
            { yypushback(1);
        popState();
            }
          case 188: break;
          case 19: 
            { yypushback(1);
	yybegin(ST_PHP_HEREDOC);
            }
          case 189: break;
          case 20: 
            { yypushback(1);
	yybegin(ST_PHP_NOWDOC);
            }
          case 190: break;
          case 21: 
            { yypushback(1);
    popState();
            }
          case 191: break;
          case 22: 
            { popState();
    return PHP_LABEL;
            }
          case 192: break;
          case 23: 
            { /* Offset could be treated as a long */
	return PHP_NUMBER;
            }
          case 193: break;
          case 24: 
            { //the difference from the original rules comes from the fact that we took ';' out of tokens
	return UNKNOWN_TOKEN;
            }
          case 194: break;
          case 25: 
            { yypushback(1);
	popState();
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 195: break;
          case 26: 
            { popState();
	return PHP_TOKEN;
            }
          case 196: break;
          case 27: 
            { return PHP_COMMENT;
            }
          case 197: break;
          case 28: 
            { return PHPDOC_COMMENT;
            }
          case 198: break;
          case 29: 
            { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			if (yylength() > 0) {
				return PHP_LINE_COMMENT;
			}
			break;
		default:
			popState();
			return PHP_LINE_COMMENT;
	}
            }
          case 199: break;
          case 30: 
            { return PHP_LINE_COMMENT;
            }
          case 200: break;
          case 31: 
            { return UNKNOWN_TOKEN;
            }
          case 201: break;
          case 32: 
            { popState();return WHITESPACE;
            }
          case 202: break;
          case 33: 
            { return PHP_OPERATOR;
            }
          case 203: break;
          case 34: 
            { pushState(ST_PHP_LOOKING_FOR_PROPERTY);
    return PHP_OBJECT_OPERATOR;
            }
          case 204: break;
          case 35: 
            { return PHP_VARIABLE;
            }
          case 205: break;
          case 36: 
            { pushState(ST_PHP_COMMENT);
    return PHP_COMMENT_START;
            }
          case 206: break;
          case 37: 
            { if (asp_tags) {
	    return PHP_CLOSETAG;
	}
	return UNKNOWN_TOKEN;
            }
          case 207: break;
          case 38: 
            { return PHP_AS;
            }
          case 208: break;
          case 39: 
            { return PHP_DO;
            }
          case 209: break;
          case 40: 
            { return PHP_IF;
            }
          case 210: break;
          case 41: 
            { return PHP_PAAMAYIM_NEKUDOTAYIM;
            }
          case 211: break;
          case 42: 
            { return PHP_CLOSETAG;
            }
          case 212: break;
          case 43: 
            { pushState(ST_PHP_QUOTES_AFTER_VARIABLE);
    return PHP_VARIABLE;
            }
          case 213: break;
          case 44: 
            { yypushback(1);
    return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 214: break;
          case 45: 
            { pushState(ST_PHP_IN_SCRIPTING);
    return PHP_TOKEN;
            }
          case 215: break;
          case 46: 
            { yypushback(1);
    pushState(ST_PHP_IN_SCRIPTING);
    return PHP_CURLY_OPEN;
            }
          case 216: break;
          case 47: 
            { yypushback(1);
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 217: break;
          case 48: 
            { popState();
    pushState(ST_PHP_LOOKING_FOR_PROPERTY);
    return PHP_OBJECT_OPERATOR;
            }
          case 218: break;
          case 49: 
            { int label_len = yylength() - 1;

    if (yytext().charAt(label_len-1)==';') {
	    label_len--;
    }

    if (label_len==heredoc_len && yytext().substring(0,label_len).equals(heredoc)) {
        heredoc=null;
        heredoc_len=0;
        yybegin(ST_PHP_IN_SCRIPTING);
        return PHP_HEREDOC_TAG;
    } else {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 219: break;
          case 50: 
            { int label_len = yylength() - 1;

    if (yytext().charAt(label_len-1)==';') {
	    label_len--;
    }

    if (label_len==nowdoc_len && yytext().substring(0,label_len).equals(nowdoc)) {
        nowdoc=null;
        nowdoc_len=0;
        yybegin(ST_PHP_IN_SCRIPTING);
        return PHP_HEREDOC_TAG;
    } else {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 220: break;
          case 51: 
            { int label_len = yylength() - 1;
	int startIndex = 0;
	String yytext = yytext();
	if (yytext.charAt(label_len - 1) == ';') {
		label_len--;
	}
	while (yytext.charAt(startIndex) == '\r'
			|| yytext.charAt(startIndex) == '\n') {
		startIndex++;
	}

	if (label_len > heredoc_len
			&& yytext.substring(startIndex, label_len).equals(
					heredoc)) {
		heredoc = null;
		heredoc_len = 0;
		yybegin(ST_PHP_IN_SCRIPTING);
		return PHP_HEREDOC_TAG;
	} else {
		yybegin(ST_PHP_HEREDOC);
		return PHP_CONSTANT_ENCAPSED_STRING;
	}
            }
          case 221: break;
          case 52: 
            { return PHP_OBJECT_OPERATOR;
            }
          case 222: break;
          case 53: 
            { popState();
    return PHP_COMMENT_END;
            }
          case 223: break;
          case 54: 
            { popState();
    return PHPDOC_COMMENT_END;
            }
          case 224: break;
          case 55: 
            { popState();
    return PHP_LINE_COMMENT;
            }
          case 225: break;
          case 56: 
            { if (asp_tags) {
	    return PHP_CLOSETAG;
	}
	String text = yytext();
	if(text.indexOf('\r') != -1 || text.indexOf('\n') != -1 ){
		popState();
	}
	return PHP_LINE_COMMENT;
            }
          case 226: break;
          case 57: 
            { pushState(ST_PHP_DOC_COMMENT);
    return PHPDOC_COMMENT_START;
            }
          case 227: break;
          case 58: 
            { return PHP_NEW;
            }
          case 228: break;
          case 59: 
            { return PHP_DIE;
            }
          case 229: break;
          case 60: 
            { return PHP_TRY;
            }
          case 230: break;
          case 61: 
            { return PHP_FOR;
            }
          case 231: break;
          case 62: 
            { return PHP_USE;
            }
          case 232: break;
          case 63: 
            { return PHP_VAR;
            }
          case 233: break;
          case 64: 
            { yypushback(1);
	pushState(ST_PHP_VAR_OFFSET);
	return PHP_VARIABLE;
            }
          case 234: break;
          case 65: 
            { int label_len = yylength() - 1;

    if (yytext().charAt(label_len-1)==';') {
	   label_len--;
    }
    if (label_len > heredoc_len && yytext().substring(label_len - heredoc_len,label_len).equals(heredoc)) {

    	if ((label_len - heredoc_len-2) >= 0 && yytext().charAt(label_len - heredoc_len-2)=='\r') {
        	label_len = label_len-2;
    	} else {
        	label_len--;
    	}
    	yypushback(heredoc_len + (yylength() - label_len));

        yybegin(ST_PHP_END_HEREDOC);
    }
    // In some cases, all text is pushed back (using yypushback()),
    // especially when the parsed document has Windows newlines.
    // In those cases, ignore this rule and try next one...
    if (yylength() > 0) {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 235: break;
          case 66: 
            { int label_len = yylength() - 1;

	if (yytext().charAt(label_len-1)==';') {
	   label_len--;
    }
    if (label_len > nowdoc_len && yytext().substring(label_len - nowdoc_len,label_len).equals(nowdoc)) {
    	//nowdoc = null;
    	//nowdoc_len = 0;
		//yypushback(1);
		//yybegin(ST_PHP_END_NOWDOC);

    	if ((label_len - nowdoc_len-2) >= 0 && yytext().charAt(label_len - nowdoc_len-2)=='\r') {
        	label_len = label_len-2;
    	} else {
        	label_len--;
    	}
    	yypushback(nowdoc_len + (yylength() - label_len));

        yybegin(ST_PHP_END_NOWDOC);
	}
    // In some cases, all text is pushed back (using yypushback()),
    // especially when the parsed document has Windows newlines.
    // In those cases, ignore this rule and try next one...
    if (yylength() > 0) {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 236: break;
          case 67: 
            { yybegin(ST_PHP_HEREDOC);
	return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 237: break;
          case 68: 
            { nowdoc = null;
	nowdoc_len = 0;
    yybegin(ST_PHP_IN_SCRIPTING);
    return PHP_HEREDOC_TAG;
            }
          case 238: break;
          case 69: 
            { return PHP_EXIT;
            }
          case 239: break;
          case 70: 
            { return PHP_ECHO;
            }
          case 240: break;
          case 71: 
            { return PHP_ELSE;
            }
          case 241: break;
          case 72: 
            { return PHP_EVAL;
            }
          case 242: break;
          case 73: 
            { yypushback(2);
    pushState(ST_PHP_COMMENT);
    return PHP_COMMENT_START;
            }
          case 243: break;
          case 74: 
            { return  PHP_KEYWORD;
            }
          case 244: break;
          case 75: 
            { return PHP_TRUE;
            }
          case 245: break;
          case 76: 
            { return PHP_FROM;
            }
          case 246: break;
          case 77: 
            { return PHP_CASE;
            }
          case 247: break;
          case 78: 
            { return PHP_SELF;
            }
          case 248: break;
          case 79: 
            { return PHP_LIST;
            }
          case 249: break;
          case 80: 
            { return PHP_GOTO;
            }
          case 250: break;
          case 81: 
            { return PHPDOC_SEE;
            }
          case 251: break;
          case 82: 
            { return PHPDOC_VAR;
            }
          case 252: break;
          case 83: 
            { return PHP_ENDIF;
            }
          case 253: break;
          case 84: 
            { return PHP_EMPTY;
            }
          case 254: break;
          case 85: 
            { return PHP_BREAK;
            }
          case 255: break;
          case 86: 
            { return PHP_THIS;
            }
          case 256: break;
          case 87: 
            { int bprefix = (yytext().charAt(0) != '<') ? 1 : 0;
    int startString=3+bprefix;

    int hereOrNowDoc_len = yylength()-bprefix-3-1-(yytext().charAt(yylength()-2)=='\r'?1:0);
    while ((yytext().charAt(startString) == ' ') || (yytext().charAt(startString) == '\t')) {
        startString++;
        hereOrNowDoc_len--;
    }
    String hereOrNowDoc = yytext().substring(startString,hereOrNowDoc_len+startString);
    if (hereOrNowDoc.charAt(0) == '\'') {
    	nowdoc = hereOrNowDoc.substring(1, hereOrNowDoc_len-1);
    	nowdoc_len = hereOrNowDoc_len - 2;
    	yybegin(ST_PHP_START_NOWDOC);
    }
    else if (hereOrNowDoc.charAt(0) == '"') {
    	heredoc = hereOrNowDoc.substring(1, hereOrNowDoc_len-1);
    	heredoc_len = hereOrNowDoc_len - 2;
    	yybegin(ST_PHP_START_HEREDOC);
    } else {
    	heredoc = hereOrNowDoc;
    	heredoc_len = hereOrNowDoc_len;
    	yybegin(ST_PHP_START_HEREDOC);
    }
    return PHP_HEREDOC_TAG;
            }
          case 257: break;
          case 88: 
            { return PHP_ARRAY;
            }
          case 258: break;
          case 89: 
            { return PHP_ISSET;
            }
          case 259: break;
          case 90: 
            { return PHP_THROW;
            }
          case 260: break;
          case 91: 
            { return PHP_FALSE;
            }
          case 261: break;
          case 92: 
            { return PHP_FINAL;
            }
          case 262: break;
          case 93: 
            { return PHP_UNSET;
            }
          case 263: break;
          case 94: 
            { return PHP_CONST;
            }
          case 264: break;
          case 95: 
            { return PHP_CATCH;
            }
          case 265: break;
          case 96: 
            { return PHP_CLONE;
            }
          case 266: break;
          case 97: 
            { return PHP_CLASS;
            }
          case 267: break;
          case 98: 
            { return PHP_WHILE;
            }
          case 268: break;
          case 99: 
            { return PHP_PRINT;
            }
          case 269: break;
          case 100: 
            { return PHP_CASTING;
            }
          case 270: break;
          case 101: 
            { return PHPDOC_NAME;
            }
          case 271: break;
          case 102: 
            { return PHPDOC_DESC;
            }
          case 272: break;
          case 103: 
            { return PHPDOC_TODO;
            }
          case 273: break;
          case 104: 
            { return PHPDOC_USES;
            }
          case 274: break;
          case 105: 
            { return PHPDOC_LINK;
            }
          case 275: break;
          case 106: 
            { return PHP_ENDFOR;
            }
          case 276: break;
          case 107: 
            { return PHP_ELSEIF;
            }
          case 277: break;
          case 108: 
            { return PHP_RETURN;
            }
          case 278: break;
          case 109: 
            { return PHP_STATIC;
            }
          case 279: break;
          case 110: 
            { return PHP_SWITCH;
            }
          case 280: break;
          case 111: 
            { return PHP_GLOBAL;
            }
          case 281: break;
          case 112: 
            { return PHP_PARENT;
            }
          case 282: break;
          case 113: 
            { return PHP_PUBLIC;
            }
          case 283: break;
          case 114: 
            { return PHPDOC_FINAL;
            }
          case 284: break;
          case 115: 
            { return PHPDOC_SINCE;
            }
          case 285: break;
          case 116: 
            { return PHPDOC_PARAM;
            }
          case 286: break;
          case 117: 
            { return PHPDOC_MAGIC;
            }
          case 287: break;
          case 118: 
            { return PHP_EXTENDS;
            }
          case 288: break;
          case 119: 
            { return PHP_REQUIRE;
            }
          case 289: break;
          case 120: 
            { return PHP_DEFAULT;
            }
          case 290: break;
          case 121: 
            { return PHP_DECLARE;
            }
          case 291: break;
          case 122: 
            { return PHP_INCLUDE;
            }
          case 292: break;
          case 123: 
            { return PHP_FOREACH;
            }
          case 293: break;
          case 124: 
            { return PHP_PRIVATE;
            }
          case 294: break;
          case 125: 
            { return PHP__DIR__;
            }
          case 295: break;
          case 126: 
            { return PHPDOC_RETURN;
            }
          case 296: break;
          case 127: 
            { return PHPDOC_AUTHOR;
            }
          case 297: break;
          case 128: 
            { return PHPDOC_ACCESS;
            }
          case 298: break;
          case 129: 
            { return PHPDOC_IGNORE;
            }
          case 299: break;
          case 130: 
            { return PHPDOC_THROWS;
            }
          case 300: break;
          case 131: 
            { return PHPDOC_STATIC;
            }
          case 301: break;
          case 132: 
            { return PHPDOC_GLOBAL;
            }
          case 302: break;
          case 133: 
            { return PHPDOC_METHOD;
            }
          case 303: break;
          case 134: 
            { return PHP_ENDWHILE;
            }
          case 304: break;
          case 135: 
            { return PHP_ABSTRACT;
            }
          case 305: break;
          case 136: 
            { return PHP_FUNCTION;
            }
          case 306: break;
          case 137: 
            { return PHP_CONTINUE;
            }
          case 307: break;
          case 138: 
            { return PHP__FILE__;
            }
          case 308: break;
          case 139: 
            { return PHP__LINE__;
            }
          case 309: break;
          case 140: 
            { return PHPDOC_EXAMPLE;
            }
          case 310: break;
          case 141: 
            { return PHPDOC_LICENSE;
            }
          case 311: break;
          case 142: 
            { return PHPDOC_PACKAGE;
            }
          case 312: break;
          case 143: 
            { return PHPDOC_VERSION;
            }
          case 313: break;
          case 144: 
            { return PHP_ENDSWITCH;
            }
          case 314: break;
          case 145: 
            { return PHP_NAMESPACE;
            }
          case 315: break;
          case 146: 
            { return PHP_INTERFACE;
            }
          case 316: break;
          case 147: 
            { return PHP_PROTECTED;
            }
          case 317: break;
          case 148: 
            { return PHP__CLASS__;
            }
          case 318: break;
          case 149: 
            { return PHPDOC_ABSTRACT;
            }
          case 319: break;
          case 150: 
            { return PHPDOC_INTERNAL;
            }
          case 320: break;
          case 151: 
            { return PHPDOC_TUTORIAL;
            }
          case 321: break;
          case 152: 
            { return PHPDOC_CATEGORY;
            }
          case 322: break;
          case 153: 
            { return PHPDOC_PROPERTY;
            }
          case 323: break;
          case 154: 
            { return PHP_ENDDECLARE;
            }
          case 324: break;
          case 155: 
            { return PHP_ENDFOREACH;
            }
          case 325: break;
          case 156: 
            { return PHP_INSTANCEOF;
            }
          case 326: break;
          case 157: 
            { return PHP_IMPLEMENTS;
            }
          case 327: break;
          case 158: 
            { return PHP__METHOD__;
            }
          case 328: break;
          case 159: 
            { return PHPDOC_EXCEPTION;
            }
          case 329: break;
          case 160: 
            { return PHPDOC_NAMESPACE;
            }
          case 330: break;
          case 161: 
            { return PHPDOC_COPYRIGHT;
            }
          case 331: break;
          case 162: 
            { return PHPDOC_STATICVAR;
            }
          case 332: break;
          case 163: 
            { return PHPDOC_DEPRECATED;
            }
          case 333: break;
          case 164: 
            { return PHPDOC_FILESOURCE;
            }
          case 334: break;
          case 165: 
            { return PHPDOC_SUBPACKAGE;
            }
          case 335: break;
          case 166: 
            { return PHP_REQUIRE_ONCE;
            }
          case 336: break;
          case 167: 
            { return PHP_INCLUDE_ONCE;
            }
          case 337: break;
          case 168: 
            { return PHP__FUNCTION__;
            }
          case 338: break;
          case 169: 
            { return PHP__NAMESPACE__;
            }
          case 339: break;
          case 170: 
            { return PHP_HALT_COMPILER;
            }
          case 340: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
