/* The following code was generated by JFlex 1.6.1 */

/*******************************************************************************
 * Copyright (c) 2006, 2015 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.compiler.ast.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTagKinds;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>documentor_compiler_ast_scanner.flex</tt>
 */
public class DocumentorLexer implements IDocumentorLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ST_IN_FIRST_LINE = 2;
  public static final int ST_IN_SHORT_DESC = 4;
  public static final int ST_IN_LONG_DESC = 6;
  public static final int ST_IN_TAGS = 8;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  1,  2,  3,  4,  5,  6,  7,  8, 9
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\2\1\0\1\0\1\3\22\0\1\1\11\0\1\4"+
    "\2\0\1\36\1\52\1\5\20\0\1\6\2\0\1\50\1\46\1\43"+
    "\2\0\1\42\1\40\4\0\1\41\1\47\2\0\1\44\1\0\1\45"+
    "\14\0\1\7\1\10\1\14\1\25\1\15\1\31\1\21\1\17\1\24"+
    "\1\0\1\33\1\30\1\27\1\32\1\20\1\23\1\0\1\13\1\11"+
    "\1\12\1\16\1\34\1\35\1\26\1\22\1\0\1\37\1\0\1\51"+
    "\7\0\1\0\u1fa2\0\1\0\1\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\udfe6\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\1\1\1\0\1\1\1\0\1\1\2\2\2\3"+
    "\1\2\2\4\3\2\2\5\4\2\2\6\1\2\2\1"+
    "\2\2\2\1\2\2\4\0\1\7\1\10\2\7\2\1"+
    "\2\0\1\1\1\11\23\0\1\12\1\1\2\0\1\13"+
    "\2\0\1\1\21\0\1\14\1\15\70\0\2\16\4\0"+
    "\1\17\30\0\1\20\6\0\1\21\30\0\1\22\12\0"+
    "\1\23\4\0\1\24\6\0\1\25\3\0\1\26\2\0"+
    "\1\27\12\0\1\30\4\0\1\31\6\0\1\32\3\0"+
    "\1\33\2\0\1\34\7\0\1\35\7\0\1\36\10\0"+
    "\1\37\10\0\1\40\7\0\1\41\10\0\1\42\4\0"+
    "\1\43\1\44\1\45\2\0\1\46\1\47\3\0\1\50"+
    "\2\0\1\51\2\0\1\52\6\0\1\53\1\54\1\55"+
    "\2\0\1\56\1\57\3\0\1\60\2\0\1\61\2\0"+
    "\1\62\13\0\1\63\1\64\3\0\1\65\2\0\1\66"+
    "\7\0\1\67\1\70\3\0\1\71\2\0\1\72\1\0"+
    "\1\73\2\0\1\74\1\75\1\0\1\76\1\77\4\0"+
    "\1\100\2\0\1\101\1\102\1\0\1\103\1\104\4\0"+
    "\1\105\1\0\1\106\3\0\1\107\1\0\1\110\1\0"+
    "\1\111\3\0\1\112\1\0\1\113\2\0\1\114\1\115"+
    "\1\0\1\116\2\0\1\117\1\120\11\0\1\121\2\0"+
    "\1\122\1\123\1\0\1\124\1\0\1\125\1\126";

  private static int [] zzUnpackAction() {
    int [] result = new int[479];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\53\0\126\0\201\0\254\0\327\0\u0102\0\u012d"+
    "\0\u0158\0\u0183\0\u01ae\0\u01d9\0\u01ae\0\u0204\0\u022f\0\u01ae"+
    "\0\u025a\0\u0285\0\u02b0\0\u02db\0\u01ae\0\u0306\0\u0331\0\u035c"+
    "\0\u0387\0\u03b2\0\u01ae\0\u03dd\0\u0408\0\u0433\0\u045e\0\u0489"+
    "\0\u04b4\0\u04df\0\u050a\0\u0535\0\u0560\0\u058b\0\u05b6\0\u022f"+
    "\0\u0285\0\u01ae\0\u01ae\0\u05e1\0\u060c\0\u02db\0\u0331\0\u035c"+
    "\0\u0387\0\u0637\0\u01ae\0\u0662\0\u068d\0\u06b8\0\u06e3\0\u070e"+
    "\0\u0739\0\u0764\0\u078f\0\u07ba\0\u07e5\0\u0810\0\u083b\0\u0866"+
    "\0\u0891\0\u08bc\0\u08e7\0\u0912\0\u03b2\0\u0408\0\u01ae\0\u093d"+
    "\0\u0489\0\u04b4\0\u01ae\0\u0535\0\u0560\0\u0968\0\u0993\0\u09be"+
    "\0\u09e9\0\u0a14\0\u0a3f\0\u0a6a\0\u0a95\0\u0ac0\0\u0aeb\0\u0b16"+
    "\0\u0b41\0\u0b6c\0\u0b97\0\u0bc2\0\u0bed\0\u0c18\0\u0c43\0\u0c6e"+
    "\0\u0c99\0\u0cc4\0\u0cef\0\u0d1a\0\u0d45\0\u0d70\0\u0d9b\0\u0dc6"+
    "\0\u0df1\0\u0e1c\0\u0e47\0\u0e72\0\u0e9d\0\u0ec8\0\u0ef3\0\u0f1e"+
    "\0\u0f49\0\u0f74\0\u0f9f\0\u0fca\0\u0ff5\0\u1020\0\u104b\0\u1076"+
    "\0\u10a1\0\u10cc\0\u10f7\0\u1122\0\u114d\0\u1178\0\u11a3\0\u11ce"+
    "\0\u11f9\0\u1224\0\u124f\0\u127a\0\u12a5\0\u12d0\0\u12fb\0\u1326"+
    "\0\u1351\0\u137c\0\u13a7\0\u13d2\0\u13fd\0\u1428\0\u1453\0\u147e"+
    "\0\u14a9\0\u14d4\0\u14ff\0\u152a\0\u1555\0\u1580\0\u15ab\0\u15d6"+
    "\0\u1601\0\u01ae\0\u162c\0\u1657\0\u1682\0\u16ad\0\u16d8\0\u01ae"+
    "\0\u1703\0\u172e\0\u1759\0\u1784\0\u17af\0\u17da\0\u1805\0\u1830"+
    "\0\u185b\0\u1886\0\u18b1\0\u18dc\0\u1907\0\u1932\0\u195d\0\u1988"+
    "\0\u19b3\0\u19de\0\u1a09\0\u1a34\0\u1a5f\0\u1a8a\0\u1ab5\0\u1ae0"+
    "\0\u01ae\0\u1b0b\0\u1b36\0\u1b61\0\u1b8c\0\u1bb7\0\u1be2\0\u01ae"+
    "\0\u1c0d\0\u1c38\0\u1c63\0\u1c8e\0\u1cb9\0\u1ce4\0\u1d0f\0\u1d3a"+
    "\0\u1d65\0\u1d90\0\u1dbb\0\u1de6\0\u1e11\0\u1e3c\0\u1e67\0\u1e92"+
    "\0\u1ebd\0\u1ee8\0\u1f13\0\u1f3e\0\u1f69\0\u1f94\0\u1fbf\0\u1fea"+
    "\0\u01ae\0\u2015\0\u2040\0\u206b\0\u2096\0\u20c1\0\u20ec\0\u2117"+
    "\0\u2142\0\u216d\0\u2198\0\u01ae\0\u21c3\0\u21ee\0\u2219\0\u2244"+
    "\0\u01ae\0\u226f\0\u229a\0\u22c5\0\u22f0\0\u231b\0\u2346\0\u01ae"+
    "\0\u2371\0\u239c\0\u23c7\0\u01ae\0\u23f2\0\u241d\0\u2448\0\u2473"+
    "\0\u249e\0\u24c9\0\u24f4\0\u251f\0\u254a\0\u2575\0\u25a0\0\u25cb"+
    "\0\u25f6\0\u01ae\0\u2621\0\u264c\0\u2677\0\u26a2\0\u01ae\0\u26cd"+
    "\0\u26f8\0\u2723\0\u274e\0\u2779\0\u27a4\0\u01ae\0\u27cf\0\u27fa"+
    "\0\u2825\0\u01ae\0\u2850\0\u287b\0\u28a6\0\u28d1\0\u28fc\0\u2927"+
    "\0\u2952\0\u297d\0\u29a8\0\u29d3\0\u01ae\0\u29fe\0\u2a29\0\u2a54"+
    "\0\u2a7f\0\u2aaa\0\u2ad5\0\u2b00\0\u01ae\0\u2b2b\0\u2b56\0\u2b81"+
    "\0\u2bac\0\u2bd7\0\u2c02\0\u2c2d\0\u2c58\0\u01ae\0\u2c83\0\u2cae"+
    "\0\u2cd9\0\u2d04\0\u2d2f\0\u2d5a\0\u2d85\0\u2db0\0\u01ae\0\u2ddb"+
    "\0\u2e06\0\u2e31\0\u2e5c\0\u2e87\0\u2eb2\0\u2edd\0\u01ae\0\u2f08"+
    "\0\u2f33\0\u2f5e\0\u2f89\0\u2fb4\0\u2fdf\0\u300a\0\u3035\0\u01ae"+
    "\0\u3060\0\u308b\0\u30b6\0\u30e1\0\u01ae\0\u01ae\0\u310c\0\u3137"+
    "\0\u3162\0\u01ae\0\u01ae\0\u318d\0\u31b8\0\u31e3\0\u01ae\0\u320e"+
    "\0\u3239\0\u01ae\0\u3264\0\u328f\0\u01ae\0\u32ba\0\u32e5\0\u3310"+
    "\0\u333b\0\u3366\0\u3391\0\u01ae\0\u01ae\0\u33bc\0\u33e7\0\u3412"+
    "\0\u01ae\0\u01ae\0\u343d\0\u3468\0\u3493\0\u01ae\0\u34be\0\u34e9"+
    "\0\u01ae\0\u3514\0\u353f\0\u01ae\0\u356a\0\u3595\0\u35c0\0\u35eb"+
    "\0\u3616\0\u3641\0\u366c\0\u3697\0\u36c2\0\u36ed\0\u3718\0\u01ae"+
    "\0\u01ae\0\u3743\0\u376e\0\u3799\0\u01ae\0\u37c4\0\u37ef\0\u01ae"+
    "\0\u381a\0\u3845\0\u3870\0\u389b\0\u38c6\0\u38f1\0\u391c\0\u01ae"+
    "\0\u01ae\0\u3947\0\u3972\0\u399d\0\u01ae\0\u39c8\0\u39f3\0\u01ae"+
    "\0\u3a1e\0\u01ae\0\u3a49\0\u3a74\0\u01ae\0\u01ae\0\u3a9f\0\u3aca"+
    "\0\u01ae\0\u3af5\0\u3b20\0\u3b4b\0\u3b76\0\u01ae\0\u3ba1\0\u3bcc"+
    "\0\u01ae\0\u01ae\0\u3bf7\0\u3c22\0\u01ae\0\u3c4d\0\u3c78\0\u3ca3"+
    "\0\u3cce\0\u01ae\0\u3cf9\0\u01ae\0\u3d24\0\u3d4f\0\u3d7a\0\u01ae"+
    "\0\u3da5\0\u01ae\0\u3dd0\0\u01ae\0\u3dfb\0\u3e26\0\u3e51\0\u01ae"+
    "\0\u3e7c\0\u01ae\0\u3ea7\0\u3ed2\0\u01ae\0\u01ae\0\u3efd\0\u01ae"+
    "\0\u3f28\0\u3f53\0\u01ae\0\u01ae\0\u3f7e\0\u3fa9\0\u3fd4\0\u3fff"+
    "\0\u402a\0\u4055\0\u4080\0\u40ab\0\u40d6\0\u01ae\0\u4101\0\u412c"+
    "\0\u01ae\0\u01ae\0\u4157\0\u01ae\0\u4182\0\u01ae\0\u01ae";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[479];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\60\13\1\14\45\13\60\15\1\16\45\15\1\13\1\17"+
    "\1\20\1\21\1\22\45\13\1\23\1\13\1\24\1\25"+
    "\1\26\1\27\1\13\1\30\30\13\1\31\12\13\1\23"+
    "\1\13\1\32\1\33\1\34\1\35\47\13\1\36\1\33"+
    "\1\34\1\37\1\13\1\30\30\13\1\31\14\13\1\40"+
    "\1\33\1\34\1\41\47\13\1\42\1\33\1\34\1\43"+
    "\1\13\1\44\30\13\1\45\13\13\57\0\1\46\52\0"+
    "\1\47\47\0\1\50\2\0\1\51\45\0\1\52\2\0"+
    "\1\20\55\0\1\53\46\0\1\54\1\52\1\55\50\0"+
    "\1\56\1\25\1\26\1\57\1\0\1\60\30\0\1\61"+
    "\12\0\1\52\2\0\1\25\51\0\1\62\1\25\1\26"+
    "\1\0\1\63\1\60\30\0\1\61\22\0\1\64\1\0"+
    "\1\65\1\66\1\67\1\70\1\71\1\72\2\0\1\73"+
    "\1\0\1\74\1\75\1\76\1\0\1\77\1\100\1\101"+
    "\1\102\1\0\1\103\24\0\1\104\45\0\1\105\2\0"+
    "\1\106\50\0\1\33\55\0\1\107\46\0\1\36\2\0"+
    "\1\37\1\0\1\60\30\0\1\61\14\0\1\110\3\0"+
    "\1\107\1\60\30\0\1\61\14\0\1\111\2\0\1\112"+
    "\53\0\1\113\46\0\1\42\2\0\1\43\1\0\1\114"+
    "\30\0\1\115\14\0\1\116\3\0\1\113\1\114\30\0"+
    "\1\115\22\0\1\117\1\0\1\120\1\121\1\122\1\123"+
    "\1\124\1\125\2\0\1\126\1\0\1\127\1\130\1\131"+
    "\1\0\1\132\1\133\1\134\1\135\1\0\1\136\24\0"+
    "\1\137\50\0\1\140\52\0\1\141\47\0\1\54\53\0"+
    "\1\52\51\0\1\62\1\25\1\26\2\0\1\60\30\0"+
    "\1\61\23\0\1\142\3\0\1\143\1\0\1\144\46\0"+
    "\1\145\2\0\1\146\1\147\5\0\1\150\44\0\1\151"+
    "\1\152\1\153\47\0\1\154\44\0\1\155\10\0\1\156"+
    "\60\0\1\157\35\0\1\160\71\0\1\161\31\0\1\162"+
    "\3\0\1\163\60\0\1\164\10\0\1\165\35\0\1\166"+
    "\52\0\1\167\61\0\1\170\52\0\1\171\35\0\1\172"+
    "\52\0\1\173\5\0\1\174\61\0\1\175\13\0\1\175"+
    "\13\0\1\110\4\0\1\60\30\0\1\61\14\0\1\116"+
    "\4\0\1\114\30\0\1\115\23\0\1\176\3\0\1\177"+
    "\1\0\1\200\46\0\1\201\2\0\1\202\1\203\5\0"+
    "\1\204\44\0\1\205\1\206\1\207\47\0\1\210\44\0"+
    "\1\211\10\0\1\212\60\0\1\213\35\0\1\214\71\0"+
    "\1\215\31\0\1\216\3\0\1\217\60\0\1\220\10\0"+
    "\1\221\35\0\1\222\52\0\1\223\61\0\1\224\52\0"+
    "\1\225\35\0\1\226\52\0\1\227\5\0\1\230\61\0"+
    "\1\231\13\0\1\231\13\0\1\140\1\232\1\233\50\0"+
    "\1\141\4\0\1\60\30\0\1\61\24\0\1\234\55\0"+
    "\1\235\50\0\1\236\47\0\1\237\60\0\1\240\45\0"+
    "\1\241\74\0\1\242\32\0\1\243\53\0\1\244\64\0"+
    "\1\245\37\0\1\246\52\0\1\247\63\0\1\250\36\0"+
    "\1\251\60\0\1\252\55\0\1\253\45\0\1\254\1\255"+
    "\56\0\1\256\64\0\1\257\32\0\1\260\51\0\1\261"+
    "\11\0\1\262\41\0\1\263\54\0\1\264\15\0\1\265"+
    "\50\0\1\266\1\0\1\267\47\0\1\270\36\0\1\271"+
    "\52\0\1\272\71\0\1\273\6\0\1\273\22\0\1\274"+
    "\55\0\1\275\50\0\1\276\47\0\1\277\60\0\1\300"+
    "\45\0\1\301\74\0\1\302\32\0\1\303\53\0\1\304"+
    "\64\0\1\305\37\0\1\306\52\0\1\307\63\0\1\310"+
    "\36\0\1\311\60\0\1\312\55\0\1\313\45\0\1\314"+
    "\1\315\56\0\1\316\64\0\1\317\32\0\1\320\51\0"+
    "\1\321\11\0\1\322\41\0\1\323\54\0\1\324\15\0"+
    "\1\325\50\0\1\326\1\0\1\327\47\0\1\330\36\0"+
    "\1\331\52\0\1\332\71\0\1\333\6\0\1\333\13\0"+
    "\1\232\62\0\1\334\55\0\1\335\54\0\1\336\45\0"+
    "\1\337\63\0\1\340\43\0\1\341\56\0\1\342\52\0"+
    "\1\343\52\0\1\344\50\0\1\345\51\0\1\346\57\0"+
    "\1\347\57\0\1\350\34\0\1\351\51\0\1\352\51\0"+
    "\1\353\76\0\1\354\42\0\1\355\47\0\1\356\47\0"+
    "\1\357\51\0\1\360\51\0\1\361\56\0\1\362\50\0"+
    "\1\363\70\0\1\364\34\0\1\365\44\0\1\366\60\0"+
    "\1\367\46\0\1\370\60\0\1\371\22\0\1\371\22\0"+
    "\1\372\55\0\1\373\54\0\1\374\45\0\1\375\63\0"+
    "\1\376\43\0\1\377\56\0\1\u0100\52\0\1\u0101\52\0"+
    "\1\u0102\50\0\1\u0103\51\0\1\u0104\57\0\1\u0105\57\0"+
    "\1\u0106\34\0\1\u0107\51\0\1\u0108\51\0\1\u0109\76\0"+
    "\1\u010a\42\0\1\u010b\47\0\1\u010c\47\0\1\u010d\51\0"+
    "\1\u010e\51\0\1\u010f\56\0\1\u0110\50\0\1\u0111\70\0"+
    "\1\u0112\34\0\1\u0113\44\0\1\u0114\60\0\1\u0115\46\0"+
    "\1\u0116\60\0\1\u0117\22\0\1\u0117\23\0\1\u0118\50\0"+
    "\1\u0119\61\0\1\u011a\56\0\1\u011b\35\0\1\u011c\60\0"+
    "\1\u011d\50\0\1\u011e\74\0\1\u011f\30\0\1\u0120\60\0"+
    "\1\u0121\44\0\1\u0122\62\0\1\u0123\36\0\1\u0124\72\0"+
    "\1\u0125\32\0\1\u0126\60\0\1\u0127\50\0\1\u0128\52\0"+
    "\1\u0129\54\0\1\u012a\55\0\1\u012b\64\0\1\u012c\31\0"+
    "\1\u012d\71\0\1\u012e\33\0\1\u012f\65\0\1\u0130\43\0"+
    "\1\u0131\25\0\1\u0131\22\0\1\u0132\50\0\1\u0133\61\0"+
    "\1\u0134\56\0\1\u0135\35\0\1\u0136\60\0\1\u0137\50\0"+
    "\1\u0138\74\0\1\u0139\30\0\1\u013a\60\0\1\u013b\44\0"+
    "\1\u013c\62\0\1\u013d\36\0\1\u013e\72\0\1\u013f\32\0"+
    "\1\u0140\60\0\1\u0141\50\0\1\u0142\52\0\1\u0143\54\0"+
    "\1\u0144\55\0\1\u0145\64\0\1\u0146\31\0\1\u0147\71\0"+
    "\1\u0148\33\0\1\u0149\65\0\1\u014a\43\0\1\u014b\25\0"+
    "\1\u014b\16\0\1\u014c\54\0\1\u014d\54\0\1\u014e\53\0"+
    "\1\u014f\52\0\1\u0150\62\0\1\u0151\37\0\1\u0152\73\0"+
    "\1\u0153\40\0\1\u0154\56\0\1\u0155\56\0\1\u0156\52\0"+
    "\1\u0157\43\0\1\u0158\44\0\1\u0159\54\0\1\u015a\67\0"+
    "\1\u015b\34\0\1\u015c\63\0\1\u015d\36\0\1\u015e\61\0"+
    "\1\u015f\55\0\1\u0160\47\0\1\u0161\45\0\1\u0162\30\0"+
    "\1\u0162\15\0\1\u0163\54\0\1\u0164\54\0\1\u0165\53\0"+
    "\1\u0166\52\0\1\u0167\62\0\1\u0168\37\0\1\u0169\73\0"+
    "\1\u016a\40\0\1\u016b\56\0\1\u016c\56\0\1\u016d\52\0"+
    "\1\u016e\43\0\1\u016f\44\0\1\u0170\54\0\1\u0171\67\0"+
    "\1\u0172\34\0\1\u0173\63\0\1\u0174\36\0\1\u0175\61\0"+
    "\1\u0176\55\0\1\u0177\47\0\1\u0178\45\0\1\u0179\30\0"+
    "\1\u0179\22\0\1\u017a\72\0\1\u017b\51\0\1\u017c\26\0"+
    "\1\u017d\56\0\1\u017e\60\0\1\u017f\46\0\1\u0180\52\0"+
    "\1\u0181\47\0\1\u0182\47\0\1\u0183\52\0\1\u0184\60\0"+
    "\1\u0185\53\0\1\u0186\43\0\1\u0187\75\0\1\u0188\44\0"+
    "\1\u0189\13\0\1\u0189\26\0\1\u018a\72\0\1\u018b\51\0"+
    "\1\u018c\26\0\1\u018d\56\0\1\u018e\60\0\1\u018f\46\0"+
    "\1\u0190\52\0\1\u0191\47\0\1\u0192\47\0\1\u0193\52\0"+
    "\1\u0194\60\0\1\u0195\53\0\1\u0196\43\0\1\u0197\75\0"+
    "\1\u0198\44\0\1\u0199\13\0\1\u0199\24\0\1\u019a\47\0"+
    "\1\u019b\52\0\1\u019c\73\0\1\u019d\44\0\1\u019e\47\0"+
    "\1\u019f\55\0\1\u01a0\60\0\1\u01a1\34\0\1\u01a2\53\0"+
    "\1\u01a3\53\0\1\u01a4\50\0\1\u01a5\32\0\1\u01a5\17\0"+
    "\1\u01a6\47\0\1\u01a7\52\0\1\u01a8\73\0\1\u01a9\44\0"+
    "\1\u01aa\47\0\1\u01ab\55\0\1\u01ac\60\0\1\u01ad\34\0"+
    "\1\u01ae\53\0\1\u01af\53\0\1\u01b0\50\0\1\u01b1\32\0"+
    "\1\u01b1\20\0\1\u01b2\60\0\1\u01b3\43\0\1\u01b4\76\0"+
    "\1\u01b5\31\0\1\u01b6\51\0\1\u01b7\53\0\1\u01b8\62\0"+
    "\1\u01b9\20\0\1\u01b9\17\0\1\u01ba\60\0\1\u01bb\43\0"+
    "\1\u01bc\76\0\1\u01bd\31\0\1\u01be\51\0\1\u01bf\53\0"+
    "\1\u01c0\62\0\1\u01c1\20\0\1\u01c1\21\0\1\u01c2\50\0"+
    "\1\u01c3\21\0\1\u01c4\42\0\1\u01c5\42\0\1\u01c6\55\0"+
    "\1\u01c7\26\0\1\u01c7\20\0\1\u01c8\50\0\1\u01c9\21\0"+
    "\1\u01ca\42\0\1\u01cb\42\0\1\u01cc\55\0\1\u01cd\26\0"+
    "\1\u01cd\20\0\1\u01ce\50\0\1\u01cf\53\0\1\u01d0\33\0"+
    "\1\u01d0\17\0\1\u01d1\50\0\1\u01d2\53\0\1\u01d3\33\0"+
    "\1\u01d3\11\0\1\u01d4\67\0\1\u01d5\77\0\1\u01d6\10\0"+
    "\1\u01d7\67\0\1\u01d8\77\0\1\u01d9\26\0\1\u01da\37\0"+
    "\1\u01db\65\0\1\u01dc\37\0\1\u01dd\55\0\1\u01de\52\0"+
    "\1\u01df\35\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[16813];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",		//$NON-NLS-1$
    "Error: could not match input",		//$NON-NLS-1$
    "Error: pushback value was too large"		//$NON-NLS-1$
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\1\1\1\0\1\1\1\0\1\1\1\11\1\1"+
    "\1\11\2\1\1\11\4\1\1\11\5\1\1\11\12\1"+
    "\4\0\2\11\4\1\2\0\1\1\1\11\23\0\1\11"+
    "\1\1\2\0\1\11\2\0\1\1\21\0\2\1\70\0"+
    "\1\11\1\1\4\0\1\11\30\0\1\11\6\0\1\11"+
    "\30\0\1\11\12\0\1\11\4\0\1\11\6\0\1\11"+
    "\3\0\1\11\2\0\1\1\12\0\1\11\4\0\1\11"+
    "\6\0\1\11\3\0\1\11\2\0\1\1\7\0\1\11"+
    "\7\0\1\11\10\0\1\11\10\0\1\11\7\0\1\11"+
    "\10\0\1\11\4\0\2\11\1\1\2\0\2\11\3\0"+
    "\1\11\2\0\1\11\2\0\1\11\6\0\2\11\1\1"+
    "\2\0\2\11\3\0\1\11\2\0\1\11\2\0\1\11"+
    "\13\0\2\11\3\0\1\11\2\0\1\11\7\0\2\11"+
    "\3\0\1\11\2\0\1\11\1\0\1\11\2\0\2\11"+
    "\1\0\1\1\1\11\4\0\1\11\2\0\2\11\1\0"+
    "\1\1\1\11\4\0\1\11\1\0\1\11\3\0\1\11"+
    "\1\0\1\11\1\0\1\11\3\0\1\11\1\0\1\11"+
    "\2\0\2\11\1\0\1\11\2\0\2\11\11\0\1\11"+
    "\2\0\2\11\1\0\1\11\1\0\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[479];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
	private String shortDesc;
	private String longDesc;
	private ArrayList<PHPDocTag> tagList;
	private int currTagId;
	private int tagPosition;
	private String matchedTag;
	private StringBuffer sBuffer;
	private int numOfLines;
	private List<Scalar> textList;

	public PHPDocBlock parse() {
		shortDesc = "";
		longDesc = "";
		tagList = new ArrayList<PHPDocTag>();
		currTagId = 0;
		tagPosition = 0;
		matchedTag = "";
		sBuffer = new StringBuffer();
		numOfLines = 1;
		textList = new ArrayList<Scalar>();

		int start = zzStartRead - _zzPushbackPos;

		// start parsing
		try {
			next_token();
		} catch (IOException e) {
			Logger.logException(e);
		}
		if (!tagList.isEmpty() && !textList.isEmpty()) {
			// lastText is empty if the last line only contains '*/' and white
			// spaces
			Scalar lastText = textList.get(textList.size() - 1);
			PHPDocTag lastTag = tagList.get(tagList.size() - 1);
			if (lastText.sourceEnd() >= lastTag.sourceEnd()) {
				textList.remove(textList.size() - 1);
				if (!isBlank(lastText.getValue())) {
					lastTag.getTexts().add(lastText);
				}
			}
		}

		PHPDocTag[] tags = new PHPDocTag[tagList.size()];
		tagList.toArray(tags);

		PHPDocBlock rv = new PHPDocBlock(start, zzMarkedPos - _zzPushbackPos,
				shortDesc, longDesc, tags, textList);

		return rv;

	}

	private boolean isBlank(String value) {
		char[] line = value.toCharArray();
		for (int i = 0; i < line.length; i++) {
			char c = line[i];
			if (c != '\t' && c != ' ') {
				return false;
			}
		}
		return true;
	}

	private void startTagsState(int firstState) {
		updateStartPos();
		hendleDesc();
		currTagId = firstState;
		tagPosition = findTagPosition();
		matchedTag = tagPosition > -1 ? new String(zzBuffer, tagPosition
				+ _zzPushbackPos, zzMarkedPos - (tagPosition + _zzPushbackPos))
		: "";
		sBuffer = new StringBuffer();
		yybegin(ST_IN_TAGS);
	}

	private int findTagPosition() {
		for (int i = zzStartRead; i < zzMarkedPos; i++) {
			if (zzBuffer[i] == '@' || zzBuffer[i] == '{') {
				return i - _zzPushbackPos;
			}
		}
		return -1;
	}

	private void setNewTag(int newTag) {
		updateStartPos();
		setTagValue();

		sBuffer = new StringBuffer();
		currTagId = newTag;
		tagPosition = findTagPosition();
		matchedTag = tagPosition > -1 ? new String(zzBuffer, tagPosition
				+ _zzPushbackPos, zzMarkedPos - (tagPosition + _zzPushbackPos))
		: "";
	}

	private void setTagValue() {
		String value = sBuffer.toString();
		// special case for backward compatibility
		if (currTagId == PHPDocTagKinds.DESC) {
			shortDesc = shortDesc + value;
			return;
		}

		PHPDocTag basicPHPDocTag = new PHPDocTag(tagPosition, zzStartRead
				- _zzPushbackPos, currTagId, matchedTag, value, getTexts(
						tagPosition, zzStartRead, true));
		tagList.add(basicPHPDocTag);
	}

	private List<Scalar> getTexts(int start, int end, boolean remove) {
		List<Scalar> result = new ArrayList<Scalar>();
		for (Iterator iterator = textList.iterator(); iterator.hasNext();) {
			Scalar scalar = (Scalar) iterator.next();
			if (scalar.sourceStart() >= start && scalar.sourceEnd() <= end) {
				result.add(scalar);
				if (remove) {
					iterator.remove();
				}
			}
		}
		// Scalar[] texts = new Scalar[result.size()];
		// result.toArray(texts);
		return result;
	}

	private void appendText() {
		if (oldString != null) {
			sBuffer.append(oldString);
		}
		StringBuffer sb = new StringBuffer();
		sb.append(zzBuffer, startPos, zzMarkedPos - startPos);
		addText(sb.toString());
		sBuffer.append(sb);
		updateStartPos();
	}

	private void addText(String string) {
		textList.add(new Scalar(startPos, startPos + string.length(), string,
				Scalar.TYPE_STRING));
	}

	private void hendleDesc() {
		if(zzLexicalState == ST_IN_SHORT_DESC || zzLexicalState == ST_IN_FIRST_LINE) {
			shortDesc = sBuffer.toString().trim();
		}
		else{
			longDesc = sBuffer.toString().trim();
		}

		sBuffer = new StringBuffer();
	}

	private void startLongDescState(boolean withNewLine) {
		hendleDesc();
		updateStartPos();
		if (!withNewLine) {
			addText("");
		}
		yybegin(ST_IN_LONG_DESC);
	}

	private void hendleNewLine() {
		appendText();
		if (numOfLines == 4) {
			int firstLineEnd = sBuffer.indexOf("\n", 1);
			shortDesc = sBuffer.substring(0, firstLineEnd);
			shortDesc = shortDesc.trim();
			sBuffer.delete(0, firstLineEnd);
			yybegin(ST_IN_LONG_DESC);
		} else {
			numOfLines++;
		}
	}
	private void appendLastText() {
		StringBuffer sb = new StringBuffer();
		sb.append(zzBuffer, startPos, zzMarkedPos - startPos - 2);
		addText(sb.toString());
		sBuffer.append(sb);
		updateStartPos();
	}

	int maxNumberofLines = 4;

	private void handleDocEnd_shortDesc() {
		appendLastText();
		if(numOfLines==maxNumberofLines) {
			int firstLineEnd = sBuffer.indexOf("\n",1);
			shortDesc = sBuffer.substring(0,firstLineEnd);
			shortDesc = shortDesc.trim();
			sBuffer.delete(0,firstLineEnd);
			longDesc = sBuffer.toString().trim();
		}
		else{
			shortDesc = sBuffer.toString().trim();
		}
	}

	private void handleDocEnd_longDesc() {
		appendLastText();
		longDesc = sBuffer.toString().trim();
	}

	private void handleDocEnd_inTags() {
		appendLastText();
		setTagValue();
	}

	/**
	 * Resets the {@code PhpAstLexer} properties to given parameters. Be
	 * careful, method {@link #next_token()} also caches those properties using
	 * internal variables (zzCurrentPosL, zzMarkedPosL, zzBufferL, zzEndReadL)
	 * that should be accordingly resetted by the lexical rules calling
	 * {@link #reset(java.io.Reader, char[], int[])}. Also be careful that those
	 * internal variables could change from one version of JFlex to another.
	 * 
	 * @param reader
	 * @param buffer
	 * @param parameters
	 */
	public void reset(java.io.Reader reader, char[] buffer, int[] parameters) {
		// (re)set all properties like in yyreset(java.io.Reader reader)

		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzMarkedPos = parameters[0];
		this._zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];
		// XXX: never used
		this.yychar = 0;
		// XXX: never used
		this.yycolumn = 0;
		this.zzAtEOF = parameters[7] != 0;
		this.zzEOFDone = parameters[8] != 0;
		this.zzFinalHighSurrogate = parameters[9];

		// NB: zzAtBOL and zzLexicalState won't be set using (directly) the
		// array "parameters", we always restart this scanner with the YYINITIAL
		// state
		this.zzAtBOL = this.zzAtEOF ? false : true;
		this.zzLexicalState = YYINITIAL;
	}

	public int[] getParamenters() {
		return new int[] { zzMarkedPos, _zzPushbackPos, zzCurrentPos,
				zzStartRead, zzEndRead, yyline, zzAtBOL ? 1 : 0,
				zzAtEOF ? 1 : 0, zzEOFDone ? 1 : 0, zzFinalHighSurrogate };
	}

	public char[] getBuffer() {
		return zzBuffer;
	}



  /** the textposition at the last state to be included in yytext */
  private int _zzPushbackPos;

  /* The following fields are added in order to support the change in zzRefill */
  private String oldString = null;
  private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public DocumentorLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 164) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    oldString = new String(zzBuffer, startPos, zzMarkedPos-startPos);

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      _zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (zzAtEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (zzRefill()) {
        return YYEOF;
    }

    return zzBuffer[zzCurrentPos++];
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = _zzPushbackPos = startPos = 0;
    oldString = null;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		startPos = zzMarkedPos;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
            zzDoEOF();
        return YYEOF;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { updateStartPos();
            }
          case 87: break;
          case 2: 
            { 
            }
          case 88: break;
          case 3: 
            { System.out.print(yytext());
            }
          case 89: break;
          case 4: 
            { hendleNewLine();
            }
          case 90: break;
          case 5: 
            { startLongDescState(false);
            }
          case 91: break;
          case 6: 
            { appendText();
            }
          case 92: break;
          case 7: 
            { appendText();
    startLongDescState(true);
            }
          case 93: break;
          case 8: 
            { maxNumberofLines = 4;
    handleDocEnd_shortDesc();
    return -1;
            }
          case 94: break;
          case 9: 
            { maxNumberofLines = 5;
    handleDocEnd_shortDesc();
    return -1;
            }
          case 95: break;
          case 10: 
            { handleDocEnd_longDesc();return -1;
            }
          case 96: break;
          case 11: 
            { handleDocEnd_inTags();return -1;
            }
          case 97: break;
          case 12: 
            { yypushback(yylength());
        updateStartPos();
        // https://bugs.eclipse.org/bugs/show_bug.cgi?id=474332
        // look for @tags on the first line of this PHPDoc block
        yybegin(ST_IN_FIRST_LINE);
            }
          case 98: break;
          case 13: 
            { // https://bugs.eclipse.org/bugs/show_bug.cgi?id=474332
    // no @tags were found on first line, continue normal
    // processing...
    updateStartPos();
    yybegin(ST_IN_SHORT_DESC);
            }
          case 99: break;
          case 14: 
            { updateStartPos();
        yybegin(ST_IN_SHORT_DESC);
            }
          case 100: break;
          case 15: 
            { startTagsState(PHPDocTagKinds.SEE);
            }
          case 101: break;
          case 16: 
            { startTagsState(PHPDocTagKinds.VAR);
            }
          case 102: break;
          case 17: 
            { setNewTag(PHPDocTagKinds.SEE);
            }
          case 103: break;
          case 18: 
            { setNewTag(PHPDocTagKinds.VAR);
            }
          case 104: break;
          case 19: 
            { startTagsState(PHPDocTagKinds.TODO);
            }
          case 105: break;
          case 20: 
            { startTagsState(PHPDocTagKinds.USES);
            }
          case 106: break;
          case 21: 
            { startTagsState(PHPDocTagKinds.DESC);
            }
          case 107: break;
          case 22: 
            { startTagsState(PHPDocTagKinds.LINK);
            }
          case 108: break;
          case 23: 
            { startTagsState(PHPDocTagKinds.NAME);
            }
          case 109: break;
          case 24: 
            { setNewTag(PHPDocTagKinds.TODO);
            }
          case 110: break;
          case 25: 
            { setNewTag(PHPDocTagKinds.USES);
            }
          case 111: break;
          case 26: 
            { setNewTag(PHPDocTagKinds.DESC);
            }
          case 112: break;
          case 27: 
            { setNewTag(PHPDocTagKinds.LINK);
            }
          case 113: break;
          case 28: 
            { setNewTag(PHPDocTagKinds.NAME);
            }
          case 114: break;
          case 29: 
            { startTagsState(PHPDocTagKinds.SINCE);
            }
          case 115: break;
          case 30: 
            { startTagsState(PHPDocTagKinds.PARAM);
            }
          case 116: break;
          case 31: 
            { startTagsState(PHPDocTagKinds.FINAL);
            }
          case 117: break;
          case 32: 
            { setNewTag(PHPDocTagKinds.SINCE);
            }
          case 118: break;
          case 33: 
            { setNewTag(PHPDocTagKinds.PARAM);
            }
          case 119: break;
          case 34: 
            { setNewTag(PHPDocTagKinds.FINAL);
            }
          case 120: break;
          case 35: 
            { startTagsState(PHPDocTagKinds.ACCESS);
            }
          case 121: break;
          case 36: 
            { startTagsState(PHPDocTagKinds.AUTHOR);
            }
          case 122: break;
          case 37: 
            { startTagsState(PHPDocTagKinds.STATIC);
            }
          case 123: break;
          case 38: 
            { startTagsState(PHPDocTagKinds.THROWS);
            }
          case 124: break;
          case 39: 
            { startTagsState(PHPDocTagKinds.RETURN);
            }
          case 125: break;
          case 40: 
            { startTagsState(PHPDocTagKinds.GLOBAL);
            }
          case 126: break;
          case 41: 
            { startTagsState(PHPDocTagKinds.IGNORE);
            }
          case 127: break;
          case 42: 
            { startTagsState(PHPDocTagKinds.METHOD);
            }
          case 128: break;
          case 43: 
            { setNewTag(PHPDocTagKinds.ACCESS);
            }
          case 129: break;
          case 44: 
            { setNewTag(PHPDocTagKinds.AUTHOR);
            }
          case 130: break;
          case 45: 
            { setNewTag(PHPDocTagKinds.STATIC);
            }
          case 131: break;
          case 46: 
            { setNewTag(PHPDocTagKinds.THROWS);
            }
          case 132: break;
          case 47: 
            { setNewTag(PHPDocTagKinds.RETURN);
            }
          case 133: break;
          case 48: 
            { setNewTag(PHPDocTagKinds.GLOBAL);
            }
          case 134: break;
          case 49: 
            { setNewTag(PHPDocTagKinds.IGNORE);
            }
          case 135: break;
          case 50: 
            { setNewTag(PHPDocTagKinds.METHOD);
            }
          case 136: break;
          case 51: 
            { startTagsState(PHPDocTagKinds.EXAMPLE);
            }
          case 137: break;
          case 52: 
            { startTagsState(PHPDocTagKinds.PACKAGE);
            }
          case 138: break;
          case 53: 
            { startTagsState(PHPDocTagKinds.LICENSE);
            }
          case 139: break;
          case 54: 
            { startTagsState(PHPDocTagKinds.VERSION);
            }
          case 140: break;
          case 55: 
            { setNewTag(PHPDocTagKinds.EXAMPLE);
            }
          case 141: break;
          case 56: 
            { setNewTag(PHPDocTagKinds.PACKAGE);
            }
          case 142: break;
          case 57: 
            { setNewTag(PHPDocTagKinds.LICENSE);
            }
          case 143: break;
          case 58: 
            { setNewTag(PHPDocTagKinds.VERSION);
            }
          case 144: break;
          case 59: 
            { startTagsState(PHPDocTagKinds.ABSTRACT);
            }
          case 145: break;
          case 60: 
            { startTagsState(PHPDocTagKinds.TUTORIAL);
            }
          case 146: break;
          case 61: 
            { startTagsState(PHPDocTagKinds.CATEGORY);
            }
          case 147: break;
          case 62: 
            { startTagsState(PHPDocTagKinds.PROPERTY);
            }
          case 148: break;
          case 63: 
            { startTagsState(PHPDocTagKinds.INTERNAL);
            }
          case 149: break;
          case 64: 
            { setNewTag(PHPDocTagKinds.ABSTRACT);
            }
          case 150: break;
          case 65: 
            { setNewTag(PHPDocTagKinds.TUTORIAL);
            }
          case 151: break;
          case 66: 
            { setNewTag(PHPDocTagKinds.CATEGORY);
            }
          case 152: break;
          case 67: 
            { setNewTag(PHPDocTagKinds.PROPERTY);
            }
          case 153: break;
          case 68: 
            { setNewTag(PHPDocTagKinds.INTERNAL);
            }
          case 154: break;
          case 69: 
            { startTagsState(PHPDocTagKinds.STATICVAR);
            }
          case 155: break;
          case 70: 
            { startTagsState(PHPDocTagKinds.COPYRIGHT);
            }
          case 156: break;
          case 71: 
            { startTagsState(PHPDocTagKinds.NAMESPACE);
            }
          case 157: break;
          case 72: 
            { setNewTag(PHPDocTagKinds.STATICVAR);
            }
          case 158: break;
          case 73: 
            { setNewTag(PHPDocTagKinds.COPYRIGHT);
            }
          case 159: break;
          case 74: 
            { setNewTag(PHPDocTagKinds.NAMESPACE);
            }
          case 160: break;
          case 75: 
            { startTagsState(PHPDocTagKinds.SUBPACKAGE);
            }
          case 161: break;
          case 76: 
            { startTagsState(PHPDocTagKinds.DEPRECATED);
            }
          case 162: break;
          case 77: 
            { startTagsState(PHPDocTagKinds.FILESOURCE);
            }
          case 163: break;
          case 78: 
            { setNewTag(PHPDocTagKinds.SUBPACKAGE);
            }
          case 164: break;
          case 79: 
            { setNewTag(PHPDocTagKinds.DEPRECATED);
            }
          case 165: break;
          case 80: 
            { setNewTag(PHPDocTagKinds.FILESOURCE);
            }
          case 166: break;
          case 81: 
            { startTagsState(PHPDocTagKinds.INHERITDOC);
            }
          case 167: break;
          case 82: 
            { setNewTag(PHPDocTagKinds.INHERITDOC);
            }
          case 168: break;
          case 83: 
            { startTagsState(PHPDocTagKinds.PROPERTY_READ);
            }
          case 169: break;
          case 84: 
            { setNewTag(PHPDocTagKinds.PROPERTY_READ);
            }
          case 170: break;
          case 85: 
            { startTagsState(PHPDocTagKinds.PROPERTY_WRITE);
            }
          case 171: break;
          case 86: 
            { setNewTag(PHPDocTagKinds.PROPERTY_WRITE);
            }
          case 172: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java DocumentorLexer [ --encoding <name> ] <inputfile(s)>");
    }
    else {
      int firstFilePos = 0;
      String encodingName = "UTF-8";
      if (argv[0].equals("--encoding")) {
        firstFilePos = 2;
        encodingName = argv[1];
        try {
          java.nio.charset.Charset.forName(encodingName); // Side-effect: is encodingName valid? 
        } catch (Exception e) {
          System.out.println("Invalid encoding '" + encodingName + "'");
          return;
        }
      }
      for (int i = firstFilePos; i < argv.length; i++) {
        DocumentorLexer scanner = null;
        try {
          java.io.FileInputStream stream = new java.io.FileInputStream(argv[i]);
          java.io.Reader reader = new java.io.InputStreamReader(stream, encodingName);
          scanner = new DocumentorLexer(reader);
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
