/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.organizeIncludes;

import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.organizeIncludes.OrganizeIncludesProcessorDelegate;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

class OrganizeIncludesChange
extends TextFileChange {
    private OrganizeIncludesProcessorDelegate processorDelegate;
    private Map<String, TextEditChangeGroup> editGroups = new LinkedHashMap<String, TextEditChangeGroup>();
    private int includeInsertionOffset;

    public OrganizeIncludesChange(OrganizeIncludesProcessorDelegate processorDelegate) {
        super(MessageFormat.format(PhpRefactoringCoreMessages.getString("OrganizeIncludesChange_In_File"), processorDelegate.getFile().getFullPath().toString()), processorDelegate.getFile());
        this.setTextType("php");
        this.setEdit((TextEdit)new MultiTextEdit());
        this.processorDelegate = processorDelegate;
    }

    private void commitEditGroups() {
        for (TextEditChangeGroup editChangeGroup : this.editGroups.values()) {
            TextEdit[] edits;
            TextEdit[] textEditArray = edits = editChangeGroup.getTextEdits();
            int n = edits.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit edit = textEditArray[n2];
                this.addEdit(edit);
                ++n2;
            }
            this.addTextEditChangeGroup(editChangeGroup);
        }
    }

    private TextEditChangeGroup createIncludeAddition(String insertionLabel, String includeString, boolean enabled) {
        InsertEdit edit = this.createInsertIncludeEdit(includeString);
        CategorizedTextEditGroup editGroup = new CategorizedTextEditGroup(insertionLabel, new GroupCategorySet(new GroupCategory(PhpRefactoringCoreMessages.getString("OrganizeIncludesChange_5"), PhpRefactoringCoreMessages.getString("OrganizeIncludesChange_Additions"), PhpRefactoringCoreMessages.getString("OrganizeIncludesChange_Additions"))));
        return this.createChangeEditGroup(new TextEdit[]{edit}, editGroup, enabled);
    }

    private TextEditChangeGroup createChangeEditGroup(TextEdit[] edits, CategorizedTextEditGroup editGroup, boolean enabled) {
        TextEdit[] textEditArray = edits;
        int n = edits.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit element = textEditArray[n2];
            editGroup.addTextEdit(element);
            ++n2;
        }
        TextEditChangeGroup editChangeGroup = new TextEditChangeGroup((TextChange)this, (TextEditGroup)editGroup);
        editChangeGroup.setEnabled(enabled);
        return editChangeGroup;
    }

    private InsertEdit createInsertIncludeEdit(String includeString) {
        return new InsertEdit(this.includeInsertionOffset, MessageFormat.format("require_once ''{0}'';{1}", includeString, this.processorDelegate.getDocument().getLineDelimiter()));
    }

    private static void addEditsToGroup(TextEditChangeGroup editChangeGroup, TextEdit[] edits) {
        TextEdit[] textEditArray = edits;
        int n = edits.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit element = textEditArray[n2];
            editChangeGroup.getTextEditGroup().addTextEdit(element);
            ++n2;
        }
    }
}

